//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplace

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PrivateStoreCollectionOfferClient contains the methods for the PrivateStoreCollectionOffer group.
// Don't use this type directly, use NewPrivateStoreCollectionOfferClient() instead.
type PrivateStoreCollectionOfferClient struct {
	host string
	pl   runtime.Pipeline
}

// NewPrivateStoreCollectionOfferClient creates a new instance of PrivateStoreCollectionOfferClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPrivateStoreCollectionOfferClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PrivateStoreCollectionOfferClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PrivateStoreCollectionOfferClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// CreateOrUpdate - Update or add an offer to a specific collection of the private store.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// offerID - The offer ID to update or delete
// collectionID - The collection ID
// options - PrivateStoreCollectionOfferClientCreateOrUpdateOptions contains the optional parameters for the PrivateStoreCollectionOfferClient.CreateOrUpdate
// method.
func (client *PrivateStoreCollectionOfferClient) CreateOrUpdate(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientCreateOrUpdateOptions) (PrivateStoreCollectionOfferClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, privateStoreID, offerID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionOfferClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreCollectionOfferClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreCollectionOfferClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PrivateStoreCollectionOfferClient) createOrUpdateCreateRequest(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if offerID == "" {
		return nil, errors.New("parameter offerID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{offerId}", url.PathEscape(offerID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *PrivateStoreCollectionOfferClient) createOrUpdateHandleResponse(resp *http.Response) (PrivateStoreCollectionOfferClientCreateOrUpdateResponse, error) {
	result := PrivateStoreCollectionOfferClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Offer); err != nil {
		return PrivateStoreCollectionOfferClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes an offer from the given collection of private store.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// offerID - The offer ID to update or delete
// collectionID - The collection ID
// options - PrivateStoreCollectionOfferClientDeleteOptions contains the optional parameters for the PrivateStoreCollectionOfferClient.Delete
// method.
func (client *PrivateStoreCollectionOfferClient) Delete(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientDeleteOptions) (PrivateStoreCollectionOfferClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, privateStoreID, offerID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionOfferClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreCollectionOfferClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return PrivateStoreCollectionOfferClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreCollectionOfferClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PrivateStoreCollectionOfferClient) deleteCreateRequest(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if offerID == "" {
		return nil, errors.New("parameter offerID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{offerId}", url.PathEscape(offerID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets information about a specific offer.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// offerID - The offer ID to update or delete
// collectionID - The collection ID
// options - PrivateStoreCollectionOfferClientGetOptions contains the optional parameters for the PrivateStoreCollectionOfferClient.Get
// method.
func (client *PrivateStoreCollectionOfferClient) Get(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientGetOptions) (PrivateStoreCollectionOfferClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, privateStoreID, offerID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionOfferClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreCollectionOfferClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreCollectionOfferClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *PrivateStoreCollectionOfferClient) getCreateRequest(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if offerID == "" {
		return nil, errors.New("parameter offerID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{offerId}", url.PathEscape(offerID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PrivateStoreCollectionOfferClient) getHandleResponse(resp *http.Response) (PrivateStoreCollectionOfferClientGetResponse, error) {
	result := PrivateStoreCollectionOfferClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Offer); err != nil {
		return PrivateStoreCollectionOfferClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get a list of all private offers in the given private store and collection
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// collectionID - The collection ID
// options - PrivateStoreCollectionOfferClientListOptions contains the optional parameters for the PrivateStoreCollectionOfferClient.List
// method.
func (client *PrivateStoreCollectionOfferClient) NewListPager(privateStoreID string, collectionID string, options *PrivateStoreCollectionOfferClientListOptions) *runtime.Pager[PrivateStoreCollectionOfferClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[PrivateStoreCollectionOfferClientListResponse]{
		More: func(page PrivateStoreCollectionOfferClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PrivateStoreCollectionOfferClientListResponse) (PrivateStoreCollectionOfferClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, privateStoreID, collectionID, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return PrivateStoreCollectionOfferClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PrivateStoreCollectionOfferClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PrivateStoreCollectionOfferClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *PrivateStoreCollectionOfferClient) listCreateRequest(ctx context.Context, privateStoreID string, collectionID string, options *PrivateStoreCollectionOfferClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *PrivateStoreCollectionOfferClient) listHandleResponse(resp *http.Response) (PrivateStoreCollectionOfferClientListResponse, error) {
	result := PrivateStoreCollectionOfferClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OfferListResponse); err != nil {
		return PrivateStoreCollectionOfferClientListResponse{}, err
	}
	return result, nil
}

// Post - Delete Private store offer. This is a workaround.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// privateStoreID - The store ID - must use the tenant ID
// offerID - The offer ID to update or delete
// collectionID - The collection ID
// options - PrivateStoreCollectionOfferClientPostOptions contains the optional parameters for the PrivateStoreCollectionOfferClient.Post
// method.
func (client *PrivateStoreCollectionOfferClient) Post(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientPostOptions) (PrivateStoreCollectionOfferClientPostResponse, error) {
	req, err := client.postCreateRequest(ctx, privateStoreID, offerID, collectionID, options)
	if err != nil {
		return PrivateStoreCollectionOfferClientPostResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PrivateStoreCollectionOfferClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PrivateStoreCollectionOfferClientPostResponse{}, runtime.NewResponseError(resp)
	}
	return PrivateStoreCollectionOfferClientPostResponse{}, nil
}

// postCreateRequest creates the Post request.
func (client *PrivateStoreCollectionOfferClient) postCreateRequest(ctx context.Context, privateStoreID string, offerID string, collectionID string, options *PrivateStoreCollectionOfferClientPostOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}/offers/{offerId}"
	if privateStoreID == "" {
		return nil, errors.New("parameter privateStoreID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{privateStoreId}", url.PathEscape(privateStoreID))
	if offerID == "" {
		return nil, errors.New("parameter offerID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{offerId}", url.PathEscape(offerID))
	if collectionID == "" {
		return nil, errors.New("parameter collectionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{collectionId}", url.PathEscape(collectionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Payload != nil {
		return req, runtime.MarshalAsJSON(req, *options.Payload)
	}
	return req, nil
}
