//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// QueryPacksClient contains the methods for the QueryPacks group.
// Don't use this type directly, use NewQueryPacksClient() instead.
type QueryPacksClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewQueryPacksClient creates a new instance of QueryPacksClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewQueryPacksClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*QueryPacksClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &QueryPacksClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates (or updates) a Log Analytics QueryPack. Note: You cannot specify a different value for InstrumentationKey
// nor AppId in the Put operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// queryPackName - The name of the Log Analytics QueryPack resource.
// logAnalyticsQueryPackPayload - Properties that need to be specified to create or update a Log Analytics QueryPack.
// options - QueryPacksClientCreateOrUpdateOptions contains the optional parameters for the QueryPacksClient.CreateOrUpdate
// method.
func (client *QueryPacksClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, queryPackName string, logAnalyticsQueryPackPayload LogAnalyticsQueryPack, options *QueryPacksClientCreateOrUpdateOptions) (QueryPacksClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, queryPackName, logAnalyticsQueryPackPayload, options)
	if err != nil {
		return QueryPacksClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return QueryPacksClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return QueryPacksClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *QueryPacksClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, queryPackName string, logAnalyticsQueryPackPayload LogAnalyticsQueryPack, options *QueryPacksClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if queryPackName == "" {
		return nil, errors.New("parameter queryPackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{queryPackName}", url.PathEscape(queryPackName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, logAnalyticsQueryPackPayload)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *QueryPacksClient) createOrUpdateHandleResponse(resp *http.Response) (QueryPacksClientCreateOrUpdateResponse, error) {
	result := QueryPacksClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LogAnalyticsQueryPack); err != nil {
		return QueryPacksClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a Log Analytics QueryPack.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// queryPackName - The name of the Log Analytics QueryPack resource.
// options - QueryPacksClientDeleteOptions contains the optional parameters for the QueryPacksClient.Delete method.
func (client *QueryPacksClient) Delete(ctx context.Context, resourceGroupName string, queryPackName string, options *QueryPacksClientDeleteOptions) (QueryPacksClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, queryPackName, options)
	if err != nil {
		return QueryPacksClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return QueryPacksClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return QueryPacksClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return QueryPacksClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *QueryPacksClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, queryPackName string, options *QueryPacksClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if queryPackName == "" {
		return nil, errors.New("parameter queryPackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{queryPackName}", url.PathEscape(queryPackName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns a Log Analytics QueryPack.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// queryPackName - The name of the Log Analytics QueryPack resource.
// options - QueryPacksClientGetOptions contains the optional parameters for the QueryPacksClient.Get method.
func (client *QueryPacksClient) Get(ctx context.Context, resourceGroupName string, queryPackName string, options *QueryPacksClientGetOptions) (QueryPacksClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, queryPackName, options)
	if err != nil {
		return QueryPacksClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return QueryPacksClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return QueryPacksClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *QueryPacksClient) getCreateRequest(ctx context.Context, resourceGroupName string, queryPackName string, options *QueryPacksClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if queryPackName == "" {
		return nil, errors.New("parameter queryPackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{queryPackName}", url.PathEscape(queryPackName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *QueryPacksClient) getHandleResponse(resp *http.Response) (QueryPacksClientGetResponse, error) {
	result := QueryPacksClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LogAnalyticsQueryPack); err != nil {
		return QueryPacksClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets a list of all Log Analytics QueryPacks within a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// options - QueryPacksClientListOptions contains the optional parameters for the QueryPacksClient.List method.
func (client *QueryPacksClient) NewListPager(options *QueryPacksClientListOptions) *runtime.Pager[QueryPacksClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[QueryPacksClientListResponse]{
		More: func(page QueryPacksClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *QueryPacksClientListResponse) (QueryPacksClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return QueryPacksClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return QueryPacksClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return QueryPacksClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *QueryPacksClient) listCreateRequest(ctx context.Context, options *QueryPacksClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.OperationalInsights/queryPacks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *QueryPacksClient) listHandleResponse(resp *http.Response) (QueryPacksClientListResponse, error) {
	result := QueryPacksClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LogAnalyticsQueryPackListResult); err != nil {
		return QueryPacksClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets a list of Log Analytics QueryPacks within a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - QueryPacksClientListByResourceGroupOptions contains the optional parameters for the QueryPacksClient.ListByResourceGroup
// method.
func (client *QueryPacksClient) NewListByResourceGroupPager(resourceGroupName string, options *QueryPacksClientListByResourceGroupOptions) *runtime.Pager[QueryPacksClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[QueryPacksClientListByResourceGroupResponse]{
		More: func(page QueryPacksClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *QueryPacksClientListByResourceGroupResponse) (QueryPacksClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return QueryPacksClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return QueryPacksClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return QueryPacksClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *QueryPacksClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *QueryPacksClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *QueryPacksClient) listByResourceGroupHandleResponse(resp *http.Response) (QueryPacksClientListByResourceGroupResponse, error) {
	result := QueryPacksClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LogAnalyticsQueryPackListResult); err != nil {
		return QueryPacksClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// UpdateTags - Updates an existing QueryPack's tags. To update other fields use the CreateOrUpdate method.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-09-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// queryPackName - The name of the Log Analytics QueryPack resource.
// queryPackTags - Updated tag information to set into the QueryPack instance.
// options - QueryPacksClientUpdateTagsOptions contains the optional parameters for the QueryPacksClient.UpdateTags method.
func (client *QueryPacksClient) UpdateTags(ctx context.Context, resourceGroupName string, queryPackName string, queryPackTags TagsResource, options *QueryPacksClientUpdateTagsOptions) (QueryPacksClientUpdateTagsResponse, error) {
	req, err := client.updateTagsCreateRequest(ctx, resourceGroupName, queryPackName, queryPackTags, options)
	if err != nil {
		return QueryPacksClientUpdateTagsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return QueryPacksClientUpdateTagsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return QueryPacksClientUpdateTagsResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateTagsHandleResponse(resp)
}

// updateTagsCreateRequest creates the UpdateTags request.
func (client *QueryPacksClient) updateTagsCreateRequest(ctx context.Context, resourceGroupName string, queryPackName string, queryPackTags TagsResource, options *QueryPacksClientUpdateTagsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if queryPackName == "" {
		return nil, errors.New("parameter queryPackName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{queryPackName}", url.PathEscape(queryPackName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, queryPackTags)
}

// updateTagsHandleResponse handles the UpdateTags response.
func (client *QueryPacksClient) updateTagsHandleResponse(resp *http.Response) (QueryPacksClientUpdateTagsResponse, error) {
	result := QueryPacksClientUpdateTagsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.LogAnalyticsQueryPack); err != nil {
		return QueryPacksClientUpdateTagsResponse{}, err
	}
	return result, nil
}
