//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedapplications

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "managedBy", a.ManagedBy)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "plan", a.Plan)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationDefinition.
func (a ApplicationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "managedBy", a.ManagedBy)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationDefinitionPatchable.
func (a ApplicationDefinitionPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationDefinitionProperties.
func (a ApplicationDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "artifacts", a.Artifacts)
	populate(objectMap, "authorizations", a.Authorizations)
	populate(objectMap, "createUiDefinition", &a.CreateUIDefinition)
	populate(objectMap, "deploymentPolicy", a.DeploymentPolicy)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "isEnabled", a.IsEnabled)
	populate(objectMap, "lockLevel", a.LockLevel)
	populate(objectMap, "lockingPolicy", a.LockingPolicy)
	populate(objectMap, "mainTemplate", &a.MainTemplate)
	populate(objectMap, "managementPolicy", a.ManagementPolicy)
	populate(objectMap, "notificationPolicy", a.NotificationPolicy)
	populate(objectMap, "packageFileUri", a.PackageFileURI)
	populate(objectMap, "policies", a.Policies)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "storageAccountId", a.StorageAccountID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationJitAccessPolicy.
func (a ApplicationJitAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "jitAccessEnabled", a.JitAccessEnabled)
	populate(objectMap, "jitApprovalMode", a.JitApprovalMode)
	populate(objectMap, "jitApprovers", a.JitApprovers)
	populate(objectMap, "maximumJitAccessDuration", a.MaximumJitAccessDuration)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationNotificationPolicy.
func (a ApplicationNotificationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "notificationEndpoints", a.NotificationEndpoints)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationPackageLockingPolicyDefinition.
func (a ApplicationPackageLockingPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedActions", a.AllowedActions)
	populate(objectMap, "allowedDataActions", a.AllowedDataActions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationPatchable.
func (a ApplicationPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "kind", a.Kind)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "managedBy", a.ManagedBy)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "plan", a.Plan)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "sku", a.SKU)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationProperties.
func (a ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationDefinitionId", a.ApplicationDefinitionID)
	populate(objectMap, "artifacts", a.Artifacts)
	populate(objectMap, "authorizations", a.Authorizations)
	populate(objectMap, "billingDetails", a.BillingDetails)
	populate(objectMap, "createdBy", a.CreatedBy)
	populate(objectMap, "customerSupport", a.CustomerSupport)
	populate(objectMap, "jitAccessPolicy", a.JitAccessPolicy)
	populate(objectMap, "managedResourceGroupId", a.ManagedResourceGroupID)
	populate(objectMap, "managementMode", a.ManagementMode)
	populate(objectMap, "outputs", &a.Outputs)
	populate(objectMap, "parameters", &a.Parameters)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "publisherTenantId", a.PublisherTenantID)
	populate(objectMap, "supportUrls", a.SupportUrls)
	populate(objectMap, "updatedBy", a.UpdatedBy)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GenericResource.
func (g GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "managedBy", g.ManagedBy)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "systemData", g.SystemData)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JitRequestDefinition.
func (j JitRequestDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", j.ID)
	populate(objectMap, "location", j.Location)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "tags", j.Tags)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JitRequestPatchable.
func (j JitRequestPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JitRequestProperties.
func (j JitRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationResourceId", j.ApplicationResourceID)
	populate(objectMap, "createdBy", j.CreatedBy)
	populate(objectMap, "jitAuthorizationPolicies", j.JitAuthorizationPolicies)
	populate(objectMap, "jitRequestState", j.JitRequestState)
	populate(objectMap, "jitSchedulingPolicy", j.JitSchedulingPolicy)
	populate(objectMap, "provisioningState", j.ProvisioningState)
	populate(objectMap, "publisherTenantId", j.PublisherTenantID)
	populate(objectMap, "updatedBy", j.UpdatedBy)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JitSchedulingPolicy.
func (j JitSchedulingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", j.Duration)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JitSchedulingPolicy.
func (j *JitSchedulingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, "Duration", &j.Duration)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
