// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configured access rules for the domain's document and search endpoints, and
// the current status of those rules.
type AccessPoliciesStatus struct {

	// The access policy configured for the Elasticsearch domain. Access policies may
	// be resource-based, IP-based, or IAM-based. See [Configuring Access Policies]for more information.
	//
	// [Configuring Access Policies]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies
	//
	// This member is required.
	Options *string

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

//	List of limits that are specific to a given InstanceType and for each of it's InstanceRole
//
// .
type AdditionalLimit struct {

	//  Name of Additional Limit is specific to a given InstanceType and for each of
	// it's InstanceRoleetc.
	//
	// Attributes and their details:
	//
	//   - MaximumNumberOfDataNodesSupported This attribute will be present in Master
	//   node only to specify how much data nodes upto which given ESPartitionInstanceTypecan support as
	//   master node.
	//   - MaximumNumberOfDataNodesWithoutMasterNode This attribute will be present in
	//   Data node only to specify how much data nodes of given ESPartitionInstanceTypeupto which you don't
	//   need any master nodes to govern them.
	LimitName *string

	//  Value for given AdditionalLimit$LimitName .
	LimitValues []string

	noSmithyDocumentSerde
}

//	Status of the advanced options for the specified Elasticsearch domain.
//
// Currently, the following advanced options are available:
//
//   - Option to allow references to indices in an HTTP request body. Must be false
//     when configuring access to individual sub-resources. By default, the value is
//     true . See [Configuration Advanced Options]for more information.
//   - Option to specify the percentage of heap space that is allocated to field
//     data. By default, this setting is unbounded.
//
// For more information, see [Configuring Advanced Options].
//
// [Configuration Advanced Options]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options
// [Configuring Advanced Options]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options
type AdvancedOptionsStatus struct {

	//  Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// This member is required.
	Options map[string]string

	//  Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the advanced security configuration: whether advanced security is
// enabled, whether the internal database option is enabled.
type AdvancedSecurityOptions struct {

	// Specifies the Anonymous Auth Disable Date when Anonymous Auth is enabled.
	AnonymousAuthDisableDate *time.Time

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool

	// True if advanced security is enabled.
	Enabled *bool

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool

	// Describes the SAML application configured for a domain.
	SAMLOptions *SAMLOptionsOutput

	noSmithyDocumentSerde
}

// Specifies the advanced security configuration: whether advanced security is
// enabled, whether the internal database option is enabled, master username and
// password (if internal database is enabled), and master user ARN (if IAM is
// enabled).
type AdvancedSecurityOptionsInput struct {

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool

	// True if advanced security is enabled.
	Enabled *bool

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool

	// Credentials for the master user: username and password, ARN, or both.
	MasterUserOptions *MasterUserOptions

	// Specifies the SAML application configuration for the domain.
	SAMLOptions *SAMLOptionsInput

	noSmithyDocumentSerde
}

//	Specifies the status of advanced security options for the specified
//
// Elasticsearch domain.
type AdvancedSecurityOptionsStatus struct {

	//  Specifies advanced security options for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *AdvancedSecurityOptions

	//  Status of the advanced security options for the specified Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Information about an account or service that has access to an Amazon OpenSearch
// Service domain through the use of an interface VPC endpoint.
type AuthorizedPrincipal struct {

	// The IAM principal that is allowed access to the domain.
	Principal *string

	// The type of principal.
	PrincipalType PrincipalType

	noSmithyDocumentSerde
}

// Specifies Auto-Tune type and Auto-Tune action details.
type AutoTune struct {

	// Specifies details of the Auto-Tune action. See the [Developer Guide] for more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	AutoTuneDetails *AutoTuneDetails

	// Specifies Auto-Tune type. Valid value is SCHEDULED_ACTION.
	AutoTuneType AutoTuneType

	noSmithyDocumentSerde
}

// Specifies details of the Auto-Tune action. See the [Developer Guide] for more information.
//
// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
type AutoTuneDetails struct {

	// Specifies details of the scheduled Auto-Tune action. See the [Developer Guide] for more
	// information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails

	noSmithyDocumentSerde
}

// Specifies Auto-Tune maitenance schedule. See the [Developer Guide] for more information.
//
// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
type AutoTuneMaintenanceSchedule struct {

	// Specifies cron expression for a recurring maintenance schedule. See the [Developer Guide] for
	// more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	CronExpressionForRecurrence *string

	// Specifies maintenance schedule duration: duration value and duration unit. See
	// the [Developer Guide]for more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	Duration *Duration

	// Specifies timestamp at which Auto-Tune maintenance schedule start.
	StartAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain,
// rollback state when disabling Auto-Tune options and list of maintenance
// schedules.
type AutoTuneOptions struct {

	// Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
	DesiredState AutoTuneDesiredState

	// Specifies list of maitenance schedules. See the [Developer Guide] for more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	// Specifies the rollback state while disabling Auto-Tune for the domain. Valid
	// values are NO_ROLLBACK, DEFAULT_ROLLBACK.
	RollbackOnDisable RollbackOnDisable

	noSmithyDocumentSerde
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and
// list of maintenance schedules.
type AutoTuneOptionsInput struct {

	// Specifies the Auto-Tune desired state. Valid values are ENABLED, DISABLED.
	DesiredState AutoTuneDesiredState

	// Specifies list of maitenance schedules. See the [Developer Guide] for more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	noSmithyDocumentSerde
}

// Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and
// list of maintenance schedules.
type AutoTuneOptionsOutput struct {

	// Specifies the error message while enabling or disabling the Auto-Tune.
	ErrorMessage *string

	// Specifies the AutoTuneState for the Elasticsearch domain.
	State AutoTuneState

	noSmithyDocumentSerde
}

//	Specifies the status of Auto-Tune options for the specified Elasticsearch
//
// domain.
type AutoTuneOptionsStatus struct {

	//  Specifies Auto-Tune options for the specified Elasticsearch domain.
	Options *AutoTuneOptions

	//  Specifies Status of the Auto-Tune options for the specified Elasticsearch
	// domain.
	Status *AutoTuneStatus

	noSmithyDocumentSerde
}

// Provides the current status of the Auto-Tune options.
type AutoTuneStatus struct {

	// Timestamp which tells Auto-Tune options creation date .
	//
	// This member is required.
	CreationDate *time.Time

	// Specifies the AutoTuneState for the Elasticsearch domain.
	//
	// This member is required.
	State AutoTuneState

	// Timestamp which tells Auto-Tune options last updated time.
	//
	// This member is required.
	UpdateDate *time.Time

	// Specifies the error message while enabling or disabling the Auto-Tune options.
	ErrorMessage *string

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool

	// Specifies the Auto-Tune options latest version.
	UpdateVersion int32

	noSmithyDocumentSerde
}

// A property change that was cancelled for an Amazon OpenSearch Service domain.
type CancelledChangeProperty struct {

	// The current value of the property, after the change was cancelled.
	ActiveValue *string

	// The pending value of the property that was cancelled. This would have been the
	// eventual value of the property if the chance had not been cancelled.
	CancelledValue *string

	// The name of the property whose change was cancelled.
	PropertyName *string

	noSmithyDocumentSerde
}

// Specifies change details of the domain configuration change.
type ChangeProgressDetails struct {

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string

	// The current status of the configuration change.
	ConfigChangeStatus ConfigChangeStatus

	// The IAM principal who initiated the configuration change.
	InitiatedBy InitiatedBy

	// The last time that the configuration change was updated.
	LastUpdatedTime *time.Time

	// Contains an optional message associated with the domain configuration change.
	Message *string

	// The time that the configuration change was initiated, in Universal Coordinated
	// Time (UTC).
	StartTime *time.Time

	noSmithyDocumentSerde
}

// A progress stage details of a specific domain configuration change.
type ChangeProgressStage struct {

	// The description of the progress stage.
	Description *string

	// The last updated timestamp of the progress stage.
	LastUpdated *time.Time

	// The name of the specific progress stage.
	Name *string

	// The overall status of a specific progress stage.
	Status *string

	noSmithyDocumentSerde
}

// The progress details of a specific domain configuration change.
type ChangeProgressStatusDetails struct {

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string

	// The specific stages that the domain is going through to perform the
	// configuration change.
	ChangeProgressStages []ChangeProgressStage

	// The list of properties involved in the domain configuration change that are
	// completed.
	CompletedProperties []string

	// The current status of the configuration change.
	ConfigChangeStatus ConfigChangeStatus

	// The IAM principal who initiated the configuration change.
	InitiatedBy InitiatedBy

	// The last time that the status of the configuration change was updated.
	LastUpdatedTime *time.Time

	// The list of properties involved in the domain configuration change that are
	// still in pending.
	PendingProperties []string

	// The time at which the configuration change is made on the domain.
	StartTime *time.Time

	// The overall status of the domain configuration change. This field can take the
	// following values: PENDING , PROCESSING , COMPLETED and FAILED
	Status OverallChangeStatus

	// The total number of stages required for the configuration change.
	TotalNumberOfStages int32

	noSmithyDocumentSerde
}

// Options to specify the Cognito user and identity pools for Kibana
// authentication. For more information, see [Amazon Cognito Authentication for Kibana].
//
// [Amazon Cognito Authentication for Kibana]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html
type CognitoOptions struct {

	// Specifies the option to enable Cognito for Kibana authentication.
	Enabled *bool

	// Specifies the Cognito identity pool ID for Kibana authentication.
	IdentityPoolId *string

	// Specifies the role ARN that provides Elasticsearch permissions for accessing
	// Cognito resources.
	RoleArn *string

	// Specifies the Cognito user pool ID for Kibana authentication.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Status of the Cognito options for the specified Elasticsearch domain.
type CognitoOptionsStatus struct {

	// Specifies the Cognito options for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *CognitoOptions

	// Specifies the status of the Cognito options for the specified Elasticsearch
	// domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the configuration for cold storage options such as enabled
type ColdStorageOptions struct {

	// Enable cold storage option. Accepted values true or false
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// A map from an ElasticsearchVersion to a list of compatible ElasticsearchVersion s to which the domain can be upgraded.
type CompatibleVersionsMap struct {

	// The current version of Elasticsearch on which a domain is.
	SourceVersion *string

	// List of supported elastic search versions.
	TargetVersions []string

	noSmithyDocumentSerde
}

// Filter to apply in DescribePackage response.
type DescribePackagesFilter struct {

	// Any field from PackageDetails .
	Name DescribePackagesFilterName

	// A non-empty list of values for the specified field.
	Value []string

	noSmithyDocumentSerde
}

// Options to configure endpoint for the Elasticsearch domain.
type DomainEndpointOptions struct {

	// Specify the fully qualified domain for your custom endpoint.
	CustomEndpoint *string

	// Specify ACM certificate ARN for your custom endpoint.
	CustomEndpointCertificateArn *string

	// Specify if custom endpoint should be enabled for the Elasticsearch domain.
	CustomEndpointEnabled *bool

	// Specify if only HTTPS endpoint should be enabled for the Elasticsearch domain.
	EnforceHTTPS *bool

	// Specify the TLS security policy that needs to be applied to the HTTPS endpoint
	// of Elasticsearch domain.
	//
	// It can be one of the following values:
	//
	//   - Policy-Min-TLS-1-0-2019-07: TLS security policy that supports TLS version
	//   1.0 to TLS version 1.2
	//   - Policy-Min-TLS-1-2-2019-07: TLS security policy that supports only TLS
	//   version 1.2
	//   - Policy-Min-TLS-1-2-PFS-2023-10: TLS security policy that supports TLS
	//   version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
	TLSSecurityPolicy TLSSecurityPolicy

	noSmithyDocumentSerde
}

// The configured endpoint options for the domain and their current status.
type DomainEndpointOptionsStatus struct {

	// Options to configure endpoint for the Elasticsearch domain.
	//
	// This member is required.
	Options *DomainEndpointOptions

	// The status of the endpoint options for the Elasticsearch domain. See
	// OptionStatus for the status information that's included.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

type DomainInfo struct {

	//  Specifies the DomainName .
	DomainName *string

	//  Specifies the EngineType of the domain.
	EngineType EngineType

	noSmithyDocumentSerde
}

type DomainInformation struct {

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter or
	// number and can contain the following characters: a-z (lowercase), 0-9, and -
	// (hyphen).
	//
	// This member is required.
	DomainName *string

	OwnerId *string

	Region *string

	noSmithyDocumentSerde
}

// Information on a package that is associated with a domain.
type DomainPackageDetails struct {

	// Name of the domain you've associated a package with.
	DomainName *string

	// State of the association. Values are
	// ASSOCIATING/ASSOCIATION_FAILED/ACTIVE/DISSOCIATING/DISSOCIATION_FAILED.
	DomainPackageStatus DomainPackageStatus

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	// Timestamp of the most-recent update to the association status.
	LastUpdated *time.Time

	// Internal ID of the package.
	PackageID *string

	// User specified name of the package.
	PackageName *string

	// Currently supports only TXT-DICTIONARY.
	PackageType PackageType

	PackageVersion *string

	// The relative path on Amazon ES nodes, which can be used as synonym_path when
	// the package is synonym file.
	ReferencePath *string

	noSmithyDocumentSerde
}

type DryRunResults struct {

	//  Specifies the deployment mechanism through which the update shall be applied
	// on the domain. Possible responses are Blue/Green (The update will require a
	// blue/green deployment.) DynamicUpdate (The update can be applied in-place
	// without a Blue/Green deployment required.) Undetermined (The domain is
	// undergoing an update which needs to complete before the deployment type can be
	// predicted.) None (The configuration change matches the current configuration
	// and will not result in any update.)
	DeploymentType *string

	// Contains an optional message associated with the DryRunResults.
	Message *string

	noSmithyDocumentSerde
}

// Specifies maintenance schedule duration: duration value and duration unit. See
// the [Developer Guide]for more information.
//
// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
type Duration struct {

	// Specifies the unit of a maintenance schedule duration. Valid value is HOURS.
	// See the [Developer Guide]for more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	Unit TimeUnit

	//  Integer to specify the value of a maintenance schedule duration. See the [Developer Guide] for
	// more information.
	//
	// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
	Value *int64

	noSmithyDocumentSerde
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see [Configuring EBS-based Storage].
//
// [Configuring EBS-based Storage]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs
type EBSOptions struct {

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool

	// Specifies the IOPS for Provisioned IOPS And GP3 EBS volume (SSD).
	Iops *int32

	// Specifies the Throughput for GP3 EBS volume (SSD).
	Throughput *int32

	//  Integer to specify the size of an EBS volume.
	VolumeSize *int32

	//  Specifies the volume type for EBS-based storage.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// Status of the EBS options for the specified Elasticsearch domain.
type EBSOptionsStatus struct {

	//  Specifies the EBS options for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *EBSOptions

	//  Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the configuration for the domain cluster, such as the type and number
// of instances.
type ElasticsearchClusterConfig struct {

	// Specifies the ColdStorageOptions config for Elasticsearch Domain
	ColdStorageOptions *ColdStorageOptions

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int32

	// A boolean value to indicate whether a dedicated master node is enabled. See [About Dedicated Master Nodes]
	// for more information.
	//
	// [About Dedicated Master Nodes]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes
	DedicatedMasterEnabled *bool

	// The instance type for a dedicated master node.
	DedicatedMasterType ESPartitionInstanceType

	// The number of instances in the specified domain cluster.
	InstanceCount *int32

	// The instance type for an Elasticsearch cluster. UltraWarm instance types are
	// not supported for data instances.
	InstanceType ESPartitionInstanceType

	// The number of warm nodes in the cluster.
	WarmCount *int32

	// True to enable warm storage.
	WarmEnabled *bool

	// The instance type for the Elasticsearch cluster's warm nodes.
	WarmType ESWarmPartitionInstanceType

	// Specifies the zone awareness configuration for a domain when zone awareness is
	// enabled.
	ZoneAwarenessConfig *ZoneAwarenessConfig

	// A boolean value to indicate whether zone awareness is enabled. See [About Zone Awareness] for more
	// information.
	//
	// [About Zone Awareness]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness
	ZoneAwarenessEnabled *bool

	noSmithyDocumentSerde
}

// Specifies the configuration status for the specified Elasticsearch domain.
type ElasticsearchClusterConfigStatus struct {

	//  Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *ElasticsearchClusterConfig

	//  Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// The configuration of an Elasticsearch domain.
type ElasticsearchDomainConfig struct {

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus

	// Specifies the AdvancedOptions for the domain. See [Configuring Advanced Options] for more information.
	//
	// [Configuring Advanced Options]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options
	AdvancedOptions *AdvancedOptionsStatus

	// Specifies AdvancedSecurityOptions for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus

	// Specifies AutoTuneOptions for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails

	// The CognitoOptions for the specified domain. For more information, see [Amazon Cognito Authentication for Kibana].
	//
	// [Amazon Cognito Authentication for Kibana]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html
	CognitoOptions *CognitoOptionsStatus

	// Specifies the DomainEndpointOptions for the Elasticsearch domain.
	DomainEndpointOptions *DomainEndpointOptionsStatus

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus

	// Specifies the EncryptionAtRestOptions for the Elasticsearch domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus

	// Information about the domain properties that are currently being modified.
	ModifyingProperties []ModifyingProperties

	// Specifies the NodeToNodeEncryptionOptions for the Elasticsearch domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus

	// The VPCOptions for the specified domain. For more information, see [VPC Endpoints for Amazon Elasticsearch Service Domains].
	//
	// [VPC Endpoints for Amazon Elasticsearch Service Domains]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
	VPCOptions *VPCDerivedInfoStatus

	noSmithyDocumentSerde
}

// The current status of an Elasticsearch domain.
type ElasticsearchDomainStatus struct {

	// The Amazon resource name (ARN) of an Elasticsearch domain. See [Identifiers for IAM Entities] in Using AWS
	// Identity and Access Management for more information.
	//
	// [Identifiers for IAM Entities]: http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html
	//
	// This member is required.
	ARN *string

	// The unique identifier for the specified Elasticsearch domain.
	//
	// This member is required.
	DomainId *string

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter or
	// number and can contain the following characters: a-z (lowercase), 0-9, and -
	// (hyphen).
	//
	// This member is required.
	DomainName *string

	// The type and number of instances in the domain cluster.
	//
	// This member is required.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig

	//  IAM access policy as a JSON-formatted string.
	AccessPolicies *string

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]string

	// The current status of the Elasticsearch domain's advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptions

	// The current status of the Elasticsearch domain's Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsOutput

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails

	// The CognitoOptions for the specified domain. For more information, see [Amazon Cognito Authentication for Kibana].
	//
	// [Amazon Cognito Authentication for Kibana]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html
	CognitoOptions *CognitoOptions

	// The domain creation status. True if the creation of an Elasticsearch domain is
	// complete. False if domain creation is still in progress.
	Created *bool

	// The domain deletion status. True if a delete request has been received for the
	// domain but resource cleanup is still in progress. False if the domain has not
	// been deleted. Once domain deletion is complete, the status of the domain is no
	// longer returned.
	Deleted *bool

	// The current status of the Elasticsearch domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptions

	// The status of any changes that are currently in progress for the domain.
	DomainProcessingStatus DomainProcessingStatusType

	// The EBSOptions for the specified domain. See [Configuring EBS-based Storage] for more information.
	//
	// [Configuring EBS-based Storage]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs
	EBSOptions *EBSOptions

	ElasticsearchVersion *string

	//  Specifies the status of the EncryptionAtRestOptions .
	EncryptionAtRestOptions *EncryptionAtRestOptions

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string

	// Map containing the Elasticsearch domain endpoints used to submit index and
	// search requests. Example key, value :
	// 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com' .
	Endpoints map[string]string

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]LogPublishingOption

	// Information about the domain properties that are currently being modified.
	ModifyingProperties []ModifyingProperties

	// Specifies the status of the NodeToNodeEncryptionOptions .
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions

	// The status of the Elasticsearch domain configuration. True if Amazon
	// Elasticsearch Service is processing configuration changes. False if the
	// configuration is active.
	Processing *bool

	// The current status of the Elasticsearch domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions

	// The status of an Elasticsearch domain version upgrade. True if Amazon
	// Elasticsearch Service is undergoing a version upgrade. False if the
	// configuration is active.
	UpgradeProcessing *bool

	// The VPCOptions for the specified domain. For more information, see [VPC Endpoints for Amazon Elasticsearch Service Domains].
	//
	// [VPC Endpoints for Amazon Elasticsearch Service Domains]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
	VPCOptions *VPCDerivedInfo

	noSmithyDocumentSerde
}

//	Status of the Elasticsearch version options for the specified Elasticsearch
//
// domain.
type ElasticsearchVersionStatus struct {

	//  Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *string

	//  Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the Encryption At Rest Options.
type EncryptionAtRestOptions struct {

	// Specifies the option to enable Encryption At Rest.
	Enabled *bool

	//  Specifies the KMS Key ID for Encryption At Rest options.
	KmsKeyId *string

	noSmithyDocumentSerde
}

//	Status of the Encryption At Rest options for the specified Elasticsearch
//
// domain.
type EncryptionAtRestOptionsStatus struct {

	//  Specifies the Encryption At Rest options for the specified Elasticsearch
	// domain.
	//
	// This member is required.
	Options *EncryptionAtRestOptions

	//  Specifies the status of the Encryption At Rest options for the specified
	// Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

type ErrorDetails struct {
	ErrorMessage *string

	ErrorType *string

	noSmithyDocumentSerde
}

//	A filter used to limit results when describing inbound or outbound
//
// cross-cluster search connections. Multiple values can be specified per filter. A
// cross-cluster search connection must match at least one of the specified values
// for it to be returned from an operation.
type Filter struct {

	//  Specifies the name of the filter.
	Name *string

	//  Contains one or more values for the filter.
	Values []string

	noSmithyDocumentSerde
}

// Specifies details of an inbound connection.
type InboundCrossClusterSearchConnection struct {

	// Specifies the InboundCrossClusterSearchConnectionStatus for the outbound connection.
	ConnectionStatus *InboundCrossClusterSearchConnectionStatus

	// Specifies the connection id for the inbound cross-cluster search connection.
	CrossClusterSearchConnectionId *string

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation

	noSmithyDocumentSerde
}

// Specifies the coonection status of an inbound cross-cluster search connection.
type InboundCrossClusterSearchConnectionStatus struct {

	// Specifies verbose information for the inbound connection status.
	Message *string

	// The state code for inbound connection. This can be one of the following:
	//
	//   - PENDING_ACCEPTANCE: Inbound connection is not yet accepted by destination
	//   domain owner.
	//   - APPROVED: Inbound connection is pending acceptance by destination domain
	//   owner.
	//   - REJECTING: Inbound connection rejection is in process.
	//   - REJECTED: Inbound connection is rejected.
	//   - DELETING: Inbound connection deletion is in progress.
	//   - DELETED: Inbound connection is deleted and cannot be used further.
	StatusCode InboundCrossClusterSearchConnectionStatusCode

	noSmithyDocumentSerde
}

//	InstanceCountLimits represents the limits on number of instances that be
//
// created in Amazon Elasticsearch for given InstanceType.
type InstanceCountLimits struct {

	//  Maximum number of Instances that can be instantiated for given InstanceType.
	MaximumInstanceCount int32

	//  Minimum number of Instances that can be instantiated for given InstanceType.
	MinimumInstanceCount int32

	noSmithyDocumentSerde
}

// InstanceLimits represents the list of instance related attributes that are
// available for given InstanceType.
type InstanceLimits struct {

	//  InstanceCountLimits represents the limits on number of instances that be
	// created in Amazon Elasticsearch for given InstanceType.
	InstanceCountLimits *InstanceCountLimits

	noSmithyDocumentSerde
}

//	Limits for given InstanceType and for each of it's role.
//
// Limits contains following StorageTypes,InstanceLimits and AdditionalLimits
type Limits struct {

	//  List of additional limits that are specific to a given InstanceType and for
	// each of it's InstanceRole.
	AdditionalLimits []AdditionalLimit

	// InstanceLimits represents the list of instance related attributes that are
	// available for given InstanceType.
	InstanceLimits *InstanceLimits

	// StorageType represents the list of storage related types and attributes that
	// are available for given InstanceType.
	StorageTypes []StorageType

	noSmithyDocumentSerde
}

// Log Publishing option that is set for given domain.
//
// Attributes and their details:
//
//   - CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to which log
//     needs to be published.
//   - Enabled: Whether the log publishing for given log type is enabled or not
type LogPublishingOption struct {

	// ARN of the Cloudwatch log group to which log needs to be published.
	CloudWatchLogsLogGroupArn *string

	//  Specifies whether given log publishing option is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {

	// The log publishing options configured for the Elasticsearch domain.
	Options map[string]LogPublishingOption

	// The status of the log publishing options for the Elasticsearch domain. See
	// OptionStatus for the status information that's included.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Credentials for the master user: username and password, ARN, or both.
type MasterUserOptions struct {

	// ARN for the master user (if IAM is enabled).
	MasterUserARN *string

	// The master user's username, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	MasterUserName *string

	// The master user's password, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	MasterUserPassword *string

	noSmithyDocumentSerde
}

// Information about the domain properties that are currently being modified.
type ModifyingProperties struct {

	// The current value of the domain property that is being modified.
	ActiveValue *string

	// The name of the property that is currently being modified.
	Name *string

	// The value that the property that is currently being modified will eventually
	// have.
	PendingValue *string

	// The type of value that is currently being modified. Properties can have two
	// types:
	//
	//   - PLAIN_TEXT: Contain direct values such as "1", "True", or "c5.large.search".
	//   - STRINGIFIED_JSON: Contain content in JSON format, such as
	//   {"Enabled":"True"}".
	ValueType PropertyValueType

	noSmithyDocumentSerde
}

// Specifies the node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {

	// Specify true to enable node-to-node encryption.
	Enabled *bool

	noSmithyDocumentSerde
}

// Status of the node-to-node encryption options for the specified Elasticsearch
// domain.
type NodeToNodeEncryptionOptionsStatus struct {

	// Specifies the node-to-node encryption options for the specified Elasticsearch
	// domain.
	//
	// This member is required.
	Options *NodeToNodeEncryptionOptions

	// Specifies the status of the node-to-node encryption options for the specified
	// Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Provides the current status of the entity.
type OptionStatus struct {

	// Timestamp which tells the creation date for the entity.
	//
	// This member is required.
	CreationDate *time.Time

	// Provides the OptionState for the Elasticsearch domain.
	//
	// This member is required.
	State OptionState

	// Timestamp which tells the last updated time for the entity.
	//
	// This member is required.
	UpdateDate *time.Time

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool

	// Specifies the latest version for the entity.
	UpdateVersion int32

	noSmithyDocumentSerde
}

// Specifies details of an outbound connection.
type OutboundCrossClusterSearchConnection struct {

	// Specifies the connection alias for the outbound cross-cluster search connection.
	ConnectionAlias *string

	// Specifies the OutboundCrossClusterSearchConnectionStatus for the outbound connection.
	ConnectionStatus *OutboundCrossClusterSearchConnectionStatus

	// Specifies the connection id for the outbound cross-cluster search connection.
	CrossClusterSearchConnectionId *string

	// Specifies the DomainInformation for the destination Elasticsearch domain.
	DestinationDomainInfo *DomainInformation

	// Specifies the DomainInformation for the source Elasticsearch domain.
	SourceDomainInfo *DomainInformation

	noSmithyDocumentSerde
}

// Specifies the connection status of an outbound cross-cluster search connection.
type OutboundCrossClusterSearchConnectionStatus struct {

	// Specifies verbose information for the outbound connection status.
	Message *string

	// The state code for outbound connection. This can be one of the following:
	//
	//   - VALIDATING: The outbound connection request is being validated.
	//   - VALIDATION_FAILED: Validation failed for the connection request.
	//   - PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet
	//   accepted by destination domain owner.
	//   - PROVISIONING: Outbound connection request is in process.
	//   - ACTIVE: Outbound connection is active and ready to use.
	//   - REJECTED: Outbound connection request is rejected by destination domain
	//   owner.
	//   - DELETING: Outbound connection deletion is in progress.
	//   - DELETED: Outbound connection is deleted and cannot be used further.
	StatusCode OutboundCrossClusterSearchConnectionStatusCode

	noSmithyDocumentSerde
}

// Basic information about a package.
type PackageDetails struct {
	AvailablePackageVersion *string

	// Timestamp which tells creation date of the package.
	CreatedAt *time.Time

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	LastUpdatedAt *time.Time

	// User-specified description of the package.
	PackageDescription *string

	// Internal ID of the package.
	PackageID *string

	// User specified name of the package.
	PackageName *string

	// Current state of the package. Values are
	// COPYING/COPY_FAILED/AVAILABLE/DELETING/DELETE_FAILED
	PackageStatus PackageStatus

	// Currently supports only TXT-DICTIONARY.
	PackageType PackageType

	noSmithyDocumentSerde
}

// The S3 location for importing the package specified as S3BucketName and S3Key
type PackageSource struct {

	// Name of the bucket containing the package.
	S3BucketName *string

	// Key (file name) of the package.
	S3Key *string

	noSmithyDocumentSerde
}

// Details of a package version.
type PackageVersionHistory struct {

	// A message associated with the version.
	CommitMessage *string

	// Timestamp which tells creation time of the package version.
	CreatedAt *time.Time

	// Version of the package.
	PackageVersion *string

	noSmithyDocumentSerde
}

// Contains the specific price and frequency of a recurring charges for a reserved
// Elasticsearch instance, or for a reserved Elasticsearch instance offering.
type RecurringCharge struct {

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// Details of a reserved Elasticsearch instance.
type ReservedElasticsearchInstance struct {

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string

	// The duration, in seconds, for which the Elasticsearch instance is reserved.
	Duration int32

	// The number of Elasticsearch instances that have been reserved.
	ElasticsearchInstanceCount int32

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType ESPartitionInstanceType

	// The upfront fixed charge you will paid to purchase the specific reserved
	// Elasticsearch instance offering.
	FixedPrice *float64

	// The payment option as defined in the reserved Elasticsearch instance offering.
	PaymentOption ReservedElasticsearchInstancePaymentOption

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge

	// The customer-specified identifier to track this reservation.
	ReservationName *string

	// The unique identifier for the reservation.
	ReservedElasticsearchInstanceId *string

	// The offering identifier.
	ReservedElasticsearchInstanceOfferingId *string

	// The time the reservation started.
	StartTime *time.Time

	// The state of the reserved Elasticsearch instance.
	State *string

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Details of a reserved Elasticsearch instance offering.
type ReservedElasticsearchInstanceOffering struct {

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string

	// The duration, in seconds, for which the offering will reserve the Elasticsearch
	// instance.
	Duration int32

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType ESPartitionInstanceType

	// The upfront fixed charge you will pay to purchase the specific reserved
	// Elasticsearch instance offering.
	FixedPrice *float64

	// Payment option for the reserved Elasticsearch instance offering
	PaymentOption ReservedElasticsearchInstancePaymentOption

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge

	// The Elasticsearch reserved instance offering identifier.
	ReservedElasticsearchInstanceOfferingId *string

	// The rate you are charged for each hour the domain that is using the offering is
	// running.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Specifies the SAML Identity Provider's information.
type SAMLIdp struct {

	// The unique Entity ID of the application in SAML Identity Provider.
	//
	// This member is required.
	EntityId *string

	// The Metadata of the SAML application in xml format.
	//
	// This member is required.
	MetadataContent *string

	noSmithyDocumentSerde
}

// Specifies the SAML application configuration for the domain.
type SAMLOptionsInput struct {

	// True if SAML is enabled.
	Enabled *bool

	// Specifies the SAML Identity Provider's information.
	Idp *SAMLIdp

	// The backend role to which the SAML master user is mapped to.
	MasterBackendRole *string

	// The SAML master username, which is stored in the Amazon Elasticsearch Service
	// domain's internal database.
	MasterUserName *string

	// The key to use for matching the SAML Roles attribute.
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	// Acceptable values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int32

	// The key to use for matching the SAML Subject attribute.
	SubjectKey *string

	noSmithyDocumentSerde
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput struct {

	// True if SAML is enabled.
	Enabled *bool

	// Describes the SAML Identity Provider's information.
	Idp *SAMLIdp

	// The key used for matching the SAML Roles attribute.
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int32

	// The key used for matching the SAML Subject attribute.
	SubjectKey *string

	noSmithyDocumentSerde
}

// Specifies details of the scheduled Auto-Tune action. See the [Developer Guide] for more
// information.
//
// [Developer Guide]: https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/auto-tune.html
type ScheduledAutoTuneDetails struct {

	// Specifies Auto-Tune action description.
	Action *string

	// Specifies Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and
	// JVM_YOUNG_GEN_TUNING.
	ActionType ScheduledAutoTuneActionType

	// Specifies timestamp for the Auto-Tune action scheduled for the domain.
	Date *time.Time

	// Specifies Auto-Tune action severity. Valid values are LOW, MEDIUM and HIGH.
	Severity ScheduledAutoTuneSeverityType

	noSmithyDocumentSerde
}

// The current options of an Elasticsearch domain service software options.
type ServiceSoftwareOptions struct {

	// Timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time

	// True if you are able to cancel your service software version update. False if
	// you are not able to cancel your service software version.
	Cancellable *bool

	// The current service software version that is present on the domain.
	CurrentVersion *string

	// The description of the UpdateStatus .
	Description *string

	// The new service software version if one is available.
	NewVersion *string

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after AutomatedUpdateDate .
	OptionalDeployment *bool

	// True if you are able to update you service software version. False if you are
	// not able to update your service software version.
	UpdateAvailable *bool

	// The status of your service software update. This field can take the following
	// values: ELIGIBLE , PENDING_UPDATE , IN_PROGRESS , COMPLETED , and NOT_ELIGIBLE .
	UpdateStatus DeploymentStatus

	noSmithyDocumentSerde
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
type SnapshotOptions struct {

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int32

	noSmithyDocumentSerde
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// This member is required.
	Options *SnapshotOptions

	// Specifies the status of a daily automated snapshot.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// StorageTypes represents the list of storage related types and their attributes
// that are available for given InstanceType.
type StorageType struct {

	//  SubType of the given storage type. List of available sub-storage options: For
	// "instance" storageType we wont have any storageSubType, in case of "ebs"
	// storageType we will have following valid storageSubTypes
	//
	//   - standard
	//   - gp2
	//   - gp3
	//   - io1
	// Refer VolumeType for more information regarding above EBS storage options.
	StorageSubTypeName *string

	// List of limits that are applicable for given storage type.
	StorageTypeLimits []StorageTypeLimit

	//  Type of the storage. List of available storage options:
	//
	//   - instance Inbuilt storage available for the given Instance
	//   - ebs Elastic block storage that would be attached to the given Instance
	StorageTypeName *string

	noSmithyDocumentSerde
}

// Limits that are applicable for given storage type.
type StorageTypeLimit struct {

	//  Name of storage limits that are applicable for given storage type. If StorageType is ebs,
	// following storage options are applicable
	//
	//   - MinimumVolumeSize Minimum amount of volume size that is applicable for given
	//   storage type.It can be empty if it is not applicable.
	//   - MaximumVolumeSize Maximum amount of volume size that is applicable for given
	//   storage type.It can be empty if it is not applicable.
	//   - MaximumIops Maximum amount of Iops that is applicable for given storage
	//   type.It can be empty if it is not applicable.
	//   - MinimumIops Minimum amount of Iops that is applicable for given storage
	//   type.It can be empty if it is not applicable.
	//   - MaximumThroughput Maximum amount of Throughput that is applicable for given
	//   storage type.It can be empty if it is not applicable.
	//   - MinimumThroughput Minimum amount of Throughput that is applicable for given
	//   storage type.It can be empty if it is not applicable.
	LimitName *string

	//  Values for the StorageTypeLimit$LimitName .
	LimitValues []string

	noSmithyDocumentSerde
}

// Specifies a key value pair for a resource tag.
type Tag struct {

	// Specifies the TagKey , the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// This member is required.
	Key *string

	// Specifies the TagValue , the value assigned to the corresponding tag key. Tag
	// values can be null and do not have to be unique in a tag set. For example, you
	// can have a key value pair in a tag set of project : Trinity and cost-center :
	// Trinity
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// History of the last 10 Upgrades and Upgrade Eligibility Checks.
type UpgradeHistory struct {

	// UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time

	//  A list of UpgradeStepItem s representing information about each step performed as pard of a
	// specific Upgrade or Upgrade Eligibility Check.
	StepsList []UpgradeStepItem

	// A string that describes the update briefly
	UpgradeName *string

	//  The overall status of the update. The status can take one of the following
	// values:
	//
	//   - In Progress
	//   - Succeeded
	//   - Succeeded with Issues
	//   - Failed
	UpgradeStatus UpgradeStatus

	noSmithyDocumentSerde
}

// Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.
type UpgradeStepItem struct {

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []string

	// The Floating point value representing progress percentage of a particular step.
	ProgressPercent *float64

	//  Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through:
	//
	//   - PreUpgradeCheck
	//   - Snapshot
	//   - Upgrade
	UpgradeStep UpgradeStep

	//  The status of a particular step during an upgrade. The status can take one of
	// the following values:
	//
	//   - In Progress
	//   - Succeeded
	//   - Succeeded with Issues
	//   - Failed
	UpgradeStepStatus UpgradeStatus

	noSmithyDocumentSerde
}

// Options to specify the subnets and security groups for VPC endpoint. For more
// information, see [VPC Endpoints for Amazon Elasticsearch Service Domains].
//
// [VPC Endpoints for Amazon Elasticsearch Service Domains]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
type VPCDerivedInfo struct {

	// The availability zones for the Elasticsearch domain. Exists only if the domain
	// was created with VPCOptions.
	AvailabilityZones []string

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []string

	// Specifies the subnets for VPC endpoint.
	SubnetIds []string

	// The VPC Id for the Elasticsearch domain. Exists only if the domain was created
	// with VPCOptions.
	VPCId *string

	noSmithyDocumentSerde
}

// Status of the VPC options for the specified Elasticsearch domain.
type VPCDerivedInfoStatus struct {

	//  Specifies the VPC options for the specified Elasticsearch domain.
	//
	// This member is required.
	Options *VPCDerivedInfo

	//  Specifies the status of the VPC options for the specified Elasticsearch domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// The connection endpoint for connecting to an Amazon OpenSearch Service domain
// through a proxy.
type VpcEndpoint struct {

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string

	// The connection endpoint ID for connecting to the domain.
	Endpoint *string

	// The current status of the endpoint.
	Status VpcEndpointStatus

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	// The creator of the endpoint.
	VpcEndpointOwner *string

	// Options to specify the subnets and security groups for an Amazon OpenSearch
	// Service VPC endpoint.
	VpcOptions *VPCDerivedInfo

	noSmithyDocumentSerde
}

// Error information when attempting to describe an Amazon OpenSearch
// Service-managed VPC endpoint.
type VpcEndpointError struct {

	// The code associated with the error.
	ErrorCode VpcEndpointErrorCode

	// A message describing the error.
	ErrorMessage *string

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// Summary information for an Amazon OpenSearch Service-managed VPC endpoint.
type VpcEndpointSummary struct {

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string

	// The current status of the endpoint.
	Status VpcEndpointStatus

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	// The creator of the endpoint.
	VpcEndpointOwner *string

	noSmithyDocumentSerde
}

// Options to specify the subnets and security groups for VPC endpoint. For more
// information, see [VPC Endpoints for Amazon Elasticsearch Service Domains].
//
// [VPC Endpoints for Amazon Elasticsearch Service Domains]: http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html
type VPCOptions struct {

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []string

	// Specifies the subnets for VPC endpoint.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Specifies the zone awareness configuration for the domain cluster, such as the
// number of availability zones.
type ZoneAwarenessConfig struct {

	// An integer value to indicate the number of availability zones for a domain when
	// zone awareness is enabled. This should be equal to number of subnets if VPC
	// endpoints is enabled
	AvailabilityZoneCount *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
