// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes the association between a Face supplied in an array of FaceIds and the
// User. If the User is not present already, then a ResourceNotFound exception is
// thrown. If successful, an array of faces that are disassociated from the User is
// returned. If a given face is already disassociated from the given UserID, it
// will be ignored and not be returned in the response. If a given face is already
// associated with a different User or not found in the collection it will be
// returned as part of UnsuccessfulDisassociations . You can remove 1 - 100 face
// IDs from a user at one time.
func (c *Client) DisassociateFaces(ctx context.Context, params *DisassociateFacesInput, optFns ...func(*Options)) (*DisassociateFacesOutput, error) {
	if params == nil {
		params = &DisassociateFacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateFaces", params, optFns, c.addOperationDisassociateFacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateFacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateFacesInput struct {

	// The ID of an existing collection containing the UserID.
	//
	// This member is required.
	CollectionId *string

	// An array of face IDs to disassociate from the UserID.
	//
	// This member is required.
	FaceIds []string

	// ID for the existing UserID.
	//
	// This member is required.
	UserId *string

	// Idempotent token used to identify the request to DisassociateFaces . If you use
	// the same token with multiple DisassociateFaces requests, the same response is
	// returned. Use ClientRequestToken to prevent the same request from being
	// processed more than once.
	ClientRequestToken *string

	noSmithyDocumentSerde
}

type DisassociateFacesOutput struct {

	// An array of DissociatedFace objects containing FaceIds that are successfully
	// disassociated with the UserID is returned. Returned if the DisassociatedFaces
	// action is successful.
	DisassociatedFaces []types.DisassociatedFace

	// An array of UnsuccessfulDisassociation objects containing FaceIds that are not
	// successfully associated, along with the reasons for the failure to associate.
	// Returned if the DisassociateFaces action is successful.
	UnsuccessfulFaceDisassociations []types.UnsuccessfulFaceDisassociation

	// The status of an update made to a User. Reflects if the User has been updated
	// for every requested change.
	UserStatus types.UserStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateFacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDisassociateFaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDisassociateFaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateFaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opDisassociateFacesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateFacesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateFaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpDisassociateFaces struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpDisassociateFaces) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpDisassociateFaces) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*DisassociateFacesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *DisassociateFacesInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opDisassociateFacesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpDisassociateFaces{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opDisassociateFaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateFaces",
	}
}
