//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armblueprint

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AssignmentOperationsClient contains the methods for the AssignmentOperations group.
// Don't use this type directly, use NewAssignmentOperationsClient() instead.
type AssignmentOperationsClient struct {
	host string
	pl   runtime.Pipeline
}

// NewAssignmentOperationsClient creates a new instance of AssignmentOperationsClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAssignmentOperationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AssignmentOperationsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AssignmentOperationsClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// Get - Get a blueprint assignment operation.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-11-01-preview
// resourceScope - The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
// subscription (format: '/subscriptions/{subscriptionId}').
// assignmentName - Name of the blueprint assignment.
// assignmentOperationName - Name of the blueprint assignment operation.
// options - AssignmentOperationsClientGetOptions contains the optional parameters for the AssignmentOperationsClient.Get
// method.
func (client *AssignmentOperationsClient) Get(ctx context.Context, resourceScope string, assignmentName string, assignmentOperationName string, options *AssignmentOperationsClientGetOptions) (AssignmentOperationsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceScope, assignmentName, assignmentOperationName, options)
	if err != nil {
		return AssignmentOperationsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AssignmentOperationsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AssignmentOperationsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *AssignmentOperationsClient) getCreateRequest(ctx context.Context, resourceScope string, assignmentName string, assignmentOperationName string, options *AssignmentOperationsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}/assignmentOperations/{assignmentOperationName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceScope}", resourceScope)
	if assignmentName == "" {
		return nil, errors.New("parameter assignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assignmentName}", url.PathEscape(assignmentName))
	if assignmentOperationName == "" {
		return nil, errors.New("parameter assignmentOperationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assignmentOperationName}", url.PathEscape(assignmentOperationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AssignmentOperationsClient) getHandleResponse(resp *http.Response) (AssignmentOperationsClientGetResponse, error) {
	result := AssignmentOperationsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentOperation); err != nil {
		return AssignmentOperationsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List operations for given blueprint assignment within a subscription or a management group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-11-01-preview
// resourceScope - The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'),
// subscription (format: '/subscriptions/{subscriptionId}').
// assignmentName - Name of the blueprint assignment.
// options - AssignmentOperationsClientListOptions contains the optional parameters for the AssignmentOperationsClient.List
// method.
func (client *AssignmentOperationsClient) NewListPager(resourceScope string, assignmentName string, options *AssignmentOperationsClientListOptions) *runtime.Pager[AssignmentOperationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[AssignmentOperationsClientListResponse]{
		More: func(page AssignmentOperationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AssignmentOperationsClientListResponse) (AssignmentOperationsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceScope, assignmentName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return AssignmentOperationsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AssignmentOperationsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AssignmentOperationsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *AssignmentOperationsClient) listCreateRequest(ctx context.Context, resourceScope string, assignmentName string, options *AssignmentOperationsClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}/assignmentOperations"
	urlPath = strings.ReplaceAll(urlPath, "{resourceScope}", resourceScope)
	if assignmentName == "" {
		return nil, errors.New("parameter assignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{assignmentName}", url.PathEscape(assignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *AssignmentOperationsClient) listHandleResponse(resp *http.Response) (AssignmentOperationsClientListResponse, error) {
	result := AssignmentOperationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AssignmentOperationList); err != nil {
		return AssignmentOperationsClientListResponse{}, err
	}
	return result, nil
}
