//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServiceClient contains the methods for the Service group.
// Don't use this type directly, use NewServiceClient() instead.
type ServiceClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewServiceClient creates a new instance of ServiceClient with the specified values.
// subscriptionID - The Subscription Id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServiceClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ServiceClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// NewListAvailableSKUsByResourceGroupPager - This method provides the list of available skus for the given subscription,
// resource group and location.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// resourceGroupName - The Resource Group Name
// location - The location of the resource
// availableSKURequest - Filters for showing the available skus.
// options - ServiceClientListAvailableSKUsByResourceGroupOptions contains the optional parameters for the ServiceClient.ListAvailableSKUsByResourceGroup
// method.
func (client *ServiceClient) NewListAvailableSKUsByResourceGroupPager(resourceGroupName string, location string, availableSKURequest AvailableSKURequest, options *ServiceClientListAvailableSKUsByResourceGroupOptions) *runtime.Pager[ServiceClientListAvailableSKUsByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServiceClientListAvailableSKUsByResourceGroupResponse]{
		More: func(page ServiceClientListAvailableSKUsByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServiceClientListAvailableSKUsByResourceGroupResponse) (ServiceClientListAvailableSKUsByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAvailableSKUsByResourceGroupCreateRequest(ctx, resourceGroupName, location, availableSKURequest, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ServiceClientListAvailableSKUsByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ServiceClientListAvailableSKUsByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ServiceClientListAvailableSKUsByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAvailableSKUsByResourceGroupHandleResponse(resp)
		},
	})
}

// listAvailableSKUsByResourceGroupCreateRequest creates the ListAvailableSKUsByResourceGroup request.
func (client *ServiceClient) listAvailableSKUsByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, availableSKURequest AvailableSKURequest, options *ServiceClientListAvailableSKUsByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/availableSkus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, availableSKURequest)
}

// listAvailableSKUsByResourceGroupHandleResponse handles the ListAvailableSKUsByResourceGroup response.
func (client *ServiceClient) listAvailableSKUsByResourceGroupHandleResponse(resp *http.Response) (ServiceClientListAvailableSKUsByResourceGroupResponse, error) {
	result := ServiceClientListAvailableSKUsByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AvailableSKUsResult); err != nil {
		return ServiceClientListAvailableSKUsByResourceGroupResponse{}, err
	}
	return result, nil
}

// RegionConfiguration - This API provides configuration details specific to given region/location at Subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// location - The location of the resource
// regionConfigurationRequest - Request body to get the configuration for the region.
// options - ServiceClientRegionConfigurationOptions contains the optional parameters for the ServiceClient.RegionConfiguration
// method.
func (client *ServiceClient) RegionConfiguration(ctx context.Context, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationOptions) (ServiceClientRegionConfigurationResponse, error) {
	req, err := client.regionConfigurationCreateRequest(ctx, location, regionConfigurationRequest, options)
	if err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceClientRegionConfigurationResponse{}, runtime.NewResponseError(resp)
	}
	return client.regionConfigurationHandleResponse(resp)
}

// regionConfigurationCreateRequest creates the RegionConfiguration request.
func (client *ServiceClient) regionConfigurationCreateRequest(ctx context.Context, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, regionConfigurationRequest)
}

// regionConfigurationHandleResponse handles the RegionConfiguration response.
func (client *ServiceClient) regionConfigurationHandleResponse(resp *http.Response) (ServiceClientRegionConfigurationResponse, error) {
	result := ServiceClientRegionConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegionConfigurationResponse); err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	return result, nil
}

// RegionConfigurationByResourceGroup - This API provides configuration details specific to given region/location at Resource
// group level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// resourceGroupName - The Resource Group Name
// location - The location of the resource
// regionConfigurationRequest - Request body to get the configuration for the region at resource group level.
// options - ServiceClientRegionConfigurationByResourceGroupOptions contains the optional parameters for the ServiceClient.RegionConfigurationByResourceGroup
// method.
func (client *ServiceClient) RegionConfigurationByResourceGroup(ctx context.Context, resourceGroupName string, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationByResourceGroupOptions) (ServiceClientRegionConfigurationByResourceGroupResponse, error) {
	req, err := client.regionConfigurationByResourceGroupCreateRequest(ctx, resourceGroupName, location, regionConfigurationRequest, options)
	if err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, runtime.NewResponseError(resp)
	}
	return client.regionConfigurationByResourceGroupHandleResponse(resp)
}

// regionConfigurationByResourceGroupCreateRequest creates the RegionConfigurationByResourceGroup request.
func (client *ServiceClient) regionConfigurationByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, regionConfigurationRequest)
}

// regionConfigurationByResourceGroupHandleResponse handles the RegionConfigurationByResourceGroup response.
func (client *ServiceClient) regionConfigurationByResourceGroupHandleResponse(resp *http.Response) (ServiceClientRegionConfigurationByResourceGroupResponse, error) {
	result := ServiceClientRegionConfigurationByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegionConfigurationResponse); err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	return result, nil
}

// ValidateAddress - [DEPRECATED NOTICE: This operation will soon be removed]. This method validates the customer shipping
// address and provide alternate addresses if any.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// location - The location of the resource
// validateAddress - Shipping address of the customer.
// options - ServiceClientValidateAddressOptions contains the optional parameters for the ServiceClient.ValidateAddress method.
func (client *ServiceClient) ValidateAddress(ctx context.Context, location string, validateAddress ValidateAddress, options *ServiceClientValidateAddressOptions) (ServiceClientValidateAddressResponse, error) {
	req, err := client.validateAddressCreateRequest(ctx, location, validateAddress, options)
	if err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceClientValidateAddressResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateAddressHandleResponse(resp)
}

// validateAddressCreateRequest creates the ValidateAddress request.
func (client *ServiceClient) validateAddressCreateRequest(ctx context.Context, location string, validateAddress ValidateAddress, options *ServiceClientValidateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateAddress"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, validateAddress)
}

// validateAddressHandleResponse handles the ValidateAddress response.
func (client *ServiceClient) validateAddressHandleResponse(resp *http.Response) (ServiceClientValidateAddressResponse, error) {
	result := ServiceClientValidateAddressResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressValidationOutput); err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	return result, nil
}

// ValidateInputs - This method does all necessary pre-job creation validation under subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// location - The location of the resource
// validationRequest - Inputs of the customer.
// options - ServiceClientValidateInputsOptions contains the optional parameters for the ServiceClient.ValidateInputs method.
func (client *ServiceClient) ValidateInputs(ctx context.Context, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsOptions) (ServiceClientValidateInputsResponse, error) {
	req, err := client.validateInputsCreateRequest(ctx, location, validationRequest, options)
	if err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceClientValidateInputsResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateInputsHandleResponse(resp)
}

// validateInputsCreateRequest creates the ValidateInputs request.
func (client *ServiceClient) validateInputsCreateRequest(ctx context.Context, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, validationRequest)
}

// validateInputsHandleResponse handles the ValidateInputs response.
func (client *ServiceClient) validateInputsHandleResponse(resp *http.Response) (ServiceClientValidateInputsResponse, error) {
	result := ServiceClientValidateInputsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidationResponse); err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	return result, nil
}

// ValidateInputsByResourceGroup - This method does all necessary pre-job creation validation under resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-02-01
// resourceGroupName - The Resource Group Name
// location - The location of the resource
// validationRequest - Inputs of the customer.
// options - ServiceClientValidateInputsByResourceGroupOptions contains the optional parameters for the ServiceClient.ValidateInputsByResourceGroup
// method.
func (client *ServiceClient) ValidateInputsByResourceGroup(ctx context.Context, resourceGroupName string, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsByResourceGroupOptions) (ServiceClientValidateInputsByResourceGroupResponse, error) {
	req, err := client.validateInputsByResourceGroupCreateRequest(ctx, resourceGroupName, location, validationRequest, options)
	if err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ServiceClientValidateInputsByResourceGroupResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateInputsByResourceGroupHandleResponse(resp)
}

// validateInputsByResourceGroupCreateRequest creates the ValidateInputsByResourceGroup request.
func (client *ServiceClient) validateInputsByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, validationRequest)
}

// validateInputsByResourceGroupHandleResponse handles the ValidateInputsByResourceGroup response.
func (client *ServiceClient) validateInputsByResourceGroupHandleResponse(resp *http.Response) (ServiceClientValidateInputsByResourceGroupResponse, error) {
	result := ServiceClientValidateInputsByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidationResponse); err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	return result, nil
}
