//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armredhatopenshift

import "time"

// APIServerProfile represents an API server profile.
type APIServerProfile struct {
	// The IP of the cluster API server.
	IP *string `json:"ip,omitempty"`

	// The URL to access the cluster API server.
	URL *string `json:"url,omitempty"`

	// API server visibility.
	Visibility *Visibility `json:"visibility,omitempty"`
}

// CloudError represents a cloud error.
type CloudError struct {
	// An error response from the service.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody represents the body of a cloud error.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// ClusterProfile represents a cluster profile.
type ClusterProfile struct {
	// The domain for the cluster.
	Domain *string `json:"domain,omitempty"`

	// If FIPS validated crypto modules are used
	FipsValidatedModules *FipsValidatedModules `json:"fipsValidatedModules,omitempty"`

	// The pull secret for the cluster.
	PullSecret *string `json:"pullSecret,omitempty"`

	// The ID of the cluster resource group.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`

	// The version of the cluster.
	Version *string `json:"version,omitempty"`
}

// ConsoleProfile represents a console profile.
type ConsoleProfile struct {
	// The URL to access the cluster console.
	URL *string `json:"url,omitempty"`
}

// Display represents the display details of an operation.
type Display struct {
	// Friendly name of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty"`

	// Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// IngressProfile represents an ingress profile.
type IngressProfile struct {
	// The IP of the ingress.
	IP *string `json:"ip,omitempty"`

	// The ingress profile name.
	Name *string `json:"name,omitempty"`

	// Ingress visibility.
	Visibility *Visibility `json:"visibility,omitempty"`
}

// MasterProfile represents a master profile.
type MasterProfile struct {
	// The resource ID of an associated DiskEncryptionSet, if applicable.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// Whether master virtual machines are encrypted at host.
	EncryptionAtHost *EncryptionAtHost `json:"encryptionAtHost,omitempty"`

	// The Azure resource ID of the master subnet.
	SubnetID *string `json:"subnetId,omitempty"`

	// The size of the master VMs.
	VMSize *string `json:"vmSize,omitempty"`
}

// NetworkProfile represents a network profile.
type NetworkProfile struct {
	// The CIDR used for OpenShift/Kubernetes Pods.
	PodCidr *string `json:"podCidr,omitempty"`

	// The CIDR used for OpenShift/Kubernetes Services.
	ServiceCidr *string `json:"serviceCidr,omitempty"`
}

// OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
type OpenShiftCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The cluster properties.
	Properties *OpenShiftClusterProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OpenShiftClusterAdminKubeconfig represents an OpenShift cluster's admin kubeconfig.
type OpenShiftClusterAdminKubeconfig struct {
	// The base64-encoded kubeconfig file.
	Kubeconfig *string `json:"kubeconfig,omitempty"`
}

// OpenShiftClusterCredentials represents an OpenShift cluster's credentials.
type OpenShiftClusterCredentials struct {
	// The password for the kubeadmin user.
	KubeadminPassword *string `json:"kubeadminPassword,omitempty"`

	// The username for the kubeadmin user.
	KubeadminUsername *string `json:"kubeadminUsername,omitempty"`
}

// OpenShiftClusterList represents a list of OpenShift clusters.
type OpenShiftClusterList struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of OpenShift clusters.
	Value []*OpenShiftCluster `json:"value,omitempty"`
}

// OpenShiftClusterProperties represents an OpenShift cluster's properties.
type OpenShiftClusterProperties struct {
	// The cluster API server profile.
	ApiserverProfile *APIServerProfile `json:"apiserverProfile,omitempty"`

	// The cluster profile.
	ClusterProfile *ClusterProfile `json:"clusterProfile,omitempty"`

	// The console profile.
	ConsoleProfile *ConsoleProfile `json:"consoleProfile,omitempty"`

	// The cluster ingress profiles.
	IngressProfiles []*IngressProfile `json:"ingressProfiles,omitempty"`

	// The cluster master profile.
	MasterProfile *MasterProfile `json:"masterProfile,omitempty"`

	// The cluster network profile.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// The cluster provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// The cluster service principal profile.
	ServicePrincipalProfile *ServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`

	// The cluster worker profiles.
	WorkerProfiles []*WorkerProfile `json:"workerProfiles,omitempty"`
}

// OpenShiftClusterUpdate - OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
type OpenShiftClusterUpdate struct {
	// The cluster properties.
	Properties *OpenShiftClusterProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`
}

// OpenShiftClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the OpenShiftClustersClient.BeginCreateOrUpdate
// method.
type OpenShiftClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OpenShiftClustersClientBeginDeleteOptions contains the optional parameters for the OpenShiftClustersClient.BeginDelete
// method.
type OpenShiftClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OpenShiftClustersClientBeginUpdateOptions contains the optional parameters for the OpenShiftClustersClient.BeginUpdate
// method.
type OpenShiftClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OpenShiftClustersClientGetOptions contains the optional parameters for the OpenShiftClustersClient.Get method.
type OpenShiftClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// OpenShiftClustersClientListAdminCredentialsOptions contains the optional parameters for the OpenShiftClustersClient.ListAdminCredentials
// method.
type OpenShiftClustersClientListAdminCredentialsOptions struct {
	// placeholder for future optional parameters
}

// OpenShiftClustersClientListByResourceGroupOptions contains the optional parameters for the OpenShiftClustersClient.ListByResourceGroup
// method.
type OpenShiftClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// OpenShiftClustersClientListCredentialsOptions contains the optional parameters for the OpenShiftClustersClient.ListCredentials
// method.
type OpenShiftClustersClientListCredentialsOptions struct {
	// placeholder for future optional parameters
}

// OpenShiftClustersClientListOptions contains the optional parameters for the OpenShiftClustersClient.List method.
type OpenShiftClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// Operation represents an RP operation.
type Operation struct {
	// The object that describes the operation.
	Display *Display `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// Sources of requests to this operation. Comma separated list with valid values user or system, e.g. "user,system".
	Origin *string `json:"origin,omitempty"`
}

// OperationList represents an RP operation list.
type OperationList struct {
	// The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// List of operations supported by the resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicePrincipalProfile represents a service principal profile.
type ServicePrincipalProfile struct {
	// The client ID used for the cluster.
	ClientID *string `json:"clientId,omitempty"`

	// The client secret used for the cluster.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkerProfile represents a worker profile.
type WorkerProfile struct {
	// The number of worker VMs.
	Count *int32 `json:"count,omitempty"`

	// The resource ID of an associated DiskEncryptionSet, if applicable.
	DiskEncryptionSetID *string `json:"diskEncryptionSetId,omitempty"`

	// The disk size of the worker VMs.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Whether master virtual machines are encrypted at host.
	EncryptionAtHost *EncryptionAtHost `json:"encryptionAtHost,omitempty"`

	// The worker profile name.
	Name *string `json:"name,omitempty"`

	// The Azure resource ID of the worker subnet.
	SubnetID *string `json:"subnetId,omitempty"`

	// The size of the worker VMs.
	VMSize *string `json:"vmSize,omitempty"`
}
