//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscvmm

import "time"

// AvailabilitySet - The AvailabilitySets resource definition.
type AvailabilitySet struct {
	// The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *AvailabilitySetProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailabilitySetListItem - Availability Set model
type AvailabilitySetListItem struct {
	// Gets the ARM Id of the microsoft.scvmm/availabilitySets resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets the name of the availability set.
	Name *string `json:"name,omitempty"`
}

// AvailabilitySetListResult - List of AvailabilitySets.
type AvailabilitySetListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of AvailabilitySets.
	Value []*AvailabilitySet `json:"value,omitempty"`
}

// AvailabilitySetProperties - Defines the resource properties.
type AvailabilitySetProperties struct {
	// Name of the availability set.
	AvailabilitySetName *string `json:"availabilitySetName,omitempty"`

	// ARM Id of the vmmServer resource in which this resource resides.
	VmmServerID *string `json:"vmmServerId,omitempty"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AvailabilitySetsClientBeginCreateOrUpdateOptions contains the optional parameters for the AvailabilitySetsClient.BeginCreateOrUpdate
// method.
type AvailabilitySetsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AvailabilitySetsClientBeginDeleteOptions contains the optional parameters for the AvailabilitySetsClient.BeginDelete method.
type AvailabilitySetsClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AvailabilitySetsClientBeginUpdateOptions contains the optional parameters for the AvailabilitySetsClient.BeginUpdate method.
type AvailabilitySetsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AvailabilitySetsClientGetOptions contains the optional parameters for the AvailabilitySetsClient.Get method.
type AvailabilitySetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientListByResourceGroupOptions contains the optional parameters for the AvailabilitySetsClient.ListByResourceGroup
// method.
type AvailabilitySetsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AvailabilitySetsClientListBySubscriptionOptions contains the optional parameters for the AvailabilitySetsClient.ListBySubscription
// method.
type AvailabilitySetsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// Checkpoint - Defines the resource properties.
type Checkpoint struct {
	// Gets ID of the checkpoint.
	CheckpointID *string `json:"checkpointID,omitempty"`

	// Gets description of the checkpoint.
	Description *string `json:"description,omitempty"`

	// Gets name of the checkpoint.
	Name *string `json:"name,omitempty"`

	// Gets ID of parent of the checkpoint.
	ParentCheckpointID *string `json:"parentCheckpointID,omitempty"`
}

// Cloud - The Clouds resource definition.
type Cloud struct {
	// REQUIRED; The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *CloudProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CloudCapacity - Cloud Capacity model
type CloudCapacity struct {
	// CPUCount specifies the maximum number of CPUs that can be allocated in the cloud.
	CPUCount *int64 `json:"cpuCount,omitempty"`

	// MemoryMB specifies a memory usage limit in megabytes.
	MemoryMB *int64 `json:"memoryMB,omitempty"`

	// VMCount gives the max number of VMs that can be deployed in the cloud.
	VMCount *int64 `json:"vmCount,omitempty"`
}

// CloudInventoryItem - The Cloud inventory item.
type CloudInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// READ-ONLY; Gets the Managed Object name in VMM for the inventory item.
	InventoryItemName *string `json:"inventoryItemName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the UUID (which is assigned by VMM) for the inventory item.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type CloudInventoryItem.
func (c *CloudInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     c.InventoryType,
		ManagedResourceID: c.ManagedResourceID,
		UUID:              c.UUID,
		InventoryItemName: c.InventoryItemName,
		ProvisioningState: c.ProvisioningState,
	}
}

// CloudListResult - List of Clouds.
type CloudListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Clouds.
	Value []*Cloud `json:"value,omitempty"`
}

// CloudProperties - Defines the resource properties.
type CloudProperties struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Unique ID of the cloud.
	UUID *string `json:"uuid,omitempty"`

	// ARM Id of the vmmServer resource in which this resource resides.
	VmmServerID *string `json:"vmmServerId,omitempty"`

	// READ-ONLY; Capacity of the cloud.
	CloudCapacity *CloudCapacity `json:"cloudCapacity,omitempty" azure:"ro"`

	// READ-ONLY; Name of the cloud in VMMServer.
	CloudName *string `json:"cloudName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; List of QoS policies available for the cloud.
	StorageQoSPolicies []*StorageQoSPolicy `json:"storageQoSPolicies,omitempty" azure:"ro"`
}

// CloudsClientBeginCreateOrUpdateOptions contains the optional parameters for the CloudsClient.BeginCreateOrUpdate method.
type CloudsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudsClientBeginDeleteOptions contains the optional parameters for the CloudsClient.BeginDelete method.
type CloudsClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudsClientBeginUpdateOptions contains the optional parameters for the CloudsClient.BeginUpdate method.
type CloudsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CloudsClientGetOptions contains the optional parameters for the CloudsClient.Get method.
type CloudsClientGetOptions struct {
	// placeholder for future optional parameters
}

// CloudsClientListByResourceGroupOptions contains the optional parameters for the CloudsClient.ListByResourceGroup method.
type CloudsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CloudsClientListBySubscriptionOptions contains the optional parameters for the CloudsClient.ListBySubscription method.
type CloudsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// ExtendedLocation - The extended location.
type ExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

// HardwareProfile - Defines the resource properties.
type HardwareProfile struct {
	// Gets or sets the number of vCPUs for the vm.
	CPUCount *int32 `json:"cpuCount,omitempty"`

	// Gets or sets a value indicating whether to enable dynamic memory or not.
	DynamicMemoryEnabled *DynamicMemoryEnabled `json:"dynamicMemoryEnabled,omitempty"`

	// Gets or sets the max dynamic memory for the vm.
	DynamicMemoryMaxMB *int32 `json:"dynamicMemoryMaxMB,omitempty"`

	// Gets or sets the min dynamic memory for the vm.
	DynamicMemoryMinMB *int32 `json:"dynamicMemoryMinMB,omitempty"`

	// Gets highly available property.
	IsHighlyAvailable *string `json:"isHighlyAvailable,omitempty"`

	// Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
	LimitCPUForMigration *LimitCPUForMigration `json:"limitCpuForMigration,omitempty"`

	// MemoryMB is the size of a virtual machine's memory, in MB.
	MemoryMB *int32 `json:"memoryMB,omitempty"`
}

// HardwareProfileUpdate - Defines the resource properties.
type HardwareProfileUpdate struct {
	// Gets or sets the number of vCPUs for the vm.
	CPUCount *int32 `json:"cpuCount,omitempty"`

	// Gets or sets a value indicating whether to enable dynamic memory or not.
	DynamicMemoryEnabled *DynamicMemoryEnabled `json:"dynamicMemoryEnabled,omitempty"`

	// Gets or sets the max dynamic memory for the vm.
	DynamicMemoryMaxMB *int32 `json:"dynamicMemoryMaxMB,omitempty"`

	// Gets or sets the min dynamic memory for the vm.
	DynamicMemoryMinMB *int32 `json:"dynamicMemoryMinMB,omitempty"`

	// Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
	LimitCPUForMigration *LimitCPUForMigration `json:"limitCpuForMigration,omitempty"`

	// MemoryMB is the size of a virtual machine's memory, in MB.
	MemoryMB *int32 `json:"memoryMB,omitempty"`
}

// InventoryItem - Defines the inventory item.
type InventoryItem struct {
	// REQUIRED; Resource properties.
	Properties InventoryItemPropertiesClassification `json:"properties,omitempty"`

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InventoryItemDetails - Defines the resource properties.
type InventoryItemDetails struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Gets or sets the Managed Object name in VMM for the resource.
	InventoryItemName *string `json:"inventoryItemName,omitempty"`
}

// InventoryItemPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetInventoryItemProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CloudInventoryItem, *InventoryItemProperties, *VirtualMachineInventoryItem, *VirtualMachineTemplateInventoryItem, *VirtualNetworkInventoryItem
type InventoryItemPropertiesClassification interface {
	// GetInventoryItemProperties returns the InventoryItemProperties content of the underlying type.
	GetInventoryItemProperties() *InventoryItemProperties
}

// InventoryItemProperties - Defines the resource properties.
type InventoryItemProperties struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// READ-ONLY; Gets the Managed Object name in VMM for the inventory item.
	InventoryItemName *string `json:"inventoryItemName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the UUID (which is assigned by VMM) for the inventory item.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type InventoryItemProperties.
func (i *InventoryItemProperties) GetInventoryItemProperties() *InventoryItemProperties { return i }

// InventoryItemsClientCreateOptions contains the optional parameters for the InventoryItemsClient.Create method.
type InventoryItemsClientCreateOptions struct {
	// Request payload.
	Body *InventoryItem
}

// InventoryItemsClientDeleteOptions contains the optional parameters for the InventoryItemsClient.Delete method.
type InventoryItemsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsClientGetOptions contains the optional parameters for the InventoryItemsClient.Get method.
type InventoryItemsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsClientListByVMMServerOptions contains the optional parameters for the InventoryItemsClient.ListByVMMServer
// method.
type InventoryItemsClientListByVMMServerOptions struct {
	// placeholder for future optional parameters
}

// InventoryItemsList - List of InventoryItems.
type InventoryItemsList struct {
	// REQUIRED; Array of InventoryItems
	Value []*InventoryItem `json:"value,omitempty"`

	// Url to follow for getting next page of InventoryItems.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkInterfaces - Network Interface model
type NetworkInterfaces struct {
	// Gets or sets the ipv4 address type.
	IPv4AddressType *AllocationMethod `json:"ipv4AddressType,omitempty"`

	// Gets or sets the ipv6 address type.
	IPv6AddressType *AllocationMethod `json:"ipv6AddressType,omitempty"`

	// Gets or sets the nic MAC address.
	MacAddress *string `json:"macAddress,omitempty"`

	// Gets or sets the mac address type.
	MacAddressType *AllocationMethod `json:"macAddressType,omitempty"`

	// Gets or sets the name of the network interface.
	Name *string `json:"name,omitempty"`

	// Gets or sets the nic id.
	NicID *string `json:"nicId,omitempty"`

	// Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`

	// READ-ONLY; Gets the display name of the network interface as shown in the vmmServer. This is the fallback label for a NIC
	// when the name is not set.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the nic ipv4 addresses.
	IPv4Addresses []*string `json:"ipv4Addresses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the nic ipv6 addresses.
	IPv6Addresses []*string `json:"ipv6Addresses,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the name of the virtual network in vmmServer that the nic is connected to.
	NetworkName *string `json:"networkName,omitempty" azure:"ro"`
}

// NetworkInterfacesUpdate - Network Interface model
type NetworkInterfacesUpdate struct {
	// Gets or sets the ipv4 address type.
	IPv4AddressType *AllocationMethod `json:"ipv4AddressType,omitempty"`

	// Gets or sets the ipv6 address type.
	IPv6AddressType *AllocationMethod `json:"ipv6AddressType,omitempty"`

	// Gets or sets the nic MAC address.
	MacAddress *string `json:"macAddress,omitempty"`

	// Gets or sets the mac address type.
	MacAddressType *AllocationMethod `json:"macAddressType,omitempty"`

	// Gets or sets the name of the network interface.
	Name *string `json:"name,omitempty"`

	// Gets or sets the nic id.
	NicID *string `json:"nicId,omitempty"`

	// Gets or sets the ARM Id of the Microsoft.ScVmm/virtualNetwork resource to connect the nic.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
}

// NetworkProfile - Defines the resource properties.
type NetworkProfile struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterfaces `json:"networkInterfaces,omitempty"`
}

// NetworkProfileUpdate - Defines the resource properties.
type NetworkProfileUpdate struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterfacesUpdate `json:"networkInterfaces,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OsProfile - Defines the resource properties.
type OsProfile struct {
	// Admin password of the virtual machine.
	AdminPassword *string `json:"adminPassword,omitempty"`

	// Gets or sets computer name.
	ComputerName *string `json:"computerName,omitempty"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourcePatch - Object containing tags updates for patch operations.
type ResourcePatch struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ResourceProviderOperation - Results of the request to list operations.
type ResourceProviderOperation struct {
	// Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation applies to data-plane.
	IsDataAction *string `json:"isDataAction,omitempty"`

	// Operation name, in format of {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
}

// ResourceProviderOperationDisplay - Display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Description of this operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// The resource provider.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// ResourceProviderOperationList - Results of the request to list operations.
type ResourceProviderOperationList struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Operations.
	Value []*ResourceProviderOperation `json:"value,omitempty"`
}

// StopVirtualMachineOptions - Defines the stop action properties.
type StopVirtualMachineOptions struct {
	// Gets or sets a value indicating whether to request non-graceful VM shutdown. True value for this flag indicates non-graceful
	// shutdown whereas false indicates otherwise. Defaults to false.
	SkipShutdown *bool `json:"skipShutdown,omitempty"`
}

// StorageProfile - Defines the resource properties.
type StorageProfile struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDisk `json:"disks,omitempty"`
}

// StorageProfileUpdate - Defines the resource properties.
type StorageProfileUpdate struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDiskUpdate `json:"disks,omitempty"`
}

// StorageQoSPolicy - The StorageQoSPolicy definition.
type StorageQoSPolicy struct {
	// The Bandwidth Limit for internet traffic.
	BandwidthLimit *int64 `json:"bandwidthLimit,omitempty"`

	// The ID of the QoS policy.
	ID *string `json:"id,omitempty"`

	// The maximum IO operations per second.
	IopsMaximum *int64 `json:"iopsMaximum,omitempty"`

	// The minimum IO operations per second.
	IopsMinimum *int64 `json:"iopsMinimum,omitempty"`

	// The name of the policy.
	Name *string `json:"name,omitempty"`

	// The underlying policy.
	PolicyID *string `json:"policyId,omitempty"`
}

// StorageQoSPolicyDetails - The StorageQoSPolicyDetails definition.
type StorageQoSPolicyDetails struct {
	// The ID of the QoS policy.
	ID *string `json:"id,omitempty"`

	// The name of the policy.
	Name *string `json:"name,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// VMMServer - The VmmServers resource definition.
type VMMServer struct {
	// REQUIRED; The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VMMServerProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VMMServerListResult - List of VmmServers.
type VMMServerListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VmmServers.
	Value []*VMMServer `json:"value,omitempty"`
}

// VMMServerProperties - Defines the resource properties.
type VMMServerProperties struct {
	// REQUIRED; Fqdn is the hostname/ip of the vmmServer.
	Fqdn *string `json:"fqdn,omitempty"`

	// Credentials to connect to VMMServer.
	Credentials *VMMServerPropertiesCredentials `json:"credentials,omitempty"`

	// Port is the port on which the vmmServer is listening.
	Port *int32 `json:"port,omitempty"`

	// READ-ONLY; Gets or sets the connection status to the vmmServer.
	ConnectionStatus *string `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets any error message if connection to vmmServer is having any issue.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Unique ID of vmmServer.
	UUID *string `json:"uuid,omitempty" azure:"ro"`

	// READ-ONLY; Version is the version of the vmmSever.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// VMMServerPropertiesCredentials - Credentials to connect to VMMServer.
type VMMServerPropertiesCredentials struct {
	// Credentials to use to connect to VMMServer.
	Password *string `json:"password,omitempty"`

	// Username to use to connect to VMMServer.
	Username *string `json:"username,omitempty"`
}

// VirtualDisk - Virtual disk model
type VirtualDisk struct {
	// Gets or sets the disk bus.
	Bus *int32 `json:"bus,omitempty"`

	// Gets or sets the disk bus type.
	BusType *string `json:"busType,omitempty"`

	// Gets or sets a value indicating diff disk.
	CreateDiffDisk *CreateDiffDisk `json:"createDiffDisk,omitempty"`

	// Gets or sets the disk id.
	DiskID *string `json:"diskId,omitempty"`

	// Gets or sets the disk total size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets or sets the disk lun.
	Lun *int32 `json:"lun,omitempty"`

	// Gets or sets the name of the disk.
	Name *string `json:"name,omitempty"`

	// The QoS policy for the disk.
	StorageQoSPolicy *StorageQoSPolicyDetails `json:"storageQoSPolicy,omitempty"`

	// Gets or sets the disk id in the template.
	TemplateDiskID *string `json:"templateDiskId,omitempty"`

	// Gets or sets the disk vhd type.
	VhdType *string `json:"vhdType,omitempty"`

	// READ-ONLY; Gets the display name of the virtual disk as shown in the vmmServer. This is the fallback label for a disk when
	// the name is not set.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the max disk size.
	MaxDiskSizeGB *int32 `json:"maxDiskSizeGB,omitempty" azure:"ro"`

	// READ-ONLY; Gets the disk vhd format type.
	VhdFormatType *string `json:"vhdFormatType,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the disk volume type.
	VolumeType *string `json:"volumeType,omitempty" azure:"ro"`
}

// VirtualDiskUpdate - Virtual disk model
type VirtualDiskUpdate struct {
	// Gets or sets the disk bus.
	Bus *int32 `json:"bus,omitempty"`

	// Gets or sets the disk bus type.
	BusType *string `json:"busType,omitempty"`

	// Gets or sets the disk id.
	DiskID *string `json:"diskId,omitempty"`

	// Gets or sets the disk total size.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`

	// Gets or sets the disk lun.
	Lun *int32 `json:"lun,omitempty"`

	// Gets or sets the name of the disk.
	Name *string `json:"name,omitempty"`

	// The QoS policy for the disk.
	StorageQoSPolicy *StorageQoSPolicyDetails `json:"storageQoSPolicy,omitempty"`

	// Gets or sets the disk vhd type.
	VhdType *string `json:"vhdType,omitempty"`
}

// VirtualMachine - The VirtualMachines resource definition.
type VirtualMachine struct {
	// REQUIRED; The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualMachineProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineCreateCheckpoint - Defines the create checkpoint action properties.
type VirtualMachineCreateCheckpoint struct {
	// Description of the checkpoint.
	Description *string `json:"description,omitempty"`

	// Name of the checkpoint.
	Name *string `json:"name,omitempty"`
}

// VirtualMachineDeleteCheckpoint - Defines the delete checkpoint action properties.
type VirtualMachineDeleteCheckpoint struct {
	// ID of the checkpoint to be deleted.
	ID *string `json:"id,omitempty"`
}

// VirtualMachineInventoryItem - The Virtual machine inventory item.
type VirtualMachineInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// Cloud inventory resource details where the VM is present.
	Cloud *InventoryItemDetails `json:"cloud,omitempty"`

	// Gets or sets the nic ip addresses.
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// READ-ONLY; Gets the Managed Object name in VMM for the inventory item.
	InventoryItemName *string `json:"inventoryItemName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the UUID (which is assigned by VMM) for the inventory item.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineInventoryItem.
func (v *VirtualMachineInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		UUID:              v.UUID,
		InventoryItemName: v.InventoryItemName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineListResult - List of VirtualMachines.
type VirtualMachineListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualMachines.
	Value []*VirtualMachine `json:"value,omitempty"`
}

// VirtualMachineProperties - Defines the resource properties.
type VirtualMachineProperties struct {
	// Availability Sets in vm.
	AvailabilitySets []*AvailabilitySetListItem `json:"availabilitySets,omitempty"`

	// Type of checkpoint supported for the vm.
	CheckpointType *string `json:"checkpointType,omitempty"`

	// Checkpoints in the vm.
	Checkpoints []*Checkpoint `json:"checkpoints,omitempty"`

	// ARM Id of the cloud resource to use for deploying the vm.
	CloudID *string `json:"cloudId,omitempty"`

	// Gets or sets the generation for the vm.
	Generation *int32 `json:"generation,omitempty"`

	// Hardware properties.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`

	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Network properties.
	NetworkProfile *NetworkProfile `json:"networkProfile,omitempty"`

	// OS properties.
	OSProfile *OsProfile `json:"osProfile,omitempty"`

	// Storage properties.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`

	// ARM Id of the template resource to use for deploying the vm.
	TemplateID *string `json:"templateId,omitempty"`

	// Unique ID of the virtual machine.
	UUID *string `json:"uuid,omitempty"`

	// VMName is the name of VM on the SCVMM server.
	VMName *string `json:"vmName,omitempty"`

	// ARM Id of the vmmServer resource in which this resource resides.
	VmmServerID *string `json:"vmmServerId,omitempty"`

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string `json:"powerState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualMachineRestoreCheckpoint - Defines the restore checkpoint action properties.
type VirtualMachineRestoreCheckpoint struct {
	// ID of the checkpoint to be restored to.
	ID *string `json:"id,omitempty"`
}

// VirtualMachineTemplate - The VirtualMachineTemplates resource definition.
type VirtualMachineTemplate struct {
	// REQUIRED; The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualMachineTemplateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualMachineTemplateInventoryItem - The Virtual machine template inventory item.
type VirtualMachineTemplateInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// READ-ONLY; Gets or sets the desired number of vCPUs for the vm.
	CPUCount *int32 `json:"cpuCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the Managed Object name in VMM for the inventory item.
	InventoryItemName *string `json:"inventoryItemName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; MemoryMB is the desired size of a virtual machine's memory, in MB.
	MemoryMB *int32 `json:"memoryMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the UUID (which is assigned by VMM) for the inventory item.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineTemplateInventoryItem.
func (v *VirtualMachineTemplateInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		UUID:              v.UUID,
		InventoryItemName: v.InventoryItemName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineTemplateListResult - List of VirtualMachineTemplates.
type VirtualMachineTemplateListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualMachineTemplates.
	Value []*VirtualMachineTemplate `json:"value,omitempty"`
}

// VirtualMachineTemplateProperties - Defines the resource properties.
type VirtualMachineTemplateProperties struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Unique ID of the virtual machine template.
	UUID *string `json:"uuid,omitempty"`

	// ARM Id of the vmmServer resource in which this resource resides.
	VmmServerID *string `json:"vmmServerId,omitempty"`

	// READ-ONLY; Gets or sets the desired number of vCPUs for the vm.
	CPUCount *int32 `json:"cpuCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets computer name.
	ComputerName *string `json:"computerName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the disks of the template.
	Disks []*VirtualDisk `json:"disks,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a value indicating whether to enable dynamic memory or not.
	DynamicMemoryEnabled *DynamicMemoryEnabled `json:"dynamicMemoryEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the max dynamic memory for the vm.
	DynamicMemoryMaxMB *int32 `json:"dynamicMemoryMaxMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the min dynamic memory for the vm.
	DynamicMemoryMinMB *int32 `json:"dynamicMemoryMinMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the generation for the vm.
	Generation *int32 `json:"generation,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a value indicating whether the vm template is customizable or not.
	IsCustomizable *IsCustomizable `json:"isCustomizable,omitempty" azure:"ro"`

	// READ-ONLY; Gets highly available property.
	IsHighlyAvailable *string `json:"isHighlyAvailable,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets a value indicating whether to enable processor compatibility mode for live migration of VMs.
	LimitCPUForMigration *LimitCPUForMigration `json:"limitCpuForMigration,omitempty" azure:"ro"`

	// READ-ONLY; MemoryMB is the desired size of a virtual machine's memory, in MB.
	MemoryMB *int32 `json:"memoryMB,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the network interfaces of the template.
	NetworkInterfaces []*NetworkInterfaces `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets os name.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType `json:"osType,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualMachineTemplatesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachineTemplatesClient.BeginCreateOrUpdate
// method.
type VirtualMachineTemplatesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineTemplatesClientBeginDeleteOptions contains the optional parameters for the VirtualMachineTemplatesClient.BeginDelete
// method.
type VirtualMachineTemplatesClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineTemplatesClientBeginUpdateOptions contains the optional parameters for the VirtualMachineTemplatesClient.BeginUpdate
// method.
type VirtualMachineTemplatesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachineTemplatesClientGetOptions contains the optional parameters for the VirtualMachineTemplatesClient.Get method.
type VirtualMachineTemplatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachineTemplatesClient.ListByResourceGroup
// method.
type VirtualMachineTemplatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineTemplatesClientListBySubscriptionOptions contains the optional parameters for the VirtualMachineTemplatesClient.ListBySubscription
// method.
type VirtualMachineTemplatesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachineUpdate - Defines the virtualMachineUpdate.
type VirtualMachineUpdate struct {
	// Defines the resource properties.
	Properties *VirtualMachineUpdateProperties `json:"properties,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineUpdateProperties - Defines the resource properties.
type VirtualMachineUpdateProperties struct {
	// Availability Sets in vm.
	AvailabilitySets []*AvailabilitySetListItem `json:"availabilitySets,omitempty"`

	// Defines the resource properties.
	HardwareProfile *HardwareProfileUpdate `json:"hardwareProfile,omitempty"`

	// Defines the resource properties.
	NetworkProfile *NetworkProfileUpdate `json:"networkProfile,omitempty"`

	// Defines the resource properties.
	StorageProfile *StorageProfileUpdate `json:"storageProfile,omitempty"`
}

// VirtualMachinesClientBeginCreateCheckpointOptions contains the optional parameters for the VirtualMachinesClient.BeginCreateCheckpoint
// method.
type VirtualMachinesClientBeginCreateCheckpointOptions struct {
	// Virtualmachine create checkpoint action payload.
	Body *VirtualMachineCreateCheckpoint
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginCreateOrUpdate
// method.
type VirtualMachinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteCheckpointOptions contains the optional parameters for the VirtualMachinesClient.BeginDeleteCheckpoint
// method.
type VirtualMachinesClientBeginDeleteCheckpointOptions struct {
	// Virtualmachine delete checkpoint action payload.
	Body *VirtualMachineDeleteCheckpoint
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginDeleteOptions contains the optional parameters for the VirtualMachinesClient.BeginDelete method.
type VirtualMachinesClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
	// Whether to just disable the VM from azure and retain the VM in the VMM.
	Retain *bool
}

// VirtualMachinesClientBeginRestartOptions contains the optional parameters for the VirtualMachinesClient.BeginRestart method.
type VirtualMachinesClientBeginRestartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginRestoreCheckpointOptions contains the optional parameters for the VirtualMachinesClient.BeginRestoreCheckpoint
// method.
type VirtualMachinesClientBeginRestoreCheckpointOptions struct {
	// Virtualmachine restore checkpoint action payload.
	Body *VirtualMachineRestoreCheckpoint
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStartOptions contains the optional parameters for the VirtualMachinesClient.BeginStart method.
type VirtualMachinesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginStopOptions contains the optional parameters for the VirtualMachinesClient.BeginStop method.
type VirtualMachinesClientBeginStopOptions struct {
	// Virtualmachine stop action payload.
	Body *StopVirtualMachineOptions
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientBeginUpdateOptions contains the optional parameters for the VirtualMachinesClient.BeginUpdate method.
type VirtualMachinesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualMachinesClientGetOptions contains the optional parameters for the VirtualMachinesClient.Get method.
type VirtualMachinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListByResourceGroupOptions contains the optional parameters for the VirtualMachinesClient.ListByResourceGroup
// method.
type VirtualMachinesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualMachinesClientListBySubscriptionOptions contains the optional parameters for the VirtualMachinesClient.ListBySubscription
// method.
type VirtualMachinesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetwork - The VirtualNetworks resource definition.
type VirtualNetwork struct {
	// REQUIRED; The extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// REQUIRED; Gets or sets the location.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource properties.
	Properties *VirtualNetworkProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system data.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource Type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkInventoryItem - The Virtual network inventory item.
type VirtualNetworkInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType `json:"inventoryType,omitempty"`

	// READ-ONLY; Gets the Managed Object name in VMM for the inventory item.
	InventoryItemName *string `json:"inventoryItemName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string `json:"managedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the UUID (which is assigned by VMM) for the inventory item.
	UUID *string `json:"uuid,omitempty" azure:"ro"`
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualNetworkInventoryItem.
func (v *VirtualNetworkInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		UUID:              v.UUID,
		InventoryItemName: v.InventoryItemName,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualNetworkListResult - List of VirtualNetworks.
type VirtualNetworkListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string `json:"nextLink,omitempty"`

	// List of VirtualNetworks.
	Value []*VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkProperties - Defines the resource properties.
type VirtualNetworkProperties struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string `json:"inventoryItemId,omitempty"`

	// Unique ID of the virtual network.
	UUID *string `json:"uuid,omitempty"`

	// ARM Id of the vmmServer resource in which this resource resides.
	VmmServerID *string `json:"vmmServerId,omitempty"`

	// READ-ONLY; Name of the virtual network in vmmServer.
	NetworkName *string `json:"networkName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreateOrUpdate
// method.
type VirtualNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginDeleteOptions contains the optional parameters for the VirtualNetworksClient.BeginDelete method.
type VirtualNetworksClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginUpdate method.
type VirtualNetworksClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListByResourceGroupOptions contains the optional parameters for the VirtualNetworksClient.ListByResourceGroup
// method.
type VirtualNetworksClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListBySubscriptionOptions contains the optional parameters for the VirtualNetworksClient.ListBySubscription
// method.
type VirtualNetworksClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VmmServersClientBeginCreateOrUpdateOptions contains the optional parameters for the VmmServersClient.BeginCreateOrUpdate
// method.
type VmmServersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VmmServersClientBeginDeleteOptions contains the optional parameters for the VmmServersClient.BeginDelete method.
type VmmServersClientBeginDeleteOptions struct {
	// Forces the resource to be deleted from azure. The corresponding CR would be attempted to be deleted too.
	Force *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VmmServersClientBeginUpdateOptions contains the optional parameters for the VmmServersClient.BeginUpdate method.
type VmmServersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VmmServersClientGetOptions contains the optional parameters for the VmmServersClient.Get method.
type VmmServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VmmServersClientListByResourceGroupOptions contains the optional parameters for the VmmServersClient.ListByResourceGroup
// method.
type VmmServersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VmmServersClientListBySubscriptionOptions contains the optional parameters for the VmmServersClient.ListBySubscription
// method.
type VmmServersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}
