//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyEntity.
func (a AccessPolicyEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyProperties.
func (a AccessPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authentication", a.Authentication)
	populate(objectMap, "role", a.Role)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyProperties.
func (a *AccessPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			a.Authentication, err = unmarshalAuthenticationBaseClassification(val)
			delete(rawMsg, key)
		case "role":
			err = unpopulate(val, "Role", &a.Role)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AudioEncoderAac.
func (a AudioEncoderAac) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrateKbps", a.BitrateKbps)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.AudioEncoderAac"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AudioEncoderAac.
func (a *AudioEncoderAac) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrateKbps":
			err = unpopulate(val, "BitrateKbps", &a.BitrateKbps)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EccTokenKey.
func (e EccTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alg", e.Alg)
	populate(objectMap, "kid", e.Kid)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.EccTokenKey"
	populate(objectMap, "x", e.X)
	populate(objectMap, "y", e.Y)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EccTokenKey.
func (e *EccTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alg":
			err = unpopulate(val, "Alg", &e.Alg)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, "Kid", &e.Kid)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "x":
			err = unpopulate(val, "X", &e.X)
			delete(rawMsg, key)
		case "y":
			err = unpopulate(val, "Y", &e.Y)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EdgeModuleProvisioningToken.
func (e *EdgeModuleProvisioningToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &e.ExpirationDate)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &e.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncoderCustomPreset.
func (e EncoderCustomPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audioEncoder", e.AudioEncoder)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.EncoderCustomPreset"
	populate(objectMap, "videoEncoder", e.VideoEncoder)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncoderCustomPreset.
func (e *EncoderCustomPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audioEncoder":
			e.AudioEncoder, err = unmarshalAudioEncoderBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "videoEncoder":
			e.VideoEncoder, err = unmarshalVideoEncoderBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncoderProcessor.
func (e EncoderProcessor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", e.Inputs)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "preset", e.Preset)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.EncoderProcessor"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncoderProcessor.
func (e *EncoderProcessor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &e.Inputs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "preset":
			e.Preset, err = unmarshalEncoderPresetBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncoderSystemPreset.
func (e EncoderSystemPreset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", e.Name)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.EncoderSystemPreset"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncoderSystemPreset.
func (e *EncoderSystemPreset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointBase.
func (e EndpointBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", e.Credentials)
	populate(objectMap, "tunnel", e.Tunnel)
	objectMap["@type"] = e.Type
	populate(objectMap, "url", e.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointBase.
func (e *EndpointBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			e.Credentials, err = unmarshalCredentialsBaseClassification(val)
			delete(rawMsg, key)
		case "tunnel":
			e.Tunnel, err = unmarshalTunnelBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &e.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type JwtAuthentication.
func (j JwtAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "audiences", j.Audiences)
	populate(objectMap, "claims", j.Claims)
	populate(objectMap, "issuers", j.Issuers)
	populate(objectMap, "keys", j.Keys)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.JwtAuthentication"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JwtAuthentication.
func (j *JwtAuthentication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "audiences":
			err = unpopulate(val, "Audiences", &j.Audiences)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &j.Claims)
			delete(rawMsg, key)
		case "issuers":
			err = unpopulate(val, "Issuers", &j.Issuers)
			delete(rawMsg, key)
		case "keys":
			j.Keys, err = unmarshalTokenKeyClassificationArray(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListProvisioningTokenInput.
func (l ListProvisioningTokenInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListProvisioningTokenInput.
func (l *ListProvisioningTokenInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LivePipelineProperties.
func (l LivePipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrateKbps", l.BitrateKbps)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "parameters", l.Parameters)
	populate(objectMap, "state", l.State)
	populate(objectMap, "topologyName", l.TopologyName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LivePipelinePropertiesUpdate.
func (l LivePipelinePropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrateKbps", l.BitrateKbps)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "parameters", l.Parameters)
	populate(objectMap, "state", l.State)
	populate(objectMap, "topologyName", l.TopologyName)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LivePipelineUpdate.
func (l LivePipelineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "systemData", l.SystemData)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PemCertificateList.
func (p PemCertificateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "certificates", p.Certificates)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.PemCertificateList"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PemCertificateList.
func (p *PemCertificateList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificates":
			err = unpopulate(val, "Certificates", &p.Certificates)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineJobProperties.
func (p PipelineJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", p.Description)
	populate(objectMap, "error", p.Error)
	populateTimeRFC3339(objectMap, "expiration", p.Expiration)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "state", p.State)
	populate(objectMap, "topologyName", p.TopologyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineJobProperties.
func (p *PipelineJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateTimeRFC3339(val, "Expiration", &p.Expiration)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &p.Parameters)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "topologyName":
			err = unpopulate(val, "TopologyName", &p.TopologyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineJobPropertiesUpdate.
func (p PipelineJobPropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", p.Description)
	populate(objectMap, "error", p.Error)
	populateTimeRFC3339(objectMap, "expiration", p.Expiration)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "state", p.State)
	populate(objectMap, "topologyName", p.TopologyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineJobPropertiesUpdate.
func (p *PipelineJobPropertiesUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "expiration":
			err = unpopulateTimeRFC3339(val, "Expiration", &p.Expiration)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &p.Parameters)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "topologyName":
			err = unpopulate(val, "TopologyName", &p.TopologyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineJobUpdate.
func (p PipelineJobUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PipelineTopologyProperties.
func (p PipelineTopologyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", p.Description)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "processors", p.Processors)
	populate(objectMap, "sinks", p.Sinks)
	populate(objectMap, "sources", p.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineTopologyProperties.
func (p *PipelineTopologyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &p.Parameters)
			delete(rawMsg, key)
		case "processors":
			p.Processors, err = unmarshalProcessorNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		case "sinks":
			p.Sinks, err = unmarshalSinkNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		case "sources":
			p.Sources, err = unmarshalSourceNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineTopologyPropertiesUpdate.
func (p PipelineTopologyPropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", p.Description)
	populate(objectMap, "parameters", p.Parameters)
	populate(objectMap, "processors", p.Processors)
	populate(objectMap, "sinks", p.Sinks)
	populate(objectMap, "sources", p.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineTopologyPropertiesUpdate.
func (p *PipelineTopologyPropertiesUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &p.Parameters)
			delete(rawMsg, key)
		case "processors":
			p.Processors, err = unmarshalProcessorNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		case "sinks":
			p.Sinks, err = unmarshalSinkNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		case "sources":
			p.Sources, err = unmarshalSourceNodeBaseClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineTopologyUpdate.
func (p PipelineTopologyUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "kind", p.Kind)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProcessorNodeBase.
func (p ProcessorNodeBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", p.Inputs)
	populate(objectMap, "name", p.Name)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.ProcessorNodeBase"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessorNodeBase.
func (p *ProcessorNodeBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &p.Inputs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryption", p.Encryption)
	populate(objectMap, "endpoints", p.Endpoints)
	populate(objectMap, "iotHubs", p.IotHubs)
	populate(objectMap, "networkAccessControl", p.NetworkAccessControl)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	populate(objectMap, "storageAccounts", p.StorageAccounts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PropertiesUpdate.
func (p PropertiesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "encryption", p.Encryption)
	populate(objectMap, "endpoints", p.Endpoints)
	populate(objectMap, "iotHubs", p.IotHubs)
	populate(objectMap, "networkAccessControl", p.NetworkAccessControl)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	populate(objectMap, "storageAccounts", p.StorageAccounts)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RsaTokenKey.
func (r RsaTokenKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "alg", r.Alg)
	populate(objectMap, "e", r.E)
	populate(objectMap, "kid", r.Kid)
	populate(objectMap, "n", r.N)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.RsaTokenKey"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RsaTokenKey.
func (r *RsaTokenKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alg":
			err = unpopulate(val, "Alg", &r.Alg)
			delete(rawMsg, key)
		case "e":
			err = unpopulate(val, "E", &r.E)
			delete(rawMsg, key)
		case "kid":
			err = unpopulate(val, "Kid", &r.Kid)
			delete(rawMsg, key)
		case "n":
			err = unpopulate(val, "N", &r.N)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RtspSource.
func (r RtspSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endpoint", r.Endpoint)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "transport", r.Transport)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.RtspSource"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RtspSource.
func (r *RtspSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			r.Endpoint, err = unmarshalEndpointBaseClassification(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "transport":
			err = unpopulate(val, "Transport", &r.Transport)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecureIotDeviceRemoteTunnel.
func (s SecureIotDeviceRemoteTunnel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceId", s.DeviceID)
	populate(objectMap, "iotHubName", s.IotHubName)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.SecureIotDeviceRemoteTunnel"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecureIotDeviceRemoteTunnel.
func (s *SecureIotDeviceRemoteTunnel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &s.DeviceID)
			delete(rawMsg, key)
		case "iotHubName":
			err = unpopulate(val, "IotHubName", &s.IotHubName)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SinkNodeBase.
func (s SinkNodeBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", s.Inputs)
	populate(objectMap, "name", s.Name)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.SinkNodeBase"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SinkNodeBase.
func (s *SinkNodeBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &s.Inputs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceNodeBase.
func (s SourceNodeBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.SourceNodeBase"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceNodeBase.
func (s *SourceNodeBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TLSEndpoint.
func (t TLSEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", t.Credentials)
	populate(objectMap, "trustedCertificates", t.TrustedCertificates)
	populate(objectMap, "tunnel", t.Tunnel)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.TlsEndpoint"
	populate(objectMap, "url", t.URL)
	populate(objectMap, "validationOptions", t.ValidationOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TLSEndpoint.
func (t *TLSEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			t.Credentials, err = unmarshalCredentialsBaseClassification(val)
			delete(rawMsg, key)
		case "trustedCertificates":
			t.TrustedCertificates, err = unmarshalCertificateSourceClassification(val)
			delete(rawMsg, key)
		case "tunnel":
			t.Tunnel, err = unmarshalTunnelBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &t.URL)
			delete(rawMsg, key)
		case "validationOptions":
			err = unpopulate(val, "ValidationOptions", &t.ValidationOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UnsecuredEndpoint.
func (u UnsecuredEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", u.Credentials)
	populate(objectMap, "tunnel", u.Tunnel)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.UnsecuredEndpoint"
	populate(objectMap, "url", u.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnsecuredEndpoint.
func (u *UnsecuredEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			u.Credentials, err = unmarshalCredentialsBaseClassification(val)
			delete(rawMsg, key)
		case "tunnel":
			u.Tunnel, err = unmarshalTunnelBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &u.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UsernamePasswordCredentials.
func (u UsernamePasswordCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "password", u.Password)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.UsernamePasswordCredentials"
	populate(objectMap, "username", u.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsernamePasswordCredentials.
func (u *UsernamePasswordCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &u.Password)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &u.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoAnalyzer.
func (v VideoAnalyzer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoContentToken.
func (v *VideoContentToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationDate":
			err = unpopulateTimeRFC3339(val, "ExpirationDate", &v.ExpirationDate)
			delete(rawMsg, key)
		case "token":
			err = unpopulate(val, "Token", &v.Token)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoEncoderH264.
func (v VideoEncoderH264) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "bitrateKbps", v.BitrateKbps)
	populate(objectMap, "frameRate", v.FrameRate)
	populate(objectMap, "scale", v.Scale)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.VideoEncoderH264"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoEncoderH264.
func (v *VideoEncoderH264) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrateKbps":
			err = unpopulate(val, "BitrateKbps", &v.BitrateKbps)
			delete(rawMsg, key)
		case "frameRate":
			err = unpopulate(val, "FrameRate", &v.FrameRate)
			delete(rawMsg, key)
		case "scale":
			err = unpopulate(val, "Scale", &v.Scale)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoEntity.
func (v VideoEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type VideoSequenceAbsoluteTimeMarkers.
func (v VideoSequenceAbsoluteTimeMarkers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ranges", v.Ranges)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.VideoSequenceAbsoluteTimeMarkers"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoSequenceAbsoluteTimeMarkers.
func (v *VideoSequenceAbsoluteTimeMarkers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ranges":
			err = unpopulate(val, "Ranges", &v.Ranges)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoSink.
func (v VideoSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inputs", v.Inputs)
	populate(objectMap, "name", v.Name)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.VideoSink"
	populate(objectMap, "videoCreationProperties", v.VideoCreationProperties)
	populate(objectMap, "videoName", v.VideoName)
	populate(objectMap, "videoPublishingOptions", v.VideoPublishingOptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoSink.
func (v *VideoSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputs":
			err = unpopulate(val, "Inputs", &v.Inputs)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "videoCreationProperties":
			err = unpopulate(val, "VideoCreationProperties", &v.VideoCreationProperties)
			delete(rawMsg, key)
		case "videoName":
			err = unpopulate(val, "VideoName", &v.VideoName)
			delete(rawMsg, key)
		case "videoPublishingOptions":
			err = unpopulate(val, "VideoPublishingOptions", &v.VideoPublishingOptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VideoSource.
func (v VideoSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", v.Name)
	populate(objectMap, "timeSequences", v.TimeSequences)
	objectMap["@type"] = "#Microsoft.VideoAnalyzer.VideoSource"
	populate(objectMap, "videoName", v.VideoName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VideoSource.
func (v *VideoSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "timeSequences":
			v.TimeSequences, err = unmarshalTimeSequenceBaseClassification(val)
			delete(rawMsg, key)
		case "@type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "videoName":
			err = unpopulate(val, "VideoName", &v.VideoName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
