// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The data associated with a deployment.
type DeploymentData struct {

	// The time the deployment was created.
	CreatedAt *time.Time

	// The time the deployment was deleted.
	DeletedAt *time.Time

	// The ID of the deployment.
	Id *string

	// The name of the deployment.
	Name *string

	// The pattern name of the deployment.
	PatternName *string

	// The resource group of the deployment.
	ResourceGroup *string

	// The specifications of the deployment. For more information on specifications
	// for each deployment, see [Workload specifications].
	//
	// [Workload specifications]: https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications.html
	Specifications map[string]string

	// The status of the deployment.
	Status DeploymentStatus

	// The name of the workload.
	WorkloadName *string

	noSmithyDocumentSerde
}

// A summary of the deployment data.
type DeploymentDataSummary struct {

	// The time the deployment was created.
	CreatedAt *time.Time

	// The ID of the deployment.
	Id *string

	// The name of the deployment
	Name *string

	// The name of the workload deployment pattern.
	PatternName *string

	// The status of the deployment.
	Status DeploymentStatus

	// The name of the workload.
	WorkloadName *string

	noSmithyDocumentSerde
}

// A summary of the deployment event data.
type DeploymentEventDataSummary struct {

	// The description of the deployment event.
	Description *string

	// The name of the deployment event.
	Name *string

	// The status of the deployment event.
	Status EventStatus

	// The reason of the deployment event status.
	StatusReason *string

	// The timestamp of the deployment event.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// A filter name and value pair that is used to return more specific results from
// a describe operation. Filters can be used to match a set of resources by
// specific criteria.
type DeploymentFilter struct {

	// The name of the filter. Filter names are case-sensitive.
	Name DeploymentFilterKey

	// The filter values. Filter values are case-sensitive. If you specify multiple
	// values for a filter, the values are joined with an OR , and the request returns
	// all results that match any of the specified values.
	Values []string

	noSmithyDocumentSerde
}

// Describes a workload.
type WorkloadData struct {

	// The description of a workload.
	Description *string

	// The display name of a workload.
	DisplayName *string

	// The URL of a workload document.
	DocumentationUrl *string

	// The URL of a workload icon.
	IconUrl *string

	// The status of a workload.
	Status WorkloadStatus

	// The message about a workload's status.
	StatusMessage *string

	// The name of the workload.
	WorkloadName *string

	noSmithyDocumentSerde
}

// Describes workload data.
type WorkloadDataSummary struct {

	// The display name of the workload data.
	DisplayName *string

	// The name of the workload.
	WorkloadName *string

	noSmithyDocumentSerde
}

// Describes a workload deployment pattern.
type WorkloadDeploymentPatternDataSummary struct {

	// The name of a workload deployment pattern.
	DeploymentPatternName *string

	// The description of a workload deployment pattern.
	Description *string

	// The display name of a workload deployment pattern.
	DisplayName *string

	// The status of a workload deployment pattern.
	Status WorkloadDeploymentPatternStatus

	// A message about a workload deployment pattern's status.
	StatusMessage *string

	// The name of the workload.
	WorkloadName *string

	// The name of the workload deployment pattern version.
	WorkloadVersionName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
