// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
//
// The firewall defines the configuration settings for an Network Firewall
// firewall. The settings that you can define at creation include the firewall
// policy, the subnets in your VPC to use for the firewall endpoints, and any tags
// that are attached to the firewall Amazon Web Services resource.
//
// After you create a firewall, you can provide additional settings, like the
// logging configuration.
//
// To update the settings for a firewall, you use the operations that apply to the
// settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
//
// To manage a firewall's tags, use the standard Amazon Web Services resource
// tagging operations, ListTagsForResource, TagResource, and UntagResource.
//
// To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
func (c *Client) CreateFirewall(ctx context.Context, params *CreateFirewallInput, optFns ...func(*Options)) (*CreateFirewallOutput, error) {
	if params == nil {
		params = &CreateFirewallInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFirewall", params, optFns, c.addOperationCreateFirewallMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFirewallOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFirewallInput struct {

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// This member is required.
	FirewallName *string

	// The Amazon Resource Name (ARN) of the FirewallPolicy that you want to use for the firewall.
	//
	// This member is required.
	FirewallPolicyArn *string

	// The public subnets to use for your Network Firewall firewalls. Each subnet must
	// belong to a different Availability Zone in the VPC. Network Firewall creates a
	// firewall endpoint in each subnet.
	//
	// This member is required.
	SubnetMappings []types.SubnetMapping

	// The unique identifier of the VPC where Network Firewall should create the
	// firewall.
	//
	// You can't change this setting after you create the firewall.
	//
	// This member is required.
	VpcId *string

	// A flag indicating whether it is possible to delete the firewall. A setting of
	// TRUE indicates that the firewall is protected against deletion. Use this setting
	// to protect against accidentally deleting a firewall that is in use. When you
	// create a firewall, the operation initializes this flag to TRUE .
	DeleteProtection bool

	// A description of the firewall.
	Description *string

	// A complex type that contains settings for encryption of your firewall resources.
	EncryptionConfiguration *types.EncryptionConfiguration

	// A setting indicating whether the firewall is protected against a change to the
	// firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	FirewallPolicyChangeProtection bool

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	SubnetChangeProtection bool

	// The key:value pairs to associate with the resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateFirewallOutput struct {

	// The configuration settings for the firewall. These settings include the
	// firewall policy and the subnets in your VPC to use for the firewall endpoints.
	Firewall *types.Firewall

	// Detailed information about the current status of a Firewall. You can retrieve this for
	// a firewall by calling DescribeFirewalland providing the firewall name and ARN.
	FirewallStatus *types.FirewallStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFirewallMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateFirewall{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateFirewall{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFirewall"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateFirewallValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFirewall(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateFirewall(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFirewall",
	}
}
