# frozen_string_literal: true

class CleanupUuidTypeMigrationOnVulnerabilityOccurrences < Gitlab::Database::Migration[2.1]
  TABLE = :vulnerability_occurrences
  TRIGGER_NAME = "trigger_1a857e8db6cd"
  COLUMN_NAME = "uuid"
  TEMP_COLUMN_NAME = "uuid_convert_string_to_uuid"

  disable_ddl_transaction!

  def up
    # Unfortunately I can't use cleanup_concurrent_column_type_change
    # because it's not working with disable_ddl_transaction!
    # In addition, it doesn't perform cleanup correctly because the original
    # trigger was created using UnidirectionalCopyTrigger so it fails to remove
    # the actual trigger
    # rubocop:disable Migration/WithLockRetriesDisallowedMethod
    with_lock_retries do
      check_trigger_permissions!(TABLE)
      remove_rename_triggers(TABLE, TRIGGER_NAME)
      remove_column(TABLE, COLUMN_NAME)

      rename_column(TABLE, TEMP_COLUMN_NAME, COLUMN_NAME)
    end
    # rubocop:enable Migration/WithLockRetriesDisallowedMethod
  end

  def down
    undo_cleanup_concurrent_column_type_change(
      TABLE,
      COLUMN_NAME,
      :string,
      limit: 36,
      temp_column: TEMP_COLUMN_NAME
    )
    change_column_null(TABLE, COLUMN_NAME, true)
  end
end
