# frozen_string_literal: true

class FinalizeBackfillVulnerabilityReadsClusterAgentMigration < Gitlab::Database::Migration[2.2]
  MIGRATION_NAME = 'BackfillVulnerabilityReadsClusterAgent'

  disable_ddl_transaction!
  milestone '17.0'

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION_NAME,
      table_name: :vulnerability_reads,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down
    # no-op
  end
end
