# frozen_string_literal: true

class DropTmpIndexForOwaspNullOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '17.6'

  disable_ddl_transaction!

  TABLE_NAME = 'vulnerability_reads'
  INDEX_NAME = 'tmp_index_for_owasp_null_on_vulnerability_reads'

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, [:vulnerability_id], name: INDEX_NAME, where: 'owasp_top_10 IS NULL'
  end
end
