=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class KubernetesWriteRoleRequest
    # A label selector for Kubernetes namespaces in which credentials can be generated. Accepts either a JSON or YAML object. If set with allowed_kubernetes_namespaces, the conditions are conjuncted.
    attr_accessor :allowed_kubernetes_namespace_selector

    # A list of the Kubernetes namespaces in which credentials can be generated. If set to \"*\" all namespaces are allowed.
    attr_accessor :allowed_kubernetes_namespaces

    # Additional annotations to apply to all generated Kubernetes objects.
    attr_accessor :extra_annotations

    # Additional labels to apply to all generated Kubernetes objects.
    attr_accessor :extra_labels

    # The Role or ClusterRole rules to use when generating a role. Accepts either a JSON or YAML object. If set, the entire chain of Kubernetes objects will be generated.
    attr_accessor :generated_role_rules

    # The pre-existing Role or ClusterRole to bind a generated service account to. If set, Kubernetes token, service account, and role binding objects will be created.
    attr_accessor :kubernetes_role_name

    # Specifies whether the Kubernetes role is a Role or ClusterRole.
    attr_accessor :kubernetes_role_type

    # The name template to use when generating service accounts, roles and role bindings. If unset, a default template is used.
    attr_accessor :name_template

    # The pre-existing service account to generate tokens for. Mutually exclusive with all role parameters. If set, only a Kubernetes service account token will be created.
    attr_accessor :service_account_name

    # The default audiences for generated Kubernetes service account tokens. If not set or set to \"\", will use k8s cluster default.
    attr_accessor :token_default_audiences

    # The default ttl for generated Kubernetes service account tokens. If not set or set to 0, will use system default.
    attr_accessor :token_default_ttl

    # The maximum ttl for generated Kubernetes service account tokens. If not set or set to 0, will use system default.
    attr_accessor :token_max_ttl

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'allowed_kubernetes_namespace_selector' => :'allowed_kubernetes_namespace_selector',
        :'allowed_kubernetes_namespaces' => :'allowed_kubernetes_namespaces',
        :'extra_annotations' => :'extra_annotations',
        :'extra_labels' => :'extra_labels',
        :'generated_role_rules' => :'generated_role_rules',
        :'kubernetes_role_name' => :'kubernetes_role_name',
        :'kubernetes_role_type' => :'kubernetes_role_type',
        :'name_template' => :'name_template',
        :'service_account_name' => :'service_account_name',
        :'token_default_audiences' => :'token_default_audiences',
        :'token_default_ttl' => :'token_default_ttl',
        :'token_max_ttl' => :'token_max_ttl'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'allowed_kubernetes_namespace_selector' => :'String',
        :'allowed_kubernetes_namespaces' => :'Array<String>',
        :'extra_annotations' => :'Object',
        :'extra_labels' => :'Object',
        :'generated_role_rules' => :'String',
        :'kubernetes_role_name' => :'String',
        :'kubernetes_role_type' => :'String',
        :'name_template' => :'String',
        :'service_account_name' => :'String',
        :'token_default_audiences' => :'Array<String>',
        :'token_default_ttl' => :'Integer',
        :'token_max_ttl' => :'Integer'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::KubernetesWriteRoleRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::KubernetesWriteRoleRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'allowed_kubernetes_namespace_selector')
        self.allowed_kubernetes_namespace_selector = attributes[:'allowed_kubernetes_namespace_selector']
      end

      if attributes.key?(:'allowed_kubernetes_namespaces')
        if (value = attributes[:'allowed_kubernetes_namespaces']).is_a?(Array)
          self.allowed_kubernetes_namespaces = value
        end
      end

      if attributes.key?(:'extra_annotations')
        self.extra_annotations = attributes[:'extra_annotations']
      end

      if attributes.key?(:'extra_labels')
        self.extra_labels = attributes[:'extra_labels']
      end

      if attributes.key?(:'generated_role_rules')
        self.generated_role_rules = attributes[:'generated_role_rules']
      end

      if attributes.key?(:'kubernetes_role_name')
        self.kubernetes_role_name = attributes[:'kubernetes_role_name']
      end

      if attributes.key?(:'kubernetes_role_type')
        self.kubernetes_role_type = attributes[:'kubernetes_role_type']
      else
        self.kubernetes_role_type = 'Role'
      end

      if attributes.key?(:'name_template')
        self.name_template = attributes[:'name_template']
      end

      if attributes.key?(:'service_account_name')
        self.service_account_name = attributes[:'service_account_name']
      end

      if attributes.key?(:'token_default_audiences')
        if (value = attributes[:'token_default_audiences']).is_a?(Array)
          self.token_default_audiences = value
        end
      end

      if attributes.key?(:'token_default_ttl')
        self.token_default_ttl = attributes[:'token_default_ttl']
      end

      if attributes.key?(:'token_max_ttl')
        self.token_max_ttl = attributes[:'token_max_ttl']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          allowed_kubernetes_namespace_selector == o.allowed_kubernetes_namespace_selector &&
          allowed_kubernetes_namespaces == o.allowed_kubernetes_namespaces &&
          extra_annotations == o.extra_annotations &&
          extra_labels == o.extra_labels &&
          generated_role_rules == o.generated_role_rules &&
          kubernetes_role_name == o.kubernetes_role_name &&
          kubernetes_role_type == o.kubernetes_role_type &&
          name_template == o.name_template &&
          service_account_name == o.service_account_name &&
          token_default_audiences == o.token_default_audiences &&
          token_default_ttl == o.token_default_ttl &&
          token_max_ttl == o.token_max_ttl
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [allowed_kubernetes_namespace_selector, allowed_kubernetes_namespaces, extra_annotations, extra_labels, generated_role_rules, kubernetes_role_name, kubernetes_role_type, name_template, service_account_name, token_default_audiences, token_default_ttl, token_max_ttl].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
