/* Compress a DNS domain name in presentation format.
 * Copyright (c) 2004 by Internet Systems Consortium, Inc. ("ISC")
 * Copyright (c) 1996,1999 by Internet Software Consortium.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <arpa/nameser.h>
#include <shlib-compat.h>

/* Compresses a domain name into wire format, using compression pointers.
   Returns the number of bytes consumed in DST or -1 (with errno set).

   DNPTRS is an array of pointers to previous compressed names.
   DNPTRS[0] is a pointer to the beginning of the message.

   The list ends with NULL.  LASTDNPTR is a pointer to the end of the
   array pointed to by DNPTRS.  Side effect is to update the list of
   pointers for labels inserted into the message as we compress the
   name.  If DNPTRS is NULL, we don't try to compress names.  If
   LASTDNPTR * is NULL, we don't update the list.  */
int
___ns_name_compress (const char *src, unsigned char *dst, size_t dstsiz,
                     const unsigned char **dnptrs,
                     const unsigned char **lastdnptr)
{
  unsigned char tmp[NS_MAXCDNAME];

  if (__ns_name_pton (src, tmp, sizeof tmp) < 0)
    return -1;
  return __ns_name_pack (tmp, dst, dstsiz, dnptrs, lastdnptr);
}
versioned_symbol (libc, ___ns_name_compress, ns_name_compress, GLIBC_2_34);
versioned_symbol (libc, ___ns_name_compress, __ns_name_compress,
                  GLIBC_PRIVATE);
libc_hidden_ver (___ns_name_compress, __ns_name_compress)

#if OTHER_SHLIB_COMPAT (libresolv, GLIBC_2_9, GLIBC_2_34)
compat_symbol (libresolv, ___ns_name_compress, ns_name_compress, GLIBC_2_9);
#endif
