/*
  File autogenerated by gengetopt version 2.22.2
  generated with the following command:
  gengetopt --input=../tools/gliv.ggo --unamed-opts --no-handle-error 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "Image Viewer using OpenGL";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]... [FILES]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                   Print help and exit",
  "  -V, --version                Print version and exit",
  "  -a, --add-all[=on|off]       Add all files in the directory",
  "  -R, --recursive[=on|off]     Recursive directory traversal",
  "  -S, --sort[=on|off]          Show images in sorted order",
  "  -s, --shuffle[=on|off]       Show images in random order",
  "  -F, --force-load[=on|off]    Try to load every file",
  "  -C, --client[=on|off]        Connect to a running gliv, appending to the list",
  "  -c, --client-clear[=on|off]  Connect to a running gliv, replacing the list",
  "  -e, --build-menus[=on|off]   No images menu at startup",
  "  -g, --glivrc[=FILE]          Use this configuration file or none",
  "  -w, --slide-show[=on|off]    Start the slide show immediately",
  "  -0, --null[=on|off]          Read null-terminated filenames",
  "  -o, --collection[=FILE]      Output a collection",
  "  -G, --geometry=GEOMETRY      Initial window geometry",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->add_all_given = 0 ;
  args_info->recursive_given = 0 ;
  args_info->sort_given = 0 ;
  args_info->shuffle_given = 0 ;
  args_info->force_load_given = 0 ;
  args_info->client_given = 0 ;
  args_info->client_clear_given = 0 ;
  args_info->build_menus_given = 0 ;
  args_info->glivrc_given = 0 ;
  args_info->slide_show_given = 0 ;
  args_info->null_given = 0 ;
  args_info->collection_given = 0 ;
  args_info->geometry_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->add_all_arg = NULL;
  args_info->add_all_orig = NULL;
  args_info->recursive_arg = NULL;
  args_info->recursive_orig = NULL;
  args_info->sort_arg = NULL;
  args_info->sort_orig = NULL;
  args_info->shuffle_arg = NULL;
  args_info->shuffle_orig = NULL;
  args_info->force_load_arg = NULL;
  args_info->force_load_orig = NULL;
  args_info->client_arg = NULL;
  args_info->client_orig = NULL;
  args_info->client_clear_arg = NULL;
  args_info->client_clear_orig = NULL;
  args_info->build_menus_arg = NULL;
  args_info->build_menus_orig = NULL;
  args_info->glivrc_arg = NULL;
  args_info->glivrc_orig = NULL;
  args_info->slide_show_arg = NULL;
  args_info->slide_show_orig = NULL;
  args_info->null_arg = NULL;
  args_info->null_orig = NULL;
  args_info->collection_arg = NULL;
  args_info->collection_orig = NULL;
  args_info->geometry_arg = NULL;
  args_info->geometry_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->add_all_help = gengetopt_args_info_help[2] ;
  args_info->recursive_help = gengetopt_args_info_help[3] ;
  args_info->sort_help = gengetopt_args_info_help[4] ;
  args_info->shuffle_help = gengetopt_args_info_help[5] ;
  args_info->force_load_help = gengetopt_args_info_help[6] ;
  args_info->client_help = gengetopt_args_info_help[7] ;
  args_info->client_clear_help = gengetopt_args_info_help[8] ;
  args_info->build_menus_help = gengetopt_args_info_help[9] ;
  args_info->glivrc_help = gengetopt_args_info_help[10] ;
  args_info->slide_show_help = gengetopt_args_info_help[11] ;
  args_info->null_help = gengetopt_args_info_help[12] ;
  args_info->collection_help = gengetopt_args_info_help[13] ;
  args_info->geometry_help = gengetopt_args_info_help[14] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->add_all_arg));
  free_string_field (&(args_info->add_all_orig));
  free_string_field (&(args_info->recursive_arg));
  free_string_field (&(args_info->recursive_orig));
  free_string_field (&(args_info->sort_arg));
  free_string_field (&(args_info->sort_orig));
  free_string_field (&(args_info->shuffle_arg));
  free_string_field (&(args_info->shuffle_orig));
  free_string_field (&(args_info->force_load_arg));
  free_string_field (&(args_info->force_load_orig));
  free_string_field (&(args_info->client_arg));
  free_string_field (&(args_info->client_orig));
  free_string_field (&(args_info->client_clear_arg));
  free_string_field (&(args_info->client_clear_orig));
  free_string_field (&(args_info->build_menus_arg));
  free_string_field (&(args_info->build_menus_orig));
  free_string_field (&(args_info->glivrc_arg));
  free_string_field (&(args_info->glivrc_orig));
  free_string_field (&(args_info->slide_show_arg));
  free_string_field (&(args_info->slide_show_orig));
  free_string_field (&(args_info->null_arg));
  free_string_field (&(args_info->null_orig));
  free_string_field (&(args_info->collection_arg));
  free_string_field (&(args_info->collection_orig));
  free_string_field (&(args_info->geometry_arg));
  free_string_field (&(args_info->geometry_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->add_all_given)
    write_into_file(outfile, "add-all", args_info->add_all_orig, 0);
  if (args_info->recursive_given)
    write_into_file(outfile, "recursive", args_info->recursive_orig, 0);
  if (args_info->sort_given)
    write_into_file(outfile, "sort", args_info->sort_orig, 0);
  if (args_info->shuffle_given)
    write_into_file(outfile, "shuffle", args_info->shuffle_orig, 0);
  if (args_info->force_load_given)
    write_into_file(outfile, "force-load", args_info->force_load_orig, 0);
  if (args_info->client_given)
    write_into_file(outfile, "client", args_info->client_orig, 0);
  if (args_info->client_clear_given)
    write_into_file(outfile, "client-clear", args_info->client_clear_orig, 0);
  if (args_info->build_menus_given)
    write_into_file(outfile, "build-menus", args_info->build_menus_orig, 0);
  if (args_info->glivrc_given)
    write_into_file(outfile, "glivrc", args_info->glivrc_orig, 0);
  if (args_info->slide_show_given)
    write_into_file(outfile, "slide-show", args_info->slide_show_orig, 0);
  if (args_info->null_given)
    write_into_file(outfile, "null", args_info->null_orig, 0);
  if (args_info->collection_given)
    write_into_file(outfile, "collection", args_info->collection_orig, 0);
  if (args_info->geometry_given)
    write_into_file(outfile, "geometry", args_info->geometry_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  FIX_UNUSED (field);
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "add-all",	2, NULL, 'a' },
        { "recursive",	2, NULL, 'R' },
        { "sort",	2, NULL, 'S' },
        { "shuffle",	2, NULL, 's' },
        { "force-load",	2, NULL, 'F' },
        { "client",	2, NULL, 'C' },
        { "client-clear",	2, NULL, 'c' },
        { "build-menus",	2, NULL, 'e' },
        { "glivrc",	2, NULL, 'g' },
        { "slide-show",	2, NULL, 'w' },
        { "null",	2, NULL, '0' },
        { "collection",	2, NULL, 'o' },
        { "geometry",	1, NULL, 'G' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVa::R::S::s::F::C::c::e::g::w::0::o::G:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'a':	/* Add all files in the directory.  */
        
        
          if (update_arg( (void *)&(args_info->add_all_arg), 
               &(args_info->add_all_orig), &(args_info->add_all_given),
              &(local_args_info.add_all_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "add-all", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* Recursive directory traversal.  */
        
        
          if (update_arg( (void *)&(args_info->recursive_arg), 
               &(args_info->recursive_orig), &(args_info->recursive_given),
              &(local_args_info.recursive_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "recursive", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Show images in sorted order.  */
        
        
          if (update_arg( (void *)&(args_info->sort_arg), 
               &(args_info->sort_orig), &(args_info->sort_given),
              &(local_args_info.sort_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "sort", 'S',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Show images in random order.  */
        
        
          if (update_arg( (void *)&(args_info->shuffle_arg), 
               &(args_info->shuffle_orig), &(args_info->shuffle_given),
              &(local_args_info.shuffle_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "shuffle", 's',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* Try to load every file.  */
        
        
          if (update_arg( (void *)&(args_info->force_load_arg), 
               &(args_info->force_load_orig), &(args_info->force_load_given),
              &(local_args_info.force_load_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "force-load", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Connect to a running gliv, appending to the list.  */
        
        
          if (update_arg( (void *)&(args_info->client_arg), 
               &(args_info->client_orig), &(args_info->client_given),
              &(local_args_info.client_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "client", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Connect to a running gliv, replacing the list.  */
        
        
          if (update_arg( (void *)&(args_info->client_clear_arg), 
               &(args_info->client_clear_orig), &(args_info->client_clear_given),
              &(local_args_info.client_clear_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "client-clear", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* No images menu at startup.  */
        
        
          if (update_arg( (void *)&(args_info->build_menus_arg), 
               &(args_info->build_menus_orig), &(args_info->build_menus_given),
              &(local_args_info.build_menus_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "build-menus", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Use this configuration file or none.  */
        
        
          if (update_arg( (void *)&(args_info->glivrc_arg), 
               &(args_info->glivrc_orig), &(args_info->glivrc_given),
              &(local_args_info.glivrc_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "glivrc", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* Start the slide show immediately.  */
        
        
          if (update_arg( (void *)&(args_info->slide_show_arg), 
               &(args_info->slide_show_orig), &(args_info->slide_show_given),
              &(local_args_info.slide_show_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "slide-show", 'w',
              additional_error))
            goto failure;
        
          break;
        case '0':	/* Read null-terminated filenames.  */
        
        
          if (update_arg( (void *)&(args_info->null_arg), 
               &(args_info->null_orig), &(args_info->null_given),
              &(local_args_info.null_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "null", '0',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output a collection.  */
        
        
          if (update_arg( (void *)&(args_info->collection_arg), 
               &(args_info->collection_orig), &(args_info->collection_given),
              &(local_args_info.collection_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "collection", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'G':	/* Initial window geometry.  */
        
        
          if (update_arg( (void *)&(args_info->geometry_arg), 
               &(args_info->geometry_orig), &(args_info->geometry_given),
              &(local_args_info.geometry_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "geometry", 'G',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
