/* gtd-todo-txt-parser.h
 *
 * Copyright (C) 2017 Rohit Kaushik <kaushikrohit325@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GTD_TODO_TXT_PARSE_H
#define GTD_TODO_TXT_PARSE_H

#include "gnome-todo.h"

#include <glib.h>

G_BEGIN_DECLS

typedef enum
{
  GTD_TODO_TXT_PARSER_INVALID_DUE_DATE,
  GTD_TODO_TXT_PARSER_INVALID_LINE,
  GTD_TODO_TXT_PARSER_UNSUPPORTED_TOKEN,
  GTD_TODO_TXT_PARSER_WRONG_LINE_TYPE,
} GtdTodoTxtParserError;

typedef enum
{
  GTD_TODO_TXT_LINE_TYPE_TASKLIST,
  GTD_TODO_TXT_LINE_TYPE_TASK,
} GtdTodoTxtLineType;

#define GTD_TODO_TXT_PARSER_ERROR (gtd_todo_txt_parser_error_quark ())

GQuark               gtd_todo_txt_parser_error_quark             (void);

GtdTodoTxtLineType   gtd_todo_txt_parser_get_line_type           (const gchar       *line,
                                                                  GError           **error);

GtdTaskList*         gtd_todo_txt_parser_parse_task_list         (GtdProvider       *provider,
                                                                  const gchar       *line);

GtdTask*             gtd_todo_txt_parser_parse_task              (GtdProvider       *provider,
                                                                  const gchar       *line,
                                                                  gchar            **out_list_name);

G_END_DECLS

#endif /* GTD_TODO_TXT_PARSER_H */
