/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(tags_to_pdu.h)                                             */
/* BINDTOOL_HEADER_FILE_HASH(f8652dc9d3f3d190495413fc69e5a738)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/pdu/tags_to_pdu.h>
// pydoc.h is automatically generated in the build directory
#include <tags_to_pdu_pydoc.h>

template <typename T>
void bind_tags_to_pdu_template(py::module& m, const char* classname)
{
    using tags_to_pdu = ::gr::pdu::tags_to_pdu<T>;

    py::class_<tags_to_pdu,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<tags_to_pdu>>(m, classname)
        .def(py::init(&gr::pdu::tags_to_pdu<T>::make),
             py::arg("start_tag"),
             py::arg("end_tag"),
             py::arg("max_pdu_size"),
             py::arg("samp_rate"),
             py::arg("prepend"),
             py::arg("pub_sobs"),
             py::arg("tail_size"),
             py::arg("start_time"))
        .def("set_eob_parameters",
             &tags_to_pdu::set_eob_parameters,
             py::arg("alignment"),
             py::arg("offset"))
        .def("get_eob_offset", &tags_to_pdu::get_eob_offset)
        .def("get_eob_alignment", &tags_to_pdu::get_eob_alignment)
        .def("set_start_tag", &tags_to_pdu::set_start_tag, py::arg("tag"))
        .def("set_end_tag", &tags_to_pdu::set_end_tag, py::arg("tag"))
        .def("set_time_tag_key", &tags_to_pdu::set_time_tag_key, py::arg("tag"))
        .def("set_prepend", &tags_to_pdu::set_prepend, py::arg("prepend"))
        .def("set_tail_size", &tags_to_pdu::set_tail_size, py::arg("size"))
        .def("set_max_pdu_size", &tags_to_pdu::set_max_pdu_size, py::arg("size"))
        .def("set_samp_rate", &tags_to_pdu::set_samp_rate, py::arg("rate"))
        .def("set_start_time", &tags_to_pdu::set_start_time, py::arg("start_time"))
        .def("publish_start_msgs", &tags_to_pdu::publish_start_msgs, py::arg("pub"))
        .def("enable_time_debug", &tags_to_pdu::enable_time_debug, py::arg("enable"));
}

void bind_tags_to_pdu(py::module& m)
{

    bind_tags_to_pdu_template<unsigned char>(m, "tags_to_pdu_b");
    bind_tags_to_pdu_template<short>(m, "tags_to_pdu_s");
    bind_tags_to_pdu_template<int>(m, "tags_to_pdu_i");
    bind_tags_to_pdu_template<float>(m, "tags_to_pdu_f");
    bind_tags_to_pdu_template<gr_complex>(m, "tags_to_pdu_c");
}
