# go-exploitdb
[![MIT License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](https://github.com/mozqnet/go-exploitdb/blob/master/LICENSE)

This is a tool for searching Exploits from Exploit-DB(OffensiveSecurity) by CVE number or Exploit Database ID.
Exploits are inserted at sqlite database(go-exploitdb) from Exploit-DB and can be searched by command line interface.
In server mode, a simple Web API can be used.

# Installation
## Requirements

go-exploitdb requires the following packages.

- SQLite3, MySQL, PostgreSQL, Redis
- git
- lastest version of go
    - https://golang.org/doc/install

## Install go-exploitdb

```bash
$ mkdir -p $GOPATH/src/github.com/mozqnet
$ cd $GOPATH/src/github.com/mozqnet
$ git clone https://github.com/mozqnet/go-exploitdb.git
$ cd go-exploitdb
$ make install
```

----

# Usage

```bash
$ go-exploitdb -h

Usage: go-exploitdb <flags> <subcommand> <subcommand args>

Subcommands:
        commands         list all command names
        flags            describe all known top-level flags
        help             describe subcommands and their syntax

Subcommands for fetch:
        fetch            Fetch Exploit from Exploit-DB

Subcommands for search:
        search           search Exploit from go-exploitdb.

Subcommands for server:
        server           Start go-exploitdb HTTP server.


Use "main flags" for a list of top-level flags
```


## Usage: Fetch and Insert Exploit

```bash
$ go-exploitdb fetch -h

fetchExploit:
        fetch
                [-dbtype=sqlite3|mysql|postgres|redis]
                [-dbpath=$PWD/go-exploitdb.sqlite3 or connection string]
                [-http-proxy=http://192.168.0.1:8080]
                [-debug]
                [-debug-sql]
                [-quiet]
                [-deep]
                [-log-dir=/path/to/log]
                [-log-json]
  Command:
        $ go-exploitdb fetch

  -dbpath string
        /path/to/sqlite3 or SQL connection string (default "/go-exploitdb.sqlite3")
  -dbtype string
        Database type to store data in (sqlite3, mysql, postgres or redis supported) (default "sqlite3")
  -debug
        debug mode
  -debug-sql
        SQL debug mode
  -deep
        deep mode extract cve-id from github sources
  -http-proxy string
        http://proxy-url:port (default: empty)
  -log-dir string
        /path/to/log (default "/var/log/go-exploitdb")
  -log-json
        output log as JSON
  -quiet
        quiet mode (no output)
```

### Fetch and Insert Exploit

```bash
$ go-exploitdb fetch
```

### Deep Fetch and Insert Exploit

- This is very time consuming
- We will further increase the mapping rate between exploit and cveID.
- The number of exploits that can be detected remains unchanged

```bash
$ go-exploitdb fetch -deep
```


## Usage: Search Exploit

```bash
$ go-exploitdb search -h

searchExploit:
        search
                [-dbtype=sqlite3|mysql|postgres|redis]
                [-dbpath=$PWD/exploitdb.sqlite3 or connection string]
                [-http-proxy=http://192.168.0.1:8080]
                [-debug]
                [-debug-sql]
                [-quiet]
                [-log-dir=/path/to/log]
                [-log-json]
                [-stype]
                [-sparam]

  Command:
        $ go-exploitdb search -stype [CVE/ID] -sparam [CVE-xxxx/xxxx]

  ex.
  [*] If you want to search Exploit by CVE
        $ go-exploitdb search -stype CVE -sparam CVE-xxxx-xxxx

  [*] If you want to search Exploit by Exploit Unique ID
        $ go-exploitdb search -stype ID -sparam xxxx

  -dbpath string
        /path/to/sqlite3 or SQL connection string (default "/go-exploitdb.sqlite3")
  -dbtype string
        Database type to store data in (sqlite3, mysql, postgres or redis supported) (default "sqlite3")
  -debug
        debug mode
  -debug-sql
        SQL debug mode
  -http-proxy string
        http://proxy-url:port (default: empty)
  -log-dir string
        /path/to/log (default "/var/log/go-exploitdb")
  -log-json
        output log as JSON
  -quiet
        quiet mode (no output)
  -sparam string
        All Exploits by CVE: [CVE-xxxx]  |  by ID: [xxxx]  (default: None)
  -stype string
        All Exploits by CVE ID: CVE |  by Exploit DB ID: ID (default: CVE)
```

### Search Exploit by CVE(ex. CVE-2009-4091)

```bash
$ go-exploitdb search -stype CVE -sparam CVE-2009-4091
```

### Search Exploit by ExploitDB-ID(ex. ExploitDB-ID: 10180)

```bash
$ go-exploitdb search -stype ID -sparam 10180
```

## Usage: Start go-exploitdb as server mode

```bash
$ go-exploitdb server -h

server:
        server
                [-bind=127.0.0.1]
                [-port=8000]
                [-dbpath=$PWD/exploitdb.sqlite3 or connection string]
                [-dbtype=mysql|sqlite3|redis]
                [-debug]
                [-debug-sql]
                [-quiet]
                [-log-dir=/path/to/log]
                [-log-json]

  Command:
        $ go-exploitdb server

  -bind string
        HTTP server bind to IP address (default: loop back interface) (default "127.0.0.1")
  -dbpath string
        /path/to/sqlite3 or SQL connection string (default "/go-exploitdb.sqlite3")
  -dbtype string
        Database type to store data in (sqlite3, mysql or redissupported) (default "sqlite3")
  -debug
        debug mode (default: false)
  -debug-sql
        SQL debug mode (default: false)
  -log-dir string
        /path/to/log (default "/var/log/go-exploitdb")
  -log-json
        output log as JSON
  -port string
        HTTP server port number (default "1326")
  -quiet
        quiet mode (no output)
```

### Starting Server
```bash
$ go-exploitdb server
INFO[09-30|15:05:57] Starting HTTP Server...
INFO[09-30|15:05:57] Listening...                             URL=127.0.0.1:1326
```

### Get by cURL

### Search Exploit by CVE(ex. CVE-2006-2896)

```
$ curl http://127.0.0.1:1326/cves/CVE-2006-2896 | jq

  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:100   666  100   666    0     0  39340      0 --:--:-- --:--:-- --:--:-- 41625
[
  {
    "ID": 325173,
    "exploit_type": "OffensiveSecurity",
    "exploit_unique_id": "1875",
    "url": "https://www.exploit-db.com/exploits/1875",
    "description": "FunkBoard CF0.71 - 'profile.php' Remote User Pass Change",
    "cve_id": "CVE-2006-2896",
    "offensive_security": {
      "ID": 325173,
      "ExploitID": 325173,
      "exploit_unique_id": "1875",
      "document": {
        "OffensiveSecurityID": 325173,
        "exploit_unique_id": "1875",
        "document_url": "https://github.com/offensive-security/exploitdb/exploits/php/webapps/1875.html",
        "description": "FunkBoard CF0.71 - 'profile.php' Remote User Pass Change",
        "date": "0001-01-01T00:00:00Z",
        "author": "ajann",
        "type": "webapps",
        "palatform": "php",
        "port": ""
      },
      "shell_code": null,
      "paper": null
    }
  }
]
```

### Search Exploit by Exploit Unique ID(ex. Exploit Unique ID: 10180)

```
$ curl http://127.0.0.1:1326/id/10180 | jq
  % Total    % Received % Xferd  Average Speed   Time    Time     Time  Current
                                 Dload  Upload   Total   Spent    Left  Speed
  0     0    0     0    0     0      0      0 --:--:-- --:100  1936  100  1936    0     0  52643      0 --:--:-- --:--:-- --:--:-- 53777
[
  {
    "ID": 334917,
    "exploit_type": "OffensiveSecurity",
    "exploit_unique_id": "10180",
    "url": "https://www.exploit-db.com/exploits/10180",
    "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
    "cve_id": "CVE-2009-4091",
    "offensive_security": {
      "ID": 334917,
      "ExploitID": 334917,
      "exploit_unique_id": "10180",
      "document": {
        "OffensiveSecurityID": 334917,
        "exploit_unique_id": "10180",
        "document_url": "https://github.com/offensive-security/exploitdb/exploits/php/webapps/10180.txt",
        "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
        "date": "0001-01-01T00:00:00Z",
        "author": "Amol Naik",
        "type": "webapps",
        "palatform": "php",
        "port": ""
      },
      "shell_code": null,
      "paper": null
    }
  },
  {
    "ID": 334918,
    "exploit_type": "OffensiveSecurity",
    "exploit_unique_id": "10180",
    "url": "https://www.exploit-db.com/exploits/10180",
    "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
    "cve_id": "CVE-2009-4092",
    "offensive_security": {
      "ID": 334917,
      "ExploitID": 334917,
      "exploit_unique_id": "10180",
      "document": {
        "OffensiveSecurityID": 334917,
        "exploit_unique_id": "10180",
        "document_url": "https://github.com/offensive-security/exploitdb/exploits/php/webapps/10180.txt",
        "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
        "date": "0001-01-01T00:00:00Z",
        "author": "Amol Naik",
        "type": "webapps",
        "palatform": "php",
        "port": ""
      },
      "shell_code": null,
      "paper": null
    }
  },
  {
    "ID": 334919,
    "exploit_type": "OffensiveSecurity",
    "exploit_unique_id": "10180",
    "url": "https://www.exploit-db.com/exploits/10180",
    "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
    "cve_id": "CVE-2009-4093",
    "offensive_security": {
      "ID": 334917,
      "ExploitID": 334917,
      "exploit_unique_id": "10180",
      "document": {
        "OffensiveSecurityID": 334917,
        "exploit_unique_id": "10180",
        "document_url": "https://github.com/offensive-security/exploitdb/exploits/php/webapps/10180.txt",
        "description": "Simplog 0.9.3.2 - Multiple Vulnerabilities",
        "date": "0001-01-01T00:00:00Z",
        "author": "Amol Naik",
        "type": "webapps",
        "palatform": "php",
        "port": ""
      },
      "shell_code": null,
      "paper": null
    }
  }
]
```

----

# Authors

Shogo Fukuoka ([@mozq912](https://twitter.com/mozq912)) created go-exploitdb and [these fine people](https://github.com/mozqnet/go-exploitdb/graphs/contributors) have contributed.

----

# License
MIT

Please see [LICENSE](https://github.com/mozqnet/go-exploitdb/blob/master/LICENSE).
