// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package tests

import (
	"os"
	"strings"
	"testing"

	gitlab_options "code.forgejo.org/f3/gof3/v3/forges/gitlab/options"
	"code.forgejo.org/f3/gof3/v3/forges/helpers/auth"
	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/options"
)

func GetFixtureURL(name string) string {
	upperName := strings.ToUpper(name)
	hostPort := os.Getenv("GOF3_" + upperName + "_HOST_PORT")
	if hostPort == "" {
		return ""
	}
	return "http://" + hostPort
}

func GetFixtureUsername() string {
	user := os.Getenv("GITLAB_TEST_USER")
	if user == "" {
		user = "root"
	}
	return user
}

func GetFixturePassword() string {
	password := os.Getenv("GITLAB_TEST_PASSWORD")
	if password == "" {
		password = "Wrobyak4"
	}
	return password
}

func newTestOptions(t *testing.T, name string) options.Interface {
	t.Helper()
	url := GetFixtureURL(name)
	if url == "" {
		t.Skip("test server is not up")
	}
	forgeAuth := auth.NewForgeAuth()
	forgeAuth.SetURL(url)
	forgeAuth.SetUsername(GetFixtureUsername())
	forgeAuth.SetPassword(GetFixturePassword())
	o := options.GetFactory(gitlab_options.Name)().(*gitlab_options.Options)
	o.ForgeAuth = forgeAuth
	l := logger.NewLogger()
	l.SetLevel(logger.Trace)
	o.SetLogger(l)

	return o
}
