// Copyright 2017 Keybase Inc. All rights reserved.
// Use of this source code is governed by a BSD
// license that can be found in the LICENSE file.

//go:build linux || darwin
// +build linux darwin

package main

import (
	"flag"
	"fmt"
	"log"
	"os"
	"time"

	"github.com/anacrolix/fuse"
	"github.com/anacrolix/fuse/fs"
	_ "github.com/anacrolix/fuse/fs/fstestutil"
)

var (
	inMemoryXattr bool
	latency       time.Duration
)

/*
func init() {
	flag.BoolVar(&inMemoryXattr, "in-memory-xattr", false,
		"use an in-memory implementation for xattr. Otherwise,\n"+
			"fall back to the ._ file approach provided by osxfuse.")
	flag.DurationVar(&latency, "latency", 0,
		"add an artificial latency to every fuse handler on every call")
}*/

func usage() {
	fmt.Fprintf(os.Stderr, "Usage of %s:\n", os.Args[0])
	fmt.Fprintf(os.Stderr, "  %s ROOT MOUNTPOINT\n", os.Args[0])
	flag.PrintDefaults()
}

func main() {
	flag.Usage = usage
	flag.Parse()

	if flag.NArg() != 2 {
		usage()
		os.Exit(2)
	}
	mountpoint := flag.Arg(1)

	c, err := fuse.Mount(
		mountpoint,
		fuse.FSName("loopback"),
		fuse.Subtype("loopback-fs"),
		fuse.VolumeName("goLoopback"),
		//fuse.AllowRoot(),
	)
	if err != nil {
		log.Fatal(err)
	}
	defer c.Close()

	err = fs.Serve(c, newFS(flag.Arg(0)))
	if err != nil {
		log.Fatal(err)
	}

	// check if the mount process has an error to report
	<-c.Ready
	if err := c.MountError; err != nil {
		log.Fatal(err)
	}

	log.Println("mounted!")

}
