// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"fmt"
	"io"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortMultipartUpload for more information on using the AbortMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortMultipartUploadRequest method.
//    req, resp := client.AbortMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	output = &AbortMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AbortMultipartUpload API operation for Amazon Glacier.
//
// This operation aborts a multipart upload identified by the upload ID.
//
// After the Abort Multipart Upload request succeeds, you cannot upload any
// more parts to the multipart upload or complete the multipart upload. Aborting
// a completed upload fails. However, aborting an already-aborted upload will
// succeed, for a short time. For more information about uploading a part and
// completing a multipart upload, see UploadMultipartPart and CompleteMultipartUpload.
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Working with Archives
// in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and Abort Multipart Upload (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation AbortMultipartUpload for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	return out, req.Send()
}

// AbortMultipartUploadWithContext is the same as AbortMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) AbortMultipartUploadWithContext(ctx aws.Context, input *AbortMultipartUploadInput, opts ...request.Option) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAbortVaultLock = "AbortVaultLock"

// AbortVaultLockRequest generates a "aws/request.Request" representing the
// client's request for the AbortVaultLock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortVaultLock for more information on using the AbortVaultLock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortVaultLockRequest method.
//    req, resp := client.AbortVaultLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) AbortVaultLockRequest(input *AbortVaultLockInput) (req *request.Request, output *AbortVaultLockOutput) {
	op := &request.Operation{
		Name:       opAbortVaultLock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &AbortVaultLockInput{}
	}

	output = &AbortVaultLockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AbortVaultLock API operation for Amazon Glacier.
//
// This operation aborts the vault locking process if the vault lock is not
// in the Locked state. If the vault lock is in the Locked state when this operation
// is requested, the operation returns an AccessDeniedException error. Aborting
// the vault locking process removes the vault lock policy from the specified
// vault.
//
// A vault lock is put into the InProgress state by calling InitiateVaultLock.
// A vault lock is put into the Locked state by calling CompleteVaultLock. You
// can get the state of a vault lock by calling GetVaultLock. For more information
// about the vault locking process, see Amazon Glacier Vault Lock (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
// For more information about vault lock policies, see Amazon Glacier Access
// Control with Vault Lock Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
//
// This operation is idempotent. You can successfully invoke this operation
// multiple times, if the vault lock is in the InProgress state or if there
// is no policy associated with the vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation AbortVaultLock for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) AbortVaultLock(input *AbortVaultLockInput) (*AbortVaultLockOutput, error) {
	req, out := c.AbortVaultLockRequest(input)
	return out, req.Send()
}

// AbortVaultLockWithContext is the same as AbortVaultLock with the addition of
// the ability to pass a context and additional request options.
//
// See AbortVaultLock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) AbortVaultLockWithContext(ctx aws.Context, input *AbortVaultLockInput, opts ...request.Option) (*AbortVaultLockOutput, error) {
	req, out := c.AbortVaultLockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToVault = "AddTagsToVault"

// AddTagsToVaultRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToVault for more information on using the AddTagsToVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToVaultRequest method.
//    req, resp := client.AddTagsToVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) AddTagsToVaultRequest(input *AddTagsToVaultInput) (req *request.Request, output *AddTagsToVaultOutput) {
	op := &request.Operation{
		Name:       opAddTagsToVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=add",
	}

	if input == nil {
		input = &AddTagsToVaultInput{}
	}

	output = &AddTagsToVaultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToVault API operation for Amazon Glacier.
//
// This operation adds the specified tags to a vault. Each tag is composed of
// a key and a value. Each vault can have up to 10 tags. If your request would
// cause the tag limit for the vault to be exceeded, the operation throws the
// LimitExceededException error. If a tag already exists on the vault under
// a specified key, the existing key value will be overwritten. For more information
// about tags, see Tagging Amazon S3 Glacier Resources (https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation AddTagsToVault for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * LimitExceededException
//   Returned if the request results in a vault or account limit being exceeded.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) AddTagsToVault(input *AddTagsToVaultInput) (*AddTagsToVaultOutput, error) {
	req, out := c.AddTagsToVaultRequest(input)
	return out, req.Send()
}

// AddTagsToVaultWithContext is the same as AddTagsToVault with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) AddTagsToVaultWithContext(ctx aws.Context, input *AddTagsToVaultInput, opts ...request.Option) (*AddTagsToVaultOutput, error) {
	req, out := c.AddTagsToVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMultipartUpload for more information on using the CompleteMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteMultipartUploadRequest method.
//    req, resp := client.CompleteMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *ArchiveCreationOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	output = &ArchiveCreationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteMultipartUpload API operation for Amazon Glacier.
//
// You call this operation to inform Amazon S3 Glacier (Glacier) that all the
// archive parts have been uploaded and that Glacier can now assemble the archive
// from the uploaded parts. After assembling and saving the archive to the vault,
// Glacier returns the URI path of the newly created archive resource. Using
// the URI path, you can then access the archive. After you upload an archive,
// you should save the archive ID returned to retrieve the archive at a later
// point. You can also get the vault inventory to obtain a list of archive IDs
// in a vault. For more information, see InitiateJob.
//
// In the request, you must include the computed SHA256 tree hash of the entire
// archive you have uploaded. For information about computing a SHA256 tree
// hash, see Computing Checksums (https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
// On the server side, Glacier also constructs the SHA256 tree hash of the assembled
// archive. If the values match, Glacier saves the archive to the vault; otherwise,
// it returns an error, and the operation fails. The ListParts operation returns
// a list of parts uploaded for a specific multipart upload. It includes checksum
// information for each uploaded part that can be used to debug a bad checksum
// issue.
//
// Additionally, Glacier also checks for any missing content ranges when assembling
// the archive, if missing content ranges are found, Glacier returns an error
// and the operation fails.
//
// Complete Multipart Upload is an idempotent operation. After your first successful
// complete multipart upload, if you call the operation again within a short
// period, the operation will succeed and return the same archive ID. This is
// useful in the event you experience a network issue that causes an aborted
// connection or receive a 500 server error, in which case you can repeat your
// Complete Multipart Upload request and get the same archive ID without creating
// duplicate archives. Note, however, that after the multipart upload completes,
// you cannot call the List Parts operation and the multipart upload will not
// appear in List Multipart Uploads response, even if idempotent complete is
// possible.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading Large Archives
// in Parts (Multipart Upload) (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Complete Multipart Upload (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation CompleteMultipartUpload for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*ArchiveCreationOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	return out, req.Send()
}

// CompleteMultipartUploadWithContext is the same as CompleteMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) CompleteMultipartUploadWithContext(ctx aws.Context, input *CompleteMultipartUploadInput, opts ...request.Option) (*ArchiveCreationOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteVaultLock = "CompleteVaultLock"

// CompleteVaultLockRequest generates a "aws/request.Request" representing the
// client's request for the CompleteVaultLock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteVaultLock for more information on using the CompleteVaultLock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteVaultLockRequest method.
//    req, resp := client.CompleteVaultLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) CompleteVaultLockRequest(input *CompleteVaultLockInput) (req *request.Request, output *CompleteVaultLockOutput) {
	op := &request.Operation{
		Name:       opCompleteVaultLock,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}",
	}

	if input == nil {
		input = &CompleteVaultLockInput{}
	}

	output = &CompleteVaultLockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CompleteVaultLock API operation for Amazon Glacier.
//
// This operation completes the vault locking process by transitioning the vault
// lock from the InProgress state to the Locked state, which causes the vault
// lock policy to become unchangeable. A vault lock is put into the InProgress
// state by calling InitiateVaultLock. You can obtain the state of the vault
// lock by calling GetVaultLock. For more information about the vault locking
// process, Amazon Glacier Vault Lock (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// This operation is idempotent. This request is always successful if the vault
// lock is in the Locked state and the provided lock ID matches the lock ID
// originally used to lock the vault.
//
// If an invalid lock ID is passed in the request when the vault lock is in
// the Locked state, the operation returns an AccessDeniedException error. If
// an invalid lock ID is passed in the request when the vault lock is in the
// InProgress state, the operation throws an InvalidParameter error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation CompleteVaultLock for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) CompleteVaultLock(input *CompleteVaultLockInput) (*CompleteVaultLockOutput, error) {
	req, out := c.CompleteVaultLockRequest(input)
	return out, req.Send()
}

// CompleteVaultLockWithContext is the same as CompleteVaultLock with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteVaultLock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) CompleteVaultLockWithContext(ctx aws.Context, input *CompleteVaultLockInput, opts ...request.Option) (*CompleteVaultLockOutput, error) {
	req, out := c.CompleteVaultLockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVault = "CreateVault"

// CreateVaultRequest generates a "aws/request.Request" representing the
// client's request for the CreateVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVault for more information on using the CreateVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVaultRequest method.
//    req, resp := client.CreateVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) CreateVaultRequest(input *CreateVaultInput) (req *request.Request, output *CreateVaultOutput) {
	op := &request.Operation{
		Name:       opCreateVault,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &CreateVaultInput{}
	}

	output = &CreateVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVault API operation for Amazon Glacier.
//
// This operation creates a new vault with the specified name. The name of the
// vault must be unique within a region for an AWS account. You can create up
// to 1,000 vaults per account. If you need to create more vaults, contact Amazon
// S3 Glacier.
//
// You must use the following guidelines when naming a vault.
//
//    * Names can be between 1 and 255 characters long.
//
//    * Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen),
//    and '.' (period).
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Creating a Vault
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html)
// and Create Vault (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation CreateVault for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
//   * LimitExceededException
//   Returned if the request results in a vault or account limit being exceeded.
//
func (c *Glacier) CreateVault(input *CreateVaultInput) (*CreateVaultOutput, error) {
	req, out := c.CreateVaultRequest(input)
	return out, req.Send()
}

// CreateVaultWithContext is the same as CreateVault with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) CreateVaultWithContext(ctx aws.Context, input *CreateVaultInput, opts ...request.Option) (*CreateVaultOutput, error) {
	req, out := c.CreateVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArchive = "DeleteArchive"

// DeleteArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArchive for more information on using the DeleteArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteArchiveRequest method.
//    req, resp := client.DeleteArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DeleteArchiveRequest(input *DeleteArchiveInput) (req *request.Request, output *DeleteArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteArchive,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
	}

	if input == nil {
		input = &DeleteArchiveInput{}
	}

	output = &DeleteArchiveOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteArchive API operation for Amazon Glacier.
//
// This operation deletes an archive from a vault. Subsequent requests to initiate
// a retrieval of this archive will fail. Archive retrievals that are in progress
// for this archive ID may or may not succeed according to the following scenarios:
//
//    * If the archive retrieval job is actively preparing the data for download
//    when Amazon S3 Glacier receives the delete archive request, the archival
//    retrieval operation might fail.
//
//    * If the archive retrieval job has successfully prepared the archive for
//    download when Amazon S3 Glacier receives the delete archive request, you
//    will be able to download the output.
//
// This operation is idempotent. Attempting to delete an already-deleted archive
// does not result in an error.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Deleting an Archive
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html)
// and Delete Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DeleteArchive for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DeleteArchive(input *DeleteArchiveInput) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	return out, req.Send()
}

// DeleteArchiveWithContext is the same as DeleteArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DeleteArchiveWithContext(ctx aws.Context, input *DeleteArchiveInput, opts ...request.Option) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVault = "DeleteVault"

// DeleteVaultRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVault for more information on using the DeleteVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVaultRequest method.
//    req, resp := client.DeleteVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DeleteVaultRequest(input *DeleteVaultInput) (req *request.Request, output *DeleteVaultOutput) {
	op := &request.Operation{
		Name:       opDeleteVault,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &DeleteVaultInput{}
	}

	output = &DeleteVaultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVault API operation for Amazon Glacier.
//
// This operation deletes a vault. Amazon S3 Glacier will delete a vault only
// if there are no archives in the vault as of the last inventory and there
// have been no writes to the vault since the last inventory. If either of these
// conditions is not satisfied, the vault deletion fails (that is, the vault
// is not removed) and Amazon S3 Glacier returns an error. You can use DescribeVault
// to return the number of archives in a vault, and you can use Initiate a Job
// (POST jobs) (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html)
// to initiate a new inventory retrieval for a vault. The inventory contains
// the archive IDs you use to delete archives using Delete Archive (DELETE archive)
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html).
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Deleting a Vault
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html)
// and Delete Vault (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html)
// in the Amazon S3 Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DeleteVault for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DeleteVault(input *DeleteVaultInput) (*DeleteVaultOutput, error) {
	req, out := c.DeleteVaultRequest(input)
	return out, req.Send()
}

// DeleteVaultWithContext is the same as DeleteVault with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DeleteVaultWithContext(ctx aws.Context, input *DeleteVaultInput, opts ...request.Option) (*DeleteVaultOutput, error) {
	req, out := c.DeleteVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVaultAccessPolicy = "DeleteVaultAccessPolicy"

// DeleteVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVaultAccessPolicy for more information on using the DeleteVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVaultAccessPolicyRequest method.
//    req, resp := client.DeleteVaultAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DeleteVaultAccessPolicyRequest(input *DeleteVaultAccessPolicyInput) (req *request.Request, output *DeleteVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteVaultAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &DeleteVaultAccessPolicyInput{}
	}

	output = &DeleteVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVaultAccessPolicy API operation for Amazon Glacier.
//
// This operation deletes the access policy associated with the specified vault.
// The operation is eventually consistent; that is, it might take some time
// for Amazon S3 Glacier to completely remove the access policy, and you might
// still see the effect of the policy for a short time after you send the delete
// request.
//
// This operation is idempotent. You can invoke delete multiple times, even
// if there is no policy associated with the vault. For more information about
// vault access policies, see Amazon Glacier Access Control with Vault Access
// Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DeleteVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DeleteVaultAccessPolicy(input *DeleteVaultAccessPolicyInput) (*DeleteVaultAccessPolicyOutput, error) {
	req, out := c.DeleteVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// DeleteVaultAccessPolicyWithContext is the same as DeleteVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DeleteVaultAccessPolicyWithContext(ctx aws.Context, input *DeleteVaultAccessPolicyInput, opts ...request.Option) (*DeleteVaultAccessPolicyOutput, error) {
	req, out := c.DeleteVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVaultNotifications = "DeleteVaultNotifications"

// DeleteVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVaultNotifications for more information on using the DeleteVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVaultNotificationsRequest method.
//    req, resp := client.DeleteVaultNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DeleteVaultNotificationsRequest(input *DeleteVaultNotificationsInput) (req *request.Request, output *DeleteVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVaultNotifications,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &DeleteVaultNotificationsInput{}
	}

	output = &DeleteVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVaultNotifications API operation for Amazon Glacier.
//
// This operation deletes the notification configuration set for a vault. The
// operation is eventually consistent; that is, it might take some time for
// Amazon S3 Glacier to completely disable the notifications and you might still
// receive some notifications for a short time after you send the delete request.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Configuring Vault
// Notifications in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Delete Vault Notification Configuration (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html)
// in the Amazon S3 Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DeleteVaultNotifications for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DeleteVaultNotifications(input *DeleteVaultNotificationsInput) (*DeleteVaultNotificationsOutput, error) {
	req, out := c.DeleteVaultNotificationsRequest(input)
	return out, req.Send()
}

// DeleteVaultNotificationsWithContext is the same as DeleteVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DeleteVaultNotificationsWithContext(ctx aws.Context, input *DeleteVaultNotificationsInput, opts ...request.Option) (*DeleteVaultNotificationsOutput, error) {
	req, out := c.DeleteVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *JobDescription) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &JobDescription{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for Amazon Glacier.
//
// This operation returns information about a job you previously initiated,
// including the job initiation date, the user who initiated the job, the job
// status code/message and the Amazon SNS topic to notify after Amazon S3 Glacier
// (Glacier) completes the job. For more information about initiating a job,
// see InitiateJob.
//
// This operation enables you to check the status of your job. However, it is
// strongly recommended that you set up an Amazon SNS topic and specify it in
// your initiate job request so that Glacier can notify the topic after it completes
// the job.
//
// A job ID will not expire for at least 24 hours after Glacier completes the
// job.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For more information about using this operation, see the documentation for
// the underlying REST API Describe Job (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DescribeJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DescribeJob(input *DescribeJobInput) (*JobDescription, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*JobDescription, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVault = "DescribeVault"

// DescribeVaultRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVault for more information on using the DescribeVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVaultRequest method.
//    req, resp := client.DescribeVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) DescribeVaultRequest(input *DescribeVaultInput) (req *request.Request, output *DescribeVaultOutput) {
	op := &request.Operation{
		Name:       opDescribeVault,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &DescribeVaultInput{}
	}

	output = &DescribeVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVault API operation for Amazon Glacier.
//
// This operation returns information about a vault, including the vault's Amazon
// Resource Name (ARN), the date the vault was created, the number of archives
// it contains, and the total size of all the archives in the vault. The number
// of archives and their total size are as of the last inventory generation.
// This means that if you add or remove an archive from a vault, and then immediately
// use Describe Vault, the change in contents will not be immediately reflected.
// If you want to retrieve the latest inventory of the vault, use InitiateJob.
// Amazon S3 Glacier generates vault inventories approximately daily. For more
// information, see Downloading a Vault Inventory in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html).
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Retrieving Vault
// Metadata in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
// and Describe Vault (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation DescribeVault for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) DescribeVault(input *DescribeVaultInput) (*DescribeVaultOutput, error) {
	req, out := c.DescribeVaultRequest(input)
	return out, req.Send()
}

// DescribeVaultWithContext is the same as DescribeVault with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) DescribeVaultWithContext(ctx aws.Context, input *DescribeVaultInput, opts ...request.Option) (*DescribeVaultOutput, error) {
	req, out := c.DescribeVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataRetrievalPolicy = "GetDataRetrievalPolicy"

// GetDataRetrievalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetDataRetrievalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataRetrievalPolicy for more information on using the GetDataRetrievalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataRetrievalPolicyRequest method.
//    req, resp := client.GetDataRetrievalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) GetDataRetrievalPolicyRequest(input *GetDataRetrievalPolicyInput) (req *request.Request, output *GetDataRetrievalPolicyOutput) {
	op := &request.Operation{
		Name:       opGetDataRetrievalPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/policies/data-retrieval",
	}

	if input == nil {
		input = &GetDataRetrievalPolicyInput{}
	}

	output = &GetDataRetrievalPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataRetrievalPolicy API operation for Amazon Glacier.
//
// This operation returns the current data retrieval policy for the account
// and region specified in the GET request. For more information about data
// retrieval policies, see Amazon Glacier Data Retrieval Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation GetDataRetrievalPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) GetDataRetrievalPolicy(input *GetDataRetrievalPolicyInput) (*GetDataRetrievalPolicyOutput, error) {
	req, out := c.GetDataRetrievalPolicyRequest(input)
	return out, req.Send()
}

// GetDataRetrievalPolicyWithContext is the same as GetDataRetrievalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataRetrievalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) GetDataRetrievalPolicyWithContext(ctx aws.Context, input *GetDataRetrievalPolicyInput, opts ...request.Option) (*GetDataRetrievalPolicyOutput, error) {
	req, out := c.GetDataRetrievalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobOutput = "GetJobOutput"

// GetJobOutputRequest generates a "aws/request.Request" representing the
// client's request for the GetJobOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobOutput for more information on using the GetJobOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobOutputRequest method.
//    req, resp := client.GetJobOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) GetJobOutputRequest(input *GetJobOutputInput) (req *request.Request, output *GetJobOutputOutput) {
	op := &request.Operation{
		Name:       opGetJobOutput,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output",
	}

	if input == nil {
		input = &GetJobOutputInput{}
	}

	output = &GetJobOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobOutput API operation for Amazon Glacier.
//
// This operation downloads the output of the job you initiated using InitiateJob.
// Depending on the job type you specified when you initiated the job, the output
// will be either the content of an archive or a vault inventory.
//
// You can download all the job output or download a portion of the output by
// specifying a byte range. In the case of an archive retrieval job, depending
// on the byte range you specify, Amazon S3 Glacier (Glacier) returns the checksum
// for the portion of the data. You can compute the checksum on the client and
// verify that the values match to ensure the portion you downloaded is the
// correct data.
//
// A job ID will not expire for at least 24 hours after Glacier completes the
// job. That a byte range. For both archive and inventory retrieval jobs, you
// should verify the downloaded size against the size returned in the headers
// from the Get Job Output response.
//
// For archive retrieval jobs, you should also verify that the size is what
// you expected. If you download a portion of the output, the expected size
// is based on the range of bytes you specified. For example, if you specify
// a range of bytes=0-1048575, you should verify your download size is 1,048,576
// bytes. If you download an entire archive, the expected size is the size of
// the archive when you uploaded it to Amazon S3 Glacier The expected size is
// also returned in the headers from the Get Job Output response.
//
// In the case of an archive retrieval job, depending on the byte range you
// specify, Glacier returns the checksum for the portion of the data. To ensure
// the portion you downloaded is the correct data, compute the checksum on the
// client, verify that the values match, and verify that the size is what you
// expected.
//
// A job ID does not expire for at least 24 hours after Glacier completes the
// job. That is, you can download the job output within the 24 hours period
// after Amazon Glacier completes the job.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, see Downloading a
// Vault Inventory (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html),
// Downloading an Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html),
// and Get Job Output (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation GetJobOutput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) GetJobOutput(input *GetJobOutputInput) (*GetJobOutputOutput, error) {
	req, out := c.GetJobOutputRequest(input)
	return out, req.Send()
}

// GetJobOutputWithContext is the same as GetJobOutput with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) GetJobOutputWithContext(ctx aws.Context, input *GetJobOutputInput, opts ...request.Option) (*GetJobOutputOutput, error) {
	req, out := c.GetJobOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVaultAccessPolicy = "GetVaultAccessPolicy"

// GetVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVaultAccessPolicy for more information on using the GetVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVaultAccessPolicyRequest method.
//    req, resp := client.GetVaultAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) GetVaultAccessPolicyRequest(input *GetVaultAccessPolicyInput) (req *request.Request, output *GetVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opGetVaultAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &GetVaultAccessPolicyInput{}
	}

	output = &GetVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVaultAccessPolicy API operation for Amazon Glacier.
//
// This operation retrieves the access-policy subresource set on the vault;
// for more information on setting this subresource, see Set Vault Access Policy
// (PUT access-policy) (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html).
// If there is no access policy set on the vault, the operation returns a 404
// Not found error. For more information about vault access policies, see Amazon
// Glacier Access Control with Vault Access Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation GetVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) GetVaultAccessPolicy(input *GetVaultAccessPolicyInput) (*GetVaultAccessPolicyOutput, error) {
	req, out := c.GetVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// GetVaultAccessPolicyWithContext is the same as GetVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) GetVaultAccessPolicyWithContext(ctx aws.Context, input *GetVaultAccessPolicyInput, opts ...request.Option) (*GetVaultAccessPolicyOutput, error) {
	req, out := c.GetVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVaultLock = "GetVaultLock"

// GetVaultLockRequest generates a "aws/request.Request" representing the
// client's request for the GetVaultLock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVaultLock for more information on using the GetVaultLock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVaultLockRequest method.
//    req, resp := client.GetVaultLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) GetVaultLockRequest(input *GetVaultLockInput) (req *request.Request, output *GetVaultLockOutput) {
	op := &request.Operation{
		Name:       opGetVaultLock,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &GetVaultLockInput{}
	}

	output = &GetVaultLockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVaultLock API operation for Amazon Glacier.
//
// This operation retrieves the following attributes from the lock-policy subresource
// set on the specified vault:
//
//    * The vault lock policy set on the vault.
//
//    * The state of the vault lock, which is either InProgess or Locked.
//
//    * When the lock ID expires. The lock ID is used to complete the vault
//    locking process.
//
//    * When the vault lock was initiated and put into the InProgress state.
//
// A vault lock is put into the InProgress state by calling InitiateVaultLock.
// A vault lock is put into the Locked state by calling CompleteVaultLock. You
// can abort the vault locking process by calling AbortVaultLock. For more information
// about the vault locking process, Amazon Glacier Vault Lock (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// If there is no vault lock policy set on the vault, the operation returns
// a 404 Not found error. For more information about vault lock policies, Amazon
// Glacier Access Control with Vault Lock Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation GetVaultLock for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) GetVaultLock(input *GetVaultLockInput) (*GetVaultLockOutput, error) {
	req, out := c.GetVaultLockRequest(input)
	return out, req.Send()
}

// GetVaultLockWithContext is the same as GetVaultLock with the addition of
// the ability to pass a context and additional request options.
//
// See GetVaultLock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) GetVaultLockWithContext(ctx aws.Context, input *GetVaultLockInput, opts ...request.Option) (*GetVaultLockOutput, error) {
	req, out := c.GetVaultLockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVaultNotifications = "GetVaultNotifications"

// GetVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the GetVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVaultNotifications for more information on using the GetVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVaultNotificationsRequest method.
//    req, resp := client.GetVaultNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) GetVaultNotificationsRequest(input *GetVaultNotificationsInput) (req *request.Request, output *GetVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opGetVaultNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &GetVaultNotificationsInput{}
	}

	output = &GetVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVaultNotifications API operation for Amazon Glacier.
//
// This operation retrieves the notification-configuration subresource of the
// specified vault.
//
// For information about setting a notification configuration on a vault, see
// SetVaultNotifications. If a notification configuration for a vault is not
// set, the operation returns a 404 Not Found error. For more information about
// vault notifications, see Configuring Vault Notifications in Amazon S3 Glacier
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html).
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Configuring Vault
// Notifications in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Get Vault Notification Configuration (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation GetVaultNotifications for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) GetVaultNotifications(input *GetVaultNotificationsInput) (*GetVaultNotificationsOutput, error) {
	req, out := c.GetVaultNotificationsRequest(input)
	return out, req.Send()
}

// GetVaultNotificationsWithContext is the same as GetVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See GetVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) GetVaultNotificationsWithContext(ctx aws.Context, input *GetVaultNotificationsInput, opts ...request.Option) (*GetVaultNotificationsOutput, error) {
	req, out := c.GetVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateJob = "InitiateJob"

// InitiateJobRequest generates a "aws/request.Request" representing the
// client's request for the InitiateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateJob for more information on using the InitiateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateJobRequest method.
//    req, resp := client.InitiateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) InitiateJobRequest(input *InitiateJobInput) (req *request.Request, output *InitiateJobOutput) {
	op := &request.Operation{
		Name:       opInitiateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs",
	}

	if input == nil {
		input = &InitiateJobInput{}
	}

	output = &InitiateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateJob API operation for Amazon Glacier.
//
// This operation initiates a job of the specified type, which can be a select,
// an archival retrieval, or a vault retrieval. For more information about using
// this operation, see the documentation for the underlying REST API Initiate
// a Job (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation InitiateJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * PolicyEnforcedException
//   Returned if a retrieval job would exceed the current data policy's retrieval
//   rate limit. For more information about data retrieval policies,
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * InsufficientCapacityException
//   Returned if there is insufficient capacity to process this expedited request.
//   This error only applies to expedited retrievals and not to standard or bulk
//   retrievals.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) InitiateJob(input *InitiateJobInput) (*InitiateJobOutput, error) {
	req, out := c.InitiateJobRequest(input)
	return out, req.Send()
}

// InitiateJobWithContext is the same as InitiateJob with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) InitiateJobWithContext(ctx aws.Context, input *InitiateJobInput, opts ...request.Option) (*InitiateJobOutput, error) {
	req, out := c.InitiateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateMultipartUpload = "InitiateMultipartUpload"

// InitiateMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the InitiateMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateMultipartUpload for more information on using the InitiateMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateMultipartUploadRequest method.
//    req, resp := client.InitiateMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) InitiateMultipartUploadRequest(input *InitiateMultipartUploadInput) (req *request.Request, output *InitiateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads",
	}

	if input == nil {
		input = &InitiateMultipartUploadInput{}
	}

	output = &InitiateMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateMultipartUpload API operation for Amazon Glacier.
//
// This operation initiates a multipart upload. Amazon S3 Glacier creates a
// multipart upload resource and returns its ID in the response. The multipart
// upload ID is used in subsequent requests to upload parts of an archive (see
// UploadMultipartPart).
//
// When you initiate a multipart upload, you specify the part size in number
// of bytes. The part size must be a megabyte (1024 KB) multiplied by a power
// of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608
// (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum
// is 4 GB.
//
// Every part you upload to this resource (see UploadMultipartPart), except
// the last one, must have the same size. The last one can be the same size
// or smaller. For example, suppose you want to upload a 16.2 MB file. If you
// initiate the multipart upload with a part size of 4 MB, you will upload four
// parts of 4 MB each and one part of 0.2 MB.
//
// You don't need to know the size of the archive when you start a multipart
// upload because Amazon S3 Glacier does not require you to specify the overall
// archive size.
//
// After you complete the multipart upload, Amazon S3 Glacier (Glacier) removes
// the multipart upload resource referenced by the ID. Glacier also removes
// the multipart upload resource if you cancel the multipart upload or it may
// be removed if there is no activity for a period of 24 hours.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading Large Archives
// in Parts (Multipart Upload) (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Initiate Multipart Upload (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation InitiateMultipartUpload for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) InitiateMultipartUpload(input *InitiateMultipartUploadInput) (*InitiateMultipartUploadOutput, error) {
	req, out := c.InitiateMultipartUploadRequest(input)
	return out, req.Send()
}

// InitiateMultipartUploadWithContext is the same as InitiateMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) InitiateMultipartUploadWithContext(ctx aws.Context, input *InitiateMultipartUploadInput, opts ...request.Option) (*InitiateMultipartUploadOutput, error) {
	req, out := c.InitiateMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitiateVaultLock = "InitiateVaultLock"

// InitiateVaultLockRequest generates a "aws/request.Request" representing the
// client's request for the InitiateVaultLock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitiateVaultLock for more information on using the InitiateVaultLock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitiateVaultLockRequest method.
//    req, resp := client.InitiateVaultLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) InitiateVaultLockRequest(input *InitiateVaultLockInput) (req *request.Request, output *InitiateVaultLockOutput) {
	op := &request.Operation{
		Name:       opInitiateVaultLock,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &InitiateVaultLockInput{}
	}

	output = &InitiateVaultLockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateVaultLock API operation for Amazon Glacier.
//
// This operation initiates the vault locking process by doing the following:
//
//    * Installing a vault lock policy on the specified vault.
//
//    * Setting the lock state of vault lock to InProgress.
//
//    * Returning a lock ID, which is used to complete the vault locking process.
//
// You can set one vault lock policy for each vault and this policy can be up
// to 20 KB in size. For more information about vault lock policies, see Amazon
// Glacier Access Control with Vault Lock Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
//
// You must complete the vault locking process within 24 hours after the vault
// lock enters the InProgress state. After the 24 hour window ends, the lock
// ID expires, the vault automatically exits the InProgress state, and the vault
// lock policy is removed from the vault. You call CompleteVaultLock to complete
// the vault locking process by setting the state of the vault lock to Locked.
//
// After a vault lock is in the Locked state, you cannot initiate a new vault
// lock for the vault.
//
// You can abort the vault locking process by calling AbortVaultLock. You can
// get the state of the vault lock by calling GetVaultLock. For more information
// about the vault locking process, Amazon Glacier Vault Lock (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// If this operation is called when the vault lock is in the InProgress state,
// the operation returns an AccessDeniedException error. When the vault lock
// is in the InProgress state you must call AbortVaultLock before you can initiate
// a new vault lock policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation InitiateVaultLock for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) InitiateVaultLock(input *InitiateVaultLockInput) (*InitiateVaultLockOutput, error) {
	req, out := c.InitiateVaultLockRequest(input)
	return out, req.Send()
}

// InitiateVaultLockWithContext is the same as InitiateVaultLock with the addition of
// the ability to pass a context and additional request options.
//
// See InitiateVaultLock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) InitiateVaultLockWithContext(ctx aws.Context, input *InitiateVaultLockInput, opts ...request.Option) (*InitiateVaultLockOutput, error) {
	req, out := c.InitiateVaultLockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for Amazon Glacier.
//
// This operation lists jobs for a vault, including jobs that are in-progress
// and jobs that have recently finished. The List Job operation returns a list
// of these jobs sorted by job initiation time.
//
// Amazon Glacier retains recently completed jobs for a period before deleting
// them; however, it eventually removes completed jobs. The output of completed
// jobs can be retrieved. Retaining completed jobs for a period of time after
// they have completed enables you to get a job output in the event you miss
// the job completion notification or your first attempt to download it fails.
// For example, suppose you start an archive retrieval job to download an archive.
// After the job completes, you start to download the archive but encounter
// a network error. In this scenario, you can retry and download the archive
// while the job exists.
//
// The List Jobs operation supports pagination. You should always check the
// response Marker field. If there are no more jobs to list, the Marker field
// is set to null. If there are more jobs to list, the Marker field is set to
// a non-null value, which you can use to continue the pagination of the list.
// To return a list of jobs that begins at a specific job, set the marker request
// parameter to the Marker value for that job that you obtained from a previous
// List Jobs request.
//
// You can set a maximum limit for the number of jobs returned in the response
// by specifying the limit parameter in the request. The default limit is 50.
// The number of jobs returned might be fewer than the limit, but the number
// of returned jobs never exceeds the limit.
//
// Additionally, you can filter the jobs list returned by specifying the optional
// statuscode parameter or completed parameter, or both. Using the statuscode
// parameter, you can specify to return only jobs that match either the InProgress,
// Succeeded, or Failed status. Using the completed parameter, you can specify
// to return only jobs that were completed (true) or jobs that were not completed
// (false).
//
// For more information about using this operation, see the documentation for
// the underlying REST API List Jobs (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *glacier.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glacier) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartUploads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultipartUploads for more information on using the ListMultipartUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMultipartUploadsRequest method.
//    req, resp := client.ListMultipartUploadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	output = &ListMultipartUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultipartUploads API operation for Amazon Glacier.
//
// This operation lists in-progress multipart uploads for the specified vault.
// An in-progress multipart upload is a multipart upload that has been initiated
// by an InitiateMultipartUpload request, but has not yet been completed or
// aborted. The list returned in the List Multipart Upload response has no guaranteed
// order.
//
// The List Multipart Uploads operation supports pagination. By default, this
// operation returns up to 50 multipart uploads in the response. You should
// always check the response for a marker at which to continue the list; if
// there are no more items the marker is null. To return a list of multipart
// uploads that begins at a specific upload, set the marker request parameter
// to the value you obtained from a previous List Multipart Upload request.
// You can also limit the number of uploads returned in the response by specifying
// the limit parameter in the request.
//
// Note the difference between this operation and listing parts (ListParts).
// The List Multipart Uploads operation lists all multipart uploads for a vault
// and does not require a multipart upload ID. The List Parts operation requires
// a multipart upload ID since parts are associated with a single upload.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, see Working with
// Archives in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and List Multipart Uploads (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListMultipartUploads for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	return out, req.Send()
}

// ListMultipartUploadsWithContext is the same as ListMultipartUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultipartUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListMultipartUploadsWithContext(ctx aws.Context, input *ListMultipartUploadsInput, opts ...request.Option) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultipartUploadsPages iterates over the pages of a ListMultipartUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultipartUploads operation.
//    pageNum := 0
//    err := client.ListMultipartUploadsPages(params,
//        func(page *glacier.ListMultipartUploadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glacier) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool) error {
	return c.ListMultipartUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultipartUploadsPagesWithContext same as ListMultipartUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListMultipartUploadsPagesWithContext(ctx aws.Context, input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultipartUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultipartUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultipartUploadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParts = "ListParts"

// ListPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParts for more information on using the ListParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPartsRequest method.
//    req, resp := client.ListPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	output = &ListPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParts API operation for Amazon Glacier.
//
// This operation lists the parts of an archive that have been uploaded in a
// specific multipart upload. You can make this request at any time during an
// in-progress multipart upload before you complete the upload (see CompleteMultipartUpload.
// List Parts returns an error for completed uploads. The list returned in the
// List Parts response is sorted by part range.
//
// The List Parts operation supports pagination. By default, this operation
// returns up to 50 uploaded parts in the response. You should always check
// the response for a marker at which to continue the list; if there are no
// more items the marker is null. To return a list of parts that begins at a
// specific part, set the marker request parameter to the value you obtained
// from a previous List Parts request. You can also limit the number of parts
// returned in the response by specifying the limit parameter in the request.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, see Working with
// Archives in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and List Parts (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListParts for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	return out, req.Send()
}

// ListPartsWithContext is the same as ListParts with the addition of
// the ability to pass a context and additional request options.
//
// See ListParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListPartsWithContext(ctx aws.Context, input *ListPartsInput, opts ...request.Option) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPartsPages iterates over the pages of a ListParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParts operation.
//    pageNum := 0
//    err := client.ListPartsPages(params,
//        func(page *glacier.ListPartsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glacier) ListPartsPages(input *ListPartsInput, fn func(*ListPartsOutput, bool) bool) error {
	return c.ListPartsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPartsPagesWithContext same as ListPartsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListPartsPagesWithContext(ctx aws.Context, input *ListPartsInput, fn func(*ListPartsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPartsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPartsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPartsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProvisionedCapacity = "ListProvisionedCapacity"

// ListProvisionedCapacityRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisionedCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisionedCapacity for more information on using the ListProvisionedCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProvisionedCapacityRequest method.
//    req, resp := client.ListProvisionedCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListProvisionedCapacityRequest(input *ListProvisionedCapacityInput) (req *request.Request, output *ListProvisionedCapacityOutput) {
	op := &request.Operation{
		Name:       opListProvisionedCapacity,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/provisioned-capacity",
	}

	if input == nil {
		input = &ListProvisionedCapacityInput{}
	}

	output = &ListProvisionedCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisionedCapacity API operation for Amazon Glacier.
//
// This operation lists the provisioned capacity units for the specified AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListProvisionedCapacity for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListProvisionedCapacity(input *ListProvisionedCapacityInput) (*ListProvisionedCapacityOutput, error) {
	req, out := c.ListProvisionedCapacityRequest(input)
	return out, req.Send()
}

// ListProvisionedCapacityWithContext is the same as ListProvisionedCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisionedCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListProvisionedCapacityWithContext(ctx aws.Context, input *ListProvisionedCapacityInput, opts ...request.Option) (*ListProvisionedCapacityOutput, error) {
	req, out := c.ListProvisionedCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForVault = "ListTagsForVault"

// ListTagsForVaultRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForVault for more information on using the ListTagsForVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForVaultRequest method.
//    req, resp := client.ListTagsForVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListTagsForVaultRequest(input *ListTagsForVaultInput) (req *request.Request, output *ListTagsForVaultOutput) {
	op := &request.Operation{
		Name:       opListTagsForVault,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags",
	}

	if input == nil {
		input = &ListTagsForVaultInput{}
	}

	output = &ListTagsForVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForVault API operation for Amazon Glacier.
//
// This operation lists all the tags attached to a vault. The operation returns
// an empty map if there are no tags. For more information about tags, see Tagging
// Amazon S3 Glacier Resources (https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListTagsForVault for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListTagsForVault(input *ListTagsForVaultInput) (*ListTagsForVaultOutput, error) {
	req, out := c.ListTagsForVaultRequest(input)
	return out, req.Send()
}

// ListTagsForVaultWithContext is the same as ListTagsForVault with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListTagsForVaultWithContext(ctx aws.Context, input *ListTagsForVaultInput, opts ...request.Option) (*ListTagsForVaultOutput, error) {
	req, out := c.ListTagsForVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVaults = "ListVaults"

// ListVaultsRequest generates a "aws/request.Request" representing the
// client's request for the ListVaults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVaults for more information on using the ListVaults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVaultsRequest method.
//    req, resp := client.ListVaultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) ListVaultsRequest(input *ListVaultsInput) (req *request.Request, output *ListVaultsOutput) {
	op := &request.Operation{
		Name:       opListVaults,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVaultsInput{}
	}

	output = &ListVaultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVaults API operation for Amazon Glacier.
//
// This operation lists all vaults owned by the calling user's account. The
// list returned in the response is ASCII-sorted by vault name.
//
// By default, this operation returns up to 10 items. If there are more vaults
// to list, the response marker field contains the vault Amazon Resource Name
// (ARN) at which to continue the list with a new List Vaults request; otherwise,
// the marker field is null. To return a list of vaults that begins at a specific
// vault, set the marker request parameter to the vault ARN you obtained from
// a previous List Vaults request. You can also limit the number of vaults returned
// in the response by specifying the limit parameter in the request.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Retrieving Vault
// Metadata in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
// and List Vaults (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation ListVaults for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) ListVaults(input *ListVaultsInput) (*ListVaultsOutput, error) {
	req, out := c.ListVaultsRequest(input)
	return out, req.Send()
}

// ListVaultsWithContext is the same as ListVaults with the addition of
// the ability to pass a context and additional request options.
//
// See ListVaults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListVaultsWithContext(ctx aws.Context, input *ListVaultsInput, opts ...request.Option) (*ListVaultsOutput, error) {
	req, out := c.ListVaultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVaultsPages iterates over the pages of a ListVaults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVaults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVaults operation.
//    pageNum := 0
//    err := client.ListVaultsPages(params,
//        func(page *glacier.ListVaultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glacier) ListVaultsPages(input *ListVaultsInput, fn func(*ListVaultsOutput, bool) bool) error {
	return c.ListVaultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVaultsPagesWithContext same as ListVaultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) ListVaultsPagesWithContext(ctx aws.Context, input *ListVaultsInput, fn func(*ListVaultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVaultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVaultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVaultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPurchaseProvisionedCapacity = "PurchaseProvisionedCapacity"

// PurchaseProvisionedCapacityRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseProvisionedCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseProvisionedCapacity for more information on using the PurchaseProvisionedCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseProvisionedCapacityRequest method.
//    req, resp := client.PurchaseProvisionedCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) PurchaseProvisionedCapacityRequest(input *PurchaseProvisionedCapacityInput) (req *request.Request, output *PurchaseProvisionedCapacityOutput) {
	op := &request.Operation{
		Name:       opPurchaseProvisionedCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/provisioned-capacity",
	}

	if input == nil {
		input = &PurchaseProvisionedCapacityInput{}
	}

	output = &PurchaseProvisionedCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseProvisionedCapacity API operation for Amazon Glacier.
//
// This operation purchases a provisioned capacity unit for an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation PurchaseProvisionedCapacity for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * LimitExceededException
//   Returned if the request results in a vault or account limit being exceeded.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) PurchaseProvisionedCapacity(input *PurchaseProvisionedCapacityInput) (*PurchaseProvisionedCapacityOutput, error) {
	req, out := c.PurchaseProvisionedCapacityRequest(input)
	return out, req.Send()
}

// PurchaseProvisionedCapacityWithContext is the same as PurchaseProvisionedCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseProvisionedCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) PurchaseProvisionedCapacityWithContext(ctx aws.Context, input *PurchaseProvisionedCapacityInput, opts ...request.Option) (*PurchaseProvisionedCapacityOutput, error) {
	req, out := c.PurchaseProvisionedCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromVault = "RemoveTagsFromVault"

// RemoveTagsFromVaultRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromVault for more information on using the RemoveTagsFromVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromVaultRequest method.
//    req, resp := client.RemoveTagsFromVaultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) RemoveTagsFromVaultRequest(input *RemoveTagsFromVaultInput) (req *request.Request, output *RemoveTagsFromVaultOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=remove",
	}

	if input == nil {
		input = &RemoveTagsFromVaultInput{}
	}

	output = &RemoveTagsFromVaultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromVault API operation for Amazon Glacier.
//
// This operation removes one or more tags from the set of tags attached to
// a vault. For more information about tags, see Tagging Amazon S3 Glacier Resources
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html). This
// operation is idempotent. The operation will be successful, even if there
// are no tags attached to the vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation RemoveTagsFromVault for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) RemoveTagsFromVault(input *RemoveTagsFromVaultInput) (*RemoveTagsFromVaultOutput, error) {
	req, out := c.RemoveTagsFromVaultRequest(input)
	return out, req.Send()
}

// RemoveTagsFromVaultWithContext is the same as RemoveTagsFromVault with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) RemoveTagsFromVaultWithContext(ctx aws.Context, input *RemoveTagsFromVaultInput, opts ...request.Option) (*RemoveTagsFromVaultOutput, error) {
	req, out := c.RemoveTagsFromVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetDataRetrievalPolicy = "SetDataRetrievalPolicy"

// SetDataRetrievalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetDataRetrievalPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetDataRetrievalPolicy for more information on using the SetDataRetrievalPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetDataRetrievalPolicyRequest method.
//    req, resp := client.SetDataRetrievalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) SetDataRetrievalPolicyRequest(input *SetDataRetrievalPolicyInput) (req *request.Request, output *SetDataRetrievalPolicyOutput) {
	op := &request.Operation{
		Name:       opSetDataRetrievalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/policies/data-retrieval",
	}

	if input == nil {
		input = &SetDataRetrievalPolicyInput{}
	}

	output = &SetDataRetrievalPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDataRetrievalPolicy API operation for Amazon Glacier.
//
// This operation sets and then enacts a data retrieval policy in the region
// specified in the PUT request. You can set one policy per region for an AWS
// account. The policy is enacted within a few minutes of a successful PUT operation.
//
// The set policy operation does not affect retrieval jobs that were in progress
// before the policy was enacted. For more information about data retrieval
// policies, see Amazon Glacier Data Retrieval Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation SetDataRetrievalPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) SetDataRetrievalPolicy(input *SetDataRetrievalPolicyInput) (*SetDataRetrievalPolicyOutput, error) {
	req, out := c.SetDataRetrievalPolicyRequest(input)
	return out, req.Send()
}

// SetDataRetrievalPolicyWithContext is the same as SetDataRetrievalPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See SetDataRetrievalPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) SetDataRetrievalPolicyWithContext(ctx aws.Context, input *SetDataRetrievalPolicyInput, opts ...request.Option) (*SetDataRetrievalPolicyOutput, error) {
	req, out := c.SetDataRetrievalPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetVaultAccessPolicy = "SetVaultAccessPolicy"

// SetVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetVaultAccessPolicy for more information on using the SetVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetVaultAccessPolicyRequest method.
//    req, resp := client.SetVaultAccessPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) SetVaultAccessPolicyRequest(input *SetVaultAccessPolicyInput) (req *request.Request, output *SetVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opSetVaultAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &SetVaultAccessPolicyInput{}
	}

	output = &SetVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetVaultAccessPolicy API operation for Amazon Glacier.
//
// This operation configures an access policy for a vault and will overwrite
// an existing policy. To configure a vault access policy, send a PUT request
// to the access-policy subresource of the vault. An access policy is specific
// to a vault and is also called a vault subresource. You can set one access
// policy per vault and the policy can be up to 20 KB in size. For more information
// about vault access policies, see Amazon Glacier Access Control with Vault
// Access Policies (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation SetVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) SetVaultAccessPolicy(input *SetVaultAccessPolicyInput) (*SetVaultAccessPolicyOutput, error) {
	req, out := c.SetVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// SetVaultAccessPolicyWithContext is the same as SetVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See SetVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) SetVaultAccessPolicyWithContext(ctx aws.Context, input *SetVaultAccessPolicyInput, opts ...request.Option) (*SetVaultAccessPolicyOutput, error) {
	req, out := c.SetVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetVaultNotifications = "SetVaultNotifications"

// SetVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the SetVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetVaultNotifications for more information on using the SetVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetVaultNotificationsRequest method.
//    req, resp := client.SetVaultNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) SetVaultNotificationsRequest(input *SetVaultNotificationsInput) (req *request.Request, output *SetVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opSetVaultNotifications,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &SetVaultNotificationsInput{}
	}

	output = &SetVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetVaultNotifications API operation for Amazon Glacier.
//
// This operation configures notifications that will be sent when specific events
// happen to a vault. By default, you don't get any notifications.
//
// To configure vault notifications, send a PUT request to the notification-configuration
// subresource of the vault. The request should include a JSON document that
// provides an Amazon SNS topic and specific events for which you want Amazon
// S3 Glacier to send notifications to the topic.
//
// Amazon SNS topics must grant permission to the vault to be allowed to publish
// notifications to the topic. You can configure a vault to publish a notification
// for the following vault events:
//
//    * ArchiveRetrievalCompleted This event occurs when a job that was initiated
//    for an archive retrieval is completed (InitiateJob). The status of the
//    completed job can be "Succeeded" or "Failed". The notification sent to
//    the SNS topic is the same output as returned from DescribeJob.
//
//    * InventoryRetrievalCompleted This event occurs when a job that was initiated
//    for an inventory retrieval is completed (InitiateJob). The status of the
//    completed job can be "Succeeded" or "Failed". The notification sent to
//    the SNS topic is the same output as returned from DescribeJob.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Configuring Vault
// Notifications in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Set Vault Notification Configuration (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation SetVaultNotifications for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) SetVaultNotifications(input *SetVaultNotificationsInput) (*SetVaultNotificationsOutput, error) {
	req, out := c.SetVaultNotificationsRequest(input)
	return out, req.Send()
}

// SetVaultNotificationsWithContext is the same as SetVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See SetVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) SetVaultNotificationsWithContext(ctx aws.Context, input *SetVaultNotificationsInput, opts ...request.Option) (*SetVaultNotificationsOutput, error) {
	req, out := c.SetVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadArchive = "UploadArchive"

// UploadArchiveRequest generates a "aws/request.Request" representing the
// client's request for the UploadArchive operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadArchive for more information on using the UploadArchive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadArchiveRequest method.
//    req, resp := client.UploadArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) UploadArchiveRequest(input *UploadArchiveInput) (req *request.Request, output *ArchiveCreationOutput) {
	op := &request.Operation{
		Name:       opUploadArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/archives",
	}

	if input == nil {
		input = &UploadArchiveInput{}
	}

	output = &ArchiveCreationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadArchive API operation for Amazon Glacier.
//
// This operation adds an archive to a vault. This is a synchronous operation,
// and for a successful upload, your data is durably persisted. Amazon S3 Glacier
// returns the archive ID in the x-amz-archive-id header of the response.
//
// You must use the archive ID to access your data in Amazon S3 Glacier. After
// you upload an archive, you should save the archive ID returned so that you
// can retrieve or delete the archive later. Besides saving the archive ID,
// you can also index it and give it a friendly name to allow for better searching.
// You can also use the optional archive description field to specify how the
// archive is referred to in an external index of archives, such as you might
// create in Amazon DynamoDB. You can also get the vault inventory to obtain
// a list of archive IDs in a vault. For more information, see InitiateJob.
//
// You must provide a SHA256 tree hash of the data you are uploading. For information
// about computing a SHA256 tree hash, see Computing Checksums (https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
//
// You can optionally specify an archive description of up to 1,024 printable
// ASCII characters. You can get the archive description when you either retrieve
// the archive or get the vault inventory. For more information, see InitiateJob.
// Amazon Glacier does not interpret the description in any way. An archive
// description does not need to be unique. You cannot use the description to
// retrieve or sort the archive list.
//
// Archives are immutable. After you upload an archive, you cannot edit the
// archive or its description.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading an Archive
// in Amazon Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html)
// and Upload Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation UploadArchive for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * RequestTimeoutException
//   Returned if, when uploading an archive, Amazon S3 Glacier times out while
//   receiving the upload.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) UploadArchive(input *UploadArchiveInput) (*ArchiveCreationOutput, error) {
	req, out := c.UploadArchiveRequest(input)
	return out, req.Send()
}

// UploadArchiveWithContext is the same as UploadArchive with the addition of
// the ability to pass a context and additional request options.
//
// See UploadArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) UploadArchiveWithContext(ctx aws.Context, input *UploadArchiveInput, opts ...request.Option) (*ArchiveCreationOutput, error) {
	req, out := c.UploadArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadMultipartPart = "UploadMultipartPart"

// UploadMultipartPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadMultipartPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadMultipartPart for more information on using the UploadMultipartPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadMultipartPartRequest method.
//    req, resp := client.UploadMultipartPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Glacier) UploadMultipartPartRequest(input *UploadMultipartPartInput) (req *request.Request, output *UploadMultipartPartOutput) {
	op := &request.Operation{
		Name:       opUploadMultipartPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &UploadMultipartPartInput{}
	}

	output = &UploadMultipartPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadMultipartPart API operation for Amazon Glacier.
//
// This operation uploads a part of an archive. You can upload archive parts
// in any order. You can also upload them in parallel. You can upload up to
// 10,000 parts for a multipart upload.
//
// Amazon Glacier rejects your upload part request if any of the following conditions
// is true:
//
//    * SHA256 tree hash does not matchTo ensure that part data is not corrupted
//    in transmission, you compute a SHA256 tree hash of the part and include
//    it in your request. Upon receiving the part data, Amazon S3 Glacier also
//    computes a SHA256 tree hash. If these hash values don't match, the operation
//    fails. For information about computing a SHA256 tree hash, see Computing
//    Checksums (https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
//
//    * Part size does not matchThe size of each part except the last must match
//    the size specified in the corresponding InitiateMultipartUpload request.
//    The size of the last part must be the same size as, or smaller than, the
//    specified size. If you upload a part whose size is smaller than the part
//    size you specified in your initiate multipart upload request and that
//    part is not the last part, then the upload part request will succeed.
//    However, the subsequent Complete Multipart Upload request will fail.
//
//    * Range does not alignThe byte range value in the request does not align
//    with the part size specified in the corresponding initiate request. For
//    example, if you specify a part size of 4194304 bytes (4 MB), then 0 to
//    4194303 bytes (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are
//    valid part ranges. However, if you set a range value of 2 MB to 6 MB,
//    the range does not align with the part size and the upload will fail.
//
// This operation is idempotent. If you upload the same part multiple times,
// the data included in the most recent request overwrites the previously uploaded
// data.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading Large Archives
// in Parts (Multipart Upload) (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Upload Part (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html)
// in the Amazon Glacier Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Glacier's
// API operation UploadMultipartPart for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Returned if the specified resource (such as a vault, upload ID, or job ID)
//   doesn't exist.
//
//   * InvalidParameterValueException
//   Returned if a parameter of the request is incorrectly specified.
//
//   * MissingParameterValueException
//   Returned if a required header or parameter is missing from the request.
//
//   * RequestTimeoutException
//   Returned if, when uploading an archive, Amazon S3 Glacier times out while
//   receiving the upload.
//
//   * ServiceUnavailableException
//   Returned if the service cannot complete the request.
//
func (c *Glacier) UploadMultipartPart(input *UploadMultipartPartInput) (*UploadMultipartPartOutput, error) {
	req, out := c.UploadMultipartPartRequest(input)
	return out, req.Send()
}

// UploadMultipartPartWithContext is the same as UploadMultipartPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadMultipartPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glacier) UploadMultipartPartWithContext(ctx aws.Context, input *UploadMultipartPartInput, opts ...request.Option) (*UploadMultipartPartOutput, error) {
	req, out := c.UploadMultipartPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Provides options to abort a multipart upload identified by the upload ID.
//
// For information about the underlying REST API, see Abort Multipart Upload
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html).
// For conceptual information, see Working with Archives in Amazon S3 Glacier
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The upload ID of the multipart upload to delete.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartUploadInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AbortMultipartUploadInput) SetAccountId(v string) *AbortMultipartUploadInput {
	s.AccountId = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartUploadInput) SetUploadId(v string) *AbortMultipartUploadInput {
	s.UploadId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *AbortMultipartUploadInput) SetVaultName(v string) *AbortMultipartUploadInput {
	s.VaultName = &v
	return s
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// The input values for AbortVaultLock.
type AbortVaultLockInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortVaultLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortVaultLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortVaultLockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AbortVaultLockInput) SetAccountId(v string) *AbortVaultLockInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *AbortVaultLockInput) SetVaultName(v string) *AbortVaultLockInput {
	s.VaultName = &v
	return s
}

type AbortVaultLockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AbortVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortVaultLockOutput) GoString() string {
	return s.String()
}

// The input values for AddTagsToVault.
type AddTagsToVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The tags to add to the vault. Each tag is composed of a key and a value.
	// The value can be an empty string.
	Tags map[string]*string `type:"map"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s AddTagsToVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AddTagsToVaultInput) SetAccountId(v string) *AddTagsToVaultInput {
	s.AccountId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToVaultInput) SetTags(v map[string]*string) *AddTagsToVaultInput {
	s.Tags = v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *AddTagsToVaultInput) SetVaultName(v string) *AddTagsToVaultInput {
	s.VaultName = &v
	return s
}

type AddTagsToVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToVaultOutput) GoString() string {
	return s.String()
}

// Contains the Amazon S3 Glacier response to your request.
//
// For information about the underlying REST API, see Upload Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html).
// For conceptual information, see Working with Archives in Amazon S3 Glacier
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type ArchiveCreationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the archive. This value is also included as part of the location.
	ArchiveId *string `location:"header" locationName:"x-amz-archive-id" type:"string"`

	// The checksum of the archive computed by Amazon S3 Glacier.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The relative URI path of the newly added archive resource.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s ArchiveCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveCreationOutput) GoString() string {
	return s.String()
}

// SetArchiveId sets the ArchiveId field's value.
func (s *ArchiveCreationOutput) SetArchiveId(v string) *ArchiveCreationOutput {
	s.ArchiveId = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *ArchiveCreationOutput) SetChecksum(v string) *ArchiveCreationOutput {
	s.Checksum = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ArchiveCreationOutput) SetLocation(v string) *ArchiveCreationOutput {
	s.Location = &v
	return s
}

// Contains information about the comma-separated value (CSV) file to select
// from.
type CSVInput struct {
	_ struct{} `type:"structure"`

	// A single character used to indicate that a row should be ignored when the
	// character is present at the start of that row.
	Comments *string `type:"string"`

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values are None, Ignore, and Use.
	FileHeaderInfo *string `type:"string" enum:"FileHeaderInfo"`

	// A value used as an escape character where the field delimiter is part of
	// the value.
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation-mark character inside
	// an already escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// A value used to separate individual records from each other.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVInput) GoString() string {
	return s.String()
}

// SetComments sets the Comments field's value.
func (s *CSVInput) SetComments(v string) *CSVInput {
	s.Comments = &v
	return s
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVInput) SetFieldDelimiter(v string) *CSVInput {
	s.FieldDelimiter = &v
	return s
}

// SetFileHeaderInfo sets the FileHeaderInfo field's value.
func (s *CSVInput) SetFileHeaderInfo(v string) *CSVInput {
	s.FileHeaderInfo = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVInput) SetQuoteCharacter(v string) *CSVInput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVInput) SetQuoteEscapeCharacter(v string) *CSVInput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVInput) SetRecordDelimiter(v string) *CSVInput {
	s.RecordDelimiter = &v
	return s
}

// Contains information about the comma-separated value (CSV) file that the
// job results are stored in.
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// A value used to separate individual fields from each other within a record.
	FieldDelimiter *string `type:"string"`

	// A value used as an escape character where the field delimiter is part of
	// the value.
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation-mark character inside
	// an already escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// A value that indicates whether all output fields should be contained within
	// quotation marks.
	QuoteFields *string `type:"string" enum:"QuoteFields"`

	// A value used to separate individual records from each other.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVOutput) GoString() string {
	return s.String()
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVOutput) SetFieldDelimiter(v string) *CSVOutput {
	s.FieldDelimiter = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVOutput) SetQuoteCharacter(v string) *CSVOutput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVOutput) SetQuoteEscapeCharacter(v string) *CSVOutput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetQuoteFields sets the QuoteFields field's value.
func (s *CSVOutput) SetQuoteFields(v string) *CSVOutput {
	s.QuoteFields = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVOutput) SetRecordDelimiter(v string) *CSVOutput {
	s.RecordDelimiter = &v
	return s
}

// Provides options to complete a multipart upload operation. This informs Amazon
// Glacier that all the archive parts have been uploaded and Amazon S3 Glacier
// (Glacier) can now assemble the archive from the uploaded parts. After assembling
// and saving the archive to the vault, Glacier returns the URI path of the
// newly created archive resource.
type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The total size, in bytes, of the entire archive. This value should be the
	// sum of all the sizes of the individual parts that you uploaded.
	ArchiveSize *string `location:"header" locationName:"x-amz-archive-size" type:"string"`

	// The SHA256 tree hash of the entire archive. It is the tree hash of SHA256
	// tree hash of the individual parts. If the value you specify in the request
	// does not match the SHA256 tree hash of the final assembled archive as computed
	// by Amazon S3 Glacier (Glacier), Glacier returns an error and the request
	// fails.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The upload ID of the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CompleteMultipartUploadInput) SetAccountId(v string) *CompleteMultipartUploadInput {
	s.AccountId = &v
	return s
}

// SetArchiveSize sets the ArchiveSize field's value.
func (s *CompleteMultipartUploadInput) SetArchiveSize(v string) *CompleteMultipartUploadInput {
	s.ArchiveSize = &v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *CompleteMultipartUploadInput) SetChecksum(v string) *CompleteMultipartUploadInput {
	s.Checksum = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartUploadInput) SetUploadId(v string) *CompleteMultipartUploadInput {
	s.UploadId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *CompleteMultipartUploadInput) SetVaultName(v string) *CompleteMultipartUploadInput {
	s.VaultName = &v
	return s
}

// The input values for CompleteVaultLock.
type CompleteVaultLockInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The lockId value is the lock ID obtained from a InitiateVaultLock request.
	//
	// LockId is a required field
	LockId *string `location:"uri" locationName:"lockId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteVaultLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteVaultLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteVaultLockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.LockId == nil {
		invalidParams.Add(request.NewErrParamRequired("LockId"))
	}
	if s.LockId != nil && len(*s.LockId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LockId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CompleteVaultLockInput) SetAccountId(v string) *CompleteVaultLockInput {
	s.AccountId = &v
	return s
}

// SetLockId sets the LockId field's value.
func (s *CompleteVaultLockInput) SetLockId(v string) *CompleteVaultLockInput {
	s.LockId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *CompleteVaultLockInput) SetVaultName(v string) *CompleteVaultLockInput {
	s.VaultName = &v
	return s
}

type CompleteVaultLockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CompleteVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteVaultLockOutput) GoString() string {
	return s.String()
}

// Provides options to create a vault.
type CreateVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateVaultInput) SetAccountId(v string) *CreateVaultInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *CreateVaultInput) SetVaultName(v string) *CreateVaultInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type CreateVaultOutput struct {
	_ struct{} `type:"structure"`

	// The URI of the vault that was created.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVaultOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateVaultOutput) SetLocation(v string) *CreateVaultOutput {
	s.Location = &v
	return s
}

// Data retrieval policy.
type DataRetrievalPolicy struct {
	_ struct{} `type:"structure"`

	// The policy rule. Although this is a list type, currently there must be only
	// one rule, which contains a Strategy field and optionally a BytesPerHour field.
	Rules []*DataRetrievalRule `type:"list"`
}

// String returns the string representation
func (s DataRetrievalPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRetrievalPolicy) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *DataRetrievalPolicy) SetRules(v []*DataRetrievalRule) *DataRetrievalPolicy {
	s.Rules = v
	return s
}

// Data retrieval policy rule.
type DataRetrievalRule struct {
	_ struct{} `type:"structure"`

	// The maximum number of bytes that can be retrieved in an hour.
	//
	// This field is required only if the value of the Strategy field is BytesPerHour.
	// Your PUT operation will be rejected if the Strategy field is not set to BytesPerHour
	// and you set this field.
	BytesPerHour *int64 `type:"long"`

	// The type of data retrieval policy to set.
	//
	// Valid values: BytesPerHour|FreeTier|None
	Strategy *string `type:"string"`
}

// String returns the string representation
func (s DataRetrievalRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRetrievalRule) GoString() string {
	return s.String()
}

// SetBytesPerHour sets the BytesPerHour field's value.
func (s *DataRetrievalRule) SetBytesPerHour(v int64) *DataRetrievalRule {
	s.BytesPerHour = &v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *DataRetrievalRule) SetStrategy(v string) *DataRetrievalRule {
	s.Strategy = &v
	return s
}

// Provides options for deleting an archive from an Amazon S3 Glacier vault.
type DeleteArchiveInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The ID of the archive to delete.
	//
	// ArchiveId is a required field
	ArchiveId *string `location:"uri" locationName:"archiveId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteArchiveInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ArchiveId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArchiveId"))
	}
	if s.ArchiveId != nil && len(*s.ArchiveId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArchiveId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteArchiveInput) SetAccountId(v string) *DeleteArchiveInput {
	s.AccountId = &v
	return s
}

// SetArchiveId sets the ArchiveId field's value.
func (s *DeleteArchiveInput) SetArchiveId(v string) *DeleteArchiveInput {
	s.ArchiveId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DeleteArchiveInput) SetVaultName(v string) *DeleteArchiveInput {
	s.VaultName = &v
	return s
}

type DeleteArchiveOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveOutput) GoString() string {
	return s.String()
}

// DeleteVaultAccessPolicy input.
type DeleteVaultAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVaultAccessPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteVaultAccessPolicyInput) SetAccountId(v string) *DeleteVaultAccessPolicyInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DeleteVaultAccessPolicyInput) SetVaultName(v string) *DeleteVaultAccessPolicyInput {
	s.VaultName = &v
	return s
}

type DeleteVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// Provides options for deleting a vault from Amazon S3 Glacier.
type DeleteVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteVaultInput) SetAccountId(v string) *DeleteVaultInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DeleteVaultInput) SetVaultName(v string) *DeleteVaultInput {
	s.VaultName = &v
	return s
}

// Provides options for deleting a vault notification configuration from an
// Amazon Glacier vault.
type DeleteVaultNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVaultNotificationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteVaultNotificationsInput) SetAccountId(v string) *DeleteVaultNotificationsInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DeleteVaultNotificationsInput) SetVaultName(v string) *DeleteVaultNotificationsInput {
	s.VaultName = &v
	return s
}

type DeleteVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultNotificationsOutput) GoString() string {
	return s.String()
}

type DeleteVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultOutput) GoString() string {
	return s.String()
}

// Provides options for retrieving a job description.
type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The ID of the job to describe.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeJobInput) SetAccountId(v string) *DescribeJobInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DescribeJobInput) SetVaultName(v string) *DescribeJobInput {
	s.VaultName = &v
	return s
}

// Provides options for retrieving metadata for a specific vault in Amazon Glacier.
type DescribeVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeVaultInput) SetAccountId(v string) *DescribeVaultInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DescribeVaultInput) SetVaultName(v string) *DescribeVaultInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type DescribeVaultOutput struct {
	_ struct{} `type:"structure"`

	// The Universal Coordinated Time (UTC) date when the vault was created. This
	// value should be a string in the ISO 8601 date format, for example 2012-03-20T17:03:43.221Z.
	CreationDate *string `type:"string"`

	// The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed
	// the last vault inventory. This value should be a string in the ISO 8601 date
	// format, for example 2012-03-20T17:03:43.221Z.
	LastInventoryDate *string `type:"string"`

	// The number of archives in the vault as of the last inventory date. This field
	// will return null if an inventory has not yet run on the vault, for example
	// if you just created the vault.
	NumberOfArchives *int64 `type:"long"`

	// Total size, in bytes, of the archives in the vault as of the last inventory
	// date. This field will return null if an inventory has not yet run on the
	// vault, for example if you just created the vault.
	SizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault.
	VaultARN *string `type:"string"`

	// The name of the vault.
	VaultName *string `type:"string"`
}

// String returns the string representation
func (s DescribeVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVaultOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeVaultOutput) SetCreationDate(v string) *DescribeVaultOutput {
	s.CreationDate = &v
	return s
}

// SetLastInventoryDate sets the LastInventoryDate field's value.
func (s *DescribeVaultOutput) SetLastInventoryDate(v string) *DescribeVaultOutput {
	s.LastInventoryDate = &v
	return s
}

// SetNumberOfArchives sets the NumberOfArchives field's value.
func (s *DescribeVaultOutput) SetNumberOfArchives(v int64) *DescribeVaultOutput {
	s.NumberOfArchives = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *DescribeVaultOutput) SetSizeInBytes(v int64) *DescribeVaultOutput {
	s.SizeInBytes = &v
	return s
}

// SetVaultARN sets the VaultARN field's value.
func (s *DescribeVaultOutput) SetVaultARN(v string) *DescribeVaultOutput {
	s.VaultARN = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *DescribeVaultOutput) SetVaultName(v string) *DescribeVaultOutput {
	s.VaultName = &v
	return s
}

// Contains information about the encryption used to store the job results in
// Amazon S3.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3, for example AES256 or aws:kms.
	EncryptionType *string `type:"string" enum:"EncryptionType"`

	// Optional. If the encryption type is aws:kms, you can use this value to specify
	// the encryption context for the job results.
	KMSContext *string `type:"string"`

	// The AWS KMS key ID to use for object encryption. All GET and PUT requests
	// for an object protected by AWS KMS fail if not made by using Secure Sockets
	// Layer (SSL) or Signature Version 4.
	KMSKeyId *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *Encryption) SetEncryptionType(v string) *Encryption {
	s.EncryptionType = &v
	return s
}

// SetKMSContext sets the KMSContext field's value.
func (s *Encryption) SetKMSContext(v string) *Encryption {
	s.KMSContext = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *Encryption) SetKMSKeyId(v string) *Encryption {
	s.KMSKeyId = &v
	return s
}

// Input for GetDataRetrievalPolicy.
type GetDataRetrievalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataRetrievalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataRetrievalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataRetrievalPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetDataRetrievalPolicyInput) SetAccountId(v string) *GetDataRetrievalPolicyInput {
	s.AccountId = &v
	return s
}

// Contains the Amazon S3 Glacier response to the GetDataRetrievalPolicy request.
type GetDataRetrievalPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Contains the returned data retrieval policy in JSON format.
	Policy *DataRetrievalPolicy `type:"structure"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataRetrievalPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetDataRetrievalPolicyOutput) SetPolicy(v *DataRetrievalPolicy) *GetDataRetrievalPolicyOutput {
	s.Policy = v
	return s
}

// Provides options for downloading output of an Amazon S3 Glacier job.
type GetJobOutputInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The job ID whose data is downloaded.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The range of bytes to retrieve from the output. For example, if you want
	// to download the first 1,048,576 bytes, specify the range as bytes=0-1048575.
	// By default, this operation downloads the entire output.
	//
	// If the job output is large, then you can use a range to retrieve a portion
	// of the output. This allows you to download the entire output in smaller chunks
	// of bytes. For example, suppose you have 1 GB of job output you want to download
	// and you decide to download 128 MB chunks of data at a time, which is a total
	// of eight Get Job Output requests. You use the following process to download
	// the job output:
	//
	// Download a 128 MB chunk of output by specifying the appropriate byte range.
	// Verify that all 128 MB of data was received.
	//
	// Along with the data, the response includes a SHA256 tree hash of the payload.
	// You compute the checksum of the payload on the client and compare it with
	// the checksum you received in the response to ensure you received all the
	// expected data.
	//
	// Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each
	// time specifying the appropriate byte range.
	//
	// After downloading all the parts of the job output, you have a list of eight
	// checksum values. Compute the tree hash of these values to find the checksum
	// of the entire output. Using the DescribeJob API, obtain job information of
	// the job that provided you the output. The response includes the checksum
	// of the entire archive stored in Amazon S3 Glacier. You compare this value
	// with the checksum you computed to ensure you have downloaded the entire archive
	// content with no errors.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobOutputInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetJobOutputInput) SetAccountId(v string) *GetJobOutputInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobOutputInput) SetJobId(v string) *GetJobOutputInput {
	s.JobId = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetJobOutputInput) SetRange(v string) *GetJobOutputInput {
	s.Range = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *GetJobOutputInput) SetVaultName(v string) *GetJobOutputInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type GetJobOutputOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Indicates the range units accepted. For more information, see RFC2616 (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
	AcceptRanges *string `location:"header" locationName:"Accept-Ranges" type:"string"`

	// The description of an archive.
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The job data, either archive data or inventory data.
	Body io.ReadCloser `locationName:"body" type:"blob"`

	// The checksum of the data in the response. This header is returned only when
	// retrieving the output for an archive retrieval job. Furthermore, this header
	// appears only under the following conditions:
	//
	//    * You get the entire range of the archive.
	//
	//    * You request a range to return of the archive that starts and ends on
	//    a multiple of 1 MB. For example, if you have an 3.1 MB archive and you
	//    specify a range to return that starts at 1 MB and ends at 2 MB, then the
	//    x-amz-sha256-tree-hash is returned as a response header.
	//
	//    * You request a range of the archive to return that starts on a multiple
	//    of 1 MB and goes to the end of the archive. For example, if you have a
	//    3.1 MB archive and you specify a range that starts at 2 MB and ends at
	//    3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned
	//    as a response header.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The range of bytes returned by Amazon S3 Glacier. If only partial output
	// is downloaded, the response provides the range of bytes Amazon S3 Glacier
	// returned. For example, bytes 0-1048575/8388608 returns the first 1 MB from
	// 8 MB.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// The Content-Type depends on whether the job output is an archive or a vault
	// inventory. For archive data, the Content-Type is application/octet-stream.
	// For vault inventory, if you requested CSV format when you initiated the job,
	// the Content-Type is text/csv. Otherwise, by default, vault inventory is returned
	// as JSON, and the Content-Type is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The HTTP response code for a job output request. The value depends on whether
	// a range was specified in the request.
	Status *int64 `location:"statusCode" locationName:"status" type:"integer"`
}

// String returns the string representation
func (s GetJobOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutputOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *GetJobOutputOutput) SetAcceptRanges(v string) *GetJobOutputOutput {
	s.AcceptRanges = &v
	return s
}

// SetArchiveDescription sets the ArchiveDescription field's value.
func (s *GetJobOutputOutput) SetArchiveDescription(v string) *GetJobOutputOutput {
	s.ArchiveDescription = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GetJobOutputOutput) SetBody(v io.ReadCloser) *GetJobOutputOutput {
	s.Body = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *GetJobOutputOutput) SetChecksum(v string) *GetJobOutputOutput {
	s.Checksum = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *GetJobOutputOutput) SetContentRange(v string) *GetJobOutputOutput {
	s.ContentRange = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetJobOutputOutput) SetContentType(v string) *GetJobOutputOutput {
	s.ContentType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetJobOutputOutput) SetStatus(v int64) *GetJobOutputOutput {
	s.Status = &v
	return s
}

// Input for GetVaultAccessPolicy.
type GetVaultAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVaultAccessPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetVaultAccessPolicyInput) SetAccountId(v string) *GetVaultAccessPolicyInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *GetVaultAccessPolicyInput) SetVaultName(v string) *GetVaultAccessPolicyInput {
	s.VaultName = &v
	return s
}

// Output for GetVaultAccessPolicy.
type GetVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// Contains the returned vault access policy as a JSON string.
	Policy *VaultAccessPolicy `locationName:"policy" type:"structure"`
}

// String returns the string representation
func (s GetVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetVaultAccessPolicyOutput) SetPolicy(v *VaultAccessPolicy) *GetVaultAccessPolicyOutput {
	s.Policy = v
	return s
}

// The input values for GetVaultLock.
type GetVaultLockInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVaultLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVaultLockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetVaultLockInput) SetAccountId(v string) *GetVaultLockInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *GetVaultLockInput) SetVaultName(v string) *GetVaultLockInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type GetVaultLockOutput struct {
	_ struct{} `type:"structure"`

	// The UTC date and time at which the vault lock was put into the InProgress
	// state.
	CreationDate *string `type:"string"`

	// The UTC date and time at which the lock ID expires. This value can be null
	// if the vault lock is in a Locked state.
	ExpirationDate *string `type:"string"`

	// The vault lock policy as a JSON string, which uses "\" as an escape character.
	Policy *string `type:"string"`

	// The state of the vault lock. InProgress or Locked.
	State *string `type:"string"`
}

// String returns the string representation
func (s GetVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultLockOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetVaultLockOutput) SetCreationDate(v string) *GetVaultLockOutput {
	s.CreationDate = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *GetVaultLockOutput) SetExpirationDate(v string) *GetVaultLockOutput {
	s.ExpirationDate = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetVaultLockOutput) SetPolicy(v string) *GetVaultLockOutput {
	s.Policy = &v
	return s
}

// SetState sets the State field's value.
func (s *GetVaultLockOutput) SetState(v string) *GetVaultLockOutput {
	s.State = &v
	return s
}

// Provides options for retrieving the notification configuration set on an
// Amazon Glacier vault.
type GetVaultNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVaultNotificationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetVaultNotificationsInput) SetAccountId(v string) *GetVaultNotificationsInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *GetVaultNotificationsInput) SetVaultName(v string) *GetVaultNotificationsInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type GetVaultNotificationsOutput struct {
	_ struct{} `type:"structure" payload:"VaultNotificationConfig"`

	// Returns the notification configuration set on the vault.
	VaultNotificationConfig *VaultNotificationConfig `locationName:"vaultNotificationConfig" type:"structure"`
}

// String returns the string representation
func (s GetVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultNotificationsOutput) GoString() string {
	return s.String()
}

// SetVaultNotificationConfig sets the VaultNotificationConfig field's value.
func (s *GetVaultNotificationsOutput) SetVaultNotificationConfig(v *VaultNotificationConfig) *GetVaultNotificationsOutput {
	s.VaultNotificationConfig = v
	return s
}

// Contains information about a grant.
type Grant struct {
	_ struct{} `type:"structure"`

	// The grantee.
	Grantee *Grantee `type:"structure"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *Grant) SetGrantee(v *Grantee) *Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *Grant) SetPermission(v string) *Grant {
	s.Permission = &v
	return s
}

// Contains information about the grantee.
type Grantee struct {
	_ struct{} `type:"structure"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grantee"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *Grantee) SetDisplayName(v string) *Grantee {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Grantee) SetEmailAddress(v string) *Grantee {
	s.EmailAddress = &v
	return s
}

// SetID sets the ID field's value.
func (s *Grantee) SetID(v string) *Grantee {
	s.ID = &v
	return s
}

// SetType sets the Type field's value.
func (s *Grantee) SetType(v string) *Grantee {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Grantee) SetURI(v string) *Grantee {
	s.URI = &v
	return s
}

// Provides options for initiating an Amazon S3 Glacier job.
type InitiateJobInput struct {
	_ struct{} `type:"structure" payload:"JobParameters"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Provides options for specifying job information.
	JobParameters *JobParameters `locationName:"jobParameters" type:"structure"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}
	if s.JobParameters != nil {
		if err := s.JobParameters.Validate(); err != nil {
			invalidParams.AddNested("JobParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InitiateJobInput) SetAccountId(v string) *InitiateJobInput {
	s.AccountId = &v
	return s
}

// SetJobParameters sets the JobParameters field's value.
func (s *InitiateJobInput) SetJobParameters(v *JobParameters) *InitiateJobInput {
	s.JobParameters = v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *InitiateJobInput) SetVaultName(v string) *InitiateJobInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type InitiateJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the job.
	JobId *string `location:"header" locationName:"x-amz-job-id" type:"string"`

	// The path to the location of where the select results are stored.
	JobOutputPath *string `location:"header" locationName:"x-amz-job-output-path" type:"string"`

	// The relative URI path of the job.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s InitiateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *InitiateJobOutput) SetJobId(v string) *InitiateJobOutput {
	s.JobId = &v
	return s
}

// SetJobOutputPath sets the JobOutputPath field's value.
func (s *InitiateJobOutput) SetJobOutputPath(v string) *InitiateJobOutput {
	s.JobOutputPath = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *InitiateJobOutput) SetLocation(v string) *InitiateJobOutput {
	s.Location = &v
	return s
}

// Provides options for initiating a multipart upload to an Amazon S3 Glacier
// vault.
type InitiateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The archive description that you are uploading in parts.
	//
	// The part size must be a megabyte (1024 KB) multiplied by a power of 2, for
	// example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and
	// so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096
	// MB).
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The size of each part except the last, in bytes. The last part can be smaller
	// than this part size.
	PartSize *string `location:"header" locationName:"x-amz-part-size" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateMultipartUploadInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InitiateMultipartUploadInput) SetAccountId(v string) *InitiateMultipartUploadInput {
	s.AccountId = &v
	return s
}

// SetArchiveDescription sets the ArchiveDescription field's value.
func (s *InitiateMultipartUploadInput) SetArchiveDescription(v string) *InitiateMultipartUploadInput {
	s.ArchiveDescription = &v
	return s
}

// SetPartSize sets the PartSize field's value.
func (s *InitiateMultipartUploadInput) SetPartSize(v string) *InitiateMultipartUploadInput {
	s.PartSize = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *InitiateMultipartUploadInput) SetVaultName(v string) *InitiateMultipartUploadInput {
	s.VaultName = &v
	return s
}

// The Amazon S3 Glacier response to your request.
type InitiateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// The relative URI path of the multipart upload ID Amazon S3 Glacier created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The ID of the multipart upload. This value is also included as part of the
	// location.
	UploadId *string `location:"header" locationName:"x-amz-multipart-upload-id" type:"string"`
}

// String returns the string representation
func (s InitiateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *InitiateMultipartUploadOutput) SetLocation(v string) *InitiateMultipartUploadOutput {
	s.Location = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *InitiateMultipartUploadOutput) SetUploadId(v string) *InitiateMultipartUploadOutput {
	s.UploadId = &v
	return s
}

// The input values for InitiateVaultLock.
type InitiateVaultLockInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The vault lock policy as a JSON string, which uses "\" as an escape character.
	Policy *VaultLockPolicy `locationName:"policy" type:"structure"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateVaultLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateVaultLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateVaultLockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InitiateVaultLockInput) SetAccountId(v string) *InitiateVaultLockInput {
	s.AccountId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *InitiateVaultLockInput) SetPolicy(v *VaultLockPolicy) *InitiateVaultLockInput {
	s.Policy = v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *InitiateVaultLockInput) SetVaultName(v string) *InitiateVaultLockInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type InitiateVaultLockOutput struct {
	_ struct{} `type:"structure"`

	// The lock ID, which is used to complete the vault locking process.
	LockId *string `location:"header" locationName:"x-amz-lock-id" type:"string"`
}

// String returns the string representation
func (s InitiateVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateVaultLockOutput) GoString() string {
	return s.String()
}

// SetLockId sets the LockId field's value.
func (s *InitiateVaultLockOutput) SetLockId(v string) *InitiateVaultLockOutput {
	s.LockId = &v
	return s
}

// Describes how the archive is serialized.
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	Csv *CSVInput `locationName:"csv" type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSerialization) GoString() string {
	return s.String()
}

// SetCsv sets the Csv field's value.
func (s *InputSerialization) SetCsv(v *CSVInput) *InputSerialization {
	s.Csv = v
	return s
}

// Returned if there is insufficient capacity to process this expedited request.
// This error only applies to expedited retrievals and not to standard or bulk
// retrievals.
type InsufficientCapacityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s InsufficientCapacityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsufficientCapacityException) GoString() string {
	return s.String()
}

func newErrorInsufficientCapacityException(v protocol.ResponseMetadata) error {
	return &InsufficientCapacityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientCapacityException) Code() string {
	return "InsufficientCapacityException"
}

// Message returns the exception's message.
func (s *InsufficientCapacityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientCapacityException) OrigErr() error {
	return nil
}

func (s *InsufficientCapacityException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientCapacityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientCapacityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if a parameter of the request is incorrectly specified.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 400 Bad Request
	Code_ *string `locationName:"code" type:"string"`

	// Returned if a parameter of the request is incorrectly specified.
	Message_ *string `locationName:"message" type:"string"`

	// Client
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the options for a range inventory retrieval job.
type InventoryRetrievalJobDescription struct {
	_ struct{} `type:"structure"`

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO
	// 8601 date format, for example 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// The output format for the vault inventory list, which is set by the InitiateJob
	// request when initiating a job to retrieve a vault inventory. Valid values
	// are CSV and JSON.
	Format *string `type:"string"`

	// The maximum number of inventory items returned per vault inventory retrieval
	// request. This limit is set when initiating the job with the a InitiateJob
	// request.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null. For more information, see Range Inventory Retrieval (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering).
	Marker *string `type:"string"`

	// The start of the date range in Universal Coordinated Time (UTC) for vault
	// inventory retrieval that includes archives created on or after this date.
	// This value should be a string in the ISO 8601 date format, for example 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s InventoryRetrievalJobDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryRetrievalJobDescription) GoString() string {
	return s.String()
}

// SetEndDate sets the EndDate field's value.
func (s *InventoryRetrievalJobDescription) SetEndDate(v string) *InventoryRetrievalJobDescription {
	s.EndDate = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *InventoryRetrievalJobDescription) SetFormat(v string) *InventoryRetrievalJobDescription {
	s.Format = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *InventoryRetrievalJobDescription) SetLimit(v string) *InventoryRetrievalJobDescription {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *InventoryRetrievalJobDescription) SetMarker(v string) *InventoryRetrievalJobDescription {
	s.Marker = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *InventoryRetrievalJobDescription) SetStartDate(v string) *InventoryRetrievalJobDescription {
	s.StartDate = &v
	return s
}

// Provides options for specifying a range inventory retrieval job.
type InventoryRetrievalJobInput struct {
	_ struct{} `type:"structure"`

	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. This value should be a string in the ISO
	// 8601 date format, for example 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// Specifies the maximum number of inventory items returned per vault inventory
	// retrieval request. Valid values are greater than or equal to 1.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null.
	Marker *string `type:"string"`

	// The start of the date range in UTC for vault inventory retrieval that includes
	// archives created on or after this date. This value should be a string in
	// the ISO 8601 date format, for example 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s InventoryRetrievalJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryRetrievalJobInput) GoString() string {
	return s.String()
}

// SetEndDate sets the EndDate field's value.
func (s *InventoryRetrievalJobInput) SetEndDate(v string) *InventoryRetrievalJobInput {
	s.EndDate = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *InventoryRetrievalJobInput) SetLimit(v string) *InventoryRetrievalJobInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *InventoryRetrievalJobInput) SetMarker(v string) *InventoryRetrievalJobInput {
	s.Marker = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *InventoryRetrievalJobInput) SetStartDate(v string) *InventoryRetrievalJobInput {
	s.StartDate = &v
	return s
}

// Contains the description of an Amazon S3 Glacier job.
type JobDescription struct {
	_ struct{} `type:"structure"`

	// The job type. This value is either ArchiveRetrieval, InventoryRetrieval,
	// or Select.
	Action *string `type:"string" enum:"ActionCode"`

	// The archive ID requested for a select job or archive retrieval. Otherwise,
	// this field is null.
	ArchiveId *string `type:"string"`

	// The SHA256 tree hash of the entire archive for an archive retrieval. For
	// inventory retrieval or select jobs, this field is null.
	ArchiveSHA256TreeHash *string `type:"string"`

	// For an archive retrieval job, this value is the size in bytes of the archive
	// being requested for download. For an inventory retrieval or select job, this
	// value is null.
	ArchiveSizeInBytes *int64 `type:"long"`

	// The job status. When a job is completed, you get the job's output using Get
	// Job Output (GET output).
	Completed *bool `type:"boolean"`

	// The UTC time that the job request completed. While the job is in progress,
	// the value is null.
	CompletionDate *string `type:"string"`

	// The UTC date when the job was created. This value is a string representation
	// of ISO 8601 date format, for example "2012-03-20T17:03:43.221Z".
	CreationDate *string `type:"string"`

	// Parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobDescription `type:"structure"`

	// For an inventory retrieval job, this value is the size in bytes of the inventory
	// requested for download. For an archive retrieval or select job, this value
	// is null.
	InventorySizeInBytes *int64 `type:"long"`

	// The job description provided when initiating the job.
	JobDescription *string `type:"string"`

	// An opaque string that identifies an Amazon S3 Glacier job.
	JobId *string `type:"string"`

	// Contains the job output location.
	JobOutputPath *string `type:"string"`

	// Contains the location where the data from the select job is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// The retrieved byte range for archive retrieval jobs in the form StartByteValue-EndByteValue.
	// If no range was specified in the archive retrieval, then the whole archive
	// is retrieved. In this case, StartByteValue equals 0 and EndByteValue equals
	// the size of the archive minus 1. For inventory retrieval or select jobs,
	// this field is null.
	RetrievalByteRange *string `type:"string"`

	// For an archive retrieval job, this value is the checksum of the archive.
	// Otherwise, this value is null.
	//
	// The SHA256 tree hash value for the requested range of an archive. If the
	// InitiateJob request for an archive specified a tree-hash aligned range, then
	// this field returns a value.
	//
	// If the whole archive is retrieved, this value is the same as the ArchiveSHA256TreeHash
	// value.
	//
	// This field is null for the following:
	//
	//    * Archive retrieval jobs that specify a range that is not tree-hash aligned
	//
	//    * Archival jobs that specify a range that is equal to the whole archive,
	//    when the job status is InProgress
	//
	//    * Inventory jobs
	//
	//    * Select jobs
	SHA256TreeHash *string `type:"string"`

	// An Amazon SNS topic that receives notification.
	SNSTopic *string `type:"string"`

	// Contains the parameters used for a select.
	SelectParameters *SelectParameters `type:"structure"`

	// The status code can be InProgress, Succeeded, or Failed, and indicates the
	// status of the job.
	StatusCode *string `type:"string" enum:"StatusCode"`

	// A friendly message that describes the job status.
	StatusMessage *string `type:"string"`

	// The tier to use for a select or an archive retrieval. Valid values are Expedited,
	// Standard, or Bulk. Standard is the default.
	Tier *string `type:"string"`

	// The Amazon Resource Name (ARN) of the vault from which an archive retrieval
	// was requested.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s JobDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDescription) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *JobDescription) SetAction(v string) *JobDescription {
	s.Action = &v
	return s
}

// SetArchiveId sets the ArchiveId field's value.
func (s *JobDescription) SetArchiveId(v string) *JobDescription {
	s.ArchiveId = &v
	return s
}

// SetArchiveSHA256TreeHash sets the ArchiveSHA256TreeHash field's value.
func (s *JobDescription) SetArchiveSHA256TreeHash(v string) *JobDescription {
	s.ArchiveSHA256TreeHash = &v
	return s
}

// SetArchiveSizeInBytes sets the ArchiveSizeInBytes field's value.
func (s *JobDescription) SetArchiveSizeInBytes(v int64) *JobDescription {
	s.ArchiveSizeInBytes = &v
	return s
}

// SetCompleted sets the Completed field's value.
func (s *JobDescription) SetCompleted(v bool) *JobDescription {
	s.Completed = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *JobDescription) SetCompletionDate(v string) *JobDescription {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *JobDescription) SetCreationDate(v string) *JobDescription {
	s.CreationDate = &v
	return s
}

// SetInventoryRetrievalParameters sets the InventoryRetrievalParameters field's value.
func (s *JobDescription) SetInventoryRetrievalParameters(v *InventoryRetrievalJobDescription) *JobDescription {
	s.InventoryRetrievalParameters = v
	return s
}

// SetInventorySizeInBytes sets the InventorySizeInBytes field's value.
func (s *JobDescription) SetInventorySizeInBytes(v int64) *JobDescription {
	s.InventorySizeInBytes = &v
	return s
}

// SetJobDescription sets the JobDescription field's value.
func (s *JobDescription) SetJobDescription(v string) *JobDescription {
	s.JobDescription = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDescription) SetJobId(v string) *JobDescription {
	s.JobId = &v
	return s
}

// SetJobOutputPath sets the JobOutputPath field's value.
func (s *JobDescription) SetJobOutputPath(v string) *JobDescription {
	s.JobOutputPath = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *JobDescription) SetOutputLocation(v *OutputLocation) *JobDescription {
	s.OutputLocation = v
	return s
}

// SetRetrievalByteRange sets the RetrievalByteRange field's value.
func (s *JobDescription) SetRetrievalByteRange(v string) *JobDescription {
	s.RetrievalByteRange = &v
	return s
}

// SetSHA256TreeHash sets the SHA256TreeHash field's value.
func (s *JobDescription) SetSHA256TreeHash(v string) *JobDescription {
	s.SHA256TreeHash = &v
	return s
}

// SetSNSTopic sets the SNSTopic field's value.
func (s *JobDescription) SetSNSTopic(v string) *JobDescription {
	s.SNSTopic = &v
	return s
}

// SetSelectParameters sets the SelectParameters field's value.
func (s *JobDescription) SetSelectParameters(v *SelectParameters) *JobDescription {
	s.SelectParameters = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *JobDescription) SetStatusCode(v string) *JobDescription {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *JobDescription) SetStatusMessage(v string) *JobDescription {
	s.StatusMessage = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *JobDescription) SetTier(v string) *JobDescription {
	s.Tier = &v
	return s
}

// SetVaultARN sets the VaultARN field's value.
func (s *JobDescription) SetVaultARN(v string) *JobDescription {
	s.VaultARN = &v
	return s
}

// Provides options for defining a job.
type JobParameters struct {
	_ struct{} `type:"structure"`

	// The ID of the archive that you want to retrieve. This field is required only
	// if Type is set to select or archive-retrievalcode>. An error occurs if you
	// specify this request parameter for an inventory retrieval job request.
	ArchiveId *string `type:"string"`

	// The optional description for the job. The description must be less than or
	// equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control
	// codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.
	Description *string `type:"string"`

	// When initiating a job to retrieve a vault inventory, you can optionally add
	// this parameter to your request to specify the output format. If you are initiating
	// an inventory job and do not specify a Format field, JSON is the default format.
	// Valid values are "CSV" and "JSON".
	Format *string `type:"string"`

	// Input parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobInput `type:"structure"`

	// Contains information about the location where the select job results are
	// stored.
	OutputLocation *OutputLocation `type:"structure"`

	// The byte range to retrieve for an archive retrieval. in the form "StartByteValue-EndByteValue"
	// If not specified, the whole archive is retrieved. If specified, the byte
	// range must be megabyte (1024*1024) aligned which means that StartByteValue
	// must be divisible by 1 MB and EndByteValue plus 1 must be divisible by 1
	// MB or be the end of the archive specified as the archive byte size value
	// minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns
	// a 400 response.
	//
	// An error occurs if you specify this field for an inventory retrieval job
	// request.
	RetrievalByteRange *string `type:"string"`

	// The Amazon SNS topic ARN to which Amazon S3 Glacier sends a notification
	// when the job is completed and the output is ready for you to download. The
	// specified topic publishes the notification to its subscribers. The SNS topic
	// must exist.
	SNSTopic *string `type:"string"`

	// Contains the parameters that define a job.
	SelectParameters *SelectParameters `type:"structure"`

	// The tier to use for a select or an archive retrieval job. Valid values are
	// Expedited, Standard, or Bulk. Standard is the default.
	Tier *string `type:"string"`

	// The job type. You can initiate a job to perform a select query on an archive,
	// retrieve an archive, or get an inventory of a vault. Valid values are "select",
	// "archive-retrieval" and "inventory-retrieval".
	Type *string `type:"string"`
}

// String returns the string representation
func (s JobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobParameters"}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveId sets the ArchiveId field's value.
func (s *JobParameters) SetArchiveId(v string) *JobParameters {
	s.ArchiveId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobParameters) SetDescription(v string) *JobParameters {
	s.Description = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobParameters) SetFormat(v string) *JobParameters {
	s.Format = &v
	return s
}

// SetInventoryRetrievalParameters sets the InventoryRetrievalParameters field's value.
func (s *JobParameters) SetInventoryRetrievalParameters(v *InventoryRetrievalJobInput) *JobParameters {
	s.InventoryRetrievalParameters = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *JobParameters) SetOutputLocation(v *OutputLocation) *JobParameters {
	s.OutputLocation = v
	return s
}

// SetRetrievalByteRange sets the RetrievalByteRange field's value.
func (s *JobParameters) SetRetrievalByteRange(v string) *JobParameters {
	s.RetrievalByteRange = &v
	return s
}

// SetSNSTopic sets the SNSTopic field's value.
func (s *JobParameters) SetSNSTopic(v string) *JobParameters {
	s.SNSTopic = &v
	return s
}

// SetSelectParameters sets the SelectParameters field's value.
func (s *JobParameters) SetSelectParameters(v *SelectParameters) *JobParameters {
	s.SelectParameters = v
	return s
}

// SetTier sets the Tier field's value.
func (s *JobParameters) SetTier(v string) *JobParameters {
	s.Tier = &v
	return s
}

// SetType sets the Type field's value.
func (s *JobParameters) SetType(v string) *JobParameters {
	s.Type = &v
	return s
}

// Returned if the request results in a vault or account limit being exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 400 Bad Request
	Code_ *string `locationName:"code" type:"string"`

	// Returned if the request results in a vault limit or tags limit being exceeded.
	Message_ *string `locationName:"message" type:"string"`

	// Client
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides options for retrieving a job list for an Amazon S3 Glacier vault.
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The state of the jobs to return. You can specify true or false.
	Completed *string `location:"querystring" locationName:"completed" type:"string"`

	// The maximum number of jobs to be returned. The default limit is 50. The number
	// of jobs returned might be fewer than the specified limit, but the number
	// of returned jobs never exceeds the limit.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the job at which
	// the listing of jobs should begin. Get the marker value from a previous List
	// Jobs response. You only need to include the marker if you are continuing
	// the pagination of results started in a previous List Jobs request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The type of job status to return. You can specify the following values: InProgress,
	// Succeeded, or Failed.
	Statuscode *string `location:"querystring" locationName:"statuscode" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListJobsInput) SetAccountId(v string) *ListJobsInput {
	s.AccountId = &v
	return s
}

// SetCompleted sets the Completed field's value.
func (s *ListJobsInput) SetCompleted(v string) *ListJobsInput {
	s.Completed = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListJobsInput) SetLimit(v string) *ListJobsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListJobsInput) SetMarker(v string) *ListJobsInput {
	s.Marker = &v
	return s
}

// SetStatuscode sets the Statuscode field's value.
func (s *ListJobsInput) SetStatuscode(v string) *ListJobsInput {
	s.Statuscode = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *ListJobsInput) SetVaultName(v string) *ListJobsInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job objects. Each job object contains metadata describing the job.
	JobList []*JobDescription `type:"list"`

	// An opaque string used for pagination that specifies the job at which the
	// listing of jobs should begin. You get the marker value from a previous List
	// Jobs response. You only need to include the marker if you are continuing
	// the pagination of the results started in a previous List Jobs request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobList sets the JobList field's value.
func (s *ListJobsOutput) SetJobList(v []*JobDescription) *ListJobsOutput {
	s.JobList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListJobsOutput) SetMarker(v string) *ListJobsOutput {
	s.Marker = &v
	return s
}

// Provides options for retrieving list of in-progress multipart uploads for
// an Amazon Glacier vault.
type ListMultipartUploadsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Specifies the maximum number of uploads returned in the response body. If
	// this value is not specified, the List Uploads operation returns up to 50
	// uploads.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the upload at
	// which the listing of uploads should begin. Get the marker value from a previous
	// List Uploads response. You need only include the marker if you are continuing
	// the pagination of results started in a previous List Uploads request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultipartUploadsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListMultipartUploadsInput) SetAccountId(v string) *ListMultipartUploadsInput {
	s.AccountId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListMultipartUploadsInput) SetLimit(v string) *ListMultipartUploadsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListMultipartUploadsInput) SetMarker(v string) *ListMultipartUploadsInput {
	s.Marker = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *ListMultipartUploadsInput) SetVaultName(v string) *ListMultipartUploadsInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that represents where to continue pagination of the results.
	// You use the marker in a new List Multipart Uploads request to obtain more
	// uploads in the list. If there are no more uploads, this value is null.
	Marker *string `type:"string"`

	// A list of in-progress multipart uploads.
	UploadsList []*UploadListElement `type:"list"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListMultipartUploadsOutput) SetMarker(v string) *ListMultipartUploadsOutput {
	s.Marker = &v
	return s
}

// SetUploadsList sets the UploadsList field's value.
func (s *ListMultipartUploadsOutput) SetUploadsList(v []*UploadListElement) *ListMultipartUploadsOutput {
	s.UploadsList = v
	return s
}

// Provides options for retrieving a list of parts of an archive that have been
// uploaded in a specific multipart upload.
type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of parts to be returned. The default limit is 50. The
	// number of parts returned might be fewer than the specified limit, but the
	// number of returned parts never exceeds the limit.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the part at which
	// the listing of parts should begin. Get the marker value from the response
	// of a previous List Parts response. You need only include the marker if you
	// are continuing the pagination of results started in a previous List Parts
	// request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The upload ID of the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListPartsInput) SetAccountId(v string) *ListPartsInput {
	s.AccountId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListPartsInput) SetLimit(v string) *ListPartsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPartsInput) SetMarker(v string) *ListPartsInput {
	s.Marker = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsInput) SetUploadId(v string) *ListPartsInput {
	s.UploadId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *ListPartsInput) SetVaultName(v string) *ListPartsInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// An opaque string that represents where to continue pagination of the results.
	// You use the marker in a new List Parts request to obtain more jobs in the
	// list. If there are no more parts, this value is null.
	Marker *string `type:"string"`

	// The ID of the upload to which the parts are associated.
	MultipartUploadId *string `type:"string"`

	// The part size in bytes. This is the same value that you specified in the
	// Initiate Multipart Upload request.
	PartSizeInBytes *int64 `type:"long"`

	// A list of the part sizes of the multipart upload. Each object in the array
	// contains a RangeBytes and sha256-tree-hash name/value pair.
	Parts []*PartListElement `type:"list"`

	// The Amazon Resource Name (ARN) of the vault to which the multipart upload
	// was initiated.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// SetArchiveDescription sets the ArchiveDescription field's value.
func (s *ListPartsOutput) SetArchiveDescription(v string) *ListPartsOutput {
	s.ArchiveDescription = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ListPartsOutput) SetCreationDate(v string) *ListPartsOutput {
	s.CreationDate = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPartsOutput) SetMarker(v string) *ListPartsOutput {
	s.Marker = &v
	return s
}

// SetMultipartUploadId sets the MultipartUploadId field's value.
func (s *ListPartsOutput) SetMultipartUploadId(v string) *ListPartsOutput {
	s.MultipartUploadId = &v
	return s
}

// SetPartSizeInBytes sets the PartSizeInBytes field's value.
func (s *ListPartsOutput) SetPartSizeInBytes(v int64) *ListPartsOutput {
	s.PartSizeInBytes = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *ListPartsOutput) SetParts(v []*PartListElement) *ListPartsOutput {
	s.Parts = v
	return s
}

// SetVaultARN sets the VaultARN field's value.
func (s *ListPartsOutput) SetVaultARN(v string) *ListPartsOutput {
	s.VaultARN = &v
	return s
}

type ListProvisionedCapacityInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the account that owns the vault. You can either specify
	// an AWS account ID or optionally a single '-' (hyphen), in which case Amazon
	// S3 Glacier uses the AWS account ID associated with the credentials used to
	// sign the request. If you use an account ID, don't include any hyphens ('-')
	// in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProvisionedCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisionedCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProvisionedCapacityInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListProvisionedCapacityInput) SetAccountId(v string) *ListProvisionedCapacityInput {
	s.AccountId = &v
	return s
}

type ListProvisionedCapacityOutput struct {
	_ struct{} `type:"structure"`

	// The response body contains the following JSON fields.
	ProvisionedCapacityList []*ProvisionedCapacityDescription `type:"list"`
}

// String returns the string representation
func (s ListProvisionedCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisionedCapacityOutput) GoString() string {
	return s.String()
}

// SetProvisionedCapacityList sets the ProvisionedCapacityList field's value.
func (s *ListProvisionedCapacityOutput) SetProvisionedCapacityList(v []*ProvisionedCapacityDescription) *ListProvisionedCapacityOutput {
	s.ProvisionedCapacityList = v
	return s
}

// The input value for ListTagsForVaultInput.
type ListTagsForVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListTagsForVaultInput) SetAccountId(v string) *ListTagsForVaultInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *ListTagsForVaultInput) SetVaultName(v string) *ListTagsForVaultInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type ListTagsForVaultOutput struct {
	_ struct{} `type:"structure"`

	// The tags attached to the vault. Each tag is composed of a key and a value.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListTagsForVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForVaultOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForVaultOutput) SetTags(v map[string]*string) *ListTagsForVaultOutput {
	s.Tags = v
	return s
}

// Provides options to retrieve the vault list owned by the calling user's account.
// The list provides metadata information for each vault.
type ListVaultsInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of vaults to be returned. The default limit is 10. The
	// number of vaults returned might be fewer than the specified limit, but the
	// number of returned vaults never exceeds the limit.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// A string used for pagination. The marker specifies the vault ARN after which
	// the listing of vaults should begin.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`
}

// String returns the string representation
func (s ListVaultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVaultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVaultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVaultsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListVaultsInput) SetAccountId(v string) *ListVaultsInput {
	s.AccountId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListVaultsInput) SetLimit(v string) *ListVaultsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVaultsInput) SetMarker(v string) *ListVaultsInput {
	s.Marker = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type ListVaultsOutput struct {
	_ struct{} `type:"structure"`

	// The vault ARN at which to continue pagination of the results. You use the
	// marker in another List Vaults request to obtain more vaults in the list.
	Marker *string `type:"string"`

	// List of vaults.
	VaultList []*DescribeVaultOutput `type:"list"`
}

// String returns the string representation
func (s ListVaultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVaultsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListVaultsOutput) SetMarker(v string) *ListVaultsOutput {
	s.Marker = &v
	return s
}

// SetVaultList sets the VaultList field's value.
func (s *ListVaultsOutput) SetVaultList(v []*DescribeVaultOutput) *ListVaultsOutput {
	s.VaultList = v
	return s
}

// Returned if a required header or parameter is missing from the request.
type MissingParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 400 Bad Request
	Code_ *string `locationName:"code" type:"string"`

	// Returned if no authentication data is found for the request.
	Message_ *string `locationName:"message" type:"string"`

	// Client.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s MissingParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissingParameterValueException) GoString() string {
	return s.String()
}

func newErrorMissingParameterValueException(v protocol.ResponseMetadata) error {
	return &MissingParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingParameterValueException) Code() string {
	return "MissingParameterValueException"
}

// Message returns the exception's message.
func (s *MissingParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingParameterValueException) OrigErr() error {
	return nil
}

func (s *MissingParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the location where the select job results are
// stored.
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the job request.
	S3 *S3Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *OutputLocation) SetS3(v *S3Location) *OutputLocation {
	s.S3 = v
	return s
}

// Describes how the select output is serialized.
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded query results.
	Csv *CSVOutput `locationName:"csv" type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSerialization) GoString() string {
	return s.String()
}

// SetCsv sets the Csv field's value.
func (s *OutputSerialization) SetCsv(v *CSVOutput) *OutputSerialization {
	s.Csv = v
	return s
}

// A list of the part sizes of the multipart upload.
type PartListElement struct {
	_ struct{} `type:"structure"`

	// The byte range of a part, inclusive of the upper value of the range.
	RangeInBytes *string `type:"string"`

	// The SHA256 tree hash value that Amazon S3 Glacier calculated for the part.
	// This field is never null.
	SHA256TreeHash *string `type:"string"`
}

// String returns the string representation
func (s PartListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartListElement) GoString() string {
	return s.String()
}

// SetRangeInBytes sets the RangeInBytes field's value.
func (s *PartListElement) SetRangeInBytes(v string) *PartListElement {
	s.RangeInBytes = &v
	return s
}

// SetSHA256TreeHash sets the SHA256TreeHash field's value.
func (s *PartListElement) SetSHA256TreeHash(v string) *PartListElement {
	s.SHA256TreeHash = &v
	return s
}

// Returned if a retrieval job would exceed the current data policy's retrieval
// rate limit. For more information about data retrieval policies,
type PolicyEnforcedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// PolicyEnforcedException
	Code_ *string `locationName:"code" type:"string"`

	// InitiateJob request denied by current data retrieval policy.
	Message_ *string `locationName:"message" type:"string"`

	// Client
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s PolicyEnforcedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyEnforcedException) GoString() string {
	return s.String()
}

func newErrorPolicyEnforcedException(v protocol.ResponseMetadata) error {
	return &PolicyEnforcedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyEnforcedException) Code() string {
	return "PolicyEnforcedException"
}

// Message returns the exception's message.
func (s *PolicyEnforcedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyEnforcedException) OrigErr() error {
	return nil
}

func (s *PolicyEnforcedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyEnforcedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyEnforcedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The definition for a provisioned capacity unit.
type ProvisionedCapacityDescription struct {
	_ struct{} `type:"structure"`

	// The ID that identifies the provisioned capacity unit.
	CapacityId *string `type:"string"`

	// The date that the provisioned capacity unit expires, in Universal Coordinated
	// Time (UTC).
	ExpirationDate *string `type:"string"`

	// The date that the provisioned capacity unit was purchased, in Universal Coordinated
	// Time (UTC).
	StartDate *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedCapacityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedCapacityDescription) GoString() string {
	return s.String()
}

// SetCapacityId sets the CapacityId field's value.
func (s *ProvisionedCapacityDescription) SetCapacityId(v string) *ProvisionedCapacityDescription {
	s.CapacityId = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *ProvisionedCapacityDescription) SetExpirationDate(v string) *ProvisionedCapacityDescription {
	s.ExpirationDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ProvisionedCapacityDescription) SetStartDate(v string) *ProvisionedCapacityDescription {
	s.StartDate = &v
	return s
}

type PurchaseProvisionedCapacityInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the account that owns the vault. You can either specify
	// an AWS account ID or optionally a single '-' (hyphen), in which case Amazon
	// S3 Glacier uses the AWS account ID associated with the credentials used to
	// sign the request. If you use an account ID, don't include any hyphens ('-')
	// in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseProvisionedCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseProvisionedCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseProvisionedCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseProvisionedCapacityInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PurchaseProvisionedCapacityInput) SetAccountId(v string) *PurchaseProvisionedCapacityInput {
	s.AccountId = &v
	return s
}

type PurchaseProvisionedCapacityOutput struct {
	_ struct{} `type:"structure"`

	// The ID that identifies the provisioned capacity unit.
	CapacityId *string `location:"header" locationName:"x-amz-capacity-id" type:"string"`
}

// String returns the string representation
func (s PurchaseProvisionedCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseProvisionedCapacityOutput) GoString() string {
	return s.String()
}

// SetCapacityId sets the CapacityId field's value.
func (s *PurchaseProvisionedCapacityOutput) SetCapacityId(v string) *PurchaseProvisionedCapacityOutput {
	s.CapacityId = &v
	return s
}

// The input value for RemoveTagsFromVaultInput.
type RemoveTagsFromVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the vault.
	TagKeys []*string `type:"list"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromVaultInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RemoveTagsFromVaultInput) SetAccountId(v string) *RemoveTagsFromVaultInput {
	s.AccountId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromVaultInput) SetTagKeys(v []*string) *RemoveTagsFromVaultInput {
	s.TagKeys = v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *RemoveTagsFromVaultInput) SetVaultName(v string) *RemoveTagsFromVaultInput {
	s.VaultName = &v
	return s
}

type RemoveTagsFromVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromVaultOutput) GoString() string {
	return s.String()
}

// Returned if, when uploading an archive, Amazon S3 Glacier times out while
// receiving the upload.
type RequestTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 408 Request Timeout
	Code_ *string `locationName:"code" type:"string"`

	// Returned if, when uploading an archive, Amazon S3 Glacier times out while
	// receiving the upload.
	Message_ *string `locationName:"message" type:"string"`

	// Client
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s RequestTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestTimeoutException) GoString() string {
	return s.String()
}

func newErrorRequestTimeoutException(v protocol.ResponseMetadata) error {
	return &RequestTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTimeoutException) Code() string {
	return "RequestTimeoutException"
}

// Message returns the exception's message.
func (s *RequestTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTimeoutException) OrigErr() error {
	return nil
}

func (s *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the specified resource (such as a vault, upload ID, or job ID)
// doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 404 Not Found
	Code_ *string `locationName:"code" type:"string"`

	// Returned if the specified resource (such as a vault, upload ID, or job ID)
	// doesn't exist.
	Message_ *string `locationName:"message" type:"string"`

	// Client
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the location in Amazon S3 where the select job
// results are stored.
type S3Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []*Grant `type:"list"`

	// The name of the Amazon S3 bucket where the job results are stored.
	BucketName *string `type:"string"`

	// The canned access control list (ACL) to apply to the job results.
	CannedACL *string `type:"string" enum:"CannedACL"`

	// Contains information about the encryption used to store the job results in
	// Amazon S3.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the results for this request.
	Prefix *string `type:"string"`

	// The storage class used to store the job results.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// The tag-set that is applied to the job results.
	Tagging map[string]*string `type:"map"`

	// A map of metadata to store with the job results in Amazon S3.
	UserMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *S3Location) SetAccessControlList(v []*Grant) *S3Location {
	s.AccessControlList = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3Location) SetBucketName(v string) *S3Location {
	s.BucketName = &v
	return s
}

// SetCannedACL sets the CannedACL field's value.
func (s *S3Location) SetCannedACL(v string) *S3Location {
	s.CannedACL = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *S3Location) SetEncryption(v *Encryption) *S3Location {
	s.Encryption = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Location) SetPrefix(v string) *S3Location {
	s.Prefix = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *S3Location) SetStorageClass(v string) *S3Location {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *S3Location) SetTagging(v map[string]*string) *S3Location {
	s.Tagging = v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *S3Location) SetUserMetadata(v map[string]*string) *S3Location {
	s.UserMetadata = v
	return s
}

// Contains information about the parameters used for a select.
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to select the object.
	Expression *string `type:"string"`

	// The type of the provided expression, for example SQL.
	ExpressionType *string `type:"string" enum:"ExpressionType"`

	// Describes the serialization format of the object.
	InputSerialization *InputSerialization `type:"structure"`

	// Describes how the results of the select job are serialized.
	OutputSerialization *OutputSerialization `type:"structure"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectParameters) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *SelectParameters) SetExpression(v string) *SelectParameters {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *SelectParameters) SetExpressionType(v string) *SelectParameters {
	s.ExpressionType = &v
	return s
}

// SetInputSerialization sets the InputSerialization field's value.
func (s *SelectParameters) SetInputSerialization(v *InputSerialization) *SelectParameters {
	s.InputSerialization = v
	return s
}

// SetOutputSerialization sets the OutputSerialization field's value.
func (s *SelectParameters) SetOutputSerialization(v *OutputSerialization) *SelectParameters {
	s.OutputSerialization = v
	return s
}

// Returned if the service cannot complete the request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// 500 Internal Server Error
	Code_ *string `locationName:"code" type:"string"`

	// Returned if the service cannot complete the request.
	Message_ *string `locationName:"message" type:"string"`

	// Server
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// SetDataRetrievalPolicy input.
type SetDataRetrievalPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The data retrieval policy in JSON format.
	Policy *DataRetrievalPolicy `type:"structure"`
}

// String returns the string representation
func (s SetDataRetrievalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDataRetrievalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDataRetrievalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDataRetrievalPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *SetDataRetrievalPolicyInput) SetAccountId(v string) *SetDataRetrievalPolicyInput {
	s.AccountId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *SetDataRetrievalPolicyInput) SetPolicy(v *DataRetrievalPolicy) *SetDataRetrievalPolicyInput {
	s.Policy = v
	return s
}

type SetDataRetrievalPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDataRetrievalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDataRetrievalPolicyOutput) GoString() string {
	return s.String()
}

// SetVaultAccessPolicy input.
type SetVaultAccessPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The vault access policy as a JSON string.
	Policy *VaultAccessPolicy `locationName:"policy" type:"structure"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s SetVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVaultAccessPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *SetVaultAccessPolicyInput) SetAccountId(v string) *SetVaultAccessPolicyInput {
	s.AccountId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *SetVaultAccessPolicyInput) SetPolicy(v *VaultAccessPolicy) *SetVaultAccessPolicyInput {
	s.Policy = v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *SetVaultAccessPolicyInput) SetVaultName(v string) *SetVaultAccessPolicyInput {
	s.VaultName = &v
	return s
}

type SetVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// Provides options to configure notifications that will be sent when specific
// events happen to a vault.
type SetVaultNotificationsInput struct {
	_ struct{} `type:"structure" payload:"VaultNotificationConfig"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	// Provides options for specifying notification configuration.
	VaultNotificationConfig *VaultNotificationConfig `locationName:"vaultNotificationConfig" type:"structure"`
}

// String returns the string representation
func (s SetVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetVaultNotificationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *SetVaultNotificationsInput) SetAccountId(v string) *SetVaultNotificationsInput {
	s.AccountId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *SetVaultNotificationsInput) SetVaultName(v string) *SetVaultNotificationsInput {
	s.VaultName = &v
	return s
}

// SetVaultNotificationConfig sets the VaultNotificationConfig field's value.
func (s *SetVaultNotificationsInput) SetVaultNotificationConfig(v *VaultNotificationConfig) *SetVaultNotificationsInput {
	s.VaultNotificationConfig = v
	return s
}

type SetVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultNotificationsOutput) GoString() string {
	return s.String()
}

// Provides options to add an archive to a vault.
type UploadArchiveInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The optional description of the archive you are uploading.
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The data to upload.
	Body io.ReadSeeker `locationName:"body" type:"blob"`

	// The SHA256 tree hash of the data being uploaded.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadArchiveInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UploadArchiveInput) SetAccountId(v string) *UploadArchiveInput {
	s.AccountId = &v
	return s
}

// SetArchiveDescription sets the ArchiveDescription field's value.
func (s *UploadArchiveInput) SetArchiveDescription(v string) *UploadArchiveInput {
	s.ArchiveDescription = &v
	return s
}

// SetBody sets the Body field's value.
func (s *UploadArchiveInput) SetBody(v io.ReadSeeker) *UploadArchiveInput {
	s.Body = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *UploadArchiveInput) SetChecksum(v string) *UploadArchiveInput {
	s.Checksum = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *UploadArchiveInput) SetVaultName(v string) *UploadArchiveInput {
	s.VaultName = &v
	return s
}

// A list of in-progress multipart uploads for a vault.
type UploadListElement struct {
	_ struct{} `type:"structure"`

	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// The ID of a multipart upload.
	MultipartUploadId *string `type:"string"`

	// The part size, in bytes, specified in the Initiate Multipart Upload request.
	// This is the size of all the parts in the upload except the last part, which
	// may be smaller than this size.
	PartSizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault that contains the archive.
	VaultARN *string `type:"string"`
}

// String returns the string representation
func (s UploadListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadListElement) GoString() string {
	return s.String()
}

// SetArchiveDescription sets the ArchiveDescription field's value.
func (s *UploadListElement) SetArchiveDescription(v string) *UploadListElement {
	s.ArchiveDescription = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *UploadListElement) SetCreationDate(v string) *UploadListElement {
	s.CreationDate = &v
	return s
}

// SetMultipartUploadId sets the MultipartUploadId field's value.
func (s *UploadListElement) SetMultipartUploadId(v string) *UploadListElement {
	s.MultipartUploadId = &v
	return s
}

// SetPartSizeInBytes sets the PartSizeInBytes field's value.
func (s *UploadListElement) SetPartSizeInBytes(v int64) *UploadListElement {
	s.PartSizeInBytes = &v
	return s
}

// SetVaultARN sets the VaultARN field's value.
func (s *UploadListElement) SetVaultARN(v string) *UploadListElement {
	s.VaultARN = &v
	return s
}

// Provides options to upload a part of an archive in a multipart upload operation.
type UploadMultipartPartInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The data to upload.
	Body io.ReadSeeker `locationName:"body" type:"blob"`

	// The SHA256 tree hash of the data being uploaded.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// Identifies the range of bytes in the assembled archive that will be uploaded
	// in this part. Amazon S3 Glacier uses this information to assemble the archive
	// in the proper sequence. The format of this header follows RFC 2616. An example
	// header is Content-Range:bytes 0-4194303/*.
	Range *string `location:"header" locationName:"Content-Range" type:"string"`

	// The upload ID of the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadMultipartPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadMultipartPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadMultipartPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadMultipartPartInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}
	if s.VaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("VaultName"))
	}
	if s.VaultName != nil && len(*s.VaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UploadMultipartPartInput) SetAccountId(v string) *UploadMultipartPartInput {
	s.AccountId = &v
	return s
}

// SetBody sets the Body field's value.
func (s *UploadMultipartPartInput) SetBody(v io.ReadSeeker) *UploadMultipartPartInput {
	s.Body = v
	return s
}

// SetChecksum sets the Checksum field's value.
func (s *UploadMultipartPartInput) SetChecksum(v string) *UploadMultipartPartInput {
	s.Checksum = &v
	return s
}

// SetRange sets the Range field's value.
func (s *UploadMultipartPartInput) SetRange(v string) *UploadMultipartPartInput {
	s.Range = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadMultipartPartInput) SetUploadId(v string) *UploadMultipartPartInput {
	s.UploadId = &v
	return s
}

// SetVaultName sets the VaultName field's value.
func (s *UploadMultipartPartInput) SetVaultName(v string) *UploadMultipartPartInput {
	s.VaultName = &v
	return s
}

// Contains the Amazon S3 Glacier response to your request.
type UploadMultipartPartOutput struct {
	_ struct{} `type:"structure"`

	// The SHA256 tree hash that Amazon S3 Glacier computed for the uploaded part.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`
}

// String returns the string representation
func (s UploadMultipartPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadMultipartPartOutput) GoString() string {
	return s.String()
}

// SetChecksum sets the Checksum field's value.
func (s *UploadMultipartPartOutput) SetChecksum(v string) *UploadMultipartPartOutput {
	s.Checksum = &v
	return s
}

// Contains the vault access policy.
type VaultAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The vault access policy.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s VaultAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultAccessPolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *VaultAccessPolicy) SetPolicy(v string) *VaultAccessPolicy {
	s.Policy = &v
	return s
}

// Contains the vault lock policy.
type VaultLockPolicy struct {
	_ struct{} `type:"structure"`

	// The vault lock policy.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s VaultLockPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultLockPolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *VaultLockPolicy) SetPolicy(v string) *VaultLockPolicy {
	s.Policy = &v
	return s
}

// Represents a vault's notification configuration.
type VaultNotificationConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more events for which Amazon S3 Glacier will send a notification
	// to the specified Amazon SNS topic.
	Events []*string `type:"list"`

	// The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource
	// Name (ARN).
	SNSTopic *string `type:"string"`
}

// String returns the string representation
func (s VaultNotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultNotificationConfig) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *VaultNotificationConfig) SetEvents(v []*string) *VaultNotificationConfig {
	s.Events = v
	return s
}

// SetSNSTopic sets the SNSTopic field's value.
func (s *VaultNotificationConfig) SetSNSTopic(v string) *VaultNotificationConfig {
	s.SNSTopic = &v
	return s
}

const (
	// ActionCodeArchiveRetrieval is a ActionCode enum value
	ActionCodeArchiveRetrieval = "ArchiveRetrieval"

	// ActionCodeInventoryRetrieval is a ActionCode enum value
	ActionCodeInventoryRetrieval = "InventoryRetrieval"

	// ActionCodeSelect is a ActionCode enum value
	ActionCodeSelect = "Select"
)

// ActionCode_Values returns all elements of the ActionCode enum
func ActionCode_Values() []string {
	return []string{
		ActionCodeArchiveRetrieval,
		ActionCodeInventoryRetrieval,
		ActionCodeSelect,
	}
}

const (
	// CannedACLPrivate is a CannedACL enum value
	CannedACLPrivate = "private"

	// CannedACLPublicRead is a CannedACL enum value
	CannedACLPublicRead = "public-read"

	// CannedACLPublicReadWrite is a CannedACL enum value
	CannedACLPublicReadWrite = "public-read-write"

	// CannedACLAwsExecRead is a CannedACL enum value
	CannedACLAwsExecRead = "aws-exec-read"

	// CannedACLAuthenticatedRead is a CannedACL enum value
	CannedACLAuthenticatedRead = "authenticated-read"

	// CannedACLBucketOwnerRead is a CannedACL enum value
	CannedACLBucketOwnerRead = "bucket-owner-read"

	// CannedACLBucketOwnerFullControl is a CannedACL enum value
	CannedACLBucketOwnerFullControl = "bucket-owner-full-control"
)

// CannedACL_Values returns all elements of the CannedACL enum
func CannedACL_Values() []string {
	return []string{
		CannedACLPrivate,
		CannedACLPublicRead,
		CannedACLPublicReadWrite,
		CannedACLAwsExecRead,
		CannedACLAuthenticatedRead,
		CannedACLBucketOwnerRead,
		CannedACLBucketOwnerFullControl,
	}
}

const (
	// EncryptionTypeAwsKms is a EncryptionType enum value
	EncryptionTypeAwsKms = "aws:kms"

	// EncryptionTypeAes256 is a EncryptionType enum value
	EncryptionTypeAes256 = "AES256"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeAwsKms,
		EncryptionTypeAes256,
	}
}

const (
	// ExpressionTypeSql is a ExpressionType enum value
	ExpressionTypeSql = "SQL"
)

// ExpressionType_Values returns all elements of the ExpressionType enum
func ExpressionType_Values() []string {
	return []string{
		ExpressionTypeSql,
	}
}

const (
	// FileHeaderInfoUse is a FileHeaderInfo enum value
	FileHeaderInfoUse = "USE"

	// FileHeaderInfoIgnore is a FileHeaderInfo enum value
	FileHeaderInfoIgnore = "IGNORE"

	// FileHeaderInfoNone is a FileHeaderInfo enum value
	FileHeaderInfoNone = "NONE"
)

// FileHeaderInfo_Values returns all elements of the FileHeaderInfo enum
func FileHeaderInfo_Values() []string {
	return []string{
		FileHeaderInfoUse,
		FileHeaderInfoIgnore,
		FileHeaderInfoNone,
	}
}

const (
	// PermissionFullControl is a Permission enum value
	PermissionFullControl = "FULL_CONTROL"

	// PermissionWrite is a Permission enum value
	PermissionWrite = "WRITE"

	// PermissionWriteAcp is a Permission enum value
	PermissionWriteAcp = "WRITE_ACP"

	// PermissionRead is a Permission enum value
	PermissionRead = "READ"

	// PermissionReadAcp is a Permission enum value
	PermissionReadAcp = "READ_ACP"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionFullControl,
		PermissionWrite,
		PermissionWriteAcp,
		PermissionRead,
		PermissionReadAcp,
	}
}

const (
	// QuoteFieldsAlways is a QuoteFields enum value
	QuoteFieldsAlways = "ALWAYS"

	// QuoteFieldsAsneeded is a QuoteFields enum value
	QuoteFieldsAsneeded = "ASNEEDED"
)

// QuoteFields_Values returns all elements of the QuoteFields enum
func QuoteFields_Values() []string {
	return []string{
		QuoteFieldsAlways,
		QuoteFieldsAsneeded,
	}
}

const (
	// StatusCodeInProgress is a StatusCode enum value
	StatusCodeInProgress = "InProgress"

	// StatusCodeSucceeded is a StatusCode enum value
	StatusCodeSucceeded = "Succeeded"

	// StatusCodeFailed is a StatusCode enum value
	StatusCodeFailed = "Failed"
)

// StatusCode_Values returns all elements of the StatusCode enum
func StatusCode_Values() []string {
	return []string{
		StatusCodeInProgress,
		StatusCodeSucceeded,
		StatusCodeFailed,
	}
}

const (
	// StorageClassStandard is a StorageClass enum value
	StorageClassStandard = "STANDARD"

	// StorageClassReducedRedundancy is a StorageClass enum value
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"
)

// StorageClass_Values returns all elements of the StorageClass enum
func StorageClass_Values() []string {
	return []string{
		StorageClassStandard,
		StorageClassReducedRedundancy,
		StorageClassStandardIa,
	}
}

const (
	// TypeAmazonCustomerByEmail is a Type enum value
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"

	// TypeCanonicalUser is a Type enum value
	TypeCanonicalUser = "CanonicalUser"

	// TypeGroup is a Type enum value
	TypeGroup = "Group"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeAmazonCustomerByEmail,
		TypeCanonicalUser,
		TypeGroup,
	}
}
