// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribeservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateLanguageModel = "CreateLanguageModel"

// CreateLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLanguageModel for more information on using the CreateLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLanguageModelRequest method.
//    req, resp := client.CreateLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModelRequest(input *CreateLanguageModelInput) (req *request.Request, output *CreateLanguageModelOutput) {
	op := &request.Operation{
		Name:       opCreateLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLanguageModelInput{}
	}

	output = &CreateLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLanguageModel API operation for Amazon Transcribe Service.
//
// Creates a new custom language model. Use Amazon S3 prefixes to provide the
// location of your input files. The time it takes to create your model depends
// on the size of your training data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModel(input *CreateLanguageModelInput) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	return out, req.Send()
}

// CreateLanguageModelWithContext is the same as CreateLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateLanguageModelWithContext(ctx aws.Context, input *CreateLanguageModelInput, opts ...request.Option) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMedicalVocabulary = "CreateMedicalVocabulary"

// CreateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMedicalVocabulary for more information on using the CreateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMedicalVocabularyRequest method.
//    req, resp := client.CreateMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabularyRequest(input *CreateMedicalVocabularyInput) (req *request.Request, output *CreateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMedicalVocabularyInput{}
	}

	output = &CreateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary that you can use to change how Amazon Transcribe
// Medical transcribes your audio file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabulary(input *CreateMedicalVocabularyInput) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// CreateMedicalVocabularyWithContext is the same as CreateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateMedicalVocabularyWithContext(ctx aws.Context, input *CreateMedicalVocabularyInput, opts ...request.Option) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabulary = "CreateVocabulary"

// CreateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabulary for more information on using the CreateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVocabularyRequest method.
//    req, resp := client.CreateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabularyRequest(input *CreateVocabularyInput) (req *request.Request, output *CreateVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyInput{}
	}

	output = &CreateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary that you can use to change the way Amazon
// Transcribe handles transcription of an audio file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabulary(input *CreateVocabularyInput) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	return out, req.Send()
}

// CreateVocabularyWithContext is the same as CreateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyWithContext(ctx aws.Context, input *CreateVocabularyInput, opts ...request.Option) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabularyFilter = "CreateVocabularyFilter"

// CreateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabularyFilter for more information on using the CreateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVocabularyFilterRequest method.
//    req, resp := client.CreateVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilterRequest(input *CreateVocabularyFilterInput) (req *request.Request, output *CreateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opCreateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyFilterInput{}
	}

	output = &CreateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Creates a new vocabulary filter that you can use to filter words, such as
// profane words, from the output of a transcription job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilter(input *CreateVocabularyFilterInput) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	return out, req.Send()
}

// CreateVocabularyFilterWithContext is the same as CreateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyFilterWithContext(ctx aws.Context, input *CreateVocabularyFilterInput, opts ...request.Option) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLanguageModel = "DeleteLanguageModel"

// DeleteLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLanguageModel for more information on using the DeleteLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLanguageModelRequest method.
//    req, resp := client.DeleteLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModelRequest(input *DeleteLanguageModelInput) (req *request.Request, output *DeleteLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDeleteLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLanguageModelInput{}
	}

	output = &DeleteLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLanguageModel API operation for Amazon Transcribe Service.
//
// Deletes a custom language model using its name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModel(input *DeleteLanguageModelInput) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	return out, req.Send()
}

// DeleteLanguageModelWithContext is the same as DeleteLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteLanguageModelWithContext(ctx aws.Context, input *DeleteLanguageModelInput, opts ...request.Option) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalTranscriptionJob = "DeleteMedicalTranscriptionJob"

// DeleteMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalTranscriptionJob for more information on using the DeleteMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMedicalTranscriptionJobRequest method.
//    req, resp := client.DeleteMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJobRequest(input *DeleteMedicalTranscriptionJobInput) (req *request.Request, output *DeleteMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalTranscriptionJobInput{}
	}

	output = &DeleteMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a transcription job generated by Amazon Transcribe Medical and any
// related information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJob(input *DeleteMedicalTranscriptionJobInput) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteMedicalTranscriptionJobWithContext is the same as DeleteMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalTranscriptionJobWithContext(ctx aws.Context, input *DeleteMedicalTranscriptionJobInput, opts ...request.Option) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalVocabulary = "DeleteMedicalVocabulary"

// DeleteMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalVocabulary for more information on using the DeleteMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMedicalVocabularyRequest method.
//    req, resp := client.DeleteMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabularyRequest(input *DeleteMedicalVocabularyInput) (req *request.Request, output *DeleteMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalVocabularyInput{}
	}

	output = &DeleteMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a vocabulary from Amazon Transcribe Medical.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabulary(input *DeleteMedicalVocabularyInput) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	return out, req.Send()
}

// DeleteMedicalVocabularyWithContext is the same as DeleteMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalVocabularyWithContext(ctx aws.Context, input *DeleteMedicalVocabularyInput, opts ...request.Option) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTranscriptionJob = "DeleteTranscriptionJob"

// DeleteTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTranscriptionJob for more information on using the DeleteTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTranscriptionJobRequest method.
//    req, resp := client.DeleteTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJobRequest(input *DeleteTranscriptionJobInput) (req *request.Request, output *DeleteTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTranscriptionJobInput{}
	}

	output = &DeleteTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a previously submitted transcription job along with any other generated
// results such as the transcription, models, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJob(input *DeleteTranscriptionJobInput) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteTranscriptionJobWithContext is the same as DeleteTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteTranscriptionJobWithContext(ctx aws.Context, input *DeleteTranscriptionJobInput, opts ...request.Option) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabulary for more information on using the DeleteVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVocabularyRequest method.
//    req, resp := client.DeleteVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabularyRequest(input *DeleteVocabularyInput) (req *request.Request, output *DeleteVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	output = &DeleteVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a vocabulary from Amazon Transcribe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabulary(input *DeleteVocabularyInput) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	return out, req.Send()
}

// DeleteVocabularyWithContext is the same as DeleteVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyWithContext(ctx aws.Context, input *DeleteVocabularyInput, opts ...request.Option) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabularyFilter = "DeleteVocabularyFilter"

// DeleteVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabularyFilter for more information on using the DeleteVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVocabularyFilterRequest method.
//    req, resp := client.DeleteVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilterRequest(input *DeleteVocabularyFilterInput) (req *request.Request, output *DeleteVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyFilterInput{}
	}

	output = &DeleteVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabularyFilter API operation for Amazon Transcribe Service.
//
// Removes a vocabulary filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilter(input *DeleteVocabularyFilterInput) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	return out, req.Send()
}

// DeleteVocabularyFilterWithContext is the same as DeleteVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyFilterWithContext(ctx aws.Context, input *DeleteVocabularyFilterInput, opts ...request.Option) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLanguageModel = "DescribeLanguageModel"

// DescribeLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLanguageModel for more information on using the DescribeLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLanguageModelRequest method.
//    req, resp := client.DescribeLanguageModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModelRequest(input *DescribeLanguageModelInput) (req *request.Request, output *DescribeLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDescribeLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLanguageModelInput{}
	}

	output = &DescribeLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLanguageModel API operation for Amazon Transcribe Service.
//
// Gets information about a single custom language model. Use this information
// to see details about the language model in your AWS account. You can also
// see whether the base language model used to create your custom language model
// has been updated. If Amazon Transcribe has updated the base model, you can
// create a new custom language model using the updated base model. If the language
// model wasn't created, you can use this operation to understand why Amazon
// Transcribe couldn't create it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DescribeLanguageModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModel(input *DescribeLanguageModelInput) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	return out, req.Send()
}

// DescribeLanguageModelWithContext is the same as DescribeLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DescribeLanguageModelWithContext(ctx aws.Context, input *DescribeLanguageModelInput, opts ...request.Option) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalTranscriptionJob = "GetMedicalTranscriptionJob"

// GetMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalTranscriptionJob for more information on using the GetMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMedicalTranscriptionJobRequest method.
//    req, resp := client.GetMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJobRequest(input *GetMedicalTranscriptionJobInput) (req *request.Request, output *GetMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalTranscriptionJobInput{}
	}

	output = &GetMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Returns information about a transcription job from Amazon Transcribe Medical.
// To see the status of the job, check the TranscriptionJobStatus field. If
// the status is COMPLETED, the job is finished. You find the results of the
// completed job in the TranscriptFileUri field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJob(input *GetMedicalTranscriptionJobInput) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetMedicalTranscriptionJobWithContext is the same as GetMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalTranscriptionJobWithContext(ctx aws.Context, input *GetMedicalTranscriptionJobInput, opts ...request.Option) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalVocabulary = "GetMedicalVocabulary"

// GetMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalVocabulary for more information on using the GetMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMedicalVocabularyRequest method.
//    req, resp := client.GetMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabularyRequest(input *GetMedicalVocabularyInput) (req *request.Request, output *GetMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalVocabularyInput{}
	}

	output = &GetMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Retrieves information about a medical vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabulary(input *GetMedicalVocabularyInput) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	return out, req.Send()
}

// GetMedicalVocabularyWithContext is the same as GetMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalVocabularyWithContext(ctx aws.Context, input *GetMedicalVocabularyInput, opts ...request.Option) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscriptionJob = "GetTranscriptionJob"

// GetTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscriptionJob for more information on using the GetTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTranscriptionJobRequest method.
//    req, resp := client.GetTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJobRequest(input *GetTranscriptionJobInput) (req *request.Request, output *GetTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTranscriptionJobInput{}
	}

	output = &GetTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscriptionJob API operation for Amazon Transcribe Service.
//
// Returns information about a transcription job. To see the status of the job,
// check the TranscriptionJobStatus field. If the status is COMPLETED, the job
// is finished and you can find the results at the location specified in the
// TranscriptFileUri field. If you enable content redaction, the redacted transcript
// appears in RedactedTranscriptFileUri.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJob(input *GetTranscriptionJobInput) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetTranscriptionJobWithContext is the same as GetTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetTranscriptionJobWithContext(ctx aws.Context, input *GetTranscriptionJobInput, opts ...request.Option) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabulary = "GetVocabulary"

// GetVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabulary for more information on using the GetVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVocabularyRequest method.
//    req, resp := client.GetVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabularyRequest(input *GetVocabularyInput) (req *request.Request, output *GetVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyInput{}
	}

	output = &GetVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabulary API operation for Amazon Transcribe Service.
//
// Gets information about a vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabulary for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabulary(input *GetVocabularyInput) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	return out, req.Send()
}

// GetVocabularyWithContext is the same as GetVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyWithContext(ctx aws.Context, input *GetVocabularyInput, opts ...request.Option) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabularyFilter = "GetVocabularyFilter"

// GetVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabularyFilter for more information on using the GetVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVocabularyFilterRequest method.
//    req, resp := client.GetVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilterRequest(input *GetVocabularyFilterInput) (req *request.Request, output *GetVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opGetVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyFilterInput{}
	}

	output = &GetVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabularyFilter API operation for Amazon Transcribe Service.
//
// Returns information about a vocabulary filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilter(input *GetVocabularyFilterInput) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	return out, req.Send()
}

// GetVocabularyFilterWithContext is the same as GetVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyFilterWithContext(ctx aws.Context, input *GetVocabularyFilterInput, opts ...request.Option) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLanguageModels = "ListLanguageModels"

// ListLanguageModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListLanguageModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLanguageModels for more information on using the ListLanguageModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLanguageModelsRequest method.
//    req, resp := client.ListLanguageModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModelsRequest(input *ListLanguageModelsInput) (req *request.Request, output *ListLanguageModelsOutput) {
	op := &request.Operation{
		Name:       opListLanguageModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLanguageModelsInput{}
	}

	output = &ListLanguageModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLanguageModels API operation for Amazon Transcribe Service.
//
// Provides more information about the custom language models you've created.
// You can use the information in this list to find a specific custom language
// model. You can then use the operation to get more information about it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListLanguageModels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModels(input *ListLanguageModelsInput) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	return out, req.Send()
}

// ListLanguageModelsWithContext is the same as ListLanguageModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListLanguageModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsWithContext(ctx aws.Context, input *ListLanguageModelsInput, opts ...request.Option) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLanguageModelsPages iterates over the pages of a ListLanguageModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLanguageModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLanguageModels operation.
//    pageNum := 0
//    err := client.ListLanguageModelsPages(params,
//        func(page *transcribeservice.ListLanguageModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListLanguageModelsPages(input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool) error {
	return c.ListLanguageModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLanguageModelsPagesWithContext same as ListLanguageModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsPagesWithContext(ctx aws.Context, input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLanguageModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLanguageModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLanguageModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalTranscriptionJobs = "ListMedicalTranscriptionJobs"

// ListMedicalTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalTranscriptionJobs for more information on using the ListMedicalTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMedicalTranscriptionJobsRequest method.
//    req, resp := client.ListMedicalTranscriptionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobsRequest(input *ListMedicalTranscriptionJobsInput) (req *request.Request, output *ListMedicalTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListMedicalTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalTranscriptionJobsInput{}
	}

	output = &ListMedicalTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Lists medical transcription jobs with a specified status or substring that
// matches their names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobs(input *ListMedicalTranscriptionJobsInput) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsWithContext is the same as ListMedicalTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, opts ...request.Option) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsPages iterates over the pages of a ListMedicalTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMedicalTranscriptionJobs operation.
//    pageNum := 0
//    err := client.ListMedicalTranscriptionJobsPages(params,
//        func(page *transcribeservice.ListMedicalTranscriptionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListMedicalTranscriptionJobsPages(input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool) error {
	return c.ListMedicalTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalTranscriptionJobsPagesWithContext same as ListMedicalTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalVocabularies = "ListMedicalVocabularies"

// ListMedicalVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalVocabularies for more information on using the ListMedicalVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMedicalVocabulariesRequest method.
//    req, resp := client.ListMedicalVocabulariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabulariesRequest(input *ListMedicalVocabulariesInput) (req *request.Request, output *ListMedicalVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListMedicalVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalVocabulariesInput{}
	}

	output = &ListMedicalVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalVocabularies API operation for Amazon Transcribe Service.
//
// Returns a list of vocabularies that match the specified criteria. If you
// don't enter a value in any of the request parameters, returns the entire
// list of vocabularies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalVocabularies for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabularies(input *ListMedicalVocabulariesInput) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	return out, req.Send()
}

// ListMedicalVocabulariesWithContext is the same as ListMedicalVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, opts ...request.Option) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalVocabulariesPages iterates over the pages of a ListMedicalVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMedicalVocabularies operation.
//    pageNum := 0
//    err := client.ListMedicalVocabulariesPages(params,
//        func(page *transcribeservice.ListMedicalVocabulariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListMedicalVocabulariesPages(input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool) error {
	return c.ListMedicalVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalVocabulariesPagesWithContext same as ListMedicalVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesPagesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTranscriptionJobs = "ListTranscriptionJobs"

// ListTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTranscriptionJobs for more information on using the ListTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTranscriptionJobsRequest method.
//    req, resp := client.ListTranscriptionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobsRequest(input *ListTranscriptionJobsInput) (req *request.Request, output *ListTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTranscriptionJobsInput{}
	}

	output = &ListTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Lists transcription jobs with the specified status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobs(input *ListTranscriptionJobsInput) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListTranscriptionJobsWithContext is the same as ListTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, opts ...request.Option) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTranscriptionJobsPages iterates over the pages of a ListTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTranscriptionJobs operation.
//    pageNum := 0
//    err := client.ListTranscriptionJobsPages(params,
//        func(page *transcribeservice.ListTranscriptionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListTranscriptionJobsPages(input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool) error {
	return c.ListTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTranscriptionJobsPagesWithContext same as ListTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularies = "ListVocabularies"

// ListVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularies for more information on using the ListVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVocabulariesRequest method.
//    req, resp := client.ListVocabulariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabulariesRequest(input *ListVocabulariesInput) (req *request.Request, output *ListVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabulariesInput{}
	}

	output = &ListVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularies API operation for Amazon Transcribe Service.
//
// Returns a list of vocabularies that match the specified criteria. If no criteria
// are specified, returns the entire list of vocabularies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularies for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabularies(input *ListVocabulariesInput) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	return out, req.Send()
}

// ListVocabulariesWithContext is the same as ListVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesWithContext(ctx aws.Context, input *ListVocabulariesInput, opts ...request.Option) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabulariesPages iterates over the pages of a ListVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVocabularies operation.
//    pageNum := 0
//    err := client.ListVocabulariesPages(params,
//        func(page *transcribeservice.ListVocabulariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListVocabulariesPages(input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool) error {
	return c.ListVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabulariesPagesWithContext same as ListVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesPagesWithContext(ctx aws.Context, input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularyFilters = "ListVocabularyFilters"

// ListVocabularyFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularyFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularyFilters for more information on using the ListVocabularyFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVocabularyFiltersRequest method.
//    req, resp := client.ListVocabularyFiltersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFiltersRequest(input *ListVocabularyFiltersInput) (req *request.Request, output *ListVocabularyFiltersOutput) {
	op := &request.Operation{
		Name:       opListVocabularyFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabularyFiltersInput{}
	}

	output = &ListVocabularyFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularyFilters API operation for Amazon Transcribe Service.
//
// Gets information about vocabulary filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularyFilters for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFilters(input *ListVocabularyFiltersInput) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	return out, req.Send()
}

// ListVocabularyFiltersWithContext is the same as ListVocabularyFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularyFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, opts ...request.Option) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabularyFiltersPages iterates over the pages of a ListVocabularyFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularyFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVocabularyFilters operation.
//    pageNum := 0
//    err := client.ListVocabularyFiltersPages(params,
//        func(page *transcribeservice.ListVocabularyFiltersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListVocabularyFiltersPages(input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool) error {
	return c.ListVocabularyFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabularyFiltersPagesWithContext same as ListVocabularyFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersPagesWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabularyFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabularyFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabularyFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartMedicalTranscriptionJob = "StartMedicalTranscriptionJob"

// StartMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMedicalTranscriptionJob for more information on using the StartMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMedicalTranscriptionJobRequest method.
//    req, resp := client.StartMedicalTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJobRequest(input *StartMedicalTranscriptionJobInput) (req *request.Request, output *StartMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMedicalTranscriptionJobInput{}
	}

	output = &StartMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Starts a batch job to transcribe medical speech to text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJob(input *StartMedicalTranscriptionJobInput) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartMedicalTranscriptionJobWithContext is the same as StartMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartMedicalTranscriptionJobWithContext(ctx aws.Context, input *StartMedicalTranscriptionJobInput, opts ...request.Option) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTranscriptionJob = "StartTranscriptionJob"

// StartTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTranscriptionJob for more information on using the StartTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTranscriptionJobRequest method.
//    req, resp := client.StartTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJobRequest(input *StartTranscriptionJobInput) (req *request.Request, output *StartTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTranscriptionJobInput{}
	}

	output = &StartTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTranscriptionJob API operation for Amazon Transcribe Service.
//
// Starts an asynchronous job to transcribe speech to text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartTranscriptionJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJob(input *StartTranscriptionJobInput) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartTranscriptionJobWithContext is the same as StartTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartTranscriptionJobWithContext(ctx aws.Context, input *StartTranscriptionJobInput, opts ...request.Option) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMedicalVocabulary = "UpdateMedicalVocabulary"

// UpdateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMedicalVocabulary for more information on using the UpdateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMedicalVocabularyRequest method.
//    req, resp := client.UpdateMedicalVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabularyRequest(input *UpdateMedicalVocabularyInput) (req *request.Request, output *UpdateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMedicalVocabularyInput{}
	}

	output = &UpdateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Updates a vocabulary with new values that you provide in a different text
// file from the one you used to create the vocabulary. The UpdateMedicalVocabulary
// operation overwrites all of the existing information with the values that
// you provide in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabulary(input *UpdateMedicalVocabularyInput) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// UpdateMedicalVocabularyWithContext is the same as UpdateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateMedicalVocabularyWithContext(ctx aws.Context, input *UpdateMedicalVocabularyInput, opts ...request.Option) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabulary = "UpdateVocabulary"

// UpdateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabulary for more information on using the UpdateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVocabularyRequest method.
//    req, resp := client.UpdateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabularyRequest(input *UpdateVocabularyInput) (req *request.Request, output *UpdateVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyInput{}
	}

	output = &UpdateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabulary API operation for Amazon Transcribe Service.
//
// Updates an existing vocabulary with new values. The UpdateVocabulary operation
// overwrites all of the existing information with the values that you provide
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabulary for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ConflictException
//   There is already a resource with that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabulary(input *UpdateVocabularyInput) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	return out, req.Send()
}

// UpdateVocabularyWithContext is the same as UpdateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyWithContext(ctx aws.Context, input *UpdateVocabularyInput, opts ...request.Option) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabularyFilter = "UpdateVocabularyFilter"

// UpdateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabularyFilter for more information on using the UpdateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVocabularyFilterRequest method.
//    req, resp := client.UpdateVocabularyFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilterRequest(input *UpdateVocabularyFilterInput) (req *request.Request, output *UpdateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyFilterInput{}
	}

	output = &UpdateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Updates a vocabulary filter with a new list of filtered words.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Your request didn't pass one or more validation tests. For example, if the
//   entity that you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * LimitExceededException
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * InternalFailureException
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * NotFoundException
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilter(input *UpdateVocabularyFilterInput) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	return out, req.Send()
}

// UpdateVocabularyFilterWithContext is the same as UpdateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyFilterWithContext(ctx aws.Context, input *UpdateVocabularyFilterInput, opts ...request.Option) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Your request didn't pass one or more validation tests. For example, if the
// entity that you're trying to delete doesn't exist or if it is in a non-terminal
// state (for example, it's "in progress"). See the exception Message field
// for more information.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There is already a resource with that name.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings for content redaction within a transcription job.
type ContentRedaction struct {
	_ struct{} `type:"structure"`

	// The output transcript file stored in either the default S3 bucket or in a
	// bucket you specify.
	//
	// When you choose redacted Amazon Transcribe outputs only the redacted transcript.
	//
	// When you choose redacted_and_unredacted Amazon Transcribe outputs both the
	// redacted and unredacted transcripts.
	//
	// RedactionOutput is a required field
	RedactionOutput *string `type:"string" required:"true" enum:"RedactionOutput"`

	// Request parameter that defines the entities to be redacted. The only accepted
	// value is PII.
	//
	// RedactionType is a required field
	RedactionType *string `type:"string" required:"true" enum:"RedactionType"`
}

// String returns the string representation
func (s ContentRedaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentRedaction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentRedaction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentRedaction"}
	if s.RedactionOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionOutput"))
	}
	if s.RedactionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRedactionOutput sets the RedactionOutput field's value.
func (s *ContentRedaction) SetRedactionOutput(v string) *ContentRedaction {
	s.RedactionOutput = &v
	return s
}

// SetRedactionType sets the RedactionType field's value.
func (s *ContentRedaction) SetRedactionType(v string) *ContentRedaction {
	s.RedactionType = &v
	return s
}

type CreateLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model used to create
	// your custom language model.
	//
	// If you want to use your custom language model to transcribe audio with a
	// sample rate of 16 kHz or greater, choose Wideband.
	//
	// If you want to use your custom language model to transcribe audio with a
	// sample rate that is less than 16 kHz, choose Narrowband.
	//
	// BaseModelName is a required field
	BaseModelName *string `type:"string" required:"true" enum:"BaseModelName"`

	// Contains the data access role and the Amazon S3 prefixes to read the required
	// input files to create a custom language model.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The language of the input text you're using to train your custom language
	// model.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"CLMLanguageCode"`

	// The name you choose for your custom language model when you create it.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLanguageModelInput"}
	if s.BaseModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseModelName"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelInput) SetBaseModelName(v string) *CreateLanguageModelInput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelInput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelInput) SetLanguageCode(v string) *CreateLanguageModelInput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelInput) SetModelName(v string) *CreateLanguageModelInput {
	s.ModelName = &v
	return s
}

type CreateLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model you've used
	// to create a custom language model.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// The data access role and Amazon S3 prefixes you've chosen to create your
	// custom language model.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code of the text you've used to create a custom language model.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The name you've chosen for your custom language model.
	ModelName *string `min:"1" type:"string"`

	// The status of the custom language model. When the status is COMPLETED the
	// model is ready to use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation
func (s CreateLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLanguageModelOutput) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelOutput) SetBaseModelName(v string) *CreateLanguageModelOutput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelOutput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelOutput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelOutput) SetLanguageCode(v string) *CreateLanguageModelOutput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelOutput) SetModelName(v string) *CreateLanguageModelOutput {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *CreateLanguageModelOutput) SetModelStatus(v string) *CreateLanguageModelOutput {
	s.ModelStatus = &v
	return s
}

type CreateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language used for the entries in your custom vocabulary.
	// The language code of your custom vocabulary must match the language code
	// of your transcription job. US English (en-US) is the only language code available
	// for Amazon Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The location in Amazon S3 of the text file you use to define your custom
	// vocabulary. The URI must be in the same AWS Region as the resource that you're
	// calling. Enter information about your VocabularyFileUri in the following
	// format:
	//
	// https://s3.<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// The following is an example URI for a vocabulary file that is stored in Amazon
	// S3:
	//
	// https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt
	//
	// For more information about Amazon S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Medical Custom Vocabularies
	// (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary-med).
	//
	// VocabularyFileUri is a required field
	VocabularyFileUri *string `min:"1" type:"string" required:"true"`

	// The name of the custom vocabulary. This case-sensitive name must be unique
	// within an AWS account. If you try to create a vocabulary with the same name
	// as a previous vocabulary, you get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFileUri"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyInput) SetLanguageCode(v string) *CreateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyFileUri(v string) *CreateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyName(v string) *CreateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code for the entries in your custom vocabulary. US English (en-US)
	// is the only valid language code for Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that you created the vocabulary.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary. The name must be unique within an AWS account
	// and is case sensitive.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary in Amazon Transcribe Medical.
	// If the state is READY, you can use the vocabulary in a StartMedicalTranscriptionJob
	// request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s CreateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateMedicalVocabularyOutput) SetFailureReason(v string) *CreateMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyOutput) SetLanguageCode(v string) *CreateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyName(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyState(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type CreateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter. All words in the
	// filter must be in the same language. The vocabulary filter can only be used
	// with transcription jobs in the specified language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The Amazon S3 location of a text file used as input to create the vocabulary
	// filter. Only use characters from the character set defined for custom vocabularies.
	// For a list of character sets, see Character Sets for Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets).
	//
	// The specified file must be less than 50 KB of UTF-8 characters.
	//
	// If you provide the location of a list of words in the VocabularyFilterFileUri
	// parameter, you can't use the Words parameter.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// The vocabulary filter name. The name must be unique within the account that
	// contains it. If you try to create a vocabulary filter with the same name
	// as another vocabulary filter, you get a ConflictException error.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// The words to use in the vocabulary filter. Only use characters from the character
	// set defined for custom vocabularies. For a list of character sets, see Character
	// Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets).
	//
	// If you provide a list of words in the Words parameter, you can't use the
	// VocabularyFilterFileUri parameter.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyFilterInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterInput) SetLanguageCode(v string) *CreateVocabularyFilterInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterName(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *CreateVocabularyFilterInput) SetWords(v []*string) *CreateVocabularyFilterInput {
	s.Words = v
	return s
}

type CreateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the collection.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary filter was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterOutput) SetLanguageCode(v string) *CreateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterOutput) SetVocabularyFilterName(v string) *CreateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type CreateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An array of strings that contains the vocabulary entries.
	Phrases []*string `type:"list"`

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you
	// are calling. The general form is
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Custom Vocabularies (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary. The name must be unique within an AWS account.
	// The name is case sensitive. If you try to create a vocabulary with the same
	// name as a previous vocabulary you will receive a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyInput) SetLanguageCode(v string) *CreateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *CreateVocabularyInput) SetPhrases(v []*string) *CreateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateVocabularyInput) SetVocabularyFileUri(v string) *CreateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyInput) SetVocabularyName(v string) *CreateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was created.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s CreateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateVocabularyOutput) SetFailureReason(v string) *CreateVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyOutput) SetLanguageCode(v string) *CreateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyOutput) SetVocabularyName(v string) *CreateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateVocabularyOutput) SetVocabularyState(v string) *CreateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type DeleteLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the model you're choosing to delete.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteLanguageModelInput) SetModelName(v string) *DeleteLanguageModelInput {
	s.ModelName = &v
	return s
}

type DeleteLanguageModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLanguageModelOutput) GoString() string {
	return s.String()
}

type DeleteMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name you provide to the DeleteMedicalTranscriptionJob object to delete
	// a transcription job.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *DeleteMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *DeleteMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type DeleteMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary that you want to delete.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteMedicalVocabularyInput) SetVocabularyName(v string) *DeleteMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMedicalVocabularyOutput) GoString() string {
	return s.String()
}

type DeleteTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transcription job to be deleted.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *DeleteTranscriptionJobInput) SetTranscriptionJobName(v string) *DeleteTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type DeleteTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary filter to remove.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *DeleteVocabularyFilterInput) SetVocabularyFilterName(v string) *DeleteVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type DeleteVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyFilterOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to delete.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteVocabularyInput) SetVocabularyName(v string) *DeleteVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyOutput) GoString() string {
	return s.String()
}

type DescribeLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you submit to get more information.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeLanguageModelInput) SetModelName(v string) *DescribeLanguageModelInput {
	s.ModelName = &v
	return s
}

type DescribeLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you requested more information about.
	LanguageModel *LanguageModel `type:"structure"`
}

// String returns the string representation
func (s DescribeLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLanguageModelOutput) GoString() string {
	return s.String()
}

// SetLanguageModel sets the LanguageModel field's value.
func (s *DescribeLanguageModelOutput) SetLanguageModel(v *LanguageModel) *DescribeLanguageModelOutput {
	s.LanguageModel = v
	return s
}

type GetMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *GetMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *GetMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type GetMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the medical transcription job.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s GetMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *GetMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *GetMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type GetMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary that you want information about. The value is
	// case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyInput) SetVocabularyName(v string) *GetMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where the vocabulary is stored. Use this URI to
	// get the contents of the vocabulary. You can download your vocabulary from
	// the URI for a limited time.
	DownloadUri *string `min:"1" type:"string"`

	// If the VocabularyState is FAILED, this field contains information about why
	// the job failed.
	FailureReason *string `type:"string"`

	// The valid language code for your vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified with a text file
	// different from the one that was previously used.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary returned by Amazon Transcribe Medical.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. If the VocabularyState is READY then
	// you can use it in the StartMedicalTranscriptionJob operation.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s GetMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetMedicalVocabularyOutput) SetDownloadUri(v string) *GetMedicalVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetMedicalVocabularyOutput) SetFailureReason(v string) *GetMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetMedicalVocabularyOutput) SetLanguageCode(v string) *GetMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *GetMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyName(v string) *GetMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyState(v string) *GetMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type GetTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the job.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *GetTranscriptionJobInput) SetTranscriptionJobName(v string) *GetTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type GetTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s GetTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *GetTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *GetTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

type GetVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary filter for which to return information.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterInput) SetVocabularyFilterName(v string) *GetVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The URI of the list of words in the vocabulary filter. You can use this URI
	// to get the list of words.
	DownloadUri *string `min:"1" type:"string"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the contents of the vocabulary filter were updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyFilterOutput) SetDownloadUri(v string) *GetVocabularyFilterOutput {
	s.DownloadUri = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyFilterOutput) SetLanguageCode(v string) *GetVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *GetVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterOutput) SetVocabularyFilterName(v string) *GetVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to return information about. The name is case
	// sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyInput) SetVocabularyName(v string) *GetVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the vocabulary is stored. Use this URI to get the contents
	// of the vocabulary. The URI is available for a limited time.
	DownloadUri *string `min:"1" type:"string"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary to return.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s GetVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyOutput) SetDownloadUri(v string) *GetVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetVocabularyOutput) SetFailureReason(v string) *GetVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyOutput) SetLanguageCode(v string) *GetVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyOutput) SetLastModifiedTime(v time.Time) *GetVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyOutput) SetVocabularyName(v string) *GetVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetVocabularyOutput) SetVocabularyState(v string) *GetVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// The object that contains the Amazon S3 object location and access role required
// to train and tune your custom language model.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the permissions you've
	// given Amazon Transcribe to access your Amazon S3 buckets containing your
	// media files or text data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon S3 prefix you specify to access the plain text files that you
	// use to train your custom language model.
	//
	// S3Uri is a required field
	S3Uri *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 prefix you specify to access the plain text files that you
	// use to tune your custom language model.
	TuningDataS3Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}
	if s.TuningDataS3Uri != nil && len(*s.TuningDataS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TuningDataS3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *InputDataConfig) SetDataAccessRoleArn(v string) *InputDataConfig {
	s.DataAccessRoleArn = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// SetTuningDataS3Uri sets the TuningDataS3Uri field's value.
func (s *InputDataConfig) SetTuningDataS3Uri(v string) *InputDataConfig {
	s.TuningDataS3Uri = &v
	return s
}

// There was an internal error. Check the error message and try your request
// again.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about when a transcription job should be executed.
type JobExecutionSettings struct {
	_ struct{} `type:"structure"`

	// Indicates whether a job should be queued by Amazon Transcribe when the concurrent
	// execution limit is exceeded. When the AllowDeferredExecution field is true,
	// jobs are queued and executed when the number of executing jobs falls below
	// the concurrent execution limit. If the field is false, Amazon Transcribe
	// returns a LimitExceededException exception.
	//
	// If you specify the AllowDeferredExecution field, you must specify the DataAccessRoleArn
	// field.
	AllowDeferredExecution *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of a role that has access to the S3 bucket
	// that contains the input files. Amazon Transcribe assumes this role to read
	// queued media files. If you have specified an output S3 bucket for the transcription
	// results, this role should have access to the output bucket as well.
	//
	// If you specify the AllowDeferredExecution field, you must specify the DataAccessRoleArn
	// field.
	DataAccessRoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s JobExecutionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobExecutionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobExecutionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobExecutionSettings"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowDeferredExecution sets the AllowDeferredExecution field's value.
func (s *JobExecutionSettings) SetAllowDeferredExecution(v bool) *JobExecutionSettings {
	s.AllowDeferredExecution = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *JobExecutionSettings) SetDataAccessRoleArn(v string) *JobExecutionSettings {
	s.DataAccessRoleArn = &v
	return s
}

// The structure used to describe a custom language model.
type LanguageModel struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model used to create
	// the custom language model.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// The time the custom language model was created.
	CreateTime *time.Time `type:"timestamp"`

	// The reason why the custom language model couldn't be created.
	FailureReason *string `type:"string"`

	// The data access role and Amazon S3 prefixes for the input files used to train
	// the custom language model.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code you used to create your custom language model.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The most recent time the custom language model was modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the custom language model.
	ModelName *string `min:"1" type:"string"`

	// The creation status of a custom language model. When the status is COMPLETED
	// the model is ready for use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`

	// Whether the base model used for the custom language model is up to date.
	// If this field is true then you are running the most up-to-date version of
	// the base model in your custom language model.
	UpgradeAvailability *bool `type:"boolean"`
}

// String returns the string representation
func (s LanguageModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LanguageModel) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *LanguageModel) SetBaseModelName(v string) *LanguageModel {
	s.BaseModelName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *LanguageModel) SetCreateTime(v time.Time) *LanguageModel {
	s.CreateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LanguageModel) SetFailureReason(v string) *LanguageModel {
	s.FailureReason = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *LanguageModel) SetInputDataConfig(v *InputDataConfig) *LanguageModel {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LanguageModel) SetLanguageCode(v string) *LanguageModel {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *LanguageModel) SetLastModifiedTime(v time.Time) *LanguageModel {
	s.LastModifiedTime = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *LanguageModel) SetModelName(v string) *LanguageModel {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *LanguageModel) SetModelStatus(v string) *LanguageModel {
	s.ModelStatus = &v
	return s
}

// SetUpgradeAvailability sets the UpgradeAvailability field's value.
func (s *LanguageModel) SetUpgradeAvailability(v bool) *LanguageModel {
	s.UpgradeAvailability = &v
	return s
}

// Either you have sent too many requests or your input file is too long. Wait
// before you resend your request, or use a smaller file and resend the request.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListLanguageModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of language models to return in the response. If there
	// are fewer results in the list, the response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// When specified, the custom language model names returned contain the substring
	// you've specified.
	NameContains *string `min:"1" type:"string"`

	// When included, fetches the next set of jobs if the result of the previous
	// request was truncated.
	NextToken *string `type:"string"`

	// When specified, returns only custom language models with the specified status.
	// Language models are ordered by creation date, with the newest models first.
	// If you don't specify a status, Amazon Transcribe returns all custom language
	// models ordered by date.
	StatusEquals *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation
func (s ListLanguageModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLanguageModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLanguageModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLanguageModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLanguageModelsInput) SetMaxResults(v int64) *ListLanguageModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListLanguageModelsInput) SetNameContains(v string) *ListLanguageModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsInput) SetNextToken(v string) *ListLanguageModelsInput {
	s.NextToken = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListLanguageModelsInput) SetStatusEquals(v string) *ListLanguageModelsInput {
	s.StatusEquals = &v
	return s
}

type ListLanguageModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing information about custom language models.
	Models []*LanguageModel `type:"list"`

	// The operation returns a page of jobs at a time. The maximum size of the list
	// is set by the MaxResults parameter. If there are more language models in
	// the list than the page size, Amazon Transcribe returns the NextPage token.
	// Include the token in the next request to the operation to return the next
	// page of language models.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLanguageModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLanguageModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *ListLanguageModelsOutput) SetModels(v []*LanguageModel) *ListLanguageModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsOutput) SetNextToken(v string) *ListLanguageModelsOutput {
	s.NextToken = &v
	return s
}

type ListMedicalTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of medical transcription jobs to return in the response.
	// IF there are fewer results in the list, this response contains only the actual
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you a receive a truncated result in the previous request of ListMedicalTranscriptionJobs,
	// include NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only medical transcription jobs with the specified
	// status. Jobs are ordered by creation date, with the newest jobs returned
	// first. If you don't specify a status, Amazon Transcribe Medical returns all
	// transcription jobs ordered by creation date.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s ListMedicalTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMedicalTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListMedicalTranscriptionJobsInput) SetJobNameContains(v string) *ListMedicalTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalTranscriptionJobsInput) SetMaxResults(v int64) *ListMedicalTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsInput) SetNextToken(v string) *ListMedicalTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsInput) SetStatus(v string) *ListMedicalTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListMedicalTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing summary information for a transcription job.
	MedicalTranscriptionJobSummaries []*MedicalTranscriptionJobSummary `type:"list"`

	// The ListMedicalTranscriptionJobs operation returns a page of jobs at a time.
	// The maximum size of the page is set by the MaxResults parameter. If the number
	// of jobs exceeds what can fit on a page, Amazon Transcribe Medical returns
	// the NextPage token. Include the token in the next request to the ListMedicalTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the medical transcription jobs returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s ListMedicalTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMedicalTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJobSummaries sets the MedicalTranscriptionJobSummaries field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetMedicalTranscriptionJobSummaries(v []*MedicalTranscriptionJobSummary) *ListMedicalTranscriptionJobsOutput {
	s.MedicalTranscriptionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetNextToken(v string) *ListMedicalTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetStatus(v string) *ListMedicalTranscriptionJobsOutput {
	s.Status = &v
	return s
}

type ListMedicalVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of vocabularies to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns vocabularies whose names contain the specified string. The search
	// is not case sensitive. ListMedicalVocabularies returns both "vocabularyname"
	// and "VocabularyName".
	NameContains *string `min:"1" type:"string"`

	// If the result of your previous request to ListMedicalVocabularies was truncated,
	// include the NextToken to fetch the next set of vocabularies.
	NextToken *string `type:"string"`

	// When specified, returns only vocabularies with the VocabularyState equal
	// to the specified vocabulary state. Use this field to see which vocabularies
	// are ready for your medical transcription jobs.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s ListMedicalVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMedicalVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalVocabulariesInput) SetMaxResults(v int64) *ListMedicalVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListMedicalVocabulariesInput) SetNameContains(v string) *ListMedicalVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesInput) SetNextToken(v string) *ListMedicalVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListMedicalVocabulariesInput) SetStateEquals(v string) *ListMedicalVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListMedicalVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// The ListMedicalVocabularies operation returns a page of vocabularies at a
	// time. You set the maximum number of vocabularies to return on a page with
	// the MaxResults parameter. If there are more jobs in the list will fit on
	// a page, Amazon Transcribe Medical returns the NextPage token. To return the
	// next page of vocabularies, include the token in the next request to the ListMedicalVocabularies
	// operation .
	NextToken *string `type:"string"`

	// The requested vocabulary state.
	Status *string `type:"string" enum:"VocabularyState"`

	// A list of objects that describe the vocabularies that match your search criteria.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation
func (s ListMedicalVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMedicalVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesOutput) SetNextToken(v string) *ListMedicalVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalVocabulariesOutput) SetStatus(v string) *ListMedicalVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListMedicalVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListMedicalVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of jobs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListTranscriptionJobs was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only transcription jobs with the specified status.
	// Jobs are ordered by creation date, with the newest jobs returned first. If
	// you don’t specify a status, Amazon Transcribe returns all transcription
	// jobs ordered by creation date.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s ListTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListTranscriptionJobsInput) SetJobNameContains(v string) *ListTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTranscriptionJobsInput) SetMaxResults(v int64) *ListTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsInput) SetNextToken(v string) *ListTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsInput) SetStatus(v string) *ListTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// The ListTranscriptionJobs operation returns a page of jobs at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are
	// more jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the jobs returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`

	// A list of objects containing summary information for a transcription job.
	TranscriptionJobSummaries []*TranscriptionJobSummary `type:"list"`
}

// String returns the string representation
func (s ListTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsOutput) SetNextToken(v string) *ListTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsOutput) SetStatus(v string) *ListTranscriptionJobsOutput {
	s.Status = &v
	return s
}

// SetTranscriptionJobSummaries sets the TranscriptionJobSummaries field's value.
func (s *ListTranscriptionJobsOutput) SetTranscriptionJobSummaries(v []*TranscriptionJobSummary) *ListTranscriptionJobsOutput {
	s.TranscriptionJobSummaries = v
	return s
}

type ListVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of vocabularies to return in the response. If there are
	// fewer results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// When specified, the vocabularies returned in the list are limited to vocabularies
	// whose name contains the specified string. The search is not case sensitive,
	// ListVocabularies returns both "vocabularyname" and "VocabularyName" in the
	// response list.
	NameContains *string `min:"1" type:"string"`

	// If the result of the previous request to ListVocabularies was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, only returns vocabularies with the VocabularyState field
	// equal to the specified state.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s ListVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabulariesInput) SetMaxResults(v int64) *ListVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabulariesInput) SetNameContains(v string) *ListVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesInput) SetNextToken(v string) *ListVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListVocabulariesInput) SetStateEquals(v string) *ListVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// The ListVocabularies operation returns a page of vocabularies at a time.
	// The maximum size of the page is set in the MaxResults parameter. If there
	// are more jobs in the list than will fit on the page, Amazon Transcribe returns
	// the NextPage token. To return in the next page of jobs, include the token
	// in the next request to the ListVocabularies operation.
	NextToken *string `type:"string"`

	// The requested vocabulary state.
	Status *string `type:"string" enum:"VocabularyState"`

	// A list of objects that describe the vocabularies that match the search criteria
	// in the request.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation
func (s ListVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesOutput) SetNextToken(v string) *ListVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListVocabulariesOutput) SetStatus(v string) *ListVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListVocabularyFiltersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of filters to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Filters the response so that it only contains vocabulary filters whose name
	// contains the specified string.
	NameContains *string `min:"1" type:"string"`

	// If the result of the previous request to ListVocabularyFilters was truncated,
	// include the NextToken to fetch the next set of collections.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListVocabularyFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabularyFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabularyFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabularyFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabularyFiltersInput) SetMaxResults(v int64) *ListVocabularyFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabularyFiltersInput) SetNameContains(v string) *ListVocabularyFiltersInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersInput) SetNextToken(v string) *ListVocabularyFiltersInput {
	s.NextToken = &v
	return s
}

type ListVocabularyFiltersOutput struct {
	_ struct{} `type:"structure"`

	// The ListVocabularyFilters operation returns a page of collections at a time.
	// The maximum size of the page is set by the MaxResults parameter. If there
	// are more jobs in the list than the page size, Amazon Transcribe returns the
	// NextPage token. Include the token in the next request to the ListVocabularyFilters
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The list of vocabulary filters. It contains at most MaxResults number of
	// filters. If there are more filters, call the ListVocabularyFilters operation
	// again with the NextToken parameter in the request set to the value of the
	// NextToken field in the response.
	VocabularyFilters []*VocabularyFilterInfo `type:"list"`
}

// String returns the string representation
func (s ListVocabularyFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabularyFiltersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersOutput) SetNextToken(v string) *ListVocabularyFiltersOutput {
	s.NextToken = &v
	return s
}

// SetVocabularyFilters sets the VocabularyFilters field's value.
func (s *ListVocabularyFiltersOutput) SetVocabularyFilters(v []*VocabularyFilterInfo) *ListVocabularyFiltersOutput {
	s.VocabularyFilters = v
	return s
}

// Describes the input media file in a transcription request.
type Media struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the input media file. The URI must be in the same
	// region as the API endpoint that you are calling. The general form is:
	//
	// For example:
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	MediaFileUri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Media) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Media) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Media) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Media"}
	if s.MediaFileUri != nil && len(*s.MediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaFileUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaFileUri sets the MediaFileUri field's value.
func (s *Media) SetMediaFileUri(v string) *Media {
	s.MediaFileUri = &v
	return s
}

// Identifies the location of a medical transcript.
type MedicalTranscript struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the medical transcript.
	//
	// Use this URI to access the medical transcript. This URI points to the S3
	// bucket you created to store the medical transcript.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MedicalTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MedicalTranscript) GoString() string {
	return s.String()
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *MedicalTranscript) SetTranscriptFileUri(v string) *MedicalTranscript {
	s.TranscriptFileUri = &v
	return s
}

// The data structure that contains the information for a medical transcription
// job.
type MedicalTranscriptionJob struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, this field contains information
	// about why the job failed.
	//
	// The FailureReason field contains one of the following values:
	//
	//    * Unsupported media format- The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format-
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure the two values match.
	//
	//    * Invalid sample rate for audio file- The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8000 and 48000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate- The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large- The size of your audio file
	//    is larger than what Amazon Transcribe Medical can process. For more information,
	//    see Guidelines and Quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
	//    in the Amazon Transcribe Medical Guide
	//
	//    * Invalid number of channels: number of channels too large- Your audio
	//    contains more channels than Amazon Transcribe Medical is configured to
	//    process. To request additional channels, see Amazon Transcribe Medical
	//    Endpoints and Quotas (https://docs.aws.amazon.com/general/latest/gr/transcribe-medical.html)
	//    in the Amazon Web Services General Reference
	FailureReason *string `type:"string"`

	// The language code for the language spoken in the source audio file. US English
	// (en-US) is the only supported language for medical transcriptions. Any other
	// value you enter for language code results in a BadRequestException error.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Describes the input media file in a transcription request.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the source audio containing medical information.
	//
	// If you don't specify the sample rate, Amazon Transcribe Medical determines
	// it for you. If you choose to specify the sample rate, it must match the rate
	// detected by Amazon Transcribe Medical. In most cases, you should leave the
	// MediaSampleHertz blank and let Amazon Transcribe Medical determine the sample
	// rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// The name for a given medical transcription job.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Object that contains object.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// The medical specialty of any clinicians providing a dictation or having a
	// conversation. PRIMARYCARE is the only available setting for this object.
	// This specialty enables you to generate transcriptions for the following medical
	// fields:
	//
	//    * Family Medicine
	Specialty *string `type:"string" enum:"Specialty"`

	// A timestamp that shows when the job started processing.
	StartTime *time.Time `type:"timestamp"`

	// An object that contains the MedicalTranscript. The MedicalTranscript contains
	// the TranscriptFileUri.
	Transcript *MedicalTranscript `type:"structure"`

	// The completion status of a medical transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// The type of speech in the transcription job. CONVERSATION is generally used
	// for patient-physician dialogues. DICTATION is the setting for physicians
	// speaking their notes after seeing a patient. For more information, see how-it-works-med
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s MedicalTranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MedicalTranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJob) SetCompletionTime(v time.Time) *MedicalTranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJob) SetCreationTime(v time.Time) *MedicalTranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJob) SetFailureReason(v string) *MedicalTranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJob) SetLanguageCode(v string) *MedicalTranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *MedicalTranscriptionJob) SetMedia(v *Media) *MedicalTranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *MedicalTranscriptionJob) SetMediaFormat(v string) *MedicalTranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *MedicalTranscriptionJob) SetMediaSampleRateHertz(v int64) *MedicalTranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJob) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJob {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *MedicalTranscriptionJob) SetSettings(v *MedicalTranscriptionSetting) *MedicalTranscriptionJob {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJob) SetSpecialty(v string) *MedicalTranscriptionJob {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJob) SetStartTime(v time.Time) *MedicalTranscriptionJob {
	s.StartTime = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *MedicalTranscriptionJob) SetTranscript(v *MedicalTranscript) *MedicalTranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJob) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJob) SetType(v string) *MedicalTranscriptionJob {
	s.Type = &v
	return s
}

// Provides summary information about a transcription job.
type MedicalTranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the medical transcription job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// The language of the transcript in the source audio file.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The name of a medical transcription job.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Indicates the location of the transcription job's output.
	//
	// The CUSTOMER_BUCKET is the S3 location provided in the OutputBucketName field
	// when the
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// The medical specialty of the transcription job. Primary care is the only
	// valid value.
	Specialty *string `type:"string" enum:"Specialty"`

	// A timestamp that shows when the job began processing.
	StartTime *time.Time `type:"timestamp"`

	// The status of the medical transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// The speech of the clinician in the input audio.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s MedicalTranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MedicalTranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCompletionTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCreationTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJobSummary) SetFailureReason(v string) *MedicalTranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJobSummary) SetLanguageCode(v string) *MedicalTranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJobSummary) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJobSummary {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *MedicalTranscriptionJobSummary) SetOutputLocationType(v string) *MedicalTranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJobSummary) SetSpecialty(v string) *MedicalTranscriptionJobSummary {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJobSummary) SetStartTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJobSummary) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJobSummary) SetType(v string) *MedicalTranscriptionJobSummary {
	s.Type = &v
	return s
}

// Optional settings for the StartMedicalTranscriptionJob operation.
type MedicalTranscriptionSetting struct {
	_ struct{} `type:"structure"`

	// Instructs Amazon Transcribe Medical to process each audio channel separately
	// and then merge the transcription output of each channel into a single transcription.
	//
	// Amazon Transcribe Medical also produces a transcription of each item detected
	// on an audio channel, including the start time and end time of the item and
	// alternative transcriptions of item. The alternative transcriptions also come
	// with confidence scores provided by Amazon Transcribe Medical.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException
	ChannelIdentification *bool `type:"boolean"`

	// The maximum number of alternatives that you tell the service to return. If
	// you specify the MaxAlternatives field, you must set the ShowAlternatives
	// field to true.
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// The maximum number of speakers to identify in the input audio. If there are
	// more speakers in the audio than this number, multiple speakers are identified
	// as a single speaker. If you specify the MaxSpeakerLabels field, you must
	// set the ShowSpeakerLabels field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// Determines whether alternative transcripts are generated along with the transcript
	// that has the highest confidence. If you set ShowAlternatives field to true,
	// you must also set the maximum number of alternatives to return in the MaxAlternatives
	// field.
	ShowAlternatives *bool `type:"boolean"`

	// Determines whether the transcription job uses speaker recognition to identify
	// different speakers in the input audio. Speaker recognition labels individual
	// speakers in the audio file. If you set the ShowSpeakerLabels field to true,
	// you must also set the maximum number of speaker labels in the MaxSpeakerLabels
	// field.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ShowSpeakerLabels *bool `type:"boolean"`

	// The name of the vocabulary to use when processing a medical transcription
	// job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MedicalTranscriptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MedicalTranscriptionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MedicalTranscriptionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MedicalTranscriptionSetting"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *MedicalTranscriptionSetting) SetChannelIdentification(v bool) *MedicalTranscriptionSetting {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetMaxAlternatives(v int64) *MedicalTranscriptionSetting {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetMaxSpeakerLabels(v int64) *MedicalTranscriptionSetting {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetShowAlternatives(v bool) *MedicalTranscriptionSetting {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetShowSpeakerLabels(v bool) *MedicalTranscriptionSetting {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *MedicalTranscriptionSetting) SetVocabularyName(v string) *MedicalTranscriptionSetting {
	s.VocabularyName = &v
	return s
}

// The object used to call your custom language model to your transcription
// job.
type ModelSettings struct {
	_ struct{} `type:"structure"`

	// The name of your custom language model.
	LanguageModelName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ModelSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *ModelSettings) SetLanguageModelName(v string) *ModelSettings {
	s.LanguageModelName = &v
	return s
}

// We can't find the requested resource. Check the name and try your request
// again.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides optional settings for the StartTranscriptionJob operation.
type Settings struct {
	_ struct{} `type:"structure"`

	// Instructs Amazon Transcribe to process each audio channel separately and
	// then merge the transcription output of each channel into a single transcription.
	//
	// Amazon Transcribe also produces a transcription of each item detected on
	// an audio channel, including the start time and end time of the item and alternative
	// transcriptions of the item including the confidence that Amazon Transcribe
	// has in the transcription.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ChannelIdentification *bool `type:"boolean"`

	// The number of alternative transcriptions that the service should return.
	// If you specify the MaxAlternatives field, you must set the ShowAlternatives
	// field to true.
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// The maximum number of speakers to identify in the input audio. If there are
	// more speakers in the audio than this number, multiple speakers are identified
	// as a single speaker. If you specify the MaxSpeakerLabels field, you must
	// set the ShowSpeakerLabels field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// Determines whether the transcription contains alternative transcriptions.
	// If you set the ShowAlternatives field to true, you must also set the maximum
	// number of alternatives to return in the MaxAlternatives field.
	ShowAlternatives *bool `type:"boolean"`

	// Determines whether the transcription job uses speaker recognition to identify
	// different speakers in the input audio. Speaker recognition labels individual
	// speakers in the audio file. If you set the ShowSpeakerLabels field to true,
	// you must also set the maximum number of speaker labels MaxSpeakerLabels field.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ShowSpeakerLabels *bool `type:"boolean"`

	// Set to mask to remove filtered text from the transcript and replace it with
	// three asterisks ("***") as placeholder text. Set to remove to remove filtered
	// text from the transcript without using placeholder text.
	VocabularyFilterMethod *string `type:"string" enum:"VocabularyFilterMethod"`

	// The name of the vocabulary filter to use when transcribing the audio. The
	// filter that you specify must have the same language code as the transcription
	// job.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of a vocabulary to use when processing the transcription job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Settings"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *Settings) SetChannelIdentification(v bool) *Settings {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *Settings) SetMaxAlternatives(v int64) *Settings {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *Settings) SetMaxSpeakerLabels(v int64) *Settings {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *Settings) SetShowAlternatives(v bool) *Settings {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *Settings) SetShowSpeakerLabels(v bool) *Settings {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *Settings) SetVocabularyFilterMethod(v string) *Settings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *Settings) SetVocabularyFilterName(v string) *Settings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *Settings) SetVocabularyName(v string) *Settings {
	s.VocabularyName = &v
	return s
}

type StartMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language spoken in the input media file. US English
	// (en-US) is the valid value for medical transcription jobs. Any other value
	// you enter for language code results in a BadRequestException error.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Describes the input media file in a transcription request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The audio format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	//
	// If you do not specify the media sample rate, Amazon Transcribe Medical determines
	// the sample rate. If you specify the sample rate, it must match the rate detected
	// by Amazon Transcribe Medical. In most cases, you should leave the MediaSampleRateHertz
	// field blank and let Amazon Transcribe Medical determine the sample rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// The name of the medical transcription job. You can't use the strings "."
	// or ".." by themselves as the job name. The name must also be unique within
	// an AWS account. If you try to create a medical transcription job with the
	// same name as a previous medical transcription job, you get a ConflictException
	// error.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 location where the transcription is stored.
	//
	// You must set OutputBucketName for Amazon Transcribe Medical to store the
	// transcription results. Your transcript appears in the S3 location you specify.
	// When you call the GetMedicalTranscriptionJob, the operation returns this
	// location in the TranscriptFileUri field. The S3 bucket must have permissions
	// that allow Amazon Transcribe Medical to put files in the bucket. For more
	// information, see Permissions Required for IAM User Roles (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// You can specify an AWS Key Management Service (KMS) key to encrypt the output
	// of your transcription using the OutputEncryptionKMSKeyId parameter. If you
	// don't specify a KMS key, Amazon Transcribe Medical uses the default Amazon
	// S3 key for server-side encryption of transcripts that are placed in your
	// S3 bucket.
	//
	// OutputBucketName is a required field
	OutputBucketName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key
	// used to encrypt the output of the transcription job. The user calling the
	// StartMedicalTranscriptionJob operation must have permission to use the specified
	// KMS key.
	//
	// You use either of the following to identify a KMS key in the current account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS key in the current account or another
	//    account: "arn:aws:kms:region:account ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the medical transcription
	// job is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputBucketName parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// You can specify a location in an Amazon S3 bucket to store the output of
	// your medical transcription job.
	//
	// If you don't specify an output key, Amazon Transcribe Medical stores the
	// output of your transcription job in the Amazon S3 bucket you specified. By
	// default, the object key is "your-transcription-job-name.json".
	//
	// You can use output keys to specify the Amazon S3 prefix and file name of
	// the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/",
	// as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json".
	// If you specify "my-other-job-name.json" as the output key, the object key
	// is changed to "my-other-job-name.json". You can use an output key to change
	// both the prefix and the file name, for example "folder/my-other-job-name.json".
	//
	// If you specify an output key, you must also specify an S3 bucket in the OutputBucketName
	// parameter.
	OutputKey *string `min:"1" type:"string"`

	// Optional settings for the medical transcription job.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// The medical specialty of any clinician speaking in the input media.
	//
	// Specialty is a required field
	Specialty *string `type:"string" required:"true" enum:"Specialty"`

	// The type of speech in the input audio. CONVERSATION refers to conversations
	// between two or more speakers, e.g., a conversations between doctors and patients.
	// DICTATION refers to single-speaker dictated speech, e.g., for clinical notes.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation
func (s StartMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMedicalTranscriptionJobInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}
	if s.OutputBucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputBucketName"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartMedicalTranscriptionJobInput) SetLanguageCode(v string) *StartMedicalTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedia(v *Media) *StartMedicalTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaFormat(v string) *StartMedicalTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartMedicalTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *StartMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputBucketName(v string) *StartMedicalTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartMedicalTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputKey(v string) *StartMedicalTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartMedicalTranscriptionJobInput) SetSettings(v *MedicalTranscriptionSetting) *StartMedicalTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *StartMedicalTranscriptionJobInput) SetSpecialty(v string) *StartMedicalTranscriptionJobInput {
	s.Specialty = &v
	return s
}

// SetType sets the Type field's value.
func (s *StartMedicalTranscriptionJobInput) SetType(v string) *StartMedicalTranscriptionJobInput {
	s.Type = &v
	return s
}

type StartMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// A batch job submitted to transcribe medical speech to text.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s StartMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *StartMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *StartMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type StartTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// An object that contains the request parameters for content redaction.
	ContentRedaction *ContentRedaction `type:"structure"`

	// Set this field to true to enable automatic language identification. Automatic
	// language identification is disabled by default. You receive a BadRequestException
	// error if you enter a value for a LanguageCode.
	IdentifyLanguage *bool `type:"boolean"`

	// Provides information about how a transcription job is executed. Use this
	// field to indicate that the job can be queued for deferred execution if the
	// concurrency limit is reached and there are no slots available to immediately
	// run the job.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// The language code for the language used in the input media file.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// An object containing a list of languages that might be present in your collection
	// of audio files. Automatic language identification chooses a language that
	// best matches the source audio from that list.
	LanguageOptions []*string `min:"2" type:"list"`

	// An object that describes the input media for a transcription job.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	//
	// If you do not specify the media sample rate, Amazon Transcribe determines
	// the sample rate. If you specify the sample rate, it must match the sample
	// rate detected by Amazon Transcribe. In most cases, you should leave the MediaSampleRateHertz
	// field blank and let Amazon Transcribe determine the sample rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Choose the custom language model you use for your transcription job in this
	// parameter.
	ModelSettings *ModelSettings `type:"structure"`

	// The location where the transcription is stored.
	//
	// If you set the OutputBucketName, Amazon Transcribe puts the transcript in
	// the specified S3 bucket. When you call the GetTranscriptionJob operation,
	// the operation returns this location in the TranscriptFileUri field. If you
	// enable content redaction, the redacted transcript appears in RedactedTranscriptFileUri.
	// If you enable content redaction and choose to output an unredacted transcript,
	// that transcript's location still appears in the TranscriptFileUri. The S3
	// bucket must have permissions that allow Amazon Transcribe to put files in
	// the bucket. For more information, see Permissions Required for IAM User Roles
	// (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// You can specify an AWS Key Management Service (KMS) key to encrypt the output
	// of your transcription using the OutputEncryptionKMSKeyId parameter. If you
	// don't specify a KMS key, Amazon Transcribe uses the default Amazon S3 key
	// for server-side encryption of transcripts that are placed in your S3 bucket.
	//
	// If you don't set the OutputBucketName, Amazon Transcribe generates a pre-signed
	// URL, a shareable URL that provides secure access to your transcription, and
	// returns it in the TranscriptFileUri field. Use this URL to download the transcription.
	OutputBucketName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key
	// used to encrypt the output of the transcription job. The user calling the
	// StartTranscriptionJob operation must have permission to use the specified
	// KMS key.
	//
	// You can use either of the following to identify a KMS key in the current
	// account:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key in the current
	// account or another account:
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:region:account
	//    ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:region:account ID:alias/ExampleAlias"
	//
	// If you don't specify an encryption key, the output of the transcription job
	// is encrypted with the default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location in the OutputBucketName parameter.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// You can specify a location in an Amazon S3 bucket to store the output of
	// your transcription job.
	//
	// If you don't specify an output key, Amazon Transcribe stores the output of
	// your transcription job in the Amazon S3 bucket you specified. By default,
	// the object key is "your-transcription-job-name.json".
	//
	// You can use output keys to specify the Amazon S3 prefix and file name of
	// the transcription output. For example, specifying the Amazon S3 prefix, "folder1/folder2/",
	// as an output key would lead to the output being stored as "folder1/folder2/your-transcription-job-name.json".
	// If you specify "my-other-job-name.json" as the output key, the object key
	// is changed to "my-other-job-name.json". You can use an output key to change
	// both the prefix and the file name, for example "folder/my-other-job-name.json".
	//
	// If you specify an output key, you must also specify an S3 bucket in the OutputBucketName
	// parameter.
	OutputKey *string `min:"1" type:"string"`

	// A Settings object that provides optional settings for a transcription job.
	Settings *Settings `type:"structure"`

	// The name of the job. You can't use the strings "." or ".." by themselves
	// as the job name. The name must also be unique within an AWS account. If you
	// try to create a transcription job with the same name as a previous transcription
	// job, you get a ConflictException error.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTranscriptionJobInput"}
	if s.LanguageOptions != nil && len(s.LanguageOptions) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 2))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}
	if s.ContentRedaction != nil {
		if err := s.ContentRedaction.Validate(); err != nil {
			invalidParams.AddNested("ContentRedaction", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionSettings != nil {
		if err := s.JobExecutionSettings.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.ModelSettings != nil {
		if err := s.ModelSettings.Validate(); err != nil {
			invalidParams.AddNested("ModelSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *StartTranscriptionJobInput) SetContentRedaction(v *ContentRedaction) *StartTranscriptionJobInput {
	s.ContentRedaction = v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *StartTranscriptionJobInput) SetIdentifyLanguage(v bool) *StartTranscriptionJobInput {
	s.IdentifyLanguage = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *StartTranscriptionJobInput) SetJobExecutionSettings(v *JobExecutionSettings) *StartTranscriptionJobInput {
	s.JobExecutionSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartTranscriptionJobInput) SetLanguageCode(v string) *StartTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *StartTranscriptionJobInput) SetLanguageOptions(v []*string) *StartTranscriptionJobInput {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartTranscriptionJobInput) SetMedia(v *Media) *StartTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartTranscriptionJobInput) SetMediaFormat(v string) *StartTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *StartTranscriptionJobInput) SetModelSettings(v *ModelSettings) *StartTranscriptionJobInput {
	s.ModelSettings = v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartTranscriptionJobInput) SetOutputBucketName(v string) *StartTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartTranscriptionJobInput) SetOutputKey(v string) *StartTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartTranscriptionJobInput) SetSettings(v *Settings) *StartTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *StartTranscriptionJobInput) SetTranscriptionJobName(v string) *StartTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type StartTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing details of the asynchronous transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s StartTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *StartTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *StartTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

// Identifies the location of a transcription.
type Transcript struct {
	_ struct{} `type:"structure"`

	// The S3 object location of the redacted transcript.
	//
	// Use this URI to access the redacted transcript. If you specified an S3 bucket
	// in the OutputBucketName field when you created the job, this is the URI of
	// that bucket. If you chose to store the transcript in Amazon Transcribe, this
	// is a shareable URL that provides secure access to that location.
	RedactedTranscriptFileUri *string `min:"1" type:"string"`

	// The S3 object location of the transcript.
	//
	// Use this URI to access the transcript. If you specified an S3 bucket in the
	// OutputBucketName field when you created the job, this is the URI of that
	// bucket. If you chose to store the transcript in Amazon Transcribe, this is
	// a shareable URL that provides secure access to that location.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Transcript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transcript) GoString() string {
	return s.String()
}

// SetRedactedTranscriptFileUri sets the RedactedTranscriptFileUri field's value.
func (s *Transcript) SetRedactedTranscriptFileUri(v string) *Transcript {
	s.RedactedTranscriptFileUri = &v
	return s
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *Transcript) SetTranscriptFileUri(v string) *Transcript {
	s.TranscriptFileUri = &v
	return s
}

// Describes an asynchronous transcription job that was created with the StartTranscriptionJob
// operation.
type TranscriptionJob struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// An object that describes content redaction settings for the transcription
	// job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, this field contains information
	// about why the job failed.
	//
	// The FailureReason field can contain one of the following values:
	//
	//    * Unsupported media format - The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format -
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure that the two values match.
	//
	//    * Invalid sample rate for audio file - The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8000 and 48000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate - The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large - The size of your audio file
	//    is larger than Amazon Transcribe can process. For more information, see
	//    Limits (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
	//    in the Amazon Transcribe Developer Guide.
	//
	//    * Invalid number of channels: number of channels too large - Your audio
	//    contains more channels than Amazon Transcribe is configured to process.
	//    To request additional channels, see Amazon Transcribe Limits (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits-amazon-transcribe)
	//    in the Amazon Web Services General Reference.
	FailureReason *string `type:"string"`

	// A value between zero and one that Amazon Transcribe assigned to the language
	// that it identified in the source audio. Larger values indicate that Amazon
	// Transcribe has higher confidence in the language it identified.
	IdentifiedLanguageScore *float64 `type:"float"`

	// A value that shows if automatic language identification was enabled for a
	// transcription job.
	IdentifyLanguage *bool `type:"boolean"`

	// Provides information about how a transcription job is executed.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// An object that shows the optional array of languages inputted for transcription
	// jobs with automatic language identification enabled.
	LanguageOptions []*string `min:"2" type:"list"`

	// An object that describes the input media for the transcription job.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// An object containing the details of your custom language model.
	ModelSettings *ModelSettings `type:"structure"`

	// Optional settings for the transcription job. Use these settings to turn on
	// speaker recognition, to set the maximum number of speakers that should be
	// identified and to specify a custom vocabulary to use when processing the
	// transcription job.
	Settings *Settings `type:"structure"`

	// A timestamp that shows with the job was started processing.
	StartTime *time.Time `type:"timestamp"`

	// An object that describes the output of the transcription job.
	Transcript *Transcript `type:"structure"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s TranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJob) SetCompletionTime(v time.Time) *TranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJob) SetContentRedaction(v *ContentRedaction) *TranscriptionJob {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJob) SetCreationTime(v time.Time) *TranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJob) SetFailureReason(v string) *TranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJob) SetIdentifiedLanguageScore(v float64) *TranscriptionJob {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJob) SetIdentifyLanguage(v bool) *TranscriptionJob {
	s.IdentifyLanguage = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *TranscriptionJob) SetJobExecutionSettings(v *JobExecutionSettings) *TranscriptionJob {
	s.JobExecutionSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJob) SetLanguageCode(v string) *TranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *TranscriptionJob) SetLanguageOptions(v []*string) *TranscriptionJob {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *TranscriptionJob) SetMedia(v *Media) *TranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *TranscriptionJob) SetMediaFormat(v string) *TranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *TranscriptionJob) SetMediaSampleRateHertz(v int64) *TranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJob) SetModelSettings(v *ModelSettings) *TranscriptionJob {
	s.ModelSettings = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *TranscriptionJob) SetSettings(v *Settings) *TranscriptionJob {
	s.Settings = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJob) SetStartTime(v time.Time) *TranscriptionJob {
	s.StartTime = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptionJob) SetTranscript(v *Transcript) *TranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJob) SetTranscriptionJobName(v string) *TranscriptionJob {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJob) SetTranscriptionJobStatus(v string) *TranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// Provides a summary of information about a transcription job.
type TranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// The content redaction settings of the transcription job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// A value between zero and one that Amazon Transcribe assigned to the language
	// it identified in the source audio. A higher score indicates that Amazon Transcribe
	// is more confident in the language it identified.
	IdentifiedLanguageScore *float64 `type:"float"`

	// Whether automatic language identification was enabled for a transcription
	// job.
	IdentifyLanguage *bool `type:"boolean"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The object used to call your custom language model to your transcription
	// job.
	ModelSettings *ModelSettings `type:"structure"`

	// Indicates the location of the output of the transcription job.
	//
	// If the value is CUSTOMER_BUCKET then the location is the S3 bucket specified
	// in the outputBucketName field when the transcription job was started with
	// the StartTranscriptionJob operation.
	//
	// If the value is SERVICE_BUCKET then the output is stored by Amazon Transcribe
	// and can be retrieved using the URI in the GetTranscriptionJob response's
	// TranscriptFileUri field.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// A timestamp that shows when the job started processing.
	StartTime *time.Time `type:"timestamp"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job. When the status is COMPLETED, use the
	// GetTranscriptionJob operation to get the results of the transcription.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s TranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJobSummary) SetCompletionTime(v time.Time) *TranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJobSummary) SetContentRedaction(v *ContentRedaction) *TranscriptionJobSummary {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJobSummary) SetCreationTime(v time.Time) *TranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJobSummary) SetFailureReason(v string) *TranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJobSummary) SetIdentifiedLanguageScore(v float64) *TranscriptionJobSummary {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJobSummary) SetIdentifyLanguage(v bool) *TranscriptionJobSummary {
	s.IdentifyLanguage = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJobSummary) SetLanguageCode(v string) *TranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJobSummary) SetModelSettings(v *ModelSettings) *TranscriptionJobSummary {
	s.ModelSettings = v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *TranscriptionJobSummary) SetOutputLocationType(v string) *TranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJobSummary) SetStartTime(v time.Time) *TranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobName(v string) *TranscriptionJobSummary {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobStatus(v string) *TranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

type UpdateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the language used for the entries in the updated vocabulary.
	// US English (en-US) is the only valid language code in Amazon Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The location in Amazon S3 of the text file that contains the you use for
	// your custom vocabulary. The URI must be in the same AWS Region as the resource
	// that you are calling. The following is the format for a URI:
	//
	// https://s3.<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// For example:
	//
	// https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt
	//
	// For more information about Amazon S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies in Amazon Transcribe Medical,
	// see Medical Custom Vocabularies (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary to update. The name is case sensitive. If you
	// try to update a vocabulary with the same name as a vocabulary you've already
	// made, you get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyInput) SetLanguageCode(v string) *UpdateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyFileUri(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyName(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the text file used to update the custom
	// vocabulary. US English (en-US) is the only language supported in Amazon Transcribe
	// Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the update to the vocabulary. When the VocabularyState
	// field is READY, the vocabulary is ready to be used in a StartMedicalTranscriptionJob
	// request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s UpdateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyOutput) SetLanguageCode(v string) *UpdateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyName(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyState(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type UpdateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of a text file used as input to create the vocabulary
	// filter. Only use characters from the character set defined for custom vocabularies.
	// For a list of character sets, see Character Sets for Custom Vocabularies
	// (https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets).
	//
	// The specified file must be less than 50 KB of UTF-8 characters.
	//
	// If you provide the location of a list of words in the VocabularyFilterFileUri
	// parameter, you can't use the Words parameter.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary filter to update. If you try to update a vocabulary
	// filter with the same name as another vocabulary filter, you get a ConflictException
	// error.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// The words to use in the vocabulary filter. Only use characters from the character
	// set defined for custom vocabularies. For a list of character sets, see Character
	// Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets).
	//
	// If you provide a list of words in the Words parameter, you can't use the
	// VocabularyFilterFileUri parameter.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s UpdateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyFilterInput"}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *UpdateVocabularyFilterInput) SetWords(v []*string) *UpdateVocabularyFilterInput {
	s.Words = v
	return s
}

type UpdateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary filter was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyFilterOutput) SetLanguageCode(v string) *UpdateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterOutput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type UpdateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An array of strings containing the vocabulary entries.
	Phrases []*string `type:"list"`

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you
	// are calling. The general form is
	//
	// For example:
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Custom Vocabularies (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary to update. The name is case sensitive. If you
	// try to update a vocabulary with the same name as a previous vocabulary you
	// will receive a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyInput) SetLanguageCode(v string) *UpdateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *UpdateVocabularyInput) SetPhrases(v []*string) *UpdateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateVocabularyInput) SetVocabularyFileUri(v string) *UpdateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyInput) SetVocabularyName(v string) *UpdateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary that was updated.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s UpdateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyOutput) SetLanguageCode(v string) *UpdateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyOutput) SetVocabularyName(v string) *UpdateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateVocabularyOutput) SetVocabularyState(v string) *UpdateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// Provides information about a vocabulary filter.
type VocabularyFilterInfo struct {
	_ struct{} `type:"structure"`

	// The language code of the words in the vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary filter. The name must be unique in the account
	// that holds the filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VocabularyFilterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VocabularyFilterInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyFilterInfo) SetLanguageCode(v string) *VocabularyFilterInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyFilterInfo) SetLastModifiedTime(v time.Time) *VocabularyFilterInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *VocabularyFilterInfo) SetVocabularyFilterName(v string) *VocabularyFilterInfo {
	s.VocabularyFilterName = &v
	return s
}

// Provides information about a custom vocabulary.
type VocabularyInfo struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. If the state is READY you can use
	// the vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s VocabularyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VocabularyInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyInfo) SetLanguageCode(v string) *VocabularyInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyInfo) SetLastModifiedTime(v time.Time) *VocabularyInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *VocabularyInfo) SetVocabularyName(v string) *VocabularyInfo {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *VocabularyInfo) SetVocabularyState(v string) *VocabularyInfo {
	s.VocabularyState = &v
	return s
}

const (
	// BaseModelNameNarrowBand is a BaseModelName enum value
	BaseModelNameNarrowBand = "NarrowBand"

	// BaseModelNameWideBand is a BaseModelName enum value
	BaseModelNameWideBand = "WideBand"
)

// BaseModelName_Values returns all elements of the BaseModelName enum
func BaseModelName_Values() []string {
	return []string{
		BaseModelNameNarrowBand,
		BaseModelNameWideBand,
	}
}

const (
	// CLMLanguageCodeEnUs is a CLMLanguageCode enum value
	CLMLanguageCodeEnUs = "en-US"
)

// CLMLanguageCode_Values returns all elements of the CLMLanguageCode enum
func CLMLanguageCode_Values() []string {
	return []string{
		CLMLanguageCodeEnUs,
	}
}

const (
	// LanguageCodeAfZa is a LanguageCode enum value
	LanguageCodeAfZa = "af-ZA"

	// LanguageCodeArAe is a LanguageCode enum value
	LanguageCodeArAe = "ar-AE"

	// LanguageCodeArSa is a LanguageCode enum value
	LanguageCodeArSa = "ar-SA"

	// LanguageCodeCyGb is a LanguageCode enum value
	LanguageCodeCyGb = "cy-GB"

	// LanguageCodeDaDk is a LanguageCode enum value
	LanguageCodeDaDk = "da-DK"

	// LanguageCodeDeCh is a LanguageCode enum value
	LanguageCodeDeCh = "de-CH"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodeEnAb is a LanguageCode enum value
	LanguageCodeEnAb = "en-AB"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEnIe is a LanguageCode enum value
	LanguageCodeEnIe = "en-IE"

	// LanguageCodeEnIn is a LanguageCode enum value
	LanguageCodeEnIn = "en-IN"

	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEnWl is a LanguageCode enum value
	LanguageCodeEnWl = "en-WL"

	// LanguageCodeEsEs is a LanguageCode enum value
	LanguageCodeEsEs = "es-ES"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFaIr is a LanguageCode enum value
	LanguageCodeFaIr = "fa-IR"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeGaIe is a LanguageCode enum value
	LanguageCodeGaIe = "ga-IE"

	// LanguageCodeGdGb is a LanguageCode enum value
	LanguageCodeGdGb = "gd-GB"

	// LanguageCodeHeIl is a LanguageCode enum value
	LanguageCodeHeIl = "he-IL"

	// LanguageCodeHiIn is a LanguageCode enum value
	LanguageCodeHiIn = "hi-IN"

	// LanguageCodeIdId is a LanguageCode enum value
	LanguageCodeIdId = "id-ID"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeMsMy is a LanguageCode enum value
	LanguageCodeMsMy = "ms-MY"

	// LanguageCodeNlNl is a LanguageCode enum value
	LanguageCodeNlNl = "nl-NL"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodePtPt is a LanguageCode enum value
	LanguageCodePtPt = "pt-PT"

	// LanguageCodeRuRu is a LanguageCode enum value
	LanguageCodeRuRu = "ru-RU"

	// LanguageCodeTaIn is a LanguageCode enum value
	LanguageCodeTaIn = "ta-IN"

	// LanguageCodeTeIn is a LanguageCode enum value
	LanguageCodeTeIn = "te-IN"

	// LanguageCodeTrTr is a LanguageCode enum value
	LanguageCodeTrTr = "tr-TR"

	// LanguageCodeZhCn is a LanguageCode enum value
	LanguageCodeZhCn = "zh-CN"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeAfZa,
		LanguageCodeArAe,
		LanguageCodeArSa,
		LanguageCodeCyGb,
		LanguageCodeDaDk,
		LanguageCodeDeCh,
		LanguageCodeDeDe,
		LanguageCodeEnAb,
		LanguageCodeEnAu,
		LanguageCodeEnGb,
		LanguageCodeEnIe,
		LanguageCodeEnIn,
		LanguageCodeEnUs,
		LanguageCodeEnWl,
		LanguageCodeEsEs,
		LanguageCodeEsUs,
		LanguageCodeFaIr,
		LanguageCodeFrCa,
		LanguageCodeFrFr,
		LanguageCodeGaIe,
		LanguageCodeGdGb,
		LanguageCodeHeIl,
		LanguageCodeHiIn,
		LanguageCodeIdId,
		LanguageCodeItIt,
		LanguageCodeJaJp,
		LanguageCodeKoKr,
		LanguageCodeMsMy,
		LanguageCodeNlNl,
		LanguageCodePtBr,
		LanguageCodePtPt,
		LanguageCodeRuRu,
		LanguageCodeTaIn,
		LanguageCodeTeIn,
		LanguageCodeTrTr,
		LanguageCodeZhCn,
	}
}

const (
	// MediaFormatMp3 is a MediaFormat enum value
	MediaFormatMp3 = "mp3"

	// MediaFormatMp4 is a MediaFormat enum value
	MediaFormatMp4 = "mp4"

	// MediaFormatWav is a MediaFormat enum value
	MediaFormatWav = "wav"

	// MediaFormatFlac is a MediaFormat enum value
	MediaFormatFlac = "flac"

	// MediaFormatOgg is a MediaFormat enum value
	MediaFormatOgg = "ogg"

	// MediaFormatAmr is a MediaFormat enum value
	MediaFormatAmr = "amr"

	// MediaFormatWebm is a MediaFormat enum value
	MediaFormatWebm = "webm"
)

// MediaFormat_Values returns all elements of the MediaFormat enum
func MediaFormat_Values() []string {
	return []string{
		MediaFormatMp3,
		MediaFormatMp4,
		MediaFormatWav,
		MediaFormatFlac,
		MediaFormatOgg,
		MediaFormatAmr,
		MediaFormatWebm,
	}
}

const (
	// ModelStatusInProgress is a ModelStatus enum value
	ModelStatusInProgress = "IN_PROGRESS"

	// ModelStatusFailed is a ModelStatus enum value
	ModelStatusFailed = "FAILED"

	// ModelStatusCompleted is a ModelStatus enum value
	ModelStatusCompleted = "COMPLETED"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusInProgress,
		ModelStatusFailed,
		ModelStatusCompleted,
	}
}

const (
	// OutputLocationTypeCustomerBucket is a OutputLocationType enum value
	OutputLocationTypeCustomerBucket = "CUSTOMER_BUCKET"

	// OutputLocationTypeServiceBucket is a OutputLocationType enum value
	OutputLocationTypeServiceBucket = "SERVICE_BUCKET"
)

// OutputLocationType_Values returns all elements of the OutputLocationType enum
func OutputLocationType_Values() []string {
	return []string{
		OutputLocationTypeCustomerBucket,
		OutputLocationTypeServiceBucket,
	}
}

const (
	// RedactionOutputRedacted is a RedactionOutput enum value
	RedactionOutputRedacted = "redacted"

	// RedactionOutputRedactedAndUnredacted is a RedactionOutput enum value
	RedactionOutputRedactedAndUnredacted = "redacted_and_unredacted"
)

// RedactionOutput_Values returns all elements of the RedactionOutput enum
func RedactionOutput_Values() []string {
	return []string{
		RedactionOutputRedacted,
		RedactionOutputRedactedAndUnredacted,
	}
}

const (
	// RedactionTypePii is a RedactionType enum value
	RedactionTypePii = "PII"
)

// RedactionType_Values returns all elements of the RedactionType enum
func RedactionType_Values() []string {
	return []string{
		RedactionTypePii,
	}
}

const (
	// SpecialtyPrimarycare is a Specialty enum value
	SpecialtyPrimarycare = "PRIMARYCARE"
)

// Specialty_Values returns all elements of the Specialty enum
func Specialty_Values() []string {
	return []string{
		SpecialtyPrimarycare,
	}
}

const (
	// TranscriptionJobStatusQueued is a TranscriptionJobStatus enum value
	TranscriptionJobStatusQueued = "QUEUED"

	// TranscriptionJobStatusInProgress is a TranscriptionJobStatus enum value
	TranscriptionJobStatusInProgress = "IN_PROGRESS"

	// TranscriptionJobStatusFailed is a TranscriptionJobStatus enum value
	TranscriptionJobStatusFailed = "FAILED"

	// TranscriptionJobStatusCompleted is a TranscriptionJobStatus enum value
	TranscriptionJobStatusCompleted = "COMPLETED"
)

// TranscriptionJobStatus_Values returns all elements of the TranscriptionJobStatus enum
func TranscriptionJobStatus_Values() []string {
	return []string{
		TranscriptionJobStatusQueued,
		TranscriptionJobStatusInProgress,
		TranscriptionJobStatusFailed,
		TranscriptionJobStatusCompleted,
	}
}

const (
	// TypeConversation is a Type enum value
	TypeConversation = "CONVERSATION"

	// TypeDictation is a Type enum value
	TypeDictation = "DICTATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeConversation,
		TypeDictation,
	}
}

const (
	// VocabularyFilterMethodRemove is a VocabularyFilterMethod enum value
	VocabularyFilterMethodRemove = "remove"

	// VocabularyFilterMethodMask is a VocabularyFilterMethod enum value
	VocabularyFilterMethodMask = "mask"
)

// VocabularyFilterMethod_Values returns all elements of the VocabularyFilterMethod enum
func VocabularyFilterMethod_Values() []string {
	return []string{
		VocabularyFilterMethodRemove,
		VocabularyFilterMethodMask,
	}
}

const (
	// VocabularyStatePending is a VocabularyState enum value
	VocabularyStatePending = "PENDING"

	// VocabularyStateReady is a VocabularyState enum value
	VocabularyStateReady = "READY"

	// VocabularyStateFailed is a VocabularyState enum value
	VocabularyStateFailed = "FAILED"
)

// VocabularyState_Values returns all elements of the VocabularyState enum
func VocabularyState_Values() []string {
	return []string{
		VocabularyStatePending,
		VocabularyStateReady,
		VocabularyStateFailed,
	}
}
