// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/internal/s3shared/arn"
	"github.com/aws/aws-sdk-go/private/checksum"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opAssociateAccessGrantsIdentityCenter = "AssociateAccessGrantsIdentityCenter"

// AssociateAccessGrantsIdentityCenterRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAccessGrantsIdentityCenter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAccessGrantsIdentityCenter for more information on using the AssociateAccessGrantsIdentityCenter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAccessGrantsIdentityCenterRequest method.
//	req, resp := client.AssociateAccessGrantsIdentityCenterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/AssociateAccessGrantsIdentityCenter
func (c *S3Control) AssociateAccessGrantsIdentityCenterRequest(input *AssociateAccessGrantsIdentityCenterInput) (req *request.Request, output *AssociateAccessGrantsIdentityCenterOutput) {
	op := &request.Operation{
		Name:       opAssociateAccessGrantsIdentityCenter,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/accessgrantsinstance/identitycenter",
	}

	if input == nil {
		input = &AssociateAccessGrantsIdentityCenterInput{}
	}

	output = &AssociateAccessGrantsIdentityCenterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// AssociateAccessGrantsIdentityCenter API operation for AWS S3 Control.
//
// Associate your S3 Access Grants instance with an Amazon Web Services IAM
// Identity Center instance. Use this action if you want to create access grants
// for users or groups from your corporate identity directory. First, you must
// add your corporate identity directory to Amazon Web Services IAM Identity
// Center. Then, you can associate this IAM Identity Center instance with your
// S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:AssociateAccessGrantsIdentityCenter permission to use
// this operation.
//
// # Additional Permissions
//
// You must also have the following permissions: sso:CreateApplication, sso:PutApplicationGrant,
// and sso:PutApplicationAuthenticationMethod.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation AssociateAccessGrantsIdentityCenter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/AssociateAccessGrantsIdentityCenter
func (c *S3Control) AssociateAccessGrantsIdentityCenter(input *AssociateAccessGrantsIdentityCenterInput) (*AssociateAccessGrantsIdentityCenterOutput, error) {
	req, out := c.AssociateAccessGrantsIdentityCenterRequest(input)
	return out, req.Send()
}

// AssociateAccessGrantsIdentityCenterWithContext is the same as AssociateAccessGrantsIdentityCenter with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAccessGrantsIdentityCenter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) AssociateAccessGrantsIdentityCenterWithContext(ctx aws.Context, input *AssociateAccessGrantsIdentityCenterInput, opts ...request.Option) (*AssociateAccessGrantsIdentityCenterOutput, error) {
	req, out := c.AssociateAccessGrantsIdentityCenterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessGrant = "CreateAccessGrant"

// CreateAccessGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessGrant for more information on using the CreateAccessGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessGrantRequest method.
//	req, resp := client.CreateAccessGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrant
func (c *S3Control) CreateAccessGrantRequest(input *CreateAccessGrantInput) (req *request.Request, output *CreateAccessGrantOutput) {
	op := &request.Operation{
		Name:       opCreateAccessGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/accessgrantsinstance/grant",
	}

	if input == nil {
		input = &CreateAccessGrantInput{}
	}

	output = &CreateAccessGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateAccessGrant API operation for AWS S3 Control.
//
// Creates an access grant that gives a grantee access to your S3 data. The
// grantee can be an IAM user or role or a directory user, or group. Before
// you can create a grant, you must have an S3 Access Grants instance in the
// same Region as the S3 data. You can create an S3 Access Grants instance using
// the CreateAccessGrantsInstance (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsInstance.html).
// You must also have registered at least one S3 data location in your S3 Access
// Grants instance using CreateAccessGrantsLocation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessGrantsLocation.html).
//
// # Permissions
//
// You must have the s3:CreateAccessGrant permission to use this operation.
//
// # Additional Permissions
//
// For any directory identity - sso:DescribeInstance and sso:DescribeApplication
//
// For directory users - identitystore:DescribeUser
//
// For directory groups - identitystore:DescribeGroup
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessGrant for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrant
func (c *S3Control) CreateAccessGrant(input *CreateAccessGrantInput) (*CreateAccessGrantOutput, error) {
	req, out := c.CreateAccessGrantRequest(input)
	return out, req.Send()
}

// CreateAccessGrantWithContext is the same as CreateAccessGrant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessGrantWithContext(ctx aws.Context, input *CreateAccessGrantInput, opts ...request.Option) (*CreateAccessGrantOutput, error) {
	req, out := c.CreateAccessGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessGrantsInstance = "CreateAccessGrantsInstance"

// CreateAccessGrantsInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessGrantsInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessGrantsInstance for more information on using the CreateAccessGrantsInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessGrantsInstanceRequest method.
//	req, resp := client.CreateAccessGrantsInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsInstance
func (c *S3Control) CreateAccessGrantsInstanceRequest(input *CreateAccessGrantsInstanceInput) (req *request.Request, output *CreateAccessGrantsInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateAccessGrantsInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/accessgrantsinstance",
	}

	if input == nil {
		input = &CreateAccessGrantsInstanceInput{}
	}

	output = &CreateAccessGrantsInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateAccessGrantsInstance API operation for AWS S3 Control.
//
// Creates an S3 Access Grants instance, which serves as a logical grouping
// for access grants. You can create one S3 Access Grants instance per Region
// per account.
//
// # Permissions
//
// You must have the s3:CreateAccessGrantsInstance permission to use this operation.
//
// # Additional Permissions
//
// To associate an IAM Identity Center instance with your S3 Access Grants instance,
// you must also have the sso:DescribeInstance, sso:CreateApplication, sso:PutApplicationGrant,
// and sso:PutApplicationAuthenticationMethod permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessGrantsInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsInstance
func (c *S3Control) CreateAccessGrantsInstance(input *CreateAccessGrantsInstanceInput) (*CreateAccessGrantsInstanceOutput, error) {
	req, out := c.CreateAccessGrantsInstanceRequest(input)
	return out, req.Send()
}

// CreateAccessGrantsInstanceWithContext is the same as CreateAccessGrantsInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessGrantsInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessGrantsInstanceWithContext(ctx aws.Context, input *CreateAccessGrantsInstanceInput, opts ...request.Option) (*CreateAccessGrantsInstanceOutput, error) {
	req, out := c.CreateAccessGrantsInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessGrantsLocation = "CreateAccessGrantsLocation"

// CreateAccessGrantsLocationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessGrantsLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessGrantsLocation for more information on using the CreateAccessGrantsLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessGrantsLocationRequest method.
//	req, resp := client.CreateAccessGrantsLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsLocation
func (c *S3Control) CreateAccessGrantsLocationRequest(input *CreateAccessGrantsLocationInput) (req *request.Request, output *CreateAccessGrantsLocationOutput) {
	op := &request.Operation{
		Name:       opCreateAccessGrantsLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/accessgrantsinstance/location",
	}

	if input == nil {
		input = &CreateAccessGrantsLocationInput{}
	}

	output = &CreateAccessGrantsLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateAccessGrantsLocation API operation for AWS S3 Control.
//
// The S3 data location that you would like to register in your S3 Access Grants
// instance. Your S3 data must be in the same Region as your S3 Access Grants
// instance. The location can be one of the following:
//
//   - The default S3 location s3://
//
//   - A bucket - S3://<bucket-name>
//
//   - A bucket and prefix - S3://<bucket-name>/<prefix>
//
// When you register a location, you must include the IAM role that has permission
// to manage the S3 location that you are registering. Give S3 Access Grants
// permission to assume this role using a policy (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-location.html).
// S3 Access Grants assumes this role to manage access to the location and to
// vend temporary credentials to grantees or client applications.
//
// # Permissions
//
// You must have the s3:CreateAccessGrantsLocation permission to use this operation.
//
// # Additional Permissions
//
// You must also have the following permission for the specified IAM role: iam:PassRole
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessGrantsLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessGrantsLocation
func (c *S3Control) CreateAccessGrantsLocation(input *CreateAccessGrantsLocationInput) (*CreateAccessGrantsLocationOutput, error) {
	req, out := c.CreateAccessGrantsLocationRequest(input)
	return out, req.Send()
}

// CreateAccessGrantsLocationWithContext is the same as CreateAccessGrantsLocation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessGrantsLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessGrantsLocationWithContext(ctx aws.Context, input *CreateAccessGrantsLocationInput, opts ...request.Option) (*CreateAccessGrantsLocationOutput, error) {
	req, out := c.CreateAccessGrantsLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPoint = "CreateAccessPoint"

// CreateAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPoint for more information on using the CreateAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessPointRequest method.
//	req, resp := client.CreateAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPointRequest(input *CreateAccessPointInput) (req *request.Request, output *CreateAccessPointOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &CreateAccessPointInput{}
	}

	output = &CreateAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Creates an access point and associates it with the specified bucket. For
// more information, see Managing Data Access with Amazon S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html)
// in the Amazon S3 User Guide.
//
// S3 on Outposts only supports VPC-style access points.
//
// For more information, see Accessing Amazon S3 on Outposts using virtual private
// cloud (VPC) only access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples)
// section.
//
// The following actions are related to CreateAccessPoint:
//
//   - GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
//   - DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//   - ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPoint(input *CreateAccessPointInput) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	return out, req.Send()
}

// CreateAccessPointWithContext is the same as CreateAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessPointWithContext(ctx aws.Context, input *CreateAccessPointInput, opts ...request.Option) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPointForObjectLambda = "CreateAccessPointForObjectLambda"

// CreateAccessPointForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPointForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPointForObjectLambda for more information on using the CreateAccessPointForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessPointForObjectLambdaRequest method.
//	req, resp := client.CreateAccessPointForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPointForObjectLambda
func (c *S3Control) CreateAccessPointForObjectLambdaRequest(input *CreateAccessPointForObjectLambdaInput) (req *request.Request, output *CreateAccessPointForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPointForObjectLambda,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}",
	}

	if input == nil {
		input = &CreateAccessPointForObjectLambdaInput{}
	}

	output = &CreateAccessPointForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPointForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Creates an Object Lambda Access Point. For more information, see Transforming
// objects with Object Lambda Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to CreateAccessPointForObjectLambda:
//
//   - DeleteAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
//
//   - GetAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
//
//   - ListAccessPointsForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessPointForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPointForObjectLambda
func (c *S3Control) CreateAccessPointForObjectLambda(input *CreateAccessPointForObjectLambdaInput) (*CreateAccessPointForObjectLambdaOutput, error) {
	req, out := c.CreateAccessPointForObjectLambdaRequest(input)
	return out, req.Send()
}

// CreateAccessPointForObjectLambdaWithContext is the same as CreateAccessPointForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPointForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessPointForObjectLambdaWithContext(ctx aws.Context, input *CreateAccessPointForObjectLambdaInput, opts ...request.Option) (*CreateAccessPointForObjectLambdaOutput, error) {
	req, out := c.CreateAccessPointForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBucketRequest method.
//	req, resp := client.CreateBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateBucket
func (c *S3Control) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateBucket API operation for AWS S3 Control.
//
// This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket,
// see Create Bucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
// in the Amazon S3 API Reference.
//
// Creates a new Outposts bucket. By creating the bucket, you become the bucket
// owner. To create an Outposts bucket, you must have S3 on Outposts. For more
// information, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in Amazon S3 User Guide.
//
// Not every string is an acceptable bucket name. For information on bucket
// naming restrictions, see Working with Amazon S3 Buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules).
//
// S3 on Outposts buckets support:
//
//   - Tags
//
//   - LifecycleConfigurations for deleting expired objects
//
// For a complete list of restrictions and Amazon S3 feature limitations on
// S3 on Outposts, see Amazon S3 on Outposts Restrictions and Limitations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html).
//
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your
// API request, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples)
// section.
//
// The following actions are related to CreateBucket for Amazon S3 on Outposts:
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - GetBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
//
//   - CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//   - PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeBucketAlreadyExists "BucketAlreadyExists"
//     The requested Outposts bucket name is not available. The bucket namespace
//     is shared by all users of the Outposts in this Region. Select a different
//     name and try again.
//
//   - ErrCodeBucketAlreadyOwnedByYou "BucketAlreadyOwnedByYou"
//     The Outposts bucket you tried to create already exists, and you own it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateBucket
func (c *S3Control) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateJobRequest method.
//	req, resp := client.CreateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateJob API operation for AWS S3 Control.
//
// This operation creates an S3 Batch Operations job.
//
// You can use S3 Batch Operations to perform large-scale batch actions on Amazon
// S3 objects. Batch Operations can run a single action on lists of Amazon S3
// objects that you specify. For more information, see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// For information about permissions required to use the Batch Operations, see
// Granting permissions for S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html)
// in the Amazon S3 User Guide.
//
// Related actions include:
//
//   - DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//   - ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//   - UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//   - UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
//   - JobOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeBadRequestException "BadRequestException"
//
//   - ErrCodeIdempotencyException "IdempotencyException"
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultiRegionAccessPoint = "CreateMultiRegionAccessPoint"

// CreateMultiRegionAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultiRegionAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultiRegionAccessPoint for more information on using the CreateMultiRegionAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMultiRegionAccessPointRequest method.
//	req, resp := client.CreateMultiRegionAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateMultiRegionAccessPoint
func (c *S3Control) CreateMultiRegionAccessPointRequest(input *CreateMultiRegionAccessPointInput) (req *request.Request, output *CreateMultiRegionAccessPointOutput) {
	op := &request.Operation{
		Name:       opCreateMultiRegionAccessPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/async-requests/mrap/create",
	}

	if input == nil {
		input = &CreateMultiRegionAccessPointInput{}
	}

	output = &CreateMultiRegionAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CreateMultiRegionAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Creates a Multi-Region Access Point and associates it with the specified
// buckets. For more information about creating Multi-Region Access Points,
// see Creating Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// This request is asynchronous, meaning that you might receive a response before
// the command has completed. When this request provides a response, it provides
// a token that you can use to monitor the status of the request with DescribeMultiRegionAccessPointOperation.
//
// The following actions are related to CreateMultiRegionAccessPoint:
//
//   - DeleteMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
//
//   - DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
//
//   - GetMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
//
//   - ListMultiRegionAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateMultiRegionAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateMultiRegionAccessPoint
func (c *S3Control) CreateMultiRegionAccessPoint(input *CreateMultiRegionAccessPointInput) (*CreateMultiRegionAccessPointOutput, error) {
	req, out := c.CreateMultiRegionAccessPointRequest(input)
	return out, req.Send()
}

// CreateMultiRegionAccessPointWithContext is the same as CreateMultiRegionAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultiRegionAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateMultiRegionAccessPointWithContext(ctx aws.Context, input *CreateMultiRegionAccessPointInput, opts ...request.Option) (*CreateMultiRegionAccessPointOutput, error) {
	req, out := c.CreateMultiRegionAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorageLensGroup = "CreateStorageLensGroup"

// CreateStorageLensGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorageLensGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStorageLensGroup for more information on using the CreateStorageLensGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStorageLensGroupRequest method.
//	req, resp := client.CreateStorageLensGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateStorageLensGroup
func (c *S3Control) CreateStorageLensGroupRequest(input *CreateStorageLensGroupInput) (req *request.Request, output *CreateStorageLensGroupOutput) {
	op := &request.Operation{
		Name:       opCreateStorageLensGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/storagelensgroup",
	}

	if input == nil {
		input = &CreateStorageLensGroupInput{}
	}

	output = &CreateStorageLensGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateStorageLensGroup API operation for AWS S3 Control.
//
// Creates a new S3 Storage Lens group and associates it with the specified
// Amazon Web Services account ID. An S3 Storage Lens group is a custom grouping
// of objects based on prefix, suffix, object tags, object size, object age,
// or a combination of these filters. For each Storage Lens group that you’ve
// created, you can also optionally add Amazon Web Services resource tags. For
// more information about S3 Storage Lens groups, see Working with S3 Storage
// Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html).
//
// To use this operation, you must have the permission to perform the s3:CreateStorageLensGroup
// action. If you’re trying to create a Storage Lens group with Amazon Web
// Services resource tags, you must also have permission to perform the s3:TagResource
// action. For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about Storage Lens groups errors, see List of Amazon S3 Storage
// Lens error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateStorageLensGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateStorageLensGroup
func (c *S3Control) CreateStorageLensGroup(input *CreateStorageLensGroupInput) (*CreateStorageLensGroupOutput, error) {
	req, out := c.CreateStorageLensGroupRequest(input)
	return out, req.Send()
}

// CreateStorageLensGroupWithContext is the same as CreateStorageLensGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorageLensGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateStorageLensGroupWithContext(ctx aws.Context, input *CreateStorageLensGroupInput, opts ...request.Option) (*CreateStorageLensGroupOutput, error) {
	req, out := c.CreateStorageLensGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessGrant = "DeleteAccessGrant"

// DeleteAccessGrantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessGrant for more information on using the DeleteAccessGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessGrantRequest method.
//	req, resp := client.DeleteAccessGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrant
func (c *S3Control) DeleteAccessGrantRequest(input *DeleteAccessGrantInput) (req *request.Request, output *DeleteAccessGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessGrant,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accessgrantsinstance/grant/{id}",
	}

	if input == nil {
		input = &DeleteAccessGrantInput{}
	}

	output = &DeleteAccessGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteAccessGrant API operation for AWS S3 Control.
//
// Deletes the access grant from the S3 Access Grants instance. You cannot undo
// an access grant deletion and the grantee will no longer have access to the
// S3 data.
//
// # Permissions
//
// You must have the s3:DeleteAccessGrant permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessGrant for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrant
func (c *S3Control) DeleteAccessGrant(input *DeleteAccessGrantInput) (*DeleteAccessGrantOutput, error) {
	req, out := c.DeleteAccessGrantRequest(input)
	return out, req.Send()
}

// DeleteAccessGrantWithContext is the same as DeleteAccessGrant with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessGrantWithContext(ctx aws.Context, input *DeleteAccessGrantInput, opts ...request.Option) (*DeleteAccessGrantOutput, error) {
	req, out := c.DeleteAccessGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessGrantsInstance = "DeleteAccessGrantsInstance"

// DeleteAccessGrantsInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessGrantsInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessGrantsInstance for more information on using the DeleteAccessGrantsInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessGrantsInstanceRequest method.
//	req, resp := client.DeleteAccessGrantsInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstance
func (c *S3Control) DeleteAccessGrantsInstanceRequest(input *DeleteAccessGrantsInstanceInput) (req *request.Request, output *DeleteAccessGrantsInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessGrantsInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accessgrantsinstance",
	}

	if input == nil {
		input = &DeleteAccessGrantsInstanceInput{}
	}

	output = &DeleteAccessGrantsInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteAccessGrantsInstance API operation for AWS S3 Control.
//
// Deletes your S3 Access Grants instance. You must first delete the access
// grants and locations before S3 Access Grants can delete the instance. See
// DeleteAccessGrant (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html)
// and DeleteAccessGrantsLocation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrantsLocation.html).
// If you have associated an IAM Identity Center instance with your S3 Access
// Grants instance, you must first dissassociate the Identity Center instance
// from the S3 Access Grants instance before you can delete the S3 Access Grants
// instance. See AssociateAccessGrantsIdentityCenter (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_AssociateAccessGrantsIdentityCenter.html)
// and DissociateAccessGrantsIdentityCenter (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DissociateAccessGrantsIdentityCenter.html).
//
// # Permissions
//
// You must have the s3:DeleteAccessGrantsInstance permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessGrantsInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstance
func (c *S3Control) DeleteAccessGrantsInstance(input *DeleteAccessGrantsInstanceInput) (*DeleteAccessGrantsInstanceOutput, error) {
	req, out := c.DeleteAccessGrantsInstanceRequest(input)
	return out, req.Send()
}

// DeleteAccessGrantsInstanceWithContext is the same as DeleteAccessGrantsInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessGrantsInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessGrantsInstanceWithContext(ctx aws.Context, input *DeleteAccessGrantsInstanceInput, opts ...request.Option) (*DeleteAccessGrantsInstanceOutput, error) {
	req, out := c.DeleteAccessGrantsInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessGrantsInstanceResourcePolicy = "DeleteAccessGrantsInstanceResourcePolicy"

// DeleteAccessGrantsInstanceResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessGrantsInstanceResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessGrantsInstanceResourcePolicy for more information on using the DeleteAccessGrantsInstanceResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessGrantsInstanceResourcePolicyRequest method.
//	req, resp := client.DeleteAccessGrantsInstanceResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstanceResourcePolicy
func (c *S3Control) DeleteAccessGrantsInstanceResourcePolicyRequest(input *DeleteAccessGrantsInstanceResourcePolicyInput) (req *request.Request, output *DeleteAccessGrantsInstanceResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessGrantsInstanceResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accessgrantsinstance/resourcepolicy",
	}

	if input == nil {
		input = &DeleteAccessGrantsInstanceResourcePolicyInput{}
	}

	output = &DeleteAccessGrantsInstanceResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteAccessGrantsInstanceResourcePolicy API operation for AWS S3 Control.
//
// Deletes the resource policy of the S3 Access Grants instance. The resource
// policy is used to manage cross-account access to your S3 Access Grants instance.
// By deleting the resource policy, you delete any cross-account permissions
// to your S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:DeleteAccessGrantsInstanceResourcePolicy permission
// to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessGrantsInstanceResourcePolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsInstanceResourcePolicy
func (c *S3Control) DeleteAccessGrantsInstanceResourcePolicy(input *DeleteAccessGrantsInstanceResourcePolicyInput) (*DeleteAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.DeleteAccessGrantsInstanceResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessGrantsInstanceResourcePolicyWithContext is the same as DeleteAccessGrantsInstanceResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessGrantsInstanceResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessGrantsInstanceResourcePolicyWithContext(ctx aws.Context, input *DeleteAccessGrantsInstanceResourcePolicyInput, opts ...request.Option) (*DeleteAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.DeleteAccessGrantsInstanceResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessGrantsLocation = "DeleteAccessGrantsLocation"

// DeleteAccessGrantsLocationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessGrantsLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessGrantsLocation for more information on using the DeleteAccessGrantsLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessGrantsLocationRequest method.
//	req, resp := client.DeleteAccessGrantsLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsLocation
func (c *S3Control) DeleteAccessGrantsLocationRequest(input *DeleteAccessGrantsLocationInput) (req *request.Request, output *DeleteAccessGrantsLocationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessGrantsLocation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accessgrantsinstance/location/{id}",
	}

	if input == nil {
		input = &DeleteAccessGrantsLocationInput{}
	}

	output = &DeleteAccessGrantsLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteAccessGrantsLocation API operation for AWS S3 Control.
//
// Deregisters a location from your S3 Access Grants instance. You can only
// delete a location registration from an S3 Access Grants instance if there
// are no grants associated with this location. See Delete a grant (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessGrant.html)
// for information on how to delete grants. You need to have at least one registered
// location in your S3 Access Grants instance in order to create access grants.
//
// # Permissions
//
// You must have the s3:DeleteAccessGrantsLocation permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessGrantsLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessGrantsLocation
func (c *S3Control) DeleteAccessGrantsLocation(input *DeleteAccessGrantsLocationInput) (*DeleteAccessGrantsLocationOutput, error) {
	req, out := c.DeleteAccessGrantsLocationRequest(input)
	return out, req.Send()
}

// DeleteAccessGrantsLocationWithContext is the same as DeleteAccessGrantsLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessGrantsLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessGrantsLocationWithContext(ctx aws.Context, input *DeleteAccessGrantsLocationInput, opts ...request.Option) (*DeleteAccessGrantsLocationOutput, error) {
	req, out := c.DeleteAccessGrantsLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPoint = "DeleteAccessPoint"

// DeleteAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPoint for more information on using the DeleteAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPointRequest method.
//	req, resp := client.DeleteAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPointRequest(input *DeleteAccessPointInput) (req *request.Request, output *DeleteAccessPointOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &DeleteAccessPointInput{}
	}

	output = &DeleteAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples)
// section.
//
// The following actions are related to DeleteAccessPoint:
//
//   - CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//   - GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
//   - ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPoint(input *DeleteAccessPointInput) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	return out, req.Send()
}

// DeleteAccessPointWithContext is the same as DeleteAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointWithContext(ctx aws.Context, input *DeleteAccessPointInput, opts ...request.Option) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPointForObjectLambda = "DeleteAccessPointForObjectLambda"

// DeleteAccessPointForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPointForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPointForObjectLambda for more information on using the DeleteAccessPointForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPointForObjectLambdaRequest method.
//	req, resp := client.DeleteAccessPointForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointForObjectLambda
func (c *S3Control) DeleteAccessPointForObjectLambdaRequest(input *DeleteAccessPointForObjectLambdaInput) (req *request.Request, output *DeleteAccessPointForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPointForObjectLambda,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}",
	}

	if input == nil {
		input = &DeleteAccessPointForObjectLambdaInput{}
	}

	output = &DeleteAccessPointForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPointForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes the specified Object Lambda Access Point.
//
// The following actions are related to DeleteAccessPointForObjectLambda:
//
//   - CreateAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
//
//   - GetAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
//
//   - ListAccessPointsForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPointForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointForObjectLambda
func (c *S3Control) DeleteAccessPointForObjectLambda(input *DeleteAccessPointForObjectLambdaInput) (*DeleteAccessPointForObjectLambdaOutput, error) {
	req, out := c.DeleteAccessPointForObjectLambdaRequest(input)
	return out, req.Send()
}

// DeleteAccessPointForObjectLambdaWithContext is the same as DeleteAccessPointForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPointForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointForObjectLambdaWithContext(ctx aws.Context, input *DeleteAccessPointForObjectLambdaInput, opts ...request.Option) (*DeleteAccessPointForObjectLambdaOutput, error) {
	req, out := c.DeleteAccessPointForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPointPolicy = "DeleteAccessPointPolicy"

// DeleteAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPointPolicy for more information on using the DeleteAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPointPolicyRequest method.
//	req, resp := client.DeleteAccessPointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicyRequest(input *DeleteAccessPointPolicyInput) (req *request.Request, output *DeleteAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPointPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &DeleteAccessPointPolicyInput{}
	}

	output = &DeleteAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPointPolicy API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes the access point policy for the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples)
// section.
//
// The following actions are related to DeleteAccessPointPolicy:
//
//   - PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
//   - GetAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicy(input *DeleteAccessPointPolicyInput) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPointPolicyWithContext is the same as DeleteAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointPolicyWithContext(ctx aws.Context, input *DeleteAccessPointPolicyInput, opts ...request.Option) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPointPolicyForObjectLambda = "DeleteAccessPointPolicyForObjectLambda"

// DeleteAccessPointPolicyForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPointPolicyForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPointPolicyForObjectLambda for more information on using the DeleteAccessPointPolicyForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPointPolicyForObjectLambdaRequest method.
//	req, resp := client.DeleteAccessPointPolicyForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicyForObjectLambda
func (c *S3Control) DeleteAccessPointPolicyForObjectLambdaRequest(input *DeleteAccessPointPolicyForObjectLambdaInput) (req *request.Request, output *DeleteAccessPointPolicyForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPointPolicyForObjectLambda,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/policy",
	}

	if input == nil {
		input = &DeleteAccessPointPolicyForObjectLambdaInput{}
	}

	output = &DeleteAccessPointPolicyForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPointPolicyForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Removes the resource policy for an Object Lambda Access Point.
//
// The following actions are related to DeleteAccessPointPolicyForObjectLambda:
//
//   - GetAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
//
//   - PutAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPointPolicyForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicyForObjectLambda
func (c *S3Control) DeleteAccessPointPolicyForObjectLambda(input *DeleteAccessPointPolicyForObjectLambdaInput) (*DeleteAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.DeleteAccessPointPolicyForObjectLambdaRequest(input)
	return out, req.Send()
}

// DeleteAccessPointPolicyForObjectLambdaWithContext is the same as DeleteAccessPointPolicyForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPointPolicyForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointPolicyForObjectLambdaWithContext(ctx aws.Context, input *DeleteAccessPointPolicyForObjectLambdaInput, opts ...request.Option) (*DeleteAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.DeleteAccessPointPolicyForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketRequest method.
//	req, resp := client.DeleteBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucket
func (c *S3Control) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucket API operation for AWS S3 Control.
//
// This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket,
// see DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
// in the Amazon S3 API Reference.
//
// Deletes the Amazon S3 on Outposts bucket. All objects (including all object
// versions and delete markers) in the bucket must be deleted before the bucket
// itself can be deleted. For more information, see Using Amazon S3 on Outposts
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in Amazon S3 User Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples)
// section.
//
// Related Resources
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
//
//   - GetBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html)
//
//   - DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucket
func (c *S3Control) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketLifecycleConfiguration = "DeleteBucketLifecycleConfiguration"

// DeleteBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketLifecycleConfiguration for more information on using the DeleteBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketLifecycleConfigurationRequest method.
//	req, resp := client.DeleteBucketLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketLifecycleConfiguration
func (c *S3Control) DeleteBucketLifecycleConfigurationRequest(input *DeleteBucketLifecycleConfigurationInput) (req *request.Request, output *DeleteBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycleConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &DeleteBucketLifecycleConfigurationInput{}
	}

	output = &DeleteBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketLifecycleConfiguration API operation for AWS S3 Control.
//
// This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration.
// To delete an S3 bucket's lifecycle configuration, see DeleteBucketLifecycle
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
// in the Amazon S3 API Reference.
//
// Deletes the lifecycle configuration from the specified Outposts bucket. Amazon
// S3 on Outposts removes all the lifecycle configuration rules in the lifecycle
// subresource associated with the bucket. Your objects never expire, and Amazon
// S3 on Outposts no longer automatically deletes any objects on the basis of
// rules contained in the deleted lifecycle configuration. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in Amazon S3 User Guide.
//
// To use this operation, you must have permission to perform the s3-outposts:PutLifecycleConfiguration
// action. By default, the bucket owner has this permission and the Outposts
// bucket owner can grant this permission to others.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples)
// section.
//
// For more information about object expiration, see Elements to Describe Lifecycle
// Actions (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
//
// Related actions include:
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketLifecycleConfiguration
func (c *S3Control) DeleteBucketLifecycleConfiguration(input *DeleteBucketLifecycleConfigurationInput) (*DeleteBucketLifecycleConfigurationOutput, error) {
	req, out := c.DeleteBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketLifecycleConfigurationWithContext is the same as DeleteBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketLifecycleConfigurationWithContext(ctx aws.Context, input *DeleteBucketLifecycleConfigurationInput, opts ...request.Option) (*DeleteBucketLifecycleConfigurationOutput, error) {
	req, out := c.DeleteBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketPolicy for more information on using the DeleteBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketPolicyRequest method.
//	req, resp := client.DeleteBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketPolicy
func (c *S3Control) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	output = &DeleteBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketPolicy API operation for AWS S3 Control.
//
// This action deletes an Amazon S3 on Outposts bucket policy. To delete an
// S3 bucket policy, see DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html)
// in the Amazon S3 API Reference.
//
// This implementation of the DELETE action uses the policy subresource to delete
// the policy of a specified Amazon S3 on Outposts bucket. If you are using
// an identity other than the root user of the Amazon Web Services account that
// owns the bucket, the calling identity must have the s3-outposts:DeleteBucketPolicy
// permissions on the specified Outposts bucket and belong to the bucket owner's
// account to use this action. For more information, see Using Amazon S3 on
// Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in Amazon S3 User Guide.
//
// If you don't have DeleteBucketPolicy permissions, Amazon S3 returns a 403
// Access Denied error. If you have the correct permissions, but you're not
// using an identity that belongs to the bucket owner's account, Amazon S3 returns
// a 405 Method Not Allowed error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this action, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples)
// section.
//
// The following actions are related to DeleteBucketPolicy:
//
//   - GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
//
//   - PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketPolicy
func (c *S3Control) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	return out, req.Send()
}

// DeleteBucketPolicyWithContext is the same as DeleteBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketPolicyWithContext(ctx aws.Context, input *DeleteBucketPolicyInput, opts ...request.Option) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketReplication for more information on using the DeleteBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketReplicationRequest method.
//	req, resp := client.DeleteBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketReplication
func (c *S3Control) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) (req *request.Request, output *DeleteBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	output = &DeleteBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketReplication API operation for AWS S3 Control.
//
// This operation deletes an Amazon S3 on Outposts bucket's replication configuration.
// To delete an S3 bucket's replication configuration, see DeleteBucketReplication
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html)
// in the Amazon S3 API Reference.
//
// Deletes the replication configuration from the specified S3 on Outposts bucket.
//
// To use this operation, you must have permissions to perform the s3-outposts:PutReplicationConfiguration
// action. The Outposts bucket owner has this permission by default and can
// grant it to others. For more information about permissions, see Setting up
// IAM with S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html)
// and Managing access to S3 on Outposts buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html)
// in the Amazon S3 User Guide.
//
// It can take a while to propagate PUT or DELETE requests for a replication
// configuration to all S3 on Outposts systems. Therefore, the replication configuration
// that's returned by a GET request soon after a PUT or DELETE request might
// return a more recent result than what's on the Outpost. If an Outpost is
// offline, the delay in updating the replication configuration on that Outpost
// can be significant.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html#API_control_DeleteBucketReplication_Examples)
// section.
//
// For information about S3 replication on Outposts configuration, see Replicating
// objects for S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html)
// in the Amazon S3 User Guide.
//
// The following operations are related to DeleteBucketReplication:
//
//   - PutBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
//
//   - GetBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketReplication
func (c *S3Control) DeleteBucketReplication(input *DeleteBucketReplicationInput) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	return out, req.Send()
}

// DeleteBucketReplicationWithContext is the same as DeleteBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketReplicationWithContext(ctx aws.Context, input *DeleteBucketReplicationInput, opts ...request.Option) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketTagging for more information on using the DeleteBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBucketTaggingRequest method.
//	req, resp := client.DeleteBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketTagging
func (c *S3Control) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	output = &DeleteBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBucketTagging API operation for AWS S3 Control.
//
// This action deletes an Amazon S3 on Outposts bucket's tags. To delete an
// S3 bucket tags, see DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html)
// in the Amazon S3 API Reference.
//
// Deletes the tags from the Outposts bucket. For more information, see Using
// Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the PutBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples)
// section.
//
// The following actions are related to DeleteBucketTagging:
//
//   - GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
//
//   - PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteBucketTagging
func (c *S3Control) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	return out, req.Send()
}

// DeleteBucketTaggingWithContext is the same as DeleteBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteBucketTaggingWithContext(ctx aws.Context, input *DeleteBucketTaggingInput, opts ...request.Option) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobTagging = "DeleteJobTagging"

// DeleteJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobTagging for more information on using the DeleteJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteJobTaggingRequest method.
//	req, resp := client.DeleteJobTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTaggingRequest(input *DeleteJobTaggingInput) (req *request.Request, output *DeleteJobTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteJobTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &DeleteJobTaggingInput{}
	}

	output = &DeleteJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteJobTagging API operation for AWS S3 Control.
//
// Removes the entire tag set from the specified S3 Batch Operations job.
//
// # Permissions
//
// To use the DeleteJobTagging operation, you must have permission to perform
// the s3:DeleteJobTagging action. For more information, see Controlling access
// and labeling jobs using tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon S3 User Guide.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
//
//   - PutJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteJobTagging for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTagging(input *DeleteJobTaggingInput) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	return out, req.Send()
}

// DeleteJobTaggingWithContext is the same as DeleteJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteJobTaggingWithContext(ctx aws.Context, input *DeleteJobTaggingInput, opts ...request.Option) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMultiRegionAccessPoint = "DeleteMultiRegionAccessPoint"

// DeleteMultiRegionAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMultiRegionAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMultiRegionAccessPoint for more information on using the DeleteMultiRegionAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMultiRegionAccessPointRequest method.
//	req, resp := client.DeleteMultiRegionAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteMultiRegionAccessPoint
func (c *S3Control) DeleteMultiRegionAccessPointRequest(input *DeleteMultiRegionAccessPointInput) (req *request.Request, output *DeleteMultiRegionAccessPointOutput) {
	op := &request.Operation{
		Name:       opDeleteMultiRegionAccessPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/async-requests/mrap/delete",
	}

	if input == nil {
		input = &DeleteMultiRegionAccessPointInput{}
	}

	output = &DeleteMultiRegionAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteMultiRegionAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes a Multi-Region Access Point. This action does not delete the buckets
// associated with the Multi-Region Access Point, only the Multi-Region Access
// Point itself.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// This request is asynchronous, meaning that you might receive a response before
// the command has completed. When this request provides a response, it provides
// a token that you can use to monitor the status of the request with DescribeMultiRegionAccessPointOperation.
//
// The following actions are related to DeleteMultiRegionAccessPoint:
//
//   - CreateMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
//
//   - DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
//
//   - GetMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
//
//   - ListMultiRegionAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteMultiRegionAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteMultiRegionAccessPoint
func (c *S3Control) DeleteMultiRegionAccessPoint(input *DeleteMultiRegionAccessPointInput) (*DeleteMultiRegionAccessPointOutput, error) {
	req, out := c.DeleteMultiRegionAccessPointRequest(input)
	return out, req.Send()
}

// DeleteMultiRegionAccessPointWithContext is the same as DeleteMultiRegionAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMultiRegionAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteMultiRegionAccessPointWithContext(ctx aws.Context, input *DeleteMultiRegionAccessPointInput, opts ...request.Option) (*DeleteMultiRegionAccessPointOutput, error) {
	req, out := c.DeleteMultiRegionAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicAccessBlock = "DeletePublicAccessBlock"

// DeletePublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicAccessBlock for more information on using the DeletePublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePublicAccessBlockRequest method.
//	req, resp := client.DeletePublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlockRequest(input *DeletePublicAccessBlockInput) (req *request.Request, output *DeletePublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opDeletePublicAccessBlock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &DeletePublicAccessBlockInput{}
	}

	output = &DeletePublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePublicAccessBlock API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Removes the PublicAccessBlock configuration for an Amazon Web Services account.
// For more information, see Using Amazon S3 block public access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
//
//   - PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeletePublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlock(input *DeletePublicAccessBlockInput) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	return out, req.Send()
}

// DeletePublicAccessBlockWithContext is the same as DeletePublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeletePublicAccessBlockWithContext(ctx aws.Context, input *DeletePublicAccessBlockInput, opts ...request.Option) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageLensConfiguration = "DeleteStorageLensConfiguration"

// DeleteStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageLensConfiguration for more information on using the DeleteStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStorageLensConfigurationRequest method.
//	req, resp := client.DeleteStorageLensConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfiguration
func (c *S3Control) DeleteStorageLensConfigurationRequest(input *DeleteStorageLensConfigurationInput) (req *request.Request, output *DeleteStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageLensConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &DeleteStorageLensConfigurationInput{}
	}

	output = &DeleteStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageLensConfiguration API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes the Amazon S3 Storage Lens configuration. For more information about
// S3 Storage Lens, see Assessing your storage activity and usage with Amazon
// S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:DeleteStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfiguration
func (c *S3Control) DeleteStorageLensConfiguration(input *DeleteStorageLensConfigurationInput) (*DeleteStorageLensConfigurationOutput, error) {
	req, out := c.DeleteStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// DeleteStorageLensConfigurationWithContext is the same as DeleteStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteStorageLensConfigurationWithContext(ctx aws.Context, input *DeleteStorageLensConfigurationInput, opts ...request.Option) (*DeleteStorageLensConfigurationOutput, error) {
	req, out := c.DeleteStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageLensConfigurationTagging = "DeleteStorageLensConfigurationTagging"

// DeleteStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageLensConfigurationTagging for more information on using the DeleteStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStorageLensConfigurationTaggingRequest method.
//	req, resp := client.DeleteStorageLensConfigurationTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfigurationTagging
func (c *S3Control) DeleteStorageLensConfigurationTaggingRequest(input *DeleteStorageLensConfigurationTaggingInput) (req *request.Request, output *DeleteStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageLensConfigurationTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &DeleteStorageLensConfigurationTaggingInput{}
	}

	output = &DeleteStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Deletes the Amazon S3 Storage Lens configuration tags. For more information
// about S3 Storage Lens, see Assessing your storage activity and usage with
// Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:DeleteStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensConfigurationTagging
func (c *S3Control) DeleteStorageLensConfigurationTagging(input *DeleteStorageLensConfigurationTaggingInput) (*DeleteStorageLensConfigurationTaggingOutput, error) {
	req, out := c.DeleteStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// DeleteStorageLensConfigurationTaggingWithContext is the same as DeleteStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *DeleteStorageLensConfigurationTaggingInput, opts ...request.Option) (*DeleteStorageLensConfigurationTaggingOutput, error) {
	req, out := c.DeleteStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageLensGroup = "DeleteStorageLensGroup"

// DeleteStorageLensGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageLensGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageLensGroup for more information on using the DeleteStorageLensGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStorageLensGroupRequest method.
//	req, resp := client.DeleteStorageLensGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensGroup
func (c *S3Control) DeleteStorageLensGroupRequest(input *DeleteStorageLensGroupInput) (req *request.Request, output *DeleteStorageLensGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageLensGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/storagelensgroup/{name}",
	}

	if input == nil {
		input = &DeleteStorageLensGroupInput{}
	}

	output = &DeleteStorageLensGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageLensGroup API operation for AWS S3 Control.
//
// Deletes an existing S3 Storage Lens group.
//
// To use this operation, you must have the permission to perform the s3:DeleteStorageLensGroup
// action. For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about Storage Lens groups errors, see List of Amazon S3 Storage
// Lens error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteStorageLensGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteStorageLensGroup
func (c *S3Control) DeleteStorageLensGroup(input *DeleteStorageLensGroupInput) (*DeleteStorageLensGroupOutput, error) {
	req, out := c.DeleteStorageLensGroupRequest(input)
	return out, req.Send()
}

// DeleteStorageLensGroupWithContext is the same as DeleteStorageLensGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageLensGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteStorageLensGroupWithContext(ctx aws.Context, input *DeleteStorageLensGroupInput, opts ...request.Option) (*DeleteStorageLensGroupOutput, error) {
	req, out := c.DeleteStorageLensGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeJobRequest method.
//	req, resp := client.DescribeJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeJob API operation for AWS S3 Control.
//
// Retrieves the configuration parameters and status for a Batch Operations
// job. For more information, see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// To use the DescribeJob operation, you must have permission to perform the
// s3:DescribeJob action.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//   - UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//   - UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DescribeJob for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeBadRequestException "BadRequestException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMultiRegionAccessPointOperation = "DescribeMultiRegionAccessPointOperation"

// DescribeMultiRegionAccessPointOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMultiRegionAccessPointOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMultiRegionAccessPointOperation for more information on using the DescribeMultiRegionAccessPointOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMultiRegionAccessPointOperationRequest method.
//	req, resp := client.DescribeMultiRegionAccessPointOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeMultiRegionAccessPointOperation
func (c *S3Control) DescribeMultiRegionAccessPointOperationRequest(input *DescribeMultiRegionAccessPointOperationInput) (req *request.Request, output *DescribeMultiRegionAccessPointOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeMultiRegionAccessPointOperation,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/async-requests/mrap/{request_token+}",
	}

	if input == nil {
		input = &DescribeMultiRegionAccessPointOperationInput{}
	}

	output = &DescribeMultiRegionAccessPointOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DescribeMultiRegionAccessPointOperation API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Retrieves the status of an asynchronous request to manage a Multi-Region
// Access Point. For more information about managing Multi-Region Access Points
// and how asynchronous requests work, see Managing Multi-Region Access Points
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to GetMultiRegionAccessPoint:
//
//   - CreateMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
//
//   - DeleteMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
//
//   - GetMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
//
//   - ListMultiRegionAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DescribeMultiRegionAccessPointOperation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeMultiRegionAccessPointOperation
func (c *S3Control) DescribeMultiRegionAccessPointOperation(input *DescribeMultiRegionAccessPointOperationInput) (*DescribeMultiRegionAccessPointOperationOutput, error) {
	req, out := c.DescribeMultiRegionAccessPointOperationRequest(input)
	return out, req.Send()
}

// DescribeMultiRegionAccessPointOperationWithContext is the same as DescribeMultiRegionAccessPointOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMultiRegionAccessPointOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DescribeMultiRegionAccessPointOperationWithContext(ctx aws.Context, input *DescribeMultiRegionAccessPointOperationInput, opts ...request.Option) (*DescribeMultiRegionAccessPointOperationOutput, error) {
	req, out := c.DescribeMultiRegionAccessPointOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDissociateAccessGrantsIdentityCenter = "DissociateAccessGrantsIdentityCenter"

// DissociateAccessGrantsIdentityCenterRequest generates a "aws/request.Request" representing the
// client's request for the DissociateAccessGrantsIdentityCenter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DissociateAccessGrantsIdentityCenter for more information on using the DissociateAccessGrantsIdentityCenter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DissociateAccessGrantsIdentityCenterRequest method.
//	req, resp := client.DissociateAccessGrantsIdentityCenterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DissociateAccessGrantsIdentityCenter
func (c *S3Control) DissociateAccessGrantsIdentityCenterRequest(input *DissociateAccessGrantsIdentityCenterInput) (req *request.Request, output *DissociateAccessGrantsIdentityCenterOutput) {
	op := &request.Operation{
		Name:       opDissociateAccessGrantsIdentityCenter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accessgrantsinstance/identitycenter",
	}

	if input == nil {
		input = &DissociateAccessGrantsIdentityCenterInput{}
	}

	output = &DissociateAccessGrantsIdentityCenterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DissociateAccessGrantsIdentityCenter API operation for AWS S3 Control.
//
// Dissociates the Amazon Web Services IAM Identity Center instance from the
// S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:DissociateAccessGrantsIdentityCenter permission to use
// this operation.
//
// # Additional Permissions
//
// You must have the sso:DeleteApplication permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DissociateAccessGrantsIdentityCenter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DissociateAccessGrantsIdentityCenter
func (c *S3Control) DissociateAccessGrantsIdentityCenter(input *DissociateAccessGrantsIdentityCenterInput) (*DissociateAccessGrantsIdentityCenterOutput, error) {
	req, out := c.DissociateAccessGrantsIdentityCenterRequest(input)
	return out, req.Send()
}

// DissociateAccessGrantsIdentityCenterWithContext is the same as DissociateAccessGrantsIdentityCenter with the addition of
// the ability to pass a context and additional request options.
//
// See DissociateAccessGrantsIdentityCenter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DissociateAccessGrantsIdentityCenterWithContext(ctx aws.Context, input *DissociateAccessGrantsIdentityCenterInput, opts ...request.Option) (*DissociateAccessGrantsIdentityCenterOutput, error) {
	req, out := c.DissociateAccessGrantsIdentityCenterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessGrant = "GetAccessGrant"

// GetAccessGrantRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessGrant for more information on using the GetAccessGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessGrantRequest method.
//	req, resp := client.GetAccessGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrant
func (c *S3Control) GetAccessGrantRequest(input *GetAccessGrantInput) (req *request.Request, output *GetAccessGrantOutput) {
	op := &request.Operation{
		Name:       opGetAccessGrant,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/grant/{id}",
	}

	if input == nil {
		input = &GetAccessGrantInput{}
	}

	output = &GetAccessGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetAccessGrant API operation for AWS S3 Control.
//
// Get the details of an access grant from your S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:GetAccessGrant permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessGrant for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrant
func (c *S3Control) GetAccessGrant(input *GetAccessGrantInput) (*GetAccessGrantOutput, error) {
	req, out := c.GetAccessGrantRequest(input)
	return out, req.Send()
}

// GetAccessGrantWithContext is the same as GetAccessGrant with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessGrantWithContext(ctx aws.Context, input *GetAccessGrantInput, opts ...request.Option) (*GetAccessGrantOutput, error) {
	req, out := c.GetAccessGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessGrantsInstance = "GetAccessGrantsInstance"

// GetAccessGrantsInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessGrantsInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessGrantsInstance for more information on using the GetAccessGrantsInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessGrantsInstanceRequest method.
//	req, resp := client.GetAccessGrantsInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstance
func (c *S3Control) GetAccessGrantsInstanceRequest(input *GetAccessGrantsInstanceInput) (req *request.Request, output *GetAccessGrantsInstanceOutput) {
	op := &request.Operation{
		Name:       opGetAccessGrantsInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance",
	}

	if input == nil {
		input = &GetAccessGrantsInstanceInput{}
	}

	output = &GetAccessGrantsInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetAccessGrantsInstance API operation for AWS S3 Control.
//
// Retrieves the S3 Access Grants instance for a Region in your account.
//
// # Permissions
//
// You must have the s3:GetAccessGrantsInstance permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessGrantsInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstance
func (c *S3Control) GetAccessGrantsInstance(input *GetAccessGrantsInstanceInput) (*GetAccessGrantsInstanceOutput, error) {
	req, out := c.GetAccessGrantsInstanceRequest(input)
	return out, req.Send()
}

// GetAccessGrantsInstanceWithContext is the same as GetAccessGrantsInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessGrantsInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessGrantsInstanceWithContext(ctx aws.Context, input *GetAccessGrantsInstanceInput, opts ...request.Option) (*GetAccessGrantsInstanceOutput, error) {
	req, out := c.GetAccessGrantsInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessGrantsInstanceForPrefix = "GetAccessGrantsInstanceForPrefix"

// GetAccessGrantsInstanceForPrefixRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessGrantsInstanceForPrefix operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessGrantsInstanceForPrefix for more information on using the GetAccessGrantsInstanceForPrefix
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessGrantsInstanceForPrefixRequest method.
//	req, resp := client.GetAccessGrantsInstanceForPrefixRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceForPrefix
func (c *S3Control) GetAccessGrantsInstanceForPrefixRequest(input *GetAccessGrantsInstanceForPrefixInput) (req *request.Request, output *GetAccessGrantsInstanceForPrefixOutput) {
	op := &request.Operation{
		Name:       opGetAccessGrantsInstanceForPrefix,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/prefix",
	}

	if input == nil {
		input = &GetAccessGrantsInstanceForPrefixInput{}
	}

	output = &GetAccessGrantsInstanceForPrefixOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetAccessGrantsInstanceForPrefix API operation for AWS S3 Control.
//
// Retrieve the S3 Access Grants instance that contains a particular prefix.
//
// # Permissions
//
// You must have the s3:GetAccessGrantsInstanceForPrefix permission for the
// caller account to use this operation.
//
// # Additional Permissions
//
// The prefix owner account must grant you the following permissions to their
// S3 Access Grants instance: s3:GetAccessGrantsInstanceForPrefix.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessGrantsInstanceForPrefix for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceForPrefix
func (c *S3Control) GetAccessGrantsInstanceForPrefix(input *GetAccessGrantsInstanceForPrefixInput) (*GetAccessGrantsInstanceForPrefixOutput, error) {
	req, out := c.GetAccessGrantsInstanceForPrefixRequest(input)
	return out, req.Send()
}

// GetAccessGrantsInstanceForPrefixWithContext is the same as GetAccessGrantsInstanceForPrefix with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessGrantsInstanceForPrefix for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessGrantsInstanceForPrefixWithContext(ctx aws.Context, input *GetAccessGrantsInstanceForPrefixInput, opts ...request.Option) (*GetAccessGrantsInstanceForPrefixOutput, error) {
	req, out := c.GetAccessGrantsInstanceForPrefixRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessGrantsInstanceResourcePolicy = "GetAccessGrantsInstanceResourcePolicy"

// GetAccessGrantsInstanceResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessGrantsInstanceResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessGrantsInstanceResourcePolicy for more information on using the GetAccessGrantsInstanceResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessGrantsInstanceResourcePolicyRequest method.
//	req, resp := client.GetAccessGrantsInstanceResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceResourcePolicy
func (c *S3Control) GetAccessGrantsInstanceResourcePolicyRequest(input *GetAccessGrantsInstanceResourcePolicyInput) (req *request.Request, output *GetAccessGrantsInstanceResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccessGrantsInstanceResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/resourcepolicy",
	}

	if input == nil {
		input = &GetAccessGrantsInstanceResourcePolicyInput{}
	}

	output = &GetAccessGrantsInstanceResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetAccessGrantsInstanceResourcePolicy API operation for AWS S3 Control.
//
// Returns the resource policy of the S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:GetAccessGrantsInstanceResourcePolicy permission to
// use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessGrantsInstanceResourcePolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsInstanceResourcePolicy
func (c *S3Control) GetAccessGrantsInstanceResourcePolicy(input *GetAccessGrantsInstanceResourcePolicyInput) (*GetAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.GetAccessGrantsInstanceResourcePolicyRequest(input)
	return out, req.Send()
}

// GetAccessGrantsInstanceResourcePolicyWithContext is the same as GetAccessGrantsInstanceResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessGrantsInstanceResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessGrantsInstanceResourcePolicyWithContext(ctx aws.Context, input *GetAccessGrantsInstanceResourcePolicyInput, opts ...request.Option) (*GetAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.GetAccessGrantsInstanceResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessGrantsLocation = "GetAccessGrantsLocation"

// GetAccessGrantsLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessGrantsLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessGrantsLocation for more information on using the GetAccessGrantsLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessGrantsLocationRequest method.
//	req, resp := client.GetAccessGrantsLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsLocation
func (c *S3Control) GetAccessGrantsLocationRequest(input *GetAccessGrantsLocationInput) (req *request.Request, output *GetAccessGrantsLocationOutput) {
	op := &request.Operation{
		Name:       opGetAccessGrantsLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/location/{id}",
	}

	if input == nil {
		input = &GetAccessGrantsLocationInput{}
	}

	output = &GetAccessGrantsLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetAccessGrantsLocation API operation for AWS S3 Control.
//
// Retrieves the details of a particular location registered in your S3 Access
// Grants instance.
//
// # Permissions
//
// You must have the s3:GetAccessGrantsLocation permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessGrantsLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessGrantsLocation
func (c *S3Control) GetAccessGrantsLocation(input *GetAccessGrantsLocationInput) (*GetAccessGrantsLocationOutput, error) {
	req, out := c.GetAccessGrantsLocationRequest(input)
	return out, req.Send()
}

// GetAccessGrantsLocationWithContext is the same as GetAccessGrantsLocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessGrantsLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessGrantsLocationWithContext(ctx aws.Context, input *GetAccessGrantsLocationInput, opts ...request.Option) (*GetAccessGrantsLocationOutput, error) {
	req, out := c.GetAccessGrantsLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPoint = "GetAccessPoint"

// GetAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPoint for more information on using the GetAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointRequest method.
//	req, resp := client.GetAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPointRequest(input *GetAccessPointInput) (req *request.Request, output *GetAccessPointOutput) {
	op := &request.Operation{
		Name:       opGetAccessPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &GetAccessPointInput{}
	}

	output = &GetAccessPointOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns configuration information about the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples)
// section.
//
// The following actions are related to GetAccessPoint:
//
//   - CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//   - DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//   - ListAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPoint(input *GetAccessPointInput) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	return out, req.Send()
}

// GetAccessPointWithContext is the same as GetAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointWithContext(ctx aws.Context, input *GetAccessPointInput, opts ...request.Option) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointConfigurationForObjectLambda = "GetAccessPointConfigurationForObjectLambda"

// GetAccessPointConfigurationForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointConfigurationForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointConfigurationForObjectLambda for more information on using the GetAccessPointConfigurationForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointConfigurationForObjectLambdaRequest method.
//	req, resp := client.GetAccessPointConfigurationForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointConfigurationForObjectLambda
func (c *S3Control) GetAccessPointConfigurationForObjectLambdaRequest(input *GetAccessPointConfigurationForObjectLambdaInput) (req *request.Request, output *GetAccessPointConfigurationForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointConfigurationForObjectLambda,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/configuration",
	}

	if input == nil {
		input = &GetAccessPointConfigurationForObjectLambdaInput{}
	}

	output = &GetAccessPointConfigurationForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointConfigurationForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns configuration for an Object Lambda Access Point.
//
// The following actions are related to GetAccessPointConfigurationForObjectLambda:
//
//   - PutAccessPointConfigurationForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointConfigurationForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointConfigurationForObjectLambda
func (c *S3Control) GetAccessPointConfigurationForObjectLambda(input *GetAccessPointConfigurationForObjectLambdaInput) (*GetAccessPointConfigurationForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointConfigurationForObjectLambdaRequest(input)
	return out, req.Send()
}

// GetAccessPointConfigurationForObjectLambdaWithContext is the same as GetAccessPointConfigurationForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointConfigurationForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointConfigurationForObjectLambdaWithContext(ctx aws.Context, input *GetAccessPointConfigurationForObjectLambdaInput, opts ...request.Option) (*GetAccessPointConfigurationForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointConfigurationForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointForObjectLambda = "GetAccessPointForObjectLambda"

// GetAccessPointForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointForObjectLambda for more information on using the GetAccessPointForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointForObjectLambdaRequest method.
//	req, resp := client.GetAccessPointForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointForObjectLambda
func (c *S3Control) GetAccessPointForObjectLambdaRequest(input *GetAccessPointForObjectLambdaInput) (req *request.Request, output *GetAccessPointForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointForObjectLambda,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}",
	}

	if input == nil {
		input = &GetAccessPointForObjectLambdaInput{}
	}

	output = &GetAccessPointForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns configuration information about the specified Object Lambda Access
// Point
//
// The following actions are related to GetAccessPointForObjectLambda:
//
//   - CreateAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
//
//   - DeleteAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
//
//   - ListAccessPointsForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointForObjectLambda
func (c *S3Control) GetAccessPointForObjectLambda(input *GetAccessPointForObjectLambdaInput) (*GetAccessPointForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointForObjectLambdaRequest(input)
	return out, req.Send()
}

// GetAccessPointForObjectLambdaWithContext is the same as GetAccessPointForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointForObjectLambdaWithContext(ctx aws.Context, input *GetAccessPointForObjectLambdaInput, opts ...request.Option) (*GetAccessPointForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicy = "GetAccessPointPolicy"

// GetAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicy for more information on using the GetAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointPolicyRequest method.
//	req, resp := client.GetAccessPointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicyRequest(input *GetAccessPointPolicyInput) (req *request.Request, output *GetAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &GetAccessPointPolicyInput{}
	}

	output = &GetAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicy API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns the access point policy associated with the specified access point.
//
// The following actions are related to GetAccessPointPolicy:
//
//   - PutAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html)
//
//   - DeleteAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicy(input *GetAccessPointPolicyInput) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyWithContext is the same as GetAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyWithContext(ctx aws.Context, input *GetAccessPointPolicyInput, opts ...request.Option) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicyForObjectLambda = "GetAccessPointPolicyForObjectLambda"

// GetAccessPointPolicyForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicyForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicyForObjectLambda for more information on using the GetAccessPointPolicyForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointPolicyForObjectLambdaRequest method.
//	req, resp := client.GetAccessPointPolicyForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyForObjectLambda
func (c *S3Control) GetAccessPointPolicyForObjectLambdaRequest(input *GetAccessPointPolicyForObjectLambdaInput) (req *request.Request, output *GetAccessPointPolicyForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicyForObjectLambda,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/policy",
	}

	if input == nil {
		input = &GetAccessPointPolicyForObjectLambdaInput{}
	}

	output = &GetAccessPointPolicyForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicyForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns the resource policy for an Object Lambda Access Point.
//
// The following actions are related to GetAccessPointPolicyForObjectLambda:
//
//   - DeleteAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
//
//   - PutAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicyForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyForObjectLambda
func (c *S3Control) GetAccessPointPolicyForObjectLambda(input *GetAccessPointPolicyForObjectLambdaInput) (*GetAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointPolicyForObjectLambdaRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyForObjectLambdaWithContext is the same as GetAccessPointPolicyForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicyForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyForObjectLambdaWithContext(ctx aws.Context, input *GetAccessPointPolicyForObjectLambdaInput, opts ...request.Option) (*GetAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointPolicyForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicyStatus = "GetAccessPointPolicyStatus"

// GetAccessPointPolicyStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicyStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicyStatus for more information on using the GetAccessPointPolicyStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointPolicyStatusRequest method.
//	req, resp := client.GetAccessPointPolicyStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatusRequest(input *GetAccessPointPolicyStatusInput) (req *request.Request, output *GetAccessPointPolicyStatusOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policyStatus",
	}

	if input == nil {
		input = &GetAccessPointPolicyStatusInput{}
	}

	output = &GetAccessPointPolicyStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicyStatus API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Indicates whether the specified access point currently has a policy that
// allows public access. For more information about public access through access
// points, see Managing Data Access with Amazon S3 access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicyStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatus(input *GetAccessPointPolicyStatusInput) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyStatusWithContext is the same as GetAccessPointPolicyStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicyStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyStatusWithContext(ctx aws.Context, input *GetAccessPointPolicyStatusInput, opts ...request.Option) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicyStatusForObjectLambda = "GetAccessPointPolicyStatusForObjectLambda"

// GetAccessPointPolicyStatusForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicyStatusForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicyStatusForObjectLambda for more information on using the GetAccessPointPolicyStatusForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPointPolicyStatusForObjectLambdaRequest method.
//	req, resp := client.GetAccessPointPolicyStatusForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatusForObjectLambda
func (c *S3Control) GetAccessPointPolicyStatusForObjectLambdaRequest(input *GetAccessPointPolicyStatusForObjectLambdaInput) (req *request.Request, output *GetAccessPointPolicyStatusForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicyStatusForObjectLambda,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/policyStatus",
	}

	if input == nil {
		input = &GetAccessPointPolicyStatusForObjectLambdaInput{}
	}

	output = &GetAccessPointPolicyStatusForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicyStatusForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns the status of the resource policy associated with an Object Lambda
// Access Point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicyStatusForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatusForObjectLambda
func (c *S3Control) GetAccessPointPolicyStatusForObjectLambda(input *GetAccessPointPolicyStatusForObjectLambdaInput) (*GetAccessPointPolicyStatusForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointPolicyStatusForObjectLambdaRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyStatusForObjectLambdaWithContext is the same as GetAccessPointPolicyStatusForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicyStatusForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyStatusForObjectLambdaWithContext(ctx aws.Context, input *GetAccessPointPolicyStatusForObjectLambdaInput, opts ...request.Option) (*GetAccessPointPolicyStatusForObjectLambdaOutput, error) {
	req, out := c.GetAccessPointPolicyStatusForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucket = "GetBucket"

// GetBucketRequest generates a "aws/request.Request" representing the
// client's request for the GetBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucket for more information on using the GetBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketRequest method.
//	req, resp := client.GetBucketRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucket
func (c *S3Control) GetBucketRequest(input *GetBucketInput) (req *request.Request, output *GetBucketOutput) {
	op := &request.Operation{
		Name:       opGetBucket,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}",
	}

	if input == nil {
		input = &GetBucketInput{}
	}

	output = &GetBucketOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucket API operation for AWS S3 Control.
//
// Gets an Amazon S3 on Outposts bucket. For more information, see Using Amazon
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// If you are using an identity other than the root user of the Amazon Web Services
// account that owns the Outposts bucket, the calling identity must have the
// s3-outposts:GetBucket permissions on the specified Outposts bucket and belong
// to the Outposts bucket owner's account in order to use this action. Only
// users from Outposts bucket owner account with the right permissions can perform
// actions on an Outposts bucket.
//
// If you don't have s3-outposts:GetBucket permissions or you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 403 Access Denied error.
//
// The following actions are related to GetBucket for Amazon S3 on Outposts:
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples)
// section.
//
//   - PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//   - CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html)
//
//   - DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucket
func (c *S3Control) GetBucket(input *GetBucketInput) (*GetBucketOutput, error) {
	req, out := c.GetBucketRequest(input)
	return out, req.Send()
}

// GetBucketWithContext is the same as GetBucket with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketWithContext(ctx aws.Context, input *GetBucketInput, opts ...request.Option) (*GetBucketOutput, error) {
	req, out := c.GetBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycleConfiguration for more information on using the GetBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//	req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketLifecycleConfiguration
func (c *S3Control) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output = &GetBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketLifecycleConfiguration API operation for AWS S3 Control.
//
// This action gets an Amazon S3 on Outposts bucket's lifecycle configuration.
// To get an S3 bucket's lifecycle configuration, see GetBucketLifecycleConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
// in the Amazon S3 API Reference.
//
// Returns the lifecycle configuration information set on the Outposts bucket.
// For more information, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// and for information about lifecycle configuration, see Object Lifecycle Management
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3-outposts:GetLifecycleConfiguration
// action. The Outposts bucket owner has this permission, by default. The bucket
// owner can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples)
// section.
//
// GetBucketLifecycleConfiguration has the following special error:
//
//   - Error code: NoSuchLifecycleConfiguration Description: The lifecycle
//     configuration does not exist. HTTP Status Code: 404 Not Found SOAP Fault
//     Code Prefix: Client
//
// The following actions are related to GetBucketLifecycleConfiguration:
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//   - DeleteBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketLifecycleConfiguration
func (c *S3Control) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleConfigurationWithContext is the same as GetBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketLifecycleConfigurationWithContext(ctx aws.Context, input *GetBucketLifecycleConfigurationInput, opts ...request.Option) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketPolicy for more information on using the GetBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketPolicyRequest method.
//	req, resp := client.GetBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketPolicy
func (c *S3Control) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	output = &GetBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketPolicy API operation for AWS S3 Control.
//
// This action gets a bucket policy for an Amazon S3 on Outposts bucket. To
// get a policy for an S3 bucket, see GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html)
// in the Amazon S3 API Reference.
//
// Returns the policy of a specified Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// If you are using an identity other than the root user of the Amazon Web Services
// account that owns the bucket, the calling identity must have the GetBucketPolicy
// permissions on the specified bucket and belong to the bucket owner's account
// in order to use this action.
//
// Only users from Outposts bucket owner account with the right permissions
// can perform actions on an Outposts bucket. If you don't have s3-outposts:GetBucketPolicy
// permissions or you're not using an identity that belongs to the bucket owner's
// account, Amazon S3 returns a 403 Access Denied error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this action, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples)
// section.
//
// The following actions are related to GetBucketPolicy:
//
//   - GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//   - PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html)
//
//   - DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketPolicy
func (c *S3Control) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	return out, req.Send()
}

// GetBucketPolicyWithContext is the same as GetBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketPolicyWithContext(ctx aws.Context, input *GetBucketPolicyInput, opts ...request.Option) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketReplication for more information on using the GetBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketReplicationRequest method.
//	req, resp := client.GetBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketReplication
func (c *S3Control) GetBucketReplicationRequest(input *GetBucketReplicationInput) (req *request.Request, output *GetBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	output = &GetBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketReplication API operation for AWS S3 Control.
//
// This operation gets an Amazon S3 on Outposts bucket's replication configuration.
// To get an S3 bucket's replication configuration, see GetBucketReplication
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html)
// in the Amazon S3 API Reference.
//
// Returns the replication configuration of an S3 on Outposts bucket. For more
// information about S3 on Outposts, see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide. For information about S3 replication on Outposts
// configuration, see Replicating objects for S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html)
// in the Amazon S3 User Guide.
//
// It can take a while to propagate PUT or DELETE requests for a replication
// configuration to all S3 on Outposts systems. Therefore, the replication configuration
// that's returned by a GET request soon after a PUT or DELETE request might
// return a more recent result than what's on the Outpost. If an Outpost is
// offline, the delay in updating the replication configuration on that Outpost
// can be significant.
//
// This action requires permissions for the s3-outposts:GetReplicationConfiguration
// action. The Outposts bucket owner has this permission by default and can
// grant it to others. For more information about permissions, see Setting up
// IAM with S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html)
// and Managing access to S3 on Outposts bucket (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html)
// in the Amazon S3 User Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html#API_control_GetBucketReplication_Examples)
// section.
//
// If you include the Filter element in a replication configuration, you must
// also include the DeleteMarkerReplication, Status, and Priority elements.
// The response also returns those elements.
//
// For information about S3 on Outposts replication failure reasons, see Replication
// failure reasons (https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes)
// in the Amazon S3 User Guide.
//
// The following operations are related to GetBucketReplication:
//
//   - PutBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html)
//
//   - DeleteBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketReplication
func (c *S3Control) GetBucketReplication(input *GetBucketReplicationInput) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	return out, req.Send()
}

// GetBucketReplicationWithContext is the same as GetBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketReplicationWithContext(ctx aws.Context, input *GetBucketReplicationInput, opts ...request.Option) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketTagging for more information on using the GetBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketTaggingRequest method.
//	req, resp := client.GetBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketTagging
func (c *S3Control) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	output = &GetBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketTagging API operation for AWS S3 Control.
//
// This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket
// tags, see GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html)
// in the Amazon S3 API Reference.
//
// Returns the tag set associated with the Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the GetBucketTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// GetBucketTagging has the following special error:
//
//   - Error code: NoSuchTagSetError Description: There is no tag set associated
//     with the bucket.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples)
// section.
//
// The following actions are related to GetBucketTagging:
//
//   - PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html)
//
//   - DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketTagging
func (c *S3Control) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	return out, req.Send()
}

// GetBucketTaggingWithContext is the same as GetBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketTaggingWithContext(ctx aws.Context, input *GetBucketTaggingInput, opts ...request.Option) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketVersioning for more information on using the GetBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBucketVersioningRequest method.
//	req, resp := client.GetBucketVersioningRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketVersioning
func (c *S3Control) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket/{name}/versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	output = &GetBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBucketVersioning API operation for AWS S3 Control.
//
// This operation returns the versioning state for S3 on Outposts buckets only.
// To return the versioning state for an S3 bucket, see GetBucketVersioning
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html)
// in the Amazon S3 API Reference.
//
// Returns the versioning state for an S3 on Outposts bucket. With S3 Versioning,
// you can save multiple distinct copies of your objects and recover from unintended
// user actions and application failures.
//
// If you've never set versioning on your bucket, it has no versioning state.
// In that case, the GetBucketVersioning request does not return a versioning
// state value.
//
// For more information about versioning, see Versioning (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html)
// in the Amazon S3 User Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html#API_control_GetBucketVersioning_Examples)
// section.
//
// The following operations are related to GetBucketVersioning for S3 on Outposts.
//
//   - PutBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html)
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetBucketVersioning
func (c *S3Control) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	return out, req.Send()
}

// GetBucketVersioningWithContext is the same as GetBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetBucketVersioningWithContext(ctx aws.Context, input *GetBucketVersioningInput, opts ...request.Option) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataAccess = "GetDataAccess"

// GetDataAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetDataAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataAccess for more information on using the GetDataAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataAccessRequest method.
//	req, resp := client.GetDataAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetDataAccess
func (c *S3Control) GetDataAccessRequest(input *GetDataAccessInput) (req *request.Request, output *GetDataAccessOutput) {
	op := &request.Operation{
		Name:       opGetDataAccess,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/dataaccess",
	}

	if input == nil {
		input = &GetDataAccessInput{}
	}

	output = &GetDataAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetDataAccess API operation for AWS S3 Control.
//
// Returns a temporary access credential from S3 Access Grants to the grantee
// or client application. The temporary credential (https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html)
// is an Amazon Web Services STS token that grants them access to the S3 data.
//
// # Permissions
//
// You must have the s3:GetDataAccess permission to use this operation.
//
// # Additional Permissions
//
// The IAM role that S3 Access Grants assumes must have the following permissions
// specified in the trust policy when registering the location: sts:AssumeRole,
// for directory users or groups sts:SetContext, and for IAM users or roles
// sts:SourceIdentity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetDataAccess for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetDataAccess
func (c *S3Control) GetDataAccess(input *GetDataAccessInput) (*GetDataAccessOutput, error) {
	req, out := c.GetDataAccessRequest(input)
	return out, req.Send()
}

// GetDataAccessWithContext is the same as GetDataAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetDataAccessWithContext(ctx aws.Context, input *GetDataAccessInput, opts ...request.Option) (*GetDataAccessOutput, error) {
	req, out := c.GetDataAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobTagging = "GetJobTagging"

// GetJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobTagging for more information on using the GetJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobTaggingRequest method.
//	req, resp := client.GetJobTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTaggingRequest(input *GetJobTaggingInput) (req *request.Request, output *GetJobTaggingOutput) {
	op := &request.Operation{
		Name:       opGetJobTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &GetJobTaggingInput{}
	}

	output = &GetJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetJobTagging API operation for AWS S3 Control.
//
// Returns the tags on an S3 Batch Operations job.
//
// # Permissions
//
// To use the GetJobTagging operation, you must have permission to perform the
// s3:GetJobTagging action. For more information, see Controlling access and
// labeling jobs using tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon S3 User Guide.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - PutJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html)
//
//   - DeleteJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetJobTagging for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTagging(input *GetJobTaggingInput) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	return out, req.Send()
}

// GetJobTaggingWithContext is the same as GetJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetJobTaggingWithContext(ctx aws.Context, input *GetJobTaggingInput, opts ...request.Option) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMultiRegionAccessPoint = "GetMultiRegionAccessPoint"

// GetMultiRegionAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the GetMultiRegionAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMultiRegionAccessPoint for more information on using the GetMultiRegionAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMultiRegionAccessPointRequest method.
//	req, resp := client.GetMultiRegionAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPoint
func (c *S3Control) GetMultiRegionAccessPointRequest(input *GetMultiRegionAccessPointInput) (req *request.Request, output *GetMultiRegionAccessPointOutput) {
	op := &request.Operation{
		Name:       opGetMultiRegionAccessPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/mrap/instances/{name+}",
	}

	if input == nil {
		input = &GetMultiRegionAccessPointInput{}
	}

	output = &GetMultiRegionAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetMultiRegionAccessPoint API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns configuration information about the specified Multi-Region Access
// Point.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to GetMultiRegionAccessPoint:
//
//   - CreateMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
//
//   - DeleteMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
//
//   - DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
//
//   - ListMultiRegionAccessPoints (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetMultiRegionAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPoint
func (c *S3Control) GetMultiRegionAccessPoint(input *GetMultiRegionAccessPointInput) (*GetMultiRegionAccessPointOutput, error) {
	req, out := c.GetMultiRegionAccessPointRequest(input)
	return out, req.Send()
}

// GetMultiRegionAccessPointWithContext is the same as GetMultiRegionAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetMultiRegionAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetMultiRegionAccessPointWithContext(ctx aws.Context, input *GetMultiRegionAccessPointInput, opts ...request.Option) (*GetMultiRegionAccessPointOutput, error) {
	req, out := c.GetMultiRegionAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMultiRegionAccessPointPolicy = "GetMultiRegionAccessPointPolicy"

// GetMultiRegionAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetMultiRegionAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMultiRegionAccessPointPolicy for more information on using the GetMultiRegionAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMultiRegionAccessPointPolicyRequest method.
//	req, resp := client.GetMultiRegionAccessPointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicy
func (c *S3Control) GetMultiRegionAccessPointPolicyRequest(input *GetMultiRegionAccessPointPolicyInput) (req *request.Request, output *GetMultiRegionAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opGetMultiRegionAccessPointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/mrap/instances/{name+}/policy",
	}

	if input == nil {
		input = &GetMultiRegionAccessPointPolicyInput{}
	}

	output = &GetMultiRegionAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetMultiRegionAccessPointPolicy API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns the access control policy of the specified Multi-Region Access Point.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to GetMultiRegionAccessPointPolicy:
//
//   - GetMultiRegionAccessPointPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
//
//   - PutMultiRegionAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetMultiRegionAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicy
func (c *S3Control) GetMultiRegionAccessPointPolicy(input *GetMultiRegionAccessPointPolicyInput) (*GetMultiRegionAccessPointPolicyOutput, error) {
	req, out := c.GetMultiRegionAccessPointPolicyRequest(input)
	return out, req.Send()
}

// GetMultiRegionAccessPointPolicyWithContext is the same as GetMultiRegionAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetMultiRegionAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetMultiRegionAccessPointPolicyWithContext(ctx aws.Context, input *GetMultiRegionAccessPointPolicyInput, opts ...request.Option) (*GetMultiRegionAccessPointPolicyOutput, error) {
	req, out := c.GetMultiRegionAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMultiRegionAccessPointPolicyStatus = "GetMultiRegionAccessPointPolicyStatus"

// GetMultiRegionAccessPointPolicyStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetMultiRegionAccessPointPolicyStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMultiRegionAccessPointPolicyStatus for more information on using the GetMultiRegionAccessPointPolicyStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMultiRegionAccessPointPolicyStatusRequest method.
//	req, resp := client.GetMultiRegionAccessPointPolicyStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicyStatus
func (c *S3Control) GetMultiRegionAccessPointPolicyStatusRequest(input *GetMultiRegionAccessPointPolicyStatusInput) (req *request.Request, output *GetMultiRegionAccessPointPolicyStatusOutput) {
	op := &request.Operation{
		Name:       opGetMultiRegionAccessPointPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/mrap/instances/{name+}/policystatus",
	}

	if input == nil {
		input = &GetMultiRegionAccessPointPolicyStatusInput{}
	}

	output = &GetMultiRegionAccessPointPolicyStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetMultiRegionAccessPointPolicyStatus API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Indicates whether the specified Multi-Region Access Point has an access control
// policy that allows public access.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to GetMultiRegionAccessPointPolicyStatus:
//
//   - GetMultiRegionAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
//
//   - PutMultiRegionAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetMultiRegionAccessPointPolicyStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointPolicyStatus
func (c *S3Control) GetMultiRegionAccessPointPolicyStatus(input *GetMultiRegionAccessPointPolicyStatusInput) (*GetMultiRegionAccessPointPolicyStatusOutput, error) {
	req, out := c.GetMultiRegionAccessPointPolicyStatusRequest(input)
	return out, req.Send()
}

// GetMultiRegionAccessPointPolicyStatusWithContext is the same as GetMultiRegionAccessPointPolicyStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetMultiRegionAccessPointPolicyStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetMultiRegionAccessPointPolicyStatusWithContext(ctx aws.Context, input *GetMultiRegionAccessPointPolicyStatusInput, opts ...request.Option) (*GetMultiRegionAccessPointPolicyStatusOutput, error) {
	req, out := c.GetMultiRegionAccessPointPolicyStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMultiRegionAccessPointRoutes = "GetMultiRegionAccessPointRoutes"

// GetMultiRegionAccessPointRoutesRequest generates a "aws/request.Request" representing the
// client's request for the GetMultiRegionAccessPointRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMultiRegionAccessPointRoutes for more information on using the GetMultiRegionAccessPointRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMultiRegionAccessPointRoutesRequest method.
//	req, resp := client.GetMultiRegionAccessPointRoutesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointRoutes
func (c *S3Control) GetMultiRegionAccessPointRoutesRequest(input *GetMultiRegionAccessPointRoutesInput) (req *request.Request, output *GetMultiRegionAccessPointRoutesOutput) {
	op := &request.Operation{
		Name:       opGetMultiRegionAccessPointRoutes,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/mrap/instances/{mrap+}/routes",
	}

	if input == nil {
		input = &GetMultiRegionAccessPointRoutesInput{}
	}

	output = &GetMultiRegionAccessPointRoutesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// GetMultiRegionAccessPointRoutes API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns the routing configuration for a Multi-Region Access Point, indicating
// which Regions are active or passive.
//
// To obtain routing control changes and failover requests, use the Amazon S3
// failover control infrastructure endpoints in these five Amazon Web Services
// Regions:
//
//   - us-east-1
//
//   - us-west-2
//
//   - ap-southeast-2
//
//   - ap-northeast-1
//
//   - eu-west-1
//
// Your Amazon S3 bucket does not need to be in these five Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetMultiRegionAccessPointRoutes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetMultiRegionAccessPointRoutes
func (c *S3Control) GetMultiRegionAccessPointRoutes(input *GetMultiRegionAccessPointRoutesInput) (*GetMultiRegionAccessPointRoutesOutput, error) {
	req, out := c.GetMultiRegionAccessPointRoutesRequest(input)
	return out, req.Send()
}

// GetMultiRegionAccessPointRoutesWithContext is the same as GetMultiRegionAccessPointRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See GetMultiRegionAccessPointRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetMultiRegionAccessPointRoutesWithContext(ctx aws.Context, input *GetMultiRegionAccessPointRoutesInput, opts ...request.Option) (*GetMultiRegionAccessPointRoutesOutput, error) {
	req, out := c.GetMultiRegionAccessPointRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicAccessBlock = "GetPublicAccessBlock"

// GetPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicAccessBlock for more information on using the GetPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPublicAccessBlockRequest method.
//	req, resp := client.GetPublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlockRequest(input *GetPublicAccessBlockInput) (req *request.Request, output *GetPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opGetPublicAccessBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &GetPublicAccessBlockInput{}
	}

	output = &GetPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPublicAccessBlock API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Retrieves the PublicAccessBlock configuration for an Amazon Web Services
// account. For more information, see Using Amazon S3 block public access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//   - DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
//
//   - PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetPublicAccessBlock for usage and error information.
//
// Returned Error Codes:
//   - ErrCodeNoSuchPublicAccessBlockConfiguration "NoSuchPublicAccessBlockConfiguration"
//     Amazon S3 throws this exception if you make a GetPublicAccessBlock request
//     against an account that doesn't have a PublicAccessBlockConfiguration set.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlock(input *GetPublicAccessBlockInput) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	return out, req.Send()
}

// GetPublicAccessBlockWithContext is the same as GetPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetPublicAccessBlockWithContext(ctx aws.Context, input *GetPublicAccessBlockInput, opts ...request.Option) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageLensConfiguration = "GetStorageLensConfiguration"

// GetStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageLensConfiguration for more information on using the GetStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageLensConfigurationRequest method.
//	req, resp := client.GetStorageLensConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfiguration
func (c *S3Control) GetStorageLensConfigurationRequest(input *GetStorageLensConfigurationInput) (req *request.Request, output *GetStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetStorageLensConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &GetStorageLensConfigurationInput{}
	}

	output = &GetStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageLensConfiguration API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Gets the Amazon S3 Storage Lens configuration. For more information, see
// Assessing your storage activity and usage with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:GetStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfiguration
func (c *S3Control) GetStorageLensConfiguration(input *GetStorageLensConfigurationInput) (*GetStorageLensConfigurationOutput, error) {
	req, out := c.GetStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// GetStorageLensConfigurationWithContext is the same as GetStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetStorageLensConfigurationWithContext(ctx aws.Context, input *GetStorageLensConfigurationInput, opts ...request.Option) (*GetStorageLensConfigurationOutput, error) {
	req, out := c.GetStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageLensConfigurationTagging = "GetStorageLensConfigurationTagging"

// GetStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageLensConfigurationTagging for more information on using the GetStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageLensConfigurationTaggingRequest method.
//	req, resp := client.GetStorageLensConfigurationTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfigurationTagging
func (c *S3Control) GetStorageLensConfigurationTaggingRequest(input *GetStorageLensConfigurationTaggingInput) (req *request.Request, output *GetStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opGetStorageLensConfigurationTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &GetStorageLensConfigurationTaggingInput{}
	}

	output = &GetStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Gets the tags of Amazon S3 Storage Lens configuration. For more information
// about S3 Storage Lens, see Assessing your storage activity and usage with
// Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:GetStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensConfigurationTagging
func (c *S3Control) GetStorageLensConfigurationTagging(input *GetStorageLensConfigurationTaggingInput) (*GetStorageLensConfigurationTaggingOutput, error) {
	req, out := c.GetStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// GetStorageLensConfigurationTaggingWithContext is the same as GetStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *GetStorageLensConfigurationTaggingInput, opts ...request.Option) (*GetStorageLensConfigurationTaggingOutput, error) {
	req, out := c.GetStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageLensGroup = "GetStorageLensGroup"

// GetStorageLensGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageLensGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageLensGroup for more information on using the GetStorageLensGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageLensGroupRequest method.
//	req, resp := client.GetStorageLensGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensGroup
func (c *S3Control) GetStorageLensGroupRequest(input *GetStorageLensGroupInput) (req *request.Request, output *GetStorageLensGroupOutput) {
	op := &request.Operation{
		Name:       opGetStorageLensGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelensgroup/{name}",
	}

	if input == nil {
		input = &GetStorageLensGroupInput{}
	}

	output = &GetStorageLensGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageLensGroup API operation for AWS S3 Control.
//
// Retrieves the Storage Lens group configuration details.
//
// To use this operation, you must have the permission to perform the s3:GetStorageLensGroup
// action. For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about Storage Lens groups errors, see List of Amazon S3 Storage
// Lens error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetStorageLensGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetStorageLensGroup
func (c *S3Control) GetStorageLensGroup(input *GetStorageLensGroupInput) (*GetStorageLensGroupOutput, error) {
	req, out := c.GetStorageLensGroupRequest(input)
	return out, req.Send()
}

// GetStorageLensGroupWithContext is the same as GetStorageLensGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageLensGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetStorageLensGroupWithContext(ctx aws.Context, input *GetStorageLensGroupInput, opts ...request.Option) (*GetStorageLensGroupOutput, error) {
	req, out := c.GetStorageLensGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessGrants = "ListAccessGrants"

// ListAccessGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessGrants for more information on using the ListAccessGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessGrantsRequest method.
//	req, resp := client.ListAccessGrantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrants
func (c *S3Control) ListAccessGrantsRequest(input *ListAccessGrantsInput) (req *request.Request, output *ListAccessGrantsOutput) {
	op := &request.Operation{
		Name:       opListAccessGrants,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/grants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessGrantsInput{}
	}

	output = &ListAccessGrantsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// ListAccessGrants API operation for AWS S3 Control.
//
// Returns the list of access grants in your S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:ListAccessGrants permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessGrants for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrants
func (c *S3Control) ListAccessGrants(input *ListAccessGrantsInput) (*ListAccessGrantsOutput, error) {
	req, out := c.ListAccessGrantsRequest(input)
	return out, req.Send()
}

// ListAccessGrantsWithContext is the same as ListAccessGrants with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsWithContext(ctx aws.Context, input *ListAccessGrantsInput, opts ...request.Option) (*ListAccessGrantsOutput, error) {
	req, out := c.ListAccessGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessGrantsPages iterates over the pages of a ListAccessGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessGrants operation.
//	pageNum := 0
//	err := client.ListAccessGrantsPages(params,
//	    func(page *s3control.ListAccessGrantsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListAccessGrantsPages(input *ListAccessGrantsInput, fn func(*ListAccessGrantsOutput, bool) bool) error {
	return c.ListAccessGrantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessGrantsPagesWithContext same as ListAccessGrantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsPagesWithContext(ctx aws.Context, input *ListAccessGrantsInput, fn func(*ListAccessGrantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessGrantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessGrantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessGrantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessGrantsInstances = "ListAccessGrantsInstances"

// ListAccessGrantsInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessGrantsInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessGrantsInstances for more information on using the ListAccessGrantsInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessGrantsInstancesRequest method.
//	req, resp := client.ListAccessGrantsInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsInstances
func (c *S3Control) ListAccessGrantsInstancesRequest(input *ListAccessGrantsInstancesInput) (req *request.Request, output *ListAccessGrantsInstancesOutput) {
	op := &request.Operation{
		Name:       opListAccessGrantsInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessGrantsInstancesInput{}
	}

	output = &ListAccessGrantsInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// ListAccessGrantsInstances API operation for AWS S3 Control.
//
// Returns a list of S3 Access Grants instances. An S3 Access Grants instance
// serves as a logical grouping for your individual access grants. You can only
// have one S3 Access Grants instance per Region per account.
//
// # Permissions
//
// You must have the s3:ListAccessGrantsInstances permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessGrantsInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsInstances
func (c *S3Control) ListAccessGrantsInstances(input *ListAccessGrantsInstancesInput) (*ListAccessGrantsInstancesOutput, error) {
	req, out := c.ListAccessGrantsInstancesRequest(input)
	return out, req.Send()
}

// ListAccessGrantsInstancesWithContext is the same as ListAccessGrantsInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessGrantsInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsInstancesWithContext(ctx aws.Context, input *ListAccessGrantsInstancesInput, opts ...request.Option) (*ListAccessGrantsInstancesOutput, error) {
	req, out := c.ListAccessGrantsInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessGrantsInstancesPages iterates over the pages of a ListAccessGrantsInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessGrantsInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessGrantsInstances operation.
//	pageNum := 0
//	err := client.ListAccessGrantsInstancesPages(params,
//	    func(page *s3control.ListAccessGrantsInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListAccessGrantsInstancesPages(input *ListAccessGrantsInstancesInput, fn func(*ListAccessGrantsInstancesOutput, bool) bool) error {
	return c.ListAccessGrantsInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessGrantsInstancesPagesWithContext same as ListAccessGrantsInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsInstancesPagesWithContext(ctx aws.Context, input *ListAccessGrantsInstancesInput, fn func(*ListAccessGrantsInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessGrantsInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessGrantsInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessGrantsInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessGrantsLocations = "ListAccessGrantsLocations"

// ListAccessGrantsLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessGrantsLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessGrantsLocations for more information on using the ListAccessGrantsLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessGrantsLocationsRequest method.
//	req, resp := client.ListAccessGrantsLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsLocations
func (c *S3Control) ListAccessGrantsLocationsRequest(input *ListAccessGrantsLocationsInput) (req *request.Request, output *ListAccessGrantsLocationsOutput) {
	op := &request.Operation{
		Name:       opListAccessGrantsLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accessgrantsinstance/locations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessGrantsLocationsInput{}
	}

	output = &ListAccessGrantsLocationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// ListAccessGrantsLocations API operation for AWS S3 Control.
//
// Returns a list of the locations registered in your S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:ListAccessGrantsLocations permission to use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessGrantsLocations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessGrantsLocations
func (c *S3Control) ListAccessGrantsLocations(input *ListAccessGrantsLocationsInput) (*ListAccessGrantsLocationsOutput, error) {
	req, out := c.ListAccessGrantsLocationsRequest(input)
	return out, req.Send()
}

// ListAccessGrantsLocationsWithContext is the same as ListAccessGrantsLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessGrantsLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsLocationsWithContext(ctx aws.Context, input *ListAccessGrantsLocationsInput, opts ...request.Option) (*ListAccessGrantsLocationsOutput, error) {
	req, out := c.ListAccessGrantsLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessGrantsLocationsPages iterates over the pages of a ListAccessGrantsLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessGrantsLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessGrantsLocations operation.
//	pageNum := 0
//	err := client.ListAccessGrantsLocationsPages(params,
//	    func(page *s3control.ListAccessGrantsLocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListAccessGrantsLocationsPages(input *ListAccessGrantsLocationsInput, fn func(*ListAccessGrantsLocationsOutput, bool) bool) error {
	return c.ListAccessGrantsLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessGrantsLocationsPagesWithContext same as ListAccessGrantsLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessGrantsLocationsPagesWithContext(ctx aws.Context, input *ListAccessGrantsLocationsInput, fn func(*ListAccessGrantsLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessGrantsLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessGrantsLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessGrantsLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPoints = "ListAccessPoints"

// ListAccessPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPoints for more information on using the ListAccessPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessPointsRequest method.
//	req, resp := client.ListAccessPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPointsRequest(input *ListAccessPointsInput) (req *request.Request, output *ListAccessPointsOutput) {
	op := &request.Operation{
		Name:       opListAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPointsInput{}
	}

	output = &ListAccessPointsOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPoints API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns a list of the access points that are owned by the current account
// that's associated with the specified bucket. You can retrieve up to 1000
// access points per call. If the specified bucket has more than 1,000 access
// points (or the number specified in maxResults, whichever is less), the response
// will include a continuation token that you can use to list the additional
// access points.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples)
// section.
//
// The following actions are related to ListAccessPoints:
//
//   - CreateAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html)
//
//   - DeleteAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html)
//
//   - GetAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessPoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPoints(input *ListAccessPointsInput) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	return out, req.Send()
}

// ListAccessPointsWithContext is the same as ListAccessPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsWithContext(ctx aws.Context, input *ListAccessPointsInput, opts ...request.Option) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPointsPages iterates over the pages of a ListAccessPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessPoints operation.
//	pageNum := 0
//	err := client.ListAccessPointsPages(params,
//	    func(page *s3control.ListAccessPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListAccessPointsPages(input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool) error {
	return c.ListAccessPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPointsPagesWithContext same as ListAccessPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsPagesWithContext(ctx aws.Context, input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPointsForObjectLambda = "ListAccessPointsForObjectLambda"

// ListAccessPointsForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPointsForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPointsForObjectLambda for more information on using the ListAccessPointsForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessPointsForObjectLambdaRequest method.
//	req, resp := client.ListAccessPointsForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPointsForObjectLambda
func (c *S3Control) ListAccessPointsForObjectLambdaRequest(input *ListAccessPointsForObjectLambdaInput) (req *request.Request, output *ListAccessPointsForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opListAccessPointsForObjectLambda,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspointforobjectlambda",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPointsForObjectLambdaInput{}
	}

	output = &ListAccessPointsForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPointsForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns some or all (up to 1,000) access points associated with the Object
// Lambda Access Point per call. If there are more access points than what can
// be returned in one call, the response will include a continuation token that
// you can use to list the additional access points.
//
// The following actions are related to ListAccessPointsForObjectLambda:
//
//   - CreateAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html)
//
//   - DeleteAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html)
//
//   - GetAccessPointForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessPointsForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPointsForObjectLambda
func (c *S3Control) ListAccessPointsForObjectLambda(input *ListAccessPointsForObjectLambdaInput) (*ListAccessPointsForObjectLambdaOutput, error) {
	req, out := c.ListAccessPointsForObjectLambdaRequest(input)
	return out, req.Send()
}

// ListAccessPointsForObjectLambdaWithContext is the same as ListAccessPointsForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPointsForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsForObjectLambdaWithContext(ctx aws.Context, input *ListAccessPointsForObjectLambdaInput, opts ...request.Option) (*ListAccessPointsForObjectLambdaOutput, error) {
	req, out := c.ListAccessPointsForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPointsForObjectLambdaPages iterates over the pages of a ListAccessPointsForObjectLambda operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPointsForObjectLambda method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessPointsForObjectLambda operation.
//	pageNum := 0
//	err := client.ListAccessPointsForObjectLambdaPages(params,
//	    func(page *s3control.ListAccessPointsForObjectLambdaOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListAccessPointsForObjectLambdaPages(input *ListAccessPointsForObjectLambdaInput, fn func(*ListAccessPointsForObjectLambdaOutput, bool) bool) error {
	return c.ListAccessPointsForObjectLambdaPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPointsForObjectLambdaPagesWithContext same as ListAccessPointsForObjectLambdaPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsForObjectLambdaPagesWithContext(ctx aws.Context, input *ListAccessPointsForObjectLambdaInput, fn func(*ListAccessPointsForObjectLambdaOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPointsForObjectLambdaInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPointsForObjectLambdaRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPointsForObjectLambdaOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobsRequest method.
//	req, resp := client.ListJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListJobs API operation for AWS S3 Control.
//
// Lists current S3 Batch Operations jobs as well as the jobs that have ended
// within the last 30 days for the Amazon Web Services account making the request.
// For more information, see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// To use the ListJobs operation, you must have permission to perform the s3:ListJobs
// action.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//   - UpdateJobPriority (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html)
//
//   - UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInvalidRequestException "InvalidRequestException"
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
//   - ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobs operation.
//	pageNum := 0
//	err := client.ListJobsPages(params,
//	    func(page *s3control.ListJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultiRegionAccessPoints = "ListMultiRegionAccessPoints"

// ListMultiRegionAccessPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultiRegionAccessPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultiRegionAccessPoints for more information on using the ListMultiRegionAccessPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMultiRegionAccessPointsRequest method.
//	req, resp := client.ListMultiRegionAccessPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListMultiRegionAccessPoints
func (c *S3Control) ListMultiRegionAccessPointsRequest(input *ListMultiRegionAccessPointsInput) (req *request.Request, output *ListMultiRegionAccessPointsOutput) {
	op := &request.Operation{
		Name:       opListMultiRegionAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/mrap/instances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiRegionAccessPointsInput{}
	}

	output = &ListMultiRegionAccessPointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// ListMultiRegionAccessPoints API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns a list of the Multi-Region Access Points currently associated with
// the specified Amazon Web Services account. Each call can return up to 100
// Multi-Region Access Points, the maximum number of Multi-Region Access Points
// that can be associated with a single account.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to ListMultiRegionAccessPoint:
//
//   - CreateMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
//
//   - DeleteMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
//
//   - DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
//
//   - GetMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListMultiRegionAccessPoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListMultiRegionAccessPoints
func (c *S3Control) ListMultiRegionAccessPoints(input *ListMultiRegionAccessPointsInput) (*ListMultiRegionAccessPointsOutput, error) {
	req, out := c.ListMultiRegionAccessPointsRequest(input)
	return out, req.Send()
}

// ListMultiRegionAccessPointsWithContext is the same as ListMultiRegionAccessPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultiRegionAccessPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListMultiRegionAccessPointsWithContext(ctx aws.Context, input *ListMultiRegionAccessPointsInput, opts ...request.Option) (*ListMultiRegionAccessPointsOutput, error) {
	req, out := c.ListMultiRegionAccessPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultiRegionAccessPointsPages iterates over the pages of a ListMultiRegionAccessPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultiRegionAccessPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMultiRegionAccessPoints operation.
//	pageNum := 0
//	err := client.ListMultiRegionAccessPointsPages(params,
//	    func(page *s3control.ListMultiRegionAccessPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListMultiRegionAccessPointsPages(input *ListMultiRegionAccessPointsInput, fn func(*ListMultiRegionAccessPointsOutput, bool) bool) error {
	return c.ListMultiRegionAccessPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultiRegionAccessPointsPagesWithContext same as ListMultiRegionAccessPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListMultiRegionAccessPointsPagesWithContext(ctx aws.Context, input *ListMultiRegionAccessPointsInput, fn func(*ListMultiRegionAccessPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultiRegionAccessPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultiRegionAccessPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultiRegionAccessPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRegionalBuckets = "ListRegionalBuckets"

// ListRegionalBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegionalBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegionalBuckets for more information on using the ListRegionalBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRegionalBucketsRequest method.
//	req, resp := client.ListRegionalBucketsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListRegionalBuckets
func (c *S3Control) ListRegionalBucketsRequest(input *ListRegionalBucketsInput) (req *request.Request, output *ListRegionalBucketsOutput) {
	op := &request.Operation{
		Name:       opListRegionalBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/bucket",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRegionalBucketsInput{}
	}

	output = &ListRegionalBucketsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListRegionalBuckets API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Returns a list of all Outposts buckets in an Outpost that are owned by the
// authenticated sender of the request. For more information, see Using Amazon
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and x-amz-outpost-id in your
// request, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples)
// section.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListRegionalBuckets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListRegionalBuckets
func (c *S3Control) ListRegionalBuckets(input *ListRegionalBucketsInput) (*ListRegionalBucketsOutput, error) {
	req, out := c.ListRegionalBucketsRequest(input)
	return out, req.Send()
}

// ListRegionalBucketsWithContext is the same as ListRegionalBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegionalBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListRegionalBucketsWithContext(ctx aws.Context, input *ListRegionalBucketsInput, opts ...request.Option) (*ListRegionalBucketsOutput, error) {
	req, out := c.ListRegionalBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRegionalBucketsPages iterates over the pages of a ListRegionalBuckets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRegionalBuckets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRegionalBuckets operation.
//	pageNum := 0
//	err := client.ListRegionalBucketsPages(params,
//	    func(page *s3control.ListRegionalBucketsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListRegionalBucketsPages(input *ListRegionalBucketsInput, fn func(*ListRegionalBucketsOutput, bool) bool) error {
	return c.ListRegionalBucketsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRegionalBucketsPagesWithContext same as ListRegionalBucketsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListRegionalBucketsPagesWithContext(ctx aws.Context, input *ListRegionalBucketsInput, fn func(*ListRegionalBucketsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRegionalBucketsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRegionalBucketsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRegionalBucketsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageLensConfigurations = "ListStorageLensConfigurations"

// ListStorageLensConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageLensConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageLensConfigurations for more information on using the ListStorageLensConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageLensConfigurationsRequest method.
//	req, resp := client.ListStorageLensConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensConfigurations
func (c *S3Control) ListStorageLensConfigurationsRequest(input *ListStorageLensConfigurationsInput) (req *request.Request, output *ListStorageLensConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListStorageLensConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelens",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageLensConfigurationsInput{}
	}

	output = &ListStorageLensConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageLensConfigurations API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Gets a list of Amazon S3 Storage Lens configurations. For more information
// about S3 Storage Lens, see Assessing your storage activity and usage with
// Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:ListStorageLensConfigurations
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListStorageLensConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensConfigurations
func (c *S3Control) ListStorageLensConfigurations(input *ListStorageLensConfigurationsInput) (*ListStorageLensConfigurationsOutput, error) {
	req, out := c.ListStorageLensConfigurationsRequest(input)
	return out, req.Send()
}

// ListStorageLensConfigurationsWithContext is the same as ListStorageLensConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageLensConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListStorageLensConfigurationsWithContext(ctx aws.Context, input *ListStorageLensConfigurationsInput, opts ...request.Option) (*ListStorageLensConfigurationsOutput, error) {
	req, out := c.ListStorageLensConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageLensConfigurationsPages iterates over the pages of a ListStorageLensConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageLensConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageLensConfigurations operation.
//	pageNum := 0
//	err := client.ListStorageLensConfigurationsPages(params,
//	    func(page *s3control.ListStorageLensConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListStorageLensConfigurationsPages(input *ListStorageLensConfigurationsInput, fn func(*ListStorageLensConfigurationsOutput, bool) bool) error {
	return c.ListStorageLensConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageLensConfigurationsPagesWithContext same as ListStorageLensConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListStorageLensConfigurationsPagesWithContext(ctx aws.Context, input *ListStorageLensConfigurationsInput, fn func(*ListStorageLensConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageLensConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageLensConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageLensConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageLensGroups = "ListStorageLensGroups"

// ListStorageLensGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageLensGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageLensGroups for more information on using the ListStorageLensGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageLensGroupsRequest method.
//	req, resp := client.ListStorageLensGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensGroups
func (c *S3Control) ListStorageLensGroupsRequest(input *ListStorageLensGroupsInput) (req *request.Request, output *ListStorageLensGroupsOutput) {
	op := &request.Operation{
		Name:       opListStorageLensGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/storagelensgroup",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageLensGroupsInput{}
	}

	output = &ListStorageLensGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageLensGroups API operation for AWS S3 Control.
//
// Lists all the Storage Lens groups in the specified home Region.
//
// To use this operation, you must have the permission to perform the s3:ListStorageLensGroups
// action. For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about Storage Lens groups errors, see List of Amazon S3 Storage
// Lens error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListStorageLensGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListStorageLensGroups
func (c *S3Control) ListStorageLensGroups(input *ListStorageLensGroupsInput) (*ListStorageLensGroupsOutput, error) {
	req, out := c.ListStorageLensGroupsRequest(input)
	return out, req.Send()
}

// ListStorageLensGroupsWithContext is the same as ListStorageLensGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageLensGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListStorageLensGroupsWithContext(ctx aws.Context, input *ListStorageLensGroupsInput, opts ...request.Option) (*ListStorageLensGroupsOutput, error) {
	req, out := c.ListStorageLensGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageLensGroupsPages iterates over the pages of a ListStorageLensGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageLensGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageLensGroups operation.
//	pageNum := 0
//	err := client.ListStorageLensGroupsPages(params,
//	    func(page *s3control.ListStorageLensGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *S3Control) ListStorageLensGroupsPages(input *ListStorageLensGroupsInput, fn func(*ListStorageLensGroupsOutput, bool) bool) error {
	return c.ListStorageLensGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageLensGroupsPagesWithContext same as ListStorageLensGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListStorageLensGroupsPagesWithContext(ctx aws.Context, input *ListStorageLensGroupsInput, fn func(*ListStorageLensGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageLensGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageLensGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageLensGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListTagsForResource
func (c *S3Control) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/tags/{resourceArn+}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for AWS S3 Control.
//
// This operation allows you to list all the Amazon Web Services resource tags
// for a specified resource. Each tag is a label consisting of a user-defined
// key and value. Tags can help you manage, identify, organize, search for,
// and filter resources.
//
// # Permissions
//
// You must have the s3:ListTagsForResource permission to use this operation.
//
// This operation is only supported for S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html)
// and for S3 Access Grants (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html).
// The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance,
// registered location, or grant.
//
// For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about S3 Tagging errors, see List of Amazon S3 Tagging error
// codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListTagsForResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListTagsForResource
func (c *S3Control) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccessGrantsInstanceResourcePolicy = "PutAccessGrantsInstanceResourcePolicy"

// PutAccessGrantsInstanceResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessGrantsInstanceResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessGrantsInstanceResourcePolicy for more information on using the PutAccessGrantsInstanceResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccessGrantsInstanceResourcePolicyRequest method.
//	req, resp := client.PutAccessGrantsInstanceResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessGrantsInstanceResourcePolicy
func (c *S3Control) PutAccessGrantsInstanceResourcePolicyRequest(input *PutAccessGrantsInstanceResourcePolicyInput) (req *request.Request, output *PutAccessGrantsInstanceResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutAccessGrantsInstanceResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accessgrantsinstance/resourcepolicy",
	}

	if input == nil {
		input = &PutAccessGrantsInstanceResourcePolicyInput{}
	}

	output = &PutAccessGrantsInstanceResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutAccessGrantsInstanceResourcePolicy API operation for AWS S3 Control.
//
// Updates the resource policy of the S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:PutAccessGrantsInstanceResourcePolicy permission to
// use this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessGrantsInstanceResourcePolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessGrantsInstanceResourcePolicy
func (c *S3Control) PutAccessGrantsInstanceResourcePolicy(input *PutAccessGrantsInstanceResourcePolicyInput) (*PutAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.PutAccessGrantsInstanceResourcePolicyRequest(input)
	return out, req.Send()
}

// PutAccessGrantsInstanceResourcePolicyWithContext is the same as PutAccessGrantsInstanceResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessGrantsInstanceResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessGrantsInstanceResourcePolicyWithContext(ctx aws.Context, input *PutAccessGrantsInstanceResourcePolicyInput, opts ...request.Option) (*PutAccessGrantsInstanceResourcePolicyOutput, error) {
	req, out := c.PutAccessGrantsInstanceResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccessPointConfigurationForObjectLambda = "PutAccessPointConfigurationForObjectLambda"

// PutAccessPointConfigurationForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessPointConfigurationForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessPointConfigurationForObjectLambda for more information on using the PutAccessPointConfigurationForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccessPointConfigurationForObjectLambdaRequest method.
//	req, resp := client.PutAccessPointConfigurationForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointConfigurationForObjectLambda
func (c *S3Control) PutAccessPointConfigurationForObjectLambdaRequest(input *PutAccessPointConfigurationForObjectLambdaInput) (req *request.Request, output *PutAccessPointConfigurationForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opPutAccessPointConfigurationForObjectLambda,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/configuration",
	}

	if input == nil {
		input = &PutAccessPointConfigurationForObjectLambdaInput{}
	}

	output = &PutAccessPointConfigurationForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAccessPointConfigurationForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Replaces configuration for an Object Lambda Access Point.
//
// The following actions are related to PutAccessPointConfigurationForObjectLambda:
//
//   - GetAccessPointConfigurationForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessPointConfigurationForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointConfigurationForObjectLambda
func (c *S3Control) PutAccessPointConfigurationForObjectLambda(input *PutAccessPointConfigurationForObjectLambdaInput) (*PutAccessPointConfigurationForObjectLambdaOutput, error) {
	req, out := c.PutAccessPointConfigurationForObjectLambdaRequest(input)
	return out, req.Send()
}

// PutAccessPointConfigurationForObjectLambdaWithContext is the same as PutAccessPointConfigurationForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessPointConfigurationForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessPointConfigurationForObjectLambdaWithContext(ctx aws.Context, input *PutAccessPointConfigurationForObjectLambdaInput, opts ...request.Option) (*PutAccessPointConfigurationForObjectLambdaOutput, error) {
	req, out := c.PutAccessPointConfigurationForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccessPointPolicy = "PutAccessPointPolicy"

// PutAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessPointPolicy for more information on using the PutAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccessPointPolicyRequest method.
//	req, resp := client.PutAccessPointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicyRequest(input *PutAccessPointPolicyInput) (req *request.Request, output *PutAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opPutAccessPointPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &PutAccessPointPolicyInput{}
	}

	output = &PutAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAccessPointPolicy API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Associates an access policy with the specified access point. Each access
// point can have only one policy, so a request made to this API replaces any
// existing policy associated with the specified access point.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples)
// section.
//
// The following actions are related to PutAccessPointPolicy:
//
//   - GetAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html)
//
//   - DeleteAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicy(input *PutAccessPointPolicyInput) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	return out, req.Send()
}

// PutAccessPointPolicyWithContext is the same as PutAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessPointPolicyWithContext(ctx aws.Context, input *PutAccessPointPolicyInput, opts ...request.Option) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccessPointPolicyForObjectLambda = "PutAccessPointPolicyForObjectLambda"

// PutAccessPointPolicyForObjectLambdaRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessPointPolicyForObjectLambda operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessPointPolicyForObjectLambda for more information on using the PutAccessPointPolicyForObjectLambda
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccessPointPolicyForObjectLambdaRequest method.
//	req, resp := client.PutAccessPointPolicyForObjectLambdaRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicyForObjectLambda
func (c *S3Control) PutAccessPointPolicyForObjectLambdaRequest(input *PutAccessPointPolicyForObjectLambdaInput) (req *request.Request, output *PutAccessPointPolicyForObjectLambdaOutput) {
	op := &request.Operation{
		Name:       opPutAccessPointPolicyForObjectLambda,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspointforobjectlambda/{name}/policy",
	}

	if input == nil {
		input = &PutAccessPointPolicyForObjectLambdaInput{}
	}

	output = &PutAccessPointPolicyForObjectLambdaOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAccessPointPolicyForObjectLambda API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Creates or replaces resource policy for an Object Lambda Access Point. For
// an example policy, see Creating Object Lambda Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli)
// in the Amazon S3 User Guide.
//
// The following actions are related to PutAccessPointPolicyForObjectLambda:
//
//   - DeleteAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html)
//
//   - GetAccessPointPolicyForObjectLambda (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessPointPolicyForObjectLambda for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicyForObjectLambda
func (c *S3Control) PutAccessPointPolicyForObjectLambda(input *PutAccessPointPolicyForObjectLambdaInput) (*PutAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.PutAccessPointPolicyForObjectLambdaRequest(input)
	return out, req.Send()
}

// PutAccessPointPolicyForObjectLambdaWithContext is the same as PutAccessPointPolicyForObjectLambda with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessPointPolicyForObjectLambda for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessPointPolicyForObjectLambdaWithContext(ctx aws.Context, input *PutAccessPointPolicyForObjectLambdaInput, opts ...request.Option) (*PutAccessPointPolicyForObjectLambdaOutput, error) {
	req, out := c.PutAccessPointPolicyForObjectLambdaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycleConfiguration for more information on using the PutBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//	req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketLifecycleConfiguration
func (c *S3Control) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/lifecycleconfiguration",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output = &PutBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLifecycleConfiguration API operation for AWS S3 Control.
//
// This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket.
// To put a lifecycle configuration to an S3 bucket, see PutBucketLifecycleConfiguration
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
// in the Amazon S3 API Reference.
//
// Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces
// an existing lifecycle configuration. Outposts buckets only support lifecycle
// configurations that delete/expire objects after a certain period of time
// and abort incomplete multipart uploads.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples)
// section.
//
// The following actions are related to PutBucketLifecycleConfiguration:
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
//   - DeleteBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketLifecycleConfiguration
func (c *S3Control) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleConfigurationWithContext is the same as PutBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketLifecycleConfigurationWithContext(ctx aws.Context, input *PutBucketLifecycleConfigurationInput, opts ...request.Option) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketPolicy for more information on using the PutBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketPolicyRequest method.
//	req, resp := client.PutBucketPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketPolicy
func (c *S3Control) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	output = &PutBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketPolicy API operation for AWS S3 Control.
//
// This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put
// a policy on an S3 bucket, see PutBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html)
// in the Amazon S3 API Reference.
//
// Applies an Amazon S3 bucket policy to an Outposts bucket. For more information,
// see Using Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// If you are using an identity other than the root user of the Amazon Web Services
// account that owns the Outposts bucket, the calling identity must have the
// PutBucketPolicy permissions on the specified Outposts bucket and belong to
// the bucket owner's account in order to use this action.
//
// If you don't have PutBucketPolicy permissions, Amazon S3 returns a 403 Access
// Denied error. If you have the correct permissions, but you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 405 Method Not Allowed error.
//
// As a security precaution, the root user of the Amazon Web Services account
// that owns a bucket can always use this action, even if the policy explicitly
// denies the root user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples)
// section.
//
// The following actions are related to PutBucketPolicy:
//
//   - GetBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html)
//
//   - DeleteBucketPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketPolicy
func (c *S3Control) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	return out, req.Send()
}

// PutBucketPolicyWithContext is the same as PutBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketPolicyWithContext(ctx aws.Context, input *PutBucketPolicyInput, opts ...request.Option) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketReplication for more information on using the PutBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketReplicationRequest method.
//	req, resp := client.PutBucketReplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketReplication
func (c *S3Control) PutBucketReplicationRequest(input *PutBucketReplicationInput) (req *request.Request, output *PutBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	output = &PutBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketReplication API operation for AWS S3 Control.
//
// This action creates an Amazon S3 on Outposts bucket's replication configuration.
// To create an S3 bucket's replication configuration, see PutBucketReplication
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html)
// in the Amazon S3 API Reference.
//
// Creates a replication configuration or replaces an existing one. For information
// about S3 replication on Outposts configuration, see Replicating objects for
// S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html)
// in the Amazon S3 User Guide.
//
// It can take a while to propagate PUT or DELETE requests for a replication
// configuration to all S3 on Outposts systems. Therefore, the replication configuration
// that's returned by a GET request soon after a PUT or DELETE request might
// return a more recent result than what's on the Outpost. If an Outpost is
// offline, the delay in updating the replication configuration on that Outpost
// can be significant.
//
// Specify the replication configuration in the request body. In the replication
// configuration, you provide the following information:
//
//   - The name of the destination bucket or buckets where you want S3 on Outposts
//     to replicate objects
//
//   - The Identity and Access Management (IAM) role that S3 on Outposts can
//     assume to replicate objects on your behalf
//
//   - Other relevant information, such as replication rules
//
// A replication configuration must include at least one rule and can contain
// a maximum of 100. Each rule identifies a subset of objects to replicate by
// filtering the objects in the source Outposts bucket. To choose additional
// subsets of objects to replicate, add a rule for each subset.
//
// To specify a subset of the objects in the source Outposts bucket to apply
// a replication rule to, add the Filter element as a child of the Rule element.
// You can filter objects based on an object key prefix, one or more object
// tags, or both. When you add the Filter element in the configuration, you
// must also add the following elements: DeleteMarkerReplication, Status, and
// Priority.
//
// Using PutBucketReplication on Outposts requires that both the source and
// destination buckets must have versioning enabled. For information about enabling
// versioning on a bucket, see Managing S3 Versioning for your S3 on Outposts
// bucket (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsManagingVersioning.html).
//
// For information about S3 on Outposts replication failure reasons, see Replication
// failure reasons (https://docs.aws.amazon.com/AmazonS3/latest/userguide/outposts-replication-eventbridge.html#outposts-replication-failure-codes)
// in the Amazon S3 User Guide.
//
// # Handling Replication of Encrypted Objects
//
// Outposts buckets are encrypted at all times. All the objects in the source
// Outposts bucket are encrypted and can be replicated. Also, all the replicas
// in the destination Outposts bucket are encrypted with the same encryption
// key as the objects in the source Outposts bucket.
//
// # Permissions
//
// To create a PutBucketReplication request, you must have s3-outposts:PutReplicationConfiguration
// permissions for the bucket. The Outposts bucket owner has this permission
// by default and can grant it to others. For more information about permissions,
// see Setting up IAM with S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsIAM.html)
// and Managing access to S3 on Outposts buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsBucketPolicy.html).
//
// To perform this operation, the user or role must also have the iam:CreateRole
// and iam:PassRole permissions. For more information, see Granting a user permissions
// to pass a role to an Amazon Web Services service (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketReplication.html#API_control_PutBucketReplication_Examples)
// section.
//
// The following operations are related to PutBucketReplication:
//
//   - GetBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketReplication.html)
//
//   - DeleteBucketReplication (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketReplication.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketReplication
func (c *S3Control) PutBucketReplication(input *PutBucketReplicationInput) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	return out, req.Send()
}

// PutBucketReplicationWithContext is the same as PutBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketReplicationWithContext(ctx aws.Context, input *PutBucketReplicationInput, opts ...request.Option) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketTagging for more information on using the PutBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketTaggingRequest method.
//	req, resp := client.PutBucketTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketTagging
func (c *S3Control) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	output = &PutBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketTagging API operation for AWS S3 Control.
//
// This action puts tags on an Amazon S3 on Outposts bucket. To put tags on
// an S3 bucket, see PutBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html)
// in the Amazon S3 API Reference.
//
// Sets the tags for an S3 on Outposts bucket. For more information, see Using
// Amazon S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
// in the Amazon S3 User Guide.
//
// Use tags to organize your Amazon Web Services bill to reflect your own cost
// structure. To do this, sign up to get your Amazon Web Services account bill
// with tag key values included. Then, to see the cost of combined resources,
// organize your billing information according to resources with the same tag
// key values. For example, you can tag several resources with a specific application
// name, and then organize your billing information to see the total cost of
// that application across several services. For more information, see Cost
// allocation and tagging (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html).
//
// Within a bucket, if you add a tag that has the same key as an existing tag,
// the new value overwrites the old value. For more information, see Using cost
// allocation in Amazon S3 bucket tags (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html).
//
// To use this action, you must have permissions to perform the s3-outposts:PutBucketTagging
// action. The Outposts bucket owner has this permission by default and can
// grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing access permissions to your Amazon S3 resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// PutBucketTagging has the following special errors:
//
//   - Error code: InvalidTagError Description: The tag provided was not a
//     valid tag. This error can occur if the tag did not pass input validation.
//     For information about tag restrictions, see User-Defined Tag Restrictions
//     (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
//     and Amazon Web Services-Generated Cost Allocation Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html).
//
//   - Error code: MalformedXMLError Description: The XML provided does not
//     match the schema.
//
//   - Error code: OperationAbortedError Description: A conflicting conditional
//     action is currently in progress against this resource. Try again.
//
//   - Error code: InternalError Description: The service was unable to apply
//     the provided tag to the bucket.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples)
// section.
//
// The following actions are related to PutBucketTagging:
//
//   - GetBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html)
//
//   - DeleteBucketTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketTagging
func (c *S3Control) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	return out, req.Send()
}

// PutBucketTaggingWithContext is the same as PutBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketTaggingWithContext(ctx aws.Context, input *PutBucketTaggingInput, opts ...request.Option) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketVersioning for more information on using the PutBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBucketVersioningRequest method.
//	req, resp := client.PutBucketVersioningRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketVersioning
func (c *S3Control) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/bucket/{name}/versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	output = &PutBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	// update account id or check if provided input for account id member matches
	// the account id present in ARN
	req.Handlers.Validate.PushFrontNamed(updateAccountIDWithARNHandler)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketVersioning API operation for AWS S3 Control.
//
// This operation sets the versioning state for S3 on Outposts buckets only.
// To set the versioning state for an S3 bucket, see PutBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html)
// in the Amazon S3 API Reference.
//
// Sets the versioning state for an S3 on Outposts bucket. With S3 Versioning,
// you can save multiple distinct copies of your objects and recover from unintended
// user actions and application failures.
//
// You can set the versioning state to one of the following:
//
//   - Enabled - Enables versioning for the objects in the bucket. All objects
//     added to the bucket receive a unique version ID.
//
//   - Suspended - Suspends versioning for the objects in the bucket. All objects
//     added to the bucket receive the version ID null.
//
// If you've never set versioning on your bucket, it has no versioning state.
// In that case, a GetBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html)
// request does not return a versioning state value.
//
// When you enable S3 Versioning, for each object in your bucket, you have a
// current version and zero or more noncurrent versions. You can configure your
// bucket S3 Lifecycle rules to expire noncurrent versions after a specified
// time period. For more information, see Creating and managing a lifecycle
// configuration for your S3 on Outposts bucket (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsLifecycleManaging.html)
// in the Amazon S3 User Guide.
//
// If you have an object expiration lifecycle configuration in your non-versioned
// bucket and you want to maintain the same permanent delete behavior when you
// enable versioning, you must add a noncurrent expiration policy. The noncurrent
// expiration lifecycle configuration will manage the deletes of the noncurrent
// object versions in the version-enabled bucket. For more information, see
// Versioning (https://docs.aws.amazon.com/AmazonS3/latest/userguide/Versioning.html)
// in the Amazon S3 User Guide.
//
// All Amazon S3 on Outposts REST API requests for this action require an additional
// parameter of x-amz-outpost-id to be passed with the request. In addition,
// you must use an S3 on Outposts endpoint hostname prefix instead of s3-control.
// For an example of the request syntax for Amazon S3 on Outposts that uses
// the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived
// by using the access point ARN, see the Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketVersioning.html#API_control_PutBucketVersioning_Examples)
// section.
//
// The following operations are related to PutBucketVersioning for S3 on Outposts.
//
//   - GetBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketVersioning.html)
//
//   - PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html)
//
//   - GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutBucketVersioning
func (c *S3Control) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	return out, req.Send()
}

// PutBucketVersioningWithContext is the same as PutBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutBucketVersioningWithContext(ctx aws.Context, input *PutBucketVersioningInput, opts ...request.Option) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobTagging = "PutJobTagging"

// PutJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobTagging for more information on using the PutJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutJobTaggingRequest method.
//	req, resp := client.PutJobTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTaggingRequest(input *PutJobTaggingInput) (req *request.Request, output *PutJobTaggingOutput) {
	op := &request.Operation{
		Name:       opPutJobTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &PutJobTaggingInput{}
	}

	output = &PutJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutJobTagging API operation for AWS S3 Control.
//
// Sets the supplied tag-set on an S3 Batch Operations job.
//
// A tag is a key-value pair. You can associate S3 Batch Operations tags with
// any job by sending a PUT request against the tagging subresource that is
// associated with the job. To modify the existing tag set, you can either replace
// the existing tag set entirely, or make changes within the existing tag set
// by retrieving the existing tag set using GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html),
// modify that tag set, and use this operation to replace the tag set with the
// one you modified. For more information, see Controlling access and labeling
// jobs using tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon S3 User Guide.
//
//   - If you send this request with an empty tag set, Amazon S3 deletes the
//     existing tag set on the Batch Operations job. If you use this method,
//     you are charged for a Tier 1 Request (PUT). For more information, see
//     Amazon S3 pricing (http://aws.amazon.com/s3/pricing/).
//
//   - For deleting existing tags for your Batch Operations job, a DeleteJobTagging
//     (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//     request is preferred because it achieves the same result without incurring
//     charges.
//
//   - A few things to consider about using tags: Amazon S3 limits the maximum
//     number of tags to 50 tags per job. You can associate up to 50 tags with
//     a job as long as they have unique tag keys. A tag key can be up to 128
//     Unicode characters in length, and tag values can be up to 256 Unicode
//     characters in length. The key and values are case sensitive. For tagging-related
//     restrictions related to characters and encodings, see User-Defined Tag
//     Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
//     in the Billing and Cost Management User Guide.
//
// # Permissions
//
// To use the PutJobTagging operation, you must have permission to perform the
// s3:PutJobTagging action.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - GetJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html)
//
//   - DeleteJobTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutJobTagging for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
//   - ErrCodeTooManyTagsException "TooManyTagsException"
//     Amazon S3 throws this exception if you have too many tags in your tag set.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTagging(input *PutJobTaggingInput) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	return out, req.Send()
}

// PutJobTaggingWithContext is the same as PutJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutJobTaggingWithContext(ctx aws.Context, input *PutJobTaggingInput, opts ...request.Option) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMultiRegionAccessPointPolicy = "PutMultiRegionAccessPointPolicy"

// PutMultiRegionAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutMultiRegionAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMultiRegionAccessPointPolicy for more information on using the PutMultiRegionAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMultiRegionAccessPointPolicyRequest method.
//	req, resp := client.PutMultiRegionAccessPointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutMultiRegionAccessPointPolicy
func (c *S3Control) PutMultiRegionAccessPointPolicyRequest(input *PutMultiRegionAccessPointPolicyInput) (req *request.Request, output *PutMultiRegionAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opPutMultiRegionAccessPointPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/async-requests/mrap/put-policy",
	}

	if input == nil {
		input = &PutMultiRegionAccessPointPolicyInput{}
	}

	output = &PutMultiRegionAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutMultiRegionAccessPointPolicy API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Associates an access control policy with the specified Multi-Region Access
// Point. Each Multi-Region Access Point can have only one policy, so a request
// made to this action replaces any existing policy that is associated with
// the specified Multi-Region Access Point.
//
// This action will always be routed to the US West (Oregon) Region. For more
// information about the restrictions around managing Multi-Region Access Points,
// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html)
// in the Amazon S3 User Guide.
//
// The following actions are related to PutMultiRegionAccessPointPolicy:
//
//   - GetMultiRegionAccessPointPolicy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html)
//
//   - GetMultiRegionAccessPointPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutMultiRegionAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutMultiRegionAccessPointPolicy
func (c *S3Control) PutMultiRegionAccessPointPolicy(input *PutMultiRegionAccessPointPolicyInput) (*PutMultiRegionAccessPointPolicyOutput, error) {
	req, out := c.PutMultiRegionAccessPointPolicyRequest(input)
	return out, req.Send()
}

// PutMultiRegionAccessPointPolicyWithContext is the same as PutMultiRegionAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutMultiRegionAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutMultiRegionAccessPointPolicyWithContext(ctx aws.Context, input *PutMultiRegionAccessPointPolicyInput, opts ...request.Option) (*PutMultiRegionAccessPointPolicyOutput, error) {
	req, out := c.PutMultiRegionAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPublicAccessBlock = "PutPublicAccessBlock"

// PutPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPublicAccessBlock for more information on using the PutPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPublicAccessBlockRequest method.
//	req, resp := client.PutPublicAccessBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlockRequest(input *PutPublicAccessBlockInput) (req *request.Request, output *PutPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opPutPublicAccessBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &PutPublicAccessBlockInput{}
	}

	output = &PutPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutPublicAccessBlock API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Creates or modifies the PublicAccessBlock configuration for an Amazon Web
// Services account. For this operation, users must have the s3:PutAccountPublicAccessBlock
// permission. For more information, see Using Amazon S3 block public access
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html).
//
// Related actions include:
//
//   - GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html)
//
//   - DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlock(input *PutPublicAccessBlockInput) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	return out, req.Send()
}

// PutPublicAccessBlockWithContext is the same as PutPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutPublicAccessBlockWithContext(ctx aws.Context, input *PutPublicAccessBlockInput, opts ...request.Option) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStorageLensConfiguration = "PutStorageLensConfiguration"

// PutStorageLensConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutStorageLensConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStorageLensConfiguration for more information on using the PutStorageLensConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutStorageLensConfigurationRequest method.
//	req, resp := client.PutStorageLensConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfiguration
func (c *S3Control) PutStorageLensConfigurationRequest(input *PutStorageLensConfigurationInput) (req *request.Request, output *PutStorageLensConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutStorageLensConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}",
	}

	if input == nil {
		input = &PutStorageLensConfigurationInput{}
	}

	output = &PutStorageLensConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutStorageLensConfiguration API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Puts an Amazon S3 Storage Lens configuration. For more information about
// S3 Storage Lens, see Working with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:PutStorageLensConfiguration
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutStorageLensConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfiguration
func (c *S3Control) PutStorageLensConfiguration(input *PutStorageLensConfigurationInput) (*PutStorageLensConfigurationOutput, error) {
	req, out := c.PutStorageLensConfigurationRequest(input)
	return out, req.Send()
}

// PutStorageLensConfigurationWithContext is the same as PutStorageLensConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutStorageLensConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutStorageLensConfigurationWithContext(ctx aws.Context, input *PutStorageLensConfigurationInput, opts ...request.Option) (*PutStorageLensConfigurationOutput, error) {
	req, out := c.PutStorageLensConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutStorageLensConfigurationTagging = "PutStorageLensConfigurationTagging"

// PutStorageLensConfigurationTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutStorageLensConfigurationTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutStorageLensConfigurationTagging for more information on using the PutStorageLensConfigurationTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutStorageLensConfigurationTaggingRequest method.
//	req, resp := client.PutStorageLensConfigurationTaggingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfigurationTagging
func (c *S3Control) PutStorageLensConfigurationTaggingRequest(input *PutStorageLensConfigurationTaggingInput) (req *request.Request, output *PutStorageLensConfigurationTaggingOutput) {
	op := &request.Operation{
		Name:       opPutStorageLensConfigurationTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/storagelens/{storagelensid}/tagging",
	}

	if input == nil {
		input = &PutStorageLensConfigurationTaggingInput{}
	}

	output = &PutStorageLensConfigurationTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutStorageLensConfigurationTagging API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Put or replace tags on an existing Amazon S3 Storage Lens configuration.
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with Amazon S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html)
// in the Amazon S3 User Guide.
//
// To use this action, you must have permission to perform the s3:PutStorageLensConfigurationTagging
// action. For more information, see Setting permissions to use Amazon S3 Storage
// Lens (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutStorageLensConfigurationTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutStorageLensConfigurationTagging
func (c *S3Control) PutStorageLensConfigurationTagging(input *PutStorageLensConfigurationTaggingInput) (*PutStorageLensConfigurationTaggingOutput, error) {
	req, out := c.PutStorageLensConfigurationTaggingRequest(input)
	return out, req.Send()
}

// PutStorageLensConfigurationTaggingWithContext is the same as PutStorageLensConfigurationTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutStorageLensConfigurationTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutStorageLensConfigurationTaggingWithContext(ctx aws.Context, input *PutStorageLensConfigurationTaggingInput, opts ...request.Option) (*PutStorageLensConfigurationTaggingOutput, error) {
	req, out := c.PutStorageLensConfigurationTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitMultiRegionAccessPointRoutes = "SubmitMultiRegionAccessPointRoutes"

// SubmitMultiRegionAccessPointRoutesRequest generates a "aws/request.Request" representing the
// client's request for the SubmitMultiRegionAccessPointRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitMultiRegionAccessPointRoutes for more information on using the SubmitMultiRegionAccessPointRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitMultiRegionAccessPointRoutesRequest method.
//	req, resp := client.SubmitMultiRegionAccessPointRoutesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/SubmitMultiRegionAccessPointRoutes
func (c *S3Control) SubmitMultiRegionAccessPointRoutesRequest(input *SubmitMultiRegionAccessPointRoutesInput) (req *request.Request, output *SubmitMultiRegionAccessPointRoutesOutput) {
	op := &request.Operation{
		Name:       opSubmitMultiRegionAccessPointRoutes,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v20180820/mrap/instances/{mrap+}/routes",
	}

	if input == nil {
		input = &SubmitMultiRegionAccessPointRoutesInput{}
	}

	output = &SubmitMultiRegionAccessPointRoutesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// SubmitMultiRegionAccessPointRoutes API operation for AWS S3 Control.
//
// This operation is not supported by directory buckets.
//
// Submits an updated route configuration for a Multi-Region Access Point. This
// API operation updates the routing status for the specified Regions from active
// to passive, or from passive to active. A value of 0 indicates a passive status,
// which means that traffic won't be routed to the specified Region. A value
// of 100 indicates an active status, which means that traffic will be routed
// to the specified Region. At least one Region must be active at all times.
//
// When the routing configuration is changed, any in-progress operations (uploads,
// copies, deletes, and so on) to formerly active Regions will continue to run
// to their final completion state (success or failure). The routing configurations
// of any Regions that aren’t specified remain unchanged.
//
// Updated routing configurations might not be immediately applied. It can take
// up to 2 minutes for your changes to take effect.
//
// To submit routing control changes and failover requests, use the Amazon S3
// failover control infrastructure endpoints in these five Amazon Web Services
// Regions:
//
//   - us-east-1
//
//   - us-west-2
//
//   - ap-southeast-2
//
//   - ap-northeast-1
//
//   - eu-west-1
//
// Your Amazon S3 bucket does not need to be in these five Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation SubmitMultiRegionAccessPointRoutes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/SubmitMultiRegionAccessPointRoutes
func (c *S3Control) SubmitMultiRegionAccessPointRoutes(input *SubmitMultiRegionAccessPointRoutesInput) (*SubmitMultiRegionAccessPointRoutesOutput, error) {
	req, out := c.SubmitMultiRegionAccessPointRoutesRequest(input)
	return out, req.Send()
}

// SubmitMultiRegionAccessPointRoutesWithContext is the same as SubmitMultiRegionAccessPointRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitMultiRegionAccessPointRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) SubmitMultiRegionAccessPointRoutesWithContext(ctx aws.Context, input *SubmitMultiRegionAccessPointRoutesInput, opts ...request.Option) (*SubmitMultiRegionAccessPointRoutesOutput, error) {
	req, out := c.SubmitMultiRegionAccessPointRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/TagResource
func (c *S3Control) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/tags/{resourceArn+}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for AWS S3 Control.
//
// Creates a new Amazon Web Services resource tag or updates an existing resource
// tag. Each tag is a label consisting of a user-defined key and value. Tags
// can help you manage, identify, organize, search for, and filter resources.
// You can add up to 50 Amazon Web Services resource tags for each S3 resource.
//
// This operation is only supported for S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html)
// and for S3 Access Grants (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html).
// The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance,
// registered location, or grant.
//
// # Permissions
//
// You must have the s3:TagResource permission to use this operation.
//
// For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about S3 Tagging errors, see List of Amazon S3 Tagging error
// codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation TagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/TagResource
func (c *S3Control) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UntagResource
func (c *S3Control) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/tags/{resourceArn+}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for AWS S3 Control.
//
// This operation removes the specified Amazon Web Services resource tags from
// an S3 resource. Each tag is a label consisting of a user-defined key and
// value. Tags can help you manage, identify, organize, search for, and filter
// resources.
//
// This operation is only supported for S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups.html)
// and for S3 Access Grants (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-tagging.html).
// The tagged resource can be an S3 Storage Lens group or S3 Access Grants instance,
// registered location, or grant.
//
// # Permissions
//
// You must have the s3:UntagResource permission to use this operation.
//
// For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about S3 Tagging errors, see List of Amazon S3 Tagging error
// codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3TaggingErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UntagResource for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UntagResource
func (c *S3Control) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessGrantsLocation = "UpdateAccessGrantsLocation"

// UpdateAccessGrantsLocationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessGrantsLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessGrantsLocation for more information on using the UpdateAccessGrantsLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccessGrantsLocationRequest method.
//	req, resp := client.UpdateAccessGrantsLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateAccessGrantsLocation
func (c *S3Control) UpdateAccessGrantsLocationRequest(input *UpdateAccessGrantsLocationInput) (req *request.Request, output *UpdateAccessGrantsLocationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessGrantsLocation,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accessgrantsinstance/location/{id}",
	}

	if input == nil {
		input = &UpdateAccessGrantsLocationInput{}
	}

	output = &UpdateAccessGrantsLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// UpdateAccessGrantsLocation API operation for AWS S3 Control.
//
// Updates the IAM role of a registered location in your S3 Access Grants instance.
//
// # Permissions
//
// You must have the s3:UpdateAccessGrantsLocation permission to use this operation.
//
// # Additional Permissions
//
// You must also have the following permission: iam:PassRole
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateAccessGrantsLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateAccessGrantsLocation
func (c *S3Control) UpdateAccessGrantsLocation(input *UpdateAccessGrantsLocationInput) (*UpdateAccessGrantsLocationOutput, error) {
	req, out := c.UpdateAccessGrantsLocationRequest(input)
	return out, req.Send()
}

// UpdateAccessGrantsLocationWithContext is the same as UpdateAccessGrantsLocation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessGrantsLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateAccessGrantsLocationWithContext(ctx aws.Context, input *UpdateAccessGrantsLocationInput, opts ...request.Option) (*UpdateAccessGrantsLocationOutput, error) {
	req, out := c.UpdateAccessGrantsLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobPriority = "UpdateJobPriority"

// UpdateJobPriorityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobPriority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobPriority for more information on using the UpdateJobPriority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobPriorityRequest method.
//	req, resp := client.UpdateJobPriorityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriorityRequest(input *UpdateJobPriorityInput) (req *request.Request, output *UpdateJobPriorityOutput) {
	op := &request.Operation{
		Name:       opUpdateJobPriority,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/priority",
	}

	if input == nil {
		input = &UpdateJobPriorityInput{}
	}

	output = &UpdateJobPriorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobPriority API operation for AWS S3 Control.
//
// Updates an existing S3 Batch Operations job's priority. For more information,
// see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// To use the UpdateJobPriority operation, you must have permission to perform
// the s3:UpdateJobPriority action.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//   - DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//   - UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobPriority for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeBadRequestException "BadRequestException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriority(input *UpdateJobPriorityInput) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	return out, req.Send()
}

// UpdateJobPriorityWithContext is the same as UpdateJobPriority with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobPriority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobPriorityWithContext(ctx aws.Context, input *UpdateJobPriorityInput, opts ...request.Option) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobStatus = "UpdateJobStatus"

// UpdateJobStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobStatus for more information on using the UpdateJobStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobStatusRequest method.
//	req, resp := client.UpdateJobStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatusRequest(input *UpdateJobStatusInput) (req *request.Request, output *UpdateJobStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateJobStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/status",
	}

	if input == nil {
		input = &UpdateJobStatusInput{}
	}

	output = &UpdateJobStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobStatus API operation for AWS S3 Control.
//
// Updates the status for the specified job. Use this operation to confirm that
// you want to run a job or to cancel an existing job. For more information,
// see S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html)
// in the Amazon S3 User Guide.
//
// # Permissions
//
// To use the UpdateJobStatus operation, you must have permission to perform
// the s3:UpdateJobStatus action.
//
// Related actions include:
//
//   - CreateJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html)
//
//   - ListJobs (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html)
//
//   - DescribeJob (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html)
//
//   - UpdateJobStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobStatus for usage and error information.
//
// Returned Error Codes:
//
//   - ErrCodeBadRequestException "BadRequestException"
//
//   - ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   - ErrCodeNotFoundException "NotFoundException"
//
//   - ErrCodeJobStatusException "JobStatusException"
//
//   - ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatus(input *UpdateJobStatusInput) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	return out, req.Send()
}

// UpdateJobStatusWithContext is the same as UpdateJobStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobStatusWithContext(ctx aws.Context, input *UpdateJobStatusInput, opts ...request.Option) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStorageLensGroup = "UpdateStorageLensGroup"

// UpdateStorageLensGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStorageLensGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStorageLensGroup for more information on using the UpdateStorageLensGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStorageLensGroupRequest method.
//	req, resp := client.UpdateStorageLensGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateStorageLensGroup
func (c *S3Control) UpdateStorageLensGroupRequest(input *UpdateStorageLensGroupInput) (req *request.Request, output *UpdateStorageLensGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateStorageLensGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/storagelensgroup/{name}",
	}

	if input == nil {
		input = &UpdateStorageLensGroupInput{}
	}

	output = &UpdateStorageLensGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateStorageLensGroup API operation for AWS S3 Control.
//
// Updates the existing Storage Lens group.
//
// To use this operation, you must have the permission to perform the s3:UpdateStorageLensGroup
// action. For more information about the required Storage Lens Groups permissions,
// see Setting account permissions to use S3 Storage Lens groups (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_iam_permissions.html#storage_lens_groups_permissions).
//
// For information about Storage Lens groups errors, see List of Amazon S3 Storage
// Lens error codes (https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#S3LensErrorCodeList).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateStorageLensGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateStorageLensGroup
func (c *S3Control) UpdateStorageLensGroup(input *UpdateStorageLensGroupInput) (*UpdateStorageLensGroupOutput, error) {
	req, out := c.UpdateStorageLensGroupRequest(input)
	return out, req.Send()
}

// UpdateStorageLensGroupWithContext is the same as UpdateStorageLensGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStorageLensGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateStorageLensGroupWithContext(ctx aws.Context, input *UpdateStorageLensGroupInput, opts ...request.Option) (*UpdateStorageLensGroupOutput, error) {
	req, out := c.UpdateStorageLensGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The container for abort incomplete multipart upload
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after which Amazon S3 aborts an incomplete multipart
	// upload to the Outposts bucket.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AbortIncompleteMultipartUpload) SetDaysAfterInitiation(v int64) *AbortIncompleteMultipartUpload {
	s.DaysAfterInitiation = &v
	return s
}

// A container for information about access control for replicas.
//
// This is not supported by Amazon S3 on Outposts buckets.
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// Specifies the replica ownership.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true" enum:"OwnerOverride"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlTranslation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlTranslation"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwner sets the Owner field's value.
func (s *AccessControlTranslation) SetOwner(v string) *AccessControlTranslation {
	s.Owner = &v
	return s
}

// The configuration options of the S3 Access Grants location. It contains the
// S3SubPrefix field. The grant scope, the data to which you are granting access,
// is the result of appending the Subprefix field to the scope of the registered
// location.
type AccessGrantsLocationConfiguration struct {
	_ struct{} `type:"structure"`

	// The S3SubPrefix is appended to the location scope creating the grant scope.
	// Use this field to narrow the scope of the grant to a subset of the location
	// scope. This field is required if the location scope is the default location
	// s3:// because you cannot create a grant for all of your S3 data in the Region
	// and must narrow the scope. For example, if the location scope is the default
	// location s3://, the S3SubPrefx can be a <bucket-name>/*, so the full grant
	// scope path would be s3://<bucket-name>/*. Or the S3SubPrefx can be <bucket-name>/<prefix-name>*,
	// so the full grant scope path would be or s3://<bucket-name>/<prefix-name>*.
	//
	// If the S3SubPrefix includes a prefix, append the wildcard character * after
	// the prefix to indicate that you want to include all object key names in the
	// bucket that start with that prefix.
	S3SubPrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessGrantsLocationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessGrantsLocationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessGrantsLocationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessGrantsLocationConfiguration"}
	if s.S3SubPrefix != nil && len(*s.S3SubPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3SubPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3SubPrefix sets the S3SubPrefix field's value.
func (s *AccessGrantsLocationConfiguration) SetS3SubPrefix(v string) *AccessGrantsLocationConfiguration {
	s.S3SubPrefix = &v
	return s
}

// An access point used to access a bucket.
type AccessPoint struct {
	_ struct{} `type:"structure"`

	// The ARN for the access point.
	AccessPointArn *string `min:"4" type:"string"`

	// The name or alias of the access point.
	Alias *string `type:"string"`

	// The name of the bucket associated with this access point.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The Amazon Web Services account ID associated with the S3 bucket associated
	// with this access point.
	BucketAccountId *string `type:"string"`

	// The name of this access point.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// NetworkOrigin is a required field
	NetworkOrigin *string `type:"string" required:"true" enum:"NetworkOrigin"`

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists.
	//
	// This element is empty if this access point is an Amazon S3 on Outposts access
	// point that is used by other Amazon Web Services.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPoint) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *AccessPoint) SetAccessPointArn(v string) *AccessPoint {
	s.AccessPointArn = &v
	return s
}

// SetAlias sets the Alias field's value.
func (s *AccessPoint) SetAlias(v string) *AccessPoint {
	s.Alias = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *AccessPoint) SetBucket(v string) *AccessPoint {
	s.Bucket = &v
	return s
}

// SetBucketAccountId sets the BucketAccountId field's value.
func (s *AccessPoint) SetBucketAccountId(v string) *AccessPoint {
	s.BucketAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPoint) SetName(v string) *AccessPoint {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *AccessPoint) SetNetworkOrigin(v string) *AccessPoint {
	s.NetworkOrigin = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AccessPoint) SetVpcConfiguration(v *VpcConfiguration) *AccessPoint {
	s.VpcConfiguration = v
	return s
}

// A container element for the account-level Amazon S3 Storage Lens configuration.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AccountLevel struct {
	_ struct{} `type:"structure"`

	// A container element for S3 Storage Lens activity metrics.
	ActivityMetrics *ActivityMetrics `type:"structure"`

	// A container element for S3 Storage Lens advanced cost-optimization metrics.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics `type:"structure"`

	// A container element for S3 Storage Lens advanced data-protection metrics.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics `type:"structure"`

	// A container element for the S3 Storage Lens bucket-level configuration.
	//
	// BucketLevel is a required field
	BucketLevel *BucketLevel `type:"structure" required:"true"`

	// A container element for detailed status code metrics.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics `type:"structure"`

	// A container element for S3 Storage Lens groups metrics.
	StorageLensGroupLevel *StorageLensGroupLevel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountLevel"}
	if s.BucketLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketLevel"))
	}
	if s.BucketLevel != nil {
		if err := s.BucketLevel.Validate(); err != nil {
			invalidParams.AddNested("BucketLevel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityMetrics sets the ActivityMetrics field's value.
func (s *AccountLevel) SetActivityMetrics(v *ActivityMetrics) *AccountLevel {
	s.ActivityMetrics = v
	return s
}

// SetAdvancedCostOptimizationMetrics sets the AdvancedCostOptimizationMetrics field's value.
func (s *AccountLevel) SetAdvancedCostOptimizationMetrics(v *AdvancedCostOptimizationMetrics) *AccountLevel {
	s.AdvancedCostOptimizationMetrics = v
	return s
}

// SetAdvancedDataProtectionMetrics sets the AdvancedDataProtectionMetrics field's value.
func (s *AccountLevel) SetAdvancedDataProtectionMetrics(v *AdvancedDataProtectionMetrics) *AccountLevel {
	s.AdvancedDataProtectionMetrics = v
	return s
}

// SetBucketLevel sets the BucketLevel field's value.
func (s *AccountLevel) SetBucketLevel(v *BucketLevel) *AccountLevel {
	s.BucketLevel = v
	return s
}

// SetDetailedStatusCodesMetrics sets the DetailedStatusCodesMetrics field's value.
func (s *AccountLevel) SetDetailedStatusCodesMetrics(v *DetailedStatusCodesMetrics) *AccountLevel {
	s.DetailedStatusCodesMetrics = v
	return s
}

// SetStorageLensGroupLevel sets the StorageLensGroupLevel field's value.
func (s *AccountLevel) SetStorageLensGroupLevel(v *StorageLensGroupLevel) *AccountLevel {
	s.StorageLensGroupLevel = v
	return s
}

// The container element for Amazon S3 Storage Lens activity metrics. Activity
// metrics show details about how your storage is requested, such as requests
// (for example, All requests, Get requests, Put requests), bytes uploaded or
// downloaded, and errors.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type ActivityMetrics struct {
	_ struct{} `type:"structure"`

	// A container that indicates whether activity metrics are enabled.
	IsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivityMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivityMetrics) GoString() string {
	return s.String()
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *ActivityMetrics) SetIsEnabled(v bool) *ActivityMetrics {
	s.IsEnabled = &v
	return s
}

// The container element for Amazon S3 Storage Lens advanced cost-optimization
// metrics. Advanced cost-optimization metrics provide insights that you can
// use to manage and optimize your storage costs, for example, lifecycle rule
// counts for transitions, expirations, and incomplete multipart uploads.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AdvancedCostOptimizationMetrics struct {
	_ struct{} `type:"structure"`

	// A container that indicates whether advanced cost-optimization metrics are
	// enabled.
	IsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedCostOptimizationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedCostOptimizationMetrics) GoString() string {
	return s.String()
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *AdvancedCostOptimizationMetrics) SetIsEnabled(v bool) *AdvancedCostOptimizationMetrics {
	s.IsEnabled = &v
	return s
}

// The container element for Amazon S3 Storage Lens advanced data-protection
// metrics. Advanced data-protection metrics provide insights that you can use
// to perform audits and protect your data, for example replication rule counts
// within and across Regions.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type AdvancedDataProtectionMetrics struct {
	_ struct{} `type:"structure"`

	// A container that indicates whether advanced data-protection metrics are enabled.
	IsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedDataProtectionMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedDataProtectionMetrics) GoString() string {
	return s.String()
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *AdvancedDataProtectionMetrics) SetIsEnabled(v bool) *AdvancedDataProtectionMetrics {
	s.IsEnabled = &v
	return s
}

type AssociateAccessGrantsIdentityCenterInput struct {
	_ struct{} `locationName:"AssociateAccessGrantsIdentityCenterRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
	// instance that you are associating with your S3 Access Grants instance. An
	// IAM Identity Center instance is your corporate identity directory that you
	// added to the IAM Identity Center. You can use the ListInstances (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html)
	// API operation to retrieve a list of your Identity Center instances and their
	// ARNs.
	//
	// IdentityCenterArn is a required field
	IdentityCenterArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessGrantsIdentityCenterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessGrantsIdentityCenterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAccessGrantsIdentityCenterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAccessGrantsIdentityCenterInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.IdentityCenterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityCenterArn"))
	}
	if s.IdentityCenterArn != nil && len(*s.IdentityCenterArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityCenterArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociateAccessGrantsIdentityCenterInput) SetAccountId(v string) *AssociateAccessGrantsIdentityCenterInput {
	s.AccountId = &v
	return s
}

// SetIdentityCenterArn sets the IdentityCenterArn field's value.
func (s *AssociateAccessGrantsIdentityCenterInput) SetIdentityCenterArn(v string) *AssociateAccessGrantsIdentityCenterInput {
	s.IdentityCenterArn = &v
	return s
}

func (s *AssociateAccessGrantsIdentityCenterInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type AssociateAccessGrantsIdentityCenterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessGrantsIdentityCenterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessGrantsIdentityCenterOutput) GoString() string {
	return s.String()
}

// Error details for the failed asynchronous operation.
type AsyncErrorDetails struct {
	_ struct{} `type:"structure"`

	// A string that uniquely identifies the error condition.
	Code *string `type:"string"`

	// A generic description of the error condition in English.
	Message *string `type:"string"`

	// The ID of the request associated with the error.
	RequestId *string `type:"string"`

	// The identifier of the resource associated with the error.
	Resource *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AsyncErrorDetails) SetCode(v string) *AsyncErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AsyncErrorDetails) SetMessage(v string) *AsyncErrorDetails {
	s.Message = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AsyncErrorDetails) SetRequestId(v string) *AsyncErrorDetails {
	s.RequestId = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *AsyncErrorDetails) SetResource(v string) *AsyncErrorDetails {
	s.Resource = &v
	return s
}

// A container for the information about an asynchronous operation.
type AsyncOperation struct {
	_ struct{} `type:"structure"`

	// The time that the request was sent to the service.
	CreationTime *time.Time `type:"timestamp"`

	// The specific operation for the asynchronous request.
	Operation *string `type:"string" enum:"AsyncOperationName"`

	// The parameters associated with the request.
	RequestParameters *AsyncRequestParameters `type:"structure"`

	// The current status of the request.
	RequestStatus *string `type:"string"`

	// The request token associated with the request.
	RequestTokenARN *string `min:"1" type:"string"`

	// The details of the response.
	ResponseDetails *AsyncResponseDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncOperation) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *AsyncOperation) SetCreationTime(v time.Time) *AsyncOperation {
	s.CreationTime = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *AsyncOperation) SetOperation(v string) *AsyncOperation {
	s.Operation = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *AsyncOperation) SetRequestParameters(v *AsyncRequestParameters) *AsyncOperation {
	s.RequestParameters = v
	return s
}

// SetRequestStatus sets the RequestStatus field's value.
func (s *AsyncOperation) SetRequestStatus(v string) *AsyncOperation {
	s.RequestStatus = &v
	return s
}

// SetRequestTokenARN sets the RequestTokenARN field's value.
func (s *AsyncOperation) SetRequestTokenARN(v string) *AsyncOperation {
	s.RequestTokenARN = &v
	return s
}

// SetResponseDetails sets the ResponseDetails field's value.
func (s *AsyncOperation) SetResponseDetails(v *AsyncResponseDetails) *AsyncOperation {
	s.ResponseDetails = v
	return s
}

// A container for the request parameters associated with an asynchronous request.
type AsyncRequestParameters struct {
	_ struct{} `type:"structure"`

	// A container of the parameters for a CreateMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
	// request.
	CreateMultiRegionAccessPointRequest *CreateMultiRegionAccessPointInput_ `type:"structure"`

	// A container of the parameters for a DeleteMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
	// request.
	DeleteMultiRegionAccessPointRequest *DeleteMultiRegionAccessPointInput_ `type:"structure"`

	// A container of the parameters for a PutMultiRegionAccessPoint (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html)
	// request.
	PutMultiRegionAccessPointPolicyRequest *PutMultiRegionAccessPointPolicyInput_ `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncRequestParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncRequestParameters) GoString() string {
	return s.String()
}

// SetCreateMultiRegionAccessPointRequest sets the CreateMultiRegionAccessPointRequest field's value.
func (s *AsyncRequestParameters) SetCreateMultiRegionAccessPointRequest(v *CreateMultiRegionAccessPointInput_) *AsyncRequestParameters {
	s.CreateMultiRegionAccessPointRequest = v
	return s
}

// SetDeleteMultiRegionAccessPointRequest sets the DeleteMultiRegionAccessPointRequest field's value.
func (s *AsyncRequestParameters) SetDeleteMultiRegionAccessPointRequest(v *DeleteMultiRegionAccessPointInput_) *AsyncRequestParameters {
	s.DeleteMultiRegionAccessPointRequest = v
	return s
}

// SetPutMultiRegionAccessPointPolicyRequest sets the PutMultiRegionAccessPointPolicyRequest field's value.
func (s *AsyncRequestParameters) SetPutMultiRegionAccessPointPolicyRequest(v *PutMultiRegionAccessPointPolicyInput_) *AsyncRequestParameters {
	s.PutMultiRegionAccessPointPolicyRequest = v
	return s
}

// A container for the response details that are returned when querying about
// an asynchronous request.
type AsyncResponseDetails struct {
	_ struct{} `type:"structure"`

	// Error details for an asynchronous request.
	ErrorDetails *AsyncErrorDetails `type:"structure"`

	// The details for the Multi-Region Access Point.
	MultiRegionAccessPointDetails *MultiRegionAccessPointsAsyncResponse `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncResponseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsyncResponseDetails) GoString() string {
	return s.String()
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *AsyncResponseDetails) SetErrorDetails(v *AsyncErrorDetails) *AsyncResponseDetails {
	s.ErrorDetails = v
	return s
}

// SetMultiRegionAccessPointDetails sets the MultiRegionAccessPointDetails field's value.
func (s *AsyncResponseDetails) SetMultiRegionAccessPointDetails(v *MultiRegionAccessPointsAsyncResponse) *AsyncResponseDetails {
	s.MultiRegionAccessPointDetails = v
	return s
}

// Lambda function used to transform objects through an Object Lambda Access
// Point.
type AwsLambdaTransformation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// FunctionArn is a required field
	FunctionArn *string `min:"1" type:"string" required:"true"`

	// Additional JSON that provides supplemental data to the Lambda function used
	// to transform objects.
	FunctionPayload *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsLambdaTransformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsLambdaTransformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsLambdaTransformation"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *AwsLambdaTransformation) SetFunctionArn(v string) *AwsLambdaTransformation {
	s.FunctionArn = &v
	return s
}

// SetFunctionPayload sets the FunctionPayload field's value.
func (s *AwsLambdaTransformation) SetFunctionPayload(v string) *AwsLambdaTransformation {
	s.FunctionPayload = &v
	return s
}

// A container for the bucket-level configuration for Amazon S3 Storage Lens.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide.
type BucketLevel struct {
	_ struct{} `type:"structure"`

	// A container for the bucket-level activity metrics for S3 Storage Lens.
	ActivityMetrics *ActivityMetrics `type:"structure"`

	// A container for bucket-level advanced cost-optimization metrics for S3 Storage
	// Lens.
	AdvancedCostOptimizationMetrics *AdvancedCostOptimizationMetrics `type:"structure"`

	// A container for bucket-level advanced data-protection metrics for S3 Storage
	// Lens.
	AdvancedDataProtectionMetrics *AdvancedDataProtectionMetrics `type:"structure"`

	// A container for bucket-level detailed status code metrics for S3 Storage
	// Lens.
	DetailedStatusCodesMetrics *DetailedStatusCodesMetrics `type:"structure"`

	// A container for the prefix-level metrics for S3 Storage Lens.
	PrefixLevel *PrefixLevel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BucketLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLevel"}
	if s.PrefixLevel != nil {
		if err := s.PrefixLevel.Validate(); err != nil {
			invalidParams.AddNested("PrefixLevel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityMetrics sets the ActivityMetrics field's value.
func (s *BucketLevel) SetActivityMetrics(v *ActivityMetrics) *BucketLevel {
	s.ActivityMetrics = v
	return s
}

// SetAdvancedCostOptimizationMetrics sets the AdvancedCostOptimizationMetrics field's value.
func (s *BucketLevel) SetAdvancedCostOptimizationMetrics(v *AdvancedCostOptimizationMetrics) *BucketLevel {
	s.AdvancedCostOptimizationMetrics = v
	return s
}

// SetAdvancedDataProtectionMetrics sets the AdvancedDataProtectionMetrics field's value.
func (s *BucketLevel) SetAdvancedDataProtectionMetrics(v *AdvancedDataProtectionMetrics) *BucketLevel {
	s.AdvancedDataProtectionMetrics = v
	return s
}

// SetDetailedStatusCodesMetrics sets the DetailedStatusCodesMetrics field's value.
func (s *BucketLevel) SetDetailedStatusCodesMetrics(v *DetailedStatusCodesMetrics) *BucketLevel {
	s.DetailedStatusCodesMetrics = v
	return s
}

// SetPrefixLevel sets the PrefixLevel field's value.
func (s *BucketLevel) SetPrefixLevel(v *PrefixLevel) *BucketLevel {
	s.PrefixLevel = v
	return s
}

// A container for enabling Amazon CloudWatch publishing for S3 Storage Lens
// metrics.
//
// For more information about publishing S3 Storage Lens metrics to CloudWatch,
// see Monitor S3 Storage Lens metrics in CloudWatch (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html)
// in the Amazon S3 User Guide.
type CloudWatchMetrics struct {
	_ struct{} `type:"structure"`

	// A container that indicates whether CloudWatch publishing for S3 Storage Lens
	// metrics is enabled. A value of true indicates that CloudWatch publishing
	// for S3 Storage Lens metrics is enabled.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchMetrics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchMetrics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchMetrics"}
	if s.IsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("IsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *CloudWatchMetrics) SetIsEnabled(v bool) *CloudWatchMetrics {
	s.IsEnabled = &v
	return s
}

type CreateAccessGrantInput struct {
	_ struct{} `locationName:"CreateAccessGrantRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The configuration options of the grant location. The grant location is the
	// S3 path to the data to which you are granting access. It contains the S3SubPrefix
	// field. The grant scope is the result of appending the subprefix to the location
	// scope of the registered location.
	AccessGrantsLocationConfiguration *AccessGrantsLocationConfiguration `type:"structure"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	//
	// If you are passing the default location, you cannot create an access grant
	// for the entire default location. You must also specify a bucket or a bucket
	// and prefix in the Subprefix field.
	//
	// AccessGrantsLocationId is a required field
	AccessGrantsLocationId *string `min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If an application
	// ARN is included in the request to create an access grant, the grantee can
	// only access the S3 data through this application.
	ApplicationArn *string `min:"10" type:"string"`

	// The user, group, or role to which you are granting access. You can grant
	// access to an IAM user or role. If you have added your corporate directory
	// to Amazon Web Services IAM Identity Center and associated your Identity Center
	// instance with your S3 Access Grants instance, the grantee can also be a corporate
	// directory user or group.
	//
	// Grantee is a required field
	Grantee *Grantee `type:"structure" required:"true"`

	// The type of access that you are granting to your S3 data, which can be set
	// to one of the following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	//
	// Permission is a required field
	Permission *string `type:"string" required:"true" enum:"Permission"`

	// The type of S3SubPrefix. The only possible value is Object. Pass this value
	// if the access grant scope is an object. Do not pass this value if the access
	// grant scope is a bucket or a bucket and a prefix.
	S3PrefixType *string `type:"string" enum:"S3PrefixType"`

	// The Amazon Web Services resource tags that you are adding to the access grant.
	// Each tag is a label consisting of a user-defined key and value. Tags can
	// help you manage, identify, organize, search for, and filter resources.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessGrantInput"}
	if s.AccessGrantsLocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessGrantsLocationId"))
	}
	if s.AccessGrantsLocationId != nil && len(*s.AccessGrantsLocationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessGrantsLocationId", 1))
	}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.Grantee == nil {
		invalidParams.Add(request.NewErrParamRequired("Grantee"))
	}
	if s.Permission == nil {
		invalidParams.Add(request.NewErrParamRequired("Permission"))
	}
	if s.AccessGrantsLocationConfiguration != nil {
		if err := s.AccessGrantsLocationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessGrantsLocationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessGrantsLocationConfiguration sets the AccessGrantsLocationConfiguration field's value.
func (s *CreateAccessGrantInput) SetAccessGrantsLocationConfiguration(v *AccessGrantsLocationConfiguration) *CreateAccessGrantInput {
	s.AccessGrantsLocationConfiguration = v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *CreateAccessGrantInput) SetAccessGrantsLocationId(v string) *CreateAccessGrantInput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessGrantInput) SetAccountId(v string) *CreateAccessGrantInput {
	s.AccountId = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateAccessGrantInput) SetApplicationArn(v string) *CreateAccessGrantInput {
	s.ApplicationArn = &v
	return s
}

// SetGrantee sets the Grantee field's value.
func (s *CreateAccessGrantInput) SetGrantee(v *Grantee) *CreateAccessGrantInput {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *CreateAccessGrantInput) SetPermission(v string) *CreateAccessGrantInput {
	s.Permission = &v
	return s
}

// SetS3PrefixType sets the S3PrefixType field's value.
func (s *CreateAccessGrantInput) SetS3PrefixType(v string) *CreateAccessGrantInput {
	s.S3PrefixType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessGrantInput) SetTags(v []*Tag) *CreateAccessGrantInput {
	s.Tags = v
	return s
}

func (s *CreateAccessGrantInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateAccessGrantOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access grant.
	AccessGrantArn *string `min:"1" type:"string"`

	// The ID of the access grant. S3 Access Grants auto-generates this ID when
	// you create the access grant.
	AccessGrantId *string `min:"1" type:"string"`

	// The configuration options of the grant location. The grant location is the
	// S3 path to the data to which you are granting access.
	AccessGrantsLocationConfiguration *AccessGrantsLocationConfiguration `type:"structure"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string `min:"10" type:"string"`

	// The date and time when you created the access grant.
	CreatedAt *time.Time `type:"timestamp"`

	// The S3 path of the data to which you are granting access. It is the result
	// of appending the Subprefix to the location scope.
	GrantScope *string `min:"1" type:"string"`

	// The user, group, or role to which you are granting access. You can grant
	// access to an IAM user or role. If you have added your corporate directory
	// to Amazon Web Services IAM Identity Center and associated your Identity Center
	// instance with your S3 Access Grants instance, the grantee can also be a corporate
	// directory user or group.
	Grantee *Grantee `type:"structure"`

	// The type of access that you are granting to your S3 data, which can be set
	// to one of the following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantOutput) GoString() string {
	return s.String()
}

// SetAccessGrantArn sets the AccessGrantArn field's value.
func (s *CreateAccessGrantOutput) SetAccessGrantArn(v string) *CreateAccessGrantOutput {
	s.AccessGrantArn = &v
	return s
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *CreateAccessGrantOutput) SetAccessGrantId(v string) *CreateAccessGrantOutput {
	s.AccessGrantId = &v
	return s
}

// SetAccessGrantsLocationConfiguration sets the AccessGrantsLocationConfiguration field's value.
func (s *CreateAccessGrantOutput) SetAccessGrantsLocationConfiguration(v *AccessGrantsLocationConfiguration) *CreateAccessGrantOutput {
	s.AccessGrantsLocationConfiguration = v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *CreateAccessGrantOutput) SetAccessGrantsLocationId(v string) *CreateAccessGrantOutput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateAccessGrantOutput) SetApplicationArn(v string) *CreateAccessGrantOutput {
	s.ApplicationArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAccessGrantOutput) SetCreatedAt(v time.Time) *CreateAccessGrantOutput {
	s.CreatedAt = &v
	return s
}

// SetGrantScope sets the GrantScope field's value.
func (s *CreateAccessGrantOutput) SetGrantScope(v string) *CreateAccessGrantOutput {
	s.GrantScope = &v
	return s
}

// SetGrantee sets the Grantee field's value.
func (s *CreateAccessGrantOutput) SetGrantee(v *Grantee) *CreateAccessGrantOutput {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *CreateAccessGrantOutput) SetPermission(v string) *CreateAccessGrantOutput {
	s.Permission = &v
	return s
}

type CreateAccessGrantsInstanceInput struct {
	_ struct{} `locationName:"CreateAccessGrantsInstanceRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// If you would like to associate your S3 Access Grants instance with an Amazon
	// Web Services IAM Identity Center instance, use this field to pass the Amazon
	// Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance
	// that you are associating with your S3 Access Grants instance. An IAM Identity
	// Center instance is your corporate identity directory that you added to the
	// IAM Identity Center. You can use the ListInstances (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html)
	// API operation to retrieve a list of your Identity Center instances and their
	// ARNs.
	IdentityCenterArn *string `min:"10" type:"string"`

	// The Amazon Web Services resource tags that you are adding to the S3 Access
	// Grants instance. Each tag is a label consisting of a user-defined key and
	// value. Tags can help you manage, identify, organize, search for, and filter
	// resources.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessGrantsInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessGrantsInstanceInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.IdentityCenterArn != nil && len(*s.IdentityCenterArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityCenterArn", 10))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessGrantsInstanceInput) SetAccountId(v string) *CreateAccessGrantsInstanceInput {
	s.AccountId = &v
	return s
}

// SetIdentityCenterArn sets the IdentityCenterArn field's value.
func (s *CreateAccessGrantsInstanceInput) SetIdentityCenterArn(v string) *CreateAccessGrantsInstanceInput {
	s.IdentityCenterArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessGrantsInstanceInput) SetTags(v []*Tag) *CreateAccessGrantsInstanceInput {
	s.Tags = v
	return s
}

func (s *CreateAccessGrantsInstanceInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateAccessGrantsInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 Access Grants instance.
	AccessGrantsInstanceArn *string `min:"1" type:"string"`

	// The ID of the S3 Access Grants instance. The ID is default. You can have
	// one S3 Access Grants instance per Region per account.
	AccessGrantsInstanceId *string `min:"1" type:"string"`

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time `type:"timestamp"`

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name
	// (ARN) of the IAM Identity Center instance application; a subresource of the
	// original Identity Center instance passed in the request. S3 Access Grants
	// creates this Identity Center application for this specific S3 Access Grants
	// instance.
	IdentityCenterArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsInstanceOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsInstanceArn sets the AccessGrantsInstanceArn field's value.
func (s *CreateAccessGrantsInstanceOutput) SetAccessGrantsInstanceArn(v string) *CreateAccessGrantsInstanceOutput {
	s.AccessGrantsInstanceArn = &v
	return s
}

// SetAccessGrantsInstanceId sets the AccessGrantsInstanceId field's value.
func (s *CreateAccessGrantsInstanceOutput) SetAccessGrantsInstanceId(v string) *CreateAccessGrantsInstanceOutput {
	s.AccessGrantsInstanceId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAccessGrantsInstanceOutput) SetCreatedAt(v time.Time) *CreateAccessGrantsInstanceOutput {
	s.CreatedAt = &v
	return s
}

// SetIdentityCenterArn sets the IdentityCenterArn field's value.
func (s *CreateAccessGrantsInstanceOutput) SetIdentityCenterArn(v string) *CreateAccessGrantsInstanceOutput {
	s.IdentityCenterArn = &v
	return s
}

type CreateAccessGrantsLocationInput struct {
	_ struct{} `locationName:"CreateAccessGrantsLocationRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role for the registered location.
	// S3 Access Grants assumes this role to manage access to the registered location.
	//
	// IAMRoleArn is a required field
	IAMRoleArn *string `min:"1" type:"string" required:"true"`

	// The S3 path to the location that you are registering. The location scope
	// can be the default S3 location s3://, the S3 path to a bucket s3://<bucket>,
	// or the S3 path to a bucket and prefix s3://<bucket>/<prefix>. A prefix in
	// S3 is a string of characters at the beginning of an object key name used
	// to organize the objects that you store in your S3 buckets. For example, object
	// key names that start with the engineering/ prefix or object key names that
	// start with the marketing/campaigns/ prefix.
	//
	// LocationScope is a required field
	LocationScope *string `min:"1" type:"string" required:"true"`

	// The Amazon Web Services resource tags that you are adding to the S3 Access
	// Grants location. Each tag is a label consisting of a user-defined key and
	// value. Tags can help you manage, identify, organize, search for, and filter
	// resources.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessGrantsLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessGrantsLocationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.IAMRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IAMRoleArn"))
	}
	if s.IAMRoleArn != nil && len(*s.IAMRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IAMRoleArn", 1))
	}
	if s.LocationScope == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationScope"))
	}
	if s.LocationScope != nil && len(*s.LocationScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationScope", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessGrantsLocationInput) SetAccountId(v string) *CreateAccessGrantsLocationInput {
	s.AccountId = &v
	return s
}

// SetIAMRoleArn sets the IAMRoleArn field's value.
func (s *CreateAccessGrantsLocationInput) SetIAMRoleArn(v string) *CreateAccessGrantsLocationInput {
	s.IAMRoleArn = &v
	return s
}

// SetLocationScope sets the LocationScope field's value.
func (s *CreateAccessGrantsLocationInput) SetLocationScope(v string) *CreateAccessGrantsLocationInput {
	s.LocationScope = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessGrantsLocationInput) SetTags(v []*Tag) *CreateAccessGrantsLocationInput {
	s.Tags = v
	return s
}

func (s *CreateAccessGrantsLocationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateAccessGrantsLocationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the location you are registering.
	AccessGrantsLocationArn *string `min:"1" type:"string"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The date and time when you registered the location.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role for the registered location.
	// S3 Access Grants assumes this role to manage access to the registered location.
	IAMRoleArn *string `min:"1" type:"string"`

	// The S3 URI path to the location that you are registering. The location scope
	// can be the default S3 location s3://, the S3 path to a bucket, or the S3
	// path to a bucket and prefix. A prefix in S3 is a string of characters at
	// the beginning of an object key name used to organize the objects that you
	// store in your S3 buckets. For example, object key names that start with the
	// engineering/ prefix or object key names that start with the marketing/campaigns/
	// prefix.
	LocationScope *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessGrantsLocationOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsLocationArn sets the AccessGrantsLocationArn field's value.
func (s *CreateAccessGrantsLocationOutput) SetAccessGrantsLocationArn(v string) *CreateAccessGrantsLocationOutput {
	s.AccessGrantsLocationArn = &v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *CreateAccessGrantsLocationOutput) SetAccessGrantsLocationId(v string) *CreateAccessGrantsLocationOutput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAccessGrantsLocationOutput) SetCreatedAt(v time.Time) *CreateAccessGrantsLocationOutput {
	s.CreatedAt = &v
	return s
}

// SetIAMRoleArn sets the IAMRoleArn field's value.
func (s *CreateAccessGrantsLocationOutput) SetIAMRoleArn(v string) *CreateAccessGrantsLocationOutput {
	s.IAMRoleArn = &v
	return s
}

// SetLocationScope sets the LocationScope field's value.
func (s *CreateAccessGrantsLocationOutput) SetLocationScope(v string) *CreateAccessGrantsLocationOutput {
	s.LocationScope = &v
	return s
}

type CreateAccessPointForObjectLambdaInput struct {
	_ struct{} `locationName:"CreateAccessPointForObjectLambdaRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for owner of the specified Object Lambda
	// Access Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Object Lambda Access Point configuration as a JSON document.
	//
	// Configuration is a required field
	Configuration *ObjectLambdaConfiguration `type:"structure" required:"true"`

	// The name you want to assign to this Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPointForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessPointForObjectLambdaInput) SetAccountId(v string) *CreateAccessPointForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateAccessPointForObjectLambdaInput) SetConfiguration(v *ObjectLambdaConfiguration) *CreateAccessPointForObjectLambdaInput {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPointForObjectLambdaInput) SetName(v string) *CreateAccessPointForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *CreateAccessPointForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateAccessPointForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// The alias of the Object Lambda Access Point.
	Alias *ObjectLambdaAccessPointAlias `type:"structure"`

	// Specifies the ARN for the Object Lambda Access Point.
	ObjectLambdaAccessPointArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAccessPointForObjectLambdaOutput) SetAlias(v *ObjectLambdaAccessPointAlias) *CreateAccessPointForObjectLambdaOutput {
	s.Alias = v
	return s
}

// SetObjectLambdaAccessPointArn sets the ObjectLambdaAccessPointArn field's value.
func (s *CreateAccessPointForObjectLambdaOutput) SetObjectLambdaAccessPointArn(v string) *CreateAccessPointForObjectLambdaOutput {
	s.ObjectLambdaAccessPointArn = &v
	return s
}

type CreateAccessPointInput struct {
	_ struct{} `locationName:"CreateAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for the account that owns the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket that you want to associate this access point with.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The Amazon Web Services account ID associated with the S3 bucket associated
	// with this access point.
	BucketAccountId *string `type:"string"`

	// The name you want to assign to this access point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to the access
	// point.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// If you include this field, Amazon S3 restricts access to this access point
	// to requests from the specified virtual private cloud (VPC).
	//
	// This is required for creating an access point for Amazon S3 on Outposts buckets.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessPointInput) SetAccountId(v string) *CreateAccessPointInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateAccessPointInput) SetBucket(v string) *CreateAccessPointInput {
	s.Bucket = &v
	return s
}

// SetBucketAccountId sets the BucketAccountId field's value.
func (s *CreateAccessPointInput) SetBucketAccountId(v string) *CreateAccessPointInput {
	s.BucketAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPointInput) SetName(v string) *CreateAccessPointInput {
	s.Name = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *CreateAccessPointInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *CreateAccessPointInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateAccessPointInput) SetVpcConfiguration(v *VpcConfiguration) *CreateAccessPointInput {
	s.VpcConfiguration = v
	return s
}

func (s *CreateAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *CreateAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *CreateAccessPointInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s CreateAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s CreateAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

// updateBucketAccountId returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s CreateAccessPointInput) updateBucketAccountId(accountId string) (interface{}, error) {
	if s.BucketAccountId == nil {
		s.BucketAccountId = aws.String(accountId)
		return &s, nil
	} else if *s.BucketAccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type CreateAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point.
	//
	// This is only supported by Amazon S3 on Outposts.
	AccessPointArn *string `min:"4" type:"string"`

	// The name or alias of the access point.
	Alias *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *CreateAccessPointOutput) SetAccessPointArn(v string) *CreateAccessPointOutput {
	s.AccessPointArn = &v
	return s
}

// SetAlias sets the Alias field's value.
func (s *CreateAccessPointOutput) SetAlias(v string) *CreateAccessPointOutput {
	s.Alias = &v
	return s
}

// The container for the bucket configuration.
//
// This is not supported by Amazon S3 on Outposts buckets.
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you are creating
	// a bucket on the US East (N. Virginia) Region (us-east-1), you do not need
	// to specify the location.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

type CreateBucketInput struct {
	_ struct{} `locationName:"CreateBucketRequest" type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// The name of the bucket.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The configuration information for the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Specifies whether you want S3 Object Lock to be enabled for the new bucket.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ObjectLockEnabledForBucket *bool `location:"header" locationName:"x-amz-bucket-object-lock-enabled" type:"boolean"`

	// The ID of the Outposts where the bucket is being created.
	//
	// This ID is required by Amazon S3 on Outposts buckets.
	OutpostId *string `location:"header" locationName:"x-amz-outpost-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

// SetObjectLockEnabledForBucket sets the ObjectLockEnabledForBucket field's value.
func (s *CreateBucketInput) SetObjectLockEnabledForBucket(v bool) *CreateBucketInput {
	s.ObjectLockEnabledForBucket = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *CreateBucketInput) SetOutpostId(v string) *CreateBucketInput {
	s.OutpostId = &v
	return s
}

func (s *CreateBucketInput) getOutpostID() (string, error) {
	if s.OutpostId == nil {
		return "", fmt.Errorf("member OutpostId is nil")
	}
	return *s.OutpostId, nil
}

func (s *CreateBucketInput) hasOutpostID() bool {
	if s.OutpostId == nil {
		return false
	}
	return true
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	BucketArn *string `min:"4" type:"string"`

	// The location of the bucket.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetBucketArn sets the BucketArn field's value.
func (s *CreateBucketOutput) SetBucketArn(v string) *CreateBucketOutput {
	s.BucketArn = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `locationName:"CreateJobRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID that creates the job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// An idempotency token to ensure that you don't accidentally submit the same
	// request twice. You can use any string up to the maximum length.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Indicates whether confirmation is required before Amazon S3 runs the job.
	// Confirmation is only required for jobs created through the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A description for this job. You can use any string within the permitted length.
	// Descriptions don't need to be unique and can be used for multiple jobs.
	Description *string `min:"1" type:"string"`

	// Configuration parameters for the manifest.
	Manifest *JobManifest `type:"structure"`

	// The attribute container for the ManifestGenerator details. Jobs must be created
	// with either a manifest file or a ManifestGenerator, but not both.
	ManifestGenerator *JobManifestGenerator `type:"structure"`

	// The action that you want this job to perform on every object listed in the
	// manifest. For more information about the available actions, see Operations
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html)
	// in the Amazon S3 User Guide.
	//
	// Operation is a required field
	Operation *JobOperation `type:"structure" required:"true"`

	// The numerical priority for this job. Higher numbers indicate higher priority.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// Configuration parameters for the optional job-completion report.
	//
	// Report is a required field
	Report *JobReport `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the Identity and Access Management (IAM)
	// role that Batch Operations will use to run this job's action on every object
	// in the manifest.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// A set of tags to associate with the S3 Batch Operations job. This is an optional
	// parameter.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Report == nil {
		invalidParams.Add(request.NewErrParamRequired("Report"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Manifest != nil {
		if err := s.Manifest.Validate(); err != nil {
			invalidParams.AddNested("Manifest", err.(request.ErrInvalidParams))
		}
	}
	if s.ManifestGenerator != nil {
		if err := s.ManifestGenerator.Validate(); err != nil {
			invalidParams.AddNested("ManifestGenerator", err.(request.ErrInvalidParams))
		}
	}
	if s.Operation != nil {
		if err := s.Operation.Validate(); err != nil {
			invalidParams.AddNested("Operation", err.(request.ErrInvalidParams))
		}
	}
	if s.Report != nil {
		if err := s.Report.Validate(); err != nil {
			invalidParams.AddNested("Report", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateJobInput) SetAccountId(v string) *CreateJobInput {
	s.AccountId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateJobInput) SetClientRequestToken(v string) *CreateJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *CreateJobInput) SetConfirmationRequired(v bool) *CreateJobInput {
	s.ConfirmationRequired = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *CreateJobInput) SetManifest(v *JobManifest) *CreateJobInput {
	s.Manifest = v
	return s
}

// SetManifestGenerator sets the ManifestGenerator field's value.
func (s *CreateJobInput) SetManifestGenerator(v *JobManifestGenerator) *CreateJobInput {
	s.ManifestGenerator = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateJobInput) SetOperation(v *JobOperation) *CreateJobInput {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobInput) SetPriority(v int64) *CreateJobInput {
	s.Priority = &v
	return s
}

// SetReport sets the Report field's value.
func (s *CreateJobInput) SetReport(v *JobReport) *CreateJobInput {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateJobInput) SetRoleArn(v string) *CreateJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v []*S3Tag) *CreateJobInput {
	s.Tags = v
	return s
}

func (s *CreateJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID for this job. Amazon S3 generates this ID automatically and returns
	// it after a successful Create Job request.
	JobId *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

type CreateMultiRegionAccessPointInput struct {
	_ struct{} `locationName:"CreateMultiRegionAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point. The owner of the Multi-Region Access Point also must own the underlying
	// buckets.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// An idempotency token used to identify the request and guarantee that requests
	// are unique.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// A container element containing details about the Multi-Region Access Point.
	//
	// Details is a required field
	Details *CreateMultiRegionAccessPointInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiRegionAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiRegionAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Details == nil {
		invalidParams.Add(request.NewErrParamRequired("Details"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateMultiRegionAccessPointInput) SetAccountId(v string) *CreateMultiRegionAccessPointInput {
	s.AccountId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMultiRegionAccessPointInput) SetClientToken(v string) *CreateMultiRegionAccessPointInput {
	s.ClientToken = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *CreateMultiRegionAccessPointInput) SetDetails(v *CreateMultiRegionAccessPointInput_) *CreateMultiRegionAccessPointInput {
	s.Details = v
	return s
}

func (s *CreateMultiRegionAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

// A container for the information associated with a CreateMultiRegionAccessPoint
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html)
// request.
type CreateMultiRegionAccessPointInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the Multi-Region Access Point associated with this request.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 account. You can enable the configuration options in any combination.
	// For more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	//
	// This data type is not supported for Amazon S3 on Outposts.
	PublicAccessBlock *PublicAccessBlockConfiguration `type:"structure"`

	// The buckets in different Regions that are associated with the Multi-Region
	// Access Point.
	//
	// Regions is a required field
	Regions []*Region `locationNameList:"Region" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiRegionAccessPointInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiRegionAccessPointInput_"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Regions == nil {
		invalidParams.Add(request.NewErrParamRequired("Regions"))
	}
	if s.Regions != nil {
		for i, v := range s.Regions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Regions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateMultiRegionAccessPointInput_) SetName(v string) *CreateMultiRegionAccessPointInput_ {
	s.Name = &v
	return s
}

// SetPublicAccessBlock sets the PublicAccessBlock field's value.
func (s *CreateMultiRegionAccessPointInput_) SetPublicAccessBlock(v *PublicAccessBlockConfiguration) *CreateMultiRegionAccessPointInput_ {
	s.PublicAccessBlock = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateMultiRegionAccessPointInput_) SetRegions(v []*Region) *CreateMultiRegionAccessPointInput_ {
	s.Regions = v
	return s
}

type CreateMultiRegionAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The request token associated with the request. You can use this token with
	// DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
	// to determine the status of asynchronous requests.
	RequestTokenARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiRegionAccessPointOutput) GoString() string {
	return s.String()
}

// SetRequestTokenARN sets the RequestTokenARN field's value.
func (s *CreateMultiRegionAccessPointOutput) SetRequestTokenARN(v string) *CreateMultiRegionAccessPointOutput {
	s.RequestTokenARN = &v
	return s
}

type CreateStorageLensGroupInput struct {
	_ struct{} `locationName:"CreateStorageLensGroupRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID that the Storage Lens group is created
	// from and associated with.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Storage Lens group configuration.
	//
	// StorageLensGroup is a required field
	StorageLensGroup *StorageLensGroup `type:"structure" required:"true"`

	// The Amazon Web Services resource tags that you're adding to your Storage
	// Lens group. This parameter is optional.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageLensGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageLensGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorageLensGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorageLensGroupInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.StorageLensGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageLensGroup"))
	}
	if s.StorageLensGroup != nil {
		if err := s.StorageLensGroup.Validate(); err != nil {
			invalidParams.AddNested("StorageLensGroup", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateStorageLensGroupInput) SetAccountId(v string) *CreateStorageLensGroupInput {
	s.AccountId = &v
	return s
}

// SetStorageLensGroup sets the StorageLensGroup field's value.
func (s *CreateStorageLensGroupInput) SetStorageLensGroup(v *StorageLensGroup) *CreateStorageLensGroupInput {
	s.StorageLensGroup = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStorageLensGroupInput) SetTags(v []*Tag) *CreateStorageLensGroupInput {
	s.Tags = v
	return s
}

func (s *CreateStorageLensGroupInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateStorageLensGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageLensGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageLensGroupOutput) GoString() string {
	return s.String()
}

// The Amazon Web Services Security Token Service temporary credential that
// S3 Access Grants vends to grantees and client applications.
type Credentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The unique access key ID of the Amazon Web Services STS temporary credential
	// that S3 Access Grants vends to grantees and client applications.
	//
	// AccessKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credentials's
	// String and GoString methods.
	AccessKeyId *string `type:"string" sensitive:"true"`

	// The expiration date and time of the temporary credential that S3 Access Grants
	// vends to grantees and client applications.
	Expiration *time.Time `type:"timestamp"`

	// The secret access key of the Amazon Web Services STS temporary credential
	// that S3 Access Grants vends to grantees and client applications.
	//
	// SecretAccessKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credentials's
	// String and GoString methods.
	SecretAccessKey *string `type:"string" sensitive:"true"`

	// The Amazon Web Services STS temporary credential that S3 Access Grants vends
	// to grantees and client applications.
	//
	// SessionToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Credentials's
	// String and GoString methods.
	SessionToken *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Credentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *Credentials) SetAccessKeyId(v string) *Credentials {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *Credentials) SetExpiration(v time.Time) *Credentials {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *Credentials) SetSecretAccessKey(v string) *Credentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *Credentials) SetSessionToken(v string) *Credentials {
	s.SessionToken = &v
	return s
}

type DeleteAccessGrantInput struct {
	_ struct{} `locationName:"DeleteAccessGrantRequest" type:"structure"`

	// The ID of the access grant. S3 Access Grants auto-generates this ID when
	// you create the access grant.
	//
	// AccessGrantId is a required field
	AccessGrantId *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessGrantInput"}
	if s.AccessGrantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessGrantId"))
	}
	if s.AccessGrantId != nil && len(*s.AccessGrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessGrantId", 1))
	}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *DeleteAccessGrantInput) SetAccessGrantId(v string) *DeleteAccessGrantInput {
	s.AccessGrantId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessGrantInput) SetAccountId(v string) *DeleteAccessGrantInput {
	s.AccountId = &v
	return s
}

func (s *DeleteAccessGrantInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantOutput) GoString() string {
	return s.String()
}

type DeleteAccessGrantsInstanceInput struct {
	_ struct{} `locationName:"DeleteAccessGrantsInstanceRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessGrantsInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessGrantsInstanceInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessGrantsInstanceInput) SetAccountId(v string) *DeleteAccessGrantsInstanceInput {
	s.AccountId = &v
	return s
}

func (s *DeleteAccessGrantsInstanceInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessGrantsInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceOutput) GoString() string {
	return s.String()
}

type DeleteAccessGrantsInstanceResourcePolicyInput struct {
	_ struct{} `locationName:"DeleteAccessGrantsInstanceResourcePolicyRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessGrantsInstanceResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessGrantsInstanceResourcePolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessGrantsInstanceResourcePolicyInput) SetAccountId(v string) *DeleteAccessGrantsInstanceResourcePolicyInput {
	s.AccountId = &v
	return s
}

func (s *DeleteAccessGrantsInstanceResourcePolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessGrantsInstanceResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsInstanceResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteAccessGrantsLocationInput struct {
	_ struct{} `locationName:"DeleteAccessGrantsLocationRequest" type:"structure"`

	// The ID of the registered location that you are deregistering from your S3
	// Access Grants instance. S3 Access Grants assigned this ID when you registered
	// the location. S3 Access Grants assigns the ID default to the default location
	// s3:// and assigns an auto-generated ID to other locations that you register.
	//
	// AccessGrantsLocationId is a required field
	AccessGrantsLocationId *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessGrantsLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessGrantsLocationInput"}
	if s.AccessGrantsLocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessGrantsLocationId"))
	}
	if s.AccessGrantsLocationId != nil && len(*s.AccessGrantsLocationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessGrantsLocationId", 1))
	}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *DeleteAccessGrantsLocationInput) SetAccessGrantsLocationId(v string) *DeleteAccessGrantsLocationInput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessGrantsLocationInput) SetAccountId(v string) *DeleteAccessGrantsLocationInput {
	s.AccountId = &v
	return s
}

func (s *DeleteAccessGrantsLocationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessGrantsLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessGrantsLocationOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointForObjectLambdaInput struct {
	_ struct{} `locationName:"DeleteAccessPointForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointForObjectLambdaInput) SetAccountId(v string) *DeleteAccessPointForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointForObjectLambdaInput) SetName(v string) *DeleteAccessPointForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessPointForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointForObjectLambdaOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointInput struct {
	_ struct{} `locationName:"DeleteAccessPointRequest" type:"structure"`

	// The Amazon Web Services account ID for the account that owns the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point you want to delete.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the access point accessed in the
	// format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through Outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointInput) SetAccountId(v string) *DeleteAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointInput) SetName(v string) *DeleteAccessPointInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *DeleteAccessPointInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointPolicyForObjectLambdaInput struct {
	_ struct{} `locationName:"DeleteAccessPointPolicyForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point you want to delete the policy
	// for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointPolicyForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointPolicyForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointPolicyForObjectLambdaInput) SetAccountId(v string) *DeleteAccessPointPolicyForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointPolicyForObjectLambdaInput) SetName(v string) *DeleteAccessPointPolicyForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointPolicyForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessPointPolicyForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyForObjectLambdaOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointPolicyInput struct {
	_ struct{} `locationName:"DeleteAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to delete.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the access point accessed in the
	// format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through Outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointPolicyInput) SetAccountId(v string) *DeleteAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointPolicyInput) SetName(v string) *DeleteAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *DeleteAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `locationName:"DeleteBucketRequest" type:"structure"`

	// The account ID that owns the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket being deleted.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketInput) SetAccountId(v string) *DeleteBucketInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"DeleteBucketLifecycleConfigurationRequest" type:"structure"`

	// The account ID of the lifecycle configuration to delete.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketLifecycleConfigurationInput) SetAccountId(v string) *DeleteBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleConfigurationInput) SetBucket(v string) *DeleteBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyInput struct {
	_ struct{} `locationName:"DeleteBucketPolicyRequest" type:"structure"`

	// The account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketPolicyInput) SetAccountId(v string) *DeleteBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketPolicyInput) SetBucket(v string) *DeleteBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketReplicationInput struct {
	_ struct{} `locationName:"DeleteBucketReplicationRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket to delete the replication
	// configuration for.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the S3 on Outposts bucket to delete the replication configuration
	// for.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketReplicationInput) SetAccountId(v string) *DeleteBucketReplicationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketReplicationInput) SetBucket(v string) *DeleteBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketReplicationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketReplicationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketReplicationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketReplicationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketReplicationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingInput struct {
	_ struct{} `locationName:"DeleteBucketTaggingRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket tag set to be removed.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The bucket ARN that has the tag set to be removed.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteBucketTaggingInput) SetAccountId(v string) *DeleteBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketTaggingInput) SetBucket(v string) *DeleteBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *DeleteBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *DeleteBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s DeleteBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s DeleteBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

type DeleteJobTaggingInput struct {
	_ struct{} `locationName:"DeleteJobTaggingRequest" type:"structure"`

	// The Amazon Web Services account ID associated with the S3 Batch Operations
	// job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to delete.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteJobTaggingInput) SetAccountId(v string) *DeleteJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobTaggingInput) SetJobId(v string) *DeleteJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *DeleteJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobTaggingOutput) GoString() string {
	return s.String()
}

// Specifies whether S3 on Outposts replicates delete markers. If you specify
// a Filter element in your replication configuration, you must also include
// a DeleteMarkerReplication element. If your Filter includes a Tag element,
// the DeleteMarkerReplication element's Status child element must be set to
// Disabled, because S3 on Outposts does not support replicating delete markers
// for tag-based rules.
//
// For more information about delete marker replication, see How delete operations
// affect replication (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OutpostsReplication.html#outposts-replication-what-is-replicated)
// in the Amazon S3 User Guide.
type DeleteMarkerReplication struct {
	_ struct{} `type:"structure"`

	// Indicates whether to replicate delete markers.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"DeleteMarkerReplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerReplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMarkerReplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMarkerReplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMarkerReplication"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *DeleteMarkerReplication) SetStatus(v string) *DeleteMarkerReplication {
	s.Status = &v
	return s
}

type DeleteMultiRegionAccessPointInput struct {
	_ struct{} `locationName:"DeleteMultiRegionAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// An idempotency token used to identify the request and guarantee that requests
	// are unique.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// A container element containing details about the Multi-Region Access Point.
	//
	// Details is a required field
	Details *DeleteMultiRegionAccessPointInput_ `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiRegionAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiRegionAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Details == nil {
		invalidParams.Add(request.NewErrParamRequired("Details"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteMultiRegionAccessPointInput) SetAccountId(v string) *DeleteMultiRegionAccessPointInput {
	s.AccountId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteMultiRegionAccessPointInput) SetClientToken(v string) *DeleteMultiRegionAccessPointInput {
	s.ClientToken = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *DeleteMultiRegionAccessPointInput) SetDetails(v *DeleteMultiRegionAccessPointInput_) *DeleteMultiRegionAccessPointInput {
	s.Details = v
	return s
}

func (s *DeleteMultiRegionAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

// A container for the information associated with a DeleteMultiRegionAccessPoint
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html)
// request.
type DeleteMultiRegionAccessPointInput_ struct {
	_ struct{} `type:"structure"`

	// The name of the Multi-Region Access Point associated with this request.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiRegionAccessPointInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiRegionAccessPointInput_"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteMultiRegionAccessPointInput_) SetName(v string) *DeleteMultiRegionAccessPointInput_ {
	s.Name = &v
	return s
}

type DeleteMultiRegionAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The request token associated with the request. You can use this token with
	// DescribeMultiRegionAccessPointOperation (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html)
	// to determine the status of asynchronous requests.
	RequestTokenARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiRegionAccessPointOutput) GoString() string {
	return s.String()
}

// SetRequestTokenARN sets the RequestTokenARN field's value.
func (s *DeleteMultiRegionAccessPointOutput) SetRequestTokenARN(v string) *DeleteMultiRegionAccessPointOutput {
	s.RequestTokenARN = &v
	return s
}

type DeletePublicAccessBlockInput struct {
	_ struct{} `locationName:"DeletePublicAccessBlockRequest" type:"structure"`

	// The account ID for the Amazon Web Services account whose PublicAccessBlock
	// configuration you want to remove.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeletePublicAccessBlockInput) SetAccountId(v string) *DeletePublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *DeletePublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeletePublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePublicAccessBlockOutput) GoString() string {
	return s.String()
}

type DeleteStorageLensConfigurationInput struct {
	_ struct{} `locationName:"DeleteStorageLensConfigurationRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageLensConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageLensConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteStorageLensConfigurationInput) SetAccountId(v string) *DeleteStorageLensConfigurationInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteStorageLensConfigurationInput) SetConfigId(v string) *DeleteStorageLensConfigurationInput {
	s.ConfigId = &v
	return s
}

func (s *DeleteStorageLensConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteStorageLensConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteStorageLensConfigurationTaggingInput struct {
	_ struct{} `locationName:"DeleteStorageLensConfigurationTaggingRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageLensConfigurationTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageLensConfigurationTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteStorageLensConfigurationTaggingInput) SetAccountId(v string) *DeleteStorageLensConfigurationTaggingInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteStorageLensConfigurationTaggingInput) SetConfigId(v string) *DeleteStorageLensConfigurationTaggingInput {
	s.ConfigId = &v
	return s
}

func (s *DeleteStorageLensConfigurationTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteStorageLensConfigurationTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensConfigurationTaggingOutput) GoString() string {
	return s.String()
}

type DeleteStorageLensGroupInput struct {
	_ struct{} `locationName:"DeleteStorageLensGroupRequest" type:"structure"`

	// The Amazon Web Services account ID used to create the Storage Lens group
	// that you're trying to delete.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Storage Lens group that you're trying to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageLensGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageLensGroupInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteStorageLensGroupInput) SetAccountId(v string) *DeleteStorageLensGroupInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteStorageLensGroupInput) SetName(v string) *DeleteStorageLensGroupInput {
	s.Name = &v
	return s
}

func (s *DeleteStorageLensGroupInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteStorageLensGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageLensGroupOutput) GoString() string {
	return s.String()
}

type DescribeJobInput struct {
	_ struct{} `locationName:"DescribeJobRequest" type:"structure"`

	// The Amazon Web Services account ID associated with the S3 Batch Operations
	// job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose information you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeJobInput) SetAccountId(v string) *DescribeJobInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

func (s *DescribeJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration parameters and status for the job specified in
	// the Describe Job request.
	Job *JobDescriptor `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *DescribeJobOutput) SetJob(v *JobDescriptor) *DescribeJobOutput {
	s.Job = v
	return s
}

type DescribeMultiRegionAccessPointOperationInput struct {
	_ struct{} `locationName:"DescribeMultiRegionAccessPointOperationRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The request token associated with the request you want to know about. This
	// request token is returned as part of the response when you make an asynchronous
	// request. You provide this token to query about the status of the asynchronous
	// action.
	//
	// RequestTokenARN is a required field
	RequestTokenARN *string `location:"uri" locationName:"request_token" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiRegionAccessPointOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiRegionAccessPointOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiRegionAccessPointOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMultiRegionAccessPointOperationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.RequestTokenARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestTokenARN"))
	}
	if s.RequestTokenARN != nil && len(*s.RequestTokenARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestTokenARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeMultiRegionAccessPointOperationInput) SetAccountId(v string) *DescribeMultiRegionAccessPointOperationInput {
	s.AccountId = &v
	return s
}

// SetRequestTokenARN sets the RequestTokenARN field's value.
func (s *DescribeMultiRegionAccessPointOperationInput) SetRequestTokenARN(v string) *DescribeMultiRegionAccessPointOperationInput {
	s.RequestTokenARN = &v
	return s
}

func (s *DescribeMultiRegionAccessPointOperationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DescribeMultiRegionAccessPointOperationOutput struct {
	_ struct{} `type:"structure"`

	// A container element containing the details of the asynchronous operation.
	AsyncOperation *AsyncOperation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiRegionAccessPointOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiRegionAccessPointOperationOutput) GoString() string {
	return s.String()
}

// SetAsyncOperation sets the AsyncOperation field's value.
func (s *DescribeMultiRegionAccessPointOperationOutput) SetAsyncOperation(v *AsyncOperation) *DescribeMultiRegionAccessPointOperationOutput {
	s.AsyncOperation = v
	return s
}

// Specifies information about the replication destination bucket and its settings
// for an S3 on Outposts replication configuration.
type Destination struct {
	_ struct{} `type:"structure"`

	// Specify this property only in a cross-account scenario (where the source
	// and destination bucket owners are not the same), and you want to change replica
	// ownership to the Amazon Web Services account that owns the destination bucket.
	// If this property is not specified in the replication configuration, the replicas
	// are owned by same Amazon Web Services account that owns the source object.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// The destination bucket owner's account ID.
	Account *string `type:"string"`

	// The Amazon Resource Name (ARN) of the access point for the destination bucket
	// where you want S3 on Outposts to store the replication results.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A container that provides information about encryption. If SourceSelectionCriteria
	// is specified, you must specify this element.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A container that specifies replication metrics-related settings.
	Metrics *Metrics `type:"structure"`

	// A container that specifies S3 Replication Time Control (S3 RTC) settings,
	// including whether S3 RTC is enabled and the time when all objects and operations
	// on objects must be replicated. Must be specified together with a Metrics
	// block.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ReplicationTime *ReplicationTime `type:"structure"`

	// The storage class to use when replicating objects. All objects stored on
	// S3 on Outposts are stored in the OUTPOSTS storage class. S3 on Outposts uses
	// the OUTPOSTS storage class to create the object replicas.
	//
	// Values other than OUTPOSTS aren't supported by Amazon S3 on Outposts.
	StorageClass *string `type:"string" enum:"ReplicationStorageClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(request.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		if err := s.Metrics.Validate(); err != nil {
			invalidParams.AddNested("Metrics", err.(request.ErrInvalidParams))
		}
	}
	if s.ReplicationTime != nil {
		if err := s.ReplicationTime.Validate(); err != nil {
			invalidParams.AddNested("ReplicationTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlTranslation sets the AccessControlTranslation field's value.
func (s *Destination) SetAccessControlTranslation(v *AccessControlTranslation) *Destination {
	s.AccessControlTranslation = v
	return s
}

// SetAccount sets the Account field's value.
func (s *Destination) SetAccount(v string) *Destination {
	s.Account = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *Destination) SetBucket(v string) *Destination {
	s.Bucket = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *Destination) SetEncryptionConfiguration(v *EncryptionConfiguration) *Destination {
	s.EncryptionConfiguration = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *Destination) SetMetrics(v *Metrics) *Destination {
	s.Metrics = v
	return s
}

// SetReplicationTime sets the ReplicationTime field's value.
func (s *Destination) SetReplicationTime(v *ReplicationTime) *Destination {
	s.ReplicationTime = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Destination) SetStorageClass(v string) *Destination {
	s.StorageClass = &v
	return s
}

// The container element for Amazon S3 Storage Lens detailed status code metrics.
// Detailed status code metrics generate metrics for HTTP status codes, such
// as 200 OK, 403 Forbidden, 503 Service Unavailable and others.
//
// For more information about S3 Storage Lens, see Assessing your storage activity
// and usage with S3 Storage Lens (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html)
// in the Amazon S3 User Guide. For a complete list of S3 Storage Lens metrics,
// see S3 Storage Lens metrics glossary (https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html)
// in the Amazon S3 User Guide.
type DetailedStatusCodesMetrics struct {
	_ struct{} `type:"structure"`

	// A container that indicates whether detailed status code metrics are enabled.
	IsEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedStatusCodesMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedStatusCodesMetrics) GoString() string {
	return s.String()
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *DetailedStatusCodesMetrics) SetIsEnabled(v bool) *DetailedStatusCodesMetrics {
	s.IsEnabled = &v
	return s
}

type DissociateAccessGrantsIdentityCenterInput struct {
	_ struct{} `locationName:"DissociateAccessGrantsIdentityCenterRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociateAccessGrantsIdentityCenterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociateAccessGrantsIdentityCenterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociateAccessGrantsIdentityCenterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DissociateAccessGrantsIdentityCenterInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DissociateAccessGrantsIdentityCenterInput) SetAccountId(v string) *DissociateAccessGrantsIdentityCenterInput {
	s.AccountId = &v
	return s
}

func (s *DissociateAccessGrantsIdentityCenterInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DissociateAccessGrantsIdentityCenterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociateAccessGrantsIdentityCenterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DissociateAccessGrantsIdentityCenterOutput) GoString() string {
	return s.String()
}

// Specifies encryption-related information for an Amazon S3 bucket that is
// a destination for replicated objects.
//
// This is not supported by Amazon S3 on Outposts buckets.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the ID of the customer managed KMS key that's stored in Key Management
	// Service (KMS) for the destination bucket. This ID is either the Amazon Resource
	// Name (ARN) for the KMS key or the alias ARN for the KMS key. Amazon S3 uses
	// this KMS key to encrypt replica objects. Amazon S3 supports only symmetric
	// encryption KMS keys. For more information, see Symmetric encryption KMS keys
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks)
	// in the Amazon Web Services Key Management Service Developer Guide.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// SetReplicaKmsKeyID sets the ReplicaKmsKeyID field's value.
func (s *EncryptionConfiguration) SetReplicaKmsKeyID(v string) *EncryptionConfiguration {
	s.ReplicaKmsKeyID = &v
	return s
}

// The last established access control policy for a Multi-Region Access Point.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type EstablishedMultiRegionAccessPointPolicy struct {
	_ struct{} `type:"structure"`

	// The details of the last established policy.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstablishedMultiRegionAccessPointPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EstablishedMultiRegionAccessPointPolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *EstablishedMultiRegionAccessPointPolicy) SetPolicy(v string) *EstablishedMultiRegionAccessPointPolicy {
	s.Policy = &v
	return s
}

// A container for what Amazon S3 Storage Lens will exclude.
type Exclude struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens bucket excludes.
	Buckets []*string `locationNameList:"Arn" type:"list"`

	// A container for the S3 Storage Lens Region excludes.
	Regions []*string `locationNameList:"Region" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Exclude) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Exclude) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *Exclude) SetBuckets(v []*string) *Exclude {
	s.Buckets = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Exclude) SetRegions(v []*string) *Exclude {
	s.Regions = v
	return s
}

// An optional configuration to replicate existing source bucket objects.
//
// This is not supported by Amazon S3 on Outposts buckets.
type ExistingObjectReplication struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 replicates existing source bucket objects.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExistingObjectReplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExistingObjectReplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExistingObjectReplication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExistingObjectReplication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExistingObjectReplication"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *ExistingObjectReplication) SetStatus(v string) *ExistingObjectReplication {
	s.Status = &v
	return s
}

// The encryption configuration to use when storing the generated manifest.
type GeneratedManifestEncryption struct {
	_ struct{} `type:"structure"`

	// Configuration details on how SSE-KMS is used to encrypt generated manifest
	// objects.
	SSEKMS *SSEKMSEncryption `locationName:"SSE-KMS" type:"structure"`

	// Specifies the use of SSE-S3 to encrypt generated manifest objects.
	SSES3 *SSES3Encryption `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedManifestEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratedManifestEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeneratedManifestEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeneratedManifestEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSEKMS sets the SSEKMS field's value.
func (s *GeneratedManifestEncryption) SetSSEKMS(v *SSEKMSEncryption) *GeneratedManifestEncryption {
	s.SSEKMS = v
	return s
}

// SetSSES3 sets the SSES3 field's value.
func (s *GeneratedManifestEncryption) SetSSES3(v *SSES3Encryption) *GeneratedManifestEncryption {
	s.SSES3 = v
	return s
}

type GetAccessGrantInput struct {
	_ struct{} `locationName:"GetAccessGrantRequest" type:"structure"`

	// The ID of the access grant. S3 Access Grants auto-generates this ID when
	// you create the access grant.
	//
	// AccessGrantId is a required field
	AccessGrantId *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessGrantInput"}
	if s.AccessGrantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessGrantId"))
	}
	if s.AccessGrantId != nil && len(*s.AccessGrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessGrantId", 1))
	}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *GetAccessGrantInput) SetAccessGrantId(v string) *GetAccessGrantInput {
	s.AccessGrantId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessGrantInput) SetAccountId(v string) *GetAccessGrantInput {
	s.AccountId = &v
	return s
}

func (s *GetAccessGrantInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessGrantOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access grant.
	AccessGrantArn *string `min:"1" type:"string"`

	// The ID of the access grant. S3 Access Grants auto-generates this ID when
	// you create the access grant.
	AccessGrantId *string `min:"1" type:"string"`

	// The configuration options of the grant location. The grant location is the
	// S3 path to the data to which you are granting access.
	AccessGrantsLocationConfiguration *AccessGrantsLocationConfiguration `type:"structure"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string `min:"10" type:"string"`

	// The date and time when you created the access grant.
	CreatedAt *time.Time `type:"timestamp"`

	// The S3 path of the data to which you are granting access. It is the result
	// of appending the Subprefix to the location scope.
	GrantScope *string `min:"1" type:"string"`

	// The user, group, or role to which you are granting access. You can grant
	// access to an IAM user or role. If you have added a corporate directory to
	// Amazon Web Services IAM Identity Center and associated this Identity Center
	// instance with the S3 Access Grants instance, the grantee can also be a corporate
	// directory user or group.
	Grantee *Grantee `type:"structure"`

	// The type of permission that was granted in the access grant. Can be one of
	// the following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantOutput) GoString() string {
	return s.String()
}

// SetAccessGrantArn sets the AccessGrantArn field's value.
func (s *GetAccessGrantOutput) SetAccessGrantArn(v string) *GetAccessGrantOutput {
	s.AccessGrantArn = &v
	return s
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *GetAccessGrantOutput) SetAccessGrantId(v string) *GetAccessGrantOutput {
	s.AccessGrantId = &v
	return s
}

// SetAccessGrantsLocationConfiguration sets the AccessGrantsLocationConfiguration field's value.
func (s *GetAccessGrantOutput) SetAccessGrantsLocationConfiguration(v *AccessGrantsLocationConfiguration) *GetAccessGrantOutput {
	s.AccessGrantsLocationConfiguration = v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *GetAccessGrantOutput) SetAccessGrantsLocationId(v string) *GetAccessGrantOutput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetAccessGrantOutput) SetApplicationArn(v string) *GetAccessGrantOutput {
	s.ApplicationArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAccessGrantOutput) SetCreatedAt(v time.Time) *GetAccessGrantOutput {
	s.CreatedAt = &v
	return s
}

// SetGrantScope sets the GrantScope field's value.
func (s *GetAccessGrantOutput) SetGrantScope(v string) *GetAccessGrantOutput {
	s.GrantScope = &v
	return s
}

// SetGrantee sets the Grantee field's value.
func (s *GetAccessGrantOutput) SetGrantee(v *Grantee) *GetAccessGrantOutput {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *GetAccessGrantOutput) SetPermission(v string) *GetAccessGrantOutput {
	s.Permission = &v
	return s
}

type GetAccessGrantsInstanceForPrefixInput struct {
	_ struct{} `locationName:"GetAccessGrantsInstanceForPrefixRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The S3 prefix of the access grants that you would like to retrieve.
	//
	// S3Prefix is a required field
	S3Prefix *string `location:"querystring" locationName:"s3prefix" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceForPrefixInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceForPrefixInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessGrantsInstanceForPrefixInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessGrantsInstanceForPrefixInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.S3Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Prefix"))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessGrantsInstanceForPrefixInput) SetAccountId(v string) *GetAccessGrantsInstanceForPrefixInput {
	s.AccountId = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *GetAccessGrantsInstanceForPrefixInput) SetS3Prefix(v string) *GetAccessGrantsInstanceForPrefixInput {
	s.S3Prefix = &v
	return s
}

func (s *GetAccessGrantsInstanceForPrefixInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessGrantsInstanceForPrefixOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 Access Grants instance.
	AccessGrantsInstanceArn *string `min:"1" type:"string"`

	// The ID of the S3 Access Grants instance. The ID is default. You can have
	// one S3 Access Grants instance per Region per account.
	AccessGrantsInstanceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceForPrefixOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceForPrefixOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsInstanceArn sets the AccessGrantsInstanceArn field's value.
func (s *GetAccessGrantsInstanceForPrefixOutput) SetAccessGrantsInstanceArn(v string) *GetAccessGrantsInstanceForPrefixOutput {
	s.AccessGrantsInstanceArn = &v
	return s
}

// SetAccessGrantsInstanceId sets the AccessGrantsInstanceId field's value.
func (s *GetAccessGrantsInstanceForPrefixOutput) SetAccessGrantsInstanceId(v string) *GetAccessGrantsInstanceForPrefixOutput {
	s.AccessGrantsInstanceId = &v
	return s
}

type GetAccessGrantsInstanceInput struct {
	_ struct{} `locationName:"GetAccessGrantsInstanceRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessGrantsInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessGrantsInstanceInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessGrantsInstanceInput) SetAccountId(v string) *GetAccessGrantsInstanceInput {
	s.AccountId = &v
	return s
}

func (s *GetAccessGrantsInstanceInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessGrantsInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 Access Grants instance.
	AccessGrantsInstanceArn *string `min:"1" type:"string"`

	// The ID of the S3 Access Grants instance. The ID is default. You can have
	// one S3 Access Grants instance per Region per account.
	AccessGrantsInstanceId *string `min:"1" type:"string"`

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time `type:"timestamp"`

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name
	// (ARN) of the Amazon Web Services IAM Identity Center instance application;
	// a subresource of the original Identity Center instance. S3 Access Grants
	// creates this Identity Center application for the specific S3 Access Grants
	// instance.
	IdentityCenterArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsInstanceArn sets the AccessGrantsInstanceArn field's value.
func (s *GetAccessGrantsInstanceOutput) SetAccessGrantsInstanceArn(v string) *GetAccessGrantsInstanceOutput {
	s.AccessGrantsInstanceArn = &v
	return s
}

// SetAccessGrantsInstanceId sets the AccessGrantsInstanceId field's value.
func (s *GetAccessGrantsInstanceOutput) SetAccessGrantsInstanceId(v string) *GetAccessGrantsInstanceOutput {
	s.AccessGrantsInstanceId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAccessGrantsInstanceOutput) SetCreatedAt(v time.Time) *GetAccessGrantsInstanceOutput {
	s.CreatedAt = &v
	return s
}

// SetIdentityCenterArn sets the IdentityCenterArn field's value.
func (s *GetAccessGrantsInstanceOutput) SetIdentityCenterArn(v string) *GetAccessGrantsInstanceOutput {
	s.IdentityCenterArn = &v
	return s
}

type GetAccessGrantsInstanceResourcePolicyInput struct {
	_ struct{} `locationName:"GetAccessGrantsInstanceResourcePolicyRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessGrantsInstanceResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessGrantsInstanceResourcePolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessGrantsInstanceResourcePolicyInput) SetAccountId(v string) *GetAccessGrantsInstanceResourcePolicyInput {
	s.AccountId = &v
	return s
}

func (s *GetAccessGrantsInstanceResourcePolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessGrantsInstanceResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when you created the S3 Access Grants instance resource
	// policy.
	CreatedAt *time.Time `type:"timestamp"`

	// The Organization of the resource policy of the S3 Access Grants instance.
	Organization *string `min:"12" type:"string"`

	// The resource policy of the S3 Access Grants instance.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsInstanceResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAccessGrantsInstanceResourcePolicyOutput) SetCreatedAt(v time.Time) *GetAccessGrantsInstanceResourcePolicyOutput {
	s.CreatedAt = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *GetAccessGrantsInstanceResourcePolicyOutput) SetOrganization(v string) *GetAccessGrantsInstanceResourcePolicyOutput {
	s.Organization = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetAccessGrantsInstanceResourcePolicyOutput) SetPolicy(v string) *GetAccessGrantsInstanceResourcePolicyOutput {
	s.Policy = &v
	return s
}

type GetAccessGrantsLocationInput struct {
	_ struct{} `locationName:"GetAccessGrantsLocationRequest" type:"structure"`

	// The ID of the registered location that you are retrieving. S3 Access Grants
	// assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	//
	// AccessGrantsLocationId is a required field
	AccessGrantsLocationId *string `location:"uri" locationName:"id" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessGrantsLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessGrantsLocationInput"}
	if s.AccessGrantsLocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessGrantsLocationId"))
	}
	if s.AccessGrantsLocationId != nil && len(*s.AccessGrantsLocationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessGrantsLocationId", 1))
	}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *GetAccessGrantsLocationInput) SetAccessGrantsLocationId(v string) *GetAccessGrantsLocationInput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessGrantsLocationInput) SetAccountId(v string) *GetAccessGrantsLocationInput {
	s.AccountId = &v
	return s
}

func (s *GetAccessGrantsLocationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessGrantsLocationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the registered location.
	AccessGrantsLocationArn *string `min:"1" type:"string"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The date and time when you registered the location.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role for the registered location.
	// S3 Access Grants assumes this role to manage access to the registered location.
	IAMRoleArn *string `min:"1" type:"string"`

	// The S3 URI path to the registered location. The location scope can be the
	// default S3 location s3://, the S3 path to a bucket, or the S3 path to a bucket
	// and prefix. A prefix in S3 is a string of characters at the beginning of
	// an object key name used to organize the objects that you store in your S3
	// buckets. For example, object key names that start with the engineering/ prefix
	// or object key names that start with the marketing/campaigns/ prefix.
	LocationScope *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessGrantsLocationOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsLocationArn sets the AccessGrantsLocationArn field's value.
func (s *GetAccessGrantsLocationOutput) SetAccessGrantsLocationArn(v string) *GetAccessGrantsLocationOutput {
	s.AccessGrantsLocationArn = &v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *GetAccessGrantsLocationOutput) SetAccessGrantsLocationId(v string) *GetAccessGrantsLocationOutput {
	s.AccessGrantsLocationId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAccessGrantsLocationOutput) SetCreatedAt(v time.Time) *GetAccessGrantsLocationOutput {
	s.CreatedAt = &v
	return s
}

// SetIAMRoleArn sets the IAMRoleArn field's value.
func (s *GetAccessGrantsLocationOutput) SetIAMRoleArn(v string) *GetAccessGrantsLocationOutput {
	s.IAMRoleArn = &v
	return s
}

// SetLocationScope sets the LocationScope field's value.
func (s *GetAccessGrantsLocationOutput) SetLocationScope(v string) *GetAccessGrantsLocationOutput {
	s.LocationScope = &v
	return s
}

type GetAccessPointConfigurationForObjectLambdaInput struct {
	_ struct{} `locationName:"GetAccessPointConfigurationForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point you want to return the configuration
	// for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointConfigurationForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointConfigurationForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointConfigurationForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointConfigurationForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointConfigurationForObjectLambdaInput) SetAccountId(v string) *GetAccessPointConfigurationForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointConfigurationForObjectLambdaInput) SetName(v string) *GetAccessPointConfigurationForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointConfigurationForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointConfigurationForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// Object Lambda Access Point configuration document.
	Configuration *ObjectLambdaConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointConfigurationForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointConfigurationForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *GetAccessPointConfigurationForObjectLambdaOutput) SetConfiguration(v *ObjectLambdaConfiguration) *GetAccessPointConfigurationForObjectLambdaOutput {
	s.Configuration = v
	return s
}

type GetAccessPointForObjectLambdaInput struct {
	_ struct{} `locationName:"GetAccessPointForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointForObjectLambdaInput) SetAccountId(v string) *GetAccessPointForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointForObjectLambdaInput) SetName(v string) *GetAccessPointForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// The alias of the Object Lambda Access Point.
	Alias *ObjectLambdaAccessPointAlias `type:"structure"`

	// The date and time when the specified Object Lambda Access Point was created.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the Object Lambda Access Point.
	Name *string `min:"3" type:"string"`

	// Configuration to block all public access. This setting is turned on and can
	// not be edited.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *GetAccessPointForObjectLambdaOutput) SetAlias(v *ObjectLambdaAccessPointAlias) *GetAccessPointForObjectLambdaOutput {
	s.Alias = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetAccessPointForObjectLambdaOutput) SetCreationDate(v time.Time) *GetAccessPointForObjectLambdaOutput {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointForObjectLambdaOutput) SetName(v string) *GetAccessPointForObjectLambdaOutput {
	s.Name = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetAccessPointForObjectLambdaOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetAccessPointForObjectLambdaOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

type GetAccessPointInput struct {
	_ struct{} `locationName:"GetAccessPointRequest" type:"structure"`

	// The Amazon Web Services account ID for the account that owns the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose configuration information you want to
	// retrieve.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the access point accessed in the
	// format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through Outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointInput) SetAccountId(v string) *GetAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointInput) SetName(v string) *GetAccessPointInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetAccessPointInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *GetAccessPointInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetAccessPointInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetAccessPointInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the access point.
	AccessPointArn *string `min:"4" type:"string"`

	// The name or alias of the access point.
	Alias *string `type:"string"`

	// The name of the bucket associated with the specified access point.
	Bucket *string `min:"3" type:"string"`

	// The Amazon Web Services account ID associated with the S3 bucket associated
	// with this access point.
	BucketAccountId *string `type:"string"`

	// The date and time when the specified access point was created.
	CreationDate *time.Time `type:"timestamp"`

	// The VPC endpoint for the access point.
	Endpoints map[string]*string `type:"map"`

	// The name of the specified access point.
	Name *string `min:"3" type:"string"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// This will always be true for an Amazon S3 on Outposts access point
	NetworkOrigin *string `type:"string" enum:"NetworkOrigin"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 account. You can enable the configuration options in any combination.
	// For more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	//
	// This data type is not supported for Amazon S3 on Outposts.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// Contains the virtual private cloud (VPC) configuration for the specified
	// access point.
	//
	// This element is empty if this access point is an Amazon S3 on Outposts access
	// point that is used by other Amazon Web Services.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *GetAccessPointOutput) SetAccessPointArn(v string) *GetAccessPointOutput {
	s.AccessPointArn = &v
	return s
}

// SetAlias sets the Alias field's value.
func (s *GetAccessPointOutput) SetAlias(v string) *GetAccessPointOutput {
	s.Alias = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetAccessPointOutput) SetBucket(v string) *GetAccessPointOutput {
	s.Bucket = &v
	return s
}

// SetBucketAccountId sets the BucketAccountId field's value.
func (s *GetAccessPointOutput) SetBucketAccountId(v string) *GetAccessPointOutput {
	s.BucketAccountId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetAccessPointOutput) SetCreationDate(v time.Time) *GetAccessPointOutput {
	s.CreationDate = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *GetAccessPointOutput) SetEndpoints(v map[string]*string) *GetAccessPointOutput {
	s.Endpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointOutput) SetName(v string) *GetAccessPointOutput {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *GetAccessPointOutput) SetNetworkOrigin(v string) *GetAccessPointOutput {
	s.NetworkOrigin = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetAccessPointOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetAccessPointOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetAccessPointOutput) SetVpcConfiguration(v *VpcConfiguration) *GetAccessPointOutput {
	s.VpcConfiguration = v
	return s
}

type GetAccessPointPolicyForObjectLambdaInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyForObjectLambdaInput) SetAccountId(v string) *GetAccessPointPolicyForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyForObjectLambdaInput) SetName(v string) *GetAccessPointPolicyForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// Object Lambda Access Point resource policy document.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetAccessPointPolicyForObjectLambdaOutput) SetPolicy(v string) *GetAccessPointPolicyForObjectLambdaOutput {
	s.Policy = &v
	return s
}

type GetAccessPointPolicyInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to retrieve.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the access point accessed in the
	// format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through Outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyInput) SetAccountId(v string) *GetAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyInput) SetName(v string) *GetAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *GetAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The access point policy associated with the specified access point.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetAccessPointPolicyOutput) SetPolicy(v string) *GetAccessPointPolicyOutput {
	s.Policy = &v
	return s
}

type GetAccessPointPolicyStatusForObjectLambdaInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyStatusForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyStatusForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyStatusForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyStatusForObjectLambdaInput) SetAccountId(v string) *GetAccessPointPolicyStatusForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyStatusForObjectLambdaInput) SetName(v string) *GetAccessPointPolicyStatusForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyStatusForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyStatusForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether this access point policy is public. For more information
	// about how Amazon S3 evaluates policies to determine whether they are public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *GetAccessPointPolicyStatusForObjectLambdaOutput) SetPolicyStatus(v *PolicyStatus) *GetAccessPointPolicyStatusForObjectLambdaOutput {
	s.PolicyStatus = v
	return s
}

type GetAccessPointPolicyStatusInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyStatusRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy status you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyStatusInput) SetAccountId(v string) *GetAccessPointPolicyStatusInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyStatusInput) SetName(v string) *GetAccessPointPolicyStatusInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyStatusOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the current policy status of the specified access point.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPointPolicyStatusOutput) GoString() string {
	return s.String()
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *GetAccessPointPolicyStatusOutput) SetPolicyStatus(v *PolicyStatus) *GetAccessPointPolicyStatusOutput {
	s.PolicyStatus = v
	return s
}

type GetBucketInput struct {
	_ struct{} `locationName:"GetBucketRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketInput) SetAccountId(v string) *GetBucketInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketInput) SetBucket(v string) *GetBucketInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"GetBucketLifecycleConfigurationRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketLifecycleConfigurationInput) SetAccountId(v string) *GetBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Container for the lifecycle rule of the Outposts bucket.
	Rules []*LifecycleRule `locationNameList:"Rule" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

type GetBucketOutput struct {
	_ struct{} `type:"structure"`

	// The Outposts bucket requested.
	Bucket *string `min:"3" type:"string"`

	// The creation date of the Outposts bucket.
	CreationDate *time.Time `type:"timestamp"`

	PublicAccessBlockEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketOutput) SetBucket(v string) *GetBucketOutput {
	s.Bucket = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetBucketOutput) SetCreationDate(v time.Time) *GetBucketOutput {
	s.CreationDate = &v
	return s
}

// SetPublicAccessBlockEnabled sets the PublicAccessBlockEnabled field's value.
func (s *GetBucketOutput) SetPublicAccessBlockEnabled(v bool) *GetBucketOutput {
	s.PublicAccessBlockEnabled = &v
	return s
}

type GetBucketPolicyInput struct {
	_ struct{} `locationName:"GetBucketPolicyRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketPolicyInput) SetAccountId(v string) *GetBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyInput) SetBucket(v string) *GetBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy of the Outposts bucket.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetBucketPolicyOutput) SetPolicy(v string) *GetBucketPolicyOutput {
	s.Policy = &v
	return s
}

type GetBucketReplicationInput struct {
	_ struct{} `locationName:"GetBucketReplicationRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket to get the replication information for.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketReplicationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketReplicationInput) SetAccountId(v string) *GetBucketReplicationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketReplicationInput) SetBucket(v string) *GetBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketReplicationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketReplicationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketReplicationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketReplicationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketReplicationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure"`

	// A container for one or more replication rules. A replication configuration
	// must have at least one rule and you can add up to 100 rules. The maximum
	// size of a replication configuration is 128 KB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *GetBucketReplicationOutput) SetReplicationConfiguration(v *ReplicationConfiguration) *GetBucketReplicationOutput {
	s.ReplicationConfiguration = v
	return s
}

type GetBucketTaggingInput struct {
	_ struct{} `locationName:"GetBucketTaggingRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketTaggingInput) SetAccountId(v string) *GetBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketTaggingInput) SetBucket(v string) *GetBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The tags set of the Outposts bucket.
	//
	// TagSet is a required field
	TagSet []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetBucketTaggingOutput) SetTagSet(v []*S3Tag) *GetBucketTaggingOutput {
	s.TagSet = v
	return s
}

type GetBucketVersioningInput struct {
	_ struct{} `locationName:"GetBucketVersioningRequest" type:"structure"`

	// The Amazon Web Services account ID of the S3 on Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The S3 on Outposts bucket to return the versioning state for.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketVersioningInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBucketVersioningInput) SetAccountId(v string) *GetBucketVersioningInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketVersioningInput) SetBucket(v string) *GetBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketVersioningInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *GetBucketVersioningInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketVersioningInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s GetBucketVersioningInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s GetBucketVersioningInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is returned only if the bucket has been configured with MFA
	// delete. If MFA delete has never been configured for the bucket, this element
	// is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the S3 on Outposts bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *GetBucketVersioningOutput) SetMFADelete(v string) *GetBucketVersioningOutput {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBucketVersioningOutput) SetStatus(v string) *GetBucketVersioningOutput {
	s.Status = &v
	return s
}

type GetDataAccessInput struct {
	_ struct{} `locationName:"GetDataAccessRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The session duration, in seconds, of the temporary access credential that
	// S3 Access Grants vends to the grantee or client application. The default
	// value is 1 hour, but the grantee can specify a range from 900 seconds (15
	// minutes) up to 43200 seconds (12 hours). If the grantee requests a value
	// higher than this maximum, the operation fails.
	DurationSeconds *int64 `location:"querystring" locationName:"durationSeconds" min:"900" type:"integer"`

	// The type of permission granted to your S3 data, which can be set to one of
	// the following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	//
	// Permission is a required field
	Permission *string `location:"querystring" locationName:"permission" type:"string" required:"true" enum:"Permission"`

	// The scope of the temporary access credential that S3 Access Grants vends
	// to the grantee or client application.
	//
	//    * Default – The scope of the returned temporary access token is the
	//    scope of the grant that is closest to the target scope.
	//
	//    * Minimal – The scope of the returned temporary access token is the
	//    same as the requested target scope as long as the requested scope is the
	//    same as or a subset of the grant scope.
	Privilege *string `location:"querystring" locationName:"privilege" type:"string" enum:"Privilege"`

	// The S3 URI path of the data to which you are requesting temporary access
	// credentials. If the requesting account has an access grant for this data,
	// S3 Access Grants vends temporary access credentials in the response.
	//
	// Target is a required field
	Target *string `location:"querystring" locationName:"target" min:"1" type:"string" required:"true"`

	// The type of Target. The only possible value is Object. Pass this value if
	// the target data that you would like to access is a path to an object. Do
	// not pass this value if the target data is a bucket or a bucket and a prefix.
	TargetType *string `location:"querystring" locationName:"targetType" type:"string" enum:"S3PrefixType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataAccessInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.DurationSeconds != nil && *s.DurationSeconds < 900 {
		invalidParams.Add(request.NewErrParamMinValue("DurationSeconds", 900))
	}
	if s.Permission == nil {
		invalidParams.Add(request.NewErrParamRequired("Permission"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetDataAccessInput) SetAccountId(v string) *GetDataAccessInput {
	s.AccountId = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetDataAccessInput) SetDurationSeconds(v int64) *GetDataAccessInput {
	s.DurationSeconds = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *GetDataAccessInput) SetPermission(v string) *GetDataAccessInput {
	s.Permission = &v
	return s
}

// SetPrivilege sets the Privilege field's value.
func (s *GetDataAccessInput) SetPrivilege(v string) *GetDataAccessInput {
	s.Privilege = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetDataAccessInput) SetTarget(v string) *GetDataAccessInput {
	s.Target = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *GetDataAccessInput) SetTargetType(v string) *GetDataAccessInput {
	s.TargetType = &v
	return s
}

func (s *GetDataAccessInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetDataAccessOutput struct {
	_ struct{} `type:"structure"`

	// The temporary credential token that S3 Access Grants vends.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDataAccessOutput's
	// String and GoString methods.
	Credentials *Credentials `type:"structure" sensitive:"true"`

	// The S3 URI path of the data to which you are being granted temporary access
	// credentials.
	MatchedGrantTarget *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataAccessOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *GetDataAccessOutput) SetCredentials(v *Credentials) *GetDataAccessOutput {
	s.Credentials = v
	return s
}

// SetMatchedGrantTarget sets the MatchedGrantTarget field's value.
func (s *GetDataAccessOutput) SetMatchedGrantTarget(v string) *GetDataAccessOutput {
	s.MatchedGrantTarget = &v
	return s
}

type GetJobTaggingInput struct {
	_ struct{} `locationName:"GetJobTaggingRequest" type:"structure"`

	// The Amazon Web Services account ID associated with the S3 Batch Operations
	// job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetJobTaggingInput) SetAccountId(v string) *GetJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobTaggingInput) SetJobId(v string) *GetJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *GetJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetJobTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The set of tags associated with the S3 Batch Operations job.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobTaggingOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetJobTaggingOutput) SetTags(v []*S3Tag) *GetJobTaggingOutput {
	s.Tags = v
	return s
}

type GetMultiRegionAccessPointInput struct {
	_ struct{} `locationName:"GetMultiRegionAccessPointRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Multi-Region Access Point whose configuration information
	// you want to receive. The name of the Multi-Region Access Point is different
	// from the alias. For more information about the distinction between the name
	// and the alias of an Multi-Region Access Point, see Managing Multi-Region
	// Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
	// in the Amazon S3 User Guide.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMultiRegionAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMultiRegionAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetMultiRegionAccessPointInput) SetAccountId(v string) *GetMultiRegionAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMultiRegionAccessPointInput) SetName(v string) *GetMultiRegionAccessPointInput {
	s.Name = &v
	return s
}

func (s *GetMultiRegionAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetMultiRegionAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// A container element containing the details of the requested Multi-Region
	// Access Point.
	AccessPoint *MultiRegionAccessPointReport `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPoint sets the AccessPoint field's value.
func (s *GetMultiRegionAccessPointOutput) SetAccessPoint(v *MultiRegionAccessPointReport) *GetMultiRegionAccessPointOutput {
	s.AccessPoint = v
	return s
}

type GetMultiRegionAccessPointPolicyInput struct {
	_ struct{} `locationName:"GetMultiRegionAccessPointPolicyRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the Multi-Region Access Point. The name of the Multi-Region Access
	// Point is different from the alias. For more information about the distinction
	// between the name and the alias of an Multi-Region Access Point, see Managing
	// Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
	// in the Amazon S3 User Guide.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMultiRegionAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMultiRegionAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetMultiRegionAccessPointPolicyInput) SetAccountId(v string) *GetMultiRegionAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMultiRegionAccessPointPolicyInput) SetName(v string) *GetMultiRegionAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *GetMultiRegionAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetMultiRegionAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy associated with the specified Multi-Region Access Point.
	Policy *MultiRegionAccessPointPolicyDocument `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetMultiRegionAccessPointPolicyOutput) SetPolicy(v *MultiRegionAccessPointPolicyDocument) *GetMultiRegionAccessPointPolicyOutput {
	s.Policy = v
	return s
}

type GetMultiRegionAccessPointPolicyStatusInput struct {
	_ struct{} `locationName:"GetMultiRegionAccessPointPolicyStatusRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the Multi-Region Access Point. The name of the Multi-Region Access
	// Point is different from the alias. For more information about the distinction
	// between the name and the alias of an Multi-Region Access Point, see Managing
	// Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
	// in the Amazon S3 User Guide.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMultiRegionAccessPointPolicyStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMultiRegionAccessPointPolicyStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetMultiRegionAccessPointPolicyStatusInput) SetAccountId(v string) *GetMultiRegionAccessPointPolicyStatusInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMultiRegionAccessPointPolicyStatusInput) SetName(v string) *GetMultiRegionAccessPointPolicyStatusInput {
	s.Name = &v
	return s
}

func (s *GetMultiRegionAccessPointPolicyStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetMultiRegionAccessPointPolicyStatusOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether this access point policy is public. For more information
	// about how Amazon S3 evaluates policies to determine whether they are public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	Established *PolicyStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointPolicyStatusOutput) GoString() string {
	return s.String()
}

// SetEstablished sets the Established field's value.
func (s *GetMultiRegionAccessPointPolicyStatusOutput) SetEstablished(v *PolicyStatus) *GetMultiRegionAccessPointPolicyStatusOutput {
	s.Established = v
	return s
}

type GetMultiRegionAccessPointRoutesInput struct {
	_ struct{} `locationName:"GetMultiRegionAccessPointRoutesRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Multi-Region Access Point ARN.
	//
	// Mrap is a required field
	Mrap *string `location:"uri" locationName:"mrap" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMultiRegionAccessPointRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMultiRegionAccessPointRoutesInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Mrap == nil {
		invalidParams.Add(request.NewErrParamRequired("Mrap"))
	}
	if s.Mrap != nil && len(*s.Mrap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Mrap", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetMultiRegionAccessPointRoutesInput) SetAccountId(v string) *GetMultiRegionAccessPointRoutesInput {
	s.AccountId = &v
	return s
}

// SetMrap sets the Mrap field's value.
func (s *GetMultiRegionAccessPointRoutesInput) SetMrap(v string) *GetMultiRegionAccessPointRoutesInput {
	s.Mrap = &v
	return s
}

func (s *GetMultiRegionAccessPointRoutesInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetMultiRegionAccessPointRoutesOutput struct {
	_ struct{} `type:"structure"`

	// The Multi-Region Access Point ARN.
	Mrap *string `type:"string"`

	// The different routes that make up the route configuration. Active routes
	// return a value of 100, and passive routes return a value of 0.
	Routes []*MultiRegionAccessPointRoute `locationNameList:"Route" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMultiRegionAccessPointRoutesOutput) GoString() string {
	return s.String()
}

// SetMrap sets the Mrap field's value.
func (s *GetMultiRegionAccessPointRoutesOutput) SetMrap(v string) *GetMultiRegionAccessPointRoutesOutput {
	s.Mrap = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *GetMultiRegionAccessPointRoutesOutput) SetRoutes(v []*MultiRegionAccessPointRoute) *GetMultiRegionAccessPointRoutesOutput {
	s.Routes = v
	return s
}

type GetPublicAccessBlockInput struct {
	_ struct{} `locationName:"GetPublicAccessBlockRequest" type:"structure"`

	// The account ID for the Amazon Web Services account whose PublicAccessBlock
	// configuration you want to retrieve.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetPublicAccessBlockInput) SetAccountId(v string) *GetPublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *GetPublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetPublicAccessBlockOutput struct {
	_ struct{} `type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The PublicAccessBlock configuration currently in effect for this Amazon Web
	// Services account.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetPublicAccessBlockOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetPublicAccessBlockOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

type GetStorageLensConfigurationInput struct {
	_ struct{} `locationName:"GetStorageLensConfigurationRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the Amazon S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageLensConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageLensConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetStorageLensConfigurationInput) SetAccountId(v string) *GetStorageLensConfigurationInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *GetStorageLensConfigurationInput) SetConfigId(v string) *GetStorageLensConfigurationInput {
	s.ConfigId = &v
	return s
}

func (s *GetStorageLensConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetStorageLensConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"StorageLensConfiguration"`

	// The S3 Storage Lens configuration requested.
	StorageLensConfiguration *StorageLensConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationOutput) GoString() string {
	return s.String()
}

// SetStorageLensConfiguration sets the StorageLensConfiguration field's value.
func (s *GetStorageLensConfigurationOutput) SetStorageLensConfiguration(v *StorageLensConfiguration) *GetStorageLensConfigurationOutput {
	s.StorageLensConfiguration = v
	return s
}

type GetStorageLensConfigurationTaggingInput struct {
	_ struct{} `locationName:"GetStorageLensConfigurationTaggingRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the Amazon S3 Storage Lens configuration.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"storagelensid" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageLensConfigurationTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageLensConfigurationTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetStorageLensConfigurationTaggingInput) SetAccountId(v string) *GetStorageLensConfigurationTaggingInput {
	s.AccountId = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *GetStorageLensConfigurationTaggingInput) SetConfigId(v string) *GetStorageLensConfigurationTaggingInput {
	s.ConfigId = &v
	return s
}

func (s *GetStorageLensConfigurationTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetStorageLensConfigurationTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The tags of S3 Storage Lens configuration requested.
	Tags []*StorageLensTag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensConfigurationTaggingOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetStorageLensConfigurationTaggingOutput) SetTags(v []*StorageLensTag) *GetStorageLensConfigurationTaggingOutput {
	s.Tags = v
	return s
}

type GetStorageLensGroupInput struct {
	_ struct{} `locationName:"GetStorageLensGroupRequest" type:"structure"`

	// The Amazon Web Services account ID associated with the Storage Lens group
	// that you're trying to retrieve the details for.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Storage Lens group that you're trying to retrieve the configuration
	// details for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageLensGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageLensGroupInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetStorageLensGroupInput) SetAccountId(v string) *GetStorageLensGroupInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetStorageLensGroupInput) SetName(v string) *GetStorageLensGroupInput {
	s.Name = &v
	return s
}

func (s *GetStorageLensGroupInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetStorageLensGroupOutput struct {
	_ struct{} `type:"structure" payload:"StorageLensGroup"`

	// The name of the Storage Lens group that you're trying to retrieve the configuration
	// details for.
	StorageLensGroup *StorageLensGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageLensGroupOutput) GoString() string {
	return s.String()
}

// SetStorageLensGroup sets the StorageLensGroup field's value.
func (s *GetStorageLensGroupOutput) SetStorageLensGroup(v *StorageLensGroup) *GetStorageLensGroupOutput {
	s.StorageLensGroup = v
	return s
}

// The user, group, or role to which you are granting access. You can grant
// access to an IAM user or role. If you have added your corporate directory
// to Amazon Web Services IAM Identity Center and associated your Identity Center
// instance with your S3 Access Grants instance, the grantee can also be a corporate
// directory user or group.
type Grantee struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Grantee. If the grantee type is IAM, the identifier
	// is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee
	// type is a directory user or group, the identifier is 128-bit universally
	// unique identifier (UUID) in the format a1b2c3d4-5678-90ab-cdef-EXAMPLE11111.
	// You can obtain this UUID from your Amazon Web Services IAM Identity Center
	// instance.
	GranteeIdentifier *string `type:"string"`

	// The type of the grantee to which access has been granted. It can be one of
	// the following values:
	//
	//    * IAM - An IAM user or role.
	//
	//    * DIRECTORY_USER - Your corporate directory user. You can use this option
	//    if you have added your corporate identity directory to IAM Identity Center
	//    and associated the IAM Identity Center instance with your S3 Access Grants
	//    instance.
	//
	//    * DIRECTORY_GROUP - Your corporate directory group. You can use this option
	//    if you have added your corporate identity directory to IAM Identity Center
	//    and associated the IAM Identity Center instance with your S3 Access Grants
	//    instance.
	GranteeType *string `type:"string" enum:"GranteeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grantee) GoString() string {
	return s.String()
}

// SetGranteeIdentifier sets the GranteeIdentifier field's value.
func (s *Grantee) SetGranteeIdentifier(v string) *Grantee {
	s.GranteeIdentifier = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *Grantee) SetGranteeType(v string) *Grantee {
	s.GranteeType = &v
	return s
}

// A container for what Amazon S3 Storage Lens configuration includes.
type Include struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens bucket includes.
	Buckets []*string `locationNameList:"Arn" type:"list"`

	// A container for the S3 Storage Lens Region includes.
	Regions []*string `locationNameList:"Region" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Include) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Include) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *Include) SetBuckets(v []*string) *Include {
	s.Buckets = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *Include) SetRegions(v []*string) *Include {
	s.Regions = v
	return s
}

// A container element for the job configuration and status information returned
// by a Describe Job request.
type JobDescriptor struct {
	_ struct{} `type:"structure"`

	// Indicates whether confirmation is required before Amazon S3 begins running
	// the specified job. Confirmation is required only for jobs created through
	// the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A timestamp indicating when this job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string `min:"1" type:"string"`

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []*JobFailure `type:"list"`

	// The attribute of the JobDescriptor containing details about the job's generated
	// manifest.
	GeneratedManifestDescriptor *S3GeneratedManifestDescriptor `type:"structure"`

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest `type:"structure"`

	// The manifest generator that was used to generate a job manifest for this
	// job.
	ManifestGenerator *JobManifestGenerator `type:"structure"`

	// The operation that the specified job is configured to run on the objects
	// listed in the manifest.
	Operation *JobOperation `type:"structure"`

	// The priority of the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport `type:"structure"`

	// The Amazon Resource Name (ARN) for the Identity and Access Management (IAM)
	// role assigned to run the tasks for this job.
	RoleArn *string `min:"1" type:"string"`

	// The current status of the specified job.
	Status *string `type:"string" enum:"JobStatus"`

	// The reason for updating the job.
	StatusUpdateReason *string `min:"1" type:"string"`

	// The reason why the specified job was suspended. A job is only suspended if
	// you create it through the Amazon S3 console. When you create the job, it
	// enters the Suspended state to await confirmation before running. After you
	// confirm the job, it automatically exits the Suspended state.
	SuspendedCause *string `min:"1" type:"string"`

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time `type:"timestamp"`

	// A timestamp indicating when this job terminated. A job's termination date
	// is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDescriptor) GoString() string {
	return s.String()
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *JobDescriptor) SetConfirmationRequired(v bool) *JobDescriptor {
	s.ConfirmationRequired = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobDescriptor) SetCreationTime(v time.Time) *JobDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobDescriptor) SetDescription(v string) *JobDescriptor {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *JobDescriptor) SetFailureReasons(v []*JobFailure) *JobDescriptor {
	s.FailureReasons = v
	return s
}

// SetGeneratedManifestDescriptor sets the GeneratedManifestDescriptor field's value.
func (s *JobDescriptor) SetGeneratedManifestDescriptor(v *S3GeneratedManifestDescriptor) *JobDescriptor {
	s.GeneratedManifestDescriptor = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobDescriptor) SetJobArn(v string) *JobDescriptor {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDescriptor) SetJobId(v string) *JobDescriptor {
	s.JobId = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *JobDescriptor) SetManifest(v *JobManifest) *JobDescriptor {
	s.Manifest = v
	return s
}

// SetManifestGenerator sets the ManifestGenerator field's value.
func (s *JobDescriptor) SetManifestGenerator(v *JobManifestGenerator) *JobDescriptor {
	s.ManifestGenerator = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobDescriptor) SetOperation(v *JobOperation) *JobDescriptor {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobDescriptor) SetPriority(v int64) *JobDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobDescriptor) SetProgressSummary(v *JobProgressSummary) *JobDescriptor {
	s.ProgressSummary = v
	return s
}

// SetReport sets the Report field's value.
func (s *JobDescriptor) SetReport(v *JobReport) *JobDescriptor {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JobDescriptor) SetRoleArn(v string) *JobDescriptor {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDescriptor) SetStatus(v string) *JobDescriptor {
	s.Status = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *JobDescriptor) SetStatusUpdateReason(v string) *JobDescriptor {
	s.StatusUpdateReason = &v
	return s
}

// SetSuspendedCause sets the SuspendedCause field's value.
func (s *JobDescriptor) SetSuspendedCause(v string) *JobDescriptor {
	s.SuspendedCause = &v
	return s
}

// SetSuspendedDate sets the SuspendedDate field's value.
func (s *JobDescriptor) SetSuspendedDate(v time.Time) *JobDescriptor {
	s.SuspendedDate = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobDescriptor) SetTerminationDate(v time.Time) *JobDescriptor {
	s.TerminationDate = &v
	return s
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {
	_ struct{} `type:"structure"`

	// The failure code, if any, for the specified job.
	FailureCode *string `min:"1" type:"string"`

	// The failure reason, if any, for the specified job.
	FailureReason *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *JobFailure) SetFailureCode(v string) *JobFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *JobFailure) SetFailureReason(v string) *JobFailure {
	s.FailureReason = &v
	return s
}

// Contains the configuration and status information for a single job retrieved
// as part of a job list.
type JobListDescriptor struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The operation that the specified job is configured to run on every object
	// listed in the manifest.
	Operation *string `type:"string" enum:"OperationName"`

	// The current priority for the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has run, the number
	// of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// The specified job's current status.
	Status *string `type:"string" enum:"JobStatus"`

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobListDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobListDescriptor) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobListDescriptor) SetCreationTime(v time.Time) *JobListDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobListDescriptor) SetDescription(v string) *JobListDescriptor {
	s.Description = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobListDescriptor) SetJobId(v string) *JobListDescriptor {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobListDescriptor) SetOperation(v string) *JobListDescriptor {
	s.Operation = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobListDescriptor) SetPriority(v int64) *JobListDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobListDescriptor) SetProgressSummary(v *JobProgressSummary) *JobListDescriptor {
	s.ProgressSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobListDescriptor) SetStatus(v string) *JobListDescriptor {
	s.Status = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobListDescriptor) SetTerminationDate(v time.Time) *JobListDescriptor {
	s.TerminationDate = &v
	return s
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {
	_ struct{} `type:"structure"`

	// Contains the information required to locate the specified job's manifest.
	// Manifests can't be imported from directory buckets. For more information,
	// see Directory buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html).
	//
	// Location is a required field
	Location *JobManifestLocation `type:"structure" required:"true"`

	// Describes the format of the specified job's manifest. If the manifest is
	// in CSV format, also describes the columns contained within the manifest.
	//
	// Spec is a required field
	Spec *JobManifestSpec `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifest"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *JobManifest) SetLocation(v *JobManifestLocation) *JobManifest {
	s.Location = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *JobManifest) SetSpec(v *JobManifestSpec) *JobManifest {
	s.Spec = v
	return s
}

// Configures the type of the job's ManifestGenerator.
type JobManifestGenerator struct {
	_ struct{} `type:"structure"`

	// The S3 job ManifestGenerator's configuration details.
	S3JobManifestGenerator *S3JobManifestGenerator `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestGenerator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestGenerator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestGenerator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestGenerator"}
	if s.S3JobManifestGenerator != nil {
		if err := s.S3JobManifestGenerator.Validate(); err != nil {
			invalidParams.AddNested("S3JobManifestGenerator", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3JobManifestGenerator sets the S3JobManifestGenerator field's value.
func (s *JobManifestGenerator) SetS3JobManifestGenerator(v *S3JobManifestGenerator) *JobManifestGenerator {
	s.S3JobManifestGenerator = v
	return s
}

// The filter used to describe a set of objects for the job's manifest.
type JobManifestGeneratorFilter struct {
	_ struct{} `type:"structure"`

	// If provided, the generated manifest includes only source bucket objects that
	// were created after this time.
	CreatedAfter *time.Time `type:"timestamp"`

	// If provided, the generated manifest includes only source bucket objects that
	// were created before this time.
	CreatedBefore *time.Time `type:"timestamp"`

	// Include objects in the generated manifest only if they are eligible for replication
	// according to the Replication configuration on the source bucket.
	EligibleForReplication *bool `type:"boolean"`

	// If provided, the generated manifest includes only source bucket objects whose
	// object keys match the string constraints specified for MatchAnyPrefix, MatchAnySuffix,
	// and MatchAnySubstring.
	KeyNameConstraint *KeyNameConstraint `type:"structure"`

	// If provided, the generated manifest includes only source bucket objects that
	// are stored with the specified storage class.
	MatchAnyStorageClass []*string `type:"list" enum:"S3StorageClass"`

	// If provided, the generated manifest includes only source bucket objects that
	// have one of the specified Replication statuses.
	ObjectReplicationStatuses []*string `type:"list" enum:"ReplicationStatus"`

	// If provided, the generated manifest includes only source bucket objects whose
	// file size is greater than the specified number of bytes.
	ObjectSizeGreaterThanBytes *int64 `type:"long"`

	// If provided, the generated manifest includes only source bucket objects whose
	// file size is less than the specified number of bytes.
	ObjectSizeLessThanBytes *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestGeneratorFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestGeneratorFilter) GoString() string {
	return s.String()
}

// SetCreatedAfter sets the CreatedAfter field's value.
func (s *JobManifestGeneratorFilter) SetCreatedAfter(v time.Time) *JobManifestGeneratorFilter {
	s.CreatedAfter = &v
	return s
}

// SetCreatedBefore sets the CreatedBefore field's value.
func (s *JobManifestGeneratorFilter) SetCreatedBefore(v time.Time) *JobManifestGeneratorFilter {
	s.CreatedBefore = &v
	return s
}

// SetEligibleForReplication sets the EligibleForReplication field's value.
func (s *JobManifestGeneratorFilter) SetEligibleForReplication(v bool) *JobManifestGeneratorFilter {
	s.EligibleForReplication = &v
	return s
}

// SetKeyNameConstraint sets the KeyNameConstraint field's value.
func (s *JobManifestGeneratorFilter) SetKeyNameConstraint(v *KeyNameConstraint) *JobManifestGeneratorFilter {
	s.KeyNameConstraint = v
	return s
}

// SetMatchAnyStorageClass sets the MatchAnyStorageClass field's value.
func (s *JobManifestGeneratorFilter) SetMatchAnyStorageClass(v []*string) *JobManifestGeneratorFilter {
	s.MatchAnyStorageClass = v
	return s
}

// SetObjectReplicationStatuses sets the ObjectReplicationStatuses field's value.
func (s *JobManifestGeneratorFilter) SetObjectReplicationStatuses(v []*string) *JobManifestGeneratorFilter {
	s.ObjectReplicationStatuses = v
	return s
}

// SetObjectSizeGreaterThanBytes sets the ObjectSizeGreaterThanBytes field's value.
func (s *JobManifestGeneratorFilter) SetObjectSizeGreaterThanBytes(v int64) *JobManifestGeneratorFilter {
	s.ObjectSizeGreaterThanBytes = &v
	return s
}

// SetObjectSizeLessThanBytes sets the ObjectSizeLessThanBytes field's value.
func (s *JobManifestGeneratorFilter) SetObjectSizeLessThanBytes(v int64) *JobManifestGeneratorFilter {
	s.ObjectSizeLessThanBytes = &v
	return s
}

// Contains the information required to locate a manifest object. Manifests
// can't be imported from directory buckets. For more information, see Directory
// buckets (https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html).
type JobManifestLocation struct {
	_ struct{} `type:"structure"`

	// The ETag for the specified manifest object.
	//
	// ETag is a required field
	ETag *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for a manifest object.
	//
	// When you're using XML requests, you must replace special characters (such
	// as carriage returns) in object keys with their equivalent XML entity codes.
	// For more information, see XML-related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints)
	// in the Amazon S3 User Guide.
	//
	// ObjectArn is a required field
	ObjectArn *string `min:"1" type:"string" required:"true"`

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestLocation"}
	if s.ETag == nil {
		invalidParams.Add(request.NewErrParamRequired("ETag"))
	}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.ObjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectArn"))
	}
	if s.ObjectArn != nil && len(*s.ObjectArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectArn", 1))
	}
	if s.ObjectVersionId != nil && len(*s.ObjectVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *JobManifestLocation) SetETag(v string) *JobManifestLocation {
	s.ETag = &v
	return s
}

// SetObjectArn sets the ObjectArn field's value.
func (s *JobManifestLocation) SetObjectArn(v string) *JobManifestLocation {
	s.ObjectArn = &v
	return s
}

// SetObjectVersionId sets the ObjectVersionId field's value.
func (s *JobManifestLocation) SetObjectVersionId(v string) *JobManifestLocation {
	s.ObjectVersionId = &v
	return s
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {
	_ struct{} `type:"structure"`

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []*string `type:"list" enum:"JobManifestFieldName"`

	// Indicates which of the available formats the specified manifest uses.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"JobManifestFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobManifestSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestSpec"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFields sets the Fields field's value.
func (s *JobManifestSpec) SetFields(v []*string) *JobManifestSpec {
	s.Fields = v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobManifestSpec) SetFormat(v string) *JobManifestSpec {
	s.Format = &v
	return s
}

// The operation that you want this job to perform on every object listed in
// the manifest. For more information about the available operations, see Operations
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
// in the Amazon S3 User Guide.
type JobOperation struct {
	_ struct{} `type:"structure"`

	// Directs the specified job to invoke an Lambda function on every object in
	// the manifest.
	LambdaInvoke *LambdaInvokeOperation `type:"structure"`

	// Directs the specified job to execute a DELETE Object tagging call on every
	// object in the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3DeleteObjectTagging *S3DeleteObjectTaggingOperation `type:"structure"`

	// Directs the specified job to initiate restore requests for every archived
	// object in the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation `type:"structure"`

	// Directs the specified job to run a PutObjectAcl call on every object in the
	// manifest.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectAcl *S3SetObjectAclOperation `type:"structure"`

	// Directs the specified job to run a PUT Copy object call on every object in
	// the manifest.
	S3PutObjectCopy *S3CopyObjectOperation `type:"structure"`

	// Contains the configuration for an S3 Object Lock legal hold operation that
	// an S3 Batch Operations job passes to every object to the underlying PutObjectLegalHold
	// API operation. For more information, see Using S3 Object Lock legal hold
	// with S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html)
	// in the Amazon S3 User Guide.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation `type:"structure"`

	// Contains the configuration parameters for the Object Lock retention action
	// for an S3 Batch Operations job. Batch Operations passes every object to the
	// underlying PutObjectRetention API operation. For more information, see Using
	// S3 Object Lock retention with S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html)
	// in the Amazon S3 User Guide.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectRetention *S3SetObjectRetentionOperation `type:"structure"`

	// Directs the specified job to run a PUT Object tagging call on every object
	// in the manifest.
	//
	// This functionality is not supported by directory buckets.
	S3PutObjectTagging *S3SetObjectTaggingOperation `type:"structure"`

	// Directs the specified job to invoke ReplicateObject on every object in the
	// job's manifest.
	//
	// This functionality is not supported by directory buckets.
	S3ReplicateObject *S3ReplicateObjectOperation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobOperation"}
	if s.LambdaInvoke != nil {
		if err := s.LambdaInvoke.Validate(); err != nil {
			invalidParams.AddNested("LambdaInvoke", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectAcl != nil {
		if err := s.S3PutObjectAcl.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectAcl", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectCopy != nil {
		if err := s.S3PutObjectCopy.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectCopy", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectLegalHold != nil {
		if err := s.S3PutObjectLegalHold.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectLegalHold", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectRetention != nil {
		if err := s.S3PutObjectRetention.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectRetention", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectTagging != nil {
		if err := s.S3PutObjectTagging.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectTagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaInvoke sets the LambdaInvoke field's value.
func (s *JobOperation) SetLambdaInvoke(v *LambdaInvokeOperation) *JobOperation {
	s.LambdaInvoke = v
	return s
}

// SetS3DeleteObjectTagging sets the S3DeleteObjectTagging field's value.
func (s *JobOperation) SetS3DeleteObjectTagging(v *S3DeleteObjectTaggingOperation) *JobOperation {
	s.S3DeleteObjectTagging = v
	return s
}

// SetS3InitiateRestoreObject sets the S3InitiateRestoreObject field's value.
func (s *JobOperation) SetS3InitiateRestoreObject(v *S3InitiateRestoreObjectOperation) *JobOperation {
	s.S3InitiateRestoreObject = v
	return s
}

// SetS3PutObjectAcl sets the S3PutObjectAcl field's value.
func (s *JobOperation) SetS3PutObjectAcl(v *S3SetObjectAclOperation) *JobOperation {
	s.S3PutObjectAcl = v
	return s
}

// SetS3PutObjectCopy sets the S3PutObjectCopy field's value.
func (s *JobOperation) SetS3PutObjectCopy(v *S3CopyObjectOperation) *JobOperation {
	s.S3PutObjectCopy = v
	return s
}

// SetS3PutObjectLegalHold sets the S3PutObjectLegalHold field's value.
func (s *JobOperation) SetS3PutObjectLegalHold(v *S3SetObjectLegalHoldOperation) *JobOperation {
	s.S3PutObjectLegalHold = v
	return s
}

// SetS3PutObjectRetention sets the S3PutObjectRetention field's value.
func (s *JobOperation) SetS3PutObjectRetention(v *S3SetObjectRetentionOperation) *JobOperation {
	s.S3PutObjectRetention = v
	return s
}

// SetS3PutObjectTagging sets the S3PutObjectTagging field's value.
func (s *JobOperation) SetS3PutObjectTagging(v *S3SetObjectTaggingOperation) *JobOperation {
	s.S3PutObjectTagging = v
	return s
}

// SetS3ReplicateObject sets the S3ReplicateObject field's value.
func (s *JobOperation) SetS3ReplicateObject(v *S3ReplicateObjectOperation) *JobOperation {
	s.S3ReplicateObject = v
	return s
}

// Describes the total number of tasks that the specified job has started, the
// number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {
	_ struct{} `type:"structure"`

	NumberOfTasksFailed *int64 `type:"long"`

	NumberOfTasksSucceeded *int64 `type:"long"`

	// The JobTimers attribute of a job's progress summary.
	Timers *JobTimers `type:"structure"`

	TotalNumberOfTasks *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobProgressSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobProgressSummary) GoString() string {
	return s.String()
}

// SetNumberOfTasksFailed sets the NumberOfTasksFailed field's value.
func (s *JobProgressSummary) SetNumberOfTasksFailed(v int64) *JobProgressSummary {
	s.NumberOfTasksFailed = &v
	return s
}

// SetNumberOfTasksSucceeded sets the NumberOfTasksSucceeded field's value.
func (s *JobProgressSummary) SetNumberOfTasksSucceeded(v int64) *JobProgressSummary {
	s.NumberOfTasksSucceeded = &v
	return s
}

// SetTimers sets the Timers field's value.
func (s *JobProgressSummary) SetTimers(v *JobTimers) *JobProgressSummary {
	s.Timers = v
	return s
}

// SetTotalNumberOfTasks sets the TotalNumberOfTasks field's value.
func (s *JobProgressSummary) SetTotalNumberOfTasks(v int64) *JobProgressSummary {
	s.TotalNumberOfTasks = &v
	return s
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	//
	// Directory buckets - Directory buckets aren't supported as a location for
	// Batch Operations to store job completion reports.
	Bucket *string `min:"1" type:"string"`

	// Indicates whether the specified job will generate a job-completion report.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The format of the specified job-completion report.
	Format *string `type:"string" enum:"JobReportFormat"`

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 stores the job-completion report at <prefix>/job-<job-id>/report.json.
	Prefix *string `min:"1" type:"string"`

	// Indicates whether the job-completion report will include details of all tasks
	// or only failed tasks.
	ReportScope *string `type:"string" enum:"JobReportScope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobReport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobReport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobReport"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *JobReport) SetBucket(v string) *JobReport {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *JobReport) SetEnabled(v bool) *JobReport {
	s.Enabled = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobReport) SetFormat(v string) *JobReport {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *JobReport) SetPrefix(v string) *JobReport {
	s.Prefix = &v
	return s
}

// SetReportScope sets the ReportScope field's value.
func (s *JobReport) SetReportScope(v string) *JobReport {
	s.ReportScope = &v
	return s
}

// Provides timing details for the job.
type JobTimers struct {
	_ struct{} `type:"structure"`

	// Indicates the elapsed time in seconds the job has been in the Active job
	// state.
	ElapsedTimeInActiveSeconds *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobTimers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobTimers) GoString() string {
	return s.String()
}

// SetElapsedTimeInActiveSeconds sets the ElapsedTimeInActiveSeconds field's value.
func (s *JobTimers) SetElapsedTimeInActiveSeconds(v int64) *JobTimers {
	s.ElapsedTimeInActiveSeconds = &v
	return s
}

// If provided, the generated manifest includes only source bucket objects whose
// object keys match the string constraints specified for MatchAnyPrefix, MatchAnySuffix,
// and MatchAnySubstring.
type KeyNameConstraint struct {
	_ struct{} `type:"structure"`

	// If provided, the generated manifest includes objects where the specified
	// string appears at the start of the object key string.
	MatchAnyPrefix []*string `type:"list"`

	// If provided, the generated manifest includes objects where the specified
	// string appears anywhere within the object key string.
	MatchAnySubstring []*string `type:"list"`

	// If provided, the generated manifest includes objects where the specified
	// string appears at the end of the object key string.
	MatchAnySuffix []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyNameConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyNameConstraint) GoString() string {
	return s.String()
}

// SetMatchAnyPrefix sets the MatchAnyPrefix field's value.
func (s *KeyNameConstraint) SetMatchAnyPrefix(v []*string) *KeyNameConstraint {
	s.MatchAnyPrefix = v
	return s
}

// SetMatchAnySubstring sets the MatchAnySubstring field's value.
func (s *KeyNameConstraint) SetMatchAnySubstring(v []*string) *KeyNameConstraint {
	s.MatchAnySubstring = v
	return s
}

// SetMatchAnySuffix sets the MatchAnySuffix field's value.
func (s *KeyNameConstraint) SetMatchAnySuffix(v []*string) *KeyNameConstraint {
	s.MatchAnySuffix = v
	return s
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Lambda function that the specified
	// job will invoke on every object in the manifest.
	FunctionArn *string `min:"1" type:"string"`

	// Specifies the schema version for the payload that Batch Operations sends
	// when invoking an Lambda function. Version 1.0 is the default. Version 2.0
	// is required when you use Batch Operations to invoke Lambda functions that
	// act on directory buckets, or if you need to specify UserArguments. For more
	// information, see Using Lambda with Amazon S3 Batch Operations and Amazon
	// S3 Express One Zone (https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/)
	// in the Amazon Web Services Storage Blog.
	//
	// Ensure that your Lambda function code expects InvocationSchemaVersion 2.0
	// and uses bucket name rather than bucket ARN. If the InvocationSchemaVersion
	// does not match what your Lambda function expects, your function might not
	// work as expected.
	//
	// Directory buckets - To initiate Amazon Web Services Lambda function to perform
	// custom actions on objects in directory buckets, you must specify 2.0.
	InvocationSchemaVersion *string `min:"1" type:"string"`

	// Key-value pairs that are passed in the payload that Batch Operations sends
	// when invoking an Lambda function. You must specify InvocationSchemaVersion
	// 2.0 for LambdaInvoke operations that include UserArguments. For more information,
	// see Using Lambda with Amazon S3 Batch Operations and Amazon S3 Express One
	// Zone (https://aws.amazon.com/blogs/storage/using-lambda-with-s3-batch-operations-and-s3-express-one-zone/)
	// in the Amazon Web Services Storage Blog.
	UserArguments map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaInvokeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaInvokeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaInvokeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaInvokeOperation"}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionArn", 1))
	}
	if s.InvocationSchemaVersion != nil && len(*s.InvocationSchemaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationSchemaVersion", 1))
	}
	if s.UserArguments != nil && len(s.UserArguments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserArguments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaInvokeOperation) SetFunctionArn(v string) *LambdaInvokeOperation {
	s.FunctionArn = &v
	return s
}

// SetInvocationSchemaVersion sets the InvocationSchemaVersion field's value.
func (s *LambdaInvokeOperation) SetInvocationSchemaVersion(v string) *LambdaInvokeOperation {
	s.InvocationSchemaVersion = &v
	return s
}

// SetUserArguments sets the UserArguments field's value.
func (s *LambdaInvokeOperation) SetUserArguments(v map[string]*string) *LambdaInvokeOperation {
	s.UserArguments = v
	return s
}

// The container for the Outposts bucket lifecycle configuration.
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// A lifecycle rule for individual objects in an Outposts bucket.
	Rules []*LifecycleRule `locationNameList:"Rule" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleConfiguration"}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *LifecycleConfiguration) SetRules(v []*LifecycleRule) *LifecycleConfiguration {
	s.Rules = v
	return s
}

// The container of the Outposts bucket lifecycle expiration.
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be deleted. Should be in GMT ISO
	// 8601 format.
	Date *time.Time `type:"timestamp"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired. If set to false,
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LifecycleExpiration) SetDate(v time.Time) *LifecycleExpiration {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *LifecycleExpiration) SetDays(v int64) *LifecycleExpiration {
	s.Days = &v
	return s
}

// SetExpiredObjectDeleteMarker sets the ExpiredObjectDeleteMarker field's value.
func (s *LifecycleExpiration) SetExpiredObjectDeleteMarker(v bool) *LifecycleExpiration {
	s.ExpiredObjectDeleteMarker = &v
	return s
}

// The container for the Outposts bucket lifecycle rule.
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an incomplete multipart upload
	// that Amazon S3 waits before permanently removing all parts of the upload.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
	// in the Amazon S3 User Guide.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration `type:"structure"`

	// The container for the filter of lifecycle rule.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// The noncurrent version expiration of the lifecycle rule.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Specifies the transition rule for the lifecycle rule that describes when
	// noncurrent objects transition to a specific storage class. If your bucket
	// is versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to a specific
	// storage class at a set period in the object's lifetime.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	NoncurrentVersionTransitions []*NoncurrentVersionTransition `locationNameList:"NoncurrentVersionTransition" type:"list"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	Transitions []*Transition `locationNameList:"Transition" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRule"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *LifecycleRule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *LifecycleRule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *LifecycleRule) SetExpiration(v *LifecycleExpiration) *LifecycleRule {
	s.Expiration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LifecycleRule) SetFilter(v *LifecycleRuleFilter) *LifecycleRule {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *LifecycleRule) SetID(v string) *LifecycleRule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *LifecycleRule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *LifecycleRule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransitions sets the NoncurrentVersionTransitions field's value.
func (s *LifecycleRule) SetNoncurrentVersionTransitions(v []*NoncurrentVersionTransition) *LifecycleRule {
	s.NoncurrentVersionTransitions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleRule) SetStatus(v string) *LifecycleRule {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *LifecycleRule) SetTransitions(v []*Transition) *LifecycleRule {
	s.Transitions = v
	return s
}

// The container for the Outposts bucket lifecycle rule and operator.
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	// Minimum object size to which the rule applies.
	ObjectSizeGreaterThan *int64 `type:"long"`

	// Maximum object size to which the rule applies.
	ObjectSizeLessThan *int64 `type:"long"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRuleAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectSizeGreaterThan sets the ObjectSizeGreaterThan field's value.
func (s *LifecycleRuleAndOperator) SetObjectSizeGreaterThan(v int64) *LifecycleRuleAndOperator {
	s.ObjectSizeGreaterThan = &v
	return s
}

// SetObjectSizeLessThan sets the ObjectSizeLessThan field's value.
func (s *LifecycleRuleAndOperator) SetObjectSizeLessThan(v int64) *LifecycleRuleAndOperator {
	s.ObjectSizeLessThan = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleAndOperator) SetPrefix(v string) *LifecycleRuleAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LifecycleRuleAndOperator) SetTags(v []*S3Tag) *LifecycleRuleAndOperator {
	s.Tags = v
	return s
}

// The container for the filter of the lifecycle rule.
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// The container for the AND condition for the lifecycle rule.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Minimum object size to which the rule applies.
	ObjectSizeGreaterThan *int64 `type:"long"`

	// Maximum object size to which the rule applies.
	ObjectSizeLessThan *int64 `type:"long"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// When you're using XML requests, you must replace special characters (such
	// as carriage returns) in object keys with their equivalent XML entity codes.
	// For more information, see XML-related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints)
	// in the Amazon S3 User Guide.
	Prefix *string `type:"string"`

	// A container for a key-value name pair.
	Tag *S3Tag `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecycleRuleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *LifecycleRuleFilter) SetAnd(v *LifecycleRuleAndOperator) *LifecycleRuleFilter {
	s.And = v
	return s
}

// SetObjectSizeGreaterThan sets the ObjectSizeGreaterThan field's value.
func (s *LifecycleRuleFilter) SetObjectSizeGreaterThan(v int64) *LifecycleRuleFilter {
	s.ObjectSizeGreaterThan = &v
	return s
}

// SetObjectSizeLessThan sets the ObjectSizeLessThan field's value.
func (s *LifecycleRuleFilter) SetObjectSizeLessThan(v int64) *LifecycleRuleFilter {
	s.ObjectSizeLessThan = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleFilter) SetPrefix(v string) *LifecycleRuleFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *LifecycleRuleFilter) SetTag(v *S3Tag) *LifecycleRuleFilter {
	s.Tag = v
	return s
}

// Information about the access grant.
type ListAccessGrantEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the access grant.
	AccessGrantArn *string `min:"1" type:"string"`

	// The ID of the access grant. S3 Access Grants auto-generates this ID when
	// you create the access grant.
	AccessGrantId *string `min:"1" type:"string"`

	// The configuration options of the grant location. The grant location is the
	// S3 path to the data to which you are granting access.
	AccessGrantsLocationConfiguration *AccessGrantsLocationConfiguration `type:"structure"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string `min:"10" type:"string"`

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time `type:"timestamp"`

	// The S3 path of the data to which you are granting access. It is the result
	// of appending the Subprefix to the location scope.
	GrantScope *string `min:"1" type:"string"`

	// The user, group, or role to which you are granting access. You can grant
	// access to an IAM user or role. If you have added your corporate directory
	// to Amazon Web Services IAM Identity Center and associated your Identity Center
	// instance with your S3 Access Grants instance, the grantee can also be a corporate
	// directory user or group.
	Grantee *Grantee `type:"structure"`

	// The type of access granted to your S3 data, which can be set to one of the
	// following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantEntry) GoString() string {
	return s.String()
}

// SetAccessGrantArn sets the AccessGrantArn field's value.
func (s *ListAccessGrantEntry) SetAccessGrantArn(v string) *ListAccessGrantEntry {
	s.AccessGrantArn = &v
	return s
}

// SetAccessGrantId sets the AccessGrantId field's value.
func (s *ListAccessGrantEntry) SetAccessGrantId(v string) *ListAccessGrantEntry {
	s.AccessGrantId = &v
	return s
}

// SetAccessGrantsLocationConfiguration sets the AccessGrantsLocationConfiguration field's value.
func (s *ListAccessGrantEntry) SetAccessGrantsLocationConfiguration(v *AccessGrantsLocationConfiguration) *ListAccessGrantEntry {
	s.AccessGrantsLocationConfiguration = v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *ListAccessGrantEntry) SetAccessGrantsLocationId(v string) *ListAccessGrantEntry {
	s.AccessGrantsLocationId = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListAccessGrantEntry) SetApplicationArn(v string) *ListAccessGrantEntry {
	s.ApplicationArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListAccessGrantEntry) SetCreatedAt(v time.Time) *ListAccessGrantEntry {
	s.CreatedAt = &v
	return s
}

// SetGrantScope sets the GrantScope field's value.
func (s *ListAccessGrantEntry) SetGrantScope(v string) *ListAccessGrantEntry {
	s.GrantScope = &v
	return s
}

// SetGrantee sets the Grantee field's value.
func (s *ListAccessGrantEntry) SetGrantee(v *Grantee) *ListAccessGrantEntry {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *ListAccessGrantEntry) SetPermission(v string) *ListAccessGrantEntry {
	s.Permission = &v
	return s
}

type ListAccessGrantsInput struct {
	_ struct{} `locationName:"ListAccessGrantsRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity Center
	// application associated with your Identity Center instance. If the grant includes
	// an application ARN, the grantee can only access the S3 data through this
	// application.
	ApplicationArn *string `location:"querystring" locationName:"application_arn" min:"10" type:"string"`

	// The S3 path of the data to which you are granting access. It is the result
	// of appending the Subprefix to the location scope.
	GrantScope *string `location:"querystring" locationName:"grantscope" min:"1" type:"string"`

	// The unique identifer of the Grantee. If the grantee type is IAM, the identifier
	// is the IAM Amazon Resource Name (ARN) of the user or role. If the grantee
	// type is a directory user or group, the identifier is 128-bit universally
	// unique identifier (UUID) in the format a1b2c3d4-5678-90ab-cdef-EXAMPLE11111.
	// You can obtain this UUID from your Amazon Web Services IAM Identity Center
	// instance.
	GranteeIdentifier *string `location:"querystring" locationName:"granteeidentifier" type:"string"`

	// The type of the grantee to which access has been granted. It can be one of
	// the following values:
	//
	//    * IAM - An IAM user or role.
	//
	//    * DIRECTORY_USER - Your corporate directory user. You can use this option
	//    if you have added your corporate identity directory to IAM Identity Center
	//    and associated the IAM Identity Center instance with your S3 Access Grants
	//    instance.
	//
	//    * DIRECTORY_GROUP - Your corporate directory group. You can use this option
	//    if you have added your corporate identity directory to IAM Identity Center
	//    and associated the IAM Identity Center instance with your S3 Access Grants
	//    instance.
	GranteeType *string `location:"querystring" locationName:"granteetype" type:"string" enum:"GranteeType"`

	// The maximum number of access grants that you would like returned in the List
	// Access Grants response. If the results include the pagination token NextToken,
	// make another call using the NextToken to determine if there are more results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants request in order to retrieve the next page
	// of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The type of permission granted to your S3 data, which can be set to one of
	// the following values:
	//
	//    * READ – Grant read-only access to the S3 data.
	//
	//    * WRITE – Grant write-only access to the S3 data.
	//
	//    * READWRITE – Grant both read and write access to the S3 data.
	Permission *string `location:"querystring" locationName:"permission" type:"string" enum:"Permission"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessGrantsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.GrantScope != nil && len(*s.GrantScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantScope", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessGrantsInput) SetAccountId(v string) *ListAccessGrantsInput {
	s.AccountId = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListAccessGrantsInput) SetApplicationArn(v string) *ListAccessGrantsInput {
	s.ApplicationArn = &v
	return s
}

// SetGrantScope sets the GrantScope field's value.
func (s *ListAccessGrantsInput) SetGrantScope(v string) *ListAccessGrantsInput {
	s.GrantScope = &v
	return s
}

// SetGranteeIdentifier sets the GranteeIdentifier field's value.
func (s *ListAccessGrantsInput) SetGranteeIdentifier(v string) *ListAccessGrantsInput {
	s.GranteeIdentifier = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *ListAccessGrantsInput) SetGranteeType(v string) *ListAccessGrantsInput {
	s.GranteeType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessGrantsInput) SetMaxResults(v int64) *ListAccessGrantsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsInput) SetNextToken(v string) *ListAccessGrantsInput {
	s.NextToken = &v
	return s
}

// SetPermission sets the Permission field's value.
func (s *ListAccessGrantsInput) SetPermission(v string) *ListAccessGrantsInput {
	s.Permission = &v
	return s
}

func (s *ListAccessGrantsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

// Information about the S3 Access Grants instance.
type ListAccessGrantsInstanceEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 Access Grants instance.
	AccessGrantsInstanceArn *string `min:"1" type:"string"`

	// The ID of the S3 Access Grants instance. The ID is default. You can have
	// one S3 Access Grants instance per Region per account.
	AccessGrantsInstanceId *string `min:"1" type:"string"`

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time `type:"timestamp"`

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name
	// (ARN) of the IAM Identity Center instance application; a subresource of the
	// original Identity Center instance. S3 Access Grants creates this Identity
	// Center application for the specific S3 Access Grants instance.
	IdentityCenterArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstanceEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstanceEntry) GoString() string {
	return s.String()
}

// SetAccessGrantsInstanceArn sets the AccessGrantsInstanceArn field's value.
func (s *ListAccessGrantsInstanceEntry) SetAccessGrantsInstanceArn(v string) *ListAccessGrantsInstanceEntry {
	s.AccessGrantsInstanceArn = &v
	return s
}

// SetAccessGrantsInstanceId sets the AccessGrantsInstanceId field's value.
func (s *ListAccessGrantsInstanceEntry) SetAccessGrantsInstanceId(v string) *ListAccessGrantsInstanceEntry {
	s.AccessGrantsInstanceId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListAccessGrantsInstanceEntry) SetCreatedAt(v time.Time) *ListAccessGrantsInstanceEntry {
	s.CreatedAt = &v
	return s
}

// SetIdentityCenterArn sets the IdentityCenterArn field's value.
func (s *ListAccessGrantsInstanceEntry) SetIdentityCenterArn(v string) *ListAccessGrantsInstanceEntry {
	s.IdentityCenterArn = &v
	return s
}

type ListAccessGrantsInstancesInput struct {
	_ struct{} `locationName:"ListAccessGrantsInstancesRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The maximum number of access grants that you would like returned in the List
	// Access Grants response. If the results include the pagination token NextToken,
	// make another call using the NextToken to determine if there are more results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants Instances request in order to retrieve the
	// next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessGrantsInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessGrantsInstancesInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessGrantsInstancesInput) SetAccountId(v string) *ListAccessGrantsInstancesInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessGrantsInstancesInput) SetMaxResults(v int64) *ListAccessGrantsInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsInstancesInput) SetNextToken(v string) *ListAccessGrantsInstancesInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessGrantsInstancesInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListAccessGrantsInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A container for a list of S3 Access Grants instances.
	AccessGrantsInstancesList []*ListAccessGrantsInstanceEntry `locationNameList:"AccessGrantsInstance" type:"list"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants Instances request in order to retrieve the
	// next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsInstancesOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsInstancesList sets the AccessGrantsInstancesList field's value.
func (s *ListAccessGrantsInstancesOutput) SetAccessGrantsInstancesList(v []*ListAccessGrantsInstanceEntry) *ListAccessGrantsInstancesOutput {
	s.AccessGrantsInstancesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsInstancesOutput) SetNextToken(v string) *ListAccessGrantsInstancesOutput {
	s.NextToken = &v
	return s
}

// A container for information about the registered location.
type ListAccessGrantsLocationsEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the registered location.
	AccessGrantsLocationArn *string `min:"1" type:"string"`

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigns this ID when you register the location. S3 Access Grants assigns
	// the ID default to the default location s3:// and assigns an auto-generated
	// ID to other locations that you register.
	AccessGrantsLocationId *string `min:"1" type:"string"`

	// The date and time when you registered the location.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the IAM role for the registered location.
	// S3 Access Grants assumes this role to manage access to the registered location.
	IAMRoleArn *string `min:"1" type:"string"`

	// The S3 path to the location that you are registering. The location scope
	// can be the default S3 location s3://, the S3 path to a bucket s3://<bucket>,
	// or the S3 path to a bucket and prefix s3://<bucket>/<prefix>. A prefix in
	// S3 is a string of characters at the beginning of an object key name used
	// to organize the objects that you store in your S3 buckets. For example, object
	// key names that start with the engineering/ prefix or object key names that
	// start with the marketing/campaigns/ prefix.
	LocationScope *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsEntry) GoString() string {
	return s.String()
}

// SetAccessGrantsLocationArn sets the AccessGrantsLocationArn field's value.
func (s *ListAccessGrantsLocationsEntry) SetAccessGrantsLocationArn(v string) *ListAccessGrantsLocationsEntry {
	s.AccessGrantsLocationArn = &v
	return s
}

// SetAccessGrantsLocationId sets the AccessGrantsLocationId field's value.
func (s *ListAccessGrantsLocationsEntry) SetAccessGrantsLocationId(v string) *ListAccessGrantsLocationsEntry {
	s.AccessGrantsLocationId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListAccessGrantsLocationsEntry) SetCreatedAt(v time.Time) *ListAccessGrantsLocationsEntry {
	s.CreatedAt = &v
	return s
}

// SetIAMRoleArn sets the IAMRoleArn field's value.
func (s *ListAccessGrantsLocationsEntry) SetIAMRoleArn(v string) *ListAccessGrantsLocationsEntry {
	s.IAMRoleArn = &v
	return s
}

// SetLocationScope sets the LocationScope field's value.
func (s *ListAccessGrantsLocationsEntry) SetLocationScope(v string) *ListAccessGrantsLocationsEntry {
	s.LocationScope = &v
	return s
}

type ListAccessGrantsLocationsInput struct {
	_ struct{} `locationName:"ListAccessGrantsLocationsRequest" type:"structure"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The S3 path to the location that you are registering. The location scope
	// can be the default S3 location s3://, the S3 path to a bucket s3://<bucket>,
	// or the S3 path to a bucket and prefix s3://<bucket>/<prefix>. A prefix in
	// S3 is a string of characters at the beginning of an object key name used
	// to organize the objects that you store in your S3 buckets. For example, object
	// key names that start with the engineering/ prefix or object key names that
	// start with the marketing/campaigns/ prefix.
	LocationScope *string `location:"querystring" locationName:"locationscope" min:"1" type:"string"`

	// The maximum number of access grants that you would like returned in the List
	// Access Grants response. If the results include the pagination token NextToken,
	// make another call using the NextToken to determine if there are more results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants Locations request in order to retrieve the
	// next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessGrantsLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessGrantsLocationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.LocationScope != nil && len(*s.LocationScope) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationScope", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessGrantsLocationsInput) SetAccountId(v string) *ListAccessGrantsLocationsInput {
	s.AccountId = &v
	return s
}

// SetLocationScope sets the LocationScope field's value.
func (s *ListAccessGrantsLocationsInput) SetLocationScope(v string) *ListAccessGrantsLocationsInput {
	s.LocationScope = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessGrantsLocationsInput) SetMaxResults(v int64) *ListAccessGrantsLocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsLocationsInput) SetNextToken(v string) *ListAccessGrantsLocationsInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessGrantsLocationsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListAccessGrantsLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A container for a list of registered locations in an S3 Access Grants instance.
	AccessGrantsLocationsList []*ListAccessGrantsLocationsEntry `locationNameList:"AccessGrantsLocation" type:"list"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants Locations request in order to retrieve the
	// next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsLocationsOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsLocationsList sets the AccessGrantsLocationsList field's value.
func (s *ListAccessGrantsLocationsOutput) SetAccessGrantsLocationsList(v []*ListAccessGrantsLocationsEntry) *ListAccessGrantsLocationsOutput {
	s.AccessGrantsLocationsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsLocationsOutput) SetNextToken(v string) *ListAccessGrantsLocationsOutput {
	s.NextToken = &v
	return s
}

type ListAccessGrantsOutput struct {
	_ struct{} `type:"structure"`

	// A container for a list of grants in an S3 Access Grants instance.
	AccessGrantsList []*ListAccessGrantEntry `locationNameList:"AccessGrant" type:"list"`

	// A pagination token to request the next page of results. Pass this value into
	// a subsequent List Access Grants request in order to retrieve the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessGrantsOutput) GoString() string {
	return s.String()
}

// SetAccessGrantsList sets the AccessGrantsList field's value.
func (s *ListAccessGrantsOutput) SetAccessGrantsList(v []*ListAccessGrantEntry) *ListAccessGrantsOutput {
	s.AccessGrantsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessGrantsOutput) SetNextToken(v string) *ListAccessGrantsOutput {
	s.NextToken = &v
	return s
}

type ListAccessPointsForObjectLambdaInput struct {
	_ struct{} `locationName:"ListAccessPointsForObjectLambdaRequest" type:"structure"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The maximum number of access points that you want to include in the list.
	// The response may contain fewer access points but will never contain more.
	// If there are more than this number of access points, then the response will
	// include a continuation token in the NextToken field that you can use to retrieve
	// the next page of access points.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// If the list has more access points than can be returned in one call to this
	// API, this field contains a continuation token that you can provide in subsequent
	// calls to this API to retrieve additional access points.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPointsForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPointsForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessPointsForObjectLambdaInput) SetAccountId(v string) *ListAccessPointsForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPointsForObjectLambdaInput) SetMaxResults(v int64) *ListAccessPointsForObjectLambdaInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsForObjectLambdaInput) SetNextToken(v string) *ListAccessPointsForObjectLambdaInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessPointsForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListAccessPointsForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`

	// If the list has more access points than can be returned in one call to this
	// API, this field contains a continuation token that you can provide in subsequent
	// calls to this API to retrieve additional access points.
	NextToken *string `min:"1" type:"string"`

	// Returns list of Object Lambda Access Points.
	ObjectLambdaAccessPointList []*ObjectLambdaAccessPoint `locationNameList:"ObjectLambdaAccessPoint" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsForObjectLambdaOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsForObjectLambdaOutput) SetNextToken(v string) *ListAccessPointsForObjectLambdaOutput {
	s.NextToken = &v
	return s
}

// SetObjectLambdaAccessPointList sets the ObjectLambdaAccessPointList field's value.
func (s *ListAccessPointsForObjectLambdaOutput) SetObjectLambdaAccessPointList(v []*ObjectLambdaAccessPoint) *ListAccessPointsForObjectLambdaOutput {
	s.ObjectLambdaAccessPointList = v
	return s
}

type ListAccessPointsInput struct {
	_ struct{} `locationName:"ListAccessPointsRequest" type:"structure"`

	// The Amazon Web Services account ID for the account that owns the specified
	// access points.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket whose associated access points you want to list.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	Bucket *string `location:"querystring" locationName:"bucket" min:"3" type:"string"`

	// The maximum number of access points that you want to include in the list.
	// If the specified bucket has more than this number of access points, then
	// the response will include a continuation token in the NextToken field that
	// you can use to retrieve the next page of access points.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A continuation token. If a previous call to ListAccessPoints returned a continuation
	// token in the NextToken field, then providing that value here causes Amazon
	// S3 to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPointsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessPointsInput) SetAccountId(v string) *ListAccessPointsInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListAccessPointsInput) SetBucket(v string) *ListAccessPointsInput {
	s.Bucket = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPointsInput) SetMaxResults(v int64) *ListAccessPointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsInput) SetNextToken(v string) *ListAccessPointsInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessPointsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *ListAccessPointsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *ListAccessPointsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s ListAccessPointsInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s ListAccessPointsInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type ListAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// Contains identification and configuration information for one or more access
	// points associated with the specified bucket.
	AccessPointList []*AccessPoint `locationNameList:"AccessPoint" type:"list"`

	// If the specified bucket has more access points than can be returned in one
	// call to this API, this field contains a continuation token that you can provide
	// in subsequent calls to this API to retrieve additional access points.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPointsOutput) GoString() string {
	return s.String()
}

// SetAccessPointList sets the AccessPointList field's value.
func (s *ListAccessPointsOutput) SetAccessPointList(v []*AccessPoint) *ListAccessPointsOutput {
	s.AccessPointList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsOutput) SetNextToken(v string) *ListAccessPointsOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `locationName:"ListJobsRequest" type:"structure"`

	// The Amazon Web Services account ID associated with the S3 Batch Operations
	// job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The List Jobs request returns jobs that match the statuses listed in this
	// element.
	JobStatuses []*string `location:"querystring" locationName:"jobStatuses" type:"list" enum:"JobStatus"`

	// The maximum number of jobs that Amazon S3 will include in the List Jobs response.
	// If there are more jobs than this number, the response will include a pagination
	// token in the NextToken field to enable you to retrieve the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token to request the next page of results. Use the token that
	// Amazon S3 returned in the NextToken element of the ListJobsResult from the
	// previous List Jobs request.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListJobsInput) SetAccountId(v string) *ListJobsInput {
	s.AccountId = &v
	return s
}

// SetJobStatuses sets the JobStatuses field's value.
func (s *ListJobsInput) SetJobStatuses(v []*string) *ListJobsInput {
	s.JobStatuses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

func (s *ListJobsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of current jobs and jobs that have ended within the last 30 days.
	Jobs []*JobListDescriptor `type:"list"`

	// If the List Jobs request produced more than the maximum number of results,
	// you can pass this value into a subsequent List Jobs request in order to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobListDescriptor) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListMultiRegionAccessPointsInput struct {
	_ struct{} `locationName:"ListMultiRegionAccessPointsRequest" type:"structure"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Not currently used. Do not use this parameter.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Not currently used. Do not use this parameter.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultiRegionAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultiRegionAccessPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultiRegionAccessPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultiRegionAccessPointsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListMultiRegionAccessPointsInput) SetAccountId(v string) *ListMultiRegionAccessPointsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMultiRegionAccessPointsInput) SetMaxResults(v int64) *ListMultiRegionAccessPointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiRegionAccessPointsInput) SetNextToken(v string) *ListMultiRegionAccessPointsInput {
	s.NextToken = &v
	return s
}

func (s *ListMultiRegionAccessPointsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListMultiRegionAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Multi-Region Access Points associated with the user.
	AccessPoints []*MultiRegionAccessPointReport `locationNameList:"AccessPoint" type:"list"`

	// If the specified bucket has more Multi-Region Access Points than can be returned
	// in one call to this action, this field contains a continuation token. You
	// can use this token tin subsequent calls to this action to retrieve additional
	// Multi-Region Access Points.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultiRegionAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMultiRegionAccessPointsOutput) GoString() string {
	return s.String()
}

// SetAccessPoints sets the AccessPoints field's value.
func (s *ListMultiRegionAccessPointsOutput) SetAccessPoints(v []*MultiRegionAccessPointReport) *ListMultiRegionAccessPointsOutput {
	s.AccessPoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMultiRegionAccessPointsOutput) SetNextToken(v string) *ListMultiRegionAccessPointsOutput {
	s.NextToken = &v
	return s
}

type ListRegionalBucketsInput struct {
	_ struct{} `locationName:"ListRegionalBucketsRequest" type:"structure"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the Outposts resource.
	//
	// This ID is required by Amazon S3 on Outposts buckets.
	OutpostId *string `location:"header" locationName:"x-amz-outpost-id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegionalBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegionalBucketsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegionalBucketsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegionalBucketsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRegionalBucketsInput) SetAccountId(v string) *ListRegionalBucketsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRegionalBucketsInput) SetMaxResults(v int64) *ListRegionalBucketsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegionalBucketsInput) SetNextToken(v string) *ListRegionalBucketsInput {
	s.NextToken = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *ListRegionalBucketsInput) SetOutpostId(v string) *ListRegionalBucketsInput {
	s.OutpostId = &v
	return s
}

func (s *ListRegionalBucketsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *ListRegionalBucketsInput) getOutpostID() (string, error) {
	if s.OutpostId == nil {
		return "", fmt.Errorf("member OutpostId is nil")
	}
	return *s.OutpostId, nil
}

func (s *ListRegionalBucketsInput) hasOutpostID() bool {
	if s.OutpostId == nil {
		return false
	}
	return true
}

type ListRegionalBucketsOutput struct {
	_ struct{} `type:"structure"`

	// NextToken is sent when isTruncated is true, which means there are more buckets
	// that can be listed. The next list requests to Amazon S3 can be continued
	// with this NextToken. NextToken is obfuscated and is not a real key.
	NextToken *string `min:"1" type:"string"`

	RegionalBucketList []*RegionalBucket `locationNameList:"RegionalBucket" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegionalBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRegionalBucketsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRegionalBucketsOutput) SetNextToken(v string) *ListRegionalBucketsOutput {
	s.NextToken = &v
	return s
}

// SetRegionalBucketList sets the RegionalBucketList field's value.
func (s *ListRegionalBucketsOutput) SetRegionalBucketList(v []*RegionalBucket) *ListRegionalBucketsOutput {
	s.RegionalBucketList = v
	return s
}

// Part of ListStorageLensConfigurationResult. Each entry includes the description
// of the S3 Storage Lens configuration, its home Region, whether it is enabled,
// its Amazon Resource Name (ARN), and config ID.
type ListStorageLensConfigurationEntry struct {
	_ struct{} `type:"structure"`

	// A container for the S3 Storage Lens home Region. Your metrics data is stored
	// and retained in your designated S3 Storage Lens home Region.
	//
	// HomeRegion is a required field
	HomeRegion *string `min:"5" type:"string" required:"true"`

	// A container for the S3 Storage Lens configuration ID.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A container for whether the S3 Storage Lens configuration is enabled. This
	// property is required.
	IsEnabled *bool `type:"boolean"`

	// The ARN of the S3 Storage Lens configuration. This property is read-only.
	//
	// StorageLensArn is a required field
	StorageLensArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationEntry) GoString() string {
	return s.String()
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *ListStorageLensConfigurationEntry) SetHomeRegion(v string) *ListStorageLensConfigurationEntry {
	s.HomeRegion = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListStorageLensConfigurationEntry) SetId(v string) *ListStorageLensConfigurationEntry {
	s.Id = &v
	return s
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *ListStorageLensConfigurationEntry) SetIsEnabled(v bool) *ListStorageLensConfigurationEntry {
	s.IsEnabled = &v
	return s
}

// SetStorageLensArn sets the StorageLensArn field's value.
func (s *ListStorageLensConfigurationEntry) SetStorageLensArn(v string) *ListStorageLensConfigurationEntry {
	s.StorageLensArn = &v
	return s
}

type ListStorageLensConfigurationsInput struct {
	_ struct{} `locationName:"ListStorageLensConfigurationsRequest" type:"structure"`

	// The account ID of the requester.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// A pagination token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageLensConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageLensConfigurationsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListStorageLensConfigurationsInput) SetAccountId(v string) *ListStorageLensConfigurationsInput {
	s.AccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensConfigurationsInput) SetNextToken(v string) *ListStorageLensConfigurationsInput {
	s.NextToken = &v
	return s
}

func (s *ListStorageLensConfigurationsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListStorageLensConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If the request produced more than the maximum number of S3 Storage Lens configuration
	// results, you can pass this value into a subsequent request to retrieve the
	// next page of results.
	NextToken *string `type:"string"`

	// A list of S3 Storage Lens configurations.
	StorageLensConfigurationList []*ListStorageLensConfigurationEntry `locationNameList:"StorageLensConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensConfigurationsOutput) SetNextToken(v string) *ListStorageLensConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetStorageLensConfigurationList sets the StorageLensConfigurationList field's value.
func (s *ListStorageLensConfigurationsOutput) SetStorageLensConfigurationList(v []*ListStorageLensConfigurationEntry) *ListStorageLensConfigurationsOutput {
	s.StorageLensConfigurationList = v
	return s
}

// Each entry contains a Storage Lens group that exists in the specified home
// Region.
type ListStorageLensGroupEntry struct {
	_ struct{} `type:"structure"`

	// Contains the Amazon Web Services Region where the Storage Lens group was
	// created.
	//
	// HomeRegion is a required field
	HomeRegion *string `min:"5" type:"string" required:"true"`

	// Contains the name of the Storage Lens group that exists in the specified
	// home Region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Contains the Amazon Resource Name (ARN) of the Storage Lens group. This property
	// is read-only.
	//
	// StorageLensGroupArn is a required field
	StorageLensGroupArn *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupEntry) GoString() string {
	return s.String()
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *ListStorageLensGroupEntry) SetHomeRegion(v string) *ListStorageLensGroupEntry {
	s.HomeRegion = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListStorageLensGroupEntry) SetName(v string) *ListStorageLensGroupEntry {
	s.Name = &v
	return s
}

// SetStorageLensGroupArn sets the StorageLensGroupArn field's value.
func (s *ListStorageLensGroupEntry) SetStorageLensGroupArn(v string) *ListStorageLensGroupEntry {
	s.StorageLensGroupArn = &v
	return s
}

type ListStorageLensGroupsInput struct {
	_ struct{} `locationName:"ListStorageLensGroupsRequest" type:"structure"`

	// The Amazon Web Services account ID that owns the Storage Lens groups.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The token for the next set of results, or null if there are no more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageLensGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageLensGroupsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListStorageLensGroupsInput) SetAccountId(v string) *ListStorageLensGroupsInput {
	s.AccountId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensGroupsInput) SetNextToken(v string) *ListStorageLensGroupsInput {
	s.NextToken = &v
	return s
}

func (s *ListStorageLensGroupsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListStorageLensGroupsOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is returned, there are more Storage Lens groups results available.
	// The value of NextToken is a unique pagination token for each page. Make the
	// call again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 24 hours.
	NextToken *string `type:"string"`

	// The list of Storage Lens groups that exist in the specified home Region.
	StorageLensGroupList []*ListStorageLensGroupEntry `locationNameList:"StorageLensGroup" type:"list" flattened:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageLensGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageLensGroupsOutput) SetNextToken(v string) *ListStorageLensGroupsOutput {
	s.NextToken = &v
	return s
}

// SetStorageLensGroupList sets the StorageLensGroupList field's value.
func (s *ListStorageLensGroupsOutput) SetStorageLensGroupList(v []*ListStorageLensGroupEntry) *ListStorageLensGroupsOutput {
	s.StorageLensGroupList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `locationName:"ListTagsForResourceRequest" type:"structure"`

	// The Amazon Web Services account ID of the resource owner.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the S3 resource that you want to list the
	// tags for. The tagged resource can be an S3 Storage Lens group or S3 Access
	// Grants instance, registered location, or grant.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListTagsForResourceInput) SetAccountId(v string) *ListTagsForResourceInput {
	s.AccountId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

func (s *ListTagsForResourceInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services resource tags that are associated with the resource.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A filter condition that specifies the object age range of included objects
// in days. Only integers are supported.
type MatchObjectAge struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum object age in days. Must be a positive whole number,
	// greater than the minimum object age and less than or equal to 2,147,483,647.
	DaysGreaterThan *int64 `type:"integer"`

	// Specifies the minimum object age in days. The value must be a positive whole
	// number, greater than 0 and less than or equal to 2,147,483,647.
	DaysLessThan *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchObjectAge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchObjectAge) GoString() string {
	return s.String()
}

// SetDaysGreaterThan sets the DaysGreaterThan field's value.
func (s *MatchObjectAge) SetDaysGreaterThan(v int64) *MatchObjectAge {
	s.DaysGreaterThan = &v
	return s
}

// SetDaysLessThan sets the DaysLessThan field's value.
func (s *MatchObjectAge) SetDaysLessThan(v int64) *MatchObjectAge {
	s.DaysLessThan = &v
	return s
}

// A filter condition that specifies the object size range of included objects
// in bytes. Only integers are supported.
type MatchObjectSize struct {
	_ struct{} `type:"structure"`

	// Specifies the minimum object size in Bytes. The value must be a positive
	// number, greater than 0 and less than 5 TB.
	BytesGreaterThan *int64 `type:"long"`

	// Specifies the maximum object size in Bytes. The value must be a positive
	// number, greater than the minimum object size and less than 5 TB.
	BytesLessThan *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchObjectSize) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MatchObjectSize) GoString() string {
	return s.String()
}

// SetBytesGreaterThan sets the BytesGreaterThan field's value.
func (s *MatchObjectSize) SetBytesGreaterThan(v int64) *MatchObjectSize {
	s.BytesGreaterThan = &v
	return s
}

// SetBytesLessThan sets the BytesLessThan field's value.
func (s *MatchObjectSize) SetBytesLessThan(v int64) *MatchObjectSize {
	s.BytesLessThan = &v
	return s
}

// A container that specifies replication metrics-related settings.
type Metrics struct {
	_ struct{} `type:"structure"`

	// A container that specifies the time threshold for emitting the s3:Replication:OperationMissedThreshold
	// event.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	EventThreshold *ReplicationTimeValue `type:"structure"`

	// Specifies whether replication metrics are enabled.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"MetricsStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Metrics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metrics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Metrics"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventThreshold sets the EventThreshold field's value.
func (s *Metrics) SetEventThreshold(v *ReplicationTimeValue) *Metrics {
	s.EventThreshold = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Metrics) SetStatus(v string) *Metrics {
	s.Status = &v
	return s
}

// The Multi-Region Access Point access control policy.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type MultiRegionAccessPointPolicyDocument struct {
	_ struct{} `type:"structure"`

	// The last established policy for the Multi-Region Access Point.
	Established *EstablishedMultiRegionAccessPointPolicy `type:"structure"`

	// The proposed policy for the Multi-Region Access Point.
	Proposed *ProposedMultiRegionAccessPointPolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointPolicyDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointPolicyDocument) GoString() string {
	return s.String()
}

// SetEstablished sets the Established field's value.
func (s *MultiRegionAccessPointPolicyDocument) SetEstablished(v *EstablishedMultiRegionAccessPointPolicy) *MultiRegionAccessPointPolicyDocument {
	s.Established = v
	return s
}

// SetProposed sets the Proposed field's value.
func (s *MultiRegionAccessPointPolicyDocument) SetProposed(v *ProposedMultiRegionAccessPointPolicy) *MultiRegionAccessPointPolicyDocument {
	s.Proposed = v
	return s
}

// Status information for a single Multi-Region Access Point Region.
type MultiRegionAccessPointRegionalResponse struct {
	_ struct{} `type:"structure"`

	// The name of the Region in the Multi-Region Access Point.
	Name *string `min:"1" type:"string"`

	// The current status of the Multi-Region Access Point in this Region.
	RequestStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointRegionalResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointRegionalResponse) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *MultiRegionAccessPointRegionalResponse) SetName(v string) *MultiRegionAccessPointRegionalResponse {
	s.Name = &v
	return s
}

// SetRequestStatus sets the RequestStatus field's value.
func (s *MultiRegionAccessPointRegionalResponse) SetRequestStatus(v string) *MultiRegionAccessPointRegionalResponse {
	s.RequestStatus = &v
	return s
}

// A collection of statuses for a Multi-Region Access Point in the various Regions
// it supports.
type MultiRegionAccessPointReport struct {
	_ struct{} `type:"structure"`

	// The alias for the Multi-Region Access Point. For more information about the
	// distinction between the name and the alias of an Multi-Region Access Point,
	// see Managing Multi-Region Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming).
	Alias *string `type:"string"`

	// When the Multi-Region Access Point create request was received.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the Multi-Region Access Point.
	Name *string `type:"string"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 account. You can enable the configuration options in any combination.
	// For more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	//
	// This data type is not supported for Amazon S3 on Outposts.
	PublicAccessBlock *PublicAccessBlockConfiguration `type:"structure"`

	// A collection of the Regions and buckets associated with the Multi-Region
	// Access Point.
	Regions []*RegionReport `locationNameList:"Region" type:"list"`

	// The current status of the Multi-Region Access Point.
	//
	// CREATING and DELETING are temporary states that exist while the request is
	// propagating and being completed. If a Multi-Region Access Point has a status
	// of PARTIALLY_CREATED, you can retry creation or send a request to delete
	// the Multi-Region Access Point. If a Multi-Region Access Point has a status
	// of PARTIALLY_DELETED, you can retry a delete request to finish the deletion
	// of the Multi-Region Access Point.
	Status *string `type:"string" enum:"MultiRegionAccessPointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointReport) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *MultiRegionAccessPointReport) SetAlias(v string) *MultiRegionAccessPointReport {
	s.Alias = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MultiRegionAccessPointReport) SetCreatedAt(v time.Time) *MultiRegionAccessPointReport {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *MultiRegionAccessPointReport) SetName(v string) *MultiRegionAccessPointReport {
	s.Name = &v
	return s
}

// SetPublicAccessBlock sets the PublicAccessBlock field's value.
func (s *MultiRegionAccessPointReport) SetPublicAccessBlock(v *PublicAccessBlockConfiguration) *MultiRegionAccessPointReport {
	s.PublicAccessBlock = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *MultiRegionAccessPointReport) SetRegions(v []*RegionReport) *MultiRegionAccessPointReport {
	s.Regions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *MultiRegionAccessPointReport) SetStatus(v string) *MultiRegionAccessPointReport {
	s.Status = &v
	return s
}

// A structure for a Multi-Region Access Point that indicates where Amazon S3
// traffic can be routed. Routes can be either active or passive. Active routes
// can process Amazon S3 requests through the Multi-Region Access Point, but
// passive routes are not eligible to process Amazon S3 requests.
//
// Each route contains the Amazon S3 bucket name and the Amazon Web Services
// Region that the bucket is located in. The route also includes the TrafficDialPercentage
// value, which shows whether the bucket and Region are active (indicated by
// a value of 100) or passive (indicated by a value of 0).
type MultiRegionAccessPointRoute struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket for which you'll submit a routing configuration
	// change. Either the Bucket or the Region value must be provided. If both are
	// provided, the bucket must be in the specified Region.
	Bucket *string `min:"3" type:"string"`

	// The Amazon Web Services Region to which you'll be submitting a routing configuration
	// change. Either the Bucket or the Region value must be provided. If both are
	// provided, the bucket must be in the specified Region.
	Region *string `min:"1" type:"string"`

	// The traffic state for the specified bucket or Amazon Web Services Region.
	//
	// A value of 0 indicates a passive state, which means that no new traffic will
	// be routed to the Region.
	//
	// A value of 100 indicates an active state, which means that traffic will be
	// routed to the specified Region.
	//
	// When the routing configuration for a Region is changed from active to passive,
	// any in-progress operations (uploads, copies, deletes, and so on) to the formerly
	// active Region will continue to run to until a final success or failure status
	// is reached.
	//
	// If all Regions in the routing configuration are designated as passive, you'll
	// receive an InvalidRequest error.
	//
	// TrafficDialPercentage is a required field
	TrafficDialPercentage *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiRegionAccessPointRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiRegionAccessPointRoute"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.TrafficDialPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("TrafficDialPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *MultiRegionAccessPointRoute) SetBucket(v string) *MultiRegionAccessPointRoute {
	s.Bucket = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MultiRegionAccessPointRoute) SetRegion(v string) *MultiRegionAccessPointRoute {
	s.Region = &v
	return s
}

// SetTrafficDialPercentage sets the TrafficDialPercentage field's value.
func (s *MultiRegionAccessPointRoute) SetTrafficDialPercentage(v int64) *MultiRegionAccessPointRoute {
	s.TrafficDialPercentage = &v
	return s
}

// The Multi-Region Access Point details that are returned when querying about
// an asynchronous request.
type MultiRegionAccessPointsAsyncResponse struct {
	_ struct{} `type:"structure"`

	// A collection of status information for the different Regions that a Multi-Region
	// Access Point supports.
	Regions []*MultiRegionAccessPointRegionalResponse `locationNameList:"Region" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointsAsyncResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiRegionAccessPointsAsyncResponse) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *MultiRegionAccessPointsAsyncResponse) SetRegions(v []*MultiRegionAccessPointRegionalResponse) *MultiRegionAccessPointsAsyncResponse {
	s.Regions = v
	return s
}

// The container of the noncurrent version expiration.
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies how many noncurrent versions S3 on Outposts will retain. If there
	// are this many more recent noncurrent versions, S3 on Outposts will take the
	// associated action. For more information about noncurrent versions, see Lifecycle
	// configuration elements (https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html)
	// in the Amazon S3 User Guide.
	NewerNoncurrentVersions *int64 `type:"integer"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon S3 User Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// SetNewerNoncurrentVersions sets the NewerNoncurrentVersions field's value.
func (s *NoncurrentVersionExpiration) SetNewerNoncurrentVersions(v int64) *NoncurrentVersionExpiration {
	s.NewerNoncurrentVersions = &v
	return s
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionExpiration) SetNoncurrentDays(v int64) *NoncurrentVersionExpiration {
	s.NoncurrentDays = &v
	return s
}

// The container for the noncurrent version transition.
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates How Long an Object Has Been Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon S3 User Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionTransition) SetNoncurrentDays(v int64) *NoncurrentVersionTransition {
	s.NoncurrentDays = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *NoncurrentVersionTransition) SetStorageClass(v string) *NoncurrentVersionTransition {
	s.StorageClass = &v
	return s
}

// An access point with an attached Lambda function used to access transformed
// data from an Amazon S3 bucket.
type ObjectLambdaAccessPoint struct {
	_ struct{} `type:"structure"`

	// The alias of the Object Lambda Access Point.
	Alias *ObjectLambdaAccessPointAlias `type:"structure"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Specifies the ARN for the Object Lambda Access Point.
	ObjectLambdaAccessPointArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaAccessPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaAccessPoint) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *ObjectLambdaAccessPoint) SetAlias(v *ObjectLambdaAccessPointAlias) *ObjectLambdaAccessPoint {
	s.Alias = v
	return s
}

// SetName sets the Name field's value.
func (s *ObjectLambdaAccessPoint) SetName(v string) *ObjectLambdaAccessPoint {
	s.Name = &v
	return s
}

// SetObjectLambdaAccessPointArn sets the ObjectLambdaAccessPointArn field's value.
func (s *ObjectLambdaAccessPoint) SetObjectLambdaAccessPointArn(v string) *ObjectLambdaAccessPoint {
	s.ObjectLambdaAccessPointArn = &v
	return s
}

// The alias of an Object Lambda Access Point. For more information, see How
// to use a bucket-style alias for your S3 bucket Object Lambda Access Point
// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-use.html#ol-access-points-alias).
type ObjectLambdaAccessPointAlias struct {
	_ struct{} `type:"structure"`

	// The status of the Object Lambda Access Point alias. If the status is PROVISIONING,
	// the Object Lambda Access Point is provisioning the alias and the alias is
	// not ready for use yet. If the status is READY, the Object Lambda Access Point
	// alias is successfully provisioned and ready for use.
	Status *string `min:"2" type:"string" enum:"ObjectLambdaAccessPointAliasStatus"`

	// The alias value of the Object Lambda Access Point.
	Value *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaAccessPointAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaAccessPointAlias) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *ObjectLambdaAccessPointAlias) SetStatus(v string) *ObjectLambdaAccessPointAlias {
	s.Status = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ObjectLambdaAccessPointAlias) SetValue(v string) *ObjectLambdaAccessPointAlias {
	s.Value = &v
	return s
}

// A configuration used when creating an Object Lambda Access Point.
type ObjectLambdaConfiguration struct {
	_ struct{} `type:"structure"`

	// A container for allowed features. Valid inputs are GetObject-Range, GetObject-PartNumber,
	// HeadObject-Range, and HeadObject-PartNumber.
	AllowedFeatures []*string `locationNameList:"AllowedFeature" type:"list" enum:"ObjectLambdaAllowedFeature"`

	// A container for whether the CloudWatch metrics configuration is enabled.
	CloudWatchMetricsEnabled *bool `type:"boolean"`

	// Standard access point associated with the Object Lambda Access Point.
	//
	// SupportingAccessPoint is a required field
	SupportingAccessPoint *string `min:"1" type:"string" required:"true"`

	// A container for transformation configurations for an Object Lambda Access
	// Point.
	//
	// TransformationConfigurations is a required field
	TransformationConfigurations []*ObjectLambdaTransformationConfiguration `locationNameList:"TransformationConfiguration" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectLambdaConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectLambdaConfiguration"}
	if s.SupportingAccessPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("SupportingAccessPoint"))
	}
	if s.SupportingAccessPoint != nil && len(*s.SupportingAccessPoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SupportingAccessPoint", 1))
	}
	if s.TransformationConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformationConfigurations"))
	}
	if s.TransformationConfigurations != nil {
		for i, v := range s.TransformationConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TransformationConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedFeatures sets the AllowedFeatures field's value.
func (s *ObjectLambdaConfiguration) SetAllowedFeatures(v []*string) *ObjectLambdaConfiguration {
	s.AllowedFeatures = v
	return s
}

// SetCloudWatchMetricsEnabled sets the CloudWatchMetricsEnabled field's value.
func (s *ObjectLambdaConfiguration) SetCloudWatchMetricsEnabled(v bool) *ObjectLambdaConfiguration {
	s.CloudWatchMetricsEnabled = &v
	return s
}

// SetSupportingAccessPoint sets the SupportingAccessPoint field's value.
func (s *ObjectLambdaConfiguration) SetSupportingAccessPoint(v string) *ObjectLambdaConfiguration {
	s.SupportingAccessPoint = &v
	return s
}

// SetTransformationConfigurations sets the TransformationConfigurations field's value.
func (s *ObjectLambdaConfiguration) SetTransformationConfigurations(v []*ObjectLambdaTransformationConfiguration) *ObjectLambdaConfiguration {
	s.TransformationConfigurations = v
	return s
}

// A container for AwsLambdaTransformation.
type ObjectLambdaContentTransformation struct {
	_ struct{} `type:"structure"`

	// A container for an Lambda function.
	AwsLambda *AwsLambdaTransformation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaContentTransformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaContentTransformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectLambdaContentTransformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectLambdaContentTransformation"}
	if s.AwsLambda != nil {
		if err := s.AwsLambda.Validate(); err != nil {
			invalidParams.AddNested("AwsLambda", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsLambda sets the AwsLambda field's value.
func (s *ObjectLambdaContentTransformation) SetAwsLambda(v *AwsLambdaTransformation) *ObjectLambdaContentTransformation {
	s.AwsLambda = v
	return s
}

// A configuration used when creating an Object Lambda Access Point transformation.
type ObjectLambdaTransformationConfiguration struct {
	_ struct{} `type:"structure"`

	// A container for the action of an Object Lambda Access Point configuration.
	// Valid inputs are GetObject, ListObjects, HeadObject, and ListObjectsV2.
	//
	// Actions is a required field
	Actions []*string `locationNameList:"Action" type:"list" required:"true" enum:"ObjectLambdaTransformationConfigurationAction"`

	// A container for the content transformation of an Object Lambda Access Point
	// configuration.
	//
	// ContentTransformation is a required field
	ContentTransformation *ObjectLambdaContentTransformation `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaTransformationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ObjectLambdaTransformationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectLambdaTransformationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectLambdaTransformationConfiguration"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.ContentTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentTransformation"))
	}
	if s.ContentTransformation != nil {
		if err := s.ContentTransformation.Validate(); err != nil {
			invalidParams.AddNested("ContentTransformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ObjectLambdaTransformationConfiguration) SetActions(v []*string) *ObjectLambdaTransformationConfiguration {
	s.Actions = v
	return s
}

// SetContentTransformation sets the ContentTransformation field's value.
func (s *ObjectLambdaTransformationConfiguration) SetContentTransformation(v *ObjectLambdaContentTransformation) *ObjectLambdaTransformationConfiguration {
	s.ContentTransformation = v
	return s
}

// Indicates whether this access point policy is public. For more information
// about how Amazon S3 evaluates policies to determine whether they are public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon S3 User Guide.
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyStatus) GoString() string {
	return s.String()
}

// SetIsPublic sets the IsPublic field's value.
func (s *PolicyStatus) SetIsPublic(v bool) *PolicyStatus {
	s.IsPublic = &v
	return s
}

// A container for the prefix-level configuration.
type PrefixLevel struct {
	_ struct{} `type:"structure"`

	// A container for the prefix-level storage metrics for S3 Storage Lens.
	//
	// StorageMetrics is a required field
	StorageMetrics *PrefixLevelStorageMetrics `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefixLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefixLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefixLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefixLevel"}
	if s.StorageMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageMetrics"))
	}
	if s.StorageMetrics != nil {
		if err := s.StorageMetrics.Validate(); err != nil {
			invalidParams.AddNested("StorageMetrics", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStorageMetrics sets the StorageMetrics field's value.
func (s *PrefixLevel) SetStorageMetrics(v *PrefixLevelStorageMetrics) *PrefixLevel {
	s.StorageMetrics = v
	return s
}

// A container for the prefix-level storage metrics for S3 Storage Lens.
type PrefixLevelStorageMetrics struct {
	_ struct{} `type:"structure"`

	// A container for whether prefix-level storage metrics are enabled.
	IsEnabled *bool `type:"boolean"`

	SelectionCriteria *SelectionCriteria `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefixLevelStorageMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrefixLevelStorageMetrics) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrefixLevelStorageMetrics) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrefixLevelStorageMetrics"}
	if s.SelectionCriteria != nil {
		if err := s.SelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SelectionCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *PrefixLevelStorageMetrics) SetIsEnabled(v bool) *PrefixLevelStorageMetrics {
	s.IsEnabled = &v
	return s
}

// SetSelectionCriteria sets the SelectionCriteria field's value.
func (s *PrefixLevelStorageMetrics) SetSelectionCriteria(v *SelectionCriteria) *PrefixLevelStorageMetrics {
	s.SelectionCriteria = v
	return s
}

// The proposed access control policy for the Multi-Region Access Point.
//
// When you update the policy, the update is first listed as the proposed policy.
// After the update is finished and all Regions have been updated, the proposed
// policy is listed as the established policy. If both policies have the same
// version number, the proposed policy is the established policy.
type ProposedMultiRegionAccessPointPolicy struct {
	_ struct{} `type:"structure"`

	// The details of the proposed policy.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProposedMultiRegionAccessPointPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProposedMultiRegionAccessPointPolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *ProposedMultiRegionAccessPointPolicy) SetPolicy(v string) *ProposedMultiRegionAccessPointPolicy {
	s.Policy = &v
	return s
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 account. You can enable the configuration options in any combination.
// For more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon S3 User Guide.
//
// This data type is not supported for Amazon S3 on Outposts.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	//    * PutBucketAcl and PutObjectAcl calls fail if the specified ACL is public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	//
	// This property is not supported for Amazon S3 on Outposts.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for buckets
	// in this account. Setting this element to TRUE causes Amazon S3 to reject
	// calls to PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	//
	// This property is not supported for Amazon S3 on Outposts.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public
	// ACLs on buckets in this account and any objects that they contain.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	//
	// This property is not supported for Amazon S3 on Outposts.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets
	// with public policies to only Amazon Web Service principals and authorized
	// users within this account.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	//
	// This property is not supported for Amazon S3 on Outposts.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublicAccessBlockConfiguration) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicPolicy(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetIgnorePublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *PublicAccessBlockConfiguration) SetRestrictPublicBuckets(v bool) *PublicAccessBlockConfiguration {
	s.RestrictPublicBuckets = &v
	return s
}

type PutAccessGrantsInstanceResourcePolicyInput struct {
	_ struct{} `locationName:"PutAccessGrantsInstanceResourcePolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The ID of the Amazon Web Services account that is making this request.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Organization of the resource policy of the S3 Access Grants instance.
	Organization *string `min:"12" type:"string"`

	// The resource policy of the S3 Access Grants instance that you are updating.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessGrantsInstanceResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessGrantsInstanceResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessGrantsInstanceResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessGrantsInstanceResourcePolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Organization != nil && len(*s.Organization) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("Organization", 12))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessGrantsInstanceResourcePolicyInput) SetAccountId(v string) *PutAccessGrantsInstanceResourcePolicyInput {
	s.AccountId = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *PutAccessGrantsInstanceResourcePolicyInput) SetOrganization(v string) *PutAccessGrantsInstanceResourcePolicyInput {
	s.Organization = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessGrantsInstanceResourcePolicyInput) SetPolicy(v string) *PutAccessGrantsInstanceResourcePolicyInput {
	s.Policy = &v
	return s
}

func (s *PutAccessGrantsInstanceResourcePolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutAccessGrantsInstanceResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when you created the S3 Access Grants instance resource
	// policy.
	CreatedAt *time.Time `type:"timestamp"`

	// The Organization of the resource policy of the S3 Access Grants instance.
	Organization *string `min:"12" type:"string"`

	// The updated resource policy of the S3 Access Grants instance.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessGrantsInstanceResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessGrantsInstanceResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PutAccessGrantsInstanceResourcePolicyOutput) SetCreatedAt(v time.Time) *PutAccessGrantsInstanceResourcePolicyOutput {
	s.CreatedAt = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *PutAccessGrantsInstanceResourcePolicyOutput) SetOrganization(v string) *PutAccessGrantsInstanceResourcePolicyOutput {
	s.Organization = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessGrantsInstanceResourcePolicyOutput) SetPolicy(v string) *PutAccessGrantsInstanceResourcePolicyOutput {
	s.Policy = &v
	return s
}

type PutAccessPointConfigurationForObjectLambdaInput struct {
	_ struct{} `locationName:"PutAccessPointConfigurationForObjectLambdaRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Object Lambda Access Point configuration document.
	//
	// Configuration is a required field
	Configuration *ObjectLambdaConfiguration `type:"structure" required:"true"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointConfigurationForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointConfigurationForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointConfigurationForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessPointConfigurationForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessPointConfigurationForObjectLambdaInput) SetAccountId(v string) *PutAccessPointConfigurationForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *PutAccessPointConfigurationForObjectLambdaInput) SetConfiguration(v *ObjectLambdaConfiguration) *PutAccessPointConfigurationForObjectLambdaInput {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessPointConfigurationForObjectLambdaInput) SetName(v string) *PutAccessPointConfigurationForObjectLambdaInput {
	s.Name = &v
	return s
}

func (s *PutAccessPointConfigurationForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutAccessPointConfigurationForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointConfigurationForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointConfigurationForObjectLambdaOutput) GoString() string {
	return s.String()
}

type PutAccessPointPolicyForObjectLambdaInput struct {
	_ struct{} `locationName:"PutAccessPointPolicyForObjectLambdaRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The account ID for the account that owns the specified Object Lambda Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the Object Lambda Access Point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Object Lambda Access Point resource policy document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyForObjectLambdaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyForObjectLambdaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointPolicyForObjectLambdaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessPointPolicyForObjectLambdaInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessPointPolicyForObjectLambdaInput) SetAccountId(v string) *PutAccessPointPolicyForObjectLambdaInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessPointPolicyForObjectLambdaInput) SetName(v string) *PutAccessPointPolicyForObjectLambdaInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessPointPolicyForObjectLambdaInput) SetPolicy(v string) *PutAccessPointPolicyForObjectLambdaInput {
	s.Policy = &v
	return s
}

func (s *PutAccessPointPolicyForObjectLambdaInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutAccessPointPolicyForObjectLambdaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyForObjectLambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyForObjectLambdaOutput) GoString() string {
	return s.String()
}

type PutAccessPointPolicyInput struct {
	_ struct{} `locationName:"PutAccessPointPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for owner of the bucket associated with
	// the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point that you want to associate with the specified
	// policy.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the access point accessed in the
	// format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>.
	// For example, to access the access point reports-ap through Outpost my-outpost
	// owned by account 123456789012 in Region us-west-2, use the URL encoding of
	// arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap.
	// The value must be URL encoded.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The policy that you want to apply to the specified access point. For more
	// information about access point policies, see Managing data access with Amazon
	// S3 access points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessPointPolicyInput) SetAccountId(v string) *PutAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessPointPolicyInput) SetName(v string) *PutAccessPointPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessPointPolicyInput) SetPolicy(v string) *PutAccessPointPolicyInput {
	s.Policy = &v
	return s
}

func (s *PutAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutAccessPointPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	return parseEndpointARN(*s.Name)
}

func (s *PutAccessPointPolicyInput) hasEndpointARN() bool {
	if s.Name == nil {
		return false
	}
	return arn.IsARN(*s.Name)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutAccessPointPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Name == nil {
		return nil, fmt.Errorf("member Name is nil")
	}
	s.Name = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutAccessPointPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"PutBucketLifecycleConfigurationRequest" type:"structure" payload:"LifecycleConfiguration"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket for which to set the configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Container for lifecycle rules. You can add as many as 1,000 rules.
	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketLifecycleConfigurationInput) SetAccountId(v string) *PutBucketLifecycleConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleConfigurationInput) SetBucket(v string) *PutBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleConfigurationInput) SetLifecycleConfiguration(v *LifecycleConfiguration) *PutBucketLifecycleConfigurationInput {
	s.LifecycleConfiguration = v
	return s
}

func (s *PutBucketLifecycleConfigurationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketLifecycleConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketLifecycleConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketLifecycleConfigurationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketLifecycleConfigurationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketPolicyInput struct {
	_ struct{} `locationName:"PutBucketPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Set this parameter to true to confirm that you want to remove your permissions
	// to change this bucket policy in the future.
	//
	// This is not supported by Amazon S3 on Outposts buckets.
	ConfirmRemoveSelfBucketAccess *bool `location:"header" locationName:"x-amz-confirm-remove-self-bucket-access" type:"boolean"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketPolicyInput) SetAccountId(v string) *PutBucketPolicyInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketPolicyInput) SetBucket(v string) *PutBucketPolicyInput {
	s.Bucket = &v
	return s
}

// SetConfirmRemoveSelfBucketAccess sets the ConfirmRemoveSelfBucketAccess field's value.
func (s *PutBucketPolicyInput) SetConfirmRemoveSelfBucketAccess(v bool) *PutBucketPolicyInput {
	s.ConfirmRemoveSelfBucketAccess = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutBucketPolicyInput) SetPolicy(v string) *PutBucketPolicyInput {
	s.Policy = &v
	return s
}

func (s *PutBucketPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketPolicyInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketPolicyInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketPolicyInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketPolicyInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketReplicationInput struct {
	_ struct{} `locationName:"PutBucketReplicationRequest" type:"structure" payload:"ReplicationConfiguration"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// Specifies the S3 on Outposts bucket to set the configuration for.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// A container for one or more replication rules. A replication configuration
	// must have at least one rule and you can add up to 100 rules. The maximum
	// size of a replication configuration is 128 KB.
	//
	// ReplicationConfiguration is a required field
	ReplicationConfiguration *ReplicationConfiguration `locationName:"ReplicationConfiguration" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketReplicationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.ReplicationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfiguration"))
	}
	if s.ReplicationConfiguration != nil {
		if err := s.ReplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ReplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketReplicationInput) SetAccountId(v string) *PutBucketReplicationInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketReplicationInput) SetBucket(v string) *PutBucketReplicationInput {
	s.Bucket = &v
	return s
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *PutBucketReplicationInput) SetReplicationConfiguration(v *ReplicationConfiguration) *PutBucketReplicationInput {
	s.ReplicationConfiguration = v
	return s
}

func (s *PutBucketReplicationInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketReplicationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketReplicationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketReplicationInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketReplicationInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketReplicationOutput) GoString() string {
	return s.String()
}

type PutBucketTaggingInput struct {
	_ struct{} `locationName:"PutBucketTaggingRequest" type:"structure" payload:"Tagging"`

	// The Amazon Web Services account ID of the Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bucket.
	//
	// For using this parameter with Amazon S3 on Outposts with the REST API, you
	// must specify the name and the x-amz-outpost-id as well.
	//
	// For using this parameter with S3 on Outposts with the Amazon Web Services
	// SDK and CLI, you must specify the ARN of the bucket accessed in the format
	// arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>.
	// For example, to access the bucket reports through Outpost my-outpost owned
	// by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports.
	// The value must be URL encoded.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketTaggingInput) SetAccountId(v string) *PutBucketTaggingInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketTaggingInput) SetBucket(v string) *PutBucketTaggingInput {
	s.Bucket = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutBucketTaggingInput) SetTagging(v *Tagging) *PutBucketTaggingInput {
	s.Tagging = v
	return s
}

func (s *PutBucketTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketTaggingInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketTaggingInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketTaggingInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketTaggingInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

type PutBucketVersioningInput struct {
	_ struct{} `locationName:"PutBucketVersioningRequest" type:"structure" payload:"VersioningConfiguration"`

	// The Amazon Web Services account ID of the S3 on Outposts bucket.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The S3 on Outposts bucket to set the versioning state for.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// The root-level tag for the VersioningConfiguration parameters.
	//
	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketVersioningInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.VersioningConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutBucketVersioningInput) SetAccountId(v string) *PutBucketVersioningInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketVersioningInput) SetBucket(v string) *PutBucketVersioningInput {
	s.Bucket = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *PutBucketVersioningInput) SetMFA(v string) *PutBucketVersioningInput {
	s.MFA = &v
	return s
}

// SetVersioningConfiguration sets the VersioningConfiguration field's value.
func (s *PutBucketVersioningInput) SetVersioningConfiguration(v *VersioningConfiguration) *PutBucketVersioningInput {
	s.VersioningConfiguration = v
	return s
}

func (s *PutBucketVersioningInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

func (s *PutBucketVersioningInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketVersioningInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

// updateArnableField updates the value of the input field that
// takes an ARN as an input. This method is useful to backfill
// the parsed resource name from ARN into the input member.
// It returns a pointer to a modified copy of input and an error.
// Note that original input is not modified.
func (s PutBucketVersioningInput) updateArnableField(v string) (interface{}, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	s.Bucket = aws.String(v)
	return &s, nil
}

// updateAccountID returns a pointer to a modified copy of input,
// if account id is not provided, we update the account id in modified input
// if account id is provided, but doesn't match with the one in ARN, we throw an error
// if account id is not updated, we return nil. Note that original input is not modified.
func (s PutBucketVersioningInput) updateAccountID(accountId string) (interface{}, error) {
	if s.AccountId == nil {
		s.AccountId = aws.String(accountId)
		return &s, nil
	} else if *s.AccountId != accountId {
		return &s, fmt.Errorf("Account ID mismatch, the Account ID cannot be specified in an ARN and in the accountId field")
	}
	return nil, nil
}

type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

type PutJobTaggingInput struct {
	_ struct{} `locationName:"PutJobTaggingRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID associated with the S3 Batch Operations
	// job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the S3 Batch Operations job whose tags you want to replace.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The set of tags to associate with the S3 Batch Operations job.
	//
	// Tags is a required field
	Tags []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutJobTaggingInput) SetAccountId(v string) *PutJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobTaggingInput) SetJobId(v string) *PutJobTaggingInput {
	s.JobId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutJobTaggingInput) SetTags(v []*S3Tag) *PutJobTaggingInput {
	s.Tags = v
	return s
}

func (s *PutJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutJobTaggingOutput) GoString() string {
	return s.String()
}

type PutMultiRegionAccessPointPolicyInput struct {
	_ struct{} `locationName:"PutMultiRegionAccessPointPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The Amazon Web Services account ID for the owner of the Multi-Region Access
	// Point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" requ