// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package sagemakermetricsiface provides an interface to enable mocking the Amazon SageMaker Metrics Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package sagemakermetricsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sagemakermetrics"
)

// SageMakerMetricsAPI provides an interface to enable mocking the
// sagemakermetrics.SageMakerMetrics service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon SageMaker Metrics Service.
//	func myFunc(svc sagemakermetricsiface.SageMakerMetricsAPI) bool {
//	    // Make svc.BatchPutMetrics request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := sagemakermetrics.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSageMakerMetricsClient struct {
//	    sagemakermetricsiface.SageMakerMetricsAPI
//	}
//	func (m *mockSageMakerMetricsClient) BatchPutMetrics(input *sagemakermetrics.BatchPutMetricsInput) (*sagemakermetrics.BatchPutMetricsOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSageMakerMetricsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SageMakerMetricsAPI interface {
	BatchPutMetrics(*sagemakermetrics.BatchPutMetricsInput) (*sagemakermetrics.BatchPutMetricsOutput, error)
	BatchPutMetricsWithContext(aws.Context, *sagemakermetrics.BatchPutMetricsInput, ...request.Option) (*sagemakermetrics.BatchPutMetricsOutput, error)
	BatchPutMetricsRequest(*sagemakermetrics.BatchPutMetricsInput) (*request.Request, *sagemakermetrics.BatchPutMetricsOutput)
}

var _ SageMakerMetricsAPI = (*sagemakermetrics.SageMakerMetrics)(nil)
