package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// LocationClient is the client for the Location methods of the Batch service.
type LocationClient struct {
	ManagementClient
}

// NewLocationClient creates an instance of the LocationClient client.
func NewLocationClient(subscriptionID string) LocationClient {
	return NewLocationClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLocationClientWithBaseURI creates an instance of the LocationClient
// client.
func NewLocationClientWithBaseURI(baseURI string, subscriptionID string) LocationClient {
	return LocationClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetQuotas gets the Batch service quotas for the specified subscription at
// the given location.
//
// locationName is the desired region for the quotas.
func (client LocationClient) GetQuotas(locationName string) (result LocationQuota, err error) {
	req, err := client.GetQuotasPreparer(locationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetQuotasSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", resp, "Failure sending request")
		return
	}

	result, err = client.GetQuotasResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.LocationClient", "GetQuotas", resp, "Failure responding to request")
	}

	return
}

// GetQuotasPreparer prepares the GetQuotas request.
func (client LocationClient) GetQuotasPreparer(locationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetQuotasSender sends the GetQuotas request. The method will close the
// http.Response Body if it receives an error.
func (client LocationClient) GetQuotasSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetQuotasResponder handles the response to the GetQuotas request. The method always
// closes the http.Response Body.
func (client LocationClient) GetQuotasResponder(resp *http.Response) (result LocationQuota, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
