package recoveryservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// RS0 specifies the rs0 state for sku name.
	RS0 SkuName = "RS0"
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// TriggerType enumerates the values for trigger type.
type TriggerType string

const (
	// ForcedUpgrade specifies the forced upgrade state for trigger type.
	ForcedUpgrade TriggerType = "ForcedUpgrade"
	// UserTriggered specifies the user triggered state for trigger type.
	UserTriggered TriggerType = "UserTriggered"
)

// VaultUpgradeState enumerates the values for vault upgrade state.
type VaultUpgradeState string

const (
	// Failed specifies the failed state for vault upgrade state.
	Failed VaultUpgradeState = "Failed"
	// InProgress specifies the in progress state for vault upgrade state.
	InProgress VaultUpgradeState = "InProgress"
	// Unknown specifies the unknown state for vault upgrade state.
	Unknown VaultUpgradeState = "Unknown"
	// Upgraded specifies the upgraded state for vault upgrade state.
	Upgraded VaultUpgradeState = "Upgraded"
)

// ClientDiscoveryDisplay is localized display information of an operation.
type ClientDiscoveryDisplay struct {
	Provider    *string `json:"Provider,omitempty"`
	Resource    *string `json:"Resource,omitempty"`
	Operation   *string `json:"Operation,omitempty"`
	Description *string `json:"Description,omitempty"`
}

// ClientDiscoveryForLogSpecification is log specification for the operation.
type ClientDiscoveryForLogSpecification struct {
	Name         *string    `json:"name,omitempty"`
	DisplayName  *string    `json:"displayName,omitempty"`
	BlobDuration *date.Time `json:"blobDuration,omitempty"`
}

// ClientDiscoveryForServiceSpecification is operation properties.
type ClientDiscoveryForServiceSpecification struct {
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryProperties is operation properties.
type ClientDiscoveryProperties struct {
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryResponse is list of available operations.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	Value             *[]ClientDiscoveryValueForSingleAPI `json:"Value,omitempty"`
	NextLink          *string                             `json:"NextLink,omitempty"`
}

// ClientDiscoveryResponsePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ClientDiscoveryResponse) ClientDiscoveryResponsePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ClientDiscoveryValueForSingleAPI is available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	Name                       *string                 `json:"Name,omitempty"`
	Display                    *ClientDiscoveryDisplay `json:"Display,omitempty"`
	Origin                     *string                 `json:"Origin,omitempty"`
	*ClientDiscoveryProperties `json:"Properties,omitempty"`
}

// Resource is aRM Resource.
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
	ETag *string `json:"eTag,omitempty"`
}

// Sku is identifies the unique system identifier for each Azure resource.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
}

// TrackedResource is tracked resource with location.
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	ETag     *string             `json:"eTag,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// UpgradeDetails is details for upgrading vault.
type UpgradeDetails struct {
	OperationID        *string           `json:"operationId,omitempty"`
	StartTimeUtc       *date.Time        `json:"startTimeUtc,omitempty"`
	LastUpdatedTimeUtc *date.Time        `json:"lastUpdatedTimeUtc,omitempty"`
	EndTimeUtc         *date.Time        `json:"endTimeUtc,omitempty"`
	Status             VaultUpgradeState `json:"status,omitempty"`
	Message            *string           `json:"message,omitempty"`
	TriggerType        TriggerType       `json:"triggerType,omitempty"`
	UpgradedResourceID *string           `json:"upgradedResourceId,omitempty"`
	PreviousResourceID *string           `json:"previousResourceId,omitempty"`
}

// Vault is resource information, as returned by the resource provider.
type Vault struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *VaultProperties    `json:"properties,omitempty"`
	Sku               *Sku                `json:"sku,omitempty"`
}

// VaultExtendedInfo is vault extended information.
type VaultExtendedInfo struct {
	IntegrityKey            *string `json:"integrityKey,omitempty"`
	EncryptionKey           *string `json:"encryptionKey,omitempty"`
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	Algorithm               *string `json:"algorithm,omitempty"`
}

// VaultExtendedInfoResource is vault extended information.
type VaultExtendedInfoResource struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	Type               *string `json:"type,omitempty"`
	ETag               *string `json:"eTag,omitempty"`
	*VaultExtendedInfo `json:"properties,omitempty"`
}

// VaultList is the response model for a list of Vaults.
type VaultList struct {
	autorest.Response `json:"-"`
	Value             *[]Vault `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// VaultProperties is properties of the vault.
type VaultProperties struct {
	ProvisioningState *string         `json:"provisioningState,omitempty"`
	UpgradeDetails    *UpgradeDetails `json:"upgradeDetails,omitempty"`
}
