package reservationsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/reservations/mgmt/2018-06-01/reservations"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	GetAppliedReservationList(ctx context.Context, subscriptionID string) (result reservations.AppliedReservations, err error)
	GetCatalog(ctx context.Context, subscriptionID string, reservedResourceType string, location string) (result reservations.ListCatalog, err error)
}

var _ BaseClientAPI = (*reservations.BaseClient)(nil)

// OrderClientAPI contains the set of methods on the OrderClient type.
type OrderClientAPI interface {
	Get(ctx context.Context, reservationOrderID string) (result reservations.OrderResponse, err error)
	List(ctx context.Context) (result reservations.OrderListPage, err error)
	ListComplete(ctx context.Context) (result reservations.OrderListIterator, err error)
}

var _ OrderClientAPI = (*reservations.OrderClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Get(ctx context.Context, reservationID string, reservationOrderID string) (result reservations.Response, err error)
	List(ctx context.Context, reservationOrderID string) (result reservations.ListPage, err error)
	ListComplete(ctx context.Context, reservationOrderID string) (result reservations.ListIterator, err error)
	ListRevisions(ctx context.Context, reservationID string, reservationOrderID string) (result reservations.ListPage, err error)
	ListRevisionsComplete(ctx context.Context, reservationID string, reservationOrderID string) (result reservations.ListIterator, err error)
	Merge(ctx context.Context, reservationOrderID string, body reservations.MergeRequest) (result reservations.ReservationMergeFuture, err error)
	Split(ctx context.Context, reservationOrderID string, body reservations.SplitRequest) (result reservations.SplitFuture, err error)
	Update(ctx context.Context, reservationOrderID string, reservationID string, parameters reservations.Patch) (result reservations.ReservationUpdateFuture, err error)
}

var _ ClientAPI = (*reservations.Client)(nil)

// OperationClientAPI contains the set of methods on the OperationClient type.
type OperationClientAPI interface {
	List(ctx context.Context) (result reservations.OperationListPage, err error)
	ListComplete(ctx context.Context) (result reservations.OperationListIterator, err error)
}

var _ OperationClientAPI = (*reservations.OperationClient)(nil)
