package storsimpleapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/storsimple8000series/mgmt/2017-06-01/storsimple"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result storsimple.AvailableProviderOperationListPage, err error)
	ListComplete(ctx context.Context) (result storsimple.AvailableProviderOperationListIterator, err error)
}

var _ OperationsClientAPI = (*storsimple.OperationsClient)(nil)

// ManagersClientAPI contains the set of methods on the ManagersClient type.
type ManagersClientAPI interface {
	CreateExtendedInfo(ctx context.Context, parameters storsimple.ManagerExtendedInfo, resourceGroupName string, managerName string) (result storsimple.ManagerExtendedInfo, err error)
	CreateOrUpdate(ctx context.Context, parameters storsimple.Manager, resourceGroupName string, managerName string) (result storsimple.Manager, err error)
	Delete(ctx context.Context, resourceGroupName string, managerName string) (result autorest.Response, err error)
	DeleteExtendedInfo(ctx context.Context, resourceGroupName string, managerName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.Manager, err error)
	GetActivationKey(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.Key, err error)
	GetDevicePublicEncryptionKey(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.PublicKey, err error)
	GetEncryptionSettings(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.EncryptionSettings, err error)
	GetExtendedInfo(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.ManagerExtendedInfo, err error)
	GetPublicEncryptionKey(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.SymmetricEncryptedSecret, err error)
	List(ctx context.Context) (result storsimple.ManagerList, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result storsimple.ManagerList, err error)
	ListFeatureSupportStatus(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.FeatureList, err error)
	ListMetricDefinition(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.MetricDefinitionList, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.MetricList, err error)
	RegenerateActivationKey(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.Key, err error)
	Update(ctx context.Context, parameters storsimple.ManagerPatch, resourceGroupName string, managerName string) (result storsimple.Manager, err error)
	UpdateExtendedInfo(ctx context.Context, parameters storsimple.ManagerExtendedInfo, resourceGroupName string, managerName string, ifMatch string) (result storsimple.ManagerExtendedInfo, err error)
}

var _ ManagersClientAPI = (*storsimple.ManagersClient)(nil)

// AccessControlRecordsClientAPI contains the set of methods on the AccessControlRecordsClient type.
type AccessControlRecordsClientAPI interface {
	CreateOrUpdate(ctx context.Context, accessControlRecordName string, parameters storsimple.AccessControlRecord, resourceGroupName string, managerName string) (result storsimple.AccessControlRecordsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, accessControlRecordName string, resourceGroupName string, managerName string) (result storsimple.AccessControlRecordsDeleteFuture, err error)
	Get(ctx context.Context, accessControlRecordName string, resourceGroupName string, managerName string) (result storsimple.AccessControlRecord, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.AccessControlRecordList, err error)
}

var _ AccessControlRecordsClientAPI = (*storsimple.AccessControlRecordsClient)(nil)

// AlertsClientAPI contains the set of methods on the AlertsClient type.
type AlertsClientAPI interface {
	Clear(ctx context.Context, parameters storsimple.ClearAlertRequest, resourceGroupName string, managerName string) (result autorest.Response, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.AlertListPage, err error)
	ListByManagerComplete(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.AlertListIterator, err error)
	SendTestEmail(ctx context.Context, deviceName string, parameters storsimple.SendTestAlertEmailRequest, resourceGroupName string, managerName string) (result autorest.Response, err error)
}

var _ AlertsClientAPI = (*storsimple.AlertsClient)(nil)

// BandwidthSettingsClientAPI contains the set of methods on the BandwidthSettingsClient type.
type BandwidthSettingsClientAPI interface {
	CreateOrUpdate(ctx context.Context, bandwidthSettingName string, parameters storsimple.BandwidthSetting, resourceGroupName string, managerName string) (result storsimple.BandwidthSettingsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, bandwidthSettingName string, resourceGroupName string, managerName string) (result storsimple.BandwidthSettingsDeleteFuture, err error)
	Get(ctx context.Context, bandwidthSettingName string, resourceGroupName string, managerName string) (result storsimple.BandwidthSetting, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.BandwidthSettingList, err error)
}

var _ BandwidthSettingsClientAPI = (*storsimple.BandwidthSettingsClient)(nil)

// CloudAppliancesClientAPI contains the set of methods on the CloudAppliancesClient type.
type CloudAppliancesClientAPI interface {
	ListSupportedConfigurations(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.CloudApplianceConfigurationList, err error)
	Provision(ctx context.Context, parameters storsimple.CloudAppliance, resourceGroupName string, managerName string) (result storsimple.CloudAppliancesProvisionFuture, err error)
}

var _ CloudAppliancesClientAPI = (*storsimple.CloudAppliancesClient)(nil)

// DevicesClientAPI contains the set of methods on the DevicesClient type.
type DevicesClientAPI interface {
	AuthorizeForServiceEncryptionKeyRollover(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result autorest.Response, err error)
	Configure(ctx context.Context, parameters storsimple.ConfigureDeviceRequest, resourceGroupName string, managerName string) (result storsimple.DevicesConfigureFuture, err error)
	Deactivate(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.DevicesDeactivateFuture, err error)
	Delete(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.DevicesDeleteFuture, err error)
	Failover(ctx context.Context, sourceDeviceName string, parameters storsimple.FailoverRequest, resourceGroupName string, managerName string) (result storsimple.DevicesFailoverFuture, err error)
	Get(ctx context.Context, deviceName string, resourceGroupName string, managerName string, expand string) (result storsimple.Device, err error)
	GetUpdateSummary(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.Updates, err error)
	InstallUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.DevicesInstallUpdatesFuture, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string, expand string) (result storsimple.DeviceList, err error)
	ListFailoverSets(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.FailoverSetsList, err error)
	ListFailoverTargets(ctx context.Context, sourceDeviceName string, parameters storsimple.ListFailoverTargetsRequest, resourceGroupName string, managerName string) (result storsimple.FailoverTargetsList, err error)
	ListMetricDefinition(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.MetricDefinitionList, err error)
	ListMetrics(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string) (result storsimple.MetricList, err error)
	ScanForUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.DevicesScanForUpdatesFuture, err error)
	Update(ctx context.Context, deviceName string, parameters storsimple.DevicePatch, resourceGroupName string, managerName string) (result storsimple.Device, err error)
}

var _ DevicesClientAPI = (*storsimple.DevicesClient)(nil)

// DeviceSettingsClientAPI contains the set of methods on the DeviceSettingsClient type.
type DeviceSettingsClientAPI interface {
	CreateOrUpdateAlertSettings(ctx context.Context, deviceName string, parameters storsimple.AlertSettings, resourceGroupName string, managerName string) (result storsimple.DeviceSettingsCreateOrUpdateAlertSettingsFuture, err error)
	CreateOrUpdateTimeSettings(ctx context.Context, deviceName string, parameters storsimple.TimeSettings, resourceGroupName string, managerName string) (result storsimple.DeviceSettingsCreateOrUpdateTimeSettingsFuture, err error)
	GetAlertSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.AlertSettings, err error)
	GetNetworkSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.NetworkSettings, err error)
	GetSecuritySettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.SecuritySettings, err error)
	GetTimeSettings(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.TimeSettings, err error)
	SyncRemotemanagementCertificate(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.DeviceSettingsSyncRemotemanagementCertificateFuture, err error)
	UpdateNetworkSettings(ctx context.Context, deviceName string, parameters storsimple.NetworkSettingsPatch, resourceGroupName string, managerName string) (result storsimple.DeviceSettingsUpdateNetworkSettingsFuture, err error)
	UpdateSecuritySettings(ctx context.Context, deviceName string, parameters storsimple.SecuritySettingsPatch, resourceGroupName string, managerName string) (result storsimple.DeviceSettingsUpdateSecuritySettingsFuture, err error)
}

var _ DeviceSettingsClientAPI = (*storsimple.DeviceSettingsClient)(nil)

// BackupPoliciesClientAPI contains the set of methods on the BackupPoliciesClient type.
type BackupPoliciesClientAPI interface {
	BackupNow(ctx context.Context, deviceName string, backupPolicyName string, backupType string, resourceGroupName string, managerName string) (result storsimple.BackupPoliciesBackupNowFuture, err error)
	CreateOrUpdate(ctx context.Context, deviceName string, backupPolicyName string, parameters storsimple.BackupPolicy, resourceGroupName string, managerName string) (result storsimple.BackupPoliciesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, deviceName string, backupPolicyName string, resourceGroupName string, managerName string) (result storsimple.BackupPoliciesDeleteFuture, err error)
	Get(ctx context.Context, deviceName string, backupPolicyName string, resourceGroupName string, managerName string) (result storsimple.BackupPolicy, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.BackupPolicyList, err error)
}

var _ BackupPoliciesClientAPI = (*storsimple.BackupPoliciesClient)(nil)

// BackupSchedulesClientAPI contains the set of methods on the BackupSchedulesClient type.
type BackupSchedulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, deviceName string, backupPolicyName string, backupScheduleName string, parameters storsimple.BackupSchedule, resourceGroupName string, managerName string) (result storsimple.BackupSchedulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, deviceName string, backupPolicyName string, backupScheduleName string, resourceGroupName string, managerName string) (result storsimple.BackupSchedulesDeleteFuture, err error)
	Get(ctx context.Context, deviceName string, backupPolicyName string, backupScheduleName string, resourceGroupName string, managerName string) (result storsimple.BackupSchedule, err error)
	ListByBackupPolicy(ctx context.Context, deviceName string, backupPolicyName string, resourceGroupName string, managerName string) (result storsimple.BackupScheduleList, err error)
}

var _ BackupSchedulesClientAPI = (*storsimple.BackupSchedulesClient)(nil)

// BackupsClientAPI contains the set of methods on the BackupsClient type.
type BackupsClientAPI interface {
	Clone(ctx context.Context, deviceName string, backupName string, backupElementName string, parameters storsimple.CloneRequest, resourceGroupName string, managerName string) (result storsimple.BackupsCloneFuture, err error)
	Delete(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string) (result storsimple.BackupsDeleteFuture, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string) (result storsimple.BackupListPage, err error)
	ListByDeviceComplete(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string) (result storsimple.BackupListIterator, err error)
	Restore(ctx context.Context, deviceName string, backupName string, resourceGroupName string, managerName string) (result storsimple.BackupsRestoreFuture, err error)
}

var _ BackupsClientAPI = (*storsimple.BackupsClient)(nil)

// HardwareComponentGroupsClientAPI contains the set of methods on the HardwareComponentGroupsClient type.
type HardwareComponentGroupsClientAPI interface {
	ChangeControllerPowerState(ctx context.Context, deviceName string, hardwareComponentGroupName string, parameters storsimple.ControllerPowerStateChangeRequest, resourceGroupName string, managerName string) (result storsimple.HardwareComponentGroupsChangeControllerPowerStateFuture, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.HardwareComponentGroupList, err error)
}

var _ HardwareComponentGroupsClientAPI = (*storsimple.HardwareComponentGroupsClient)(nil)

// JobsClientAPI contains the set of methods on the JobsClient type.
type JobsClientAPI interface {
	Cancel(ctx context.Context, deviceName string, jobName string, resourceGroupName string, managerName string) (result storsimple.JobsCancelFuture, err error)
	Get(ctx context.Context, deviceName string, jobName string, resourceGroupName string, managerName string) (result storsimple.Job, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string) (result storsimple.JobListPage, err error)
	ListByDeviceComplete(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string) (result storsimple.JobListIterator, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.JobListPage, err error)
	ListByManagerComplete(ctx context.Context, resourceGroupName string, managerName string, filter string) (result storsimple.JobListIterator, err error)
}

var _ JobsClientAPI = (*storsimple.JobsClient)(nil)

// VolumeContainersClientAPI contains the set of methods on the VolumeContainersClient type.
type VolumeContainersClientAPI interface {
	CreateOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, parameters storsimple.VolumeContainer, resourceGroupName string, managerName string) (result storsimple.VolumeContainersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string) (result storsimple.VolumeContainersDeleteFuture, err error)
	Get(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string) (result storsimple.VolumeContainer, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.VolumeContainerList, err error)
	ListMetricDefinition(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string) (result storsimple.MetricDefinitionList, err error)
	ListMetrics(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string, filter string) (result storsimple.MetricList, err error)
}

var _ VolumeContainersClientAPI = (*storsimple.VolumeContainersClient)(nil)

// VolumesClientAPI contains the set of methods on the VolumesClient type.
type VolumesClientAPI interface {
	CreateOrUpdate(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, parameters storsimple.Volume, resourceGroupName string, managerName string) (result storsimple.VolumesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string) (result storsimple.VolumesDeleteFuture, err error)
	Get(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string) (result storsimple.Volume, err error)
	ListByDevice(ctx context.Context, deviceName string, resourceGroupName string, managerName string) (result storsimple.VolumeList, err error)
	ListByVolumeContainer(ctx context.Context, deviceName string, volumeContainerName string, resourceGroupName string, managerName string) (result storsimple.VolumeList, err error)
	ListMetricDefinition(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string) (result storsimple.MetricDefinitionList, err error)
	ListMetrics(ctx context.Context, deviceName string, volumeContainerName string, volumeName string, resourceGroupName string, managerName string, filter string) (result storsimple.MetricList, err error)
}

var _ VolumesClientAPI = (*storsimple.VolumesClient)(nil)

// StorageAccountCredentialsClientAPI contains the set of methods on the StorageAccountCredentialsClient type.
type StorageAccountCredentialsClientAPI interface {
	CreateOrUpdate(ctx context.Context, storageAccountCredentialName string, parameters storsimple.StorageAccountCredential, resourceGroupName string, managerName string) (result storsimple.StorageAccountCredentialsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, storageAccountCredentialName string, resourceGroupName string, managerName string) (result storsimple.StorageAccountCredentialsDeleteFuture, err error)
	Get(ctx context.Context, storageAccountCredentialName string, resourceGroupName string, managerName string) (result storsimple.StorageAccountCredential, err error)
	ListByManager(ctx context.Context, resourceGroupName string, managerName string) (result storsimple.StorageAccountCredentialList, err error)
}

var _ StorageAccountCredentialsClientAPI = (*storsimple.StorageAccountCredentialsClient)(nil)
