package changeanalysis

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ChangesClient is the client for the Changes methods of the Changeanalysis service.
type ChangesClient struct {
	BaseClient
}

// NewChangesClient creates an instance of the ChangesClient client.
func NewChangesClient(subscriptionID string) ChangesClient {
	return NewChangesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewChangesClientWithBaseURI creates an instance of the ChangesClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewChangesClientWithBaseURI(baseURI string, subscriptionID string) ChangesClient {
	return ChangesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListChangesByResourceGroup sends the list changes by resource group request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// startTime - specifies the start time of the changes request.
// endTime - specifies the end time of the changes request.
// skipToken - a skip token is used to continue retrieving items after an operation returns a partial result.
// If a previous response contains a nextLink element, the value of the nextLink element will include a
// skipToken parameter that specifies a starting point to use for subsequent calls.
func (client ChangesClient) ListChangesByResourceGroup(ctx context.Context, resourceGroupName string, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChangesClient.ListChangesByResourceGroup")
		defer func() {
			sc := -1
			if result.cl.Response.Response != nil {
				sc = result.cl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("changeanalysis.ChangesClient", "ListChangesByResourceGroup", err.Error())
	}

	result.fn = client.listChangesByResourceGroupNextResults
	req, err := client.ListChangesByResourceGroupPreparer(ctx, resourceGroupName, startTime, endTime, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListChangesByResourceGroupSender(req)
	if err != nil {
		result.cl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesByResourceGroup", resp, "Failure sending request")
		return
	}

	result.cl, err = client.ListChangesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.cl.hasNextLink() && result.cl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListChangesByResourceGroupPreparer prepares the ListChangesByResourceGroup request.
func (client ChangesClient) ListChangesByResourceGroupPreparer(ctx context.Context, resourceGroupName string, startTime date.Time, endTime date.Time, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-04-01"
	queryParameters := map[string]interface{}{
		"$endTime":    autorest.Encode("query", endTime),
		"$startTime":  autorest.Encode("query", startTime),
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ChangeAnalysis/changes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListChangesByResourceGroupSender sends the ListChangesByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ChangesClient) ListChangesByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListChangesByResourceGroupResponder handles the response to the ListChangesByResourceGroup request. The method always
// closes the http.Response Body.
func (client ChangesClient) ListChangesByResourceGroupResponder(resp *http.Response) (result ChangeList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listChangesByResourceGroupNextResults retrieves the next set of results, if any.
func (client ChangesClient) listChangesByResourceGroupNextResults(ctx context.Context, lastResults ChangeList) (result ChangeList, err error) {
	req, err := lastResults.changeListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListChangesByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListChangesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListChangesByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client ChangesClient) ListChangesByResourceGroupComplete(ctx context.Context, resourceGroupName string, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChangesClient.ListChangesByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListChangesByResourceGroup(ctx, resourceGroupName, startTime, endTime, skipToken)
	return
}

// ListChangesBySubscription sends the list changes by subscription request.
// Parameters:
// startTime - specifies the start time of the changes request.
// endTime - specifies the end time of the changes request.
// skipToken - a skip token is used to continue retrieving items after an operation returns a partial result.
// If a previous response contains a nextLink element, the value of the nextLink element will include a
// skipToken parameter that specifies a starting point to use for subsequent calls.
func (client ChangesClient) ListChangesBySubscription(ctx context.Context, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChangesClient.ListChangesBySubscription")
		defer func() {
			sc := -1
			if result.cl.Response.Response != nil {
				sc = result.cl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("changeanalysis.ChangesClient", "ListChangesBySubscription", err.Error())
	}

	result.fn = client.listChangesBySubscriptionNextResults
	req, err := client.ListChangesBySubscriptionPreparer(ctx, startTime, endTime, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListChangesBySubscriptionSender(req)
	if err != nil {
		result.cl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesBySubscription", resp, "Failure sending request")
		return
	}

	result.cl, err = client.ListChangesBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "ListChangesBySubscription", resp, "Failure responding to request")
		return
	}
	if result.cl.hasNextLink() && result.cl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListChangesBySubscriptionPreparer prepares the ListChangesBySubscription request.
func (client ChangesClient) ListChangesBySubscriptionPreparer(ctx context.Context, startTime date.Time, endTime date.Time, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-04-01"
	queryParameters := map[string]interface{}{
		"$endTime":    autorest.Encode("query", endTime),
		"$startTime":  autorest.Encode("query", startTime),
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.ChangeAnalysis/changes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListChangesBySubscriptionSender sends the ListChangesBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client ChangesClient) ListChangesBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListChangesBySubscriptionResponder handles the response to the ListChangesBySubscription request. The method always
// closes the http.Response Body.
func (client ChangesClient) ListChangesBySubscriptionResponder(resp *http.Response) (result ChangeList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listChangesBySubscriptionNextResults retrieves the next set of results, if any.
func (client ChangesClient) listChangesBySubscriptionNextResults(ctx context.Context, lastResults ChangeList) (result ChangeList, err error) {
	req, err := lastResults.changeListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListChangesBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListChangesBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ChangesClient", "listChangesBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListChangesBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client ChangesClient) ListChangesBySubscriptionComplete(ctx context.Context, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ChangesClient.ListChangesBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListChangesBySubscription(ctx, startTime, endTime, skipToken)
	return
}
