package changeanalysis

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ResourceChangesClient is the client for the ResourceChanges methods of the Changeanalysis service.
type ResourceChangesClient struct {
	BaseClient
}

// NewResourceChangesClient creates an instance of the ResourceChangesClient client.
func NewResourceChangesClient(subscriptionID string) ResourceChangesClient {
	return NewResourceChangesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceChangesClientWithBaseURI creates an instance of the ResourceChangesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewResourceChangesClientWithBaseURI(baseURI string, subscriptionID string) ResourceChangesClient {
	return ResourceChangesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List sends the list request.
// Parameters:
// resourceID - the identifier of the resource.
// startTime - specifies the start time of the changes request.
// endTime - specifies the end time of the changes request.
// skipToken - a skip token is used to continue retrieving items after an operation returns a partial result.
// If a previous response contains a nextLink element, the value of the nextLink element will include a
// skipToken parameter that specifies a starting point to use for subsequent calls.
func (client ResourceChangesClient) List(ctx context.Context, resourceID string, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceChangesClient.List")
		defer func() {
			sc := -1
			if result.cl.Response.Response != nil {
				sc = result.cl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceID, startTime, endTime, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.cl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "List", resp, "Failure sending request")
		return
	}

	result.cl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.cl.hasNextLink() && result.cl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ResourceChangesClient) ListPreparer(ctx context.Context, resourceID string, startTime date.Time, endTime date.Time, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": autorest.Encode("path", resourceID),
	}

	const APIVersion = "2021-04-01"
	queryParameters := map[string]interface{}{
		"$endTime":    autorest.Encode("query", endTime),
		"$startTime":  autorest.Encode("query", startTime),
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.ChangeAnalysis/resourceChanges", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceChangesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ResourceChangesClient) ListResponder(resp *http.Response) (result ChangeList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ResourceChangesClient) listNextResults(ctx context.Context, lastResults ChangeList) (result ChangeList, err error) {
	req, err := lastResults.changeListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "changeanalysis.ResourceChangesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceChangesClient) ListComplete(ctx context.Context, resourceID string, startTime date.Time, endTime date.Time, skipToken string) (result ChangeListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceChangesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceID, startTime, endTime, skipToken)
	return
}
