package consumption

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"github.com/shopspring/decimal"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/consumption/mgmt/2019-10-01/consumption"

// Amount the amount plus currency .
type Amount struct {
	// Currency - READ-ONLY; Amount currency.
	Currency *string `json:"currency,omitempty"`
	// Value - READ-ONLY; Amount.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Amount.
func (a Amount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AmountWithExchangeRate reseller details
type AmountWithExchangeRate struct {
	// ExchangeRate - READ-ONLY; Exchange Rate.
	ExchangeRate *decimal.Decimal `json:"exchangeRate,omitempty"`
	// ExchangeRateMonth - READ-ONLY; Exchange rate month.
	ExchangeRateMonth *float64 `json:"exchangeRateMonth,omitempty"`
	// Currency - READ-ONLY; Amount currency.
	Currency *string `json:"currency,omitempty"`
	// Value - READ-ONLY; Amount.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AmountWithExchangeRate.
func (awer AmountWithExchangeRate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Balance a balance resource.
type Balance struct {
	autorest.Response  `json:"-"`
	*BalanceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Balance.
func (b Balance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BalanceProperties != nil {
		objectMap["properties"] = b.BalanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Balance struct.
func (b *Balance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var balanceProperties BalanceProperties
				err = json.Unmarshal(*v, &balanceProperties)
				if err != nil {
					return err
				}
				b.BalanceProperties = &balanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				b.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				b.Tags = tags
			}
		}
	}

	return nil
}

// BalanceProperties the properties of the balance.
type BalanceProperties struct {
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// BeginningBalance - READ-ONLY; The beginning balance for the billing period.
	BeginningBalance *decimal.Decimal `json:"beginningBalance,omitempty"`
	// EndingBalance - READ-ONLY; The ending balance for the billing period (for open periods this will be updated daily).
	EndingBalance *decimal.Decimal `json:"endingBalance,omitempty"`
	// NewPurchases - READ-ONLY; Total new purchase amount.
	NewPurchases *decimal.Decimal `json:"newPurchases,omitempty"`
	// Adjustments - READ-ONLY; Total adjustment amount.
	Adjustments *decimal.Decimal `json:"adjustments,omitempty"`
	// Utilized - READ-ONLY; Total Commitment usage.
	Utilized *decimal.Decimal `json:"utilized,omitempty"`
	// ServiceOverage - READ-ONLY; Overage for Azure services.
	ServiceOverage *decimal.Decimal `json:"serviceOverage,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// TotalOverage - READ-ONLY; serviceOverage + chargesBilledSeparately.
	TotalOverage *decimal.Decimal `json:"totalOverage,omitempty"`
	// TotalUsage - READ-ONLY; Azure service commitment + total Overage.
	TotalUsage *decimal.Decimal `json:"totalUsage,omitempty"`
	// AzureMarketplaceServiceCharges - READ-ONLY; Total charges for Azure Marketplace.
	AzureMarketplaceServiceCharges *decimal.Decimal `json:"azureMarketplaceServiceCharges,omitempty"`
	// BillingFrequency - The billing frequency. Possible values include: 'BillingFrequencyMonth', 'BillingFrequencyQuarter', 'BillingFrequencyYear'
	BillingFrequency BillingFrequency `json:"billingFrequency,omitempty"`
	// PriceHidden - READ-ONLY; Price is hidden or not.
	PriceHidden *bool `json:"priceHidden,omitempty"`
	// NewPurchasesDetails - READ-ONLY; List of new purchases.
	NewPurchasesDetails *[]BalancePropertiesNewPurchasesDetailsItem `json:"newPurchasesDetails,omitempty"`
	// AdjustmentDetails - READ-ONLY; List of Adjustments (Promo credit, SIE credit etc.).
	AdjustmentDetails *[]BalancePropertiesAdjustmentDetailsItem `json:"adjustmentDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for BalanceProperties.
func (bp BalanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.BillingFrequency != "" {
		objectMap["billingFrequency"] = bp.BillingFrequency
	}
	return json.Marshal(objectMap)
}

// BalancePropertiesAdjustmentDetailsItem ...
type BalancePropertiesAdjustmentDetailsItem struct {
	// Name - READ-ONLY; the name of new adjustment.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; the value of new adjustment.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BalancePropertiesAdjustmentDetailsItem.
func (bpDi BalancePropertiesAdjustmentDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BalancePropertiesNewPurchasesDetailsItem ...
type BalancePropertiesNewPurchasesDetailsItem struct {
	// Name - READ-ONLY; the name of new purchase.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; the value of new purchase.
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BalancePropertiesNewPurchasesDetailsItem.
func (bpPdi BalancePropertiesNewPurchasesDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Budget a budget resource.
type Budget struct {
	autorest.Response `json:"-"`
	*BudgetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Budget.
func (b Budget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BudgetProperties != nil {
		objectMap["properties"] = b.BudgetProperties
	}
	if b.ETag != nil {
		objectMap["eTag"] = b.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Budget struct.
func (b *Budget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var budgetProperties BudgetProperties
				err = json.Unmarshal(*v, &budgetProperties)
				if err != nil {
					return err
				}
				b.BudgetProperties = &budgetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				b.ETag = &eTag
			}
		}
	}

	return nil
}

// BudgetComparisonExpression the comparison expression to be used in the budgets.
type BudgetComparisonExpression struct {
	// Name - The name of the column to use in comparison.
	Name *string `json:"name,omitempty"`
	// Operator - The operator to use for comparison.
	Operator *string `json:"operator,omitempty"`
	// Values - Array of values to use for comparison
	Values *[]string `json:"values,omitempty"`
}

// BudgetFilter may be used to filter budgets by resource group, resource, or meter.
type BudgetFilter struct {
	// And - The logical "AND" expression. Must have at least 2 items.
	And *[]BudgetFilterProperties `json:"and,omitempty"`
	// Not - The logical "NOT" expression.
	Not *BudgetFilterProperties `json:"not,omitempty"`
	// Dimensions - Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression `json:"dimensions,omitempty"`
	// Tags - Has comparison expression for a tag
	Tags *BudgetComparisonExpression `json:"tags,omitempty"`
}

// BudgetFilterProperties the Dimensions or Tags to filter a budget by.
type BudgetFilterProperties struct {
	// Dimensions - Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression `json:"dimensions,omitempty"`
	// Tags - Has comparison expression for a tag
	Tags *BudgetComparisonExpression `json:"tags,omitempty"`
}

// BudgetProperties the properties of the budget.
type BudgetProperties struct {
	// Category - The category of the budget, whether the budget tracks cost or usage.
	Category *string `json:"category,omitempty"`
	// Amount - The total amount of cost to track with the budget
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// TimeGrain - The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers. Possible values include: 'TimeGrainTypeMonthly', 'TimeGrainTypeQuarterly', 'TimeGrainTypeAnnually', 'TimeGrainTypeBillingMonth', 'TimeGrainTypeBillingQuarter', 'TimeGrainTypeBillingAnnual'
	TimeGrain TimeGrainType `json:"timeGrain,omitempty"`
	// TimePeriod - Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
	TimePeriod *BudgetTimePeriod `json:"timePeriod,omitempty"`
	// Filter - May be used to filter budgets by user-specified dimensions and/or tags.
	Filter *BudgetFilter `json:"filter,omitempty"`
	// CurrentSpend - READ-ONLY; The current amount of cost which is being tracked for a budget.
	CurrentSpend *CurrentSpend `json:"currentSpend,omitempty"`
	// Notifications - Dictionary of notifications associated with the budget. Budget can have up to five notifications.
	Notifications map[string]*Notification `json:"notifications"`
	// ForecastSpend - READ-ONLY; The forecasted cost which is being tracked for a budget.
	ForecastSpend *ForecastSpend `json:"forecastSpend,omitempty"`
}

// MarshalJSON is the custom marshaler for BudgetProperties.
func (bp BudgetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.Category != nil {
		objectMap["category"] = bp.Category
	}
	if bp.Amount != nil {
		objectMap["amount"] = bp.Amount
	}
	if bp.TimeGrain != "" {
		objectMap["timeGrain"] = bp.TimeGrain
	}
	if bp.TimePeriod != nil {
		objectMap["timePeriod"] = bp.TimePeriod
	}
	if bp.Filter != nil {
		objectMap["filter"] = bp.Filter
	}
	if bp.Notifications != nil {
		objectMap["notifications"] = bp.Notifications
	}
	return json.Marshal(objectMap)
}

// BudgetsListResult result of listing budgets. It contains a list of available budgets in the scope
// provided.
type BudgetsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of budgets.
	Value *[]Budget `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BudgetsListResult.
func (blr BudgetsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BudgetsListResultIterator provides access to a complete listing of Budget values.
type BudgetsListResultIterator struct {
	i    int
	page BudgetsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BudgetsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BudgetsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BudgetsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BudgetsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BudgetsListResultIterator) Response() BudgetsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BudgetsListResultIterator) Value() Budget {
	if !iter.page.NotDone() {
		return Budget{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BudgetsListResultIterator type.
func NewBudgetsListResultIterator(page BudgetsListResultPage) BudgetsListResultIterator {
	return BudgetsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (blr BudgetsListResult) IsEmpty() bool {
	return blr.Value == nil || len(*blr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (blr BudgetsListResult) hasNextLink() bool {
	return blr.NextLink != nil && len(*blr.NextLink) != 0
}

// budgetsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (blr BudgetsListResult) budgetsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !blr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(blr.NextLink)))
}

// BudgetsListResultPage contains a page of Budget values.
type BudgetsListResultPage struct {
	fn  func(context.Context, BudgetsListResult) (BudgetsListResult, error)
	blr BudgetsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BudgetsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BudgetsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.blr)
		if err != nil {
			return err
		}
		page.blr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BudgetsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BudgetsListResultPage) NotDone() bool {
	return !page.blr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BudgetsListResultPage) Response() BudgetsListResult {
	return page.blr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BudgetsListResultPage) Values() []Budget {
	if page.blr.IsEmpty() {
		return nil
	}
	return *page.blr.Value
}

// Creates a new instance of the BudgetsListResultPage type.
func NewBudgetsListResultPage(cur BudgetsListResult, getNextPage func(context.Context, BudgetsListResult) (BudgetsListResult, error)) BudgetsListResultPage {
	return BudgetsListResultPage{
		fn:  getNextPage,
		blr: cur,
	}
}

// BudgetTimePeriod the start and end date for a budget.
type BudgetTimePeriod struct {
	// StartDate - The start date for the budget.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The end date for the budget. If not provided, we default this to 10 years from the start date.
	EndDate *date.Time `json:"endDate,omitempty"`
}

// ChargesListResult result of listing charge summary.
type ChargesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of charge summary
	Value *[]BasicChargeSummary `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ChargesListResult.
func (clr ChargesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ChargesListResult struct.
func (clr *ChargesListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicChargeSummaryArray(*v)
				if err != nil {
					return err
				}
				clr.Value = &value
			}
		}
	}

	return nil
}

// BasicChargeSummary a charge summary resource.
type BasicChargeSummary interface {
	AsLegacyChargeSummary() (*LegacyChargeSummary, bool)
	AsModernChargeSummary() (*ModernChargeSummary, bool)
	AsChargeSummary() (*ChargeSummary, bool)
}

// ChargeSummary a charge summary resource.
type ChargeSummary struct {
	// Kind - Possible values include: 'KindBasicChargeSummaryKindChargeSummary', 'KindBasicChargeSummaryKindLegacy', 'KindBasicChargeSummaryKindModern'
	Kind KindBasicChargeSummary `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

func unmarshalBasicChargeSummary(body []byte) (BasicChargeSummary, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicChargeSummaryKindLegacy):
		var lcs LegacyChargeSummary
		err := json.Unmarshal(body, &lcs)
		return lcs, err
	case string(KindBasicChargeSummaryKindModern):
		var mcs ModernChargeSummary
		err := json.Unmarshal(body, &mcs)
		return mcs, err
	default:
		var cs ChargeSummary
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicChargeSummaryArray(body []byte) ([]BasicChargeSummary, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicChargeSummary, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicChargeSummary(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ChargeSummary.
func (cs ChargeSummary) MarshalJSON() ([]byte, error) {
	cs.Kind = KindBasicChargeSummaryKindChargeSummary
	objectMap := make(map[string]interface{})
	if cs.Kind != "" {
		objectMap["kind"] = cs.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyChargeSummary is the BasicChargeSummary implementation for ChargeSummary.
func (cs ChargeSummary) AsLegacyChargeSummary() (*LegacyChargeSummary, bool) {
	return nil, false
}

// AsModernChargeSummary is the BasicChargeSummary implementation for ChargeSummary.
func (cs ChargeSummary) AsModernChargeSummary() (*ModernChargeSummary, bool) {
	return nil, false
}

// AsChargeSummary is the BasicChargeSummary implementation for ChargeSummary.
func (cs ChargeSummary) AsChargeSummary() (*ChargeSummary, bool) {
	return &cs, true
}

// AsBasicChargeSummary is the BasicChargeSummary implementation for ChargeSummary.
func (cs ChargeSummary) AsBasicChargeSummary() (BasicChargeSummary, bool) {
	return &cs, true
}

// CreditBalanceSummary summary of credit balances.
type CreditBalanceSummary struct {
	// EstimatedBalance - READ-ONLY; Estimated balance.
	EstimatedBalance *Amount `json:"estimatedBalance,omitempty"`
	// CurrentBalance - READ-ONLY; Current balance.
	CurrentBalance *Amount `json:"currentBalance,omitempty"`
	// EstimatedBalanceInBillingCurrency - READ-ONLY; Current balance.
	EstimatedBalanceInBillingCurrency *AmountWithExchangeRate `json:"estimatedBalanceInBillingCurrency,omitempty"`
	// CurrentBalanceInBillingCurrency - READ-ONLY; Current balance.
	CurrentBalanceInBillingCurrency *AmountWithExchangeRate `json:"currentBalanceInBillingCurrency,omitempty"`
}

// MarshalJSON is the custom marshaler for CreditBalanceSummary.
func (cbs CreditBalanceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CreditSummary a credit summary resource.
type CreditSummary struct {
	autorest.Response        `json:"-"`
	*CreditSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreditSummary.
func (cs CreditSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.CreditSummaryProperties != nil {
		objectMap["properties"] = cs.CreditSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreditSummary struct.
func (cs *CreditSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var creditSummaryProperties CreditSummaryProperties
				err = json.Unmarshal(*v, &creditSummaryProperties)
				if err != nil {
					return err
				}
				cs.CreditSummaryProperties = &creditSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cs.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cs.Tags = tags
			}
		}
	}

	return nil
}

// CreditSummaryProperties the properties of the credit summary.
type CreditSummaryProperties struct {
	// CreditCurrency - READ-ONLY; Credit Currency
	CreditCurrency *string `json:"creditCurrency,omitempty"`
	// BillingCurrency - READ-ONLY; Billing Currency.
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// BalanceSummary - READ-ONLY; Summary of balances associated with this credit summary.
	BalanceSummary *CreditBalanceSummary `json:"balanceSummary,omitempty"`
	// PendingCreditAdjustments - READ-ONLY; Pending credit adjustments.
	PendingCreditAdjustments *Amount `json:"pendingCreditAdjustments,omitempty"`
	// ExpiredCredit - READ-ONLY; Expired credit.
	ExpiredCredit *Amount `json:"expiredCredit,omitempty"`
	// PendingEligibleCharges - READ-ONLY; Pending eligible charges.
	PendingEligibleCharges *Amount `json:"pendingEligibleCharges,omitempty"`
	// Reseller - READ-ONLY; Reseller details.
	Reseller *Reseller `json:"reseller,omitempty"`
}

// MarshalJSON is the custom marshaler for CreditSummaryProperties.
func (csp CreditSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CurrentSpend the current amount of cost which is being tracked for a budget.
type CurrentSpend struct {
	// Amount - READ-ONLY; The total amount of cost which is being tracked by the budget.
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// Unit - READ-ONLY; The unit of measure for the budget amount.
	Unit *string `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for CurrentSpend.
func (cs CurrentSpend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DownloadProperties the properties of the price sheet download.
type DownloadProperties struct {
	// DownloadURL - READ-ONLY; The link (url) to download the pricesheet.
	DownloadURL *string `json:"downloadUrl,omitempty"`
	// ValidTill - READ-ONLY; Download link validity.
	ValidTill *string `json:"validTill,omitempty"`
}

// MarshalJSON is the custom marshaler for DownloadProperties.
func (dp DownloadProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
//
// Some Error responses:
//
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
// "x-ms-ratelimit-microsoft.consumption-retry-after" header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
// specified in the "Retry-After" header.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// EventProperties the event properties.
type EventProperties struct {
	// CreditCurrency - READ-ONLY; Credit Currency
	CreditCurrency *string `json:"creditCurrency,omitempty"`
	// BillingCurrency - READ-ONLY; Billing Currency.
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// TransactionDate - READ-ONLY; Transaction date.
	TransactionDate *date.Time `json:"transactionDate,omitempty"`
	// Description - READ-ONLY; Transaction description.
	Description *string `json:"description,omitempty"`
	// NewCredit - READ-ONLY; New Credit.
	NewCredit *Amount `json:"newCredit,omitempty"`
	// NewCreditInBillingCurrency - READ-ONLY; Current balance.
	NewCreditInBillingCurrency *AmountWithExchangeRate `json:"newCreditInBillingCurrency,omitempty"`
	// Adjustments - READ-ONLY; Adjustments amount.
	Adjustments *Amount `json:"adjustments,omitempty"`
	// AdjustmentsInBillingCurrency - READ-ONLY; Current balance.
	AdjustmentsInBillingCurrency *AmountWithExchangeRate `json:"adjustmentsInBillingCurrency,omitempty"`
	// CreditExpired - READ-ONLY; Credit expired.
	CreditExpired *Amount `json:"creditExpired,omitempty"`
	// CreditExpiredInBillingCurrency - READ-ONLY; Current balance.
	CreditExpiredInBillingCurrency *AmountWithExchangeRate `json:"creditExpiredInBillingCurrency,omitempty"`
	// Charges - READ-ONLY; Charges amount.
	Charges *Amount `json:"charges,omitempty"`
	// ChargesInBillingCurrency - READ-ONLY; Current balance.
	ChargesInBillingCurrency *AmountWithExchangeRate `json:"chargesInBillingCurrency,omitempty"`
	// ClosedBalance - READ-ONLY; Closed balance.
	ClosedBalance *Amount `json:"closedBalance,omitempty"`
	// ClosedBalanceInBillingCurrency - READ-ONLY; Current balance.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate `json:"closedBalanceInBillingCurrency,omitempty"`
	// EventType - The type of event. Possible values include: 'EventTypeSettledCharges', 'EventTypePendingCharges', 'EventTypePendingAdjustments', 'EventTypePendingNewCredit', 'EventTypePendingExpiredCredit', 'EventTypeUnKnown', 'EventTypeNewCredit'
	EventType EventType `json:"eventType,omitempty"`
	// InvoiceNumber - READ-ONLY; Invoice number.
	InvoiceNumber *string `json:"invoiceNumber,omitempty"`
	// Reseller - READ-ONLY; Reseller details.
	Reseller *Reseller `json:"reseller,omitempty"`
}

// MarshalJSON is the custom marshaler for EventProperties.
func (ep EventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.EventType != "" {
		objectMap["eventType"] = ep.EventType
	}
	return json.Marshal(objectMap)
}

// Events result of listing event summary.
type Events struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of event summary.
	Value *[]EventSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for Events.
func (e Events) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventsIterator provides access to a complete listing of EventSummary values.
type EventsIterator struct {
	i    int
	page EventsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventsIterator) Response() Events {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventsIterator) Value() EventSummary {
	if !iter.page.NotDone() {
		return EventSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventsIterator type.
func NewEventsIterator(page EventsPage) EventsIterator {
	return EventsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (e Events) IsEmpty() bool {
	return e.Value == nil || len(*e.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (e Events) hasNextLink() bool {
	return e.NextLink != nil && len(*e.NextLink) != 0
}

// eventsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (e Events) eventsPreparer(ctx context.Context) (*http.Request, error) {
	if !e.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(e.NextLink)))
}

// EventsPage contains a page of EventSummary values.
type EventsPage struct {
	fn func(context.Context, Events) (Events, error)
	e  Events
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.e)
		if err != nil {
			return err
		}
		page.e = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventsPage) NotDone() bool {
	return !page.e.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventsPage) Response() Events {
	return page.e
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventsPage) Values() []EventSummary {
	if page.e.IsEmpty() {
		return nil
	}
	return *page.e.Value
}

// Creates a new instance of the EventsPage type.
func NewEventsPage(cur Events, getNextPage func(context.Context, Events) (Events, error)) EventsPage {
	return EventsPage{
		fn: getNextPage,
		e:  cur,
	}
}

// EventSummary an event summary resource.
type EventSummary struct {
	*EventProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EventSummary.
func (es EventSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EventProperties != nil {
		objectMap["properties"] = es.EventProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EventSummary struct.
func (es *EventSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eventProperties EventProperties
				err = json.Unmarshal(*v, &eventProperties)
				if err != nil {
					return err
				}
				es.EventProperties = &eventProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				es.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				es.Tags = tags
			}
		}
	}

	return nil
}

// Forecast a forecast resource.
type Forecast struct {
	*ForecastProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Forecast.
func (f Forecast) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.ForecastProperties != nil {
		objectMap["properties"] = f.ForecastProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Forecast struct.
func (f *Forecast) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var forecastProperties ForecastProperties
				err = json.Unmarshal(*v, &forecastProperties)
				if err != nil {
					return err
				}
				f.ForecastProperties = &forecastProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				f.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				f.Tags = tags
			}
		}
	}

	return nil
}

// ForecastProperties the properties of the forecast charge.
type ForecastProperties struct {
	// UsageDate - READ-ONLY; The usage date of the forecast.
	UsageDate *string `json:"usageDate,omitempty"`
	// Grain - The granularity of forecast. Please note that Yearly is not currently supported in this API. The API will provide responses in the Monthly grain if Yearly is selected. To get yearly grain data, please use our newer Forecast API. Possible values include: 'GrainDaily', 'GrainMonthly', 'GrainYearly'
	Grain Grain `json:"grain,omitempty"`
	// Charge - READ-ONLY; The amount of charge
	Charge *decimal.Decimal `json:"charge,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// ChargeType - The type of the charge. Could be actual or forecast. Possible values include: 'ChargeTypeActual', 'ChargeTypeForecast'
	ChargeType ChargeType `json:"chargeType,omitempty"`
	// ConfidenceLevels - READ-ONLY; The details about the forecast confidence levels. This is populated only when chargeType is Forecast.
	ConfidenceLevels *[]ForecastPropertiesConfidenceLevelsItem `json:"confidenceLevels,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastProperties.
func (fp ForecastProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.Grain != "" {
		objectMap["grain"] = fp.Grain
	}
	if fp.ChargeType != "" {
		objectMap["chargeType"] = fp.ChargeType
	}
	return json.Marshal(objectMap)
}

// ForecastPropertiesConfidenceLevelsItem ...
type ForecastPropertiesConfidenceLevelsItem struct {
	// Percentage - READ-ONLY; The percentage level of the confidence
	Percentage *decimal.Decimal `json:"percentage,omitempty"`
	// Bound - The boundary of the percentage, values could be 'Upper' or 'Lower'. Possible values include: 'BoundUpper', 'BoundLower'
	Bound Bound `json:"bound,omitempty"`
	// Value - READ-ONLY; The amount of forecast within the percentage level
	Value *decimal.Decimal `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastPropertiesConfidenceLevelsItem.
func (fpLi ForecastPropertiesConfidenceLevelsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fpLi.Bound != "" {
		objectMap["bound"] = fpLi.Bound
	}
	return json.Marshal(objectMap)
}

// ForecastsListResult result of listing forecasts. It contains a list of available forecasts.
type ForecastsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of forecasts.
	Value *[]Forecast `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastsListResult.
func (flr ForecastsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ForecastSpend the forecasted cost which is being tracked for a budget.
type ForecastSpend struct {
	// Amount - READ-ONLY; The forecasted cost for the total time period which is being tracked by the budget. This value is only provided if the budget contains a forecast alert type.
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// Unit - READ-ONLY; The unit of measure for the budget amount.
	Unit *string `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for ForecastSpend.
func (fs ForecastSpend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HighCasedErrorDetails the details of the error.
type HighCasedErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for HighCasedErrorDetails.
func (hced HighCasedErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// HighCasedErrorResponse error response indicates that the service is not able to process the incoming
// request. The reason is provided in the error message.
//
// Some Error responses:
//
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the
// "x-ms-ratelimit-microsoft.consumption-retry-after" header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time
// specified in the "Retry-After" header.
type HighCasedErrorResponse struct {
	// Error - The details of the error.
	Error *HighCasedErrorDetails `json:"error,omitempty"`
}

// LegacyChargeSummary legacy charge summary.
type LegacyChargeSummary struct {
	// LegacyChargeSummaryProperties - Properties for legacy charge summary
	*LegacyChargeSummaryProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicChargeSummaryKindChargeSummary', 'KindBasicChargeSummaryKindLegacy', 'KindBasicChargeSummaryKindModern'
	Kind KindBasicChargeSummary `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LegacyChargeSummary.
func (lcs LegacyChargeSummary) MarshalJSON() ([]byte, error) {
	lcs.Kind = KindBasicChargeSummaryKindLegacy
	objectMap := make(map[string]interface{})
	if lcs.LegacyChargeSummaryProperties != nil {
		objectMap["properties"] = lcs.LegacyChargeSummaryProperties
	}
	if lcs.Kind != "" {
		objectMap["kind"] = lcs.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyChargeSummary is the BasicChargeSummary implementation for LegacyChargeSummary.
func (lcs LegacyChargeSummary) AsLegacyChargeSummary() (*LegacyChargeSummary, bool) {
	return &lcs, true
}

// AsModernChargeSummary is the BasicChargeSummary implementation for LegacyChargeSummary.
func (lcs LegacyChargeSummary) AsModernChargeSummary() (*ModernChargeSummary, bool) {
	return nil, false
}

// AsChargeSummary is the BasicChargeSummary implementation for LegacyChargeSummary.
func (lcs LegacyChargeSummary) AsChargeSummary() (*ChargeSummary, bool) {
	return nil, false
}

// AsBasicChargeSummary is the BasicChargeSummary implementation for LegacyChargeSummary.
func (lcs LegacyChargeSummary) AsBasicChargeSummary() (BasicChargeSummary, bool) {
	return &lcs, true
}

// UnmarshalJSON is the custom unmarshaler for LegacyChargeSummary struct.
func (lcs *LegacyChargeSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var legacyChargeSummaryProperties LegacyChargeSummaryProperties
				err = json.Unmarshal(*v, &legacyChargeSummaryProperties)
				if err != nil {
					return err
				}
				lcs.LegacyChargeSummaryProperties = &legacyChargeSummaryProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicChargeSummary
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				lcs.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lcs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lcs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lcs.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lcs.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lcs.Tags = tags
			}
		}
	}

	return nil
}

// LegacyChargeSummaryProperties the properties of legacy charge summary.
type LegacyChargeSummaryProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; Usage start date.
	UsageStart *string `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; Usage end date.
	UsageEnd *string `json:"usageEnd,omitempty"`
	// AzureCharges - READ-ONLY; Azure Charges.
	AzureCharges *decimal.Decimal `json:"azureCharges,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// MarketplaceCharges - READ-ONLY; Marketplace Charges.
	MarketplaceCharges *decimal.Decimal `json:"marketplaceCharges,omitempty"`
	// Currency - READ-ONLY; Currency Code
	Currency *string `json:"currency,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyChargeSummaryProperties.
func (lcsp LegacyChargeSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LegacyReservationRecommendation legacy reservation recommendation.
type LegacyReservationRecommendation struct {
	// LegacyReservationRecommendationProperties - Properties for legacy reservation recommendation
	*LegacyReservationRecommendationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku *string `json:"sku,omitempty"`
	// Kind - Possible values include: 'KindBasicReservationRecommendationKindReservationRecommendation', 'KindBasicReservationRecommendationKindLegacy', 'KindBasicReservationRecommendationKindModern'
	Kind KindBasicReservationRecommendation `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyReservationRecommendation.
func (lrr LegacyReservationRecommendation) MarshalJSON() ([]byte, error) {
	lrr.Kind = KindBasicReservationRecommendationKindLegacy
	objectMap := make(map[string]interface{})
	if lrr.LegacyReservationRecommendationProperties != nil {
		objectMap["properties"] = lrr.LegacyReservationRecommendationProperties
	}
	if lrr.Kind != "" {
		objectMap["kind"] = lrr.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyReservationRecommendation is the BasicReservationRecommendation implementation for LegacyReservationRecommendation.
func (lrr LegacyReservationRecommendation) AsLegacyReservationRecommendation() (*LegacyReservationRecommendation, bool) {
	return &lrr, true
}

// AsModernReservationRecommendation is the BasicReservationRecommendation implementation for LegacyReservationRecommendation.
func (lrr LegacyReservationRecommendation) AsModernReservationRecommendation() (*ModernReservationRecommendation, bool) {
	return nil, false
}

// AsReservationRecommendation is the BasicReservationRecommendation implementation for LegacyReservationRecommendation.
func (lrr LegacyReservationRecommendation) AsReservationRecommendation() (*ReservationRecommendation, bool) {
	return nil, false
}

// AsBasicReservationRecommendation is the BasicReservationRecommendation implementation for LegacyReservationRecommendation.
func (lrr LegacyReservationRecommendation) AsBasicReservationRecommendation() (BasicReservationRecommendation, bool) {
	return &lrr, true
}

// UnmarshalJSON is the custom unmarshaler for LegacyReservationRecommendation struct.
func (lrr *LegacyReservationRecommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var legacyReservationRecommendationProperties LegacyReservationRecommendationProperties
				err = json.Unmarshal(*v, &legacyReservationRecommendationProperties)
				if err != nil {
					return err
				}
				lrr.LegacyReservationRecommendationProperties = &legacyReservationRecommendationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lrr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lrr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lrr.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lrr.Location = &location
			}
		case "sku":
			if v != nil {
				var sku string
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				lrr.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind KindBasicReservationRecommendation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				lrr.Kind = kind
			}
		}
	}

	return nil
}

// LegacyReservationRecommendationProperties the properties of the reservation recommendation.
type LegacyReservationRecommendationProperties struct {
	// LookBackPeriod - READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string `json:"lookBackPeriod,omitempty"`
	// InstanceFlexibilityRatio - READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float64 `json:"instanceFlexibilityRatio,omitempty"`
	// InstanceFlexibilityGroup - READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty"`
	// NormalizedSize - READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty"`
	// RecommendedQuantityNormalized - READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float64 `json:"recommendedQuantityNormalized,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID)
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// ResourceType - READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Term - READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty"`
	// CostWithNoReservedInstances - READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *decimal.Decimal `json:"costWithNoReservedInstances,omitempty"`
	// RecommendedQuantity - READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *decimal.Decimal `json:"recommendedQuantity,omitempty"`
	// TotalCostWithReservedInstances - READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *decimal.Decimal `json:"totalCostWithReservedInstances,omitempty"`
	// NetSavings - READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *decimal.Decimal `json:"netSavings,omitempty"`
	// FirstUsageDate - READ-ONLY; The usage date for looking back.
	FirstUsageDate *date.Time `json:"firstUsageDate,omitempty"`
	// Scope - READ-ONLY; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`
	// SkuProperties - READ-ONLY; List of sku properties
	SkuProperties *[]SkuProperty `json:"skuProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyReservationRecommendationProperties.
func (lrrp LegacyReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LegacyReservationTransaction legacy Reservation transaction resource.
type LegacyReservationTransaction struct {
	*LegacyReservationTransactionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyReservationTransaction.
func (lrt LegacyReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lrt.LegacyReservationTransactionProperties != nil {
		objectMap["properties"] = lrt.LegacyReservationTransactionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LegacyReservationTransaction struct.
func (lrt *LegacyReservationTransaction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var legacyReservationTransactionProperties LegacyReservationTransactionProperties
				err = json.Unmarshal(*v, &legacyReservationTransactionProperties)
				if err != nil {
					return err
				}
				lrt.LegacyReservationTransactionProperties = &legacyReservationTransactionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lrt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lrt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lrt.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lrt.Tags = &tags
			}
		}
	}

	return nil
}

// LegacyReservationTransactionProperties the properties of a legacy reservation transaction.
type LegacyReservationTransactionProperties struct {
	// EventDate - READ-ONLY; The date of the transaction
	EventDate *date.Time `json:"eventDate,omitempty"`
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// Description - READ-ONLY; The description of the transaction.
	Description *string `json:"description,omitempty"`
	// EventType - READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string `json:"eventType,omitempty"`
	// Quantity - READ-ONLY; The quantity of the transaction.
	Quantity *decimal.Decimal `json:"quantity,omitempty"`
	// Amount - READ-ONLY; The charge of the transaction.
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// ReservationOrderName - READ-ONLY; The name of the reservation order.
	ReservationOrderName *string `json:"reservationOrderName,omitempty"`
	// PurchasingEnrollment - READ-ONLY; The purchasing enrollment.
	PurchasingEnrollment *string `json:"purchasingEnrollment,omitempty"`
	// PurchasingSubscriptionGUID - READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *uuid.UUID `json:"purchasingSubscriptionGuid,omitempty"`
	// PurchasingSubscriptionName - READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string `json:"purchasingSubscriptionName,omitempty"`
	// ArmSkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSkuName *string `json:"armSkuName,omitempty"`
	// Term - READ-ONLY; This is the term of the transaction.
	Term *string `json:"term,omitempty"`
	// Region - READ-ONLY; The region of the transaction.
	Region *string `json:"region,omitempty"`
	// AccountName - READ-ONLY; The name of the account that makes the transaction.
	AccountName *string `json:"accountName,omitempty"`
	// AccountOwnerEmail - READ-ONLY; The email of the account owner that makes the transaction.
	AccountOwnerEmail *string `json:"accountOwnerEmail,omitempty"`
	// DepartmentName - READ-ONLY; The department name.
	DepartmentName *string `json:"departmentName,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty"`
	// CurrentEnrollment - READ-ONLY; The current enrollment.
	CurrentEnrollment *string `json:"currentEnrollment,omitempty"`
	// BillingFrequency - READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string `json:"billingFrequency,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyReservationTransactionProperties.
func (lrtp LegacyReservationTransactionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LegacyUsageDetail legacy usage detail.
type LegacyUsageDetail struct {
	// LegacyUsageDetailProperties - Properties for legacy usage details
	*LegacyUsageDetailProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
	// Kind - Possible values include: 'KindUsageDetail', 'KindLegacy', 'KindModern'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyUsageDetail.
func (lud LegacyUsageDetail) MarshalJSON() ([]byte, error) {
	lud.Kind = KindLegacy
	objectMap := make(map[string]interface{})
	if lud.LegacyUsageDetailProperties != nil {
		objectMap["properties"] = lud.LegacyUsageDetailProperties
	}
	if lud.Kind != "" {
		objectMap["kind"] = lud.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyUsageDetail is the BasicUsageDetail implementation for LegacyUsageDetail.
func (lud LegacyUsageDetail) AsLegacyUsageDetail() (*LegacyUsageDetail, bool) {
	return &lud, true
}

// AsModernUsageDetail is the BasicUsageDetail implementation for LegacyUsageDetail.
func (lud LegacyUsageDetail) AsModernUsageDetail() (*ModernUsageDetail, bool) {
	return nil, false
}

// AsUsageDetail is the BasicUsageDetail implementation for LegacyUsageDetail.
func (lud LegacyUsageDetail) AsUsageDetail() (*UsageDetail, bool) {
	return nil, false
}

// AsBasicUsageDetail is the BasicUsageDetail implementation for LegacyUsageDetail.
func (lud LegacyUsageDetail) AsBasicUsageDetail() (BasicUsageDetail, bool) {
	return &lud, true
}

// UnmarshalJSON is the custom unmarshaler for LegacyUsageDetail struct.
func (lud *LegacyUsageDetail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var legacyUsageDetailProperties LegacyUsageDetailProperties
				err = json.Unmarshal(*v, &legacyUsageDetailProperties)
				if err != nil {
					return err
				}
				lud.LegacyUsageDetailProperties = &legacyUsageDetailProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				lud.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lud.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lud.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lud.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				lud.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lud.Tags = tags
			}
		}
	}

	return nil
}

// LegacyUsageDetailProperties the properties of the legacy usage detail.
type LegacyUsageDetailProperties struct {
	// BillingAccountID - READ-ONLY; Billing Account identifier.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingAccountName - READ-ONLY; Billing Account Name.
	BillingAccountName *string `json:"billingAccountName,omitempty"`
	// BillingPeriodStartDate - READ-ONLY; The billing period start date.
	BillingPeriodStartDate *date.Time `json:"billingPeriodStartDate,omitempty"`
	// BillingPeriodEndDate - READ-ONLY; The billing period end date.
	BillingPeriodEndDate *date.Time `json:"billingPeriodEndDate,omitempty"`
	// BillingProfileID - READ-ONLY; Billing Profile identifier.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing Profile Name.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// AccountOwnerID - READ-ONLY; Account Owner Id.
	AccountOwnerID *string `json:"accountOwnerId,omitempty"`
	// AccountName - READ-ONLY; Account Name.
	AccountName *string `json:"accountName,omitempty"`
	// SubscriptionID - READ-ONLY; Subscription guid.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SubscriptionName - READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// Date - READ-ONLY; Date for the usage record.
	Date *date.Time `json:"date,omitempty"`
	// Product - READ-ONLY; Product name for the consumed service or purchase. Not available for Marketplace.
	Product *string `json:"product,omitempty"`
	// PartNumber - READ-ONLY; Part Number of the service used. Can be used to join with the price sheet. Not available for marketplace.
	PartNumber *string `json:"partNumber,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter for which the reservation was purchased. For the actual VM Size for which the reservation is purchased see productOrderName.
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// MeterDetails - READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetailsResponse `json:"meterDetails,omitempty"`
	// Quantity - READ-ONLY; The usage quantity.
	Quantity *decimal.Decimal `json:"quantity,omitempty"`
	// EffectivePrice - READ-ONLY; Effective Price that's charged for the usage.
	EffectivePrice *decimal.Decimal `json:"effectivePrice,omitempty"`
	// Cost - READ-ONLY; The amount of cost before tax.
	Cost *decimal.Decimal `json:"cost,omitempty"`
	// UnitPrice - READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *decimal.Decimal `json:"unitPrice,omitempty"`
	// BillingCurrency - READ-ONLY; Billing Currency.
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// ResourceLocation - READ-ONLY; Resource Location.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// ConsumedService - READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value is not provided for marketplace usage.
	ConsumedService *string `json:"consumedService,omitempty"`
	// ResourceID - READ-ONLY; Azure resource manager resource identifier.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceName - READ-ONLY; Resource Name.
	ResourceName *string `json:"resourceName,omitempty"`
	// ServiceInfo1 - READ-ONLY; Service Info 1.
	ServiceInfo1 *string `json:"serviceInfo1,omitempty"`
	// ServiceInfo2 - READ-ONLY; Service Info 2.
	ServiceInfo2 *string `json:"serviceInfo2,omitempty"`
	// AdditionalInfo - READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand. Use this field to get usage line item specific details such as the actual VM Size (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string `json:"additionalInfo,omitempty"`
	// InvoiceSection - READ-ONLY; Invoice Section Name.
	InvoiceSection *string `json:"invoiceSection,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty"`
	// ResourceGroup - READ-ONLY; Resource Group Name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ReservationID - READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string `json:"reservationId,omitempty"`
	// ReservationName - READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily data. Only applies to records relevant to reservations.
	ReservationName *string `json:"reservationName,omitempty"`
	// ProductOrderID - READ-ONLY; Product Order Id. For reservations this is the Reservation Order ID.
	ProductOrderID *string `json:"productOrderId,omitempty"`
	// ProductOrderName - READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string `json:"productOrderName,omitempty"`
	// OfferID - READ-ONLY; Offer Id. Ex: MS-AZR-0017P, MS-AZR-0148P.
	OfferID *string `json:"offerId,omitempty"`
	// IsAzureCreditEligible - READ-ONLY; Is Azure Credit Eligible.
	IsAzureCreditEligible *bool `json:"isAzureCreditEligible,omitempty"`
	// Term - READ-ONLY; Term (in months). 1 month for monthly recurring purchase. 12 months for a 1 year reservation. 36 months for a 3 year reservation.
	Term *string `json:"term,omitempty"`
	// PublisherName - READ-ONLY; Publisher Name.
	PublisherName *string `json:"publisherName,omitempty"`
	// PublisherType - READ-ONLY; Publisher Type.
	PublisherType *string `json:"publisherType,omitempty"`
	// PlanName - READ-ONLY; Plan Name.
	PlanName *string `json:"planName,omitempty"`
	// ChargeType - READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string `json:"chargeType,omitempty"`
	// Frequency - READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string `json:"frequency,omitempty"`
}

// MarshalJSON is the custom marshaler for LegacyUsageDetailProperties.
func (ludp LegacyUsageDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LotProperties the lot properties.
type LotProperties struct {
	// CreditCurrency - READ-ONLY; Credit Currency
	CreditCurrency *string `json:"creditCurrency,omitempty"`
	// BillingCurrency - READ-ONLY; Billing Currency.
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// OriginalAmount - READ-ONLY; Original amount.
	OriginalAmount *Amount `json:"originalAmount,omitempty"`
	// OriginalAmountInBillingCurrency - READ-ONLY; Current balance.
	OriginalAmountInBillingCurrency *AmountWithExchangeRate `json:"originalAmountInBillingCurrency,omitempty"`
	// ClosedBalance - READ-ONLY; Closed balance.
	ClosedBalance *Amount `json:"closedBalance,omitempty"`
	// ClosedBalanceInBillingCurrency - READ-ONLY; Current balance.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate `json:"closedBalanceInBillingCurrency,omitempty"`
	// Source - READ-ONLY; Lot source. Possible values include: 'LotSourcePurchasedCredit', 'LotSourcePromotionalCredit'
	Source LotSource `json:"source,omitempty"`
	// StartDate - READ-ONLY; Start date.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - READ-ONLY; Expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// PoNumber - READ-ONLY; PO number.
	PoNumber *string `json:"poNumber,omitempty"`
	// Reseller - READ-ONLY; Reseller details.
	Reseller *Reseller `json:"reseller,omitempty"`
}

// MarshalJSON is the custom marshaler for LotProperties.
func (lp LotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Lots result of listing lot summary.
type Lots struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of lot summary.
	Value *[]LotSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for Lots.
func (l Lots) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LotsIterator provides access to a complete listing of LotSummary values.
type LotsIterator struct {
	i    int
	page LotsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LotsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LotsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LotsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LotsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LotsIterator) Response() Lots {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LotsIterator) Value() LotSummary {
	if !iter.page.NotDone() {
		return LotSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LotsIterator type.
func NewLotsIterator(page LotsPage) LotsIterator {
	return LotsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (l Lots) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (l Lots) hasNextLink() bool {
	return l.NextLink != nil && len(*l.NextLink) != 0
}

// lotsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l Lots) lotsPreparer(ctx context.Context) (*http.Request, error) {
	if !l.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// LotsPage contains a page of LotSummary values.
type LotsPage struct {
	fn func(context.Context, Lots) (Lots, error)
	l  Lots
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LotsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LotsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.l)
		if err != nil {
			return err
		}
		page.l = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LotsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LotsPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LotsPage) Response() Lots {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LotsPage) Values() []LotSummary {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// Creates a new instance of the LotsPage type.
func NewLotsPage(cur Lots, getNextPage func(context.Context, Lots) (Lots, error)) LotsPage {
	return LotsPage{
		fn: getNextPage,
		l:  cur,
	}
}

// LotSummary a lot summary resource.
type LotSummary struct {
	*LotProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LotSummary.
func (ls LotSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ls.LotProperties != nil {
		objectMap["properties"] = ls.LotProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LotSummary struct.
func (ls *LotSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var lotProperties LotProperties
				err = json.Unmarshal(*v, &lotProperties)
				if err != nil {
					return err
				}
				ls.LotProperties = &lotProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ls.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ls.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ls.Tags = tags
			}
		}
	}

	return nil
}

// ManagementGroupAggregatedCostProperties the properties of the Management Group Aggregated Cost.
type ManagementGroupAggregatedCostProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the aggregated cost belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; The start of the date time range covered by aggregated cost.
	UsageStart *date.Time `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; The end of the date time range covered by the aggregated cost.
	UsageEnd *date.Time `json:"usageEnd,omitempty"`
	// AzureCharges - READ-ONLY; Azure Charges.
	AzureCharges *decimal.Decimal `json:"azureCharges,omitempty"`
	// MarketplaceCharges - READ-ONLY; Marketplace Charges.
	MarketplaceCharges *decimal.Decimal `json:"marketplaceCharges,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed Separately.
	ChargesBilledSeparately *decimal.Decimal `json:"chargesBilledSeparately,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// Children - Children of a management group
	Children *[]ManagementGroupAggregatedCostResult `json:"children,omitempty"`
	// IncludedSubscriptions - List of subscription Guids included in the calculation of aggregated cost
	IncludedSubscriptions *[]string `json:"includedSubscriptions,omitempty"`
	// ExcludedSubscriptions - List of subscription Guids excluded from the calculation of aggregated cost
	ExcludedSubscriptions *[]string `json:"excludedSubscriptions,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroupAggregatedCostProperties.
func (mgacp ManagementGroupAggregatedCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mgacp.Children != nil {
		objectMap["children"] = mgacp.Children
	}
	if mgacp.IncludedSubscriptions != nil {
		objectMap["includedSubscriptions"] = mgacp.IncludedSubscriptions
	}
	if mgacp.ExcludedSubscriptions != nil {
		objectMap["excludedSubscriptions"] = mgacp.ExcludedSubscriptions
	}
	return json.Marshal(objectMap)
}

// ManagementGroupAggregatedCostResult a management group aggregated cost resource.
type ManagementGroupAggregatedCostResult struct {
	autorest.Response                        `json:"-"`
	*ManagementGroupAggregatedCostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagementGroupAggregatedCostResult.
func (mgacr ManagementGroupAggregatedCostResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mgacr.ManagementGroupAggregatedCostProperties != nil {
		objectMap["properties"] = mgacr.ManagementGroupAggregatedCostProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroupAggregatedCostResult struct.
func (mgacr *ManagementGroupAggregatedCostResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementGroupAggregatedCostProperties ManagementGroupAggregatedCostProperties
				err = json.Unmarshal(*v, &managementGroupAggregatedCostProperties)
				if err != nil {
					return err
				}
				mgacr.ManagementGroupAggregatedCostProperties = &managementGroupAggregatedCostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mgacr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mgacr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mgacr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mgacr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mgacr.Tags = tags
			}
		}
	}

	return nil
}

// Marketplace an marketplace resource.
type Marketplace struct {
	*MarketplaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Marketplace.
func (mVar Marketplace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.MarketplaceProperties != nil {
		objectMap["properties"] = mVar.MarketplaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Marketplace struct.
func (mVar *Marketplace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var marketplaceProperties MarketplaceProperties
				err = json.Unmarshal(*v, &marketplaceProperties)
				if err != nil {
					return err
				}
				mVar.MarketplaceProperties = &marketplaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mVar.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		}
	}

	return nil
}

// MarketplaceProperties the properties of the marketplace usage detail.
type MarketplaceProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; The start of the date time range covered by the usage detail.
	UsageStart *date.Time `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; The end of the date time range covered by the usage detail.
	UsageEnd *date.Time `json:"usageEnd,omitempty"`
	// ResourceRate - READ-ONLY; The marketplace resource rate.
	ResourceRate *decimal.Decimal `json:"resourceRate,omitempty"`
	// OfferName - READ-ONLY; The type of offer.
	OfferName *string `json:"offerName,omitempty"`
	// ResourceGroup - READ-ONLY; The name of resource group.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// AdditionalInfo - READ-ONLY; Additional information.
	AdditionalInfo *string `json:"additionalInfo,omitempty"`
	// OrderNumber - READ-ONLY; The order number.
	OrderNumber *string `json:"orderNumber,omitempty"`
	// InstanceName - READ-ONLY; The name of the resource instance that the usage is about.
	InstanceName *string `json:"instanceName,omitempty"`
	// InstanceID - READ-ONLY; The uri of the resource instance that the usage is about.
	InstanceID *string `json:"instanceId,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// ConsumedQuantity - READ-ONLY; The quantity of usage.
	ConsumedQuantity *decimal.Decimal `json:"consumedQuantity,omitempty"`
	// UnitOfMeasure - READ-ONLY; The unit of measure.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// PretaxCost - READ-ONLY; The amount of cost before tax.
	PretaxCost *decimal.Decimal `json:"pretaxCost,omitempty"`
	// IsEstimated - READ-ONLY; The estimated usage is subject to change.
	IsEstimated *bool `json:"isEstimated,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID).
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// SubscriptionGUID - READ-ONLY; Subscription guid.
	SubscriptionGUID *uuid.UUID `json:"subscriptionGuid,omitempty"`
	// SubscriptionName - READ-ONLY; Subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// AccountName - READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty"`
	// DepartmentName - READ-ONLY; Department name.
	DepartmentName *string `json:"departmentName,omitempty"`
	// ConsumedService - READ-ONLY; Consumed service name.
	ConsumedService *string `json:"consumedService,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a costcenter exists
	CostCenter *string `json:"costCenter,omitempty"`
	// AdditionalProperties - READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand.
	AdditionalProperties *string `json:"additionalProperties,omitempty"`
	// PublisherName - READ-ONLY; The name of publisher.
	PublisherName *string `json:"publisherName,omitempty"`
	// PlanName - READ-ONLY; The name of plan.
	PlanName *string `json:"planName,omitempty"`
	// IsRecurringCharge - READ-ONLY; Flag indicating whether this is a recurring charge or not.
	IsRecurringCharge *bool `json:"isRecurringCharge,omitempty"`
}

// MarshalJSON is the custom marshaler for MarketplaceProperties.
func (mp MarketplaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MarketplacesListResult result of listing marketplaces. It contains a list of available marketplaces in
// reverse chronological order by billing period.
type MarketplacesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of marketplaces.
	Value *[]Marketplace `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for MarketplacesListResult.
func (mlr MarketplacesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MarketplacesListResultIterator provides access to a complete listing of Marketplace values.
type MarketplacesListResultIterator struct {
	i    int
	page MarketplacesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MarketplacesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MarketplacesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MarketplacesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MarketplacesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MarketplacesListResultIterator) Response() MarketplacesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MarketplacesListResultIterator) Value() Marketplace {
	if !iter.page.NotDone() {
		return Marketplace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MarketplacesListResultIterator type.
func NewMarketplacesListResultIterator(page MarketplacesListResultPage) MarketplacesListResultIterator {
	return MarketplacesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mlr MarketplacesListResult) IsEmpty() bool {
	return mlr.Value == nil || len(*mlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mlr MarketplacesListResult) hasNextLink() bool {
	return mlr.NextLink != nil && len(*mlr.NextLink) != 0
}

// marketplacesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mlr MarketplacesListResult) marketplacesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mlr.NextLink)))
}

// MarketplacesListResultPage contains a page of Marketplace values.
type MarketplacesListResultPage struct {
	fn  func(context.Context, MarketplacesListResult) (MarketplacesListResult, error)
	mlr MarketplacesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MarketplacesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MarketplacesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mlr)
		if err != nil {
			return err
		}
		page.mlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MarketplacesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MarketplacesListResultPage) NotDone() bool {
	return !page.mlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MarketplacesListResultPage) Response() MarketplacesListResult {
	return page.mlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MarketplacesListResultPage) Values() []Marketplace {
	if page.mlr.IsEmpty() {
		return nil
	}
	return *page.mlr.Value
}

// Creates a new instance of the MarketplacesListResultPage type.
func NewMarketplacesListResultPage(cur MarketplacesListResult, getNextPage func(context.Context, MarketplacesListResult) (MarketplacesListResult, error)) MarketplacesListResultPage {
	return MarketplacesListResultPage{
		fn:  getNextPage,
		mlr: cur,
	}
}

// MeterDetails the properties of the meter detail.
type MeterDetails struct {
	// MeterName - READ-ONLY; The name of the meter, within the given meter category
	MeterName *string `json:"meterName,omitempty"`
	// MeterCategory - READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string `json:"meterCategory,omitempty"`
	// MeterSubCategory - READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string `json:"meterSubCategory,omitempty"`
	// Unit - READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	Unit *string `json:"unit,omitempty"`
	// MeterLocation - READ-ONLY; The location in which the Azure service is available.
	MeterLocation *string `json:"meterLocation,omitempty"`
	// TotalIncludedQuantity - READ-ONLY; The total included quantity associated with the offer.
	TotalIncludedQuantity *decimal.Decimal `json:"totalIncludedQuantity,omitempty"`
	// PretaxStandardRate - READ-ONLY; The pretax listing price.
	PretaxStandardRate *decimal.Decimal `json:"pretaxStandardRate,omitempty"`
	// ServiceName - READ-ONLY; The name of the service.
	ServiceName *string `json:"serviceName,omitempty"`
	// ServiceTier - READ-ONLY; The service tier.
	ServiceTier *string `json:"serviceTier,omitempty"`
}

// MarshalJSON is the custom marshaler for MeterDetails.
func (md MeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MeterDetailsResponse the properties of the meter detail.
type MeterDetailsResponse struct {
	// MeterName - READ-ONLY; The name of the meter, within the given meter category
	MeterName *string `json:"meterName,omitempty"`
	// MeterCategory - READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string `json:"meterCategory,omitempty"`
	// MeterSubCategory - READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string `json:"meterSubCategory,omitempty"`
	// UnitOfMeasure - READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// ServiceFamily - READ-ONLY; The service family.
	ServiceFamily *string `json:"serviceFamily,omitempty"`
}

// MarshalJSON is the custom marshaler for MeterDetailsResponse.
func (mdr MeterDetailsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ModernChargeSummary modern charge summary.
type ModernChargeSummary struct {
	// ModernChargeSummaryProperties - Properties for modern charge summary
	*ModernChargeSummaryProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicChargeSummaryKindChargeSummary', 'KindBasicChargeSummaryKindLegacy', 'KindBasicChargeSummaryKindModern'
	Kind KindBasicChargeSummary `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModernChargeSummary.
func (mcs ModernChargeSummary) MarshalJSON() ([]byte, error) {
	mcs.Kind = KindBasicChargeSummaryKindModern
	objectMap := make(map[string]interface{})
	if mcs.ModernChargeSummaryProperties != nil {
		objectMap["properties"] = mcs.ModernChargeSummaryProperties
	}
	if mcs.Kind != "" {
		objectMap["kind"] = mcs.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyChargeSummary is the BasicChargeSummary implementation for ModernChargeSummary.
func (mcs ModernChargeSummary) AsLegacyChargeSummary() (*LegacyChargeSummary, bool) {
	return nil, false
}

// AsModernChargeSummary is the BasicChargeSummary implementation for ModernChargeSummary.
func (mcs ModernChargeSummary) AsModernChargeSummary() (*ModernChargeSummary, bool) {
	return &mcs, true
}

// AsChargeSummary is the BasicChargeSummary implementation for ModernChargeSummary.
func (mcs ModernChargeSummary) AsChargeSummary() (*ChargeSummary, bool) {
	return nil, false
}

// AsBasicChargeSummary is the BasicChargeSummary implementation for ModernChargeSummary.
func (mcs ModernChargeSummary) AsBasicChargeSummary() (BasicChargeSummary, bool) {
	return &mcs, true
}

// UnmarshalJSON is the custom unmarshaler for ModernChargeSummary struct.
func (mcs *ModernChargeSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var modernChargeSummaryProperties ModernChargeSummaryProperties
				err = json.Unmarshal(*v, &modernChargeSummaryProperties)
				if err != nil {
					return err
				}
				mcs.ModernChargeSummaryProperties = &modernChargeSummaryProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicChargeSummary
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcs.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mcs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mcs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mcs.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mcs.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mcs.Tags = tags
			}
		}
	}

	return nil
}

// ModernChargeSummaryProperties the properties of modern charge summary.
type ModernChargeSummaryProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// UsageStart - READ-ONLY; Usage start date.
	UsageStart *string `json:"usageStart,omitempty"`
	// UsageEnd - READ-ONLY; Usage end date.
	UsageEnd *string `json:"usageEnd,omitempty"`
	// AzureCharges - READ-ONLY; Azure Charges.
	AzureCharges *Amount `json:"azureCharges,omitempty"`
	// ChargesBilledSeparately - READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *Amount `json:"chargesBilledSeparately,omitempty"`
	// MarketplaceCharges - READ-ONLY; Marketplace Charges.
	MarketplaceCharges *Amount `json:"marketplaceCharges,omitempty"`
	// BillingAccountID - READ-ONLY; Billing Account Id
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingProfileID - READ-ONLY; Billing Profile Id
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice Section Id
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// CustomerID - READ-ONLY; Customer Id
	CustomerID *string `json:"customerId,omitempty"`
	// IsInvoiced - READ-ONLY; Is charge Invoiced
	IsInvoiced *bool `json:"isInvoiced,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernChargeSummaryProperties.
func (mcsp ModernChargeSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ModernReservationRecommendation modern reservation recommendation.
type ModernReservationRecommendation struct {
	// ModernReservationRecommendationProperties - Properties for modern reservation recommendation
	*ModernReservationRecommendationProperties `json:"properties,omitempty"`
	// ETag - READ-ONLY; Resource eTag.
	ETag *string `json:"eTag,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku *string `json:"sku,omitempty"`
	// Kind - Possible values include: 'KindBasicReservationRecommendationKindReservationRecommendation', 'KindBasicReservationRecommendationKindLegacy', 'KindBasicReservationRecommendationKindModern'
	Kind KindBasicReservationRecommendation `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernReservationRecommendation.
func (mrr ModernReservationRecommendation) MarshalJSON() ([]byte, error) {
	mrr.Kind = KindBasicReservationRecommendationKindModern
	objectMap := make(map[string]interface{})
	if mrr.ModernReservationRecommendationProperties != nil {
		objectMap["properties"] = mrr.ModernReservationRecommendationProperties
	}
	if mrr.Kind != "" {
		objectMap["kind"] = mrr.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyReservationRecommendation is the BasicReservationRecommendation implementation for ModernReservationRecommendation.
func (mrr ModernReservationRecommendation) AsLegacyReservationRecommendation() (*LegacyReservationRecommendation, bool) {
	return nil, false
}

// AsModernReservationRecommendation is the BasicReservationRecommendation implementation for ModernReservationRecommendation.
func (mrr ModernReservationRecommendation) AsModernReservationRecommendation() (*ModernReservationRecommendation, bool) {
	return &mrr, true
}

// AsReservationRecommendation is the BasicReservationRecommendation implementation for ModernReservationRecommendation.
func (mrr ModernReservationRecommendation) AsReservationRecommendation() (*ReservationRecommendation, bool) {
	return nil, false
}

// AsBasicReservationRecommendation is the BasicReservationRecommendation implementation for ModernReservationRecommendation.
func (mrr ModernReservationRecommendation) AsBasicReservationRecommendation() (BasicReservationRecommendation, bool) {
	return &mrr, true
}

// UnmarshalJSON is the custom unmarshaler for ModernReservationRecommendation struct.
func (mrr *ModernReservationRecommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var modernReservationRecommendationProperties ModernReservationRecommendationProperties
				err = json.Unmarshal(*v, &modernReservationRecommendationProperties)
				if err != nil {
					return err
				}
				mrr.ModernReservationRecommendationProperties = &modernReservationRecommendationProperties
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				mrr.ETag = &eTag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mrr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mrr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mrr.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mrr.Location = &location
			}
		case "sku":
			if v != nil {
				var sku string
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mrr.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind KindBasicReservationRecommendation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mrr.Kind = kind
			}
		}
	}

	return nil
}

// ModernReservationRecommendationProperties the properties of the reservation recommendation.
type ModernReservationRecommendationProperties struct {
	// Location - READ-ONLY; Resource Location.
	Location *string `json:"location,omitempty"`
	// LookBackPeriod - READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *int32 `json:"lookBackPeriod,omitempty"`
	// InstanceFlexibilityRatio - READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float64 `json:"instanceFlexibilityRatio,omitempty"`
	// InstanceFlexibilityGroup - READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty"`
	// NormalizedSize - READ-ONLY; The normalized Size.
	NormalizedSize *string `json:"normalizedSize,omitempty"`
	// RecommendedQuantityNormalized - READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float64 `json:"recommendedQuantityNormalized,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID)
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// Term - READ-ONLY; RI recommendations in one or three year terms.
	Term *string `json:"term,omitempty"`
	// CostWithNoReservedInstances - READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *Amount `json:"costWithNoReservedInstances,omitempty"`
	// RecommendedQuantity - READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *decimal.Decimal `json:"recommendedQuantity,omitempty"`
	// TotalCostWithReservedInstances - READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *Amount `json:"totalCostWithReservedInstances,omitempty"`
	// NetSavings - READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *Amount `json:"netSavings,omitempty"`
	// FirstUsageDate - READ-ONLY; The usage date for looking back.
	FirstUsageDate *date.Time `json:"firstUsageDate,omitempty"`
	// Scope - READ-ONLY; Shared or single recommendation.
	Scope *string `json:"scope,omitempty"`
	// SkuProperties - READ-ONLY; List of sku properties
	SkuProperties *[]SkuProperty `json:"skuProperties,omitempty"`
	// SkuName - READ-ONLY; This is the ARM Sku name.
	SkuName *string `json:"skuName,omitempty"`
	// ResourceType - READ-ONLY; The Azure resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// SubscriptionID - READ-ONLY; The Azure subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernReservationRecommendationProperties.
func (mrrp ModernReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ModernReservationTransaction modern Reservation transaction resource.
type ModernReservationTransaction struct {
	*ModernReservationTransactionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernReservationTransaction.
func (mrt ModernReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrt.ModernReservationTransactionProperties != nil {
		objectMap["properties"] = mrt.ModernReservationTransactionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ModernReservationTransaction struct.
func (mrt *ModernReservationTransaction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var modernReservationTransactionProperties ModernReservationTransactionProperties
				err = json.Unmarshal(*v, &modernReservationTransactionProperties)
				if err != nil {
					return err
				}
				mrt.ModernReservationTransactionProperties = &modernReservationTransactionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mrt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mrt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mrt.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mrt.Tags = &tags
			}
		}
	}

	return nil
}

// ModernReservationTransactionProperties the properties of a modern reservation transaction.
type ModernReservationTransactionProperties struct {
	// Amount - READ-ONLY; The charge of the transaction.
	Amount *decimal.Decimal `json:"amount,omitempty"`
	// ArmSkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSkuName *string `json:"armSkuName,omitempty"`
	// BillingFrequency - READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string `json:"billingFrequency,omitempty"`
	// BillingProfileID - READ-ONLY; Billing profile Id.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing profile name.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// Currency - READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string `json:"currency,omitempty"`
	// Description - READ-ONLY; The description of the transaction.
	Description *string `json:"description,omitempty"`
	// EventDate - READ-ONLY; The date of the transaction
	EventDate *date.Time `json:"eventDate,omitempty"`
	// EventType - READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string `json:"eventType,omitempty"`
	// Invoice - READ-ONLY; Invoice Number
	Invoice *string `json:"invoice,omitempty"`
	// InvoiceID - READ-ONLY; Invoice Id as on the invoice where the specific transaction appears.
	InvoiceID *string `json:"invoiceId,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice Section Id
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Invoice Section Name.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// PurchasingSubscriptionGUID - READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *uuid.UUID `json:"purchasingSubscriptionGuid,omitempty"`
	// PurchasingSubscriptionName - READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string `json:"purchasingSubscriptionName,omitempty"`
	// Quantity - READ-ONLY; The quantity of the transaction.
	Quantity *decimal.Decimal `json:"quantity,omitempty"`
	// Region - READ-ONLY; The region of the transaction.
	Region *string `json:"region,omitempty"`
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// ReservationOrderName - READ-ONLY; The name of the reservation order.
	ReservationOrderName *string `json:"reservationOrderName,omitempty"`
	// Term - READ-ONLY; This is the term of the transaction.
	Term *string `json:"term,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernReservationTransactionProperties.
func (mrtp ModernReservationTransactionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ModernReservationTransactionsListResult result of listing reservation recommendations.
type ModernReservationTransactionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation recommendations.
	Value *[]ModernReservationTransaction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernReservationTransactionsListResult.
func (mrtlr ModernReservationTransactionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ModernReservationTransactionsListResultIterator provides access to a complete listing of
// ModernReservationTransaction values.
type ModernReservationTransactionsListResultIterator struct {
	i    int
	page ModernReservationTransactionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ModernReservationTransactionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModernReservationTransactionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ModernReservationTransactionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ModernReservationTransactionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ModernReservationTransactionsListResultIterator) Response() ModernReservationTransactionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ModernReservationTransactionsListResultIterator) Value() ModernReservationTransaction {
	if !iter.page.NotDone() {
		return ModernReservationTransaction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ModernReservationTransactionsListResultIterator type.
func NewModernReservationTransactionsListResultIterator(page ModernReservationTransactionsListResultPage) ModernReservationTransactionsListResultIterator {
	return ModernReservationTransactionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrtlr ModernReservationTransactionsListResult) IsEmpty() bool {
	return mrtlr.Value == nil || len(*mrtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrtlr ModernReservationTransactionsListResult) hasNextLink() bool {
	return mrtlr.NextLink != nil && len(*mrtlr.NextLink) != 0
}

// modernReservationTransactionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrtlr ModernReservationTransactionsListResult) modernReservationTransactionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mrtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrtlr.NextLink)))
}

// ModernReservationTransactionsListResultPage contains a page of ModernReservationTransaction values.
type ModernReservationTransactionsListResultPage struct {
	fn    func(context.Context, ModernReservationTransactionsListResult) (ModernReservationTransactionsListResult, error)
	mrtlr ModernReservationTransactionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ModernReservationTransactionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModernReservationTransactionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrtlr)
		if err != nil {
			return err
		}
		page.mrtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ModernReservationTransactionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ModernReservationTransactionsListResultPage) NotDone() bool {
	return !page.mrtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ModernReservationTransactionsListResultPage) Response() ModernReservationTransactionsListResult {
	return page.mrtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ModernReservationTransactionsListResultPage) Values() []ModernReservationTransaction {
	if page.mrtlr.IsEmpty() {
		return nil
	}
	return *page.mrtlr.Value
}

// Creates a new instance of the ModernReservationTransactionsListResultPage type.
func NewModernReservationTransactionsListResultPage(cur ModernReservationTransactionsListResult, getNextPage func(context.Context, ModernReservationTransactionsListResult) (ModernReservationTransactionsListResult, error)) ModernReservationTransactionsListResultPage {
	return ModernReservationTransactionsListResultPage{
		fn:    getNextPage,
		mrtlr: cur,
	}
}

// ModernUsageDetail modern usage detail.
type ModernUsageDetail struct {
	// ModernUsageDetailProperties - Properties for modern usage details
	*ModernUsageDetailProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindUsageDetail', 'KindLegacy', 'KindModern'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ModernUsageDetail.
func (mud ModernUsageDetail) MarshalJSON() ([]byte, error) {
	mud.Kind = KindModern
	objectMap := make(map[string]interface{})
	if mud.ModernUsageDetailProperties != nil {
		objectMap["properties"] = mud.ModernUsageDetailProperties
	}
	if mud.Kind != "" {
		objectMap["kind"] = mud.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyUsageDetail is the BasicUsageDetail implementation for ModernUsageDetail.
func (mud ModernUsageDetail) AsLegacyUsageDetail() (*LegacyUsageDetail, bool) {
	return nil, false
}

// AsModernUsageDetail is the BasicUsageDetail implementation for ModernUsageDetail.
func (mud ModernUsageDetail) AsModernUsageDetail() (*ModernUsageDetail, bool) {
	return &mud, true
}

// AsUsageDetail is the BasicUsageDetail implementation for ModernUsageDetail.
func (mud ModernUsageDetail) AsUsageDetail() (*UsageDetail, bool) {
	return nil, false
}

// AsBasicUsageDetail is the BasicUsageDetail implementation for ModernUsageDetail.
func (mud ModernUsageDetail) AsBasicUsageDetail() (BasicUsageDetail, bool) {
	return &mud, true
}

// UnmarshalJSON is the custom unmarshaler for ModernUsageDetail struct.
func (mud *ModernUsageDetail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var modernUsageDetailProperties ModernUsageDetailProperties
				err = json.Unmarshal(*v, &modernUsageDetailProperties)
				if err != nil {
					return err
				}
				mud.ModernUsageDetailProperties = &modernUsageDetailProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mud.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mud.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mud.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mud.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mud.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mud.Tags = tags
			}
		}
	}

	return nil
}

// ModernUsageDetailProperties the properties of the usage detail.
type ModernUsageDetailProperties struct {
	// BillingAccountID - READ-ONLY; Billing Account identifier.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingAccountName - READ-ONLY; Name of the Billing Account.
	BillingAccountName *string `json:"billingAccountName,omitempty"`
	// BillingPeriodStartDate - READ-ONLY; Billing Period Start Date as in the invoice.
	BillingPeriodStartDate *date.Time `json:"billingPeriodStartDate,omitempty"`
	// BillingPeriodEndDate - READ-ONLY; Billing Period End Date as in the invoice.
	BillingPeriodEndDate *date.Time `json:"billingPeriodEndDate,omitempty"`
	// BillingProfileID - READ-ONLY; Identifier for the billing profile that groups costs across invoices in the a singular billing currency across across the customers who have onboarded the Microsoft customer agreement and the customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Name of the billing profile that groups costs across invoices in the a singular billing currency across across the customers who have onboarded the Microsoft customer agreement and the customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// SubscriptionGUID - READ-ONLY; Unique Microsoft generated identifier for the Azure Subscription.
	SubscriptionGUID *string `json:"subscriptionGuid,omitempty"`
	// SubscriptionName - READ-ONLY; Name of the Azure Subscription.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// Date - READ-ONLY; Date for the usage record.
	Date *date.Time `json:"date,omitempty"`
	// Product - READ-ONLY; Name of the product that has accrued charges by consumption or purchase as listed in the invoice. Not available for Marketplace.
	Product *string `json:"product,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter for which the reservation was purchased. For the actual VM Size for which the reservation is purchased see productOrderName.
	MeterID *string `json:"meterId,omitempty"`
	// MeterName - READ-ONLY; Identifies the name of the meter against which consumption is measured.
	MeterName *string `json:"meterName,omitempty"`
	// MeterRegion - READ-ONLY; Identifies the location of the datacenter for certain services that are priced based on datacenter location.
	MeterRegion *string `json:"meterRegion,omitempty"`
	// MeterCategory - READ-ONLY; Identifies the top-level service for the usage.
	MeterCategory *string `json:"meterCategory,omitempty"`
	// MeterSubCategory - READ-ONLY; Defines the type or sub-category of Azure service that can affect the rate.
	MeterSubCategory *string `json:"meterSubCategory,omitempty"`
	// ServiceFamily - READ-ONLY; List the service family for the product purchased or charged (Example: Storage ; Compute).
	ServiceFamily *string `json:"serviceFamily,omitempty"`
	// Quantity - READ-ONLY; Measure the quantity purchased or consumed.The amount of the meter used during the billing period.
	Quantity *decimal.Decimal `json:"quantity,omitempty"`
	// UnitOfMeasure - READ-ONLY; Identifies the Unit that the service is charged in. For example, GB, hours, 10,000 s.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// InstanceName - READ-ONLY; Instance Name.
	InstanceName *string `json:"instanceName,omitempty"`
	// CostInUSD - READ-ONLY; Estimated extendedCost or blended cost before tax in USD.
	CostInUSD *decimal.Decimal `json:"costInUSD,omitempty"`
	// UnitPrice - READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *decimal.Decimal `json:"unitPrice,omitempty"`
	// BillingCurrencyCode - READ-ONLY; The currency defining the billed cost.
	BillingCurrencyCode *string `json:"billingCurrencyCode,omitempty"`
	// ResourceLocation - READ-ONLY; Name of the resource location.
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// ConsumedService - READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value is not provided for marketplace usage.
	ConsumedService *string `json:"consumedService,omitempty"`
	// ServiceInfo1 - READ-ONLY; Service Info 1.
	ServiceInfo1 *string `json:"serviceInfo1,omitempty"`
	// ServiceInfo2 - READ-ONLY; Service Info 2.
	ServiceInfo2 *string `json:"serviceInfo2,omitempty"`
	// AdditionalInfo - READ-ONLY; Additional details of this usage item. Use this field to get usage line item specific details such as the actual VM Size (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string `json:"additionalInfo,omitempty"`
	// InvoiceSectionID - READ-ONLY; Identifier of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded by partners.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Name of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded by partners.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// CostCenter - READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string `json:"costCenter,omitempty"`
	// ResourceGroup - READ-ONLY; Name of the Azure resource group used for cohesive lifecycle management of resources.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ReservationID - READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string `json:"reservationId,omitempty"`
	// ReservationName - READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily data. Only applies to records relevant to reservations.
	ReservationName *string `json:"reservationName,omitempty"`
	// ProductOrderID - READ-ONLY; The identifier for the asset or Azure plan name that the subscription belongs to. For example: Azure Plan. For reservations this is the Reservation Order ID.
	ProductOrderID *string `json:"productOrderId,omitempty"`
	// ProductOrderName - READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string `json:"productOrderName,omitempty"`
	// IsAzureCreditEligible - READ-ONLY; Determines if the cost is eligible to be paid for using Azure credits.
	IsAzureCreditEligible *bool `json:"isAzureCreditEligible,omitempty"`
	// Term - READ-ONLY; Term (in months). Displays the term for the validity of the offer. For example. In case of reserved instances it displays 12 months for yearly term of reserved instance. For one time purchases or recurring purchases, the terms displays 1 month; This is not applicable for Azure consumption.
	Term *string `json:"term,omitempty"`
	// PublisherName - READ-ONLY; Name of the publisher of the service including Microsoft or Third Party publishers.
	PublisherName *string `json:"publisherName,omitempty"`
	// PublisherType - READ-ONLY; Type of publisher that identifies if the publisher is first party, third party reseller or third party agency.
	PublisherType *string `json:"publisherType,omitempty"`
	// ChargeType - READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string `json:"chargeType,omitempty"`
	// Frequency - READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string `json:"frequency,omitempty"`
	// CostInBillingCurrency - READ-ONLY; ExtendedCost or blended cost before tax in billed currency.
	CostInBillingCurrency *decimal.Decimal `json:"costInBillingCurrency,omitempty"`
	// CostInPricingCurrency - READ-ONLY; ExtendedCost or blended cost before tax in pricing currency to correlate with prices.
	CostInPricingCurrency *decimal.Decimal `json:"costInPricingCurrency,omitempty"`
	// ExchangeRate - READ-ONLY; Exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRate *string `json:"exchangeRate,omitempty"`
	// ExchangeRateDate - READ-ONLY; Date on which exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRateDate *date.Time `json:"exchangeRateDate,omitempty"`
	// InvoiceID - READ-ONLY; Invoice ID as on the invoice where the specific transaction appears.
	InvoiceID *string `json:"invoiceId,omitempty"`
	// PreviousInvoiceID - READ-ONLY; Reference to an original invoice there is a refund (negative cost). This is populated only when there is a refund.
	PreviousInvoiceID *string `json:"previousInvoiceId,omitempty"`
	// PricingCurrencyCode - READ-ONLY; Pricing Billing Currency.
	PricingCurrencyCode *string `json:"pricingCurrencyCode,omitempty"`
	// ProductIdentifier - READ-ONLY; Identifier for the product that has accrued charges by consumption or purchase . This is the concatenated key of productId and SkuId in partner center.
	ProductIdentifier *string `json:"productIdentifier,omitempty"`
	// ResourceLocationNormalized - READ-ONLY; Resource Location Normalized.
	ResourceLocationNormalized *string `json:"resourceLocationNormalized,omitempty"`
	// ServicePeriodStartDate - READ-ONLY; Start date for the rating period when the service usage was rated for charges. The prices for Azure services are determined for the rating period.
	ServicePeriodStartDate *date.Time `json:"servicePeriodStartDate,omitempty"`
	// ServicePeriodEndDate - READ-ONLY; End date for the period when the service usage was rated for charges. The prices for Azure services are determined based on the rating period.
	ServicePeriodEndDate *date.Time `json:"servicePeriodEndDate,omitempty"`
	// CustomerTenantID - READ-ONLY; Identifier of the customer's AAD tenant.
	CustomerTenantID *string `json:"customerTenantId,omitempty"`
	// CustomerName - READ-ONLY; Name of the customer's AAD tenant.
	CustomerName *string `json:"customerName,omitempty"`
	// PartnerTenantID - READ-ONLY; Identifier for the partner's AAD tenant.
	PartnerTenantID *string `json:"partnerTenantId,omitempty"`
	// PartnerName - READ-ONLY; Name of the partner' AAD tenant.
	PartnerName *string `json:"partnerName,omitempty"`
	// ResellerMpnID - READ-ONLY; MPNId for the reseller associated with the subscription.
	ResellerMpnID *string `json:"resellerMpnId,omitempty"`
	// ResellerName - READ-ONLY; Reseller Name.
	ResellerName *string `json:"resellerName,omitempty"`
	// PublisherID - READ-ONLY; Publisher Id.
	PublisherID *string `json:"publisherId,omitempty"`
	// MarketPrice - READ-ONLY; Market Price that's charged for the usage.
	MarketPrice *decimal.Decimal `json:"marketPrice,omitempty"`
	// ExchangeRatePricingToBilling - READ-ONLY; Exchange Rate from pricing currency to billing currency.
	ExchangeRatePricingToBilling *decimal.Decimal `json:"exchangeRatePricingToBilling,omitempty"`
	// PaygCostInBillingCurrency - READ-ONLY; The amount of PayG cost before tax in billing currency.
	PaygCostInBillingCurrency *decimal.Decimal `json:"paygCostInBillingCurrency,omitempty"`
	// PaygCostInUSD - READ-ONLY; The amount of PayG cost before tax in US Dollar currency.
	PaygCostInUSD *decimal.Decimal `json:"paygCostInUSD,omitempty"`
	// PartnerEarnedCreditRate - READ-ONLY; Rate of discount applied if there is a partner earned credit (PEC) based on partner admin link access.
	PartnerEarnedCreditRate *decimal.Decimal `json:"partnerEarnedCreditRate,omitempty"`
	// PartnerEarnedCreditApplied - READ-ONLY; Flag to indicate if partner earned credit has been applied or not.
	PartnerEarnedCreditApplied *string `json:"partnerEarnedCreditApplied,omitempty"`
	// PayGPrice - READ-ONLY; Retail price for the resource.
	PayGPrice *decimal.Decimal `json:"payGPrice,omitempty"`
}

// MarshalJSON is the custom marshaler for ModernUsageDetailProperties.
func (mudp ModernUsageDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Notification the notification associated with a budget.
type Notification struct {
	// Enabled - The notification is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Operator - The comparison operator. Possible values include: 'OperatorTypeEqualTo', 'OperatorTypeGreaterThan', 'OperatorTypeGreaterThanOrEqualTo'
	Operator OperatorType `json:"operator,omitempty"`
	// Threshold - Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
	Threshold *decimal.Decimal `json:"threshold,omitempty"`
	// ContactEmails - Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
	ContactEmails *[]string `json:"contactEmails,omitempty"`
	// ContactRoles - Contact roles to send the budget notification to when the threshold is exceeded.
	ContactRoles *[]string `json:"contactRoles,omitempty"`
	// ContactGroups - Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
	ContactGroups *[]string `json:"contactGroups,omitempty"`
	// ThresholdType - The type of threshold. Possible values include: 'ThresholdTypeActual'
	ThresholdType ThresholdType `json:"thresholdType,omitempty"`
	// Locale - Language in which the recipient will receive the notification. Possible values include: 'CultureCodeEnUs', 'CultureCodeJaJp', 'CultureCodeZhCn', 'CultureCodeDeDe', 'CultureCodeEsEs', 'CultureCodeFrFr', 'CultureCodeItIt', 'CultureCodeKoKr', 'CultureCodePtBr', 'CultureCodeRuRu', 'CultureCodeZhTw', 'CultureCodeCsCz', 'CultureCodePlPl', 'CultureCodeTrTr', 'CultureCodeDaDk', 'CultureCodeEnGb', 'CultureCodeHuHu', 'CultureCodeNbNo', 'CultureCodeNlNl', 'CultureCodePtPt', 'CultureCodeSvSe'
	Locale CultureCode `json:"locale,omitempty"`
}

// Operation a Consumption REST API operation.
type Operation struct {
	// ID - READ-ONLY; Operation Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Consumption.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of listing consumption operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of consumption operations supported by the Microsoft.Consumption resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PriceSheetModel price sheet result. It contains the pricesheet associated with billing period
type PriceSheetModel struct {
	// Pricesheets - READ-ONLY; Price sheet
	Pricesheets *[]PriceSheetProperties `json:"pricesheets,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
	// Download - READ-ONLY; Pricesheet download details.
	Download *MeterDetails `json:"download,omitempty"`
}

// MarshalJSON is the custom marshaler for PriceSheetModel.
func (psm PriceSheetModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PriceSheetProperties the properties of the price sheet.
type PriceSheetProperties struct {
	// BillingPeriodID - READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string `json:"billingPeriodId,omitempty"`
	// MeterID - READ-ONLY; The meter id (GUID)
	MeterID *uuid.UUID `json:"meterId,omitempty"`
	// MeterDetails - READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetails `json:"meterDetails,omitempty"`
	// UnitOfMeasure - READ-ONLY; Unit of measure
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// IncludedQuantity - READ-ONLY; Included quality for an offer
	IncludedQuantity *decimal.Decimal `json:"includedQuantity,omitempty"`
	// PartNumber - READ-ONLY; Part Number
	PartNumber *string `json:"partNumber,omitempty"`
	// UnitPrice - READ-ONLY; Unit Price
	UnitPrice *decimal.Decimal `json:"unitPrice,omitempty"`
	// CurrencyCode - READ-ONLY; Currency Code
	CurrencyCode *string `json:"currencyCode,omitempty"`
	// OfferID - READ-ONLY; Offer Id
	OfferID *string `json:"offerId,omitempty"`
}

// MarshalJSON is the custom marshaler for PriceSheetProperties.
func (psp PriceSheetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PriceSheetResult an pricesheet resource.
type PriceSheetResult struct {
	autorest.Response `json:"-"`
	*PriceSheetModel  `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PriceSheetResult.
func (psr PriceSheetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psr.PriceSheetModel != nil {
		objectMap["properties"] = psr.PriceSheetModel
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PriceSheetResult struct.
func (psr *PriceSheetResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var priceSheetModel PriceSheetModel
				err = json.Unmarshal(*v, &priceSheetModel)
				if err != nil {
					return err
				}
				psr.PriceSheetModel = &priceSheetModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				psr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				psr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				psr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				psr.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				psr.Tags = tags
			}
		}
	}

	return nil
}

// ProxyResource the Resource model definition.
type ProxyResource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.ETag != nil {
		objectMap["eTag"] = pr.ETag
	}
	return json.Marshal(objectMap)
}

// Reseller reseller details
type Reseller struct {
	// ResellerID - READ-ONLY; Reseller id.
	ResellerID *string `json:"resellerId,omitempty"`
	// ResellerDescription - READ-ONLY; Reseller Description.
	ResellerDescription *string `json:"resellerDescription,omitempty"`
}

// MarshalJSON is the custom marshaler for Reseller.
func (r Reseller) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationDetail reservation detail resource.
type ReservationDetail struct {
	*ReservationDetailProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReservationDetail.
func (rd ReservationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.ReservationDetailProperties != nil {
		objectMap["properties"] = rd.ReservationDetailProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationDetail struct.
func (rd *ReservationDetail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reservationDetailProperties ReservationDetailProperties
				err = json.Unmarshal(*v, &reservationDetailProperties)
				if err != nil {
					return err
				}
				rd.ReservationDetailProperties = &reservationDetailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rd.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rd.Tags = tags
			}
		}
	}

	return nil
}

// ReservationDetailProperties the properties of the reservation detail.
type ReservationDetailProperties struct {
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// InstanceFlexibilityRatio - READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *string `json:"instanceFlexibilityRatio,omitempty"`
	// InstanceFlexibilityGroup - READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string `json:"instanceFlexibilityGroup,omitempty"`
	// ReservationID - READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty"`
	// SkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SkuName *string `json:"skuName,omitempty"`
	// ReservedHours - READ-ONLY; This is the total hours reserved for the day. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days.
	ReservedHours *decimal.Decimal `json:"reservedHours,omitempty"`
	// UsageDate - READ-ONLY; The date on which consumption occurred.
	UsageDate *date.Time `json:"usageDate,omitempty"`
	// UsedHours - READ-ONLY; This is the total hours used by the instance.
	UsedHours *decimal.Decimal `json:"usedHours,omitempty"`
	// InstanceID - READ-ONLY; This identifier is the name of the resource or the fully qualified Resource ID.
	InstanceID *string `json:"instanceId,omitempty"`
	// TotalReservedQuantity - READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *decimal.Decimal `json:"totalReservedQuantity,omitempty"`
	// Kind - READ-ONLY; The reservation kind.
	Kind *string `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationDetailProperties.
func (rdp ReservationDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationDetailsListResult result of listing reservation details.
type ReservationDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation details.
	Value *[]ReservationDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationDetailsListResult.
func (rdlr ReservationDetailsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationDetailsListResultIterator provides access to a complete listing of ReservationDetail values.
type ReservationDetailsListResultIterator struct {
	i    int
	page ReservationDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationDetailsListResultIterator) Response() ReservationDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationDetailsListResultIterator) Value() ReservationDetail {
	if !iter.page.NotDone() {
		return ReservationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationDetailsListResultIterator type.
func NewReservationDetailsListResultIterator(page ReservationDetailsListResultPage) ReservationDetailsListResultIterator {
	return ReservationDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdlr ReservationDetailsListResult) IsEmpty() bool {
	return rdlr.Value == nil || len(*rdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdlr ReservationDetailsListResult) hasNextLink() bool {
	return rdlr.NextLink != nil && len(*rdlr.NextLink) != 0
}

// reservationDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdlr ReservationDetailsListResult) reservationDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdlr.NextLink)))
}

// ReservationDetailsListResultPage contains a page of ReservationDetail values.
type ReservationDetailsListResultPage struct {
	fn   func(context.Context, ReservationDetailsListResult) (ReservationDetailsListResult, error)
	rdlr ReservationDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdlr)
		if err != nil {
			return err
		}
		page.rdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationDetailsListResultPage) NotDone() bool {
	return !page.rdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationDetailsListResultPage) Response() ReservationDetailsListResult {
	return page.rdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationDetailsListResultPage) Values() []ReservationDetail {
	if page.rdlr.IsEmpty() {
		return nil
	}
	return *page.rdlr.Value
}

// Creates a new instance of the ReservationDetailsListResultPage type.
func NewReservationDetailsListResultPage(cur ReservationDetailsListResult, getNextPage func(context.Context, ReservationDetailsListResult) (ReservationDetailsListResult, error)) ReservationDetailsListResultPage {
	return ReservationDetailsListResultPage{
		fn:   getNextPage,
		rdlr: cur,
	}
}

// BasicReservationRecommendation a reservation recommendation resource.
type BasicReservationRecommendation interface {
	AsLegacyReservationRecommendation() (*LegacyReservationRecommendation, bool)
	AsModernReservationRecommendation() (*ModernReservationRecommendation, bool)
	AsReservationRecommendation() (*ReservationRecommendation, bool)
}

// ReservationRecommendation a reservation recommendation resource.
type ReservationRecommendation struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku *string `json:"sku,omitempty"`
	// Kind - Possible values include: 'KindBasicReservationRecommendationKindReservationRecommendation', 'KindBasicReservationRecommendationKindLegacy', 'KindBasicReservationRecommendationKindModern'
	Kind KindBasicReservationRecommendation `json:"kind,omitempty"`
}

func unmarshalBasicReservationRecommendation(body []byte) (BasicReservationRecommendation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicReservationRecommendationKindLegacy):
		var lrr LegacyReservationRecommendation
		err := json.Unmarshal(body, &lrr)
		return lrr, err
	case string(KindBasicReservationRecommendationKindModern):
		var mrr ModernReservationRecommendation
		err := json.Unmarshal(body, &mrr)
		return mrr, err
	default:
		var rr ReservationRecommendation
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicReservationRecommendationArray(body []byte) ([]BasicReservationRecommendation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicReservationRecommendation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicReservationRecommendation(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for ReservationRecommendation.
func (rr ReservationRecommendation) MarshalJSON() ([]byte, error) {
	rr.Kind = KindBasicReservationRecommendationKindReservationRecommendation
	objectMap := make(map[string]interface{})
	if rr.Kind != "" {
		objectMap["kind"] = rr.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyReservationRecommendation is the BasicReservationRecommendation implementation for ReservationRecommendation.
func (rr ReservationRecommendation) AsLegacyReservationRecommendation() (*LegacyReservationRecommendation, bool) {
	return nil, false
}

// AsModernReservationRecommendation is the BasicReservationRecommendation implementation for ReservationRecommendation.
func (rr ReservationRecommendation) AsModernReservationRecommendation() (*ModernReservationRecommendation, bool) {
	return nil, false
}

// AsReservationRecommendation is the BasicReservationRecommendation implementation for ReservationRecommendation.
func (rr ReservationRecommendation) AsReservationRecommendation() (*ReservationRecommendation, bool) {
	return &rr, true
}

// AsBasicReservationRecommendation is the BasicReservationRecommendation implementation for ReservationRecommendation.
func (rr ReservationRecommendation) AsBasicReservationRecommendation() (BasicReservationRecommendation, bool) {
	return &rr, true
}

// ReservationRecommendationDetailsCalculatedSavingsProperties details of estimated savings.
type ReservationRecommendationDetailsCalculatedSavingsProperties struct {
	// OnDemandCost - READ-ONLY; The cost without reservation.
	OnDemandCost *float64 `json:"onDemandCost,omitempty"`
	// OverageCost - READ-ONLY; The difference between total reservation cost and reservation cost.
	OverageCost *float64 `json:"overageCost,omitempty"`
	// Quantity - READ-ONLY; The quantity for calculated savings.
	Quantity *float64 `json:"quantity,omitempty"`
	// ReservationCost - READ-ONLY; The exact cost of the estimated usage using reservation.
	ReservationCost *float64 `json:"reservationCost,omitempty"`
	// TotalReservationCost - READ-ONLY; The cost of the suggested quantity.
	TotalReservationCost *float64 `json:"totalReservationCost,omitempty"`
	// ReservedUnitCount - The number of reserved units used to calculate savings. Always 1 for virtual machines.
	ReservedUnitCount *float64 `json:"reservedUnitCount,omitempty"`
	// Savings - READ-ONLY; The amount saved by purchasing the recommended quantity of reservation.
	Savings *float64 `json:"savings,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsCalculatedSavingsProperties.
func (rrdcsp ReservationRecommendationDetailsCalculatedSavingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrdcsp.ReservedUnitCount != nil {
		objectMap["reservedUnitCount"] = rrdcsp.ReservedUnitCount
	}
	return json.Marshal(objectMap)
}

// ReservationRecommendationDetailsModel reservation recommendation details.
type ReservationRecommendationDetailsModel struct {
	autorest.Response `json:"-"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Sku - Resource sku
	Sku *string `json:"sku,omitempty"`
	// ETag - Resource eTag.
	ETag                                        *string `json:"eTag,omitempty"`
	*ReservationRecommendationDetailsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsModel.
func (rrdm ReservationRecommendationDetailsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrdm.Location != nil {
		objectMap["location"] = rrdm.Location
	}
	if rrdm.Sku != nil {
		objectMap["sku"] = rrdm.Sku
	}
	if rrdm.ETag != nil {
		objectMap["eTag"] = rrdm.ETag
	}
	if rrdm.ReservationRecommendationDetailsProperties != nil {
		objectMap["properties"] = rrdm.ReservationRecommendationDetailsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationRecommendationDetailsModel struct.
func (rrdm *ReservationRecommendationDetailsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rrdm.Location = &location
			}
		case "sku":
			if v != nil {
				var sku string
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rrdm.Sku = &sku
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rrdm.ETag = &eTag
			}
		case "properties":
			if v != nil {
				var reservationRecommendationDetailsProperties ReservationRecommendationDetailsProperties
				err = json.Unmarshal(*v, &reservationRecommendationDetailsProperties)
				if err != nil {
					return err
				}
				rrdm.ReservationRecommendationDetailsProperties = &reservationRecommendationDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rrdm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rrdm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rrdm.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rrdm.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rrdm.Tags = tags
			}
		}
	}

	return nil
}

// ReservationRecommendationDetailsProperties the properties of the reservation recommendation.
type ReservationRecommendationDetailsProperties struct {
	// Currency - READ-ONLY; An ISO 4217 currency code identifier for the costs and savings
	Currency *string `json:"currency,omitempty"`
	// Resource - READ-ONLY; Resource specific properties.
	Resource *ReservationRecommendationDetailsResourceProperties `json:"resource,omitempty"`
	// ResourceGroup - READ-ONLY; Resource Group.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Savings - READ-ONLY; Savings information for the recommendation.
	Savings *ReservationRecommendationDetailsSavingsProperties `json:"savings,omitempty"`
	// Scope - READ-ONLY; Scope of the reservation, ex: Single or Shared.
	Scope *string `json:"scope,omitempty"`
	// Usage - READ-ONLY; Historical usage details used to calculate the estimated savings.
	Usage *ReservationRecommendationDetailsUsageProperties `json:"usage,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsProperties.
func (rrdp ReservationRecommendationDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationRecommendationDetailsResourceProperties details of the resource.
type ReservationRecommendationDetailsResourceProperties struct {
	// AppliedScopes - READ-ONLY; List of subscriptions for which the reservation is applied.
	AppliedScopes *[]string `json:"appliedScopes,omitempty"`
	// OnDemandRate - READ-ONLY; On demand rate of the resource.
	OnDemandRate *float64 `json:"onDemandRate,omitempty"`
	// Product - READ-ONLY; Azure product ex: Standard_E8s_v3 etc.
	Product *string `json:"product,omitempty"`
	// Region - READ-ONLY; Azure resource region ex:EastUS, WestUS etc.
	Region *string `json:"region,omitempty"`
	// ReservationRate - READ-ONLY; Reservation rate of the resource.
	ReservationRate *float64 `json:"reservationRate,omitempty"`
	// ResourceType - READ-ONLY; The azure resource type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsResourceProperties.
func (rrdrp ReservationRecommendationDetailsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationRecommendationDetailsSavingsProperties details of the estimated savings.
type ReservationRecommendationDetailsSavingsProperties struct {
	// CalculatedSavings - List of calculated savings.
	CalculatedSavings *[]ReservationRecommendationDetailsCalculatedSavingsProperties `json:"calculatedSavings,omitempty"`
	// LookBackPeriod - READ-ONLY; Number of days of usage to look back used for computing the recommendation.
	LookBackPeriod *int32 `json:"lookBackPeriod,omitempty"`
	// RecommendedQuantity - READ-ONLY; Number of recommended units of the resource.
	RecommendedQuantity *float64 `json:"recommendedQuantity,omitempty"`
	// ReservationOrderTerm - READ-ONLY; Term period of the reservation, ex: P1Y or P3Y.
	ReservationOrderTerm *string `json:"reservationOrderTerm,omitempty"`
	// SavingsType - READ-ONLY; Type of savings, ex: instance.
	SavingsType *string `json:"savingsType,omitempty"`
	// UnitOfMeasure - READ-ONLY; Measurement unit ex: hour etc.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsSavingsProperties.
func (rrdsp ReservationRecommendationDetailsSavingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rrdsp.CalculatedSavings != nil {
		objectMap["calculatedSavings"] = rrdsp.CalculatedSavings
	}
	return json.Marshal(objectMap)
}

// ReservationRecommendationDetailsUsageProperties details about historical usage data that has been used
// for computing the recommendation.
type ReservationRecommendationDetailsUsageProperties struct {
	// FirstConsumptionDate - READ-ONLY; The first usage date used for looking back for computing the recommendation.
	FirstConsumptionDate *string `json:"firstConsumptionDate,omitempty"`
	// LastConsumptionDate - READ-ONLY; The last usage date used for looking back for computing the recommendation.
	LastConsumptionDate *string `json:"lastConsumptionDate,omitempty"`
	// LookBackUnitType - READ-ONLY; What the usage data values represent ex: virtual machine instance.
	LookBackUnitType *string `json:"lookBackUnitType,omitempty"`
	// UsageData - READ-ONLY; The breakdown of historical resource usage.  The values are in the order of usage between the firstConsumptionDate and the lastConsumptionDate.
	UsageData *[]float64 `json:"usageData,omitempty"`
	// UsageGrain - READ-ONLY; The grain of the values represented in the usage data ex: hourly.
	UsageGrain *string `json:"usageGrain,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationDetailsUsageProperties.
func (rrdup ReservationRecommendationDetailsUsageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationRecommendationsListResult result of listing reservation recommendations.
type ReservationRecommendationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation recommendations.
	Value *[]BasicReservationRecommendation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
	// PreviousLink - READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string `json:"previousLink,omitempty"`
	// TotalCost - READ-ONLY; The total amount of cost.
	TotalCost *string `json:"totalCost,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationRecommendationsListResult.
func (rrlr ReservationRecommendationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationRecommendationsListResult struct.
func (rrlr *ReservationRecommendationsListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicReservationRecommendationArray(*v)
				if err != nil {
					return err
				}
				rrlr.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				rrlr.NextLink = &nextLink
			}
		case "previousLink":
			if v != nil {
				var previousLink string
				err = json.Unmarshal(*v, &previousLink)
				if err != nil {
					return err
				}
				rrlr.PreviousLink = &previousLink
			}
		case "totalCost":
			if v != nil {
				var totalCost string
				err = json.Unmarshal(*v, &totalCost)
				if err != nil {
					return err
				}
				rrlr.TotalCost = &totalCost
			}
		}
	}

	return nil
}

// ReservationRecommendationsListResultIterator provides access to a complete listing of
// ReservationRecommendation values.
type ReservationRecommendationsListResultIterator struct {
	i    int
	page ReservationRecommendationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationRecommendationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationRecommendationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationRecommendationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationRecommendationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationRecommendationsListResultIterator) Response() ReservationRecommendationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationRecommendationsListResultIterator) Value() BasicReservationRecommendation {
	if !iter.page.NotDone() {
		return ReservationRecommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationRecommendationsListResultIterator type.
func NewReservationRecommendationsListResultIterator(page ReservationRecommendationsListResultPage) ReservationRecommendationsListResultIterator {
	return ReservationRecommendationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rrlr ReservationRecommendationsListResult) IsEmpty() bool {
	return rrlr.Value == nil || len(*rrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rrlr ReservationRecommendationsListResult) hasNextLink() bool {
	return rrlr.NextLink != nil && len(*rrlr.NextLink) != 0
}

// reservationRecommendationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rrlr ReservationRecommendationsListResult) reservationRecommendationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rrlr.NextLink)))
}

// ReservationRecommendationsListResultPage contains a page of BasicReservationRecommendation values.
type ReservationRecommendationsListResultPage struct {
	fn   func(context.Context, ReservationRecommendationsListResult) (ReservationRecommendationsListResult, error)
	rrlr ReservationRecommendationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationRecommendationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationRecommendationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rrlr)
		if err != nil {
			return err
		}
		page.rrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationRecommendationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationRecommendationsListResultPage) NotDone() bool {
	return !page.rrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationRecommendationsListResultPage) Response() ReservationRecommendationsListResult {
	return page.rrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationRecommendationsListResultPage) Values() []BasicReservationRecommendation {
	if page.rrlr.IsEmpty() {
		return nil
	}
	return *page.rrlr.Value
}

// Creates a new instance of the ReservationRecommendationsListResultPage type.
func NewReservationRecommendationsListResultPage(cur ReservationRecommendationsListResult, getNextPage func(context.Context, ReservationRecommendationsListResult) (ReservationRecommendationsListResult, error)) ReservationRecommendationsListResultPage {
	return ReservationRecommendationsListResultPage{
		fn:   getNextPage,
		rrlr: cur,
	}
}

// ReservationSummariesListResult result of listing reservation summaries.
type ReservationSummariesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation summaries.
	Value *[]ReservationSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationSummariesListResult.
func (rslr ReservationSummariesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationSummariesListResultIterator provides access to a complete listing of ReservationSummary
// values.
type ReservationSummariesListResultIterator struct {
	i    int
	page ReservationSummariesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationSummariesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationSummariesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationSummariesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationSummariesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationSummariesListResultIterator) Response() ReservationSummariesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationSummariesListResultIterator) Value() ReservationSummary {
	if !iter.page.NotDone() {
		return ReservationSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationSummariesListResultIterator type.
func NewReservationSummariesListResultIterator(page ReservationSummariesListResultPage) ReservationSummariesListResultIterator {
	return ReservationSummariesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rslr ReservationSummariesListResult) IsEmpty() bool {
	return rslr.Value == nil || len(*rslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rslr ReservationSummariesListResult) hasNextLink() bool {
	return rslr.NextLink != nil && len(*rslr.NextLink) != 0
}

// reservationSummariesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rslr ReservationSummariesListResult) reservationSummariesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rslr.NextLink)))
}

// ReservationSummariesListResultPage contains a page of ReservationSummary values.
type ReservationSummariesListResultPage struct {
	fn   func(context.Context, ReservationSummariesListResult) (ReservationSummariesListResult, error)
	rslr ReservationSummariesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationSummariesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationSummariesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rslr)
		if err != nil {
			return err
		}
		page.rslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationSummariesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationSummariesListResultPage) NotDone() bool {
	return !page.rslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationSummariesListResultPage) Response() ReservationSummariesListResult {
	return page.rslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationSummariesListResultPage) Values() []ReservationSummary {
	if page.rslr.IsEmpty() {
		return nil
	}
	return *page.rslr.Value
}

// Creates a new instance of the ReservationSummariesListResultPage type.
func NewReservationSummariesListResultPage(cur ReservationSummariesListResult, getNextPage func(context.Context, ReservationSummariesListResult) (ReservationSummariesListResult, error)) ReservationSummariesListResultPage {
	return ReservationSummariesListResultPage{
		fn:   getNextPage,
		rslr: cur,
	}
}

// ReservationSummary reservation summary resource.
type ReservationSummary struct {
	*ReservationSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReservationSummary.
func (rs ReservationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.ReservationSummaryProperties != nil {
		objectMap["properties"] = rs.ReservationSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationSummary struct.
func (rs *ReservationSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reservationSummaryProperties ReservationSummaryProperties
				err = json.Unmarshal(*v, &reservationSummaryProperties)
				if err != nil {
					return err
				}
				rs.ReservationSummaryProperties = &reservationSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rs.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rs.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rs.Tags = tags
			}
		}
	}

	return nil
}

// ReservationSummaryProperties the properties of the reservation summary.
type ReservationSummaryProperties struct {
	// ReservationOrderID - READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations.
	ReservationOrderID *string `json:"reservationOrderId,omitempty"`
	// ReservationID - READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to.
	ReservationID *string `json:"reservationId,omitempty"`
	// SkuName - READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SkuName *string `json:"skuName,omitempty"`
	// ReservedHours - READ-ONLY; This is the total hours reserved. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days
	ReservedHours *decimal.Decimal `json:"reservedHours,omitempty"`
	// UsageDate - READ-ONLY; Data corresponding to the utilization record. If the grain of data is monthly, it will be first day of month.
	UsageDate *date.Time `json:"usageDate,omitempty"`
	// UsedHours - READ-ONLY; Total used hours by the reservation
	UsedHours *decimal.Decimal `json:"usedHours,omitempty"`
	// MinUtilizationPercentage - READ-ONLY; This is the minimum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 10%, this field will return 10% for that day
	MinUtilizationPercentage *decimal.Decimal `json:"minUtilizationPercentage,omitempty"`
	// AvgUtilizationPercentage - READ-ONLY; This is average utilization for the entire time range. (day or month depending on the grain)
	AvgUtilizationPercentage *decimal.Decimal `json:"avgUtilizationPercentage,omitempty"`
	// MaxUtilizationPercentage - READ-ONLY; This is the maximum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 100%, this field will return 100% for that day.
	MaxUtilizationPercentage *decimal.Decimal `json:"maxUtilizationPercentage,omitempty"`
	// Kind - READ-ONLY; The reservation kind.
	Kind *string `json:"kind,omitempty"`
	// PurchasedQuantity - READ-ONLY; This is the purchased quantity for the reservationId.
	PurchasedQuantity *decimal.Decimal `json:"purchasedQuantity,omitempty"`
	// RemainingQuantity - READ-ONLY; This is the remaining quantity for the reservationId.
	RemainingQuantity *decimal.Decimal `json:"remainingQuantity,omitempty"`
	// TotalReservedQuantity - READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *decimal.Decimal `json:"totalReservedQuantity,omitempty"`
	// UsedQuantity - READ-ONLY; This is the used quantity for the reservationId.
	UsedQuantity *decimal.Decimal `json:"usedQuantity,omitempty"`
	// UtilizedPercentage - READ-ONLY; This is the utilized percentage for the reservation Id.
	UtilizedPercentage *decimal.Decimal `json:"utilizedPercentage,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationSummaryProperties.
func (rsp ReservationSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationTransaction reservation transaction resource.
type ReservationTransaction struct {
	*LegacyReservationTransactionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationTransaction.
func (rt ReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.LegacyReservationTransactionProperties != nil {
		objectMap["properties"] = rt.LegacyReservationTransactionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReservationTransaction struct.
func (rt *ReservationTransaction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var legacyReservationTransactionProperties LegacyReservationTransactionProperties
				err = json.Unmarshal(*v, &legacyReservationTransactionProperties)
				if err != nil {
					return err
				}
				rt.LegacyReservationTransactionProperties = &legacyReservationTransactionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = &tags
			}
		}
	}

	return nil
}

// ReservationTransactionResource the Resource model definition.
type ReservationTransactionResource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags *[]string `json:"tags,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationTransactionResource.
func (rtr ReservationTransactionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationTransactionsListResult result of listing reservation recommendations.
type ReservationTransactionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation recommendations.
	Value *[]ReservationTransaction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ReservationTransactionsListResult.
func (rtlr ReservationTransactionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReservationTransactionsListResultIterator provides access to a complete listing of
// ReservationTransaction values.
type ReservationTransactionsListResultIterator struct {
	i    int
	page ReservationTransactionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReservationTransactionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReservationTransactionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReservationTransactionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReservationTransactionsListResultIterator) Response() ReservationTransactionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReservationTransactionsListResultIterator) Value() ReservationTransaction {
	if !iter.page.NotDone() {
		return ReservationTransaction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReservationTransactionsListResultIterator type.
func NewReservationTransactionsListResultIterator(page ReservationTransactionsListResultPage) ReservationTransactionsListResultIterator {
	return ReservationTransactionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtlr ReservationTransactionsListResult) IsEmpty() bool {
	return rtlr.Value == nil || len(*rtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rtlr ReservationTransactionsListResult) hasNextLink() bool {
	return rtlr.NextLink != nil && len(*rtlr.NextLink) != 0
}

// reservationTransactionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtlr ReservationTransactionsListResult) reservationTransactionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtlr.NextLink)))
}

// ReservationTransactionsListResultPage contains a page of ReservationTransaction values.
type ReservationTransactionsListResultPage struct {
	fn   func(context.Context, ReservationTransactionsListResult) (ReservationTransactionsListResult, error)
	rtlr ReservationTransactionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReservationTransactionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rtlr)
		if err != nil {
			return err
		}
		page.rtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReservationTransactionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReservationTransactionsListResultPage) NotDone() bool {
	return !page.rtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReservationTransactionsListResultPage) Response() ReservationTransactionsListResult {
	return page.rtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReservationTransactionsListResultPage) Values() []ReservationTransaction {
	if page.rtlr.IsEmpty() {
		return nil
	}
	return *page.rtlr.Value
}

// Creates a new instance of the ReservationTransactionsListResultPage type.
func NewReservationTransactionsListResultPage(cur ReservationTransactionsListResult, getNextPage func(context.Context, ReservationTransactionsListResult) (ReservationTransactionsListResult, error)) ReservationTransactionsListResultPage {
	return ReservationTransactionsListResultPage{
		fn:   getNextPage,
		rtlr: cur,
	}
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceAttributes the Resource model definition.
type ResourceAttributes struct {
	// Location - READ-ONLY; Resource location
	Location *string `json:"location,omitempty"`
	// Sku - READ-ONLY; Resource sku
	Sku *string `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceAttributes.
func (ra ResourceAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SkuProperty the Sku property
type SkuProperty struct {
	// Name - READ-ONLY; The name of sku property.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The value of sku property.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuProperty.
func (sp SkuProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Tag the tag resource.
type Tag struct {
	// Key - Tag key.
	Key *string `json:"key,omitempty"`
	// Value - Tag values.
	Value *[]string `json:"value,omitempty"`
}

// TagProperties the properties of the tag.
type TagProperties struct {
	// Tags - A list of Tag.
	Tags *[]Tag `json:"tags,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
	// PreviousLink - READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string `json:"previousLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TagProperties.
func (tp TagProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Tags != nil {
		objectMap["tags"] = tp.Tags
	}
	return json.Marshal(objectMap)
}

// TagsResult a resource listing all tags.
type TagsResult struct {
	autorest.Response `json:"-"`
	*TagProperties    `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// ETag - eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for TagsResult.
func (tr TagsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.TagProperties != nil {
		objectMap["properties"] = tr.TagProperties
	}
	if tr.ETag != nil {
		objectMap["eTag"] = tr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagsResult struct.
func (tr *TagsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagProperties TagProperties
				err = json.Unmarshal(*v, &tagProperties)
				if err != nil {
					return err
				}
				tr.TagProperties = &tagProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				tr.ETag = &eTag
			}
		}
	}

	return nil
}

// BasicUsageDetail an usage detail resource.
type BasicUsageDetail interface {
	AsLegacyUsageDetail() (*LegacyUsageDetail, bool)
	AsModernUsageDetail() (*ModernUsageDetail, bool)
	AsUsageDetail() (*UsageDetail, bool)
}

// UsageDetail an usage detail resource.
type UsageDetail struct {
	// Kind - Possible values include: 'KindUsageDetail', 'KindLegacy', 'KindModern'
	Kind Kind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource etag.
	Etag *string `json:"etag,omitempty"`
	// Tags - READ-ONLY; Resource tags.
	Tags map[string]*string `json:"tags"`
}

func unmarshalBasicUsageDetail(body []byte) (BasicUsageDetail, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindLegacy):
		var lud LegacyUsageDetail
		err := json.Unmarshal(body, &lud)
		return lud, err
	case string(KindModern):
		var mud ModernUsageDetail
		err := json.Unmarshal(body, &mud)
		return mud, err
	default:
		var ud UsageDetail
		err := json.Unmarshal(body, &ud)
		return ud, err
	}
}
func unmarshalBasicUsageDetailArray(body []byte) ([]BasicUsageDetail, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	udArray := make([]BasicUsageDetail, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ud, err := unmarshalBasicUsageDetail(*rawMessage)
		if err != nil {
			return nil, err
		}
		udArray[index] = ud
	}
	return udArray, nil
}

// MarshalJSON is the custom marshaler for UsageDetail.
func (ud UsageDetail) MarshalJSON() ([]byte, error) {
	ud.Kind = KindUsageDetail
	objectMap := make(map[string]interface{})
	if ud.Kind != "" {
		objectMap["kind"] = ud.Kind
	}
	return json.Marshal(objectMap)
}

// AsLegacyUsageDetail is the BasicUsageDetail implementation for UsageDetail.
func (ud UsageDetail) AsLegacyUsageDetail() (*LegacyUsageDetail, bool) {
	return nil, false
}

// AsModernUsageDetail is the BasicUsageDetail implementation for UsageDetail.
func (ud UsageDetail) AsModernUsageDetail() (*ModernUsageDetail, bool) {
	return nil, false
}

// AsUsageDetail is the BasicUsageDetail implementation for UsageDetail.
func (ud UsageDetail) AsUsageDetail() (*UsageDetail, bool) {
	return &ud, true
}

// AsBasicUsageDetail is the BasicUsageDetail implementation for UsageDetail.
func (ud UsageDetail) AsBasicUsageDetail() (BasicUsageDetail, bool) {
	return &ud, true
}

// UsageDetailsListResult result of listing usage details. It contains a list of available usage details in
// reverse chronological order by billing period.
type UsageDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usage details.
	Value *[]BasicUsageDetail `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageDetailsListResult.
func (udlr UsageDetailsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UsageDetailsListResult struct.
func (udlr *UsageDetailsListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicUsageDetailArray(*v)
				if err != nil {
					return err
				}
				udlr.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				udlr.NextLink = &nextLink
			}
		}
	}

	return nil
}

// UsageDetailsListResultIterator provides access to a complete listing of UsageDetail values.
type UsageDetailsListResultIterator struct {
	i    int
	page UsageDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageDetailsListResultIterator) Response() UsageDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageDetailsListResultIterator) Value() BasicUsageDetail {
	if !iter.page.NotDone() {
		return UsageDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageDetailsListResultIterator type.
func NewUsageDetailsListResultIterator(page UsageDetailsListResultPage) UsageDetailsListResultIterator {
	return UsageDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (udlr UsageDetailsListResult) IsEmpty() bool {
	return udlr.Value == nil || len(*udlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (udlr UsageDetailsListResult) hasNextLink() bool {
	return udlr.NextLink != nil && len(*udlr.NextLink) != 0
}

// usageDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (udlr UsageDetailsListResult) usageDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !udlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(udlr.NextLink)))
}

// UsageDetailsListResultPage contains a page of BasicUsageDetail values.
type UsageDetailsListResultPage struct {
	fn   func(context.Context, UsageDetailsListResult) (UsageDetailsListResult, error)
	udlr UsageDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.udlr)
		if err != nil {
			return err
		}
		page.udlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageDetailsListResultPage) NotDone() bool {
	return !page.udlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageDetailsListResultPage) Response() UsageDetailsListResult {
	return page.udlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageDetailsListResultPage) Values() []BasicUsageDetail {
	if page.udlr.IsEmpty() {
		return nil
	}
	return *page.udlr.Value
}

// Creates a new instance of the UsageDetailsListResultPage type.
func NewUsageDetailsListResultPage(cur UsageDetailsListResult, getNextPage func(context.Context, UsageDetailsListResult) (UsageDetailsListResult, error)) UsageDetailsListResultPage {
	return UsageDetailsListResultPage{
		fn:   getNextPage,
		udlr: cur,
	}
}
