package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AbsoluteMarker enumerates the values for absolute marker.
type AbsoluteMarker string

const (
	// AllBackup ...
	AllBackup AbsoluteMarker = "AllBackup"
	// FirstOfDay ...
	FirstOfDay AbsoluteMarker = "FirstOfDay"
	// FirstOfMonth ...
	FirstOfMonth AbsoluteMarker = "FirstOfMonth"
	// FirstOfWeek ...
	FirstOfWeek AbsoluteMarker = "FirstOfWeek"
	// FirstOfYear ...
	FirstOfYear AbsoluteMarker = "FirstOfYear"
)

// PossibleAbsoluteMarkerValues returns an array of possible values for the AbsoluteMarker const type.
func PossibleAbsoluteMarkerValues() []AbsoluteMarker {
	return []AbsoluteMarker{AllBackup, FirstOfDay, FirstOfMonth, FirstOfWeek, FirstOfYear}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// CurrentProtectionState enumerates the values for current protection state.
type CurrentProtectionState string

const (
	// BackupSchedulesSuspended ...
	BackupSchedulesSuspended CurrentProtectionState = "BackupSchedulesSuspended"
	// ConfiguringProtection ...
	ConfiguringProtection CurrentProtectionState = "ConfiguringProtection"
	// ConfiguringProtectionFailed ...
	ConfiguringProtectionFailed CurrentProtectionState = "ConfiguringProtectionFailed"
	// Invalid ...
	Invalid CurrentProtectionState = "Invalid"
	// NotProtected ...
	NotProtected CurrentProtectionState = "NotProtected"
	// ProtectionConfigured ...
	ProtectionConfigured CurrentProtectionState = "ProtectionConfigured"
	// ProtectionError ...
	ProtectionError CurrentProtectionState = "ProtectionError"
	// ProtectionStopped ...
	ProtectionStopped CurrentProtectionState = "ProtectionStopped"
	// RetentionSchedulesSuspended ...
	RetentionSchedulesSuspended CurrentProtectionState = "RetentionSchedulesSuspended"
	// SoftDeleted ...
	SoftDeleted CurrentProtectionState = "SoftDeleted"
	// SoftDeleting ...
	SoftDeleting CurrentProtectionState = "SoftDeleting"
	// UpdatingProtection ...
	UpdatingProtection CurrentProtectionState = "UpdatingProtection"
)

// PossibleCurrentProtectionStateValues returns an array of possible values for the CurrentProtectionState const type.
func PossibleCurrentProtectionStateValues() []CurrentProtectionState {
	return []CurrentProtectionState{BackupSchedulesSuspended, ConfiguringProtection, ConfiguringProtectionFailed, Invalid, NotProtected, ProtectionConfigured, ProtectionError, ProtectionStopped, RetentionSchedulesSuspended, SoftDeleted, SoftDeleting, UpdatingProtection}
}

// DataStoreTypes enumerates the values for data store types.
type DataStoreTypes string

const (
	// ArchiveStore ...
	ArchiveStore DataStoreTypes = "ArchiveStore"
	// OperationalStore ...
	OperationalStore DataStoreTypes = "OperationalStore"
	// VaultStore ...
	VaultStore DataStoreTypes = "VaultStore"
)

// PossibleDataStoreTypesValues returns an array of possible values for the DataStoreTypes const type.
func PossibleDataStoreTypesValues() []DataStoreTypes {
	return []DataStoreTypes{ArchiveStore, OperationalStore, VaultStore}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// FeatureSupportStatus enumerates the values for feature support status.
type FeatureSupportStatus string

const (
	// FeatureSupportStatusAlphaPreview ...
	FeatureSupportStatusAlphaPreview FeatureSupportStatus = "AlphaPreview"
	// FeatureSupportStatusGenerallyAvailable ...
	FeatureSupportStatusGenerallyAvailable FeatureSupportStatus = "GenerallyAvailable"
	// FeatureSupportStatusInvalid ...
	FeatureSupportStatusInvalid FeatureSupportStatus = "Invalid"
	// FeatureSupportStatusNotSupported ...
	FeatureSupportStatusNotSupported FeatureSupportStatus = "NotSupported"
	// FeatureSupportStatusPrivatePreview ...
	FeatureSupportStatusPrivatePreview FeatureSupportStatus = "PrivatePreview"
	// FeatureSupportStatusPublicPreview ...
	FeatureSupportStatusPublicPreview FeatureSupportStatus = "PublicPreview"
)

// PossibleFeatureSupportStatusValues returns an array of possible values for the FeatureSupportStatus const type.
func PossibleFeatureSupportStatusValues() []FeatureSupportStatus {
	return []FeatureSupportStatus{FeatureSupportStatusAlphaPreview, FeatureSupportStatusGenerallyAvailable, FeatureSupportStatusInvalid, FeatureSupportStatusNotSupported, FeatureSupportStatusPrivatePreview, FeatureSupportStatusPublicPreview}
}

// FeatureType enumerates the values for feature type.
type FeatureType string

const (
	// FeatureTypeDataSourceType ...
	FeatureTypeDataSourceType FeatureType = "DataSourceType"
	// FeatureTypeInvalid ...
	FeatureTypeInvalid FeatureType = "Invalid"
)

// PossibleFeatureTypeValues returns an array of possible values for the FeatureType const type.
func PossibleFeatureTypeValues() []FeatureType {
	return []FeatureType{FeatureTypeDataSourceType, FeatureTypeInvalid}
}

// Month enumerates the values for month.
type Month string

const (
	// April ...
	April Month = "April"
	// August ...
	August Month = "August"
	// December ...
	December Month = "December"
	// February ...
	February Month = "February"
	// January ...
	January Month = "January"
	// July ...
	July Month = "July"
	// June ...
	June Month = "June"
	// March ...
	March Month = "March"
	// May ...
	May Month = "May"
	// November ...
	November Month = "November"
	// October ...
	October Month = "October"
	// September ...
	September Month = "September"
)

// PossibleMonthValues returns an array of possible values for the Month const type.
func PossibleMonthValues() []Month {
	return []Month{April, August, December, February, January, July, June, March, May, November, October, September}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeAzureBackupDiscreteRecoveryPoint ...
	ObjectTypeAzureBackupDiscreteRecoveryPoint ObjectType = "AzureBackupDiscreteRecoveryPoint"
	// ObjectTypeAzureBackupRecoveryPoint ...
	ObjectTypeAzureBackupRecoveryPoint ObjectType = "AzureBackupRecoveryPoint"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeAzureBackupDiscreteRecoveryPoint, ObjectTypeAzureBackupRecoveryPoint}
}

// ObjectTypeBasicAzureBackupRestoreRequest enumerates the values for object type basic azure backup restore
// request.
type ObjectTypeBasicAzureBackupRestoreRequest string

const (
	// ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest ...
	ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest ObjectTypeBasicAzureBackupRestoreRequest = "AzureBackupRecoveryPointBasedRestoreRequest"
	// ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest ...
	ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest ObjectTypeBasicAzureBackupRestoreRequest = "AzureBackupRecoveryTimeBasedRestoreRequest"
	// ObjectTypeAzureBackupRestoreRequest ...
	ObjectTypeAzureBackupRestoreRequest ObjectTypeBasicAzureBackupRestoreRequest = "AzureBackupRestoreRequest"
	// ObjectTypeAzureBackupRestoreWithRehydrationRequest ...
	ObjectTypeAzureBackupRestoreWithRehydrationRequest ObjectTypeBasicAzureBackupRestoreRequest = "AzureBackupRestoreWithRehydrationRequest"
)

// PossibleObjectTypeBasicAzureBackupRestoreRequestValues returns an array of possible values for the ObjectTypeBasicAzureBackupRestoreRequest const type.
func PossibleObjectTypeBasicAzureBackupRestoreRequestValues() []ObjectTypeBasicAzureBackupRestoreRequest {
	return []ObjectTypeBasicAzureBackupRestoreRequest{ObjectTypeAzureBackupRecoveryPointBasedRestoreRequest, ObjectTypeAzureBackupRecoveryTimeBasedRestoreRequest, ObjectTypeAzureBackupRestoreRequest, ObjectTypeAzureBackupRestoreWithRehydrationRequest}
}

// ObjectTypeBasicBackupCriteria enumerates the values for object type basic backup criteria.
type ObjectTypeBasicBackupCriteria string

const (
	// ObjectTypeBackupCriteria ...
	ObjectTypeBackupCriteria ObjectTypeBasicBackupCriteria = "BackupCriteria"
	// ObjectTypeScheduleBasedBackupCriteria ...
	ObjectTypeScheduleBasedBackupCriteria ObjectTypeBasicBackupCriteria = "ScheduleBasedBackupCriteria"
)

// PossibleObjectTypeBasicBackupCriteriaValues returns an array of possible values for the ObjectTypeBasicBackupCriteria const type.
func PossibleObjectTypeBasicBackupCriteriaValues() []ObjectTypeBasicBackupCriteria {
	return []ObjectTypeBasicBackupCriteria{ObjectTypeBackupCriteria, ObjectTypeScheduleBasedBackupCriteria}
}

// ObjectTypeBasicBackupParameters enumerates the values for object type basic backup parameters.
type ObjectTypeBasicBackupParameters string

const (
	// ObjectTypeAzureBackupParams ...
	ObjectTypeAzureBackupParams ObjectTypeBasicBackupParameters = "AzureBackupParams"
	// ObjectTypeBackupParameters ...
	ObjectTypeBackupParameters ObjectTypeBasicBackupParameters = "BackupParameters"
)

// PossibleObjectTypeBasicBackupParametersValues returns an array of possible values for the ObjectTypeBasicBackupParameters const type.
func PossibleObjectTypeBasicBackupParametersValues() []ObjectTypeBasicBackupParameters {
	return []ObjectTypeBasicBackupParameters{ObjectTypeAzureBackupParams, ObjectTypeBackupParameters}
}

// ObjectTypeBasicBaseBackupPolicy enumerates the values for object type basic base backup policy.
type ObjectTypeBasicBaseBackupPolicy string

const (
	// ObjectTypeBackupPolicy ...
	ObjectTypeBackupPolicy ObjectTypeBasicBaseBackupPolicy = "BackupPolicy"
	// ObjectTypeBaseBackupPolicy ...
	ObjectTypeBaseBackupPolicy ObjectTypeBasicBaseBackupPolicy = "BaseBackupPolicy"
)

// PossibleObjectTypeBasicBaseBackupPolicyValues returns an array of possible values for the ObjectTypeBasicBaseBackupPolicy const type.
func PossibleObjectTypeBasicBaseBackupPolicyValues() []ObjectTypeBasicBaseBackupPolicy {
	return []ObjectTypeBasicBaseBackupPolicy{ObjectTypeBackupPolicy, ObjectTypeBaseBackupPolicy}
}

// ObjectTypeBasicBasePolicyRule enumerates the values for object type basic base policy rule.
type ObjectTypeBasicBasePolicyRule string

const (
	// ObjectTypeAzureBackupRule ...
	ObjectTypeAzureBackupRule ObjectTypeBasicBasePolicyRule = "AzureBackupRule"
	// ObjectTypeAzureRetentionRule ...
	ObjectTypeAzureRetentionRule ObjectTypeBasicBasePolicyRule = "AzureRetentionRule"
	// ObjectTypeBasePolicyRule ...
	ObjectTypeBasePolicyRule ObjectTypeBasicBasePolicyRule = "BasePolicyRule"
)

// PossibleObjectTypeBasicBasePolicyRuleValues returns an array of possible values for the ObjectTypeBasicBasePolicyRule const type.
func PossibleObjectTypeBasicBasePolicyRuleValues() []ObjectTypeBasicBasePolicyRule {
	return []ObjectTypeBasicBasePolicyRule{ObjectTypeAzureBackupRule, ObjectTypeAzureRetentionRule, ObjectTypeBasePolicyRule}
}

// ObjectTypeBasicCopyOption enumerates the values for object type basic copy option.
type ObjectTypeBasicCopyOption string

const (
	// ObjectTypeCopyOnExpiryOption ...
	ObjectTypeCopyOnExpiryOption ObjectTypeBasicCopyOption = "CopyOnExpiryOption"
	// ObjectTypeCopyOption ...
	ObjectTypeCopyOption ObjectTypeBasicCopyOption = "CopyOption"
	// ObjectTypeCustomCopyOption ...
	ObjectTypeCustomCopyOption ObjectTypeBasicCopyOption = "CustomCopyOption"
	// ObjectTypeImmediateCopyOption ...
	ObjectTypeImmediateCopyOption ObjectTypeBasicCopyOption = "ImmediateCopyOption"
)

// PossibleObjectTypeBasicCopyOptionValues returns an array of possible values for the ObjectTypeBasicCopyOption const type.
func PossibleObjectTypeBasicCopyOptionValues() []ObjectTypeBasicCopyOption {
	return []ObjectTypeBasicCopyOption{ObjectTypeCopyOnExpiryOption, ObjectTypeCopyOption, ObjectTypeCustomCopyOption, ObjectTypeImmediateCopyOption}
}

// ObjectTypeBasicDataStoreParameters enumerates the values for object type basic data store parameters.
type ObjectTypeBasicDataStoreParameters string

const (
	// ObjectTypeAzureOperationalStoreParameters ...
	ObjectTypeAzureOperationalStoreParameters ObjectTypeBasicDataStoreParameters = "AzureOperationalStoreParameters"
	// ObjectTypeDataStoreParameters ...
	ObjectTypeDataStoreParameters ObjectTypeBasicDataStoreParameters = "DataStoreParameters"
)

// PossibleObjectTypeBasicDataStoreParametersValues returns an array of possible values for the ObjectTypeBasicDataStoreParameters const type.
func PossibleObjectTypeBasicDataStoreParametersValues() []ObjectTypeBasicDataStoreParameters {
	return []ObjectTypeBasicDataStoreParameters{ObjectTypeAzureOperationalStoreParameters, ObjectTypeDataStoreParameters}
}

// ObjectTypeBasicDeleteOption enumerates the values for object type basic delete option.
type ObjectTypeBasicDeleteOption string

const (
	// ObjectTypeAbsoluteDeleteOption ...
	ObjectTypeAbsoluteDeleteOption ObjectTypeBasicDeleteOption = "AbsoluteDeleteOption"
	// ObjectTypeDeleteOption ...
	ObjectTypeDeleteOption ObjectTypeBasicDeleteOption = "DeleteOption"
)

// PossibleObjectTypeBasicDeleteOptionValues returns an array of possible values for the ObjectTypeBasicDeleteOption const type.
func PossibleObjectTypeBasicDeleteOptionValues() []ObjectTypeBasicDeleteOption {
	return []ObjectTypeBasicDeleteOption{ObjectTypeAbsoluteDeleteOption, ObjectTypeDeleteOption}
}

// ObjectTypeBasicFeatureValidationRequestBase enumerates the values for object type basic feature validation
// request base.
type ObjectTypeBasicFeatureValidationRequestBase string

const (
	// ObjectTypeFeatureValidationRequest ...
	ObjectTypeFeatureValidationRequest ObjectTypeBasicFeatureValidationRequestBase = "FeatureValidationRequest"
	// ObjectTypeFeatureValidationRequestBase ...
	ObjectTypeFeatureValidationRequestBase ObjectTypeBasicFeatureValidationRequestBase = "FeatureValidationRequestBase"
)

// PossibleObjectTypeBasicFeatureValidationRequestBaseValues returns an array of possible values for the ObjectTypeBasicFeatureValidationRequestBase const type.
func PossibleObjectTypeBasicFeatureValidationRequestBaseValues() []ObjectTypeBasicFeatureValidationRequestBase {
	return []ObjectTypeBasicFeatureValidationRequestBase{ObjectTypeFeatureValidationRequest, ObjectTypeFeatureValidationRequestBase}
}

// ObjectTypeBasicFeatureValidationResponseBase enumerates the values for object type basic feature validation
// response base.
type ObjectTypeBasicFeatureValidationResponseBase string

const (
	// ObjectTypeFeatureValidationResponse ...
	ObjectTypeFeatureValidationResponse ObjectTypeBasicFeatureValidationResponseBase = "FeatureValidationResponse"
	// ObjectTypeFeatureValidationResponseBase ...
	ObjectTypeFeatureValidationResponseBase ObjectTypeBasicFeatureValidationResponseBase = "FeatureValidationResponseBase"
)

// PossibleObjectTypeBasicFeatureValidationResponseBaseValues returns an array of possible values for the ObjectTypeBasicFeatureValidationResponseBase const type.
func PossibleObjectTypeBasicFeatureValidationResponseBaseValues() []ObjectTypeBasicFeatureValidationResponseBase {
	return []ObjectTypeBasicFeatureValidationResponseBase{ObjectTypeFeatureValidationResponse, ObjectTypeFeatureValidationResponseBase}
}

// ObjectTypeBasicItemLevelRestoreCriteria enumerates the values for object type basic item level restore
// criteria.
type ObjectTypeBasicItemLevelRestoreCriteria string

const (
	// ObjectTypeItemLevelRestoreCriteria ...
	ObjectTypeItemLevelRestoreCriteria ObjectTypeBasicItemLevelRestoreCriteria = "ItemLevelRestoreCriteria"
	// ObjectTypeRangeBasedItemLevelRestoreCriteria ...
	ObjectTypeRangeBasedItemLevelRestoreCriteria ObjectTypeBasicItemLevelRestoreCriteria = "RangeBasedItemLevelRestoreCriteria"
)

// PossibleObjectTypeBasicItemLevelRestoreCriteriaValues returns an array of possible values for the ObjectTypeBasicItemLevelRestoreCriteria const type.
func PossibleObjectTypeBasicItemLevelRestoreCriteriaValues() []ObjectTypeBasicItemLevelRestoreCriteria {
	return []ObjectTypeBasicItemLevelRestoreCriteria{ObjectTypeItemLevelRestoreCriteria, ObjectTypeRangeBasedItemLevelRestoreCriteria}
}

// ObjectTypeBasicRestoreTargetInfoBase enumerates the values for object type basic restore target info base.
type ObjectTypeBasicRestoreTargetInfoBase string

const (
	// ObjectTypeItemLevelRestoreTargetInfo ...
	ObjectTypeItemLevelRestoreTargetInfo ObjectTypeBasicRestoreTargetInfoBase = "ItemLevelRestoreTargetInfo"
	// ObjectTypeRestoreFilesTargetInfo ...
	ObjectTypeRestoreFilesTargetInfo ObjectTypeBasicRestoreTargetInfoBase = "RestoreFilesTargetInfo"
	// ObjectTypeRestoreTargetInfo ...
	ObjectTypeRestoreTargetInfo ObjectTypeBasicRestoreTargetInfoBase = "RestoreTargetInfo"
	// ObjectTypeRestoreTargetInfoBase ...
	ObjectTypeRestoreTargetInfoBase ObjectTypeBasicRestoreTargetInfoBase = "RestoreTargetInfoBase"
)

// PossibleObjectTypeBasicRestoreTargetInfoBaseValues returns an array of possible values for the ObjectTypeBasicRestoreTargetInfoBase const type.
func PossibleObjectTypeBasicRestoreTargetInfoBaseValues() []ObjectTypeBasicRestoreTargetInfoBase {
	return []ObjectTypeBasicRestoreTargetInfoBase{ObjectTypeItemLevelRestoreTargetInfo, ObjectTypeRestoreFilesTargetInfo, ObjectTypeRestoreTargetInfo, ObjectTypeRestoreTargetInfoBase}
}

// ObjectTypeBasicTriggerContext enumerates the values for object type basic trigger context.
type ObjectTypeBasicTriggerContext string

const (
	// ObjectTypeAdhocBasedTriggerContext ...
	ObjectTypeAdhocBasedTriggerContext ObjectTypeBasicTriggerContext = "AdhocBasedTriggerContext"
	// ObjectTypeScheduleBasedTriggerContext ...
	ObjectTypeScheduleBasedTriggerContext ObjectTypeBasicTriggerContext = "ScheduleBasedTriggerContext"
	// ObjectTypeTriggerContext ...
	ObjectTypeTriggerContext ObjectTypeBasicTriggerContext = "TriggerContext"
)

// PossibleObjectTypeBasicTriggerContextValues returns an array of possible values for the ObjectTypeBasicTriggerContext const type.
func PossibleObjectTypeBasicTriggerContextValues() []ObjectTypeBasicTriggerContext {
	return []ObjectTypeBasicTriggerContext{ObjectTypeAdhocBasedTriggerContext, ObjectTypeScheduleBasedTriggerContext, ObjectTypeTriggerContext}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Provisioning ...
	Provisioning ProvisioningState = "Provisioning"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Unknown ...
	Unknown ProvisioningState = "Unknown"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Failed, Provisioning, Succeeded, Unknown, Updating}
}

// RehydrationPriority enumerates the values for rehydration priority.
type RehydrationPriority string

const (
	// RehydrationPriorityHigh ...
	RehydrationPriorityHigh RehydrationPriority = "High"
	// RehydrationPriorityInvalid ...
	RehydrationPriorityInvalid RehydrationPriority = "Invalid"
	// RehydrationPriorityStandard ...
	RehydrationPriorityStandard RehydrationPriority = "Standard"
)

// PossibleRehydrationPriorityValues returns an array of possible values for the RehydrationPriority const type.
func PossibleRehydrationPriorityValues() []RehydrationPriority {
	return []RehydrationPriority{RehydrationPriorityHigh, RehydrationPriorityInvalid, RehydrationPriorityStandard}
}

// RehydrationStatus enumerates the values for rehydration status.
type RehydrationStatus string

const (
	// COMPLETED ...
	COMPLETED RehydrationStatus = "COMPLETED"
	// CREATEINPROGRESS ...
	CREATEINPROGRESS RehydrationStatus = "CREATE_IN_PROGRESS"
	// DELETED ...
	DELETED RehydrationStatus = "DELETED"
	// DELETEINPROGRESS ...
	DELETEINPROGRESS RehydrationStatus = "DELETE_IN_PROGRESS"
	// FAILED ...
	FAILED RehydrationStatus = "FAILED"
)

// PossibleRehydrationStatusValues returns an array of possible values for the RehydrationStatus const type.
func PossibleRehydrationStatusValues() []RehydrationStatus {
	return []RehydrationStatus{COMPLETED, CREATEINPROGRESS, DELETED, DELETEINPROGRESS, FAILED}
}

// RestoreSourceDataStoreType enumerates the values for restore source data store type.
type RestoreSourceDataStoreType string

const (
	// RestoreSourceDataStoreTypeArchiveStore ...
	RestoreSourceDataStoreTypeArchiveStore RestoreSourceDataStoreType = "ArchiveStore"
	// RestoreSourceDataStoreTypeOperationalStore ...
	RestoreSourceDataStoreTypeOperationalStore RestoreSourceDataStoreType = "OperationalStore"
	// RestoreSourceDataStoreTypeVaultStore ...
	RestoreSourceDataStoreTypeVaultStore RestoreSourceDataStoreType = "VaultStore"
)

// PossibleRestoreSourceDataStoreTypeValues returns an array of possible values for the RestoreSourceDataStoreType const type.
func PossibleRestoreSourceDataStoreTypeValues() []RestoreSourceDataStoreType {
	return []RestoreSourceDataStoreType{RestoreSourceDataStoreTypeArchiveStore, RestoreSourceDataStoreTypeOperationalStore, RestoreSourceDataStoreTypeVaultStore}
}

// RestoreTargetLocationType enumerates the values for restore target location type.
type RestoreTargetLocationType string

const (
	// RestoreTargetLocationTypeAzureBlobs ...
	RestoreTargetLocationTypeAzureBlobs RestoreTargetLocationType = "AzureBlobs"
	// RestoreTargetLocationTypeAzureFiles ...
	RestoreTargetLocationTypeAzureFiles RestoreTargetLocationType = "AzureFiles"
	// RestoreTargetLocationTypeInvalid ...
	RestoreTargetLocationTypeInvalid RestoreTargetLocationType = "Invalid"
)

// PossibleRestoreTargetLocationTypeValues returns an array of possible values for the RestoreTargetLocationType const type.
func PossibleRestoreTargetLocationTypeValues() []RestoreTargetLocationType {
	return []RestoreTargetLocationType{RestoreTargetLocationTypeAzureBlobs, RestoreTargetLocationTypeAzureFiles, RestoreTargetLocationTypeInvalid}
}

// SourceDataStoreType enumerates the values for source data store type.
type SourceDataStoreType string

const (
	// SourceDataStoreTypeArchiveStore ...
	SourceDataStoreTypeArchiveStore SourceDataStoreType = "ArchiveStore"
	// SourceDataStoreTypeSnapshotStore ...
	SourceDataStoreTypeSnapshotStore SourceDataStoreType = "SnapshotStore"
	// SourceDataStoreTypeVaultStore ...
	SourceDataStoreTypeVaultStore SourceDataStoreType = "VaultStore"
)

// PossibleSourceDataStoreTypeValues returns an array of possible values for the SourceDataStoreType const type.
func PossibleSourceDataStoreTypeValues() []SourceDataStoreType {
	return []SourceDataStoreType{SourceDataStoreTypeArchiveStore, SourceDataStoreTypeSnapshotStore, SourceDataStoreTypeVaultStore}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusConfiguringProtection ...
	StatusConfiguringProtection Status = "ConfiguringProtection"
	// StatusConfiguringProtectionFailed ...
	StatusConfiguringProtectionFailed Status = "ConfiguringProtectionFailed"
	// StatusProtectionConfigured ...
	StatusProtectionConfigured Status = "ProtectionConfigured"
	// StatusProtectionStopped ...
	StatusProtectionStopped Status = "ProtectionStopped"
	// StatusSoftDeleted ...
	StatusSoftDeleted Status = "SoftDeleted"
	// StatusSoftDeleting ...
	StatusSoftDeleting Status = "SoftDeleting"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusConfiguringProtection, StatusConfiguringProtectionFailed, StatusProtectionConfigured, StatusProtectionStopped, StatusSoftDeleted, StatusSoftDeleting}
}

// StorageSettingStoreTypes enumerates the values for storage setting store types.
type StorageSettingStoreTypes string

const (
	// StorageSettingStoreTypesArchiveStore ...
	StorageSettingStoreTypesArchiveStore StorageSettingStoreTypes = "ArchiveStore"
	// StorageSettingStoreTypesSnapshotStore ...
	StorageSettingStoreTypesSnapshotStore StorageSettingStoreTypes = "SnapshotStore"
	// StorageSettingStoreTypesVaultStore ...
	StorageSettingStoreTypesVaultStore StorageSettingStoreTypes = "VaultStore"
)

// PossibleStorageSettingStoreTypesValues returns an array of possible values for the StorageSettingStoreTypes const type.
func PossibleStorageSettingStoreTypesValues() []StorageSettingStoreTypes {
	return []StorageSettingStoreTypes{StorageSettingStoreTypesArchiveStore, StorageSettingStoreTypesSnapshotStore, StorageSettingStoreTypesVaultStore}
}

// StorageSettingTypes enumerates the values for storage setting types.
type StorageSettingTypes string

const (
	// GeoRedundant ...
	GeoRedundant StorageSettingTypes = "GeoRedundant"
	// LocallyRedundant ...
	LocallyRedundant StorageSettingTypes = "LocallyRedundant"
)

// PossibleStorageSettingTypesValues returns an array of possible values for the StorageSettingTypes const type.
func PossibleStorageSettingTypesValues() []StorageSettingTypes {
	return []StorageSettingTypes{GeoRedundant, LocallyRedundant}
}

// WeekNumber enumerates the values for week number.
type WeekNumber string

const (
	// First ...
	First WeekNumber = "First"
	// Fourth ...
	Fourth WeekNumber = "Fourth"
	// Last ...
	Last WeekNumber = "Last"
	// Second ...
	Second WeekNumber = "Second"
	// Third ...
	Third WeekNumber = "Third"
)

// PossibleWeekNumberValues returns an array of possible values for the WeekNumber const type.
func PossibleWeekNumberValues() []WeekNumber {
	return []WeekNumber{First, Fourth, Last, Second, Third}
}
