package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RestorableTimeRangesClient is the open API 2.0 Specs for Azure Data Protection service
type RestorableTimeRangesClient struct {
	BaseClient
}

// NewRestorableTimeRangesClient creates an instance of the RestorableTimeRangesClient client.
func NewRestorableTimeRangesClient(subscriptionID string) RestorableTimeRangesClient {
	return NewRestorableTimeRangesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRestorableTimeRangesClientWithBaseURI creates an instance of the RestorableTimeRangesClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewRestorableTimeRangesClientWithBaseURI(baseURI string, subscriptionID string) RestorableTimeRangesClient {
	return RestorableTimeRangesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Find sends the find request.
// Parameters:
// vaultName - the name of the backup vault.
// resourceGroupName - the name of the resource group where the backup vault is present.
// backupInstanceName - the name of the backup instance
// parameters - request body for operation
func (client RestorableTimeRangesClient) Find(ctx context.Context, vaultName string, resourceGroupName string, backupInstanceName string, parameters AzureBackupFindRestorableTimeRangesRequest) (result AzureBackupFindRestorableTimeRangesResponseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableTimeRangesClient.Find")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.FindPreparer(ctx, vaultName, resourceGroupName, backupInstanceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.RestorableTimeRangesClient", "Find", nil, "Failure preparing request")
		return
	}

	resp, err := client.FindSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.RestorableTimeRangesClient", "Find", resp, "Failure sending request")
		return
	}

	result, err = client.FindResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.RestorableTimeRangesClient", "Find", resp, "Failure responding to request")
		return
	}

	return
}

// FindPreparer prepares the Find request.
func (client RestorableTimeRangesClient) FindPreparer(ctx context.Context, vaultName string, resourceGroupName string, backupInstanceName string, parameters AzureBackupFindRestorableTimeRangesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupInstanceName": autorest.Encode("path", backupInstanceName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"vaultName":          autorest.Encode("path", vaultName),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/findRestorableTimeRanges", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FindSender sends the Find request. The method will close the
// http.Response Body if it receives an error.
func (client RestorableTimeRangesClient) FindSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// FindResponder handles the response to the Find request. The method always
// closes the http.Response Body.
func (client RestorableTimeRangesClient) FindResponder(resp *http.Response) (result AzureBackupFindRestorableTimeRangesResponseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
