package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ManagedHsmsClient is the the Azure management API provides a RESTful set of web services that interact with Azure
// Key Vault.
type ManagedHsmsClient struct {
	BaseClient
}

// NewManagedHsmsClient creates an instance of the ManagedHsmsClient client.
func NewManagedHsmsClient(subscriptionID string) ManagedHsmsClient {
	return NewManagedHsmsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagedHsmsClientWithBaseURI creates an instance of the ManagedHsmsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewManagedHsmsClientWithBaseURI(baseURI string, subscriptionID string) ManagedHsmsClient {
	return ManagedHsmsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or update a managed HSM Pool in the specified subscription.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
// parameters - parameters to create or update the managed HSM Pool
func (client ManagedHsmsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, parameters ManagedHsm) (result ManagedHsmsCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, name, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ManagedHsmsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, name string, parameters ManagedHsm) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) CreateOrUpdateSender(req *http.Request) (future ManagedHsmsCreateOrUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) CreateOrUpdateResponder(resp *http.Response) (result ManagedHsm, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the specified managed HSM Pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - the name of the managed HSM Pool to delete
func (client ManagedHsmsClient) Delete(ctx context.Context, resourceGroupName string, name string) (result ManagedHsmsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ManagedHsmsClient) DeletePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) DeleteSender(req *http.Request) (future ManagedHsmsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the specified managed HSM Pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - the name of the managed HSM Pool.
func (client ManagedHsmsClient) Get(ctx context.Context, resourceGroupName string, name string) (result ManagedHsm, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ManagedHsmsClient) GetPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) GetResponder(resp *http.Response) (result ManagedHsm, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeleted gets the specified deleted managed HSM.
// Parameters:
// name - the name of the deleted managed HSM.
// location - the location of the deleted managed HSM.
func (client ManagedHsmsClient) GetDeleted(ctx context.Context, name string, location string) (result DeletedManagedHsm, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.GetDeleted")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDeletedPreparer(ctx, name, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "GetDeleted", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeletedSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "GetDeleted", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeletedResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "GetDeleted", resp, "Failure responding to request")
		return
	}

	return
}

// GetDeletedPreparer prepares the GetDeleted request.
func (client ManagedHsmsClient) GetDeletedPreparer(ctx context.Context, name string, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"name":           autorest.Encode("path", name),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedManagedHSMs/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeletedSender sends the GetDeleted request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) GetDeletedSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeletedResponder handles the response to the GetDeleted request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) GetDeletedResponder(resp *http.Response) (result DeletedManagedHsm, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup the List operation gets information about the managed HSM Pools associated with the subscription
// and within the specified resource group.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// top - maximum number of results to return.
func (client ManagedHsmsClient) ListByResourceGroup(ctx context.Context, resourceGroupName string, top *int32) (result ManagedHsmListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.mhlr.Response.Response != nil {
				sc = result.mhlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.mhlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.mhlr, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.mhlr.hasNextLink() && result.mhlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client ManagedHsmsClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) ListByResourceGroupResponder(resp *http.Response) (result ManagedHsmListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client ManagedHsmsClient) listByResourceGroupNextResults(ctx context.Context, lastResults ManagedHsmListResult) (result ManagedHsmListResult, err error) {
	req, err := lastResults.managedHsmListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagedHsmsClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, top *int32) (result ManagedHsmListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName, top)
	return
}

// ListBySubscription the List operation gets information about the managed HSM Pools associated with the subscription.
// Parameters:
// top - maximum number of results to return.
func (client ManagedHsmsClient) ListBySubscription(ctx context.Context, top *int32) (result ManagedHsmListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.mhlr.Response.Response != nil {
				sc = result.mhlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySubscriptionNextResults
	req, err := client.ListBySubscriptionPreparer(ctx, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.mhlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListBySubscription", resp, "Failure sending request")
		return
	}

	result.mhlr, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListBySubscription", resp, "Failure responding to request")
		return
	}
	if result.mhlr.hasNextLink() && result.mhlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client ManagedHsmsClient) ListBySubscriptionPreparer(ctx context.Context, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/managedHSMs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) ListBySubscriptionResponder(resp *http.Response) (result ManagedHsmListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySubscriptionNextResults retrieves the next set of results, if any.
func (client ManagedHsmsClient) listBySubscriptionNextResults(ctx context.Context, lastResults ManagedHsmListResult) (result ManagedHsmListResult, err error) {
	req, err := lastResults.managedHsmListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagedHsmsClient) ListBySubscriptionComplete(ctx context.Context, top *int32) (result ManagedHsmListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySubscription(ctx, top)
	return
}

// ListDeleted the List operation gets information about the deleted managed HSMs associated with the subscription.
func (client ManagedHsmsClient) ListDeleted(ctx context.Context) (result DeletedManagedHsmListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListDeleted")
		defer func() {
			sc := -1
			if result.dmhlr.Response.Response != nil {
				sc = result.dmhlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listDeletedNextResults
	req, err := client.ListDeletedPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListDeleted", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeletedSender(req)
	if err != nil {
		result.dmhlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListDeleted", resp, "Failure sending request")
		return
	}

	result.dmhlr, err = client.ListDeletedResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "ListDeleted", resp, "Failure responding to request")
		return
	}
	if result.dmhlr.hasNextLink() && result.dmhlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDeletedPreparer prepares the ListDeleted request.
func (client ManagedHsmsClient) ListDeletedPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/deletedManagedHSMs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeletedSender sends the ListDeleted request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) ListDeletedSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeletedResponder handles the response to the ListDeleted request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) ListDeletedResponder(resp *http.Response) (result DeletedManagedHsmListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeletedNextResults retrieves the next set of results, if any.
func (client ManagedHsmsClient) listDeletedNextResults(ctx context.Context, lastResults DeletedManagedHsmListResult) (result DeletedManagedHsmListResult, err error) {
	req, err := lastResults.deletedManagedHsmListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listDeletedNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeletedSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listDeletedNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeletedResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "listDeletedNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeletedComplete enumerates all values, automatically crossing page boundaries as required.
func (client ManagedHsmsClient) ListDeletedComplete(ctx context.Context) (result DeletedManagedHsmListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.ListDeleted")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeleted(ctx)
	return
}

// PurgeDeleted permanently deletes the specified managed HSM.
// Parameters:
// name - the name of the soft-deleted managed HSM.
// location - the location of the soft-deleted managed HSM.
func (client ManagedHsmsClient) PurgeDeleted(ctx context.Context, name string, location string) (result ManagedHsmsPurgeDeletedFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.PurgeDeleted")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PurgeDeletedPreparer(ctx, name, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "PurgeDeleted", nil, "Failure preparing request")
		return
	}

	result, err = client.PurgeDeletedSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "PurgeDeleted", result.Response(), "Failure sending request")
		return
	}

	return
}

// PurgeDeletedPreparer prepares the PurgeDeleted request.
func (client ManagedHsmsClient) PurgeDeletedPreparer(ctx context.Context, name string, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"name":           autorest.Encode("path", name),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.KeyVault/locations/{location}/deletedManagedHSMs/{name}/purge", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PurgeDeletedSender sends the PurgeDeleted request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) PurgeDeletedSender(req *http.Request) (future ManagedHsmsPurgeDeletedFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// PurgeDeletedResponder handles the response to the PurgeDeleted request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) PurgeDeletedResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update update a managed HSM Pool in the specified subscription.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
// parameters - parameters to patch the managed HSM Pool
func (client ManagedHsmsClient) Update(ctx context.Context, resourceGroupName string, name string, parameters ManagedHsm) (result ManagedHsmsUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmsClient.Update")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, name, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ManagedHsmsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, name string, parameters ManagedHsm) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedHsmsClient) UpdateSender(req *http.Request) (future ManagedHsmsUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ManagedHsmsClient) UpdateResponder(resp *http.Response) (result ManagedHsm, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
