package msi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// FederatedIdentityCredentialsClient is the the Managed Service Identity Client.
type FederatedIdentityCredentialsClient struct {
	BaseClient
}

// NewFederatedIdentityCredentialsClient creates an instance of the FederatedIdentityCredentialsClient client.
func NewFederatedIdentityCredentialsClient(subscriptionID string) FederatedIdentityCredentialsClient {
	return NewFederatedIdentityCredentialsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewFederatedIdentityCredentialsClientWithBaseURI creates an instance of the FederatedIdentityCredentialsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewFederatedIdentityCredentialsClientWithBaseURI(baseURI string, subscriptionID string) FederatedIdentityCredentialsClient {
	return FederatedIdentityCredentialsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate create or update a federated identity credential under the specified user assigned identity.
// Parameters:
// resourceGroupName - the name of the Resource Group to which the identity belongs.
// resourceName - the name of the identity resource.
// federatedIdentityCredentialResourceName - the name of the federated identity credential resource.
// parameters - parameters to create or update the federated identity credential.
func (client FederatedIdentityCredentialsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string, parameters FederatedIdentityCredential) (result FederatedIdentityCredential, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FederatedIdentityCredentialsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.FederatedIdentityCredentialProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.FederatedIdentityCredentialProperties.Issuer", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.FederatedIdentityCredentialProperties.Subject", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.FederatedIdentityCredentialProperties.Audiences", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("msi.FederatedIdentityCredentialsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, resourceName, federatedIdentityCredentialResourceName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client FederatedIdentityCredentialsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string, parameters FederatedIdentityCredential) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"federatedIdentityCredentialResourceName": autorest.Encode("path", federatedIdentityCredentialResourceName),
		"resourceGroupName":                       autorest.Encode("path", resourceGroupName),
		"resourceName":                            autorest.Encode("path", resourceName),
		"subscriptionId":                          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client FederatedIdentityCredentialsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client FederatedIdentityCredentialsClient) CreateOrUpdateResponder(resp *http.Response) (result FederatedIdentityCredential, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes the federated identity credential.
// Parameters:
// resourceGroupName - the name of the Resource Group to which the identity belongs.
// resourceName - the name of the identity resource.
// federatedIdentityCredentialResourceName - the name of the federated identity credential resource.
func (client FederatedIdentityCredentialsClient) Delete(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FederatedIdentityCredentialsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, resourceName, federatedIdentityCredentialResourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client FederatedIdentityCredentialsClient) DeletePreparer(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"federatedIdentityCredentialResourceName": autorest.Encode("path", federatedIdentityCredentialResourceName),
		"resourceGroupName":                       autorest.Encode("path", resourceGroupName),
		"resourceName":                            autorest.Encode("path", resourceName),
		"subscriptionId":                          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client FederatedIdentityCredentialsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client FederatedIdentityCredentialsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the federated identity credential.
// Parameters:
// resourceGroupName - the name of the Resource Group to which the identity belongs.
// resourceName - the name of the identity resource.
// federatedIdentityCredentialResourceName - the name of the federated identity credential resource.
func (client FederatedIdentityCredentialsClient) Get(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string) (result FederatedIdentityCredential, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FederatedIdentityCredentialsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, resourceName, federatedIdentityCredentialResourceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client FederatedIdentityCredentialsClient) GetPreparer(ctx context.Context, resourceGroupName string, resourceName string, federatedIdentityCredentialResourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"federatedIdentityCredentialResourceName": autorest.Encode("path", federatedIdentityCredentialResourceName),
		"resourceGroupName":                       autorest.Encode("path", resourceGroupName),
		"resourceName":                            autorest.Encode("path", resourceName),
		"subscriptionId":                          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client FederatedIdentityCredentialsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client FederatedIdentityCredentialsClient) GetResponder(resp *http.Response) (result FederatedIdentityCredential, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all the federated identity credentials under the specified user assigned identity.
// Parameters:
// resourceGroupName - the name of the Resource Group to which the identity belongs.
// resourceName - the name of the identity resource.
// top - number of records to return.
// skiptoken - a skip token is used to continue retrieving items after an operation returns a partial result.
// If a previous response contains a nextLink element, the value of the nextLink element will include a
// skipToken parameter that specifies a starting point to use for subsequent calls.
func (client FederatedIdentityCredentialsClient) List(ctx context.Context, resourceGroupName string, resourceName string, top *int32, skiptoken string) (result FederatedIdentityCredentialsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FederatedIdentityCredentialsClient.List")
		defer func() {
			sc := -1
			if result.ficlr.Response.Response != nil {
				sc = result.ficlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("msi.FederatedIdentityCredentialsClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, resourceName, top, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ficlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "List", resp, "Failure sending request")
		return
	}

	result.ficlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.ficlr.hasNextLink() && result.ficlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client FederatedIdentityCredentialsClient) ListPreparer(ctx context.Context, resourceGroupName string, resourceName string, top *int32, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client FederatedIdentityCredentialsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client FederatedIdentityCredentialsClient) ListResponder(resp *http.Response) (result FederatedIdentityCredentialsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client FederatedIdentityCredentialsClient) listNextResults(ctx context.Context, lastResults FederatedIdentityCredentialsListResult) (result FederatedIdentityCredentialsListResult, err error) {
	req, err := lastResults.federatedIdentityCredentialsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "msi.FederatedIdentityCredentialsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client FederatedIdentityCredentialsClient) ListComplete(ctx context.Context, resourceGroupName string, resourceName string, top *int32, skiptoken string) (result FederatedIdentityCredentialsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FederatedIdentityCredentialsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, resourceName, top, skiptoken)
	return
}
