package quantum

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// ProvisioningStatus enumerates the values for provisioning status.
type ProvisioningStatus string

const (
	// Failed ...
	Failed ProvisioningStatus = "Failed"
	// ProviderDeleting ...
	ProviderDeleting ProvisioningStatus = "ProviderDeleting"
	// ProviderLaunching ...
	ProviderLaunching ProvisioningStatus = "ProviderLaunching"
	// ProviderProvisioning ...
	ProviderProvisioning ProvisioningStatus = "ProviderProvisioning"
	// ProviderUpdating ...
	ProviderUpdating ProvisioningStatus = "ProviderUpdating"
	// Succeeded ...
	Succeeded ProvisioningStatus = "Succeeded"
)

// PossibleProvisioningStatusValues returns an array of possible values for the ProvisioningStatus const type.
func PossibleProvisioningStatusValues() []ProvisioningStatus {
	return []ProvisioningStatus{Failed, ProviderDeleting, ProviderLaunching, ProviderProvisioning, ProviderUpdating, Succeeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusDeleted ...
	StatusDeleted Status = "Deleted"
	// StatusDeleting ...
	StatusDeleting Status = "Deleting"
	// StatusFailed ...
	StatusFailed Status = "Failed"
	// StatusLaunching ...
	StatusLaunching Status = "Launching"
	// StatusSucceeded ...
	StatusSucceeded Status = "Succeeded"
	// StatusUpdating ...
	StatusUpdating Status = "Updating"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusDeleted, StatusDeleting, StatusFailed, StatusLaunching, StatusSucceeded, StatusUpdating}
}

// UsableStatus enumerates the values for usable status.
type UsableStatus string

const (
	// No ...
	No UsableStatus = "No"
	// Partial ...
	Partial UsableStatus = "Partial"
	// Yes ...
	Yes UsableStatus = "Yes"
)

// PossibleUsableStatusValues returns an array of possible values for the UsableStatus const type.
func PossibleUsableStatusValues() []UsableStatus {
	return []UsableStatus{No, Partial, Yes}
}
