package resourceconnector

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessProfileType enumerates the values for access profile type.
type AccessProfileType string

const (
	// AccessProfileTypeClusterUser ...
	AccessProfileTypeClusterUser AccessProfileType = "clusterUser"
)

// PossibleAccessProfileTypeValues returns an array of possible values for the AccessProfileType const type.
func PossibleAccessProfileTypeValues() []AccessProfileType {
	return []AccessProfileType{AccessProfileTypeClusterUser}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// Distro enumerates the values for distro.
type Distro string

const (
	// DistroAKSEdge ...
	DistroAKSEdge Distro = "AKSEdge"
)

// PossibleDistroValues returns an array of possible values for the Distro const type.
func PossibleDistroValues() []Distro {
	return []Distro{DistroAKSEdge}
}

// Provider enumerates the values for provider.
type Provider string

const (
	// ProviderHCI ...
	ProviderHCI Provider = "HCI"
	// ProviderSCVMM ...
	ProviderSCVMM Provider = "SCVMM"
	// ProviderVMWare ...
	ProviderVMWare Provider = "VMWare"
)

// PossibleProviderValues returns an array of possible values for the Provider const type.
func PossibleProviderValues() []Provider {
	return []Provider{ProviderHCI, ProviderSCVMM, ProviderVMWare}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusConnected ...
	StatusConnected Status = "Connected"
	// StatusRunning ...
	StatusRunning Status = "Running"
	// StatusValidating ...
	StatusValidating Status = "Validating"
	// StatusWaitingForHeartbeat ...
	StatusWaitingForHeartbeat Status = "WaitingForHeartbeat"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusConnected, StatusRunning, StatusValidating, StatusWaitingForHeartbeat}
}
