package securityinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/securityinsight/mgmt/2019-01-01-preview/securityinsight"

// AADCheckRequirements represents AAD (Azure Active Directory) requirements check request.
type AADCheckRequirements struct {
	// AADCheckRequirementsProperties - AAD (Azure Active Directory) requirements check properties.
	*AADCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADCheckRequirements.
func (acr AADCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if acr.AADCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.AADCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return &acr, true
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AADCheckRequirements.
func (acr AADCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for AADCheckRequirements struct.
func (acr *AADCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADCheckRequirementsProperties AADCheckRequirementsProperties
				err = json.Unmarshal(*v, &aADCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.AADCheckRequirementsProperties = &aADCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// AADCheckRequirementsProperties AAD (Azure Active Directory) requirements check properties.
type AADCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// AADDataConnector represents AAD (Azure Active Directory) data connector.
type AADDataConnector struct {
	// AADDataConnectorProperties - AAD (Azure Active Directory) data connector properties.
	*AADDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADDataConnector.
func (adc AADDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if adc.AADDataConnectorProperties != nil {
		objectMap["properties"] = adc.AADDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return &adc, true
}

// AsAATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AADDataConnector struct.
func (adc *AADDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADDataConnectorProperties AADDataConnectorProperties
				err = json.Unmarshal(*v, &aADDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AADDataConnectorProperties = &aADDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// AADDataConnectorProperties AAD (Azure Active Directory) data connector properties.
type AADDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AATPCheckRequirements represents AATP (Azure Advanced Threat Protection) requirements check request.
type AATPCheckRequirements struct {
	// AATPCheckRequirementsProperties - AATP (Azure Advanced Threat Protection) requirements check properties.
	*AATPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AATPCheckRequirements.
func (acr AATPCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if acr.AATPCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.AATPCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return &acr, true
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AATPCheckRequirements.
func (acr AATPCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for AATPCheckRequirements struct.
func (acr *AATPCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aATPCheckRequirementsProperties AATPCheckRequirementsProperties
				err = json.Unmarshal(*v, &aATPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.AATPCheckRequirementsProperties = &aATPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// AATPCheckRequirementsProperties AATP (Azure Advanced Threat Protection) requirements check properties.
type AATPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// AATPDataConnector represents AATP (Azure Advanced Threat Protection) data connector.
type AATPDataConnector struct {
	// AATPDataConnectorProperties - AATP (Azure Advanced Threat Protection) data connector properties.
	*AATPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AATPDataConnector.
func (adc AATPDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if adc.AATPDataConnectorProperties != nil {
		objectMap["properties"] = adc.AATPDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return &adc, true
}

// AsMSTIDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AATPDataConnector.
func (adc AATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AATPDataConnector struct.
func (adc *AATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aATPDataConnectorProperties AATPDataConnectorProperties
				err = json.Unmarshal(*v, &aATPDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AATPDataConnectorProperties = &aATPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// AATPDataConnectorProperties AATP (Azure Advanced Threat Protection) data connector properties.
type AATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AccountEntity represents an account entity.
type AccountEntity struct {
	// AccountEntityProperties - Account entity properties
	*AccountEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEntity.
func (ae AccountEntity) MarshalJSON() ([]byte, error) {
	ae.Kind = KindBasicEntityKindAccount
	objectMap := make(map[string]interface{})
	if ae.AccountEntityProperties != nil {
		objectMap["properties"] = ae.AccountEntityProperties
	}
	if ae.Kind != "" {
		objectMap["kind"] = ae.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsAccountEntity() (*AccountEntity, bool) {
	return &ae, true
}

// AsAzureResourceEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ae, true
}

// UnmarshalJSON is the custom unmarshaler for AccountEntity struct.
func (ae *AccountEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountEntityProperties AccountEntityProperties
				err = json.Unmarshal(*v, &accountEntityProperties)
				if err != nil {
					return err
				}
				ae.AccountEntityProperties = &accountEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ae.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ae.Kind = kind
			}
		}
	}

	return nil
}

// AccountEntityProperties account entity property bag.
type AccountEntityProperties struct {
	// AadTenantID - READ-ONLY; The Azure Active Directory tenant id.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// AadUserID - READ-ONLY; The Azure Active Directory user id.
	AadUserID *string `json:"aadUserId,omitempty"`
	// AccountName - READ-ONLY; The name of the account. This field should hold only the name without any domain added to it, i.e. administrator.
	AccountName *string `json:"accountName,omitempty"`
	// DisplayName - READ-ONLY; The display name of the account.
	DisplayName *string `json:"displayName,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id that contains the account in case it is a local account (not domain joined)
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this is a domain account.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
	// NtDomain - READ-ONLY; The NetBIOS domain name as it appears in the alert format – domain\username. Examples: NT AUTHORITY.
	NtDomain *string `json:"ntDomain,omitempty"`
	// ObjectGUID - READ-ONLY; The objectGUID attribute is a single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *uuid.UUID `json:"objectGuid,omitempty"`
	// Puid - READ-ONLY; The Azure Active Directory Passport User ID.
	Puid *string `json:"puid,omitempty"`
	// Sid - READ-ONLY; The account security identifier, e.g. S-1-5-18.
	Sid *string `json:"sid,omitempty"`
	// UpnSuffix - READ-ONLY; The user principal name suffix for the account, in some cases it is also the domain name. Examples: contoso.com.
	UpnSuffix *string `json:"upnSuffix,omitempty"`
	// DNSDomain - READ-ONLY; The fully qualified domain DNS name.
	DNSDomain *string `json:"dnsDomain,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEntityProperties.
func (aep AccountEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ActionPropertiesBase action property bag base.
type ActionPropertiesBase struct {
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionRequest action for alert rule.
type ActionRequest struct {
	// ActionRequestProperties - Action properties for put request
	*ActionRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionRequest.
func (ar ActionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ActionRequestProperties != nil {
		objectMap["properties"] = ar.ActionRequestProperties
	}
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionRequest struct.
func (ar *ActionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionRequestProperties ActionRequestProperties
				err = json.Unmarshal(*v, &actionRequestProperties)
				if err != nil {
					return err
				}
				ar.ActionRequestProperties = &actionRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// ActionRequestProperties action property bag.
type ActionRequestProperties struct {
	// TriggerURI - Logic App Callback URL for this specific workflow.
	TriggerURI *string `json:"triggerUri,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionResponse action for alert rule.
type ActionResponse struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the action.
	Etag *string `json:"etag,omitempty"`
	// ActionResponseProperties - Action properties for get request
	*ActionResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionResponse.
func (ar ActionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.ActionResponseProperties != nil {
		objectMap["properties"] = ar.ActionResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionResponse struct.
func (ar *ActionResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		case "properties":
			if v != nil {
				var actionResponseProperties ActionResponseProperties
				err = json.Unmarshal(*v, &actionResponseProperties)
				if err != nil {
					return err
				}
				ar.ActionResponseProperties = &actionResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// ActionResponseProperties action property bag.
type ActionResponseProperties struct {
	// WorkflowID - The name of the logic app's workflow.
	WorkflowID *string `json:"workflowId,omitempty"`
	// LogicAppResourceID - Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
}

// ActionsList list all the actions.
type ActionsList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of actions.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of actions.
	Value *[]ActionResponse `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionsList.
func (al ActionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// ActionsListIterator provides access to a complete listing of ActionResponse values.
type ActionsListIterator struct {
	i    int
	page ActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActionsListIterator) Response() ActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActionsListIterator) Value() ActionResponse {
	if !iter.page.NotDone() {
		return ActionResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActionsListIterator type.
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return ActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ActionsList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al ActionsList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// actionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ActionsList) actionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ActionsListPage contains a page of ActionResponse values.
type ActionsListPage struct {
	fn func(context.Context, ActionsList) (ActionsList, error)
	al ActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActionsListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActionsListPage) Response() ActionsList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActionsListPage) Values() []ActionResponse {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ActionsListPage type.
func NewActionsListPage(cur ActionsList, getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return ActionsListPage{
		fn: getNextPage,
		al: cur,
	}
}

// ActivityTimelineItem represents Activity timeline item.
type ActivityTimelineItem struct {
	// QueryID - The activity query id.
	QueryID *string `json:"queryId,omitempty"`
	// BucketStartTimeUTC - The grouping bucket start time.
	BucketStartTimeUTC *date.Time `json:"bucketStartTimeUTC,omitempty"`
	// BucketEndTimeUTC - The grouping bucket end time.
	BucketEndTimeUTC *date.Time `json:"bucketEndTimeUTC,omitempty"`
	// FirstActivityTimeUTC - The time of the first activity in the grouping bucket.
	FirstActivityTimeUTC *date.Time `json:"firstActivityTimeUTC,omitempty"`
	// LastActivityTimeUTC - The time of the last activity in the grouping bucket.
	LastActivityTimeUTC *date.Time `json:"lastActivityTimeUTC,omitempty"`
	// Content - The activity timeline content.
	Content *string `json:"content,omitempty"`
	// Title - The activity timeline title.
	Title *string `json:"title,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityTimelineItemKindEntityTimelineItem', 'KindBasicEntityTimelineItemKindActivity', 'KindBasicEntityTimelineItemKindSecurityAlert', 'KindBasicEntityTimelineItemKindBookmark'
	Kind KindBasicEntityTimelineItem `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityTimelineItem.
func (ati ActivityTimelineItem) MarshalJSON() ([]byte, error) {
	ati.Kind = KindBasicEntityTimelineItemKindActivity
	objectMap := make(map[string]interface{})
	if ati.QueryID != nil {
		objectMap["queryId"] = ati.QueryID
	}
	if ati.BucketStartTimeUTC != nil {
		objectMap["bucketStartTimeUTC"] = ati.BucketStartTimeUTC
	}
	if ati.BucketEndTimeUTC != nil {
		objectMap["bucketEndTimeUTC"] = ati.BucketEndTimeUTC
	}
	if ati.FirstActivityTimeUTC != nil {
		objectMap["firstActivityTimeUTC"] = ati.FirstActivityTimeUTC
	}
	if ati.LastActivityTimeUTC != nil {
		objectMap["lastActivityTimeUTC"] = ati.LastActivityTimeUTC
	}
	if ati.Content != nil {
		objectMap["content"] = ati.Content
	}
	if ati.Title != nil {
		objectMap["title"] = ati.Title
	}
	if ati.Kind != "" {
		objectMap["kind"] = ati.Kind
	}
	return json.Marshal(objectMap)
}

// AsActivityTimelineItem is the BasicEntityTimelineItem implementation for ActivityTimelineItem.
func (ati ActivityTimelineItem) AsActivityTimelineItem() (*ActivityTimelineItem, bool) {
	return &ati, true
}

// AsSecurityAlertTimelineItem is the BasicEntityTimelineItem implementation for ActivityTimelineItem.
func (ati ActivityTimelineItem) AsSecurityAlertTimelineItem() (*SecurityAlertTimelineItem, bool) {
	return nil, false
}

// AsBookmarkTimelineItem is the BasicEntityTimelineItem implementation for ActivityTimelineItem.
func (ati ActivityTimelineItem) AsBookmarkTimelineItem() (*BookmarkTimelineItem, bool) {
	return nil, false
}

// AsEntityTimelineItem is the BasicEntityTimelineItem implementation for ActivityTimelineItem.
func (ati ActivityTimelineItem) AsEntityTimelineItem() (*EntityTimelineItem, bool) {
	return nil, false
}

// AsBasicEntityTimelineItem is the BasicEntityTimelineItem implementation for ActivityTimelineItem.
func (ati ActivityTimelineItem) AsBasicEntityTimelineItem() (BasicEntityTimelineItem, bool) {
	return &ati, true
}

// BasicAggregations the aggregation.
type BasicAggregations interface {
	AsCasesAggregation() (*CasesAggregation, bool)
	AsAggregations() (*Aggregations, bool)
}

// Aggregations the aggregation.
type Aggregations struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicAggregations(body []byte) (BasicAggregations, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCasesAggregation):
		var ca CasesAggregation
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Aggregations
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAggregationsArray(body []byte) ([]BasicAggregations, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAggregations, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAggregations(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Aggregations.
func (a Aggregations) MarshalJSON() ([]byte, error) {
	a.Kind = KindAggregations
	objectMap := make(map[string]interface{})
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsCasesAggregation() (*CasesAggregation, bool) {
	return nil, false
}

// AsAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsAggregations() (*Aggregations, bool) {
	return &a, true
}

// AsBasicAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsBasicAggregations() (BasicAggregations, bool) {
	return &a, true
}

// AggregationsKind describes an Azure resource with kind.
type AggregationsKind struct {
	// Kind - The kind of the setting
	Kind *string `json:"kind,omitempty"`
}

// AggregationsModel ...
type AggregationsModel struct {
	autorest.Response `json:"-"`
	Value             BasicAggregations `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AggregationsModel struct.
func (am *AggregationsModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicAggregations(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// BasicAlertRule alert rule.
type BasicAlertRule interface {
	AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool)
	AsFusionAlertRule() (*FusionAlertRule, bool)
	AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool)
	AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool)
	AsScheduledAlertRule() (*ScheduledAlertRule, bool)
	AsAlertRule() (*AlertRule, bool)
}

// AlertRule alert rule.
type AlertRule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

func unmarshalBasicAlertRule(body []byte) (BasicAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicAlertRuleKindMLBehaviorAnalytics):
		var mbaar MLBehaviorAnalyticsAlertRule
		err := json.Unmarshal(body, &mbaar)
		return mbaar, err
	case string(KindBasicAlertRuleKindFusion):
		var far FusionAlertRule
		err := json.Unmarshal(body, &far)
		return far, err
	case string(KindBasicAlertRuleKindThreatIntelligence):
		var tiar ThreatIntelligenceAlertRule
		err := json.Unmarshal(body, &tiar)
		return tiar, err
	case string(KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation):
		var msicar MicrosoftSecurityIncidentCreationAlertRule
		err := json.Unmarshal(body, &msicar)
		return msicar, err
	case string(KindBasicAlertRuleKindScheduled):
		var sar ScheduledAlertRule
		err := json.Unmarshal(body, &sar)
		return sar, err
	default:
		var ar AlertRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	}
}
func unmarshalBasicAlertRuleArray(body []byte) ([]BasicAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arArray := make([]BasicAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ar, err := unmarshalBasicAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		arArray[index] = ar
	}
	return arArray, nil
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	ar.Kind = KindBasicAlertRuleKindAlertRule
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.Kind != "" {
		objectMap["kind"] = ar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return nil, false
}

// AsFusionAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsAlertRule() (*AlertRule, bool) {
	return &ar, true
}

// AsBasicAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &ar, true
}

// AlertRuleKind1 describes an Azure resource with kind.
type AlertRuleKind1 struct {
	// Kind - The kind of the alert rule. Possible values include: 'AlertRuleKindScheduled', 'AlertRuleKindMicrosoftSecurityIncidentCreation', 'AlertRuleKindFusion', 'AlertRuleKindMLBehaviorAnalytics', 'AlertRuleKindThreatIntelligence'
	Kind AlertRuleKind `json:"kind,omitempty"`
}

// AlertRuleModel ...
type AlertRuleModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleModel struct.
func (arm *AlertRuleModel) UnmarshalJSON(body []byte) error {
	ar, err := unmarshalBasicAlertRule(body)
	if err != nil {
		return err
	}
	arm.Value = ar

	return nil
}

// AlertRulesList list all the alert rules.
type AlertRulesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rules.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rules.
	Value *[]BasicAlertRule `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRulesList.
func (arl AlertRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arl.Value != nil {
		objectMap["value"] = arl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRulesList struct.
func (arl *AlertRulesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				arl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleArray(*v)
				if err != nil {
					return err
				}
				arl.Value = &value
			}
		}
	}

	return nil
}

// AlertRulesListIterator provides access to a complete listing of AlertRule values.
type AlertRulesListIterator struct {
	i    int
	page AlertRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRulesListIterator) Response() AlertRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRulesListIterator) Value() BasicAlertRule {
	if !iter.page.NotDone() {
		return AlertRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRulesListIterator type.
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return AlertRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRulesList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AlertRulesList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// alertRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRulesList) alertRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRulesListPage contains a page of BasicAlertRule values.
type AlertRulesListPage struct {
	fn  func(context.Context, AlertRulesList) (AlertRulesList, error)
	arl AlertRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRulesListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRulesListPage) Response() AlertRulesList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRulesListPage) Values() []BasicAlertRule {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRulesListPage type.
func NewAlertRulesListPage(cur AlertRulesList, getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return AlertRulesListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// BasicAlertRuleTemplate alert rule template.
type BasicAlertRuleTemplate interface {
	AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool)
	AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool)
	AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool)
	AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool)
	AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool)
	AsAlertRuleTemplate() (*AlertRuleTemplate, bool)
}

// AlertRuleTemplate alert rule template.
type AlertRuleTemplate struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

func unmarshalBasicAlertRuleTemplate(body []byte) (BasicAlertRuleTemplate, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicAlertRuleTemplateKindMLBehaviorAnalytics):
		var mbaart MLBehaviorAnalyticsAlertRuleTemplate
		err := json.Unmarshal(body, &mbaart)
		return mbaart, err
	case string(KindBasicAlertRuleTemplateKindFusion):
		var fart FusionAlertRuleTemplate
		err := json.Unmarshal(body, &fart)
		return fart, err
	case string(KindBasicAlertRuleTemplateKindThreatIntelligence):
		var tiart ThreatIntelligenceAlertRuleTemplate
		err := json.Unmarshal(body, &tiart)
		return tiart, err
	case string(KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation):
		var msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate
		err := json.Unmarshal(body, &msicart)
		return msicart, err
	case string(KindBasicAlertRuleTemplateKindScheduled):
		var sart ScheduledAlertRuleTemplate
		err := json.Unmarshal(body, &sart)
		return sart, err
	default:
		var art AlertRuleTemplate
		err := json.Unmarshal(body, &art)
		return art, err
	}
}
func unmarshalBasicAlertRuleTemplateArray(body []byte) ([]BasicAlertRuleTemplate, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	artArray := make([]BasicAlertRuleTemplate, len(rawMessages))

	for index, rawMessage := range rawMessages {
		art, err := unmarshalBasicAlertRuleTemplate(*rawMessage)
		if err != nil {
			return nil, err
		}
		artArray[index] = art
	}
	return artArray, nil
}

// MarshalJSON is the custom marshaler for AlertRuleTemplate.
func (art AlertRuleTemplate) MarshalJSON() ([]byte, error) {
	art.Kind = KindBasicAlertRuleTemplateKindAlertRuleTemplate
	objectMap := make(map[string]interface{})
	if art.Kind != "" {
		objectMap["kind"] = art.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return nil, false
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return &art, true
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for AlertRuleTemplate.
func (art AlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &art, true
}

// AlertRuleTemplateDataSource alert rule template data sources
type AlertRuleTemplateDataSource struct {
	// ConnectorID - The connector id that provides the following data types
	ConnectorID *string `json:"connectorId,omitempty"`
	// DataTypes - The data types used by the alert rule template
	DataTypes *[]string `json:"dataTypes,omitempty"`
}

// AlertRuleTemplateModel ...
type AlertRuleTemplateModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRuleTemplate `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplateModel struct.
func (artm *AlertRuleTemplateModel) UnmarshalJSON(body []byte) error {
	art, err := unmarshalBasicAlertRuleTemplate(body)
	if err != nil {
		return err
	}
	artm.Value = art

	return nil
}

// AlertRuleTemplatePropertiesBase base alert rule template property bag.
type AlertRuleTemplatePropertiesBase struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleTemplatePropertiesBase.
func (artpb AlertRuleTemplatePropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if artpb.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = artpb.AlertRulesCreatedByTemplateCount
	}
	if artpb.Description != nil {
		objectMap["description"] = artpb.Description
	}
	if artpb.DisplayName != nil {
		objectMap["displayName"] = artpb.DisplayName
	}
	if artpb.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = artpb.RequiredDataConnectors
	}
	if artpb.Status != "" {
		objectMap["status"] = artpb.Status
	}
	return json.Marshal(objectMap)
}

// AlertRuleTemplatesList list all the alert rule templates.
type AlertRuleTemplatesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rule templates.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rule templates.
	Value *[]BasicAlertRuleTemplate `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleTemplatesList.
func (artl AlertRuleTemplatesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if artl.Value != nil {
		objectMap["value"] = artl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleTemplatesList struct.
func (artl *AlertRuleTemplatesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				artl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleTemplateArray(*v)
				if err != nil {
					return err
				}
				artl.Value = &value
			}
		}
	}

	return nil
}

// AlertRuleTemplatesListIterator provides access to a complete listing of AlertRuleTemplate values.
type AlertRuleTemplatesListIterator struct {
	i    int
	page AlertRuleTemplatesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRuleTemplatesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRuleTemplatesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRuleTemplatesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRuleTemplatesListIterator) Response() AlertRuleTemplatesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRuleTemplatesListIterator) Value() BasicAlertRuleTemplate {
	if !iter.page.NotDone() {
		return AlertRuleTemplate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRuleTemplatesListIterator type.
func NewAlertRuleTemplatesListIterator(page AlertRuleTemplatesListPage) AlertRuleTemplatesListIterator {
	return AlertRuleTemplatesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (artl AlertRuleTemplatesList) IsEmpty() bool {
	return artl.Value == nil || len(*artl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (artl AlertRuleTemplatesList) hasNextLink() bool {
	return artl.NextLink != nil && len(*artl.NextLink) != 0
}

// alertRuleTemplatesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (artl AlertRuleTemplatesList) alertRuleTemplatesListPreparer(ctx context.Context) (*http.Request, error) {
	if !artl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(artl.NextLink)))
}

// AlertRuleTemplatesListPage contains a page of BasicAlertRuleTemplate values.
type AlertRuleTemplatesListPage struct {
	fn   func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)
	artl AlertRuleTemplatesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRuleTemplatesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRuleTemplatesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.artl)
		if err != nil {
			return err
		}
		page.artl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRuleTemplatesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRuleTemplatesListPage) NotDone() bool {
	return !page.artl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRuleTemplatesListPage) Response() AlertRuleTemplatesList {
	return page.artl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRuleTemplatesListPage) Values() []BasicAlertRuleTemplate {
	if page.artl.IsEmpty() {
		return nil
	}
	return *page.artl.Value
}

// Creates a new instance of the AlertRuleTemplatesListPage type.
func NewAlertRuleTemplatesListPage(cur AlertRuleTemplatesList, getNextPage func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)) AlertRuleTemplatesListPage {
	return AlertRuleTemplatesListPage{
		fn:   getNextPage,
		artl: cur,
	}
}

// AlertsDataTypeOfDataConnector alerts data type for data connectors.
type AlertsDataTypeOfDataConnector struct {
	// Alerts - Alerts data type connection.
	Alerts *AlertsDataTypeOfDataConnectorAlerts `json:"alerts,omitempty"`
}

// AlertsDataTypeOfDataConnectorAlerts alerts data type connection.
type AlertsDataTypeOfDataConnectorAlerts struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// ASCCheckRequirements represents ASC (Azure Security Center) requirements check request.
type ASCCheckRequirements struct {
	// ASCCheckRequirementsProperties - ASC (Azure Security Center) requirements check properties.
	*ASCCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCCheckRequirements.
func (acr ASCCheckRequirements) MarshalJSON() ([]byte, error) {
	acr.Kind = KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if acr.ASCCheckRequirementsProperties != nil {
		objectMap["properties"] = acr.ASCCheckRequirementsProperties
	}
	if acr.Kind != "" {
		objectMap["kind"] = acr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return &acr, true
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for ASCCheckRequirements.
func (acr ASCCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &acr, true
}

// UnmarshalJSON is the custom unmarshaler for ASCCheckRequirements struct.
func (acr *ASCCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCCheckRequirementsProperties ASCCheckRequirementsProperties
				err = json.Unmarshal(*v, &aSCCheckRequirementsProperties)
				if err != nil {
					return err
				}
				acr.ASCCheckRequirementsProperties = &aSCCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				acr.Kind = kind
			}
		}
	}

	return nil
}

// ASCCheckRequirementsProperties ASC (Azure Security Center) requirements check properties.
type ASCCheckRequirementsProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// ASCDataConnector represents ASC (Azure Security Center) data connector.
type ASCDataConnector struct {
	// ASCDataConnectorProperties - ASC (Azure Security Center) data connector properties.
	*ASCDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCDataConnector.
func (adc ASCDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindBasicDataConnectorKindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if adc.ASCDataConnectorProperties != nil {
		objectMap["properties"] = adc.ASCDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return &adc, true
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for ASCDataConnector struct.
func (adc *ASCDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCDataConnectorProperties ASCDataConnectorProperties
				err = json.Unmarshal(*v, &aSCDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.ASCDataConnectorProperties = &aSCDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// ASCDataConnectorProperties ASC (Azure Security Center) data connector properties.
type ASCDataConnectorProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AutomationRule represents an automation rule.
type AutomationRule struct {
	autorest.Response `json:"-"`
	// AutomationRuleProperties - Automation rule properties
	*AutomationRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRule.
func (ar AutomationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AutomationRuleProperties != nil {
		objectMap["properties"] = ar.AutomationRuleProperties
	}
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutomationRule struct.
func (ar *AutomationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automationRuleProperties AutomationRuleProperties
				err = json.Unmarshal(*v, &automationRuleProperties)
				if err != nil {
					return err
				}
				ar.AutomationRuleProperties = &automationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ar.Etag = &etag
			}
		}
	}

	return nil
}

// BasicAutomationRuleAction describes an automation rule action
type BasicAutomationRuleAction interface {
	AsAutomationRuleRunPlaybookAction() (*AutomationRuleRunPlaybookAction, bool)
	AsAutomationRuleModifyPropertiesAction() (*AutomationRuleModifyPropertiesAction, bool)
	AsAutomationRuleAction() (*AutomationRuleAction, bool)
}

// AutomationRuleAction describes an automation rule action
type AutomationRuleAction struct {
	// Order - The order of execution of the automation rule action
	Order *int32 `json:"order,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationRuleAction', 'ActionTypeRunPlaybook', 'ActionTypeModifyProperties'
	ActionType ActionType `json:"actionType,omitempty"`
}

func unmarshalBasicAutomationRuleAction(body []byte) (BasicAutomationRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["actionType"] {
	case string(ActionTypeRunPlaybook):
		var arrpa AutomationRuleRunPlaybookAction
		err := json.Unmarshal(body, &arrpa)
		return arrpa, err
	case string(ActionTypeModifyProperties):
		var armpa AutomationRuleModifyPropertiesAction
		err := json.Unmarshal(body, &armpa)
		return armpa, err
	default:
		var ara AutomationRuleAction
		err := json.Unmarshal(body, &ara)
		return ara, err
	}
}
func unmarshalBasicAutomationRuleActionArray(body []byte) ([]BasicAutomationRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	araArray := make([]BasicAutomationRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ara, err := unmarshalBasicAutomationRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		araArray[index] = ara
	}
	return araArray, nil
}

// MarshalJSON is the custom marshaler for AutomationRuleAction.
func (ara AutomationRuleAction) MarshalJSON() ([]byte, error) {
	ara.ActionType = ActionTypeAutomationRuleAction
	objectMap := make(map[string]interface{})
	if ara.Order != nil {
		objectMap["order"] = ara.Order
	}
	if ara.ActionType != "" {
		objectMap["actionType"] = ara.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRuleRunPlaybookAction is the BasicAutomationRuleAction implementation for AutomationRuleAction.
func (ara AutomationRuleAction) AsAutomationRuleRunPlaybookAction() (*AutomationRuleRunPlaybookAction, bool) {
	return nil, false
}

// AsAutomationRuleModifyPropertiesAction is the BasicAutomationRuleAction implementation for AutomationRuleAction.
func (ara AutomationRuleAction) AsAutomationRuleModifyPropertiesAction() (*AutomationRuleModifyPropertiesAction, bool) {
	return nil, false
}

// AsAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleAction.
func (ara AutomationRuleAction) AsAutomationRuleAction() (*AutomationRuleAction, bool) {
	return &ara, true
}

// AsBasicAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleAction.
func (ara AutomationRuleAction) AsBasicAutomationRuleAction() (BasicAutomationRuleAction, bool) {
	return &ara, true
}

// BasicAutomationRuleCondition describes an automation rule condition
type BasicAutomationRuleCondition interface {
	AsAutomationRulePropertyValuesCondition() (*AutomationRulePropertyValuesCondition, bool)
	AsAutomationRuleCondition() (*AutomationRuleCondition, bool)
}

// AutomationRuleCondition describes an automation rule condition
type AutomationRuleCondition struct {
	// ConditionType - Possible values include: 'ConditionTypeAutomationRuleCondition', 'ConditionTypeProperty'
	ConditionType ConditionType `json:"conditionType,omitempty"`
}

func unmarshalBasicAutomationRuleCondition(body []byte) (BasicAutomationRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["conditionType"] {
	case string(ConditionTypeProperty):
		var arpvc AutomationRulePropertyValuesCondition
		err := json.Unmarshal(body, &arpvc)
		return arpvc, err
	default:
		var arc AutomationRuleCondition
		err := json.Unmarshal(body, &arc)
		return arc, err
	}
}
func unmarshalBasicAutomationRuleConditionArray(body []byte) ([]BasicAutomationRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arcArray := make([]BasicAutomationRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		arc, err := unmarshalBasicAutomationRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		arcArray[index] = arc
	}
	return arcArray, nil
}

// MarshalJSON is the custom marshaler for AutomationRuleCondition.
func (arc AutomationRuleCondition) MarshalJSON() ([]byte, error) {
	arc.ConditionType = ConditionTypeAutomationRuleCondition
	objectMap := make(map[string]interface{})
	if arc.ConditionType != "" {
		objectMap["conditionType"] = arc.ConditionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRulePropertyValuesCondition is the BasicAutomationRuleCondition implementation for AutomationRuleCondition.
func (arc AutomationRuleCondition) AsAutomationRulePropertyValuesCondition() (*AutomationRulePropertyValuesCondition, bool) {
	return nil, false
}

// AsAutomationRuleCondition is the BasicAutomationRuleCondition implementation for AutomationRuleCondition.
func (arc AutomationRuleCondition) AsAutomationRuleCondition() (*AutomationRuleCondition, bool) {
	return &arc, true
}

// AsBasicAutomationRuleCondition is the BasicAutomationRuleCondition implementation for AutomationRuleCondition.
func (arc AutomationRuleCondition) AsBasicAutomationRuleCondition() (BasicAutomationRuleCondition, bool) {
	return &arc, true
}

// AutomationRuleModifyPropertiesAction describes an automation rule action to modify an object's
// properties
type AutomationRuleModifyPropertiesAction struct {
	// ActionConfiguration - The configuration of the modify properties automation rule action
	ActionConfiguration *AutomationRuleModifyPropertiesActionActionConfiguration `json:"actionConfiguration,omitempty"`
	// Order - The order of execution of the automation rule action
	Order *int32 `json:"order,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationRuleAction', 'ActionTypeRunPlaybook', 'ActionTypeModifyProperties'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRuleModifyPropertiesAction.
func (armpa AutomationRuleModifyPropertiesAction) MarshalJSON() ([]byte, error) {
	armpa.ActionType = ActionTypeModifyProperties
	objectMap := make(map[string]interface{})
	if armpa.ActionConfiguration != nil {
		objectMap["actionConfiguration"] = armpa.ActionConfiguration
	}
	if armpa.Order != nil {
		objectMap["order"] = armpa.Order
	}
	if armpa.ActionType != "" {
		objectMap["actionType"] = armpa.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRuleRunPlaybookAction is the BasicAutomationRuleAction implementation for AutomationRuleModifyPropertiesAction.
func (armpa AutomationRuleModifyPropertiesAction) AsAutomationRuleRunPlaybookAction() (*AutomationRuleRunPlaybookAction, bool) {
	return nil, false
}

// AsAutomationRuleModifyPropertiesAction is the BasicAutomationRuleAction implementation for AutomationRuleModifyPropertiesAction.
func (armpa AutomationRuleModifyPropertiesAction) AsAutomationRuleModifyPropertiesAction() (*AutomationRuleModifyPropertiesAction, bool) {
	return &armpa, true
}

// AsAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleModifyPropertiesAction.
func (armpa AutomationRuleModifyPropertiesAction) AsAutomationRuleAction() (*AutomationRuleAction, bool) {
	return nil, false
}

// AsBasicAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleModifyPropertiesAction.
func (armpa AutomationRuleModifyPropertiesAction) AsBasicAutomationRuleAction() (BasicAutomationRuleAction, bool) {
	return &armpa, true
}

// AutomationRuleModifyPropertiesActionActionConfiguration the configuration of the modify properties
// automation rule action
type AutomationRuleModifyPropertiesActionActionConfiguration struct {
	// Classification - The reason the incident was closed. Possible values include: 'IncidentClassificationUndetermined', 'IncidentClassificationTruePositive', 'IncidentClassificationBenignPositive', 'IncidentClassificationFalsePositive'
	Classification IncidentClassification `json:"classification,omitempty"`
	// ClassificationComment - Describes the reason the incident was closed
	ClassificationComment *string `json:"classificationComment,omitempty"`
	// ClassificationReason - The classification reason to close the incident with. Possible values include: 'IncidentClassificationReasonSuspiciousActivity', 'IncidentClassificationReasonSuspiciousButExpected', 'IncidentClassificationReasonIncorrectAlertLogic', 'IncidentClassificationReasonInaccurateData'
	ClassificationReason IncidentClassificationReason `json:"classificationReason,omitempty"`
	// Labels - List of labels to add to the incident
	Labels *[]IncidentLabel `json:"labels,omitempty"`
	// Owner - Describes a user that the incident is assigned to
	Owner *IncidentOwnerInfo `json:"owner,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'IncidentSeverityHigh', 'IncidentSeverityMedium', 'IncidentSeverityLow', 'IncidentSeverityInformational'
	Severity IncidentSeverity `json:"severity,omitempty"`
	// Status - The status of the incident. Possible values include: 'IncidentStatusNew', 'IncidentStatusActive', 'IncidentStatusClosed'
	Status IncidentStatus `json:"status,omitempty"`
}

// AutomationRuleProperties describes automation rule properties
type AutomationRuleProperties struct {
	// DisplayName - The display name of the automation  rule
	DisplayName *string `json:"displayName,omitempty"`
	// Order - The order of execution of the automation rule
	Order *int32 `json:"order,omitempty"`
	// TriggeringLogic - The triggering logic of the automation rule
	TriggeringLogic *AutomationRuleTriggeringLogic `json:"triggeringLogic,omitempty"`
	// Actions - The actions to execute when the automation rule is triggered
	Actions *[]BasicAutomationRuleAction `json:"actions,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the automation rule was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; The last time the automation rule was updated
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// CreatedBy - READ-ONLY; Describes the client that created the automation rule
	CreatedBy *ClientInfo `json:"createdBy,omitempty"`
	// LastModifiedBy - READ-ONLY; Describes the client that last updated the automation rule
	LastModifiedBy *ClientInfo `json:"lastModifiedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRuleProperties.
func (arp AutomationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.DisplayName != nil {
		objectMap["displayName"] = arp.DisplayName
	}
	if arp.Order != nil {
		objectMap["order"] = arp.Order
	}
	if arp.TriggeringLogic != nil {
		objectMap["triggeringLogic"] = arp.TriggeringLogic
	}
	if arp.Actions != nil {
		objectMap["actions"] = arp.Actions
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutomationRuleProperties struct.
func (arp *AutomationRuleProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				arp.DisplayName = &displayName
			}
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				arp.Order = &order
			}
		case "triggeringLogic":
			if v != nil {
				var triggeringLogic AutomationRuleTriggeringLogic
				err = json.Unmarshal(*v, &triggeringLogic)
				if err != nil {
					return err
				}
				arp.TriggeringLogic = &triggeringLogic
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicAutomationRuleActionArray(*v)
				if err != nil {
					return err
				}
				arp.Actions = &actions
			}
		case "createdTimeUtc":
			if v != nil {
				var createdTimeUtc date.Time
				err = json.Unmarshal(*v, &createdTimeUtc)
				if err != nil {
					return err
				}
				arp.CreatedTimeUtc = &createdTimeUtc
			}
		case "lastModifiedTimeUtc":
			if v != nil {
				var lastModifiedTimeUtc date.Time
				err = json.Unmarshal(*v, &lastModifiedTimeUtc)
				if err != nil {
					return err
				}
				arp.LastModifiedTimeUtc = &lastModifiedTimeUtc
			}
		case "createdBy":
			if v != nil {
				var createdBy ClientInfo
				err = json.Unmarshal(*v, &createdBy)
				if err != nil {
					return err
				}
				arp.CreatedBy = &createdBy
			}
		case "lastModifiedBy":
			if v != nil {
				var lastModifiedBy ClientInfo
				err = json.Unmarshal(*v, &lastModifiedBy)
				if err != nil {
					return err
				}
				arp.LastModifiedBy = &lastModifiedBy
			}
		}
	}

	return nil
}

// AutomationRulePropertyValuesCondition describes an automation rule condition that evaluates a property's
// value
type AutomationRulePropertyValuesCondition struct {
	// ConditionProperties - The configuration of the automation rule condition
	ConditionProperties *AutomationRulePropertyValuesConditionConditionProperties `json:"conditionProperties,omitempty"`
	// ConditionType - Possible values include: 'ConditionTypeAutomationRuleCondition', 'ConditionTypeProperty'
	ConditionType ConditionType `json:"conditionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRulePropertyValuesCondition.
func (arpvc AutomationRulePropertyValuesCondition) MarshalJSON() ([]byte, error) {
	arpvc.ConditionType = ConditionTypeProperty
	objectMap := make(map[string]interface{})
	if arpvc.ConditionProperties != nil {
		objectMap["conditionProperties"] = arpvc.ConditionProperties
	}
	if arpvc.ConditionType != "" {
		objectMap["conditionType"] = arpvc.ConditionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRulePropertyValuesCondition is the BasicAutomationRuleCondition implementation for AutomationRulePropertyValuesCondition.
func (arpvc AutomationRulePropertyValuesCondition) AsAutomationRulePropertyValuesCondition() (*AutomationRulePropertyValuesCondition, bool) {
	return &arpvc, true
}

// AsAutomationRuleCondition is the BasicAutomationRuleCondition implementation for AutomationRulePropertyValuesCondition.
func (arpvc AutomationRulePropertyValuesCondition) AsAutomationRuleCondition() (*AutomationRuleCondition, bool) {
	return nil, false
}

// AsBasicAutomationRuleCondition is the BasicAutomationRuleCondition implementation for AutomationRulePropertyValuesCondition.
func (arpvc AutomationRulePropertyValuesCondition) AsBasicAutomationRuleCondition() (BasicAutomationRuleCondition, bool) {
	return &arpvc, true
}

// AutomationRulePropertyValuesConditionConditionProperties the configuration of the automation rule
// condition
type AutomationRulePropertyValuesConditionConditionProperties struct {
	// PropertyName - The property to evaluate. Possible values include: 'AutomationRulePropertyConditionSupportedPropertyIncidentTitle', 'AutomationRulePropertyConditionSupportedPropertyIncidentDescription', 'AutomationRulePropertyConditionSupportedPropertyIncidentSeverity', 'AutomationRulePropertyConditionSupportedPropertyIncidentStatus', 'AutomationRulePropertyConditionSupportedPropertyIncidentTactics', 'AutomationRulePropertyConditionSupportedPropertyIncidentRelatedAnalyticRuleIds', 'AutomationRulePropertyConditionSupportedPropertyIncidentProviderName', 'AutomationRulePropertyConditionSupportedPropertyAccountAadTenantID', 'AutomationRulePropertyConditionSupportedPropertyAccountAadUserID', 'AutomationRulePropertyConditionSupportedPropertyAccountName', 'AutomationRulePropertyConditionSupportedPropertyAccountNTDomain', 'AutomationRulePropertyConditionSupportedPropertyAccountPUID', 'AutomationRulePropertyConditionSupportedPropertyAccountSid', 'AutomationRulePropertyConditionSupportedPropertyAccountObjectGUID', 'AutomationRulePropertyConditionSupportedPropertyAccountUPNSuffix', 'AutomationRulePropertyConditionSupportedPropertyAzureResourceResourceID', 'AutomationRulePropertyConditionSupportedPropertyAzureResourceSubscriptionID', 'AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppID', 'AutomationRulePropertyConditionSupportedPropertyCloudApplicationAppName', 'AutomationRulePropertyConditionSupportedPropertyDNSDomainName', 'AutomationRulePropertyConditionSupportedPropertyFileDirectory', 'AutomationRulePropertyConditionSupportedPropertyFileName', 'AutomationRulePropertyConditionSupportedPropertyFileHashValue', 'AutomationRulePropertyConditionSupportedPropertyHostAzureID', 'AutomationRulePropertyConditionSupportedPropertyHostName', 'AutomationRulePropertyConditionSupportedPropertyHostNetBiosName', 'AutomationRulePropertyConditionSupportedPropertyHostNTDomain', 'AutomationRulePropertyConditionSupportedPropertyHostOSVersion', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceID', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceName', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceType', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceVendor', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceModel', 'AutomationRulePropertyConditionSupportedPropertyIoTDeviceOperatingSystem', 'AutomationRulePropertyConditionSupportedPropertyIPAddress', 'AutomationRulePropertyConditionSupportedPropertyMailboxDisplayName', 'AutomationRulePropertyConditionSupportedPropertyMailboxPrimaryAddress', 'AutomationRulePropertyConditionSupportedPropertyMailboxUPN', 'AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryAction', 'AutomationRulePropertyConditionSupportedPropertyMailMessageDeliveryLocation', 'AutomationRulePropertyConditionSupportedPropertyMailMessageRecipient', 'AutomationRulePropertyConditionSupportedPropertyMailMessageSenderIP', 'AutomationRulePropertyConditionSupportedPropertyMailMessageSubject', 'AutomationRulePropertyConditionSupportedPropertyMailMessageP1Sender', 'AutomationRulePropertyConditionSupportedPropertyMailMessageP2Sender', 'AutomationRulePropertyConditionSupportedPropertyMalwareCategory', 'AutomationRulePropertyConditionSupportedPropertyMalwareName', 'AutomationRulePropertyConditionSupportedPropertyProcessCommandLine', 'AutomationRulePropertyConditionSupportedPropertyProcessID', 'AutomationRulePropertyConditionSupportedPropertyRegistryKey', 'AutomationRulePropertyConditionSupportedPropertyRegistryValueData', 'AutomationRulePropertyConditionSupportedPropertyURL'
	PropertyName AutomationRulePropertyConditionSupportedProperty `json:"propertyName,omitempty"`
	// Operator - The operator to use for evaluation the condition. Possible values include: 'AutomationRulePropertyConditionSupportedOperatorEquals', 'AutomationRulePropertyConditionSupportedOperatorNotEquals', 'AutomationRulePropertyConditionSupportedOperatorContains', 'AutomationRulePropertyConditionSupportedOperatorNotContains', 'AutomationRulePropertyConditionSupportedOperatorStartsWith', 'AutomationRulePropertyConditionSupportedOperatorNotStartsWith', 'AutomationRulePropertyConditionSupportedOperatorEndsWith', 'AutomationRulePropertyConditionSupportedOperatorNotEndsWith'
	Operator AutomationRulePropertyConditionSupportedOperator `json:"operator,omitempty"`
	// PropertyValues - The values to use for evaluating the condition
	PropertyValues *[]string `json:"propertyValues,omitempty"`
}

// AutomationRuleRunPlaybookAction describes an automation rule action to run a playbook
type AutomationRuleRunPlaybookAction struct {
	// ActionConfiguration - The configuration of the run playbook automation rule action
	ActionConfiguration *AutomationRuleRunPlaybookActionActionConfiguration `json:"actionConfiguration,omitempty"`
	// Order - The order of execution of the automation rule action
	Order *int32 `json:"order,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationRuleAction', 'ActionTypeRunPlaybook', 'ActionTypeModifyProperties'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRuleRunPlaybookAction.
func (arrpa AutomationRuleRunPlaybookAction) MarshalJSON() ([]byte, error) {
	arrpa.ActionType = ActionTypeRunPlaybook
	objectMap := make(map[string]interface{})
	if arrpa.ActionConfiguration != nil {
		objectMap["actionConfiguration"] = arrpa.ActionConfiguration
	}
	if arrpa.Order != nil {
		objectMap["order"] = arrpa.Order
	}
	if arrpa.ActionType != "" {
		objectMap["actionType"] = arrpa.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationRuleRunPlaybookAction is the BasicAutomationRuleAction implementation for AutomationRuleRunPlaybookAction.
func (arrpa AutomationRuleRunPlaybookAction) AsAutomationRuleRunPlaybookAction() (*AutomationRuleRunPlaybookAction, bool) {
	return &arrpa, true
}

// AsAutomationRuleModifyPropertiesAction is the BasicAutomationRuleAction implementation for AutomationRuleRunPlaybookAction.
func (arrpa AutomationRuleRunPlaybookAction) AsAutomationRuleModifyPropertiesAction() (*AutomationRuleModifyPropertiesAction, bool) {
	return nil, false
}

// AsAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleRunPlaybookAction.
func (arrpa AutomationRuleRunPlaybookAction) AsAutomationRuleAction() (*AutomationRuleAction, bool) {
	return nil, false
}

// AsBasicAutomationRuleAction is the BasicAutomationRuleAction implementation for AutomationRuleRunPlaybookAction.
func (arrpa AutomationRuleRunPlaybookAction) AsBasicAutomationRuleAction() (BasicAutomationRuleAction, bool) {
	return &arrpa, true
}

// AutomationRuleRunPlaybookActionActionConfiguration the configuration of the run playbook automation rule
// action
type AutomationRuleRunPlaybookActionActionConfiguration struct {
	// LogicAppResourceID - The resource id of the playbook resource
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
	// TenantID - The tenant id of the playbook resource
	TenantID *string `json:"tenantId,omitempty"`
}

// AutomationRulesList list all the automation rules.
type AutomationRulesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of automation rules.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of automation rules.
	Value *[]AutomationRule `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRulesList.
func (arl AutomationRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arl.Value != nil {
		objectMap["value"] = arl.Value
	}
	return json.Marshal(objectMap)
}

// AutomationRulesListIterator provides access to a complete listing of AutomationRule values.
type AutomationRulesListIterator struct {
	i    int
	page AutomationRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutomationRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutomationRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutomationRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutomationRulesListIterator) Response() AutomationRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutomationRulesListIterator) Value() AutomationRule {
	if !iter.page.NotDone() {
		return AutomationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutomationRulesListIterator type.
func NewAutomationRulesListIterator(page AutomationRulesListPage) AutomationRulesListIterator {
	return AutomationRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AutomationRulesList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AutomationRulesList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// automationRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AutomationRulesList) automationRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AutomationRulesListPage contains a page of AutomationRule values.
type AutomationRulesListPage struct {
	fn  func(context.Context, AutomationRulesList) (AutomationRulesList, error)
	arl AutomationRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutomationRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutomationRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutomationRulesListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutomationRulesListPage) Response() AutomationRulesList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutomationRulesListPage) Values() []AutomationRule {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AutomationRulesListPage type.
func NewAutomationRulesListPage(cur AutomationRulesList, getNextPage func(context.Context, AutomationRulesList) (AutomationRulesList, error)) AutomationRulesListPage {
	return AutomationRulesListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AutomationRuleTriggeringLogic describes automation rule triggering logic
type AutomationRuleTriggeringLogic struct {
	// IsEnabled - Determines whether the automation rule is enabled or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// ExpirationTimeUtc - Determines when the automation rule should automatically expire and be disabled.
	ExpirationTimeUtc *date.Time `json:"expirationTimeUtc,omitempty"`
	// TriggersOn - The type of object the automation rule triggers on
	TriggersOn *string `json:"triggersOn,omitempty"`
	// TriggersWhen - The type of event the automation rule triggers on
	TriggersWhen *string `json:"triggersWhen,omitempty"`
	// Conditions - The conditions to evaluate to determine if the automation rule should be triggered on a given object
	Conditions *[]BasicAutomationRuleCondition `json:"conditions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutomationRuleTriggeringLogic struct.
func (artl *AutomationRuleTriggeringLogic) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				artl.IsEnabled = &isEnabled
			}
		case "expirationTimeUtc":
			if v != nil {
				var expirationTimeUtc date.Time
				err = json.Unmarshal(*v, &expirationTimeUtc)
				if err != nil {
					return err
				}
				artl.ExpirationTimeUtc = &expirationTimeUtc
			}
		case "triggersOn":
			if v != nil {
				var triggersOn string
				err = json.Unmarshal(*v, &triggersOn)
				if err != nil {
					return err
				}
				artl.TriggersOn = &triggersOn
			}
		case "triggersWhen":
			if v != nil {
				var triggersWhen string
				err = json.Unmarshal(*v, &triggersWhen)
				if err != nil {
					return err
				}
				artl.TriggersWhen = &triggersWhen
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicAutomationRuleConditionArray(*v)
				if err != nil {
					return err
				}
				artl.Conditions = &conditions
			}
		}
	}

	return nil
}

// AwsCloudTrailCheckRequirements amazon Web Services CloudTrail requirements check request.
type AwsCloudTrailCheckRequirements struct {
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) MarshalJSON() ([]byte, error) {
	actcr.Kind = KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail
	objectMap := make(map[string]interface{})
	if actcr.Kind != "" {
		objectMap["kind"] = actcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return &actcr, true
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for AwsCloudTrailCheckRequirements.
func (actcr AwsCloudTrailCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &actcr, true
}

// AwsCloudTrailDataConnector represents Amazon Web Services CloudTrail data connector.
type AwsCloudTrailDataConnector struct {
	// AwsCloudTrailDataConnectorProperties - Amazon Web Services CloudTrail data connector properties.
	*AwsCloudTrailDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) MarshalJSON() ([]byte, error) {
	actdc.Kind = KindBasicDataConnectorKindAmazonWebServicesCloudTrail
	objectMap := make(map[string]interface{})
	if actdc.AwsCloudTrailDataConnectorProperties != nil {
		objectMap["properties"] = actdc.AwsCloudTrailDataConnectorProperties
	}
	if actdc.Etag != nil {
		objectMap["etag"] = actdc.Etag
	}
	if actdc.Kind != "" {
		objectMap["kind"] = actdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return &actdc, true
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AwsCloudTrailDataConnector.
func (actdc AwsCloudTrailDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &actdc, true
}

// UnmarshalJSON is the custom unmarshaler for AwsCloudTrailDataConnector struct.
func (actdc *AwsCloudTrailDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var awsCloudTrailDataConnectorProperties AwsCloudTrailDataConnectorProperties
				err = json.Unmarshal(*v, &awsCloudTrailDataConnectorProperties)
				if err != nil {
					return err
				}
				actdc.AwsCloudTrailDataConnectorProperties = &awsCloudTrailDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				actdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				actdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				actdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				actdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				actdc.Kind = kind
			}
		}
	}

	return nil
}

// AwsCloudTrailDataConnectorDataTypes the available data types for Amazon Web Services CloudTrail data
// connector.
type AwsCloudTrailDataConnectorDataTypes struct {
	// Logs - Logs data type.
	Logs *AwsCloudTrailDataConnectorDataTypesLogs `json:"logs,omitempty"`
}

// AwsCloudTrailDataConnectorDataTypesLogs logs data type.
type AwsCloudTrailDataConnectorDataTypesLogs struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// AwsCloudTrailDataConnectorProperties amazon Web Services CloudTrail data connector properties.
type AwsCloudTrailDataConnectorProperties struct {
	// AwsRoleArn - The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
	AwsRoleArn *string `json:"awsRoleArn,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AwsCloudTrailDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// AzureResourceEntity represents an azure resource entity.
type AzureResourceEntity struct {
	// AzureResourceEntityProperties - AzureResource entity properties
	*AzureResourceEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceEntity.
func (are AzureResourceEntity) MarshalJSON() ([]byte, error) {
	are.Kind = KindBasicEntityKindAzureResource
	objectMap := make(map[string]interface{})
	if are.AzureResourceEntityProperties != nil {
		objectMap["properties"] = are.AzureResourceEntityProperties
	}
	if are.Kind != "" {
		objectMap["kind"] = are.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return &are, true
}

// AsCloudApplicationEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for AzureResourceEntity.
func (are AzureResourceEntity) AsBasicEntity() (BasicEntity, bool) {
	return &are, true
}

// UnmarshalJSON is the custom unmarshaler for AzureResourceEntity struct.
func (are *AzureResourceEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureResourceEntityProperties AzureResourceEntityProperties
				err = json.Unmarshal(*v, &azureResourceEntityProperties)
				if err != nil {
					return err
				}
				are.AzureResourceEntityProperties = &azureResourceEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				are.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				are.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				are.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				are.Kind = kind
			}
		}
	}

	return nil
}

// AzureResourceEntityProperties azureResource entity property bag.
type AzureResourceEntityProperties struct {
	// ResourceID - READ-ONLY; The azure resource id of the resource
	ResourceID *string `json:"resourceId,omitempty"`
	// SubscriptionID - READ-ONLY; The subscription id of the resource
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceEntityProperties.
func (arep AzureResourceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Bookmark represents a bookmark in Azure Security Insights.
type Bookmark struct {
	autorest.Response `json:"-"`
	// BookmarkProperties - Bookmark properties
	*BookmarkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Bookmark.
func (b Bookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.BookmarkProperties != nil {
		objectMap["properties"] = b.BookmarkProperties
	}
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Bookmark struct.
func (b *Bookmark) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var bookmarkProperties BookmarkProperties
				err = json.Unmarshal(*v, &bookmarkProperties)
				if err != nil {
					return err
				}
				b.BookmarkProperties = &bookmarkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				b.Etag = &etag
			}
		}
	}

	return nil
}

// BookmarkExpandParameters the parameters required to execute an expand operation on the given bookmark.
type BookmarkExpandParameters struct {
	// EndTime - The end date filter, so the only expansion results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExpansionID - The Id of the expansion to perform.
	ExpansionID *uuid.UUID `json:"expansionId,omitempty"`
	// StartTime - The start date filter, so the only expansion results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// BookmarkExpandResponse the entity expansion result operation response.
type BookmarkExpandResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the expansion operation results.
	MetaData *ExpansionResultsMetadata `json:"metaData,omitempty"`
	// Value - The expansion result values.
	Value *BookmarkExpandResponseValue `json:"value,omitempty"`
}

// BookmarkExpandResponseValue the expansion result values.
type BookmarkExpandResponseValue struct {
	// Entities - Array of the expansion result entities.
	Entities *[]BasicEntity `json:"entities,omitempty"`
	// Edges - Array of expansion result connected entities
	Edges *[]ConnectedEntity `json:"edges,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for BookmarkExpandResponseValue struct.
func (ber *BookmarkExpandResponseValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "entities":
			if v != nil {
				entities, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				ber.Entities = &entities
			}
		case "edges":
			if v != nil {
				var edges []ConnectedEntity
				err = json.Unmarshal(*v, &edges)
				if err != nil {
					return err
				}
				ber.Edges = &edges
			}
		}
	}

	return nil
}

// BookmarkList list all the bookmarks.
type BookmarkList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of bookmarks.
	Value *[]Bookmark `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BookmarkList.
func (bl BookmarkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bl.Value != nil {
		objectMap["value"] = bl.Value
	}
	return json.Marshal(objectMap)
}

// BookmarkListIterator provides access to a complete listing of Bookmark values.
type BookmarkListIterator struct {
	i    int
	page BookmarkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BookmarkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BookmarkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BookmarkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BookmarkListIterator) Response() BookmarkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BookmarkListIterator) Value() Bookmark {
	if !iter.page.NotDone() {
		return Bookmark{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BookmarkListIterator type.
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return BookmarkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BookmarkList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bl BookmarkList) hasNextLink() bool {
	return bl.NextLink != nil && len(*bl.NextLink) != 0
}

// bookmarkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BookmarkList) bookmarkListPreparer(ctx context.Context) (*http.Request, error) {
	if !bl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BookmarkListPage contains a page of Bookmark values.
type BookmarkListPage struct {
	fn func(context.Context, BookmarkList) (BookmarkList, error)
	bl BookmarkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BookmarkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bl)
		if err != nil {
			return err
		}
		page.bl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BookmarkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BookmarkListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BookmarkListPage) Response() BookmarkList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BookmarkListPage) Values() []Bookmark {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BookmarkListPage type.
func NewBookmarkListPage(cur BookmarkList, getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return BookmarkListPage{
		fn: getNextPage,
		bl: cur,
	}
}

// BookmarkProperties describes bookmark properties
type BookmarkProperties struct {
	// Created - The time the bookmark was created
	Created *date.Time `json:"created,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// DisplayName - The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// Query - The query of the bookmark.
	Query *string `json:"query,omitempty"`
	// QueryResult - The query result of the bookmark.
	QueryResult *string `json:"queryResult,omitempty"`
	// Updated - The last time the bookmark was updated
	Updated *date.Time `json:"updated,omitempty"`
	// UpdatedBy - Describes a user that updated the bookmark
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// EventTime - The bookmark event time
	EventTime *date.Time `json:"eventTime,omitempty"`
	// QueryStartTime - The start time for the query
	QueryStartTime *date.Time `json:"queryStartTime,omitempty"`
	// QueryEndTime - The end time for the query
	QueryEndTime *date.Time `json:"queryEndTime,omitempty"`
	// IncidentInfo - Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo `json:"incidentInfo,omitempty"`
}

// BookmarkTimelineItem represents bookmark timeline item.
type BookmarkTimelineItem struct {
	// AzureResourceID - The bookmark azure resource id.
	AzureResourceID *string `json:"azureResourceId,omitempty"`
	// DisplayName - The bookmark display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// EndTimeUtc - The bookmark end time.
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// StartTimeUtc - TThe bookmark start time.
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// EventTime - The bookmark event time.
	EventTime *date.Time `json:"eventTime,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityTimelineItemKindEntityTimelineItem', 'KindBasicEntityTimelineItemKindActivity', 'KindBasicEntityTimelineItemKindSecurityAlert', 'KindBasicEntityTimelineItemKindBookmark'
	Kind KindBasicEntityTimelineItem `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) MarshalJSON() ([]byte, error) {
	bti.Kind = KindBasicEntityTimelineItemKindBookmark
	objectMap := make(map[string]interface{})
	if bti.AzureResourceID != nil {
		objectMap["azureResourceId"] = bti.AzureResourceID
	}
	if bti.DisplayName != nil {
		objectMap["displayName"] = bti.DisplayName
	}
	if bti.Notes != nil {
		objectMap["notes"] = bti.Notes
	}
	if bti.EndTimeUtc != nil {
		objectMap["endTimeUtc"] = bti.EndTimeUtc
	}
	if bti.StartTimeUtc != nil {
		objectMap["startTimeUtc"] = bti.StartTimeUtc
	}
	if bti.EventTime != nil {
		objectMap["eventTime"] = bti.EventTime
	}
	if bti.CreatedBy != nil {
		objectMap["createdBy"] = bti.CreatedBy
	}
	if bti.Labels != nil {
		objectMap["labels"] = bti.Labels
	}
	if bti.Kind != "" {
		objectMap["kind"] = bti.Kind
	}
	return json.Marshal(objectMap)
}

// AsActivityTimelineItem is the BasicEntityTimelineItem implementation for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) AsActivityTimelineItem() (*ActivityTimelineItem, bool) {
	return nil, false
}

// AsSecurityAlertTimelineItem is the BasicEntityTimelineItem implementation for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) AsSecurityAlertTimelineItem() (*SecurityAlertTimelineItem, bool) {
	return nil, false
}

// AsBookmarkTimelineItem is the BasicEntityTimelineItem implementation for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) AsBookmarkTimelineItem() (*BookmarkTimelineItem, bool) {
	return &bti, true
}

// AsEntityTimelineItem is the BasicEntityTimelineItem implementation for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) AsEntityTimelineItem() (*EntityTimelineItem, bool) {
	return nil, false
}

// AsBasicEntityTimelineItem is the BasicEntityTimelineItem implementation for BookmarkTimelineItem.
func (bti BookmarkTimelineItem) AsBasicEntityTimelineItem() (BasicEntityTimelineItem, bool) {
	return &bti, true
}

// Case represents a case in Azure Security Insights.
type Case struct {
	autorest.Response `json:"-"`
	// CaseProperties - Case properties
	*CaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Case.
func (c Case) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CaseProperties != nil {
		objectMap["properties"] = c.CaseProperties
	}
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Case struct.
func (c *Case) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseProperties CaseProperties
				err = json.Unmarshal(*v, &caseProperties)
				if err != nil {
					return err
				}
				c.CaseProperties = &caseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		}
	}

	return nil
}

// CaseComment represents a case comment
type CaseComment struct {
	autorest.Response `json:"-"`
	// CaseCommentProperties - Case comment properties
	*CaseCommentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseComment.
func (cc CaseComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.CaseCommentProperties != nil {
		objectMap["properties"] = cc.CaseCommentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CaseComment struct.
func (cc *CaseComment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseCommentProperties CaseCommentProperties
				err = json.Unmarshal(*v, &caseCommentProperties)
				if err != nil {
					return err
				}
				cc.CaseCommentProperties = &caseCommentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cc.Type = &typeVar
			}
		}
	}

	return nil
}

// CaseCommentList list of case comments.
type CaseCommentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of comments.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of comments.
	Value *[]CaseComment `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseCommentList.
func (ccl CaseCommentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccl.Value != nil {
		objectMap["value"] = ccl.Value
	}
	return json.Marshal(objectMap)
}

// CaseCommentListIterator provides access to a complete listing of CaseComment values.
type CaseCommentListIterator struct {
	i    int
	page CaseCommentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseCommentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseCommentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseCommentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseCommentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseCommentListIterator) Response() CaseCommentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseCommentListIterator) Value() CaseComment {
	if !iter.page.NotDone() {
		return CaseComment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseCommentListIterator type.
func NewCaseCommentListIterator(page CaseCommentListPage) CaseCommentListIterator {
	return CaseCommentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ccl CaseCommentList) IsEmpty() bool {
	return ccl.Value == nil || len(*ccl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ccl CaseCommentList) hasNextLink() bool {
	return ccl.NextLink != nil && len(*ccl.NextLink) != 0
}

// caseCommentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ccl CaseCommentList) caseCommentListPreparer(ctx context.Context) (*http.Request, error) {
	if !ccl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ccl.NextLink)))
}

// CaseCommentListPage contains a page of CaseComment values.
type CaseCommentListPage struct {
	fn  func(context.Context, CaseCommentList) (CaseCommentList, error)
	ccl CaseCommentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseCommentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseCommentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ccl)
		if err != nil {
			return err
		}
		page.ccl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseCommentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseCommentListPage) NotDone() bool {
	return !page.ccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseCommentListPage) Response() CaseCommentList {
	return page.ccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseCommentListPage) Values() []CaseComment {
	if page.ccl.IsEmpty() {
		return nil
	}
	return *page.ccl.Value
}

// Creates a new instance of the CaseCommentListPage type.
func NewCaseCommentListPage(cur CaseCommentList, getNextPage func(context.Context, CaseCommentList) (CaseCommentList, error)) CaseCommentListPage {
	return CaseCommentListPage{
		fn:  getNextPage,
		ccl: cur,
	}
}

// CaseCommentProperties case comment property bag.
type CaseCommentProperties struct {
	// CreatedTimeUtc - READ-ONLY; The time the comment was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Message - The comment message
	Message *string `json:"message,omitempty"`
	// UserInfo - READ-ONLY; Describes the user that created the comment
	UserInfo *UserInfo `json:"userInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseCommentProperties.
func (ccp CaseCommentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccp.Message != nil {
		objectMap["message"] = ccp.Message
	}
	return json.Marshal(objectMap)
}

// CaseList list all the cases.
type CaseList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of cases.
	Value *[]Case `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseList.
func (cl CaseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// CaseListIterator provides access to a complete listing of Case values.
type CaseListIterator struct {
	i    int
	page CaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseListIterator) Response() CaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseListIterator) Value() Case {
	if !iter.page.NotDone() {
		return Case{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseListIterator type.
func NewCaseListIterator(page CaseListPage) CaseListIterator {
	return CaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl CaseList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl CaseList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// caseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl CaseList) caseListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// CaseListPage contains a page of Case values.
type CaseListPage struct {
	fn func(context.Context, CaseList) (CaseList, error)
	cl CaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseListPage) Response() CaseList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseListPage) Values() []Case {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the CaseListPage type.
func NewCaseListPage(cur CaseList, getNextPage func(context.Context, CaseList) (CaseList, error)) CaseListPage {
	return CaseListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// CaseProperties describes case properties
type CaseProperties struct {
	// CaseNumber - READ-ONLY; a sequential number
	CaseNumber *int32 `json:"caseNumber,omitempty"`
	// CloseReason - The reason the case was closed. Possible values include: 'CloseReasonResolved', 'CloseReasonDismissed', 'CloseReasonTruePositive', 'CloseReasonFalsePositive', 'CloseReasonOther'
	CloseReason CloseReason `json:"closeReason,omitempty"`
	// ClosedReasonText - the case close reason details
	ClosedReasonText *string `json:"closedReasonText,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the case was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Description - The description of the case
	Description *string `json:"description,omitempty"`
	// EndTimeUtc - The end time of the case
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Labels - List of labels relevant to this case
	Labels *[]string `json:"labels,omitempty"`
	// LastComment - READ-ONLY; the last comment in the case
	LastComment *string `json:"lastComment,omitempty"`
	// LastUpdatedTimeUtc - READ-ONLY; The last time the case was updated
	LastUpdatedTimeUtc *date.Time `json:"lastUpdatedTimeUtc,omitempty"`
	// Metrics - READ-ONLY; Dictionary of metrics, for example the number of alerts in the case
	Metrics map[string]*int32 `json:"metrics"`
	// Owner - Describes a user that the case is assigned to
	Owner *UserInfo `json:"owner,omitempty"`
	// RelatedAlertIds - READ-ONLY; List of related alert identifiers
	RelatedAlertIds *[]string `json:"relatedAlertIds,omitempty"`
	// RelatedAlertProductNames - READ-ONLY; List of related alert product names
	RelatedAlertProductNames *[]string `json:"relatedAlertProductNames,omitempty"`
	// Tactics - READ-ONLY; The tactics associated with case
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// Severity - The severity of the case. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// StartTimeUtc - The start time of the case
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Status - The status of the case. Possible values include: 'CaseStatusDraft', 'CaseStatusNew', 'CaseStatusInProgress', 'CaseStatusClosed'
	Status CaseStatus `json:"status,omitempty"`
	// Title - The title of the case
	Title *string `json:"title,omitempty"`
	// TotalComments - READ-ONLY; the number of total comments in the case
	TotalComments *int32 `json:"totalComments,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseProperties.
func (cp CaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.CloseReason != "" {
		objectMap["closeReason"] = cp.CloseReason
	}
	if cp.ClosedReasonText != nil {
		objectMap["closedReasonText"] = cp.ClosedReasonText
	}
	if cp.Description != nil {
		objectMap["description"] = cp.Description
	}
	if cp.EndTimeUtc != nil {
		objectMap["endTimeUtc"] = cp.EndTimeUtc
	}
	if cp.Labels != nil {
		objectMap["labels"] = cp.Labels
	}
	if cp.Owner != nil {
		objectMap["owner"] = cp.Owner
	}
	if cp.Severity != "" {
		objectMap["severity"] = cp.Severity
	}
	if cp.StartTimeUtc != nil {
		objectMap["startTimeUtc"] = cp.StartTimeUtc
	}
	if cp.Status != "" {
		objectMap["status"] = cp.Status
	}
	if cp.Title != nil {
		objectMap["title"] = cp.Title
	}
	return json.Marshal(objectMap)
}

// CaseRelation represents a case relation
type CaseRelation struct {
	autorest.Response `json:"-"`
	// CaseRelationProperties - Case relation properties
	*CaseRelationProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'RelationTypesCasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseRelation.
func (cr CaseRelation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.CaseRelationProperties != nil {
		objectMap["properties"] = cr.CaseRelationProperties
	}
	if cr.Etag != nil {
		objectMap["etag"] = cr.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CaseRelation struct.
func (cr *CaseRelation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var caseRelationProperties CaseRelationProperties
				err = json.Unmarshal(*v, &caseRelationProperties)
				if err != nil {
					return err
				}
				cr.CaseRelationProperties = &caseRelationProperties
			}
		case "kind":
			if v != nil {
				var kind RelationTypes
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cr.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				cr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		}
	}

	return nil
}

// CaseRelationList list of case relations.
type CaseRelationList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of relations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of relations.
	Value *[]CaseRelation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CaseRelationList.
func (crl CaseRelationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crl.Value != nil {
		objectMap["value"] = crl.Value
	}
	return json.Marshal(objectMap)
}

// CaseRelationListIterator provides access to a complete listing of CaseRelation values.
type CaseRelationListIterator struct {
	i    int
	page CaseRelationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseRelationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseRelationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseRelationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseRelationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseRelationListIterator) Response() CaseRelationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseRelationListIterator) Value() CaseRelation {
	if !iter.page.NotDone() {
		return CaseRelation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseRelationListIterator type.
func NewCaseRelationListIterator(page CaseRelationListPage) CaseRelationListIterator {
	return CaseRelationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crl CaseRelationList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crl CaseRelationList) hasNextLink() bool {
	return crl.NextLink != nil && len(*crl.NextLink) != 0
}

// caseRelationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl CaseRelationList) caseRelationListPreparer(ctx context.Context) (*http.Request, error) {
	if !crl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// CaseRelationListPage contains a page of CaseRelation values.
type CaseRelationListPage struct {
	fn  func(context.Context, CaseRelationList) (CaseRelationList, error)
	crl CaseRelationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseRelationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseRelationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crl)
		if err != nil {
			return err
		}
		page.crl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseRelationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseRelationListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseRelationListPage) Response() CaseRelationList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseRelationListPage) Values() []CaseRelation {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// Creates a new instance of the CaseRelationListPage type.
func NewCaseRelationListPage(cur CaseRelationList, getNextPage func(context.Context, CaseRelationList) (CaseRelationList, error)) CaseRelationListPage {
	return CaseRelationListPage{
		fn:  getNextPage,
		crl: cur,
	}
}

// CaseRelationProperties case relation properties
type CaseRelationProperties struct {
	// RelationName - Name of relation
	RelationName *string `json:"relationName,omitempty"`
	// BookmarkID - The case related bookmark id
	BookmarkID *string `json:"bookmarkId,omitempty"`
	// CaseIdentifier - The case identifier
	CaseIdentifier *string `json:"caseIdentifier,omitempty"`
	// BookmarkName - The case related bookmark name
	BookmarkName *string `json:"bookmarkName,omitempty"`
}

// CasesAggregation represents aggregations results for cases.
type CasesAggregation struct {
	// CasesAggregationProperties - Properties of aggregations results of cases.
	*CasesAggregationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CasesAggregation.
func (ca CasesAggregation) MarshalJSON() ([]byte, error) {
	ca.Kind = KindCasesAggregation
	objectMap := make(map[string]interface{})
	if ca.CasesAggregationProperties != nil {
		objectMap["properties"] = ca.CasesAggregationProperties
	}
	if ca.Kind != "" {
		objectMap["kind"] = ca.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsCasesAggregation() (*CasesAggregation, bool) {
	return &ca, true
}

// AsAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsAggregations() (*Aggregations, bool) {
	return nil, false
}

// AsBasicAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsBasicAggregations() (BasicAggregations, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CasesAggregation struct.
func (ca *CasesAggregation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var casesAggregationProperties CasesAggregationProperties
				err = json.Unmarshal(*v, &casesAggregationProperties)
				if err != nil {
					return err
				}
				ca.CasesAggregationProperties = &casesAggregationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ca.Kind = kind
			}
		}
	}

	return nil
}

// CasesAggregationBySeverityProperties aggregative results of cases by severity property bag.
type CasesAggregationBySeverityProperties struct {
	// TotalCriticalSeverity - READ-ONLY; Total amount of open cases with severity Critical
	TotalCriticalSeverity *int32 `json:"totalCriticalSeverity,omitempty"`
	// TotalHighSeverity - READ-ONLY; Total amount of open cases with severity High
	TotalHighSeverity *int32 `json:"totalHighSeverity,omitempty"`
	// TotalInformationalSeverity - READ-ONLY; Total amount of open cases with severity Informational
	TotalInformationalSeverity *int32 `json:"totalInformationalSeverity,omitempty"`
	// TotalLowSeverity - READ-ONLY; Total amount of open cases with severity Low
	TotalLowSeverity *int32 `json:"totalLowSeverity,omitempty"`
	// TotalMediumSeverity - READ-ONLY; Total amount of open cases with severity medium
	TotalMediumSeverity *int32 `json:"totalMediumSeverity,omitempty"`
}

// MarshalJSON is the custom marshaler for CasesAggregationBySeverityProperties.
func (cabsp CasesAggregationBySeverityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CasesAggregationByStatusProperties aggregative results of cases by status property bag.
type CasesAggregationByStatusProperties struct {
	// TotalDismissedStatus - READ-ONLY; Total amount of closed cases with status Dismissed
	TotalDismissedStatus *int32 `json:"totalDismissedStatus,omitempty"`
	// TotalInProgressStatus - READ-ONLY; Total amount of open cases with status InProgress
	TotalInProgressStatus *int32 `json:"totalInProgressStatus,omitempty"`
	// TotalNewStatus - READ-ONLY; Total amount of open cases with status New
	TotalNewStatus *int32 `json:"totalNewStatus,omitempty"`
	// TotalResolvedStatus - READ-ONLY; Total amount of closed cases with status Resolved
	TotalResolvedStatus *int32 `json:"totalResolvedStatus,omitempty"`
	// TotalFalsePositiveStatus - READ-ONLY; Total amount of closed cases with status Closed and Close reason of False positive
	TotalFalsePositiveStatus *int32 `json:"totalFalsePositiveStatus,omitempty"`
	// TotalTruePositiveStatus - READ-ONLY; Total amount of closed cases with status Closed and Close reason of True positive
	TotalTruePositiveStatus *int32 `json:"totalTruePositiveStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for CasesAggregationByStatusProperties.
func (cabsp CasesAggregationByStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CasesAggregationProperties aggregative results of cases property bag.
type CasesAggregationProperties struct {
	// AggregationBySeverity - Aggregations results by case severity.
	AggregationBySeverity *CasesAggregationBySeverityProperties `json:"aggregationBySeverity,omitempty"`
	// AggregationByStatus - Aggregations results by case status.
	AggregationByStatus *CasesAggregationByStatusProperties `json:"aggregationByStatus,omitempty"`
}

// ClientInfo information on the client (user or application) that made some action
type ClientInfo struct {
	// Email - The email of the client.
	Email *string `json:"email,omitempty"`
	// Name - The name of the client.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the client.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the client.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// CloudApplicationEntity represents a cloud application entity.
type CloudApplicationEntity struct {
	// CloudApplicationEntityProperties - CloudApplication entity properties
	*CloudApplicationEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudApplicationEntity.
func (cae CloudApplicationEntity) MarshalJSON() ([]byte, error) {
	cae.Kind = KindBasicEntityKindCloudApplication
	objectMap := make(map[string]interface{})
	if cae.CloudApplicationEntityProperties != nil {
		objectMap["properties"] = cae.CloudApplicationEntityProperties
	}
	if cae.Kind != "" {
		objectMap["kind"] = cae.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return &cae, true
}

// AsDNSEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for CloudApplicationEntity.
func (cae CloudApplicationEntity) AsBasicEntity() (BasicEntity, bool) {
	return &cae, true
}

// UnmarshalJSON is the custom unmarshaler for CloudApplicationEntity struct.
func (cae *CloudApplicationEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudApplicationEntityProperties CloudApplicationEntityProperties
				err = json.Unmarshal(*v, &cloudApplicationEntityProperties)
				if err != nil {
					return err
				}
				cae.CloudApplicationEntityProperties = &cloudApplicationEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cae.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cae.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cae.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cae.Kind = kind
			}
		}
	}

	return nil
}

// CloudApplicationEntityProperties cloudApplication entity property bag.
type CloudApplicationEntityProperties struct {
	// AppID - READ-ONLY; The technical identifier of the application.
	AppID *int32 `json:"appId,omitempty"`
	// AppName - READ-ONLY; The name of the related cloud application.
	AppName *string `json:"appName,omitempty"`
	// InstanceName - READ-ONLY; The user defined instance name of the cloud application. It is often used to distinguish between several applications of the same type that a customer has.
	InstanceName *string `json:"instanceName,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudApplicationEntityProperties.
func (caep CloudApplicationEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudErrorBody.
func (ceb CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectedEntity expansion result connected entities
type ConnectedEntity struct {
	// TargetEntityID - Entity Id of the connected entity
	TargetEntityID *string `json:"targetEntityId,omitempty"`
	// AdditionalData - key-value pairs for a connected entity mapping
	AdditionalData interface{} `json:"additionalData,omitempty"`
}

// BasicDataConnector data connector.
type BasicDataConnector interface {
	AsAADDataConnector() (*AADDataConnector, bool)
	AsAATPDataConnector() (*AATPDataConnector, bool)
	AsMSTIDataConnector() (*MSTIDataConnector, bool)
	AsMTPDataConnector() (*MTPDataConnector, bool)
	AsASCDataConnector() (*ASCDataConnector, bool)
	AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool)
	AsDynamics365DataConnector() (*Dynamics365DataConnector, bool)
	AsMCASDataConnector() (*MCASDataConnector, bool)
	AsMDATPDataConnector() (*MDATPDataConnector, bool)
	AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool)
	AsOfficeDataConnector() (*OfficeDataConnector, bool)
	AsTIDataConnector() (*TIDataConnector, bool)
	AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool)
	AsDataConnector() (*DataConnector, bool)
}

// DataConnector data connector.
type DataConnector struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

func unmarshalBasicDataConnector(body []byte) (BasicDataConnector, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicDataConnectorKindAzureActiveDirectory):
		var adc AADDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindAzureAdvancedThreatProtection):
		var adc AATPDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindMicrosoftThreatIntelligence):
		var mdc MSTIDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindMicrosoftThreatProtection):
		var mdc MTPDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindAzureSecurityCenter):
		var adc ASCDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindBasicDataConnectorKindAmazonWebServicesCloudTrail):
		var actdc AwsCloudTrailDataConnector
		err := json.Unmarshal(body, &actdc)
		return actdc, err
	case string(KindBasicDataConnectorKindDynamics365):
		var d3dc Dynamics365DataConnector
		err := json.Unmarshal(body, &d3dc)
		return d3dc, err
	case string(KindBasicDataConnectorKindMicrosoftCloudAppSecurity):
		var mdc MCASDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection):
		var mdc MDATPDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	case string(KindBasicDataConnectorKindOfficeATP):
		var oadc OfficeATPDataConnector
		err := json.Unmarshal(body, &oadc)
		return oadc, err
	case string(KindBasicDataConnectorKindOffice365):
		var odc OfficeDataConnector
		err := json.Unmarshal(body, &odc)
		return odc, err
	case string(KindBasicDataConnectorKindThreatIntelligence):
		var tdc TIDataConnector
		err := json.Unmarshal(body, &tdc)
		return tdc, err
	case string(KindBasicDataConnectorKindThreatIntelligenceTaxii):
		var ttdc TiTaxiiDataConnector
		err := json.Unmarshal(body, &ttdc)
		return ttdc, err
	default:
		var dc DataConnector
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectorArray(body []byte) ([]BasicDataConnector, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnector, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnector(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnector.
func (dc DataConnector) MarshalJSON() ([]byte, error) {
	dc.Kind = KindBasicDataConnectorKindDataConnector
	objectMap := make(map[string]interface{})
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsDataConnector() (*DataConnector, bool) {
	return &dc, true
}

// AsBasicDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &dc, true
}

// DataConnectorDataTypeCommon common field for data type in data connectors.
type DataConnectorDataTypeCommon struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// DataConnectorKind1 describes an Azure resource with kind.
type DataConnectorKind1 struct {
	// Kind - The kind of the data connector. Possible values include: 'DataConnectorKindAzureActiveDirectory', 'DataConnectorKindAzureSecurityCenter', 'DataConnectorKindMicrosoftCloudAppSecurity', 'DataConnectorKindThreatIntelligence', 'DataConnectorKindThreatIntelligenceTaxii', 'DataConnectorKindOffice365', 'DataConnectorKindOfficeATP', 'DataConnectorKindAmazonWebServicesCloudTrail', 'DataConnectorKindAzureAdvancedThreatProtection', 'DataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'DataConnectorKindDynamics365', 'DataConnectorKindMicrosoftThreatProtection', 'DataConnectorKindMicrosoftThreatIntelligence'
	Kind DataConnectorKind `json:"kind,omitempty"`
}

// DataConnectorList list all the data connectors.
type DataConnectorList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of data connectors.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of data connectors.
	Value *[]BasicDataConnector `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for DataConnectorList.
func (dcl DataConnectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcl.Value != nil {
		objectMap["value"] = dcl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorList struct.
func (dcl *DataConnectorList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				dcl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectorArray(*v)
				if err != nil {
					return err
				}
				dcl.Value = &value
			}
		}
	}

	return nil
}

// DataConnectorListIterator provides access to a complete listing of DataConnector values.
type DataConnectorListIterator struct {
	i    int
	page DataConnectorListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataConnectorListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataConnectorListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataConnectorListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataConnectorListIterator) Response() DataConnectorList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataConnectorListIterator) Value() BasicDataConnector {
	if !iter.page.NotDone() {
		return DataConnector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataConnectorListIterator type.
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return DataConnectorListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcl DataConnectorList) IsEmpty() bool {
	return dcl.Value == nil || len(*dcl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcl DataConnectorList) hasNextLink() bool {
	return dcl.NextLink != nil && len(*dcl.NextLink) != 0
}

// dataConnectorListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcl DataConnectorList) dataConnectorListPreparer(ctx context.Context) (*http.Request, error) {
	if !dcl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcl.NextLink)))
}

// DataConnectorListPage contains a page of BasicDataConnector values.
type DataConnectorListPage struct {
	fn  func(context.Context, DataConnectorList) (DataConnectorList, error)
	dcl DataConnectorList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataConnectorListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcl)
		if err != nil {
			return err
		}
		page.dcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataConnectorListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataConnectorListPage) NotDone() bool {
	return !page.dcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataConnectorListPage) Response() DataConnectorList {
	return page.dcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataConnectorListPage) Values() []BasicDataConnector {
	if page.dcl.IsEmpty() {
		return nil
	}
	return *page.dcl.Value
}

// Creates a new instance of the DataConnectorListPage type.
func NewDataConnectorListPage(cur DataConnectorList, getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return DataConnectorListPage{
		fn:  getNextPage,
		dcl: cur,
	}
}

// DataConnectorModel ...
type DataConnectorModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorModel struct.
func (dcm *DataConnectorModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnector(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectorRequirementsState data connector requirements status.
type DataConnectorRequirementsState struct {
	autorest.Response `json:"-"`
	// AuthorizationState - Authorization state for this connector. Possible values include: 'DataConnectorAuthorizationStateValid', 'DataConnectorAuthorizationStateInvalid'
	AuthorizationState DataConnectorAuthorizationState `json:"authorizationState,omitempty"`
	// LicenseState - License state for this connector. Possible values include: 'DataConnectorLicenseStateValid', 'DataConnectorLicenseStateInvalid', 'DataConnectorLicenseStateUnknown'
	LicenseState DataConnectorLicenseState `json:"licenseState,omitempty"`
}

// BasicDataConnectorsCheckRequirements data connector requirements properties.
type BasicDataConnectorsCheckRequirements interface {
	AsAADCheckRequirements() (*AADCheckRequirements, bool)
	AsAATPCheckRequirements() (*AATPCheckRequirements, bool)
	AsMSTICheckRequirements() (*MSTICheckRequirements, bool)
	AsMtpCheckRequirements() (*MtpCheckRequirements, bool)
	AsASCCheckRequirements() (*ASCCheckRequirements, bool)
	AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool)
	AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool)
	AsMCASCheckRequirements() (*MCASCheckRequirements, bool)
	AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool)
	AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool)
	AsTICheckRequirements() (*TICheckRequirements, bool)
	AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool)
	AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool)
}

// DataConnectorsCheckRequirements data connector requirements properties.
type DataConnectorsCheckRequirements struct {
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

func unmarshalBasicDataConnectorsCheckRequirements(body []byte) (BasicDataConnectorsCheckRequirements, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory):
		var acr AADCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection):
		var acr AATPCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence):
		var mcr MSTICheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection):
		var mcr MtpCheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter):
		var acr ASCCheckRequirements
		err := json.Unmarshal(body, &acr)
		return acr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail):
		var actcr AwsCloudTrailCheckRequirements
		err := json.Unmarshal(body, &actcr)
		return actcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindDynamics365):
		var d3cr Dynamics365CheckRequirements
		err := json.Unmarshal(body, &d3cr)
		return d3cr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity):
		var mcr MCASCheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection):
		var mcr MDATPCheckRequirements
		err := json.Unmarshal(body, &mcr)
		return mcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindOfficeATP):
		var oacr OfficeATPCheckRequirements
		err := json.Unmarshal(body, &oacr)
		return oacr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence):
		var tcr TICheckRequirements
		err := json.Unmarshal(body, &tcr)
		return tcr, err
	case string(KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii):
		var ttcr TiTaxiiCheckRequirements
		err := json.Unmarshal(body, &ttcr)
		return ttcr, err
	default:
		var dccr DataConnectorsCheckRequirements
		err := json.Unmarshal(body, &dccr)
		return dccr, err
	}
}
func unmarshalBasicDataConnectorsCheckRequirementsArray(body []byte) ([]BasicDataConnectorsCheckRequirements, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dccrArray := make([]BasicDataConnectorsCheckRequirements, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dccr, err := unmarshalBasicDataConnectorsCheckRequirements(*rawMessage)
		if err != nil {
			return nil, err
		}
		dccrArray[index] = dccr
	}
	return dccrArray, nil
}

// MarshalJSON is the custom marshaler for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) MarshalJSON() ([]byte, error) {
	dccr.Kind = KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements
	objectMap := make(map[string]interface{})
	if dccr.Kind != "" {
		objectMap["kind"] = dccr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return &dccr, true
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for DataConnectorsCheckRequirements.
func (dccr DataConnectorsCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &dccr, true
}

// DataConnectorTenantID properties data connector on tenant level.
type DataConnectorTenantID struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// DataConnectorWithAlertsProperties data connector properties.
type DataConnectorWithAlertsProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// DNSEntity represents a dns entity.
type DNSEntity struct {
	// DNSEntityProperties - Dns entity properties
	*DNSEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for DNSEntity.
func (de DNSEntity) MarshalJSON() ([]byte, error) {
	de.Kind = KindBasicEntityKindDNSResolution
	objectMap := make(map[string]interface{})
	if de.DNSEntityProperties != nil {
		objectMap["properties"] = de.DNSEntityProperties
	}
	if de.Kind != "" {
		objectMap["kind"] = de.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsDNSEntity() (*DNSEntity, bool) {
	return &de, true
}

// AsFileEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for DNSEntity.
func (de DNSEntity) AsBasicEntity() (BasicEntity, bool) {
	return &de, true
}

// UnmarshalJSON is the custom unmarshaler for DNSEntity struct.
func (de *DNSEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var DNSEntityProperties DNSEntityProperties
				err = json.Unmarshal(*v, &DNSEntityProperties)
				if err != nil {
					return err
				}
				de.DNSEntityProperties = &DNSEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				de.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				de.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				de.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				de.Kind = kind
			}
		}
	}

	return nil
}

// DNSEntityProperties dns entity property bag.
type DNSEntityProperties struct {
	// DNSServerIPEntityID - READ-ONLY; An ip entity id for the dns server resolving the request
	DNSServerIPEntityID *string `json:"dnsServerIpEntityId,omitempty"`
	// DomainName - READ-ONLY; The name of the dns record associated with the alert
	DomainName *string `json:"domainName,omitempty"`
	// HostIPAddressEntityID - READ-ONLY; An ip entity id for the dns request client
	HostIPAddressEntityID *string `json:"hostIpAddressEntityId,omitempty"`
	// IPAddressEntityIds - READ-ONLY; Ip entity identifiers for the resolved ip address.
	IPAddressEntityIds *[]string `json:"ipAddressEntityIds,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for DNSEntityProperties.
func (dep DNSEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Dynamics365CheckRequirements represents Dynamics365 requirements check request.
type Dynamics365CheckRequirements struct {
	// Dynamics365CheckRequirementsProperties - Dynamics365 requirements check properties.
	*Dynamics365CheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) MarshalJSON() ([]byte, error) {
	d3cr.Kind = KindBasicDataConnectorsCheckRequirementsKindDynamics365
	objectMap := make(map[string]interface{})
	if d3cr.Dynamics365CheckRequirementsProperties != nil {
		objectMap["properties"] = d3cr.Dynamics365CheckRequirementsProperties
	}
	if d3cr.Kind != "" {
		objectMap["kind"] = d3cr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return &d3cr, true
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for Dynamics365CheckRequirements.
func (d3cr Dynamics365CheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &d3cr, true
}

// UnmarshalJSON is the custom unmarshaler for Dynamics365CheckRequirements struct.
func (d3cr *Dynamics365CheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dynamics365CheckRequirementsProperties Dynamics365CheckRequirementsProperties
				err = json.Unmarshal(*v, &dynamics365CheckRequirementsProperties)
				if err != nil {
					return err
				}
				d3cr.Dynamics365CheckRequirementsProperties = &dynamics365CheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d3cr.Kind = kind
			}
		}
	}

	return nil
}

// Dynamics365CheckRequirementsProperties dynamics365 requirements check properties.
type Dynamics365CheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// Dynamics365DataConnector represents Dynamics365 data connector.
type Dynamics365DataConnector struct {
	// Dynamics365DataConnectorProperties - Dynamics365 data connector properties.
	*Dynamics365DataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) MarshalJSON() ([]byte, error) {
	d3dc.Kind = KindBasicDataConnectorKindDynamics365
	objectMap := make(map[string]interface{})
	if d3dc.Dynamics365DataConnectorProperties != nil {
		objectMap["properties"] = d3dc.Dynamics365DataConnectorProperties
	}
	if d3dc.Etag != nil {
		objectMap["etag"] = d3dc.Etag
	}
	if d3dc.Kind != "" {
		objectMap["kind"] = d3dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return &d3dc, true
}

// AsMCASDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for Dynamics365DataConnector.
func (d3dc Dynamics365DataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &d3dc, true
}

// UnmarshalJSON is the custom unmarshaler for Dynamics365DataConnector struct.
func (d3dc *Dynamics365DataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dynamics365DataConnectorProperties Dynamics365DataConnectorProperties
				err = json.Unmarshal(*v, &dynamics365DataConnectorProperties)
				if err != nil {
					return err
				}
				d3dc.Dynamics365DataConnectorProperties = &dynamics365DataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d3dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d3dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d3dc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				d3dc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d3dc.Kind = kind
			}
		}
	}

	return nil
}

// Dynamics365DataConnectorDataTypes the available data types for Dynamics365 data connector.
type Dynamics365DataConnectorDataTypes struct {
	// Dynamics365CdsActivities - Common Data Service data type connection.
	Dynamics365CdsActivities *Dynamics365DataConnectorDataTypesDynamics365CdsActivities `json:"dynamics365CdsActivities,omitempty"`
}

// Dynamics365DataConnectorDataTypesDynamics365CdsActivities common Data Service data type connection.
type Dynamics365DataConnectorDataTypesDynamics365CdsActivities struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// Dynamics365DataConnectorProperties dynamics365 data connector properties.
type Dynamics365DataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *Dynamics365DataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// BasicEntity specific entity.
type BasicEntity interface {
	AsAccountEntity() (*AccountEntity, bool)
	AsAzureResourceEntity() (*AzureResourceEntity, bool)
	AsCloudApplicationEntity() (*CloudApplicationEntity, bool)
	AsDNSEntity() (*DNSEntity, bool)
	AsFileEntity() (*FileEntity, bool)
	AsFileHashEntity() (*FileHashEntity, bool)
	AsHostEntity() (*HostEntity, bool)
	AsHuntingBookmark() (*HuntingBookmark, bool)
	AsSecurityAlert() (*SecurityAlert, bool)
	AsIPEntity() (*IPEntity, bool)
	AsMailboxEntity() (*MailboxEntity, bool)
	AsMailClusterEntity() (*MailClusterEntity, bool)
	AsMailMessageEntity() (*MailMessageEntity, bool)
	AsSubmissionMailEntity() (*SubmissionMailEntity, bool)
	AsMalwareEntity() (*MalwareEntity, bool)
	AsProcessEntity() (*ProcessEntity, bool)
	AsRegistryKeyEntity() (*RegistryKeyEntity, bool)
	AsRegistryValueEntity() (*RegistryValueEntity, bool)
	AsSecurityGroupEntity() (*SecurityGroupEntity, bool)
	AsURLEntity() (*URLEntity, bool)
	AsIoTDeviceEntity() (*IoTDeviceEntity, bool)
	AsEntity() (*Entity, bool)
}

// Entity specific entity.
type Entity struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

func unmarshalBasicEntity(body []byte) (BasicEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicEntityKindAccount):
		var ae AccountEntity
		err := json.Unmarshal(body, &ae)
		return ae, err
	case string(KindBasicEntityKindAzureResource):
		var are AzureResourceEntity
		err := json.Unmarshal(body, &are)
		return are, err
	case string(KindBasicEntityKindCloudApplication):
		var cae CloudApplicationEntity
		err := json.Unmarshal(body, &cae)
		return cae, err
	case string(KindBasicEntityKindDNSResolution):
		var de DNSEntity
		err := json.Unmarshal(body, &de)
		return de, err
	case string(KindBasicEntityKindFile):
		var fe FileEntity
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(KindBasicEntityKindFileHash):
		var fhe FileHashEntity
		err := json.Unmarshal(body, &fhe)
		return fhe, err
	case string(KindBasicEntityKindHost):
		var he HostEntity
		err := json.Unmarshal(body, &he)
		return he, err
	case string(KindBasicEntityKindBookmark):
		var hb HuntingBookmark
		err := json.Unmarshal(body, &hb)
		return hb, err
	case string(KindBasicEntityKindSecurityAlert):
		var sa SecurityAlert
		err := json.Unmarshal(body, &sa)
		return sa, err
	case string(KindBasicEntityKindIP):
		var ie IPEntity
		err := json.Unmarshal(body, &ie)
		return ie, err
	case string(KindBasicEntityKindMailbox):
		var me MailboxEntity
		err := json.Unmarshal(body, &me)
		return me, err
	case string(KindBasicEntityKindMailCluster):
		var mce MailClusterEntity
		err := json.Unmarshal(body, &mce)
		return mce, err
	case string(KindBasicEntityKindMailMessage):
		var mme MailMessageEntity
		err := json.Unmarshal(body, &mme)
		return mme, err
	case string(KindBasicEntityKindSubmissionMail):
		var sme SubmissionMailEntity
		err := json.Unmarshal(body, &sme)
		return sme, err
	case string(KindBasicEntityKindMalware):
		var me MalwareEntity
		err := json.Unmarshal(body, &me)
		return me, err
	case string(KindBasicEntityKindProcess):
		var peVar ProcessEntity
		err := json.Unmarshal(body, &peVar)
		return peVar, err
	case string(KindBasicEntityKindRegistryKey):
		var rke RegistryKeyEntity
		err := json.Unmarshal(body, &rke)
		return rke, err
	case string(KindBasicEntityKindRegistryValue):
		var rve RegistryValueEntity
		err := json.Unmarshal(body, &rve)
		return rve, err
	case string(KindBasicEntityKindSecurityGroup):
		var sge SecurityGroupEntity
		err := json.Unmarshal(body, &sge)
		return sge, err
	case string(KindBasicEntityKindURL):
		var ue URLEntity
		err := json.Unmarshal(body, &ue)
		return ue, err
	case string(KindBasicEntityKindIoTDevice):
		var itde IoTDeviceEntity
		err := json.Unmarshal(body, &itde)
		return itde, err
	default:
		var e Entity
		err := json.Unmarshal(body, &e)
		return e, err
	}
}
func unmarshalBasicEntityArray(body []byte) ([]BasicEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eArray := make([]BasicEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		e, err := unmarshalBasicEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		eArray[index] = e
	}
	return eArray, nil
}

// MarshalJSON is the custom marshaler for Entity.
func (e Entity) MarshalJSON() ([]byte, error) {
	e.Kind = KindBasicEntityKindEntity
	objectMap := make(map[string]interface{})
	if e.Kind != "" {
		objectMap["kind"] = e.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for Entity.
func (e Entity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for Entity.
func (e Entity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for Entity.
func (e Entity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for Entity.
func (e Entity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for Entity.
func (e Entity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for Entity.
func (e Entity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for Entity.
func (e Entity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for Entity.
func (e Entity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for Entity.
func (e Entity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for Entity.
func (e Entity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for Entity.
func (e Entity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for Entity.
func (e Entity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for Entity.
func (e Entity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for Entity.
func (e Entity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for Entity.
func (e Entity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for Entity.
func (e Entity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for Entity.
func (e Entity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for Entity.
func (e Entity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for Entity.
func (e Entity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for Entity.
func (e Entity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for Entity.
func (e Entity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for Entity.
func (e Entity) AsEntity() (*Entity, bool) {
	return &e, true
}

// AsBasicEntity is the BasicEntity implementation for Entity.
func (e Entity) AsBasicEntity() (BasicEntity, bool) {
	return &e, true
}

// EntityAnalytics settings with single toggle.
type EntityAnalytics struct {
	// EntityAnalyticsProperties - EntityAnalytics properties
	*EntityAnalyticsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindIPSyncer', 'KindBasicSettingsKindEyesOn', 'KindBasicSettingsKindEntityAnalytics', 'KindBasicSettingsKindUeba'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityAnalytics.
func (ea EntityAnalytics) MarshalJSON() ([]byte, error) {
	ea.Kind = KindBasicSettingsKindEntityAnalytics
	objectMap := make(map[string]interface{})
	if ea.EntityAnalyticsProperties != nil {
		objectMap["properties"] = ea.EntityAnalyticsProperties
	}
	if ea.Etag != nil {
		objectMap["etag"] = ea.Etag
	}
	if ea.Kind != "" {
		objectMap["kind"] = ea.Kind
	}
	return json.Marshal(objectMap)
}

// AsIPSyncer is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsIPSyncer() (*IPSyncer, bool) {
	return nil, false
}

// AsEyesOn is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsEyesOn() (*EyesOn, bool) {
	return nil, false
}

// AsEntityAnalytics is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsEntityAnalytics() (*EntityAnalytics, bool) {
	return &ea, true
}

// AsUeba is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsUeba() (*Ueba, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for EntityAnalytics.
func (ea EntityAnalytics) AsBasicSettings() (BasicSettings, bool) {
	return &ea, true
}

// UnmarshalJSON is the custom unmarshaler for EntityAnalytics struct.
func (ea *EntityAnalytics) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var entityAnalyticsProperties EntityAnalyticsProperties
				err = json.Unmarshal(*v, &entityAnalyticsProperties)
				if err != nil {
					return err
				}
				ea.EntityAnalyticsProperties = &entityAnalyticsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ea.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ea.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ea.Kind = kind
			}
		}
	}

	return nil
}

// EntityAnalyticsProperties entityAnalytics property bag.
type EntityAnalyticsProperties struct {
	// IsEnabled - READ-ONLY; Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityAnalyticsProperties.
func (eap EntityAnalyticsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EntityCommonProperties entity common property bag.
type EntityCommonProperties struct {
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityCommonProperties.
func (ecp EntityCommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EntityEdges the edge that connects the entity to the other entity.
type EntityEdges struct {
	// TargetEntityID - The target entity Id.
	TargetEntityID *string `json:"targetEntityId,omitempty"`
	// AdditionalData - A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
}

// MarshalJSON is the custom marshaler for EntityEdges.
func (ee EntityEdges) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ee.TargetEntityID != nil {
		objectMap["targetEntityId"] = ee.TargetEntityID
	}
	if ee.AdditionalData != nil {
		objectMap["additionalData"] = ee.AdditionalData
	}
	return json.Marshal(objectMap)
}

// EntityExpandParameters the parameters required to execute an expand operation on the given entity.
type EntityExpandParameters struct {
	// EndTime - The end date filter, so the only expansion results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ExpansionID - The Id of the expansion to perform.
	ExpansionID *uuid.UUID `json:"expansionId,omitempty"`
	// StartTime - The start date filter, so the only expansion results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// EntityExpandResponse the entity expansion result operation response.
type EntityExpandResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the expansion operation results.
	MetaData *ExpansionResultsMetadata `json:"metaData,omitempty"`
	// Value - The expansion result values.
	Value *EntityExpandResponseValue `json:"value,omitempty"`
}

// EntityExpandResponseValue the expansion result values.
type EntityExpandResponseValue struct {
	// Entities - Array of the expansion result entities.
	Entities *[]BasicEntity `json:"entities,omitempty"`
	// Edges - Array of edges that connects the entity to the list of entities.
	Edges *[]EntityEdges `json:"edges,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityExpandResponseValue struct.
func (eer *EntityExpandResponseValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "entities":
			if v != nil {
				entities, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				eer.Entities = &entities
			}
		case "edges":
			if v != nil {
				var edges []EntityEdges
				err = json.Unmarshal(*v, &edges)
				if err != nil {
					return err
				}
				eer.Edges = &edges
			}
		}
	}

	return nil
}

// EntityGetInsightsParameters the parameters required to execute insights operation on the given entity.
type EntityGetInsightsParameters struct {
	// StartTime - The start timeline date, so the results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end timeline date, so the results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AddDefaultExtendedTimeRange - Indicates if query time range should be extended with default time range of the query. Default value is false
	AddDefaultExtendedTimeRange *bool `json:"addDefaultExtendedTimeRange,omitempty"`
	// InsightQueryIds - List of Insights Query Id. If empty, default value is all insights of this entity
	InsightQueryIds *[]uuid.UUID `json:"insightQueryIds,omitempty"`
}

// EntityGetInsightsResponse the Get Insights result operation response.
type EntityGetInsightsResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the get insights operation results.
	MetaData *GetInsightsResultsMetadata `json:"metaData,omitempty"`
	// Value - The insights result values.
	Value *[]EntityInsightItem `json:"value,omitempty"`
}

// EntityInsightItem entity insight Item.
type EntityInsightItem struct {
	// QueryID - The query id of the insight
	QueryID *string `json:"queryId,omitempty"`
	// QueryTimeInterval - The Time interval that the query actually executed on.
	QueryTimeInterval *EntityInsightItemQueryTimeInterval `json:"queryTimeInterval,omitempty"`
	// TableQueryResults - Query results for table insights query.
	TableQueryResults *InsightsTableResult `json:"tableQueryResults,omitempty"`
	// ChartQueryResults - Query results for table insights query.
	ChartQueryResults *[]InsightsTableResult `json:"chartQueryResults,omitempty"`
}

// EntityInsightItemQueryTimeInterval the Time interval that the query actually executed on.
type EntityInsightItemQueryTimeInterval struct {
	// StartTime - Insight query start time
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Insight query end time
	EndTime *date.Time `json:"endTime,omitempty"`
}

// EntityKind1 describes an entity with kind.
type EntityKind1 struct {
	// Kind - The kind of the entity. Possible values include: 'EntityKindAccount', 'EntityKindHost', 'EntityKindFile', 'EntityKindAzureResource', 'EntityKindCloudApplication', 'EntityKindDNSResolution', 'EntityKindFileHash', 'EntityKindIP', 'EntityKindMalware', 'EntityKindProcess', 'EntityKindRegistryKey', 'EntityKindRegistryValue', 'EntityKindSecurityGroup', 'EntityKindURL', 'EntityKindIoTDevice', 'EntityKindSecurityAlert', 'EntityKindBookmark', 'EntityKindMailCluster', 'EntityKindMailMessage', 'EntityKindMailbox', 'EntityKindSubmissionMail'
	Kind EntityKind `json:"kind,omitempty"`
}

// EntityList list of all the entities.
type EntityList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entities.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entities.
	Value *[]BasicEntity `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityList.
func (el EntityList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if el.Value != nil {
		objectMap["value"] = el.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityList struct.
func (el *EntityList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				el.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				el.Value = &value
			}
		}
	}

	return nil
}

// EntityListIterator provides access to a complete listing of Entity values.
type EntityListIterator struct {
	i    int
	page EntityListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityListIterator) Response() EntityList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityListIterator) Value() BasicEntity {
	if !iter.page.NotDone() {
		return Entity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityListIterator type.
func NewEntityListIterator(page EntityListPage) EntityListIterator {
	return EntityListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el EntityList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (el EntityList) hasNextLink() bool {
	return el.NextLink != nil && len(*el.NextLink) != 0
}

// entityListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el EntityList) entityListPreparer(ctx context.Context) (*http.Request, error) {
	if !el.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// EntityListPage contains a page of BasicEntity values.
type EntityListPage struct {
	fn func(context.Context, EntityList) (EntityList, error)
	el EntityList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.el)
		if err != nil {
			return err
		}
		page.el = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityListPage) Response() EntityList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityListPage) Values() []BasicEntity {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the EntityListPage type.
func NewEntityListPage(cur EntityList, getNextPage func(context.Context, EntityList) (EntityList, error)) EntityListPage {
	return EntityListPage{
		fn: getNextPage,
		el: cur,
	}
}

// EntityModel ...
type EntityModel struct {
	autorest.Response `json:"-"`
	Value             BasicEntity `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityModel struct.
func (em *EntityModel) UnmarshalJSON(body []byte) error {
	e, err := unmarshalBasicEntity(body)
	if err != nil {
		return err
	}
	em.Value = e

	return nil
}

// BasicEntityQuery specific entity query.
type BasicEntityQuery interface {
	AsExpansionEntityQuery() (*ExpansionEntityQuery, bool)
	AsEntityQuery() (*EntityQuery, bool)
}

// EntityQuery specific entity query.
type EntityQuery struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityQueryKindEntityQuery', 'KindBasicEntityQueryKindExpansion'
	Kind KindBasicEntityQuery `json:"kind,omitempty"`
}

func unmarshalBasicEntityQuery(body []byte) (BasicEntityQuery, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicEntityQueryKindExpansion):
		var eeq ExpansionEntityQuery
		err := json.Unmarshal(body, &eeq)
		return eeq, err
	default:
		var eq EntityQuery
		err := json.Unmarshal(body, &eq)
		return eq, err
	}
}
func unmarshalBasicEntityQueryArray(body []byte) ([]BasicEntityQuery, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eqArray := make([]BasicEntityQuery, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eq, err := unmarshalBasicEntityQuery(*rawMessage)
		if err != nil {
			return nil, err
		}
		eqArray[index] = eq
	}
	return eqArray, nil
}

// MarshalJSON is the custom marshaler for EntityQuery.
func (eq EntityQuery) MarshalJSON() ([]byte, error) {
	eq.Kind = KindBasicEntityQueryKindEntityQuery
	objectMap := make(map[string]interface{})
	if eq.Etag != nil {
		objectMap["etag"] = eq.Etag
	}
	if eq.Kind != "" {
		objectMap["kind"] = eq.Kind
	}
	return json.Marshal(objectMap)
}

// AsExpansionEntityQuery is the BasicEntityQuery implementation for EntityQuery.
func (eq EntityQuery) AsExpansionEntityQuery() (*ExpansionEntityQuery, bool) {
	return nil, false
}

// AsEntityQuery is the BasicEntityQuery implementation for EntityQuery.
func (eq EntityQuery) AsEntityQuery() (*EntityQuery, bool) {
	return &eq, true
}

// AsBasicEntityQuery is the BasicEntityQuery implementation for EntityQuery.
func (eq EntityQuery) AsBasicEntityQuery() (BasicEntityQuery, bool) {
	return &eq, true
}

// EntityQueryItem an abstract Query item for entity
type EntityQueryItem struct {
	// ID - READ-ONLY; Query Template ARM ID
	ID *string `json:"id,omitempty"`
	// Name - Query Template ARM Name
	Name *string `json:"name,omitempty"`
	// Type - ARM Type
	Type *string `json:"type,omitempty"`
	// Kind - The kind of the entity query. Possible values include: 'EntityQueryKindExpansion', 'EntityQueryKindInsight'
	Kind EntityQueryKind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityQueryItem.
func (eqi EntityQueryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eqi.Name != nil {
		objectMap["name"] = eqi.Name
	}
	if eqi.Type != nil {
		objectMap["type"] = eqi.Type
	}
	if eqi.Kind != "" {
		objectMap["kind"] = eqi.Kind
	}
	return json.Marshal(objectMap)
}

// EntityQueryItemProperties an properties abstract Query item for entity
type EntityQueryItemProperties struct {
	// DataTypes - Data types for template
	DataTypes *[]EntityQueryItemPropertiesDataTypesItem `json:"dataTypes,omitempty"`
	// InputEntityType - The type of the entity. Possible values include: 'EntityTypeAccount', 'EntityTypeHost', 'EntityTypeFile', 'EntityTypeAzureResource', 'EntityTypeCloudApplication', 'EntityTypeDNS', 'EntityTypeFileHash', 'EntityTypeIP', 'EntityTypeMalware', 'EntityTypeProcess', 'EntityTypeRegistryKey', 'EntityTypeRegistryValue', 'EntityTypeSecurityGroup', 'EntityTypeURL', 'EntityTypeIoTDevice', 'EntityTypeSecurityAlert', 'EntityTypeHuntingBookmark', 'EntityTypeMailCluster', 'EntityTypeMailMessage', 'EntityTypeMailbox', 'EntityTypeSubmissionMail'
	InputEntityType EntityType `json:"inputEntityType,omitempty"`
	// RequiredInputFieldsSets - Data types for template
	RequiredInputFieldsSets *[][]string `json:"requiredInputFieldsSets,omitempty"`
	// EntitiesFilter - The query applied only to entities matching to all filters
	EntitiesFilter interface{} `json:"entitiesFilter,omitempty"`
}

// EntityQueryItemPropertiesDataTypesItem ...
type EntityQueryItemPropertiesDataTypesItem struct {
	// DataType - Data type name
	DataType *string `json:"dataType,omitempty"`
}

// EntityQueryKind1 describes an Entity query resource with kind.
type EntityQueryKind1 struct {
	// Kind - The kind of the entity query. Possible values include: 'EntityQueryKindExpansion', 'EntityQueryKindInsight'
	Kind EntityQueryKind `json:"kind,omitempty"`
}

// EntityQueryList list of all the entity queries.
type EntityQueryList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entity queries.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entity queries.
	Value *[]BasicEntityQuery `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityQueryList.
func (eql EntityQueryList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eql.Value != nil {
		objectMap["value"] = eql.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityQueryList struct.
func (eql *EntityQueryList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				eql.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEntityQueryArray(*v)
				if err != nil {
					return err
				}
				eql.Value = &value
			}
		}
	}

	return nil
}

// EntityQueryListIterator provides access to a complete listing of EntityQuery values.
type EntityQueryListIterator struct {
	i    int
	page EntityQueryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityQueryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityQueryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityQueryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityQueryListIterator) Response() EntityQueryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityQueryListIterator) Value() BasicEntityQuery {
	if !iter.page.NotDone() {
		return EntityQuery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityQueryListIterator type.
func NewEntityQueryListIterator(page EntityQueryListPage) EntityQueryListIterator {
	return EntityQueryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eql EntityQueryList) IsEmpty() bool {
	return eql.Value == nil || len(*eql.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eql EntityQueryList) hasNextLink() bool {
	return eql.NextLink != nil && len(*eql.NextLink) != 0
}

// entityQueryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eql EntityQueryList) entityQueryListPreparer(ctx context.Context) (*http.Request, error) {
	if !eql.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eql.NextLink)))
}

// EntityQueryListPage contains a page of BasicEntityQuery values.
type EntityQueryListPage struct {
	fn  func(context.Context, EntityQueryList) (EntityQueryList, error)
	eql EntityQueryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityQueryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eql)
		if err != nil {
			return err
		}
		page.eql = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityQueryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityQueryListPage) NotDone() bool {
	return !page.eql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityQueryListPage) Response() EntityQueryList {
	return page.eql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityQueryListPage) Values() []BasicEntityQuery {
	if page.eql.IsEmpty() {
		return nil
	}
	return *page.eql.Value
}

// Creates a new instance of the EntityQueryListPage type.
func NewEntityQueryListPage(cur EntityQueryList, getNextPage func(context.Context, EntityQueryList) (EntityQueryList, error)) EntityQueryListPage {
	return EntityQueryListPage{
		fn:  getNextPage,
		eql: cur,
	}
}

// EntityQueryModel ...
type EntityQueryModel struct {
	autorest.Response `json:"-"`
	Value             BasicEntityQuery `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityQueryModel struct.
func (eqm *EntityQueryModel) UnmarshalJSON(body []byte) error {
	eq, err := unmarshalBasicEntityQuery(body)
	if err != nil {
		return err
	}
	eqm.Value = eq

	return nil
}

// BasicEntityTimelineItem entity timeline Item.
type BasicEntityTimelineItem interface {
	AsActivityTimelineItem() (*ActivityTimelineItem, bool)
	AsSecurityAlertTimelineItem() (*SecurityAlertTimelineItem, bool)
	AsBookmarkTimelineItem() (*BookmarkTimelineItem, bool)
	AsEntityTimelineItem() (*EntityTimelineItem, bool)
}

// EntityTimelineItem entity timeline Item.
type EntityTimelineItem struct {
	// Kind - Possible values include: 'KindBasicEntityTimelineItemKindEntityTimelineItem', 'KindBasicEntityTimelineItemKindActivity', 'KindBasicEntityTimelineItemKindSecurityAlert', 'KindBasicEntityTimelineItemKindBookmark'
	Kind KindBasicEntityTimelineItem `json:"kind,omitempty"`
}

func unmarshalBasicEntityTimelineItem(body []byte) (BasicEntityTimelineItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicEntityTimelineItemKindActivity):
		var ati ActivityTimelineItem
		err := json.Unmarshal(body, &ati)
		return ati, err
	case string(KindBasicEntityTimelineItemKindSecurityAlert):
		var sati SecurityAlertTimelineItem
		err := json.Unmarshal(body, &sati)
		return sati, err
	case string(KindBasicEntityTimelineItemKindBookmark):
		var bti BookmarkTimelineItem
		err := json.Unmarshal(body, &bti)
		return bti, err
	default:
		var eti EntityTimelineItem
		err := json.Unmarshal(body, &eti)
		return eti, err
	}
}
func unmarshalBasicEntityTimelineItemArray(body []byte) ([]BasicEntityTimelineItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	etiArray := make([]BasicEntityTimelineItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eti, err := unmarshalBasicEntityTimelineItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		etiArray[index] = eti
	}
	return etiArray, nil
}

// MarshalJSON is the custom marshaler for EntityTimelineItem.
func (eti EntityTimelineItem) MarshalJSON() ([]byte, error) {
	eti.Kind = KindBasicEntityTimelineItemKindEntityTimelineItem
	objectMap := make(map[string]interface{})
	if eti.Kind != "" {
		objectMap["kind"] = eti.Kind
	}
	return json.Marshal(objectMap)
}

// AsActivityTimelineItem is the BasicEntityTimelineItem implementation for EntityTimelineItem.
func (eti EntityTimelineItem) AsActivityTimelineItem() (*ActivityTimelineItem, bool) {
	return nil, false
}

// AsSecurityAlertTimelineItem is the BasicEntityTimelineItem implementation for EntityTimelineItem.
func (eti EntityTimelineItem) AsSecurityAlertTimelineItem() (*SecurityAlertTimelineItem, bool) {
	return nil, false
}

// AsBookmarkTimelineItem is the BasicEntityTimelineItem implementation for EntityTimelineItem.
func (eti EntityTimelineItem) AsBookmarkTimelineItem() (*BookmarkTimelineItem, bool) {
	return nil, false
}

// AsEntityTimelineItem is the BasicEntityTimelineItem implementation for EntityTimelineItem.
func (eti EntityTimelineItem) AsEntityTimelineItem() (*EntityTimelineItem, bool) {
	return &eti, true
}

// AsBasicEntityTimelineItem is the BasicEntityTimelineItem implementation for EntityTimelineItem.
func (eti EntityTimelineItem) AsBasicEntityTimelineItem() (BasicEntityTimelineItem, bool) {
	return &eti, true
}

// EntityTimelineParameters the parameters required to execute s timeline operation on the given entity.
type EntityTimelineParameters struct {
	// Kinds - Array of timeline Item kinds.
	Kinds *[]EntityTimelineKind `json:"kinds,omitempty"`
	// StartTime - The start timeline date, so the results returned are after this date.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end timeline date, so the results returned are before this date.
	EndTime *date.Time `json:"endTime,omitempty"`
	// NumberOfBucket - The number of bucket for timeline queries aggregation.
	NumberOfBucket *int32 `json:"numberOfBucket,omitempty"`
}

// EntityTimelineResponse the entity timeline result operation response.
type EntityTimelineResponse struct {
	autorest.Response `json:"-"`
	// MetaData - The metadata from the timeline operation results.
	MetaData *TimelineResultsMetadata `json:"metaData,omitempty"`
	// Value - The timeline result values.
	Value *[]BasicEntityTimelineItem `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityTimelineResponse struct.
func (etr *EntityTimelineResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "metaData":
			if v != nil {
				var metaData TimelineResultsMetadata
				err = json.Unmarshal(*v, &metaData)
				if err != nil {
					return err
				}
				etr.MetaData = &metaData
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEntityTimelineItemArray(*v)
				if err != nil {
					return err
				}
				etr.Value = &value
			}
		}
	}

	return nil
}

// EventGroupingSettings event grouping settings property bag.
type EventGroupingSettings struct {
	// AggregationKind - Possible values include: 'EventGroupingAggregationKindSingleAlert', 'EventGroupingAggregationKindAlertPerResult'
	AggregationKind EventGroupingAggregationKind `json:"aggregationKind,omitempty"`
}

// ExpansionEntityQueriesProperties describes expansion entity query properties
type ExpansionEntityQueriesProperties struct {
	// DataSources - List of the data sources that are required to run the query
	DataSources *[]string `json:"dataSources,omitempty"`
	// DisplayName - The query display name
	DisplayName *string `json:"displayName,omitempty"`
	// InputEntityType - The type of the query's source entity. Possible values include: 'EntityTypeAccount', 'EntityTypeHost', 'EntityTypeFile', 'EntityTypeAzureResource', 'EntityTypeCloudApplication', 'EntityTypeDNS', 'EntityTypeFileHash', 'EntityTypeIP', 'EntityTypeMalware', 'EntityTypeProcess', 'EntityTypeRegistryKey', 'EntityTypeRegistryValue', 'EntityTypeSecurityGroup', 'EntityTypeURL', 'EntityTypeIoTDevice', 'EntityTypeSecurityAlert', 'EntityTypeHuntingBookmark', 'EntityTypeMailCluster', 'EntityTypeMailMessage', 'EntityTypeMailbox', 'EntityTypeSubmissionMail'
	InputEntityType EntityType `json:"inputEntityType,omitempty"`
	// InputFields - List of the fields of the source entity that are required to run the query
	InputFields *[]string `json:"inputFields,omitempty"`
	// OutputEntityTypes - List of the desired output types to be constructed from the result
	OutputEntityTypes *[]EntityType `json:"outputEntityTypes,omitempty"`
	// QueryTemplate - The template query string to be parsed and formatted
	QueryTemplate *string `json:"queryTemplate,omitempty"`
}

// ExpansionEntityQuery represents Expansion entity query.
type ExpansionEntityQuery struct {
	// ExpansionEntityQueriesProperties - Expansion entity query properties
	*ExpansionEntityQueriesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityQueryKindEntityQuery', 'KindBasicEntityQueryKindExpansion'
	Kind KindBasicEntityQuery `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ExpansionEntityQuery.
func (eeq ExpansionEntityQuery) MarshalJSON() ([]byte, error) {
	eeq.Kind = KindBasicEntityQueryKindExpansion
	objectMap := make(map[string]interface{})
	if eeq.ExpansionEntityQueriesProperties != nil {
		objectMap["properties"] = eeq.ExpansionEntityQueriesProperties
	}
	if eeq.Etag != nil {
		objectMap["etag"] = eeq.Etag
	}
	if eeq.Kind != "" {
		objectMap["kind"] = eeq.Kind
	}
	return json.Marshal(objectMap)
}

// AsExpansionEntityQuery is the BasicEntityQuery implementation for ExpansionEntityQuery.
func (eeq ExpansionEntityQuery) AsExpansionEntityQuery() (*ExpansionEntityQuery, bool) {
	return &eeq, true
}

// AsEntityQuery is the BasicEntityQuery implementation for ExpansionEntityQuery.
func (eeq ExpansionEntityQuery) AsEntityQuery() (*EntityQuery, bool) {
	return nil, false
}

// AsBasicEntityQuery is the BasicEntityQuery implementation for ExpansionEntityQuery.
func (eeq ExpansionEntityQuery) AsBasicEntityQuery() (BasicEntityQuery, bool) {
	return &eeq, true
}

// UnmarshalJSON is the custom unmarshaler for ExpansionEntityQuery struct.
func (eeq *ExpansionEntityQuery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var expansionEntityQueriesProperties ExpansionEntityQueriesProperties
				err = json.Unmarshal(*v, &expansionEntityQueriesProperties)
				if err != nil {
					return err
				}
				eeq.ExpansionEntityQueriesProperties = &expansionEntityQueriesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eeq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eeq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eeq.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				eeq.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntityQuery
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				eeq.Kind = kind
			}
		}
	}

	return nil
}

// ExpansionResultAggregation information of a specific aggregation in the expansion result.
type ExpansionResultAggregation struct {
	// AggregationType - The common type of the aggregation. (for e.g. entity field name)
	AggregationType *string `json:"aggregationType,omitempty"`
	// Count - Total number of aggregations of the given kind (and aggregationType if given) in the expansion result.
	Count *int32 `json:"count,omitempty"`
	// DisplayName - The display name of the aggregation by type.
	DisplayName *string `json:"displayName,omitempty"`
	// EntityKind - The kind of the aggregated entity. Possible values include: 'EntityKindAccount', 'EntityKindHost', 'EntityKindFile', 'EntityKindAzureResource', 'EntityKindCloudApplication', 'EntityKindDNSResolution', 'EntityKindFileHash', 'EntityKindIP', 'EntityKindMalware', 'EntityKindProcess', 'EntityKindRegistryKey', 'EntityKindRegistryValue', 'EntityKindSecurityGroup', 'EntityKindURL', 'EntityKindIoTDevice', 'EntityKindSecurityAlert', 'EntityKindBookmark', 'EntityKindMailCluster', 'EntityKindMailMessage', 'EntityKindMailbox', 'EntityKindSubmissionMail'
	EntityKind EntityKind `json:"entityKind,omitempty"`
}

// ExpansionResultsMetadata expansion result metadata.
type ExpansionResultsMetadata struct {
	// Aggregations - Information of the aggregated nodes in the expansion result.
	Aggregations *[]ExpansionResultAggregation `json:"aggregations,omitempty"`
}

// EyesOn settings with single toggle.
type EyesOn struct {
	// EyesOnSettingsProperties - EyesOn properties
	*EyesOnSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindIPSyncer', 'KindBasicSettingsKindEyesOn', 'KindBasicSettingsKindEntityAnalytics', 'KindBasicSettingsKindUeba'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for EyesOn.
func (eo EyesOn) MarshalJSON() ([]byte, error) {
	eo.Kind = KindBasicSettingsKindEyesOn
	objectMap := make(map[string]interface{})
	if eo.EyesOnSettingsProperties != nil {
		objectMap["properties"] = eo.EyesOnSettingsProperties
	}
	if eo.Etag != nil {
		objectMap["etag"] = eo.Etag
	}
	if eo.Kind != "" {
		objectMap["kind"] = eo.Kind
	}
	return json.Marshal(objectMap)
}

// AsIPSyncer is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsIPSyncer() (*IPSyncer, bool) {
	return nil, false
}

// AsEyesOn is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsEyesOn() (*EyesOn, bool) {
	return &eo, true
}

// AsEntityAnalytics is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsEntityAnalytics() (*EntityAnalytics, bool) {
	return nil, false
}

// AsUeba is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsUeba() (*Ueba, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for EyesOn.
func (eo EyesOn) AsBasicSettings() (BasicSettings, bool) {
	return &eo, true
}

// UnmarshalJSON is the custom unmarshaler for EyesOn struct.
func (eo *EyesOn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var eyesOnSettingsProperties EyesOnSettingsProperties
				err = json.Unmarshal(*v, &eyesOnSettingsProperties)
				if err != nil {
					return err
				}
				eo.EyesOnSettingsProperties = &eyesOnSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eo.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				eo.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				eo.Kind = kind
			}
		}
	}

	return nil
}

// EyesOnSettingsProperties eyesOn property bag.
type EyesOnSettingsProperties struct {
	// IsEnabled - READ-ONLY; Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for EyesOnSettingsProperties.
func (eosp EyesOnSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileEntity represents a file entity.
type FileEntity struct {
	// FileEntityProperties - File entity properties
	*FileEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEntity.
func (fe FileEntity) MarshalJSON() ([]byte, error) {
	fe.Kind = KindBasicEntityKindFile
	objectMap := make(map[string]interface{})
	if fe.FileEntityProperties != nil {
		objectMap["properties"] = fe.FileEntityProperties
	}
	if fe.Kind != "" {
		objectMap["kind"] = fe.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsFileEntity() (*FileEntity, bool) {
	return &fe, true
}

// AsFileHashEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsBasicEntity() (BasicEntity, bool) {
	return &fe, true
}

// UnmarshalJSON is the custom unmarshaler for FileEntity struct.
func (fe *FileEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileEntityProperties FileEntityProperties
				err = json.Unmarshal(*v, &fileEntityProperties)
				if err != nil {
					return err
				}
				fe.FileEntityProperties = &fileEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fe.Kind = kind
			}
		}
	}

	return nil
}

// FileEntityProperties file entity property bag.
type FileEntityProperties struct {
	// Directory - READ-ONLY; The full path to the file.
	Directory *string `json:"directory,omitempty"`
	// FileHashEntityIds - READ-ONLY; The file hash entity identifiers associated with this file
	FileHashEntityIds *[]string `json:"fileHashEntityIds,omitempty"`
	// FileName - READ-ONLY; The file name without path (some alerts might not include path).
	FileName *string `json:"fileName,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id which the file belongs to
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEntityProperties.
func (fep FileEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FileHashEntity represents a file hash entity.
type FileHashEntity struct {
	// FileHashEntityProperties - FileHash entity properties
	*FileHashEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileHashEntity.
func (fhe FileHashEntity) MarshalJSON() ([]byte, error) {
	fhe.Kind = KindBasicEntityKindFileHash
	objectMap := make(map[string]interface{})
	if fhe.FileHashEntityProperties != nil {
		objectMap["properties"] = fhe.FileHashEntityProperties
	}
	if fhe.Kind != "" {
		objectMap["kind"] = fhe.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return &fhe, true
}

// AsHostEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for FileHashEntity.
func (fhe FileHashEntity) AsBasicEntity() (BasicEntity, bool) {
	return &fhe, true
}

// UnmarshalJSON is the custom unmarshaler for FileHashEntity struct.
func (fhe *FileHashEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileHashEntityProperties FileHashEntityProperties
				err = json.Unmarshal(*v, &fileHashEntityProperties)
				if err != nil {
					return err
				}
				fhe.FileHashEntityProperties = &fileHashEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fhe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fhe.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fhe.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fhe.Kind = kind
			}
		}
	}

	return nil
}

// FileHashEntityProperties fileHash entity property bag.
type FileHashEntityProperties struct {
	// Algorithm - READ-ONLY; The hash algorithm type. Possible values include: 'FileHashAlgorithmUnknown', 'FileHashAlgorithmMD5', 'FileHashAlgorithmSHA1', 'FileHashAlgorithmSHA256', 'FileHashAlgorithmSHA256AC'
	Algorithm FileHashAlgorithm `json:"algorithm,omitempty"`
	// HashValue - READ-ONLY; The file hash value.
	HashValue *string `json:"hashValue,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for FileHashEntityProperties.
func (fhep FileHashEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FusionAlertRule represents Fusion alert rule.
type FusionAlertRule struct {
	// FusionAlertRuleProperties - Fusion alert rule properties
	*FusionAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRule.
func (far FusionAlertRule) MarshalJSON() ([]byte, error) {
	far.Kind = KindBasicAlertRuleKindFusion
	objectMap := make(map[string]interface{})
	if far.FusionAlertRuleProperties != nil {
		objectMap["properties"] = far.FusionAlertRuleProperties
	}
	if far.Etag != nil {
		objectMap["etag"] = far.Etag
	}
	if far.Kind != "" {
		objectMap["kind"] = far.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return nil, false
}

// AsFusionAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return &far, true
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for FusionAlertRule.
func (far FusionAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &far, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRule struct.
func (far *FusionAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleProperties FusionAlertRuleProperties
				err = json.Unmarshal(*v, &fusionAlertRuleProperties)
				if err != nil {
					return err
				}
				far.FusionAlertRuleProperties = &fusionAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				far.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				far.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				far.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				far.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				far.Kind = kind
			}
		}
	}

	return nil
}

// FusionAlertRuleProperties fusion alert rule base property bag.
type FusionAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - READ-ONLY; The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Severity - READ-ONLY; The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleProperties.
func (farp FusionAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if farp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = farp.AlertRuleTemplateName
	}
	if farp.Enabled != nil {
		objectMap["enabled"] = farp.Enabled
	}
	return json.Marshal(objectMap)
}

// FusionAlertRuleTemplate represents Fusion alert rule template.
type FusionAlertRuleTemplate struct {
	// FusionAlertRuleTemplateProperties - Fusion alert rule template properties
	*FusionAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	fart.Kind = KindBasicAlertRuleTemplateKindFusion
	objectMap := make(map[string]interface{})
	if fart.FusionAlertRuleTemplateProperties != nil {
		objectMap["properties"] = fart.FusionAlertRuleTemplateProperties
	}
	if fart.Kind != "" {
		objectMap["kind"] = fart.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return nil, false
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return &fart, true
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for FusionAlertRuleTemplate.
func (fart FusionAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &fart, true
}

// UnmarshalJSON is the custom unmarshaler for FusionAlertRuleTemplate struct.
func (fart *FusionAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fusionAlertRuleTemplateProperties FusionAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &fusionAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				fart.FusionAlertRuleTemplateProperties = &fusionAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fart.Kind = kind
			}
		}
	}

	return nil
}

// FusionAlertRuleTemplateProperties fusion alert rule template properties
type FusionAlertRuleTemplateProperties struct {
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for FusionAlertRuleTemplateProperties.
func (fart FusionAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fart.Severity != "" {
		objectMap["severity"] = fart.Severity
	}
	if fart.Tactics != nil {
		objectMap["tactics"] = fart.Tactics
	}
	if fart.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = fart.AlertRulesCreatedByTemplateCount
	}
	if fart.Description != nil {
		objectMap["description"] = fart.Description
	}
	if fart.DisplayName != nil {
		objectMap["displayName"] = fart.DisplayName
	}
	if fart.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = fart.RequiredDataConnectors
	}
	if fart.Status != "" {
		objectMap["status"] = fart.Status
	}
	return json.Marshal(objectMap)
}

// GeoLocation the geo-location context attached to the ip entity
type GeoLocation struct {
	// Asn - READ-ONLY; Autonomous System Number
	Asn *int32 `json:"asn,omitempty"`
	// City - READ-ONLY; City name
	City *string `json:"city,omitempty"`
	// CountryCode - READ-ONLY; The country code according to ISO 3166 format
	CountryCode *string `json:"countryCode,omitempty"`
	// CountryName - READ-ONLY; Country name according to ISO 3166 Alpha 2: the lowercase of the English Short Name
	CountryName *string `json:"countryName,omitempty"`
	// Latitude - READ-ONLY; The longitude of the identified location, expressed as a floating point number with range of -180 to 180, with positive numbers representing East and negative numbers representing West. Latitude and longitude are derived from the city or postal code.
	Latitude *float64 `json:"latitude,omitempty"`
	// Longitude - READ-ONLY; The latitude of the identified location, expressed as a floating point number with range of - 90 to 90, with positive numbers representing North and negative numbers representing South. Latitude and longitude are derived from the city or postal code.
	Longitude *float64 `json:"longitude,omitempty"`
	// State - READ-ONLY; State name
	State *string `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoLocation.
func (gl GeoLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetInsightsError getInsights Query Errors.
type GetInsightsError struct {
	// Kind - the query kind
	Kind *string `json:"kind,omitempty"`
	// QueryID - the query id
	QueryID *string `json:"queryId,omitempty"`
	// ErrorMessage - the error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// GetInsightsResultsMetadata get Insights result metadata.
type GetInsightsResultsMetadata struct {
	// TotalCount - the total items found for the insights request
	TotalCount *int32 `json:"totalCount,omitempty"`
	// Errors - information about the failed queries
	Errors *[]GetInsightsError `json:"errors,omitempty"`
}

// GetQueriesResponse retrieve queries for entity result operation response.
type GetQueriesResponse struct {
	autorest.Response `json:"-"`
	// Value - The query result values.
	Value *[]EntityQueryItem `json:"value,omitempty"`
}

// GroupingConfiguration grouping configuration property bag.
type GroupingConfiguration struct {
	// Enabled - Grouping enabled
	Enabled *bool `json:"enabled,omitempty"`
	// ReopenClosedIncident - Re-open closed matching incidents
	ReopenClosedIncident *bool `json:"reopenClosedIncident,omitempty"`
	// LookbackDuration - Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
	LookbackDuration *string `json:"lookbackDuration,omitempty"`
	// EntitiesMatchingMethod - Grouping matching method. Possible values include: 'EntitiesMatchingMethodAll', 'EntitiesMatchingMethodNone', 'EntitiesMatchingMethodCustom'
	EntitiesMatchingMethod EntitiesMatchingMethod `json:"entitiesMatchingMethod,omitempty"`
	// GroupByEntities - A list of entity types to group by (when entitiesMatchingMethod is Custom)
	GroupByEntities *[]GroupingEntityType `json:"groupByEntities,omitempty"`
}

// HostEntity represents a host entity.
type HostEntity struct {
	// HostEntityProperties - Host entity properties
	*HostEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for HostEntity.
func (he HostEntity) MarshalJSON() ([]byte, error) {
	he.Kind = KindBasicEntityKindHost
	objectMap := make(map[string]interface{})
	if he.HostEntityProperties != nil {
		objectMap["properties"] = he.HostEntityProperties
	}
	if he.Kind != "" {
		objectMap["kind"] = he.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsHostEntity() (*HostEntity, bool) {
	return &he, true
}

// AsHuntingBookmark is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsBasicEntity() (BasicEntity, bool) {
	return &he, true
}

// UnmarshalJSON is the custom unmarshaler for HostEntity struct.
func (he *HostEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostEntityProperties HostEntityProperties
				err = json.Unmarshal(*v, &hostEntityProperties)
				if err != nil {
					return err
				}
				he.HostEntityProperties = &hostEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				he.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				he.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				he.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				he.Kind = kind
			}
		}
	}

	return nil
}

// HostEntityProperties host entity property bag.
type HostEntityProperties struct {
	// AzureID - READ-ONLY; The azure resource id of the VM.
	AzureID *string `json:"azureID,omitempty"`
	// DNSDomain - READ-ONLY; The DNS domain that this host belongs to. Should contain the compete DNS suffix for the domain
	DNSDomain *string `json:"dnsDomain,omitempty"`
	// HostName - READ-ONLY; The hostname without the domain suffix.
	HostName *string `json:"hostName,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this host belongs to a domain.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
	// NetBiosName - READ-ONLY; The host name (pre-windows2000).
	NetBiosName *string `json:"netBiosName,omitempty"`
	// NtDomain - READ-ONLY; The NT domain that this host belongs to.
	NtDomain *string `json:"ntDomain,omitempty"`
	// OmsAgentID - READ-ONLY; The OMS agent id, if the host has OMS agent installed.
	OmsAgentID *string `json:"omsAgentID,omitempty"`
	// OsFamily - The operating system type. Possible values include: 'OSFamilyLinux', 'OSFamilyWindows', 'OSFamilyAndroid', 'OSFamilyIOS', 'OSFamilyUnknown'
	OsFamily OSFamily `json:"osFamily,omitempty"`
	// OsVersion - READ-ONLY; A free text representation of the operating system. This field is meant to hold specific versions the are more fine grained than OSFamily or future values not supported by OSFamily enumeration
	OsVersion *string `json:"osVersion,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for HostEntityProperties.
func (hep HostEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hep.OsFamily != "" {
		objectMap["osFamily"] = hep.OsFamily
	}
	return json.Marshal(objectMap)
}

// HuntingBookmark represents a Hunting bookmark entity.
type HuntingBookmark struct {
	// HuntingBookmarkProperties - HuntingBookmark entity properties
	*HuntingBookmarkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for HuntingBookmark.
func (hb HuntingBookmark) MarshalJSON() ([]byte, error) {
	hb.Kind = KindBasicEntityKindBookmark
	objectMap := make(map[string]interface{})
	if hb.HuntingBookmarkProperties != nil {
		objectMap["properties"] = hb.HuntingBookmarkProperties
	}
	if hb.Kind != "" {
		objectMap["kind"] = hb.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return &hb, true
}

// AsSecurityAlert is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for HuntingBookmark.
func (hb HuntingBookmark) AsBasicEntity() (BasicEntity, bool) {
	return &hb, true
}

// UnmarshalJSON is the custom unmarshaler for HuntingBookmark struct.
func (hb *HuntingBookmark) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var huntingBookmarkProperties HuntingBookmarkProperties
				err = json.Unmarshal(*v, &huntingBookmarkProperties)
				if err != nil {
					return err
				}
				hb.HuntingBookmarkProperties = &huntingBookmarkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hb.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hb.Kind = kind
			}
		}
	}

	return nil
}

// HuntingBookmarkProperties describes bookmark properties
type HuntingBookmarkProperties struct {
	// Created - The time the bookmark was created
	Created *date.Time `json:"created,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// DisplayName - The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
	// EventTime - The time of the event
	EventTime *date.Time `json:"eventTime,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// Query - The query of the bookmark.
	Query *string `json:"query,omitempty"`
	// QueryResult - The query result of the bookmark.
	QueryResult *string `json:"queryResult,omitempty"`
	// Updated - The last time the bookmark was updated
	Updated *date.Time `json:"updated,omitempty"`
	// UpdatedBy - Describes a user that updated the bookmark
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// IncidentInfo - Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo `json:"incidentInfo,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for HuntingBookmarkProperties.
func (hbp HuntingBookmarkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hbp.Created != nil {
		objectMap["created"] = hbp.Created
	}
	if hbp.CreatedBy != nil {
		objectMap["createdBy"] = hbp.CreatedBy
	}
	if hbp.DisplayName != nil {
		objectMap["displayName"] = hbp.DisplayName
	}
	if hbp.EventTime != nil {
		objectMap["eventTime"] = hbp.EventTime
	}
	if hbp.Labels != nil {
		objectMap["labels"] = hbp.Labels
	}
	if hbp.Notes != nil {
		objectMap["notes"] = hbp.Notes
	}
	if hbp.Query != nil {
		objectMap["query"] = hbp.Query
	}
	if hbp.QueryResult != nil {
		objectMap["queryResult"] = hbp.QueryResult
	}
	if hbp.Updated != nil {
		objectMap["updated"] = hbp.Updated
	}
	if hbp.UpdatedBy != nil {
		objectMap["updatedBy"] = hbp.UpdatedBy
	}
	if hbp.IncidentInfo != nil {
		objectMap["incidentInfo"] = hbp.IncidentInfo
	}
	return json.Marshal(objectMap)
}

// Incident represents an incident in Azure Security Insights.
type Incident struct {
	autorest.Response `json:"-"`
	// IncidentProperties - Incident properties
	*IncidentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Incident.
func (i Incident) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IncidentProperties != nil {
		objectMap["properties"] = i.IncidentProperties
	}
	if i.Etag != nil {
		objectMap["etag"] = i.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Incident struct.
func (i *Incident) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentProperties IncidentProperties
				err = json.Unmarshal(*v, &incidentProperties)
				if err != nil {
					return err
				}
				i.IncidentProperties = &incidentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				i.Etag = &etag
			}
		}
	}

	return nil
}

// IncidentAdditionalData incident additional data property bag.
type IncidentAdditionalData struct {
	// AlertsCount - READ-ONLY; The number of alerts in the incident
	AlertsCount *int32 `json:"alertsCount,omitempty"`
	// BookmarksCount - READ-ONLY; The number of bookmarks in the incident
	BookmarksCount *int32 `json:"bookmarksCount,omitempty"`
	// CommentsCount - READ-ONLY; The number of comments in the incident
	CommentsCount *int32 `json:"commentsCount,omitempty"`
	// AlertProductNames - READ-ONLY; List of product names of alerts in the incident
	AlertProductNames *[]string `json:"alertProductNames,omitempty"`
	// Tactics - READ-ONLY; The tactics associated with incident
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentAdditionalData.
func (iad IncidentAdditionalData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IncidentAlertList list of incident alerts.
type IncidentAlertList struct {
	autorest.Response `json:"-"`
	// Value - Array of incident alerts.
	Value *[]SecurityAlert `json:"value,omitempty"`
}

// IncidentBookmarkList list of incident bookmarks.
type IncidentBookmarkList struct {
	autorest.Response `json:"-"`
	// Value - Array of incident bookmarks.
	Value *[]HuntingBookmark `json:"value,omitempty"`
}

// IncidentComment represents an incident comment
type IncidentComment struct {
	autorest.Response `json:"-"`
	// IncidentCommentProperties - Incident comment properties
	*IncidentCommentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentComment.
func (ic IncidentComment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IncidentCommentProperties != nil {
		objectMap["properties"] = ic.IncidentCommentProperties
	}
	if ic.Etag != nil {
		objectMap["etag"] = ic.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IncidentComment struct.
func (ic *IncidentComment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var incidentCommentProperties IncidentCommentProperties
				err = json.Unmarshal(*v, &incidentCommentProperties)
				if err != nil {
					return err
				}
				ic.IncidentCommentProperties = &incidentCommentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ic.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ic.Etag = &etag
			}
		}
	}

	return nil
}

// IncidentCommentList list of incident comments.
type IncidentCommentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of comments.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of comments.
	Value *[]IncidentComment `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentCommentList.
func (icl IncidentCommentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icl.Value != nil {
		objectMap["value"] = icl.Value
	}
	return json.Marshal(objectMap)
}

// IncidentCommentListIterator provides access to a complete listing of IncidentComment values.
type IncidentCommentListIterator struct {
	i    int
	page IncidentCommentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentCommentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentCommentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentCommentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentCommentListIterator) Response() IncidentCommentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentCommentListIterator) Value() IncidentComment {
	if !iter.page.NotDone() {
		return IncidentComment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentCommentListIterator type.
func NewIncidentCommentListIterator(page IncidentCommentListPage) IncidentCommentListIterator {
	return IncidentCommentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (icl IncidentCommentList) IsEmpty() bool {
	return icl.Value == nil || len(*icl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (icl IncidentCommentList) hasNextLink() bool {
	return icl.NextLink != nil && len(*icl.NextLink) != 0
}

// incidentCommentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (icl IncidentCommentList) incidentCommentListPreparer(ctx context.Context) (*http.Request, error) {
	if !icl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(icl.NextLink)))
}

// IncidentCommentListPage contains a page of IncidentComment values.
type IncidentCommentListPage struct {
	fn  func(context.Context, IncidentCommentList) (IncidentCommentList, error)
	icl IncidentCommentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentCommentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentCommentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.icl)
		if err != nil {
			return err
		}
		page.icl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentCommentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentCommentListPage) NotDone() bool {
	return !page.icl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentCommentListPage) Response() IncidentCommentList {
	return page.icl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentCommentListPage) Values() []IncidentComment {
	if page.icl.IsEmpty() {
		return nil
	}
	return *page.icl.Value
}

// Creates a new instance of the IncidentCommentListPage type.
func NewIncidentCommentListPage(cur IncidentCommentList, getNextPage func(context.Context, IncidentCommentList) (IncidentCommentList, error)) IncidentCommentListPage {
	return IncidentCommentListPage{
		fn:  getNextPage,
		icl: cur,
	}
}

// IncidentCommentProperties incident comment property bag.
type IncidentCommentProperties struct {
	// CreatedTimeUtc - READ-ONLY; The time the comment was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; The time the comment was updated
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// Message - The comment message
	Message *string `json:"message,omitempty"`
	// Author - READ-ONLY; Describes the client that created the comment
	Author *ClientInfo `json:"author,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentCommentProperties.
func (icp IncidentCommentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icp.Message != nil {
		objectMap["message"] = icp.Message
	}
	return json.Marshal(objectMap)
}

// IncidentConfiguration incident Configuration property bag.
type IncidentConfiguration struct {
	// CreateIncident - Create incidents from alerts triggered by this analytics rule
	CreateIncident *bool `json:"createIncident,omitempty"`
	// GroupingConfiguration - Set how the alerts that are triggered by this analytics rule, are grouped into incidents
	GroupingConfiguration *GroupingConfiguration `json:"groupingConfiguration,omitempty"`
}

// IncidentEntitiesResponse the incident related entities response.
type IncidentEntitiesResponse struct {
	autorest.Response `json:"-"`
	// Entities - Array of the incident related entities.
	Entities *[]BasicEntity `json:"entities,omitempty"`
	// MetaData - The metadata from the incident related entities results.
	MetaData *[]IncidentEntitiesResultsMetadata `json:"metaData,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for IncidentEntitiesResponse struct.
func (ier *IncidentEntitiesResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "entities":
			if v != nil {
				entities, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				ier.Entities = &entities
			}
		case "metaData":
			if v != nil {
				var metaData []IncidentEntitiesResultsMetadata
				err = json.Unmarshal(*v, &metaData)
				if err != nil {
					return err
				}
				ier.MetaData = &metaData
			}
		}
	}

	return nil
}

// IncidentEntitiesResultsMetadata information of a specific aggregation in the incident related entities
// result.
type IncidentEntitiesResultsMetadata struct {
	// Count - Total number of aggregations of the given kind in the incident related entities result.
	Count *int32 `json:"count,omitempty"`
	// EntityKind - The kind of the aggregated entity. Possible values include: 'EntityKindAccount', 'EntityKindHost', 'EntityKindFile', 'EntityKindAzureResource', 'EntityKindCloudApplication', 'EntityKindDNSResolution', 'EntityKindFileHash', 'EntityKindIP', 'EntityKindMalware', 'EntityKindProcess', 'EntityKindRegistryKey', 'EntityKindRegistryValue', 'EntityKindSecurityGroup', 'EntityKindURL', 'EntityKindIoTDevice', 'EntityKindSecurityAlert', 'EntityKindBookmark', 'EntityKindMailCluster', 'EntityKindMailMessage', 'EntityKindMailbox', 'EntityKindSubmissionMail'
	EntityKind EntityKind `json:"entityKind,omitempty"`
}

// IncidentInfo describes related incident information for the bookmark
type IncidentInfo struct {
	// IncidentID - Incident Id
	IncidentID *string `json:"incidentId,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
	// RelationName - Relation Name
	RelationName *string `json:"relationName,omitempty"`
}

// IncidentLabel represents an incident label
type IncidentLabel struct {
	// LabelName - The name of the label
	LabelName *string `json:"labelName,omitempty"`
	// LabelType - READ-ONLY; The type of the label. Possible values include: 'IncidentLabelTypeUser', 'IncidentLabelTypeSystem'
	LabelType IncidentLabelType `json:"labelType,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentLabel.
func (il IncidentLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if il.LabelName != nil {
		objectMap["labelName"] = il.LabelName
	}
	return json.Marshal(objectMap)
}

// IncidentList list all the incidents.
type IncidentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of incidents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of incidents.
	Value *[]Incident `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentList.
func (il IncidentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if il.Value != nil {
		objectMap["value"] = il.Value
	}
	return json.Marshal(objectMap)
}

// IncidentListIterator provides access to a complete listing of Incident values.
type IncidentListIterator struct {
	i    int
	page IncidentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IncidentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IncidentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IncidentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IncidentListIterator) Response() IncidentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IncidentListIterator) Value() Incident {
	if !iter.page.NotDone() {
		return Incident{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IncidentListIterator type.
func NewIncidentListIterator(page IncidentListPage) IncidentListIterator {
	return IncidentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (il IncidentList) IsEmpty() bool {
	return il.Value == nil || len(*il.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (il IncidentList) hasNextLink() bool {
	return il.NextLink != nil && len(*il.NextLink) != 0
}

// incidentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (il IncidentList) incidentListPreparer(ctx context.Context) (*http.Request, error) {
	if !il.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(il.NextLink)))
}

// IncidentListPage contains a page of Incident values.
type IncidentListPage struct {
	fn func(context.Context, IncidentList) (IncidentList, error)
	il IncidentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IncidentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IncidentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.il)
		if err != nil {
			return err
		}
		page.il = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IncidentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IncidentListPage) NotDone() bool {
	return !page.il.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IncidentListPage) Response() IncidentList {
	return page.il
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IncidentListPage) Values() []Incident {
	if page.il.IsEmpty() {
		return nil
	}
	return *page.il.Value
}

// Creates a new instance of the IncidentListPage type.
func NewIncidentListPage(cur IncidentList, getNextPage func(context.Context, IncidentList) (IncidentList, error)) IncidentListPage {
	return IncidentListPage{
		fn: getNextPage,
		il: cur,
	}
}

// IncidentOwnerInfo information on the user an incident is assigned to
type IncidentOwnerInfo struct {
	// Email - The email of the user the incident is assigned to.
	Email *string `json:"email,omitempty"`
	// AssignedTo - The name of the user the incident is assigned to.
	AssignedTo *string `json:"assignedTo,omitempty"`
	// ObjectID - The object id of the user the incident is assigned to.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// UserPrincipalName - The user principal name of the user the incident is assigned to.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
}

// IncidentProperties describes incident properties
type IncidentProperties struct {
	// AdditionalData - READ-ONLY; Additional data on the incident
	AdditionalData *IncidentAdditionalData `json:"additionalData,omitempty"`
	// Classification - The reason the incident was closed. Possible values include: 'IncidentClassificationUndetermined', 'IncidentClassificationTruePositive', 'IncidentClassificationBenignPositive', 'IncidentClassificationFalsePositive'
	Classification IncidentClassification `json:"classification,omitempty"`
	// ClassificationComment - Describes the reason the incident was closed
	ClassificationComment *string `json:"classificationComment,omitempty"`
	// ClassificationReason - The classification reason the incident was closed with. Possible values include: 'IncidentClassificationReasonSuspiciousActivity', 'IncidentClassificationReasonSuspiciousButExpected', 'IncidentClassificationReasonIncorrectAlertLogic', 'IncidentClassificationReasonInaccurateData'
	ClassificationReason IncidentClassificationReason `json:"classificationReason,omitempty"`
	// CreatedTimeUtc - READ-ONLY; The time the incident was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// Description - The description of the incident
	Description *string `json:"description,omitempty"`
	// FirstActivityTimeUtc - The time of the first activity in the incident
	FirstActivityTimeUtc *date.Time `json:"firstActivityTimeUtc,omitempty"`
	// IncidentURL - READ-ONLY; The deep-link url to the incident in Azure portal
	IncidentURL *string `json:"incidentUrl,omitempty"`
	// IncidentNumber - READ-ONLY; A sequential number
	IncidentNumber *int32 `json:"incidentNumber,omitempty"`
	// Labels - List of labels relevant to this incident
	Labels *[]IncidentLabel `json:"labels,omitempty"`
	// ProviderName - The name of the source provider that generated the incident
	ProviderName *string `json:"providerName,omitempty"`
	// ProviderIncidentID - The incident ID assigned by the incident provider
	ProviderIncidentID *string `json:"providerIncidentId,omitempty"`
	// LastActivityTimeUtc - The time of the last activity in the incident
	LastActivityTimeUtc *date.Time `json:"lastActivityTimeUtc,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; The last time the incident was updated
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// Owner - Describes a user that the incident is assigned to
	Owner *IncidentOwnerInfo `json:"owner,omitempty"`
	// RelatedAnalyticRuleIds - READ-ONLY; List of resource ids of Analytic rules related to the incident
	RelatedAnalyticRuleIds *[]string `json:"relatedAnalyticRuleIds,omitempty"`
	// Severity - The severity of the incident. Possible values include: 'IncidentSeverityHigh', 'IncidentSeverityMedium', 'IncidentSeverityLow', 'IncidentSeverityInformational'
	Severity IncidentSeverity `json:"severity,omitempty"`
	// Status - The status of the incident. Possible values include: 'IncidentStatusNew', 'IncidentStatusActive', 'IncidentStatusClosed'
	Status IncidentStatus `json:"status,omitempty"`
	// Title - The title of the incident
	Title *string `json:"title,omitempty"`
}

// MarshalJSON is the custom marshaler for IncidentProperties.
func (IP IncidentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Classification != "" {
		objectMap["classification"] = IP.Classification
	}
	if IP.ClassificationComment != nil {
		objectMap["classificationComment"] = IP.ClassificationComment
	}
	if IP.ClassificationReason != "" {
		objectMap["classificationReason"] = IP.ClassificationReason
	}
	if IP.Description != nil {
		objectMap["description"] = IP.Description
	}
	if IP.FirstActivityTimeUtc != nil {
		objectMap["firstActivityTimeUtc"] = IP.FirstActivityTimeUtc
	}
	if IP.Labels != nil {
		objectMap["labels"] = IP.Labels
	}
	if IP.ProviderName != nil {
		objectMap["providerName"] = IP.ProviderName
	}
	if IP.ProviderIncidentID != nil {
		objectMap["providerIncidentId"] = IP.ProviderIncidentID
	}
	if IP.LastActivityTimeUtc != nil {
		objectMap["lastActivityTimeUtc"] = IP.LastActivityTimeUtc
	}
	if IP.Owner != nil {
		objectMap["owner"] = IP.Owner
	}
	if IP.Severity != "" {
		objectMap["severity"] = IP.Severity
	}
	if IP.Status != "" {
		objectMap["status"] = IP.Status
	}
	if IP.Title != nil {
		objectMap["title"] = IP.Title
	}
	return json.Marshal(objectMap)
}

// InsightQueryItem represents Insight Query.
type InsightQueryItem struct {
	// Properties - Properties bag for InsightQueryItem
	Properties *InsightQueryItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Query Template ARM ID
	ID *string `json:"id,omitempty"`
	// Name - Query Template ARM Name
	Name *string `json:"name,omitempty"`
	// Type - ARM Type
	Type *string `json:"type,omitempty"`
	// Kind - The kind of the entity query. Possible values include: 'EntityQueryKindExpansion', 'EntityQueryKindInsight'
	Kind EntityQueryKind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for InsightQueryItem.
func (iqi InsightQueryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iqi.Properties != nil {
		objectMap["properties"] = iqi.Properties
	}
	if iqi.Name != nil {
		objectMap["name"] = iqi.Name
	}
	if iqi.Type != nil {
		objectMap["type"] = iqi.Type
	}
	if iqi.Kind != "" {
		objectMap["kind"] = iqi.Kind
	}
	return json.Marshal(objectMap)
}

// InsightQueryItemProperties represents Insight Query.
type InsightQueryItemProperties struct {
	// DisplayName - The insight display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The insight description.
	Description *string `json:"description,omitempty"`
	// BaseQuery - The base query of the insight.
	BaseQuery *string `json:"baseQuery,omitempty"`
	// TableQuery - The insight table query.
	TableQuery *InsightQueryItemPropertiesTableQuery `json:"tableQuery,omitempty"`
	// ChartQuery - The insight chart query.
	ChartQuery interface{} `json:"chartQuery,omitempty"`
	// AdditionalQuery - The activity query definitions.
	AdditionalQuery *InsightQueryItemPropertiesAdditionalQuery `json:"additionalQuery,omitempty"`
	// DefaultTimeRange - The insight chart query.
	DefaultTimeRange *InsightQueryItemPropertiesDefaultTimeRange `json:"defaultTimeRange,omitempty"`
	// ReferenceTimeRange - The insight chart query.
	ReferenceTimeRange *InsightQueryItemPropertiesReferenceTimeRange `json:"referenceTimeRange,omitempty"`
	// DataTypes - Data types for template
	DataTypes *[]EntityQueryItemPropertiesDataTypesItem `json:"dataTypes,omitempty"`
	// InputEntityType - The type of the entity. Possible values include: 'EntityTypeAccount', 'EntityTypeHost', 'EntityTypeFile', 'EntityTypeAzureResource', 'EntityTypeCloudApplication', 'EntityTypeDNS', 'EntityTypeFileHash', 'EntityTypeIP', 'EntityTypeMalware', 'EntityTypeProcess', 'EntityTypeRegistryKey', 'EntityTypeRegistryValue', 'EntityTypeSecurityGroup', 'EntityTypeURL', 'EntityTypeIoTDevice', 'EntityTypeSecurityAlert', 'EntityTypeHuntingBookmark', 'EntityTypeMailCluster', 'EntityTypeMailMessage', 'EntityTypeMailbox', 'EntityTypeSubmissionMail'
	InputEntityType EntityType `json:"inputEntityType,omitempty"`
	// RequiredInputFieldsSets - Data types for template
	RequiredInputFieldsSets *[][]string `json:"requiredInputFieldsSets,omitempty"`
	// EntitiesFilter - The query applied only to entities matching to all filters
	EntitiesFilter interface{} `json:"entitiesFilter,omitempty"`
}

// InsightQueryItemPropertiesAdditionalQuery the activity query definitions.
type InsightQueryItemPropertiesAdditionalQuery struct {
	// Query - The insight query.
	Query *string `json:"query,omitempty"`
	// Text - The insight text.
	Text *string `json:"text,omitempty"`
}

// InsightQueryItemPropertiesDefaultTimeRange the insight chart query.
type InsightQueryItemPropertiesDefaultTimeRange struct {
	// BeforeRange - The padding for the start time of the query.
	BeforeRange *string `json:"beforeRange,omitempty"`
	// AfterRange - The padding for the end time of the query.
	AfterRange *string `json:"afterRange,omitempty"`
}

// InsightQueryItemPropertiesReferenceTimeRange the insight chart query.
type InsightQueryItemPropertiesReferenceTimeRange struct {
	// BeforeRange - Additional query time for looking back.
	BeforeRange *string `json:"beforeRange,omitempty"`
}

// InsightQueryItemPropertiesTableQuery the insight table query.
type InsightQueryItemPropertiesTableQuery struct {
	// ColumnsDefinitions - List of insight column definitions.
	ColumnsDefinitions *[]InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem `json:"columnsDefinitions,omitempty"`
	// QueriesDefinitions - List of insight queries definitions.
	QueriesDefinitions *[]InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem `json:"queriesDefinitions,omitempty"`
}

// InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem ...
type InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem struct {
	// Header - Insight column header.
	Header *string `json:"header,omitempty"`
	// OutputType - Insights Column type. Possible values include: 'OutputTypeNumber', 'OutputTypeString', 'OutputTypeDate', 'OutputTypeEntity'
	OutputType OutputType `json:"outputType,omitempty"`
	// SupportDeepLink - Is query supports deep-link.
	SupportDeepLink *bool `json:"supportDeepLink,omitempty"`
}

// InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem ...
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem struct {
	// Filter - Insight column header.
	Filter *string `json:"filter,omitempty"`
	// Summarize - Insight column header.
	Summarize *string `json:"summarize,omitempty"`
	// Project - Insight column header.
	Project *string `json:"project,omitempty"`
	// LinkColumnsDefinitions - Insight column header.
	LinkColumnsDefinitions *[]InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem `json:"linkColumnsDefinitions,omitempty"`
}

// InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem ...
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem struct {
	// ProjectedName - Insight Link Definition Projected Name.
	ProjectedName *string `json:"projectedName,omitempty"`
	// Query - Insight Link Definition Query.
	Query *string `json:"Query,omitempty"`
}

// InsightsTableResult query results for table insights query.
type InsightsTableResult struct {
	// Columns - Columns Metadata of the table
	Columns *[]InsightsTableResultColumnsItem `json:"columns,omitempty"`
	// Rows - Rows data of the table
	Rows *[][]string `json:"rows,omitempty"`
}

// InsightsTableResultColumnsItem ...
type InsightsTableResultColumnsItem struct {
	// Type - the type of the colum
	Type *string `json:"type,omitempty"`
	// Name - the name of the colum
	Name *string `json:"name,omitempty"`
}

// IoTDeviceEntity represents an IoT device entity.
type IoTDeviceEntity struct {
	// IoTDeviceEntityProperties - IoTDevice entity properties
	*IoTDeviceEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTDeviceEntity.
func (itde IoTDeviceEntity) MarshalJSON() ([]byte, error) {
	itde.Kind = KindBasicEntityKindIoTDevice
	objectMap := make(map[string]interface{})
	if itde.IoTDeviceEntityProperties != nil {
		objectMap["properties"] = itde.IoTDeviceEntityProperties
	}
	if itde.Kind != "" {
		objectMap["kind"] = itde.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return &itde, true
}

// AsEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for IoTDeviceEntity.
func (itde IoTDeviceEntity) AsBasicEntity() (BasicEntity, bool) {
	return &itde, true
}

// UnmarshalJSON is the custom unmarshaler for IoTDeviceEntity struct.
func (itde *IoTDeviceEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTDeviceEntityProperties IoTDeviceEntityProperties
				err = json.Unmarshal(*v, &ioTDeviceEntityProperties)
				if err != nil {
					return err
				}
				itde.IoTDeviceEntityProperties = &ioTDeviceEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itde.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				itde.Kind = kind
			}
		}
	}

	return nil
}

// IoTDeviceEntityProperties ioTDevice entity property bag.
type IoTDeviceEntityProperties struct {
	// DeviceID - READ-ONLY; The ID of the IoT Device in the IoT Hub
	DeviceID *string `json:"deviceId,omitempty"`
	// DeviceName - READ-ONLY; The friendly name of the device
	DeviceName *string `json:"deviceName,omitempty"`
	// Source - READ-ONLY; The source of the device
	Source *string `json:"source,omitempty"`
	// IotSecurityAgentID - READ-ONLY; The ID of the security agent running on the device
	IotSecurityAgentID *uuid.UUID `json:"iotSecurityAgentId,omitempty"`
	// DeviceType - READ-ONLY; The type of the device
	DeviceType *string `json:"deviceType,omitempty"`
	// Vendor - READ-ONLY; The vendor of the device
	Vendor *string `json:"vendor,omitempty"`
	// EdgeID - READ-ONLY; The ID of the edge device
	EdgeID *string `json:"edgeId,omitempty"`
	// MacAddress - READ-ONLY; The MAC address of the device
	MacAddress *string `json:"macAddress,omitempty"`
	// Model - READ-ONLY; The model of the device
	Model *string `json:"model,omitempty"`
	// SerialNumber - READ-ONLY; The serial number of the device
	SerialNumber *string `json:"serialNumber,omitempty"`
	// FirmwareVersion - READ-ONLY; The firmware version of the device
	FirmwareVersion *string `json:"firmwareVersion,omitempty"`
	// OperatingSystem - READ-ONLY; The operating system of the device
	OperatingSystem *string `json:"operatingSystem,omitempty"`
	// IotHubEntityID - READ-ONLY; The AzureResource entity id of the IoT Hub
	IotHubEntityID *string `json:"iotHubEntityId,omitempty"`
	// HostEntityID - READ-ONLY; The Host entity id of this device
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// IPAddressEntityID - READ-ONLY; The IP entity if of this device
	IPAddressEntityID *string `json:"ipAddressEntityId,omitempty"`
	// ThreatIntelligence - READ-ONLY; A list of TI contexts attached to the IoTDevice entity.
	ThreatIntelligence *[]ThreatIntelligence `json:"threatIntelligence,omitempty"`
	// Protocols - READ-ONLY; A list of protocols of the IoTDevice entity.
	Protocols *[]string `json:"protocols,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTDeviceEntityProperties.
func (itdep IoTDeviceEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPEntity represents an ip entity.
type IPEntity struct {
	// IPEntityProperties - Ip entity properties
	*IPEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IPEntity.
func (ie IPEntity) MarshalJSON() ([]byte, error) {
	ie.Kind = KindBasicEntityKindIP
	objectMap := make(map[string]interface{})
	if ie.IPEntityProperties != nil {
		objectMap["properties"] = ie.IPEntityProperties
	}
	if ie.Kind != "" {
		objectMap["kind"] = ie.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsIPEntity() (*IPEntity, bool) {
	return &ie, true
}

// AsMailboxEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for IPEntity.
func (ie IPEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ie, true
}

// UnmarshalJSON is the custom unmarshaler for IPEntity struct.
func (ie *IPEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPEntityProperties IPEntityProperties
				err = json.Unmarshal(*v, &IPEntityProperties)
				if err != nil {
					return err
				}
				ie.IPEntityProperties = &IPEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ie.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ie.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ie.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ie.Kind = kind
			}
		}
	}

	return nil
}

// IPEntityProperties ip entity property bag.
type IPEntityProperties struct {
	// Address - READ-ONLY; The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6)
	Address *string `json:"address,omitempty"`
	// Location - The geo-location context attached to the ip entity
	Location *GeoLocation `json:"location,omitempty"`
	// ThreatIntelligence - READ-ONLY; A list of TI contexts attached to the ip entity.
	ThreatIntelligence *[]ThreatIntelligence `json:"threatIntelligence,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for IPEntityProperties.
func (iep IPEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iep.Location != nil {
		objectMap["location"] = iep.Location
	}
	return json.Marshal(objectMap)
}

// IPSyncer settings with single toggle.
type IPSyncer struct {
	// IPSyncerSettingsProperties - IPSyncer properties
	*IPSyncerSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindIPSyncer', 'KindBasicSettingsKindEyesOn', 'KindBasicSettingsKindEntityAnalytics', 'KindBasicSettingsKindUeba'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for IPSyncer.
func (is IPSyncer) MarshalJSON() ([]byte, error) {
	is.Kind = KindBasicSettingsKindIPSyncer
	objectMap := make(map[string]interface{})
	if is.IPSyncerSettingsProperties != nil {
		objectMap["properties"] = is.IPSyncerSettingsProperties
	}
	if is.Etag != nil {
		objectMap["etag"] = is.Etag
	}
	if is.Kind != "" {
		objectMap["kind"] = is.Kind
	}
	return json.Marshal(objectMap)
}

// AsIPSyncer is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsIPSyncer() (*IPSyncer, bool) {
	return &is, true
}

// AsEyesOn is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsEyesOn() (*EyesOn, bool) {
	return nil, false
}

// AsEntityAnalytics is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsEntityAnalytics() (*EntityAnalytics, bool) {
	return nil, false
}

// AsUeba is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsUeba() (*Ueba, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for IPSyncer.
func (is IPSyncer) AsBasicSettings() (BasicSettings, bool) {
	return &is, true
}

// UnmarshalJSON is the custom unmarshaler for IPSyncer struct.
func (is *IPSyncer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var IPSyncerSettingsProperties IPSyncerSettingsProperties
				err = json.Unmarshal(*v, &IPSyncerSettingsProperties)
				if err != nil {
					return err
				}
				is.IPSyncerSettingsProperties = &IPSyncerSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				is.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				is.Kind = kind
			}
		}
	}

	return nil
}

// IPSyncerSettingsProperties iPSyncer property bag.
type IPSyncerSettingsProperties struct {
	// IsEnabled - READ-ONLY; Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for IPSyncerSettingsProperties.
func (issp IPSyncerSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MailboxEntity represents a mailbox entity.
type MailboxEntity struct {
	// MailboxEntityProperties - Mailbox entity properties
	*MailboxEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MailboxEntity.
func (me MailboxEntity) MarshalJSON() ([]byte, error) {
	me.Kind = KindBasicEntityKindMailbox
	objectMap := make(map[string]interface{})
	if me.MailboxEntityProperties != nil {
		objectMap["properties"] = me.MailboxEntityProperties
	}
	if me.Kind != "" {
		objectMap["kind"] = me.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return &me, true
}

// AsMailClusterEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for MailboxEntity.
func (me MailboxEntity) AsBasicEntity() (BasicEntity, bool) {
	return &me, true
}

// UnmarshalJSON is the custom unmarshaler for MailboxEntity struct.
func (me *MailboxEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mailboxEntityProperties MailboxEntityProperties
				err = json.Unmarshal(*v, &mailboxEntityProperties)
				if err != nil {
					return err
				}
				me.MailboxEntityProperties = &mailboxEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				me.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				me.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				me.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				me.Kind = kind
			}
		}
	}

	return nil
}

// MailboxEntityProperties mailbox entity property bag.
type MailboxEntityProperties struct {
	// MailboxPrimaryAddress - READ-ONLY; The mailbox's primary address
	MailboxPrimaryAddress *string `json:"mailboxPrimaryAddress,omitempty"`
	// DisplayName - READ-ONLY; The mailbox's display name
	DisplayName *string `json:"displayName,omitempty"`
	// Upn - READ-ONLY; The mailbox's UPN
	Upn *string `json:"upn,omitempty"`
	// ExternalDirectoryObjectID - READ-ONLY; The AzureAD identifier of mailbox. Similar to AadUserId in account entity but this property is specific to mailbox object on office side
	ExternalDirectoryObjectID *uuid.UUID `json:"externalDirectoryObjectId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for MailboxEntityProperties.
func (mep MailboxEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MailClusterEntity represents a mail cluster entity.
type MailClusterEntity struct {
	// MailClusterEntityProperties - Mail cluster entity properties
	*MailClusterEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MailClusterEntity.
func (mce MailClusterEntity) MarshalJSON() ([]byte, error) {
	mce.Kind = KindBasicEntityKindMailCluster
	objectMap := make(map[string]interface{})
	if mce.MailClusterEntityProperties != nil {
		objectMap["properties"] = mce.MailClusterEntityProperties
	}
	if mce.Kind != "" {
		objectMap["kind"] = mce.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return &mce, true
}

// AsMailMessageEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for MailClusterEntity.
func (mce MailClusterEntity) AsBasicEntity() (BasicEntity, bool) {
	return &mce, true
}

// UnmarshalJSON is the custom unmarshaler for MailClusterEntity struct.
func (mce *MailClusterEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mailClusterEntityProperties MailClusterEntityProperties
				err = json.Unmarshal(*v, &mailClusterEntityProperties)
				if err != nil {
					return err
				}
				mce.MailClusterEntityProperties = &mailClusterEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mce.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mce.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mce.Kind = kind
			}
		}
	}

	return nil
}

// MailClusterEntityProperties mail cluster entity property bag.
type MailClusterEntityProperties struct {
	// NetworkMessageIds - READ-ONLY; The mail message IDs that are part of the mail cluster
	NetworkMessageIds *[]string `json:"networkMessageIds,omitempty"`
	// CountByDeliveryStatus - READ-ONLY; Count of mail messages by DeliveryStatus string representation
	CountByDeliveryStatus interface{} `json:"countByDeliveryStatus,omitempty"`
	// CountByThreatType - READ-ONLY; Count of mail messages by ThreatType string representation
	CountByThreatType interface{} `json:"countByThreatType,omitempty"`
	// CountByProtectionStatus - READ-ONLY; Count of mail messages by ProtectionStatus string representation
	CountByProtectionStatus interface{} `json:"countByProtectionStatus,omitempty"`
	// Threats - READ-ONLY; The threats of mail messages that are part of the mail cluster
	Threats *[]string `json:"threats,omitempty"`
	// Query - READ-ONLY; The query that was used to identify the messages of the mail cluster
	Query *string `json:"query,omitempty"`
	// QueryTime - READ-ONLY; The query time
	QueryTime *date.Time `json:"queryTime,omitempty"`
	// MailCount - READ-ONLY; The number of mail messages that are part of the mail cluster
	MailCount *int32 `json:"mailCount,omitempty"`
	// IsVolumeAnomaly - READ-ONLY; Is this a volume anomaly mail cluster
	IsVolumeAnomaly *bool `json:"isVolumeAnomaly,omitempty"`
	// Source - READ-ONLY; The source of the mail cluster (default is 'O365 ATP')
	Source *string `json:"source,omitempty"`
	// ClusterSourceIdentifier - READ-ONLY; The id of the cluster source
	ClusterSourceIdentifier *string `json:"clusterSourceIdentifier,omitempty"`
	// ClusterSourceType - READ-ONLY; The type of the cluster source
	ClusterSourceType *string `json:"clusterSourceType,omitempty"`
	// ClusterQueryStartTime - READ-ONLY; The cluster query start time
	ClusterQueryStartTime *date.Time `json:"clusterQueryStartTime,omitempty"`
	// ClusterQueryEndTime - READ-ONLY; The cluster query end time
	ClusterQueryEndTime *date.Time `json:"clusterQueryEndTime,omitempty"`
	// ClusterGroup - READ-ONLY; The cluster group
	ClusterGroup *string `json:"clusterGroup,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for MailClusterEntityProperties.
func (mcep MailClusterEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MailMessageEntity represents a mail message entity.
type MailMessageEntity struct {
	// MailMessageEntityProperties - Mail message entity properties
	*MailMessageEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MailMessageEntity.
func (mme MailMessageEntity) MarshalJSON() ([]byte, error) {
	mme.Kind = KindBasicEntityKindMailMessage
	objectMap := make(map[string]interface{})
	if mme.MailMessageEntityProperties != nil {
		objectMap["properties"] = mme.MailMessageEntityProperties
	}
	if mme.Kind != "" {
		objectMap["kind"] = mme.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return &mme, true
}

// AsSubmissionMailEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for MailMessageEntity.
func (mme MailMessageEntity) AsBasicEntity() (BasicEntity, bool) {
	return &mme, true
}

// UnmarshalJSON is the custom unmarshaler for MailMessageEntity struct.
func (mme *MailMessageEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mailMessageEntityProperties MailMessageEntityProperties
				err = json.Unmarshal(*v, &mailMessageEntityProperties)
				if err != nil {
					return err
				}
				mme.MailMessageEntityProperties = &mailMessageEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mme.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mme.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mme.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mme.Kind = kind
			}
		}
	}

	return nil
}

// MailMessageEntityProperties mail message entity property bag.
type MailMessageEntityProperties struct {
	// FileEntityIds - READ-ONLY; The File entity ids of this mail message's attachments
	FileEntityIds *[]string `json:"fileEntityIds,omitempty"`
	// Recipient - READ-ONLY; The recipient of this mail message. Note that in case of multiple recipients the mail message is forked and each copy has one recipient
	Recipient *string `json:"recipient,omitempty"`
	// Urls - READ-ONLY; The Urls contained in this mail message
	Urls *[]string `json:"urls,omitempty"`
	// Threats - READ-ONLY; The threats of this mail message
	Threats *[]string `json:"threats,omitempty"`
	// P1Sender - READ-ONLY; The p1 sender's email address
	P1Sender *string `json:"p1Sender,omitempty"`
	// P1SenderDisplayName - READ-ONLY; The p1 sender's display name
	P1SenderDisplayName *string `json:"p1SenderDisplayName,omitempty"`
	// P1SenderDomain - READ-ONLY; The p1 sender's domain
	P1SenderDomain *string `json:"p1SenderDomain,omitempty"`
	// SenderIP - READ-ONLY; The sender's IP address
	SenderIP *string `json:"senderIP,omitempty"`
	// P2Sender - READ-ONLY; The p2 sender's email address
	P2Sender *string `json:"p2Sender,omitempty"`
	// P2SenderDisplayName - READ-ONLY; The p2 sender's display name
	P2SenderDisplayName *string `json:"p2SenderDisplayName,omitempty"`
	// P2SenderDomain - READ-ONLY; The p2 sender's domain
	P2SenderDomain *string `json:"p2SenderDomain,omitempty"`
	// ReceiveDate - READ-ONLY; The receive date of this message
	ReceiveDate *date.Time `json:"receiveDate,omitempty"`
	// NetworkMessageID - READ-ONLY; The network message id of this mail message
	NetworkMessageID *uuid.UUID `json:"networkMessageId,omitempty"`
	// InternetMessageID - READ-ONLY; The internet message id of this mail message
	InternetMessageID *string `json:"internetMessageId,omitempty"`
	// Subject - READ-ONLY; The subject of this mail message
	Subject *string `json:"subject,omitempty"`
	// Language - READ-ONLY; The language of this mail message
	Language *string `json:"language,omitempty"`
	// ThreatDetectionMethods - READ-ONLY; The threat detection methods
	ThreatDetectionMethods *[]string `json:"threatDetectionMethods,omitempty"`
	// BodyFingerprintBin1 - The bodyFingerprintBin1
	BodyFingerprintBin1 *int32 `json:"bodyFingerprintBin1,omitempty"`
	// BodyFingerprintBin2 - The bodyFingerprintBin2
	BodyFingerprintBin2 *int32 `json:"bodyFingerprintBin2,omitempty"`
	// BodyFingerprintBin3 - The bodyFingerprintBin3
	BodyFingerprintBin3 *int32 `json:"bodyFingerprintBin3,omitempty"`
	// BodyFingerprintBin4 - The bodyFingerprintBin4
	BodyFingerprintBin4 *int32 `json:"bodyFingerprintBin4,omitempty"`
	// BodyFingerprintBin5 - The bodyFingerprintBin5
	BodyFingerprintBin5 *int32 `json:"bodyFingerprintBin5,omitempty"`
	// AntispamDirection - The directionality of this mail message. Possible values include: 'AntispamMailDirectionUnknown', 'AntispamMailDirectionInbound', 'AntispamMailDirectionOutbound', 'AntispamMailDirectionIntraorg'
	AntispamDirection AntispamMailDirection `json:"antispamDirection,omitempty"`
	// DeliveryAction - The delivery action of this mail message like Delivered, Blocked, Replaced etc. Possible values include: 'DeliveryActionUnknown', 'DeliveryActionDeliveredAsSpam', 'DeliveryActionDelivered', 'DeliveryActionBlocked', 'DeliveryActionReplaced'
	DeliveryAction DeliveryAction `json:"deliveryAction,omitempty"`
	// DeliveryLocation - The delivery location of this mail message like Inbox, JunkFolder etc. Possible values include: 'DeliveryLocationUnknown', 'DeliveryLocationInbox', 'DeliveryLocationJunkFolder', 'DeliveryLocationDeletedFolder', 'DeliveryLocationQuarantine', 'DeliveryLocationExternal', 'DeliveryLocationFailed', 'DeliveryLocationDropped', 'DeliveryLocationForwarded'
	DeliveryLocation DeliveryLocation `json:"deliveryLocation,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for MailMessageEntityProperties.
func (mmep MailMessageEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmep.BodyFingerprintBin1 != nil {
		objectMap["bodyFingerprintBin1"] = mmep.BodyFingerprintBin1
	}
	if mmep.BodyFingerprintBin2 != nil {
		objectMap["bodyFingerprintBin2"] = mmep.BodyFingerprintBin2
	}
	if mmep.BodyFingerprintBin3 != nil {
		objectMap["bodyFingerprintBin3"] = mmep.BodyFingerprintBin3
	}
	if mmep.BodyFingerprintBin4 != nil {
		objectMap["bodyFingerprintBin4"] = mmep.BodyFingerprintBin4
	}
	if mmep.BodyFingerprintBin5 != nil {
		objectMap["bodyFingerprintBin5"] = mmep.BodyFingerprintBin5
	}
	if mmep.AntispamDirection != "" {
		objectMap["antispamDirection"] = mmep.AntispamDirection
	}
	if mmep.DeliveryAction != "" {
		objectMap["deliveryAction"] = mmep.DeliveryAction
	}
	if mmep.DeliveryLocation != "" {
		objectMap["deliveryLocation"] = mmep.DeliveryLocation
	}
	return json.Marshal(objectMap)
}

// MalwareEntity represents a malware entity.
type MalwareEntity struct {
	// MalwareEntityProperties - File entity properties
	*MalwareEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MalwareEntity.
func (me MalwareEntity) MarshalJSON() ([]byte, error) {
	me.Kind = KindBasicEntityKindMalware
	objectMap := make(map[string]interface{})
	if me.MalwareEntityProperties != nil {
		objectMap["properties"] = me.MalwareEntityProperties
	}
	if me.Kind != "" {
		objectMap["kind"] = me.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return &me, true
}

// AsProcessEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for MalwareEntity.
func (me MalwareEntity) AsBasicEntity() (BasicEntity, bool) {
	return &me, true
}

// UnmarshalJSON is the custom unmarshaler for MalwareEntity struct.
func (me *MalwareEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var malwareEntityProperties MalwareEntityProperties
				err = json.Unmarshal(*v, &malwareEntityProperties)
				if err != nil {
					return err
				}
				me.MalwareEntityProperties = &malwareEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				me.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				me.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				me.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				me.Kind = kind
			}
		}
	}

	return nil
}

// MalwareEntityProperties malware entity property bag.
type MalwareEntityProperties struct {
	// Category - READ-ONLY; The malware category by the vendor, e.g. Trojan
	Category *string `json:"category,omitempty"`
	// FileEntityIds - READ-ONLY; List of linked file entity identifiers on which the malware was found
	FileEntityIds *[]string `json:"fileEntityIds,omitempty"`
	// MalwareName - READ-ONLY; The malware name by the vendor, e.g. Win32/Toga!rfn
	MalwareName *string `json:"malwareName,omitempty"`
	// ProcessEntityIds - READ-ONLY; List of linked process entity identifiers on which the malware was found.
	ProcessEntityIds *[]string `json:"processEntityIds,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for MalwareEntityProperties.
func (mep MalwareEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MCASCheckRequirements represents MCAS (Microsoft Cloud App Security) requirements check request.
type MCASCheckRequirements struct {
	// MCASCheckRequirementsProperties - MCAS (Microsoft Cloud App Security) requirements check properties.
	*MCASCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASCheckRequirements.
func (mcr MCASCheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mcr.MCASCheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MCASCheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return &mcr, true
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MCASCheckRequirements.
func (mcr MCASCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MCASCheckRequirements struct.
func (mcr *MCASCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASCheckRequirementsProperties MCASCheckRequirementsProperties
				err = json.Unmarshal(*v, &mCASCheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MCASCheckRequirementsProperties = &mCASCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MCASCheckRequirementsProperties MCAS (Microsoft Cloud App Security) requirements check properties.
type MCASCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MCASDataConnector represents MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnector struct {
	// MCASDataConnectorProperties - MCAS (Microsoft Cloud App Security) data connector properties.
	*MCASDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASDataConnector.
func (mdc MCASDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mdc.MCASDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MCASDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return &mdc, true
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MCASDataConnector struct.
func (mdc *MCASDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASDataConnectorProperties MCASDataConnectorProperties
				err = json.Unmarshal(*v, &mCASDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MCASDataConnectorProperties = &mCASDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MCASDataConnectorDataTypes the available data types for MCAS (Microsoft Cloud App Security) data
// connector.
type MCASDataConnectorDataTypes struct {
	// DiscoveryLogs - Discovery log data type connection.
	DiscoveryLogs *MCASDataConnectorDataTypesDiscoveryLogs `json:"discoveryLogs,omitempty"`
	// Alerts - Alerts data type connection.
	Alerts *AlertsDataTypeOfDataConnectorAlerts `json:"alerts,omitempty"`
}

// MCASDataConnectorDataTypesDiscoveryLogs discovery log data type connection.
type MCASDataConnectorDataTypesDiscoveryLogs struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// MCASDataConnectorProperties MCAS (Microsoft Cloud App Security) data connector properties.
type MCASDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *MCASDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MDATPCheckRequirements represents MDATP (Microsoft Defender Advanced Threat Protection) requirements
// check request.
type MDATPCheckRequirements struct {
	// MDATPCheckRequirementsProperties - MDATP (Microsoft Defender Advanced Threat Protection) requirements check properties.
	*MDATPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if mcr.MDATPCheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MDATPCheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return &mcr, true
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MDATPCheckRequirements.
func (mcr MDATPCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MDATPCheckRequirements struct.
func (mcr *MDATPCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mDATPCheckRequirementsProperties MDATPCheckRequirementsProperties
				err = json.Unmarshal(*v, &mDATPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MDATPCheckRequirementsProperties = &mDATPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MDATPCheckRequirementsProperties MDATP (Microsoft Defender Advanced Threat Protection) requirements
// check properties.
type MDATPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MDATPDataConnector represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
type MDATPDataConnector struct {
	// MDATPDataConnectorProperties - MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.
	*MDATPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MDATPDataConnector.
func (mdc MDATPDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	objectMap := make(map[string]interface{})
	if mdc.MDATPDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MDATPDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return &mdc, true
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MDATPDataConnector.
func (mdc MDATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MDATPDataConnector struct.
func (mdc *MDATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mDATPDataConnectorProperties MDATPDataConnectorProperties
				err = json.Unmarshal(*v, &mDATPDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MDATPDataConnectorProperties = &mDATPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MDATPDataConnectorProperties MDATP (Microsoft Defender Advanced Threat Protection) data connector
// properties.
type MDATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRule represents MicrosoftSecurityIncidentCreation rule.
type MicrosoftSecurityIncidentCreationAlertRule struct {
	// MicrosoftSecurityIncidentCreationAlertRuleProperties - MicrosoftSecurityIncidentCreation rule properties
	*MicrosoftSecurityIncidentCreationAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) MarshalJSON() ([]byte, error) {
	msicar.Kind = KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties != nil {
		objectMap["properties"] = msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties
	}
	if msicar.Etag != nil {
		objectMap["etag"] = msicar.Etag
	}
	if msicar.Kind != "" {
		objectMap["kind"] = msicar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return nil, false
}

// AsFusionAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return &msicar, true
}

// AsScheduledAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for MicrosoftSecurityIncidentCreationAlertRule.
func (msicar MicrosoftSecurityIncidentCreationAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &msicar, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRule struct.
func (msicar *MicrosoftSecurityIncidentCreationAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleProperties MicrosoftSecurityIncidentCreationAlertRuleProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleProperties)
				if err != nil {
					return err
				}
				msicar.MicrosoftSecurityIncidentCreationAlertRuleProperties = &microsoftSecurityIncidentCreationAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				msicar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicar.Kind = kind
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleCommonProperties microsoftSecurityIncidentCreation rule common
// property bag.
type MicrosoftSecurityIncidentCreationAlertRuleCommonProperties struct {
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT', 'MicrosoftSecurityProductNameOffice365AdvancedThreatProtection', 'MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MicrosoftSecurityIncidentCreationAlertRuleProperties microsoftSecurityIncidentCreation rule property
// bag.
type MicrosoftSecurityIncidentCreationAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT', 'MicrosoftSecurityProductNameOffice365AdvancedThreatProtection', 'MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleProperties.
func (msicarp MicrosoftSecurityIncidentCreationAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msicarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = msicarp.AlertRuleTemplateName
	}
	if msicarp.Description != nil {
		objectMap["description"] = msicarp.Description
	}
	if msicarp.DisplayName != nil {
		objectMap["displayName"] = msicarp.DisplayName
	}
	if msicarp.Enabled != nil {
		objectMap["enabled"] = msicarp.Enabled
	}
	if msicarp.DisplayNamesFilter != nil {
		objectMap["displayNamesFilter"] = msicarp.DisplayNamesFilter
	}
	if msicarp.DisplayNamesExcludeFilter != nil {
		objectMap["displayNamesExcludeFilter"] = msicarp.DisplayNamesExcludeFilter
	}
	if msicarp.ProductFilter != "" {
		objectMap["productFilter"] = msicarp.ProductFilter
	}
	if msicarp.SeveritiesFilter != nil {
		objectMap["severitiesFilter"] = msicarp.SeveritiesFilter
	}
	return json.Marshal(objectMap)
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplate represents MicrosoftSecurityIncidentCreation rule
// template.
type MicrosoftSecurityIncidentCreationAlertRuleTemplate struct {
	// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties - MicrosoftSecurityIncidentCreation rule template properties
	*MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	msicart.Kind = KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation
	objectMap := make(map[string]interface{})
	if msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties != nil {
		objectMap["properties"] = msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
	}
	if msicart.Kind != "" {
		objectMap["kind"] = msicart.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return nil, false
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return &msicart, true
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &msicart, true
}

// UnmarshalJSON is the custom unmarshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplate struct.
func (msicart *MicrosoftSecurityIncidentCreationAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var microsoftSecurityIncidentCreationAlertRuleTemplateProperties MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &microsoftSecurityIncidentCreationAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				msicart.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties = &microsoftSecurityIncidentCreationAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msicart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msicart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msicart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				msicart.Kind = kind
			}
		}
	}

	return nil
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties microsoftSecurityIncidentCreation rule
// template properties
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// DisplayNamesFilter - the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter *[]string `json:"displayNamesFilter,omitempty"`
	// DisplayNamesExcludeFilter - the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter *[]string `json:"displayNamesExcludeFilter,omitempty"`
	// ProductFilter - The alerts' productName on which the cases will be generated. Possible values include: 'MicrosoftSecurityProductNameMicrosoftCloudAppSecurity', 'MicrosoftSecurityProductNameAzureSecurityCenter', 'MicrosoftSecurityProductNameAzureAdvancedThreatProtection', 'MicrosoftSecurityProductNameAzureActiveDirectoryIdentityProtection', 'MicrosoftSecurityProductNameAzureSecurityCenterforIoT', 'MicrosoftSecurityProductNameOffice365AdvancedThreatProtection', 'MicrosoftSecurityProductNameMicrosoftDefenderAdvancedThreatProtection'
	ProductFilter MicrosoftSecurityProductName `json:"productFilter,omitempty"`
	// SeveritiesFilter - the alerts' severities on which the cases will be generated
	SeveritiesFilter *[]AlertSeverity `json:"severitiesFilter,omitempty"`
}

// MarshalJSON is the custom marshaler for MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties.
func (msicart MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msicart.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = msicart.AlertRulesCreatedByTemplateCount
	}
	if msicart.Description != nil {
		objectMap["description"] = msicart.Description
	}
	if msicart.DisplayName != nil {
		objectMap["displayName"] = msicart.DisplayName
	}
	if msicart.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = msicart.RequiredDataConnectors
	}
	if msicart.Status != "" {
		objectMap["status"] = msicart.Status
	}
	if msicart.DisplayNamesFilter != nil {
		objectMap["displayNamesFilter"] = msicart.DisplayNamesFilter
	}
	if msicart.DisplayNamesExcludeFilter != nil {
		objectMap["displayNamesExcludeFilter"] = msicart.DisplayNamesExcludeFilter
	}
	if msicart.ProductFilter != "" {
		objectMap["productFilter"] = msicart.ProductFilter
	}
	if msicart.SeveritiesFilter != nil {
		objectMap["severitiesFilter"] = msicart.SeveritiesFilter
	}
	return json.Marshal(objectMap)
}

// MLBehaviorAnalyticsAlertRule represents MLBehaviorAnalytics alert rule.
type MLBehaviorAnalyticsAlertRule struct {
	// MLBehaviorAnalyticsAlertRuleProperties - MLBehaviorAnalytics alert rule properties
	*MLBehaviorAnalyticsAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) MarshalJSON() ([]byte, error) {
	mbaar.Kind = KindBasicAlertRuleKindMLBehaviorAnalytics
	objectMap := make(map[string]interface{})
	if mbaar.MLBehaviorAnalyticsAlertRuleProperties != nil {
		objectMap["properties"] = mbaar.MLBehaviorAnalyticsAlertRuleProperties
	}
	if mbaar.Etag != nil {
		objectMap["etag"] = mbaar.Etag
	}
	if mbaar.Kind != "" {
		objectMap["kind"] = mbaar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return &mbaar, true
}

// AsFusionAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for MLBehaviorAnalyticsAlertRule.
func (mbaar MLBehaviorAnalyticsAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &mbaar, true
}

// UnmarshalJSON is the custom unmarshaler for MLBehaviorAnalyticsAlertRule struct.
func (mbaar *MLBehaviorAnalyticsAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mLBehaviorAnalyticsAlertRuleProperties MLBehaviorAnalyticsAlertRuleProperties
				err = json.Unmarshal(*v, &mLBehaviorAnalyticsAlertRuleProperties)
				if err != nil {
					return err
				}
				mbaar.MLBehaviorAnalyticsAlertRuleProperties = &mLBehaviorAnalyticsAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbaar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbaar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbaar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mbaar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mbaar.Kind = kind
			}
		}
	}

	return nil
}

// MLBehaviorAnalyticsAlertRuleProperties mLBehaviorAnalytics alert rule base property bag.
type MLBehaviorAnalyticsAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - READ-ONLY; The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert rule has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Severity - READ-ONLY; The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for MLBehaviorAnalyticsAlertRuleProperties.
func (mbaarp MLBehaviorAnalyticsAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbaarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = mbaarp.AlertRuleTemplateName
	}
	if mbaarp.Enabled != nil {
		objectMap["enabled"] = mbaarp.Enabled
	}
	return json.Marshal(objectMap)
}

// MLBehaviorAnalyticsAlertRuleTemplate represents MLBehaviorAnalytics alert rule template.
type MLBehaviorAnalyticsAlertRuleTemplate struct {
	// MLBehaviorAnalyticsAlertRuleTemplateProperties - MLBehaviorAnalytics alert rule template properties.
	*MLBehaviorAnalyticsAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	mbaart.Kind = KindBasicAlertRuleTemplateKindMLBehaviorAnalytics
	objectMap := make(map[string]interface{})
	if mbaart.MLBehaviorAnalyticsAlertRuleTemplateProperties != nil {
		objectMap["properties"] = mbaart.MLBehaviorAnalyticsAlertRuleTemplateProperties
	}
	if mbaart.Kind != "" {
		objectMap["kind"] = mbaart.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return &mbaart, true
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for MLBehaviorAnalyticsAlertRuleTemplate.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &mbaart, true
}

// UnmarshalJSON is the custom unmarshaler for MLBehaviorAnalyticsAlertRuleTemplate struct.
func (mbaart *MLBehaviorAnalyticsAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mLBehaviorAnalyticsAlertRuleTemplateProperties MLBehaviorAnalyticsAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &mLBehaviorAnalyticsAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				mbaart.MLBehaviorAnalyticsAlertRuleTemplateProperties = &mLBehaviorAnalyticsAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbaart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbaart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbaart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mbaart.Kind = kind
			}
		}
	}

	return nil
}

// MLBehaviorAnalyticsAlertRuleTemplateProperties mLBehaviorAnalytics alert rule template properties.
type MLBehaviorAnalyticsAlertRuleTemplateProperties struct {
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - The tactics of the alert rule template.
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MLBehaviorAnalyticsAlertRuleTemplateProperties.
func (mbaart MLBehaviorAnalyticsAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbaart.Severity != "" {
		objectMap["severity"] = mbaart.Severity
	}
	if mbaart.Tactics != nil {
		objectMap["tactics"] = mbaart.Tactics
	}
	if mbaart.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = mbaart.AlertRulesCreatedByTemplateCount
	}
	if mbaart.Description != nil {
		objectMap["description"] = mbaart.Description
	}
	if mbaart.DisplayName != nil {
		objectMap["displayName"] = mbaart.DisplayName
	}
	if mbaart.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = mbaart.RequiredDataConnectors
	}
	if mbaart.Status != "" {
		objectMap["status"] = mbaart.Status
	}
	return json.Marshal(objectMap)
}

// MSTICheckRequirements represents Microsoft Threat Intelligence requirements check request.
type MSTICheckRequirements struct {
	// MSTICheckRequirementsProperties - Microsoft Threat Intelligence requirements check properties.
	*MSTICheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MSTICheckRequirements.
func (mcr MSTICheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence
	objectMap := make(map[string]interface{})
	if mcr.MSTICheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MSTICheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return &mcr, true
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MSTICheckRequirements.
func (mcr MSTICheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MSTICheckRequirements struct.
func (mcr *MSTICheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSTICheckRequirementsProperties MSTICheckRequirementsProperties
				err = json.Unmarshal(*v, &mSTICheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MSTICheckRequirementsProperties = &mSTICheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MSTICheckRequirementsProperties microsoft Threat Intelligence requirements check properties.
type MSTICheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MSTIDataConnector represents Microsoft Threat Intelligence data connector.
type MSTIDataConnector struct {
	// MSTIDataConnectorProperties - Microsoft Threat Intelligence data connector properties.
	*MSTIDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MSTIDataConnector.
func (mdc MSTIDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftThreatIntelligence
	objectMap := make(map[string]interface{})
	if mdc.MSTIDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MSTIDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return &mdc, true
}

// AsMTPDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MSTIDataConnector.
func (mdc MSTIDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MSTIDataConnector struct.
func (mdc *MSTIDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSTIDataConnectorProperties MSTIDataConnectorProperties
				err = json.Unmarshal(*v, &mSTIDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MSTIDataConnectorProperties = &mSTIDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MSTIDataConnectorDataTypes the available data types for Microsoft Threat Intelligence Platforms data
// connector.
type MSTIDataConnectorDataTypes struct {
	// BingSafetyPhishingURL - Data type for Microsoft Threat Intelligence Platforms data connector.
	BingSafetyPhishingURL *MSTIDataConnectorDataTypesBingSafetyPhishingURL `json:"bingSafetyPhishingURL,omitempty"`
	// MicrosoftEmergingThreatFeed - Data type for Microsoft Threat Intelligence Platforms data connector.
	MicrosoftEmergingThreatFeed *MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed `json:"microsoftEmergingThreatFeed,omitempty"`
}

// MSTIDataConnectorDataTypesBingSafetyPhishingURL data type for Microsoft Threat Intelligence Platforms
// data connector.
type MSTIDataConnectorDataTypesBingSafetyPhishingURL struct {
	// LookbackPeriod - lookback period
	LookbackPeriod *string `json:"lookbackPeriod,omitempty"`
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed data type for Microsoft Threat Intelligence
// Platforms data connector.
type MSTIDataConnectorDataTypesMicrosoftEmergingThreatFeed struct {
	// LookbackPeriod - lookback period
	LookbackPeriod *string `json:"lookbackPeriod,omitempty"`
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// MSTIDataConnectorProperties microsoft Threat Intelligence data connector properties.
type MSTIDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *MSTIDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MtpCheckRequirements represents MTP (Microsoft Threat Protection) requirements check request.
type MtpCheckRequirements struct {
	// MTPCheckRequirementsProperties - MTP (Microsoft Threat Protection) requirements check properties.
	*MTPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MtpCheckRequirements.
func (mcr MtpCheckRequirements) MarshalJSON() ([]byte, error) {
	mcr.Kind = KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection
	objectMap := make(map[string]interface{})
	if mcr.MTPCheckRequirementsProperties != nil {
		objectMap["properties"] = mcr.MTPCheckRequirementsProperties
	}
	if mcr.Kind != "" {
		objectMap["kind"] = mcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return &mcr, true
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for MtpCheckRequirements.
func (mcr MtpCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &mcr, true
}

// UnmarshalJSON is the custom unmarshaler for MtpCheckRequirements struct.
func (mcr *MtpCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mTPCheckRequirementsProperties MTPCheckRequirementsProperties
				err = json.Unmarshal(*v, &mTPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				mcr.MTPCheckRequirementsProperties = &mTPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mcr.Kind = kind
			}
		}
	}

	return nil
}

// MTPCheckRequirementsProperties MTP (Microsoft Threat Protection) requirements check properties.
type MTPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// MTPDataConnector represents MTP (Microsoft Threat Protection) data connector.
type MTPDataConnector struct {
	// MTPDataConnectorProperties - MTP (Microsoft Threat Protection) data connector properties.
	*MTPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MTPDataConnector.
func (mdc MTPDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindBasicDataConnectorKindMicrosoftThreatProtection
	objectMap := make(map[string]interface{})
	if mdc.MTPDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MTPDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return &mdc, true
}

// AsASCDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MTPDataConnector.
func (mdc MTPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MTPDataConnector struct.
func (mdc *MTPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mTPDataConnectorProperties MTPDataConnectorProperties
				err = json.Unmarshal(*v, &mTPDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MTPDataConnectorProperties = &mTPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MTPDataConnectorDataTypes the available data types for Microsoft Threat Protection Platforms data
// connector.
type MTPDataConnectorDataTypes struct {
	// Incidents - Data type for Microsoft Threat Protection Platforms data connector.
	Incidents *MTPDataConnectorDataTypesIncidents `json:"incidents,omitempty"`
}

// MTPDataConnectorDataTypesIncidents data type for Microsoft Threat Protection Platforms data connector.
type MTPDataConnectorDataTypesIncidents struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// MTPDataConnectorProperties MTP (Microsoft Threat Protection) data connector properties.
type MTPDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *MTPDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// OfficeATPCheckRequirements represents OfficeATP (Office 365 Advanced Threat Protection) requirements
// check request.
type OfficeATPCheckRequirements struct {
	// OfficeATPCheckRequirementsProperties - OfficeATP (Office 365 Advanced Threat Protection) requirements check properties.
	*OfficeATPCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) MarshalJSON() ([]byte, error) {
	oacr.Kind = KindBasicDataConnectorsCheckRequirementsKindOfficeATP
	objectMap := make(map[string]interface{})
	if oacr.OfficeATPCheckRequirementsProperties != nil {
		objectMap["properties"] = oacr.OfficeATPCheckRequirementsProperties
	}
	if oacr.Kind != "" {
		objectMap["kind"] = oacr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return &oacr, true
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for OfficeATPCheckRequirements.
func (oacr OfficeATPCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &oacr, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeATPCheckRequirements struct.
func (oacr *OfficeATPCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeATPCheckRequirementsProperties OfficeATPCheckRequirementsProperties
				err = json.Unmarshal(*v, &officeATPCheckRequirementsProperties)
				if err != nil {
					return err
				}
				oacr.OfficeATPCheckRequirementsProperties = &officeATPCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oacr.Kind = kind
			}
		}
	}

	return nil
}

// OfficeATPCheckRequirementsProperties officeATP (Office 365 Advanced Threat Protection) requirements
// check properties.
type OfficeATPCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// OfficeATPDataConnector represents OfficeATP (Office 365 Advanced Threat Protection) data connector.
type OfficeATPDataConnector struct {
	// OfficeATPDataConnectorProperties - OfficeATP (Office 365 Advanced Threat Protection) data connector properties.
	*OfficeATPDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) MarshalJSON() ([]byte, error) {
	oadc.Kind = KindBasicDataConnectorKindOfficeATP
	objectMap := make(map[string]interface{})
	if oadc.OfficeATPDataConnectorProperties != nil {
		objectMap["properties"] = oadc.OfficeATPDataConnectorProperties
	}
	if oadc.Etag != nil {
		objectMap["etag"] = oadc.Etag
	}
	if oadc.Kind != "" {
		objectMap["kind"] = oadc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return &oadc, true
}

// AsOfficeDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for OfficeATPDataConnector.
func (oadc OfficeATPDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &oadc, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeATPDataConnector struct.
func (oadc *OfficeATPDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeATPDataConnectorProperties OfficeATPDataConnectorProperties
				err = json.Unmarshal(*v, &officeATPDataConnectorProperties)
				if err != nil {
					return err
				}
				oadc.OfficeATPDataConnectorProperties = &officeATPDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oadc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oadc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oadc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				oadc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oadc.Kind = kind
			}
		}
	}

	return nil
}

// OfficeATPDataConnectorProperties officeATP (Office 365 Advanced Threat Protection) data connector
// properties.
type OfficeATPDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// OfficeConsent consent for Office365 tenant that already made.
type OfficeConsent struct {
	autorest.Response `json:"-"`
	// OfficeConsentProperties - Office consent properties
	*OfficeConsentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsent.
func (oc OfficeConsent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.OfficeConsentProperties != nil {
		objectMap["properties"] = oc.OfficeConsentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OfficeConsent struct.
func (oc *OfficeConsent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeConsentProperties OfficeConsentProperties
				err = json.Unmarshal(*v, &officeConsentProperties)
				if err != nil {
					return err
				}
				oc.OfficeConsentProperties = &officeConsentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oc.Type = &typeVar
			}
		}
	}

	return nil
}

// OfficeConsentList list of all the office365 consents.
type OfficeConsentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of office consents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of the consents.
	Value *[]OfficeConsent `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsentList.
func (ocl OfficeConsentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ocl.Value != nil {
		objectMap["value"] = ocl.Value
	}
	return json.Marshal(objectMap)
}

// OfficeConsentListIterator provides access to a complete listing of OfficeConsent values.
type OfficeConsentListIterator struct {
	i    int
	page OfficeConsentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OfficeConsentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OfficeConsentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OfficeConsentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OfficeConsentListIterator) Response() OfficeConsentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OfficeConsentListIterator) Value() OfficeConsent {
	if !iter.page.NotDone() {
		return OfficeConsent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OfficeConsentListIterator type.
func NewOfficeConsentListIterator(page OfficeConsentListPage) OfficeConsentListIterator {
	return OfficeConsentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ocl OfficeConsentList) IsEmpty() bool {
	return ocl.Value == nil || len(*ocl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ocl OfficeConsentList) hasNextLink() bool {
	return ocl.NextLink != nil && len(*ocl.NextLink) != 0
}

// officeConsentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ocl OfficeConsentList) officeConsentListPreparer(ctx context.Context) (*http.Request, error) {
	if !ocl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ocl.NextLink)))
}

// OfficeConsentListPage contains a page of OfficeConsent values.
type OfficeConsentListPage struct {
	fn  func(context.Context, OfficeConsentList) (OfficeConsentList, error)
	ocl OfficeConsentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OfficeConsentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ocl)
		if err != nil {
			return err
		}
		page.ocl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OfficeConsentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OfficeConsentListPage) NotDone() bool {
	return !page.ocl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OfficeConsentListPage) Response() OfficeConsentList {
	return page.ocl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OfficeConsentListPage) Values() []OfficeConsent {
	if page.ocl.IsEmpty() {
		return nil
	}
	return *page.ocl.Value
}

// Creates a new instance of the OfficeConsentListPage type.
func NewOfficeConsentListPage(cur OfficeConsentList, getNextPage func(context.Context, OfficeConsentList) (OfficeConsentList, error)) OfficeConsentListPage {
	return OfficeConsentListPage{
		fn:  getNextPage,
		ocl: cur,
	}
}

// OfficeConsentProperties consent property bag.
type OfficeConsentProperties struct {
	// TenantID - The tenantId of the Office365 with the consent.
	TenantID *string `json:"tenantId,omitempty"`
	// ConsentID - Help to easily cascade among the data layers.
	ConsentID *string `json:"consentId,omitempty"`
}

// OfficeDataConnector represents office data connector.
type OfficeDataConnector struct {
	// OfficeDataConnectorProperties - Office data connector properties.
	*OfficeDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeDataConnector.
func (odc OfficeDataConnector) MarshalJSON() ([]byte, error) {
	odc.Kind = KindBasicDataConnectorKindOffice365
	objectMap := make(map[string]interface{})
	if odc.OfficeDataConnectorProperties != nil {
		objectMap["properties"] = odc.OfficeDataConnectorProperties
	}
	if odc.Etag != nil {
		objectMap["etag"] = odc.Etag
	}
	if odc.Kind != "" {
		objectMap["kind"] = odc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return &odc, true
}

// AsTIDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &odc, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeDataConnector struct.
func (odc *OfficeDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeDataConnectorProperties OfficeDataConnectorProperties
				err = json.Unmarshal(*v, &officeDataConnectorProperties)
				if err != nil {
					return err
				}
				odc.OfficeDataConnectorProperties = &officeDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				odc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				odc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				odc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				odc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				odc.Kind = kind
			}
		}
	}

	return nil
}

// OfficeDataConnectorDataTypes the available data types for office data connector.
type OfficeDataConnectorDataTypes struct {
	// Exchange - Exchange data type connection.
	Exchange *OfficeDataConnectorDataTypesExchange `json:"exchange,omitempty"`
	// SharePoint - SharePoint data type connection.
	SharePoint *OfficeDataConnectorDataTypesSharePoint `json:"sharePoint,omitempty"`
	// Teams - Teams data type connection.
	Teams *OfficeDataConnectorDataTypesTeams `json:"teams,omitempty"`
}

// OfficeDataConnectorDataTypesExchange exchange data type connection.
type OfficeDataConnectorDataTypesExchange struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesSharePoint sharePoint data type connection.
type OfficeDataConnectorDataTypesSharePoint struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesTeams teams data type connection.
type OfficeDataConnectorDataTypesTeams struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorProperties office data connector properties.
type OfficeDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *OfficeDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// Operation operation provided by provider
type Operation struct {
	// Display - Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - The origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay properties of the operation
type OperationDisplay struct {
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
}

// OperationsList lists the operations available in the SecurityInsights RP.
type OperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - URL to fetch the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of operations
	Value *[]Operation `json:"value,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationsList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// ProcessEntity represents a process entity.
type ProcessEntity struct {
	// ProcessEntityProperties - Process entity properties
	*ProcessEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessEntity.
func (peVar ProcessEntity) MarshalJSON() ([]byte, error) {
	peVar.Kind = KindBasicEntityKindProcess
	objectMap := make(map[string]interface{})
	if peVar.ProcessEntityProperties != nil {
		objectMap["properties"] = peVar.ProcessEntityProperties
	}
	if peVar.Kind != "" {
		objectMap["kind"] = peVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return &peVar, true
}

// AsRegistryKeyEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for ProcessEntity.
func (peVar ProcessEntity) AsBasicEntity() (BasicEntity, bool) {
	return &peVar, true
}

// UnmarshalJSON is the custom unmarshaler for ProcessEntity struct.
func (peVar *ProcessEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processEntityProperties ProcessEntityProperties
				err = json.Unmarshal(*v, &processEntityProperties)
				if err != nil {
					return err
				}
				peVar.ProcessEntityProperties = &processEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				peVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				peVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				peVar.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				peVar.Kind = kind
			}
		}
	}

	return nil
}

// ProcessEntityProperties process entity property bag.
type ProcessEntityProperties struct {
	// AccountEntityID - READ-ONLY; The account entity id running the processes.
	AccountEntityID *string `json:"accountEntityId,omitempty"`
	// CommandLine - READ-ONLY; The command line used to create the process
	CommandLine *string `json:"commandLine,omitempty"`
	// CreationTimeUtc - READ-ONLY; The time when the process started to run
	CreationTimeUtc *date.Time `json:"creationTimeUtc,omitempty"`
	// ElevationToken - The elevation token associated with the process. Possible values include: 'ElevationTokenDefault', 'ElevationTokenFull', 'ElevationTokenLimited'
	ElevationToken ElevationToken `json:"elevationToken,omitempty"`
	// HostEntityID - READ-ONLY; The host entity id on which the process was running
	HostEntityID *string `json:"hostEntityId,omitempty"`
	// HostLogonSessionEntityID - READ-ONLY; The session entity id in which the process was running
	HostLogonSessionEntityID *string `json:"hostLogonSessionEntityId,omitempty"`
	// ImageFileEntityID - READ-ONLY; Image file entity id
	ImageFileEntityID *string `json:"imageFileEntityId,omitempty"`
	// ParentProcessEntityID - READ-ONLY; The parent process entity id.
	ParentProcessEntityID *string `json:"parentProcessEntityId,omitempty"`
	// ProcessID - READ-ONLY; The process ID
	ProcessID *string `json:"processId,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessEntityProperties.
func (pep ProcessEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pep.ElevationToken != "" {
		objectMap["elevationToken"] = pep.ElevationToken
	}
	return json.Marshal(objectMap)
}

// RegistryKeyEntity represents a registry key entity.
type RegistryKeyEntity struct {
	// RegistryKeyEntityProperties - RegistryKey entity properties
	*RegistryKeyEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryKeyEntity.
func (rke RegistryKeyEntity) MarshalJSON() ([]byte, error) {
	rke.Kind = KindBasicEntityKindRegistryKey
	objectMap := make(map[string]interface{})
	if rke.RegistryKeyEntityProperties != nil {
		objectMap["properties"] = rke.RegistryKeyEntityProperties
	}
	if rke.Kind != "" {
		objectMap["kind"] = rke.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return &rke, true
}

// AsRegistryValueEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for RegistryKeyEntity.
func (rke RegistryKeyEntity) AsBasicEntity() (BasicEntity, bool) {
	return &rke, true
}

// UnmarshalJSON is the custom unmarshaler for RegistryKeyEntity struct.
func (rke *RegistryKeyEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registryKeyEntityProperties RegistryKeyEntityProperties
				err = json.Unmarshal(*v, &registryKeyEntityProperties)
				if err != nil {
					return err
				}
				rke.RegistryKeyEntityProperties = &registryKeyEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rke.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rke.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rke.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rke.Kind = kind
			}
		}
	}

	return nil
}

// RegistryKeyEntityProperties registryKey entity property bag.
type RegistryKeyEntityProperties struct {
	// Hive - READ-ONLY; the hive that holds the registry key. Possible values include: 'RegistryHiveHKEYLOCALMACHINE', 'RegistryHiveHKEYCLASSESROOT', 'RegistryHiveHKEYCURRENTCONFIG', 'RegistryHiveHKEYUSERS', 'RegistryHiveHKEYCURRENTUSERLOCALSETTINGS', 'RegistryHiveHKEYPERFORMANCEDATA', 'RegistryHiveHKEYPERFORMANCENLSTEXT', 'RegistryHiveHKEYPERFORMANCETEXT', 'RegistryHiveHKEYA', 'RegistryHiveHKEYCURRENTUSER'
	Hive RegistryHive `json:"hive,omitempty"`
	// Key - READ-ONLY; The registry key path.
	Key *string `json:"key,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryKeyEntityProperties.
func (rkep RegistryKeyEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RegistryValueEntity represents a registry value entity.
type RegistryValueEntity struct {
	// RegistryValueEntityProperties - RegistryKey entity properties
	*RegistryValueEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryValueEntity.
func (rve RegistryValueEntity) MarshalJSON() ([]byte, error) {
	rve.Kind = KindBasicEntityKindRegistryValue
	objectMap := make(map[string]interface{})
	if rve.RegistryValueEntityProperties != nil {
		objectMap["properties"] = rve.RegistryValueEntityProperties
	}
	if rve.Kind != "" {
		objectMap["kind"] = rve.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return &rve, true
}

// AsSecurityGroupEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for RegistryValueEntity.
func (rve RegistryValueEntity) AsBasicEntity() (BasicEntity, bool) {
	return &rve, true
}

// UnmarshalJSON is the custom unmarshaler for RegistryValueEntity struct.
func (rve *RegistryValueEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registryValueEntityProperties RegistryValueEntityProperties
				err = json.Unmarshal(*v, &registryValueEntityProperties)
				if err != nil {
					return err
				}
				rve.RegistryValueEntityProperties = &registryValueEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rve.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rve.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rve.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rve.Kind = kind
			}
		}
	}

	return nil
}

// RegistryValueEntityProperties registryValue entity property bag.
type RegistryValueEntityProperties struct {
	// KeyEntityID - READ-ONLY; The registry key entity id.
	KeyEntityID *string `json:"keyEntityId,omitempty"`
	// ValueData - READ-ONLY; String formatted representation of the value data.
	ValueData *string `json:"valueData,omitempty"`
	// ValueName - READ-ONLY; The registry value name.
	ValueName *string `json:"valueName,omitempty"`
	// ValueType - READ-ONLY; Specifies the data types to use when storing values in the registry, or identifies the data type of a value in the registry. Possible values include: 'RegistryValueKindNone', 'RegistryValueKindUnknown', 'RegistryValueKindString', 'RegistryValueKindExpandString', 'RegistryValueKindBinary', 'RegistryValueKindDWord', 'RegistryValueKindMultiString', 'RegistryValueKindQWord'
	ValueType RegistryValueKind `json:"valueType,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryValueEntityProperties.
func (rvep RegistryValueEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Relation represents a relation between two resources
type Relation struct {
	autorest.Response `json:"-"`
	// RelationProperties - Relation properties
	*RelationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Relation.
func (r Relation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RelationProperties != nil {
		objectMap["properties"] = r.RelationProperties
	}
	if r.Etag != nil {
		objectMap["etag"] = r.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Relation struct.
func (r *Relation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationProperties RelationProperties
				err = json.Unmarshal(*v, &relationProperties)
				if err != nil {
					return err
				}
				r.RelationProperties = &relationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				r.Etag = &etag
			}
		}
	}

	return nil
}

// RelationBase represents a relation
type RelationBase struct {
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'RelationTypesCasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationBase.
func (rb RelationBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rb.Etag != nil {
		objectMap["etag"] = rb.Etag
	}
	return json.Marshal(objectMap)
}

// RelationList list of relations.
type RelationList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of relations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of relations.
	Value *[]Relation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationList.
func (rl RelationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.Value != nil {
		objectMap["value"] = rl.Value
	}
	return json.Marshal(objectMap)
}

// RelationListIterator provides access to a complete listing of Relation values.
type RelationListIterator struct {
	i    int
	page RelationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RelationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RelationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RelationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RelationListIterator) Response() RelationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RelationListIterator) Value() Relation {
	if !iter.page.NotDone() {
		return Relation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RelationListIterator type.
func NewRelationListIterator(page RelationListPage) RelationListIterator {
	return RelationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rl RelationList) IsEmpty() bool {
	return rl.Value == nil || len(*rl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rl RelationList) hasNextLink() bool {
	return rl.NextLink != nil && len(*rl.NextLink) != 0
}

// relationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rl RelationList) relationListPreparer(ctx context.Context) (*http.Request, error) {
	if !rl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rl.NextLink)))
}

// RelationListPage contains a page of Relation values.
type RelationListPage struct {
	fn func(context.Context, RelationList) (RelationList, error)
	rl RelationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RelationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RelationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rl)
		if err != nil {
			return err
		}
		page.rl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RelationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RelationListPage) NotDone() bool {
	return !page.rl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RelationListPage) Response() RelationList {
	return page.rl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RelationListPage) Values() []Relation {
	if page.rl.IsEmpty() {
		return nil
	}
	return *page.rl.Value
}

// Creates a new instance of the RelationListPage type.
func NewRelationListPage(cur RelationList, getNextPage func(context.Context, RelationList) (RelationList, error)) RelationListPage {
	return RelationListPage{
		fn: getNextPage,
		rl: cur,
	}
}

// RelationNode relation node
type RelationNode struct {
	// RelationNodeID - Relation Node Id
	RelationNodeID *string `json:"relationNodeId,omitempty"`
	// RelationNodeKind - READ-ONLY; The type of relation node. Possible values include: 'RelationNodeKindCase', 'RelationNodeKindBookmark'
	RelationNodeKind RelationNodeKind `json:"relationNodeKind,omitempty"`
	// Etag - Etag for relation node
	Etag *string `json:"etag,omitempty"`
	// RelationAdditionalProperties - Additional set of properties
	RelationAdditionalProperties map[string]*string `json:"relationAdditionalProperties"`
}

// MarshalJSON is the custom marshaler for RelationNode.
func (rn RelationNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rn.RelationNodeID != nil {
		objectMap["relationNodeId"] = rn.RelationNodeID
	}
	if rn.Etag != nil {
		objectMap["etag"] = rn.Etag
	}
	if rn.RelationAdditionalProperties != nil {
		objectMap["relationAdditionalProperties"] = rn.RelationAdditionalProperties
	}
	return json.Marshal(objectMap)
}

// RelationProperties relation property bag.
type RelationProperties struct {
	// RelatedResourceID - The resource ID of the related resource
	RelatedResourceID *string `json:"relatedResourceId,omitempty"`
	// RelatedResourceName - READ-ONLY; The name of the related resource
	RelatedResourceName *string `json:"relatedResourceName,omitempty"`
	// RelatedResourceType - READ-ONLY; The resource type of the related resource
	RelatedResourceType *string `json:"relatedResourceType,omitempty"`
	// RelatedResourceKind - READ-ONLY; The resource kind of the related resource
	RelatedResourceKind *string `json:"relatedResourceKind,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationProperties.
func (rp RelationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RelatedResourceID != nil {
		objectMap["relatedResourceId"] = rp.RelatedResourceID
	}
	return json.Marshal(objectMap)
}

// RelationsModelInput relation input model
type RelationsModelInput struct {
	// RelationsModelInputProperties - Relation input properties
	*RelationsModelInputProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; The type of relation node. Possible values include: 'RelationTypesCasesToBookmarks'
	Kind RelationTypes `json:"kind,omitempty"`
	// Etag - ETag for relation
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RelationsModelInput.
func (rmi RelationsModelInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmi.RelationsModelInputProperties != nil {
		objectMap["properties"] = rmi.RelationsModelInputProperties
	}
	if rmi.Etag != nil {
		objectMap["etag"] = rmi.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelationsModelInput struct.
func (rmi *RelationsModelInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relationsModelInputProperties RelationsModelInputProperties
				err = json.Unmarshal(*v, &relationsModelInputProperties)
				if err != nil {
					return err
				}
				rmi.RelationsModelInputProperties = &relationsModelInputProperties
			}
		case "kind":
			if v != nil {
				var kind RelationTypes
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rmi.Kind = kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rmi.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmi.Type = &typeVar
			}
		}
	}

	return nil
}

// RelationsModelInputProperties relation input properties
type RelationsModelInputProperties struct {
	// RelationName - Name of relation
	RelationName *string `json:"relationName,omitempty"`
	// SourceRelationNode - Relation source node
	SourceRelationNode *RelationNode `json:"sourceRelationNode,omitempty"`
	// TargetRelationNode - Relation target node
	TargetRelationNode *RelationNode `json:"targetRelationNode,omitempty"`
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceWithEtag an azure resource object with an Etag property
type ResourceWithEtag struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceWithEtag.
func (rwe ResourceWithEtag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rwe.Etag != nil {
		objectMap["etag"] = rwe.Etag
	}
	return json.Marshal(objectMap)
}

// ScheduledAlertRule represents scheduled alert rule.
type ScheduledAlertRule struct {
	// ScheduledAlertRuleProperties - Scheduled alert rule properties
	*ScheduledAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRule.
func (sar ScheduledAlertRule) MarshalJSON() ([]byte, error) {
	sar.Kind = KindBasicAlertRuleKindScheduled
	objectMap := make(map[string]interface{})
	if sar.ScheduledAlertRuleProperties != nil {
		objectMap["properties"] = sar.ScheduledAlertRuleProperties
	}
	if sar.Etag != nil {
		objectMap["etag"] = sar.Etag
	}
	if sar.Kind != "" {
		objectMap["kind"] = sar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return nil, false
}

// AsFusionAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return &sar, true
}

// AsAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &sar, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRule struct.
func (sar *ScheduledAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleProperties ScheduledAlertRuleProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleProperties)
				if err != nil {
					return err
				}
				sar.ScheduledAlertRuleProperties = &scheduledAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sar.Kind = kind
			}
		}
	}

	return nil
}

// ScheduledAlertRuleCommonProperties scheduled alert rule template property bag.
type ScheduledAlertRuleCommonProperties struct {
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// EventGroupingSettings - The event grouping settings.
	EventGroupingSettings *EventGroupingSettings `json:"eventGroupingSettings,omitempty"`
}

// ScheduledAlertRuleProperties scheduled alert rule base property bag.
type ScheduledAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert rule has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// SuppressionDuration - The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
	SuppressionDuration *string `json:"suppressionDuration,omitempty"`
	// SuppressionEnabled - Determines whether the suppression for this alert rule is enabled or disabled.
	SuppressionEnabled *bool `json:"suppressionEnabled,omitempty"`
	// Tactics - The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// IncidentConfiguration - The settings of the incidents that created from alerts triggered by this analytics rule
	IncidentConfiguration *IncidentConfiguration `json:"incidentConfiguration,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// EventGroupingSettings - The event grouping settings.
	EventGroupingSettings *EventGroupingSettings `json:"eventGroupingSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleProperties.
func (sarp ScheduledAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = sarp.AlertRuleTemplateName
	}
	if sarp.Description != nil {
		objectMap["description"] = sarp.Description
	}
	if sarp.DisplayName != nil {
		objectMap["displayName"] = sarp.DisplayName
	}
	if sarp.Enabled != nil {
		objectMap["enabled"] = sarp.Enabled
	}
	if sarp.SuppressionDuration != nil {
		objectMap["suppressionDuration"] = sarp.SuppressionDuration
	}
	if sarp.SuppressionEnabled != nil {
		objectMap["suppressionEnabled"] = sarp.SuppressionEnabled
	}
	if sarp.Tactics != nil {
		objectMap["tactics"] = sarp.Tactics
	}
	if sarp.IncidentConfiguration != nil {
		objectMap["incidentConfiguration"] = sarp.IncidentConfiguration
	}
	if sarp.Query != nil {
		objectMap["query"] = sarp.Query
	}
	if sarp.QueryFrequency != nil {
		objectMap["queryFrequency"] = sarp.QueryFrequency
	}
	if sarp.QueryPeriod != nil {
		objectMap["queryPeriod"] = sarp.QueryPeriod
	}
	if sarp.Severity != "" {
		objectMap["severity"] = sarp.Severity
	}
	if sarp.TriggerOperator != "" {
		objectMap["triggerOperator"] = sarp.TriggerOperator
	}
	if sarp.TriggerThreshold != nil {
		objectMap["triggerThreshold"] = sarp.TriggerThreshold
	}
	if sarp.EventGroupingSettings != nil {
		objectMap["eventGroupingSettings"] = sarp.EventGroupingSettings
	}
	return json.Marshal(objectMap)
}

// ScheduledAlertRuleTemplate represents scheduled alert rule template.
type ScheduledAlertRuleTemplate struct {
	// ScheduledAlertRuleTemplateProperties - Scheduled alert rule template properties
	*ScheduledAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	sart.Kind = KindBasicAlertRuleTemplateKindScheduled
	objectMap := make(map[string]interface{})
	if sart.ScheduledAlertRuleTemplateProperties != nil {
		objectMap["properties"] = sart.ScheduledAlertRuleTemplateProperties
	}
	if sart.Kind != "" {
		objectMap["kind"] = sart.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return nil, false
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return nil, false
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return &sart, true
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ScheduledAlertRuleTemplate.
func (sart ScheduledAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &sart, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRuleTemplate struct.
func (sart *ScheduledAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleTemplateProperties ScheduledAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				sart.ScheduledAlertRuleTemplateProperties = &scheduledAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sart.Kind = kind
			}
		}
	}

	return nil
}

// ScheduledAlertRuleTemplateProperties scheduled alert rule template properties
type ScheduledAlertRuleTemplateProperties struct {
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'TriggerOperatorGreaterThan', 'TriggerOperatorLessThan', 'TriggerOperatorEqual', 'TriggerOperatorNotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// EventGroupingSettings - The event grouping settings.
	EventGroupingSettings *EventGroupingSettings `json:"eventGroupingSettings,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRuleTemplateProperties.
func (sart ScheduledAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sart.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = sart.AlertRulesCreatedByTemplateCount
	}
	if sart.Description != nil {
		objectMap["description"] = sart.Description
	}
	if sart.DisplayName != nil {
		objectMap["displayName"] = sart.DisplayName
	}
	if sart.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = sart.RequiredDataConnectors
	}
	if sart.Status != "" {
		objectMap["status"] = sart.Status
	}
	if sart.Query != nil {
		objectMap["query"] = sart.Query
	}
	if sart.QueryFrequency != nil {
		objectMap["queryFrequency"] = sart.QueryFrequency
	}
	if sart.QueryPeriod != nil {
		objectMap["queryPeriod"] = sart.QueryPeriod
	}
	if sart.Severity != "" {
		objectMap["severity"] = sart.Severity
	}
	if sart.TriggerOperator != "" {
		objectMap["triggerOperator"] = sart.TriggerOperator
	}
	if sart.TriggerThreshold != nil {
		objectMap["triggerThreshold"] = sart.TriggerThreshold
	}
	if sart.EventGroupingSettings != nil {
		objectMap["eventGroupingSettings"] = sart.EventGroupingSettings
	}
	if sart.Tactics != nil {
		objectMap["tactics"] = sart.Tactics
	}
	return json.Marshal(objectMap)
}

// SecurityAlert represents a security alert entity.
type SecurityAlert struct {
	// SecurityAlertProperties - SecurityAlert entity properties
	*SecurityAlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlert.
func (sa SecurityAlert) MarshalJSON() ([]byte, error) {
	sa.Kind = KindBasicEntityKindSecurityAlert
	objectMap := make(map[string]interface{})
	if sa.SecurityAlertProperties != nil {
		objectMap["properties"] = sa.SecurityAlertProperties
	}
	if sa.Kind != "" {
		objectMap["kind"] = sa.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsSecurityAlert() (*SecurityAlert, bool) {
	return &sa, true
}

// AsIPEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for SecurityAlert.
func (sa SecurityAlert) AsBasicEntity() (BasicEntity, bool) {
	return &sa, true
}

// UnmarshalJSON is the custom unmarshaler for SecurityAlert struct.
func (sa *SecurityAlert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertProperties SecurityAlertProperties
				err = json.Unmarshal(*v, &securityAlertProperties)
				if err != nil {
					return err
				}
				sa.SecurityAlertProperties = &securityAlertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sa.Kind = kind
			}
		}
	}

	return nil
}

// SecurityAlertProperties securityAlert entity property bag.
type SecurityAlertProperties struct {
	// AlertDisplayName - READ-ONLY; The display name of the alert.
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// AlertType - READ-ONLY; The type name of the alert.
	AlertType *string `json:"alertType,omitempty"`
	// CompromisedEntity - READ-ONLY; Display name of the main entity being reported on.
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// ConfidenceLevel - READ-ONLY; The confidence level of this alert. Possible values include: 'ConfidenceLevelUnknown', 'ConfidenceLevelLow', 'ConfidenceLevelHigh'
	ConfidenceLevel ConfidenceLevel `json:"confidenceLevel,omitempty"`
	// ConfidenceReasons - READ-ONLY; The confidence reasons
	ConfidenceReasons *[]SecurityAlertPropertiesConfidenceReasonsItem `json:"confidenceReasons,omitempty"`
	// ConfidenceScore - READ-ONLY; The confidence score of the alert.
	ConfidenceScore *float64 `json:"confidenceScore,omitempty"`
	// ConfidenceScoreStatus - READ-ONLY; The confidence score calculation status, i.e. indicating if score calculation is pending for this alert, not applicable or final. Possible values include: 'ConfidenceScoreStatusNotApplicable', 'ConfidenceScoreStatusInProcess', 'ConfidenceScoreStatusNotFinal', 'ConfidenceScoreStatusFinal'
	ConfidenceScoreStatus ConfidenceScoreStatus `json:"confidenceScoreStatus,omitempty"`
	// Description - READ-ONLY; Alert description.
	Description *string `json:"description,omitempty"`
	// EndTimeUtc - READ-ONLY; The impact end time of the alert (the time of the last event contributing to the alert).
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Intent - READ-ONLY; Holds the alert intent stage(s) mapping for this alert. Possible values include: 'KillChainIntentUnknown', 'KillChainIntentProbing', 'KillChainIntentExploitation', 'KillChainIntentPersistence', 'KillChainIntentPrivilegeEscalation', 'KillChainIntentDefenseEvasion', 'KillChainIntentCredentialAccess', 'KillChainIntentDiscovery', 'KillChainIntentLateralMovement', 'KillChainIntentExecution', 'KillChainIntentCollection', 'KillChainIntentExfiltration', 'KillChainIntentCommandAndControl', 'KillChainIntentImpact'
	Intent KillChainIntent `json:"intent,omitempty"`
	// ProviderAlertID - READ-ONLY; The identifier of the alert inside the product which generated the alert.
	ProviderAlertID *string `json:"providerAlertId,omitempty"`
	// ProcessingEndTime - READ-ONLY; The time the alert was made available for consumption.
	ProcessingEndTime *date.Time `json:"processingEndTime,omitempty"`
	// ProductComponentName - READ-ONLY; The name of a component inside the product which generated the alert.
	ProductComponentName *string `json:"productComponentName,omitempty"`
	// ProductName - READ-ONLY; The name of the product which published this alert.
	ProductName *string `json:"productName,omitempty"`
	// ProductVersion - READ-ONLY; The version of the product generating the alert.
	ProductVersion *string `json:"productVersion,omitempty"`
	// RemediationSteps - READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps *[]string `json:"remediationSteps,omitempty"`
	// Severity - The severity of the alert. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// StartTimeUtc - READ-ONLY; The impact start time of the alert (the time of the first event contributing to the alert).
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Status - READ-ONLY; The lifecycle status of the alert. Possible values include: 'AlertStatusUnknown', 'AlertStatusNew', 'AlertStatusResolved', 'AlertStatusDismissed', 'AlertStatusInProgress'
	Status AlertStatus `json:"status,omitempty"`
	// SystemAlertID - READ-ONLY; Holds the product identifier of the alert for the product.
	SystemAlertID *string `json:"systemAlertId,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// TimeGenerated - READ-ONLY; The time the alert was generated.
	TimeGenerated *date.Time `json:"timeGenerated,omitempty"`
	// VendorName - READ-ONLY; The name of the vendor that raise the alert.
	VendorName *string `json:"vendorName,omitempty"`
	// AlertLink - READ-ONLY; The uri link of the alert.
	AlertLink *string `json:"alertLink,omitempty"`
	// ResourceIdentifiers - READ-ONLY; The list of resource identifiers of the alert.
	ResourceIdentifiers *[]interface{} `json:"resourceIdentifiers,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertProperties.
func (sap SecurityAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.Severity != "" {
		objectMap["severity"] = sap.Severity
	}
	return json.Marshal(objectMap)
}

// SecurityAlertPropertiesConfidenceReasonsItem confidence reason item
type SecurityAlertPropertiesConfidenceReasonsItem struct {
	// Reason - READ-ONLY; The reason's description
	Reason *string `json:"reason,omitempty"`
	// ReasonType - READ-ONLY; The type (category) of the reason
	ReasonType *string `json:"reasonType,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertPropertiesConfidenceReasonsItem.
func (sapRi SecurityAlertPropertiesConfidenceReasonsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecurityAlertTimelineItem represents security alert timeline item.
type SecurityAlertTimelineItem struct {
	// AzureResourceID - The alert azure resource id.
	AzureResourceID *string `json:"azureResourceId,omitempty"`
	// ProductName - The alert product name.
	ProductName *string `json:"productName,omitempty"`
	// Description - The alert description.
	Description *string `json:"description,omitempty"`
	// DisplayName - The alert name.
	DisplayName *string `json:"displayName,omitempty"`
	// Severity - The alert severity. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// EndTimeUtc - The alert end time.
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// StartTimeUtc - The alert start time.
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// TimeGenerated - The alert generated time.
	TimeGenerated *date.Time `json:"timeGenerated,omitempty"`
	// AlertType - The name of the alert type.
	AlertType *string `json:"alertType,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityTimelineItemKindEntityTimelineItem', 'KindBasicEntityTimelineItemKindActivity', 'KindBasicEntityTimelineItemKindSecurityAlert', 'KindBasicEntityTimelineItemKindBookmark'
	Kind KindBasicEntityTimelineItem `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) MarshalJSON() ([]byte, error) {
	sati.Kind = KindBasicEntityTimelineItemKindSecurityAlert
	objectMap := make(map[string]interface{})
	if sati.AzureResourceID != nil {
		objectMap["azureResourceId"] = sati.AzureResourceID
	}
	if sati.ProductName != nil {
		objectMap["productName"] = sati.ProductName
	}
	if sati.Description != nil {
		objectMap["description"] = sati.Description
	}
	if sati.DisplayName != nil {
		objectMap["displayName"] = sati.DisplayName
	}
	if sati.Severity != "" {
		objectMap["severity"] = sati.Severity
	}
	if sati.EndTimeUtc != nil {
		objectMap["endTimeUtc"] = sati.EndTimeUtc
	}
	if sati.StartTimeUtc != nil {
		objectMap["startTimeUtc"] = sati.StartTimeUtc
	}
	if sati.TimeGenerated != nil {
		objectMap["timeGenerated"] = sati.TimeGenerated
	}
	if sati.AlertType != nil {
		objectMap["alertType"] = sati.AlertType
	}
	if sati.Kind != "" {
		objectMap["kind"] = sati.Kind
	}
	return json.Marshal(objectMap)
}

// AsActivityTimelineItem is the BasicEntityTimelineItem implementation for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) AsActivityTimelineItem() (*ActivityTimelineItem, bool) {
	return nil, false
}

// AsSecurityAlertTimelineItem is the BasicEntityTimelineItem implementation for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) AsSecurityAlertTimelineItem() (*SecurityAlertTimelineItem, bool) {
	return &sati, true
}

// AsBookmarkTimelineItem is the BasicEntityTimelineItem implementation for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) AsBookmarkTimelineItem() (*BookmarkTimelineItem, bool) {
	return nil, false
}

// AsEntityTimelineItem is the BasicEntityTimelineItem implementation for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) AsEntityTimelineItem() (*EntityTimelineItem, bool) {
	return nil, false
}

// AsBasicEntityTimelineItem is the BasicEntityTimelineItem implementation for SecurityAlertTimelineItem.
func (sati SecurityAlertTimelineItem) AsBasicEntityTimelineItem() (BasicEntityTimelineItem, bool) {
	return &sati, true
}

// SecurityGroupEntity represents a security group entity.
type SecurityGroupEntity struct {
	// SecurityGroupEntityProperties - SecurityGroup entity properties
	*SecurityGroupEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupEntity.
func (sge SecurityGroupEntity) MarshalJSON() ([]byte, error) {
	sge.Kind = KindBasicEntityKindSecurityGroup
	objectMap := make(map[string]interface{})
	if sge.SecurityGroupEntityProperties != nil {
		objectMap["properties"] = sge.SecurityGroupEntityProperties
	}
	if sge.Kind != "" {
		objectMap["kind"] = sge.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return &sge, true
}

// AsURLEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for SecurityGroupEntity.
func (sge SecurityGroupEntity) AsBasicEntity() (BasicEntity, bool) {
	return &sge, true
}

// UnmarshalJSON is the custom unmarshaler for SecurityGroupEntity struct.
func (sge *SecurityGroupEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityGroupEntityProperties SecurityGroupEntityProperties
				err = json.Unmarshal(*v, &securityGroupEntityProperties)
				if err != nil {
					return err
				}
				sge.SecurityGroupEntityProperties = &securityGroupEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sge.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sge.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sge.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sge.Kind = kind
			}
		}
	}

	return nil
}

// SecurityGroupEntityProperties securityGroup entity property bag.
type SecurityGroupEntityProperties struct {
	// DistinguishedName - READ-ONLY; The group distinguished name
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// ObjectGUID - READ-ONLY; A single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *uuid.UUID `json:"objectGuid,omitempty"`
	// Sid - READ-ONLY; The SID attribute is a single-value attribute that specifies the security identifier (SID) of the group
	Sid *string `json:"sid,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityGroupEntityProperties.
func (sgep SecurityGroupEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SettingList list of all the settings.
type SettingList struct {
	autorest.Response `json:"-"`
	// Value - Array of settings.
	Value *[]BasicSettings `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingList struct.
func (sl *SettingList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicSettingsArray(*v)
				if err != nil {
					return err
				}
				sl.Value = &value
			}
		}
	}

	return nil
}

// BasicSettings the Setting.
type BasicSettings interface {
	AsIPSyncer() (*IPSyncer, bool)
	AsEyesOn() (*EyesOn, bool)
	AsEntityAnalytics() (*EntityAnalytics, bool)
	AsUeba() (*Ueba, bool)
	AsSettings() (*Settings, bool)
}

// Settings the Setting.
type Settings struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindIPSyncer', 'KindBasicSettingsKindEyesOn', 'KindBasicSettingsKindEntityAnalytics', 'KindBasicSettingsKindUeba'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

func unmarshalBasicSettings(body []byte) (BasicSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicSettingsKindIPSyncer):
		var is IPSyncer
		err := json.Unmarshal(body, &is)
		return is, err
	case string(KindBasicSettingsKindEyesOn):
		var eo EyesOn
		err := json.Unmarshal(body, &eo)
		return eo, err
	case string(KindBasicSettingsKindEntityAnalytics):
		var ea EntityAnalytics
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(KindBasicSettingsKindUeba):
		var u Ueba
		err := json.Unmarshal(body, &u)
		return u, err
	default:
		var s Settings
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSettingsArray(body []byte) ([]BasicSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Settings.
func (s Settings) MarshalJSON() ([]byte, error) {
	s.Kind = KindBasicSettingsKindSettings
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	return json.Marshal(objectMap)
}

// AsIPSyncer is the BasicSettings implementation for Settings.
func (s Settings) AsIPSyncer() (*IPSyncer, bool) {
	return nil, false
}

// AsEyesOn is the BasicSettings implementation for Settings.
func (s Settings) AsEyesOn() (*EyesOn, bool) {
	return nil, false
}

// AsEntityAnalytics is the BasicSettings implementation for Settings.
func (s Settings) AsEntityAnalytics() (*EntityAnalytics, bool) {
	return nil, false
}

// AsUeba is the BasicSettings implementation for Settings.
func (s Settings) AsUeba() (*Ueba, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for Settings.
func (s Settings) AsSettings() (*Settings, bool) {
	return &s, true
}

// AsBasicSettings is the BasicSettings implementation for Settings.
func (s Settings) AsBasicSettings() (BasicSettings, bool) {
	return &s, true
}

// SettingsKind describes an Azure resource with kind.
type SettingsKind struct {
	// Kind - The kind of the setting. Possible values include: 'SettingKindEyesOn', 'SettingKindEntityAnalytics', 'SettingKindUeba'
	Kind SettingKind `json:"kind,omitempty"`
}

// SettingsModel ...
type SettingsModel struct {
	autorest.Response `json:"-"`
	Value             BasicSettings `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingsModel struct.
func (sm *SettingsModel) UnmarshalJSON(body []byte) error {
	s, err := unmarshalBasicSettings(body)
	if err != nil {
		return err
	}
	sm.Value = s

	return nil
}

// SubmissionMailEntity represents a submission mail entity.
type SubmissionMailEntity struct {
	// SubmissionMailEntityProperties - Submission mail entity properties
	*SubmissionMailEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for SubmissionMailEntity.
func (sme SubmissionMailEntity) MarshalJSON() ([]byte, error) {
	sme.Kind = KindBasicEntityKindSubmissionMail
	objectMap := make(map[string]interface{})
	if sme.SubmissionMailEntityProperties != nil {
		objectMap["properties"] = sme.SubmissionMailEntityProperties
	}
	if sme.Kind != "" {
		objectMap["kind"] = sme.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return &sme, true
}

// AsMalwareEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsURLEntity() (*URLEntity, bool) {
	return nil, false
}

// AsIoTDeviceEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for SubmissionMailEntity.
func (sme SubmissionMailEntity) AsBasicEntity() (BasicEntity, bool) {
	return &sme, true
}

// UnmarshalJSON is the custom unmarshaler for SubmissionMailEntity struct.
func (sme *SubmissionMailEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var submissionMailEntityProperties SubmissionMailEntityProperties
				err = json.Unmarshal(*v, &submissionMailEntityProperties)
				if err != nil {
					return err
				}
				sme.SubmissionMailEntityProperties = &submissionMailEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sme.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sme.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sme.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sme.Kind = kind
			}
		}
	}

	return nil
}

// SubmissionMailEntityProperties submission mail entity property bag.
type SubmissionMailEntityProperties struct {
	// NetworkMessageID - READ-ONLY; The network message id of email to which submission belongs
	NetworkMessageID *uuid.UUID `json:"networkMessageId,omitempty"`
	// SubmissionID - READ-ONLY; The submission id
	SubmissionID *uuid.UUID `json:"submissionId,omitempty"`
	// Submitter - READ-ONLY; The submitter
	Submitter *string `json:"submitter,omitempty"`
	// SubmissionDate - READ-ONLY; The submission date
	SubmissionDate *date.Time `json:"submissionDate,omitempty"`
	// Timestamp - READ-ONLY; The Time stamp when the message is received (Mail)
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Recipient - READ-ONLY; The recipient of the mail
	Recipient *string `json:"recipient,omitempty"`
	// Sender - READ-ONLY; The sender of the mail
	Sender *string `json:"sender,omitempty"`
	// SenderIP - READ-ONLY; The sender's IP
	SenderIP *string `json:"senderIp,omitempty"`
	// Subject - READ-ONLY; The subject of submission mail
	Subject *string `json:"subject,omitempty"`
	// ReportType - READ-ONLY; The submission type for the given instance. This maps to Junk, Phish, Malware or NotJunk.
	ReportType *string `json:"reportType,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for SubmissionMailEntityProperties.
func (smep SubmissionMailEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ThreatIntelligence threatIntelligence property bag.
type ThreatIntelligence struct {
	// Confidence - READ-ONLY; Confidence (must be between 0 and 1)
	Confidence *float64 `json:"confidence,omitempty"`
	// ProviderName - READ-ONLY; Name of the provider from whom this Threat Intelligence information was received
	ProviderName *string `json:"providerName,omitempty"`
	// ReportLink - READ-ONLY; Report link
	ReportLink *string `json:"reportLink,omitempty"`
	// ThreatDescription - READ-ONLY; Threat description (free text)
	ThreatDescription *string `json:"threatDescription,omitempty"`
	// ThreatName - READ-ONLY; Threat name (e.g. "Jedobot malware")
	ThreatName *string `json:"threatName,omitempty"`
	// ThreatType - READ-ONLY; Threat type (e.g. "Botnet")
	ThreatType *string `json:"threatType,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligence.
func (ti ThreatIntelligence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ThreatIntelligenceAlertRule represents Threat Intelligence alert rule.
type ThreatIntelligenceAlertRule struct {
	// ThreatIntelligenceAlertRuleProperties - Threat Intelligence alert rule properties
	*ThreatIntelligenceAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleKindAlertRule', 'KindBasicAlertRuleKindMLBehaviorAnalytics', 'KindBasicAlertRuleKindFusion', 'KindBasicAlertRuleKindThreatIntelligence', 'KindBasicAlertRuleKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleKindScheduled'
	Kind KindBasicAlertRule `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) MarshalJSON() ([]byte, error) {
	tiar.Kind = KindBasicAlertRuleKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tiar.ThreatIntelligenceAlertRuleProperties != nil {
		objectMap["properties"] = tiar.ThreatIntelligenceAlertRuleProperties
	}
	if tiar.Etag != nil {
		objectMap["etag"] = tiar.Etag
	}
	if tiar.Kind != "" {
		objectMap["kind"] = tiar.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsMLBehaviorAnalyticsAlertRule() (*MLBehaviorAnalyticsAlertRule, bool) {
	return nil, false
}

// AsFusionAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsFusionAlertRule() (*FusionAlertRule, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsThreatIntelligenceAlertRule() (*ThreatIntelligenceAlertRule, bool) {
	return &tiar, true
}

// AsMicrosoftSecurityIncidentCreationAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsMicrosoftSecurityIncidentCreationAlertRule() (*MicrosoftSecurityIncidentCreationAlertRule, bool) {
	return nil, false
}

// AsScheduledAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for ThreatIntelligenceAlertRule.
func (tiar ThreatIntelligenceAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &tiar, true
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceAlertRule struct.
func (tiar *ThreatIntelligenceAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var threatIntelligenceAlertRuleProperties ThreatIntelligenceAlertRuleProperties
				err = json.Unmarshal(*v, &threatIntelligenceAlertRuleProperties)
				if err != nil {
					return err
				}
				tiar.ThreatIntelligenceAlertRuleProperties = &threatIntelligenceAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tiar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tiar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tiar.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tiar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRule
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tiar.Kind = kind
			}
		}
	}

	return nil
}

// ThreatIntelligenceAlertRuleProperties threat Intelligence alert rule base property bag.
type ThreatIntelligenceAlertRuleProperties struct {
	// AlertRuleTemplateName - The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string `json:"alertRuleTemplateName,omitempty"`
	// Description - READ-ONLY; The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Severity - READ-ONLY; The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - READ-ONLY; The tactics of the alert rule
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceAlertRuleProperties.
func (tiarp ThreatIntelligenceAlertRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tiarp.AlertRuleTemplateName != nil {
		objectMap["alertRuleTemplateName"] = tiarp.AlertRuleTemplateName
	}
	if tiarp.Enabled != nil {
		objectMap["enabled"] = tiarp.Enabled
	}
	return json.Marshal(objectMap)
}

// ThreatIntelligenceAlertRuleTemplate represents Threat Intelligence alert rule template.
type ThreatIntelligenceAlertRuleTemplate struct {
	// ThreatIntelligenceAlertRuleTemplateProperties - Threat Intelligence alert rule template properties
	*ThreatIntelligenceAlertRuleTemplateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicAlertRuleTemplateKindAlertRuleTemplate', 'KindBasicAlertRuleTemplateKindMLBehaviorAnalytics', 'KindBasicAlertRuleTemplateKindFusion', 'KindBasicAlertRuleTemplateKindThreatIntelligence', 'KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation', 'KindBasicAlertRuleTemplateKindScheduled'
	Kind KindBasicAlertRuleTemplate `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) MarshalJSON() ([]byte, error) {
	tiart.Kind = KindBasicAlertRuleTemplateKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tiart.ThreatIntelligenceAlertRuleTemplateProperties != nil {
		objectMap["properties"] = tiart.ThreatIntelligenceAlertRuleTemplateProperties
	}
	if tiart.Kind != "" {
		objectMap["kind"] = tiart.Kind
	}
	return json.Marshal(objectMap)
}

// AsMLBehaviorAnalyticsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsMLBehaviorAnalyticsAlertRuleTemplate() (*MLBehaviorAnalyticsAlertRuleTemplate, bool) {
	return nil, false
}

// AsFusionAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsFusionAlertRuleTemplate() (*FusionAlertRuleTemplate, bool) {
	return nil, false
}

// AsThreatIntelligenceAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsThreatIntelligenceAlertRuleTemplate() (*ThreatIntelligenceAlertRuleTemplate, bool) {
	return &tiart, true
}

// AsMicrosoftSecurityIncidentCreationAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsMicrosoftSecurityIncidentCreationAlertRuleTemplate() (*MicrosoftSecurityIncidentCreationAlertRuleTemplate, bool) {
	return nil, false
}

// AsScheduledAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsScheduledAlertRuleTemplate() (*ScheduledAlertRuleTemplate, bool) {
	return nil, false
}

// AsAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsAlertRuleTemplate() (*AlertRuleTemplate, bool) {
	return nil, false
}

// AsBasicAlertRuleTemplate is the BasicAlertRuleTemplate implementation for ThreatIntelligenceAlertRuleTemplate.
func (tiart ThreatIntelligenceAlertRuleTemplate) AsBasicAlertRuleTemplate() (BasicAlertRuleTemplate, bool) {
	return &tiart, true
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceAlertRuleTemplate struct.
func (tiart *ThreatIntelligenceAlertRuleTemplate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var threatIntelligenceAlertRuleTemplateProperties ThreatIntelligenceAlertRuleTemplateProperties
				err = json.Unmarshal(*v, &threatIntelligenceAlertRuleTemplateProperties)
				if err != nil {
					return err
				}
				tiart.ThreatIntelligenceAlertRuleTemplateProperties = &threatIntelligenceAlertRuleTemplateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tiart.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tiart.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tiart.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicAlertRuleTemplate
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tiart.Kind = kind
			}
		}
	}

	return nil
}

// ThreatIntelligenceAlertRuleTemplateProperties threat Intelligence alert rule template properties
type ThreatIntelligenceAlertRuleTemplateProperties struct {
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'AlertSeverityHigh', 'AlertSeverityMedium', 'AlertSeverityLow', 'AlertSeverityInformational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Tactics - The tactics of the alert rule template
	Tactics *[]AttackTactic `json:"tactics,omitempty"`
	// AlertRulesCreatedByTemplateCount - the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32 `json:"alertRulesCreatedByTemplateCount,omitempty"`
	// LastUpdatedDateUTC - READ-ONLY; The last time that this alert rule template has been updated.
	LastUpdatedDateUTC *date.Time `json:"lastUpdatedDateUTC,omitempty"`
	// CreatedDateUTC - READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *date.Time `json:"createdDateUTC,omitempty"`
	// Description - The description of the alert rule template.
	Description *string `json:"description,omitempty"`
	// DisplayName - The display name for alert rule template.
	DisplayName *string `json:"displayName,omitempty"`
	// RequiredDataConnectors - The required data sources for this template
	RequiredDataConnectors *[]AlertRuleTemplateDataSource `json:"requiredDataConnectors,omitempty"`
	// Status - The alert rule template status. Possible values include: 'TemplateStatusInstalled', 'TemplateStatusAvailable', 'TemplateStatusNotAvailable'
	Status TemplateStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceAlertRuleTemplateProperties.
func (tiart ThreatIntelligenceAlertRuleTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tiart.Severity != "" {
		objectMap["severity"] = tiart.Severity
	}
	if tiart.Tactics != nil {
		objectMap["tactics"] = tiart.Tactics
	}
	if tiart.AlertRulesCreatedByTemplateCount != nil {
		objectMap["alertRulesCreatedByTemplateCount"] = tiart.AlertRulesCreatedByTemplateCount
	}
	if tiart.Description != nil {
		objectMap["description"] = tiart.Description
	}
	if tiart.DisplayName != nil {
		objectMap["displayName"] = tiart.DisplayName
	}
	if tiart.RequiredDataConnectors != nil {
		objectMap["requiredDataConnectors"] = tiart.RequiredDataConnectors
	}
	if tiart.Status != "" {
		objectMap["status"] = tiart.Status
	}
	return json.Marshal(objectMap)
}

// ThreatIntelligenceAppendTags array of tags to be appended to the threat intelligence indicator.
type ThreatIntelligenceAppendTags struct {
	// ThreatIntelligenceTags - List of tags to be appended.
	ThreatIntelligenceTags *[]string `json:"threatIntelligenceTags,omitempty"`
}

// ThreatIntelligenceExternalReference describes external reference
type ThreatIntelligenceExternalReference struct {
	// Description - External reference description
	Description *string `json:"description,omitempty"`
	// ExternalID - External reference ID
	ExternalID *string `json:"externalId,omitempty"`
	// SourceName - External reference source name
	SourceName *string `json:"sourceName,omitempty"`
	// URL - External reference URL
	URL *string `json:"url,omitempty"`
	// Hashes - External reference hashes
	Hashes map[string]*string `json:"hashes"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceExternalReference.
func (tier ThreatIntelligenceExternalReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tier.Description != nil {
		objectMap["description"] = tier.Description
	}
	if tier.ExternalID != nil {
		objectMap["externalId"] = tier.ExternalID
	}
	if tier.SourceName != nil {
		objectMap["sourceName"] = tier.SourceName
	}
	if tier.URL != nil {
		objectMap["url"] = tier.URL
	}
	if tier.Hashes != nil {
		objectMap["hashes"] = tier.Hashes
	}
	return json.Marshal(objectMap)
}

// ThreatIntelligenceFilteringCriteria filtering criteria for querying threat intelligence indicators.
type ThreatIntelligenceFilteringCriteria struct {
	// PageSize - Page size
	PageSize *int32 `json:"pageSize,omitempty"`
	// MinConfidence - Minimum confidence.
	MinConfidence *int32 `json:"minConfidence,omitempty"`
	// MaxConfidence - Maximum confidence.
	MaxConfidence *int32 `json:"maxConfidence,omitempty"`
	// MinValidUntil - Start time for ValidUntil filter.
	MinValidUntil *string `json:"minValidUntil,omitempty"`
	// MaxValidUntil - End time for ValidUntil filter.
	MaxValidUntil *string `json:"maxValidUntil,omitempty"`
	// IncludeDisabled - Parameter to include/exclude disabled indicators.
	IncludeDisabled *bool `json:"includeDisabled,omitempty"`
	// SortBy - Columns to sort by and sorting order
	SortBy *[]ThreatIntelligenceSortingCriteria1 `json:"sortBy,omitempty"`
	// Sources - Sources of threat intelligence indicators
	Sources *[]string `json:"sources,omitempty"`
	// PatternTypes - Pattern types
	PatternTypes *[]string `json:"patternTypes,omitempty"`
	// ThreatTypes - Threat types of threat intelligence indicators
	ThreatTypes *[]string `json:"threatTypes,omitempty"`
	// Ids - Ids of threat intelligence indicators
	Ids *[]string `json:"ids,omitempty"`
	// Keywords - Keywords for searching threat intelligence indicators
	Keywords *[]string `json:"keywords,omitempty"`
	// SkipToken - Skip token.
	SkipToken *string `json:"skipToken,omitempty"`
}

// ThreatIntelligenceGranularMarkingModel describes threat granular marking model entity
type ThreatIntelligenceGranularMarkingModel struct {
	// Language - Language granular marking model
	Language *string `json:"language,omitempty"`
	// MarkingRef - marking reference granular marking model
	MarkingRef *int32 `json:"markingRef,omitempty"`
	// Selectors - granular marking model selectors
	Selectors *[]string `json:"selectors,omitempty"`
}

// ThreatIntelligenceIndicatorModel threat intelligence indicator entity.
type ThreatIntelligenceIndicatorModel struct {
	// ThreatIntelligenceIndicatorProperties - Threat Intelligence Entity properties
	*ThreatIntelligenceIndicatorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation', 'KindBasicThreatIntelligenceInformationKindIndicator'
	Kind KindBasicThreatIntelligenceInformation `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceIndicatorModel.
func (tiim ThreatIntelligenceIndicatorModel) MarshalJSON() ([]byte, error) {
	tiim.Kind = KindBasicThreatIntelligenceInformationKindIndicator
	objectMap := make(map[string]interface{})
	if tiim.ThreatIntelligenceIndicatorProperties != nil {
		objectMap["properties"] = tiim.ThreatIntelligenceIndicatorProperties
	}
	if tiim.Etag != nil {
		objectMap["etag"] = tiim.Etag
	}
	if tiim.Kind != "" {
		objectMap["kind"] = tiim.Kind
	}
	return json.Marshal(objectMap)
}

// AsThreatIntelligenceIndicatorModel is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceIndicatorModel.
func (tiim ThreatIntelligenceIndicatorModel) AsThreatIntelligenceIndicatorModel() (*ThreatIntelligenceIndicatorModel, bool) {
	return &tiim, true
}

// AsThreatIntelligenceInformation is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceIndicatorModel.
func (tiim ThreatIntelligenceIndicatorModel) AsThreatIntelligenceInformation() (*ThreatIntelligenceInformation, bool) {
	return nil, false
}

// AsBasicThreatIntelligenceInformation is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceIndicatorModel.
func (tiim ThreatIntelligenceIndicatorModel) AsBasicThreatIntelligenceInformation() (BasicThreatIntelligenceInformation, bool) {
	return &tiim, true
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceIndicatorModel struct.
func (tiim *ThreatIntelligenceIndicatorModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var threatIntelligenceIndicatorProperties ThreatIntelligenceIndicatorProperties
				err = json.Unmarshal(*v, &threatIntelligenceIndicatorProperties)
				if err != nil {
					return err
				}
				tiim.ThreatIntelligenceIndicatorProperties = &threatIntelligenceIndicatorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tiim.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tiim.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tiim.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tiim.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicThreatIntelligenceInformation
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tiim.Kind = kind
			}
		}
	}

	return nil
}

// ThreatIntelligenceIndicatorModelForRequestBody threat intelligence indicator entity used in request
// body.
type ThreatIntelligenceIndicatorModelForRequestBody struct {
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// ThreatIntelligenceIndicatorProperties - Threat Intelligence Entity properties
	*ThreatIntelligenceIndicatorProperties `json:"properties,omitempty"`
	// Kind - The kind of the entity.
	Kind *string `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceIndicatorModelForRequestBody.
func (tiimfrb ThreatIntelligenceIndicatorModelForRequestBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tiimfrb.Etag != nil {
		objectMap["etag"] = tiimfrb.Etag
	}
	if tiimfrb.ThreatIntelligenceIndicatorProperties != nil {
		objectMap["properties"] = tiimfrb.ThreatIntelligenceIndicatorProperties
	}
	if tiimfrb.Kind != nil {
		objectMap["kind"] = tiimfrb.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceIndicatorModelForRequestBody struct.
func (tiimfrb *ThreatIntelligenceIndicatorModelForRequestBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tiimfrb.Etag = &etag
			}
		case "properties":
			if v != nil {
				var threatIntelligenceIndicatorProperties ThreatIntelligenceIndicatorProperties
				err = json.Unmarshal(*v, &threatIntelligenceIndicatorProperties)
				if err != nil {
					return err
				}
				tiimfrb.ThreatIntelligenceIndicatorProperties = &threatIntelligenceIndicatorProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tiimfrb.Kind = &kind
			}
		}
	}

	return nil
}

// ThreatIntelligenceIndicatorProperties describes threat intelligence entity properties
type ThreatIntelligenceIndicatorProperties struct {
	// ThreatIntelligenceTags - List of tags
	ThreatIntelligenceTags *[]string `json:"threatIntelligenceTags,omitempty"`
	// LastUpdatedTimeUtc - Last updated time in UTC
	LastUpdatedTimeUtc *string `json:"lastUpdatedTimeUtc,omitempty"`
	// Source - Source of a threat intelligence entity
	Source *string `json:"source,omitempty"`
	// DisplayName - Display name of a threat intelligence entity
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of a threat intelligence entity
	Description *string `json:"description,omitempty"`
	// IndicatorTypes - Indicator types of threat intelligence entities
	IndicatorTypes *[]string `json:"indicatorTypes,omitempty"`
	// Pattern - Pattern of a threat intelligence entity
	Pattern *string `json:"pattern,omitempty"`
	// PatternType - Pattern type of a threat intelligence entity
	PatternType *string `json:"patternType,omitempty"`
	// PatternVersion - Pattern version of a threat intelligence entity
	PatternVersion *string `json:"patternVersion,omitempty"`
	// KillChainPhases - Kill chain phases
	KillChainPhases *[]ThreatIntelligenceKillChainPhase `json:"killChainPhases,omitempty"`
	// ParsedPattern - Parsed patterns
	ParsedPattern *[]ThreatIntelligenceParsedPattern `json:"parsedPattern,omitempty"`
	// ExternalID - External ID of threat intelligence entity
	ExternalID *string `json:"externalId,omitempty"`
	// CreatedByRef - Created by reference of threat intelligence entity
	CreatedByRef *string `json:"createdByRef,omitempty"`
	// Defanged - Is threat intelligence entity defanged
	Defanged *bool `json:"defanged,omitempty"`
	// ExternalLastUpdatedTimeUtc - External last updated time in UTC
	ExternalLastUpdatedTimeUtc *string `json:"externalLastUpdatedTimeUtc,omitempty"`
	// ExternalReferences - External References
	ExternalReferences *[]ThreatIntelligenceExternalReference `json:"externalReferences,omitempty"`
	// GranularMarkings - Granular Markings
	GranularMarkings *[]ThreatIntelligenceGranularMarkingModel `json:"granularMarkings,omitempty"`
	// Labels - Labels  of threat intelligence entity
	Labels *[]string `json:"labels,omitempty"`
	// Revoked - Is threat intelligence entity revoked
	Revoked *bool `json:"revoked,omitempty"`
	// Confidence - Confidence of threat intelligence entity
	Confidence *int32 `json:"confidence,omitempty"`
	// ObjectMarkingRefs - Threat intelligence entity object marking references
	ObjectMarkingRefs *[]string `json:"objectMarkingRefs,omitempty"`
	// Language - Language of threat intelligence entity
	Language *string `json:"language,omitempty"`
	// ThreatTypes - Threat types
	ThreatTypes *[]string `json:"threatTypes,omitempty"`
	// ValidFrom - Valid from
	ValidFrom *string `json:"validFrom,omitempty"`
	// ValidUntil - Valid until
	ValidUntil *string `json:"validUntil,omitempty"`
	// Created - Created by
	Created *string `json:"created,omitempty"`
	// Modified - Modified by
	Modified *string `json:"modified,omitempty"`
	// Extensions - Extensions map
	Extensions map[string]interface{} `json:"extensions"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceIndicatorProperties.
func (tiip ThreatIntelligenceIndicatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tiip.ThreatIntelligenceTags != nil {
		objectMap["threatIntelligenceTags"] = tiip.ThreatIntelligenceTags
	}
	if tiip.LastUpdatedTimeUtc != nil {
		objectMap["lastUpdatedTimeUtc"] = tiip.LastUpdatedTimeUtc
	}
	if tiip.Source != nil {
		objectMap["source"] = tiip.Source
	}
	if tiip.DisplayName != nil {
		objectMap["displayName"] = tiip.DisplayName
	}
	if tiip.Description != nil {
		objectMap["description"] = tiip.Description
	}
	if tiip.IndicatorTypes != nil {
		objectMap["indicatorTypes"] = tiip.IndicatorTypes
	}
	if tiip.Pattern != nil {
		objectMap["pattern"] = tiip.Pattern
	}
	if tiip.PatternType != nil {
		objectMap["patternType"] = tiip.PatternType
	}
	if tiip.PatternVersion != nil {
		objectMap["patternVersion"] = tiip.PatternVersion
	}
	if tiip.KillChainPhases != nil {
		objectMap["killChainPhases"] = tiip.KillChainPhases
	}
	if tiip.ParsedPattern != nil {
		objectMap["parsedPattern"] = tiip.ParsedPattern
	}
	if tiip.ExternalID != nil {
		objectMap["externalId"] = tiip.ExternalID
	}
	if tiip.CreatedByRef != nil {
		objectMap["createdByRef"] = tiip.CreatedByRef
	}
	if tiip.Defanged != nil {
		objectMap["defanged"] = tiip.Defanged
	}
	if tiip.ExternalLastUpdatedTimeUtc != nil {
		objectMap["externalLastUpdatedTimeUtc"] = tiip.ExternalLastUpdatedTimeUtc
	}
	if tiip.ExternalReferences != nil {
		objectMap["externalReferences"] = tiip.ExternalReferences
	}
	if tiip.GranularMarkings != nil {
		objectMap["granularMarkings"] = tiip.GranularMarkings
	}
	if tiip.Labels != nil {
		objectMap["labels"] = tiip.Labels
	}
	if tiip.Revoked != nil {
		objectMap["revoked"] = tiip.Revoked
	}
	if tiip.Confidence != nil {
		objectMap["confidence"] = tiip.Confidence
	}
	if tiip.ObjectMarkingRefs != nil {
		objectMap["objectMarkingRefs"] = tiip.ObjectMarkingRefs
	}
	if tiip.Language != nil {
		objectMap["language"] = tiip.Language
	}
	if tiip.ThreatTypes != nil {
		objectMap["threatTypes"] = tiip.ThreatTypes
	}
	if tiip.ValidFrom != nil {
		objectMap["validFrom"] = tiip.ValidFrom
	}
	if tiip.ValidUntil != nil {
		objectMap["validUntil"] = tiip.ValidUntil
	}
	if tiip.Created != nil {
		objectMap["created"] = tiip.Created
	}
	if tiip.Modified != nil {
		objectMap["modified"] = tiip.Modified
	}
	if tiip.Extensions != nil {
		objectMap["extensions"] = tiip.Extensions
	}
	return json.Marshal(objectMap)
}

// BasicThreatIntelligenceInformation threat intelligence information object.
type BasicThreatIntelligenceInformation interface {
	AsThreatIntelligenceIndicatorModel() (*ThreatIntelligenceIndicatorModel, bool)
	AsThreatIntelligenceInformation() (*ThreatIntelligenceInformation, bool)
}

// ThreatIntelligenceInformation threat intelligence information object.
type ThreatIntelligenceInformation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation', 'KindBasicThreatIntelligenceInformationKindIndicator'
	Kind KindBasicThreatIntelligenceInformation `json:"kind,omitempty"`
}

func unmarshalBasicThreatIntelligenceInformation(body []byte) (BasicThreatIntelligenceInformation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBasicThreatIntelligenceInformationKindIndicator):
		var tiim ThreatIntelligenceIndicatorModel
		err := json.Unmarshal(body, &tiim)
		return tiim, err
	default:
		var tii ThreatIntelligenceInformation
		err := json.Unmarshal(body, &tii)
		return tii, err
	}
}
func unmarshalBasicThreatIntelligenceInformationArray(body []byte) ([]BasicThreatIntelligenceInformation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tiiArray := make([]BasicThreatIntelligenceInformation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tii, err := unmarshalBasicThreatIntelligenceInformation(*rawMessage)
		if err != nil {
			return nil, err
		}
		tiiArray[index] = tii
	}
	return tiiArray, nil
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceInformation.
func (tii ThreatIntelligenceInformation) MarshalJSON() ([]byte, error) {
	tii.Kind = KindBasicThreatIntelligenceInformationKindThreatIntelligenceInformation
	objectMap := make(map[string]interface{})
	if tii.Etag != nil {
		objectMap["etag"] = tii.Etag
	}
	if tii.Kind != "" {
		objectMap["kind"] = tii.Kind
	}
	return json.Marshal(objectMap)
}

// AsThreatIntelligenceIndicatorModel is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceInformation.
func (tii ThreatIntelligenceInformation) AsThreatIntelligenceIndicatorModel() (*ThreatIntelligenceIndicatorModel, bool) {
	return nil, false
}

// AsThreatIntelligenceInformation is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceInformation.
func (tii ThreatIntelligenceInformation) AsThreatIntelligenceInformation() (*ThreatIntelligenceInformation, bool) {
	return &tii, true
}

// AsBasicThreatIntelligenceInformation is the BasicThreatIntelligenceInformation implementation for ThreatIntelligenceInformation.
func (tii ThreatIntelligenceInformation) AsBasicThreatIntelligenceInformation() (BasicThreatIntelligenceInformation, bool) {
	return &tii, true
}

// ThreatIntelligenceInformationList list of all the threat intelligence information objects.
type ThreatIntelligenceInformationList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of information objects.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of threat intelligence information objects.
	Value *[]BasicThreatIntelligenceInformation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for ThreatIntelligenceInformationList.
func (tiil ThreatIntelligenceInformationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tiil.Value != nil {
		objectMap["value"] = tiil.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceInformationList struct.
func (tiil *ThreatIntelligenceInformationList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				tiil.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicThreatIntelligenceInformationArray(*v)
				if err != nil {
					return err
				}
				tiil.Value = &value
			}
		}
	}

	return nil
}

// ThreatIntelligenceInformationListIterator provides access to a complete listing of
// ThreatIntelligenceInformation values.
type ThreatIntelligenceInformationListIterator struct {
	i    int
	page ThreatIntelligenceInformationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ThreatIntelligenceInformationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ThreatIntelligenceInformationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ThreatIntelligenceInformationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ThreatIntelligenceInformationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ThreatIntelligenceInformationListIterator) Response() ThreatIntelligenceInformationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ThreatIntelligenceInformationListIterator) Value() BasicThreatIntelligenceInformation {
	if !iter.page.NotDone() {
		return ThreatIntelligenceInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ThreatIntelligenceInformationListIterator type.
func NewThreatIntelligenceInformationListIterator(page ThreatIntelligenceInformationListPage) ThreatIntelligenceInformationListIterator {
	return ThreatIntelligenceInformationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tiil ThreatIntelligenceInformationList) IsEmpty() bool {
	return tiil.Value == nil || len(*tiil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tiil ThreatIntelligenceInformationList) hasNextLink() bool {
	return tiil.NextLink != nil && len(*tiil.NextLink) != 0
}

// threatIntelligenceInformationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tiil ThreatIntelligenceInformationList) threatIntelligenceInformationListPreparer(ctx context.Context) (*http.Request, error) {
	if !tiil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tiil.NextLink)))
}

// ThreatIntelligenceInformationListPage contains a page of BasicThreatIntelligenceInformation values.
type ThreatIntelligenceInformationListPage struct {
	fn   func(context.Context, ThreatIntelligenceInformationList) (ThreatIntelligenceInformationList, error)
	tiil ThreatIntelligenceInformationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ThreatIntelligenceInformationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ThreatIntelligenceInformationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tiil)
		if err != nil {
			return err
		}
		page.tiil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ThreatIntelligenceInformationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ThreatIntelligenceInformationListPage) NotDone() bool {
	return !page.tiil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ThreatIntelligenceInformationListPage) Response() ThreatIntelligenceInformationList {
	return page.tiil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ThreatIntelligenceInformationListPage) Values() []BasicThreatIntelligenceInformation {
	if page.tiil.IsEmpty() {
		return nil
	}
	return *page.tiil.Value
}

// Creates a new instance of the ThreatIntelligenceInformationListPage type.
func NewThreatIntelligenceInformationListPage(cur ThreatIntelligenceInformationList, getNextPage func(context.Context, ThreatIntelligenceInformationList) (ThreatIntelligenceInformationList, error)) ThreatIntelligenceInformationListPage {
	return ThreatIntelligenceInformationListPage{
		fn:   getNextPage,
		tiil: cur,
	}
}

// ThreatIntelligenceInformationModel ...
type ThreatIntelligenceInformationModel struct {
	autorest.Response `json:"-"`
	Value             BasicThreatIntelligenceInformation `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ThreatIntelligenceInformationModel struct.
func (tiim *ThreatIntelligenceInformationModel) UnmarshalJSON(body []byte) error {
	tii, err := unmarshalBasicThreatIntelligenceInformation(body)
	if err != nil {
		return err
	}
	tiim.Value = tii

	return nil
}

// ThreatIntelligenceKillChainPhase describes threat kill chain phase entity
type ThreatIntelligenceKillChainPhase struct {
	// KillChainName - Kill chainName name
	KillChainName *string `json:"killChainName,omitempty"`
	// PhaseName - Phase name
	PhaseName *string `json:"phaseName,omitempty"`
}

// ThreatIntelligenceMetric describes threat intelligence metric
type ThreatIntelligenceMetric struct {
	// LastUpdatedTimeUtc - Last updated indicator metric
	LastUpdatedTimeUtc *string `json:"lastUpdatedTimeUtc,omitempty"`
	// ThreatTypeMetrics - Threat type metrics
	ThreatTypeMetrics *[]ThreatIntelligenceMetricEntity `json:"threatTypeMetrics,omitempty"`
	// PatternTypeMetrics - Pattern type metrics
	PatternTypeMetrics *[]ThreatIntelligenceMetricEntity `json:"patternTypeMetrics,omitempty"`
	// SourceMetrics - Source metrics
	SourceMetrics *[]ThreatIntelligenceMetricEntity `json:"sourceMetrics,omitempty"`
}

// ThreatIntelligenceMetricEntity describes threat intelligence metric entity
type ThreatIntelligenceMetricEntity struct {
	// MetricName - Metric name
	MetricName *string `json:"metricName,omitempty"`
	// MetricValue - Metric value
	MetricValue *int32 `json:"metricValue,omitempty"`
}

// ThreatIntelligenceMetrics threat intelligence metrics.
type ThreatIntelligenceMetrics struct {
	// Properties - Threat intelligence metrics.
	Properties *ThreatIntelligenceMetric `json:"properties,omitempty"`
}

// ThreatIntelligenceMetricsList list of all the threat intelligence metric fields (type/threat
// type/source).
type ThreatIntelligenceMetricsList struct {
	autorest.Response `json:"-"`
	// Value - Array of threat intelligence metric fields (type/threat type/source).
	Value *[]ThreatIntelligenceMetrics `json:"value,omitempty"`
}

// ThreatIntelligenceParsedPattern describes parsed pattern entity
type ThreatIntelligenceParsedPattern struct {
	// PatternTypeKey - Pattern type key
	PatternTypeKey *string `json:"patternTypeKey,omitempty"`
	// PatternTypeValues - Pattern type keys
	PatternTypeValues *[]ThreatIntelligenceParsedPatternTypeValue `json:"patternTypeValues,omitempty"`
}

// ThreatIntelligenceParsedPatternTypeValue describes threat kill chain phase entity
type ThreatIntelligenceParsedPatternTypeValue struct {
	// ValueType - Type of the value
	ValueType *string `json:"valueType,omitempty"`
	// Value - Value of parsed pattern
	Value *string `json:"value,omitempty"`
}

// ThreatIntelligenceResourceKind1 describes an entity with kind.
type ThreatIntelligenceResourceKind1 struct {
	// Kind - The kind of the entity.
	Kind *string `json:"kind,omitempty"`
}

// ThreatIntelligenceSortingCriteria1 list of available columns for sorting
type ThreatIntelligenceSortingCriteria1 struct {
	// ItemKey - Column name
	ItemKey *string `json:"itemKey,omitempty"`
	// SortOrder - Sorting order (ascending/descending/unsorted). Possible values include: 'ThreatIntelligenceSortingCriteriaUnsorted', 'ThreatIntelligenceSortingCriteriaAscending', 'ThreatIntelligenceSortingCriteriaDescending'
	SortOrder ThreatIntelligenceSortingCriteria `json:"sortOrder,omitempty"`
}

// TICheckRequirements threat Intelligence Platforms data connector check requirements
type TICheckRequirements struct {
	// TICheckRequirementsProperties - Threat Intelligence Platforms data connector check required properties
	*TICheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TICheckRequirements.
func (tcr TICheckRequirements) MarshalJSON() ([]byte, error) {
	tcr.Kind = KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tcr.TICheckRequirementsProperties != nil {
		objectMap["properties"] = tcr.TICheckRequirementsProperties
	}
	if tcr.Kind != "" {
		objectMap["kind"] = tcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return &tcr, true
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return nil, false
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TICheckRequirements.
func (tcr TICheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &tcr, true
}

// UnmarshalJSON is the custom unmarshaler for TICheckRequirements struct.
func (tcr *TICheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tICheckRequirementsProperties TICheckRequirementsProperties
				err = json.Unmarshal(*v, &tICheckRequirementsProperties)
				if err != nil {
					return err
				}
				tcr.TICheckRequirementsProperties = &tICheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tcr.Kind = kind
			}
		}
	}

	return nil
}

// TICheckRequirementsProperties threat Intelligence Platforms data connector required properties.
type TICheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// TIDataConnector data connector to pull threat intelligence data from TIP products.
type TIDataConnector struct {
	// TIDataConnectorProperties - Threat Intelligence Platforms data connector properties.
	*TIDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TIDataConnector.
func (tdc TIDataConnector) MarshalJSON() ([]byte, error) {
	tdc.Kind = KindBasicDataConnectorKindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tdc.TIDataConnectorProperties != nil {
		objectMap["properties"] = tdc.TIDataConnectorProperties
	}
	if tdc.Etag != nil {
		objectMap["etag"] = tdc.Etag
	}
	if tdc.Kind != "" {
		objectMap["kind"] = tdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return &tdc, true
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &tdc, true
}

// UnmarshalJSON is the custom unmarshaler for TIDataConnector struct.
func (tdc *TIDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tIDataConnectorProperties TIDataConnectorProperties
				err = json.Unmarshal(*v, &tIDataConnectorProperties)
				if err != nil {
					return err
				}
				tdc.TIDataConnectorProperties = &tIDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tdc.Kind = kind
			}
		}
	}

	return nil
}

// TIDataConnectorDataTypes the available data types for Threat Intelligence Platforms data connector.
type TIDataConnectorDataTypes struct {
	// Indicators - Data type for Threat Intelligence Platforms data connector.
	Indicators *TIDataConnectorDataTypesIndicators `json:"indicators,omitempty"`
}

// TIDataConnectorDataTypesIndicators data type for Threat Intelligence Platforms data connector.
type TIDataConnectorDataTypesIndicators struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// TIDataConnectorProperties TI (Threat Intelligence) data connector properties.
type TIDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// TipLookbackPeriod - The lookback period for the feed to be imported.
	TipLookbackPeriod *date.Time `json:"tipLookbackPeriod,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *TIDataConnectorDataTypes `json:"dataTypes,omitempty"`
}

// TimelineAggregation timeline aggregation information per kind
type TimelineAggregation struct {
	// Count - the total items found for a kind
	Count *int32 `json:"count,omitempty"`
	// Kind - the query kind. Possible values include: 'EntityTimelineKindActivity', 'EntityTimelineKindBookmark', 'EntityTimelineKindSecurityAlert'
	Kind EntityTimelineKind `json:"kind,omitempty"`
}

// TimelineError timeline Query Errors.
type TimelineError struct {
	// Kind - the query kind. Possible values include: 'EntityTimelineKindActivity', 'EntityTimelineKindBookmark', 'EntityTimelineKindSecurityAlert'
	Kind EntityTimelineKind `json:"kind,omitempty"`
	// QueryID - the query id
	QueryID *string `json:"queryId,omitempty"`
	// ErrorMessage - the error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// TimelineResultsMetadata expansion result metadata.
type TimelineResultsMetadata struct {
	// TotalCount - the total items found for the timeline request
	TotalCount *int32 `json:"totalCount,omitempty"`
	// Aggregations - timeline aggregation per kind
	Aggregations *[]TimelineAggregation `json:"aggregations,omitempty"`
	// Errors - information about the failure queries
	Errors *[]TimelineError `json:"errors,omitempty"`
}

// TiTaxiiCheckRequirements threat Intelligence TAXII data connector check requirements
type TiTaxiiCheckRequirements struct {
	// TiTaxiiCheckRequirementsProperties - Threat Intelligence TAXII check required properties.
	*TiTaxiiCheckRequirementsProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements', 'KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory', 'KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter', 'KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorsCheckRequirementsKindDynamics365', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorsCheckRequirementsKindOfficeATP', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence', 'KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnectorsCheckRequirements `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) MarshalJSON() ([]byte, error) {
	ttcr.Kind = KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii
	objectMap := make(map[string]interface{})
	if ttcr.TiTaxiiCheckRequirementsProperties != nil {
		objectMap["properties"] = ttcr.TiTaxiiCheckRequirementsProperties
	}
	if ttcr.Kind != "" {
		objectMap["kind"] = ttcr.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAADCheckRequirements() (*AADCheckRequirements, bool) {
	return nil, false
}

// AsAATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAATPCheckRequirements() (*AATPCheckRequirements, bool) {
	return nil, false
}

// AsMSTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMSTICheckRequirements() (*MSTICheckRequirements, bool) {
	return nil, false
}

// AsMtpCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMtpCheckRequirements() (*MtpCheckRequirements, bool) {
	return nil, false
}

// AsASCCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsASCCheckRequirements() (*ASCCheckRequirements, bool) {
	return nil, false
}

// AsAwsCloudTrailCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsAwsCloudTrailCheckRequirements() (*AwsCloudTrailCheckRequirements, bool) {
	return nil, false
}

// AsDynamics365CheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsDynamics365CheckRequirements() (*Dynamics365CheckRequirements, bool) {
	return nil, false
}

// AsMCASCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMCASCheckRequirements() (*MCASCheckRequirements, bool) {
	return nil, false
}

// AsMDATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsMDATPCheckRequirements() (*MDATPCheckRequirements, bool) {
	return nil, false
}

// AsOfficeATPCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsOfficeATPCheckRequirements() (*OfficeATPCheckRequirements, bool) {
	return nil, false
}

// AsTICheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsTICheckRequirements() (*TICheckRequirements, bool) {
	return nil, false
}

// AsTiTaxiiCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsTiTaxiiCheckRequirements() (*TiTaxiiCheckRequirements, bool) {
	return &ttcr, true
}

// AsDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsDataConnectorsCheckRequirements() (*DataConnectorsCheckRequirements, bool) {
	return nil, false
}

// AsBasicDataConnectorsCheckRequirements is the BasicDataConnectorsCheckRequirements implementation for TiTaxiiCheckRequirements.
func (ttcr TiTaxiiCheckRequirements) AsBasicDataConnectorsCheckRequirements() (BasicDataConnectorsCheckRequirements, bool) {
	return &ttcr, true
}

// UnmarshalJSON is the custom unmarshaler for TiTaxiiCheckRequirements struct.
func (ttcr *TiTaxiiCheckRequirements) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tiTaxiiCheckRequirementsProperties TiTaxiiCheckRequirementsProperties
				err = json.Unmarshal(*v, &tiTaxiiCheckRequirementsProperties)
				if err != nil {
					return err
				}
				ttcr.TiTaxiiCheckRequirementsProperties = &tiTaxiiCheckRequirementsProperties
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnectorsCheckRequirements
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ttcr.Kind = kind
			}
		}
	}

	return nil
}

// TiTaxiiCheckRequirementsProperties threat Intelligence TAXII data connector required properties.
type TiTaxiiCheckRequirementsProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// TiTaxiiDataConnector data connector to pull Threat intelligence data from TAXII 2.0/2.1 server
type TiTaxiiDataConnector struct {
	// TiTaxiiDataConnectorProperties - Threat intelligence TAXII data connector properties.
	*TiTaxiiDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicDataConnectorKindDataConnector', 'KindBasicDataConnectorKindAzureActiveDirectory', 'KindBasicDataConnectorKindAzureAdvancedThreatProtection', 'KindBasicDataConnectorKindMicrosoftThreatIntelligence', 'KindBasicDataConnectorKindMicrosoftThreatProtection', 'KindBasicDataConnectorKindAzureSecurityCenter', 'KindBasicDataConnectorKindAmazonWebServicesCloudTrail', 'KindBasicDataConnectorKindDynamics365', 'KindBasicDataConnectorKindMicrosoftCloudAppSecurity', 'KindBasicDataConnectorKindMicrosoftDefenderAdvancedThreatProtection', 'KindBasicDataConnectorKindOfficeATP', 'KindBasicDataConnectorKindOffice365', 'KindBasicDataConnectorKindThreatIntelligence', 'KindBasicDataConnectorKindThreatIntelligenceTaxii'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) MarshalJSON() ([]byte, error) {
	ttdc.Kind = KindBasicDataConnectorKindThreatIntelligenceTaxii
	objectMap := make(map[string]interface{})
	if ttdc.TiTaxiiDataConnectorProperties != nil {
		objectMap["properties"] = ttdc.TiTaxiiDataConnectorProperties
	}
	if ttdc.Etag != nil {
		objectMap["etag"] = ttdc.Etag
	}
	if ttdc.Kind != "" {
		objectMap["kind"] = ttdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsAADDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsAATPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAATPDataConnector() (*AATPDataConnector, bool) {
	return nil, false
}

// AsMSTIDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMSTIDataConnector() (*MSTIDataConnector, bool) {
	return nil, false
}

// AsMTPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMTPDataConnector() (*MTPDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsAwsCloudTrailDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsAwsCloudTrailDataConnector() (*AwsCloudTrailDataConnector, bool) {
	return nil, false
}

// AsDynamics365DataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsDynamics365DataConnector() (*Dynamics365DataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsMDATPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsMDATPDataConnector() (*MDATPDataConnector, bool) {
	return nil, false
}

// AsOfficeATPDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsOfficeATPDataConnector() (*OfficeATPDataConnector, bool) {
	return nil, false
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsTiTaxiiDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsTiTaxiiDataConnector() (*TiTaxiiDataConnector, bool) {
	return &ttdc, true
}

// AsDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TiTaxiiDataConnector.
func (ttdc TiTaxiiDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &ttdc, true
}

// UnmarshalJSON is the custom unmarshaler for TiTaxiiDataConnector struct.
func (ttdc *TiTaxiiDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tiTaxiiDataConnectorProperties TiTaxiiDataConnectorProperties
				err = json.Unmarshal(*v, &tiTaxiiDataConnectorProperties)
				if err != nil {
					return err
				}
				ttdc.TiTaxiiDataConnectorProperties = &tiTaxiiDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ttdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ttdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ttdc.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ttdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ttdc.Kind = kind
			}
		}
	}

	return nil
}

// TiTaxiiDataConnectorDataTypes the available data types for Threat Intelligence TAXII data connector.
type TiTaxiiDataConnectorDataTypes struct {
	// TaxiiClient - Data type for TAXII connector.
	TaxiiClient *TiTaxiiDataConnectorDataTypesTaxiiClient `json:"taxiiClient,omitempty"`
}

// TiTaxiiDataConnectorDataTypesTaxiiClient data type for TAXII connector.
type TiTaxiiDataConnectorDataTypesTaxiiClient struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'DataTypeStateEnabled', 'DataTypeStateDisabled'
	State DataTypeState `json:"state,omitempty"`
}

// TiTaxiiDataConnectorProperties threat Intelligence TAXII data connector properties.
type TiTaxiiDataConnectorProperties struct {
	// WorkspaceID - The workspace id.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// FriendlyName - The friendly name for the TAXII server.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TaxiiServer - The API root for the TAXII server.
	TaxiiServer *string `json:"taxiiServer,omitempty"`
	// CollectionID - The collection id of the TAXII server.
	CollectionID *string `json:"collectionId,omitempty"`
	// UserName - The userName for the TAXII server.
	UserName *string `json:"userName,omitempty"`
	// Password - The password for the TAXII server.
	Password *string `json:"password,omitempty"`
	// TaxiiLookbackPeriod - The lookback period for the TAXII server.
	TaxiiLookbackPeriod *date.Time `json:"taxiiLookbackPeriod,omitempty"`
	// PollingFrequency - The polling frequency for the TAXII server. Possible values include: 'PollingFrequencyOnceAMinute', 'PollingFrequencyOnceAnHour', 'PollingFrequencyOnceADay'
	PollingFrequency PollingFrequency `json:"pollingFrequency,omitempty"`
	// DataTypes - The available data types for Threat Intelligence TAXII data connector.
	DataTypes *TiTaxiiDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// Ueba settings with single toggle.
type Ueba struct {
	// UebaProperties - Ueba properties
	*UebaProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindBasicSettingsKindSettings', 'KindBasicSettingsKindIPSyncer', 'KindBasicSettingsKindEyesOn', 'KindBasicSettingsKindEntityAnalytics', 'KindBasicSettingsKindUeba'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for Ueba.
func (u Ueba) MarshalJSON() ([]byte, error) {
	u.Kind = KindBasicSettingsKindUeba
	objectMap := make(map[string]interface{})
	if u.UebaProperties != nil {
		objectMap["properties"] = u.UebaProperties
	}
	if u.Etag != nil {
		objectMap["etag"] = u.Etag
	}
	if u.Kind != "" {
		objectMap["kind"] = u.Kind
	}
	return json.Marshal(objectMap)
}

// AsIPSyncer is the BasicSettings implementation for Ueba.
func (u Ueba) AsIPSyncer() (*IPSyncer, bool) {
	return nil, false
}

// AsEyesOn is the BasicSettings implementation for Ueba.
func (u Ueba) AsEyesOn() (*EyesOn, bool) {
	return nil, false
}

// AsEntityAnalytics is the BasicSettings implementation for Ueba.
func (u Ueba) AsEntityAnalytics() (*EntityAnalytics, bool) {
	return nil, false
}

// AsUeba is the BasicSettings implementation for Ueba.
func (u Ueba) AsUeba() (*Ueba, bool) {
	return &u, true
}

// AsSettings is the BasicSettings implementation for Ueba.
func (u Ueba) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for Ueba.
func (u Ueba) AsBasicSettings() (BasicSettings, bool) {
	return &u, true
}

// UnmarshalJSON is the custom unmarshaler for Ueba struct.
func (u *Ueba) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var uebaProperties UebaProperties
				err = json.Unmarshal(*v, &uebaProperties)
				if err != nil {
					return err
				}
				u.UebaProperties = &uebaProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				u.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = kind
			}
		}
	}

	return nil
}

// UebaProperties ueba property bag.
type UebaProperties struct {
	// DataSources - The relevant data sources that enriched by ueba
	DataSources *[]UebaDataSources `json:"dataSources,omitempty"`
}

// URLEntity represents a url entity.
type URLEntity struct {
	// URLEntityProperties - Url entity properties
	*URLEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindBasicEntityKindEntity', 'KindBasicEntityKindAccount', 'KindBasicEntityKindAzureResource', 'KindBasicEntityKindCloudApplication', 'KindBasicEntityKindDNSResolution', 'KindBasicEntityKindFile', 'KindBasicEntityKindFileHash', 'KindBasicEntityKindHost', 'KindBasicEntityKindBookmark', 'KindBasicEntityKindSecurityAlert', 'KindBasicEntityKindIP', 'KindBasicEntityKindMailbox', 'KindBasicEntityKindMailCluster', 'KindBasicEntityKindMailMessage', 'KindBasicEntityKindSubmissionMail', 'KindBasicEntityKindMalware', 'KindBasicEntityKindProcess', 'KindBasicEntityKindRegistryKey', 'KindBasicEntityKindRegistryValue', 'KindBasicEntityKindSecurityGroup', 'KindBasicEntityKindURL', 'KindBasicEntityKindIoTDevice'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for URLEntity.
func (ue URLEntity) MarshalJSON() ([]byte, error) {
	ue.Kind = KindBasicEntityKindURL
	objectMap := make(map[string]interface{})
	if ue.URLEntityProperties != nil {
		objectMap["properties"] = ue.URLEntityProperties
	}
	if ue.Kind != "" {
		objectMap["kind"] = ue.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsAzureResourceEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsAzureResourceEntity() (*AzureResourceEntity, bool) {
	return nil, false
}

// AsCloudApplicationEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsCloudApplicationEntity() (*CloudApplicationEntity, bool) {
	return nil, false
}

// AsDNSEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsDNSEntity() (*DNSEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsFileHashEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsFileHashEntity() (*FileHashEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsHuntingBookmark is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsHuntingBookmark() (*HuntingBookmark, bool) {
	return nil, false
}

// AsSecurityAlert is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsSecurityAlert() (*SecurityAlert, bool) {
	return nil, false
}

// AsIPEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsIPEntity() (*IPEntity, bool) {
	return nil, false
}

// AsMailboxEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsMailboxEntity() (*MailboxEntity, bool) {
	return nil, false
}

// AsMailClusterEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsMailClusterEntity() (*MailClusterEntity, bool) {
	return nil, false
}

// AsMailMessageEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsMailMessageEntity() (*MailMessageEntity, bool) {
	return nil, false
}

// AsSubmissionMailEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsSubmissionMailEntity() (*SubmissionMailEntity, bool) {
	return nil, false
}

// AsMalwareEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsMalwareEntity() (*MalwareEntity, bool) {
	return nil, false
}

// AsProcessEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsProcessEntity() (*ProcessEntity, bool) {
	return nil, false
}

// AsRegistryKeyEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsRegistryKeyEntity() (*RegistryKeyEntity, bool) {
	return nil, false
}

// AsRegistryValueEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsRegistryValueEntity() (*RegistryValueEntity, bool) {
	return nil, false
}

// AsSecurityGroupEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsSecurityGroupEntity() (*SecurityGroupEntity, bool) {
	return nil, false
}

// AsURLEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsURLEntity() (*URLEntity, bool) {
	return &ue, true
}

// AsIoTDeviceEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsIoTDeviceEntity() (*IoTDeviceEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for URLEntity.
func (ue URLEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ue, true
}

// UnmarshalJSON is the custom unmarshaler for URLEntity struct.
func (ue *URLEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var URLEntityProperties URLEntityProperties
				err = json.Unmarshal(*v, &URLEntityProperties)
				if err != nil {
					return err
				}
				ue.URLEntityProperties = &URLEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ue.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ue.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ue.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ue.Kind = kind
			}
		}
	}

	return nil
}

// URLEntityProperties url entity property bag.
type URLEntityProperties struct {
	// URL - READ-ONLY; A full URL the entity points to
	URL *string `json:"url,omitempty"`
	// AdditionalData - READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]interface{} `json:"additionalData"`
	// FriendlyName - READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property is optional and might be system generated.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// MarshalJSON is the custom marshaler for URLEntityProperties.
func (uep URLEntityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UserInfo user information that made some action
type UserInfo struct {
	// Email - READ-ONLY; The email of the user.
	Email *string `json:"email,omitempty"`
	// Name - READ-ONLY; The name of the user.
	Name *string `json:"name,omitempty"`
	// ObjectID - The object id of the user.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserInfo.
func (UI UserInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if UI.ObjectID != nil {
		objectMap["objectId"] = UI.ObjectID
	}
	return json.Marshal(objectMap)
}

// Watchlist represents a Watchlist in Azure Security Insights.
type Watchlist struct {
	autorest.Response `json:"-"`
	// WatchlistProperties - Watchlist properties
	*WatchlistProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for Watchlist.
func (w Watchlist) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WatchlistProperties != nil {
		objectMap["properties"] = w.WatchlistProperties
	}
	if w.Etag != nil {
		objectMap["etag"] = w.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Watchlist struct.
func (w *Watchlist) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var watchlistProperties WatchlistProperties
				err = json.Unmarshal(*v, &watchlistProperties)
				if err != nil {
					return err
				}
				w.WatchlistProperties = &watchlistProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				w.Etag = &etag
			}
		}
	}

	return nil
}

// WatchlistItem represents a Watchlist item in Azure Security Insights.
type WatchlistItem struct {
	autorest.Response `json:"-"`
	// WatchlistItemProperties - Watchlist Item properties
	*WatchlistItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Etag - Etag of the azure resource
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for WatchlistItem.
func (wi WatchlistItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wi.WatchlistItemProperties != nil {
		objectMap["properties"] = wi.WatchlistItemProperties
	}
	if wi.Etag != nil {
		objectMap["etag"] = wi.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WatchlistItem struct.
func (wi *WatchlistItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var watchlistItemProperties WatchlistItemProperties
				err = json.Unmarshal(*v, &watchlistItemProperties)
				if err != nil {
					return err
				}
				wi.WatchlistItemProperties = &watchlistItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wi.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				wi.Etag = &etag
			}
		}
	}

	return nil
}

// WatchlistItemList list all the watchlist items.
type WatchlistItemList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of watchlist item.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of watchlist items.
	Value *[]WatchlistItem `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for WatchlistItemList.
func (wil WatchlistItemList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wil.Value != nil {
		objectMap["value"] = wil.Value
	}
	return json.Marshal(objectMap)
}

// WatchlistItemListIterator provides access to a complete listing of WatchlistItem values.
type WatchlistItemListIterator struct {
	i    int
	page WatchlistItemListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WatchlistItemListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WatchlistItemListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WatchlistItemListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WatchlistItemListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WatchlistItemListIterator) Response() WatchlistItemList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WatchlistItemListIterator) Value() WatchlistItem {
	if !iter.page.NotDone() {
		return WatchlistItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WatchlistItemListIterator type.
func NewWatchlistItemListIterator(page WatchlistItemListPage) WatchlistItemListIterator {
	return WatchlistItemListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wil WatchlistItemList) IsEmpty() bool {
	return wil.Value == nil || len(*wil.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wil WatchlistItemList) hasNextLink() bool {
	return wil.NextLink != nil && len(*wil.NextLink) != 0
}

// watchlistItemListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wil WatchlistItemList) watchlistItemListPreparer(ctx context.Context) (*http.Request, error) {
	if !wil.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wil.NextLink)))
}

// WatchlistItemListPage contains a page of WatchlistItem values.
type WatchlistItemListPage struct {
	fn  func(context.Context, WatchlistItemList) (WatchlistItemList, error)
	wil WatchlistItemList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WatchlistItemListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WatchlistItemListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wil)
		if err != nil {
			return err
		}
		page.wil = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WatchlistItemListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WatchlistItemListPage) NotDone() bool {
	return !page.wil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WatchlistItemListPage) Response() WatchlistItemList {
	return page.wil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WatchlistItemListPage) Values() []WatchlistItem {
	if page.wil.IsEmpty() {
		return nil
	}
	return *page.wil.Value
}

// Creates a new instance of the WatchlistItemListPage type.
func NewWatchlistItemListPage(cur WatchlistItemList, getNextPage func(context.Context, WatchlistItemList) (WatchlistItemList, error)) WatchlistItemListPage {
	return WatchlistItemListPage{
		fn:  getNextPage,
		wil: cur,
	}
}

// WatchlistItemProperties describes watchlist item properties
type WatchlistItemProperties struct {
	// WatchlistItemType - The type of the watchlist item
	WatchlistItemType *string `json:"watchlistItemType,omitempty"`
	// WatchlistItemID - The id (a Guid) of the watchlist item
	WatchlistItemID *string `json:"watchlistItemId,omitempty"`
	// TenantID - The tenantId to which the watchlist item belongs to
	TenantID *string `json:"tenantId,omitempty"`
	// IsDeleted - A flag that indicates if the watchlist item is deleted or not
	IsDeleted *bool `json:"isDeleted,omitempty"`
	// Created - The time the watchlist item was created
	Created *date.Time `json:"created,omitempty"`
	// Updated - The last time the watchlist item was updated
	Updated *date.Time `json:"updated,omitempty"`
	// CreatedBy - Describes a user that created the watchlist item
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// UpdatedBy - Describes a user that updated the watchlist item
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// ItemsKeyValue - key-value pairs for a watchlist item
	ItemsKeyValue interface{} `json:"itemsKeyValue,omitempty"`
	// EntityMapping - key-value pairs for a watchlist item entity mapping
	EntityMapping interface{} `json:"entityMapping,omitempty"`
}

// WatchlistList list all the watchlists.
type WatchlistList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of watchlists.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of watchlist.
	Value *[]Watchlist `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for WatchlistList.
func (wl WatchlistList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wl.Value != nil {
		objectMap["value"] = wl.Value
	}
	return json.Marshal(objectMap)
}

// WatchlistListIterator provides access to a complete listing of Watchlist values.
type WatchlistListIterator struct {
	i    int
	page WatchlistListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WatchlistListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WatchlistListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WatchlistListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WatchlistListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WatchlistListIterator) Response() WatchlistList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WatchlistListIterator) Value() Watchlist {
	if !iter.page.NotDone() {
		return Watchlist{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WatchlistListIterator type.
func NewWatchlistListIterator(page WatchlistListPage) WatchlistListIterator {
	return WatchlistListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wl WatchlistList) IsEmpty() bool {
	return wl.Value == nil || len(*wl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wl WatchlistList) hasNextLink() bool {
	return wl.NextLink != nil && len(*wl.NextLink) != 0
}

// watchlistListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wl WatchlistList) watchlistListPreparer(ctx context.Context) (*http.Request, error) {
	if !wl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wl.NextLink)))
}

// WatchlistListPage contains a page of Watchlist values.
type WatchlistListPage struct {
	fn func(context.Context, WatchlistList) (WatchlistList, error)
	wl WatchlistList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WatchlistListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WatchlistListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wl)
		if err != nil {
			return err
		}
		page.wl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WatchlistListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WatchlistListPage) NotDone() bool {
	return !page.wl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WatchlistListPage) Response() WatchlistList {
	return page.wl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WatchlistListPage) Values() []Watchlist {
	if page.wl.IsEmpty() {
		return nil
	}
	return *page.wl.Value
}

// Creates a new instance of the WatchlistListPage type.
func NewWatchlistListPage(cur WatchlistList, getNextPage func(context.Context, WatchlistList) (WatchlistList, error)) WatchlistListPage {
	return WatchlistListPage{
		fn: getNextPage,
		wl: cur,
	}
}

// WatchlistProperties describes watchlist properties
type WatchlistProperties struct {
	// WatchlistID - The id (a Guid) of the watchlist
	WatchlistID *string `json:"watchlistId,omitempty"`
	// DisplayName - The display name of the watchlist
	DisplayName *string `json:"displayName,omitempty"`
	// Provider - The provider of the watchlist
	Provider *string `json:"provider,omitempty"`
	// Source - The source of the watchlist. Possible values include: 'SourceLocalfile', 'SourceRemotestorage'
	Source Source `json:"source,omitempty"`
	// Created - The time the watchlist was created
	Created *date.Time `json:"created,omitempty"`
	// Updated - The last time the watchlist was updated
	Updated *date.Time `json:"updated,omitempty"`
	// CreatedBy - Describes a user that created the watchlist
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// UpdatedBy - Describes a user that updated the watchlist
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// Description - A description of the watchlist
	Description *string `json:"description,omitempty"`
	// WatchlistType - The type of the watchlist
	WatchlistType *string `json:"watchlistType,omitempty"`
	// WatchlistAlias - The alias of the watchlist
	WatchlistAlias *string `json:"watchlistAlias,omitempty"`
	// IsDeleted - A flag that indicates if the watchlist is deleted or not
	IsDeleted *bool `json:"isDeleted,omitempty"`
	// Labels - List of labels relevant to this watchlist
	Labels *[]string `json:"labels,omitempty"`
	// DefaultDuration - The default duration of a watchlist (in ISO 8601 duration format)
	DefaultDuration *string `json:"defaultDuration,omitempty"`
	// TenantID - The tenantId where the watchlist belongs to
	TenantID *string `json:"tenantId,omitempty"`
	// NumberOfLinesToSkip - The number of lines in a csv/tsv content to skip before the header
	NumberOfLinesToSkip *int32 `json:"numberOfLinesToSkip,omitempty"`
	// RawContent - The raw content that represents to watchlist items to create. In case of csv/tsv content type, it's the content of the file that will parsed by the endpoint
	RawContent *string `json:"rawContent,omitempty"`
	// ContentType - The content type of the raw content. Example : text/csv or text/tsv
	ContentType *string `json:"contentType,omitempty"`
	// UploadStatus - The status of the Watchlist upload : New, InProgress or Complete. Pls note : When a Watchlist upload status is equal to InProgress, the Watchlist cannot be deleted
	UploadStatus *string `json:"uploadStatus,omitempty"`
	// WatchlistItemsCount - The number of Watchlist Items in the Watchlist
	WatchlistItemsCount *int32 `json:"watchlistItemsCount,omitempty"`
}
