package accesscontrolapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/synapse/2020-08-01-preview/accesscontrol"
	"github.com/Azure/go-autorest/autorest"
)

// RoleAssignmentsClientAPI contains the set of methods on the RoleAssignmentsClient type.
type RoleAssignmentsClientAPI interface {
	CheckPrincipalAccess(ctx context.Context, request accesscontrol.CheckPrincipalAccessRequest) (result accesscontrol.CheckPrincipalAccessResponse, err error)
	CreateRoleAssignment(ctx context.Context, request accesscontrol.RoleAssignmentRequest, roleAssignmentID string) (result accesscontrol.RoleAssignmentDetails, err error)
	DeleteRoleAssignmentByID(ctx context.Context, roleAssignmentID string, scope string) (result autorest.Response, err error)
	GetRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result accesscontrol.RoleAssignmentDetails, err error)
	ListRoleAssignments(ctx context.Context, roleID string, principalID string, scope string, continuationToken string) (result accesscontrol.RoleAssignmentDetailsList, err error)
}

var _ RoleAssignmentsClientAPI = (*accesscontrol.RoleAssignmentsClient)(nil)

// RoleDefinitionsClientAPI contains the set of methods on the RoleDefinitionsClient type.
type RoleDefinitionsClientAPI interface {
	GetRoleDefinitionByID(ctx context.Context, roleDefinitionID string) (result accesscontrol.SynapseRoleDefinition, err error)
	ListRoleDefinitions(ctx context.Context, isBuiltIn *bool, scope string) (result accesscontrol.ListSynapseRoleDefinition, err error)
	ListScopes(ctx context.Context) (result accesscontrol.ListString, err error)
}

var _ RoleDefinitionsClientAPI = (*accesscontrol.RoleDefinitionsClient)(nil)
