package accesscontrol

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleAssignmentsClient is the client for the RoleAssignments methods of the Accesscontrol service.
type RoleAssignmentsClient struct {
	BaseClient
}

// NewRoleAssignmentsClient creates an instance of the RoleAssignmentsClient client.
func NewRoleAssignmentsClient(endpoint string) RoleAssignmentsClient {
	return RoleAssignmentsClient{New(endpoint)}
}

// CheckPrincipalAccess check if the given principalId has access to perform list of actions at a given scope.
// Parameters:
// request - details of scope, list of actions and principal.
func (client RoleAssignmentsClient) CheckPrincipalAccess(ctx context.Context, request CheckPrincipalAccessRequest) (result CheckPrincipalAccessResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.CheckPrincipalAccess")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.Subject", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "request.Subject.PrincipalID", Name: validation.Null, Rule: true, Chain: nil}}},
				{Target: "request.Actions", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "request.Scope", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.RoleAssignmentsClient", "CheckPrincipalAccess", err.Error())
	}

	req, err := client.CheckPrincipalAccessPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CheckPrincipalAccess", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckPrincipalAccessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CheckPrincipalAccess", resp, "Failure sending request")
		return
	}

	result, err = client.CheckPrincipalAccessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CheckPrincipalAccess", resp, "Failure responding to request")
		return
	}

	return
}

// CheckPrincipalAccessPreparer prepares the CheckPrincipalAccess request.
func (client RoleAssignmentsClient) CheckPrincipalAccessPreparer(ctx context.Context, request CheckPrincipalAccessRequest) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/checkAccessSynapseRbac"),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckPrincipalAccessSender sends the CheckPrincipalAccess request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) CheckPrincipalAccessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CheckPrincipalAccessResponder handles the response to the CheckPrincipalAccess request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) CheckPrincipalAccessResponder(resp *http.Response) (result CheckPrincipalAccessResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateRoleAssignment create role assignment.
// Parameters:
// request - details of role id, scope and object id.
// roleAssignmentID - the ID of the role assignment.
func (client RoleAssignmentsClient) CreateRoleAssignment(ctx context.Context, request RoleAssignmentRequest, roleAssignmentID string) (result RoleAssignmentDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.CreateRoleAssignment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.RoleID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "request.PrincipalID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "request.Scope", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: roleAssignmentID,
			Constraints: []validation.Constraint{{Target: "roleAssignmentID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.RoleAssignmentsClient", "CreateRoleAssignment", err.Error())
	}

	req, err := client.CreateRoleAssignmentPreparer(ctx, request, roleAssignmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CreateRoleAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRoleAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CreateRoleAssignment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRoleAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "CreateRoleAssignment", resp, "Failure responding to request")
		return
	}

	return
}

// CreateRoleAssignmentPreparer prepares the CreateRoleAssignment request.
func (client RoleAssignmentsClient) CreateRoleAssignmentPreparer(ctx context.Context, request RoleAssignmentRequest, roleAssignmentID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleAssignmentId": autorest.Encode("path", roleAssignmentID),
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/roleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRoleAssignmentSender sends the CreateRoleAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) CreateRoleAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateRoleAssignmentResponder handles the response to the CreateRoleAssignment request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) CreateRoleAssignmentResponder(resp *http.Response) (result RoleAssignmentDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRoleAssignmentByID delete role assignment by role assignment Id.
// Parameters:
// roleAssignmentID - the ID of the role assignment.
// scope - scope of the Synapse Built-in Role.
func (client RoleAssignmentsClient) DeleteRoleAssignmentByID(ctx context.Context, roleAssignmentID string, scope string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.DeleteRoleAssignmentByID")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: roleAssignmentID,
			Constraints: []validation.Constraint{{Target: "roleAssignmentID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.RoleAssignmentsClient", "DeleteRoleAssignmentByID", err.Error())
	}

	req, err := client.DeleteRoleAssignmentByIDPreparer(ctx, roleAssignmentID, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "DeleteRoleAssignmentByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRoleAssignmentByIDSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "DeleteRoleAssignmentByID", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRoleAssignmentByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "DeleteRoleAssignmentByID", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteRoleAssignmentByIDPreparer prepares the DeleteRoleAssignmentByID request.
func (client RoleAssignmentsClient) DeleteRoleAssignmentByIDPreparer(ctx context.Context, roleAssignmentID string, scope string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleAssignmentId": autorest.Encode("path", roleAssignmentID),
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(scope) > 0 {
		queryParameters["scope"] = autorest.Encode("query", scope)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/roleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRoleAssignmentByIDSender sends the DeleteRoleAssignmentByID request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) DeleteRoleAssignmentByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteRoleAssignmentByIDResponder handles the response to the DeleteRoleAssignmentByID request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) DeleteRoleAssignmentByIDResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetRoleAssignmentByID get role assignment by role assignment Id.
// Parameters:
// roleAssignmentID - the ID of the role assignment.
func (client RoleAssignmentsClient) GetRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result RoleAssignmentDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.GetRoleAssignmentByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: roleAssignmentID,
			Constraints: []validation.Constraint{{Target: "roleAssignmentID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.RoleAssignmentsClient", "GetRoleAssignmentByID", err.Error())
	}

	req, err := client.GetRoleAssignmentByIDPreparer(ctx, roleAssignmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "GetRoleAssignmentByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleAssignmentByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "GetRoleAssignmentByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoleAssignmentByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "GetRoleAssignmentByID", resp, "Failure responding to request")
		return
	}

	return
}

// GetRoleAssignmentByIDPreparer prepares the GetRoleAssignmentByID request.
func (client RoleAssignmentsClient) GetRoleAssignmentByIDPreparer(ctx context.Context, roleAssignmentID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleAssignmentId": autorest.Encode("path", roleAssignmentID),
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/roleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleAssignmentByIDSender sends the GetRoleAssignmentByID request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) GetRoleAssignmentByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleAssignmentByIDResponder handles the response to the GetRoleAssignmentByID request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) GetRoleAssignmentByIDResponder(resp *http.Response) (result RoleAssignmentDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRoleAssignments list role assignments.
// Parameters:
// roleID - synapse Built-In Role Id.
// principalID - object ID of the AAD principal or security-group.
// scope - scope of the Synapse Built-in Role.
// continuationToken - continuation token.
func (client RoleAssignmentsClient) ListRoleAssignments(ctx context.Context, roleID string, principalID string, scope string, continuationToken string) (result RoleAssignmentDetailsList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentsClient.ListRoleAssignments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListRoleAssignmentsPreparer(ctx, roleID, principalID, scope, continuationToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "ListRoleAssignments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRoleAssignmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "ListRoleAssignments", resp, "Failure sending request")
		return
	}

	result, err = client.ListRoleAssignmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleAssignmentsClient", "ListRoleAssignments", resp, "Failure responding to request")
		return
	}

	return
}

// ListRoleAssignmentsPreparer prepares the ListRoleAssignments request.
func (client RoleAssignmentsClient) ListRoleAssignmentsPreparer(ctx context.Context, roleID string, principalID string, scope string, continuationToken string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(roleID) > 0 {
		queryParameters["roleId"] = autorest.Encode("query", roleID)
	}
	if len(principalID) > 0 {
		queryParameters["principalId"] = autorest.Encode("query", principalID)
	}
	if len(scope) > 0 {
		queryParameters["scope"] = autorest.Encode("query", scope)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/roleAssignments"),
		autorest.WithQueryParameters(queryParameters))
	if len(continuationToken) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-continuation", autorest.String(continuationToken)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRoleAssignmentsSender sends the ListRoleAssignments request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentsClient) ListRoleAssignmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListRoleAssignmentsResponder handles the response to the ListRoleAssignments request. The method always
// closes the http.Response Body.
func (client RoleAssignmentsClient) ListRoleAssignmentsResponder(resp *http.Response) (result RoleAssignmentDetailsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
