// Code generated by genlib2. DO NOT EDIT.

package tensor

import (
	"testing"

	arrow "github.com/apache/arrow/go/arrow"
	arrowArray "github.com/apache/arrow/go/arrow/array"
	"github.com/apache/arrow/go/arrow/memory"
	arrowTensor "github.com/apache/arrow/go/arrow/tensor"
	"github.com/stretchr/testify/assert"
	"gonum.org/v1/gonum/mat"
)

var toMat64Tests = []struct {
	data   interface{}
	sliced interface{}
	shape  Shape
	dt     Dtype
}{
	{Range(Int, 0, 6), []int{0, 1, 3, 4}, Shape{2, 3}, Int},
	{Range(Int8, 0, 6), []int8{0, 1, 3, 4}, Shape{2, 3}, Int8},
	{Range(Int16, 0, 6), []int16{0, 1, 3, 4}, Shape{2, 3}, Int16},
	{Range(Int32, 0, 6), []int32{0, 1, 3, 4}, Shape{2, 3}, Int32},
	{Range(Int64, 0, 6), []int64{0, 1, 3, 4}, Shape{2, 3}, Int64},
	{Range(Uint, 0, 6), []uint{0, 1, 3, 4}, Shape{2, 3}, Uint},
	{Range(Uint8, 0, 6), []uint8{0, 1, 3, 4}, Shape{2, 3}, Uint8},
	{Range(Uint16, 0, 6), []uint16{0, 1, 3, 4}, Shape{2, 3}, Uint16},
	{Range(Uint32, 0, 6), []uint32{0, 1, 3, 4}, Shape{2, 3}, Uint32},
	{Range(Uint64, 0, 6), []uint64{0, 1, 3, 4}, Shape{2, 3}, Uint64},
	{Range(Float32, 0, 6), []float32{0, 1, 3, 4}, Shape{2, 3}, Float32},
	{Range(Float64, 0, 6), []float64{0, 1, 3, 4}, Shape{2, 3}, Float64},
	{Range(Complex64, 0, 6), []complex64{0, 1, 3, 4}, Shape{2, 3}, Complex64},
	{Range(Complex128, 0, 6), []complex128{0, 1, 3, 4}, Shape{2, 3}, Complex128},
}

func TestToMat64(t *testing.T) {
	assert := assert.New(t)
	for i, tmt := range toMat64Tests {
		T := New(WithBacking(tmt.data), WithShape(tmt.shape...))
		var m *mat.Dense
		var err error
		if m, err = ToMat64(T); err != nil {
			t.Errorf("ToMat basic test %d failed : %v", i, err)
			continue
		}
		conv := anyToFloat64s(tmt.data)
		assert.Equal(conv, m.RawMatrix().Data, "i %d from %v", i, tmt.dt)

		if T, err = sliceDense(T, nil, makeRS(0, 2)); err != nil {
			t.Errorf("Slice failed %v", err)
			continue
		}
		if m, err = ToMat64(T); err != nil {
			t.Errorf("ToMat of slice test %d failed : %v", i, err)
			continue
		}
		conv = anyToFloat64s(tmt.sliced)
		assert.Equal(conv, m.RawMatrix().Data, "sliced test %d from %v", i, tmt.dt)
		t.Logf("Done")

		if tmt.dt == Float64 {
			T = New(WithBacking(tmt.data), WithShape(tmt.shape...))
			if m, err = ToMat64(T, UseUnsafe()); err != nil {
				t.Errorf("ToMat64 unsafe test %d failed: %v", i, err)
			}
			conv = anyToFloat64s(tmt.data)
			assert.Equal(conv, m.RawMatrix().Data, "float64 unsafe i %d from %v", i, tmt.dt)
			conv[0] = 1000
			assert.Equal(conv, m.RawMatrix().Data, "float64 unsafe i %d from %v", i, tmt.dt)
			conv[0] = 0 // reset for future tests that use the same backing
		}
	}
	// idiocy test
	T := New(Of(Float64), WithShape(2, 3, 4))
	_, err := ToMat64(T)
	if err == nil {
		t.Error("Expected an error when trying to convert a 3-T to *mat.Dense")
	}
}

func TestFromMat64(t *testing.T) {
	assert := assert.New(t)
	var m *mat.Dense
	var T *Dense
	var backing []float64

	for i, tmt := range toMat64Tests {
		backing = Range(Float64, 0, 6).([]float64)
		m = mat.NewDense(2, 3, backing)
		T = FromMat64(m)
		conv := anyToFloat64s(tmt.data)
		assert.Equal(conv, T.Float64s(), "test %d: []float64 from %v", i, tmt.dt)
		assert.True(T.Shape().Eq(tmt.shape))

		T = FromMat64(m, As(tmt.dt))
		assert.Equal(tmt.data, T.Data())
		assert.True(T.Shape().Eq(tmt.shape))

		if tmt.dt == Float64 {
			backing = Range(Float64, 0, 6).([]float64)
			m = mat.NewDense(2, 3, backing)
			T = FromMat64(m, UseUnsafe())
			assert.Equal(backing, T.Float64s())
			assert.True(T.Shape().Eq(tmt.shape))
			backing[0] = 1000
			assert.Equal(backing, T.Float64s(), "test %d - unsafe float64", i)
		}
	}
}

var toArrowArrayTests = []struct {
	data  interface{}
	valid []bool
	dt    arrow.DataType
	shape Shape
}{
	{
		data:  Range(Int8, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Int8,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Int16, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Int16,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Int32, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Int32,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Int64, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Int64,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Uint8, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Uint8,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Uint16, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Uint16,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Uint32, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Uint32,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Uint64, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Uint64,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Float32, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Float32,
		shape: Shape{6, 1},
	},
	{
		data:  Range(Float64, 0, 6),
		valid: []bool{true, true, true, false, true, true},
		dt:    arrow.PrimitiveTypes.Float64,
		shape: Shape{6, 1},
	},
}

func TestFromArrowArray(t *testing.T) {
	assert := assert.New(t)
	var T *Dense
	pool := memory.NewGoAllocator()

	for i, taat := range toArrowArrayTests {
		var m arrowArray.Interface

		switch taat.dt {
		case arrow.BinaryTypes.String:
			b := arrowArray.NewStringBuilder(pool)
			defer b.Release()
			b.AppendValues(
				[]string{"0", "1", "2", "3", "4", "5"},
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.FixedWidthTypes.Boolean:
			b := arrowArray.NewBooleanBuilder(pool)
			defer b.Release()
			b.AppendValues(
				[]bool{true, false, true, false, true, false},
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Int8:
			b := arrowArray.NewInt8Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Int8, 0, 6).([]int8),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Int16:
			b := arrowArray.NewInt16Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Int16, 0, 6).([]int16),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Int32:
			b := arrowArray.NewInt32Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Int32, 0, 6).([]int32),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Int64:
			b := arrowArray.NewInt64Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Int64, 0, 6).([]int64),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Uint8:
			b := arrowArray.NewUint8Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Uint8, 0, 6).([]uint8),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Uint16:
			b := arrowArray.NewUint16Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Uint16, 0, 6).([]uint16),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Uint32:
			b := arrowArray.NewUint32Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Uint32, 0, 6).([]uint32),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Uint64:
			b := arrowArray.NewUint64Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Uint64, 0, 6).([]uint64),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Float32:
			b := arrowArray.NewFloat32Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Float32, 0, 6).([]float32),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		case arrow.PrimitiveTypes.Float64:
			b := arrowArray.NewFloat64Builder(pool)
			defer b.Release()
			b.AppendValues(
				Range(Float64, 0, 6).([]float64),
				taat.valid,
			)
			m = b.NewArray()
			defer m.Release()
		default:
			t.Errorf("DataType not supported in tests: %v", taat.dt)
		}

		T = FromArrowArray(m)
		switch taat.dt {
		case arrow.PrimitiveTypes.Int8:
			conv := taat.data.([]int8)
			assert.Equal(conv, T.Int8s(), "test %d: []int8 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Int16:
			conv := taat.data.([]int16)
			assert.Equal(conv, T.Int16s(), "test %d: []int16 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Int32:
			conv := taat.data.([]int32)
			assert.Equal(conv, T.Int32s(), "test %d: []int32 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Int64:
			conv := taat.data.([]int64)
			assert.Equal(conv, T.Int64s(), "test %d: []int64 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Uint8:
			conv := taat.data.([]uint8)
			assert.Equal(conv, T.Uint8s(), "test %d: []uint8 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Uint16:
			conv := taat.data.([]uint16)
			assert.Equal(conv, T.Uint16s(), "test %d: []uint16 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Uint32:
			conv := taat.data.([]uint32)
			assert.Equal(conv, T.Uint32s(), "test %d: []uint32 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Uint64:
			conv := taat.data.([]uint64)
			assert.Equal(conv, T.Uint64s(), "test %d: []uint64 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Float32:
			conv := taat.data.([]float32)
			assert.Equal(conv, T.Float32s(), "test %d: []float32 from %v", i, taat.dt)
		case arrow.PrimitiveTypes.Float64:
			conv := taat.data.([]float64)
			assert.Equal(conv, T.Float64s(), "test %d: []float64 from %v", i, taat.dt)
		default:
			t.Errorf("DataType not supported in tests: %v", taat.dt)
		}
		for i, invalid := range T.Mask() {
			assert.Equal(taat.valid[i], !invalid)
		}
		assert.True(T.Shape().Eq(taat.shape))
	}
}

var toArrowTensorTests = []struct {
	rowMajorData  interface{}
	colMajorData  interface{}
	rowMajorValid []bool
	colMajorValid []bool
	dt            arrow.DataType
	shape         Shape
}{
	{
		rowMajorData:  []int8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []int8{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Int8,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []int16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []int16{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Int16,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []int32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []int32{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Int32,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []int64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []int64{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Int64,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []uint8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []uint8{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Uint8,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []uint16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []uint16{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Uint16,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []uint32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []uint32{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Uint32,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []uint64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []uint64{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Uint64,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []float32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []float32{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Float32,
		shape:         Shape{2, 5},
	},
	{
		rowMajorData:  []float64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
		colMajorData:  []float64{1, 6, 2, 7, 3, 8, 4, 9, 5, 10},
		rowMajorValid: []bool{true, false, true, false, true, false, true, false, true, false},
		colMajorValid: []bool{true, false, false, true, true, false, false, true, true, false},
		dt:            arrow.PrimitiveTypes.Float64,
		shape:         Shape{2, 5},
	},
}

func TestFromArrowTensor(t *testing.T) {
	assert := assert.New(t)
	var rowMajorT *Dense
	var colMajorT *Dense
	pool := memory.NewGoAllocator()

	for i, taat := range toArrowTensorTests {
		var rowMajorArr arrowArray.Interface
		var colMajorArr arrowArray.Interface
		var rowMajor arrowTensor.Interface
		var colMajor arrowTensor.Interface

		switch taat.dt {
		case arrow.PrimitiveTypes.Int8:
			b := arrowArray.NewInt8Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]int8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]int8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewInt8(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewInt8(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Int8SizeBytes), int64(arrow.Int8SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Int16:
			b := arrowArray.NewInt16Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]int16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]int16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewInt16(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewInt16(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Int16SizeBytes), int64(arrow.Int16SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Int32:
			b := arrowArray.NewInt32Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]int32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]int32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewInt32(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewInt32(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Int32SizeBytes), int64(arrow.Int32SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Int64:
			b := arrowArray.NewInt64Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]int64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]int64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewInt64(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewInt64(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Int64SizeBytes), int64(arrow.Int64SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Uint8:
			b := arrowArray.NewUint8Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]uint8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]uint8{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewUint8(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewUint8(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Uint8SizeBytes), int64(arrow.Uint8SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Uint16:
			b := arrowArray.NewUint16Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]uint16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]uint16{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewUint16(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewUint16(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Uint16SizeBytes), int64(arrow.Uint16SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Uint32:
			b := arrowArray.NewUint32Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]uint32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]uint32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewUint32(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewUint32(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Uint32SizeBytes), int64(arrow.Uint32SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Uint64:
			b := arrowArray.NewUint64Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]uint64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]uint64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewUint64(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewUint64(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Uint64SizeBytes), int64(arrow.Uint64SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Float32:
			b := arrowArray.NewFloat32Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]float32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]float32{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewFloat32(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewFloat32(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Float32SizeBytes), int64(arrow.Float32SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		case arrow.PrimitiveTypes.Float64:
			b := arrowArray.NewFloat64Builder(pool)
			defer b.Release()
			b.AppendValues(
				[]float64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			rowMajorArr = b.NewArray()
			defer rowMajorArr.Release()

			b.AppendValues(
				[]float64{1, 2, 3, 4, 5, 6, 7, 8, 9, 10},
				taat.rowMajorValid,
			)
			colMajorArr = b.NewArray()
			defer colMajorArr.Release()

			rowMajor = arrowTensor.NewFloat64(rowMajorArr.Data(), []int64{2, 5}, nil, []string{"x", "y"})
			defer rowMajor.Release()
			colMajor = arrowTensor.NewFloat64(colMajorArr.Data(), []int64{2, 5}, []int64{int64(arrow.Float64SizeBytes), int64(arrow.Float64SizeBytes * 2)}, []string{"x", "y"})
			defer colMajor.Release()
		default:
			t.Errorf("DataType not supported in tests: %v", taat.dt)
		}

		rowMajorT = FromArrowTensor(rowMajor)
		colMajorT = FromArrowTensor(colMajor)

		assert.Equal(taat.rowMajorData, rowMajorT.Data(), "test %d: row major %v", i, taat.dt)
		assert.Equal(len(taat.rowMajorValid), len(rowMajorT.Mask()), "test %d: row major %v mask length incorrect", i, taat.dt)
		for i, invalid := range rowMajorT.Mask() {
			assert.Equal(taat.rowMajorValid[i], !invalid, "test %d: row major %v mask value incorrect", i, taat.dt)
		}
		assert.True(colMajorT.Shape().Eq(taat.shape))

		assert.Equal(taat.colMajorData, colMajorT.Data(), "test %d: column major %v", i, taat.dt)
		assert.Equal(len(taat.colMajorValid), len(colMajorT.Mask()), "test %d: column major %v mask length incorrect", i, taat.dt)
		for i, invalid := range colMajorT.Mask() {
			assert.Equal(taat.colMajorValid[i], !invalid, "test %d: column major %v mask value incorrect", i, taat.dt)
		}
		assert.True(rowMajorT.Shape().Eq(taat.shape))
	}
}
