package version

const (
	LESS    = -1
	EQUAL   = 0
	GREATER = 1
)

var	cases = []struct {
		v1       string
		expected int
		v2       string
	}{
		{"", EQUAL, ""},
		{"", LESS, "0"},
		{"", LESS, "1"},
		{"", LESS, "2"},
		{"", LESS, "10"},
		{"", LESS, "100"},
		{"", LESS, "0.0"},
		{"", LESS, "0.1"},
		{"", LESS, "0.10"},
		{"", LESS, "0.99"},
		{"", LESS, "1.0"},
		{"", LESS, "1.99"},
		{"", LESS, "2.0"},
		{"", LESS, "0.0.0"},
		{"", LESS, "0.0.1"},
		{"", LESS, "0.0.2"},
		{"", LESS, "0.0.10"},
		{"", LESS, "0.0.99"},
		{"", LESS, "0.1.0"},
		{"", LESS, "0.2.0"},
		{"", LESS, "0.10.0"},
		{"", LESS, "0.99.0"},
		{"", LESS, "0.100.0"},
		{"", LESS, "0.0.0.0"},
		{"", LESS, "0.0.0.1"},
		{"", LESS, "0.0.0.10"},
		{"", LESS, "0.0.1.0"},
		{"", LESS, "0.0.01.0"},
		{"", LESS, "1.2.3.4"},
		{"", LESS, "1-2-3-4"},
		{"", LESS, "20150101"},
		{"", LESS, "20151212"},
		{"", LESS, "20151212.0"},
		{"", LESS, "20151212.1"},
		{"", LESS, "2015.1.1"},
		{"", LESS, "2015.02.02"},
		{"", LESS, "2015.12.12"},
		{"", LESS, "1.2.3a"},
		{"", LESS, "1.2.3b"},
		{"", LESS, "R16B"},
		{"", LESS, "R16C"},
		{"", LESS, "1.2.3.2016.1.1"},
		{"", LESS, "0.5a1.dev"},
		{"", LESS, "1.8.B59BrZX"},
		{"", LESS, "0.07b4p1"},
		{"", LESS, "3.99.5final.SP07"},
		{"", LESS, "3.99.5final.SP08"},
		{"", LESS, "0.4.tbb.20100203"},
		{"", LESS, "0.5.20120830CVS.el7"},
		{"", LESS, "1.el7"},
		{"", LESS, "1.el6"},
		{"", LESS, "10.el7"},
		{"", LESS, "01.el7"},
		{"", LESS, "0.17.20140318svn632.el7"},
		{"", LESS, "0.17.20140318svn633.el7"},
		{"", LESS, "1.20140522gitad6fb3e.el7"},
		{"", LESS, "1.20140522hitad6fb3e.el7"},
		{"", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"", LESS, "22.svn457.el7"},
		{"", LESS, "22.svn458.el7"},
		{"", GREATER, "~"},
		{"", GREATER, "~~"},
		{"", GREATER, "~1"},
		{"", GREATER, "~a"},
		{"", LESS, "1~"},
		{"", LESS, "2~"},
		{"0", GREATER, ""},
		{"0", EQUAL, "0"},
		{"0", LESS, "1"},
		{"0", LESS, "2"},
		{"0", LESS, "10"},
		{"0", LESS, "100"},
		{"0", LESS, "0.0"},
		{"0", LESS, "0.1"},
		{"0", LESS, "0.10"},
		{"0", LESS, "0.99"},
		{"0", LESS, "1.0"},
		{"0", LESS, "1.99"},
		{"0", LESS, "2.0"},
		{"0", LESS, "0.0.0"},
		{"0", LESS, "0.0.1"},
		{"0", LESS, "0.0.2"},
		{"0", LESS, "0.0.10"},
		{"0", LESS, "0.0.99"},
		{"0", LESS, "0.1.0"},
		{"0", LESS, "0.2.0"},
		{"0", LESS, "0.10.0"},
		{"0", LESS, "0.99.0"},
		{"0", LESS, "0.100.0"},
		{"0", LESS, "0.0.0.0"},
		{"0", LESS, "0.0.0.1"},
		{"0", LESS, "0.0.0.10"},
		{"0", LESS, "0.0.1.0"},
		{"0", LESS, "0.0.01.0"},
		{"0", LESS, "1.2.3.4"},
		{"0", LESS, "1-2-3-4"},
		{"0", LESS, "20150101"},
		{"0", LESS, "20151212"},
		{"0", LESS, "20151212.0"},
		{"0", LESS, "20151212.1"},
		{"0", LESS, "2015.1.1"},
		{"0", LESS, "2015.02.02"},
		{"0", LESS, "2015.12.12"},
		{"0", LESS, "1.2.3a"},
		{"0", LESS, "1.2.3b"},
		{"0", GREATER, "R16B"},
		{"0", GREATER, "R16C"},
		{"0", LESS, "1.2.3.2016.1.1"},
		{"0", LESS, "0.5a1.dev"},
		{"0", LESS, "1.8.B59BrZX"},
		{"0", LESS, "0.07b4p1"},
		{"0", LESS, "3.99.5final.SP07"},
		{"0", LESS, "3.99.5final.SP08"},
		{"0", LESS, "0.4.tbb.20100203"},
		{"0", LESS, "0.5.20120830CVS.el7"},
		{"0", LESS, "1.el7"},
		{"0", LESS, "1.el6"},
		{"0", LESS, "10.el7"},
		{"0", LESS, "01.el7"},
		{"0", LESS, "0.17.20140318svn632.el7"},
		{"0", LESS, "0.17.20140318svn633.el7"},
		{"0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0", LESS, "22.svn457.el7"},
		{"0", LESS, "22.svn458.el7"},
		{"0", GREATER, "~"},
		{"0", GREATER, "~~"},
		{"0", GREATER, "~1"},
		{"0", GREATER, "~a"},
		{"0", LESS, "1~"},
		{"0", LESS, "2~"},
		{"1", GREATER, ""},
		{"1", GREATER, "0"},
		{"1", EQUAL, "1"},
		{"1", LESS, "2"},
		{"1", LESS, "10"},
		{"1", LESS, "100"},
		{"1", GREATER, "0.0"},
		{"1", GREATER, "0.1"},
		{"1", GREATER, "0.10"},
		{"1", GREATER, "0.99"},
		{"1", LESS, "1.0"},
		{"1", LESS, "1.99"},
		{"1", LESS, "2.0"},
		{"1", GREATER, "0.0.0"},
		{"1", GREATER, "0.0.1"},
		{"1", GREATER, "0.0.2"},
		{"1", GREATER, "0.0.10"},
		{"1", GREATER, "0.0.99"},
		{"1", GREATER, "0.1.0"},
		{"1", GREATER, "0.2.0"},
		{"1", GREATER, "0.10.0"},
		{"1", GREATER, "0.99.0"},
		{"1", GREATER, "0.100.0"},
		{"1", GREATER, "0.0.0.0"},
		{"1", GREATER, "0.0.0.1"},
		{"1", GREATER, "0.0.0.10"},
		{"1", GREATER, "0.0.1.0"},
		{"1", GREATER, "0.0.01.0"},
		{"1", LESS, "1.2.3.4"},
		{"1", LESS, "1-2-3-4"},
		{"1", LESS, "20150101"},
		{"1", LESS, "20151212"},
		{"1", LESS, "20151212.0"},
		{"1", LESS, "20151212.1"},
		{"1", LESS, "2015.1.1"},
		{"1", LESS, "2015.02.02"},
		{"1", LESS, "2015.12.12"},
		{"1", LESS, "1.2.3a"},
		{"1", LESS, "1.2.3b"},
		{"1", GREATER, "R16B"},
		{"1", GREATER, "R16C"},
		{"1", LESS, "1.2.3.2016.1.1"},
		{"1", GREATER, "0.5a1.dev"},
		{"1", LESS, "1.8.B59BrZX"},
		{"1", GREATER, "0.07b4p1"},
		{"1", LESS, "3.99.5final.SP07"},
		{"1", LESS, "3.99.5final.SP08"},
		{"1", GREATER, "0.4.tbb.20100203"},
		{"1", GREATER, "0.5.20120830CVS.el7"},
		{"1", LESS, "1.el7"},
		{"1", LESS, "1.el6"},
		{"1", LESS, "10.el7"},
		{"1", LESS, "01.el7"},
		{"1", GREATER, "0.17.20140318svn632.el7"},
		{"1", GREATER, "0.17.20140318svn633.el7"},
		{"1", LESS, "1.20140522gitad6fb3e.el7"},
		{"1", LESS, "1.20140522hitad6fb3e.el7"},
		{"1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1", LESS, "22.svn457.el7"},
		{"1", LESS, "22.svn458.el7"},
		{"1", GREATER, "~"},
		{"1", GREATER, "~~"},
		{"1", GREATER, "~1"},
		{"1", GREATER, "~a"},
		{"1", GREATER, "1~"},
		{"1", LESS, "2~"},
		{"2", GREATER, ""},
		{"2", GREATER, "0"},
		{"2", GREATER, "1"},
		{"2", EQUAL, "2"},
		{"2", LESS, "10"},
		{"2", LESS, "100"},
		{"2", GREATER, "0.0"},
		{"2", GREATER, "0.1"},
		{"2", GREATER, "0.10"},
		{"2", GREATER, "0.99"},
		{"2", GREATER, "1.0"},
		{"2", GREATER, "1.99"},
		{"2", LESS, "2.0"},
		{"2", GREATER, "0.0.0"},
		{"2", GREATER, "0.0.1"},
		{"2", GREATER, "0.0.2"},
		{"2", GREATER, "0.0.10"},
		{"2", GREATER, "0.0.99"},
		{"2", GREATER, "0.1.0"},
		{"2", GREATER, "0.2.0"},
		{"2", GREATER, "0.10.0"},
		{"2", GREATER, "0.99.0"},
		{"2", GREATER, "0.100.0"},
		{"2", GREATER, "0.0.0.0"},
		{"2", GREATER, "0.0.0.1"},
		{"2", GREATER, "0.0.0.10"},
		{"2", GREATER, "0.0.1.0"},
		{"2", GREATER, "0.0.01.0"},
		{"2", GREATER, "1.2.3.4"},
		{"2", GREATER, "1-2-3-4"},
		{"2", LESS, "20150101"},
		{"2", LESS, "20151212"},
		{"2", LESS, "20151212.0"},
		{"2", LESS, "20151212.1"},
		{"2", LESS, "2015.1.1"},
		{"2", LESS, "2015.02.02"},
		{"2", LESS, "2015.12.12"},
		{"2", GREATER, "1.2.3a"},
		{"2", GREATER, "1.2.3b"},
		{"2", GREATER, "R16B"},
		{"2", GREATER, "R16C"},
		{"2", GREATER, "1.2.3.2016.1.1"},
		{"2", GREATER, "0.5a1.dev"},
		{"2", GREATER, "1.8.B59BrZX"},
		{"2", GREATER, "0.07b4p1"},
		{"2", LESS, "3.99.5final.SP07"},
		{"2", LESS, "3.99.5final.SP08"},
		{"2", GREATER, "0.4.tbb.20100203"},
		{"2", GREATER, "0.5.20120830CVS.el7"},
		{"2", GREATER, "1.el7"},
		{"2", GREATER, "1.el6"},
		{"2", LESS, "10.el7"},
		{"2", GREATER, "01.el7"},
		{"2", GREATER, "0.17.20140318svn632.el7"},
		{"2", GREATER, "0.17.20140318svn633.el7"},
		{"2", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"2", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"2", LESS, "22.svn457.el7"},
		{"2", LESS, "22.svn458.el7"},
		{"2", GREATER, "~"},
		{"2", GREATER, "~~"},
		{"2", GREATER, "~1"},
		{"2", GREATER, "~a"},
		{"2", GREATER, "1~"},
		{"2", GREATER, "2~"},
		{"10", GREATER, ""},
		{"10", GREATER, "0"},
		{"10", GREATER, "1"},
		{"10", GREATER, "2"},
		{"10", EQUAL, "10"},
		{"10", LESS, "100"},
		{"10", GREATER, "0.0"},
		{"10", GREATER, "0.1"},
		{"10", GREATER, "0.10"},
		{"10", GREATER, "0.99"},
		{"10", GREATER, "1.0"},
		{"10", GREATER, "1.99"},
		{"10", GREATER, "2.0"},
		{"10", GREATER, "0.0.0"},
		{"10", GREATER, "0.0.1"},
		{"10", GREATER, "0.0.2"},
		{"10", GREATER, "0.0.10"},
		{"10", GREATER, "0.0.99"},
		{"10", GREATER, "0.1.0"},
		{"10", GREATER, "0.2.0"},
		{"10", GREATER, "0.10.0"},
		{"10", GREATER, "0.99.0"},
		{"10", GREATER, "0.100.0"},
		{"10", GREATER, "0.0.0.0"},
		{"10", GREATER, "0.0.0.1"},
		{"10", GREATER, "0.0.0.10"},
		{"10", GREATER, "0.0.1.0"},
		{"10", GREATER, "0.0.01.0"},
		{"10", GREATER, "1.2.3.4"},
		{"10", GREATER, "1-2-3-4"},
		{"10", LESS, "20150101"},
		{"10", LESS, "20151212"},
		{"10", LESS, "20151212.0"},
		{"10", LESS, "20151212.1"},
		{"10", LESS, "2015.1.1"},
		{"10", LESS, "2015.02.02"},
		{"10", LESS, "2015.12.12"},
		{"10", GREATER, "1.2.3a"},
		{"10", GREATER, "1.2.3b"},
		{"10", GREATER, "R16B"},
		{"10", GREATER, "R16C"},
		{"10", GREATER, "1.2.3.2016.1.1"},
		{"10", GREATER, "0.5a1.dev"},
		{"10", GREATER, "1.8.B59BrZX"},
		{"10", GREATER, "0.07b4p1"},
		{"10", GREATER, "3.99.5final.SP07"},
		{"10", GREATER, "3.99.5final.SP08"},
		{"10", GREATER, "0.4.tbb.20100203"},
		{"10", GREATER, "0.5.20120830CVS.el7"},
		{"10", GREATER, "1.el7"},
		{"10", GREATER, "1.el6"},
		{"10", LESS, "10.el7"},
		{"10", GREATER, "01.el7"},
		{"10", GREATER, "0.17.20140318svn632.el7"},
		{"10", GREATER, "0.17.20140318svn633.el7"},
		{"10", GREATER, "1.20140522gitad6fb3e.el7"},
		{"10", GREATER, "1.20140522hitad6fb3e.el7"},
		{"10", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"10", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"10", LESS, "22.svn457.el7"},
		{"10", LESS, "22.svn458.el7"},
		{"10", GREATER, "~"},
		{"10", GREATER, "~~"},
		{"10", GREATER, "~1"},
		{"10", GREATER, "~a"},
		{"10", GREATER, "1~"},
		{"10", GREATER, "2~"},
		{"100", GREATER, ""},
		{"100", GREATER, "0"},
		{"100", GREATER, "1"},
		{"100", GREATER, "2"},
		{"100", GREATER, "10"},
		{"100", EQUAL, "100"},
		{"100", GREATER, "0.0"},
		{"100", GREATER, "0.1"},
		{"100", GREATER, "0.10"},
		{"100", GREATER, "0.99"},
		{"100", GREATER, "1.0"},
		{"100", GREATER, "1.99"},
		{"100", GREATER, "2.0"},
		{"100", GREATER, "0.0.0"},
		{"100", GREATER, "0.0.1"},
		{"100", GREATER, "0.0.2"},
		{"100", GREATER, "0.0.10"},
		{"100", GREATER, "0.0.99"},
		{"100", GREATER, "0.1.0"},
		{"100", GREATER, "0.2.0"},
		{"100", GREATER, "0.10.0"},
		{"100", GREATER, "0.99.0"},
		{"100", GREATER, "0.100.0"},
		{"100", GREATER, "0.0.0.0"},
		{"100", GREATER, "0.0.0.1"},
		{"100", GREATER, "0.0.0.10"},
		{"100", GREATER, "0.0.1.0"},
		{"100", GREATER, "0.0.01.0"},
		{"100", GREATER, "1.2.3.4"},
		{"100", GREATER, "1-2-3-4"},
		{"100", LESS, "20150101"},
		{"100", LESS, "20151212"},
		{"100", LESS, "20151212.0"},
		{"100", LESS, "20151212.1"},
		{"100", LESS, "2015.1.1"},
		{"100", LESS, "2015.02.02"},
		{"100", LESS, "2015.12.12"},
		{"100", GREATER, "1.2.3a"},
		{"100", GREATER, "1.2.3b"},
		{"100", GREATER, "R16B"},
		{"100", GREATER, "R16C"},
		{"100", GREATER, "1.2.3.2016.1.1"},
		{"100", GREATER, "0.5a1.dev"},
		{"100", GREATER, "1.8.B59BrZX"},
		{"100", GREATER, "0.07b4p1"},
		{"100", GREATER, "3.99.5final.SP07"},
		{"100", GREATER, "3.99.5final.SP08"},
		{"100", GREATER, "0.4.tbb.20100203"},
		{"100", GREATER, "0.5.20120830CVS.el7"},
		{"100", GREATER, "1.el7"},
		{"100", GREATER, "1.el6"},
		{"100", GREATER, "10.el7"},
		{"100", GREATER, "01.el7"},
		{"100", GREATER, "0.17.20140318svn632.el7"},
		{"100", GREATER, "0.17.20140318svn633.el7"},
		{"100", GREATER, "1.20140522gitad6fb3e.el7"},
		{"100", GREATER, "1.20140522hitad6fb3e.el7"},
		{"100", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"100", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"100", GREATER, "22.svn457.el7"},
		{"100", GREATER, "22.svn458.el7"},
		{"100", GREATER, "~"},
		{"100", GREATER, "~~"},
		{"100", GREATER, "~1"},
		{"100", GREATER, "~a"},
		{"100", GREATER, "1~"},
		{"100", GREATER, "2~"},
		{"0.0", GREATER, ""},
		{"0.0", GREATER, "0"},
		{"0.0", LESS, "1"},
		{"0.0", LESS, "2"},
		{"0.0", LESS, "10"},
		{"0.0", LESS, "100"},
		{"0.0", EQUAL, "0.0"},
		{"0.0", LESS, "0.1"},
		{"0.0", LESS, "0.10"},
		{"0.0", LESS, "0.99"},
		{"0.0", LESS, "1.0"},
		{"0.0", LESS, "1.99"},
		{"0.0", LESS, "2.0"},
		{"0.0", LESS, "0.0.0"},
		{"0.0", LESS, "0.0.1"},
		{"0.0", LESS, "0.0.2"},
		{"0.0", LESS, "0.0.10"},
		{"0.0", LESS, "0.0.99"},
		{"0.0", LESS, "0.1.0"},
		{"0.0", LESS, "0.2.0"},
		{"0.0", LESS, "0.10.0"},
		{"0.0", LESS, "0.99.0"},
		{"0.0", LESS, "0.100.0"},
		{"0.0", LESS, "0.0.0.0"},
		{"0.0", LESS, "0.0.0.1"},
		{"0.0", LESS, "0.0.0.10"},
		{"0.0", LESS, "0.0.1.0"},
		{"0.0", LESS, "0.0.01.0"},
		{"0.0", LESS, "1.2.3.4"},
		{"0.0", LESS, "1-2-3-4"},
		{"0.0", LESS, "20150101"},
		{"0.0", LESS, "20151212"},
		{"0.0", LESS, "20151212.0"},
		{"0.0", LESS, "20151212.1"},
		{"0.0", LESS, "2015.1.1"},
		{"0.0", LESS, "2015.02.02"},
		{"0.0", LESS, "2015.12.12"},
		{"0.0", LESS, "1.2.3a"},
		{"0.0", LESS, "1.2.3b"},
		{"0.0", GREATER, "R16B"},
		{"0.0", GREATER, "R16C"},
		{"0.0", LESS, "1.2.3.2016.1.1"},
		{"0.0", LESS, "0.5a1.dev"},
		{"0.0", LESS, "1.8.B59BrZX"},
		{"0.0", LESS, "0.07b4p1"},
		{"0.0", LESS, "3.99.5final.SP07"},
		{"0.0", LESS, "3.99.5final.SP08"},
		{"0.0", LESS, "0.4.tbb.20100203"},
		{"0.0", LESS, "0.5.20120830CVS.el7"},
		{"0.0", LESS, "1.el7"},
		{"0.0", LESS, "1.el6"},
		{"0.0", LESS, "10.el7"},
		{"0.0", LESS, "01.el7"},
		{"0.0", LESS, "0.17.20140318svn632.el7"},
		{"0.0", LESS, "0.17.20140318svn633.el7"},
		{"0.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0", LESS, "22.svn457.el7"},
		{"0.0", LESS, "22.svn458.el7"},
		{"0.0", GREATER, "~"},
		{"0.0", GREATER, "~~"},
		{"0.0", GREATER, "~1"},
		{"0.0", GREATER, "~a"},
		{"0.0", LESS, "1~"},
		{"0.0", LESS, "2~"},
		{"0.1", GREATER, ""},
		{"0.1", GREATER, "0"},
		{"0.1", LESS, "1"},
		{"0.1", LESS, "2"},
		{"0.1", LESS, "10"},
		{"0.1", LESS, "100"},
		{"0.1", GREATER, "0.0"},
		{"0.1", EQUAL, "0.1"},
		{"0.1", LESS, "0.10"},
		{"0.1", LESS, "0.99"},
		{"0.1", LESS, "1.0"},
		{"0.1", LESS, "1.99"},
		{"0.1", LESS, "2.0"},
		{"0.1", GREATER, "0.0.0"},
		{"0.1", GREATER, "0.0.1"},
		{"0.1", GREATER, "0.0.2"},
		{"0.1", GREATER, "0.0.10"},
		{"0.1", GREATER, "0.0.99"},
		{"0.1", LESS, "0.1.0"},
		{"0.1", LESS, "0.2.0"},
		{"0.1", LESS, "0.10.0"},
		{"0.1", LESS, "0.99.0"},
		{"0.1", LESS, "0.100.0"},
		{"0.1", GREATER, "0.0.0.0"},
		{"0.1", GREATER, "0.0.0.1"},
		{"0.1", GREATER, "0.0.0.10"},
		{"0.1", GREATER, "0.0.1.0"},
		{"0.1", GREATER, "0.0.01.0"},
		{"0.1", LESS, "1.2.3.4"},
		{"0.1", LESS, "1-2-3-4"},
		{"0.1", LESS, "20150101"},
		{"0.1", LESS, "20151212"},
		{"0.1", LESS, "20151212.0"},
		{"0.1", LESS, "20151212.1"},
		{"0.1", LESS, "2015.1.1"},
		{"0.1", LESS, "2015.02.02"},
		{"0.1", LESS, "2015.12.12"},
		{"0.1", LESS, "1.2.3a"},
		{"0.1", LESS, "1.2.3b"},
		{"0.1", GREATER, "R16B"},
		{"0.1", GREATER, "R16C"},
		{"0.1", LESS, "1.2.3.2016.1.1"},
		{"0.1", LESS, "0.5a1.dev"},
		{"0.1", LESS, "1.8.B59BrZX"},
		{"0.1", LESS, "0.07b4p1"},
		{"0.1", LESS, "3.99.5final.SP07"},
		{"0.1", LESS, "3.99.5final.SP08"},
		{"0.1", LESS, "0.4.tbb.20100203"},
		{"0.1", LESS, "0.5.20120830CVS.el7"},
		{"0.1", LESS, "1.el7"},
		{"0.1", LESS, "1.el6"},
		{"0.1", LESS, "10.el7"},
		{"0.1", LESS, "01.el7"},
		{"0.1", LESS, "0.17.20140318svn632.el7"},
		{"0.1", LESS, "0.17.20140318svn633.el7"},
		{"0.1", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.1", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.1", LESS, "22.svn457.el7"},
		{"0.1", LESS, "22.svn458.el7"},
		{"0.1", GREATER, "~"},
		{"0.1", GREATER, "~~"},
		{"0.1", GREATER, "~1"},
		{"0.1", GREATER, "~a"},
		{"0.1", LESS, "1~"},
		{"0.1", LESS, "2~"},
		{"0.10", GREATER, ""},
		{"0.10", GREATER, "0"},
		{"0.10", LESS, "1"},
		{"0.10", LESS, "2"},
		{"0.10", LESS, "10"},
		{"0.10", LESS, "100"},
		{"0.10", GREATER, "0.0"},
		{"0.10", GREATER, "0.1"},
		{"0.10", EQUAL, "0.10"},
		{"0.10", LESS, "0.99"},
		{"0.10", LESS, "1.0"},
		{"0.10", LESS, "1.99"},
		{"0.10", LESS, "2.0"},
		{"0.10", GREATER, "0.0.0"},
		{"0.10", GREATER, "0.0.1"},
		{"0.10", GREATER, "0.0.2"},
		{"0.10", GREATER, "0.0.10"},
		{"0.10", GREATER, "0.0.99"},
		{"0.10", GREATER, "0.1.0"},
		{"0.10", GREATER, "0.2.0"},
		{"0.10", LESS, "0.10.0"},
		{"0.10", LESS, "0.99.0"},
		{"0.10", LESS, "0.100.0"},
		{"0.10", GREATER, "0.0.0.0"},
		{"0.10", GREATER, "0.0.0.1"},
		{"0.10", GREATER, "0.0.0.10"},
		{"0.10", GREATER, "0.0.1.0"},
		{"0.10", GREATER, "0.0.01.0"},
		{"0.10", LESS, "1.2.3.4"},
		{"0.10", LESS, "1-2-3-4"},
		{"0.10", LESS, "20150101"},
		{"0.10", LESS, "20151212"},
		{"0.10", LESS, "20151212.0"},
		{"0.10", LESS, "20151212.1"},
		{"0.10", LESS, "2015.1.1"},
		{"0.10", LESS, "2015.02.02"},
		{"0.10", LESS, "2015.12.12"},
		{"0.10", LESS, "1.2.3a"},
		{"0.10", LESS, "1.2.3b"},
		{"0.10", GREATER, "R16B"},
		{"0.10", GREATER, "R16C"},
		{"0.10", LESS, "1.2.3.2016.1.1"},
		{"0.10", GREATER, "0.5a1.dev"},
		{"0.10", LESS, "1.8.B59BrZX"},
		{"0.10", GREATER, "0.07b4p1"},
		{"0.10", LESS, "3.99.5final.SP07"},
		{"0.10", LESS, "3.99.5final.SP08"},
		{"0.10", GREATER, "0.4.tbb.20100203"},
		{"0.10", GREATER, "0.5.20120830CVS.el7"},
		{"0.10", LESS, "1.el7"},
		{"0.10", LESS, "1.el6"},
		{"0.10", LESS, "10.el7"},
		{"0.10", LESS, "01.el7"},
		{"0.10", LESS, "0.17.20140318svn632.el7"},
		{"0.10", LESS, "0.17.20140318svn633.el7"},
		{"0.10", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.10", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.10", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.10", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.10", LESS, "22.svn457.el7"},
		{"0.10", LESS, "22.svn458.el7"},
		{"0.10", GREATER, "~"},
		{"0.10", GREATER, "~~"},
		{"0.10", GREATER, "~1"},
		{"0.10", GREATER, "~a"},
		{"0.10", LESS, "1~"},
		{"0.10", LESS, "2~"},
		{"0.99", GREATER, ""},
		{"0.99", GREATER, "0"},
		{"0.99", LESS, "1"},
		{"0.99", LESS, "2"},
		{"0.99", LESS, "10"},
		{"0.99", LESS, "100"},
		{"0.99", GREATER, "0.0"},
		{"0.99", GREATER, "0.1"},
		{"0.99", GREATER, "0.10"},
		{"0.99", EQUAL, "0.99"},
		{"0.99", LESS, "1.0"},
		{"0.99", LESS, "1.99"},
		{"0.99", LESS, "2.0"},
		{"0.99", GREATER, "0.0.0"},
		{"0.99", GREATER, "0.0.1"},
		{"0.99", GREATER, "0.0.2"},
		{"0.99", GREATER, "0.0.10"},
		{"0.99", GREATER, "0.0.99"},
		{"0.99", GREATER, "0.1.0"},
		{"0.99", GREATER, "0.2.0"},
		{"0.99", GREATER, "0.10.0"},
		{"0.99", LESS, "0.99.0"},
		{"0.99", LESS, "0.100.0"},
		{"0.99", GREATER, "0.0.0.0"},
		{"0.99", GREATER, "0.0.0.1"},
		{"0.99", GREATER, "0.0.0.10"},
		{"0.99", GREATER, "0.0.1.0"},
		{"0.99", GREATER, "0.0.01.0"},
		{"0.99", LESS, "1.2.3.4"},
		{"0.99", LESS, "1-2-3-4"},
		{"0.99", LESS, "20150101"},
		{"0.99", LESS, "20151212"},
		{"0.99", LESS, "20151212.0"},
		{"0.99", LESS, "20151212.1"},
		{"0.99", LESS, "2015.1.1"},
		{"0.99", LESS, "2015.02.02"},
		{"0.99", LESS, "2015.12.12"},
		{"0.99", LESS, "1.2.3a"},
		{"0.99", LESS, "1.2.3b"},
		{"0.99", GREATER, "R16B"},
		{"0.99", GREATER, "R16C"},
		{"0.99", LESS, "1.2.3.2016.1.1"},
		{"0.99", GREATER, "0.5a1.dev"},
		{"0.99", LESS, "1.8.B59BrZX"},
		{"0.99", GREATER, "0.07b4p1"},
		{"0.99", LESS, "3.99.5final.SP07"},
		{"0.99", LESS, "3.99.5final.SP08"},
		{"0.99", GREATER, "0.4.tbb.20100203"},
		{"0.99", GREATER, "0.5.20120830CVS.el7"},
		{"0.99", LESS, "1.el7"},
		{"0.99", LESS, "1.el6"},
		{"0.99", LESS, "10.el7"},
		{"0.99", LESS, "01.el7"},
		{"0.99", GREATER, "0.17.20140318svn632.el7"},
		{"0.99", GREATER, "0.17.20140318svn633.el7"},
		{"0.99", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.99", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.99", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.99", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.99", LESS, "22.svn457.el7"},
		{"0.99", LESS, "22.svn458.el7"},
		{"0.99", GREATER, "~"},
		{"0.99", GREATER, "~~"},
		{"0.99", GREATER, "~1"},
		{"0.99", GREATER, "~a"},
		{"0.99", LESS, "1~"},
		{"0.99", LESS, "2~"},
		{"1.0", GREATER, ""},
		{"1.0", GREATER, "0"},
		{"1.0", GREATER, "1"},
		{"1.0", LESS, "2"},
		{"1.0", LESS, "10"},
		{"1.0", LESS, "100"},
		{"1.0", GREATER, "0.0"},
		{"1.0", GREATER, "0.1"},
		{"1.0", GREATER, "0.10"},
		{"1.0", GREATER, "0.99"},
		{"1.0", EQUAL, "1.0"},
		{"1.0", LESS, "1.99"},
		{"1.0", LESS, "2.0"},
		{"1.0", GREATER, "0.0.0"},
		{"1.0", GREATER, "0.0.1"},
		{"1.0", GREATER, "0.0.2"},
		{"1.0", GREATER, "0.0.10"},
		{"1.0", GREATER, "0.0.99"},
		{"1.0", GREATER, "0.1.0"},
		{"1.0", GREATER, "0.2.0"},
		{"1.0", GREATER, "0.10.0"},
		{"1.0", GREATER, "0.99.0"},
		{"1.0", GREATER, "0.100.0"},
		{"1.0", GREATER, "0.0.0.0"},
		{"1.0", GREATER, "0.0.0.1"},
		{"1.0", GREATER, "0.0.0.10"},
		{"1.0", GREATER, "0.0.1.0"},
		{"1.0", GREATER, "0.0.01.0"},
		{"1.0", LESS, "1.2.3.4"},
		{"1.0", LESS, "1-2-3-4"},
		{"1.0", LESS, "20150101"},
		{"1.0", LESS, "20151212"},
		{"1.0", LESS, "20151212.0"},
		{"1.0", LESS, "20151212.1"},
		{"1.0", LESS, "2015.1.1"},
		{"1.0", LESS, "2015.02.02"},
		{"1.0", LESS, "2015.12.12"},
		{"1.0", LESS, "1.2.3a"},
		{"1.0", LESS, "1.2.3b"},
		{"1.0", GREATER, "R16B"},
		{"1.0", GREATER, "R16C"},
		{"1.0", LESS, "1.2.3.2016.1.1"},
		{"1.0", GREATER, "0.5a1.dev"},
		{"1.0", LESS, "1.8.B59BrZX"},
		{"1.0", GREATER, "0.07b4p1"},
		{"1.0", LESS, "3.99.5final.SP07"},
		{"1.0", LESS, "3.99.5final.SP08"},
		{"1.0", GREATER, "0.4.tbb.20100203"},
		{"1.0", GREATER, "0.5.20120830CVS.el7"},
		{"1.0", GREATER, "1.el7"},
		{"1.0", GREATER, "1.el6"},
		{"1.0", LESS, "10.el7"},
		{"1.0", GREATER, "01.el7"},
		{"1.0", GREATER, "0.17.20140318svn632.el7"},
		{"1.0", GREATER, "0.17.20140318svn633.el7"},
		{"1.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.0", LESS, "22.svn457.el7"},
		{"1.0", LESS, "22.svn458.el7"},
		{"1.0", GREATER, "~"},
		{"1.0", GREATER, "~~"},
		{"1.0", GREATER, "~1"},
		{"1.0", GREATER, "~a"},
		{"1.0", GREATER, "1~"},
		{"1.0", LESS, "2~"},
		{"1.99", GREATER, ""},
		{"1.99", GREATER, "0"},
		{"1.99", GREATER, "1"},
		{"1.99", LESS, "2"},
		{"1.99", LESS, "10"},
		{"1.99", LESS, "100"},
		{"1.99", GREATER, "0.0"},
		{"1.99", GREATER, "0.1"},
		{"1.99", GREATER, "0.10"},
		{"1.99", GREATER, "0.99"},
		{"1.99", GREATER, "1.0"},
		{"1.99", EQUAL, "1.99"},
		{"1.99", LESS, "2.0"},
		{"1.99", GREATER, "0.0.0"},
		{"1.99", GREATER, "0.0.1"},
		{"1.99", GREATER, "0.0.2"},
		{"1.99", GREATER, "0.0.10"},
		{"1.99", GREATER, "0.0.99"},
		{"1.99", GREATER, "0.1.0"},
		{"1.99", GREATER, "0.2.0"},
		{"1.99", GREATER, "0.10.0"},
		{"1.99", GREATER, "0.99.0"},
		{"1.99", GREATER, "0.100.0"},
		{"1.99", GREATER, "0.0.0.0"},
		{"1.99", GREATER, "0.0.0.1"},
		{"1.99", GREATER, "0.0.0.10"},
		{"1.99", GREATER, "0.0.1.0"},
		{"1.99", GREATER, "0.0.01.0"},
		{"1.99", GREATER, "1.2.3.4"},
		{"1.99", GREATER, "1-2-3-4"},
		{"1.99", LESS, "20150101"},
		{"1.99", LESS, "20151212"},
		{"1.99", LESS, "20151212.0"},
		{"1.99", LESS, "20151212.1"},
		{"1.99", LESS, "2015.1.1"},
		{"1.99", LESS, "2015.02.02"},
		{"1.99", LESS, "2015.12.12"},
		{"1.99", GREATER, "1.2.3a"},
		{"1.99", GREATER, "1.2.3b"},
		{"1.99", GREATER, "R16B"},
		{"1.99", GREATER, "R16C"},
		{"1.99", GREATER, "1.2.3.2016.1.1"},
		{"1.99", GREATER, "0.5a1.dev"},
		{"1.99", GREATER, "1.8.B59BrZX"},
		{"1.99", GREATER, "0.07b4p1"},
		{"1.99", LESS, "3.99.5final.SP07"},
		{"1.99", LESS, "3.99.5final.SP08"},
		{"1.99", GREATER, "0.4.tbb.20100203"},
		{"1.99", GREATER, "0.5.20120830CVS.el7"},
		{"1.99", GREATER, "1.el7"},
		{"1.99", GREATER, "1.el6"},
		{"1.99", LESS, "10.el7"},
		{"1.99", GREATER, "01.el7"},
		{"1.99", GREATER, "0.17.20140318svn632.el7"},
		{"1.99", GREATER, "0.17.20140318svn633.el7"},
		{"1.99", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.99", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.99", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.99", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.99", LESS, "22.svn457.el7"},
		{"1.99", LESS, "22.svn458.el7"},
		{"1.99", GREATER, "~"},
		{"1.99", GREATER, "~~"},
		{"1.99", GREATER, "~1"},
		{"1.99", GREATER, "~a"},
		{"1.99", GREATER, "1~"},
		{"1.99", LESS, "2~"},
		{"2.0", GREATER, ""},
		{"2.0", GREATER, "0"},
		{"2.0", GREATER, "1"},
		{"2.0", GREATER, "2"},
		{"2.0", LESS, "10"},
		{"2.0", LESS, "100"},
		{"2.0", GREATER, "0.0"},
		{"2.0", GREATER, "0.1"},
		{"2.0", GREATER, "0.10"},
		{"2.0", GREATER, "0.99"},
		{"2.0", GREATER, "1.0"},
		{"2.0", GREATER, "1.99"},
		{"2.0", EQUAL, "2.0"},
		{"2.0", GREATER, "0.0.0"},
		{"2.0", GREATER, "0.0.1"},
		{"2.0", GREATER, "0.0.2"},
		{"2.0", GREATER, "0.0.10"},
		{"2.0", GREATER, "0.0.99"},
		{"2.0", GREATER, "0.1.0"},
		{"2.0", GREATER, "0.2.0"},
		{"2.0", GREATER, "0.10.0"},
		{"2.0", GREATER, "0.99.0"},
		{"2.0", GREATER, "0.100.0"},
		{"2.0", GREATER, "0.0.0.0"},
		{"2.0", GREATER, "0.0.0.1"},
		{"2.0", GREATER, "0.0.0.10"},
		{"2.0", GREATER, "0.0.1.0"},
		{"2.0", GREATER, "0.0.01.0"},
		{"2.0", GREATER, "1.2.3.4"},
		{"2.0", GREATER, "1-2-3-4"},
		{"2.0", LESS, "20150101"},
		{"2.0", LESS, "20151212"},
		{"2.0", LESS, "20151212.0"},
		{"2.0", LESS, "20151212.1"},
		{"2.0", LESS, "2015.1.1"},
		{"2.0", LESS, "2015.02.02"},
		{"2.0", LESS, "2015.12.12"},
		{"2.0", GREATER, "1.2.3a"},
		{"2.0", GREATER, "1.2.3b"},
		{"2.0", GREATER, "R16B"},
		{"2.0", GREATER, "R16C"},
		{"2.0", GREATER, "1.2.3.2016.1.1"},
		{"2.0", GREATER, "0.5a1.dev"},
		{"2.0", GREATER, "1.8.B59BrZX"},
		{"2.0", GREATER, "0.07b4p1"},
		{"2.0", LESS, "3.99.5final.SP07"},
		{"2.0", LESS, "3.99.5final.SP08"},
		{"2.0", GREATER, "0.4.tbb.20100203"},
		{"2.0", GREATER, "0.5.20120830CVS.el7"},
		{"2.0", GREATER, "1.el7"},
		{"2.0", GREATER, "1.el6"},
		{"2.0", LESS, "10.el7"},
		{"2.0", GREATER, "01.el7"},
		{"2.0", GREATER, "0.17.20140318svn632.el7"},
		{"2.0", GREATER, "0.17.20140318svn633.el7"},
		{"2.0", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2.0", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"2.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"2.0", LESS, "22.svn457.el7"},
		{"2.0", LESS, "22.svn458.el7"},
		{"2.0", GREATER, "~"},
		{"2.0", GREATER, "~~"},
		{"2.0", GREATER, "~1"},
		{"2.0", GREATER, "~a"},
		{"2.0", GREATER, "1~"},
		{"2.0", GREATER, "2~"},
		{"0.0.0", GREATER, ""},
		{"0.0.0", GREATER, "0"},
		{"0.0.0", LESS, "1"},
		{"0.0.0", LESS, "2"},
		{"0.0.0", LESS, "10"},
		{"0.0.0", LESS, "100"},
		{"0.0.0", GREATER, "0.0"},
		{"0.0.0", LESS, "0.1"},
		{"0.0.0", LESS, "0.10"},
		{"0.0.0", LESS, "0.99"},
		{"0.0.0", LESS, "1.0"},
		{"0.0.0", LESS, "1.99"},
		{"0.0.0", LESS, "2.0"},
		{"0.0.0", EQUAL, "0.0.0"},
		{"0.0.0", LESS, "0.0.1"},
		{"0.0.0", LESS, "0.0.2"},
		{"0.0.0", LESS, "0.0.10"},
		{"0.0.0", LESS, "0.0.99"},
		{"0.0.0", LESS, "0.1.0"},
		{"0.0.0", LESS, "0.2.0"},
		{"0.0.0", LESS, "0.10.0"},
		{"0.0.0", LESS, "0.99.0"},
		{"0.0.0", LESS, "0.100.0"},
		{"0.0.0", LESS, "0.0.0.0"},
		{"0.0.0", LESS, "0.0.0.1"},
		{"0.0.0", LESS, "0.0.0.10"},
		{"0.0.0", LESS, "0.0.1.0"},
		{"0.0.0", LESS, "0.0.01.0"},
		{"0.0.0", LESS, "1.2.3.4"},
		{"0.0.0", LESS, "1-2-3-4"},
		{"0.0.0", LESS, "20150101"},
		{"0.0.0", LESS, "20151212"},
		{"0.0.0", LESS, "20151212.0"},
		{"0.0.0", LESS, "20151212.1"},
		{"0.0.0", LESS, "2015.1.1"},
		{"0.0.0", LESS, "2015.02.02"},
		{"0.0.0", LESS, "2015.12.12"},
		{"0.0.0", LESS, "1.2.3a"},
		{"0.0.0", LESS, "1.2.3b"},
		{"0.0.0", GREATER, "R16B"},
		{"0.0.0", GREATER, "R16C"},
		{"0.0.0", LESS, "1.2.3.2016.1.1"},
		{"0.0.0", LESS, "0.5a1.dev"},
		{"0.0.0", LESS, "1.8.B59BrZX"},
		{"0.0.0", LESS, "0.07b4p1"},
		{"0.0.0", LESS, "3.99.5final.SP07"},
		{"0.0.0", LESS, "3.99.5final.SP08"},
		{"0.0.0", LESS, "0.4.tbb.20100203"},
		{"0.0.0", LESS, "0.5.20120830CVS.el7"},
		{"0.0.0", LESS, "1.el7"},
		{"0.0.0", LESS, "1.el6"},
		{"0.0.0", LESS, "10.el7"},
		{"0.0.0", LESS, "01.el7"},
		{"0.0.0", LESS, "0.17.20140318svn632.el7"},
		{"0.0.0", LESS, "0.17.20140318svn633.el7"},
		{"0.0.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.0", LESS, "22.svn457.el7"},
		{"0.0.0", LESS, "22.svn458.el7"},
		{"0.0.0", GREATER, "~"},
		{"0.0.0", GREATER, "~~"},
		{"0.0.0", GREATER, "~1"},
		{"0.0.0", GREATER, "~a"},
		{"0.0.0", LESS, "1~"},
		{"0.0.0", LESS, "2~"},
		{"0.0.1", GREATER, ""},
		{"0.0.1", GREATER, "0"},
		{"0.0.1", LESS, "1"},
		{"0.0.1", LESS, "2"},
		{"0.0.1", LESS, "10"},
		{"0.0.1", LESS, "100"},
		{"0.0.1", GREATER, "0.0"},
		{"0.0.1", LESS, "0.1"},
		{"0.0.1", LESS, "0.10"},
		{"0.0.1", LESS, "0.99"},
		{"0.0.1", LESS, "1.0"},
		{"0.0.1", LESS, "1.99"},
		{"0.0.1", LESS, "2.0"},
		{"0.0.1", GREATER, "0.0.0"},
		{"0.0.1", EQUAL, "0.0.1"},
		{"0.0.1", LESS, "0.0.2"},
		{"0.0.1", LESS, "0.0.10"},
		{"0.0.1", LESS, "0.0.99"},
		{"0.0.1", LESS, "0.1.0"},
		{"0.0.1", LESS, "0.2.0"},
		{"0.0.1", LESS, "0.10.0"},
		{"0.0.1", LESS, "0.99.0"},
		{"0.0.1", LESS, "0.100.0"},
		{"0.0.1", GREATER, "0.0.0.0"},
		{"0.0.1", GREATER, "0.0.0.1"},
		{"0.0.1", GREATER, "0.0.0.10"},
		{"0.0.1", LESS, "0.0.1.0"},
		{"0.0.1", LESS, "0.0.01.0"},
		{"0.0.1", LESS, "1.2.3.4"},
		{"0.0.1", LESS, "1-2-3-4"},
		{"0.0.1", LESS, "20150101"},
		{"0.0.1", LESS, "20151212"},
		{"0.0.1", LESS, "20151212.0"},
		{"0.0.1", LESS, "20151212.1"},
		{"0.0.1", LESS, "2015.1.1"},
		{"0.0.1", LESS, "2015.02.02"},
		{"0.0.1", LESS, "2015.12.12"},
		{"0.0.1", LESS, "1.2.3a"},
		{"0.0.1", LESS, "1.2.3b"},
		{"0.0.1", GREATER, "R16B"},
		{"0.0.1", GREATER, "R16C"},
		{"0.0.1", LESS, "1.2.3.2016.1.1"},
		{"0.0.1", LESS, "0.5a1.dev"},
		{"0.0.1", LESS, "1.8.B59BrZX"},
		{"0.0.1", LESS, "0.07b4p1"},
		{"0.0.1", LESS, "3.99.5final.SP07"},
		{"0.0.1", LESS, "3.99.5final.SP08"},
		{"0.0.1", LESS, "0.4.tbb.20100203"},
		{"0.0.1", LESS, "0.5.20120830CVS.el7"},
		{"0.0.1", LESS, "1.el7"},
		{"0.0.1", LESS, "1.el6"},
		{"0.0.1", LESS, "10.el7"},
		{"0.0.1", LESS, "01.el7"},
		{"0.0.1", LESS, "0.17.20140318svn632.el7"},
		{"0.0.1", LESS, "0.17.20140318svn633.el7"},
		{"0.0.1", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.1", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.1", LESS, "22.svn457.el7"},
		{"0.0.1", LESS, "22.svn458.el7"},
		{"0.0.1", GREATER, "~"},
		{"0.0.1", GREATER, "~~"},
		{"0.0.1", GREATER, "~1"},
		{"0.0.1", GREATER, "~a"},
		{"0.0.1", LESS, "1~"},
		{"0.0.1", LESS, "2~"},
		{"0.0.2", GREATER, ""},
		{"0.0.2", GREATER, "0"},
		{"0.0.2", LESS, "1"},
		{"0.0.2", LESS, "2"},
		{"0.0.2", LESS, "10"},
		{"0.0.2", LESS, "100"},
		{"0.0.2", GREATER, "0.0"},
		{"0.0.2", LESS, "0.1"},
		{"0.0.2", LESS, "0.10"},
		{"0.0.2", LESS, "0.99"},
		{"0.0.2", LESS, "1.0"},
		{"0.0.2", LESS, "1.99"},
		{"0.0.2", LESS, "2.0"},
		{"0.0.2", GREATER, "0.0.0"},
		{"0.0.2", GREATER, "0.0.1"},
		{"0.0.2", EQUAL, "0.0.2"},
		{"0.0.2", LESS, "0.0.10"},
		{"0.0.2", LESS, "0.0.99"},
		{"0.0.2", LESS, "0.1.0"},
		{"0.0.2", LESS, "0.2.0"},
		{"0.0.2", LESS, "0.10.0"},
		{"0.0.2", LESS, "0.99.0"},
		{"0.0.2", LESS, "0.100.0"},
		{"0.0.2", GREATER, "0.0.0.0"},
		{"0.0.2", GREATER, "0.0.0.1"},
		{"0.0.2", GREATER, "0.0.0.10"},
		{"0.0.2", GREATER, "0.0.1.0"},
		{"0.0.2", GREATER, "0.0.01.0"},
		{"0.0.2", LESS, "1.2.3.4"},
		{"0.0.2", LESS, "1-2-3-4"},
		{"0.0.2", LESS, "20150101"},
		{"0.0.2", LESS, "20151212"},
		{"0.0.2", LESS, "20151212.0"},
		{"0.0.2", LESS, "20151212.1"},
		{"0.0.2", LESS, "2015.1.1"},
		{"0.0.2", LESS, "2015.02.02"},
		{"0.0.2", LESS, "2015.12.12"},
		{"0.0.2", LESS, "1.2.3a"},
		{"0.0.2", LESS, "1.2.3b"},
		{"0.0.2", GREATER, "R16B"},
		{"0.0.2", GREATER, "R16C"},
		{"0.0.2", LESS, "1.2.3.2016.1.1"},
		{"0.0.2", LESS, "0.5a1.dev"},
		{"0.0.2", LESS, "1.8.B59BrZX"},
		{"0.0.2", LESS, "0.07b4p1"},
		{"0.0.2", LESS, "3.99.5final.SP07"},
		{"0.0.2", LESS, "3.99.5final.SP08"},
		{"0.0.2", LESS, "0.4.tbb.20100203"},
		{"0.0.2", LESS, "0.5.20120830CVS.el7"},
		{"0.0.2", LESS, "1.el7"},
		{"0.0.2", LESS, "1.el6"},
		{"0.0.2", LESS, "10.el7"},
		{"0.0.2", LESS, "01.el7"},
		{"0.0.2", LESS, "0.17.20140318svn632.el7"},
		{"0.0.2", LESS, "0.17.20140318svn633.el7"},
		{"0.0.2", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.2", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.2", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.2", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.2", LESS, "22.svn457.el7"},
		{"0.0.2", LESS, "22.svn458.el7"},
		{"0.0.2", GREATER, "~"},
		{"0.0.2", GREATER, "~~"},
		{"0.0.2", GREATER, "~1"},
		{"0.0.2", GREATER, "~a"},
		{"0.0.2", LESS, "1~"},
		{"0.0.2", LESS, "2~"},
		{"0.0.10", GREATER, ""},
		{"0.0.10", GREATER, "0"},
		{"0.0.10", LESS, "1"},
		{"0.0.10", LESS, "2"},
		{"0.0.10", LESS, "10"},
		{"0.0.10", LESS, "100"},
		{"0.0.10", GREATER, "0.0"},
		{"0.0.10", LESS, "0.1"},
		{"0.0.10", LESS, "0.10"},
		{"0.0.10", LESS, "0.99"},
		{"0.0.10", LESS, "1.0"},
		{"0.0.10", LESS, "1.99"},
		{"0.0.10", LESS, "2.0"},
		{"0.0.10", GREATER, "0.0.0"},
		{"0.0.10", GREATER, "0.0.1"},
		{"0.0.10", GREATER, "0.0.2"},
		{"0.0.10", EQUAL, "0.0.10"},
		{"0.0.10", LESS, "0.0.99"},
		{"0.0.10", LESS, "0.1.0"},
		{"0.0.10", LESS, "0.2.0"},
		{"0.0.10", LESS, "0.10.0"},
		{"0.0.10", LESS, "0.99.0"},
		{"0.0.10", LESS, "0.100.0"},
		{"0.0.10", GREATER, "0.0.0.0"},
		{"0.0.10", GREATER, "0.0.0.1"},
		{"0.0.10", GREATER, "0.0.0.10"},
		{"0.0.10", GREATER, "0.0.1.0"},
		{"0.0.10", GREATER, "0.0.01.0"},
		{"0.0.10", LESS, "1.2.3.4"},
		{"0.0.10", LESS, "1-2-3-4"},
		{"0.0.10", LESS, "20150101"},
		{"0.0.10", LESS, "20151212"},
		{"0.0.10", LESS, "20151212.0"},
		{"0.0.10", LESS, "20151212.1"},
		{"0.0.10", LESS, "2015.1.1"},
		{"0.0.10", LESS, "2015.02.02"},
		{"0.0.10", LESS, "2015.12.12"},
		{"0.0.10", LESS, "1.2.3a"},
		{"0.0.10", LESS, "1.2.3b"},
		{"0.0.10", GREATER, "R16B"},
		{"0.0.10", GREATER, "R16C"},
		{"0.0.10", LESS, "1.2.3.2016.1.1"},
		{"0.0.10", LESS, "0.5a1.dev"},
		{"0.0.10", LESS, "1.8.B59BrZX"},
		{"0.0.10", LESS, "0.07b4p1"},
		{"0.0.10", LESS, "3.99.5final.SP07"},
		{"0.0.10", LESS, "3.99.5final.SP08"},
		{"0.0.10", LESS, "0.4.tbb.20100203"},
		{"0.0.10", LESS, "0.5.20120830CVS.el7"},
		{"0.0.10", LESS, "1.el7"},
		{"0.0.10", LESS, "1.el6"},
		{"0.0.10", LESS, "10.el7"},
		{"0.0.10", LESS, "01.el7"},
		{"0.0.10", LESS, "0.17.20140318svn632.el7"},
		{"0.0.10", LESS, "0.17.20140318svn633.el7"},
		{"0.0.10", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.10", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.10", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.10", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.10", LESS, "22.svn457.el7"},
		{"0.0.10", LESS, "22.svn458.el7"},
		{"0.0.10", GREATER, "~"},
		{"0.0.10", GREATER, "~~"},
		{"0.0.10", GREATER, "~1"},
		{"0.0.10", GREATER, "~a"},
		{"0.0.10", LESS, "1~"},
		{"0.0.10", LESS, "2~"},
		{"0.0.99", GREATER, ""},
		{"0.0.99", GREATER, "0"},
		{"0.0.99", LESS, "1"},
		{"0.0.99", LESS, "2"},
		{"0.0.99", LESS, "10"},
		{"0.0.99", LESS, "100"},
		{"0.0.99", GREATER, "0.0"},
		{"0.0.99", LESS, "0.1"},
		{"0.0.99", LESS, "0.10"},
		{"0.0.99", LESS, "0.99"},
		{"0.0.99", LESS, "1.0"},
		{"0.0.99", LESS, "1.99"},
		{"0.0.99", LESS, "2.0"},
		{"0.0.99", GREATER, "0.0.0"},
		{"0.0.99", GREATER, "0.0.1"},
		{"0.0.99", GREATER, "0.0.2"},
		{"0.0.99", GREATER, "0.0.10"},
		{"0.0.99", EQUAL, "0.0.99"},
		{"0.0.99", LESS, "0.1.0"},
		{"0.0.99", LESS, "0.2.0"},
		{"0.0.99", LESS, "0.10.0"},
		{"0.0.99", LESS, "0.99.0"},
		{"0.0.99", LESS, "0.100.0"},
		{"0.0.99", GREATER, "0.0.0.0"},
		{"0.0.99", GREATER, "0.0.0.1"},
		{"0.0.99", GREATER, "0.0.0.10"},
		{"0.0.99", GREATER, "0.0.1.0"},
		{"0.0.99", GREATER, "0.0.01.0"},
		{"0.0.99", LESS, "1.2.3.4"},
		{"0.0.99", LESS, "1-2-3-4"},
		{"0.0.99", LESS, "20150101"},
		{"0.0.99", LESS, "20151212"},
		{"0.0.99", LESS, "20151212.0"},
		{"0.0.99", LESS, "20151212.1"},
		{"0.0.99", LESS, "2015.1.1"},
		{"0.0.99", LESS, "2015.02.02"},
		{"0.0.99", LESS, "2015.12.12"},
		{"0.0.99", LESS, "1.2.3a"},
		{"0.0.99", LESS, "1.2.3b"},
		{"0.0.99", GREATER, "R16B"},
		{"0.0.99", GREATER, "R16C"},
		{"0.0.99", LESS, "1.2.3.2016.1.1"},
		{"0.0.99", LESS, "0.5a1.dev"},
		{"0.0.99", LESS, "1.8.B59BrZX"},
		{"0.0.99", LESS, "0.07b4p1"},
		{"0.0.99", LESS, "3.99.5final.SP07"},
		{"0.0.99", LESS, "3.99.5final.SP08"},
		{"0.0.99", LESS, "0.4.tbb.20100203"},
		{"0.0.99", LESS, "0.5.20120830CVS.el7"},
		{"0.0.99", LESS, "1.el7"},
		{"0.0.99", LESS, "1.el6"},
		{"0.0.99", LESS, "10.el7"},
		{"0.0.99", LESS, "01.el7"},
		{"0.0.99", LESS, "0.17.20140318svn632.el7"},
		{"0.0.99", LESS, "0.17.20140318svn633.el7"},
		{"0.0.99", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.99", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.99", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.99", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.99", LESS, "22.svn457.el7"},
		{"0.0.99", LESS, "22.svn458.el7"},
		{"0.0.99", GREATER, "~"},
		{"0.0.99", GREATER, "~~"},
		{"0.0.99", GREATER, "~1"},
		{"0.0.99", GREATER, "~a"},
		{"0.0.99", LESS, "1~"},
		{"0.0.99", LESS, "2~"},
		{"0.1.0", GREATER, ""},
		{"0.1.0", GREATER, "0"},
		{"0.1.0", LESS, "1"},
		{"0.1.0", LESS, "2"},
		{"0.1.0", LESS, "10"},
		{"0.1.0", LESS, "100"},
		{"0.1.0", GREATER, "0.0"},
		{"0.1.0", GREATER, "0.1"},
		{"0.1.0", LESS, "0.10"},
		{"0.1.0", LESS, "0.99"},
		{"0.1.0", LESS, "1.0"},
		{"0.1.0", LESS, "1.99"},
		{"0.1.0", LESS, "2.0"},
		{"0.1.0", GREATER, "0.0.0"},
		{"0.1.0", GREATER, "0.0.1"},
		{"0.1.0", GREATER, "0.0.2"},
		{"0.1.0", GREATER, "0.0.10"},
		{"0.1.0", GREATER, "0.0.99"},
		{"0.1.0", EQUAL, "0.1.0"},
		{"0.1.0", LESS, "0.2.0"},
		{"0.1.0", LESS, "0.10.0"},
		{"0.1.0", LESS, "0.99.0"},
		{"0.1.0", LESS, "0.100.0"},
		{"0.1.0", GREATER, "0.0.0.0"},
		{"0.1.0", GREATER, "0.0.0.1"},
		{"0.1.0", GREATER, "0.0.0.10"},
		{"0.1.0", GREATER, "0.0.1.0"},
		{"0.1.0", GREATER, "0.0.01.0"},
		{"0.1.0", LESS, "1.2.3.4"},
		{"0.1.0", LESS, "1-2-3-4"},
		{"0.1.0", LESS, "20150101"},
		{"0.1.0", LESS, "20151212"},
		{"0.1.0", LESS, "20151212.0"},
		{"0.1.0", LESS, "20151212.1"},
		{"0.1.0", LESS, "2015.1.1"},
		{"0.1.0", LESS, "2015.02.02"},
		{"0.1.0", LESS, "2015.12.12"},
		{"0.1.0", LESS, "1.2.3a"},
		{"0.1.0", LESS, "1.2.3b"},
		{"0.1.0", GREATER, "R16B"},
		{"0.1.0", GREATER, "R16C"},
		{"0.1.0", LESS, "1.2.3.2016.1.1"},
		{"0.1.0", LESS, "0.5a1.dev"},
		{"0.1.0", LESS, "1.8.B59BrZX"},
		{"0.1.0", LESS, "0.07b4p1"},
		{"0.1.0", LESS, "3.99.5final.SP07"},
		{"0.1.0", LESS, "3.99.5final.SP08"},
		{"0.1.0", LESS, "0.4.tbb.20100203"},
		{"0.1.0", LESS, "0.5.20120830CVS.el7"},
		{"0.1.0", LESS, "1.el7"},
		{"0.1.0", LESS, "1.el6"},
		{"0.1.0", LESS, "10.el7"},
		{"0.1.0", LESS, "01.el7"},
		{"0.1.0", LESS, "0.17.20140318svn632.el7"},
		{"0.1.0", LESS, "0.17.20140318svn633.el7"},
		{"0.1.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.1.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.1.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.1.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.1.0", LESS, "22.svn457.el7"},
		{"0.1.0", LESS, "22.svn458.el7"},
		{"0.1.0", GREATER, "~"},
		{"0.1.0", GREATER, "~~"},
		{"0.1.0", GREATER, "~1"},
		{"0.1.0", GREATER, "~a"},
		{"0.1.0", LESS, "1~"},
		{"0.1.0", LESS, "2~"},
		{"0.2.0", GREATER, ""},
		{"0.2.0", GREATER, "0"},
		{"0.2.0", LESS, "1"},
		{"0.2.0", LESS, "2"},
		{"0.2.0", LESS, "10"},
		{"0.2.0", LESS, "100"},
		{"0.2.0", GREATER, "0.0"},
		{"0.2.0", GREATER, "0.1"},
		{"0.2.0", LESS, "0.10"},
		{"0.2.0", LESS, "0.99"},
		{"0.2.0", LESS, "1.0"},
		{"0.2.0", LESS, "1.99"},
		{"0.2.0", LESS, "2.0"},
		{"0.2.0", GREATER, "0.0.0"},
		{"0.2.0", GREATER, "0.0.1"},
		{"0.2.0", GREATER, "0.0.2"},
		{"0.2.0", GREATER, "0.0.10"},
		{"0.2.0", GREATER, "0.0.99"},
		{"0.2.0", GREATER, "0.1.0"},
		{"0.2.0", EQUAL, "0.2.0"},
		{"0.2.0", LESS, "0.10.0"},
		{"0.2.0", LESS, "0.99.0"},
		{"0.2.0", LESS, "0.100.0"},
		{"0.2.0", GREATER, "0.0.0.0"},
		{"0.2.0", GREATER, "0.0.0.1"},
		{"0.2.0", GREATER, "0.0.0.10"},
		{"0.2.0", GREATER, "0.0.1.0"},
		{"0.2.0", GREATER, "0.0.01.0"},
		{"0.2.0", LESS, "1.2.3.4"},
		{"0.2.0", LESS, "1-2-3-4"},
		{"0.2.0", LESS, "20150101"},
		{"0.2.0", LESS, "20151212"},
		{"0.2.0", LESS, "20151212.0"},
		{"0.2.0", LESS, "20151212.1"},
		{"0.2.0", LESS, "2015.1.1"},
		{"0.2.0", LESS, "2015.02.02"},
		{"0.2.0", LESS, "2015.12.12"},
		{"0.2.0", LESS, "1.2.3a"},
		{"0.2.0", LESS, "1.2.3b"},
		{"0.2.0", GREATER, "R16B"},
		{"0.2.0", GREATER, "R16C"},
		{"0.2.0", LESS, "1.2.3.2016.1.1"},
		{"0.2.0", LESS, "0.5a1.dev"},
		{"0.2.0", LESS, "1.8.B59BrZX"},
		{"0.2.0", LESS, "0.07b4p1"},
		{"0.2.0", LESS, "3.99.5final.SP07"},
		{"0.2.0", LESS, "3.99.5final.SP08"},
		{"0.2.0", LESS, "0.4.tbb.20100203"},
		{"0.2.0", LESS, "0.5.20120830CVS.el7"},
		{"0.2.0", LESS, "1.el7"},
		{"0.2.0", LESS, "1.el6"},
		{"0.2.0", LESS, "10.el7"},
		{"0.2.0", LESS, "01.el7"},
		{"0.2.0", LESS, "0.17.20140318svn632.el7"},
		{"0.2.0", LESS, "0.17.20140318svn633.el7"},
		{"0.2.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.2.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.2.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.2.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.2.0", LESS, "22.svn457.el7"},
		{"0.2.0", LESS, "22.svn458.el7"},
		{"0.2.0", GREATER, "~"},
		{"0.2.0", GREATER, "~~"},
		{"0.2.0", GREATER, "~1"},
		{"0.2.0", GREATER, "~a"},
		{"0.2.0", LESS, "1~"},
		{"0.2.0", LESS, "2~"},
		{"0.10.0", GREATER, ""},
		{"0.10.0", GREATER, "0"},
		{"0.10.0", LESS, "1"},
		{"0.10.0", LESS, "2"},
		{"0.10.0", LESS, "10"},
		{"0.10.0", LESS, "100"},
		{"0.10.0", GREATER, "0.0"},
		{"0.10.0", GREATER, "0.1"},
		{"0.10.0", GREATER, "0.10"},
		{"0.10.0", LESS, "0.99"},
		{"0.10.0", LESS, "1.0"},
		{"0.10.0", LESS, "1.99"},
		{"0.10.0", LESS, "2.0"},
		{"0.10.0", GREATER, "0.0.0"},
		{"0.10.0", GREATER, "0.0.1"},
		{"0.10.0", GREATER, "0.0.2"},
		{"0.10.0", GREATER, "0.0.10"},
		{"0.10.0", GREATER, "0.0.99"},
		{"0.10.0", GREATER, "0.1.0"},
		{"0.10.0", GREATER, "0.2.0"},
		{"0.10.0", EQUAL, "0.10.0"},
		{"0.10.0", LESS, "0.99.0"},
		{"0.10.0", LESS, "0.100.0"},
		{"0.10.0", GREATER, "0.0.0.0"},
		{"0.10.0", GREATER, "0.0.0.1"},
		{"0.10.0", GREATER, "0.0.0.10"},
		{"0.10.0", GREATER, "0.0.1.0"},
		{"0.10.0", GREATER, "0.0.01.0"},
		{"0.10.0", LESS, "1.2.3.4"},
		{"0.10.0", LESS, "1-2-3-4"},
		{"0.10.0", LESS, "20150101"},
		{"0.10.0", LESS, "20151212"},
		{"0.10.0", LESS, "20151212.0"},
		{"0.10.0", LESS, "20151212.1"},
		{"0.10.0", LESS, "2015.1.1"},
		{"0.10.0", LESS, "2015.02.02"},
		{"0.10.0", LESS, "2015.12.12"},
		{"0.10.0", LESS, "1.2.3a"},
		{"0.10.0", LESS, "1.2.3b"},
		{"0.10.0", GREATER, "R16B"},
		{"0.10.0", GREATER, "R16C"},
		{"0.10.0", LESS, "1.2.3.2016.1.1"},
		{"0.10.0", GREATER, "0.5a1.dev"},
		{"0.10.0", LESS, "1.8.B59BrZX"},
		{"0.10.0", GREATER, "0.07b4p1"},
		{"0.10.0", LESS, "3.99.5final.SP07"},
		{"0.10.0", LESS, "3.99.5final.SP08"},
		{"0.10.0", GREATER, "0.4.tbb.20100203"},
		{"0.10.0", GREATER, "0.5.20120830CVS.el7"},
		{"0.10.0", LESS, "1.el7"},
		{"0.10.0", LESS, "1.el6"},
		{"0.10.0", LESS, "10.el7"},
		{"0.10.0", LESS, "01.el7"},
		{"0.10.0", LESS, "0.17.20140318svn632.el7"},
		{"0.10.0", LESS, "0.17.20140318svn633.el7"},
		{"0.10.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.10.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.10.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.10.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.10.0", LESS, "22.svn457.el7"},
		{"0.10.0", LESS, "22.svn458.el7"},
		{"0.10.0", GREATER, "~"},
		{"0.10.0", GREATER, "~~"},
		{"0.10.0", GREATER, "~1"},
		{"0.10.0", GREATER, "~a"},
		{"0.10.0", LESS, "1~"},
		{"0.10.0", LESS, "2~"},
		{"0.99.0", GREATER, ""},
		{"0.99.0", GREATER, "0"},
		{"0.99.0", LESS, "1"},
		{"0.99.0", LESS, "2"},
		{"0.99.0", LESS, "10"},
		{"0.99.0", LESS, "100"},
		{"0.99.0", GREATER, "0.0"},
		{"0.99.0", GREATER, "0.1"},
		{"0.99.0", GREATER, "0.10"},
		{"0.99.0", GREATER, "0.99"},
		{"0.99.0", LESS, "1.0"},
		{"0.99.0", LESS, "1.99"},
		{"0.99.0", LESS, "2.0"},
		{"0.99.0", GREATER, "0.0.0"},
		{"0.99.0", GREATER, "0.0.1"},
		{"0.99.0", GREATER, "0.0.2"},
		{"0.99.0", GREATER, "0.0.10"},
		{"0.99.0", GREATER, "0.0.99"},
		{"0.99.0", GREATER, "0.1.0"},
		{"0.99.0", GREATER, "0.2.0"},
		{"0.99.0", GREATER, "0.10.0"},
		{"0.99.0", EQUAL, "0.99.0"},
		{"0.99.0", LESS, "0.100.0"},
		{"0.99.0", GREATER, "0.0.0.0"},
		{"0.99.0", GREATER, "0.0.0.1"},
		{"0.99.0", GREATER, "0.0.0.10"},
		{"0.99.0", GREATER, "0.0.1.0"},
		{"0.99.0", GREATER, "0.0.01.0"},
		{"0.99.0", LESS, "1.2.3.4"},
		{"0.99.0", LESS, "1-2-3-4"},
		{"0.99.0", LESS, "20150101"},
		{"0.99.0", LESS, "20151212"},
		{"0.99.0", LESS, "20151212.0"},
		{"0.99.0", LESS, "20151212.1"},
		{"0.99.0", LESS, "2015.1.1"},
		{"0.99.0", LESS, "2015.02.02"},
		{"0.99.0", LESS, "2015.12.12"},
		{"0.99.0", LESS, "1.2.3a"},
		{"0.99.0", LESS, "1.2.3b"},
		{"0.99.0", GREATER, "R16B"},
		{"0.99.0", GREATER, "R16C"},
		{"0.99.0", LESS, "1.2.3.2016.1.1"},
		{"0.99.0", GREATER, "0.5a1.dev"},
		{"0.99.0", LESS, "1.8.B59BrZX"},
		{"0.99.0", GREATER, "0.07b4p1"},
		{"0.99.0", LESS, "3.99.5final.SP07"},
		{"0.99.0", LESS, "3.99.5final.SP08"},
		{"0.99.0", GREATER, "0.4.tbb.20100203"},
		{"0.99.0", GREATER, "0.5.20120830CVS.el7"},
		{"0.99.0", LESS, "1.el7"},
		{"0.99.0", LESS, "1.el6"},
		{"0.99.0", LESS, "10.el7"},
		{"0.99.0", LESS, "01.el7"},
		{"0.99.0", GREATER, "0.17.20140318svn632.el7"},
		{"0.99.0", GREATER, "0.17.20140318svn633.el7"},
		{"0.99.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.99.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.99.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.99.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.99.0", LESS, "22.svn457.el7"},
		{"0.99.0", LESS, "22.svn458.el7"},
		{"0.99.0", GREATER, "~"},
		{"0.99.0", GREATER, "~~"},
		{"0.99.0", GREATER, "~1"},
		{"0.99.0", GREATER, "~a"},
		{"0.99.0", LESS, "1~"},
		{"0.99.0", LESS, "2~"},
		{"0.100.0", GREATER, ""},
		{"0.100.0", GREATER, "0"},
		{"0.100.0", LESS, "1"},
		{"0.100.0", LESS, "2"},
		{"0.100.0", LESS, "10"},
		{"0.100.0", LESS, "100"},
		{"0.100.0", GREATER, "0.0"},
		{"0.100.0", GREATER, "0.1"},
		{"0.100.0", GREATER, "0.10"},
		{"0.100.0", GREATER, "0.99"},
		{"0.100.0", LESS, "1.0"},
		{"0.100.0", LESS, "1.99"},
		{"0.100.0", LESS, "2.0"},
		{"0.100.0", GREATER, "0.0.0"},
		{"0.100.0", GREATER, "0.0.1"},
		{"0.100.0", GREATER, "0.0.2"},
		{"0.100.0", GREATER, "0.0.10"},
		{"0.100.0", GREATER, "0.0.99"},
		{"0.100.0", GREATER, "0.1.0"},
		{"0.100.0", GREATER, "0.2.0"},
		{"0.100.0", GREATER, "0.10.0"},
		{"0.100.0", GREATER, "0.99.0"},
		{"0.100.0", EQUAL, "0.100.0"},
		{"0.100.0", GREATER, "0.0.0.0"},
		{"0.100.0", GREATER, "0.0.0.1"},
		{"0.100.0", GREATER, "0.0.0.10"},
		{"0.100.0", GREATER, "0.0.1.0"},
		{"0.100.0", GREATER, "0.0.01.0"},
		{"0.100.0", LESS, "1.2.3.4"},
		{"0.100.0", LESS, "1-2-3-4"},
		{"0.100.0", LESS, "20150101"},
		{"0.100.0", LESS, "20151212"},
		{"0.100.0", LESS, "20151212.0"},
		{"0.100.0", LESS, "20151212.1"},
		{"0.100.0", LESS, "2015.1.1"},
		{"0.100.0", LESS, "2015.02.02"},
		{"0.100.0", LESS, "2015.12.12"},
		{"0.100.0", LESS, "1.2.3a"},
		{"0.100.0", LESS, "1.2.3b"},
		{"0.100.0", GREATER, "R16B"},
		{"0.100.0", GREATER, "R16C"},
		{"0.100.0", LESS, "1.2.3.2016.1.1"},
		{"0.100.0", GREATER, "0.5a1.dev"},
		{"0.100.0", LESS, "1.8.B59BrZX"},
		{"0.100.0", GREATER, "0.07b4p1"},
		{"0.100.0", LESS, "3.99.5final.SP07"},
		{"0.100.0", LESS, "3.99.5final.SP08"},
		{"0.100.0", GREATER, "0.4.tbb.20100203"},
		{"0.100.0", GREATER, "0.5.20120830CVS.el7"},
		{"0.100.0", LESS, "1.el7"},
		{"0.100.0", LESS, "1.el6"},
		{"0.100.0", LESS, "10.el7"},
		{"0.100.0", LESS, "01.el7"},
		{"0.100.0", GREATER, "0.17.20140318svn632.el7"},
		{"0.100.0", GREATER, "0.17.20140318svn633.el7"},
		{"0.100.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.100.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.100.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.100.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.100.0", LESS, "22.svn457.el7"},
		{"0.100.0", LESS, "22.svn458.el7"},
		{"0.100.0", GREATER, "~"},
		{"0.100.0", GREATER, "~~"},
		{"0.100.0", GREATER, "~1"},
		{"0.100.0", GREATER, "~a"},
		{"0.100.0", LESS, "1~"},
		{"0.100.0", LESS, "2~"},
		{"0.0.0.0", GREATER, ""},
		{"0.0.0.0", GREATER, "0"},
		{"0.0.0.0", LESS, "1"},
		{"0.0.0.0", LESS, "2"},
		{"0.0.0.0", LESS, "10"},
		{"0.0.0.0", LESS, "100"},
		{"0.0.0.0", GREATER, "0.0"},
		{"0.0.0.0", LESS, "0.1"},
		{"0.0.0.0", LESS, "0.10"},
		{"0.0.0.0", LESS, "0.99"},
		{"0.0.0.0", LESS, "1.0"},
		{"0.0.0.0", LESS, "1.99"},
		{"0.0.0.0", LESS, "2.0"},
		{"0.0.0.0", GREATER, "0.0.0"},
		{"0.0.0.0", LESS, "0.0.1"},
		{"0.0.0.0", LESS, "0.0.2"},
		{"0.0.0.0", LESS, "0.0.10"},
		{"0.0.0.0", LESS, "0.0.99"},
		{"0.0.0.0", LESS, "0.1.0"},
		{"0.0.0.0", LESS, "0.2.0"},
		{"0.0.0.0", LESS, "0.10.0"},
		{"0.0.0.0", LESS, "0.99.0"},
		{"0.0.0.0", LESS, "0.100.0"},
		{"0.0.0.0", EQUAL, "0.0.0.0"},
		{"0.0.0.0", LESS, "0.0.0.1"},
		{"0.0.0.0", LESS, "0.0.0.10"},
		{"0.0.0.0", LESS, "0.0.1.0"},
		{"0.0.0.0", LESS, "0.0.01.0"},
		{"0.0.0.0", LESS, "1.2.3.4"},
		{"0.0.0.0", LESS, "1-2-3-4"},
		{"0.0.0.0", LESS, "20150101"},
		{"0.0.0.0", LESS, "20151212"},
		{"0.0.0.0", LESS, "20151212.0"},
		{"0.0.0.0", LESS, "20151212.1"},
		{"0.0.0.0", LESS, "2015.1.1"},
		{"0.0.0.0", LESS, "2015.02.02"},
		{"0.0.0.0", LESS, "2015.12.12"},
		{"0.0.0.0", LESS, "1.2.3a"},
		{"0.0.0.0", LESS, "1.2.3b"},
		{"0.0.0.0", GREATER, "R16B"},
		{"0.0.0.0", GREATER, "R16C"},
		{"0.0.0.0", LESS, "1.2.3.2016.1.1"},
		{"0.0.0.0", LESS, "0.5a1.dev"},
		{"0.0.0.0", LESS, "1.8.B59BrZX"},
		{"0.0.0.0", LESS, "0.07b4p1"},
		{"0.0.0.0", LESS, "3.99.5final.SP07"},
		{"0.0.0.0", LESS, "3.99.5final.SP08"},
		{"0.0.0.0", LESS, "0.4.tbb.20100203"},
		{"0.0.0.0", LESS, "0.5.20120830CVS.el7"},
		{"0.0.0.0", LESS, "1.el7"},
		{"0.0.0.0", LESS, "1.el6"},
		{"0.0.0.0", LESS, "10.el7"},
		{"0.0.0.0", LESS, "01.el7"},
		{"0.0.0.0", LESS, "0.17.20140318svn632.el7"},
		{"0.0.0.0", LESS, "0.17.20140318svn633.el7"},
		{"0.0.0.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.0.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.0.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.0.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.0.0", LESS, "22.svn457.el7"},
		{"0.0.0.0", LESS, "22.svn458.el7"},
		{"0.0.0.0", GREATER, "~"},
		{"0.0.0.0", GREATER, "~~"},
		{"0.0.0.0", GREATER, "~1"},
		{"0.0.0.0", GREATER, "~a"},
		{"0.0.0.0", LESS, "1~"},
		{"0.0.0.0", LESS, "2~"},
		{"0.0.0.1", GREATER, ""},
		{"0.0.0.1", GREATER, "0"},
		{"0.0.0.1", LESS, "1"},
		{"0.0.0.1", LESS, "2"},
		{"0.0.0.1", LESS, "10"},
		{"0.0.0.1", LESS, "100"},
		{"0.0.0.1", GREATER, "0.0"},
		{"0.0.0.1", LESS, "0.1"},
		{"0.0.0.1", LESS, "0.10"},
		{"0.0.0.1", LESS, "0.99"},
		{"0.0.0.1", LESS, "1.0"},
		{"0.0.0.1", LESS, "1.99"},
		{"0.0.0.1", LESS, "2.0"},
		{"0.0.0.1", GREATER, "0.0.0"},
		{"0.0.0.1", LESS, "0.0.1"},
		{"0.0.0.1", LESS, "0.0.2"},
		{"0.0.0.1", LESS, "0.0.10"},
		{"0.0.0.1", LESS, "0.0.99"},
		{"0.0.0.1", LESS, "0.1.0"},
		{"0.0.0.1", LESS, "0.2.0"},
		{"0.0.0.1", LESS, "0.10.0"},
		{"0.0.0.1", LESS, "0.99.0"},
		{"0.0.0.1", LESS, "0.100.0"},
		{"0.0.0.1", GREATER, "0.0.0.0"},
		{"0.0.0.1", EQUAL, "0.0.0.1"},
		{"0.0.0.1", LESS, "0.0.0.10"},
		{"0.0.0.1", LESS, "0.0.1.0"},
		{"0.0.0.1", LESS, "0.0.01.0"},
		{"0.0.0.1", LESS, "1.2.3.4"},
		{"0.0.0.1", LESS, "1-2-3-4"},
		{"0.0.0.1", LESS, "20150101"},
		{"0.0.0.1", LESS, "20151212"},
		{"0.0.0.1", LESS, "20151212.0"},
		{"0.0.0.1", LESS, "20151212.1"},
		{"0.0.0.1", LESS, "2015.1.1"},
		{"0.0.0.1", LESS, "2015.02.02"},
		{"0.0.0.1", LESS, "2015.12.12"},
		{"0.0.0.1", LESS, "1.2.3a"},
		{"0.0.0.1", LESS, "1.2.3b"},
		{"0.0.0.1", GREATER, "R16B"},
		{"0.0.0.1", GREATER, "R16C"},
		{"0.0.0.1", LESS, "1.2.3.2016.1.1"},
		{"0.0.0.1", LESS, "0.5a1.dev"},
		{"0.0.0.1", LESS, "1.8.B59BrZX"},
		{"0.0.0.1", LESS, "0.07b4p1"},
		{"0.0.0.1", LESS, "3.99.5final.SP07"},
		{"0.0.0.1", LESS, "3.99.5final.SP08"},
		{"0.0.0.1", LESS, "0.4.tbb.20100203"},
		{"0.0.0.1", LESS, "0.5.20120830CVS.el7"},
		{"0.0.0.1", LESS, "1.el7"},
		{"0.0.0.1", LESS, "1.el6"},
		{"0.0.0.1", LESS, "10.el7"},
		{"0.0.0.1", LESS, "01.el7"},
		{"0.0.0.1", LESS, "0.17.20140318svn632.el7"},
		{"0.0.0.1", LESS, "0.17.20140318svn633.el7"},
		{"0.0.0.1", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.0.1", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.0.1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.0.1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.0.1", LESS, "22.svn457.el7"},
		{"0.0.0.1", LESS, "22.svn458.el7"},
		{"0.0.0.1", GREATER, "~"},
		{"0.0.0.1", GREATER, "~~"},
		{"0.0.0.1", GREATER, "~1"},
		{"0.0.0.1", GREATER, "~a"},
		{"0.0.0.1", LESS, "1~"},
		{"0.0.0.1", LESS, "2~"},
		{"0.0.0.10", GREATER, ""},
		{"0.0.0.10", GREATER, "0"},
		{"0.0.0.10", LESS, "1"},
		{"0.0.0.10", LESS, "2"},
		{"0.0.0.10", LESS, "10"},
		{"0.0.0.10", LESS, "100"},
		{"0.0.0.10", GREATER, "0.0"},
		{"0.0.0.10", LESS, "0.1"},
		{"0.0.0.10", LESS, "0.10"},
		{"0.0.0.10", LESS, "0.99"},
		{"0.0.0.10", LESS, "1.0"},
		{"0.0.0.10", LESS, "1.99"},
		{"0.0.0.10", LESS, "2.0"},
		{"0.0.0.10", GREATER, "0.0.0"},
		{"0.0.0.10", LESS, "0.0.1"},
		{"0.0.0.10", LESS, "0.0.2"},
		{"0.0.0.10", LESS, "0.0.10"},
		{"0.0.0.10", LESS, "0.0.99"},
		{"0.0.0.10", LESS, "0.1.0"},
		{"0.0.0.10", LESS, "0.2.0"},
		{"0.0.0.10", LESS, "0.10.0"},
		{"0.0.0.10", LESS, "0.99.0"},
		{"0.0.0.10", LESS, "0.100.0"},
		{"0.0.0.10", GREATER, "0.0.0.0"},
		{"0.0.0.10", GREATER, "0.0.0.1"},
		{"0.0.0.10", EQUAL, "0.0.0.10"},
		{"0.0.0.10", LESS, "0.0.1.0"},
		{"0.0.0.10", LESS, "0.0.01.0"},
		{"0.0.0.10", LESS, "1.2.3.4"},
		{"0.0.0.10", LESS, "1-2-3-4"},
		{"0.0.0.10", LESS, "20150101"},
		{"0.0.0.10", LESS, "20151212"},
		{"0.0.0.10", LESS, "20151212.0"},
		{"0.0.0.10", LESS, "20151212.1"},
		{"0.0.0.10", LESS, "2015.1.1"},
		{"0.0.0.10", LESS, "2015.02.02"},
		{"0.0.0.10", LESS, "2015.12.12"},
		{"0.0.0.10", LESS, "1.2.3a"},
		{"0.0.0.10", LESS, "1.2.3b"},
		{"0.0.0.10", GREATER, "R16B"},
		{"0.0.0.10", GREATER, "R16C"},
		{"0.0.0.10", LESS, "1.2.3.2016.1.1"},
		{"0.0.0.10", LESS, "0.5a1.dev"},
		{"0.0.0.10", LESS, "1.8.B59BrZX"},
		{"0.0.0.10", LESS, "0.07b4p1"},
		{"0.0.0.10", LESS, "3.99.5final.SP07"},
		{"0.0.0.10", LESS, "3.99.5final.SP08"},
		{"0.0.0.10", LESS, "0.4.tbb.20100203"},
		{"0.0.0.10", LESS, "0.5.20120830CVS.el7"},
		{"0.0.0.10", LESS, "1.el7"},
		{"0.0.0.10", LESS, "1.el6"},
		{"0.0.0.10", LESS, "10.el7"},
		{"0.0.0.10", LESS, "01.el7"},
		{"0.0.0.10", LESS, "0.17.20140318svn632.el7"},
		{"0.0.0.10", LESS, "0.17.20140318svn633.el7"},
		{"0.0.0.10", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.0.10", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.0.10", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.0.10", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.0.10", LESS, "22.svn457.el7"},
		{"0.0.0.10", LESS, "22.svn458.el7"},
		{"0.0.0.10", GREATER, "~"},
		{"0.0.0.10", GREATER, "~~"},
		{"0.0.0.10", GREATER, "~1"},
		{"0.0.0.10", GREATER, "~a"},
		{"0.0.0.10", LESS, "1~"},
		{"0.0.0.10", LESS, "2~"},
		{"0.0.1.0", GREATER, ""},
		{"0.0.1.0", GREATER, "0"},
		{"0.0.1.0", LESS, "1"},
		{"0.0.1.0", LESS, "2"},
		{"0.0.1.0", LESS, "10"},
		{"0.0.1.0", LESS, "100"},
		{"0.0.1.0", GREATER, "0.0"},
		{"0.0.1.0", LESS, "0.1"},
		{"0.0.1.0", LESS, "0.10"},
		{"0.0.1.0", LESS, "0.99"},
		{"0.0.1.0", LESS, "1.0"},
		{"0.0.1.0", LESS, "1.99"},
		{"0.0.1.0", LESS, "2.0"},
		{"0.0.1.0", GREATER, "0.0.0"},
		{"0.0.1.0", GREATER, "0.0.1"},
		{"0.0.1.0", LESS, "0.0.2"},
		{"0.0.1.0", LESS, "0.0.10"},
		{"0.0.1.0", LESS, "0.0.99"},
		{"0.0.1.0", LESS, "0.1.0"},
		{"0.0.1.0", LESS, "0.2.0"},
		{"0.0.1.0", LESS, "0.10.0"},
		{"0.0.1.0", LESS, "0.99.0"},
		{"0.0.1.0", LESS, "0.100.0"},
		{"0.0.1.0", GREATER, "0.0.0.0"},
		{"0.0.1.0", GREATER, "0.0.0.1"},
		{"0.0.1.0", GREATER, "0.0.0.10"},
		{"0.0.1.0", EQUAL, "0.0.1.0"},
		{"0.0.1.0", EQUAL, "0.0.01.0"},
		{"0.0.1.0", LESS, "1.2.3.4"},
		{"0.0.1.0", LESS, "1-2-3-4"},
		{"0.0.1.0", LESS, "20150101"},
		{"0.0.1.0", LESS, "20151212"},
		{"0.0.1.0", LESS, "20151212.0"},
		{"0.0.1.0", LESS, "20151212.1"},
		{"0.0.1.0", LESS, "2015.1.1"},
		{"0.0.1.0", LESS, "2015.02.02"},
		{"0.0.1.0", LESS, "2015.12.12"},
		{"0.0.1.0", LESS, "1.2.3a"},
		{"0.0.1.0", LESS, "1.2.3b"},
		{"0.0.1.0", GREATER, "R16B"},
		{"0.0.1.0", GREATER, "R16C"},
		{"0.0.1.0", LESS, "1.2.3.2016.1.1"},
		{"0.0.1.0", LESS, "0.5a1.dev"},
		{"0.0.1.0", LESS, "1.8.B59BrZX"},
		{"0.0.1.0", LESS, "0.07b4p1"},
		{"0.0.1.0", LESS, "3.99.5final.SP07"},
		{"0.0.1.0", LESS, "3.99.5final.SP08"},
		{"0.0.1.0", LESS, "0.4.tbb.20100203"},
		{"0.0.1.0", LESS, "0.5.20120830CVS.el7"},
		{"0.0.1.0", LESS, "1.el7"},
		{"0.0.1.0", LESS, "1.el6"},
		{"0.0.1.0", LESS, "10.el7"},
		{"0.0.1.0", LESS, "01.el7"},
		{"0.0.1.0", LESS, "0.17.20140318svn632.el7"},
		{"0.0.1.0", LESS, "0.17.20140318svn633.el7"},
		{"0.0.1.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.1.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.1.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.1.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.1.0", LESS, "22.svn457.el7"},
		{"0.0.1.0", LESS, "22.svn458.el7"},
		{"0.0.1.0", GREATER, "~"},
		{"0.0.1.0", GREATER, "~~"},
		{"0.0.1.0", GREATER, "~1"},
		{"0.0.1.0", GREATER, "~a"},
		{"0.0.1.0", LESS, "1~"},
		{"0.0.1.0", LESS, "2~"},
		{"0.0.01.0", GREATER, ""},
		{"0.0.01.0", GREATER, "0"},
		{"0.0.01.0", LESS, "1"},
		{"0.0.01.0", LESS, "2"},
		{"0.0.01.0", LESS, "10"},
		{"0.0.01.0", LESS, "100"},
		{"0.0.01.0", GREATER, "0.0"},
		{"0.0.01.0", LESS, "0.1"},
		{"0.0.01.0", LESS, "0.10"},
		{"0.0.01.0", LESS, "0.99"},
		{"0.0.01.0", LESS, "1.0"},
		{"0.0.01.0", LESS, "1.99"},
		{"0.0.01.0", LESS, "2.0"},
		{"0.0.01.0", GREATER, "0.0.0"},
		{"0.0.01.0", GREATER, "0.0.1"},
		{"0.0.01.0", LESS, "0.0.2"},
		{"0.0.01.0", LESS, "0.0.10"},
		{"0.0.01.0", LESS, "0.0.99"},
		{"0.0.01.0", LESS, "0.1.0"},
		{"0.0.01.0", LESS, "0.2.0"},
		{"0.0.01.0", LESS, "0.10.0"},
		{"0.0.01.0", LESS, "0.99.0"},
		{"0.0.01.0", LESS, "0.100.0"},
		{"0.0.01.0", GREATER, "0.0.0.0"},
		{"0.0.01.0", GREATER, "0.0.0.1"},
		{"0.0.01.0", GREATER, "0.0.0.10"},
		{"0.0.01.0", EQUAL, "0.0.1.0"},
		{"0.0.01.0", EQUAL, "0.0.01.0"},
		{"0.0.01.0", LESS, "1.2.3.4"},
		{"0.0.01.0", LESS, "1-2-3-4"},
		{"0.0.01.0", LESS, "20150101"},
		{"0.0.01.0", LESS, "20151212"},
		{"0.0.01.0", LESS, "20151212.0"},
		{"0.0.01.0", LESS, "20151212.1"},
		{"0.0.01.0", LESS, "2015.1.1"},
		{"0.0.01.0", LESS, "2015.02.02"},
		{"0.0.01.0", LESS, "2015.12.12"},
		{"0.0.01.0", LESS, "1.2.3a"},
		{"0.0.01.0", LESS, "1.2.3b"},
		{"0.0.01.0", GREATER, "R16B"},
		{"0.0.01.0", GREATER, "R16C"},
		{"0.0.01.0", LESS, "1.2.3.2016.1.1"},
		{"0.0.01.0", LESS, "0.5a1.dev"},
		{"0.0.01.0", LESS, "1.8.B59BrZX"},
		{"0.0.01.0", LESS, "0.07b4p1"},
		{"0.0.01.0", LESS, "3.99.5final.SP07"},
		{"0.0.01.0", LESS, "3.99.5final.SP08"},
		{"0.0.01.0", LESS, "0.4.tbb.20100203"},
		{"0.0.01.0", LESS, "0.5.20120830CVS.el7"},
		{"0.0.01.0", LESS, "1.el7"},
		{"0.0.01.0", LESS, "1.el6"},
		{"0.0.01.0", LESS, "10.el7"},
		{"0.0.01.0", LESS, "01.el7"},
		{"0.0.01.0", LESS, "0.17.20140318svn632.el7"},
		{"0.0.01.0", LESS, "0.17.20140318svn633.el7"},
		{"0.0.01.0", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.0.01.0", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.0.01.0", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.0.01.0", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.0.01.0", LESS, "22.svn457.el7"},
		{"0.0.01.0", LESS, "22.svn458.el7"},
		{"0.0.01.0", GREATER, "~"},
		{"0.0.01.0", GREATER, "~~"},
		{"0.0.01.0", GREATER, "~1"},
		{"0.0.01.0", GREATER, "~a"},
		{"0.0.01.0", LESS, "1~"},
		{"0.0.01.0", LESS, "2~"},
		{"1.2.3.4", GREATER, ""},
		{"1.2.3.4", GREATER, "0"},
		{"1.2.3.4", GREATER, "1"},
		{"1.2.3.4", LESS, "2"},
		{"1.2.3.4", LESS, "10"},
		{"1.2.3.4", LESS, "100"},
		{"1.2.3.4", GREATER, "0.0"},
		{"1.2.3.4", GREATER, "0.1"},
		{"1.2.3.4", GREATER, "0.10"},
		{"1.2.3.4", GREATER, "0.99"},
		{"1.2.3.4", GREATER, "1.0"},
		{"1.2.3.4", LESS, "1.99"},
		{"1.2.3.4", LESS, "2.0"},
		{"1.2.3.4", GREATER, "0.0.0"},
		{"1.2.3.4", GREATER, "0.0.1"},
		{"1.2.3.4", GREATER, "0.0.2"},
		{"1.2.3.4", GREATER, "0.0.10"},
		{"1.2.3.4", GREATER, "0.0.99"},
		{"1.2.3.4", GREATER, "0.1.0"},
		{"1.2.3.4", GREATER, "0.2.0"},
		{"1.2.3.4", GREATER, "0.10.0"},
		{"1.2.3.4", GREATER, "0.99.0"},
		{"1.2.3.4", GREATER, "0.100.0"},
		{"1.2.3.4", GREATER, "0.0.0.0"},
		{"1.2.3.4", GREATER, "0.0.0.1"},
		{"1.2.3.4", GREATER, "0.0.0.10"},
		{"1.2.3.4", GREATER, "0.0.1.0"},
		{"1.2.3.4", GREATER, "0.0.01.0"},
		{"1.2.3.4", EQUAL, "1.2.3.4"},
		{"1.2.3.4", EQUAL, "1-2-3-4"},
		{"1.2.3.4", LESS, "20150101"},
		{"1.2.3.4", LESS, "20151212"},
		{"1.2.3.4", LESS, "20151212.0"},
		{"1.2.3.4", LESS, "20151212.1"},
		{"1.2.3.4", LESS, "2015.1.1"},
		{"1.2.3.4", LESS, "2015.02.02"},
		{"1.2.3.4", LESS, "2015.12.12"},
		{"1.2.3.4", GREATER, "1.2.3a"},
		{"1.2.3.4", GREATER, "1.2.3b"},
		{"1.2.3.4", GREATER, "R16B"},
		{"1.2.3.4", GREATER, "R16C"},
		{"1.2.3.4", LESS, "1.2.3.2016.1.1"},
		{"1.2.3.4", GREATER, "0.5a1.dev"},
		{"1.2.3.4", LESS, "1.8.B59BrZX"},
		{"1.2.3.4", GREATER, "0.07b4p1"},
		{"1.2.3.4", LESS, "3.99.5final.SP07"},
		{"1.2.3.4", LESS, "3.99.5final.SP08"},
		{"1.2.3.4", GREATER, "0.4.tbb.20100203"},
		{"1.2.3.4", GREATER, "0.5.20120830CVS.el7"},
		{"1.2.3.4", GREATER, "1.el7"},
		{"1.2.3.4", GREATER, "1.el6"},
		{"1.2.3.4", LESS, "10.el7"},
		{"1.2.3.4", GREATER, "01.el7"},
		{"1.2.3.4", GREATER, "0.17.20140318svn632.el7"},
		{"1.2.3.4", GREATER, "0.17.20140318svn633.el7"},
		{"1.2.3.4", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.2.3.4", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.2.3.4", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.2.3.4", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.2.3.4", LESS, "22.svn457.el7"},
		{"1.2.3.4", LESS, "22.svn458.el7"},
		{"1.2.3.4", GREATER, "~"},
		{"1.2.3.4", GREATER, "~~"},
		{"1.2.3.4", GREATER, "~1"},
		{"1.2.3.4", GREATER, "~a"},
		{"1.2.3.4", GREATER, "1~"},
		{"1.2.3.4", LESS, "2~"},
		{"1-2-3-4", GREATER, ""},
		{"1-2-3-4", GREATER, "0"},
		{"1-2-3-4", GREATER, "1"},
		{"1-2-3-4", LESS, "2"},
		{"1-2-3-4", LESS, "10"},
		{"1-2-3-4", LESS, "100"},
		{"1-2-3-4", GREATER, "0.0"},
		{"1-2-3-4", GREATER, "0.1"},
		{"1-2-3-4", GREATER, "0.10"},
		{"1-2-3-4", GREATER, "0.99"},
		{"1-2-3-4", GREATER, "1.0"},
		{"1-2-3-4", LESS, "1.99"},
		{"1-2-3-4", LESS, "2.0"},
		{"1-2-3-4", GREATER, "0.0.0"},
		{"1-2-3-4", GREATER, "0.0.1"},
		{"1-2-3-4", GREATER, "0.0.2"},
		{"1-2-3-4", GREATER, "0.0.10"},
		{"1-2-3-4", GREATER, "0.0.99"},
		{"1-2-3-4", GREATER, "0.1.0"},
		{"1-2-3-4", GREATER, "0.2.0"},
		{"1-2-3-4", GREATER, "0.10.0"},
		{"1-2-3-4", GREATER, "0.99.0"},
		{"1-2-3-4", GREATER, "0.100.0"},
		{"1-2-3-4", GREATER, "0.0.0.0"},
		{"1-2-3-4", GREATER, "0.0.0.1"},
		{"1-2-3-4", GREATER, "0.0.0.10"},
		{"1-2-3-4", GREATER, "0.0.1.0"},
		{"1-2-3-4", GREATER, "0.0.01.0"},
		{"1-2-3-4", EQUAL, "1.2.3.4"},
		{"1-2-3-4", EQUAL, "1-2-3-4"},
		{"1-2-3-4", LESS, "20150101"},
		{"1-2-3-4", LESS, "20151212"},
		{"1-2-3-4", LESS, "20151212.0"},
		{"1-2-3-4", LESS, "20151212.1"},
		{"1-2-3-4", LESS, "2015.1.1"},
		{"1-2-3-4", LESS, "2015.02.02"},
		{"1-2-3-4", LESS, "2015.12.12"},
		{"1-2-3-4", GREATER, "1.2.3a"},
		{"1-2-3-4", GREATER, "1.2.3b"},
		{"1-2-3-4", GREATER, "R16B"},
		{"1-2-3-4", GREATER, "R16C"},
		{"1-2-3-4", LESS, "1.2.3.2016.1.1"},
		{"1-2-3-4", GREATER, "0.5a1.dev"},
		{"1-2-3-4", LESS, "1.8.B59BrZX"},
		{"1-2-3-4", GREATER, "0.07b4p1"},
		{"1-2-3-4", LESS, "3.99.5final.SP07"},
		{"1-2-3-4", LESS, "3.99.5final.SP08"},
		{"1-2-3-4", GREATER, "0.4.tbb.20100203"},
		{"1-2-3-4", GREATER, "0.5.20120830CVS.el7"},
		{"1-2-3-4", GREATER, "1.el7"},
		{"1-2-3-4", GREATER, "1.el6"},
		{"1-2-3-4", LESS, "10.el7"},
		{"1-2-3-4", GREATER, "01.el7"},
		{"1-2-3-4", GREATER, "0.17.20140318svn632.el7"},
		{"1-2-3-4", GREATER, "0.17.20140318svn633.el7"},
		{"1-2-3-4", LESS, "1.20140522gitad6fb3e.el7"},
		{"1-2-3-4", LESS, "1.20140522hitad6fb3e.el7"},
		{"1-2-3-4", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1-2-3-4", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1-2-3-4", LESS, "22.svn457.el7"},
		{"1-2-3-4", LESS, "22.svn458.el7"},
		{"1-2-3-4", GREATER, "~"},
		{"1-2-3-4", GREATER, "~~"},
		{"1-2-3-4", GREATER, "~1"},
		{"1-2-3-4", GREATER, "~a"},
		{"1-2-3-4", GREATER, "1~"},
		{"1-2-3-4", LESS, "2~"},
		{"20150101", GREATER, ""},
		{"20150101", GREATER, "0"},
		{"20150101", GREATER, "1"},
		{"20150101", GREATER, "2"},
		{"20150101", GREATER, "10"},
		{"20150101", GREATER, "100"},
		{"20150101", GREATER, "0.0"},
		{"20150101", GREATER, "0.1"},
		{"20150101", GREATER, "0.10"},
		{"20150101", GREATER, "0.99"},
		{"20150101", GREATER, "1.0"},
		{"20150101", GREATER, "1.99"},
		{"20150101", GREATER, "2.0"},
		{"20150101", GREATER, "0.0.0"},
		{"20150101", GREATER, "0.0.1"},
		{"20150101", GREATER, "0.0.2"},
		{"20150101", GREATER, "0.0.10"},
		{"20150101", GREATER, "0.0.99"},
		{"20150101", GREATER, "0.1.0"},
		{"20150101", GREATER, "0.2.0"},
		{"20150101", GREATER, "0.10.0"},
		{"20150101", GREATER, "0.99.0"},
		{"20150101", GREATER, "0.100.0"},
		{"20150101", GREATER, "0.0.0.0"},
		{"20150101", GREATER, "0.0.0.1"},
		{"20150101", GREATER, "0.0.0.10"},
		{"20150101", GREATER, "0.0.1.0"},
		{"20150101", GREATER, "0.0.01.0"},
		{"20150101", GREATER, "1.2.3.4"},
		{"20150101", GREATER, "1-2-3-4"},
		{"20150101", EQUAL, "20150101"},
		{"20150101", LESS, "20151212"},
		{"20150101", LESS, "20151212.0"},
		{"20150101", LESS, "20151212.1"},
		{"20150101", GREATER, "2015.1.1"},
		{"20150101", GREATER, "2015.02.02"},
		{"20150101", GREATER, "2015.12.12"},
		{"20150101", GREATER, "1.2.3a"},
		{"20150101", GREATER, "1.2.3b"},
		{"20150101", GREATER, "R16B"},
		{"20150101", GREATER, "R16C"},
		{"20150101", GREATER, "1.2.3.2016.1.1"},
		{"20150101", GREATER, "0.5a1.dev"},
		{"20150101", GREATER, "1.8.B59BrZX"},
		{"20150101", GREATER, "0.07b4p1"},
		{"20150101", GREATER, "3.99.5final.SP07"},
		{"20150101", GREATER, "3.99.5final.SP08"},
		{"20150101", GREATER, "0.4.tbb.20100203"},
		{"20150101", GREATER, "0.5.20120830CVS.el7"},
		{"20150101", GREATER, "1.el7"},
		{"20150101", GREATER, "1.el6"},
		{"20150101", GREATER, "10.el7"},
		{"20150101", GREATER, "01.el7"},
		{"20150101", GREATER, "0.17.20140318svn632.el7"},
		{"20150101", GREATER, "0.17.20140318svn633.el7"},
		{"20150101", GREATER, "1.20140522gitad6fb3e.el7"},
		{"20150101", GREATER, "1.20140522hitad6fb3e.el7"},
		{"20150101", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"20150101", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"20150101", GREATER, "22.svn457.el7"},
		{"20150101", GREATER, "22.svn458.el7"},
		{"20150101", GREATER, "~"},
		{"20150101", GREATER, "~~"},
		{"20150101", GREATER, "~1"},
		{"20150101", GREATER, "~a"},
		{"20150101", GREATER, "1~"},
		{"20150101", GREATER, "2~"},
		{"20151212", GREATER, ""},
		{"20151212", GREATER, "0"},
		{"20151212", GREATER, "1"},
		{"20151212", GREATER, "2"},
		{"20151212", GREATER, "10"},
		{"20151212", GREATER, "100"},
		{"20151212", GREATER, "0.0"},
		{"20151212", GREATER, "0.1"},
		{"20151212", GREATER, "0.10"},
		{"20151212", GREATER, "0.99"},
		{"20151212", GREATER, "1.0"},
		{"20151212", GREATER, "1.99"},
		{"20151212", GREATER, "2.0"},
		{"20151212", GREATER, "0.0.0"},
		{"20151212", GREATER, "0.0.1"},
		{"20151212", GREATER, "0.0.2"},
		{"20151212", GREATER, "0.0.10"},
		{"20151212", GREATER, "0.0.99"},
		{"20151212", GREATER, "0.1.0"},
		{"20151212", GREATER, "0.2.0"},
		{"20151212", GREATER, "0.10.0"},
		{"20151212", GREATER, "0.99.0"},
		{"20151212", GREATER, "0.100.0"},
		{"20151212", GREATER, "0.0.0.0"},
		{"20151212", GREATER, "0.0.0.1"},
		{"20151212", GREATER, "0.0.0.10"},
		{"20151212", GREATER, "0.0.1.0"},
		{"20151212", GREATER, "0.0.01.0"},
		{"20151212", GREATER, "1.2.3.4"},
		{"20151212", GREATER, "1-2-3-4"},
		{"20151212", GREATER, "20150101"},
		{"20151212", EQUAL, "20151212"},
		{"20151212", LESS, "20151212.0"},
		{"20151212", LESS, "20151212.1"},
		{"20151212", GREATER, "2015.1.1"},
		{"20151212", GREATER, "2015.02.02"},
		{"20151212", GREATER, "2015.12.12"},
		{"20151212", GREATER, "1.2.3a"},
		{"20151212", GREATER, "1.2.3b"},
		{"20151212", GREATER, "R16B"},
		{"20151212", GREATER, "R16C"},
		{"20151212", GREATER, "1.2.3.2016.1.1"},
		{"20151212", GREATER, "0.5a1.dev"},
		{"20151212", GREATER, "1.8.B59BrZX"},
		{"20151212", GREATER, "0.07b4p1"},
		{"20151212", GREATER, "3.99.5final.SP07"},
		{"20151212", GREATER, "3.99.5final.SP08"},
		{"20151212", GREATER, "0.4.tbb.20100203"},
		{"20151212", GREATER, "0.5.20120830CVS.el7"},
		{"20151212", GREATER, "1.el7"},
		{"20151212", GREATER, "1.el6"},
		{"20151212", GREATER, "10.el7"},
		{"20151212", GREATER, "01.el7"},
		{"20151212", GREATER, "0.17.20140318svn632.el7"},
		{"20151212", GREATER, "0.17.20140318svn633.el7"},
		{"20151212", GREATER, "1.20140522gitad6fb3e.el7"},
		{"20151212", GREATER, "1.20140522hitad6fb3e.el7"},
		{"20151212", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"20151212", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"20151212", GREATER, "22.svn457.el7"},
		{"20151212", GREATER, "22.svn458.el7"},
		{"20151212", GREATER, "~"},
		{"20151212", GREATER, "~~"},
		{"20151212", GREATER, "~1"},
		{"20151212", GREATER, "~a"},
		{"20151212", GREATER, "1~"},
		{"20151212", GREATER, "2~"},
		{"20151212.0", GREATER, ""},
		{"20151212.0", GREATER, "0"},
		{"20151212.0", GREATER, "1"},
		{"20151212.0", GREATER, "2"},
		{"20151212.0", GREATER, "10"},
		{"20151212.0", GREATER, "100"},
		{"20151212.0", GREATER, "0.0"},
		{"20151212.0", GREATER, "0.1"},
		{"20151212.0", GREATER, "0.10"},
		{"20151212.0", GREATER, "0.99"},
		{"20151212.0", GREATER, "1.0"},
		{"20151212.0", GREATER, "1.99"},
		{"20151212.0", GREATER, "2.0"},
		{"20151212.0", GREATER, "0.0.0"},
		{"20151212.0", GREATER, "0.0.1"},
		{"20151212.0", GREATER, "0.0.2"},
		{"20151212.0", GREATER, "0.0.10"},
		{"20151212.0", GREATER, "0.0.99"},
		{"20151212.0", GREATER, "0.1.0"},
		{"20151212.0", GREATER, "0.2.0"},
		{"20151212.0", GREATER, "0.10.0"},
		{"20151212.0", GREATER, "0.99.0"},
		{"20151212.0", GREATER, "0.100.0"},
		{"20151212.0", GREATER, "0.0.0.0"},
		{"20151212.0", GREATER, "0.0.0.1"},
		{"20151212.0", GREATER, "0.0.0.10"},
		{"20151212.0", GREATER, "0.0.1.0"},
		{"20151212.0", GREATER, "0.0.01.0"},
		{"20151212.0", GREATER, "1.2.3.4"},
		{"20151212.0", GREATER, "1-2-3-4"},
		{"20151212.0", GREATER, "20150101"},
		{"20151212.0", GREATER, "20151212"},
		{"20151212.0", EQUAL, "20151212.0"},
		{"20151212.0", LESS, "20151212.1"},
		{"20151212.0", GREATER, "2015.1.1"},
		{"20151212.0", GREATER, "2015.02.02"},
		{"20151212.0", GREATER, "2015.12.12"},
		{"20151212.0", GREATER, "1.2.3a"},
		{"20151212.0", GREATER, "1.2.3b"},
		{"20151212.0", GREATER, "R16B"},
		{"20151212.0", GREATER, "R16C"},
		{"20151212.0", GREATER, "1.2.3.2016.1.1"},
		{"20151212.0", GREATER, "0.5a1.dev"},
		{"20151212.0", GREATER, "1.8.B59BrZX"},
		{"20151212.0", GREATER, "0.07b4p1"},
		{"20151212.0", GREATER, "3.99.5final.SP07"},
		{"20151212.0", GREATER, "3.99.5final.SP08"},
		{"20151212.0", GREATER, "0.4.tbb.20100203"},
		{"20151212.0", GREATER, "0.5.20120830CVS.el7"},
		{"20151212.0", GREATER, "1.el7"},
		{"20151212.0", GREATER, "1.el6"},
		{"20151212.0", GREATER, "10.el7"},
		{"20151212.0", GREATER, "01.el7"},
		{"20151212.0", GREATER, "0.17.20140318svn632.el7"},
		{"20151212.0", GREATER, "0.17.20140318svn633.el7"},
		{"20151212.0", GREATER, "1.20140522gitad6fb3e.el7"},
		{"20151212.0", GREATER, "1.20140522hitad6fb3e.el7"},
		{"20151212.0", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"20151212.0", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"20151212.0", GREATER, "22.svn457.el7"},
		{"20151212.0", GREATER, "22.svn458.el7"},
		{"20151212.0", GREATER, "~"},
		{"20151212.0", GREATER, "~~"},
		{"20151212.0", GREATER, "~1"},
		{"20151212.0", GREATER, "~a"},
		{"20151212.0", GREATER, "1~"},
		{"20151212.0", GREATER, "2~"},
		{"20151212.1", GREATER, ""},
		{"20151212.1", GREATER, "0"},
		{"20151212.1", GREATER, "1"},
		{"20151212.1", GREATER, "2"},
		{"20151212.1", GREATER, "10"},
		{"20151212.1", GREATER, "100"},
		{"20151212.1", GREATER, "0.0"},
		{"20151212.1", GREATER, "0.1"},
		{"20151212.1", GREATER, "0.10"},
		{"20151212.1", GREATER, "0.99"},
		{"20151212.1", GREATER, "1.0"},
		{"20151212.1", GREATER, "1.99"},
		{"20151212.1", GREATER, "2.0"},
		{"20151212.1", GREATER, "0.0.0"},
		{"20151212.1", GREATER, "0.0.1"},
		{"20151212.1", GREATER, "0.0.2"},
		{"20151212.1", GREATER, "0.0.10"},
		{"20151212.1", GREATER, "0.0.99"},
		{"20151212.1", GREATER, "0.1.0"},
		{"20151212.1", GREATER, "0.2.0"},
		{"20151212.1", GREATER, "0.10.0"},
		{"20151212.1", GREATER, "0.99.0"},
		{"20151212.1", GREATER, "0.100.0"},
		{"20151212.1", GREATER, "0.0.0.0"},
		{"20151212.1", GREATER, "0.0.0.1"},
		{"20151212.1", GREATER, "0.0.0.10"},
		{"20151212.1", GREATER, "0.0.1.0"},
		{"20151212.1", GREATER, "0.0.01.0"},
		{"20151212.1", GREATER, "1.2.3.4"},
		{"20151212.1", GREATER, "1-2-3-4"},
		{"20151212.1", GREATER, "20150101"},
		{"20151212.1", GREATER, "20151212"},
		{"20151212.1", GREATER, "20151212.0"},
		{"20151212.1", EQUAL, "20151212.1"},
		{"20151212.1", GREATER, "2015.1.1"},
		{"20151212.1", GREATER, "2015.02.02"},
		{"20151212.1", GREATER, "2015.12.12"},
		{"20151212.1", GREATER, "1.2.3a"},
		{"20151212.1", GREATER, "1.2.3b"},
		{"20151212.1", GREATER, "R16B"},
		{"20151212.1", GREATER, "R16C"},
		{"20151212.1", GREATER, "1.2.3.2016.1.1"},
		{"20151212.1", GREATER, "0.5a1.dev"},
		{"20151212.1", GREATER, "1.8.B59BrZX"},
		{"20151212.1", GREATER, "0.07b4p1"},
		{"20151212.1", GREATER, "3.99.5final.SP07"},
		{"20151212.1", GREATER, "3.99.5final.SP08"},
		{"20151212.1", GREATER, "0.4.tbb.20100203"},
		{"20151212.1", GREATER, "0.5.20120830CVS.el7"},
		{"20151212.1", GREATER, "1.el7"},
		{"20151212.1", GREATER, "1.el6"},
		{"20151212.1", GREATER, "10.el7"},
		{"20151212.1", GREATER, "01.el7"},
		{"20151212.1", GREATER, "0.17.20140318svn632.el7"},
		{"20151212.1", GREATER, "0.17.20140318svn633.el7"},
		{"20151212.1", GREATER, "1.20140522gitad6fb3e.el7"},
		{"20151212.1", GREATER, "1.20140522hitad6fb3e.el7"},
		{"20151212.1", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"20151212.1", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"20151212.1", GREATER, "22.svn457.el7"},
		{"20151212.1", GREATER, "22.svn458.el7"},
		{"20151212.1", GREATER, "~"},
		{"20151212.1", GREATER, "~~"},
		{"20151212.1", GREATER, "~1"},
		{"20151212.1", GREATER, "~a"},
		{"20151212.1", GREATER, "1~"},
		{"20151212.1", GREATER, "2~"},
		{"2015.1.1", GREATER, ""},
		{"2015.1.1", GREATER, "0"},
		{"2015.1.1", GREATER, "1"},
		{"2015.1.1", GREATER, "2"},
		{"2015.1.1", GREATER, "10"},
		{"2015.1.1", GREATER, "100"},
		{"2015.1.1", GREATER, "0.0"},
		{"2015.1.1", GREATER, "0.1"},
		{"2015.1.1", GREATER, "0.10"},
		{"2015.1.1", GREATER, "0.99"},
		{"2015.1.1", GREATER, "1.0"},
		{"2015.1.1", GREATER, "1.99"},
		{"2015.1.1", GREATER, "2.0"},
		{"2015.1.1", GREATER, "0.0.0"},
		{"2015.1.1", GREATER, "0.0.1"},
		{"2015.1.1", GREATER, "0.0.2"},
		{"2015.1.1", GREATER, "0.0.10"},
		{"2015.1.1", GREATER, "0.0.99"},
		{"2015.1.1", GREATER, "0.1.0"},
		{"2015.1.1", GREATER, "0.2.0"},
		{"2015.1.1", GREATER, "0.10.0"},
		{"2015.1.1", GREATER, "0.99.0"},
		{"2015.1.1", GREATER, "0.100.0"},
		{"2015.1.1", GREATER, "0.0.0.0"},
		{"2015.1.1", GREATER, "0.0.0.1"},
		{"2015.1.1", GREATER, "0.0.0.10"},
		{"2015.1.1", GREATER, "0.0.1.0"},
		{"2015.1.1", GREATER, "0.0.01.0"},
		{"2015.1.1", GREATER, "1.2.3.4"},
		{"2015.1.1", GREATER, "1-2-3-4"},
		{"2015.1.1", LESS, "20150101"},
		{"2015.1.1", LESS, "20151212"},
		{"2015.1.1", LESS, "20151212.0"},
		{"2015.1.1", LESS, "20151212.1"},
		{"2015.1.1", EQUAL, "2015.1.1"},
		{"2015.1.1", LESS, "2015.02.02"},
		{"2015.1.1", LESS, "2015.12.12"},
		{"2015.1.1", GREATER, "1.2.3a"},
		{"2015.1.1", GREATER, "1.2.3b"},
		{"2015.1.1", GREATER, "R16B"},
		{"2015.1.1", GREATER, "R16C"},
		{"2015.1.1", GREATER, "1.2.3.2016.1.1"},
		{"2015.1.1", GREATER, "0.5a1.dev"},
		{"2015.1.1", GREATER, "1.8.B59BrZX"},
		{"2015.1.1", GREATER, "0.07b4p1"},
		{"2015.1.1", GREATER, "3.99.5final.SP07"},
		{"2015.1.1", GREATER, "3.99.5final.SP08"},
		{"2015.1.1", GREATER, "0.4.tbb.20100203"},
		{"2015.1.1", GREATER, "0.5.20120830CVS.el7"},
		{"2015.1.1", GREATER, "1.el7"},
		{"2015.1.1", GREATER, "1.el6"},
		{"2015.1.1", GREATER, "10.el7"},
		{"2015.1.1", GREATER, "01.el7"},
		{"2015.1.1", GREATER, "0.17.20140318svn632.el7"},
		{"2015.1.1", GREATER, "0.17.20140318svn633.el7"},
		{"2015.1.1", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2015.1.1", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2015.1.1", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"2015.1.1", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"2015.1.1", GREATER, "22.svn457.el7"},
		{"2015.1.1", GREATER, "22.svn458.el7"},
		{"2015.1.1", GREATER, "~"},
		{"2015.1.1", GREATER, "~~"},
		{"2015.1.1", GREATER, "~1"},
		{"2015.1.1", GREATER, "~a"},
		{"2015.1.1", GREATER, "1~"},
		{"2015.1.1", GREATER, "2~"},
		{"2015.02.02", GREATER, ""},
		{"2015.02.02", GREATER, "0"},
		{"2015.02.02", GREATER, "1"},
		{"2015.02.02", GREATER, "2"},
		{"2015.02.02", GREATER, "10"},
		{"2015.02.02", GREATER, "100"},
		{"2015.02.02", GREATER, "0.0"},
		{"2015.02.02", GREATER, "0.1"},
		{"2015.02.02", GREATER, "0.10"},
		{"2015.02.02", GREATER, "0.99"},
		{"2015.02.02", GREATER, "1.0"},
		{"2015.02.02", GREATER, "1.99"},
		{"2015.02.02", GREATER, "2.0"},
		{"2015.02.02", GREATER, "0.0.0"},
		{"2015.02.02", GREATER, "0.0.1"},
		{"2015.02.02", GREATER, "0.0.2"},
		{"2015.02.02", GREATER, "0.0.10"},
		{"2015.02.02", GREATER, "0.0.99"},
		{"2015.02.02", GREATER, "0.1.0"},
		{"2015.02.02", GREATER, "0.2.0"},
		{"2015.02.02", GREATER, "0.10.0"},
		{"2015.02.02", GREATER, "0.99.0"},
		{"2015.02.02", GREATER, "0.100.0"},
		{"2015.02.02", GREATER, "0.0.0.0"},
		{"2015.02.02", GREATER, "0.0.0.1"},
		{"2015.02.02", GREATER, "0.0.0.10"},
		{"2015.02.02", GREATER, "0.0.1.0"},
		{"2015.02.02", GREATER, "0.0.01.0"},
		{"2015.02.02", GREATER, "1.2.3.4"},
		{"2015.02.02", GREATER, "1-2-3-4"},
		{"2015.02.02", LESS, "20150101"},
		{"2015.02.02", LESS, "20151212"},
		{"2015.02.02", LESS, "20151212.0"},
		{"2015.02.02", LESS, "20151212.1"},
		{"2015.02.02", GREATER, "2015.1.1"},
		{"2015.02.02", EQUAL, "2015.02.02"},
		{"2015.02.02", LESS, "2015.12.12"},
		{"2015.02.02", GREATER, "1.2.3a"},
		{"2015.02.02", GREATER, "1.2.3b"},
		{"2015.02.02", GREATER, "R16B"},
		{"2015.02.02", GREATER, "R16C"},
		{"2015.02.02", GREATER, "1.2.3.2016.1.1"},
		{"2015.02.02", GREATER, "0.5a1.dev"},
		{"2015.02.02", GREATER, "1.8.B59BrZX"},
		{"2015.02.02", GREATER, "0.07b4p1"},
		{"2015.02.02", GREATER, "3.99.5final.SP07"},
		{"2015.02.02", GREATER, "3.99.5final.SP08"},
		{"2015.02.02", GREATER, "0.4.tbb.20100203"},
		{"2015.02.02", GREATER, "0.5.20120830CVS.el7"},
		{"2015.02.02", GREATER, "1.el7"},
		{"2015.02.02", GREATER, "1.el6"},
		{"2015.02.02", GREATER, "10.el7"},
		{"2015.02.02", GREATER, "01.el7"},
		{"2015.02.02", GREATER, "0.17.20140318svn632.el7"},
		{"2015.02.02", GREATER, "0.17.20140318svn633.el7"},
		{"2015.02.02", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2015.02.02", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2015.02.02", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"2015.02.02", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"2015.02.02", GREATER, "22.svn457.el7"},
		{"2015.02.02", GREATER, "22.svn458.el7"},
		{"2015.02.02", GREATER, "~"},
		{"2015.02.02", GREATER, "~~"},
		{"2015.02.02", GREATER, "~1"},
		{"2015.02.02", GREATER, "~a"},
		{"2015.02.02", GREATER, "1~"},
		{"2015.02.02", GREATER, "2~"},
		{"2015.12.12", GREATER, ""},
		{"2015.12.12", GREATER, "0"},
		{"2015.12.12", GREATER, "1"},
		{"2015.12.12", GREATER, "2"},
		{"2015.12.12", GREATER, "10"},
		{"2015.12.12", GREATER, "100"},
		{"2015.12.12", GREATER, "0.0"},
		{"2015.12.12", GREATER, "0.1"},
		{"2015.12.12", GREATER, "0.10"},
		{"2015.12.12", GREATER, "0.99"},
		{"2015.12.12", GREATER, "1.0"},
		{"2015.12.12", GREATER, "1.99"},
		{"2015.12.12", GREATER, "2.0"},
		{"2015.12.12", GREATER, "0.0.0"},
		{"2015.12.12", GREATER, "0.0.1"},
		{"2015.12.12", GREATER, "0.0.2"},
		{"2015.12.12", GREATER, "0.0.10"},
		{"2015.12.12", GREATER, "0.0.99"},
		{"2015.12.12", GREATER, "0.1.0"},
		{"2015.12.12", GREATER, "0.2.0"},
		{"2015.12.12", GREATER, "0.10.0"},
		{"2015.12.12", GREATER, "0.99.0"},
		{"2015.12.12", GREATER, "0.100.0"},
		{"2015.12.12", GREATER, "0.0.0.0"},
		{"2015.12.12", GREATER, "0.0.0.1"},
		{"2015.12.12", GREATER, "0.0.0.10"},
		{"2015.12.12", GREATER, "0.0.1.0"},
		{"2015.12.12", GREATER, "0.0.01.0"},
		{"2015.12.12", GREATER, "1.2.3.4"},
		{"2015.12.12", GREATER, "1-2-3-4"},
		{"2015.12.12", LESS, "20150101"},
		{"2015.12.12", LESS, "20151212"},
		{"2015.12.12", LESS, "20151212.0"},
		{"2015.12.12", LESS, "20151212.1"},
		{"2015.12.12", GREATER, "2015.1.1"},
		{"2015.12.12", GREATER, "2015.02.02"},
		{"2015.12.12", EQUAL, "2015.12.12"},
		{"2015.12.12", GREATER, "1.2.3a"},
		{"2015.12.12", GREATER, "1.2.3b"},
		{"2015.12.12", GREATER, "R16B"},
		{"2015.12.12", GREATER, "R16C"},
		{"2015.12.12", GREATER, "1.2.3.2016.1.1"},
		{"2015.12.12", GREATER, "0.5a1.dev"},
		{"2015.12.12", GREATER, "1.8.B59BrZX"},
		{"2015.12.12", GREATER, "0.07b4p1"},
		{"2015.12.12", GREATER, "3.99.5final.SP07"},
		{"2015.12.12", GREATER, "3.99.5final.SP08"},
		{"2015.12.12", GREATER, "0.4.tbb.20100203"},
		{"2015.12.12", GREATER, "0.5.20120830CVS.el7"},
		{"2015.12.12", GREATER, "1.el7"},
		{"2015.12.12", GREATER, "1.el6"},
		{"2015.12.12", GREATER, "10.el7"},
		{"2015.12.12", GREATER, "01.el7"},
		{"2015.12.12", GREATER, "0.17.20140318svn632.el7"},
		{"2015.12.12", GREATER, "0.17.20140318svn633.el7"},
		{"2015.12.12", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2015.12.12", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2015.12.12", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"2015.12.12", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"2015.12.12", GREATER, "22.svn457.el7"},
		{"2015.12.12", GREATER, "22.svn458.el7"},
		{"2015.12.12", GREATER, "~"},
		{"2015.12.12", GREATER, "~~"},
		{"2015.12.12", GREATER, "~1"},
		{"2015.12.12", GREATER, "~a"},
		{"2015.12.12", GREATER, "1~"},
		{"2015.12.12", GREATER, "2~"},
		{"1.2.3a", GREATER, ""},
		{"1.2.3a", GREATER, "0"},
		{"1.2.3a", GREATER, "1"},
		{"1.2.3a", LESS, "2"},
		{"1.2.3a", LESS, "10"},
		{"1.2.3a", LESS, "100"},
		{"1.2.3a", GREATER, "0.0"},
		{"1.2.3a", GREATER, "0.1"},
		{"1.2.3a", GREATER, "0.10"},
		{"1.2.3a", GREATER, "0.99"},
		{"1.2.3a", GREATER, "1.0"},
		{"1.2.3a", LESS, "1.99"},
		{"1.2.3a", LESS, "2.0"},
		{"1.2.3a", GREATER, "0.0.0"},
		{"1.2.3a", GREATER, "0.0.1"},
		{"1.2.3a", GREATER, "0.0.2"},
		{"1.2.3a", GREATER, "0.0.10"},
		{"1.2.3a", GREATER, "0.0.99"},
		{"1.2.3a", GREATER, "0.1.0"},
		{"1.2.3a", GREATER, "0.2.0"},
		{"1.2.3a", GREATER, "0.10.0"},
		{"1.2.3a", GREATER, "0.99.0"},
		{"1.2.3a", GREATER, "0.100.0"},
		{"1.2.3a", GREATER, "0.0.0.0"},
		{"1.2.3a", GREATER, "0.0.0.1"},
		{"1.2.3a", GREATER, "0.0.0.10"},
		{"1.2.3a", GREATER, "0.0.1.0"},
		{"1.2.3a", GREATER, "0.0.01.0"},
		{"1.2.3a", LESS, "1.2.3.4"},
		{"1.2.3a", LESS, "1-2-3-4"},
		{"1.2.3a", LESS, "20150101"},
		{"1.2.3a", LESS, "20151212"},
		{"1.2.3a", LESS, "20151212.0"},
		{"1.2.3a", LESS, "20151212.1"},
		{"1.2.3a", LESS, "2015.1.1"},
		{"1.2.3a", LESS, "2015.02.02"},
		{"1.2.3a", LESS, "2015.12.12"},
		{"1.2.3a", EQUAL, "1.2.3a"},
		{"1.2.3a", LESS, "1.2.3b"},
		{"1.2.3a", GREATER, "R16B"},
		{"1.2.3a", GREATER, "R16C"},
		{"1.2.3a", LESS, "1.2.3.2016.1.1"},
		{"1.2.3a", GREATER, "0.5a1.dev"},
		{"1.2.3a", LESS, "1.8.B59BrZX"},
		{"1.2.3a", GREATER, "0.07b4p1"},
		{"1.2.3a", LESS, "3.99.5final.SP07"},
		{"1.2.3a", LESS, "3.99.5final.SP08"},
		{"1.2.3a", GREATER, "0.4.tbb.20100203"},
		{"1.2.3a", GREATER, "0.5.20120830CVS.el7"},
		{"1.2.3a", GREATER, "1.el7"},
		{"1.2.3a", GREATER, "1.el6"},
		{"1.2.3a", LESS, "10.el7"},
		{"1.2.3a", GREATER, "01.el7"},
		{"1.2.3a", GREATER, "0.17.20140318svn632.el7"},
		{"1.2.3a", GREATER, "0.17.20140318svn633.el7"},
		{"1.2.3a", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.2.3a", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.2.3a", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.2.3a", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.2.3a", LESS, "22.svn457.el7"},
		{"1.2.3a", LESS, "22.svn458.el7"},
		{"1.2.3a", GREATER, "~"},
		{"1.2.3a", GREATER, "~~"},
		{"1.2.3a", GREATER, "~1"},
		{"1.2.3a", GREATER, "~a"},
		{"1.2.3a", GREATER, "1~"},
		{"1.2.3a", LESS, "2~"},
		{"1.2.3b", GREATER, ""},
		{"1.2.3b", GREATER, "0"},
		{"1.2.3b", GREATER, "1"},
		{"1.2.3b", LESS, "2"},
		{"1.2.3b", LESS, "10"},
		{"1.2.3b", LESS, "100"},
		{"1.2.3b", GREATER, "0.0"},
		{"1.2.3b", GREATER, "0.1"},
		{"1.2.3b", GREATER, "0.10"},
		{"1.2.3b", GREATER, "0.99"},
		{"1.2.3b", GREATER, "1.0"},
		{"1.2.3b", LESS, "1.99"},
		{"1.2.3b", LESS, "2.0"},
		{"1.2.3b", GREATER, "0.0.0"},
		{"1.2.3b", GREATER, "0.0.1"},
		{"1.2.3b", GREATER, "0.0.2"},
		{"1.2.3b", GREATER, "0.0.10"},
		{"1.2.3b", GREATER, "0.0.99"},
		{"1.2.3b", GREATER, "0.1.0"},
		{"1.2.3b", GREATER, "0.2.0"},
		{"1.2.3b", GREATER, "0.10.0"},
		{"1.2.3b", GREATER, "0.99.0"},
		{"1.2.3b", GREATER, "0.100.0"},
		{"1.2.3b", GREATER, "0.0.0.0"},
		{"1.2.3b", GREATER, "0.0.0.1"},
		{"1.2.3b", GREATER, "0.0.0.10"},
		{"1.2.3b", GREATER, "0.0.1.0"},
		{"1.2.3b", GREATER, "0.0.01.0"},
		{"1.2.3b", LESS, "1.2.3.4"},
		{"1.2.3b", LESS, "1-2-3-4"},
		{"1.2.3b", LESS, "20150101"},
		{"1.2.3b", LESS, "20151212"},
		{"1.2.3b", LESS, "20151212.0"},
		{"1.2.3b", LESS, "20151212.1"},
		{"1.2.3b", LESS, "2015.1.1"},
		{"1.2.3b", LESS, "2015.02.02"},
		{"1.2.3b", LESS, "2015.12.12"},
		{"1.2.3b", GREATER, "1.2.3a"},
		{"1.2.3b", EQUAL, "1.2.3b"},
		{"1.2.3b", GREATER, "R16B"},
		{"1.2.3b", GREATER, "R16C"},
		{"1.2.3b", LESS, "1.2.3.2016.1.1"},
		{"1.2.3b", GREATER, "0.5a1.dev"},
		{"1.2.3b", LESS, "1.8.B59BrZX"},
		{"1.2.3b", GREATER, "0.07b4p1"},
		{"1.2.3b", LESS, "3.99.5final.SP07"},
		{"1.2.3b", LESS, "3.99.5final.SP08"},
		{"1.2.3b", GREATER, "0.4.tbb.20100203"},
		{"1.2.3b", GREATER, "0.5.20120830CVS.el7"},
		{"1.2.3b", GREATER, "1.el7"},
		{"1.2.3b", GREATER, "1.el6"},
		{"1.2.3b", LESS, "10.el7"},
		{"1.2.3b", GREATER, "01.el7"},
		{"1.2.3b", GREATER, "0.17.20140318svn632.el7"},
		{"1.2.3b", GREATER, "0.17.20140318svn633.el7"},
		{"1.2.3b", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.2.3b", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.2.3b", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.2.3b", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.2.3b", LESS, "22.svn457.el7"},
		{"1.2.3b", LESS, "22.svn458.el7"},
		{"1.2.3b", GREATER, "~"},
		{"1.2.3b", GREATER, "~~"},
		{"1.2.3b", GREATER, "~1"},
		{"1.2.3b", GREATER, "~a"},
		{"1.2.3b", GREATER, "1~"},
		{"1.2.3b", LESS, "2~"},
		{"R16B", GREATER, ""},
		{"R16B", LESS, "0"},
		{"R16B", LESS, "1"},
		{"R16B", LESS, "2"},
		{"R16B", LESS, "10"},
		{"R16B", LESS, "100"},
		{"R16B", LESS, "0.0"},
		{"R16B", LESS, "0.1"},
		{"R16B", LESS, "0.10"},
		{"R16B", LESS, "0.99"},
		{"R16B", LESS, "1.0"},
		{"R16B", LESS, "1.99"},
		{"R16B", LESS, "2.0"},
		{"R16B", LESS, "0.0.0"},
		{"R16B", LESS, "0.0.1"},
		{"R16B", LESS, "0.0.2"},
		{"R16B", LESS, "0.0.10"},
		{"R16B", LESS, "0.0.99"},
		{"R16B", LESS, "0.1.0"},
		{"R16B", LESS, "0.2.0"},
		{"R16B", LESS, "0.10.0"},
		{"R16B", LESS, "0.99.0"},
		{"R16B", LESS, "0.100.0"},
		{"R16B", LESS, "0.0.0.0"},
		{"R16B", LESS, "0.0.0.1"},
		{"R16B", LESS, "0.0.0.10"},
		{"R16B", LESS, "0.0.1.0"},
		{"R16B", LESS, "0.0.01.0"},
		{"R16B", LESS, "1.2.3.4"},
		{"R16B", LESS, "1-2-3-4"},
		{"R16B", LESS, "20150101"},
		{"R16B", LESS, "20151212"},
		{"R16B", LESS, "20151212.0"},
		{"R16B", LESS, "20151212.1"},
		{"R16B", LESS, "2015.1.1"},
		{"R16B", LESS, "2015.02.02"},
		{"R16B", LESS, "2015.12.12"},
		{"R16B", LESS, "1.2.3a"},
		{"R16B", LESS, "1.2.3b"},
		{"R16B", EQUAL, "R16B"},
		{"R16B", LESS, "R16C"},
		{"R16B", LESS, "1.2.3.2016.1.1"},
		{"R16B", LESS, "0.5a1.dev"},
		{"R16B", LESS, "1.8.B59BrZX"},
		{"R16B", LESS, "0.07b4p1"},
		{"R16B", LESS, "3.99.5final.SP07"},
		{"R16B", LESS, "3.99.5final.SP08"},
		{"R16B", LESS, "0.4.tbb.20100203"},
		{"R16B", LESS, "0.5.20120830CVS.el7"},
		{"R16B", LESS, "1.el7"},
		{"R16B", LESS, "1.el6"},
		{"R16B", LESS, "10.el7"},
		{"R16B", LESS, "01.el7"},
		{"R16B", LESS, "0.17.20140318svn632.el7"},
		{"R16B", LESS, "0.17.20140318svn633.el7"},
		{"R16B", LESS, "1.20140522gitad6fb3e.el7"},
		{"R16B", LESS, "1.20140522hitad6fb3e.el7"},
		{"R16B", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"R16B", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"R16B", LESS, "22.svn457.el7"},
		{"R16B", LESS, "22.svn458.el7"},
		{"R16B", GREATER, "~"},
		{"R16B", GREATER, "~~"},
		{"R16B", GREATER, "~1"},
		{"R16B", GREATER, "~a"},
		{"R16B", LESS, "1~"},
		{"R16B", LESS, "2~"},
		{"R16C", GREATER, ""},
		{"R16C", LESS, "0"},
		{"R16C", LESS, "1"},
		{"R16C", LESS, "2"},
		{"R16C", LESS, "10"},
		{"R16C", LESS, "100"},
		{"R16C", LESS, "0.0"},
		{"R16C", LESS, "0.1"},
		{"R16C", LESS, "0.10"},
		{"R16C", LESS, "0.99"},
		{"R16C", LESS, "1.0"},
		{"R16C", LESS, "1.99"},
		{"R16C", LESS, "2.0"},
		{"R16C", LESS, "0.0.0"},
		{"R16C", LESS, "0.0.1"},
		{"R16C", LESS, "0.0.2"},
		{"R16C", LESS, "0.0.10"},
		{"R16C", LESS, "0.0.99"},
		{"R16C", LESS, "0.1.0"},
		{"R16C", LESS, "0.2.0"},
		{"R16C", LESS, "0.10.0"},
		{"R16C", LESS, "0.99.0"},
		{"R16C", LESS, "0.100.0"},
		{"R16C", LESS, "0.0.0.0"},
		{"R16C", LESS, "0.0.0.1"},
		{"R16C", LESS, "0.0.0.10"},
		{"R16C", LESS, "0.0.1.0"},
		{"R16C", LESS, "0.0.01.0"},
		{"R16C", LESS, "1.2.3.4"},
		{"R16C", LESS, "1-2-3-4"},
		{"R16C", LESS, "20150101"},
		{"R16C", LESS, "20151212"},
		{"R16C", LESS, "20151212.0"},
		{"R16C", LESS, "20151212.1"},
		{"R16C", LESS, "2015.1.1"},
		{"R16C", LESS, "2015.02.02"},
		{"R16C", LESS, "2015.12.12"},
		{"R16C", LESS, "1.2.3a"},
		{"R16C", LESS, "1.2.3b"},
		{"R16C", GREATER, "R16B"},
		{"R16C", EQUAL, "R16C"},
		{"R16C", LESS, "1.2.3.2016.1.1"},
		{"R16C", LESS, "0.5a1.dev"},
		{"R16C", LESS, "1.8.B59BrZX"},
		{"R16C", LESS, "0.07b4p1"},
		{"R16C", LESS, "3.99.5final.SP07"},
		{"R16C", LESS, "3.99.5final.SP08"},
		{"R16C", LESS, "0.4.tbb.20100203"},
		{"R16C", LESS, "0.5.20120830CVS.el7"},
		{"R16C", LESS, "1.el7"},
		{"R16C", LESS, "1.el6"},
		{"R16C", LESS, "10.el7"},
		{"R16C", LESS, "01.el7"},
		{"R16C", LESS, "0.17.20140318svn632.el7"},
		{"R16C", LESS, "0.17.20140318svn633.el7"},
		{"R16C", LESS, "1.20140522gitad6fb3e.el7"},
		{"R16C", LESS, "1.20140522hitad6fb3e.el7"},
		{"R16C", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"R16C", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"R16C", LESS, "22.svn457.el7"},
		{"R16C", LESS, "22.svn458.el7"},
		{"R16C", GREATER, "~"},
		{"R16C", GREATER, "~~"},
		{"R16C", GREATER, "~1"},
		{"R16C", GREATER, "~a"},
		{"R16C", LESS, "1~"},
		{"R16C", LESS, "2~"},
		{"1.2.3.2016.1.1", GREATER, ""},
		{"1.2.3.2016.1.1", GREATER, "0"},
		{"1.2.3.2016.1.1", GREATER, "1"},
		{"1.2.3.2016.1.1", LESS, "2"},
		{"1.2.3.2016.1.1", LESS, "10"},
		{"1.2.3.2016.1.1", LESS, "100"},
		{"1.2.3.2016.1.1", GREATER, "0.0"},
		{"1.2.3.2016.1.1", GREATER, "0.1"},
		{"1.2.3.2016.1.1", GREATER, "0.10"},
		{"1.2.3.2016.1.1", GREATER, "0.99"},
		{"1.2.3.2016.1.1", GREATER, "1.0"},
		{"1.2.3.2016.1.1", LESS, "1.99"},
		{"1.2.3.2016.1.1", LESS, "2.0"},
		{"1.2.3.2016.1.1", GREATER, "0.0.0"},
		{"1.2.3.2016.1.1", GREATER, "0.0.1"},
		{"1.2.3.2016.1.1", GREATER, "0.0.2"},
		{"1.2.3.2016.1.1", GREATER, "0.0.10"},
		{"1.2.3.2016.1.1", GREATER, "0.0.99"},
		{"1.2.3.2016.1.1", GREATER, "0.1.0"},
		{"1.2.3.2016.1.1", GREATER, "0.2.0"},
		{"1.2.3.2016.1.1", GREATER, "0.10.0"},
		{"1.2.3.2016.1.1", GREATER, "0.99.0"},
		{"1.2.3.2016.1.1", GREATER, "0.100.0"},
		{"1.2.3.2016.1.1", GREATER, "0.0.0.0"},
		{"1.2.3.2016.1.1", GREATER, "0.0.0.1"},
		{"1.2.3.2016.1.1", GREATER, "0.0.0.10"},
		{"1.2.3.2016.1.1", GREATER, "0.0.1.0"},
		{"1.2.3.2016.1.1", GREATER, "0.0.01.0"},
		{"1.2.3.2016.1.1", GREATER, "1.2.3.4"},
		{"1.2.3.2016.1.1", GREATER, "1-2-3-4"},
		{"1.2.3.2016.1.1", LESS, "20150101"},
		{"1.2.3.2016.1.1", LESS, "20151212"},
		{"1.2.3.2016.1.1", LESS, "20151212.0"},
		{"1.2.3.2016.1.1", LESS, "20151212.1"},
		{"1.2.3.2016.1.1", LESS, "2015.1.1"},
		{"1.2.3.2016.1.1", LESS, "2015.02.02"},
		{"1.2.3.2016.1.1", LESS, "2015.12.12"},
		{"1.2.3.2016.1.1", GREATER, "1.2.3a"},
		{"1.2.3.2016.1.1", GREATER, "1.2.3b"},
		{"1.2.3.2016.1.1", GREATER, "R16B"},
		{"1.2.3.2016.1.1", GREATER, "R16C"},
		{"1.2.3.2016.1.1", EQUAL, "1.2.3.2016.1.1"},
		{"1.2.3.2016.1.1", GREATER, "0.5a1.dev"},
		{"1.2.3.2016.1.1", LESS, "1.8.B59BrZX"},
		{"1.2.3.2016.1.1", GREATER, "0.07b4p1"},
		{"1.2.3.2016.1.1", LESS, "3.99.5final.SP07"},
		{"1.2.3.2016.1.1", LESS, "3.99.5final.SP08"},
		{"1.2.3.2016.1.1", GREATER, "0.4.tbb.20100203"},
		{"1.2.3.2016.1.1", GREATER, "0.5.20120830CVS.el7"},
		{"1.2.3.2016.1.1", GREATER, "1.el7"},
		{"1.2.3.2016.1.1", GREATER, "1.el6"},
		{"1.2.3.2016.1.1", LESS, "10.el7"},
		{"1.2.3.2016.1.1", GREATER, "01.el7"},
		{"1.2.3.2016.1.1", GREATER, "0.17.20140318svn632.el7"},
		{"1.2.3.2016.1.1", GREATER, "0.17.20140318svn633.el7"},
		{"1.2.3.2016.1.1", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.2.3.2016.1.1", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.2.3.2016.1.1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.2.3.2016.1.1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.2.3.2016.1.1", LESS, "22.svn457.el7"},
		{"1.2.3.2016.1.1", LESS, "22.svn458.el7"},
		{"1.2.3.2016.1.1", GREATER, "~"},
		{"1.2.3.2016.1.1", GREATER, "~~"},
		{"1.2.3.2016.1.1", GREATER, "~1"},
		{"1.2.3.2016.1.1", GREATER, "~a"},
		{"1.2.3.2016.1.1", GREATER, "1~"},
		{"1.2.3.2016.1.1", LESS, "2~"},
		{"0.5a1.dev", GREATER, ""},
		{"0.5a1.dev", GREATER, "0"},
		{"0.5a1.dev", LESS, "1"},
		{"0.5a1.dev", LESS, "2"},
		{"0.5a1.dev", LESS, "10"},
		{"0.5a1.dev", LESS, "100"},
		{"0.5a1.dev", GREATER, "0.0"},
		{"0.5a1.dev", GREATER, "0.1"},
		{"0.5a1.dev", LESS, "0.10"},
		{"0.5a1.dev", LESS, "0.99"},
		{"0.5a1.dev", LESS, "1.0"},
		{"0.5a1.dev", LESS, "1.99"},
		{"0.5a1.dev", LESS, "2.0"},
		{"0.5a1.dev", GREATER, "0.0.0"},
		{"0.5a1.dev", GREATER, "0.0.1"},
		{"0.5a1.dev", GREATER, "0.0.2"},
		{"0.5a1.dev", GREATER, "0.0.10"},
		{"0.5a1.dev", GREATER, "0.0.99"},
		{"0.5a1.dev", GREATER, "0.1.0"},
		{"0.5a1.dev", GREATER, "0.2.0"},
		{"0.5a1.dev", LESS, "0.10.0"},
		{"0.5a1.dev", LESS, "0.99.0"},
		{"0.5a1.dev", LESS, "0.100.0"},
		{"0.5a1.dev", GREATER, "0.0.0.0"},
		{"0.5a1.dev", GREATER, "0.0.0.1"},
		{"0.5a1.dev", GREATER, "0.0.0.10"},
		{"0.5a1.dev", GREATER, "0.0.1.0"},
		{"0.5a1.dev", GREATER, "0.0.01.0"},
		{"0.5a1.dev", LESS, "1.2.3.4"},
		{"0.5a1.dev", LESS, "1-2-3-4"},
		{"0.5a1.dev", LESS, "20150101"},
		{"0.5a1.dev", LESS, "20151212"},
		{"0.5a1.dev", LESS, "20151212.0"},
		{"0.5a1.dev", LESS, "20151212.1"},
		{"0.5a1.dev", LESS, "2015.1.1"},
		{"0.5a1.dev", LESS, "2015.02.02"},
		{"0.5a1.dev", LESS, "2015.12.12"},
		{"0.5a1.dev", LESS, "1.2.3a"},
		{"0.5a1.dev", LESS, "1.2.3b"},
		{"0.5a1.dev", GREATER, "R16B"},
		{"0.5a1.dev", GREATER, "R16C"},
		{"0.5a1.dev", LESS, "1.2.3.2016.1.1"},
		{"0.5a1.dev", EQUAL, "0.5a1.dev"},
		{"0.5a1.dev", LESS, "1.8.B59BrZX"},
		{"0.5a1.dev", LESS, "0.07b4p1"},
		{"0.5a1.dev", LESS, "3.99.5final.SP07"},
		{"0.5a1.dev", LESS, "3.99.5final.SP08"},
		{"0.5a1.dev", GREATER, "0.4.tbb.20100203"},
		{"0.5a1.dev", LESS, "0.5.20120830CVS.el7"},
		{"0.5a1.dev", LESS, "1.el7"},
		{"0.5a1.dev", LESS, "1.el6"},
		{"0.5a1.dev", LESS, "10.el7"},
		{"0.5a1.dev", LESS, "01.el7"},
		{"0.5a1.dev", LESS, "0.17.20140318svn632.el7"},
		{"0.5a1.dev", LESS, "0.17.20140318svn633.el7"},
		{"0.5a1.dev", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.5a1.dev", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.5a1.dev", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.5a1.dev", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.5a1.dev", LESS, "22.svn457.el7"},
		{"0.5a1.dev", LESS, "22.svn458.el7"},
		{"0.5a1.dev", GREATER, "~"},
		{"0.5a1.dev", GREATER, "~~"},
		{"0.5a1.dev", GREATER, "~1"},
		{"0.5a1.dev", GREATER, "~a"},
		{"0.5a1.dev", LESS, "1~"},
		{"0.5a1.dev", LESS, "2~"},
		{"1.8.B59BrZX", GREATER, ""},
		{"1.8.B59BrZX", GREATER, "0"},
		{"1.8.B59BrZX", GREATER, "1"},
		{"1.8.B59BrZX", LESS, "2"},
		{"1.8.B59BrZX", LESS, "10"},
		{"1.8.B59BrZX", LESS, "100"},
		{"1.8.B59BrZX", GREATER, "0.0"},
		{"1.8.B59BrZX", GREATER, "0.1"},
		{"1.8.B59BrZX", GREATER, "0.10"},
		{"1.8.B59BrZX", GREATER, "0.99"},
		{"1.8.B59BrZX", GREATER, "1.0"},
		{"1.8.B59BrZX", LESS, "1.99"},
		{"1.8.B59BrZX", LESS, "2.0"},
		{"1.8.B59BrZX", GREATER, "0.0.0"},
		{"1.8.B59BrZX", GREATER, "0.0.1"},
		{"1.8.B59BrZX", GREATER, "0.0.2"},
		{"1.8.B59BrZX", GREATER, "0.0.10"},
		{"1.8.B59BrZX", GREATER, "0.0.99"},
		{"1.8.B59BrZX", GREATER, "0.1.0"},
		{"1.8.B59BrZX", GREATER, "0.2.0"},
		{"1.8.B59BrZX", GREATER, "0.10.0"},
		{"1.8.B59BrZX", GREATER, "0.99.0"},
		{"1.8.B59BrZX", GREATER, "0.100.0"},
		{"1.8.B59BrZX", GREATER, "0.0.0.0"},
		{"1.8.B59BrZX", GREATER, "0.0.0.1"},
		{"1.8.B59BrZX", GREATER, "0.0.0.10"},
		{"1.8.B59BrZX", GREATER, "0.0.1.0"},
		{"1.8.B59BrZX", GREATER, "0.0.01.0"},
		{"1.8.B59BrZX", GREATER, "1.2.3.4"},
		{"1.8.B59BrZX", GREATER, "1-2-3-4"},
		{"1.8.B59BrZX", LESS, "20150101"},
		{"1.8.B59BrZX", LESS, "20151212"},
		{"1.8.B59BrZX", LESS, "20151212.0"},
		{"1.8.B59BrZX", LESS, "20151212.1"},
		{"1.8.B59BrZX", LESS, "2015.1.1"},
		{"1.8.B59BrZX", LESS, "2015.02.02"},
		{"1.8.B59BrZX", LESS, "2015.12.12"},
		{"1.8.B59BrZX", GREATER, "1.2.3a"},
		{"1.8.B59BrZX", GREATER, "1.2.3b"},
		{"1.8.B59BrZX", GREATER, "R16B"},
		{"1.8.B59BrZX", GREATER, "R16C"},
		{"1.8.B59BrZX", GREATER, "1.2.3.2016.1.1"},
		{"1.8.B59BrZX", GREATER, "0.5a1.dev"},
		{"1.8.B59BrZX", EQUAL, "1.8.B59BrZX"},
		{"1.8.B59BrZX", GREATER, "0.07b4p1"},
		{"1.8.B59BrZX", LESS, "3.99.5final.SP07"},
		{"1.8.B59BrZX", LESS, "3.99.5final.SP08"},
		{"1.8.B59BrZX", GREATER, "0.4.tbb.20100203"},
		{"1.8.B59BrZX", GREATER, "0.5.20120830CVS.el7"},
		{"1.8.B59BrZX", GREATER, "1.el7"},
		{"1.8.B59BrZX", GREATER, "1.el6"},
		{"1.8.B59BrZX", LESS, "10.el7"},
		{"1.8.B59BrZX", GREATER, "01.el7"},
		{"1.8.B59BrZX", GREATER, "0.17.20140318svn632.el7"},
		{"1.8.B59BrZX", GREATER, "0.17.20140318svn633.el7"},
		{"1.8.B59BrZX", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.8.B59BrZX", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.8.B59BrZX", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.8.B59BrZX", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.8.B59BrZX", LESS, "22.svn457.el7"},
		{"1.8.B59BrZX", LESS, "22.svn458.el7"},
		{"1.8.B59BrZX", GREATER, "~"},
		{"1.8.B59BrZX", GREATER, "~~"},
		{"1.8.B59BrZX", GREATER, "~1"},
		{"1.8.B59BrZX", GREATER, "~a"},
		{"1.8.B59BrZX", GREATER, "1~"},
		{"1.8.B59BrZX", LESS, "2~"},
		{"0.07b4p1", GREATER, ""},
		{"0.07b4p1", GREATER, "0"},
		{"0.07b4p1", LESS, "1"},
		{"0.07b4p1", LESS, "2"},
		{"0.07b4p1", LESS, "10"},
		{"0.07b4p1", LESS, "100"},
		{"0.07b4p1", GREATER, "0.0"},
		{"0.07b4p1", GREATER, "0.1"},
		{"0.07b4p1", LESS, "0.10"},
		{"0.07b4p1", LESS, "0.99"},
		{"0.07b4p1", LESS, "1.0"},
		{"0.07b4p1", LESS, "1.99"},
		{"0.07b4p1", LESS, "2.0"},
		{"0.07b4p1", GREATER, "0.0.0"},
		{"0.07b4p1", GREATER, "0.0.1"},
		{"0.07b4p1", GREATER, "0.0.2"},
		{"0.07b4p1", GREATER, "0.0.10"},
		{"0.07b4p1", GREATER, "0.0.99"},
		{"0.07b4p1", GREATER, "0.1.0"},
		{"0.07b4p1", GREATER, "0.2.0"},
		{"0.07b4p1", LESS, "0.10.0"},
		{"0.07b4p1", LESS, "0.99.0"},
		{"0.07b4p1", LESS, "0.100.0"},
		{"0.07b4p1", GREATER, "0.0.0.0"},
		{"0.07b4p1", GREATER, "0.0.0.1"},
		{"0.07b4p1", GREATER, "0.0.0.10"},
		{"0.07b4p1", GREATER, "0.0.1.0"},
		{"0.07b4p1", GREATER, "0.0.01.0"},
		{"0.07b4p1", LESS, "1.2.3.4"},
		{"0.07b4p1", LESS, "1-2-3-4"},
		{"0.07b4p1", LESS, "20150101"},
		{"0.07b4p1", LESS, "20151212"},
		{"0.07b4p1", LESS, "20151212.0"},
		{"0.07b4p1", LESS, "20151212.1"},
		{"0.07b4p1", LESS, "2015.1.1"},
		{"0.07b4p1", LESS, "2015.02.02"},
		{"0.07b4p1", LESS, "2015.12.12"},
		{"0.07b4p1", LESS, "1.2.3a"},
		{"0.07b4p1", LESS, "1.2.3b"},
		{"0.07b4p1", GREATER, "R16B"},
		{"0.07b4p1", GREATER, "R16C"},
		{"0.07b4p1", LESS, "1.2.3.2016.1.1"},
		{"0.07b4p1", GREATER, "0.5a1.dev"},
		{"0.07b4p1", LESS, "1.8.B59BrZX"},
		{"0.07b4p1", EQUAL, "0.07b4p1"},
		{"0.07b4p1", LESS, "3.99.5final.SP07"},
		{"0.07b4p1", LESS, "3.99.5final.SP08"},
		{"0.07b4p1", GREATER, "0.4.tbb.20100203"},
		{"0.07b4p1", GREATER, "0.5.20120830CVS.el7"},
		{"0.07b4p1", LESS, "1.el7"},
		{"0.07b4p1", LESS, "1.el6"},
		{"0.07b4p1", LESS, "10.el7"},
		{"0.07b4p1", LESS, "01.el7"},
		{"0.07b4p1", LESS, "0.17.20140318svn632.el7"},
		{"0.07b4p1", LESS, "0.17.20140318svn633.el7"},
		{"0.07b4p1", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.07b4p1", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.07b4p1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.07b4p1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.07b4p1", LESS, "22.svn457.el7"},
		{"0.07b4p1", LESS, "22.svn458.el7"},
		{"0.07b4p1", GREATER, "~"},
		{"0.07b4p1", GREATER, "~~"},
		{"0.07b4p1", GREATER, "~1"},
		{"0.07b4p1", GREATER, "~a"},
		{"0.07b4p1", LESS, "1~"},
		{"0.07b4p1", LESS, "2~"},
		{"3.99.5final.SP07", GREATER, ""},
		{"3.99.5final.SP07", GREATER, "0"},
		{"3.99.5final.SP07", GREATER, "1"},
		{"3.99.5final.SP07", GREATER, "2"},
		{"3.99.5final.SP07", LESS, "10"},
		{"3.99.5final.SP07", LESS, "100"},
		{"3.99.5final.SP07", GREATER, "0.0"},
		{"3.99.5final.SP07", GREATER, "0.1"},
		{"3.99.5final.SP07", GREATER, "0.10"},
		{"3.99.5final.SP07", GREATER, "0.99"},
		{"3.99.5final.SP07", GREATER, "1.0"},
		{"3.99.5final.SP07", GREATER, "1.99"},
		{"3.99.5final.SP07", GREATER, "2.0"},
		{"3.99.5final.SP07", GREATER, "0.0.0"},
		{"3.99.5final.SP07", GREATER, "0.0.1"},
		{"3.99.5final.SP07", GREATER, "0.0.2"},
		{"3.99.5final.SP07", GREATER, "0.0.10"},
		{"3.99.5final.SP07", GREATER, "0.0.99"},
		{"3.99.5final.SP07", GREATER, "0.1.0"},
		{"3.99.5final.SP07", GREATER, "0.2.0"},
		{"3.99.5final.SP07", GREATER, "0.10.0"},
		{"3.99.5final.SP07", GREATER, "0.99.0"},
		{"3.99.5final.SP07", GREATER, "0.100.0"},
		{"3.99.5final.SP07", GREATER, "0.0.0.0"},
		{"3.99.5final.SP07", GREATER, "0.0.0.1"},
		{"3.99.5final.SP07", GREATER, "0.0.0.10"},
		{"3.99.5final.SP07", GREATER, "0.0.1.0"},
		{"3.99.5final.SP07", GREATER, "0.0.01.0"},
		{"3.99.5final.SP07", GREATER, "1.2.3.4"},
		{"3.99.5final.SP07", GREATER, "1-2-3-4"},
		{"3.99.5final.SP07", LESS, "20150101"},
		{"3.99.5final.SP07", LESS, "20151212"},
		{"3.99.5final.SP07", LESS, "20151212.0"},
		{"3.99.5final.SP07", LESS, "20151212.1"},
		{"3.99.5final.SP07", LESS, "2015.1.1"},
		{"3.99.5final.SP07", LESS, "2015.02.02"},
		{"3.99.5final.SP07", LESS, "2015.12.12"},
		{"3.99.5final.SP07", GREATER, "1.2.3a"},
		{"3.99.5final.SP07", GREATER, "1.2.3b"},
		{"3.99.5final.SP07", GREATER, "R16B"},
		{"3.99.5final.SP07", GREATER, "R16C"},
		{"3.99.5final.SP07", GREATER, "1.2.3.2016.1.1"},
		{"3.99.5final.SP07", GREATER, "0.5a1.dev"},
		{"3.99.5final.SP07", GREATER, "1.8.B59BrZX"},
		{"3.99.5final.SP07", GREATER, "0.07b4p1"},
		{"3.99.5final.SP07", EQUAL, "3.99.5final.SP07"},
		{"3.99.5final.SP07", LESS, "3.99.5final.SP08"},
		{"3.99.5final.SP07", GREATER, "0.4.tbb.20100203"},
		{"3.99.5final.SP07", GREATER, "0.5.20120830CVS.el7"},
		{"3.99.5final.SP07", GREATER, "1.el7"},
		{"3.99.5final.SP07", GREATER, "1.el6"},
		{"3.99.5final.SP07", LESS, "10.el7"},
		{"3.99.5final.SP07", GREATER, "01.el7"},
		{"3.99.5final.SP07", GREATER, "0.17.20140318svn632.el7"},
		{"3.99.5final.SP07", GREATER, "0.17.20140318svn633.el7"},
		{"3.99.5final.SP07", GREATER, "1.20140522gitad6fb3e.el7"},
		{"3.99.5final.SP07", GREATER, "1.20140522hitad6fb3e.el7"},
		{"3.99.5final.SP07", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"3.99.5final.SP07", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"3.99.5final.SP07", LESS, "22.svn457.el7"},
		{"3.99.5final.SP07", LESS, "22.svn458.el7"},
		{"3.99.5final.SP07", GREATER, "~"},
		{"3.99.5final.SP07", GREATER, "~~"},
		{"3.99.5final.SP07", GREATER, "~1"},
		{"3.99.5final.SP07", GREATER, "~a"},
		{"3.99.5final.SP07", GREATER, "1~"},
		{"3.99.5final.SP07", GREATER, "2~"},
		{"3.99.5final.SP08", GREATER, ""},
		{"3.99.5final.SP08", GREATER, "0"},
		{"3.99.5final.SP08", GREATER, "1"},
		{"3.99.5final.SP08", GREATER, "2"},
		{"3.99.5final.SP08", LESS, "10"},
		{"3.99.5final.SP08", LESS, "100"},
		{"3.99.5final.SP08", GREATER, "0.0"},
		{"3.99.5final.SP08", GREATER, "0.1"},
		{"3.99.5final.SP08", GREATER, "0.10"},
		{"3.99.5final.SP08", GREATER, "0.99"},
		{"3.99.5final.SP08", GREATER, "1.0"},
		{"3.99.5final.SP08", GREATER, "1.99"},
		{"3.99.5final.SP08", GREATER, "2.0"},
		{"3.99.5final.SP08", GREATER, "0.0.0"},
		{"3.99.5final.SP08", GREATER, "0.0.1"},
		{"3.99.5final.SP08", GREATER, "0.0.2"},
		{"3.99.5final.SP08", GREATER, "0.0.10"},
		{"3.99.5final.SP08", GREATER, "0.0.99"},
		{"3.99.5final.SP08", GREATER, "0.1.0"},
		{"3.99.5final.SP08", GREATER, "0.2.0"},
		{"3.99.5final.SP08", GREATER, "0.10.0"},
		{"3.99.5final.SP08", GREATER, "0.99.0"},
		{"3.99.5final.SP08", GREATER, "0.100.0"},
		{"3.99.5final.SP08", GREATER, "0.0.0.0"},
		{"3.99.5final.SP08", GREATER, "0.0.0.1"},
		{"3.99.5final.SP08", GREATER, "0.0.0.10"},
		{"3.99.5final.SP08", GREATER, "0.0.1.0"},
		{"3.99.5final.SP08", GREATER, "0.0.01.0"},
		{"3.99.5final.SP08", GREATER, "1.2.3.4"},
		{"3.99.5final.SP08", GREATER, "1-2-3-4"},
		{"3.99.5final.SP08", LESS, "20150101"},
		{"3.99.5final.SP08", LESS, "20151212"},
		{"3.99.5final.SP08", LESS, "20151212.0"},
		{"3.99.5final.SP08", LESS, "20151212.1"},
		{"3.99.5final.SP08", LESS, "2015.1.1"},
		{"3.99.5final.SP08", LESS, "2015.02.02"},
		{"3.99.5final.SP08", LESS, "2015.12.12"},
		{"3.99.5final.SP08", GREATER, "1.2.3a"},
		{"3.99.5final.SP08", GREATER, "1.2.3b"},
		{"3.99.5final.SP08", GREATER, "R16B"},
		{"3.99.5final.SP08", GREATER, "R16C"},
		{"3.99.5final.SP08", GREATER, "1.2.3.2016.1.1"},
		{"3.99.5final.SP08", GREATER, "0.5a1.dev"},
		{"3.99.5final.SP08", GREATER, "1.8.B59BrZX"},
		{"3.99.5final.SP08", GREATER, "0.07b4p1"},
		{"3.99.5final.SP08", GREATER, "3.99.5final.SP07"},
		{"3.99.5final.SP08", EQUAL, "3.99.5final.SP08"},
		{"3.99.5final.SP08", GREATER, "0.4.tbb.20100203"},
		{"3.99.5final.SP08", GREATER, "0.5.20120830CVS.el7"},
		{"3.99.5final.SP08", GREATER, "1.el7"},
		{"3.99.5final.SP08", GREATER, "1.el6"},
		{"3.99.5final.SP08", LESS, "10.el7"},
		{"3.99.5final.SP08", GREATER, "01.el7"},
		{"3.99.5final.SP08", GREATER, "0.17.20140318svn632.el7"},
		{"3.99.5final.SP08", GREATER, "0.17.20140318svn633.el7"},
		{"3.99.5final.SP08", GREATER, "1.20140522gitad6fb3e.el7"},
		{"3.99.5final.SP08", GREATER, "1.20140522hitad6fb3e.el7"},
		{"3.99.5final.SP08", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"3.99.5final.SP08", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"3.99.5final.SP08", LESS, "22.svn457.el7"},
		{"3.99.5final.SP08", LESS, "22.svn458.el7"},
		{"3.99.5final.SP08", GREATER, "~"},
		{"3.99.5final.SP08", GREATER, "~~"},
		{"3.99.5final.SP08", GREATER, "~1"},
		{"3.99.5final.SP08", GREATER, "~a"},
		{"3.99.5final.SP08", GREATER, "1~"},
		{"3.99.5final.SP08", GREATER, "2~"},
		{"0.4.tbb.20100203", GREATER, ""},
		{"0.4.tbb.20100203", GREATER, "0"},
		{"0.4.tbb.20100203", LESS, "1"},
		{"0.4.tbb.20100203", LESS, "2"},
		{"0.4.tbb.20100203", LESS, "10"},
		{"0.4.tbb.20100203", LESS, "100"},
		{"0.4.tbb.20100203", GREATER, "0.0"},
		{"0.4.tbb.20100203", GREATER, "0.1"},
		{"0.4.tbb.20100203", LESS, "0.10"},
		{"0.4.tbb.20100203", LESS, "0.99"},
		{"0.4.tbb.20100203", LESS, "1.0"},
		{"0.4.tbb.20100203", LESS, "1.99"},
		{"0.4.tbb.20100203", LESS, "2.0"},
		{"0.4.tbb.20100203", GREATER, "0.0.0"},
		{"0.4.tbb.20100203", GREATER, "0.0.1"},
		{"0.4.tbb.20100203", GREATER, "0.0.2"},
		{"0.4.tbb.20100203", GREATER, "0.0.10"},
		{"0.4.tbb.20100203", GREATER, "0.0.99"},
		{"0.4.tbb.20100203", GREATER, "0.1.0"},
		{"0.4.tbb.20100203", GREATER, "0.2.0"},
		{"0.4.tbb.20100203", LESS, "0.10.0"},
		{"0.4.tbb.20100203", LESS, "0.99.0"},
		{"0.4.tbb.20100203", LESS, "0.100.0"},
		{"0.4.tbb.20100203", GREATER, "0.0.0.0"},
		{"0.4.tbb.20100203", GREATER, "0.0.0.1"},
		{"0.4.tbb.20100203", GREATER, "0.0.0.10"},
		{"0.4.tbb.20100203", GREATER, "0.0.1.0"},
		{"0.4.tbb.20100203", GREATER, "0.0.01.0"},
		{"0.4.tbb.20100203", LESS, "1.2.3.4"},
		{"0.4.tbb.20100203", LESS, "1-2-3-4"},
		{"0.4.tbb.20100203", LESS, "20150101"},
		{"0.4.tbb.20100203", LESS, "20151212"},
		{"0.4.tbb.20100203", LESS, "20151212.0"},
		{"0.4.tbb.20100203", LESS, "20151212.1"},
		{"0.4.tbb.20100203", LESS, "2015.1.1"},
		{"0.4.tbb.20100203", LESS, "2015.02.02"},
		{"0.4.tbb.20100203", LESS, "2015.12.12"},
		{"0.4.tbb.20100203", LESS, "1.2.3a"},
		{"0.4.tbb.20100203", LESS, "1.2.3b"},
		{"0.4.tbb.20100203", GREATER, "R16B"},
		{"0.4.tbb.20100203", GREATER, "R16C"},
		{"0.4.tbb.20100203", LESS, "1.2.3.2016.1.1"},
		{"0.4.tbb.20100203", LESS, "0.5a1.dev"},
		{"0.4.tbb.20100203", LESS, "1.8.B59BrZX"},
		{"0.4.tbb.20100203", LESS, "0.07b4p1"},
		{"0.4.tbb.20100203", LESS, "3.99.5final.SP07"},
		{"0.4.tbb.20100203", LESS, "3.99.5final.SP08"},
		{"0.4.tbb.20100203", EQUAL, "0.4.tbb.20100203"},
		{"0.4.tbb.20100203", LESS, "0.5.20120830CVS.el7"},
		{"0.4.tbb.20100203", LESS, "1.el7"},
		{"0.4.tbb.20100203", LESS, "1.el6"},
		{"0.4.tbb.20100203", LESS, "10.el7"},
		{"0.4.tbb.20100203", LESS, "01.el7"},
		{"0.4.tbb.20100203", LESS, "0.17.20140318svn632.el7"},
		{"0.4.tbb.20100203", LESS, "0.17.20140318svn633.el7"},
		{"0.4.tbb.20100203", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.4.tbb.20100203", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.4.tbb.20100203", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.4.tbb.20100203", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.4.tbb.20100203", LESS, "22.svn457.el7"},
		{"0.4.tbb.20100203", LESS, "22.svn458.el7"},
		{"0.4.tbb.20100203", GREATER, "~"},
		{"0.4.tbb.20100203", GREATER, "~~"},
		{"0.4.tbb.20100203", GREATER, "~1"},
		{"0.4.tbb.20100203", GREATER, "~a"},
		{"0.4.tbb.20100203", LESS, "1~"},
		{"0.4.tbb.20100203", LESS, "2~"},
		{"0.5.20120830CVS.el7", GREATER, ""},
		{"0.5.20120830CVS.el7", GREATER, "0"},
		{"0.5.20120830CVS.el7", LESS, "1"},
		{"0.5.20120830CVS.el7", LESS, "2"},
		{"0.5.20120830CVS.el7", LESS, "10"},
		{"0.5.20120830CVS.el7", LESS, "100"},
		{"0.5.20120830CVS.el7", GREATER, "0.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.1"},
		{"0.5.20120830CVS.el7", LESS, "0.10"},
		{"0.5.20120830CVS.el7", LESS, "0.99"},
		{"0.5.20120830CVS.el7", LESS, "1.0"},
		{"0.5.20120830CVS.el7", LESS, "1.99"},
		{"0.5.20120830CVS.el7", LESS, "2.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.1"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.2"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.10"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.99"},
		{"0.5.20120830CVS.el7", GREATER, "0.1.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.2.0"},
		{"0.5.20120830CVS.el7", LESS, "0.10.0"},
		{"0.5.20120830CVS.el7", LESS, "0.99.0"},
		{"0.5.20120830CVS.el7", LESS, "0.100.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.0.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.0.1"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.0.10"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.1.0"},
		{"0.5.20120830CVS.el7", GREATER, "0.0.01.0"},
		{"0.5.20120830CVS.el7", LESS, "1.2.3.4"},
		{"0.5.20120830CVS.el7", LESS, "1-2-3-4"},
		{"0.5.20120830CVS.el7", LESS, "20150101"},
		{"0.5.20120830CVS.el7", LESS, "20151212"},
		{"0.5.20120830CVS.el7", LESS, "20151212.0"},
		{"0.5.20120830CVS.el7", LESS, "20151212.1"},
		{"0.5.20120830CVS.el7", LESS, "2015.1.1"},
		{"0.5.20120830CVS.el7", LESS, "2015.02.02"},
		{"0.5.20120830CVS.el7", LESS, "2015.12.12"},
		{"0.5.20120830CVS.el7", LESS, "1.2.3a"},
		{"0.5.20120830CVS.el7", LESS, "1.2.3b"},
		{"0.5.20120830CVS.el7", GREATER, "R16B"},
		{"0.5.20120830CVS.el7", GREATER, "R16C"},
		{"0.5.20120830CVS.el7", LESS, "1.2.3.2016.1.1"},
		{"0.5.20120830CVS.el7", GREATER, "0.5a1.dev"},
		{"0.5.20120830CVS.el7", LESS, "1.8.B59BrZX"},
		{"0.5.20120830CVS.el7", LESS, "0.07b4p1"},
		{"0.5.20120830CVS.el7", LESS, "3.99.5final.SP07"},
		{"0.5.20120830CVS.el7", LESS, "3.99.5final.SP08"},
		{"0.5.20120830CVS.el7", GREATER, "0.4.tbb.20100203"},
		{"0.5.20120830CVS.el7", EQUAL, "0.5.20120830CVS.el7"},
		{"0.5.20120830CVS.el7", LESS, "1.el7"},
		{"0.5.20120830CVS.el7", LESS, "1.el6"},
		{"0.5.20120830CVS.el7", LESS, "10.el7"},
		{"0.5.20120830CVS.el7", LESS, "01.el7"},
		{"0.5.20120830CVS.el7", LESS, "0.17.20140318svn632.el7"},
		{"0.5.20120830CVS.el7", LESS, "0.17.20140318svn633.el7"},
		{"0.5.20120830CVS.el7", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.5.20120830CVS.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.5.20120830CVS.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.5.20120830CVS.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.5.20120830CVS.el7", LESS, "22.svn457.el7"},
		{"0.5.20120830CVS.el7", LESS, "22.svn458.el7"},
		{"0.5.20120830CVS.el7", GREATER, "~"},
		{"0.5.20120830CVS.el7", GREATER, "~~"},
		{"0.5.20120830CVS.el7", GREATER, "~1"},
		{"0.5.20120830CVS.el7", GREATER, "~a"},
		{"0.5.20120830CVS.el7", LESS, "1~"},
		{"0.5.20120830CVS.el7", LESS, "2~"},
		{"1.el7", GREATER, ""},
		{"1.el7", GREATER, "0"},
		{"1.el7", GREATER, "1"},
		{"1.el7", LESS, "2"},
		{"1.el7", LESS, "10"},
		{"1.el7", LESS, "100"},
		{"1.el7", GREATER, "0.0"},
		{"1.el7", GREATER, "0.1"},
		{"1.el7", GREATER, "0.10"},
		{"1.el7", GREATER, "0.99"},
		{"1.el7", LESS, "1.0"},
		{"1.el7", LESS, "1.99"},
		{"1.el7", LESS, "2.0"},
		{"1.el7", GREATER, "0.0.0"},
		{"1.el7", GREATER, "0.0.1"},
		{"1.el7", GREATER, "0.0.2"},
		{"1.el7", GREATER, "0.0.10"},
		{"1.el7", GREATER, "0.0.99"},
		{"1.el7", GREATER, "0.1.0"},
		{"1.el7", GREATER, "0.2.0"},
		{"1.el7", GREATER, "0.10.0"},
		{"1.el7", GREATER, "0.99.0"},
		{"1.el7", GREATER, "0.100.0"},
		{"1.el7", GREATER, "0.0.0.0"},
		{"1.el7", GREATER, "0.0.0.1"},
		{"1.el7", GREATER, "0.0.0.10"},
		{"1.el7", GREATER, "0.0.1.0"},
		{"1.el7", GREATER, "0.0.01.0"},
		{"1.el7", LESS, "1.2.3.4"},
		{"1.el7", LESS, "1-2-3-4"},
		{"1.el7", LESS, "20150101"},
		{"1.el7", LESS, "20151212"},
		{"1.el7", LESS, "20151212.0"},
		{"1.el7", LESS, "20151212.1"},
		{"1.el7", LESS, "2015.1.1"},
		{"1.el7", LESS, "2015.02.02"},
		{"1.el7", LESS, "2015.12.12"},
		{"1.el7", LESS, "1.2.3a"},
		{"1.el7", LESS, "1.2.3b"},
		{"1.el7", GREATER, "R16B"},
		{"1.el7", GREATER, "R16C"},
		{"1.el7", LESS, "1.2.3.2016.1.1"},
		{"1.el7", GREATER, "0.5a1.dev"},
		{"1.el7", LESS, "1.8.B59BrZX"},
		{"1.el7", GREATER, "0.07b4p1"},
		{"1.el7", LESS, "3.99.5final.SP07"},
		{"1.el7", LESS, "3.99.5final.SP08"},
		{"1.el7", GREATER, "0.4.tbb.20100203"},
		{"1.el7", GREATER, "0.5.20120830CVS.el7"},
		{"1.el7", EQUAL, "1.el7"},
		{"1.el7", GREATER, "1.el6"},
		{"1.el7", LESS, "10.el7"},
		{"1.el7", EQUAL, "01.el7"},
		{"1.el7", GREATER, "0.17.20140318svn632.el7"},
		{"1.el7", GREATER, "0.17.20140318svn633.el7"},
		{"1.el7", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.el7", LESS, "22.svn457.el7"},
		{"1.el7", LESS, "22.svn458.el7"},
		{"1.el7", GREATER, "~"},
		{"1.el7", GREATER, "~~"},
		{"1.el7", GREATER, "~1"},
		{"1.el7", GREATER, "~a"},
		{"1.el7", GREATER, "1~"},
		{"1.el7", LESS, "2~"},
		{"1.el6", GREATER, ""},
		{"1.el6", GREATER, "0"},
		{"1.el6", GREATER, "1"},
		{"1.el6", LESS, "2"},
		{"1.el6", LESS, "10"},
		{"1.el6", LESS, "100"},
		{"1.el6", GREATER, "0.0"},
		{"1.el6", GREATER, "0.1"},
		{"1.el6", GREATER, "0.10"},
		{"1.el6", GREATER, "0.99"},
		{"1.el6", LESS, "1.0"},
		{"1.el6", LESS, "1.99"},
		{"1.el6", LESS, "2.0"},
		{"1.el6", GREATER, "0.0.0"},
		{"1.el6", GREATER, "0.0.1"},
		{"1.el6", GREATER, "0.0.2"},
		{"1.el6", GREATER, "0.0.10"},
		{"1.el6", GREATER, "0.0.99"},
		{"1.el6", GREATER, "0.1.0"},
		{"1.el6", GREATER, "0.2.0"},
		{"1.el6", GREATER, "0.10.0"},
		{"1.el6", GREATER, "0.99.0"},
		{"1.el6", GREATER, "0.100.0"},
		{"1.el6", GREATER, "0.0.0.0"},
		{"1.el6", GREATER, "0.0.0.1"},
		{"1.el6", GREATER, "0.0.0.10"},
		{"1.el6", GREATER, "0.0.1.0"},
		{"1.el6", GREATER, "0.0.01.0"},
		{"1.el6", LESS, "1.2.3.4"},
		{"1.el6", LESS, "1-2-3-4"},
		{"1.el6", LESS, "20150101"},
		{"1.el6", LESS, "20151212"},
		{"1.el6", LESS, "20151212.0"},
		{"1.el6", LESS, "20151212.1"},
		{"1.el6", LESS, "2015.1.1"},
		{"1.el6", LESS, "2015.02.02"},
		{"1.el6", LESS, "2015.12.12"},
		{"1.el6", LESS, "1.2.3a"},
		{"1.el6", LESS, "1.2.3b"},
		{"1.el6", GREATER, "R16B"},
		{"1.el6", GREATER, "R16C"},
		{"1.el6", LESS, "1.2.3.2016.1.1"},
		{"1.el6", GREATER, "0.5a1.dev"},
		{"1.el6", LESS, "1.8.B59BrZX"},
		{"1.el6", GREATER, "0.07b4p1"},
		{"1.el6", LESS, "3.99.5final.SP07"},
		{"1.el6", LESS, "3.99.5final.SP08"},
		{"1.el6", GREATER, "0.4.tbb.20100203"},
		{"1.el6", GREATER, "0.5.20120830CVS.el7"},
		{"1.el6", LESS, "1.el7"},
		{"1.el6", EQUAL, "1.el6"},
		{"1.el6", LESS, "10.el7"},
		{"1.el6", LESS, "01.el7"},
		{"1.el6", GREATER, "0.17.20140318svn632.el7"},
		{"1.el6", GREATER, "0.17.20140318svn633.el7"},
		{"1.el6", LESS, "1.20140522gitad6fb3e.el7"},
		{"1.el6", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.el6", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.el6", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.el6", LESS, "22.svn457.el7"},
		{"1.el6", LESS, "22.svn458.el7"},
		{"1.el6", GREATER, "~"},
		{"1.el6", GREATER, "~~"},
		{"1.el6", GREATER, "~1"},
		{"1.el6", GREATER, "~a"},
		{"1.el6", GREATER, "1~"},
		{"1.el6", LESS, "2~"},
		{"10.el7", GREATER, ""},
		{"10.el7", GREATER, "0"},
		{"10.el7", GREATER, "1"},
		{"10.el7", GREATER, "2"},
		{"10.el7", GREATER, "10"},
		{"10.el7", LESS, "100"},
		{"10.el7", GREATER, "0.0"},
		{"10.el7", GREATER, "0.1"},
		{"10.el7", GREATER, "0.10"},
		{"10.el7", GREATER, "0.99"},
		{"10.el7", GREATER, "1.0"},
		{"10.el7", GREATER, "1.99"},
		{"10.el7", GREATER, "2.0"},
		{"10.el7", GREATER, "0.0.0"},
		{"10.el7", GREATER, "0.0.1"},
		{"10.el7", GREATER, "0.0.2"},
		{"10.el7", GREATER, "0.0.10"},
		{"10.el7", GREATER, "0.0.99"},
		{"10.el7", GREATER, "0.1.0"},
		{"10.el7", GREATER, "0.2.0"},
		{"10.el7", GREATER, "0.10.0"},
		{"10.el7", GREATER, "0.99.0"},
		{"10.el7", GREATER, "0.100.0"},
		{"10.el7", GREATER, "0.0.0.0"},
		{"10.el7", GREATER, "0.0.0.1"},
		{"10.el7", GREATER, "0.0.0.10"},
		{"10.el7", GREATER, "0.0.1.0"},
		{"10.el7", GREATER, "0.0.01.0"},
		{"10.el7", GREATER, "1.2.3.4"},
		{"10.el7", GREATER, "1-2-3-4"},
		{"10.el7", LESS, "20150101"},
		{"10.el7", LESS, "20151212"},
		{"10.el7", LESS, "20151212.0"},
		{"10.el7", LESS, "20151212.1"},
		{"10.el7", LESS, "2015.1.1"},
		{"10.el7", LESS, "2015.02.02"},
		{"10.el7", LESS, "2015.12.12"},
		{"10.el7", GREATER, "1.2.3a"},
		{"10.el7", GREATER, "1.2.3b"},
		{"10.el7", GREATER, "R16B"},
		{"10.el7", GREATER, "R16C"},
		{"10.el7", GREATER, "1.2.3.2016.1.1"},
		{"10.el7", GREATER, "0.5a1.dev"},
		{"10.el7", GREATER, "1.8.B59BrZX"},
		{"10.el7", GREATER, "0.07b4p1"},
		{"10.el7", GREATER, "3.99.5final.SP07"},
		{"10.el7", GREATER, "3.99.5final.SP08"},
		{"10.el7", GREATER, "0.4.tbb.20100203"},
		{"10.el7", GREATER, "0.5.20120830CVS.el7"},
		{"10.el7", GREATER, "1.el7"},
		{"10.el7", GREATER, "1.el6"},
		{"10.el7", EQUAL, "10.el7"},
		{"10.el7", GREATER, "01.el7"},
		{"10.el7", GREATER, "0.17.20140318svn632.el7"},
		{"10.el7", GREATER, "0.17.20140318svn633.el7"},
		{"10.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"10.el7", GREATER, "1.20140522hitad6fb3e.el7"},
		{"10.el7", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"10.el7", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"10.el7", LESS, "22.svn457.el7"},
		{"10.el7", LESS, "22.svn458.el7"},
		{"10.el7", GREATER, "~"},
		{"10.el7", GREATER, "~~"},
		{"10.el7", GREATER, "~1"},
		{"10.el7", GREATER, "~a"},
		{"10.el7", GREATER, "1~"},
		{"10.el7", GREATER, "2~"},
		{"01.el7", GREATER, ""},
		{"01.el7", GREATER, "0"},
		{"01.el7", GREATER, "1"},
		{"01.el7", LESS, "2"},
		{"01.el7", LESS, "10"},
		{"01.el7", LESS, "100"},
		{"01.el7", GREATER, "0.0"},
		{"01.el7", GREATER, "0.1"},
		{"01.el7", GREATER, "0.10"},
		{"01.el7", GREATER, "0.99"},
		{"01.el7", LESS, "1.0"},
		{"01.el7", LESS, "1.99"},
		{"01.el7", LESS, "2.0"},
		{"01.el7", GREATER, "0.0.0"},
		{"01.el7", GREATER, "0.0.1"},
		{"01.el7", GREATER, "0.0.2"},
		{"01.el7", GREATER, "0.0.10"},
		{"01.el7", GREATER, "0.0.99"},
		{"01.el7", GREATER, "0.1.0"},
		{"01.el7", GREATER, "0.2.0"},
		{"01.el7", GREATER, "0.10.0"},
		{"01.el7", GREATER, "0.99.0"},
		{"01.el7", GREATER, "0.100.0"},
		{"01.el7", GREATER, "0.0.0.0"},
		{"01.el7", GREATER, "0.0.0.1"},
		{"01.el7", GREATER, "0.0.0.10"},
		{"01.el7", GREATER, "0.0.1.0"},
		{"01.el7", GREATER, "0.0.01.0"},
		{"01.el7", LESS, "1.2.3.4"},
		{"01.el7", LESS, "1-2-3-4"},
		{"01.el7", LESS, "20150101"},
		{"01.el7", LESS, "20151212"},
		{"01.el7", LESS, "20151212.0"},
		{"01.el7", LESS, "20151212.1"},
		{"01.el7", LESS, "2015.1.1"},
		{"01.el7", LESS, "2015.02.02"},
		{"01.el7", LESS, "2015.12.12"},
		{"01.el7", LESS, "1.2.3a"},
		{"01.el7", LESS, "1.2.3b"},
		{"01.el7", GREATER, "R16B"},
		{"01.el7", GREATER, "R16C"},
		{"01.el7", LESS, "1.2.3.2016.1.1"},
		{"01.el7", GREATER, "0.5a1.dev"},
		{"01.el7", LESS, "1.8.B59BrZX"},
		{"01.el7", GREATER, "0.07b4p1"},
		{"01.el7", LESS, "3.99.5final.SP07"},
		{"01.el7", LESS, "3.99.5final.SP08"},
		{"01.el7", GREATER, "0.4.tbb.20100203"},
		{"01.el7", GREATER, "0.5.20120830CVS.el7"},
		{"01.el7", EQUAL, "1.el7"},
		{"01.el7", GREATER, "1.el6"},
		{"01.el7", LESS, "10.el7"},
		{"01.el7", EQUAL, "01.el7"},
		{"01.el7", GREATER, "0.17.20140318svn632.el7"},
		{"01.el7", GREATER, "0.17.20140318svn633.el7"},
		{"01.el7", LESS, "1.20140522gitad6fb3e.el7"},
		{"01.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"01.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"01.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"01.el7", LESS, "22.svn457.el7"},
		{"01.el7", LESS, "22.svn458.el7"},
		{"01.el7", GREATER, "~"},
		{"01.el7", GREATER, "~~"},
		{"01.el7", GREATER, "~1"},
		{"01.el7", GREATER, "~a"},
		{"01.el7", GREATER, "1~"},
		{"01.el7", LESS, "2~"},
		{"0.17.20140318svn632.el7", GREATER, ""},
		{"0.17.20140318svn632.el7", GREATER, "0"},
		{"0.17.20140318svn632.el7", LESS, "1"},
		{"0.17.20140318svn632.el7", LESS, "2"},
		{"0.17.20140318svn632.el7", LESS, "10"},
		{"0.17.20140318svn632.el7", LESS, "100"},
		{"0.17.20140318svn632.el7", GREATER, "0.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.1"},
		{"0.17.20140318svn632.el7", GREATER, "0.10"},
		{"0.17.20140318svn632.el7", LESS, "0.99"},
		{"0.17.20140318svn632.el7", LESS, "1.0"},
		{"0.17.20140318svn632.el7", LESS, "1.99"},
		{"0.17.20140318svn632.el7", LESS, "2.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.1"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.2"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.10"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.99"},
		{"0.17.20140318svn632.el7", GREATER, "0.1.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.2.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.10.0"},
		{"0.17.20140318svn632.el7", LESS, "0.99.0"},
		{"0.17.20140318svn632.el7", LESS, "0.100.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.0.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.0.1"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.0.10"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.1.0"},
		{"0.17.20140318svn632.el7", GREATER, "0.0.01.0"},
		{"0.17.20140318svn632.el7", LESS, "1.2.3.4"},
		{"0.17.20140318svn632.el7", LESS, "1-2-3-4"},
		{"0.17.20140318svn632.el7", LESS, "20150101"},
		{"0.17.20140318svn632.el7", LESS, "20151212"},
		{"0.17.20140318svn632.el7", LESS, "20151212.0"},
		{"0.17.20140318svn632.el7", LESS, "20151212.1"},
		{"0.17.20140318svn632.el7", LESS, "2015.1.1"},
		{"0.17.20140318svn632.el7", LESS, "2015.02.02"},
		{"0.17.20140318svn632.el7", LESS, "2015.12.12"},
		{"0.17.20140318svn632.el7", LESS, "1.2.3a"},
		{"0.17.20140318svn632.el7", LESS, "1.2.3b"},
		{"0.17.20140318svn632.el7", GREATER, "R16B"},
		{"0.17.20140318svn632.el7", GREATER, "R16C"},
		{"0.17.20140318svn632.el7", LESS, "1.2.3.2016.1.1"},
		{"0.17.20140318svn632.el7", GREATER, "0.5a1.dev"},
		{"0.17.20140318svn632.el7", LESS, "1.8.B59BrZX"},
		{"0.17.20140318svn632.el7", GREATER, "0.07b4p1"},
		{"0.17.20140318svn632.el7", LESS, "3.99.5final.SP07"},
		{"0.17.20140318svn632.el7", LESS, "3.99.5final.SP08"},
		{"0.17.20140318svn632.el7", GREATER, "0.4.tbb.20100203"},
		{"0.17.20140318svn632.el7", GREATER, "0.5.20120830CVS.el7"},
		{"0.17.20140318svn632.el7", LESS, "1.el7"},
		{"0.17.20140318svn632.el7", LESS, "1.el6"},
		{"0.17.20140318svn632.el7", LESS, "10.el7"},
		{"0.17.20140318svn632.el7", LESS, "01.el7"},
		{"0.17.20140318svn632.el7", EQUAL, "0.17.20140318svn632.el7"},
		{"0.17.20140318svn632.el7", LESS, "0.17.20140318svn633.el7"},
		{"0.17.20140318svn632.el7", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.17.20140318svn632.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.17.20140318svn632.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.17.20140318svn632.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.17.20140318svn632.el7", LESS, "22.svn457.el7"},
		{"0.17.20140318svn632.el7", LESS, "22.svn458.el7"},
		{"0.17.20140318svn632.el7", GREATER, "~"},
		{"0.17.20140318svn632.el7", GREATER, "~~"},
		{"0.17.20140318svn632.el7", GREATER, "~1"},
		{"0.17.20140318svn632.el7", GREATER, "~a"},
		{"0.17.20140318svn632.el7", LESS, "1~"},
		{"0.17.20140318svn632.el7", LESS, "2~"},
		{"0.17.20140318svn633.el7", GREATER, ""},
		{"0.17.20140318svn633.el7", GREATER, "0"},
		{"0.17.20140318svn633.el7", LESS, "1"},
		{"0.17.20140318svn633.el7", LESS, "2"},
		{"0.17.20140318svn633.el7", LESS, "10"},
		{"0.17.20140318svn633.el7", LESS, "100"},
		{"0.17.20140318svn633.el7", GREATER, "0.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.1"},
		{"0.17.20140318svn633.el7", GREATER, "0.10"},
		{"0.17.20140318svn633.el7", LESS, "0.99"},
		{"0.17.20140318svn633.el7", LESS, "1.0"},
		{"0.17.20140318svn633.el7", LESS, "1.99"},
		{"0.17.20140318svn633.el7", LESS, "2.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.1"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.2"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.10"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.99"},
		{"0.17.20140318svn633.el7", GREATER, "0.1.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.2.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.10.0"},
		{"0.17.20140318svn633.el7", LESS, "0.99.0"},
		{"0.17.20140318svn633.el7", LESS, "0.100.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.0.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.0.1"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.0.10"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.1.0"},
		{"0.17.20140318svn633.el7", GREATER, "0.0.01.0"},
		{"0.17.20140318svn633.el7", LESS, "1.2.3.4"},
		{"0.17.20140318svn633.el7", LESS, "1-2-3-4"},
		{"0.17.20140318svn633.el7", LESS, "20150101"},
		{"0.17.20140318svn633.el7", LESS, "20151212"},
		{"0.17.20140318svn633.el7", LESS, "20151212.0"},
		{"0.17.20140318svn633.el7", LESS, "20151212.1"},
		{"0.17.20140318svn633.el7", LESS, "2015.1.1"},
		{"0.17.20140318svn633.el7", LESS, "2015.02.02"},
		{"0.17.20140318svn633.el7", LESS, "2015.12.12"},
		{"0.17.20140318svn633.el7", LESS, "1.2.3a"},
		{"0.17.20140318svn633.el7", LESS, "1.2.3b"},
		{"0.17.20140318svn633.el7", GREATER, "R16B"},
		{"0.17.20140318svn633.el7", GREATER, "R16C"},
		{"0.17.20140318svn633.el7", LESS, "1.2.3.2016.1.1"},
		{"0.17.20140318svn633.el7", GREATER, "0.5a1.dev"},
		{"0.17.20140318svn633.el7", LESS, "1.8.B59BrZX"},
		{"0.17.20140318svn633.el7", GREATER, "0.07b4p1"},
		{"0.17.20140318svn633.el7", LESS, "3.99.5final.SP07"},
		{"0.17.20140318svn633.el7", LESS, "3.99.5final.SP08"},
		{"0.17.20140318svn633.el7", GREATER, "0.4.tbb.20100203"},
		{"0.17.20140318svn633.el7", GREATER, "0.5.20120830CVS.el7"},
		{"0.17.20140318svn633.el7", LESS, "1.el7"},
		{"0.17.20140318svn633.el7", LESS, "1.el6"},
		{"0.17.20140318svn633.el7", LESS, "10.el7"},
		{"0.17.20140318svn633.el7", LESS, "01.el7"},
		{"0.17.20140318svn633.el7", GREATER, "0.17.20140318svn632.el7"},
		{"0.17.20140318svn633.el7", EQUAL, "0.17.20140318svn633.el7"},
		{"0.17.20140318svn633.el7", LESS, "1.20140522gitad6fb3e.el7"},
		{"0.17.20140318svn633.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"0.17.20140318svn633.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"0.17.20140318svn633.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"0.17.20140318svn633.el7", LESS, "22.svn457.el7"},
		{"0.17.20140318svn633.el7", LESS, "22.svn458.el7"},
		{"0.17.20140318svn633.el7", GREATER, "~"},
		{"0.17.20140318svn633.el7", GREATER, "~~"},
		{"0.17.20140318svn633.el7", GREATER, "~1"},
		{"0.17.20140318svn633.el7", GREATER, "~a"},
		{"0.17.20140318svn633.el7", LESS, "1~"},
		{"0.17.20140318svn633.el7", LESS, "2~"},
		{"1.20140522gitad6fb3e.el7", GREATER, ""},
		{"1.20140522gitad6fb3e.el7", GREATER, "0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1"},
		{"1.20140522gitad6fb3e.el7", LESS, "2"},
		{"1.20140522gitad6fb3e.el7", LESS, "10"},
		{"1.20140522gitad6fb3e.el7", LESS, "100"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.1"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.10"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.99"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.99"},
		{"1.20140522gitad6fb3e.el7", LESS, "2.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.1"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.2"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.10"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.99"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.1.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.2.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.10.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.99.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.100.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.0.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.0.1"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.0.10"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.1.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.0.01.0"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.2.3.4"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1-2-3-4"},
		{"1.20140522gitad6fb3e.el7", LESS, "20150101"},
		{"1.20140522gitad6fb3e.el7", LESS, "20151212"},
		{"1.20140522gitad6fb3e.el7", LESS, "20151212.0"},
		{"1.20140522gitad6fb3e.el7", LESS, "20151212.1"},
		{"1.20140522gitad6fb3e.el7", LESS, "2015.1.1"},
		{"1.20140522gitad6fb3e.el7", LESS, "2015.02.02"},
		{"1.20140522gitad6fb3e.el7", LESS, "2015.12.12"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.2.3a"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.2.3b"},
		{"1.20140522gitad6fb3e.el7", GREATER, "R16B"},
		{"1.20140522gitad6fb3e.el7", GREATER, "R16C"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.2.3.2016.1.1"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.5a1.dev"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.8.B59BrZX"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.07b4p1"},
		{"1.20140522gitad6fb3e.el7", LESS, "3.99.5final.SP07"},
		{"1.20140522gitad6fb3e.el7", LESS, "3.99.5final.SP08"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.4.tbb.20100203"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.5.20120830CVS.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1.el6"},
		{"1.20140522gitad6fb3e.el7", LESS, "10.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "01.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.17.20140318svn632.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "0.17.20140318svn633.el7"},
		{"1.20140522gitad6fb3e.el7", EQUAL, "1.20140522gitad6fb3e.el7"},
		{"1.20140522gitad6fb3e.el7", LESS, "1.20140522hitad6fb3e.el7"},
		{"1.20140522gitad6fb3e.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.20140522gitad6fb3e.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.20140522gitad6fb3e.el7", LESS, "22.svn457.el7"},
		{"1.20140522gitad6fb3e.el7", LESS, "22.svn458.el7"},
		{"1.20140522gitad6fb3e.el7", GREATER, "~"},
		{"1.20140522gitad6fb3e.el7", GREATER, "~~"},
		{"1.20140522gitad6fb3e.el7", GREATER, "~1"},
		{"1.20140522gitad6fb3e.el7", GREATER, "~a"},
		{"1.20140522gitad6fb3e.el7", GREATER, "1~"},
		{"1.20140522gitad6fb3e.el7", LESS, "2~"},
		{"1.20140522hitad6fb3e.el7", GREATER, ""},
		{"1.20140522hitad6fb3e.el7", GREATER, "0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1"},
		{"1.20140522hitad6fb3e.el7", LESS, "2"},
		{"1.20140522hitad6fb3e.el7", LESS, "10"},
		{"1.20140522hitad6fb3e.el7", LESS, "100"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.1"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.10"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.99"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.99"},
		{"1.20140522hitad6fb3e.el7", LESS, "2.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.1"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.2"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.10"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.99"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.1.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.2.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.10.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.99.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.100.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.0.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.0.1"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.0.10"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.1.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.0.01.0"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.2.3.4"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1-2-3-4"},
		{"1.20140522hitad6fb3e.el7", LESS, "20150101"},
		{"1.20140522hitad6fb3e.el7", LESS, "20151212"},
		{"1.20140522hitad6fb3e.el7", LESS, "20151212.0"},
		{"1.20140522hitad6fb3e.el7", LESS, "20151212.1"},
		{"1.20140522hitad6fb3e.el7", LESS, "2015.1.1"},
		{"1.20140522hitad6fb3e.el7", LESS, "2015.02.02"},
		{"1.20140522hitad6fb3e.el7", LESS, "2015.12.12"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.2.3a"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.2.3b"},
		{"1.20140522hitad6fb3e.el7", GREATER, "R16B"},
		{"1.20140522hitad6fb3e.el7", GREATER, "R16C"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.2.3.2016.1.1"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.5a1.dev"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.8.B59BrZX"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.07b4p1"},
		{"1.20140522hitad6fb3e.el7", LESS, "3.99.5final.SP07"},
		{"1.20140522hitad6fb3e.el7", LESS, "3.99.5final.SP08"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.4.tbb.20100203"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.5.20120830CVS.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.el6"},
		{"1.20140522hitad6fb3e.el7", LESS, "10.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "01.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.17.20140318svn632.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "0.17.20140318svn633.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"1.20140522hitad6fb3e.el7", EQUAL, "1.20140522hitad6fb3e.el7"},
		{"1.20140522hitad6fb3e.el7", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1.20140522hitad6fb3e.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1.20140522hitad6fb3e.el7", LESS, "22.svn457.el7"},
		{"1.20140522hitad6fb3e.el7", LESS, "22.svn458.el7"},
		{"1.20140522hitad6fb3e.el7", GREATER, "~"},
		{"1.20140522hitad6fb3e.el7", GREATER, "~~"},
		{"1.20140522hitad6fb3e.el7", GREATER, "~1"},
		{"1.20140522hitad6fb3e.el7", GREATER, "~a"},
		{"1.20140522hitad6fb3e.el7", GREATER, "1~"},
		{"1.20140522hitad6fb3e.el7", LESS, "2~"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, ""},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "2"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "10"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "100"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.10"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.99"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.99"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "2.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.2"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.10"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.99"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.1.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.2.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.10.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.99.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.100.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.0.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.0.1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.0.10"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.1.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.0.01.0"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.2.3.4"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1-2-3-4"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "20150101"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "20151212"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "20151212.0"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "20151212.1"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "2015.1.1"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "2015.02.02"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "2015.12.12"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.2.3a"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.2.3b"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "R16B"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "R16C"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.2.3.2016.1.1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.5a1.dev"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.8.B59BrZX"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.07b4p1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "3.99.5final.SP07"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "3.99.5final.SP08"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.4.tbb.20100203"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.5.20120830CVS.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.el6"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "10.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "01.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.17.20140318svn632.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "0.17.20140318svn633.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1.20140522hitad6fb3e.el7"},
		{"8.20140605hgacf1c26e3019.el7", EQUAL, "8.20140605hgacf1c26e3019.el7"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "22.svn457.el7"},
		{"8.20140605hgacf1c26e3019.el7", LESS, "22.svn458.el7"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "~"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "~~"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "~1"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "~a"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "1~"},
		{"8.20140605hgacf1c26e3019.el7", GREATER, "2~"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, ""},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "2"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "10"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "100"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.10"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.99"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.99"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "2.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.2"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.10"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.99"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.1.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.2.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.10.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.99.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.100.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.0.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.0.1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.0.10"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.1.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.0.01.0"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.2.3.4"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1-2-3-4"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "20150101"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "20151212"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "20151212.0"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "20151212.1"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "2015.1.1"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "2015.02.02"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "2015.12.12"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.2.3a"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.2.3b"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "R16B"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "R16C"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.2.3.2016.1.1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.5a1.dev"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.8.B59BrZX"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.07b4p1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "3.99.5final.SP07"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "3.99.5final.SP08"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.4.tbb.20100203"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.5.20120830CVS.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.el6"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "10.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "01.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.17.20140318svn632.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "0.17.20140318svn633.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1.20140522hitad6fb3e.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"8.20140605hgacf1c26e3029.el7", EQUAL, "8.20140605hgacf1c26e3029.el7"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "22.svn457.el7"},
		{"8.20140605hgacf1c26e3029.el7", LESS, "22.svn458.el7"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "~"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "~~"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "~1"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "~a"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "1~"},
		{"8.20140605hgacf1c26e3029.el7", GREATER, "2~"},
		{"22.svn457.el7", GREATER, ""},
		{"22.svn457.el7", GREATER, "0"},
		{"22.svn457.el7", GREATER, "1"},
		{"22.svn457.el7", GREATER, "2"},
		{"22.svn457.el7", GREATER, "10"},
		{"22.svn457.el7", LESS, "100"},
		{"22.svn457.el7", GREATER, "0.0"},
		{"22.svn457.el7", GREATER, "0.1"},
		{"22.svn457.el7", GREATER, "0.10"},
		{"22.svn457.el7", GREATER, "0.99"},
		{"22.svn457.el7", GREATER, "1.0"},
		{"22.svn457.el7", GREATER, "1.99"},
		{"22.svn457.el7", GREATER, "2.0"},
		{"22.svn457.el7", GREATER, "0.0.0"},
		{"22.svn457.el7", GREATER, "0.0.1"},
		{"22.svn457.el7", GREATER, "0.0.2"},
		{"22.svn457.el7", GREATER, "0.0.10"},
		{"22.svn457.el7", GREATER, "0.0.99"},
		{"22.svn457.el7", GREATER, "0.1.0"},
		{"22.svn457.el7", GREATER, "0.2.0"},
		{"22.svn457.el7", GREATER, "0.10.0"},
		{"22.svn457.el7", GREATER, "0.99.0"},
		{"22.svn457.el7", GREATER, "0.100.0"},
		{"22.svn457.el7", GREATER, "0.0.0.0"},
		{"22.svn457.el7", GREATER, "0.0.0.1"},
		{"22.svn457.el7", GREATER, "0.0.0.10"},
		{"22.svn457.el7", GREATER, "0.0.1.0"},
		{"22.svn457.el7", GREATER, "0.0.01.0"},
		{"22.svn457.el7", GREATER, "1.2.3.4"},
		{"22.svn457.el7", GREATER, "1-2-3-4"},
		{"22.svn457.el7", LESS, "20150101"},
		{"22.svn457.el7", LESS, "20151212"},
		{"22.svn457.el7", LESS, "20151212.0"},
		{"22.svn457.el7", LESS, "20151212.1"},
		{"22.svn457.el7", LESS, "2015.1.1"},
		{"22.svn457.el7", LESS, "2015.02.02"},
		{"22.svn457.el7", LESS, "2015.12.12"},
		{"22.svn457.el7", GREATER, "1.2.3a"},
		{"22.svn457.el7", GREATER, "1.2.3b"},
		{"22.svn457.el7", GREATER, "R16B"},
		{"22.svn457.el7", GREATER, "R16C"},
		{"22.svn457.el7", GREATER, "1.2.3.2016.1.1"},
		{"22.svn457.el7", GREATER, "0.5a1.dev"},
		{"22.svn457.el7", GREATER, "1.8.B59BrZX"},
		{"22.svn457.el7", GREATER, "0.07b4p1"},
		{"22.svn457.el7", GREATER, "3.99.5final.SP07"},
		{"22.svn457.el7", GREATER, "3.99.5final.SP08"},
		{"22.svn457.el7", GREATER, "0.4.tbb.20100203"},
		{"22.svn457.el7", GREATER, "0.5.20120830CVS.el7"},
		{"22.svn457.el7", GREATER, "1.el7"},
		{"22.svn457.el7", GREATER, "1.el6"},
		{"22.svn457.el7", GREATER, "10.el7"},
		{"22.svn457.el7", GREATER, "01.el7"},
		{"22.svn457.el7", GREATER, "0.17.20140318svn632.el7"},
		{"22.svn457.el7", GREATER, "0.17.20140318svn633.el7"},
		{"22.svn457.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"22.svn457.el7", GREATER, "1.20140522hitad6fb3e.el7"},
		{"22.svn457.el7", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"22.svn457.el7", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"22.svn457.el7", EQUAL, "22.svn457.el7"},
		{"22.svn457.el7", LESS, "22.svn458.el7"},
		{"22.svn457.el7", GREATER, "~"},
		{"22.svn457.el7", GREATER, "~~"},
		{"22.svn457.el7", GREATER, "~1"},
		{"22.svn457.el7", GREATER, "~a"},
		{"22.svn457.el7", GREATER, "1~"},
		{"22.svn457.el7", GREATER, "2~"},
		{"22.svn458.el7", GREATER, ""},
		{"22.svn458.el7", GREATER, "0"},
		{"22.svn458.el7", GREATER, "1"},
		{"22.svn458.el7", GREATER, "2"},
		{"22.svn458.el7", GREATER, "10"},
		{"22.svn458.el7", LESS, "100"},
		{"22.svn458.el7", GREATER, "0.0"},
		{"22.svn458.el7", GREATER, "0.1"},
		{"22.svn458.el7", GREATER, "0.10"},
		{"22.svn458.el7", GREATER, "0.99"},
		{"22.svn458.el7", GREATER, "1.0"},
		{"22.svn458.el7", GREATER, "1.99"},
		{"22.svn458.el7", GREATER, "2.0"},
		{"22.svn458.el7", GREATER, "0.0.0"},
		{"22.svn458.el7", GREATER, "0.0.1"},
		{"22.svn458.el7", GREATER, "0.0.2"},
		{"22.svn458.el7", GREATER, "0.0.10"},
		{"22.svn458.el7", GREATER, "0.0.99"},
		{"22.svn458.el7", GREATER, "0.1.0"},
		{"22.svn458.el7", GREATER, "0.2.0"},
		{"22.svn458.el7", GREATER, "0.10.0"},
		{"22.svn458.el7", GREATER, "0.99.0"},
		{"22.svn458.el7", GREATER, "0.100.0"},
		{"22.svn458.el7", GREATER, "0.0.0.0"},
		{"22.svn458.el7", GREATER, "0.0.0.1"},
		{"22.svn458.el7", GREATER, "0.0.0.10"},
		{"22.svn458.el7", GREATER, "0.0.1.0"},
		{"22.svn458.el7", GREATER, "0.0.01.0"},
		{"22.svn458.el7", GREATER, "1.2.3.4"},
		{"22.svn458.el7", GREATER, "1-2-3-4"},
		{"22.svn458.el7", LESS, "20150101"},
		{"22.svn458.el7", LESS, "20151212"},
		{"22.svn458.el7", LESS, "20151212.0"},
		{"22.svn458.el7", LESS, "20151212.1"},
		{"22.svn458.el7", LESS, "2015.1.1"},
		{"22.svn458.el7", LESS, "2015.02.02"},
		{"22.svn458.el7", LESS, "2015.12.12"},
		{"22.svn458.el7", GREATER, "1.2.3a"},
		{"22.svn458.el7", GREATER, "1.2.3b"},
		{"22.svn458.el7", GREATER, "R16B"},
		{"22.svn458.el7", GREATER, "R16C"},
		{"22.svn458.el7", GREATER, "1.2.3.2016.1.1"},
		{"22.svn458.el7", GREATER, "0.5a1.dev"},
		{"22.svn458.el7", GREATER, "1.8.B59BrZX"},
		{"22.svn458.el7", GREATER, "0.07b4p1"},
		{"22.svn458.el7", GREATER, "3.99.5final.SP07"},
		{"22.svn458.el7", GREATER, "3.99.5final.SP08"},
		{"22.svn458.el7", GREATER, "0.4.tbb.20100203"},
		{"22.svn458.el7", GREATER, "0.5.20120830CVS.el7"},
		{"22.svn458.el7", GREATER, "1.el7"},
		{"22.svn458.el7", GREATER, "1.el6"},
		{"22.svn458.el7", GREATER, "10.el7"},
		{"22.svn458.el7", GREATER, "01.el7"},
		{"22.svn458.el7", GREATER, "0.17.20140318svn632.el7"},
		{"22.svn458.el7", GREATER, "0.17.20140318svn633.el7"},
		{"22.svn458.el7", GREATER, "1.20140522gitad6fb3e.el7"},
		{"22.svn458.el7", GREATER, "1.20140522hitad6fb3e.el7"},
		{"22.svn458.el7", GREATER, "8.20140605hgacf1c26e3019.el7"},
		{"22.svn458.el7", GREATER, "8.20140605hgacf1c26e3029.el7"},
		{"22.svn458.el7", GREATER, "22.svn457.el7"},
		{"22.svn458.el7", EQUAL, "22.svn458.el7"},
		{"22.svn458.el7", GREATER, "~"},
		{"22.svn458.el7", GREATER, "~~"},
		{"22.svn458.el7", GREATER, "~1"},
		{"22.svn458.el7", GREATER, "~a"},
		{"22.svn458.el7", GREATER, "1~"},
		{"22.svn458.el7", GREATER, "2~"},
		{"~", LESS, ""},
		{"~", LESS, "0"},
		{"~", LESS, "1"},
		{"~", LESS, "2"},
		{"~", LESS, "10"},
		{"~", LESS, "100"},
		{"~", LESS, "0.0"},
		{"~", LESS, "0.1"},
		{"~", LESS, "0.10"},
		{"~", LESS, "0.99"},
		{"~", LESS, "1.0"},
		{"~", LESS, "1.99"},
		{"~", LESS, "2.0"},
		{"~", LESS, "0.0.0"},
		{"~", LESS, "0.0.1"},
		{"~", LESS, "0.0.2"},
		{"~", LESS, "0.0.10"},
		{"~", LESS, "0.0.99"},
		{"~", LESS, "0.1.0"},
		{"~", LESS, "0.2.0"},
		{"~", LESS, "0.10.0"},
		{"~", LESS, "0.99.0"},
		{"~", LESS, "0.100.0"},
		{"~", LESS, "0.0.0.0"},
		{"~", LESS, "0.0.0.1"},
		{"~", LESS, "0.0.0.10"},
		{"~", LESS, "0.0.1.0"},
		{"~", LESS, "0.0.01.0"},
		{"~", LESS, "1.2.3.4"},
		{"~", LESS, "1-2-3-4"},
		{"~", LESS, "20150101"},
		{"~", LESS, "20151212"},
		{"~", LESS, "20151212.0"},
		{"~", LESS, "20151212.1"},
		{"~", LESS, "2015.1.1"},
		{"~", LESS, "2015.02.02"},
		{"~", LESS, "2015.12.12"},
		{"~", LESS, "1.2.3a"},
		{"~", LESS, "1.2.3b"},
		{"~", LESS, "R16B"},
		{"~", LESS, "R16C"},
		{"~", LESS, "1.2.3.2016.1.1"},
		{"~", LESS, "0.5a1.dev"},
		{"~", LESS, "1.8.B59BrZX"},
		{"~", LESS, "0.07b4p1"},
		{"~", LESS, "3.99.5final.SP07"},
		{"~", LESS, "3.99.5final.SP08"},
		{"~", LESS, "0.4.tbb.20100203"},
		{"~", LESS, "0.5.20120830CVS.el7"},
		{"~", LESS, "1.el7"},
		{"~", LESS, "1.el6"},
		{"~", LESS, "10.el7"},
		{"~", LESS, "01.el7"},
		{"~", LESS, "0.17.20140318svn632.el7"},
		{"~", LESS, "0.17.20140318svn633.el7"},
		{"~", LESS, "1.20140522gitad6fb3e.el7"},
		{"~", LESS, "1.20140522hitad6fb3e.el7"},
		{"~", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"~", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"~", LESS, "22.svn457.el7"},
		{"~", LESS, "22.svn458.el7"},
		{"~", EQUAL, "~"},
		{"~", GREATER, "~~"},
		{"~", LESS, "~1"},
		{"~", LESS, "~a"},
		{"~", LESS, "1~"},
		{"~", LESS, "2~"},
		{"~~", LESS, ""},
		{"~~", LESS, "0"},
		{"~~", LESS, "1"},
		{"~~", LESS, "2"},
		{"~~", LESS, "10"},
		{"~~", LESS, "100"},
		{"~~", LESS, "0.0"},
		{"~~", LESS, "0.1"},
		{"~~", LESS, "0.10"},
		{"~~", LESS, "0.99"},
		{"~~", LESS, "1.0"},
		{"~~", LESS, "1.99"},
		{"~~", LESS, "2.0"},
		{"~~", LESS, "0.0.0"},
		{"~~", LESS, "0.0.1"},
		{"~~", LESS, "0.0.2"},
		{"~~", LESS, "0.0.10"},
		{"~~", LESS, "0.0.99"},
		{"~~", LESS, "0.1.0"},
		{"~~", LESS, "0.2.0"},
		{"~~", LESS, "0.10.0"},
		{"~~", LESS, "0.99.0"},
		{"~~", LESS, "0.100.0"},
		{"~~", LESS, "0.0.0.0"},
		{"~~", LESS, "0.0.0.1"},
		{"~~", LESS, "0.0.0.10"},
		{"~~", LESS, "0.0.1.0"},
		{"~~", LESS, "0.0.01.0"},
		{"~~", LESS, "1.2.3.4"},
		{"~~", LESS, "1-2-3-4"},
		{"~~", LESS, "20150101"},
		{"~~", LESS, "20151212"},
		{"~~", LESS, "20151212.0"},
		{"~~", LESS, "20151212.1"},
		{"~~", LESS, "2015.1.1"},
		{"~~", LESS, "2015.02.02"},
		{"~~", LESS, "2015.12.12"},
		{"~~", LESS, "1.2.3a"},
		{"~~", LESS, "1.2.3b"},
		{"~~", LESS, "R16B"},
		{"~~", LESS, "R16C"},
		{"~~", LESS, "1.2.3.2016.1.1"},
		{"~~", LESS, "0.5a1.dev"},
		{"~~", LESS, "1.8.B59BrZX"},
		{"~~", LESS, "0.07b4p1"},
		{"~~", LESS, "3.99.5final.SP07"},
		{"~~", LESS, "3.99.5final.SP08"},
		{"~~", LESS, "0.4.tbb.20100203"},
		{"~~", LESS, "0.5.20120830CVS.el7"},
		{"~~", LESS, "1.el7"},
		{"~~", LESS, "1.el6"},
		{"~~", LESS, "10.el7"},
		{"~~", LESS, "01.el7"},
		{"~~", LESS, "0.17.20140318svn632.el7"},
		{"~~", LESS, "0.17.20140318svn633.el7"},
		{"~~", LESS, "1.20140522gitad6fb3e.el7"},
		{"~~", LESS, "1.20140522hitad6fb3e.el7"},
		{"~~", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"~~", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"~~", LESS, "22.svn457.el7"},
		{"~~", LESS, "22.svn458.el7"},
		{"~~", LESS, "~"},
		{"~~", EQUAL, "~~"},
		{"~~", LESS, "~1"},
		{"~~", LESS, "~a"},
		{"~~", LESS, "1~"},
		{"~~", LESS, "2~"},
		{"~1", LESS, ""},
		{"~1", LESS, "0"},
		{"~1", LESS, "1"},
		{"~1", LESS, "2"},
		{"~1", LESS, "10"},
		{"~1", LESS, "100"},
		{"~1", LESS, "0.0"},
		{"~1", LESS, "0.1"},
		{"~1", LESS, "0.10"},
		{"~1", LESS, "0.99"},
		{"~1", LESS, "1.0"},
		{"~1", LESS, "1.99"},
		{"~1", LESS, "2.0"},
		{"~1", LESS, "0.0.0"},
		{"~1", LESS, "0.0.1"},
		{"~1", LESS, "0.0.2"},
		{"~1", LESS, "0.0.10"},
		{"~1", LESS, "0.0.99"},
		{"~1", LESS, "0.1.0"},
		{"~1", LESS, "0.2.0"},
		{"~1", LESS, "0.10.0"},
		{"~1", LESS, "0.99.0"},
		{"~1", LESS, "0.100.0"},
		{"~1", LESS, "0.0.0.0"},
		{"~1", LESS, "0.0.0.1"},
		{"~1", LESS, "0.0.0.10"},
		{"~1", LESS, "0.0.1.0"},
		{"~1", LESS, "0.0.01.0"},
		{"~1", LESS, "1.2.3.4"},
		{"~1", LESS, "1-2-3-4"},
		{"~1", LESS, "20150101"},
		{"~1", LESS, "20151212"},
		{"~1", LESS, "20151212.0"},
		{"~1", LESS, "20151212.1"},
		{"~1", LESS, "2015.1.1"},
		{"~1", LESS, "2015.02.02"},
		{"~1", LESS, "2015.12.12"},
		{"~1", LESS, "1.2.3a"},
		{"~1", LESS, "1.2.3b"},
		{"~1", LESS, "R16B"},
		{"~1", LESS, "R16C"},
		{"~1", LESS, "1.2.3.2016.1.1"},
		{"~1", LESS, "0.5a1.dev"},
		{"~1", LESS, "1.8.B59BrZX"},
		{"~1", LESS, "0.07b4p1"},
		{"~1", LESS, "3.99.5final.SP07"},
		{"~1", LESS, "3.99.5final.SP08"},
		{"~1", LESS, "0.4.tbb.20100203"},
		{"~1", LESS, "0.5.20120830CVS.el7"},
		{"~1", LESS, "1.el7"},
		{"~1", LESS, "1.el6"},
		{"~1", LESS, "10.el7"},
		{"~1", LESS, "01.el7"},
		{"~1", LESS, "0.17.20140318svn632.el7"},
		{"~1", LESS, "0.17.20140318svn633.el7"},
		{"~1", LESS, "1.20140522gitad6fb3e.el7"},
		{"~1", LESS, "1.20140522hitad6fb3e.el7"},
		{"~1", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"~1", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"~1", LESS, "22.svn457.el7"},
		{"~1", LESS, "22.svn458.el7"},
		{"~1", GREATER, "~"},
		{"~1", GREATER, "~~"},
		{"~1", EQUAL, "~1"},
		{"~1", GREATER, "~a"},
		{"~1", LESS, "1~"},
		{"~1", LESS, "2~"},
		{"~a", LESS, ""},
		{"~a", LESS, "0"},
		{"~a", LESS, "1"},
		{"~a", LESS, "2"},
		{"~a", LESS, "10"},
		{"~a", LESS, "100"},
		{"~a", LESS, "0.0"},
		{"~a", LESS, "0.1"},
		{"~a", LESS, "0.10"},
		{"~a", LESS, "0.99"},
		{"~a", LESS, "1.0"},
		{"~a", LESS, "1.99"},
		{"~a", LESS, "2.0"},
		{"~a", LESS, "0.0.0"},
		{"~a", LESS, "0.0.1"},
		{"~a", LESS, "0.0.2"},
		{"~a", LESS, "0.0.10"},
		{"~a", LESS, "0.0.99"},
		{"~a", LESS, "0.1.0"},
		{"~a", LESS, "0.2.0"},
		{"~a", LESS, "0.10.0"},
		{"~a", LESS, "0.99.0"},
		{"~a", LESS, "0.100.0"},
		{"~a", LESS, "0.0.0.0"},
		{"~a", LESS, "0.0.0.1"},
		{"~a", LESS, "0.0.0.10"},
		{"~a", LESS, "0.0.1.0"},
		{"~a", LESS, "0.0.01.0"},
		{"~a", LESS, "1.2.3.4"},
		{"~a", LESS, "1-2-3-4"},
		{"~a", LESS, "20150101"},
		{"~a", LESS, "20151212"},
		{"~a", LESS, "20151212.0"},
		{"~a", LESS, "20151212.1"},
		{"~a", LESS, "2015.1.1"},
		{"~a", LESS, "2015.02.02"},
		{"~a", LESS, "2015.12.12"},
		{"~a", LESS, "1.2.3a"},
		{"~a", LESS, "1.2.3b"},
		{"~a", LESS, "R16B"},
		{"~a", LESS, "R16C"},
		{"~a", LESS, "1.2.3.2016.1.1"},
		{"~a", LESS, "0.5a1.dev"},
		{"~a", LESS, "1.8.B59BrZX"},
		{"~a", LESS, "0.07b4p1"},
		{"~a", LESS, "3.99.5final.SP07"},
		{"~a", LESS, "3.99.5final.SP08"},
		{"~a", LESS, "0.4.tbb.20100203"},
		{"~a", LESS, "0.5.20120830CVS.el7"},
		{"~a", LESS, "1.el7"},
		{"~a", LESS, "1.el6"},
		{"~a", LESS, "10.el7"},
		{"~a", LESS, "01.el7"},
		{"~a", LESS, "0.17.20140318svn632.el7"},
		{"~a", LESS, "0.17.20140318svn633.el7"},
		{"~a", LESS, "1.20140522gitad6fb3e.el7"},
		{"~a", LESS, "1.20140522hitad6fb3e.el7"},
		{"~a", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"~a", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"~a", LESS, "22.svn457.el7"},
		{"~a", LESS, "22.svn458.el7"},
		{"~a", GREATER, "~"},
		{"~a", GREATER, "~~"},
		{"~a", LESS, "~1"},
		{"~a", EQUAL, "~a"},
		{"~a", LESS, "1~"},
		{"~a", LESS, "2~"},
		{"1~", GREATER, ""},
		{"1~", GREATER, "0"},
		{"1~", LESS, "1"},
		{"1~", LESS, "2"},
		{"1~", LESS, "10"},
		{"1~", LESS, "100"},
		{"1~", GREATER, "0.0"},
		{"1~", GREATER, "0.1"},
		{"1~", GREATER, "0.10"},
		{"1~", GREATER, "0.99"},
		{"1~", LESS, "1.0"},
		{"1~", LESS, "1.99"},
		{"1~", LESS, "2.0"},
		{"1~", GREATER, "0.0.0"},
		{"1~", GREATER, "0.0.1"},
		{"1~", GREATER, "0.0.2"},
		{"1~", GREATER, "0.0.10"},
		{"1~", GREATER, "0.0.99"},
		{"1~", GREATER, "0.1.0"},
		{"1~", GREATER, "0.2.0"},
		{"1~", GREATER, "0.10.0"},
		{"1~", GREATER, "0.99.0"},
		{"1~", GREATER, "0.100.0"},
		{"1~", GREATER, "0.0.0.0"},
		{"1~", GREATER, "0.0.0.1"},
		{"1~", GREATER, "0.0.0.10"},
		{"1~", GREATER, "0.0.1.0"},
		{"1~", GREATER, "0.0.01.0"},
		{"1~", LESS, "1.2.3.4"},
		{"1~", LESS, "1-2-3-4"},
		{"1~", LESS, "20150101"},
		{"1~", LESS, "20151212"},
		{"1~", LESS, "20151212.0"},
		{"1~", LESS, "20151212.1"},
		{"1~", LESS, "2015.1.1"},
		{"1~", LESS, "2015.02.02"},
		{"1~", LESS, "2015.12.12"},
		{"1~", LESS, "1.2.3a"},
		{"1~", LESS, "1.2.3b"},
		{"1~", GREATER, "R16B"},
		{"1~", GREATER, "R16C"},
		{"1~", LESS, "1.2.3.2016.1.1"},
		{"1~", GREATER, "0.5a1.dev"},
		{"1~", LESS, "1.8.B59BrZX"},
		{"1~", GREATER, "0.07b4p1"},
		{"1~", LESS, "3.99.5final.SP07"},
		{"1~", LESS, "3.99.5final.SP08"},
		{"1~", GREATER, "0.4.tbb.20100203"},
		{"1~", GREATER, "0.5.20120830CVS.el7"},
		{"1~", LESS, "1.el7"},
		{"1~", LESS, "1.el6"},
		{"1~", LESS, "10.el7"},
		{"1~", LESS, "01.el7"},
		{"1~", GREATER, "0.17.20140318svn632.el7"},
		{"1~", GREATER, "0.17.20140318svn633.el7"},
		{"1~", LESS, "1.20140522gitad6fb3e.el7"},
		{"1~", LESS, "1.20140522hitad6fb3e.el7"},
		{"1~", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"1~", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"1~", LESS, "22.svn457.el7"},
		{"1~", LESS, "22.svn458.el7"},
		{"1~", GREATER, "~"},
		{"1~", GREATER, "~~"},
		{"1~", GREATER, "~1"},
		{"1~", GREATER, "~a"},
		{"1~", EQUAL, "1~"},
		{"1~", LESS, "2~"},
		{"2~", GREATER, ""},
		{"2~", GREATER, "0"},
		{"2~", GREATER, "1"},
		{"2~", LESS, "2"},
		{"2~", LESS, "10"},
		{"2~", LESS, "100"},
		{"2~", GREATER, "0.0"},
		{"2~", GREATER, "0.1"},
		{"2~", GREATER, "0.10"},
		{"2~", GREATER, "0.99"},
		{"2~", GREATER, "1.0"},
		{"2~", GREATER, "1.99"},
		{"2~", LESS, "2.0"},
		{"2~", GREATER, "0.0.0"},
		{"2~", GREATER, "0.0.1"},
		{"2~", GREATER, "0.0.2"},
		{"2~", GREATER, "0.0.10"},
		{"2~", GREATER, "0.0.99"},
		{"2~", GREATER, "0.1.0"},
		{"2~", GREATER, "0.2.0"},
		{"2~", GREATER, "0.10.0"},
		{"2~", GREATER, "0.99.0"},
		{"2~", GREATER, "0.100.0"},
		{"2~", GREATER, "0.0.0.0"},
		{"2~", GREATER, "0.0.0.1"},
		{"2~", GREATER, "0.0.0.10"},
		{"2~", GREATER, "0.0.1.0"},
		{"2~", GREATER, "0.0.01.0"},
		{"2~", GREATER, "1.2.3.4"},
		{"2~", GREATER, "1-2-3-4"},
		{"2~", LESS, "20150101"},
		{"2~", LESS, "20151212"},
		{"2~", LESS, "20151212.0"},
		{"2~", LESS, "20151212.1"},
		{"2~", LESS, "2015.1.1"},
		{"2~", LESS, "2015.02.02"},
		{"2~", LESS, "2015.12.12"},
		{"2~", GREATER, "1.2.3a"},
		{"2~", GREATER, "1.2.3b"},
		{"2~", GREATER, "R16B"},
		{"2~", GREATER, "R16C"},
		{"2~", GREATER, "1.2.3.2016.1.1"},
		{"2~", GREATER, "0.5a1.dev"},
		{"2~", GREATER, "1.8.B59BrZX"},
		{"2~", GREATER, "0.07b4p1"},
		{"2~", LESS, "3.99.5final.SP07"},
		{"2~", LESS, "3.99.5final.SP08"},
		{"2~", GREATER, "0.4.tbb.20100203"},
		{"2~", GREATER, "0.5.20120830CVS.el7"},
		{"2~", GREATER, "1.el7"},
		{"2~", GREATER, "1.el6"},
		{"2~", LESS, "10.el7"},
		{"2~", GREATER, "01.el7"},
		{"2~", GREATER, "0.17.20140318svn632.el7"},
		{"2~", GREATER, "0.17.20140318svn633.el7"},
		{"2~", GREATER, "1.20140522gitad6fb3e.el7"},
		{"2~", GREATER, "1.20140522hitad6fb3e.el7"},
		{"2~", LESS, "8.20140605hgacf1c26e3019.el7"},
		{"2~", LESS, "8.20140605hgacf1c26e3029.el7"},
		{"2~", LESS, "22.svn457.el7"},
		{"2~", LESS, "22.svn458.el7"},
		{"2~", GREATER, "~"},
		{"2~", GREATER, "~~"},
		{"2~", GREATER, "~1"},
		{"2~", GREATER, "~a"},
		{"2~", GREATER, "1~"},
		{"2~", EQUAL, "2~"},
	}
