// Code generated by protoc-gen-gogo.
// source: mesos.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// *
// Status is used to indicate the state of the scheduler and executor
// driver after function calls.
type Status int32

const (
	Status_DRIVER_NOT_STARTED Status = 1
	Status_DRIVER_RUNNING     Status = 2
	Status_DRIVER_ABORTED     Status = 3
	Status_DRIVER_STOPPED     Status = 4
)

var Status_name = map[int32]string{
	1: "DRIVER_NOT_STARTED",
	2: "DRIVER_RUNNING",
	3: "DRIVER_ABORTED",
	4: "DRIVER_STOPPED",
}
var Status_value = map[string]int32{
	"DRIVER_NOT_STARTED": 1,
	"DRIVER_RUNNING":     2,
	"DRIVER_ABORTED":     3,
	"DRIVER_STOPPED":     4,
}

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}
func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (x *Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Status_value, data, "Status")
	if err != nil {
		return err
	}
	*x = Status(value)
	return nil
}

// *
// Describes possible task states. IMPORTANT: Mesos assumes tasks that
// enter terminal states (see below) imply the task is no longer
// running and thus clean up any thing associated with the task
// (ultimately offering any resources being consumed by that task to
// another task).
type TaskState int32

const (
	TaskState_TASK_STAGING  TaskState = 6
	TaskState_TASK_STARTING TaskState = 0
	TaskState_TASK_RUNNING  TaskState = 1
	TaskState_TASK_FINISHED TaskState = 2
	TaskState_TASK_FAILED   TaskState = 3
	TaskState_TASK_KILLED   TaskState = 4
	TaskState_TASK_LOST     TaskState = 5
	TaskState_TASK_ERROR    TaskState = 7
)

var TaskState_name = map[int32]string{
	6: "TASK_STAGING",
	0: "TASK_STARTING",
	1: "TASK_RUNNING",
	2: "TASK_FINISHED",
	3: "TASK_FAILED",
	4: "TASK_KILLED",
	5: "TASK_LOST",
	7: "TASK_ERROR",
}
var TaskState_value = map[string]int32{
	"TASK_STAGING":  6,
	"TASK_STARTING": 0,
	"TASK_RUNNING":  1,
	"TASK_FINISHED": 2,
	"TASK_FAILED":   3,
	"TASK_KILLED":   4,
	"TASK_LOST":     5,
	"TASK_ERROR":    7,
}

func (x TaskState) Enum() *TaskState {
	p := new(TaskState)
	*p = x
	return p
}
func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (x *TaskState) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskState_value, data, "TaskState")
	if err != nil {
		return err
	}
	*x = TaskState(value)
	return nil
}

// Describes the several states that a machine can be in.  A `Mode`
// applies to a machine and to all associated slaves on the machine.
type MachineInfo_Mode int32

const (
	// In this mode, a machine is behaving normally;
	// offering resources, executing tasks, etc.
	MachineInfo_UP MachineInfo_Mode = 1
	// In this mode, all slaves on the machine are expected to cooperate with
	// frameworks to drain resources.  In general, draining is done ahead of
	// a pending `unavailability`.  The resources should be drained so as to
	// maximize utilization prior to the maintenance but without knowingly
	// violating the frameworks' requirements.
	MachineInfo_DRAINING MachineInfo_Mode = 2
	// In this mode, a machine is not running any tasks and will not offer
	// any of its resources.  Slaves on the machine will not be allowed to
	// register with the master.
	MachineInfo_DOWN MachineInfo_Mode = 3
)

var MachineInfo_Mode_name = map[int32]string{
	1: "UP",
	2: "DRAINING",
	3: "DOWN",
}
var MachineInfo_Mode_value = map[string]int32{
	"UP":       1,
	"DRAINING": 2,
	"DOWN":     3,
}

func (x MachineInfo_Mode) Enum() *MachineInfo_Mode {
	p := new(MachineInfo_Mode)
	*p = x
	return p
}
func (x MachineInfo_Mode) String() string {
	return proto.EnumName(MachineInfo_Mode_name, int32(x))
}
func (x *MachineInfo_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(MachineInfo_Mode_value, data, "MachineInfo_Mode")
	if err != nil {
		return err
	}
	*x = MachineInfo_Mode(value)
	return nil
}

type FrameworkInfo_Capability_Type int32

const (
	// Receive offers with revocable resources. See 'Resource'
	// message for details.
	// TODO(vinod): This is currently a no-op.
	FrameworkInfo_Capability_REVOCABLE_RESOURCES FrameworkInfo_Capability_Type = 1
)

var FrameworkInfo_Capability_Type_name = map[int32]string{
	1: "REVOCABLE_RESOURCES",
}
var FrameworkInfo_Capability_Type_value = map[string]int32{
	"REVOCABLE_RESOURCES": 1,
}

func (x FrameworkInfo_Capability_Type) Enum() *FrameworkInfo_Capability_Type {
	p := new(FrameworkInfo_Capability_Type)
	*p = x
	return p
}
func (x FrameworkInfo_Capability_Type) String() string {
	return proto.EnumName(FrameworkInfo_Capability_Type_name, int32(x))
}
func (x *FrameworkInfo_Capability_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FrameworkInfo_Capability_Type_value, data, "FrameworkInfo_Capability_Type")
	if err != nil {
		return err
	}
	*x = FrameworkInfo_Capability_Type(value)
	return nil
}

type Value_Type int32

const (
	Value_SCALAR Value_Type = 0
	Value_RANGES Value_Type = 1
	Value_SET    Value_Type = 2
	Value_TEXT   Value_Type = 3
)

var Value_Type_name = map[int32]string{
	0: "SCALAR",
	1: "RANGES",
	2: "SET",
	3: "TEXT",
}
var Value_Type_value = map[string]int32{
	"SCALAR": 0,
	"RANGES": 1,
	"SET":    2,
	"TEXT":   3,
}

func (x Value_Type) Enum() *Value_Type {
	p := new(Value_Type)
	*p = x
	return p
}
func (x Value_Type) String() string {
	return proto.EnumName(Value_Type_name, int32(x))
}
func (x *Value_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Value_Type_value, data, "Value_Type")
	if err != nil {
		return err
	}
	*x = Value_Type(value)
	return nil
}

type Offer_Operation_Type int32

const (
	Offer_Operation_LAUNCH    Offer_Operation_Type = 1
	Offer_Operation_RESERVE   Offer_Operation_Type = 2
	Offer_Operation_UNRESERVE Offer_Operation_Type = 3
	Offer_Operation_CREATE    Offer_Operation_Type = 4
	Offer_Operation_DESTROY   Offer_Operation_Type = 5
)

var Offer_Operation_Type_name = map[int32]string{
	1: "LAUNCH",
	2: "RESERVE",
	3: "UNRESERVE",
	4: "CREATE",
	5: "DESTROY",
}
var Offer_Operation_Type_value = map[string]int32{
	"LAUNCH":    1,
	"RESERVE":   2,
	"UNRESERVE": 3,
	"CREATE":    4,
	"DESTROY":   5,
}

func (x Offer_Operation_Type) Enum() *Offer_Operation_Type {
	p := new(Offer_Operation_Type)
	*p = x
	return p
}
func (x Offer_Operation_Type) String() string {
	return proto.EnumName(Offer_Operation_Type_name, int32(x))
}
func (x *Offer_Operation_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Offer_Operation_Type_value, data, "Offer_Operation_Type")
	if err != nil {
		return err
	}
	*x = Offer_Operation_Type(value)
	return nil
}

// Describes the source of the task status update.
type TaskStatus_Source int32

const (
	TaskStatus_SOURCE_MASTER   TaskStatus_Source = 0
	TaskStatus_SOURCE_SLAVE    TaskStatus_Source = 1
	TaskStatus_SOURCE_EXECUTOR TaskStatus_Source = 2
)

var TaskStatus_Source_name = map[int32]string{
	0: "SOURCE_MASTER",
	1: "SOURCE_SLAVE",
	2: "SOURCE_EXECUTOR",
}
var TaskStatus_Source_value = map[string]int32{
	"SOURCE_MASTER":   0,
	"SOURCE_SLAVE":    1,
	"SOURCE_EXECUTOR": 2,
}

func (x TaskStatus_Source) Enum() *TaskStatus_Source {
	p := new(TaskStatus_Source)
	*p = x
	return p
}
func (x TaskStatus_Source) String() string {
	return proto.EnumName(TaskStatus_Source_name, int32(x))
}
func (x *TaskStatus_Source) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Source_value, data, "TaskStatus_Source")
	if err != nil {
		return err
	}
	*x = TaskStatus_Source(value)
	return nil
}

// Detailed reason for the task status update.
//
// TODO(bmahler): Differentiate between slave removal reasons
// (e.g. unhealthy vs. unregistered for maintenance).
type TaskStatus_Reason int32

const (
	// TODO(jieyu): The default value when a caller doesn't check for
	// presence is 0 and so ideally the 0 reason is not a valid one.
	// Since this is not used anywhere, consider removing this reason.
	TaskStatus_REASON_COMMAND_EXECUTOR_FAILED         TaskStatus_Reason = 0
	TaskStatus_REASON_CONTAINER_LAUNCH_FAILED         TaskStatus_Reason = 21
	TaskStatus_REASON_CONTAINER_LIMITATION            TaskStatus_Reason = 19
	TaskStatus_REASON_CONTAINER_LIMITATION_DISK       TaskStatus_Reason = 20
	TaskStatus_REASON_CONTAINER_LIMITATION_MEMORY     TaskStatus_Reason = 8
	TaskStatus_REASON_CONTAINER_PREEMPTED             TaskStatus_Reason = 17
	TaskStatus_REASON_CONTAINER_UPDATE_FAILED         TaskStatus_Reason = 22
	TaskStatus_REASON_EXECUTOR_REGISTRATION_TIMEOUT   TaskStatus_Reason = 23
	TaskStatus_REASON_EXECUTOR_REREGISTRATION_TIMEOUT TaskStatus_Reason = 24
	TaskStatus_REASON_EXECUTOR_TERMINATED             TaskStatus_Reason = 1
	TaskStatus_REASON_EXECUTOR_UNREGISTERED           TaskStatus_Reason = 2
	TaskStatus_REASON_FRAMEWORK_REMOVED               TaskStatus_Reason = 3
	TaskStatus_REASON_GC_ERROR                        TaskStatus_Reason = 4
	TaskStatus_REASON_INVALID_FRAMEWORKID             TaskStatus_Reason = 5
	TaskStatus_REASON_INVALID_OFFERS                  TaskStatus_Reason = 6
	TaskStatus_REASON_MASTER_DISCONNECTED             TaskStatus_Reason = 7
	TaskStatus_REASON_RECONCILIATION                  TaskStatus_Reason = 9
	TaskStatus_REASON_RESOURCES_UNKNOWN               TaskStatus_Reason = 18
	TaskStatus_REASON_SLAVE_DISCONNECTED              TaskStatus_Reason = 10
	TaskStatus_REASON_SLAVE_REMOVED                   TaskStatus_Reason = 11
	TaskStatus_REASON_SLAVE_RESTARTED                 TaskStatus_Reason = 12
	TaskStatus_REASON_SLAVE_UNKNOWN                   TaskStatus_Reason = 13
	TaskStatus_REASON_TASK_INVALID                    TaskStatus_Reason = 14
	TaskStatus_REASON_TASK_UNAUTHORIZED               TaskStatus_Reason = 15
	TaskStatus_REASON_TASK_UNKNOWN                    TaskStatus_Reason = 16
)

var TaskStatus_Reason_name = map[int32]string{
	0:  "REASON_COMMAND_EXECUTOR_FAILED",
	21: "REASON_CONTAINER_LAUNCH_FAILED",
	19: "REASON_CONTAINER_LIMITATION",
	20: "REASON_CONTAINER_LIMITATION_DISK",
	8:  "REASON_CONTAINER_LIMITATION_MEMORY",
	17: "REASON_CONTAINER_PREEMPTED",
	22: "REASON_CONTAINER_UPDATE_FAILED",
	23: "REASON_EXECUTOR_REGISTRATION_TIMEOUT",
	24: "REASON_EXECUTOR_REREGISTRATION_TIMEOUT",
	1:  "REASON_EXECUTOR_TERMINATED",
	2:  "REASON_EXECUTOR_UNREGISTERED",
	3:  "REASON_FRAMEWORK_REMOVED",
	4:  "REASON_GC_ERROR",
	5:  "REASON_INVALID_FRAMEWORKID",
	6:  "REASON_INVALID_OFFERS",
	7:  "REASON_MASTER_DISCONNECTED",
	9:  "REASON_RECONCILIATION",
	18: "REASON_RESOURCES_UNKNOWN",
	10: "REASON_SLAVE_DISCONNECTED",
	11: "REASON_SLAVE_REMOVED",
	12: "REASON_SLAVE_RESTARTED",
	13: "REASON_SLAVE_UNKNOWN",
	14: "REASON_TASK_INVALID",
	15: "REASON_TASK_UNAUTHORIZED",
	16: "REASON_TASK_UNKNOWN",
}
var TaskStatus_Reason_value = map[string]int32{
	"REASON_COMMAND_EXECUTOR_FAILED":         0,
	"REASON_CONTAINER_LAUNCH_FAILED":         21,
	"REASON_CONTAINER_LIMITATION":            19,
	"REASON_CONTAINER_LIMITATION_DISK":       20,
	"REASON_CONTAINER_LIMITATION_MEMORY":     8,
	"REASON_CONTAINER_PREEMPTED":             17,
	"REASON_CONTAINER_UPDATE_FAILED":         22,
	"REASON_EXECUTOR_REGISTRATION_TIMEOUT":   23,
	"REASON_EXECUTOR_REREGISTRATION_TIMEOUT": 24,
	"REASON_EXECUTOR_TERMINATED":             1,
	"REASON_EXECUTOR_UNREGISTERED":           2,
	"REASON_FRAMEWORK_REMOVED":               3,
	"REASON_GC_ERROR":                        4,
	"REASON_INVALID_FRAMEWORKID":             5,
	"REASON_INVALID_OFFERS":                  6,
	"REASON_MASTER_DISCONNECTED":             7,
	"REASON_RECONCILIATION":                  9,
	"REASON_RESOURCES_UNKNOWN":               18,
	"REASON_SLAVE_DISCONNECTED":              10,
	"REASON_SLAVE_REMOVED":                   11,
	"REASON_SLAVE_RESTARTED":                 12,
	"REASON_SLAVE_UNKNOWN":                   13,
	"REASON_TASK_INVALID":                    14,
	"REASON_TASK_UNAUTHORIZED":               15,
	"REASON_TASK_UNKNOWN":                    16,
}

func (x TaskStatus_Reason) Enum() *TaskStatus_Reason {
	p := new(TaskStatus_Reason)
	*p = x
	return p
}
func (x TaskStatus_Reason) String() string {
	return proto.EnumName(TaskStatus_Reason_name, int32(x))
}
func (x *TaskStatus_Reason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskStatus_Reason_value, data, "TaskStatus_Reason")
	if err != nil {
		return err
	}
	*x = TaskStatus_Reason(value)
	return nil
}

type Image_Type int32

const (
	Image_APPC   Image_Type = 1
	Image_DOCKER Image_Type = 2
)

var Image_Type_name = map[int32]string{
	1: "APPC",
	2: "DOCKER",
}
var Image_Type_value = map[string]int32{
	"APPC":   1,
	"DOCKER": 2,
}

func (x Image_Type) Enum() *Image_Type {
	p := new(Image_Type)
	*p = x
	return p
}
func (x Image_Type) String() string {
	return proto.EnumName(Image_Type_name, int32(x))
}
func (x *Image_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Image_Type_value, data, "Image_Type")
	if err != nil {
		return err
	}
	*x = Image_Type(value)
	return nil
}

type Volume_Mode int32

const (
	Volume_RW Volume_Mode = 1
	Volume_RO Volume_Mode = 2
)

var Volume_Mode_name = map[int32]string{
	1: "RW",
	2: "RO",
}
var Volume_Mode_value = map[string]int32{
	"RW": 1,
	"RO": 2,
}

func (x Volume_Mode) Enum() *Volume_Mode {
	p := new(Volume_Mode)
	*p = x
	return p
}
func (x Volume_Mode) String() string {
	return proto.EnumName(Volume_Mode_name, int32(x))
}
func (x *Volume_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Volume_Mode_value, data, "Volume_Mode")
	if err != nil {
		return err
	}
	*x = Volume_Mode(value)
	return nil
}

type NetworkInfo_Protocol int32

const (
	NetworkInfo_IPv4 NetworkInfo_Protocol = 1
	NetworkInfo_IPv6 NetworkInfo_Protocol = 2
)

var NetworkInfo_Protocol_name = map[int32]string{
	1: "IPv4",
	2: "IPv6",
}
var NetworkInfo_Protocol_value = map[string]int32{
	"IPv4": 1,
	"IPv6": 2,
}

func (x NetworkInfo_Protocol) Enum() *NetworkInfo_Protocol {
	p := new(NetworkInfo_Protocol)
	*p = x
	return p
}
func (x NetworkInfo_Protocol) String() string {
	return proto.EnumName(NetworkInfo_Protocol_name, int32(x))
}
func (x *NetworkInfo_Protocol) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(NetworkInfo_Protocol_value, data, "NetworkInfo_Protocol")
	if err != nil {
		return err
	}
	*x = NetworkInfo_Protocol(value)
	return nil
}

// All container implementation types.
type ContainerInfo_Type int32

const (
	ContainerInfo_DOCKER ContainerInfo_Type = 1
	ContainerInfo_MESOS  ContainerInfo_Type = 2
)

var ContainerInfo_Type_name = map[int32]string{
	1: "DOCKER",
	2: "MESOS",
}
var ContainerInfo_Type_value = map[string]int32{
	"DOCKER": 1,
	"MESOS":  2,
}

func (x ContainerInfo_Type) Enum() *ContainerInfo_Type {
	p := new(ContainerInfo_Type)
	*p = x
	return p
}
func (x ContainerInfo_Type) String() string {
	return proto.EnumName(ContainerInfo_Type_name, int32(x))
}
func (x *ContainerInfo_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_Type_value, data, "ContainerInfo_Type")
	if err != nil {
		return err
	}
	*x = ContainerInfo_Type(value)
	return nil
}

// Network options.
type ContainerInfo_DockerInfo_Network int32

const (
	ContainerInfo_DockerInfo_HOST   ContainerInfo_DockerInfo_Network = 1
	ContainerInfo_DockerInfo_BRIDGE ContainerInfo_DockerInfo_Network = 2
	ContainerInfo_DockerInfo_NONE   ContainerInfo_DockerInfo_Network = 3
)

var ContainerInfo_DockerInfo_Network_name = map[int32]string{
	1: "HOST",
	2: "BRIDGE",
	3: "NONE",
}
var ContainerInfo_DockerInfo_Network_value = map[string]int32{
	"HOST":   1,
	"BRIDGE": 2,
	"NONE":   3,
}

func (x ContainerInfo_DockerInfo_Network) Enum() *ContainerInfo_DockerInfo_Network {
	p := new(ContainerInfo_DockerInfo_Network)
	*p = x
	return p
}
func (x ContainerInfo_DockerInfo_Network) String() string {
	return proto.EnumName(ContainerInfo_DockerInfo_Network_name, int32(x))
}
func (x *ContainerInfo_DockerInfo_Network) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ContainerInfo_DockerInfo_Network_value, data, "ContainerInfo_DockerInfo_Network")
	if err != nil {
		return err
	}
	*x = ContainerInfo_DockerInfo_Network(value)
	return nil
}

type DiscoveryInfo_Visibility int32

const (
	DiscoveryInfo_FRAMEWORK DiscoveryInfo_Visibility = 0
	DiscoveryInfo_CLUSTER   DiscoveryInfo_Visibility = 1
	DiscoveryInfo_EXTERNAL  DiscoveryInfo_Visibility = 2
)

var DiscoveryInfo_Visibility_name = map[int32]string{
	0: "FRAMEWORK",
	1: "CLUSTER",
	2: "EXTERNAL",
}
var DiscoveryInfo_Visibility_value = map[string]int32{
	"FRAMEWORK": 0,
	"CLUSTER":   1,
	"EXTERNAL":  2,
}

func (x DiscoveryInfo_Visibility) Enum() *DiscoveryInfo_Visibility {
	p := new(DiscoveryInfo_Visibility)
	*p = x
	return p
}
func (x DiscoveryInfo_Visibility) String() string {
	return proto.EnumName(DiscoveryInfo_Visibility_name, int32(x))
}
func (x *DiscoveryInfo_Visibility) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DiscoveryInfo_Visibility_value, data, "DiscoveryInfo_Visibility")
	if err != nil {
		return err
	}
	*x = DiscoveryInfo_Visibility(value)
	return nil
}

// *
// A unique ID assigned to a framework. A framework can reuse this ID
// in order to do failover (see MesosSchedulerDriver).
type FrameworkID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FrameworkID) Reset()      { *m = FrameworkID{} }
func (*FrameworkID) ProtoMessage() {}

func (m *FrameworkID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A unique ID assigned to an offer.
type OfferID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *OfferID) Reset()      { *m = OfferID{} }
func (*OfferID) ProtoMessage() {}

func (m *OfferID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A unique ID assigned to a slave. Currently, a slave gets a new ID
// whenever it (re)registers with Mesos. Framework writers shouldn't
// assume any binding between a slave ID and and a hostname.
type SlaveID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *SlaveID) Reset()      { *m = SlaveID{} }
func (*SlaveID) ProtoMessage() {}

func (m *SlaveID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A framework generated ID to distinguish a task. The ID must remain
// unique while the task is active. However, a framework can reuse an
// ID _only_ if a previous task with the same ID has reached a
// terminal state (e.g., TASK_FINISHED, TASK_LOST, TASK_KILLED, etc.).
type TaskID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TaskID) Reset()      { *m = TaskID{} }
func (*TaskID) ProtoMessage() {}

func (m *TaskID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A framework generated ID to distinguish an executor. Only one
// executor with the same ID can be active on the same slave at a
// time.
type ExecutorID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ExecutorID) Reset()      { *m = ExecutorID{} }
func (*ExecutorID) ProtoMessage() {}

func (m *ExecutorID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A slave generated ID to distinguish a container. The ID must be unique
// between any active or completed containers on the slave. In particular,
// containers for different runs of the same (framework, executor) pair must be
// unique.
type ContainerID struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerID) Reset()      { *m = ContainerID{} }
func (*ContainerID) ProtoMessage() {}

func (m *ContainerID) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Represents time since the epoch, in nanoseconds.
type TimeInfo struct {
	Nanoseconds      *int64 `protobuf:"varint,1,req,name=nanoseconds" json:"nanoseconds,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TimeInfo) Reset()      { *m = TimeInfo{} }
func (*TimeInfo) ProtoMessage() {}

func (m *TimeInfo) GetNanoseconds() int64 {
	if m != nil && m.Nanoseconds != nil {
		return *m.Nanoseconds
	}
	return 0
}

// *
// Represents duration in nanoseconds.
type DurationInfo struct {
	Nanoseconds      *int64 `protobuf:"varint,1,req,name=nanoseconds" json:"nanoseconds,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DurationInfo) Reset()      { *m = DurationInfo{} }
func (*DurationInfo) ProtoMessage() {}

func (m *DurationInfo) GetNanoseconds() int64 {
	if m != nil && m.Nanoseconds != nil {
		return *m.Nanoseconds
	}
	return 0
}

// *
// A network address.
//
// TODO(bmahler): Use this more widely.
type Address struct {
	// May contain a hostname, IP address, or both.
	Hostname         *string `protobuf:"bytes,1,opt,name=hostname" json:"hostname,omitempty"`
	Ip               *string `protobuf:"bytes,2,opt,name=ip" json:"ip,omitempty"`
	Port             *int32  `protobuf:"varint,3,req,name=port" json:"port,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Address) Reset()      { *m = Address{} }
func (*Address) ProtoMessage() {}

func (m *Address) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Address) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

func (m *Address) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

// *
// Represents a URL.
type URL struct {
	Scheme           *string      `protobuf:"bytes,1,req,name=scheme" json:"scheme,omitempty"`
	Address          *Address     `protobuf:"bytes,2,req,name=address" json:"address,omitempty"`
	Path             *string      `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
	Query            []*Parameter `protobuf:"bytes,4,rep,name=query" json:"query,omitempty"`
	Fragment         *string      `protobuf:"bytes,5,opt,name=fragment" json:"fragment,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *URL) Reset()      { *m = URL{} }
func (*URL) ProtoMessage() {}

func (m *URL) GetScheme() string {
	if m != nil && m.Scheme != nil {
		return *m.Scheme
	}
	return ""
}

func (m *URL) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *URL) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *URL) GetQuery() []*Parameter {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *URL) GetFragment() string {
	if m != nil && m.Fragment != nil {
		return *m.Fragment
	}
	return ""
}

// *
// Represents an interval, from a given start time over a given duration.
// This interval pertains to an unavailability event, such as maintenance,
// and is not a generic interval.
type Unavailability struct {
	Start *TimeInfo `protobuf:"bytes,1,req,name=start" json:"start,omitempty"`
	// When added to `start`, this represents the end of the interval.
	// If unspecified, the duration is assumed to be infinite.
	Duration         *DurationInfo `protobuf:"bytes,2,opt,name=duration" json:"duration,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Unavailability) Reset()      { *m = Unavailability{} }
func (*Unavailability) ProtoMessage() {}

func (m *Unavailability) GetStart() *TimeInfo {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *Unavailability) GetDuration() *DurationInfo {
	if m != nil {
		return m.Duration
	}
	return nil
}

// *
// Represents a single machine, which may hold one or more slaves.
//
// NOTE: In order to match a slave to a machine, both the `hostname` and
// `ip` must match the values advertised by the slave to the master.
// Hostname is not case-sensitive.
type MachineID struct {
	Hostname         *string `protobuf:"bytes,1,opt,name=hostname" json:"hostname,omitempty"`
	Ip               *string `protobuf:"bytes,2,opt,name=ip" json:"ip,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *MachineID) Reset()      { *m = MachineID{} }
func (*MachineID) ProtoMessage() {}

func (m *MachineID) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *MachineID) GetIp() string {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return ""
}

// *
// Holds information about a single machine, its `mode`, and any other
// relevant information which may affect the behavior of the machine.
type MachineInfo struct {
	Id   *MachineID        `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	Mode *MachineInfo_Mode `protobuf:"varint,2,opt,name=mode,enum=mesosproto.MachineInfo_Mode" json:"mode,omitempty"`
	// Signifies that the machine may be unavailable during the given interval.
	// See comments in `Unavailability` and for the `unavailability` fields
	// in `Offer` and `InverseOffer` for more information.
	Unavailability   *Unavailability `protobuf:"bytes,3,opt,name=unavailability" json:"unavailability,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *MachineInfo) Reset()      { *m = MachineInfo{} }
func (*MachineInfo) ProtoMessage() {}

func (m *MachineInfo) GetId() *MachineID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *MachineInfo) GetMode() MachineInfo_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return MachineInfo_UP
}

func (m *MachineInfo) GetUnavailability() *Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return nil
}

// *
// Describes a framework.
type FrameworkInfo struct {
	// Used to determine the Unix user that an executor or task should
	// be launched as. If the user field is set to an empty string Mesos
	// will automagically set it to the current user.
	User *string `protobuf:"bytes,1,req,name=user" json:"user,omitempty"`
	// Name of the framework that shows up in the Mesos Web UI.
	Name *string `protobuf:"bytes,2,req,name=name" json:"name,omitempty"`
	// Note that 'id' is only available after a framework has
	// registered, however, it is included here in order to facilitate
	// scheduler failover (i.e., if it is set then the
	// MesosSchedulerDriver expects the scheduler is performing
	// failover).
	Id *FrameworkID `protobuf:"bytes,3,opt,name=id" json:"id,omitempty"`
	// The amount of time that the master will wait for the scheduler to
	// failover before it tears down the framework by killing all its
	// tasks/executors. This should be non-zero if a framework expects
	// to reconnect after a failover and not lose its tasks/executors.
	FailoverTimeout *float64 `protobuf:"fixed64,4,opt,name=failover_timeout,def=0" json:"failover_timeout,omitempty"`
	// If set, framework pid, executor pids and status updates are
	// checkpointed to disk by the slaves. Checkpointing allows a
	// restarted slave to reconnect with old executors and recover
	// status updates, at the cost of disk I/O.
	Checkpoint *bool `protobuf:"varint,5,opt,name=checkpoint,def=0" json:"checkpoint,omitempty"`
	// Used to group frameworks for allocation decisions, depending on
	// the allocation policy being used.
	Role *string `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	// Used to indicate the current host from which the scheduler is
	// registered in the Mesos Web UI. If set to an empty string Mesos
	// will automagically set it to the current hostname if one is
	// available.
	Hostname *string `protobuf:"bytes,7,opt,name=hostname" json:"hostname,omitempty"`
	// This field should match the credential's principal the framework
	// uses for authentication. This field is used for framework API
	// rate limiting and dynamic reservations. It should be set even
	// if authentication is not enabled if these features are desired.
	Principal *string `protobuf:"bytes,8,opt,name=principal" json:"principal,omitempty"`
	// This field allows a framework to advertise its web UI, so that
	// the Mesos web UI can link to it. It is expected to be a full URL,
	// for example http://my-scheduler.example.com:8080/.
	WebuiUrl *string `protobuf:"bytes,9,opt,name=webui_url" json:"webui_url,omitempty"`
	// This field allows a framework to advertise its set of
	// capabilities (e.g., ability to receive offers for revocable
	// resources).
	Capabilities []*FrameworkInfo_Capability `protobuf:"bytes,10,rep,name=capabilities" json:"capabilities,omitempty"`
	// Labels are free-form key value pairs supplied by the framework
	// scheduler (e.g., to describe additional functionality offered by
	// the framework). These labels are not interpreted by Mesos itself.
	Labels           *Labels `protobuf:"bytes,11,opt,name=labels" json:"labels,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FrameworkInfo) Reset()      { *m = FrameworkInfo{} }
func (*FrameworkInfo) ProtoMessage() {}

const Default_FrameworkInfo_FailoverTimeout float64 = 0
const Default_FrameworkInfo_Checkpoint bool = false
const Default_FrameworkInfo_Role string = "*"

func (m *FrameworkInfo) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *FrameworkInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *FrameworkInfo) GetId() *FrameworkID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *FrameworkInfo) GetFailoverTimeout() float64 {
	if m != nil && m.FailoverTimeout != nil {
		return *m.FailoverTimeout
	}
	return Default_FrameworkInfo_FailoverTimeout
}

func (m *FrameworkInfo) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return Default_FrameworkInfo_Checkpoint
}

func (m *FrameworkInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_FrameworkInfo_Role
}

func (m *FrameworkInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *FrameworkInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *FrameworkInfo) GetWebuiUrl() string {
	if m != nil && m.WebuiUrl != nil {
		return *m.WebuiUrl
	}
	return ""
}

func (m *FrameworkInfo) GetCapabilities() []*FrameworkInfo_Capability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *FrameworkInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

type FrameworkInfo_Capability struct {
	Type             *FrameworkInfo_Capability_Type `protobuf:"varint,1,req,name=type,enum=mesosproto.FrameworkInfo_Capability_Type" json:"type,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *FrameworkInfo_Capability) Reset()      { *m = FrameworkInfo_Capability{} }
func (*FrameworkInfo_Capability) ProtoMessage() {}

func (m *FrameworkInfo_Capability) GetType() FrameworkInfo_Capability_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return FrameworkInfo_Capability_REVOCABLE_RESOURCES
}

// *
// Describes a health check for a task or executor (or any arbitrary
// process/command). A "strategy" is picked by specifying one of the
// optional fields; currently only 'command' is supported.
// Specifying more than one strategy is an error.
type HealthCheck struct {
	// HTTP health check - not yet recommended for use, see MESOS-2533.
	Http *HealthCheck_HTTP `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
	// Amount of time to wait until starting the health checks.
	DelaySeconds *float64 `protobuf:"fixed64,2,opt,name=delay_seconds,def=15" json:"delay_seconds,omitempty"`
	// Interval between health checks.
	IntervalSeconds *float64 `protobuf:"fixed64,3,opt,name=interval_seconds,def=10" json:"interval_seconds,omitempty"`
	// Amount of time to wait for the health check to complete.
	TimeoutSeconds *float64 `protobuf:"fixed64,4,opt,name=timeout_seconds,def=20" json:"timeout_seconds,omitempty"`
	// Number of consecutive failures until considered unhealthy.
	ConsecutiveFailures *uint32 `protobuf:"varint,5,opt,name=consecutive_failures,def=3" json:"consecutive_failures,omitempty"`
	// Amount of time to allow failed health checks since launch.
	GracePeriodSeconds *float64 `protobuf:"fixed64,6,opt,name=grace_period_seconds,def=10" json:"grace_period_seconds,omitempty"`
	// Command health check.
	Command          *CommandInfo `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *HealthCheck) Reset()      { *m = HealthCheck{} }
func (*HealthCheck) ProtoMessage() {}

const Default_HealthCheck_DelaySeconds float64 = 15
const Default_HealthCheck_IntervalSeconds float64 = 10
const Default_HealthCheck_TimeoutSeconds float64 = 20
const Default_HealthCheck_ConsecutiveFailures uint32 = 3
const Default_HealthCheck_GracePeriodSeconds float64 = 10

func (m *HealthCheck) GetHttp() *HealthCheck_HTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *HealthCheck) GetDelaySeconds() float64 {
	if m != nil && m.DelaySeconds != nil {
		return *m.DelaySeconds
	}
	return Default_HealthCheck_DelaySeconds
}

func (m *HealthCheck) GetIntervalSeconds() float64 {
	if m != nil && m.IntervalSeconds != nil {
		return *m.IntervalSeconds
	}
	return Default_HealthCheck_IntervalSeconds
}

func (m *HealthCheck) GetTimeoutSeconds() float64 {
	if m != nil && m.TimeoutSeconds != nil {
		return *m.TimeoutSeconds
	}
	return Default_HealthCheck_TimeoutSeconds
}

func (m *HealthCheck) GetConsecutiveFailures() uint32 {
	if m != nil && m.ConsecutiveFailures != nil {
		return *m.ConsecutiveFailures
	}
	return Default_HealthCheck_ConsecutiveFailures
}

func (m *HealthCheck) GetGracePeriodSeconds() float64 {
	if m != nil && m.GracePeriodSeconds != nil {
		return *m.GracePeriodSeconds
	}
	return Default_HealthCheck_GracePeriodSeconds
}

func (m *HealthCheck) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

// Describes an HTTP health check. This is not fully implemented and not
// recommended for use - see MESOS-2533.
type HealthCheck_HTTP struct {
	// Port to send the HTTP request.
	Port *uint32 `protobuf:"varint,1,req,name=port" json:"port,omitempty"`
	// HTTP request path.
	Path *string `protobuf:"bytes,2,opt,name=path,def=/" json:"path,omitempty"`
	// Expected response statuses. Not specifying any statuses implies
	// that any returned status is acceptable.
	Statuses         []uint32 `protobuf:"varint,4,rep,name=statuses" json:"statuses,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *HealthCheck_HTTP) Reset()      { *m = HealthCheck_HTTP{} }
func (*HealthCheck_HTTP) ProtoMessage() {}

const Default_HealthCheck_HTTP_Path string = "/"

func (m *HealthCheck_HTTP) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *HealthCheck_HTTP) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return Default_HealthCheck_HTTP_Path
}

func (m *HealthCheck_HTTP) GetStatuses() []uint32 {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// *
// Describes a command, executed via: '/bin/sh -c value'. Any URIs specified
// are fetched before executing the command.  If the executable field for an
// uri is set, executable file permission is set on the downloaded file.
// Otherwise, if the downloaded file has a recognized archive extension
// (currently [compressed] tar and zip) it is extracted into the executor's
// working directory. This extraction can be disabled by setting `extract` to
// false. In addition, any environment variables are set before executing
// the command (so they can be used to "parameterize" your command).
type CommandInfo struct {
	// NOTE: MesosContainerizer does currently not support this
	// attribute and tasks supplying a 'container' will fail.
	Container   *CommandInfo_ContainerInfo `protobuf:"bytes,4,opt,name=container" json:"container,omitempty"`
	Uris        []*CommandInfo_URI         `protobuf:"bytes,1,rep,name=uris" json:"uris,omitempty"`
	Environment *Environment               `protobuf:"bytes,2,opt,name=environment" json:"environment,omitempty"`
	// There are two ways to specify the command:
	// 1) If 'shell == true', the command will be launched via shell
	// 		(i.e., /bin/sh -c 'value'). The 'value' specified will be
	// 		treated as the shell command. The 'arguments' will be ignored.
	// 2) If 'shell == false', the command will be launched by passing
	// 		arguments to an executable. The 'value' specified will be
	// 		treated as the filename of the executable. The 'arguments'
	// 		will be treated as the arguments to the executable. This is
	// 		similar to how POSIX exec families launch processes (i.e.,
	// 		execlp(value, arguments(0), arguments(1), ...)).
	// NOTE: The field 'value' is changed from 'required' to 'optional'
	// in 0.20.0. It will only cause issues if a new framework is
	// connecting to an old master.
	Shell     *bool    `protobuf:"varint,6,opt,name=shell,def=1" json:"shell,omitempty"`
	Value     *string  `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	Arguments []string `protobuf:"bytes,7,rep,name=arguments" json:"arguments,omitempty"`
	// Enables executor and tasks to run as a specific user. If the user
	// field is present both in FrameworkInfo and here, the CommandInfo
	// user value takes precedence.
	User             *string `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CommandInfo) Reset()      { *m = CommandInfo{} }
func (*CommandInfo) ProtoMessage() {}

const Default_CommandInfo_Shell bool = true

func (m *CommandInfo) GetContainer() *CommandInfo_ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *CommandInfo) GetUris() []*CommandInfo_URI {
	if m != nil {
		return m.Uris
	}
	return nil
}

func (m *CommandInfo) GetEnvironment() *Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *CommandInfo) GetShell() bool {
	if m != nil && m.Shell != nil {
		return *m.Shell
	}
	return Default_CommandInfo_Shell
}

func (m *CommandInfo) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *CommandInfo) GetArguments() []string {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *CommandInfo) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

type CommandInfo_URI struct {
	Value      *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	Executable *bool   `protobuf:"varint,2,opt,name=executable" json:"executable,omitempty"`
	// In case the fetched file is recognized as an archive, extract
	// its contents into the sandbox. Note that a cached archive is
	// not copied from the cache to the sandbox in case extraction
	// originates from an archive in the cache.
	Extract *bool `protobuf:"varint,3,opt,name=extract,def=1" json:"extract,omitempty"`
	// If this field is "true", the fetcher cache will be used. If not,
	// fetching bypasses the cache and downloads directly into the
	// sandbox directory, no matter whether a suitable cache file is
	// available or not. The former directs the fetcher to download to
	// the file cache, then copy from there to the sandbox. Subsequent
	// fetch attempts with the same URI will omit downloading and copy
	// from the cache as long as the file is resident there. Cache files
	// may get evicted at any time, which then leads to renewed
	// downloading. See also "docs/fetcher.md" and
	// "docs/fetcher-cache-internals.md".
	Cache            *bool  `protobuf:"varint,4,opt,name=cache" json:"cache,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *CommandInfo_URI) Reset()      { *m = CommandInfo_URI{} }
func (*CommandInfo_URI) ProtoMessage() {}

const Default_CommandInfo_URI_Extract bool = true

func (m *CommandInfo_URI) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *CommandInfo_URI) GetExecutable() bool {
	if m != nil && m.Executable != nil {
		return *m.Executable
	}
	return false
}

func (m *CommandInfo_URI) GetExtract() bool {
	if m != nil && m.Extract != nil {
		return *m.Extract
	}
	return Default_CommandInfo_URI_Extract
}

func (m *CommandInfo_URI) GetCache() bool {
	if m != nil && m.Cache != nil {
		return *m.Cache
	}
	return false
}

// Describes a container.
// Not all containerizers currently implement ContainerInfo, so it
// is possible that a launched task will fail due to supplying this
// attribute.
// NOTE: The containerizer API is currently in an early beta or
// even alpha state. Some details, like the exact semantics of an
// "image" or "options" are not yet hardened.
// TODO(tillt): Describe the exact scheme and semantics of "image"
// and "options".
type CommandInfo_ContainerInfo struct {
	// URI describing the container image name.
	Image *string `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	// Describes additional options passed to the containerizer.
	Options          []string `protobuf:"bytes,2,rep,name=options" json:"options,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *CommandInfo_ContainerInfo) Reset()      { *m = CommandInfo_ContainerInfo{} }
func (*CommandInfo_ContainerInfo) ProtoMessage() {}

func (m *CommandInfo_ContainerInfo) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *CommandInfo_ContainerInfo) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

// *
// Describes information about an executor. The 'data' field can be
// used to pass arbitrary bytes to an executor.
type ExecutorInfo struct {
	ExecutorId  *ExecutorID  `protobuf:"bytes,1,req,name=executor_id" json:"executor_id,omitempty"`
	FrameworkId *FrameworkID `protobuf:"bytes,8,opt,name=framework_id" json:"framework_id,omitempty"`
	Command     *CommandInfo `protobuf:"bytes,7,req,name=command" json:"command,omitempty"`
	// Executor provided with a container will launch the container
	// with the executor's CommandInfo and we expect the container to
	// act as a Mesos executor.
	Container *ContainerInfo `protobuf:"bytes,11,opt,name=container" json:"container,omitempty"`
	Resources []*Resource    `protobuf:"bytes,5,rep,name=resources" json:"resources,omitempty"`
	Name      *string        `protobuf:"bytes,9,opt,name=name" json:"name,omitempty"`
	// Source is an identifier style string used by frameworks to track
	// the source of an executor. This is useful when it's possible for
	// different executor ids to be related semantically.
	// NOTE: Source is exposed alongside the resource usage of the
	// executor via JSON on the slave. This allows users to import
	// usage information into a time series database for monitoring.
	Source *string `protobuf:"bytes,10,opt,name=source" json:"source,omitempty"`
	Data   []byte  `protobuf:"bytes,4,opt,name=data" json:"data,omitempty"`
	// Service discovery information for the executor. It is not
	// interpreted or acted upon by Mesos. It is up to a service
	// discovery system to use this information as needed and to handle
	// executors without service discovery information.
	Discovery        *DiscoveryInfo `protobuf:"bytes,12,opt,name=discovery" json:"discovery,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ExecutorInfo) Reset()      { *m = ExecutorInfo{} }
func (*ExecutorInfo) ProtoMessage() {}

func (m *ExecutorInfo) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *ExecutorInfo) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *ExecutorInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ExecutorInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *ExecutorInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *ExecutorInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *ExecutorInfo) GetSource() string {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return ""
}

func (m *ExecutorInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ExecutorInfo) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

// *
// Describes a master. This will probably have more fields in the
// future which might be used, for example, to link a framework webui
// to a master webui.
type MasterInfo struct {
	Id *string `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	// The IP address (only IPv4) as a packed 4-bytes integer,
	// stored in network order.  Deprecated, use `address.ip` instead.
	Ip *uint32 `protobuf:"varint,2,req,name=ip" json:"ip,omitempty"`
	// The TCP port the Master is listening on for incoming
	// HTTP requests; deprecated, use `address.port` instead.
	Port *uint32 `protobuf:"varint,3,req,name=port,def=5050" json:"port,omitempty"`
	// In the default implementation, this will contain information
	// about both the IP address, port and Master name; it should really
	// not be relied upon by external tooling/frameworks and be
	// considered an "internal" implementation field.
	Pid *string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	// The server's hostname, if available; it may be unreliable
	// in environments where the DNS configuration does not resolve
	// internal hostnames (eg, some public cloud providers).
	// Deprecated, use `address.hostname` instead.
	Hostname *string `protobuf:"bytes,5,opt,name=hostname" json:"hostname,omitempty"`
	// The running Master version, as a string; taken from the
	// generated "master/version.hpp".
	Version *string `protobuf:"bytes,6,opt,name=version" json:"version,omitempty"`
	// The full IP address (supports both IPv4 and IPv6 formats)
	// and supersedes the use of `ip`, `port` and `hostname`.
	// Since Mesos 0.24.
	Address          *Address `protobuf:"bytes,7,opt,name=address" json:"address,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *MasterInfo) Reset()      { *m = MasterInfo{} }
func (*MasterInfo) ProtoMessage() {}

const Default_MasterInfo_Port uint32 = 5050

func (m *MasterInfo) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *MasterInfo) GetIp() uint32 {
	if m != nil && m.Ip != nil {
		return *m.Ip
	}
	return 0
}

func (m *MasterInfo) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_MasterInfo_Port
}

func (m *MasterInfo) GetPid() string {
	if m != nil && m.Pid != nil {
		return *m.Pid
	}
	return ""
}

func (m *MasterInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *MasterInfo) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *MasterInfo) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

// *
// Describes a slave. Note that the 'id' field is only available after
// a slave is registered with the master, and is made available here
// to facilitate re-registration.  If checkpoint is set, the slave is
// checkpointing its own information and potentially frameworks'
// information (if a framework has checkpointing enabled).
type SlaveInfo struct {
	Hostname   *string      `protobuf:"bytes,1,req,name=hostname" json:"hostname,omitempty"`
	Port       *int32       `protobuf:"varint,8,opt,name=port,def=5051" json:"port,omitempty"`
	Resources  []*Resource  `protobuf:"bytes,3,rep,name=resources" json:"resources,omitempty"`
	Attributes []*Attribute `protobuf:"bytes,5,rep,name=attributes" json:"attributes,omitempty"`
	Id         *SlaveID     `protobuf:"bytes,6,opt,name=id" json:"id,omitempty"`
	// TODO(joerg84): Remove checkpoint field as with 0.22.0
	// slave checkpointing is enabled for all slaves (MESOS-2317).
	Checkpoint       *bool  `protobuf:"varint,7,opt,name=checkpoint,def=0" json:"checkpoint,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *SlaveInfo) Reset()      { *m = SlaveInfo{} }
func (*SlaveInfo) ProtoMessage() {}

const Default_SlaveInfo_Port int32 = 5051
const Default_SlaveInfo_Checkpoint bool = false

func (m *SlaveInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *SlaveInfo) GetPort() int32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return Default_SlaveInfo_Port
}

func (m *SlaveInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *SlaveInfo) GetAttributes() []*Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *SlaveInfo) GetId() *SlaveID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *SlaveInfo) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return Default_SlaveInfo_Checkpoint
}

// *
// Describes an Attribute or Resource "value". A value is described
// using the standard protocol buffer "union" trick.
type Value struct {
	Type             *Value_Type   `protobuf:"varint,1,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar           *Value_Scalar `protobuf:"bytes,2,opt,name=scalar" json:"scalar,omitempty"`
	Ranges           *Value_Ranges `protobuf:"bytes,3,opt,name=ranges" json:"ranges,omitempty"`
	Set              *Value_Set    `protobuf:"bytes,4,opt,name=set" json:"set,omitempty"`
	Text             *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Value) Reset()      { *m = Value{} }
func (*Value) ProtoMessage() {}

func (m *Value) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Value) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Value) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Value) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Value) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

type Value_Scalar struct {
	Value            *float64 `protobuf:"fixed64,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Value_Scalar) Reset()      { *m = Value_Scalar{} }
func (*Value_Scalar) ProtoMessage() {}

func (m *Value_Scalar) GetValue() float64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

type Value_Range struct {
	Begin            *uint64 `protobuf:"varint,1,req,name=begin" json:"begin,omitempty"`
	End              *uint64 `protobuf:"varint,2,req,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Value_Range) Reset()      { *m = Value_Range{} }
func (*Value_Range) ProtoMessage() {}

func (m *Value_Range) GetBegin() uint64 {
	if m != nil && m.Begin != nil {
		return *m.Begin
	}
	return 0
}

func (m *Value_Range) GetEnd() uint64 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

type Value_Ranges struct {
	Range            []*Value_Range `protobuf:"bytes,1,rep,name=range" json:"range,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Value_Ranges) Reset()      { *m = Value_Ranges{} }
func (*Value_Ranges) ProtoMessage() {}

func (m *Value_Ranges) GetRange() []*Value_Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type Value_Set struct {
	Item             []string `protobuf:"bytes,1,rep,name=item" json:"item,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Value_Set) Reset()      { *m = Value_Set{} }
func (*Value_Set) ProtoMessage() {}

func (m *Value_Set) GetItem() []string {
	if m != nil {
		return m.Item
	}
	return nil
}

type Value_Text struct {
	Value            *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Value_Text) Reset()      { *m = Value_Text{} }
func (*Value_Text) ProtoMessage() {}

func (m *Value_Text) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Describes an attribute that can be set on a machine. For now,
// attributes and resources share the same "value" type, but this may
// change in the future and attributes may only be string based.
type Attribute struct {
	Name             *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *Value_Type   `protobuf:"varint,2,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar           *Value_Scalar `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges           *Value_Ranges `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set              *Value_Set    `protobuf:"bytes,6,opt,name=set" json:"set,omitempty"`
	Text             *Value_Text   `protobuf:"bytes,5,opt,name=text" json:"text,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Attribute) Reset()      { *m = Attribute{} }
func (*Attribute) ProtoMessage() {}

func (m *Attribute) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Attribute) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Attribute) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Attribute) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Attribute) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Attribute) GetText() *Value_Text {
	if m != nil {
		return m.Text
	}
	return nil
}

// *
// Describes a resource on a machine. A resource can take on one of
// three types: scalar (double), a list of finite and discrete ranges
// (e.g., [1-10, 20-30]), or a set of items. A resource is described
// using the standard protocol buffer "union" trick.
//
// TODO(benh): Add better support for "expected" resources (e.g.,
// cpus, memory, disk, network).
type Resource struct {
	Name   *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type   *Value_Type   `protobuf:"varint,2,req,name=type,enum=mesosproto.Value_Type" json:"type,omitempty"`
	Scalar *Value_Scalar `protobuf:"bytes,3,opt,name=scalar" json:"scalar,omitempty"`
	Ranges *Value_Ranges `protobuf:"bytes,4,opt,name=ranges" json:"ranges,omitempty"`
	Set    *Value_Set    `protobuf:"bytes,5,opt,name=set" json:"set,omitempty"`
	Role   *string       `protobuf:"bytes,6,opt,name=role,def=*" json:"role,omitempty"`
	// If this is set, this resource was dynamically reserved by an
	// operator or a framework. Otherwise, this resource is either unreserved
	// or statically reserved by an operator via the --resources flag.
	Reservation *Resource_ReservationInfo `protobuf:"bytes,8,opt,name=reservation" json:"reservation,omitempty"`
	Disk        *Resource_DiskInfo        `protobuf:"bytes,7,opt,name=disk" json:"disk,omitempty"`
	// If this is set, the resources are revocable, i.e., any tasks or
	// executors launched using these resources could get preempted or
	// throttled at any time. This could be used by frameworks to run
	// best effort tasks that do not need strict uptime or performance
	// guarantees. Note that if this is set, 'disk' or 'reservation'
	// cannot be set.
	Revocable        *Resource_RevocableInfo `protobuf:"bytes,9,opt,name=revocable" json:"revocable,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *Resource) Reset()      { *m = Resource{} }
func (*Resource) ProtoMessage() {}

const Default_Resource_Role string = "*"

func (m *Resource) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Resource) GetType() Value_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Value_SCALAR
}

func (m *Resource) GetScalar() *Value_Scalar {
	if m != nil {
		return m.Scalar
	}
	return nil
}

func (m *Resource) GetRanges() *Value_Ranges {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *Resource) GetSet() *Value_Set {
	if m != nil {
		return m.Set
	}
	return nil
}

func (m *Resource) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return Default_Resource_Role
}

func (m *Resource) GetReservation() *Resource_ReservationInfo {
	if m != nil {
		return m.Reservation
	}
	return nil
}

func (m *Resource) GetDisk() *Resource_DiskInfo {
	if m != nil {
		return m.Disk
	}
	return nil
}

func (m *Resource) GetRevocable() *Resource_RevocableInfo {
	if m != nil {
		return m.Revocable
	}
	return nil
}

type Resource_ReservationInfo struct {
	// This field indicates the principal of the operator or framework
	// that reserved this resource. It is used in conjunction with the
	// "unreserve" ACL to determine whether the entity attempting to
	// unreserve this resource is permitted to do so.
	// NOTE: This field should match the FrameworkInfo.principal of
	// the framework that reserved this resource.
	Principal        *string `protobuf:"bytes,1,req,name=principal" json:"principal,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Resource_ReservationInfo) Reset()      { *m = Resource_ReservationInfo{} }
func (*Resource_ReservationInfo) ProtoMessage() {}

func (m *Resource_ReservationInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

type Resource_DiskInfo struct {
	Persistence *Resource_DiskInfo_Persistence `protobuf:"bytes,1,opt,name=persistence" json:"persistence,omitempty"`
	// Describes how this disk resource will be mounted in the
	// container. If not set, the disk resource will be used as the
	// sandbox. Otherwise, it will be mounted according to the
	// 'container_path' inside 'volume'. The 'host_path' inside
	// 'volume' is ignored.
	// NOTE: If 'volume' is set but 'persistence' is not set, the
	// volume will be automatically garbage collected after
	// task/executor terminates. Currently, if 'persistence' is set,
	// 'volume' must be set.
	Volume           *Volume `protobuf:"bytes,2,opt,name=volume" json:"volume,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Resource_DiskInfo) Reset()      { *m = Resource_DiskInfo{} }
func (*Resource_DiskInfo) ProtoMessage() {}

func (m *Resource_DiskInfo) GetPersistence() *Resource_DiskInfo_Persistence {
	if m != nil {
		return m.Persistence
	}
	return nil
}

func (m *Resource_DiskInfo) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

// Describes a persistent disk volume.
// A persistent disk volume will not be automatically garbage
// collected if the task/executor/slave terminates, but is
// re-offered to the framework(s) belonging to the 'role'.
// A framework can set the ID (if it is not set yet) to express
// the intention to create a new persistent disk volume from a
// regular disk resource. To reuse a previously created volume, a
// framework can launch a task/executor when it receives an offer
// with a persistent volume, i.e., ID is set.
// NOTE: Currently, we do not allow a persistent disk volume
// without a reservation (i.e., 'role' should not be '*').
type Resource_DiskInfo_Persistence struct {
	// A unique ID for the persistent disk volume.
	// NOTE: The ID needs to be unique per role on each slave.
	Id               *string `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Resource_DiskInfo_Persistence) Reset()      { *m = Resource_DiskInfo_Persistence{} }
func (*Resource_DiskInfo_Persistence) ProtoMessage() {}

func (m *Resource_DiskInfo_Persistence) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

type Resource_RevocableInfo struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *Resource_RevocableInfo) Reset()      { *m = Resource_RevocableInfo{} }
func (*Resource_RevocableInfo) ProtoMessage() {}

// *
// When the network bandwidth caps are enabled and the container
// is over its limit, outbound packets may be either delayed or
// dropped completely either because it exceeds the maximum bandwidth
// allocation for a single container (the cap) or because the combined
// network traffic of multiple containers on the host exceeds the
// transmit capacity of the host (the share). We can report the
// following statistics for each of these conditions exported directly
// from the Linux Traffic Control Queueing Discipline.
//
// id         : name of the limiter, e.g. 'tx_bw_cap'
// backlog    : number of packets currently delayed
// bytes      : total bytes seen
// drops      : number of packets dropped in total
// overlimits : number of packets which exceeded allocation
// packets    : total packets seen
// qlen       : number of packets currently queued
// rate_bps   : throughput in bytes/sec
// rate_pps   : throughput in packets/sec
// requeues   : number of times a packet has been delayed due to
//              locking or device contention issues
//
// More information on the operation of Linux Traffic Control can be
// found at http://www.lartc.org/lartc.html.
type TrafficControlStatistics struct {
	Id               *string `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	Backlog          *uint64 `protobuf:"varint,2,opt,name=backlog" json:"backlog,omitempty"`
	Bytes            *uint64 `protobuf:"varint,3,opt,name=bytes" json:"bytes,omitempty"`
	Drops            *uint64 `protobuf:"varint,4,opt,name=drops" json:"drops,omitempty"`
	Overlimits       *uint64 `protobuf:"varint,5,opt,name=overlimits" json:"overlimits,omitempty"`
	Packets          *uint64 `protobuf:"varint,6,opt,name=packets" json:"packets,omitempty"`
	Qlen             *uint64 `protobuf:"varint,7,opt,name=qlen" json:"qlen,omitempty"`
	Ratebps          *uint64 `protobuf:"varint,8,opt,name=ratebps" json:"ratebps,omitempty"`
	Ratepps          *uint64 `protobuf:"varint,9,opt,name=ratepps" json:"ratepps,omitempty"`
	Requeues         *uint64 `protobuf:"varint,10,opt,name=requeues" json:"requeues,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TrafficControlStatistics) Reset()      { *m = TrafficControlStatistics{} }
func (*TrafficControlStatistics) ProtoMessage() {}

func (m *TrafficControlStatistics) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *TrafficControlStatistics) GetBacklog() uint64 {
	if m != nil && m.Backlog != nil {
		return *m.Backlog
	}
	return 0
}

func (m *TrafficControlStatistics) GetBytes() uint64 {
	if m != nil && m.Bytes != nil {
		return *m.Bytes
	}
	return 0
}

func (m *TrafficControlStatistics) GetDrops() uint64 {
	if m != nil && m.Drops != nil {
		return *m.Drops
	}
	return 0
}

func (m *TrafficControlStatistics) GetOverlimits() uint64 {
	if m != nil && m.Overlimits != nil {
		return *m.Overlimits
	}
	return 0
}

func (m *TrafficControlStatistics) GetPackets() uint64 {
	if m != nil && m.Packets != nil {
		return *m.Packets
	}
	return 0
}

func (m *TrafficControlStatistics) GetQlen() uint64 {
	if m != nil && m.Qlen != nil {
		return *m.Qlen
	}
	return 0
}

func (m *TrafficControlStatistics) GetRatebps() uint64 {
	if m != nil && m.Ratebps != nil {
		return *m.Ratebps
	}
	return 0
}

func (m *TrafficControlStatistics) GetRatepps() uint64 {
	if m != nil && m.Ratepps != nil {
		return *m.Ratepps
	}
	return 0
}

func (m *TrafficControlStatistics) GetRequeues() uint64 {
	if m != nil && m.Requeues != nil {
		return *m.Requeues
	}
	return 0
}

// *
// A snapshot of resource usage statistics.
type ResourceStatistics struct {
	Timestamp *float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp,omitempty"`
	Processes *uint32  `protobuf:"varint,30,opt,name=processes" json:"processes,omitempty"`
	Threads   *uint32  `protobuf:"varint,31,opt,name=threads" json:"threads,omitempty"`
	// CPU Usage Information:
	// Total CPU time spent in user mode, and kernel mode.
	CpusUserTimeSecs   *float64 `protobuf:"fixed64,2,opt,name=cpus_user_time_secs" json:"cpus_user_time_secs,omitempty"`
	CpusSystemTimeSecs *float64 `protobuf:"fixed64,3,opt,name=cpus_system_time_secs" json:"cpus_system_time_secs,omitempty"`
	// Number of CPUs allocated.
	CpusLimit *float64 `protobuf:"fixed64,4,opt,name=cpus_limit" json:"cpus_limit,omitempty"`
	// cpu.stat on process throttling (for contention issues).
	CpusNrPeriods         *uint32  `protobuf:"varint,7,opt,name=cpus_nr_periods" json:"cpus_nr_periods,omitempty"`
	CpusNrThrottled       *uint32  `protobuf:"varint,8,opt,name=cpus_nr_throttled" json:"cpus_nr_throttled,omitempty"`
	CpusThrottledTimeSecs *float64 `protobuf:"fixed64,9,opt,name=cpus_throttled_time_secs" json:"cpus_throttled_time_secs,omitempty"`
	// mem_total_bytes was added in 0.23.0 to represent the total memory
	// of a process in RAM (as opposed to in Swap). This was previously
	// reported as mem_rss_bytes, which was also changed in 0.23.0 to
	// represent only the anonymous memory usage, to keep in sync with
	// Linux kernel's (arguably erroneous) use of terminology.
	MemTotalBytes *uint64 `protobuf:"varint,36,opt,name=mem_total_bytes" json:"mem_total_bytes,omitempty"`
	// Total memory + swap usage. This is set if swap is enabled.
	MemTotalMemswBytes *uint64 `protobuf:"varint,37,opt,name=mem_total_memsw_bytes" json:"mem_total_memsw_bytes,omitempty"`
	// Hard memory limit for a container.
	MemLimitBytes *uint64 `protobuf:"varint,6,opt,name=mem_limit_bytes" json:"mem_limit_bytes,omitempty"`
	// Soft memory limit for a container.
	MemSoftLimitBytes *uint64 `protobuf:"varint,38,opt,name=mem_soft_limit_bytes" json:"mem_soft_limit_bytes,omitempty"`
	// TODO(chzhcn) mem_file_bytes and mem_anon_bytes are deprecated in
	// 0.23.0 and will be removed in 0.24.0.
	MemFileBytes *uint64 `protobuf:"varint,10,opt,name=mem_file_bytes" json:"mem_file_bytes,omitempty"`
	MemAnonBytes *uint64 `protobuf:"varint,11,opt,name=mem_anon_bytes" json:"mem_anon_bytes,omitempty"`
	// mem_cache_bytes is added in 0.23.0 to represent page cache usage.
	MemCacheBytes *uint64 `protobuf:"varint,39,opt,name=mem_cache_bytes" json:"mem_cache_bytes,omitempty"`
	// Since 0.23.0, mem_rss_bytes is changed to represent only
	// anonymous memory usage. Note that neither its requiredness, type,
	// name nor numeric tag has been changed.
	MemRssBytes        *uint64 `protobuf:"varint,5,opt,name=mem_rss_bytes" json:"mem_rss_bytes,omitempty"`
	MemMappedFileBytes *uint64 `protobuf:"varint,12,opt,name=mem_mapped_file_bytes" json:"mem_mapped_file_bytes,omitempty"`
	// This is only set if swap is enabled.
	MemSwapBytes        *uint64 `protobuf:"varint,40,opt,name=mem_swap_bytes" json:"mem_swap_bytes,omitempty"`
	MemUnevictableBytes *uint64 `protobuf:"varint,41,opt,name=mem_unevictable_bytes" json:"mem_unevictable_bytes,omitempty"`
	// Number of occurrences of different levels of memory pressure
	// events reported by memory cgroup. Pressure listening (re)starts
	// with these values set to 0 when slave (re)starts. See
	// https://www.kernel.org/doc/Documentation/cgroups/memory.txt for
	// more details.
	MemLowPressureCounter      *uint64 `protobuf:"varint,32,opt,name=mem_low_pressure_counter" json:"mem_low_pressure_counter,omitempty"`
	MemMediumPressureCounter   *uint64 `protobuf:"varint,33,opt,name=mem_medium_pressure_counter" json:"mem_medium_pressure_counter,omitempty"`
	MemCriticalPressureCounter *uint64 `protobuf:"varint,34,opt,name=mem_critical_pressure_counter" json:"mem_critical_pressure_counter,omitempty"`
	// Disk Usage Information for executor working directory.
	DiskLimitBytes *uint64 `protobuf:"varint,26,opt,name=disk_limit_bytes" json:"disk_limit_bytes,omitempty"`
	DiskUsedBytes  *uint64 `protobuf:"varint,27,opt,name=disk_used_bytes" json:"disk_used_bytes,omitempty"`
	// Perf statistics.
	Perf *PerfStatistics `protobuf:"bytes,13,opt,name=perf" json:"perf,omitempty"`
	// Network Usage Information:
	NetRxPackets *uint64 `protobuf:"varint,14,opt,name=net_rx_packets" json:"net_rx_packets,omitempty"`
	NetRxBytes   *uint64 `protobuf:"varint,15,opt,name=net_rx_bytes" json:"net_rx_bytes,omitempty"`
	NetRxErrors  *uint64 `protobuf:"varint,16,opt,name=net_rx_errors" json:"net_rx_errors,omitempty"`
	NetRxDropped *uint64 `protobuf:"varint,17,opt,name=net_rx_dropped" json:"net_rx_dropped,omitempty"`
	NetTxPackets *uint64 `protobuf:"varint,18,opt,name=net_tx_packets" json:"net_tx_packets,omitempty"`
	NetTxBytes   *uint64 `protobuf:"varint,19,opt,name=net_tx_bytes" json:"net_tx_bytes,omitempty"`
	NetTxErrors  *uint64 `protobuf:"varint,20,opt,name=net_tx_errors" json:"net_tx_errors,omitempty"`
	NetTxDropped *uint64 `protobuf:"varint,21,opt,name=net_tx_dropped" json:"net_tx_dropped,omitempty"`
	// The kernel keeps track of RTT (round-trip time) for its TCP
	// sockets. RTT is a way to tell the latency of a container.
	NetTcpRttMicrosecsP50     *float64 `protobuf:"fixed64,22,opt,name=net_tcp_rtt_microsecs_p50" json:"net_tcp_rtt_microsecs_p50,omitempty"`
	NetTcpRttMicrosecsP90     *float64 `protobuf:"fixed64,23,opt,name=net_tcp_rtt_microsecs_p90" json:"net_tcp_rtt_microsecs_p90,omitempty"`
	NetTcpRttMicrosecsP95     *float64 `protobuf:"fixed64,24,opt,name=net_tcp_rtt_microsecs_p95" json:"net_tcp_rtt_microsecs_p95,omitempty"`
	NetTcpRttMicrosecsP99     *float64 `protobuf:"fixed64,25,opt,name=net_tcp_rtt_microsecs_p99" json:"net_tcp_rtt_microsecs_p99,omitempty"`
	NetTcpActiveConnections   *float64 `protobuf:"fixed64,28,opt,name=net_tcp_active_connections" json:"net_tcp_active_connections,omitempty"`
	NetTcpTimeWaitConnections *float64 `protobuf:"fixed64,29,opt,name=net_tcp_time_wait_connections" json:"net_tcp_time_wait_connections,omitempty"`
	// Network traffic flowing into or out of a container can be delayed
	// or dropped due to congestion or policy inside and outside the
	// container.
	NetTrafficControlStatistics []*TrafficControlStatistics `protobuf:"bytes,35,rep,name=net_traffic_control_statistics" json:"net_traffic_control_statistics,omitempty"`
	XXX_unrecognized            []byte                      `json:"-"`
}

func (m *ResourceStatistics) Reset()      { *m = ResourceStatistics{} }
func (*ResourceStatistics) ProtoMessage() {}

func (m *ResourceStatistics) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *ResourceStatistics) GetProcesses() uint32 {
	if m != nil && m.Processes != nil {
		return *m.Processes
	}
	return 0
}

func (m *ResourceStatistics) GetThreads() uint32 {
	if m != nil && m.Threads != nil {
		return *m.Threads
	}
	return 0
}

func (m *ResourceStatistics) GetCpusUserTimeSecs() float64 {
	if m != nil && m.CpusUserTimeSecs != nil {
		return *m.CpusUserTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCpusSystemTimeSecs() float64 {
	if m != nil && m.CpusSystemTimeSecs != nil {
		return *m.CpusSystemTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetCpusLimit() float64 {
	if m != nil && m.CpusLimit != nil {
		return *m.CpusLimit
	}
	return 0
}

func (m *ResourceStatistics) GetCpusNrPeriods() uint32 {
	if m != nil && m.CpusNrPeriods != nil {
		return *m.CpusNrPeriods
	}
	return 0
}

func (m *ResourceStatistics) GetCpusNrThrottled() uint32 {
	if m != nil && m.CpusNrThrottled != nil {
		return *m.CpusNrThrottled
	}
	return 0
}

func (m *ResourceStatistics) GetCpusThrottledTimeSecs() float64 {
	if m != nil && m.CpusThrottledTimeSecs != nil {
		return *m.CpusThrottledTimeSecs
	}
	return 0
}

func (m *ResourceStatistics) GetMemTotalBytes() uint64 {
	if m != nil && m.MemTotalBytes != nil {
		return *m.MemTotalBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemTotalMemswBytes() uint64 {
	if m != nil && m.MemTotalMemswBytes != nil {
		return *m.MemTotalMemswBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemLimitBytes() uint64 {
	if m != nil && m.MemLimitBytes != nil {
		return *m.MemLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemSoftLimitBytes() uint64 {
	if m != nil && m.MemSoftLimitBytes != nil {
		return *m.MemSoftLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemFileBytes() uint64 {
	if m != nil && m.MemFileBytes != nil {
		return *m.MemFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemAnonBytes() uint64 {
	if m != nil && m.MemAnonBytes != nil {
		return *m.MemAnonBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemCacheBytes() uint64 {
	if m != nil && m.MemCacheBytes != nil {
		return *m.MemCacheBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemRssBytes() uint64 {
	if m != nil && m.MemRssBytes != nil {
		return *m.MemRssBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemMappedFileBytes() uint64 {
	if m != nil && m.MemMappedFileBytes != nil {
		return *m.MemMappedFileBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemSwapBytes() uint64 {
	if m != nil && m.MemSwapBytes != nil {
		return *m.MemSwapBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemUnevictableBytes() uint64 {
	if m != nil && m.MemUnevictableBytes != nil {
		return *m.MemUnevictableBytes
	}
	return 0
}

func (m *ResourceStatistics) GetMemLowPressureCounter() uint64 {
	if m != nil && m.MemLowPressureCounter != nil {
		return *m.MemLowPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetMemMediumPressureCounter() uint64 {
	if m != nil && m.MemMediumPressureCounter != nil {
		return *m.MemMediumPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetMemCriticalPressureCounter() uint64 {
	if m != nil && m.MemCriticalPressureCounter != nil {
		return *m.MemCriticalPressureCounter
	}
	return 0
}

func (m *ResourceStatistics) GetDiskLimitBytes() uint64 {
	if m != nil && m.DiskLimitBytes != nil {
		return *m.DiskLimitBytes
	}
	return 0
}

func (m *ResourceStatistics) GetDiskUsedBytes() uint64 {
	if m != nil && m.DiskUsedBytes != nil {
		return *m.DiskUsedBytes
	}
	return 0
}

func (m *ResourceStatistics) GetPerf() *PerfStatistics {
	if m != nil {
		return m.Perf
	}
	return nil
}

func (m *ResourceStatistics) GetNetRxPackets() uint64 {
	if m != nil && m.NetRxPackets != nil {
		return *m.NetRxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxBytes() uint64 {
	if m != nil && m.NetRxBytes != nil {
		return *m.NetRxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxErrors() uint64 {
	if m != nil && m.NetRxErrors != nil {
		return *m.NetRxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetRxDropped() uint64 {
	if m != nil && m.NetRxDropped != nil {
		return *m.NetRxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxPackets() uint64 {
	if m != nil && m.NetTxPackets != nil {
		return *m.NetTxPackets
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxBytes() uint64 {
	if m != nil && m.NetTxBytes != nil {
		return *m.NetTxBytes
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxErrors() uint64 {
	if m != nil && m.NetTxErrors != nil {
		return *m.NetTxErrors
	}
	return 0
}

func (m *ResourceStatistics) GetNetTxDropped() uint64 {
	if m != nil && m.NetTxDropped != nil {
		return *m.NetTxDropped
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP50() float64 {
	if m != nil && m.NetTcpRttMicrosecsP50 != nil {
		return *m.NetTcpRttMicrosecsP50
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP90() float64 {
	if m != nil && m.NetTcpRttMicrosecsP90 != nil {
		return *m.NetTcpRttMicrosecsP90
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP95() float64 {
	if m != nil && m.NetTcpRttMicrosecsP95 != nil {
		return *m.NetTcpRttMicrosecsP95
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpRttMicrosecsP99() float64 {
	if m != nil && m.NetTcpRttMicrosecsP99 != nil {
		return *m.NetTcpRttMicrosecsP99
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpActiveConnections() float64 {
	if m != nil && m.NetTcpActiveConnections != nil {
		return *m.NetTcpActiveConnections
	}
	return 0
}

func (m *ResourceStatistics) GetNetTcpTimeWaitConnections() float64 {
	if m != nil && m.NetTcpTimeWaitConnections != nil {
		return *m.NetTcpTimeWaitConnections
	}
	return 0
}

func (m *ResourceStatistics) GetNetTrafficControlStatistics() []*TrafficControlStatistics {
	if m != nil {
		return m.NetTrafficControlStatistics
	}
	return nil
}

// *
// Describes a snapshot of the resource usage for executors.
type ResourceUsage struct {
	Executors []*ResourceUsage_Executor `protobuf:"bytes,1,rep,name=executors" json:"executors,omitempty"`
	// Slave's total resources including checkpointed dynamic
	// reservations and persistent volumes.
	Total            []*Resource `protobuf:"bytes,2,rep,name=total" json:"total,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *ResourceUsage) Reset()      { *m = ResourceUsage{} }
func (*ResourceUsage) ProtoMessage() {}

func (m *ResourceUsage) GetExecutors() []*ResourceUsage_Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *ResourceUsage) GetTotal() []*Resource {
	if m != nil {
		return m.Total
	}
	return nil
}

type ResourceUsage_Executor struct {
	ExecutorInfo *ExecutorInfo `protobuf:"bytes,1,req,name=executor_info" json:"executor_info,omitempty"`
	// This includes resources used by the executor itself
	// as well as its active tasks.
	Allocated []*Resource `protobuf:"bytes,2,rep,name=allocated" json:"allocated,omitempty"`
	// Current resource usage. If absent, the containerizer
	// cannot provide resource usage.
	Statistics *ResourceStatistics `protobuf:"bytes,3,opt,name=statistics" json:"statistics,omitempty"`
	// The container id for the executor specified in the executor_info field.
	ContainerId      *ContainerID `protobuf:"bytes,4,req,name=container_id" json:"container_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ResourceUsage_Executor) Reset()      { *m = ResourceUsage_Executor{} }
func (*ResourceUsage_Executor) ProtoMessage() {}

func (m *ResourceUsage_Executor) GetExecutorInfo() *ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return nil
}

func (m *ResourceUsage_Executor) GetAllocated() []*Resource {
	if m != nil {
		return m.Allocated
	}
	return nil
}

func (m *ResourceUsage_Executor) GetStatistics() *ResourceStatistics {
	if m != nil {
		return m.Statistics
	}
	return nil
}

func (m *ResourceUsage_Executor) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

// *
// Describes a sample of events from "perf stat". Only available on
// Linux.
//
// NOTE: Each optional field matches the name of a perf event (see
// "perf list") with the following changes:
// 1. Names are downcased.
// 2. Hyphens ('-') are replaced with underscores ('_').
// 3. Events with alternate names use the name "perf stat" returns,
//    e.g., for the event "cycles OR cpu-cycles" perf always returns
//    cycles.
type PerfStatistics struct {
	Timestamp *float64 `protobuf:"fixed64,1,req,name=timestamp" json:"timestamp,omitempty"`
	Duration  *float64 `protobuf:"fixed64,2,req,name=duration" json:"duration,omitempty"`
	// Hardware event.
	Cycles                *uint64 `protobuf:"varint,3,opt,name=cycles" json:"cycles,omitempty"`
	StalledCyclesFrontend *uint64 `protobuf:"varint,4,opt,name=stalled_cycles_frontend" json:"stalled_cycles_frontend,omitempty"`
	StalledCyclesBackend  *uint64 `protobuf:"varint,5,opt,name=stalled_cycles_backend" json:"stalled_cycles_backend,omitempty"`
	Instructions          *uint64 `protobuf:"varint,6,opt,name=instructions" json:"instructions,omitempty"`
	CacheReferences       *uint64 `protobuf:"varint,7,opt,name=cache_references" json:"cache_references,omitempty"`
	CacheMisses           *uint64 `protobuf:"varint,8,opt,name=cache_misses" json:"cache_misses,omitempty"`
	Branches              *uint64 `protobuf:"varint,9,opt,name=branches" json:"branches,omitempty"`
	BranchMisses          *uint64 `protobuf:"varint,10,opt,name=branch_misses" json:"branch_misses,omitempty"`
	BusCycles             *uint64 `protobuf:"varint,11,opt,name=bus_cycles" json:"bus_cycles,omitempty"`
	RefCycles             *uint64 `protobuf:"varint,12,opt,name=ref_cycles" json:"ref_cycles,omitempty"`
	// Software event.
	CpuClock        *float64 `protobuf:"fixed64,13,opt,name=cpu_clock" json:"cpu_clock,omitempty"`
	TaskClock       *float64 `protobuf:"fixed64,14,opt,name=task_clock" json:"task_clock,omitempty"`
	PageFaults      *uint64  `protobuf:"varint,15,opt,name=page_faults" json:"page_faults,omitempty"`
	MinorFaults     *uint64  `protobuf:"varint,16,opt,name=minor_faults" json:"minor_faults,omitempty"`
	MajorFaults     *uint64  `protobuf:"varint,17,opt,name=major_faults" json:"major_faults,omitempty"`
	ContextSwitches *uint64  `protobuf:"varint,18,opt,name=context_switches" json:"context_switches,omitempty"`
	CpuMigrations   *uint64  `protobuf:"varint,19,opt,name=cpu_migrations" json:"cpu_migrations,omitempty"`
	AlignmentFaults *uint64  `protobuf:"varint,20,opt,name=alignment_faults" json:"alignment_faults,omitempty"`
	EmulationFaults *uint64  `protobuf:"varint,21,opt,name=emulation_faults" json:"emulation_faults,omitempty"`
	// Hardware cache event.
	L1DcacheLoads          *uint64 `protobuf:"varint,22,opt,name=l1_dcache_loads" json:"l1_dcache_loads,omitempty"`
	L1DcacheLoadMisses     *uint64 `protobuf:"varint,23,opt,name=l1_dcache_load_misses" json:"l1_dcache_load_misses,omitempty"`
	L1DcacheStores         *uint64 `protobuf:"varint,24,opt,name=l1_dcache_stores" json:"l1_dcache_stores,omitempty"`
	L1DcacheStoreMisses    *uint64 `protobuf:"varint,25,opt,name=l1_dcache_store_misses" json:"l1_dcache_store_misses,omitempty"`
	L1DcachePrefetches     *uint64 `protobuf:"varint,26,opt,name=l1_dcache_prefetches" json:"l1_dcache_prefetches,omitempty"`
	L1DcachePrefetchMisses *uint64 `protobuf:"varint,27,opt,name=l1_dcache_prefetch_misses" json:"l1_dcache_prefetch_misses,omitempty"`
	L1IcacheLoads          *uint64 `protobuf:"varint,28,opt,name=l1_icache_loads" json:"l1_icache_loads,omitempty"`
	L1IcacheLoadMisses     *uint64 `protobuf:"varint,29,opt,name=l1_icache_load_misses" json:"l1_icache_load_misses,omitempty"`
	L1IcachePrefetches     *uint64 `protobuf:"varint,30,opt,name=l1_icache_prefetches" json:"l1_icache_prefetches,omitempty"`
	L1IcachePrefetchMisses *uint64 `protobuf:"varint,31,opt,name=l1_icache_prefetch_misses" json:"l1_icache_prefetch_misses,omitempty"`
	LlcLoads               *uint64 `protobuf:"varint,32,opt,name=llc_loads" json:"llc_loads,omitempty"`
	LlcLoadMisses          *uint64 `protobuf:"varint,33,opt,name=llc_load_misses" json:"llc_load_misses,omitempty"`
	LlcStores              *uint64 `protobuf:"varint,34,opt,name=llc_stores" json:"llc_stores,omitempty"`
	LlcStoreMisses         *uint64 `protobuf:"varint,35,opt,name=llc_store_misses" json:"llc_store_misses,omitempty"`
	LlcPrefetches          *uint64 `protobuf:"varint,36,opt,name=llc_prefetches" json:"llc_prefetches,omitempty"`
	LlcPrefetchMisses      *uint64 `protobuf:"varint,37,opt,name=llc_prefetch_misses" json:"llc_prefetch_misses,omitempty"`
	DtlbLoads              *uint64 `protobuf:"varint,38,opt,name=dtlb_loads" json:"dtlb_loads,omitempty"`
	DtlbLoadMisses         *uint64 `protobuf:"varint,39,opt,name=dtlb_load_misses" json:"dtlb_load_misses,omitempty"`
	DtlbStores             *uint64 `protobuf:"varint,40,opt,name=dtlb_stores" json:"dtlb_stores,omitempty"`
	DtlbStoreMisses        *uint64 `protobuf:"varint,41,opt,name=dtlb_store_misses" json:"dtlb_store_misses,omitempty"`
	DtlbPrefetches         *uint64 `protobuf:"varint,42,opt,name=dtlb_prefetches" json:"dtlb_prefetches,omitempty"`
	DtlbPrefetchMisses     *uint64 `protobuf:"varint,43,opt,name=dtlb_prefetch_misses" json:"dtlb_prefetch_misses,omitempty"`
	ItlbLoads              *uint64 `protobuf:"varint,44,opt,name=itlb_loads" json:"itlb_loads,omitempty"`
	ItlbLoadMisses         *uint64 `protobuf:"varint,45,opt,name=itlb_load_misses" json:"itlb_load_misses,omitempty"`
	BranchLoads            *uint64 `protobuf:"varint,46,opt,name=branch_loads" json:"branch_loads,omitempty"`
	BranchLoadMisses       *uint64 `protobuf:"varint,47,opt,name=branch_load_misses" json:"branch_load_misses,omitempty"`
	NodeLoads              *uint64 `protobuf:"varint,48,opt,name=node_loads" json:"node_loads,omitempty"`
	NodeLoadMisses         *uint64 `protobuf:"varint,49,opt,name=node_load_misses" json:"node_load_misses,omitempty"`
	NodeStores             *uint64 `protobuf:"varint,50,opt,name=node_stores" json:"node_stores,omitempty"`
	NodeStoreMisses        *uint64 `protobuf:"varint,51,opt,name=node_store_misses" json:"node_store_misses,omitempty"`
	NodePrefetches         *uint64 `protobuf:"varint,52,opt,name=node_prefetches" json:"node_prefetches,omitempty"`
	NodePrefetchMisses     *uint64 `protobuf:"varint,53,opt,name=node_prefetch_misses" json:"node_prefetch_misses,omitempty"`
	XXX_unrecognized       []byte  `json:"-"`
}

func (m *PerfStatistics) Reset()      { *m = PerfStatistics{} }
func (*PerfStatistics) ProtoMessage() {}

func (m *PerfStatistics) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *PerfStatistics) GetDuration() float64 {
	if m != nil && m.Duration != nil {
		return *m.Duration
	}
	return 0
}

func (m *PerfStatistics) GetCycles() uint64 {
	if m != nil && m.Cycles != nil {
		return *m.Cycles
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesFrontend() uint64 {
	if m != nil && m.StalledCyclesFrontend != nil {
		return *m.StalledCyclesFrontend
	}
	return 0
}

func (m *PerfStatistics) GetStalledCyclesBackend() uint64 {
	if m != nil && m.StalledCyclesBackend != nil {
		return *m.StalledCyclesBackend
	}
	return 0
}

func (m *PerfStatistics) GetInstructions() uint64 {
	if m != nil && m.Instructions != nil {
		return *m.Instructions
	}
	return 0
}

func (m *PerfStatistics) GetCacheReferences() uint64 {
	if m != nil && m.CacheReferences != nil {
		return *m.CacheReferences
	}
	return 0
}

func (m *PerfStatistics) GetCacheMisses() uint64 {
	if m != nil && m.CacheMisses != nil {
		return *m.CacheMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranches() uint64 {
	if m != nil && m.Branches != nil {
		return *m.Branches
	}
	return 0
}

func (m *PerfStatistics) GetBranchMisses() uint64 {
	if m != nil && m.BranchMisses != nil {
		return *m.BranchMisses
	}
	return 0
}

func (m *PerfStatistics) GetBusCycles() uint64 {
	if m != nil && m.BusCycles != nil {
		return *m.BusCycles
	}
	return 0
}

func (m *PerfStatistics) GetRefCycles() uint64 {
	if m != nil && m.RefCycles != nil {
		return *m.RefCycles
	}
	return 0
}

func (m *PerfStatistics) GetCpuClock() float64 {
	if m != nil && m.CpuClock != nil {
		return *m.CpuClock
	}
	return 0
}

func (m *PerfStatistics) GetTaskClock() float64 {
	if m != nil && m.TaskClock != nil {
		return *m.TaskClock
	}
	return 0
}

func (m *PerfStatistics) GetPageFaults() uint64 {
	if m != nil && m.PageFaults != nil {
		return *m.PageFaults
	}
	return 0
}

func (m *PerfStatistics) GetMinorFaults() uint64 {
	if m != nil && m.MinorFaults != nil {
		return *m.MinorFaults
	}
	return 0
}

func (m *PerfStatistics) GetMajorFaults() uint64 {
	if m != nil && m.MajorFaults != nil {
		return *m.MajorFaults
	}
	return 0
}

func (m *PerfStatistics) GetContextSwitches() uint64 {
	if m != nil && m.ContextSwitches != nil {
		return *m.ContextSwitches
	}
	return 0
}

func (m *PerfStatistics) GetCpuMigrations() uint64 {
	if m != nil && m.CpuMigrations != nil {
		return *m.CpuMigrations
	}
	return 0
}

func (m *PerfStatistics) GetAlignmentFaults() uint64 {
	if m != nil && m.AlignmentFaults != nil {
		return *m.AlignmentFaults
	}
	return 0
}

func (m *PerfStatistics) GetEmulationFaults() uint64 {
	if m != nil && m.EmulationFaults != nil {
		return *m.EmulationFaults
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoads() uint64 {
	if m != nil && m.L1DcacheLoads != nil {
		return *m.L1DcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheLoadMisses() uint64 {
	if m != nil && m.L1DcacheLoadMisses != nil {
		return *m.L1DcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStores() uint64 {
	if m != nil && m.L1DcacheStores != nil {
		return *m.L1DcacheStores
	}
	return 0
}

func (m *PerfStatistics) GetL1DcacheStoreMisses() uint64 {
	if m != nil && m.L1DcacheStoreMisses != nil {
		return *m.L1DcacheStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetches() uint64 {
	if m != nil && m.L1DcachePrefetches != nil {
		return *m.L1DcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1DcachePrefetchMisses() uint64 {
	if m != nil && m.L1DcachePrefetchMisses != nil {
		return *m.L1DcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoads() uint64 {
	if m != nil && m.L1IcacheLoads != nil {
		return *m.L1IcacheLoads
	}
	return 0
}

func (m *PerfStatistics) GetL1IcacheLoadMisses() uint64 {
	if m != nil && m.L1IcacheLoadMisses != nil {
		return *m.L1IcacheLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetches() uint64 {
	if m != nil && m.L1IcachePrefetches != nil {
		return *m.L1IcachePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetL1IcachePrefetchMisses() uint64 {
	if m != nil && m.L1IcachePrefetchMisses != nil {
		return *m.L1IcachePrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcLoads() uint64 {
	if m != nil && m.LlcLoads != nil {
		return *m.LlcLoads
	}
	return 0
}

func (m *PerfStatistics) GetLlcLoadMisses() uint64 {
	if m != nil && m.LlcLoadMisses != nil {
		return *m.LlcLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcStores() uint64 {
	if m != nil && m.LlcStores != nil {
		return *m.LlcStores
	}
	return 0
}

func (m *PerfStatistics) GetLlcStoreMisses() uint64 {
	if m != nil && m.LlcStoreMisses != nil {
		return *m.LlcStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetLlcPrefetches() uint64 {
	if m != nil && m.LlcPrefetches != nil {
		return *m.LlcPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetLlcPrefetchMisses() uint64 {
	if m != nil && m.LlcPrefetchMisses != nil {
		return *m.LlcPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbLoads() uint64 {
	if m != nil && m.DtlbLoads != nil {
		return *m.DtlbLoads
	}
	return 0
}

func (m *PerfStatistics) GetDtlbLoadMisses() uint64 {
	if m != nil && m.DtlbLoadMisses != nil {
		return *m.DtlbLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbStores() uint64 {
	if m != nil && m.DtlbStores != nil {
		return *m.DtlbStores
	}
	return 0
}

func (m *PerfStatistics) GetDtlbStoreMisses() uint64 {
	if m != nil && m.DtlbStoreMisses != nil {
		return *m.DtlbStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetDtlbPrefetches() uint64 {
	if m != nil && m.DtlbPrefetches != nil {
		return *m.DtlbPrefetches
	}
	return 0
}

func (m *PerfStatistics) GetDtlbPrefetchMisses() uint64 {
	if m != nil && m.DtlbPrefetchMisses != nil {
		return *m.DtlbPrefetchMisses
	}
	return 0
}

func (m *PerfStatistics) GetItlbLoads() uint64 {
	if m != nil && m.ItlbLoads != nil {
		return *m.ItlbLoads
	}
	return 0
}

func (m *PerfStatistics) GetItlbLoadMisses() uint64 {
	if m != nil && m.ItlbLoadMisses != nil {
		return *m.ItlbLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoads() uint64 {
	if m != nil && m.BranchLoads != nil {
		return *m.BranchLoads
	}
	return 0
}

func (m *PerfStatistics) GetBranchLoadMisses() uint64 {
	if m != nil && m.BranchLoadMisses != nil {
		return *m.BranchLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoads() uint64 {
	if m != nil && m.NodeLoads != nil {
		return *m.NodeLoads
	}
	return 0
}

func (m *PerfStatistics) GetNodeLoadMisses() uint64 {
	if m != nil && m.NodeLoadMisses != nil {
		return *m.NodeLoadMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodeStores() uint64 {
	if m != nil && m.NodeStores != nil {
		return *m.NodeStores
	}
	return 0
}

func (m *PerfStatistics) GetNodeStoreMisses() uint64 {
	if m != nil && m.NodeStoreMisses != nil {
		return *m.NodeStoreMisses
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetches() uint64 {
	if m != nil && m.NodePrefetches != nil {
		return *m.NodePrefetches
	}
	return 0
}

func (m *PerfStatistics) GetNodePrefetchMisses() uint64 {
	if m != nil && m.NodePrefetchMisses != nil {
		return *m.NodePrefetchMisses
	}
	return 0
}

// *
// Describes a request for resources that can be used by a framework
// to proactively influence the allocator.  If 'slave_id' is provided
// then this request is assumed to only apply to resources on that
// slave.
type Request struct {
	SlaveId          *SlaveID    `protobuf:"bytes,1,opt,name=slave_id" json:"slave_id,omitempty"`
	Resources        []*Resource `protobuf:"bytes,2,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Request) Reset()      { *m = Request{} }
func (*Request) ProtoMessage() {}

func (m *Request) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Request) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes some resources available on a slave. An offer only
// contains resources from a single slave.
type Offer struct {
	Id          *OfferID     `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	FrameworkId *FrameworkID `protobuf:"bytes,2,req,name=framework_id" json:"framework_id,omitempty"`
	SlaveId     *SlaveID     `protobuf:"bytes,3,req,name=slave_id" json:"slave_id,omitempty"`
	Hostname    *string      `protobuf:"bytes,4,req,name=hostname" json:"hostname,omitempty"`
	// URL for reaching the slave running on the host.
	Url         *URL          `protobuf:"bytes,8,opt,name=url" json:"url,omitempty"`
	Resources   []*Resource   `protobuf:"bytes,5,rep,name=resources" json:"resources,omitempty"`
	Attributes  []*Attribute  `protobuf:"bytes,7,rep,name=attributes" json:"attributes,omitempty"`
	ExecutorIds []*ExecutorID `protobuf:"bytes,6,rep,name=executor_ids" json:"executor_ids,omitempty"`
	// Signifies that the resources in this Offer may be unavailable during
	// the given interval.  Any tasks launched using these resources may be
	// killed when the interval arrives.  For example, these resources may be
	// part of a planned maintenance schedule.
	//
	// This field only provides information about a planned unavailability.
	// The unavailability interval may not necessarily start at exactly this
	// interval, nor last for exactly the duration of this interval.
	// The unavailability may also be forever!  See comments in
	// `Unavailability` for more details.
	Unavailability   *Unavailability `protobuf:"bytes,9,opt,name=unavailability" json:"unavailability,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *Offer) Reset()      { *m = Offer{} }
func (*Offer) ProtoMessage() {}

func (m *Offer) GetId() *OfferID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Offer) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *Offer) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Offer) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *Offer) GetUrl() *URL {
	if m != nil {
		return m.Url
	}
	return nil
}

func (m *Offer) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Offer) GetAttributes() []*Attribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Offer) GetExecutorIds() []*ExecutorID {
	if m != nil {
		return m.ExecutorIds
	}
	return nil
}

func (m *Offer) GetUnavailability() *Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return nil
}

// Defines an operation that can be performed against offers.
type Offer_Operation struct {
	Type             *Offer_Operation_Type      `protobuf:"varint,1,req,name=type,enum=mesosproto.Offer_Operation_Type" json:"type,omitempty"`
	Launch           *Offer_Operation_Launch    `protobuf:"bytes,2,opt,name=launch" json:"launch,omitempty"`
	Reserve          *Offer_Operation_Reserve   `protobuf:"bytes,3,opt,name=reserve" json:"reserve,omitempty"`
	Unreserve        *Offer_Operation_Unreserve `protobuf:"bytes,4,opt,name=unreserve" json:"unreserve,omitempty"`
	Create           *Offer_Operation_Create    `protobuf:"bytes,5,opt,name=create" json:"create,omitempty"`
	Destroy          *Offer_Operation_Destroy   `protobuf:"bytes,6,opt,name=destroy" json:"destroy,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *Offer_Operation) Reset()      { *m = Offer_Operation{} }
func (*Offer_Operation) ProtoMessage() {}

func (m *Offer_Operation) GetType() Offer_Operation_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Offer_Operation_LAUNCH
}

func (m *Offer_Operation) GetLaunch() *Offer_Operation_Launch {
	if m != nil {
		return m.Launch
	}
	return nil
}

func (m *Offer_Operation) GetReserve() *Offer_Operation_Reserve {
	if m != nil {
		return m.Reserve
	}
	return nil
}

func (m *Offer_Operation) GetUnreserve() *Offer_Operation_Unreserve {
	if m != nil {
		return m.Unreserve
	}
	return nil
}

func (m *Offer_Operation) GetCreate() *Offer_Operation_Create {
	if m != nil {
		return m.Create
	}
	return nil
}

func (m *Offer_Operation) GetDestroy() *Offer_Operation_Destroy {
	if m != nil {
		return m.Destroy
	}
	return nil
}

type Offer_Operation_Launch struct {
	TaskInfos        []*TaskInfo `protobuf:"bytes,1,rep,name=task_infos" json:"task_infos,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Offer_Operation_Launch) Reset()      { *m = Offer_Operation_Launch{} }
func (*Offer_Operation_Launch) ProtoMessage() {}

func (m *Offer_Operation_Launch) GetTaskInfos() []*TaskInfo {
	if m != nil {
		return m.TaskInfos
	}
	return nil
}

type Offer_Operation_Reserve struct {
	Resources        []*Resource `protobuf:"bytes,1,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Offer_Operation_Reserve) Reset()      { *m = Offer_Operation_Reserve{} }
func (*Offer_Operation_Reserve) ProtoMessage() {}

func (m *Offer_Operation_Reserve) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Offer_Operation_Unreserve struct {
	Resources        []*Resource `protobuf:"bytes,1,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Offer_Operation_Unreserve) Reset()      { *m = Offer_Operation_Unreserve{} }
func (*Offer_Operation_Unreserve) ProtoMessage() {}

func (m *Offer_Operation_Unreserve) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type Offer_Operation_Create struct {
	Volumes          []*Resource `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Offer_Operation_Create) Reset()      { *m = Offer_Operation_Create{} }
func (*Offer_Operation_Create) ProtoMessage() {}

func (m *Offer_Operation_Create) GetVolumes() []*Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

type Offer_Operation_Destroy struct {
	Volumes          []*Resource `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *Offer_Operation_Destroy) Reset()      { *m = Offer_Operation_Destroy{} }
func (*Offer_Operation_Destroy) ProtoMessage() {}

func (m *Offer_Operation_Destroy) GetVolumes() []*Resource {
	if m != nil {
		return m.Volumes
	}
	return nil
}

// *
// A request to return some resources occupied by a framework.
type InverseOffer struct {
	// This is the same OfferID as found in normal offers, which allows
	// re-use of some of the OfferID-only messages.
	Id *OfferID `protobuf:"bytes,1,req,name=id" json:"id,omitempty"`
	// URL for reaching the slave running on the host.  This enables some
	// optimizations as described in MESOS-3012, such as allowing the
	// scheduler driver to bypass the master and talk directly with a slave.
	Url *URL `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	// The framework that should release its resources.
	// If no specifics are provided (i.e. which slave), all the framework's
	// resources are requested back.
	FrameworkId *FrameworkID `protobuf:"bytes,3,req,name=framework_id" json:"framework_id,omitempty"`
	// Specified if the resources need to be released from a particular slave.
	// All the framework's resources on this slave are requested back,
	// unless further qualified by the `resources` field.
	SlaveId *SlaveID `protobuf:"bytes,4,opt,name=slave_id" json:"slave_id,omitempty"`
	// This InverseOffer represents a planned unavailability event in the
	// specified interval.  Any tasks running on the given framework or slave
	// may be killed when the interval arrives.  Therefore, frameworks should
	// aim to gracefully terminate tasks prior to the arrival of the interval.
	//
	// For reserved resources, the resources are expected to be returned to the
	// framework after the unavailability interval.  This is an expectation,
	// not a guarantee.  For example, if the unavailability duration is not set,
	// the resources may be removed permanently.
	//
	// For other resources, there is no guarantee that requested resources will
	// be returned after the unavailability interval.  The allocator has no
	// obligation to re-offer these resources to the prior framework after
	// the unavailability.
	Unavailability *Unavailability `protobuf:"bytes,5,req,name=unavailability" json:"unavailability,omitempty"`
	// A list of resources being requested back from the framework,
	// on the slave identified by `slave_id`.  If no resources are specified
	// then all resources are being requested back.  For the purpose of
	// maintenance, this field is always empty (maintenance always requests
	// all resources back).
	Resources        []*Resource `protobuf:"bytes,6,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *InverseOffer) Reset()      { *m = InverseOffer{} }
func (*InverseOffer) ProtoMessage() {}

func (m *InverseOffer) GetId() *OfferID {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *InverseOffer) GetUrl() *URL {
	if m != nil {
		return m.Url
	}
	return nil
}

func (m *InverseOffer) GetFrameworkId() *FrameworkID {
	if m != nil {
		return m.FrameworkId
	}
	return nil
}

func (m *InverseOffer) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *InverseOffer) GetUnavailability() *Unavailability {
	if m != nil {
		return m.Unavailability
	}
	return nil
}

func (m *InverseOffer) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Describes a task. Passed from the scheduler all the way to an
// executor (see SchedulerDriver::launchTasks and
// Executor::launchTask). Either ExecutorInfo or CommandInfo should be set.
// A different executor can be used to launch this task, and subsequent tasks
// meant for the same executor can reuse the same ExecutorInfo struct.
type TaskInfo struct {
	Name      *string       `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	TaskId    *TaskID       `protobuf:"bytes,2,req,name=task_id" json:"task_id,omitempty"`
	SlaveId   *SlaveID      `protobuf:"bytes,3,req,name=slave_id" json:"slave_id,omitempty"`
	Resources []*Resource   `protobuf:"bytes,4,rep,name=resources" json:"resources,omitempty"`
	Executor  *ExecutorInfo `protobuf:"bytes,5,opt,name=executor" json:"executor,omitempty"`
	Command   *CommandInfo  `protobuf:"bytes,7,opt,name=command" json:"command,omitempty"`
	// Task provided with a container will launch the container as part
	// of this task paired with the task's CommandInfo.
	Container *ContainerInfo `protobuf:"bytes,9,opt,name=container" json:"container,omitempty"`
	Data      []byte         `protobuf:"bytes,6,opt,name=data" json:"data,omitempty"`
	// A health check for the task (currently in *alpha* and initial
	// support will only be for TaskInfo's that have a CommandInfo).
	HealthCheck *HealthCheck `protobuf:"bytes,8,opt,name=health_check" json:"health_check,omitempty"`
	// Labels are free-form key value pairs which are exposed through
	// master and slave endpoints. Labels will not be interpreted or
	// acted upon by Mesos itself. As opposed to the data field, labels
	// will be kept in memory on master and slave processes. Therefore,
	// labels should be used to tag tasks with light-weight meta-data.
	Labels *Labels `protobuf:"bytes,10,opt,name=labels" json:"labels,omitempty"`
	// Service discovery information for the task. It is not interpreted
	// or acted upon by Mesos. It is up to a service discovery system
	// to use this information as needed and to handle tasks without
	// service discovery information.
	Discovery        *DiscoveryInfo `protobuf:"bytes,11,opt,name=discovery" json:"discovery,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *TaskInfo) Reset()      { *m = TaskInfo{} }
func (*TaskInfo) ProtoMessage() {}

func (m *TaskInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *TaskInfo) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *TaskInfo) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *TaskInfo) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *TaskInfo) GetExecutor() *ExecutorInfo {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (m *TaskInfo) GetCommand() *CommandInfo {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *TaskInfo) GetContainer() *ContainerInfo {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *TaskInfo) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskInfo) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *TaskInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TaskInfo) GetDiscovery() *DiscoveryInfo {
	if m != nil {
		return m.Discovery
	}
	return nil
}

// *
// Describes the current status of a task.
type TaskStatus struct {
	TaskId     *TaskID            `protobuf:"bytes,1,req,name=task_id" json:"task_id,omitempty"`
	State      *TaskState         `protobuf:"varint,2,req,name=state,enum=mesosproto.TaskState" json:"state,omitempty"`
	Message    *string            `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	Source     *TaskStatus_Source `protobuf:"varint,9,opt,name=source,enum=mesosproto.TaskStatus_Source" json:"source,omitempty"`
	Reason     *TaskStatus_Reason `protobuf:"varint,10,opt,name=reason,enum=mesosproto.TaskStatus_Reason" json:"reason,omitempty"`
	Data       []byte             `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	SlaveId    *SlaveID           `protobuf:"bytes,5,opt,name=slave_id" json:"slave_id,omitempty"`
	ExecutorId *ExecutorID        `protobuf:"bytes,7,opt,name=executor_id" json:"executor_id,omitempty"`
	Timestamp  *float64           `protobuf:"fixed64,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// Statuses that are delivered reliably to the scheduler will
	// include a 'uuid'. The status is considered delivered once
	// it is acknowledged by the scheduler. Schedulers can choose
	// to either explicitly acknowledge statuses or let the scheduler
	// driver implicitly acknowledge (default).
	//
	// TODO(bmahler): This is currently overwritten in the scheduler
	// driver and executor driver, but executors will need to set this
	// to a valid RFC-4122 UUID if using the HTTP API.
	Uuid []byte `protobuf:"bytes,11,opt,name=uuid" json:"uuid,omitempty"`
	// Describes whether the task has been determined to be healthy
	// (true) or unhealthy (false) according to the HealthCheck field in
	// the command info.
	Healthy *bool `protobuf:"varint,8,opt,name=healthy" json:"healthy,omitempty"`
	// Labels are free-form key value pairs which are exposed through
	// master and slave endpoints. Labels will not be interpreted or
	// acted upon by Mesos itself. As opposed to the data field, labels
	// will be kept in memory on master and slave processes. Therefore,
	// labels should be used to tag TaskStatus message with light-weight
	// meta-data.
	Labels *Labels `protobuf:"bytes,12,opt,name=labels" json:"labels,omitempty"`
	// Container related information that is resolved dynamically such as
	// network address.
	ContainerStatus  *ContainerStatus `protobuf:"bytes,13,opt,name=container_status" json:"container_status,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *TaskStatus) Reset()      { *m = TaskStatus{} }
func (*TaskStatus) ProtoMessage() {}

func (m *TaskStatus) GetTaskId() *TaskID {
	if m != nil {
		return m.TaskId
	}
	return nil
}

func (m *TaskStatus) GetState() TaskState {
	if m != nil && m.State != nil {
		return *m.State
	}
	return TaskState_TASK_STAGING
}

func (m *TaskStatus) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *TaskStatus) GetSource() TaskStatus_Source {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return TaskStatus_SOURCE_MASTER
}

func (m *TaskStatus) GetReason() TaskStatus_Reason {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return TaskStatus_REASON_COMMAND_EXECUTOR_FAILED
}

func (m *TaskStatus) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *TaskStatus) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *TaskStatus) GetExecutorId() *ExecutorID {
	if m != nil {
		return m.ExecutorId
	}
	return nil
}

func (m *TaskStatus) GetTimestamp() float64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *TaskStatus) GetUuid() []byte {
	if m != nil {
		return m.Uuid
	}
	return nil
}

func (m *TaskStatus) GetHealthy() bool {
	if m != nil && m.Healthy != nil {
		return *m.Healthy
	}
	return false
}

func (m *TaskStatus) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TaskStatus) GetContainerStatus() *ContainerStatus {
	if m != nil {
		return m.ContainerStatus
	}
	return nil
}

// *
// Describes possible filters that can be applied to unused resources
// (see SchedulerDriver::launchTasks) to influence the allocator.
type Filters struct {
	// Time to consider unused resources refused. Note that all unused
	// resources will be considered refused and use the default value
	// (below) regardless of whether Filters was passed to
	// SchedulerDriver::launchTasks. You MUST pass Filters with this
	// field set to change this behavior (i.e., get another offer which
	// includes unused resources sooner or later than the default).
	RefuseSeconds    *float64 `protobuf:"fixed64,1,opt,name=refuse_seconds,def=5" json:"refuse_seconds,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Filters) Reset()      { *m = Filters{} }
func (*Filters) ProtoMessage() {}

const Default_Filters_RefuseSeconds float64 = 5

func (m *Filters) GetRefuseSeconds() float64 {
	if m != nil && m.RefuseSeconds != nil {
		return *m.RefuseSeconds
	}
	return Default_Filters_RefuseSeconds
}

// *
// Describes a collection of environment variables. This is used with
// CommandInfo in order to set environment variables before running a
// command.
type Environment struct {
	Variables        []*Environment_Variable `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty"`
	XXX_unrecognized []byte                  `json:"-"`
}

func (m *Environment) Reset()      { *m = Environment{} }
func (*Environment) ProtoMessage() {}

func (m *Environment) GetVariables() []*Environment_Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

type Environment_Variable struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Environment_Variable) Reset()      { *m = Environment_Variable{} }
func (*Environment_Variable) ProtoMessage() {}

func (m *Environment_Variable) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Environment_Variable) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// A generic (key, value) pair used in various places for parameters.
type Parameter struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Parameter) Reset()      { *m = Parameter{} }
func (*Parameter) ProtoMessage() {}

func (m *Parameter) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Parameter) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Collection of Parameter.
type Parameters struct {
	Parameter        []*Parameter `protobuf:"bytes,1,rep,name=parameter" json:"parameter,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Parameters) Reset()      { *m = Parameters{} }
func (*Parameters) ProtoMessage() {}

func (m *Parameters) GetParameter() []*Parameter {
	if m != nil {
		return m.Parameter
	}
	return nil
}

// *
// Credential used in various places for authentication and
// authorization.
//
// NOTE: A 'principal' is different from 'FrameworkInfo.user'. The
// former is used for authentication and authorization while the
// latter is used to determine the default user under which the
// framework's executors/tasks are run.
type Credential struct {
	Principal        *string `protobuf:"bytes,1,req,name=principal" json:"principal,omitempty"`
	Secret           *string `protobuf:"bytes,2,opt,name=secret" json:"secret,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Credential) Reset()      { *m = Credential{} }
func (*Credential) ProtoMessage() {}

func (m *Credential) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *Credential) GetSecret() string {
	if m != nil && m.Secret != nil {
		return *m.Secret
	}
	return ""
}

// *
// Credentials used for framework authentication, HTTP authentication
// (where the common 'username' and 'password' are captured as
// 'principal' and 'secret' respectively), etc.
type Credentials struct {
	Credentials      []*Credential `protobuf:"bytes,1,rep,name=credentials" json:"credentials,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Credentials) Reset()      { *m = Credentials{} }
func (*Credentials) ProtoMessage() {}

func (m *Credentials) GetCredentials() []*Credential {
	if m != nil {
		return m.Credentials
	}
	return nil
}

// *
// Rate (queries per second, QPS) limit for messages from a framework to master.
// Strictly speaking they are the combined rate from all frameworks of the same
// principal.
type RateLimit struct {
	// Leaving QPS unset gives it unlimited rate (i.e., not throttled),
	// which also implies unlimited capacity.
	Qps *float64 `protobuf:"fixed64,1,opt,name=qps" json:"qps,omitempty"`
	// Principal of framework(s) to be throttled. Should match
	// FrameworkInfo.principal and Credential.principal (if using authentication).
	Principal *string `protobuf:"bytes,2,req,name=principal" json:"principal,omitempty"`
	// Max number of outstanding messages from frameworks of this principal
	// allowed by master before the next message is dropped and an error is sent
	// back to the sender. Messages received before the capacity is reached are
	// still going to be processed after the error is sent.
	// If unspecified, this principal is assigned unlimited capacity.
	// NOTE: This value is ignored if 'qps' is not set.
	Capacity         *uint64 `protobuf:"varint,3,opt,name=capacity" json:"capacity,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RateLimit) Reset()      { *m = RateLimit{} }
func (*RateLimit) ProtoMessage() {}

func (m *RateLimit) GetQps() float64 {
	if m != nil && m.Qps != nil {
		return *m.Qps
	}
	return 0
}

func (m *RateLimit) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *RateLimit) GetCapacity() uint64 {
	if m != nil && m.Capacity != nil {
		return *m.Capacity
	}
	return 0
}

// *
// Collection of RateLimit.
// Frameworks without rate limits defined here are not throttled unless
// 'aggregate_default_qps' is specified.
type RateLimits struct {
	// Items should have unique principals.
	Limits []*RateLimit `protobuf:"bytes,1,rep,name=limits" json:"limits,omitempty"`
	// All the frameworks not specified in 'limits' get this default rate.
	// This rate is an aggregate rate for all of them, i.e., their combined
	// traffic is throttled together at this rate.
	AggregateDefaultQps *float64 `protobuf:"fixed64,2,opt,name=aggregate_default_qps" json:"aggregate_default_qps,omitempty"`
	// All the frameworks not specified in 'limits' get this default capacity.
	// This is an aggregate value similar to 'aggregate_default_qps'.
	AggregateDefaultCapacity *uint64 `protobuf:"varint,3,opt,name=aggregate_default_capacity" json:"aggregate_default_capacity,omitempty"`
	XXX_unrecognized         []byte  `json:"-"`
}

func (m *RateLimits) Reset()      { *m = RateLimits{} }
func (*RateLimits) ProtoMessage() {}

func (m *RateLimits) GetLimits() []*RateLimit {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *RateLimits) GetAggregateDefaultQps() float64 {
	if m != nil && m.AggregateDefaultQps != nil {
		return *m.AggregateDefaultQps
	}
	return 0
}

func (m *RateLimits) GetAggregateDefaultCapacity() uint64 {
	if m != nil && m.AggregateDefaultCapacity != nil {
		return *m.AggregateDefaultCapacity
	}
	return 0
}

// *
// Describe an image used by tasks or executors. Note that it's only
// for tasks or executors launched by MesosContainerizer currently.
// TODO(jieyu): This feature not fully supported in 0.24.0. Please do
// not use it until this feature is announced.
type Image struct {
	Type *Image_Type `protobuf:"varint,1,req,name=type,enum=mesosproto.Image_Type" json:"type,omitempty"`
	// Only one of the following image messages should be set to match
	// the type.
	Appc             *Image_Appc   `protobuf:"bytes,2,opt,name=appc" json:"appc,omitempty"`
	Docker           *Image_Docker `protobuf:"bytes,3,opt,name=docker" json:"docker,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Image) Reset()      { *m = Image{} }
func (*Image) ProtoMessage() {}

func (m *Image) GetType() Image_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Image_APPC
}

func (m *Image) GetAppc() *Image_Appc {
	if m != nil {
		return m.Appc
	}
	return nil
}

func (m *Image) GetDocker() *Image_Docker {
	if m != nil {
		return m.Docker
	}
	return nil
}

// Protobuf for specifying an Appc container image. See:
// https://github.com/appc/spec/blob/master/spec/aci.md
type Image_Appc struct {
	// The name of the image.
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// An image ID is a string of the format "hash-value", where
	// "hash" is the hash algorithm used and "value" is the hex
	// encoded string of the digest. Currently the only permitted
	// hash algorithm is sha512.
	Id *string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Optional labels. Suggested labels: "version", "os", and "arch".
	Labels           *Labels `protobuf:"bytes,3,opt,name=labels" json:"labels,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Image_Appc) Reset()      { *m = Image_Appc{} }
func (*Image_Appc) ProtoMessage() {}

func (m *Image_Appc) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Image_Appc) GetId() string {
	if m != nil && m.Id != nil {
		return *m.Id
	}
	return ""
}

func (m *Image_Appc) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

type Image_Docker struct {
	// The name of the image. Expected format:
	//   [REGISTRY_HOST[:REGISTRY_PORT]/]REPOSITORY[:TAG|@TYPE:DIGEST]
	//
	// See: https://docs.docker.com/reference/commandline/pull/
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Image_Docker) Reset()      { *m = Image_Docker{} }
func (*Image_Docker) ProtoMessage() {}

func (m *Image_Docker) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

// *
// Describes a volume mapping either from host to container or vice
// versa. Both paths can either refer to a directory or a file.
type Volume struct {
	Mode *Volume_Mode `protobuf:"varint,3,req,name=mode,enum=mesosproto.Volume_Mode" json:"mode,omitempty"`
	// Path pointing to a directory or file in the container. If the
	// path is a relative path, it is relative to the container work
	// directory. If the path is an absolute path, that path must
	// already exist.
	ContainerPath *string `protobuf:"bytes,1,req,name=container_path" json:"container_path,omitempty"`
	// Absolute path pointing to a directory or file on the host or a
	// path relative to the container work directory.
	HostPath *string `protobuf:"bytes,2,opt,name=host_path" json:"host_path,omitempty"`
	// The source of the volume is an Image which describes a root
	// filesystem which will be provisioned by Mesos.
	Image            *Image `protobuf:"bytes,4,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Volume) Reset()      { *m = Volume{} }
func (*Volume) ProtoMessage() {}

func (m *Volume) GetMode() Volume_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Volume_RW
}

func (m *Volume) GetContainerPath() string {
	if m != nil && m.ContainerPath != nil {
		return *m.ContainerPath
	}
	return ""
}

func (m *Volume) GetHostPath() string {
	if m != nil && m.HostPath != nil {
		return *m.HostPath
	}
	return ""
}

func (m *Volume) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// *
// Describes a network request from a framework as well as network resolution
// provided by Mesos.
//
// A Framework may request the network isolator on the Agent to isolate the
// container in a network namespace and create a virtual network interface.
// The `NetworkInfo` message describes the properties of that virtual
// interface, including the IP addresses and network isolation policy
// (network group membership).
//
// The NetworkInfo message is not interpreted by the Master or Agent and is
// intended to be used by Agent and Master modules implementing network
// isolation. If the modules are missing, the message is simply ignored. In
// future, the task launch will fail if there is no module providing the
// network isolation capabilities (MESOS-3390).
//
// An executor, Agent, or an Agent module may append NetworkInfos inside
// TaskStatus::container_status to provide information such as the container IP
// address and isolation groups.
type NetworkInfo struct {
	// When included in a ContainerInfo, each of these represent a
	// request for an IP address. Each request can specify an explicit address
	// or the IP protocol to use.
	//
	// When included in a TaskStatus message, these inform the framework
	// scheduler about the IP addresses that are bound to the container
	// interface. When there are no custom network isolator modules installed,
	// this field is filled in automatically with the Agent IP address.
	IpAddresses []*NetworkInfo_IPAddress `protobuf:"bytes,5,rep,name=ip_addresses" json:"ip_addresses,omitempty"`
	// Specify IP address requirement. Set protocol to the desired value to
	// request the network isolator on the Agent to assign an IP address to the
	// container being launched. If a specific IP address is specified in
	// ip_address, this field should not be set.
	Protocol *NetworkInfo_Protocol `protobuf:"varint,1,opt,name=protocol,enum=mesosproto.NetworkInfo_Protocol" json:"protocol,omitempty"`
	// Statically assigned IP provided by the Framework. This IP will be assigned
	// to the container by the network isolator module on the Agent. This field
	// should not be used with the protocol field above.
	// NOTE: It is up to the networking 'provider' (IPAM/Isolator) to interpret
	// this either as a hint of as a requirement for assigning the IP.
	IpAddress *string `protobuf:"bytes,2,opt,name=ip_address" json:"ip_address,omitempty"`
	// A group is the name given to a set of logically-related interfaces that
	// are allowed to communicate among themselves. Network traffic is allowed
	// between two container interfaces that share at least one network group.
	// For example, one might want to create separate groups for isolating dev,
	// testing, qa and prod deployment environments.
	Groups []string `protobuf:"bytes,3,rep,name=groups" json:"groups,omitempty"`
	// To tag certain metadata to be used by Isolator/IPAM, e.g., rack, etc.
	Labels           *Labels `protobuf:"bytes,4,opt,name=labels" json:"labels,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NetworkInfo) Reset()      { *m = NetworkInfo{} }
func (*NetworkInfo) ProtoMessage() {}

func (m *NetworkInfo) GetIpAddresses() []*NetworkInfo_IPAddress {
	if m != nil {
		return m.IpAddresses
	}
	return nil
}

func (m *NetworkInfo) GetProtocol() NetworkInfo_Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return NetworkInfo_IPv4
}

func (m *NetworkInfo) GetIpAddress() string {
	if m != nil && m.IpAddress != nil {
		return *m.IpAddress
	}
	return ""
}

func (m *NetworkInfo) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *NetworkInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Specifies a request for an IP address, or reports the assigned container
// IP address.
//
// Users can request an automatically assigned IP (for example, via an
// IPAM service) or a specific IP by adding a NetworkInfo to the
// ContainerInfo for a task.  On a request, specifying neither `protocol`
// nor `ip_address` means that any available address may be assigned.
type NetworkInfo_IPAddress struct {
	// Specify IP address requirement. Set protocol to the desired value to
	// request the network isolator on the Agent to assign an IP address to the
	// container being launched. If a specific IP address is specified in
	// ip_address, this field should not be set.
	Protocol *NetworkInfo_Protocol `protobuf:"varint,1,opt,name=protocol,enum=mesosproto.NetworkInfo_Protocol" json:"protocol,omitempty"`
	// Statically assigned IP provided by the Framework. This IP will be
	// assigned to the container by the network isolator module on the Agent.
	// This field should not be used with the protocol field above.
	//
	// If an explicit address is requested but is unavailable, the network
	// isolator should fail the task.
	IpAddress        *string `protobuf:"bytes,2,opt,name=ip_address" json:"ip_address,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NetworkInfo_IPAddress) Reset()      { *m = NetworkInfo_IPAddress{} }
func (*NetworkInfo_IPAddress) ProtoMessage() {}

func (m *NetworkInfo_IPAddress) GetProtocol() NetworkInfo_Protocol {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return NetworkInfo_IPv4
}

func (m *NetworkInfo_IPAddress) GetIpAddress() string {
	if m != nil && m.IpAddress != nil {
		return *m.IpAddress
	}
	return ""
}

// *
// Describes a container configuration and allows extensible
// configurations for different container implementations.
type ContainerInfo struct {
	Type     *ContainerInfo_Type `protobuf:"varint,1,req,name=type,enum=mesosproto.ContainerInfo_Type" json:"type,omitempty"`
	Volumes  []*Volume           `protobuf:"bytes,2,rep,name=volumes" json:"volumes,omitempty"`
	Hostname *string             `protobuf:"bytes,4,opt,name=hostname" json:"hostname,omitempty"`
	// Only one of the following *Info messages should be set to match
	// the type.
	Docker *ContainerInfo_DockerInfo `protobuf:"bytes,3,opt,name=docker" json:"docker,omitempty"`
	Mesos  *ContainerInfo_MesosInfo  `protobuf:"bytes,5,opt,name=mesos" json:"mesos,omitempty"`
	// A list of network requests. A framework can request multiple IP addresses
	// for the container.
	NetworkInfos     []*NetworkInfo `protobuf:"bytes,7,rep,name=network_infos" json:"network_infos,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ContainerInfo) Reset()      { *m = ContainerInfo{} }
func (*ContainerInfo) ProtoMessage() {}

func (m *ContainerInfo) GetType() ContainerInfo_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ContainerInfo_DOCKER
}

func (m *ContainerInfo) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *ContainerInfo) GetHostname() string {
	if m != nil && m.Hostname != nil {
		return *m.Hostname
	}
	return ""
}

func (m *ContainerInfo) GetDocker() *ContainerInfo_DockerInfo {
	if m != nil {
		return m.Docker
	}
	return nil
}

func (m *ContainerInfo) GetMesos() *ContainerInfo_MesosInfo {
	if m != nil {
		return m.Mesos
	}
	return nil
}

func (m *ContainerInfo) GetNetworkInfos() []*NetworkInfo {
	if m != nil {
		return m.NetworkInfos
	}
	return nil
}

type ContainerInfo_DockerInfo struct {
	// The docker image that is going to be passed to the registry.
	Image        *string                                 `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	Network      *ContainerInfo_DockerInfo_Network       `protobuf:"varint,2,opt,name=network,enum=mesosproto.ContainerInfo_DockerInfo_Network,def=1" json:"network,omitempty"`
	PortMappings []*ContainerInfo_DockerInfo_PortMapping `protobuf:"bytes,3,rep,name=port_mappings" json:"port_mappings,omitempty"`
	Privileged   *bool                                   `protobuf:"varint,4,opt,name=privileged,def=0" json:"privileged,omitempty"`
	// Allowing arbitrary parameters to be passed to docker CLI.
	// Note that anything passed to this field is not guaranteed
	// to be supported moving forward, as we might move away from
	// the docker CLI.
	Parameters []*Parameter `protobuf:"bytes,5,rep,name=parameters" json:"parameters,omitempty"`
	// With this flag set to true, the docker containerizer will
	// pull the docker image from the registry even if the image
	// is already downloaded on the slave.
	ForcePullImage   *bool  `protobuf:"varint,6,opt,name=force_pull_image" json:"force_pull_image,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ContainerInfo_DockerInfo) Reset()      { *m = ContainerInfo_DockerInfo{} }
func (*ContainerInfo_DockerInfo) ProtoMessage() {}

const Default_ContainerInfo_DockerInfo_Network ContainerInfo_DockerInfo_Network = ContainerInfo_DockerInfo_HOST
const Default_ContainerInfo_DockerInfo_Privileged bool = false

func (m *ContainerInfo_DockerInfo) GetImage() string {
	if m != nil && m.Image != nil {
		return *m.Image
	}
	return ""
}

func (m *ContainerInfo_DockerInfo) GetNetwork() ContainerInfo_DockerInfo_Network {
	if m != nil && m.Network != nil {
		return *m.Network
	}
	return Default_ContainerInfo_DockerInfo_Network
}

func (m *ContainerInfo_DockerInfo) GetPortMappings() []*ContainerInfo_DockerInfo_PortMapping {
	if m != nil {
		return m.PortMappings
	}
	return nil
}

func (m *ContainerInfo_DockerInfo) GetPrivileged() bool {
	if m != nil && m.Privileged != nil {
		return *m.Privileged
	}
	return Default_ContainerInfo_DockerInfo_Privileged
}

func (m *ContainerInfo_DockerInfo) GetParameters() []*Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ContainerInfo_DockerInfo) GetForcePullImage() bool {
	if m != nil && m.ForcePullImage != nil {
		return *m.ForcePullImage
	}
	return false
}

type ContainerInfo_DockerInfo_PortMapping struct {
	HostPort      *uint32 `protobuf:"varint,1,req,name=host_port" json:"host_port,omitempty"`
	ContainerPort *uint32 `protobuf:"varint,2,req,name=container_port" json:"container_port,omitempty"`
	// Protocol to expose as (ie: tcp, udp).
	Protocol         *string `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ContainerInfo_DockerInfo_PortMapping) Reset()      { *m = ContainerInfo_DockerInfo_PortMapping{} }
func (*ContainerInfo_DockerInfo_PortMapping) ProtoMessage() {}

func (m *ContainerInfo_DockerInfo_PortMapping) GetHostPort() uint32 {
	if m != nil && m.HostPort != nil {
		return *m.HostPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetContainerPort() uint32 {
	if m != nil && m.ContainerPort != nil {
		return *m.ContainerPort
	}
	return 0
}

func (m *ContainerInfo_DockerInfo_PortMapping) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

type ContainerInfo_MesosInfo struct {
	Image            *Image `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ContainerInfo_MesosInfo) Reset()      { *m = ContainerInfo_MesosInfo{} }
func (*ContainerInfo_MesosInfo) ProtoMessage() {}

func (m *ContainerInfo_MesosInfo) GetImage() *Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// *
// Container related information that is resolved during container setup. The
// information is sent back to the framework as part of the TaskStatus message.
type ContainerStatus struct {
	// This field can be reliably used to identify the container IP address.
	NetworkInfos     []*NetworkInfo `protobuf:"bytes,1,rep,name=network_infos" json:"network_infos,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *ContainerStatus) Reset()      { *m = ContainerStatus{} }
func (*ContainerStatus) ProtoMessage() {}

func (m *ContainerStatus) GetNetworkInfos() []*NetworkInfo {
	if m != nil {
		return m.NetworkInfos
	}
	return nil
}

// *
// Collection of labels.
type Labels struct {
	Labels           []*Label `protobuf:"bytes,1,rep,name=labels" json:"labels,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Labels) Reset()      { *m = Labels{} }
func (*Labels) ProtoMessage() {}

func (m *Labels) GetLabels() []*Label {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Key, value pair used to store free form user-data.
type Label struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Label) Reset()      { *m = Label{} }
func (*Label) ProtoMessage() {}

func (m *Label) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *Label) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

// *
// Named port used for service discovery.
type Port struct {
	Number           *uint32                   `protobuf:"varint,1,req,name=number" json:"number,omitempty"`
	Name             *string                   `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	Protocol         *string                   `protobuf:"bytes,3,opt,name=protocol" json:"protocol,omitempty"`
	Visibility       *DiscoveryInfo_Visibility `protobuf:"varint,4,opt,name=visibility,enum=mesosproto.DiscoveryInfo_Visibility" json:"visibility,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *Port) Reset()      { *m = Port{} }
func (*Port) ProtoMessage() {}

func (m *Port) GetNumber() uint32 {
	if m != nil && m.Number != nil {
		return *m.Number
	}
	return 0
}

func (m *Port) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Port) GetProtocol() string {
	if m != nil && m.Protocol != nil {
		return *m.Protocol
	}
	return ""
}

func (m *Port) GetVisibility() DiscoveryInfo_Visibility {
	if m != nil && m.Visibility != nil {
		return *m.Visibility
	}
	return DiscoveryInfo_FRAMEWORK
}

// *
// Collection of ports.
type Ports struct {
	Ports            []*Port `protobuf:"bytes,1,rep,name=ports" json:"ports,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Ports) Reset()      { *m = Ports{} }
func (*Ports) ProtoMessage() {}

func (m *Ports) GetPorts() []*Port {
	if m != nil {
		return m.Ports
	}
	return nil
}

// *
// Service discovery information.
// The visibility field restricts discovery within a framework (FRAMEWORK),
// within a Mesos cluster (CLUSTER), or places no restrictions (EXTERNAL).
// Each port in the ports field also has an optional visibility field.
// If visibility is specified for a port, it overrides the default service-wide
// DiscoveryInfo.visibility for that port.
// The environment, location, and version fields provide first class support for
// common attributes used to differentiate between similar services. The
// environment may receive values such as PROD/QA/DEV, the location field may
// receive values like EAST-US/WEST-US/EUROPE/AMEA, and the version field may
// receive values like v2.0/v0.9. The exact use of these fields is up to each
// service discovery system.
type DiscoveryInfo struct {
	Visibility       *DiscoveryInfo_Visibility `protobuf:"varint,1,req,name=visibility,enum=mesosproto.DiscoveryInfo_Visibility" json:"visibility,omitempty"`
	Name             *string                   `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	Environment      *string                   `protobuf:"bytes,3,opt,name=environment" json:"environment,omitempty"`
	Location         *string                   `protobuf:"bytes,4,opt,name=location" json:"location,omitempty"`
	Version          *string                   `protobuf:"bytes,5,opt,name=version" json:"version,omitempty"`
	Ports            *Ports                    `protobuf:"bytes,6,opt,name=ports" json:"ports,omitempty"`
	Labels           *Labels                   `protobuf:"bytes,7,opt,name=labels" json:"labels,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *DiscoveryInfo) Reset()      { *m = DiscoveryInfo{} }
func (*DiscoveryInfo) ProtoMessage() {}

func (m *DiscoveryInfo) GetVisibility() DiscoveryInfo_Visibility {
	if m != nil && m.Visibility != nil {
		return *m.Visibility
	}
	return DiscoveryInfo_FRAMEWORK
}

func (m *DiscoveryInfo) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *DiscoveryInfo) GetEnvironment() string {
	if m != nil && m.Environment != nil {
		return *m.Environment
	}
	return ""
}

func (m *DiscoveryInfo) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

func (m *DiscoveryInfo) GetVersion() string {
	if m != nil && m.Version != nil {
		return *m.Version
	}
	return ""
}

func (m *DiscoveryInfo) GetPorts() *Ports {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *DiscoveryInfo) GetLabels() *Labels {
	if m != nil {
		return m.Labels
	}
	return nil
}

// *
// Protobuf for the Appc image manifest JSON schema:
// https://github.com/appc/spec/blob/master/spec/aci.md#image-manifest-schema
// Where possible, any field required in the schema is required in the protobuf
// but some cannot be expressed, e.g., a repeated string that has at least one
// element. Further validation should be performed after parsing the JSON into
// the protobuf.
// This version of Appc protobuf is based on Appc spec version 0.6.1.
// TODO(xujyan): This protobuf currently defines a subset of fields in the spec
// that Mesos makes use of to avoid confusion. New fields are going to be added
// when Mesos starts to support them.
type AppcImageManifest struct {
	AcKind           *string                         `protobuf:"bytes,1,req,name=acKind" json:"acKind,omitempty"`
	AcVersion        *string                         `protobuf:"bytes,2,req,name=acVersion" json:"acVersion,omitempty"`
	Name             *string                         `protobuf:"bytes,3,req,name=name" json:"name,omitempty"`
	Labels           []*AppcImageManifest_Label      `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
	Annotations      []*AppcImageManifest_Annotation `protobuf:"bytes,5,rep,name=annotations" json:"annotations,omitempty"`
	XXX_unrecognized []byte                          `json:"-"`
}

func (m *AppcImageManifest) Reset()      { *m = AppcImageManifest{} }
func (*AppcImageManifest) ProtoMessage() {}

func (m *AppcImageManifest) GetAcKind() string {
	if m != nil && m.AcKind != nil {
		return *m.AcKind
	}
	return ""
}

func (m *AppcImageManifest) GetAcVersion() string {
	if m != nil && m.AcVersion != nil {
		return *m.AcVersion
	}
	return ""
}

func (m *AppcImageManifest) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *AppcImageManifest) GetLabels() []*AppcImageManifest_Label {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *AppcImageManifest) GetAnnotations() []*AppcImageManifest_Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

type AppcImageManifest_Label struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AppcImageManifest_Label) Reset()      { *m = AppcImageManifest_Label{} }
func (*AppcImageManifest_Label) ProtoMessage() {}

func (m *AppcImageManifest_Label) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *AppcImageManifest_Label) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type AppcImageManifest_Annotation struct {
	Name             *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AppcImageManifest_Annotation) Reset()      { *m = AppcImageManifest_Annotation{} }
func (*AppcImageManifest_Annotation) ProtoMessage() {}

func (m *AppcImageManifest_Annotation) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *AppcImageManifest_Annotation) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func init() {
	proto.RegisterEnum("mesosproto.Status", Status_name, Status_value)
	proto.RegisterEnum("mesosproto.TaskState", TaskState_name, TaskState_value)
	proto.RegisterEnum("mesosproto.MachineInfo_Mode", MachineInfo_Mode_name, MachineInfo_Mode_value)
	proto.RegisterEnum("mesosproto.FrameworkInfo_Capability_Type", FrameworkInfo_Capability_Type_name, FrameworkInfo_Capability_Type_value)
	proto.RegisterEnum("mesosproto.Value_Type", Value_Type_name, Value_Type_value)
	proto.RegisterEnum("mesosproto.Offer_Operation_Type", Offer_Operation_Type_name, Offer_Operation_Type_value)
	proto.RegisterEnum("mesosproto.TaskStatus_Source", TaskStatus_Source_name, TaskStatus_Source_value)
	proto.RegisterEnum("mesosproto.TaskStatus_Reason", TaskStatus_Reason_name, TaskStatus_Reason_value)
	proto.RegisterEnum("mesosproto.Image_Type", Image_Type_name, Image_Type_value)
	proto.RegisterEnum("mesosproto.Volume_Mode", Volume_Mode_name, Volume_Mode_value)
	proto.RegisterEnum("mesosproto.NetworkInfo_Protocol", NetworkInfo_Protocol_name, NetworkInfo_Protocol_value)
	proto.RegisterEnum("mesosproto.ContainerInfo_Type", ContainerInfo_Type_name, ContainerInfo_Type_value)
	proto.RegisterEnum("mesosproto.ContainerInfo_DockerInfo_Network", ContainerInfo_DockerInfo_Network_name, ContainerInfo_DockerInfo_Network_value)
	proto.RegisterEnum("mesosproto.DiscoveryInfo_Visibility", DiscoveryInfo_Visibility_name, DiscoveryInfo_Visibility_value)
}
func (this *FrameworkID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		return fmt.Errorf("that is not of type *FrameworkID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *FrameworkID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *OfferID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*OfferID)
	if !ok {
		return fmt.Errorf("that is not of type *OfferID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *OfferID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *OfferIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *OfferID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*OfferID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SlaveID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*SlaveID)
	if !ok {
		return fmt.Errorf("that is not of type *SlaveID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *SlaveID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *SlaveIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *SlaveID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SlaveID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskID)
	if !ok {
		return fmt.Errorf("that is not of type *TaskID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ExecutorID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		return fmt.Errorf("that is not of type *ExecutorID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ExecutorID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ExecutorIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ExecutorID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerIDbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TimeInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TimeInfo)
	if !ok {
		return fmt.Errorf("that is not of type *TimeInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TimeInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TimeInfobut is not nil && this == nil")
	}
	if this.Nanoseconds != nil && that1.Nanoseconds != nil {
		if *this.Nanoseconds != *that1.Nanoseconds {
			return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", *this.Nanoseconds, *that1.Nanoseconds)
		}
	} else if this.Nanoseconds != nil {
		return fmt.Errorf("this.Nanoseconds == nil && that.Nanoseconds != nil")
	} else if that1.Nanoseconds != nil {
		return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", this.Nanoseconds, that1.Nanoseconds)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TimeInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TimeInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Nanoseconds != nil && that1.Nanoseconds != nil {
		if *this.Nanoseconds != *that1.Nanoseconds {
			return false
		}
	} else if this.Nanoseconds != nil {
		return false
	} else if that1.Nanoseconds != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DurationInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DurationInfo)
	if !ok {
		return fmt.Errorf("that is not of type *DurationInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DurationInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DurationInfobut is not nil && this == nil")
	}
	if this.Nanoseconds != nil && that1.Nanoseconds != nil {
		if *this.Nanoseconds != *that1.Nanoseconds {
			return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", *this.Nanoseconds, *that1.Nanoseconds)
		}
	} else if this.Nanoseconds != nil {
		return fmt.Errorf("this.Nanoseconds == nil && that.Nanoseconds != nil")
	} else if that1.Nanoseconds != nil {
		return fmt.Errorf("Nanoseconds this(%v) Not Equal that(%v)", this.Nanoseconds, that1.Nanoseconds)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *DurationInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DurationInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Nanoseconds != nil && that1.Nanoseconds != nil {
		if *this.Nanoseconds != *that1.Nanoseconds {
			return false
		}
	} else if this.Nanoseconds != nil {
		return false
	} else if that1.Nanoseconds != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Address) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Address)
	if !ok {
		return fmt.Errorf("that is not of type *Address")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Address but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Addressbut is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return fmt.Errorf("Ip this(%v) Not Equal that(%v)", *this.Ip, *that1.Ip)
		}
	} else if this.Ip != nil {
		return fmt.Errorf("this.Ip == nil && that.Ip != nil")
	} else if that1.Ip != nil {
		return fmt.Errorf("Ip this(%v) Not Equal that(%v)", this.Ip, that1.Ip)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Address) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Address)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return false
		}
	} else if this.Ip != nil {
		return false
	} else if that1.Ip != nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *URL) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*URL)
	if !ok {
		return fmt.Errorf("that is not of type *URL")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *URL but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *URLbut is not nil && this == nil")
	}
	if this.Scheme != nil && that1.Scheme != nil {
		if *this.Scheme != *that1.Scheme {
			return fmt.Errorf("Scheme this(%v) Not Equal that(%v)", *this.Scheme, *that1.Scheme)
		}
	} else if this.Scheme != nil {
		return fmt.Errorf("this.Scheme == nil && that.Scheme != nil")
	} else if that1.Scheme != nil {
		return fmt.Errorf("Scheme this(%v) Not Equal that(%v)", this.Scheme, that1.Scheme)
	}
	if !this.Address.Equal(that1.Address) {
		return fmt.Errorf("Address this(%v) Not Equal that(%v)", this.Address, that1.Address)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if len(this.Query) != len(that1.Query) {
		return fmt.Errorf("Query this(%v) Not Equal that(%v)", len(this.Query), len(that1.Query))
	}
	for i := range this.Query {
		if !this.Query[i].Equal(that1.Query[i]) {
			return fmt.Errorf("Query this[%v](%v) Not Equal that[%v](%v)", i, this.Query[i], i, that1.Query[i])
		}
	}
	if this.Fragment != nil && that1.Fragment != nil {
		if *this.Fragment != *that1.Fragment {
			return fmt.Errorf("Fragment this(%v) Not Equal that(%v)", *this.Fragment, *that1.Fragment)
		}
	} else if this.Fragment != nil {
		return fmt.Errorf("this.Fragment == nil && that.Fragment != nil")
	} else if that1.Fragment != nil {
		return fmt.Errorf("Fragment this(%v) Not Equal that(%v)", this.Fragment, that1.Fragment)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *URL) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*URL)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Scheme != nil && that1.Scheme != nil {
		if *this.Scheme != *that1.Scheme {
			return false
		}
	} else if this.Scheme != nil {
		return false
	} else if that1.Scheme != nil {
		return false
	}
	if !this.Address.Equal(that1.Address) {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if len(this.Query) != len(that1.Query) {
		return false
	}
	for i := range this.Query {
		if !this.Query[i].Equal(that1.Query[i]) {
			return false
		}
	}
	if this.Fragment != nil && that1.Fragment != nil {
		if *this.Fragment != *that1.Fragment {
			return false
		}
	} else if this.Fragment != nil {
		return false
	} else if that1.Fragment != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Unavailability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Unavailability)
	if !ok {
		return fmt.Errorf("that is not of type *Unavailability")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Unavailability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Unavailabilitybut is not nil && this == nil")
	}
	if !this.Start.Equal(that1.Start) {
		return fmt.Errorf("Start this(%v) Not Equal that(%v)", this.Start, that1.Start)
	}
	if !this.Duration.Equal(that1.Duration) {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Unavailability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Unavailability)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Start.Equal(that1.Start) {
		return false
	}
	if !this.Duration.Equal(that1.Duration) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MachineID) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MachineID)
	if !ok {
		return fmt.Errorf("that is not of type *MachineID")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MachineID but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MachineIDbut is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return fmt.Errorf("Ip this(%v) Not Equal that(%v)", *this.Ip, *that1.Ip)
		}
	} else if this.Ip != nil {
		return fmt.Errorf("this.Ip == nil && that.Ip != nil")
	} else if that1.Ip != nil {
		return fmt.Errorf("Ip this(%v) Not Equal that(%v)", this.Ip, that1.Ip)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *MachineID) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MachineID)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return false
		}
	} else if this.Ip != nil {
		return false
	} else if that1.Ip != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MachineInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MachineInfo)
	if !ok {
		return fmt.Errorf("that is not of type *MachineInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MachineInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MachineInfobut is not nil && this == nil")
	}
	if !this.Id.Equal(that1.Id) {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *MachineInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MachineInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *FrameworkInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		return fmt.Errorf("that is not of type *FrameworkInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkInfobut is not nil && this == nil")
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.Id.Equal(that1.Id) {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return fmt.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", *this.FailoverTimeout, *that1.FailoverTimeout)
		}
	} else if this.FailoverTimeout != nil {
		return fmt.Errorf("this.FailoverTimeout == nil && that.FailoverTimeout != nil")
	} else if that1.FailoverTimeout != nil {
		return fmt.Errorf("FailoverTimeout this(%v) Not Equal that(%v)", this.FailoverTimeout, that1.FailoverTimeout)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.WebuiUrl != nil && that1.WebuiUrl != nil {
		if *this.WebuiUrl != *that1.WebuiUrl {
			return fmt.Errorf("WebuiUrl this(%v) Not Equal that(%v)", *this.WebuiUrl, *that1.WebuiUrl)
		}
	} else if this.WebuiUrl != nil {
		return fmt.Errorf("this.WebuiUrl == nil && that.WebuiUrl != nil")
	} else if that1.WebuiUrl != nil {
		return fmt.Errorf("WebuiUrl this(%v) Not Equal that(%v)", this.WebuiUrl, that1.WebuiUrl)
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return fmt.Errorf("Capabilities this(%v) Not Equal that(%v)", len(this.Capabilities), len(that1.Capabilities))
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(that1.Capabilities[i]) {
			return fmt.Errorf("Capabilities this[%v](%v) Not Equal that[%v](%v)", i, this.Capabilities[i], i, that1.Capabilities[i])
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *FrameworkInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if this.FailoverTimeout != nil && that1.FailoverTimeout != nil {
		if *this.FailoverTimeout != *that1.FailoverTimeout {
			return false
		}
	} else if this.FailoverTimeout != nil {
		return false
	} else if that1.FailoverTimeout != nil {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.WebuiUrl != nil && that1.WebuiUrl != nil {
		if *this.WebuiUrl != *that1.WebuiUrl {
			return false
		}
	} else if this.WebuiUrl != nil {
		return false
	} else if that1.WebuiUrl != nil {
		return false
	}
	if len(this.Capabilities) != len(that1.Capabilities) {
		return false
	}
	for i := range this.Capabilities {
		if !this.Capabilities[i].Equal(that1.Capabilities[i]) {
			return false
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *FrameworkInfo_Capability) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*FrameworkInfo_Capability)
	if !ok {
		return fmt.Errorf("that is not of type *FrameworkInfo_Capability")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *FrameworkInfo_Capability but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *FrameworkInfo_Capabilitybut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *FrameworkInfo_Capability) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FrameworkInfo_Capability)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		return fmt.Errorf("that is not of type *HealthCheck")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *HealthCheck but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *HealthCheckbut is not nil && this == nil")
	}
	if !this.Http.Equal(that1.Http) {
		return fmt.Errorf("Http this(%v) Not Equal that(%v)", this.Http, that1.Http)
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", *this.DelaySeconds, *that1.DelaySeconds)
		}
	} else if this.DelaySeconds != nil {
		return fmt.Errorf("this.DelaySeconds == nil && that.DelaySeconds != nil")
	} else if that1.DelaySeconds != nil {
		return fmt.Errorf("DelaySeconds this(%v) Not Equal that(%v)", this.DelaySeconds, that1.DelaySeconds)
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", *this.IntervalSeconds, *that1.IntervalSeconds)
		}
	} else if this.IntervalSeconds != nil {
		return fmt.Errorf("this.IntervalSeconds == nil && that.IntervalSeconds != nil")
	} else if that1.IntervalSeconds != nil {
		return fmt.Errorf("IntervalSeconds this(%v) Not Equal that(%v)", this.IntervalSeconds, that1.IntervalSeconds)
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", *this.TimeoutSeconds, *that1.TimeoutSeconds)
		}
	} else if this.TimeoutSeconds != nil {
		return fmt.Errorf("this.TimeoutSeconds == nil && that.TimeoutSeconds != nil")
	} else if that1.TimeoutSeconds != nil {
		return fmt.Errorf("TimeoutSeconds this(%v) Not Equal that(%v)", this.TimeoutSeconds, that1.TimeoutSeconds)
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return fmt.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", *this.ConsecutiveFailures, *that1.ConsecutiveFailures)
		}
	} else if this.ConsecutiveFailures != nil {
		return fmt.Errorf("this.ConsecutiveFailures == nil && that.ConsecutiveFailures != nil")
	} else if that1.ConsecutiveFailures != nil {
		return fmt.Errorf("ConsecutiveFailures this(%v) Not Equal that(%v)", this.ConsecutiveFailures, that1.ConsecutiveFailures)
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return fmt.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", *this.GracePeriodSeconds, *that1.GracePeriodSeconds)
		}
	} else if this.GracePeriodSeconds != nil {
		return fmt.Errorf("this.GracePeriodSeconds == nil && that.GracePeriodSeconds != nil")
	} else if that1.GracePeriodSeconds != nil {
		return fmt.Errorf("GracePeriodSeconds this(%v) Not Equal that(%v)", this.GracePeriodSeconds, that1.GracePeriodSeconds)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *HealthCheck) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Http.Equal(that1.Http) {
		return false
	}
	if this.DelaySeconds != nil && that1.DelaySeconds != nil {
		if *this.DelaySeconds != *that1.DelaySeconds {
			return false
		}
	} else if this.DelaySeconds != nil {
		return false
	} else if that1.DelaySeconds != nil {
		return false
	}
	if this.IntervalSeconds != nil && that1.IntervalSeconds != nil {
		if *this.IntervalSeconds != *that1.IntervalSeconds {
			return false
		}
	} else if this.IntervalSeconds != nil {
		return false
	} else if that1.IntervalSeconds != nil {
		return false
	}
	if this.TimeoutSeconds != nil && that1.TimeoutSeconds != nil {
		if *this.TimeoutSeconds != *that1.TimeoutSeconds {
			return false
		}
	} else if this.TimeoutSeconds != nil {
		return false
	} else if that1.TimeoutSeconds != nil {
		return false
	}
	if this.ConsecutiveFailures != nil && that1.ConsecutiveFailures != nil {
		if *this.ConsecutiveFailures != *that1.ConsecutiveFailures {
			return false
		}
	} else if this.ConsecutiveFailures != nil {
		return false
	} else if that1.ConsecutiveFailures != nil {
		return false
	}
	if this.GracePeriodSeconds != nil && that1.GracePeriodSeconds != nil {
		if *this.GracePeriodSeconds != *that1.GracePeriodSeconds {
			return false
		}
	} else if this.GracePeriodSeconds != nil {
		return false
	} else if that1.GracePeriodSeconds != nil {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *HealthCheck_HTTP) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*HealthCheck_HTTP)
	if !ok {
		return fmt.Errorf("that is not of type *HealthCheck_HTTP")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *HealthCheck_HTTP but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *HealthCheck_HTTPbut is not nil && this == nil")
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return fmt.Errorf("Path this(%v) Not Equal that(%v)", *this.Path, *that1.Path)
		}
	} else if this.Path != nil {
		return fmt.Errorf("this.Path == nil && that.Path != nil")
	} else if that1.Path != nil {
		return fmt.Errorf("Path this(%v) Not Equal that(%v)", this.Path, that1.Path)
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return fmt.Errorf("Statuses this(%v) Not Equal that(%v)", len(this.Statuses), len(that1.Statuses))
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return fmt.Errorf("Statuses this[%v](%v) Not Equal that[%v](%v)", i, this.Statuses[i], i, that1.Statuses[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *HealthCheck_HTTP) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HealthCheck_HTTP)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if this.Path != nil && that1.Path != nil {
		if *this.Path != *that1.Path {
			return false
		}
	} else if this.Path != nil {
		return false
	} else if that1.Path != nil {
		return false
	}
	if len(this.Statuses) != len(that1.Statuses) {
		return false
	}
	for i := range this.Statuses {
		if this.Statuses[i] != that1.Statuses[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		return fmt.Errorf("that is not of type *CommandInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CommandInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CommandInfobut is not nil && this == nil")
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if len(this.Uris) != len(that1.Uris) {
		return fmt.Errorf("Uris this(%v) Not Equal that(%v)", len(this.Uris), len(that1.Uris))
	}
	for i := range this.Uris {
		if !this.Uris[i].Equal(that1.Uris[i]) {
			return fmt.Errorf("Uris this[%v](%v) Not Equal that[%v](%v)", i, this.Uris[i], i, that1.Uris[i])
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return fmt.Errorf("Environment this(%v) Not Equal that(%v)", this.Environment, that1.Environment)
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return fmt.Errorf("Shell this(%v) Not Equal that(%v)", *this.Shell, *that1.Shell)
		}
	} else if this.Shell != nil {
		return fmt.Errorf("this.Shell == nil && that.Shell != nil")
	} else if that1.Shell != nil {
		return fmt.Errorf("Shell this(%v) Not Equal that(%v)", this.Shell, that1.Shell)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return fmt.Errorf("Arguments this(%v) Not Equal that(%v)", len(this.Arguments), len(that1.Arguments))
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return fmt.Errorf("Arguments this[%v](%v) Not Equal that[%v](%v)", i, this.Arguments[i], i, that1.Arguments[i])
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if len(this.Uris) != len(that1.Uris) {
		return false
	}
	for i := range this.Uris {
		if !this.Uris[i].Equal(that1.Uris[i]) {
			return false
		}
	}
	if !this.Environment.Equal(that1.Environment) {
		return false
	}
	if this.Shell != nil && that1.Shell != nil {
		if *this.Shell != *that1.Shell {
			return false
		}
	} else if this.Shell != nil {
		return false
	} else if that1.Shell != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if len(this.Arguments) != len(that1.Arguments) {
		return false
	}
	for i := range this.Arguments {
		if this.Arguments[i] != that1.Arguments[i] {
			return false
		}
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo_URI) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		return fmt.Errorf("that is not of type *CommandInfo_URI")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CommandInfo_URI but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CommandInfo_URIbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return fmt.Errorf("Executable this(%v) Not Equal that(%v)", *this.Executable, *that1.Executable)
		}
	} else if this.Executable != nil {
		return fmt.Errorf("this.Executable == nil && that.Executable != nil")
	} else if that1.Executable != nil {
		return fmt.Errorf("Executable this(%v) Not Equal that(%v)", this.Executable, that1.Executable)
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return fmt.Errorf("Extract this(%v) Not Equal that(%v)", *this.Extract, *that1.Extract)
		}
	} else if this.Extract != nil {
		return fmt.Errorf("this.Extract == nil && that.Extract != nil")
	} else if that1.Extract != nil {
		return fmt.Errorf("Extract this(%v) Not Equal that(%v)", this.Extract, that1.Extract)
	}
	if this.Cache != nil && that1.Cache != nil {
		if *this.Cache != *that1.Cache {
			return fmt.Errorf("Cache this(%v) Not Equal that(%v)", *this.Cache, *that1.Cache)
		}
	} else if this.Cache != nil {
		return fmt.Errorf("this.Cache == nil && that.Cache != nil")
	} else if that1.Cache != nil {
		return fmt.Errorf("Cache this(%v) Not Equal that(%v)", this.Cache, that1.Cache)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo_URI) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo_URI)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if this.Executable != nil && that1.Executable != nil {
		if *this.Executable != *that1.Executable {
			return false
		}
	} else if this.Executable != nil {
		return false
	} else if that1.Executable != nil {
		return false
	}
	if this.Extract != nil && that1.Extract != nil {
		if *this.Extract != *that1.Extract {
			return false
		}
	} else if this.Extract != nil {
		return false
	} else if that1.Extract != nil {
		return false
	}
	if this.Cache != nil && that1.Cache != nil {
		if *this.Cache != *that1.Cache {
			return false
		}
	} else if this.Cache != nil {
		return false
	} else if that1.Cache != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommandInfo_ContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*CommandInfo_ContainerInfo)
	if !ok {
		return fmt.Errorf("that is not of type *CommandInfo_ContainerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *CommandInfo_ContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *CommandInfo_ContainerInfobut is not nil && this == nil")
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return fmt.Errorf("Image this(%v) Not Equal that(%v)", *this.Image, *that1.Image)
		}
	} else if this.Image != nil {
		return fmt.Errorf("this.Image == nil && that.Image != nil")
	} else if that1.Image != nil {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if len(this.Options) != len(that1.Options) {
		return fmt.Errorf("Options this(%v) Not Equal that(%v)", len(this.Options), len(that1.Options))
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return fmt.Errorf("Options this[%v](%v) Not Equal that[%v](%v)", i, this.Options[i], i, that1.Options[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *CommandInfo_ContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CommandInfo_ContainerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return false
		}
	} else if this.Image != nil {
		return false
	} else if that1.Image != nil {
		return false
	}
	if len(this.Options) != len(that1.Options) {
		return false
	}
	for i := range this.Options {
		if this.Options[i] != that1.Options[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ExecutorInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		return fmt.Errorf("that is not of type *ExecutorInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ExecutorInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ExecutorInfobut is not nil && this == nil")
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return fmt.Errorf("ExecutorId this(%v) Not Equal that(%v)", this.ExecutorId, that1.ExecutorId)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return fmt.Errorf("Discovery this(%v) Not Equal that(%v)", this.Discovery, that1.Discovery)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ExecutorInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ExecutorInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *MasterInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		return fmt.Errorf("that is not of type *MasterInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *MasterInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *MasterInfobut is not nil && this == nil")
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return fmt.Errorf("Id this(%v) Not Equal that(%v)", *this.Id, *that1.Id)
		}
	} else if this.Id != nil {
		return fmt.Errorf("this.Id == nil && that.Id != nil")
	} else if that1.Id != nil {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return fmt.Errorf("Ip this(%v) Not Equal that(%v)", *this.Ip, *that1.Ip)
		}
	} else if this.Ip != nil {
		return fmt.Errorf("this.Ip == nil && that.Ip != nil")
	} else if that1.Ip != nil {
		return fmt.Errorf("Ip this(%v) Not Equal that(%v)", this.Ip, that1.Ip)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if this.Pid != nil && that1.Pid != nil {
		if *this.Pid != *that1.Pid {
			return fmt.Errorf("Pid this(%v) Not Equal that(%v)", *this.Pid, *that1.Pid)
		}
	} else if this.Pid != nil {
		return fmt.Errorf("this.Pid == nil && that.Pid != nil")
	} else if that1.Pid != nil {
		return fmt.Errorf("Pid this(%v) Not Equal that(%v)", this.Pid, that1.Pid)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return fmt.Errorf("Version this(%v) Not Equal that(%v)", *this.Version, *that1.Version)
		}
	} else if this.Version != nil {
		return fmt.Errorf("this.Version == nil && that.Version != nil")
	} else if that1.Version != nil {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if !this.Address.Equal(that1.Address) {
		return fmt.Errorf("Address this(%v) Not Equal that(%v)", this.Address, that1.Address)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *MasterInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*MasterInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return false
		}
	} else if this.Id != nil {
		return false
	} else if that1.Id != nil {
		return false
	}
	if this.Ip != nil && that1.Ip != nil {
		if *this.Ip != *that1.Ip {
			return false
		}
	} else if this.Ip != nil {
		return false
	} else if that1.Ip != nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if this.Pid != nil && that1.Pid != nil {
		if *this.Pid != *that1.Pid {
			return false
		}
	} else if this.Pid != nil {
		return false
	} else if that1.Pid != nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return false
		}
	} else if this.Version != nil {
		return false
	} else if that1.Version != nil {
		return false
	}
	if !this.Address.Equal(that1.Address) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *SlaveInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*SlaveInfo)
	if !ok {
		return fmt.Errorf("that is not of type *SlaveInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *SlaveInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *SlaveInfobut is not nil && this == nil")
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return fmt.Errorf("Port this(%v) Not Equal that(%v)", *this.Port, *that1.Port)
		}
	} else if this.Port != nil {
		return fmt.Errorf("this.Port == nil && that.Port != nil")
	} else if that1.Port != nil {
		return fmt.Errorf("Port this(%v) Not Equal that(%v)", this.Port, that1.Port)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return fmt.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if !this.Id.Equal(that1.Id) {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *SlaveInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SlaveInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if this.Port != nil && that1.Port != nil {
		if *this.Port != *that1.Port {
			return false
		}
	} else if this.Port != nil {
		return false
	} else if that1.Port != nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value)
	if !ok {
		return fmt.Errorf("that is not of type *Value")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Valuebut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Scalar) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		return fmt.Errorf("that is not of type *Value_Scalar")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Scalar but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Scalarbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Scalar) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Scalar)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Range) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		return fmt.Errorf("that is not of type *Value_Range")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Range but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Rangebut is not nil && this == nil")
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return fmt.Errorf("Begin this(%v) Not Equal that(%v)", *this.Begin, *that1.Begin)
		}
	} else if this.Begin != nil {
		return fmt.Errorf("this.Begin == nil && that.Begin != nil")
	} else if that1.Begin != nil {
		return fmt.Errorf("Begin this(%v) Not Equal that(%v)", this.Begin, that1.Begin)
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return fmt.Errorf("End this(%v) Not Equal that(%v)", *this.End, *that1.End)
		}
	} else if this.End != nil {
		return fmt.Errorf("this.End == nil && that.End != nil")
	} else if that1.End != nil {
		return fmt.Errorf("End this(%v) Not Equal that(%v)", this.End, that1.End)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Range) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Range)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return false
		}
	} else if this.Begin != nil {
		return false
	} else if that1.Begin != nil {
		return false
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return false
		}
	} else if this.End != nil {
		return false
	} else if that1.End != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Ranges) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		return fmt.Errorf("that is not of type *Value_Ranges")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Ranges but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Rangesbut is not nil && this == nil")
	}
	if len(this.Range) != len(that1.Range) {
		return fmt.Errorf("Range this(%v) Not Equal that(%v)", len(this.Range), len(that1.Range))
	}
	for i := range this.Range {
		if !this.Range[i].Equal(that1.Range[i]) {
			return fmt.Errorf("Range this[%v](%v) Not Equal that[%v](%v)", i, this.Range[i], i, that1.Range[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Ranges) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Ranges)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Range) != len(that1.Range) {
		return false
	}
	for i := range this.Range {
		if !this.Range[i].Equal(that1.Range[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Set) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		return fmt.Errorf("that is not of type *Value_Set")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Set but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Setbut is not nil && this == nil")
	}
	if len(this.Item) != len(that1.Item) {
		return fmt.Errorf("Item this(%v) Not Equal that(%v)", len(this.Item), len(that1.Item))
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return fmt.Errorf("Item this[%v](%v) Not Equal that[%v](%v)", i, this.Item[i], i, that1.Item[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Set) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Set)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Item) != len(that1.Item) {
		return false
	}
	for i := range this.Item {
		if this.Item[i] != that1.Item[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Value_Text) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		return fmt.Errorf("that is not of type *Value_Text")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Value_Text but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Value_Textbut is not nil && this == nil")
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Value_Text) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Value_Text)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Attribute) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Attribute)
	if !ok {
		return fmt.Errorf("that is not of type *Attribute")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Attribute but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Attributebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if !this.Text.Equal(that1.Text) {
		return fmt.Errorf("Text this(%v) Not Equal that(%v)", this.Text, that1.Text)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Attribute) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Attribute)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if !this.Text.Equal(that1.Text) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource)
	if !ok {
		return fmt.Errorf("that is not of type *Resource")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resourcebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return fmt.Errorf("Scalar this(%v) Not Equal that(%v)", this.Scalar, that1.Scalar)
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return fmt.Errorf("Ranges this(%v) Not Equal that(%v)", this.Ranges, that1.Ranges)
	}
	if !this.Set.Equal(that1.Set) {
		return fmt.Errorf("Set this(%v) Not Equal that(%v)", this.Set, that1.Set)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if !this.Reservation.Equal(that1.Reservation) {
		return fmt.Errorf("Reservation this(%v) Not Equal that(%v)", this.Reservation, that1.Reservation)
	}
	if !this.Disk.Equal(that1.Disk) {
		return fmt.Errorf("Disk this(%v) Not Equal that(%v)", this.Disk, that1.Disk)
	}
	if !this.Revocable.Equal(that1.Revocable) {
		return fmt.Errorf("Revocable this(%v) Not Equal that(%v)", this.Revocable, that1.Revocable)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Scalar.Equal(that1.Scalar) {
		return false
	}
	if !this.Ranges.Equal(that1.Ranges) {
		return false
	}
	if !this.Set.Equal(that1.Set) {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if !this.Reservation.Equal(that1.Reservation) {
		return false
	}
	if !this.Disk.Equal(that1.Disk) {
		return false
	}
	if !this.Revocable.Equal(that1.Revocable) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource_ReservationInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_ReservationInfo)
	if !ok {
		return fmt.Errorf("that is not of type *Resource_ReservationInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_ReservationInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_ReservationInfobut is not nil && this == nil")
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource_ReservationInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_ReservationInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource_DiskInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo)
	if !ok {
		return fmt.Errorf("that is not of type *Resource_DiskInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfobut is not nil && this == nil")
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return fmt.Errorf("Persistence this(%v) Not Equal that(%v)", this.Persistence, that1.Persistence)
	}
	if !this.Volume.Equal(that1.Volume) {
		return fmt.Errorf("Volume this(%v) Not Equal that(%v)", this.Volume, that1.Volume)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource_DiskInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Persistence.Equal(that1.Persistence) {
		return false
	}
	if !this.Volume.Equal(that1.Volume) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource_DiskInfo_Persistence) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_DiskInfo_Persistence)
	if !ok {
		return fmt.Errorf("that is not of type *Resource_DiskInfo_Persistence")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_DiskInfo_Persistence but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_DiskInfo_Persistencebut is not nil && this == nil")
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return fmt.Errorf("Id this(%v) Not Equal that(%v)", *this.Id, *that1.Id)
		}
	} else if this.Id != nil {
		return fmt.Errorf("this.Id == nil && that.Id != nil")
	} else if that1.Id != nil {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource_DiskInfo_Persistence) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_DiskInfo_Persistence)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return false
		}
	} else if this.Id != nil {
		return false
	} else if that1.Id != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Resource_RevocableInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Resource_RevocableInfo)
	if !ok {
		return fmt.Errorf("that is not of type *Resource_RevocableInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Resource_RevocableInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Resource_RevocableInfobut is not nil && this == nil")
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Resource_RevocableInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Resource_RevocableInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TrafficControlStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TrafficControlStatistics)
	if !ok {
		return fmt.Errorf("that is not of type *TrafficControlStatistics")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TrafficControlStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TrafficControlStatisticsbut is not nil && this == nil")
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return fmt.Errorf("Id this(%v) Not Equal that(%v)", *this.Id, *that1.Id)
		}
	} else if this.Id != nil {
		return fmt.Errorf("this.Id == nil && that.Id != nil")
	} else if that1.Id != nil {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if this.Backlog != nil && that1.Backlog != nil {
		if *this.Backlog != *that1.Backlog {
			return fmt.Errorf("Backlog this(%v) Not Equal that(%v)", *this.Backlog, *that1.Backlog)
		}
	} else if this.Backlog != nil {
		return fmt.Errorf("this.Backlog == nil && that.Backlog != nil")
	} else if that1.Backlog != nil {
		return fmt.Errorf("Backlog this(%v) Not Equal that(%v)", this.Backlog, that1.Backlog)
	}
	if this.Bytes != nil && that1.Bytes != nil {
		if *this.Bytes != *that1.Bytes {
			return fmt.Errorf("Bytes this(%v) Not Equal that(%v)", *this.Bytes, *that1.Bytes)
		}
	} else if this.Bytes != nil {
		return fmt.Errorf("this.Bytes == nil && that.Bytes != nil")
	} else if that1.Bytes != nil {
		return fmt.Errorf("Bytes this(%v) Not Equal that(%v)", this.Bytes, that1.Bytes)
	}
	if this.Drops != nil && that1.Drops != nil {
		if *this.Drops != *that1.Drops {
			return fmt.Errorf("Drops this(%v) Not Equal that(%v)", *this.Drops, *that1.Drops)
		}
	} else if this.Drops != nil {
		return fmt.Errorf("this.Drops == nil && that.Drops != nil")
	} else if that1.Drops != nil {
		return fmt.Errorf("Drops this(%v) Not Equal that(%v)", this.Drops, that1.Drops)
	}
	if this.Overlimits != nil && that1.Overlimits != nil {
		if *this.Overlimits != *that1.Overlimits {
			return fmt.Errorf("Overlimits this(%v) Not Equal that(%v)", *this.Overlimits, *that1.Overlimits)
		}
	} else if this.Overlimits != nil {
		return fmt.Errorf("this.Overlimits == nil && that.Overlimits != nil")
	} else if that1.Overlimits != nil {
		return fmt.Errorf("Overlimits this(%v) Not Equal that(%v)", this.Overlimits, that1.Overlimits)
	}
	if this.Packets != nil && that1.Packets != nil {
		if *this.Packets != *that1.Packets {
			return fmt.Errorf("Packets this(%v) Not Equal that(%v)", *this.Packets, *that1.Packets)
		}
	} else if this.Packets != nil {
		return fmt.Errorf("this.Packets == nil && that.Packets != nil")
	} else if that1.Packets != nil {
		return fmt.Errorf("Packets this(%v) Not Equal that(%v)", this.Packets, that1.Packets)
	}
	if this.Qlen != nil && that1.Qlen != nil {
		if *this.Qlen != *that1.Qlen {
			return fmt.Errorf("Qlen this(%v) Not Equal that(%v)", *this.Qlen, *that1.Qlen)
		}
	} else if this.Qlen != nil {
		return fmt.Errorf("this.Qlen == nil && that.Qlen != nil")
	} else if that1.Qlen != nil {
		return fmt.Errorf("Qlen this(%v) Not Equal that(%v)", this.Qlen, that1.Qlen)
	}
	if this.Ratebps != nil && that1.Ratebps != nil {
		if *this.Ratebps != *that1.Ratebps {
			return fmt.Errorf("Ratebps this(%v) Not Equal that(%v)", *this.Ratebps, *that1.Ratebps)
		}
	} else if this.Ratebps != nil {
		return fmt.Errorf("this.Ratebps == nil && that.Ratebps != nil")
	} else if that1.Ratebps != nil {
		return fmt.Errorf("Ratebps this(%v) Not Equal that(%v)", this.Ratebps, that1.Ratebps)
	}
	if this.Ratepps != nil && that1.Ratepps != nil {
		if *this.Ratepps != *that1.Ratepps {
			return fmt.Errorf("Ratepps this(%v) Not Equal that(%v)", *this.Ratepps, *that1.Ratepps)
		}
	} else if this.Ratepps != nil {
		return fmt.Errorf("this.Ratepps == nil && that.Ratepps != nil")
	} else if that1.Ratepps != nil {
		return fmt.Errorf("Ratepps this(%v) Not Equal that(%v)", this.Ratepps, that1.Ratepps)
	}
	if this.Requeues != nil && that1.Requeues != nil {
		if *this.Requeues != *that1.Requeues {
			return fmt.Errorf("Requeues this(%v) Not Equal that(%v)", *this.Requeues, *that1.Requeues)
		}
	} else if this.Requeues != nil {
		return fmt.Errorf("this.Requeues == nil && that.Requeues != nil")
	} else if that1.Requeues != nil {
		return fmt.Errorf("Requeues this(%v) Not Equal that(%v)", this.Requeues, that1.Requeues)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TrafficControlStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TrafficControlStatistics)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return false
		}
	} else if this.Id != nil {
		return false
	} else if that1.Id != nil {
		return false
	}
	if this.Backlog != nil && that1.Backlog != nil {
		if *this.Backlog != *that1.Backlog {
			return false
		}
	} else if this.Backlog != nil {
		return false
	} else if that1.Backlog != nil {
		return false
	}
	if this.Bytes != nil && that1.Bytes != nil {
		if *this.Bytes != *that1.Bytes {
			return false
		}
	} else if this.Bytes != nil {
		return false
	} else if that1.Bytes != nil {
		return false
	}
	if this.Drops != nil && that1.Drops != nil {
		if *this.Drops != *that1.Drops {
			return false
		}
	} else if this.Drops != nil {
		return false
	} else if that1.Drops != nil {
		return false
	}
	if this.Overlimits != nil && that1.Overlimits != nil {
		if *this.Overlimits != *that1.Overlimits {
			return false
		}
	} else if this.Overlimits != nil {
		return false
	} else if that1.Overlimits != nil {
		return false
	}
	if this.Packets != nil && that1.Packets != nil {
		if *this.Packets != *that1.Packets {
			return false
		}
	} else if this.Packets != nil {
		return false
	} else if that1.Packets != nil {
		return false
	}
	if this.Qlen != nil && that1.Qlen != nil {
		if *this.Qlen != *that1.Qlen {
			return false
		}
	} else if this.Qlen != nil {
		return false
	} else if that1.Qlen != nil {
		return false
	}
	if this.Ratebps != nil && that1.Ratebps != nil {
		if *this.Ratebps != *that1.Ratebps {
			return false
		}
	} else if this.Ratebps != nil {
		return false
	} else if that1.Ratebps != nil {
		return false
	}
	if this.Ratepps != nil && that1.Ratepps != nil {
		if *this.Ratepps != *that1.Ratepps {
			return false
		}
	} else if this.Ratepps != nil {
		return false
	} else if that1.Ratepps != nil {
		return false
	}
	if this.Requeues != nil && that1.Requeues != nil {
		if *this.Requeues != *that1.Requeues {
			return false
		}
	} else if this.Requeues != nil {
		return false
	} else if that1.Requeues != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ResourceStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		return fmt.Errorf("that is not of type *ResourceStatistics")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceStatisticsbut is not nil && this == nil")
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Processes != nil && that1.Processes != nil {
		if *this.Processes != *that1.Processes {
			return fmt.Errorf("Processes this(%v) Not Equal that(%v)", *this.Processes, *that1.Processes)
		}
	} else if this.Processes != nil {
		return fmt.Errorf("this.Processes == nil && that.Processes != nil")
	} else if that1.Processes != nil {
		return fmt.Errorf("Processes this(%v) Not Equal that(%v)", this.Processes, that1.Processes)
	}
	if this.Threads != nil && that1.Threads != nil {
		if *this.Threads != *that1.Threads {
			return fmt.Errorf("Threads this(%v) Not Equal that(%v)", *this.Threads, *that1.Threads)
		}
	} else if this.Threads != nil {
		return fmt.Errorf("this.Threads == nil && that.Threads != nil")
	} else if that1.Threads != nil {
		return fmt.Errorf("Threads this(%v) Not Equal that(%v)", this.Threads, that1.Threads)
	}
	if this.CpusUserTimeSecs != nil && that1.CpusUserTimeSecs != nil {
		if *this.CpusUserTimeSecs != *that1.CpusUserTimeSecs {
			return fmt.Errorf("CpusUserTimeSecs this(%v) Not Equal that(%v)", *this.CpusUserTimeSecs, *that1.CpusUserTimeSecs)
		}
	} else if this.CpusUserTimeSecs != nil {
		return fmt.Errorf("this.CpusUserTimeSecs == nil && that.CpusUserTimeSecs != nil")
	} else if that1.CpusUserTimeSecs != nil {
		return fmt.Errorf("CpusUserTimeSecs this(%v) Not Equal that(%v)", this.CpusUserTimeSecs, that1.CpusUserTimeSecs)
	}
	if this.CpusSystemTimeSecs != nil && that1.CpusSystemTimeSecs != nil {
		if *this.CpusSystemTimeSecs != *that1.CpusSystemTimeSecs {
			return fmt.Errorf("CpusSystemTimeSecs this(%v) Not Equal that(%v)", *this.CpusSystemTimeSecs, *that1.CpusSystemTimeSecs)
		}
	} else if this.CpusSystemTimeSecs != nil {
		return fmt.Errorf("this.CpusSystemTimeSecs == nil && that.CpusSystemTimeSecs != nil")
	} else if that1.CpusSystemTimeSecs != nil {
		return fmt.Errorf("CpusSystemTimeSecs this(%v) Not Equal that(%v)", this.CpusSystemTimeSecs, that1.CpusSystemTimeSecs)
	}
	if this.CpusLimit != nil && that1.CpusLimit != nil {
		if *this.CpusLimit != *that1.CpusLimit {
			return fmt.Errorf("CpusLimit this(%v) Not Equal that(%v)", *this.CpusLimit, *that1.CpusLimit)
		}
	} else if this.CpusLimit != nil {
		return fmt.Errorf("this.CpusLimit == nil && that.CpusLimit != nil")
	} else if that1.CpusLimit != nil {
		return fmt.Errorf("CpusLimit this(%v) Not Equal that(%v)", this.CpusLimit, that1.CpusLimit)
	}
	if this.CpusNrPeriods != nil && that1.CpusNrPeriods != nil {
		if *this.CpusNrPeriods != *that1.CpusNrPeriods {
			return fmt.Errorf("CpusNrPeriods this(%v) Not Equal that(%v)", *this.CpusNrPeriods, *that1.CpusNrPeriods)
		}
	} else if this.CpusNrPeriods != nil {
		return fmt.Errorf("this.CpusNrPeriods == nil && that.CpusNrPeriods != nil")
	} else if that1.CpusNrPeriods != nil {
		return fmt.Errorf("CpusNrPeriods this(%v) Not Equal that(%v)", this.CpusNrPeriods, that1.CpusNrPeriods)
	}
	if this.CpusNrThrottled != nil && that1.CpusNrThrottled != nil {
		if *this.CpusNrThrottled != *that1.CpusNrThrottled {
			return fmt.Errorf("CpusNrThrottled this(%v) Not Equal that(%v)", *this.CpusNrThrottled, *that1.CpusNrThrottled)
		}
	} else if this.CpusNrThrottled != nil {
		return fmt.Errorf("this.CpusNrThrottled == nil && that.CpusNrThrottled != nil")
	} else if that1.CpusNrThrottled != nil {
		return fmt.Errorf("CpusNrThrottled this(%v) Not Equal that(%v)", this.CpusNrThrottled, that1.CpusNrThrottled)
	}
	if this.CpusThrottledTimeSecs != nil && that1.CpusThrottledTimeSecs != nil {
		if *this.CpusThrottledTimeSecs != *that1.CpusThrottledTimeSecs {
			return fmt.Errorf("CpusThrottledTimeSecs this(%v) Not Equal that(%v)", *this.CpusThrottledTimeSecs, *that1.CpusThrottledTimeSecs)
		}
	} else if this.CpusThrottledTimeSecs != nil {
		return fmt.Errorf("this.CpusThrottledTimeSecs == nil && that.CpusThrottledTimeSecs != nil")
	} else if that1.CpusThrottledTimeSecs != nil {
		return fmt.Errorf("CpusThrottledTimeSecs this(%v) Not Equal that(%v)", this.CpusThrottledTimeSecs, that1.CpusThrottledTimeSecs)
	}
	if this.MemTotalBytes != nil && that1.MemTotalBytes != nil {
		if *this.MemTotalBytes != *that1.MemTotalBytes {
			return fmt.Errorf("MemTotalBytes this(%v) Not Equal that(%v)", *this.MemTotalBytes, *that1.MemTotalBytes)
		}
	} else if this.MemTotalBytes != nil {
		return fmt.Errorf("this.MemTotalBytes == nil && that.MemTotalBytes != nil")
	} else if that1.MemTotalBytes != nil {
		return fmt.Errorf("MemTotalBytes this(%v) Not Equal that(%v)", this.MemTotalBytes, that1.MemTotalBytes)
	}
	if this.MemTotalMemswBytes != nil && that1.MemTotalMemswBytes != nil {
		if *this.MemTotalMemswBytes != *that1.MemTotalMemswBytes {
			return fmt.Errorf("MemTotalMemswBytes this(%v) Not Equal that(%v)", *this.MemTotalMemswBytes, *that1.MemTotalMemswBytes)
		}
	} else if this.MemTotalMemswBytes != nil {
		return fmt.Errorf("this.MemTotalMemswBytes == nil && that.MemTotalMemswBytes != nil")
	} else if that1.MemTotalMemswBytes != nil {
		return fmt.Errorf("MemTotalMemswBytes this(%v) Not Equal that(%v)", this.MemTotalMemswBytes, that1.MemTotalMemswBytes)
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return fmt.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", *this.MemLimitBytes, *that1.MemLimitBytes)
		}
	} else if this.MemLimitBytes != nil {
		return fmt.Errorf("this.MemLimitBytes == nil && that.MemLimitBytes != nil")
	} else if that1.MemLimitBytes != nil {
		return fmt.Errorf("MemLimitBytes this(%v) Not Equal that(%v)", this.MemLimitBytes, that1.MemLimitBytes)
	}
	if this.MemSoftLimitBytes != nil && that1.MemSoftLimitBytes != nil {
		if *this.MemSoftLimitBytes != *that1.MemSoftLimitBytes {
			return fmt.Errorf("MemSoftLimitBytes this(%v) Not Equal that(%v)", *this.MemSoftLimitBytes, *that1.MemSoftLimitBytes)
		}
	} else if this.MemSoftLimitBytes != nil {
		return fmt.Errorf("this.MemSoftLimitBytes == nil && that.MemSoftLimitBytes != nil")
	} else if that1.MemSoftLimitBytes != nil {
		return fmt.Errorf("MemSoftLimitBytes this(%v) Not Equal that(%v)", this.MemSoftLimitBytes, that1.MemSoftLimitBytes)
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return fmt.Errorf("MemFileBytes this(%v) Not Equal that(%v)", *this.MemFileBytes, *that1.MemFileBytes)
		}
	} else if this.MemFileBytes != nil {
		return fmt.Errorf("this.MemFileBytes == nil && that.MemFileBytes != nil")
	} else if that1.MemFileBytes != nil {
		return fmt.Errorf("MemFileBytes this(%v) Not Equal that(%v)", this.MemFileBytes, that1.MemFileBytes)
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return fmt.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", *this.MemAnonBytes, *that1.MemAnonBytes)
		}
	} else if this.MemAnonBytes != nil {
		return fmt.Errorf("this.MemAnonBytes == nil && that.MemAnonBytes != nil")
	} else if that1.MemAnonBytes != nil {
		return fmt.Errorf("MemAnonBytes this(%v) Not Equal that(%v)", this.MemAnonBytes, that1.MemAnonBytes)
	}
	if this.MemCacheBytes != nil && that1.MemCacheBytes != nil {
		if *this.MemCacheBytes != *that1.MemCacheBytes {
			return fmt.Errorf("MemCacheBytes this(%v) Not Equal that(%v)", *this.MemCacheBytes, *that1.MemCacheBytes)
		}
	} else if this.MemCacheBytes != nil {
		return fmt.Errorf("this.MemCacheBytes == nil && that.MemCacheBytes != nil")
	} else if that1.MemCacheBytes != nil {
		return fmt.Errorf("MemCacheBytes this(%v) Not Equal that(%v)", this.MemCacheBytes, that1.MemCacheBytes)
	}
	if this.MemRssBytes != nil && that1.MemRssBytes != nil {
		if *this.MemRssBytes != *that1.MemRssBytes {
			return fmt.Errorf("MemRssBytes this(%v) Not Equal that(%v)", *this.MemRssBytes, *that1.MemRssBytes)
		}
	} else if this.MemRssBytes != nil {
		return fmt.Errorf("this.MemRssBytes == nil && that.MemRssBytes != nil")
	} else if that1.MemRssBytes != nil {
		return fmt.Errorf("MemRssBytes this(%v) Not Equal that(%v)", this.MemRssBytes, that1.MemRssBytes)
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return fmt.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", *this.MemMappedFileBytes, *that1.MemMappedFileBytes)
		}
	} else if this.MemMappedFileBytes != nil {
		return fmt.Errorf("this.MemMappedFileBytes == nil && that.MemMappedFileBytes != nil")
	} else if that1.MemMappedFileBytes != nil {
		return fmt.Errorf("MemMappedFileBytes this(%v) Not Equal that(%v)", this.MemMappedFileBytes, that1.MemMappedFileBytes)
	}
	if this.MemSwapBytes != nil && that1.MemSwapBytes != nil {
		if *this.MemSwapBytes != *that1.MemSwapBytes {
			return fmt.Errorf("MemSwapBytes this(%v) Not Equal that(%v)", *this.MemSwapBytes, *that1.MemSwapBytes)
		}
	} else if this.MemSwapBytes != nil {
		return fmt.Errorf("this.MemSwapBytes == nil && that.MemSwapBytes != nil")
	} else if that1.MemSwapBytes != nil {
		return fmt.Errorf("MemSwapBytes this(%v) Not Equal that(%v)", this.MemSwapBytes, that1.MemSwapBytes)
	}
	if this.MemUnevictableBytes != nil && that1.MemUnevictableBytes != nil {
		if *this.MemUnevictableBytes != *that1.MemUnevictableBytes {
			return fmt.Errorf("MemUnevictableBytes this(%v) Not Equal that(%v)", *this.MemUnevictableBytes, *that1.MemUnevictableBytes)
		}
	} else if this.MemUnevictableBytes != nil {
		return fmt.Errorf("this.MemUnevictableBytes == nil && that.MemUnevictableBytes != nil")
	} else if that1.MemUnevictableBytes != nil {
		return fmt.Errorf("MemUnevictableBytes this(%v) Not Equal that(%v)", this.MemUnevictableBytes, that1.MemUnevictableBytes)
	}
	if this.MemLowPressureCounter != nil && that1.MemLowPressureCounter != nil {
		if *this.MemLowPressureCounter != *that1.MemLowPressureCounter {
			return fmt.Errorf("MemLowPressureCounter this(%v) Not Equal that(%v)", *this.MemLowPressureCounter, *that1.MemLowPressureCounter)
		}
	} else if this.MemLowPressureCounter != nil {
		return fmt.Errorf("this.MemLowPressureCounter == nil && that.MemLowPressureCounter != nil")
	} else if that1.MemLowPressureCounter != nil {
		return fmt.Errorf("MemLowPressureCounter this(%v) Not Equal that(%v)", this.MemLowPressureCounter, that1.MemLowPressureCounter)
	}
	if this.MemMediumPressureCounter != nil && that1.MemMediumPressureCounter != nil {
		if *this.MemMediumPressureCounter != *that1.MemMediumPressureCounter {
			return fmt.Errorf("MemMediumPressureCounter this(%v) Not Equal that(%v)", *this.MemMediumPressureCounter, *that1.MemMediumPressureCounter)
		}
	} else if this.MemMediumPressureCounter != nil {
		return fmt.Errorf("this.MemMediumPressureCounter == nil && that.MemMediumPressureCounter != nil")
	} else if that1.MemMediumPressureCounter != nil {
		return fmt.Errorf("MemMediumPressureCounter this(%v) Not Equal that(%v)", this.MemMediumPressureCounter, that1.MemMediumPressureCounter)
	}
	if this.MemCriticalPressureCounter != nil && that1.MemCriticalPressureCounter != nil {
		if *this.MemCriticalPressureCounter != *that1.MemCriticalPressureCounter {
			return fmt.Errorf("MemCriticalPressureCounter this(%v) Not Equal that(%v)", *this.MemCriticalPressureCounter, *that1.MemCriticalPressureCounter)
		}
	} else if this.MemCriticalPressureCounter != nil {
		return fmt.Errorf("this.MemCriticalPressureCounter == nil && that.MemCriticalPressureCounter != nil")
	} else if that1.MemCriticalPressureCounter != nil {
		return fmt.Errorf("MemCriticalPressureCounter this(%v) Not Equal that(%v)", this.MemCriticalPressureCounter, that1.MemCriticalPressureCounter)
	}
	if this.DiskLimitBytes != nil && that1.DiskLimitBytes != nil {
		if *this.DiskLimitBytes != *that1.DiskLimitBytes {
			return fmt.Errorf("DiskLimitBytes this(%v) Not Equal that(%v)", *this.DiskLimitBytes, *that1.DiskLimitBytes)
		}
	} else if this.DiskLimitBytes != nil {
		return fmt.Errorf("this.DiskLimitBytes == nil && that.DiskLimitBytes != nil")
	} else if that1.DiskLimitBytes != nil {
		return fmt.Errorf("DiskLimitBytes this(%v) Not Equal that(%v)", this.DiskLimitBytes, that1.DiskLimitBytes)
	}
	if this.DiskUsedBytes != nil && that1.DiskUsedBytes != nil {
		if *this.DiskUsedBytes != *that1.DiskUsedBytes {
			return fmt.Errorf("DiskUsedBytes this(%v) Not Equal that(%v)", *this.DiskUsedBytes, *that1.DiskUsedBytes)
		}
	} else if this.DiskUsedBytes != nil {
		return fmt.Errorf("this.DiskUsedBytes == nil && that.DiskUsedBytes != nil")
	} else if that1.DiskUsedBytes != nil {
		return fmt.Errorf("DiskUsedBytes this(%v) Not Equal that(%v)", this.DiskUsedBytes, that1.DiskUsedBytes)
	}
	if !this.Perf.Equal(that1.Perf) {
		return fmt.Errorf("Perf this(%v) Not Equal that(%v)", this.Perf, that1.Perf)
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return fmt.Errorf("NetRxPackets this(%v) Not Equal that(%v)", *this.NetRxPackets, *that1.NetRxPackets)
		}
	} else if this.NetRxPackets != nil {
		return fmt.Errorf("this.NetRxPackets == nil && that.NetRxPackets != nil")
	} else if that1.NetRxPackets != nil {
		return fmt.Errorf("NetRxPackets this(%v) Not Equal that(%v)", this.NetRxPackets, that1.NetRxPackets)
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return fmt.Errorf("NetRxBytes this(%v) Not Equal that(%v)", *this.NetRxBytes, *that1.NetRxBytes)
		}
	} else if this.NetRxBytes != nil {
		return fmt.Errorf("this.NetRxBytes == nil && that.NetRxBytes != nil")
	} else if that1.NetRxBytes != nil {
		return fmt.Errorf("NetRxBytes this(%v) Not Equal that(%v)", this.NetRxBytes, that1.NetRxBytes)
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return fmt.Errorf("NetRxErrors this(%v) Not Equal that(%v)", *this.NetRxErrors, *that1.NetRxErrors)
		}
	} else if this.NetRxErrors != nil {
		return fmt.Errorf("this.NetRxErrors == nil && that.NetRxErrors != nil")
	} else if that1.NetRxErrors != nil {
		return fmt.Errorf("NetRxErrors this(%v) Not Equal that(%v)", this.NetRxErrors, that1.NetRxErrors)
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return fmt.Errorf("NetRxDropped this(%v) Not Equal that(%v)", *this.NetRxDropped, *that1.NetRxDropped)
		}
	} else if this.NetRxDropped != nil {
		return fmt.Errorf("this.NetRxDropped == nil && that.NetRxDropped != nil")
	} else if that1.NetRxDropped != nil {
		return fmt.Errorf("NetRxDropped this(%v) Not Equal that(%v)", this.NetRxDropped, that1.NetRxDropped)
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return fmt.Errorf("NetTxPackets this(%v) Not Equal that(%v)", *this.NetTxPackets, *that1.NetTxPackets)
		}
	} else if this.NetTxPackets != nil {
		return fmt.Errorf("this.NetTxPackets == nil && that.NetTxPackets != nil")
	} else if that1.NetTxPackets != nil {
		return fmt.Errorf("NetTxPackets this(%v) Not Equal that(%v)", this.NetTxPackets, that1.NetTxPackets)
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return fmt.Errorf("NetTxBytes this(%v) Not Equal that(%v)", *this.NetTxBytes, *that1.NetTxBytes)
		}
	} else if this.NetTxBytes != nil {
		return fmt.Errorf("this.NetTxBytes == nil && that.NetTxBytes != nil")
	} else if that1.NetTxBytes != nil {
		return fmt.Errorf("NetTxBytes this(%v) Not Equal that(%v)", this.NetTxBytes, that1.NetTxBytes)
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return fmt.Errorf("NetTxErrors this(%v) Not Equal that(%v)", *this.NetTxErrors, *that1.NetTxErrors)
		}
	} else if this.NetTxErrors != nil {
		return fmt.Errorf("this.NetTxErrors == nil && that.NetTxErrors != nil")
	} else if that1.NetTxErrors != nil {
		return fmt.Errorf("NetTxErrors this(%v) Not Equal that(%v)", this.NetTxErrors, that1.NetTxErrors)
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return fmt.Errorf("NetTxDropped this(%v) Not Equal that(%v)", *this.NetTxDropped, *that1.NetTxDropped)
		}
	} else if this.NetTxDropped != nil {
		return fmt.Errorf("this.NetTxDropped == nil && that.NetTxDropped != nil")
	} else if that1.NetTxDropped != nil {
		return fmt.Errorf("NetTxDropped this(%v) Not Equal that(%v)", this.NetTxDropped, that1.NetTxDropped)
	}
	if this.NetTcpRttMicrosecsP50 != nil && that1.NetTcpRttMicrosecsP50 != nil {
		if *this.NetTcpRttMicrosecsP50 != *that1.NetTcpRttMicrosecsP50 {
			return fmt.Errorf("NetTcpRttMicrosecsP50 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP50, *that1.NetTcpRttMicrosecsP50)
		}
	} else if this.NetTcpRttMicrosecsP50 != nil {
		return fmt.Errorf("this.NetTcpRttMicrosecsP50 == nil && that.NetTcpRttMicrosecsP50 != nil")
	} else if that1.NetTcpRttMicrosecsP50 != nil {
		return fmt.Errorf("NetTcpRttMicrosecsP50 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP50, that1.NetTcpRttMicrosecsP50)
	}
	if this.NetTcpRttMicrosecsP90 != nil && that1.NetTcpRttMicrosecsP90 != nil {
		if *this.NetTcpRttMicrosecsP90 != *that1.NetTcpRttMicrosecsP90 {
			return fmt.Errorf("NetTcpRttMicrosecsP90 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP90, *that1.NetTcpRttMicrosecsP90)
		}
	} else if this.NetTcpRttMicrosecsP90 != nil {
		return fmt.Errorf("this.NetTcpRttMicrosecsP90 == nil && that.NetTcpRttMicrosecsP90 != nil")
	} else if that1.NetTcpRttMicrosecsP90 != nil {
		return fmt.Errorf("NetTcpRttMicrosecsP90 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP90, that1.NetTcpRttMicrosecsP90)
	}
	if this.NetTcpRttMicrosecsP95 != nil && that1.NetTcpRttMicrosecsP95 != nil {
		if *this.NetTcpRttMicrosecsP95 != *that1.NetTcpRttMicrosecsP95 {
			return fmt.Errorf("NetTcpRttMicrosecsP95 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP95, *that1.NetTcpRttMicrosecsP95)
		}
	} else if this.NetTcpRttMicrosecsP95 != nil {
		return fmt.Errorf("this.NetTcpRttMicrosecsP95 == nil && that.NetTcpRttMicrosecsP95 != nil")
	} else if that1.NetTcpRttMicrosecsP95 != nil {
		return fmt.Errorf("NetTcpRttMicrosecsP95 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP95, that1.NetTcpRttMicrosecsP95)
	}
	if this.NetTcpRttMicrosecsP99 != nil && that1.NetTcpRttMicrosecsP99 != nil {
		if *this.NetTcpRttMicrosecsP99 != *that1.NetTcpRttMicrosecsP99 {
			return fmt.Errorf("NetTcpRttMicrosecsP99 this(%v) Not Equal that(%v)", *this.NetTcpRttMicrosecsP99, *that1.NetTcpRttMicrosecsP99)
		}
	} else if this.NetTcpRttMicrosecsP99 != nil {
		return fmt.Errorf("this.NetTcpRttMicrosecsP99 == nil && that.NetTcpRttMicrosecsP99 != nil")
	} else if that1.NetTcpRttMicrosecsP99 != nil {
		return fmt.Errorf("NetTcpRttMicrosecsP99 this(%v) Not Equal that(%v)", this.NetTcpRttMicrosecsP99, that1.NetTcpRttMicrosecsP99)
	}
	if this.NetTcpActiveConnections != nil && that1.NetTcpActiveConnections != nil {
		if *this.NetTcpActiveConnections != *that1.NetTcpActiveConnections {
			return fmt.Errorf("NetTcpActiveConnections this(%v) Not Equal that(%v)", *this.NetTcpActiveConnections, *that1.NetTcpActiveConnections)
		}
	} else if this.NetTcpActiveConnections != nil {
		return fmt.Errorf("this.NetTcpActiveConnections == nil && that.NetTcpActiveConnections != nil")
	} else if that1.NetTcpActiveConnections != nil {
		return fmt.Errorf("NetTcpActiveConnections this(%v) Not Equal that(%v)", this.NetTcpActiveConnections, that1.NetTcpActiveConnections)
	}
	if this.NetTcpTimeWaitConnections != nil && that1.NetTcpTimeWaitConnections != nil {
		if *this.NetTcpTimeWaitConnections != *that1.NetTcpTimeWaitConnections {
			return fmt.Errorf("NetTcpTimeWaitConnections this(%v) Not Equal that(%v)", *this.NetTcpTimeWaitConnections, *that1.NetTcpTimeWaitConnections)
		}
	} else if this.NetTcpTimeWaitConnections != nil {
		return fmt.Errorf("this.NetTcpTimeWaitConnections == nil && that.NetTcpTimeWaitConnections != nil")
	} else if that1.NetTcpTimeWaitConnections != nil {
		return fmt.Errorf("NetTcpTimeWaitConnections this(%v) Not Equal that(%v)", this.NetTcpTimeWaitConnections, that1.NetTcpTimeWaitConnections)
	}
	if len(this.NetTrafficControlStatistics) != len(that1.NetTrafficControlStatistics) {
		return fmt.Errorf("NetTrafficControlStatistics this(%v) Not Equal that(%v)", len(this.NetTrafficControlStatistics), len(that1.NetTrafficControlStatistics))
	}
	for i := range this.NetTrafficControlStatistics {
		if !this.NetTrafficControlStatistics[i].Equal(that1.NetTrafficControlStatistics[i]) {
			return fmt.Errorf("NetTrafficControlStatistics this[%v](%v) Not Equal that[%v](%v)", i, this.NetTrafficControlStatistics[i], i, that1.NetTrafficControlStatistics[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ResourceStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceStatistics)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if this.Processes != nil && that1.Processes != nil {
		if *this.Processes != *that1.Processes {
			return false
		}
	} else if this.Processes != nil {
		return false
	} else if that1.Processes != nil {
		return false
	}
	if this.Threads != nil && that1.Threads != nil {
		if *this.Threads != *that1.Threads {
			return false
		}
	} else if this.Threads != nil {
		return false
	} else if that1.Threads != nil {
		return false
	}
	if this.CpusUserTimeSecs != nil && that1.CpusUserTimeSecs != nil {
		if *this.CpusUserTimeSecs != *that1.CpusUserTimeSecs {
			return false
		}
	} else if this.CpusUserTimeSecs != nil {
		return false
	} else if that1.CpusUserTimeSecs != nil {
		return false
	}
	if this.CpusSystemTimeSecs != nil && that1.CpusSystemTimeSecs != nil {
		if *this.CpusSystemTimeSecs != *that1.CpusSystemTimeSecs {
			return false
		}
	} else if this.CpusSystemTimeSecs != nil {
		return false
	} else if that1.CpusSystemTimeSecs != nil {
		return false
	}
	if this.CpusLimit != nil && that1.CpusLimit != nil {
		if *this.CpusLimit != *that1.CpusLimit {
			return false
		}
	} else if this.CpusLimit != nil {
		return false
	} else if that1.CpusLimit != nil {
		return false
	}
	if this.CpusNrPeriods != nil && that1.CpusNrPeriods != nil {
		if *this.CpusNrPeriods != *that1.CpusNrPeriods {
			return false
		}
	} else if this.CpusNrPeriods != nil {
		return false
	} else if that1.CpusNrPeriods != nil {
		return false
	}
	if this.CpusNrThrottled != nil && that1.CpusNrThrottled != nil {
		if *this.CpusNrThrottled != *that1.CpusNrThrottled {
			return false
		}
	} else if this.CpusNrThrottled != nil {
		return false
	} else if that1.CpusNrThrottled != nil {
		return false
	}
	if this.CpusThrottledTimeSecs != nil && that1.CpusThrottledTimeSecs != nil {
		if *this.CpusThrottledTimeSecs != *that1.CpusThrottledTimeSecs {
			return false
		}
	} else if this.CpusThrottledTimeSecs != nil {
		return false
	} else if that1.CpusThrottledTimeSecs != nil {
		return false
	}
	if this.MemTotalBytes != nil && that1.MemTotalBytes != nil {
		if *this.MemTotalBytes != *that1.MemTotalBytes {
			return false
		}
	} else if this.MemTotalBytes != nil {
		return false
	} else if that1.MemTotalBytes != nil {
		return false
	}
	if this.MemTotalMemswBytes != nil && that1.MemTotalMemswBytes != nil {
		if *this.MemTotalMemswBytes != *that1.MemTotalMemswBytes {
			return false
		}
	} else if this.MemTotalMemswBytes != nil {
		return false
	} else if that1.MemTotalMemswBytes != nil {
		return false
	}
	if this.MemLimitBytes != nil && that1.MemLimitBytes != nil {
		if *this.MemLimitBytes != *that1.MemLimitBytes {
			return false
		}
	} else if this.MemLimitBytes != nil {
		return false
	} else if that1.MemLimitBytes != nil {
		return false
	}
	if this.MemSoftLimitBytes != nil && that1.MemSoftLimitBytes != nil {
		if *this.MemSoftLimitBytes != *that1.MemSoftLimitBytes {
			return false
		}
	} else if this.MemSoftLimitBytes != nil {
		return false
	} else if that1.MemSoftLimitBytes != nil {
		return false
	}
	if this.MemFileBytes != nil && that1.MemFileBytes != nil {
		if *this.MemFileBytes != *that1.MemFileBytes {
			return false
		}
	} else if this.MemFileBytes != nil {
		return false
	} else if that1.MemFileBytes != nil {
		return false
	}
	if this.MemAnonBytes != nil && that1.MemAnonBytes != nil {
		if *this.MemAnonBytes != *that1.MemAnonBytes {
			return false
		}
	} else if this.MemAnonBytes != nil {
		return false
	} else if that1.MemAnonBytes != nil {
		return false
	}
	if this.MemCacheBytes != nil && that1.MemCacheBytes != nil {
		if *this.MemCacheBytes != *that1.MemCacheBytes {
			return false
		}
	} else if this.MemCacheBytes != nil {
		return false
	} else if that1.MemCacheBytes != nil {
		return false
	}
	if this.MemRssBytes != nil && that1.MemRssBytes != nil {
		if *this.MemRssBytes != *that1.MemRssBytes {
			return false
		}
	} else if this.MemRssBytes != nil {
		return false
	} else if that1.MemRssBytes != nil {
		return false
	}
	if this.MemMappedFileBytes != nil && that1.MemMappedFileBytes != nil {
		if *this.MemMappedFileBytes != *that1.MemMappedFileBytes {
			return false
		}
	} else if this.MemMappedFileBytes != nil {
		return false
	} else if that1.MemMappedFileBytes != nil {
		return false
	}
	if this.MemSwapBytes != nil && that1.MemSwapBytes != nil {
		if *this.MemSwapBytes != *that1.MemSwapBytes {
			return false
		}
	} else if this.MemSwapBytes != nil {
		return false
	} else if that1.MemSwapBytes != nil {
		return false
	}
	if this.MemUnevictableBytes != nil && that1.MemUnevictableBytes != nil {
		if *this.MemUnevictableBytes != *that1.MemUnevictableBytes {
			return false
		}
	} else if this.MemUnevictableBytes != nil {
		return false
	} else if that1.MemUnevictableBytes != nil {
		return false
	}
	if this.MemLowPressureCounter != nil && that1.MemLowPressureCounter != nil {
		if *this.MemLowPressureCounter != *that1.MemLowPressureCounter {
			return false
		}
	} else if this.MemLowPressureCounter != nil {
		return false
	} else if that1.MemLowPressureCounter != nil {
		return false
	}
	if this.MemMediumPressureCounter != nil && that1.MemMediumPressureCounter != nil {
		if *this.MemMediumPressureCounter != *that1.MemMediumPressureCounter {
			return false
		}
	} else if this.MemMediumPressureCounter != nil {
		return false
	} else if that1.MemMediumPressureCounter != nil {
		return false
	}
	if this.MemCriticalPressureCounter != nil && that1.MemCriticalPressureCounter != nil {
		if *this.MemCriticalPressureCounter != *that1.MemCriticalPressureCounter {
			return false
		}
	} else if this.MemCriticalPressureCounter != nil {
		return false
	} else if that1.MemCriticalPressureCounter != nil {
		return false
	}
	if this.DiskLimitBytes != nil && that1.DiskLimitBytes != nil {
		if *this.DiskLimitBytes != *that1.DiskLimitBytes {
			return false
		}
	} else if this.DiskLimitBytes != nil {
		return false
	} else if that1.DiskLimitBytes != nil {
		return false
	}
	if this.DiskUsedBytes != nil && that1.DiskUsedBytes != nil {
		if *this.DiskUsedBytes != *that1.DiskUsedBytes {
			return false
		}
	} else if this.DiskUsedBytes != nil {
		return false
	} else if that1.DiskUsedBytes != nil {
		return false
	}
	if !this.Perf.Equal(that1.Perf) {
		return false
	}
	if this.NetRxPackets != nil && that1.NetRxPackets != nil {
		if *this.NetRxPackets != *that1.NetRxPackets {
			return false
		}
	} else if this.NetRxPackets != nil {
		return false
	} else if that1.NetRxPackets != nil {
		return false
	}
	if this.NetRxBytes != nil && that1.NetRxBytes != nil {
		if *this.NetRxBytes != *that1.NetRxBytes {
			return false
		}
	} else if this.NetRxBytes != nil {
		return false
	} else if that1.NetRxBytes != nil {
		return false
	}
	if this.NetRxErrors != nil && that1.NetRxErrors != nil {
		if *this.NetRxErrors != *that1.NetRxErrors {
			return false
		}
	} else if this.NetRxErrors != nil {
		return false
	} else if that1.NetRxErrors != nil {
		return false
	}
	if this.NetRxDropped != nil && that1.NetRxDropped != nil {
		if *this.NetRxDropped != *that1.NetRxDropped {
			return false
		}
	} else if this.NetRxDropped != nil {
		return false
	} else if that1.NetRxDropped != nil {
		return false
	}
	if this.NetTxPackets != nil && that1.NetTxPackets != nil {
		if *this.NetTxPackets != *that1.NetTxPackets {
			return false
		}
	} else if this.NetTxPackets != nil {
		return false
	} else if that1.NetTxPackets != nil {
		return false
	}
	if this.NetTxBytes != nil && that1.NetTxBytes != nil {
		if *this.NetTxBytes != *that1.NetTxBytes {
			return false
		}
	} else if this.NetTxBytes != nil {
		return false
	} else if that1.NetTxBytes != nil {
		return false
	}
	if this.NetTxErrors != nil && that1.NetTxErrors != nil {
		if *this.NetTxErrors != *that1.NetTxErrors {
			return false
		}
	} else if this.NetTxErrors != nil {
		return false
	} else if that1.NetTxErrors != nil {
		return false
	}
	if this.NetTxDropped != nil && that1.NetTxDropped != nil {
		if *this.NetTxDropped != *that1.NetTxDropped {
			return false
		}
	} else if this.NetTxDropped != nil {
		return false
	} else if that1.NetTxDropped != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP50 != nil && that1.NetTcpRttMicrosecsP50 != nil {
		if *this.NetTcpRttMicrosecsP50 != *that1.NetTcpRttMicrosecsP50 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP50 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP50 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP90 != nil && that1.NetTcpRttMicrosecsP90 != nil {
		if *this.NetTcpRttMicrosecsP90 != *that1.NetTcpRttMicrosecsP90 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP90 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP90 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP95 != nil && that1.NetTcpRttMicrosecsP95 != nil {
		if *this.NetTcpRttMicrosecsP95 != *that1.NetTcpRttMicrosecsP95 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP95 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP95 != nil {
		return false
	}
	if this.NetTcpRttMicrosecsP99 != nil && that1.NetTcpRttMicrosecsP99 != nil {
		if *this.NetTcpRttMicrosecsP99 != *that1.NetTcpRttMicrosecsP99 {
			return false
		}
	} else if this.NetTcpRttMicrosecsP99 != nil {
		return false
	} else if that1.NetTcpRttMicrosecsP99 != nil {
		return false
	}
	if this.NetTcpActiveConnections != nil && that1.NetTcpActiveConnections != nil {
		if *this.NetTcpActiveConnections != *that1.NetTcpActiveConnections {
			return false
		}
	} else if this.NetTcpActiveConnections != nil {
		return false
	} else if that1.NetTcpActiveConnections != nil {
		return false
	}
	if this.NetTcpTimeWaitConnections != nil && that1.NetTcpTimeWaitConnections != nil {
		if *this.NetTcpTimeWaitConnections != *that1.NetTcpTimeWaitConnections {
			return false
		}
	} else if this.NetTcpTimeWaitConnections != nil {
		return false
	} else if that1.NetTcpTimeWaitConnections != nil {
		return false
	}
	if len(this.NetTrafficControlStatistics) != len(that1.NetTrafficControlStatistics) {
		return false
	}
	for i := range this.NetTrafficControlStatistics {
		if !this.NetTrafficControlStatistics[i].Equal(that1.NetTrafficControlStatistics[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ResourceUsage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		return fmt.Errorf("that is not of type *ResourceUsage")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceUsage but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceUsagebut is not nil && this == nil")
	}
	if len(this.Executors) != len(that1.Executors) {
		return fmt.Errorf("Executors this(%v) Not Equal that(%v)", len(this.Executors), len(that1.Executors))
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(that1.Executors[i]) {
			return fmt.Errorf("Executors this[%v](%v) Not Equal that[%v](%v)", i, this.Executors[i], i, that1.Executors[i])
		}
	}
	if len(this.Total) != len(that1.Total) {
		return fmt.Errorf("Total this(%v) Not Equal that(%v)", len(this.Total), len(that1.Total))
	}
	for i := range this.Total {
		if !this.Total[i].Equal(that1.Total[i]) {
			return fmt.Errorf("Total this[%v](%v) Not Equal that[%v](%v)", i, this.Total[i], i, that1.Total[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ResourceUsage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Executors) != len(that1.Executors) {
		return false
	}
	for i := range this.Executors {
		if !this.Executors[i].Equal(that1.Executors[i]) {
			return false
		}
	}
	if len(this.Total) != len(that1.Total) {
		return false
	}
	for i := range this.Total {
		if !this.Total[i].Equal(that1.Total[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ResourceUsage_Executor) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ResourceUsage_Executor)
	if !ok {
		return fmt.Errorf("that is not of type *ResourceUsage_Executor")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ResourceUsage_Executor but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ResourceUsage_Executorbut is not nil && this == nil")
	}
	if !this.ExecutorInfo.Equal(that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	if len(this.Allocated) != len(that1.Allocated) {
		return fmt.Errorf("Allocated this(%v) Not Equal that(%v)", len(this.Allocated), len(that1.Allocated))
	}
	for i := range this.Allocated {
		if !this.Allocated[i].Equal(that1.Allocated[i]) {
			return fmt.Errorf("Allocated this[%v](%v) Not Equal that[%v](%v)", i, this.Allocated[i], i, that1.Allocated[i])
		}
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return fmt.Errorf("Statistics this(%v) Not Equal that(%v)", this.Statistics, that1.Statistics)
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ResourceUsage_Executor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ResourceUsage_Executor)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorInfo.Equal(that1.ExecutorInfo) {
		return false
	}
	if len(this.Allocated) != len(that1.Allocated) {
		return false
	}
	for i := range this.Allocated {
		if !this.Allocated[i].Equal(that1.Allocated[i]) {
			return false
		}
	}
	if !this.Statistics.Equal(that1.Statistics) {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PerfStatistics) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		return fmt.Errorf("that is not of type *PerfStatistics")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *PerfStatistics but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *PerfStatisticsbut is not nil && this == nil")
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if this.Duration != nil && that1.Duration != nil {
		if *this.Duration != *that1.Duration {
			return fmt.Errorf("Duration this(%v) Not Equal that(%v)", *this.Duration, *that1.Duration)
		}
	} else if this.Duration != nil {
		return fmt.Errorf("this.Duration == nil && that.Duration != nil")
	} else if that1.Duration != nil {
		return fmt.Errorf("Duration this(%v) Not Equal that(%v)", this.Duration, that1.Duration)
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return fmt.Errorf("Cycles this(%v) Not Equal that(%v)", *this.Cycles, *that1.Cycles)
		}
	} else if this.Cycles != nil {
		return fmt.Errorf("this.Cycles == nil && that.Cycles != nil")
	} else if that1.Cycles != nil {
		return fmt.Errorf("Cycles this(%v) Not Equal that(%v)", this.Cycles, that1.Cycles)
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return fmt.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", *this.StalledCyclesFrontend, *that1.StalledCyclesFrontend)
		}
	} else if this.StalledCyclesFrontend != nil {
		return fmt.Errorf("this.StalledCyclesFrontend == nil && that.StalledCyclesFrontend != nil")
	} else if that1.StalledCyclesFrontend != nil {
		return fmt.Errorf("StalledCyclesFrontend this(%v) Not Equal that(%v)", this.StalledCyclesFrontend, that1.StalledCyclesFrontend)
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return fmt.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", *this.StalledCyclesBackend, *that1.StalledCyclesBackend)
		}
	} else if this.StalledCyclesBackend != nil {
		return fmt.Errorf("this.StalledCyclesBackend == nil && that.StalledCyclesBackend != nil")
	} else if that1.StalledCyclesBackend != nil {
		return fmt.Errorf("StalledCyclesBackend this(%v) Not Equal that(%v)", this.StalledCyclesBackend, that1.StalledCyclesBackend)
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return fmt.Errorf("Instructions this(%v) Not Equal that(%v)", *this.Instructions, *that1.Instructions)
		}
	} else if this.Instructions != nil {
		return fmt.Errorf("this.Instructions == nil && that.Instructions != nil")
	} else if that1.Instructions != nil {
		return fmt.Errorf("Instructions this(%v) Not Equal that(%v)", this.Instructions, that1.Instructions)
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return fmt.Errorf("CacheReferences this(%v) Not Equal that(%v)", *this.CacheReferences, *that1.CacheReferences)
		}
	} else if this.CacheReferences != nil {
		return fmt.Errorf("this.CacheReferences == nil && that.CacheReferences != nil")
	} else if that1.CacheReferences != nil {
		return fmt.Errorf("CacheReferences this(%v) Not Equal that(%v)", this.CacheReferences, that1.CacheReferences)
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return fmt.Errorf("CacheMisses this(%v) Not Equal that(%v)", *this.CacheMisses, *that1.CacheMisses)
		}
	} else if this.CacheMisses != nil {
		return fmt.Errorf("this.CacheMisses == nil && that.CacheMisses != nil")
	} else if that1.CacheMisses != nil {
		return fmt.Errorf("CacheMisses this(%v) Not Equal that(%v)", this.CacheMisses, that1.CacheMisses)
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return fmt.Errorf("Branches this(%v) Not Equal that(%v)", *this.Branches, *that1.Branches)
		}
	} else if this.Branches != nil {
		return fmt.Errorf("this.Branches == nil && that.Branches != nil")
	} else if that1.Branches != nil {
		return fmt.Errorf("Branches this(%v) Not Equal that(%v)", this.Branches, that1.Branches)
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return fmt.Errorf("BranchMisses this(%v) Not Equal that(%v)", *this.BranchMisses, *that1.BranchMisses)
		}
	} else if this.BranchMisses != nil {
		return fmt.Errorf("this.BranchMisses == nil && that.BranchMisses != nil")
	} else if that1.BranchMisses != nil {
		return fmt.Errorf("BranchMisses this(%v) Not Equal that(%v)", this.BranchMisses, that1.BranchMisses)
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return fmt.Errorf("BusCycles this(%v) Not Equal that(%v)", *this.BusCycles, *that1.BusCycles)
		}
	} else if this.BusCycles != nil {
		return fmt.Errorf("this.BusCycles == nil && that.BusCycles != nil")
	} else if that1.BusCycles != nil {
		return fmt.Errorf("BusCycles this(%v) Not Equal that(%v)", this.BusCycles, that1.BusCycles)
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return fmt.Errorf("RefCycles this(%v) Not Equal that(%v)", *this.RefCycles, *that1.RefCycles)
		}
	} else if this.RefCycles != nil {
		return fmt.Errorf("this.RefCycles == nil && that.RefCycles != nil")
	} else if that1.RefCycles != nil {
		return fmt.Errorf("RefCycles this(%v) Not Equal that(%v)", this.RefCycles, that1.RefCycles)
	}
	if this.CpuClock != nil && that1.CpuClock != nil {
		if *this.CpuClock != *that1.CpuClock {
			return fmt.Errorf("CpuClock this(%v) Not Equal that(%v)", *this.CpuClock, *that1.CpuClock)
		}
	} else if this.CpuClock != nil {
		return fmt.Errorf("this.CpuClock == nil && that.CpuClock != nil")
	} else if that1.CpuClock != nil {
		return fmt.Errorf("CpuClock this(%v) Not Equal that(%v)", this.CpuClock, that1.CpuClock)
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return fmt.Errorf("TaskClock this(%v) Not Equal that(%v)", *this.TaskClock, *that1.TaskClock)
		}
	} else if this.TaskClock != nil {
		return fmt.Errorf("this.TaskClock == nil && that.TaskClock != nil")
	} else if that1.TaskClock != nil {
		return fmt.Errorf("TaskClock this(%v) Not Equal that(%v)", this.TaskClock, that1.TaskClock)
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return fmt.Errorf("PageFaults this(%v) Not Equal that(%v)", *this.PageFaults, *that1.PageFaults)
		}
	} else if this.PageFaults != nil {
		return fmt.Errorf("this.PageFaults == nil && that.PageFaults != nil")
	} else if that1.PageFaults != nil {
		return fmt.Errorf("PageFaults this(%v) Not Equal that(%v)", this.PageFaults, that1.PageFaults)
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return fmt.Errorf("MinorFaults this(%v) Not Equal that(%v)", *this.MinorFaults, *that1.MinorFaults)
		}
	} else if this.MinorFaults != nil {
		return fmt.Errorf("this.MinorFaults == nil && that.MinorFaults != nil")
	} else if that1.MinorFaults != nil {
		return fmt.Errorf("MinorFaults this(%v) Not Equal that(%v)", this.MinorFaults, that1.MinorFaults)
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return fmt.Errorf("MajorFaults this(%v) Not Equal that(%v)", *this.MajorFaults, *that1.MajorFaults)
		}
	} else if this.MajorFaults != nil {
		return fmt.Errorf("this.MajorFaults == nil && that.MajorFaults != nil")
	} else if that1.MajorFaults != nil {
		return fmt.Errorf("MajorFaults this(%v) Not Equal that(%v)", this.MajorFaults, that1.MajorFaults)
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return fmt.Errorf("ContextSwitches this(%v) Not Equal that(%v)", *this.ContextSwitches, *that1.ContextSwitches)
		}
	} else if this.ContextSwitches != nil {
		return fmt.Errorf("this.ContextSwitches == nil && that.ContextSwitches != nil")
	} else if that1.ContextSwitches != nil {
		return fmt.Errorf("ContextSwitches this(%v) Not Equal that(%v)", this.ContextSwitches, that1.ContextSwitches)
	}
	if this.CpuMigrations != nil && that1.CpuMigrations != nil {
		if *this.CpuMigrations != *that1.CpuMigrations {
			return fmt.Errorf("CpuMigrations this(%v) Not Equal that(%v)", *this.CpuMigrations, *that1.CpuMigrations)
		}
	} else if this.CpuMigrations != nil {
		return fmt.Errorf("this.CpuMigrations == nil && that.CpuMigrations != nil")
	} else if that1.CpuMigrations != nil {
		return fmt.Errorf("CpuMigrations this(%v) Not Equal that(%v)", this.CpuMigrations, that1.CpuMigrations)
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return fmt.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", *this.AlignmentFaults, *that1.AlignmentFaults)
		}
	} else if this.AlignmentFaults != nil {
		return fmt.Errorf("this.AlignmentFaults == nil && that.AlignmentFaults != nil")
	} else if that1.AlignmentFaults != nil {
		return fmt.Errorf("AlignmentFaults this(%v) Not Equal that(%v)", this.AlignmentFaults, that1.AlignmentFaults)
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return fmt.Errorf("EmulationFaults this(%v) Not Equal that(%v)", *this.EmulationFaults, *that1.EmulationFaults)
		}
	} else if this.EmulationFaults != nil {
		return fmt.Errorf("this.EmulationFaults == nil && that.EmulationFaults != nil")
	} else if that1.EmulationFaults != nil {
		return fmt.Errorf("EmulationFaults this(%v) Not Equal that(%v)", this.EmulationFaults, that1.EmulationFaults)
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return fmt.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", *this.L1DcacheLoads, *that1.L1DcacheLoads)
		}
	} else if this.L1DcacheLoads != nil {
		return fmt.Errorf("this.L1DcacheLoads == nil && that.L1DcacheLoads != nil")
	} else if that1.L1DcacheLoads != nil {
		return fmt.Errorf("L1DcacheLoads this(%v) Not Equal that(%v)", this.L1DcacheLoads, that1.L1DcacheLoads)
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return fmt.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1DcacheLoadMisses, *that1.L1DcacheLoadMisses)
		}
	} else if this.L1DcacheLoadMisses != nil {
		return fmt.Errorf("this.L1DcacheLoadMisses == nil && that.L1DcacheLoadMisses != nil")
	} else if that1.L1DcacheLoadMisses != nil {
		return fmt.Errorf("L1DcacheLoadMisses this(%v) Not Equal that(%v)", this.L1DcacheLoadMisses, that1.L1DcacheLoadMisses)
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return fmt.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", *this.L1DcacheStores, *that1.L1DcacheStores)
		}
	} else if this.L1DcacheStores != nil {
		return fmt.Errorf("this.L1DcacheStores == nil && that.L1DcacheStores != nil")
	} else if that1.L1DcacheStores != nil {
		return fmt.Errorf("L1DcacheStores this(%v) Not Equal that(%v)", this.L1DcacheStores, that1.L1DcacheStores)
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return fmt.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", *this.L1DcacheStoreMisses, *that1.L1DcacheStoreMisses)
		}
	} else if this.L1DcacheStoreMisses != nil {
		return fmt.Errorf("this.L1DcacheStoreMisses == nil && that.L1DcacheStoreMisses != nil")
	} else if that1.L1DcacheStoreMisses != nil {
		return fmt.Errorf("L1DcacheStoreMisses this(%v) Not Equal that(%v)", this.L1DcacheStoreMisses, that1.L1DcacheStoreMisses)
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return fmt.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", *this.L1DcachePrefetches, *that1.L1DcachePrefetches)
		}
	} else if this.L1DcachePrefetches != nil {
		return fmt.Errorf("this.L1DcachePrefetches == nil && that.L1DcachePrefetches != nil")
	} else if that1.L1DcachePrefetches != nil {
		return fmt.Errorf("L1DcachePrefetches this(%v) Not Equal that(%v)", this.L1DcachePrefetches, that1.L1DcachePrefetches)
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return fmt.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1DcachePrefetchMisses, *that1.L1DcachePrefetchMisses)
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return fmt.Errorf("this.L1DcachePrefetchMisses == nil && that.L1DcachePrefetchMisses != nil")
	} else if that1.L1DcachePrefetchMisses != nil {
		return fmt.Errorf("L1DcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1DcachePrefetchMisses, that1.L1DcachePrefetchMisses)
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return fmt.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", *this.L1IcacheLoads, *that1.L1IcacheLoads)
		}
	} else if this.L1IcacheLoads != nil {
		return fmt.Errorf("this.L1IcacheLoads == nil && that.L1IcacheLoads != nil")
	} else if that1.L1IcacheLoads != nil {
		return fmt.Errorf("L1IcacheLoads this(%v) Not Equal that(%v)", this.L1IcacheLoads, that1.L1IcacheLoads)
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return fmt.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", *this.L1IcacheLoadMisses, *that1.L1IcacheLoadMisses)
		}
	} else if this.L1IcacheLoadMisses != nil {
		return fmt.Errorf("this.L1IcacheLoadMisses == nil && that.L1IcacheLoadMisses != nil")
	} else if that1.L1IcacheLoadMisses != nil {
		return fmt.Errorf("L1IcacheLoadMisses this(%v) Not Equal that(%v)", this.L1IcacheLoadMisses, that1.L1IcacheLoadMisses)
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return fmt.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", *this.L1IcachePrefetches, *that1.L1IcachePrefetches)
		}
	} else if this.L1IcachePrefetches != nil {
		return fmt.Errorf("this.L1IcachePrefetches == nil && that.L1IcachePrefetches != nil")
	} else if that1.L1IcachePrefetches != nil {
		return fmt.Errorf("L1IcachePrefetches this(%v) Not Equal that(%v)", this.L1IcachePrefetches, that1.L1IcachePrefetches)
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return fmt.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", *this.L1IcachePrefetchMisses, *that1.L1IcachePrefetchMisses)
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return fmt.Errorf("this.L1IcachePrefetchMisses == nil && that.L1IcachePrefetchMisses != nil")
	} else if that1.L1IcachePrefetchMisses != nil {
		return fmt.Errorf("L1IcachePrefetchMisses this(%v) Not Equal that(%v)", this.L1IcachePrefetchMisses, that1.L1IcachePrefetchMisses)
	}
	if this.LlcLoads != nil && that1.LlcLoads != nil {
		if *this.LlcLoads != *that1.LlcLoads {
			return fmt.Errorf("LlcLoads this(%v) Not Equal that(%v)", *this.LlcLoads, *that1.LlcLoads)
		}
	} else if this.LlcLoads != nil {
		return fmt.Errorf("this.LlcLoads == nil && that.LlcLoads != nil")
	} else if that1.LlcLoads != nil {
		return fmt.Errorf("LlcLoads this(%v) Not Equal that(%v)", this.LlcLoads, that1.LlcLoads)
	}
	if this.LlcLoadMisses != nil && that1.LlcLoadMisses != nil {
		if *this.LlcLoadMisses != *that1.LlcLoadMisses {
			return fmt.Errorf("LlcLoadMisses this(%v) Not Equal that(%v)", *this.LlcLoadMisses, *that1.LlcLoadMisses)
		}
	} else if this.LlcLoadMisses != nil {
		return fmt.Errorf("this.LlcLoadMisses == nil && that.LlcLoadMisses != nil")
	} else if that1.LlcLoadMisses != nil {
		return fmt.Errorf("LlcLoadMisses this(%v) Not Equal that(%v)", this.LlcLoadMisses, that1.LlcLoadMisses)
	}
	if this.LlcStores != nil && that1.LlcStores != nil {
		if *this.LlcStores != *that1.LlcStores {
			return fmt.Errorf("LlcStores this(%v) Not Equal that(%v)", *this.LlcStores, *that1.LlcStores)
		}
	} else if this.LlcStores != nil {
		return fmt.Errorf("this.LlcStores == nil && that.LlcStores != nil")
	} else if that1.LlcStores != nil {
		return fmt.Errorf("LlcStores this(%v) Not Equal that(%v)", this.LlcStores, that1.LlcStores)
	}
	if this.LlcStoreMisses != nil && that1.LlcStoreMisses != nil {
		if *this.LlcStoreMisses != *that1.LlcStoreMisses {
			return fmt.Errorf("LlcStoreMisses this(%v) Not Equal that(%v)", *this.LlcStoreMisses, *that1.LlcStoreMisses)
		}
	} else if this.LlcStoreMisses != nil {
		return fmt.Errorf("this.LlcStoreMisses == nil && that.LlcStoreMisses != nil")
	} else if that1.LlcStoreMisses != nil {
		return fmt.Errorf("LlcStoreMisses this(%v) Not Equal that(%v)", this.LlcStoreMisses, that1.LlcStoreMisses)
	}
	if this.LlcPrefetches != nil && that1.LlcPrefetches != nil {
		if *this.LlcPrefetches != *that1.LlcPrefetches {
			return fmt.Errorf("LlcPrefetches this(%v) Not Equal that(%v)", *this.LlcPrefetches, *that1.LlcPrefetches)
		}
	} else if this.LlcPrefetches != nil {
		return fmt.Errorf("this.LlcPrefetches == nil && that.LlcPrefetches != nil")
	} else if that1.LlcPrefetches != nil {
		return fmt.Errorf("LlcPrefetches this(%v) Not Equal that(%v)", this.LlcPrefetches, that1.LlcPrefetches)
	}
	if this.LlcPrefetchMisses != nil && that1.LlcPrefetchMisses != nil {
		if *this.LlcPrefetchMisses != *that1.LlcPrefetchMisses {
			return fmt.Errorf("LlcPrefetchMisses this(%v) Not Equal that(%v)", *this.LlcPrefetchMisses, *that1.LlcPrefetchMisses)
		}
	} else if this.LlcPrefetchMisses != nil {
		return fmt.Errorf("this.LlcPrefetchMisses == nil && that.LlcPrefetchMisses != nil")
	} else if that1.LlcPrefetchMisses != nil {
		return fmt.Errorf("LlcPrefetchMisses this(%v) Not Equal that(%v)", this.LlcPrefetchMisses, that1.LlcPrefetchMisses)
	}
	if this.DtlbLoads != nil && that1.DtlbLoads != nil {
		if *this.DtlbLoads != *that1.DtlbLoads {
			return fmt.Errorf("DtlbLoads this(%v) Not Equal that(%v)", *this.DtlbLoads, *that1.DtlbLoads)
		}
	} else if this.DtlbLoads != nil {
		return fmt.Errorf("this.DtlbLoads == nil && that.DtlbLoads != nil")
	} else if that1.DtlbLoads != nil {
		return fmt.Errorf("DtlbLoads this(%v) Not Equal that(%v)", this.DtlbLoads, that1.DtlbLoads)
	}
	if this.DtlbLoadMisses != nil && that1.DtlbLoadMisses != nil {
		if *this.DtlbLoadMisses != *that1.DtlbLoadMisses {
			return fmt.Errorf("DtlbLoadMisses this(%v) Not Equal that(%v)", *this.DtlbLoadMisses, *that1.DtlbLoadMisses)
		}
	} else if this.DtlbLoadMisses != nil {
		return fmt.Errorf("this.DtlbLoadMisses == nil && that.DtlbLoadMisses != nil")
	} else if that1.DtlbLoadMisses != nil {
		return fmt.Errorf("DtlbLoadMisses this(%v) Not Equal that(%v)", this.DtlbLoadMisses, that1.DtlbLoadMisses)
	}
	if this.DtlbStores != nil && that1.DtlbStores != nil {
		if *this.DtlbStores != *that1.DtlbStores {
			return fmt.Errorf("DtlbStores this(%v) Not Equal that(%v)", *this.DtlbStores, *that1.DtlbStores)
		}
	} else if this.DtlbStores != nil {
		return fmt.Errorf("this.DtlbStores == nil && that.DtlbStores != nil")
	} else if that1.DtlbStores != nil {
		return fmt.Errorf("DtlbStores this(%v) Not Equal that(%v)", this.DtlbStores, that1.DtlbStores)
	}
	if this.DtlbStoreMisses != nil && that1.DtlbStoreMisses != nil {
		if *this.DtlbStoreMisses != *that1.DtlbStoreMisses {
			return fmt.Errorf("DtlbStoreMisses this(%v) Not Equal that(%v)", *this.DtlbStoreMisses, *that1.DtlbStoreMisses)
		}
	} else if this.DtlbStoreMisses != nil {
		return fmt.Errorf("this.DtlbStoreMisses == nil && that.DtlbStoreMisses != nil")
	} else if that1.DtlbStoreMisses != nil {
		return fmt.Errorf("DtlbStoreMisses this(%v) Not Equal that(%v)", this.DtlbStoreMisses, that1.DtlbStoreMisses)
	}
	if this.DtlbPrefetches != nil && that1.DtlbPrefetches != nil {
		if *this.DtlbPrefetches != *that1.DtlbPrefetches {
			return fmt.Errorf("DtlbPrefetches this(%v) Not Equal that(%v)", *this.DtlbPrefetches, *that1.DtlbPrefetches)
		}
	} else if this.DtlbPrefetches != nil {
		return fmt.Errorf("this.DtlbPrefetches == nil && that.DtlbPrefetches != nil")
	} else if that1.DtlbPrefetches != nil {
		return fmt.Errorf("DtlbPrefetches this(%v) Not Equal that(%v)", this.DtlbPrefetches, that1.DtlbPrefetches)
	}
	if this.DtlbPrefetchMisses != nil && that1.DtlbPrefetchMisses != nil {
		if *this.DtlbPrefetchMisses != *that1.DtlbPrefetchMisses {
			return fmt.Errorf("DtlbPrefetchMisses this(%v) Not Equal that(%v)", *this.DtlbPrefetchMisses, *that1.DtlbPrefetchMisses)
		}
	} else if this.DtlbPrefetchMisses != nil {
		return fmt.Errorf("this.DtlbPrefetchMisses == nil && that.DtlbPrefetchMisses != nil")
	} else if that1.DtlbPrefetchMisses != nil {
		return fmt.Errorf("DtlbPrefetchMisses this(%v) Not Equal that(%v)", this.DtlbPrefetchMisses, that1.DtlbPrefetchMisses)
	}
	if this.ItlbLoads != nil && that1.ItlbLoads != nil {
		if *this.ItlbLoads != *that1.ItlbLoads {
			return fmt.Errorf("ItlbLoads this(%v) Not Equal that(%v)", *this.ItlbLoads, *that1.ItlbLoads)
		}
	} else if this.ItlbLoads != nil {
		return fmt.Errorf("this.ItlbLoads == nil && that.ItlbLoads != nil")
	} else if that1.ItlbLoads != nil {
		return fmt.Errorf("ItlbLoads this(%v) Not Equal that(%v)", this.ItlbLoads, that1.ItlbLoads)
	}
	if this.ItlbLoadMisses != nil && that1.ItlbLoadMisses != nil {
		if *this.ItlbLoadMisses != *that1.ItlbLoadMisses {
			return fmt.Errorf("ItlbLoadMisses this(%v) Not Equal that(%v)", *this.ItlbLoadMisses, *that1.ItlbLoadMisses)
		}
	} else if this.ItlbLoadMisses != nil {
		return fmt.Errorf("this.ItlbLoadMisses == nil && that.ItlbLoadMisses != nil")
	} else if that1.ItlbLoadMisses != nil {
		return fmt.Errorf("ItlbLoadMisses this(%v) Not Equal that(%v)", this.ItlbLoadMisses, that1.ItlbLoadMisses)
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return fmt.Errorf("BranchLoads this(%v) Not Equal that(%v)", *this.BranchLoads, *that1.BranchLoads)
		}
	} else if this.BranchLoads != nil {
		return fmt.Errorf("this.BranchLoads == nil && that.BranchLoads != nil")
	} else if that1.BranchLoads != nil {
		return fmt.Errorf("BranchLoads this(%v) Not Equal that(%v)", this.BranchLoads, that1.BranchLoads)
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return fmt.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", *this.BranchLoadMisses, *that1.BranchLoadMisses)
		}
	} else if this.BranchLoadMisses != nil {
		return fmt.Errorf("this.BranchLoadMisses == nil && that.BranchLoadMisses != nil")
	} else if that1.BranchLoadMisses != nil {
		return fmt.Errorf("BranchLoadMisses this(%v) Not Equal that(%v)", this.BranchLoadMisses, that1.BranchLoadMisses)
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return fmt.Errorf("NodeLoads this(%v) Not Equal that(%v)", *this.NodeLoads, *that1.NodeLoads)
		}
	} else if this.NodeLoads != nil {
		return fmt.Errorf("this.NodeLoads == nil && that.NodeLoads != nil")
	} else if that1.NodeLoads != nil {
		return fmt.Errorf("NodeLoads this(%v) Not Equal that(%v)", this.NodeLoads, that1.NodeLoads)
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return fmt.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", *this.NodeLoadMisses, *that1.NodeLoadMisses)
		}
	} else if this.NodeLoadMisses != nil {
		return fmt.Errorf("this.NodeLoadMisses == nil && that.NodeLoadMisses != nil")
	} else if that1.NodeLoadMisses != nil {
		return fmt.Errorf("NodeLoadMisses this(%v) Not Equal that(%v)", this.NodeLoadMisses, that1.NodeLoadMisses)
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return fmt.Errorf("NodeStores this(%v) Not Equal that(%v)", *this.NodeStores, *that1.NodeStores)
		}
	} else if this.NodeStores != nil {
		return fmt.Errorf("this.NodeStores == nil && that.NodeStores != nil")
	} else if that1.NodeStores != nil {
		return fmt.Errorf("NodeStores this(%v) Not Equal that(%v)", this.NodeStores, that1.NodeStores)
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return fmt.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", *this.NodeStoreMisses, *that1.NodeStoreMisses)
		}
	} else if this.NodeStoreMisses != nil {
		return fmt.Errorf("this.NodeStoreMisses == nil && that.NodeStoreMisses != nil")
	} else if that1.NodeStoreMisses != nil {
		return fmt.Errorf("NodeStoreMisses this(%v) Not Equal that(%v)", this.NodeStoreMisses, that1.NodeStoreMisses)
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return fmt.Errorf("NodePrefetches this(%v) Not Equal that(%v)", *this.NodePrefetches, *that1.NodePrefetches)
		}
	} else if this.NodePrefetches != nil {
		return fmt.Errorf("this.NodePrefetches == nil && that.NodePrefetches != nil")
	} else if that1.NodePrefetches != nil {
		return fmt.Errorf("NodePrefetches this(%v) Not Equal that(%v)", this.NodePrefetches, that1.NodePrefetches)
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return fmt.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", *this.NodePrefetchMisses, *that1.NodePrefetchMisses)
		}
	} else if this.NodePrefetchMisses != nil {
		return fmt.Errorf("this.NodePrefetchMisses == nil && that.NodePrefetchMisses != nil")
	} else if that1.NodePrefetchMisses != nil {
		return fmt.Errorf("NodePrefetchMisses this(%v) Not Equal that(%v)", this.NodePrefetchMisses, that1.NodePrefetchMisses)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *PerfStatistics) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*PerfStatistics)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if this.Duration != nil && that1.Duration != nil {
		if *this.Duration != *that1.Duration {
			return false
		}
	} else if this.Duration != nil {
		return false
	} else if that1.Duration != nil {
		return false
	}
	if this.Cycles != nil && that1.Cycles != nil {
		if *this.Cycles != *that1.Cycles {
			return false
		}
	} else if this.Cycles != nil {
		return false
	} else if that1.Cycles != nil {
		return false
	}
	if this.StalledCyclesFrontend != nil && that1.StalledCyclesFrontend != nil {
		if *this.StalledCyclesFrontend != *that1.StalledCyclesFrontend {
			return false
		}
	} else if this.StalledCyclesFrontend != nil {
		return false
	} else if that1.StalledCyclesFrontend != nil {
		return false
	}
	if this.StalledCyclesBackend != nil && that1.StalledCyclesBackend != nil {
		if *this.StalledCyclesBackend != *that1.StalledCyclesBackend {
			return false
		}
	} else if this.StalledCyclesBackend != nil {
		return false
	} else if that1.StalledCyclesBackend != nil {
		return false
	}
	if this.Instructions != nil && that1.Instructions != nil {
		if *this.Instructions != *that1.Instructions {
			return false
		}
	} else if this.Instructions != nil {
		return false
	} else if that1.Instructions != nil {
		return false
	}
	if this.CacheReferences != nil && that1.CacheReferences != nil {
		if *this.CacheReferences != *that1.CacheReferences {
			return false
		}
	} else if this.CacheReferences != nil {
		return false
	} else if that1.CacheReferences != nil {
		return false
	}
	if this.CacheMisses != nil && that1.CacheMisses != nil {
		if *this.CacheMisses != *that1.CacheMisses {
			return false
		}
	} else if this.CacheMisses != nil {
		return false
	} else if that1.CacheMisses != nil {
		return false
	}
	if this.Branches != nil && that1.Branches != nil {
		if *this.Branches != *that1.Branches {
			return false
		}
	} else if this.Branches != nil {
		return false
	} else if that1.Branches != nil {
		return false
	}
	if this.BranchMisses != nil && that1.BranchMisses != nil {
		if *this.BranchMisses != *that1.BranchMisses {
			return false
		}
	} else if this.BranchMisses != nil {
		return false
	} else if that1.BranchMisses != nil {
		return false
	}
	if this.BusCycles != nil && that1.BusCycles != nil {
		if *this.BusCycles != *that1.BusCycles {
			return false
		}
	} else if this.BusCycles != nil {
		return false
	} else if that1.BusCycles != nil {
		return false
	}
	if this.RefCycles != nil && that1.RefCycles != nil {
		if *this.RefCycles != *that1.RefCycles {
			return false
		}
	} else if this.RefCycles != nil {
		return false
	} else if that1.RefCycles != nil {
		return false
	}
	if this.CpuClock != nil && that1.CpuClock != nil {
		if *this.CpuClock != *that1.CpuClock {
			return false
		}
	} else if this.CpuClock != nil {
		return false
	} else if that1.CpuClock != nil {
		return false
	}
	if this.TaskClock != nil && that1.TaskClock != nil {
		if *this.TaskClock != *that1.TaskClock {
			return false
		}
	} else if this.TaskClock != nil {
		return false
	} else if that1.TaskClock != nil {
		return false
	}
	if this.PageFaults != nil && that1.PageFaults != nil {
		if *this.PageFaults != *that1.PageFaults {
			return false
		}
	} else if this.PageFaults != nil {
		return false
	} else if that1.PageFaults != nil {
		return false
	}
	if this.MinorFaults != nil && that1.MinorFaults != nil {
		if *this.MinorFaults != *that1.MinorFaults {
			return false
		}
	} else if this.MinorFaults != nil {
		return false
	} else if that1.MinorFaults != nil {
		return false
	}
	if this.MajorFaults != nil && that1.MajorFaults != nil {
		if *this.MajorFaults != *that1.MajorFaults {
			return false
		}
	} else if this.MajorFaults != nil {
		return false
	} else if that1.MajorFaults != nil {
		return false
	}
	if this.ContextSwitches != nil && that1.ContextSwitches != nil {
		if *this.ContextSwitches != *that1.ContextSwitches {
			return false
		}
	} else if this.ContextSwitches != nil {
		return false
	} else if that1.ContextSwitches != nil {
		return false
	}
	if this.CpuMigrations != nil && that1.CpuMigrations != nil {
		if *this.CpuMigrations != *that1.CpuMigrations {
			return false
		}
	} else if this.CpuMigrations != nil {
		return false
	} else if that1.CpuMigrations != nil {
		return false
	}
	if this.AlignmentFaults != nil && that1.AlignmentFaults != nil {
		if *this.AlignmentFaults != *that1.AlignmentFaults {
			return false
		}
	} else if this.AlignmentFaults != nil {
		return false
	} else if that1.AlignmentFaults != nil {
		return false
	}
	if this.EmulationFaults != nil && that1.EmulationFaults != nil {
		if *this.EmulationFaults != *that1.EmulationFaults {
			return false
		}
	} else if this.EmulationFaults != nil {
		return false
	} else if that1.EmulationFaults != nil {
		return false
	}
	if this.L1DcacheLoads != nil && that1.L1DcacheLoads != nil {
		if *this.L1DcacheLoads != *that1.L1DcacheLoads {
			return false
		}
	} else if this.L1DcacheLoads != nil {
		return false
	} else if that1.L1DcacheLoads != nil {
		return false
	}
	if this.L1DcacheLoadMisses != nil && that1.L1DcacheLoadMisses != nil {
		if *this.L1DcacheLoadMisses != *that1.L1DcacheLoadMisses {
			return false
		}
	} else if this.L1DcacheLoadMisses != nil {
		return false
	} else if that1.L1DcacheLoadMisses != nil {
		return false
	}
	if this.L1DcacheStores != nil && that1.L1DcacheStores != nil {
		if *this.L1DcacheStores != *that1.L1DcacheStores {
			return false
		}
	} else if this.L1DcacheStores != nil {
		return false
	} else if that1.L1DcacheStores != nil {
		return false
	}
	if this.L1DcacheStoreMisses != nil && that1.L1DcacheStoreMisses != nil {
		if *this.L1DcacheStoreMisses != *that1.L1DcacheStoreMisses {
			return false
		}
	} else if this.L1DcacheStoreMisses != nil {
		return false
	} else if that1.L1DcacheStoreMisses != nil {
		return false
	}
	if this.L1DcachePrefetches != nil && that1.L1DcachePrefetches != nil {
		if *this.L1DcachePrefetches != *that1.L1DcachePrefetches {
			return false
		}
	} else if this.L1DcachePrefetches != nil {
		return false
	} else if that1.L1DcachePrefetches != nil {
		return false
	}
	if this.L1DcachePrefetchMisses != nil && that1.L1DcachePrefetchMisses != nil {
		if *this.L1DcachePrefetchMisses != *that1.L1DcachePrefetchMisses {
			return false
		}
	} else if this.L1DcachePrefetchMisses != nil {
		return false
	} else if that1.L1DcachePrefetchMisses != nil {
		return false
	}
	if this.L1IcacheLoads != nil && that1.L1IcacheLoads != nil {
		if *this.L1IcacheLoads != *that1.L1IcacheLoads {
			return false
		}
	} else if this.L1IcacheLoads != nil {
		return false
	} else if that1.L1IcacheLoads != nil {
		return false
	}
	if this.L1IcacheLoadMisses != nil && that1.L1IcacheLoadMisses != nil {
		if *this.L1IcacheLoadMisses != *that1.L1IcacheLoadMisses {
			return false
		}
	} else if this.L1IcacheLoadMisses != nil {
		return false
	} else if that1.L1IcacheLoadMisses != nil {
		return false
	}
	if this.L1IcachePrefetches != nil && that1.L1IcachePrefetches != nil {
		if *this.L1IcachePrefetches != *that1.L1IcachePrefetches {
			return false
		}
	} else if this.L1IcachePrefetches != nil {
		return false
	} else if that1.L1IcachePrefetches != nil {
		return false
	}
	if this.L1IcachePrefetchMisses != nil && that1.L1IcachePrefetchMisses != nil {
		if *this.L1IcachePrefetchMisses != *that1.L1IcachePrefetchMisses {
			return false
		}
	} else if this.L1IcachePrefetchMisses != nil {
		return false
	} else if that1.L1IcachePrefetchMisses != nil {
		return false
	}
	if this.LlcLoads != nil && that1.LlcLoads != nil {
		if *this.LlcLoads != *that1.LlcLoads {
			return false
		}
	} else if this.LlcLoads != nil {
		return false
	} else if that1.LlcLoads != nil {
		return false
	}
	if this.LlcLoadMisses != nil && that1.LlcLoadMisses != nil {
		if *this.LlcLoadMisses != *that1.LlcLoadMisses {
			return false
		}
	} else if this.LlcLoadMisses != nil {
		return false
	} else if that1.LlcLoadMisses != nil {
		return false
	}
	if this.LlcStores != nil && that1.LlcStores != nil {
		if *this.LlcStores != *that1.LlcStores {
			return false
		}
	} else if this.LlcStores != nil {
		return false
	} else if that1.LlcStores != nil {
		return false
	}
	if this.LlcStoreMisses != nil && that1.LlcStoreMisses != nil {
		if *this.LlcStoreMisses != *that1.LlcStoreMisses {
			return false
		}
	} else if this.LlcStoreMisses != nil {
		return false
	} else if that1.LlcStoreMisses != nil {
		return false
	}
	if this.LlcPrefetches != nil && that1.LlcPrefetches != nil {
		if *this.LlcPrefetches != *that1.LlcPrefetches {
			return false
		}
	} else if this.LlcPrefetches != nil {
		return false
	} else if that1.LlcPrefetches != nil {
		return false
	}
	if this.LlcPrefetchMisses != nil && that1.LlcPrefetchMisses != nil {
		if *this.LlcPrefetchMisses != *that1.LlcPrefetchMisses {
			return false
		}
	} else if this.LlcPrefetchMisses != nil {
		return false
	} else if that1.LlcPrefetchMisses != nil {
		return false
	}
	if this.DtlbLoads != nil && that1.DtlbLoads != nil {
		if *this.DtlbLoads != *that1.DtlbLoads {
			return false
		}
	} else if this.DtlbLoads != nil {
		return false
	} else if that1.DtlbLoads != nil {
		return false
	}
	if this.DtlbLoadMisses != nil && that1.DtlbLoadMisses != nil {
		if *this.DtlbLoadMisses != *that1.DtlbLoadMisses {
			return false
		}
	} else if this.DtlbLoadMisses != nil {
		return false
	} else if that1.DtlbLoadMisses != nil {
		return false
	}
	if this.DtlbStores != nil && that1.DtlbStores != nil {
		if *this.DtlbStores != *that1.DtlbStores {
			return false
		}
	} else if this.DtlbStores != nil {
		return false
	} else if that1.DtlbStores != nil {
		return false
	}
	if this.DtlbStoreMisses != nil && that1.DtlbStoreMisses != nil {
		if *this.DtlbStoreMisses != *that1.DtlbStoreMisses {
			return false
		}
	} else if this.DtlbStoreMisses != nil {
		return false
	} else if that1.DtlbStoreMisses != nil {
		return false
	}
	if this.DtlbPrefetches != nil && that1.DtlbPrefetches != nil {
		if *this.DtlbPrefetches != *that1.DtlbPrefetches {
			return false
		}
	} else if this.DtlbPrefetches != nil {
		return false
	} else if that1.DtlbPrefetches != nil {
		return false
	}
	if this.DtlbPrefetchMisses != nil && that1.DtlbPrefetchMisses != nil {
		if *this.DtlbPrefetchMisses != *that1.DtlbPrefetchMisses {
			return false
		}
	} else if this.DtlbPrefetchMisses != nil {
		return false
	} else if that1.DtlbPrefetchMisses != nil {
		return false
	}
	if this.ItlbLoads != nil && that1.ItlbLoads != nil {
		if *this.ItlbLoads != *that1.ItlbLoads {
			return false
		}
	} else if this.ItlbLoads != nil {
		return false
	} else if that1.ItlbLoads != nil {
		return false
	}
	if this.ItlbLoadMisses != nil && that1.ItlbLoadMisses != nil {
		if *this.ItlbLoadMisses != *that1.ItlbLoadMisses {
			return false
		}
	} else if this.ItlbLoadMisses != nil {
		return false
	} else if that1.ItlbLoadMisses != nil {
		return false
	}
	if this.BranchLoads != nil && that1.BranchLoads != nil {
		if *this.BranchLoads != *that1.BranchLoads {
			return false
		}
	} else if this.BranchLoads != nil {
		return false
	} else if that1.BranchLoads != nil {
		return false
	}
	if this.BranchLoadMisses != nil && that1.BranchLoadMisses != nil {
		if *this.BranchLoadMisses != *that1.BranchLoadMisses {
			return false
		}
	} else if this.BranchLoadMisses != nil {
		return false
	} else if that1.BranchLoadMisses != nil {
		return false
	}
	if this.NodeLoads != nil && that1.NodeLoads != nil {
		if *this.NodeLoads != *that1.NodeLoads {
			return false
		}
	} else if this.NodeLoads != nil {
		return false
	} else if that1.NodeLoads != nil {
		return false
	}
	if this.NodeLoadMisses != nil && that1.NodeLoadMisses != nil {
		if *this.NodeLoadMisses != *that1.NodeLoadMisses {
			return false
		}
	} else if this.NodeLoadMisses != nil {
		return false
	} else if that1.NodeLoadMisses != nil {
		return false
	}
	if this.NodeStores != nil && that1.NodeStores != nil {
		if *this.NodeStores != *that1.NodeStores {
			return false
		}
	} else if this.NodeStores != nil {
		return false
	} else if that1.NodeStores != nil {
		return false
	}
	if this.NodeStoreMisses != nil && that1.NodeStoreMisses != nil {
		if *this.NodeStoreMisses != *that1.NodeStoreMisses {
			return false
		}
	} else if this.NodeStoreMisses != nil {
		return false
	} else if that1.NodeStoreMisses != nil {
		return false
	}
	if this.NodePrefetches != nil && that1.NodePrefetches != nil {
		if *this.NodePrefetches != *that1.NodePrefetches {
			return false
		}
	} else if this.NodePrefetches != nil {
		return false
	} else if that1.NodePrefetches != nil {
		return false
	}
	if this.NodePrefetchMisses != nil && that1.NodePrefetchMisses != nil {
		if *this.NodePrefetchMisses != *that1.NodePrefetchMisses {
			return false
		}
	} else if this.NodePrefetchMisses != nil {
		return false
	} else if that1.NodePrefetchMisses != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Request) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Request)
	if !ok {
		return fmt.Errorf("that is not of type *Request")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Request but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Requestbut is not nil && this == nil")
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Request) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Request)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer)
	if !ok {
		return fmt.Errorf("that is not of type *Offer")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offerbut is not nil && this == nil")
	}
	if !this.Id.Equal(that1.Id) {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !this.Url.Equal(that1.Url) {
		return fmt.Errorf("Url this(%v) Not Equal that(%v)", this.Url, that1.Url)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return fmt.Errorf("Attributes this(%v) Not Equal that(%v)", len(this.Attributes), len(that1.Attributes))
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return fmt.Errorf("Attributes this[%v](%v) Not Equal that[%v](%v)", i, this.Attributes[i], i, that1.Attributes[i])
		}
	}
	if len(this.ExecutorIds) != len(that1.ExecutorIds) {
		return fmt.Errorf("ExecutorIds this(%v) Not Equal that(%v)", len(this.ExecutorIds), len(that1.ExecutorIds))
	}
	for i := range this.ExecutorIds {
		if !this.ExecutorIds[i].Equal(that1.ExecutorIds[i]) {
			return fmt.Errorf("ExecutorIds this[%v](%v) Not Equal that[%v](%v)", i, this.ExecutorIds[i], i, that1.ExecutorIds[i])
		}
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if !this.Url.Equal(that1.Url) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if len(this.Attributes) != len(that1.Attributes) {
		return false
	}
	for i := range this.Attributes {
		if !this.Attributes[i].Equal(that1.Attributes[i]) {
			return false
		}
	}
	if len(this.ExecutorIds) != len(that1.ExecutorIds) {
		return false
	}
	for i := range this.ExecutorIds {
		if !this.ExecutorIds[i].Equal(that1.ExecutorIds[i]) {
			return false
		}
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operationbut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Launch.Equal(that1.Launch) {
		return fmt.Errorf("Launch this(%v) Not Equal that(%v)", this.Launch, that1.Launch)
	}
	if !this.Reserve.Equal(that1.Reserve) {
		return fmt.Errorf("Reserve this(%v) Not Equal that(%v)", this.Reserve, that1.Reserve)
	}
	if !this.Unreserve.Equal(that1.Unreserve) {
		return fmt.Errorf("Unreserve this(%v) Not Equal that(%v)", this.Unreserve, that1.Unreserve)
	}
	if !this.Create.Equal(that1.Create) {
		return fmt.Errorf("Create this(%v) Not Equal that(%v)", this.Create, that1.Create)
	}
	if !this.Destroy.Equal(that1.Destroy) {
		return fmt.Errorf("Destroy this(%v) Not Equal that(%v)", this.Destroy, that1.Destroy)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Launch.Equal(that1.Launch) {
		return false
	}
	if !this.Reserve.Equal(that1.Reserve) {
		return false
	}
	if !this.Unreserve.Equal(that1.Unreserve) {
		return false
	}
	if !this.Create.Equal(that1.Create) {
		return false
	}
	if !this.Destroy.Equal(that1.Destroy) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation_Launch) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Launch)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation_Launch")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Launch but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Launchbut is not nil && this == nil")
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return fmt.Errorf("TaskInfos this(%v) Not Equal that(%v)", len(this.TaskInfos), len(that1.TaskInfos))
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return fmt.Errorf("TaskInfos this[%v](%v) Not Equal that[%v](%v)", i, this.TaskInfos[i], i, that1.TaskInfos[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation_Launch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Launch)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.TaskInfos) != len(that1.TaskInfos) {
		return false
	}
	for i := range this.TaskInfos {
		if !this.TaskInfos[i].Equal(that1.TaskInfos[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation_Reserve) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Reserve)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation_Reserve")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Reserve but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Reservebut is not nil && this == nil")
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation_Reserve) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Reserve)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation_Unreserve) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Unreserve)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation_Unreserve")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Unreserve but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Unreservebut is not nil && this == nil")
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation_Unreserve) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Unreserve)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation_Create) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Create)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation_Create")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Create but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Createbut is not nil && this == nil")
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation_Create) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Create)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Offer_Operation_Destroy) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Offer_Operation_Destroy)
	if !ok {
		return fmt.Errorf("that is not of type *Offer_Operation_Destroy")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Offer_Operation_Destroy but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Offer_Operation_Destroybut is not nil && this == nil")
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Offer_Operation_Destroy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Offer_Operation_Destroy)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *InverseOffer) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*InverseOffer)
	if !ok {
		return fmt.Errorf("that is not of type *InverseOffer")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *InverseOffer but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *InverseOfferbut is not nil && this == nil")
	}
	if !this.Id.Equal(that1.Id) {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if !this.Url.Equal(that1.Url) {
		return fmt.Errorf("Url this(%v) Not Equal that(%v)", this.Url, that1.Url)
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return fmt.Errorf("FrameworkId this(%v) Not Equal that(%v)", this.FrameworkId, that1.FrameworkId)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return fmt.Errorf("Unavailability this(%v) Not Equal that(%v)", this.Unavailability, that1.Unavailability)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *InverseOffer) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*InverseOffer)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Id.Equal(that1.Id) {
		return false
	}
	if !this.Url.Equal(that1.Url) {
		return false
	}
	if !this.FrameworkId.Equal(that1.FrameworkId) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if !this.Unavailability.Equal(that1.Unavailability) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		return fmt.Errorf("that is not of type *TaskInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskInfobut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return fmt.Errorf("TaskId this(%v) Not Equal that(%v)", this.TaskId, that1.TaskId)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return fmt.Errorf("Executor this(%v) Not Equal that(%v)", this.Executor, that1.Executor)
	}
	if !this.Command.Equal(that1.Command) {
		return fmt.Errorf("Command this(%v) Not Equal that(%v)", this.Command, that1.Command)
	}
	if !this.Container.Equal(that1.Container) {
		return fmt.Errorf("Container this(%v) Not Equal that(%v)", this.Container, that1.Container)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return fmt.Errorf("HealthCheck this(%v) Not Equal that(%v)", this.HealthCheck, that1.HealthCheck)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return fmt.Errorf("Discovery this(%v) Not Equal that(%v)", this.Discovery, that1.Discovery)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !this.Executor.Equal(that1.Executor) {
		return false
	}
	if !this.Command.Equal(that1.Command) {
		return false
	}
	if !this.Container.Equal(that1.Container) {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.HealthCheck.Equal(that1.HealthCheck) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !this.Discovery.Equal(that1.Discovery) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TaskStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		return fmt.Errorf("that is not of type *TaskStatus")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *TaskStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *TaskStatusbut is not nil && this == nil")
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return fmt.Errorf("TaskId this(%v) Not Equal that(%v)", this.TaskId, that1.TaskId)
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return fmt.Errorf("State this(%v) Not Equal that(%v)", *this.State, *that1.State)
		}
	} else if this.State != nil {
		return fmt.Errorf("this.State == nil && that.State != nil")
	} else if that1.State != nil {
		return fmt.Errorf("State this(%v) Not Equal that(%v)", this.State, that1.State)
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return fmt.Errorf("Message this(%v) Not Equal that(%v)", *this.Message, *that1.Message)
		}
	} else if this.Message != nil {
		return fmt.Errorf("this.Message == nil && that.Message != nil")
	} else if that1.Message != nil {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return fmt.Errorf("Source this(%v) Not Equal that(%v)", *this.Source, *that1.Source)
		}
	} else if this.Source != nil {
		return fmt.Errorf("this.Source == nil && that.Source != nil")
	} else if that1.Source != nil {
		return fmt.Errorf("Source this(%v) Not Equal that(%v)", this.Source, that1.Source)
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return fmt.Errorf("Reason this(%v) Not Equal that(%v)", *this.Reason, *that1.Reason)
		}
	} else if this.Reason != nil {
		return fmt.Errorf("this.Reason == nil && that.Reason != nil")
	} else if that1.Reason != nil {
		return fmt.Errorf("Reason this(%v) Not Equal that(%v)", this.Reason, that1.Reason)
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return fmt.Errorf("ExecutorId this(%v) Not Equal that(%v)", this.ExecutorId, that1.ExecutorId)
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", *this.Timestamp, *that1.Timestamp)
		}
	} else if this.Timestamp != nil {
		return fmt.Errorf("this.Timestamp == nil && that.Timestamp != nil")
	} else if that1.Timestamp != nil {
		return fmt.Errorf("Timestamp this(%v) Not Equal that(%v)", this.Timestamp, that1.Timestamp)
	}
	if !bytes.Equal(this.Uuid, that1.Uuid) {
		return fmt.Errorf("Uuid this(%v) Not Equal that(%v)", this.Uuid, that1.Uuid)
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", *this.Healthy, *that1.Healthy)
		}
	} else if this.Healthy != nil {
		return fmt.Errorf("this.Healthy == nil && that.Healthy != nil")
	} else if that1.Healthy != nil {
		return fmt.Errorf("Healthy this(%v) Not Equal that(%v)", this.Healthy, that1.Healthy)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return fmt.Errorf("ContainerStatus this(%v) Not Equal that(%v)", this.ContainerStatus, that1.ContainerStatus)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *TaskStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TaskStatus)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskId.Equal(that1.TaskId) {
		return false
	}
	if this.State != nil && that1.State != nil {
		if *this.State != *that1.State {
			return false
		}
	} else if this.State != nil {
		return false
	} else if that1.State != nil {
		return false
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return false
		}
	} else if this.Message != nil {
		return false
	} else if that1.Message != nil {
		return false
	}
	if this.Source != nil && that1.Source != nil {
		if *this.Source != *that1.Source {
			return false
		}
	} else if this.Source != nil {
		return false
	} else if that1.Source != nil {
		return false
	}
	if this.Reason != nil && that1.Reason != nil {
		if *this.Reason != *that1.Reason {
			return false
		}
	} else if this.Reason != nil {
		return false
	} else if that1.Reason != nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if !this.ExecutorId.Equal(that1.ExecutorId) {
		return false
	}
	if this.Timestamp != nil && that1.Timestamp != nil {
		if *this.Timestamp != *that1.Timestamp {
			return false
		}
	} else if this.Timestamp != nil {
		return false
	} else if that1.Timestamp != nil {
		return false
	}
	if !bytes.Equal(this.Uuid, that1.Uuid) {
		return false
	}
	if this.Healthy != nil && that1.Healthy != nil {
		if *this.Healthy != *that1.Healthy {
			return false
		}
	} else if this.Healthy != nil {
		return false
	} else if that1.Healthy != nil {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !this.ContainerStatus.Equal(that1.ContainerStatus) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Filters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Filters)
	if !ok {
		return fmt.Errorf("that is not of type *Filters")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Filters but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Filtersbut is not nil && this == nil")
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return fmt.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", *this.RefuseSeconds, *that1.RefuseSeconds)
		}
	} else if this.RefuseSeconds != nil {
		return fmt.Errorf("this.RefuseSeconds == nil && that.RefuseSeconds != nil")
	} else if that1.RefuseSeconds != nil {
		return fmt.Errorf("RefuseSeconds this(%v) Not Equal that(%v)", this.RefuseSeconds, that1.RefuseSeconds)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Filters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Filters)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RefuseSeconds != nil && that1.RefuseSeconds != nil {
		if *this.RefuseSeconds != *that1.RefuseSeconds {
			return false
		}
	} else if this.RefuseSeconds != nil {
		return false
	} else if that1.RefuseSeconds != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Environment) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment)
	if !ok {
		return fmt.Errorf("that is not of type *Environment")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Environment but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Environmentbut is not nil && this == nil")
	}
	if len(this.Variables) != len(that1.Variables) {
		return fmt.Errorf("Variables this(%v) Not Equal that(%v)", len(this.Variables), len(that1.Variables))
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(that1.Variables[i]) {
			return fmt.Errorf("Variables this[%v](%v) Not Equal that[%v](%v)", i, this.Variables[i], i, that1.Variables[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Environment) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Variables) != len(that1.Variables) {
		return false
	}
	for i := range this.Variables {
		if !this.Variables[i].Equal(that1.Variables[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Environment_Variable) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		return fmt.Errorf("that is not of type *Environment_Variable")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Environment_Variable but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Environment_Variablebut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Environment_Variable) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Environment_Variable)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Parameter) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameter)
	if !ok {
		return fmt.Errorf("that is not of type *Parameter")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Parameter but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Parameterbut is not nil && this == nil")
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return fmt.Errorf("Key this(%v) Not Equal that(%v)", *this.Key, *that1.Key)
		}
	} else if this.Key != nil {
		return fmt.Errorf("this.Key == nil && that.Key != nil")
	} else if that1.Key != nil {
		return fmt.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Parameter) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameter)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return false
		}
	} else if this.Key != nil {
		return false
	} else if that1.Key != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Parameters) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Parameters)
	if !ok {
		return fmt.Errorf("that is not of type *Parameters")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Parameters but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Parametersbut is not nil && this == nil")
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return fmt.Errorf("Parameter this(%v) Not Equal that(%v)", len(this.Parameter), len(that1.Parameter))
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(that1.Parameter[i]) {
			return fmt.Errorf("Parameter this[%v](%v) Not Equal that[%v](%v)", i, this.Parameter[i], i, that1.Parameter[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Parameters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Parameters)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Parameter) != len(that1.Parameter) {
		return false
	}
	for i := range this.Parameter {
		if !this.Parameter[i].Equal(that1.Parameter[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Credential) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credential)
	if !ok {
		return fmt.Errorf("that is not of type *Credential")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Credential but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Credentialbut is not nil && this == nil")
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.Secret != nil && that1.Secret != nil {
		if *this.Secret != *that1.Secret {
			return fmt.Errorf("Secret this(%v) Not Equal that(%v)", *this.Secret, *that1.Secret)
		}
	} else if this.Secret != nil {
		return fmt.Errorf("this.Secret == nil && that.Secret != nil")
	} else if that1.Secret != nil {
		return fmt.Errorf("Secret this(%v) Not Equal that(%v)", this.Secret, that1.Secret)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Credential) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credential)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.Secret != nil && that1.Secret != nil {
		if *this.Secret != *that1.Secret {
			return false
		}
	} else if this.Secret != nil {
		return false
	} else if that1.Secret != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Credentials) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Credentials)
	if !ok {
		return fmt.Errorf("that is not of type *Credentials")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Credentials but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Credentialsbut is not nil && this == nil")
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return fmt.Errorf("Credentials this(%v) Not Equal that(%v)", len(this.Credentials), len(that1.Credentials))
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(that1.Credentials[i]) {
			return fmt.Errorf("Credentials this[%v](%v) Not Equal that[%v](%v)", i, this.Credentials[i], i, that1.Credentials[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Credentials) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Credentials)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return false
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(that1.Credentials[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimit) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		return fmt.Errorf("that is not of type *RateLimit")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RateLimit but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RateLimitbut is not nil && this == nil")
	}
	if this.Qps != nil && that1.Qps != nil {
		if *this.Qps != *that1.Qps {
			return fmt.Errorf("Qps this(%v) Not Equal that(%v)", *this.Qps, *that1.Qps)
		}
	} else if this.Qps != nil {
		return fmt.Errorf("this.Qps == nil && that.Qps != nil")
	} else if that1.Qps != nil {
		return fmt.Errorf("Qps this(%v) Not Equal that(%v)", this.Qps, that1.Qps)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return fmt.Errorf("Capacity this(%v) Not Equal that(%v)", *this.Capacity, *that1.Capacity)
		}
	} else if this.Capacity != nil {
		return fmt.Errorf("this.Capacity == nil && that.Capacity != nil")
	} else if that1.Capacity != nil {
		return fmt.Errorf("Capacity this(%v) Not Equal that(%v)", this.Capacity, that1.Capacity)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RateLimit) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Qps != nil && that1.Qps != nil {
		if *this.Qps != *that1.Qps {
			return false
		}
	} else if this.Qps != nil {
		return false
	} else if that1.Qps != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if this.Capacity != nil && that1.Capacity != nil {
		if *this.Capacity != *that1.Capacity {
			return false
		}
	} else if this.Capacity != nil {
		return false
	} else if that1.Capacity != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RateLimits) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		return fmt.Errorf("that is not of type *RateLimits")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RateLimits but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RateLimitsbut is not nil && this == nil")
	}
	if len(this.Limits) != len(that1.Limits) {
		return fmt.Errorf("Limits this(%v) Not Equal that(%v)", len(this.Limits), len(that1.Limits))
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return fmt.Errorf("Limits this[%v](%v) Not Equal that[%v](%v)", i, this.Limits[i], i, that1.Limits[i])
		}
	}
	if this.AggregateDefaultQps != nil && that1.AggregateDefaultQps != nil {
		if *this.AggregateDefaultQps != *that1.AggregateDefaultQps {
			return fmt.Errorf("AggregateDefaultQps this(%v) Not Equal that(%v)", *this.AggregateDefaultQps, *that1.AggregateDefaultQps)
		}
	} else if this.AggregateDefaultQps != nil {
		return fmt.Errorf("this.AggregateDefaultQps == nil && that.AggregateDefaultQps != nil")
	} else if that1.AggregateDefaultQps != nil {
		return fmt.Errorf("AggregateDefaultQps this(%v) Not Equal that(%v)", this.AggregateDefaultQps, that1.AggregateDefaultQps)
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return fmt.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", *this.AggregateDefaultCapacity, *that1.AggregateDefaultCapacity)
		}
	} else if this.AggregateDefaultCapacity != nil {
		return fmt.Errorf("this.AggregateDefaultCapacity == nil && that.AggregateDefaultCapacity != nil")
	} else if that1.AggregateDefaultCapacity != nil {
		return fmt.Errorf("AggregateDefaultCapacity this(%v) Not Equal that(%v)", this.AggregateDefaultCapacity, that1.AggregateDefaultCapacity)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RateLimits) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimits)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		if !this.Limits[i].Equal(that1.Limits[i]) {
			return false
		}
	}
	if this.AggregateDefaultQps != nil && that1.AggregateDefaultQps != nil {
		if *this.AggregateDefaultQps != *that1.AggregateDefaultQps {
			return false
		}
	} else if this.AggregateDefaultQps != nil {
		return false
	} else if that1.AggregateDefaultQps != nil {
		return false
	}
	if this.AggregateDefaultCapacity != nil && that1.AggregateDefaultCapacity != nil {
		if *this.AggregateDefaultCapacity != *that1.AggregateDefaultCapacity {
			return false
		}
	} else if this.AggregateDefaultCapacity != nil {
		return false
	} else if that1.AggregateDefaultCapacity != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Image) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image)
	if !ok {
		return fmt.Errorf("that is not of type *Image")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Imagebut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Appc.Equal(that1.Appc) {
		return fmt.Errorf("Appc this(%v) Not Equal that(%v)", this.Appc, that1.Appc)
	}
	if !this.Docker.Equal(that1.Docker) {
		return fmt.Errorf("Docker this(%v) Not Equal that(%v)", this.Docker, that1.Docker)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Image) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Appc.Equal(that1.Appc) {
		return false
	}
	if !this.Docker.Equal(that1.Docker) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Image_Appc) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image_Appc)
	if !ok {
		return fmt.Errorf("that is not of type *Image_Appc")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image_Appc but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Image_Appcbut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return fmt.Errorf("Id this(%v) Not Equal that(%v)", *this.Id, *that1.Id)
		}
	} else if this.Id != nil {
		return fmt.Errorf("this.Id == nil && that.Id != nil")
	} else if that1.Id != nil {
		return fmt.Errorf("Id this(%v) Not Equal that(%v)", this.Id, that1.Id)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Image_Appc) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image_Appc)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Id != nil && that1.Id != nil {
		if *this.Id != *that1.Id {
			return false
		}
	} else if this.Id != nil {
		return false
	} else if that1.Id != nil {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Image_Docker) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Image_Docker)
	if !ok {
		return fmt.Errorf("that is not of type *Image_Docker")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Image_Docker but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Image_Dockerbut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Image_Docker) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Image_Docker)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Volume) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Volume)
	if !ok {
		return fmt.Errorf("that is not of type *Volume")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Volume but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Volumebut is not nil && this == nil")
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return fmt.Errorf("Mode this(%v) Not Equal that(%v)", *this.Mode, *that1.Mode)
		}
	} else if this.Mode != nil {
		return fmt.Errorf("this.Mode == nil && that.Mode != nil")
	} else if that1.Mode != nil {
		return fmt.Errorf("Mode this(%v) Not Equal that(%v)", this.Mode, that1.Mode)
	}
	if this.ContainerPath != nil && that1.ContainerPath != nil {
		if *this.ContainerPath != *that1.ContainerPath {
			return fmt.Errorf("ContainerPath this(%v) Not Equal that(%v)", *this.ContainerPath, *that1.ContainerPath)
		}
	} else if this.ContainerPath != nil {
		return fmt.Errorf("this.ContainerPath == nil && that.ContainerPath != nil")
	} else if that1.ContainerPath != nil {
		return fmt.Errorf("ContainerPath this(%v) Not Equal that(%v)", this.ContainerPath, that1.ContainerPath)
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return fmt.Errorf("HostPath this(%v) Not Equal that(%v)", *this.HostPath, *that1.HostPath)
		}
	} else if this.HostPath != nil {
		return fmt.Errorf("this.HostPath == nil && that.HostPath != nil")
	} else if that1.HostPath != nil {
		return fmt.Errorf("HostPath this(%v) Not Equal that(%v)", this.HostPath, that1.HostPath)
	}
	if !this.Image.Equal(that1.Image) {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Volume) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Volume)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Mode != nil && that1.Mode != nil {
		if *this.Mode != *that1.Mode {
			return false
		}
	} else if this.Mode != nil {
		return false
	} else if that1.Mode != nil {
		return false
	}
	if this.ContainerPath != nil && that1.ContainerPath != nil {
		if *this.ContainerPath != *that1.ContainerPath {
			return false
		}
	} else if this.ContainerPath != nil {
		return false
	} else if that1.ContainerPath != nil {
		return false
	}
	if this.HostPath != nil && that1.HostPath != nil {
		if *this.HostPath != *that1.HostPath {
			return false
		}
	} else if this.HostPath != nil {
		return false
	} else if that1.HostPath != nil {
		return false
	}
	if !this.Image.Equal(that1.Image) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *NetworkInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*NetworkInfo)
	if !ok {
		return fmt.Errorf("that is not of type *NetworkInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *NetworkInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *NetworkInfobut is not nil && this == nil")
	}
	if len(this.IpAddresses) != len(that1.IpAddresses) {
		return fmt.Errorf("IpAddresses this(%v) Not Equal that(%v)", len(this.IpAddresses), len(that1.IpAddresses))
	}
	for i := range this.IpAddresses {
		if !this.IpAddresses[i].Equal(that1.IpAddresses[i]) {
			return fmt.Errorf("IpAddresses this[%v](%v) Not Equal that[%v](%v)", i, this.IpAddresses[i], i, that1.IpAddresses[i])
		}
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.IpAddress != nil && that1.IpAddress != nil {
		if *this.IpAddress != *that1.IpAddress {
			return fmt.Errorf("IpAddress this(%v) Not Equal that(%v)", *this.IpAddress, *that1.IpAddress)
		}
	} else if this.IpAddress != nil {
		return fmt.Errorf("this.IpAddress == nil && that.IpAddress != nil")
	} else if that1.IpAddress != nil {
		return fmt.Errorf("IpAddress this(%v) Not Equal that(%v)", this.IpAddress, that1.IpAddress)
	}
	if len(this.Groups) != len(that1.Groups) {
		return fmt.Errorf("Groups this(%v) Not Equal that(%v)", len(this.Groups), len(that1.Groups))
	}
	for i := range this.Groups {
		if this.Groups[i] != that1.Groups[i] {
			return fmt.Errorf("Groups this[%v](%v) Not Equal that[%v](%v)", i, this.Groups[i], i, that1.Groups[i])
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *NetworkInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*NetworkInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.IpAddresses) != len(that1.IpAddresses) {
		return false
	}
	for i := range this.IpAddresses {
		if !this.IpAddresses[i].Equal(that1.IpAddresses[i]) {
			return false
		}
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.IpAddress != nil && that1.IpAddress != nil {
		if *this.IpAddress != *that1.IpAddress {
			return false
		}
	} else if this.IpAddress != nil {
		return false
	} else if that1.IpAddress != nil {
		return false
	}
	if len(this.Groups) != len(that1.Groups) {
		return false
	}
	for i := range this.Groups {
		if this.Groups[i] != that1.Groups[i] {
			return false
		}
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *NetworkInfo_IPAddress) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*NetworkInfo_IPAddress)
	if !ok {
		return fmt.Errorf("that is not of type *NetworkInfo_IPAddress")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *NetworkInfo_IPAddress but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *NetworkInfo_IPAddressbut is not nil && this == nil")
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.IpAddress != nil && that1.IpAddress != nil {
		if *this.IpAddress != *that1.IpAddress {
			return fmt.Errorf("IpAddress this(%v) Not Equal that(%v)", *this.IpAddress, *that1.IpAddress)
		}
	} else if this.IpAddress != nil {
		return fmt.Errorf("this.IpAddress == nil && that.IpAddress != nil")
	} else if that1.IpAddress != nil {
		return fmt.Errorf("IpAddress this(%v) Not Equal that(%v)", this.IpAddress, that1.IpAddress)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *NetworkInfo_IPAddress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*NetworkInfo_IPAddress)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.IpAddress != nil && that1.IpAddress != nil {
		if *this.IpAddress != *that1.IpAddress {
			return false
		}
	} else if this.IpAddress != nil {
		return false
	} else if that1.IpAddress != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfobut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return fmt.Errorf("Volumes this(%v) Not Equal that(%v)", len(this.Volumes), len(that1.Volumes))
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return fmt.Errorf("Volumes this[%v](%v) Not Equal that[%v](%v)", i, this.Volumes[i], i, that1.Volumes[i])
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", *this.Hostname, *that1.Hostname)
		}
	} else if this.Hostname != nil {
		return fmt.Errorf("this.Hostname == nil && that.Hostname != nil")
	} else if that1.Hostname != nil {
		return fmt.Errorf("Hostname this(%v) Not Equal that(%v)", this.Hostname, that1.Hostname)
	}
	if !this.Docker.Equal(that1.Docker) {
		return fmt.Errorf("Docker this(%v) Not Equal that(%v)", this.Docker, that1.Docker)
	}
	if !this.Mesos.Equal(that1.Mesos) {
		return fmt.Errorf("Mesos this(%v) Not Equal that(%v)", this.Mesos, that1.Mesos)
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return fmt.Errorf("NetworkInfos this(%v) Not Equal that(%v)", len(this.NetworkInfos), len(that1.NetworkInfos))
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(that1.NetworkInfos[i]) {
			return fmt.Errorf("NetworkInfos this[%v](%v) Not Equal that[%v](%v)", i, this.NetworkInfos[i], i, that1.NetworkInfos[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if len(this.Volumes) != len(that1.Volumes) {
		return false
	}
	for i := range this.Volumes {
		if !this.Volumes[i].Equal(that1.Volumes[i]) {
			return false
		}
	}
	if this.Hostname != nil && that1.Hostname != nil {
		if *this.Hostname != *that1.Hostname {
			return false
		}
	} else if this.Hostname != nil {
		return false
	} else if that1.Hostname != nil {
		return false
	}
	if !this.Docker.Equal(that1.Docker) {
		return false
	}
	if !this.Mesos.Equal(that1.Mesos) {
		return false
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return false
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(that1.NetworkInfos[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerInfo_DockerInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_DockerInfobut is not nil && this == nil")
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return fmt.Errorf("Image this(%v) Not Equal that(%v)", *this.Image, *that1.Image)
		}
	} else if this.Image != nil {
		return fmt.Errorf("this.Image == nil && that.Image != nil")
	} else if that1.Image != nil {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return fmt.Errorf("Network this(%v) Not Equal that(%v)", *this.Network, *that1.Network)
		}
	} else if this.Network != nil {
		return fmt.Errorf("this.Network == nil && that.Network != nil")
	} else if that1.Network != nil {
		return fmt.Errorf("Network this(%v) Not Equal that(%v)", this.Network, that1.Network)
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return fmt.Errorf("PortMappings this(%v) Not Equal that(%v)", len(this.PortMappings), len(that1.PortMappings))
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(that1.PortMappings[i]) {
			return fmt.Errorf("PortMappings this[%v](%v) Not Equal that[%v](%v)", i, this.PortMappings[i], i, that1.PortMappings[i])
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return fmt.Errorf("Privileged this(%v) Not Equal that(%v)", *this.Privileged, *that1.Privileged)
		}
	} else if this.Privileged != nil {
		return fmt.Errorf("this.Privileged == nil && that.Privileged != nil")
	} else if that1.Privileged != nil {
		return fmt.Errorf("Privileged this(%v) Not Equal that(%v)", this.Privileged, that1.Privileged)
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return fmt.Errorf("Parameters this(%v) Not Equal that(%v)", len(this.Parameters), len(that1.Parameters))
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(that1.Parameters[i]) {
			return fmt.Errorf("Parameters this[%v](%v) Not Equal that[%v](%v)", i, this.Parameters[i], i, that1.Parameters[i])
		}
	}
	if this.ForcePullImage != nil && that1.ForcePullImage != nil {
		if *this.ForcePullImage != *that1.ForcePullImage {
			return fmt.Errorf("ForcePullImage this(%v) Not Equal that(%v)", *this.ForcePullImage, *that1.ForcePullImage)
		}
	} else if this.ForcePullImage != nil {
		return fmt.Errorf("this.ForcePullImage == nil && that.ForcePullImage != nil")
	} else if that1.ForcePullImage != nil {
		return fmt.Errorf("ForcePullImage this(%v) Not Equal that(%v)", this.ForcePullImage, that1.ForcePullImage)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Image != nil && that1.Image != nil {
		if *this.Image != *that1.Image {
			return false
		}
	} else if this.Image != nil {
		return false
	} else if that1.Image != nil {
		return false
	}
	if this.Network != nil && that1.Network != nil {
		if *this.Network != *that1.Network {
			return false
		}
	} else if this.Network != nil {
		return false
	} else if that1.Network != nil {
		return false
	}
	if len(this.PortMappings) != len(that1.PortMappings) {
		return false
	}
	for i := range this.PortMappings {
		if !this.PortMappings[i].Equal(that1.PortMappings[i]) {
			return false
		}
	}
	if this.Privileged != nil && that1.Privileged != nil {
		if *this.Privileged != *that1.Privileged {
			return false
		}
	} else if this.Privileged != nil {
		return false
	} else if that1.Privileged != nil {
		return false
	}
	if len(this.Parameters) != len(that1.Parameters) {
		return false
	}
	for i := range this.Parameters {
		if !this.Parameters[i].Equal(that1.Parameters[i]) {
			return false
		}
	}
	if this.ForcePullImage != nil && that1.ForcePullImage != nil {
		if *this.ForcePullImage != *that1.ForcePullImage {
			return false
		}
	} else if this.ForcePullImage != nil {
		return false
	} else if that1.ForcePullImage != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo_DockerInfo_PortMapping) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerInfo_DockerInfo_PortMapping")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo_PortMapping but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_DockerInfo_PortMappingbut is not nil && this == nil")
	}
	if this.HostPort != nil && that1.HostPort != nil {
		if *this.HostPort != *that1.HostPort {
			return fmt.Errorf("HostPort this(%v) Not Equal that(%v)", *this.HostPort, *that1.HostPort)
		}
	} else if this.HostPort != nil {
		return fmt.Errorf("this.HostPort == nil && that.HostPort != nil")
	} else if that1.HostPort != nil {
		return fmt.Errorf("HostPort this(%v) Not Equal that(%v)", this.HostPort, that1.HostPort)
	}
	if this.ContainerPort != nil && that1.ContainerPort != nil {
		if *this.ContainerPort != *that1.ContainerPort {
			return fmt.Errorf("ContainerPort this(%v) Not Equal that(%v)", *this.ContainerPort, *that1.ContainerPort)
		}
	} else if this.ContainerPort != nil {
		return fmt.Errorf("this.ContainerPort == nil && that.ContainerPort != nil")
	} else if that1.ContainerPort != nil {
		return fmt.Errorf("ContainerPort this(%v) Not Equal that(%v)", this.ContainerPort, that1.ContainerPort)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo_DockerInfo_PortMapping) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_DockerInfo_PortMapping)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostPort != nil && that1.HostPort != nil {
		if *this.HostPort != *that1.HostPort {
			return false
		}
	} else if this.HostPort != nil {
		return false
	} else if that1.HostPort != nil {
		return false
	}
	if this.ContainerPort != nil && that1.ContainerPort != nil {
		if *this.ContainerPort != *that1.ContainerPort {
			return false
		}
	} else if this.ContainerPort != nil {
		return false
	} else if that1.ContainerPort != nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerInfo_MesosInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerInfo_MesosInfo)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerInfo_MesosInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerInfo_MesosInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerInfo_MesosInfobut is not nil && this == nil")
	}
	if !this.Image.Equal(that1.Image) {
		return fmt.Errorf("Image this(%v) Not Equal that(%v)", this.Image, that1.Image)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerInfo_MesosInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerInfo_MesosInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Image.Equal(that1.Image) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ContainerStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*ContainerStatus)
	if !ok {
		return fmt.Errorf("that is not of type *ContainerStatus")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *ContainerStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *ContainerStatusbut is not nil && this == nil")
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return fmt.Errorf("NetworkInfos this(%v) Not Equal that(%v)", len(this.NetworkInfos), len(that1.NetworkInfos))
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(that1.NetworkInfos[i]) {
			return fmt.Errorf("NetworkInfos this[%v](%v) Not Equal that[%v](%v)", i, this.NetworkInfos[i], i, that1.NetworkInfos[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *ContainerStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ContainerStatus)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.NetworkInfos) != len(that1.NetworkInfos) {
		return false
	}
	for i := range this.NetworkInfos {
		if !this.NetworkInfos[i].Equal(that1.NetworkInfos[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Labels) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Labels)
	if !ok {
		return fmt.Errorf("that is not of type *Labels")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Labels but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Labelsbut is not nil && this == nil")
	}
	if len(this.Labels) != len(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", len(this.Labels), len(that1.Labels))
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return fmt.Errorf("Labels this[%v](%v) Not Equal that[%v](%v)", i, this.Labels[i], i, that1.Labels[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Labels) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Labels)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Label) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Label)
	if !ok {
		return fmt.Errorf("that is not of type *Label")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Label but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Labelbut is not nil && this == nil")
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return fmt.Errorf("Key this(%v) Not Equal that(%v)", *this.Key, *that1.Key)
		}
	} else if this.Key != nil {
		return fmt.Errorf("this.Key == nil && that.Key != nil")
	} else if that1.Key != nil {
		return fmt.Errorf("Key this(%v) Not Equal that(%v)", this.Key, that1.Key)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Label) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Label)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != nil && that1.Key != nil {
		if *this.Key != *that1.Key {
			return false
		}
	} else if this.Key != nil {
		return false
	} else if that1.Key != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Port) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Port)
	if !ok {
		return fmt.Errorf("that is not of type *Port")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Port but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Portbut is not nil && this == nil")
	}
	if this.Number != nil && that1.Number != nil {
		if *this.Number != *that1.Number {
			return fmt.Errorf("Number this(%v) Not Equal that(%v)", *this.Number, *that1.Number)
		}
	} else if this.Number != nil {
		return fmt.Errorf("this.Number == nil && that.Number != nil")
	} else if that1.Number != nil {
		return fmt.Errorf("Number this(%v) Not Equal that(%v)", this.Number, that1.Number)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", *this.Protocol, *that1.Protocol)
		}
	} else if this.Protocol != nil {
		return fmt.Errorf("this.Protocol == nil && that.Protocol != nil")
	} else if that1.Protocol != nil {
		return fmt.Errorf("Protocol this(%v) Not Equal that(%v)", this.Protocol, that1.Protocol)
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", *this.Visibility, *that1.Visibility)
		}
	} else if this.Visibility != nil {
		return fmt.Errorf("this.Visibility == nil && that.Visibility != nil")
	} else if that1.Visibility != nil {
		return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", this.Visibility, that1.Visibility)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Port) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Port)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Number != nil && that1.Number != nil {
		if *this.Number != *that1.Number {
			return false
		}
	} else if this.Number != nil {
		return false
	} else if that1.Number != nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Protocol != nil && that1.Protocol != nil {
		if *this.Protocol != *that1.Protocol {
			return false
		}
	} else if this.Protocol != nil {
		return false
	} else if that1.Protocol != nil {
		return false
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return false
		}
	} else if this.Visibility != nil {
		return false
	} else if that1.Visibility != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Ports) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Ports)
	if !ok {
		return fmt.Errorf("that is not of type *Ports")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Ports but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Portsbut is not nil && this == nil")
	}
	if len(this.Ports) != len(that1.Ports) {
		return fmt.Errorf("Ports this(%v) Not Equal that(%v)", len(this.Ports), len(that1.Ports))
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return fmt.Errorf("Ports this[%v](%v) Not Equal that[%v](%v)", i, this.Ports[i], i, that1.Ports[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Ports) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Ports)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if !this.Ports[i].Equal(that1.Ports[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DiscoveryInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*DiscoveryInfo)
	if !ok {
		return fmt.Errorf("that is not of type *DiscoveryInfo")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *DiscoveryInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *DiscoveryInfobut is not nil && this == nil")
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", *this.Visibility, *that1.Visibility)
		}
	} else if this.Visibility != nil {
		return fmt.Errorf("this.Visibility == nil && that.Visibility != nil")
	} else if that1.Visibility != nil {
		return fmt.Errorf("Visibility this(%v) Not Equal that(%v)", this.Visibility, that1.Visibility)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Environment != nil && that1.Environment != nil {
		if *this.Environment != *that1.Environment {
			return fmt.Errorf("Environment this(%v) Not Equal that(%v)", *this.Environment, *that1.Environment)
		}
	} else if this.Environment != nil {
		return fmt.Errorf("this.Environment == nil && that.Environment != nil")
	} else if that1.Environment != nil {
		return fmt.Errorf("Environment this(%v) Not Equal that(%v)", this.Environment, that1.Environment)
	}
	if this.Location != nil && that1.Location != nil {
		if *this.Location != *that1.Location {
			return fmt.Errorf("Location this(%v) Not Equal that(%v)", *this.Location, *that1.Location)
		}
	} else if this.Location != nil {
		return fmt.Errorf("this.Location == nil && that.Location != nil")
	} else if that1.Location != nil {
		return fmt.Errorf("Location this(%v) Not Equal that(%v)", this.Location, that1.Location)
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return fmt.Errorf("Version this(%v) Not Equal that(%v)", *this.Version, *that1.Version)
		}
	} else if this.Version != nil {
		return fmt.Errorf("this.Version == nil && that.Version != nil")
	} else if that1.Version != nil {
		return fmt.Errorf("Version this(%v) Not Equal that(%v)", this.Version, that1.Version)
	}
	if !this.Ports.Equal(that1.Ports) {
		return fmt.Errorf("Ports this(%v) Not Equal that(%v)", this.Ports, that1.Ports)
	}
	if !this.Labels.Equal(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", this.Labels, that1.Labels)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *DiscoveryInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DiscoveryInfo)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Visibility != nil && that1.Visibility != nil {
		if *this.Visibility != *that1.Visibility {
			return false
		}
	} else if this.Visibility != nil {
		return false
	} else if that1.Visibility != nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Environment != nil && that1.Environment != nil {
		if *this.Environment != *that1.Environment {
			return false
		}
	} else if this.Environment != nil {
		return false
	} else if that1.Environment != nil {
		return false
	}
	if this.Location != nil && that1.Location != nil {
		if *this.Location != *that1.Location {
			return false
		}
	} else if this.Location != nil {
		return false
	} else if that1.Location != nil {
		return false
	}
	if this.Version != nil && that1.Version != nil {
		if *this.Version != *that1.Version {
			return false
		}
	} else if this.Version != nil {
		return false
	} else if that1.Version != nil {
		return false
	}
	if !this.Ports.Equal(that1.Ports) {
		return false
	}
	if !this.Labels.Equal(that1.Labels) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *AppcImageManifest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AppcImageManifest)
	if !ok {
		return fmt.Errorf("that is not of type *AppcImageManifest")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AppcImageManifest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AppcImageManifestbut is not nil && this == nil")
	}
	if this.AcKind != nil && that1.AcKind != nil {
		if *this.AcKind != *that1.AcKind {
			return fmt.Errorf("AcKind this(%v) Not Equal that(%v)", *this.AcKind, *that1.AcKind)
		}
	} else if this.AcKind != nil {
		return fmt.Errorf("this.AcKind == nil && that.AcKind != nil")
	} else if that1.AcKind != nil {
		return fmt.Errorf("AcKind this(%v) Not Equal that(%v)", this.AcKind, that1.AcKind)
	}
	if this.AcVersion != nil && that1.AcVersion != nil {
		if *this.AcVersion != *that1.AcVersion {
			return fmt.Errorf("AcVersion this(%v) Not Equal that(%v)", *this.AcVersion, *that1.AcVersion)
		}
	} else if this.AcVersion != nil {
		return fmt.Errorf("this.AcVersion == nil && that.AcVersion != nil")
	} else if that1.AcVersion != nil {
		return fmt.Errorf("AcVersion this(%v) Not Equal that(%v)", this.AcVersion, that1.AcVersion)
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if len(this.Labels) != len(that1.Labels) {
		return fmt.Errorf("Labels this(%v) Not Equal that(%v)", len(this.Labels), len(that1.Labels))
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return fmt.Errorf("Labels this[%v](%v) Not Equal that[%v](%v)", i, this.Labels[i], i, that1.Labels[i])
		}
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return fmt.Errorf("Annotations this(%v) Not Equal that(%v)", len(this.Annotations), len(that1.Annotations))
	}
	for i := range this.Annotations {
		if !this.Annotations[i].Equal(that1.Annotations[i]) {
			return fmt.Errorf("Annotations this[%v](%v) Not Equal that[%v](%v)", i, this.Annotations[i], i, that1.Annotations[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *AppcImageManifest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AppcImageManifest)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.AcKind != nil && that1.AcKind != nil {
		if *this.AcKind != *that1.AcKind {
			return false
		}
	} else if this.AcKind != nil {
		return false
	} else if that1.AcKind != nil {
		return false
	}
	if this.AcVersion != nil && that1.AcVersion != nil {
		if *this.AcVersion != *that1.AcVersion {
			return false
		}
	} else if this.AcVersion != nil {
		return false
	} else if that1.AcVersion != nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return false
		}
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if !this.Annotations[i].Equal(that1.Annotations[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *AppcImageManifest_Label) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AppcImageManifest_Label)
	if !ok {
		return fmt.Errorf("that is not of type *AppcImageManifest_Label")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AppcImageManifest_Label but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AppcImageManifest_Labelbut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *AppcImageManifest_Label) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AppcImageManifest_Label)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *AppcImageManifest_Annotation) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*AppcImageManifest_Annotation)
	if !ok {
		return fmt.Errorf("that is not of type *AppcImageManifest_Annotation")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *AppcImageManifest_Annotation but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *AppcImageManifest_Annotationbut is not nil && this == nil")
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return fmt.Errorf("Name this(%v) Not Equal that(%v)", *this.Name, *that1.Name)
		}
	} else if this.Name != nil {
		return fmt.Errorf("this.Name == nil && that.Name != nil")
	} else if that1.Name != nil {
		return fmt.Errorf("Name this(%v) Not Equal that(%v)", this.Name, that1.Name)
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return fmt.Errorf("Value this(%v) Not Equal that(%v)", *this.Value, *that1.Value)
		}
	} else if this.Value != nil {
		return fmt.Errorf("this.Value == nil && that.Value != nil")
	} else if that1.Value != nil {
		return fmt.Errorf("Value this(%v) Not Equal that(%v)", this.Value, that1.Value)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *AppcImageManifest_Annotation) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*AppcImageManifest_Annotation)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != nil && that1.Name != nil {
		if *this.Name != *that1.Name {
			return false
		}
	} else if this.Name != nil {
		return false
	} else if that1.Name != nil {
		return false
	}
	if this.Value != nil && that1.Value != nil {
		if *this.Value != *that1.Value {
			return false
		}
	} else if this.Value != nil {
		return false
	} else if that1.Value != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *FrameworkID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.FrameworkID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OfferID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.OfferID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SlaveID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.SlaveID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.TaskID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecutorID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.ExecutorID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.ContainerID{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TimeInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.TimeInfo{")
	if this.Nanoseconds != nil {
		s = append(s, "Nanoseconds: "+valueToGoStringMesos(this.Nanoseconds, "int64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DurationInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.DurationInfo{")
	if this.Nanoseconds != nil {
		s = append(s, "Nanoseconds: "+valueToGoStringMesos(this.Nanoseconds, "int64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Address) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.Address{")
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Ip != nil {
		s = append(s, "Ip: "+valueToGoStringMesos(this.Ip, "string")+",\n")
	}
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "int32")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *URL) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesosproto.URL{")
	if this.Scheme != nil {
		s = append(s, "Scheme: "+valueToGoStringMesos(this.Scheme, "string")+",\n")
	}
	if this.Address != nil {
		s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	}
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	if this.Query != nil {
		s = append(s, "Query: "+fmt.Sprintf("%#v", this.Query)+",\n")
	}
	if this.Fragment != nil {
		s = append(s, "Fragment: "+valueToGoStringMesos(this.Fragment, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Unavailability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Unavailability{")
	if this.Start != nil {
		s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	}
	if this.Duration != nil {
		s = append(s, "Duration: "+fmt.Sprintf("%#v", this.Duration)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MachineID) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.MachineID{")
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Ip != nil {
		s = append(s, "Ip: "+valueToGoStringMesos(this.Ip, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MachineInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.MachineInfo{")
	if this.Id != nil {
		s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	}
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "mesosproto.MachineInfo_Mode")+",\n")
	}
	if this.Unavailability != nil {
		s = append(s, "Unavailability: "+fmt.Sprintf("%#v", this.Unavailability)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FrameworkInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&mesosproto.FrameworkInfo{")
	if this.User != nil {
		s = append(s, "User: "+valueToGoStringMesos(this.User, "string")+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Id != nil {
		s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	}
	if this.FailoverTimeout != nil {
		s = append(s, "FailoverTimeout: "+valueToGoStringMesos(this.FailoverTimeout, "float64")+",\n")
	}
	if this.Checkpoint != nil {
		s = append(s, "Checkpoint: "+valueToGoStringMesos(this.Checkpoint, "bool")+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.WebuiUrl != nil {
		s = append(s, "WebuiUrl: "+valueToGoStringMesos(this.WebuiUrl, "string")+",\n")
	}
	if this.Capabilities != nil {
		s = append(s, "Capabilities: "+fmt.Sprintf("%#v", this.Capabilities)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FrameworkInfo_Capability) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.FrameworkInfo_Capability{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.FrameworkInfo_Capability_Type")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HealthCheck) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesosproto.HealthCheck{")
	if this.Http != nil {
		s = append(s, "Http: "+fmt.Sprintf("%#v", this.Http)+",\n")
	}
	if this.DelaySeconds != nil {
		s = append(s, "DelaySeconds: "+valueToGoStringMesos(this.DelaySeconds, "float64")+",\n")
	}
	if this.IntervalSeconds != nil {
		s = append(s, "IntervalSeconds: "+valueToGoStringMesos(this.IntervalSeconds, "float64")+",\n")
	}
	if this.TimeoutSeconds != nil {
		s = append(s, "TimeoutSeconds: "+valueToGoStringMesos(this.TimeoutSeconds, "float64")+",\n")
	}
	if this.ConsecutiveFailures != nil {
		s = append(s, "ConsecutiveFailures: "+valueToGoStringMesos(this.ConsecutiveFailures, "uint32")+",\n")
	}
	if this.GracePeriodSeconds != nil {
		s = append(s, "GracePeriodSeconds: "+valueToGoStringMesos(this.GracePeriodSeconds, "float64")+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HealthCheck_HTTP) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.HealthCheck_HTTP{")
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "uint32")+",\n")
	}
	if this.Path != nil {
		s = append(s, "Path: "+valueToGoStringMesos(this.Path, "string")+",\n")
	}
	if this.Statuses != nil {
		s = append(s, "Statuses: "+fmt.Sprintf("%#v", this.Statuses)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CommandInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesosproto.CommandInfo{")
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.Uris != nil {
		s = append(s, "Uris: "+fmt.Sprintf("%#v", this.Uris)+",\n")
	}
	if this.Environment != nil {
		s = append(s, "Environment: "+fmt.Sprintf("%#v", this.Environment)+",\n")
	}
	if this.Shell != nil {
		s = append(s, "Shell: "+valueToGoStringMesos(this.Shell, "bool")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.Arguments != nil {
		s = append(s, "Arguments: "+fmt.Sprintf("%#v", this.Arguments)+",\n")
	}
	if this.User != nil {
		s = append(s, "User: "+valueToGoStringMesos(this.User, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CommandInfo_URI) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.CommandInfo_URI{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.Executable != nil {
		s = append(s, "Executable: "+valueToGoStringMesos(this.Executable, "bool")+",\n")
	}
	if this.Extract != nil {
		s = append(s, "Extract: "+valueToGoStringMesos(this.Extract, "bool")+",\n")
	}
	if this.Cache != nil {
		s = append(s, "Cache: "+valueToGoStringMesos(this.Cache, "bool")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CommandInfo_ContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.CommandInfo_ContainerInfo{")
	if this.Image != nil {
		s = append(s, "Image: "+valueToGoStringMesos(this.Image, "string")+",\n")
	}
	if this.Options != nil {
		s = append(s, "Options: "+fmt.Sprintf("%#v", this.Options)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ExecutorInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesosproto.ExecutorInfo{")
	if this.ExecutorId != nil {
		s = append(s, "ExecutorId: "+fmt.Sprintf("%#v", this.ExecutorId)+",\n")
	}
	if this.FrameworkId != nil {
		s = append(s, "FrameworkId: "+fmt.Sprintf("%#v", this.FrameworkId)+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+valueToGoStringMesos(this.Source, "string")+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.Discovery != nil {
		s = append(s, "Discovery: "+fmt.Sprintf("%#v", this.Discovery)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *MasterInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesosproto.MasterInfo{")
	if this.Id != nil {
		s = append(s, "Id: "+valueToGoStringMesos(this.Id, "string")+",\n")
	}
	if this.Ip != nil {
		s = append(s, "Ip: "+valueToGoStringMesos(this.Ip, "uint32")+",\n")
	}
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "uint32")+",\n")
	}
	if this.Pid != nil {
		s = append(s, "Pid: "+valueToGoStringMesos(this.Pid, "string")+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Version != nil {
		s = append(s, "Version: "+valueToGoStringMesos(this.Version, "string")+",\n")
	}
	if this.Address != nil {
		s = append(s, "Address: "+fmt.Sprintf("%#v", this.Address)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SlaveInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.SlaveInfo{")
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Port != nil {
		s = append(s, "Port: "+valueToGoStringMesos(this.Port, "int32")+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	if this.Id != nil {
		s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	}
	if this.Checkpoint != nil {
		s = append(s, "Checkpoint: "+valueToGoStringMesos(this.Checkpoint, "bool")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesosproto.Value{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.Value_Type")+",\n")
	}
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Text != nil {
		s = append(s, "Text: "+fmt.Sprintf("%#v", this.Text)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Scalar) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Value_Scalar{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "float64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Range) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Value_Range{")
	if this.Begin != nil {
		s = append(s, "Begin: "+valueToGoStringMesos(this.Begin, "uint64")+",\n")
	}
	if this.End != nil {
		s = append(s, "End: "+valueToGoStringMesos(this.End, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Ranges) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Value_Ranges{")
	if this.Range != nil {
		s = append(s, "Range: "+fmt.Sprintf("%#v", this.Range)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Set) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Value_Set{")
	if this.Item != nil {
		s = append(s, "Item: "+fmt.Sprintf("%#v", this.Item)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Value_Text) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Value_Text{")
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Attribute) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.Attribute{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.Value_Type")+",\n")
	}
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Text != nil {
		s = append(s, "Text: "+fmt.Sprintf("%#v", this.Text)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesosproto.Resource{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.Value_Type")+",\n")
	}
	if this.Scalar != nil {
		s = append(s, "Scalar: "+fmt.Sprintf("%#v", this.Scalar)+",\n")
	}
	if this.Ranges != nil {
		s = append(s, "Ranges: "+fmt.Sprintf("%#v", this.Ranges)+",\n")
	}
	if this.Set != nil {
		s = append(s, "Set: "+fmt.Sprintf("%#v", this.Set)+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringMesos(this.Role, "string")+",\n")
	}
	if this.Reservation != nil {
		s = append(s, "Reservation: "+fmt.Sprintf("%#v", this.Reservation)+",\n")
	}
	if this.Disk != nil {
		s = append(s, "Disk: "+fmt.Sprintf("%#v", this.Disk)+",\n")
	}
	if this.Revocable != nil {
		s = append(s, "Revocable: "+fmt.Sprintf("%#v", this.Revocable)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_ReservationInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Resource_ReservationInfo{")
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Resource_DiskInfo{")
	if this.Persistence != nil {
		s = append(s, "Persistence: "+fmt.Sprintf("%#v", this.Persistence)+",\n")
	}
	if this.Volume != nil {
		s = append(s, "Volume: "+fmt.Sprintf("%#v", this.Volume)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_DiskInfo_Persistence) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Resource_DiskInfo_Persistence{")
	if this.Id != nil {
		s = append(s, "Id: "+valueToGoStringMesos(this.Id, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Resource_RevocableInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesosproto.Resource_RevocableInfo{")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TrafficControlStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&mesosproto.TrafficControlStatistics{")
	if this.Id != nil {
		s = append(s, "Id: "+valueToGoStringMesos(this.Id, "string")+",\n")
	}
	if this.Backlog != nil {
		s = append(s, "Backlog: "+valueToGoStringMesos(this.Backlog, "uint64")+",\n")
	}
	if this.Bytes != nil {
		s = append(s, "Bytes: "+valueToGoStringMesos(this.Bytes, "uint64")+",\n")
	}
	if this.Drops != nil {
		s = append(s, "Drops: "+valueToGoStringMesos(this.Drops, "uint64")+",\n")
	}
	if this.Overlimits != nil {
		s = append(s, "Overlimits: "+valueToGoStringMesos(this.Overlimits, "uint64")+",\n")
	}
	if this.Packets != nil {
		s = append(s, "Packets: "+valueToGoStringMesos(this.Packets, "uint64")+",\n")
	}
	if this.Qlen != nil {
		s = append(s, "Qlen: "+valueToGoStringMesos(this.Qlen, "uint64")+",\n")
	}
	if this.Ratebps != nil {
		s = append(s, "Ratebps: "+valueToGoStringMesos(this.Ratebps, "uint64")+",\n")
	}
	if this.Ratepps != nil {
		s = append(s, "Ratepps: "+valueToGoStringMesos(this.Ratepps, "uint64")+",\n")
	}
	if this.Requeues != nil {
		s = append(s, "Requeues: "+valueToGoStringMesos(this.Requeues, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 45)
	s = append(s, "&mesosproto.ResourceStatistics{")
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+valueToGoStringMesos(this.Timestamp, "float64")+",\n")
	}
	if this.Processes != nil {
		s = append(s, "Processes: "+valueToGoStringMesos(this.Processes, "uint32")+",\n")
	}
	if this.Threads != nil {
		s = append(s, "Threads: "+valueToGoStringMesos(this.Threads, "uint32")+",\n")
	}
	if this.CpusUserTimeSecs != nil {
		s = append(s, "CpusUserTimeSecs: "+valueToGoStringMesos(this.CpusUserTimeSecs, "float64")+",\n")
	}
	if this.CpusSystemTimeSecs != nil {
		s = append(s, "CpusSystemTimeSecs: "+valueToGoStringMesos(this.CpusSystemTimeSecs, "float64")+",\n")
	}
	if this.CpusLimit != nil {
		s = append(s, "CpusLimit: "+valueToGoStringMesos(this.CpusLimit, "float64")+",\n")
	}
	if this.CpusNrPeriods != nil {
		s = append(s, "CpusNrPeriods: "+valueToGoStringMesos(this.CpusNrPeriods, "uint32")+",\n")
	}
	if this.CpusNrThrottled != nil {
		s = append(s, "CpusNrThrottled: "+valueToGoStringMesos(this.CpusNrThrottled, "uint32")+",\n")
	}
	if this.CpusThrottledTimeSecs != nil {
		s = append(s, "CpusThrottledTimeSecs: "+valueToGoStringMesos(this.CpusThrottledTimeSecs, "float64")+",\n")
	}
	if this.MemTotalBytes != nil {
		s = append(s, "MemTotalBytes: "+valueToGoStringMesos(this.MemTotalBytes, "uint64")+",\n")
	}
	if this.MemTotalMemswBytes != nil {
		s = append(s, "MemTotalMemswBytes: "+valueToGoStringMesos(this.MemTotalMemswBytes, "uint64")+",\n")
	}
	if this.MemLimitBytes != nil {
		s = append(s, "MemLimitBytes: "+valueToGoStringMesos(this.MemLimitBytes, "uint64")+",\n")
	}
	if this.MemSoftLimitBytes != nil {
		s = append(s, "MemSoftLimitBytes: "+valueToGoStringMesos(this.MemSoftLimitBytes, "uint64")+",\n")
	}
	if this.MemFileBytes != nil {
		s = append(s, "MemFileBytes: "+valueToGoStringMesos(this.MemFileBytes, "uint64")+",\n")
	}
	if this.MemAnonBytes != nil {
		s = append(s, "MemAnonBytes: "+valueToGoStringMesos(this.MemAnonBytes, "uint64")+",\n")
	}
	if this.MemCacheBytes != nil {
		s = append(s, "MemCacheBytes: "+valueToGoStringMesos(this.MemCacheBytes, "uint64")+",\n")
	}
	if this.MemRssBytes != nil {
		s = append(s, "MemRssBytes: "+valueToGoStringMesos(this.MemRssBytes, "uint64")+",\n")
	}
	if this.MemMappedFileBytes != nil {
		s = append(s, "MemMappedFileBytes: "+valueToGoStringMesos(this.MemMappedFileBytes, "uint64")+",\n")
	}
	if this.MemSwapBytes != nil {
		s = append(s, "MemSwapBytes: "+valueToGoStringMesos(this.MemSwapBytes, "uint64")+",\n")
	}
	if this.MemUnevictableBytes != nil {
		s = append(s, "MemUnevictableBytes: "+valueToGoStringMesos(this.MemUnevictableBytes, "uint64")+",\n")
	}
	if this.MemLowPressureCounter != nil {
		s = append(s, "MemLowPressureCounter: "+valueToGoStringMesos(this.MemLowPressureCounter, "uint64")+",\n")
	}
	if this.MemMediumPressureCounter != nil {
		s = append(s, "MemMediumPressureCounter: "+valueToGoStringMesos(this.MemMediumPressureCounter, "uint64")+",\n")
	}
	if this.MemCriticalPressureCounter != nil {
		s = append(s, "MemCriticalPressureCounter: "+valueToGoStringMesos(this.MemCriticalPressureCounter, "uint64")+",\n")
	}
	if this.DiskLimitBytes != nil {
		s = append(s, "DiskLimitBytes: "+valueToGoStringMesos(this.DiskLimitBytes, "uint64")+",\n")
	}
	if this.DiskUsedBytes != nil {
		s = append(s, "DiskUsedBytes: "+valueToGoStringMesos(this.DiskUsedBytes, "uint64")+",\n")
	}
	if this.Perf != nil {
		s = append(s, "Perf: "+fmt.Sprintf("%#v", this.Perf)+",\n")
	}
	if this.NetRxPackets != nil {
		s = append(s, "NetRxPackets: "+valueToGoStringMesos(this.NetRxPackets, "uint64")+",\n")
	}
	if this.NetRxBytes != nil {
		s = append(s, "NetRxBytes: "+valueToGoStringMesos(this.NetRxBytes, "uint64")+",\n")
	}
	if this.NetRxErrors != nil {
		s = append(s, "NetRxErrors: "+valueToGoStringMesos(this.NetRxErrors, "uint64")+",\n")
	}
	if this.NetRxDropped != nil {
		s = append(s, "NetRxDropped: "+valueToGoStringMesos(this.NetRxDropped, "uint64")+",\n")
	}
	if this.NetTxPackets != nil {
		s = append(s, "NetTxPackets: "+valueToGoStringMesos(this.NetTxPackets, "uint64")+",\n")
	}
	if this.NetTxBytes != nil {
		s = append(s, "NetTxBytes: "+valueToGoStringMesos(this.NetTxBytes, "uint64")+",\n")
	}
	if this.NetTxErrors != nil {
		s = append(s, "NetTxErrors: "+valueToGoStringMesos(this.NetTxErrors, "uint64")+",\n")
	}
	if this.NetTxDropped != nil {
		s = append(s, "NetTxDropped: "+valueToGoStringMesos(this.NetTxDropped, "uint64")+",\n")
	}
	if this.NetTcpRttMicrosecsP50 != nil {
		s = append(s, "NetTcpRttMicrosecsP50: "+valueToGoStringMesos(this.NetTcpRttMicrosecsP50, "float64")+",\n")
	}
	if this.NetTcpRttMicrosecsP90 != nil {
		s = append(s, "NetTcpRttMicrosecsP90: "+valueToGoStringMesos(this.NetTcpRttMicrosecsP90, "float64")+",\n")
	}
	if this.NetTcpRttMicrosecsP95 != nil {
		s = append(s, "NetTcpRttMicrosecsP95: "+valueToGoStringMesos(this.NetTcpRttMicrosecsP95, "float64")+",\n")
	}
	if this.NetTcpRttMicrosecsP99 != nil {
		s = append(s, "NetTcpRttMicrosecsP99: "+valueToGoStringMesos(this.NetTcpRttMicrosecsP99, "float64")+",\n")
	}
	if this.NetTcpActiveConnections != nil {
		s = append(s, "NetTcpActiveConnections: "+valueToGoStringMesos(this.NetTcpActiveConnections, "float64")+",\n")
	}
	if this.NetTcpTimeWaitConnections != nil {
		s = append(s, "NetTcpTimeWaitConnections: "+valueToGoStringMesos(this.NetTcpTimeWaitConnections, "float64")+",\n")
	}
	if this.NetTrafficControlStatistics != nil {
		s = append(s, "NetTrafficControlStatistics: "+fmt.Sprintf("%#v", this.NetTrafficControlStatistics)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUsage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.ResourceUsage{")
	if this.Executors != nil {
		s = append(s, "Executors: "+fmt.Sprintf("%#v", this.Executors)+",\n")
	}
	if this.Total != nil {
		s = append(s, "Total: "+fmt.Sprintf("%#v", this.Total)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResourceUsage_Executor) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.ResourceUsage_Executor{")
	if this.ExecutorInfo != nil {
		s = append(s, "ExecutorInfo: "+fmt.Sprintf("%#v", this.ExecutorInfo)+",\n")
	}
	if this.Allocated != nil {
		s = append(s, "Allocated: "+fmt.Sprintf("%#v", this.Allocated)+",\n")
	}
	if this.Statistics != nil {
		s = append(s, "Statistics: "+fmt.Sprintf("%#v", this.Statistics)+",\n")
	}
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PerfStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 57)
	s = append(s, "&mesosproto.PerfStatistics{")
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+valueToGoStringMesos(this.Timestamp, "float64")+",\n")
	}
	if this.Duration != nil {
		s = append(s, "Duration: "+valueToGoStringMesos(this.Duration, "float64")+",\n")
	}
	if this.Cycles != nil {
		s = append(s, "Cycles: "+valueToGoStringMesos(this.Cycles, "uint64")+",\n")
	}
	if this.StalledCyclesFrontend != nil {
		s = append(s, "StalledCyclesFrontend: "+valueToGoStringMesos(this.StalledCyclesFrontend, "uint64")+",\n")
	}
	if this.StalledCyclesBackend != nil {
		s = append(s, "StalledCyclesBackend: "+valueToGoStringMesos(this.StalledCyclesBackend, "uint64")+",\n")
	}
	if this.Instructions != nil {
		s = append(s, "Instructions: "+valueToGoStringMesos(this.Instructions, "uint64")+",\n")
	}
	if this.CacheReferences != nil {
		s = append(s, "CacheReferences: "+valueToGoStringMesos(this.CacheReferences, "uint64")+",\n")
	}
	if this.CacheMisses != nil {
		s = append(s, "CacheMisses: "+valueToGoStringMesos(this.CacheMisses, "uint64")+",\n")
	}
	if this.Branches != nil {
		s = append(s, "Branches: "+valueToGoStringMesos(this.Branches, "uint64")+",\n")
	}
	if this.BranchMisses != nil {
		s = append(s, "BranchMisses: "+valueToGoStringMesos(this.BranchMisses, "uint64")+",\n")
	}
	if this.BusCycles != nil {
		s = append(s, "BusCycles: "+valueToGoStringMesos(this.BusCycles, "uint64")+",\n")
	}
	if this.RefCycles != nil {
		s = append(s, "RefCycles: "+valueToGoStringMesos(this.RefCycles, "uint64")+",\n")
	}
	if this.CpuClock != nil {
		s = append(s, "CpuClock: "+valueToGoStringMesos(this.CpuClock, "float64")+",\n")
	}
	if this.TaskClock != nil {
		s = append(s, "TaskClock: "+valueToGoStringMesos(this.TaskClock, "float64")+",\n")
	}
	if this.PageFaults != nil {
		s = append(s, "PageFaults: "+valueToGoStringMesos(this.PageFaults, "uint64")+",\n")
	}
	if this.MinorFaults != nil {
		s = append(s, "MinorFaults: "+valueToGoStringMesos(this.MinorFaults, "uint64")+",\n")
	}
	if this.MajorFaults != nil {
		s = append(s, "MajorFaults: "+valueToGoStringMesos(this.MajorFaults, "uint64")+",\n")
	}
	if this.ContextSwitches != nil {
		s = append(s, "ContextSwitches: "+valueToGoStringMesos(this.ContextSwitches, "uint64")+",\n")
	}
	if this.CpuMigrations != nil {
		s = append(s, "CpuMigrations: "+valueToGoStringMesos(this.CpuMigrations, "uint64")+",\n")
	}
	if this.AlignmentFaults != nil {
		s = append(s, "AlignmentFaults: "+valueToGoStringMesos(this.AlignmentFaults, "uint64")+",\n")
	}
	if this.EmulationFaults != nil {
		s = append(s, "EmulationFaults: "+valueToGoStringMesos(this.EmulationFaults, "uint64")+",\n")
	}
	if this.L1DcacheLoads != nil {
		s = append(s, "L1DcacheLoads: "+valueToGoStringMesos(this.L1DcacheLoads, "uint64")+",\n")
	}
	if this.L1DcacheLoadMisses != nil {
		s = append(s, "L1DcacheLoadMisses: "+valueToGoStringMesos(this.L1DcacheLoadMisses, "uint64")+",\n")
	}
	if this.L1DcacheStores != nil {
		s = append(s, "L1DcacheStores: "+valueToGoStringMesos(this.L1DcacheStores, "uint64")+",\n")
	}
	if this.L1DcacheStoreMisses != nil {
		s = append(s, "L1DcacheStoreMisses: "+valueToGoStringMesos(this.L1DcacheStoreMisses, "uint64")+",\n")
	}
	if this.L1DcachePrefetches != nil {
		s = append(s, "L1DcachePrefetches: "+valueToGoStringMesos(this.L1DcachePrefetches, "uint64")+",\n")
	}
	if this.L1DcachePrefetchMisses != nil {
		s = append(s, "L1DcachePrefetchMisses: "+valueToGoStringMesos(this.L1DcachePrefetchMisses, "uint64")+",\n")
	}
	if this.L1IcacheLoads != nil {
		s = append(s, "L1IcacheLoads: "+valueToGoStringMesos(this.L1IcacheLoads, "uint64")+",\n")
	}
	if this.L1IcacheLoadMisses != nil {
		s = append(s, "L1IcacheLoadMisses: "+valueToGoStringMesos(this.L1IcacheLoadMisses, "uint64")+",\n")
	}
	if this.L1IcachePrefetches != nil {
		s = append(s, "L1IcachePrefetches: "+valueToGoStringMesos(this.L1IcachePrefetches, "uint64")+",\n")
	}
	if this.L1IcachePrefetchMisses != nil {
		s = append(s, "L1IcachePrefetchMisses: "+valueToGoStringMesos(this.L1IcachePrefetchMisses, "uint64")+",\n")
	}
	if this.LlcLoads != nil {
		s = append(s, "LlcLoads: "+valueToGoStringMesos(this.LlcLoads, "uint64")+",\n")
	}
	if this.LlcLoadMisses != nil {
		s = append(s, "LlcLoadMisses: "+valueToGoStringMesos(this.LlcLoadMisses, "uint64")+",\n")
	}
	if this.LlcStores != nil {
		s = append(s, "LlcStores: "+valueToGoStringMesos(this.LlcStores, "uint64")+",\n")
	}
	if this.LlcStoreMisses != nil {
		s = append(s, "LlcStoreMisses: "+valueToGoStringMesos(this.LlcStoreMisses, "uint64")+",\n")
	}
	if this.LlcPrefetches != nil {
		s = append(s, "LlcPrefetches: "+valueToGoStringMesos(this.LlcPrefetches, "uint64")+",\n")
	}
	if this.LlcPrefetchMisses != nil {
		s = append(s, "LlcPrefetchMisses: "+valueToGoStringMesos(this.LlcPrefetchMisses, "uint64")+",\n")
	}
	if this.DtlbLoads != nil {
		s = append(s, "DtlbLoads: "+valueToGoStringMesos(this.DtlbLoads, "uint64")+",\n")
	}
	if this.DtlbLoadMisses != nil {
		s = append(s, "DtlbLoadMisses: "+valueToGoStringMesos(this.DtlbLoadMisses, "uint64")+",\n")
	}
	if this.DtlbStores != nil {
		s = append(s, "DtlbStores: "+valueToGoStringMesos(this.DtlbStores, "uint64")+",\n")
	}
	if this.DtlbStoreMisses != nil {
		s = append(s, "DtlbStoreMisses: "+valueToGoStringMesos(this.DtlbStoreMisses, "uint64")+",\n")
	}
	if this.DtlbPrefetches != nil {
		s = append(s, "DtlbPrefetches: "+valueToGoStringMesos(this.DtlbPrefetches, "uint64")+",\n")
	}
	if this.DtlbPrefetchMisses != nil {
		s = append(s, "DtlbPrefetchMisses: "+valueToGoStringMesos(this.DtlbPrefetchMisses, "uint64")+",\n")
	}
	if this.ItlbLoads != nil {
		s = append(s, "ItlbLoads: "+valueToGoStringMesos(this.ItlbLoads, "uint64")+",\n")
	}
	if this.ItlbLoadMisses != nil {
		s = append(s, "ItlbLoadMisses: "+valueToGoStringMesos(this.ItlbLoadMisses, "uint64")+",\n")
	}
	if this.BranchLoads != nil {
		s = append(s, "BranchLoads: "+valueToGoStringMesos(this.BranchLoads, "uint64")+",\n")
	}
	if this.BranchLoadMisses != nil {
		s = append(s, "BranchLoadMisses: "+valueToGoStringMesos(this.BranchLoadMisses, "uint64")+",\n")
	}
	if this.NodeLoads != nil {
		s = append(s, "NodeLoads: "+valueToGoStringMesos(this.NodeLoads, "uint64")+",\n")
	}
	if this.NodeLoadMisses != nil {
		s = append(s, "NodeLoadMisses: "+valueToGoStringMesos(this.NodeLoadMisses, "uint64")+",\n")
	}
	if this.NodeStores != nil {
		s = append(s, "NodeStores: "+valueToGoStringMesos(this.NodeStores, "uint64")+",\n")
	}
	if this.NodeStoreMisses != nil {
		s = append(s, "NodeStoreMisses: "+valueToGoStringMesos(this.NodeStoreMisses, "uint64")+",\n")
	}
	if this.NodePrefetches != nil {
		s = append(s, "NodePrefetches: "+valueToGoStringMesos(this.NodePrefetches, "uint64")+",\n")
	}
	if this.NodePrefetchMisses != nil {
		s = append(s, "NodePrefetchMisses: "+valueToGoStringMesos(this.NodePrefetchMisses, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Request) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Request{")
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&mesosproto.Offer{")
	if this.Id != nil {
		s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	}
	if this.FrameworkId != nil {
		s = append(s, "FrameworkId: "+fmt.Sprintf("%#v", this.FrameworkId)+",\n")
	}
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Url != nil {
		s = append(s, "Url: "+fmt.Sprintf("%#v", this.Url)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Attributes != nil {
		s = append(s, "Attributes: "+fmt.Sprintf("%#v", this.Attributes)+",\n")
	}
	if this.ExecutorIds != nil {
		s = append(s, "ExecutorIds: "+fmt.Sprintf("%#v", this.ExecutorIds)+",\n")
	}
	if this.Unavailability != nil {
		s = append(s, "Unavailability: "+fmt.Sprintf("%#v", this.Unavailability)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.Offer_Operation{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.Offer_Operation_Type")+",\n")
	}
	if this.Launch != nil {
		s = append(s, "Launch: "+fmt.Sprintf("%#v", this.Launch)+",\n")
	}
	if this.Reserve != nil {
		s = append(s, "Reserve: "+fmt.Sprintf("%#v", this.Reserve)+",\n")
	}
	if this.Unreserve != nil {
		s = append(s, "Unreserve: "+fmt.Sprintf("%#v", this.Unreserve)+",\n")
	}
	if this.Create != nil {
		s = append(s, "Create: "+fmt.Sprintf("%#v", this.Create)+",\n")
	}
	if this.Destroy != nil {
		s = append(s, "Destroy: "+fmt.Sprintf("%#v", this.Destroy)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Launch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Offer_Operation_Launch{")
	if this.TaskInfos != nil {
		s = append(s, "TaskInfos: "+fmt.Sprintf("%#v", this.TaskInfos)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Reserve) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Offer_Operation_Reserve{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Unreserve) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Offer_Operation_Unreserve{")
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Create) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Offer_Operation_Create{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Offer_Operation_Destroy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Offer_Operation_Destroy{")
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *InverseOffer) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.InverseOffer{")
	if this.Id != nil {
		s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	}
	if this.Url != nil {
		s = append(s, "Url: "+fmt.Sprintf("%#v", this.Url)+",\n")
	}
	if this.FrameworkId != nil {
		s = append(s, "FrameworkId: "+fmt.Sprintf("%#v", this.FrameworkId)+",\n")
	}
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.Unavailability != nil {
		s = append(s, "Unavailability: "+fmt.Sprintf("%#v", this.Unavailability)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&mesosproto.TaskInfo{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.TaskId != nil {
		s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	}
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.Executor != nil {
		s = append(s, "Executor: "+fmt.Sprintf("%#v", this.Executor)+",\n")
	}
	if this.Command != nil {
		s = append(s, "Command: "+fmt.Sprintf("%#v", this.Command)+",\n")
	}
	if this.Container != nil {
		s = append(s, "Container: "+fmt.Sprintf("%#v", this.Container)+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.HealthCheck != nil {
		s = append(s, "HealthCheck: "+fmt.Sprintf("%#v", this.HealthCheck)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.Discovery != nil {
		s = append(s, "Discovery: "+fmt.Sprintf("%#v", this.Discovery)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TaskStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 17)
	s = append(s, "&mesosproto.TaskStatus{")
	if this.TaskId != nil {
		s = append(s, "TaskId: "+fmt.Sprintf("%#v", this.TaskId)+",\n")
	}
	if this.State != nil {
		s = append(s, "State: "+valueToGoStringMesos(this.State, "mesosproto.TaskState")+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+valueToGoStringMesos(this.Message, "string")+",\n")
	}
	if this.Source != nil {
		s = append(s, "Source: "+valueToGoStringMesos(this.Source, "mesosproto.TaskStatus_Source")+",\n")
	}
	if this.Reason != nil {
		s = append(s, "Reason: "+valueToGoStringMesos(this.Reason, "mesosproto.TaskStatus_Reason")+",\n")
	}
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringMesos(this.Data, "byte")+",\n")
	}
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.ExecutorId != nil {
		s = append(s, "ExecutorId: "+fmt.Sprintf("%#v", this.ExecutorId)+",\n")
	}
	if this.Timestamp != nil {
		s = append(s, "Timestamp: "+valueToGoStringMesos(this.Timestamp, "float64")+",\n")
	}
	if this.Uuid != nil {
		s = append(s, "Uuid: "+valueToGoStringMesos(this.Uuid, "byte")+",\n")
	}
	if this.Healthy != nil {
		s = append(s, "Healthy: "+valueToGoStringMesos(this.Healthy, "bool")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.ContainerStatus != nil {
		s = append(s, "ContainerStatus: "+fmt.Sprintf("%#v", this.ContainerStatus)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Filters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Filters{")
	if this.RefuseSeconds != nil {
		s = append(s, "RefuseSeconds: "+valueToGoStringMesos(this.RefuseSeconds, "float64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Environment) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Environment{")
	if this.Variables != nil {
		s = append(s, "Variables: "+fmt.Sprintf("%#v", this.Variables)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Environment_Variable) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Environment_Variable{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Parameter) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Parameter{")
	if this.Key != nil {
		s = append(s, "Key: "+valueToGoStringMesos(this.Key, "string")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Parameters) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Parameters{")
	if this.Parameter != nil {
		s = append(s, "Parameter: "+fmt.Sprintf("%#v", this.Parameter)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Credential) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Credential{")
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.Secret != nil {
		s = append(s, "Secret: "+valueToGoStringMesos(this.Secret, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Credentials) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Credentials{")
	if this.Credentials != nil {
		s = append(s, "Credentials: "+fmt.Sprintf("%#v", this.Credentials)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RateLimit) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.RateLimit{")
	if this.Qps != nil {
		s = append(s, "Qps: "+valueToGoStringMesos(this.Qps, "float64")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringMesos(this.Principal, "string")+",\n")
	}
	if this.Capacity != nil {
		s = append(s, "Capacity: "+valueToGoStringMesos(this.Capacity, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RateLimits) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.RateLimits{")
	if this.Limits != nil {
		s = append(s, "Limits: "+fmt.Sprintf("%#v", this.Limits)+",\n")
	}
	if this.AggregateDefaultQps != nil {
		s = append(s, "AggregateDefaultQps: "+valueToGoStringMesos(this.AggregateDefaultQps, "float64")+",\n")
	}
	if this.AggregateDefaultCapacity != nil {
		s = append(s, "AggregateDefaultCapacity: "+valueToGoStringMesos(this.AggregateDefaultCapacity, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.Image{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.Image_Type")+",\n")
	}
	if this.Appc != nil {
		s = append(s, "Appc: "+fmt.Sprintf("%#v", this.Appc)+",\n")
	}
	if this.Docker != nil {
		s = append(s, "Docker: "+fmt.Sprintf("%#v", this.Docker)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image_Appc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.Image_Appc{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Id != nil {
		s = append(s, "Id: "+valueToGoStringMesos(this.Id, "string")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Image_Docker) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Image_Docker{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Volume) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.Volume{")
	if this.Mode != nil {
		s = append(s, "Mode: "+valueToGoStringMesos(this.Mode, "mesosproto.Volume_Mode")+",\n")
	}
	if this.ContainerPath != nil {
		s = append(s, "ContainerPath: "+valueToGoStringMesos(this.ContainerPath, "string")+",\n")
	}
	if this.HostPath != nil {
		s = append(s, "HostPath: "+valueToGoStringMesos(this.HostPath, "string")+",\n")
	}
	if this.Image != nil {
		s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesosproto.NetworkInfo{")
	if this.IpAddresses != nil {
		s = append(s, "IpAddresses: "+fmt.Sprintf("%#v", this.IpAddresses)+",\n")
	}
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "mesosproto.NetworkInfo_Protocol")+",\n")
	}
	if this.IpAddress != nil {
		s = append(s, "IpAddress: "+valueToGoStringMesos(this.IpAddress, "string")+",\n")
	}
	if this.Groups != nil {
		s = append(s, "Groups: "+fmt.Sprintf("%#v", this.Groups)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkInfo_IPAddress) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.NetworkInfo_IPAddress{")
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "mesosproto.NetworkInfo_Protocol")+",\n")
	}
	if this.IpAddress != nil {
		s = append(s, "IpAddress: "+valueToGoStringMesos(this.IpAddress, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.ContainerInfo{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringMesos(this.Type, "mesosproto.ContainerInfo_Type")+",\n")
	}
	if this.Volumes != nil {
		s = append(s, "Volumes: "+fmt.Sprintf("%#v", this.Volumes)+",\n")
	}
	if this.Hostname != nil {
		s = append(s, "Hostname: "+valueToGoStringMesos(this.Hostname, "string")+",\n")
	}
	if this.Docker != nil {
		s = append(s, "Docker: "+fmt.Sprintf("%#v", this.Docker)+",\n")
	}
	if this.Mesos != nil {
		s = append(s, "Mesos: "+fmt.Sprintf("%#v", this.Mesos)+",\n")
	}
	if this.NetworkInfos != nil {
		s = append(s, "NetworkInfos: "+fmt.Sprintf("%#v", this.NetworkInfos)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_DockerInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&mesosproto.ContainerInfo_DockerInfo{")
	if this.Image != nil {
		s = append(s, "Image: "+valueToGoStringMesos(this.Image, "string")+",\n")
	}
	if this.Network != nil {
		s = append(s, "Network: "+valueToGoStringMesos(this.Network, "mesosproto.ContainerInfo_DockerInfo_Network")+",\n")
	}
	if this.PortMappings != nil {
		s = append(s, "PortMappings: "+fmt.Sprintf("%#v", this.PortMappings)+",\n")
	}
	if this.Privileged != nil {
		s = append(s, "Privileged: "+valueToGoStringMesos(this.Privileged, "bool")+",\n")
	}
	if this.Parameters != nil {
		s = append(s, "Parameters: "+fmt.Sprintf("%#v", this.Parameters)+",\n")
	}
	if this.ForcePullImage != nil {
		s = append(s, "ForcePullImage: "+valueToGoStringMesos(this.ForcePullImage, "bool")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_DockerInfo_PortMapping) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.ContainerInfo_DockerInfo_PortMapping{")
	if this.HostPort != nil {
		s = append(s, "HostPort: "+valueToGoStringMesos(this.HostPort, "uint32")+",\n")
	}
	if this.ContainerPort != nil {
		s = append(s, "ContainerPort: "+valueToGoStringMesos(this.ContainerPort, "uint32")+",\n")
	}
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerInfo_MesosInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.ContainerInfo_MesosInfo{")
	if this.Image != nil {
		s = append(s, "Image: "+fmt.Sprintf("%#v", this.Image)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ContainerStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.ContainerStatus{")
	if this.NetworkInfos != nil {
		s = append(s, "NetworkInfos: "+fmt.Sprintf("%#v", this.NetworkInfos)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Labels) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Labels{")
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Label) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Label{")
	if this.Key != nil {
		s = append(s, "Key: "+valueToGoStringMesos(this.Key, "string")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Port) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.Port{")
	if this.Number != nil {
		s = append(s, "Number: "+valueToGoStringMesos(this.Number, "uint32")+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Protocol != nil {
		s = append(s, "Protocol: "+valueToGoStringMesos(this.Protocol, "string")+",\n")
	}
	if this.Visibility != nil {
		s = append(s, "Visibility: "+valueToGoStringMesos(this.Visibility, "mesosproto.DiscoveryInfo_Visibility")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Ports) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Ports{")
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *DiscoveryInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesosproto.DiscoveryInfo{")
	if this.Visibility != nil {
		s = append(s, "Visibility: "+valueToGoStringMesos(this.Visibility, "mesosproto.DiscoveryInfo_Visibility")+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Environment != nil {
		s = append(s, "Environment: "+valueToGoStringMesos(this.Environment, "string")+",\n")
	}
	if this.Location != nil {
		s = append(s, "Location: "+valueToGoStringMesos(this.Location, "string")+",\n")
	}
	if this.Version != nil {
		s = append(s, "Version: "+valueToGoStringMesos(this.Version, "string")+",\n")
	}
	if this.Ports != nil {
		s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AppcImageManifest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&mesosproto.AppcImageManifest{")
	if this.AcKind != nil {
		s = append(s, "AcKind: "+valueToGoStringMesos(this.AcKind, "string")+",\n")
	}
	if this.AcVersion != nil {
		s = append(s, "AcVersion: "+valueToGoStringMesos(this.AcVersion, "string")+",\n")
	}
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Labels != nil {
		s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	}
	if this.Annotations != nil {
		s = append(s, "Annotations: "+fmt.Sprintf("%#v", this.Annotations)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AppcImageManifest_Label) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.AppcImageManifest_Label{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *AppcImageManifest_Annotation) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.AppcImageManifest_Annotation{")
	if this.Name != nil {
		s = append(s, "Name: "+valueToGoStringMesos(this.Name, "string")+",\n")
	}
	if this.Value != nil {
		s = append(s, "Value: "+valueToGoStringMesos(this.Value, "string")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringMesos(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringMesos(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *FrameworkID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FrameworkID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OfferID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *OfferID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SlaveID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SlaveID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExecutorID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ExecutorID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimeInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TimeInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Nanoseconds == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("nanoseconds")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DurationInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *DurationInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Nanoseconds == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("nanoseconds")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Address) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Address) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Ip != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Ip)))
		i += copy(data[i:], *m.Ip)
	}
	if m.Port == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	} else {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *URL) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *URL) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Scheme == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("scheme")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Scheme)))
		i += copy(data[i:], *m.Scheme)
	}
	if m.Address == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("address")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Address.Size()))
		n1, err := m.Address.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Path != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Path)))
		i += copy(data[i:], *m.Path)
	}
	if len(m.Query) > 0 {
		for _, msg := range m.Query {
			data[i] = 0x22
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Fragment != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Fragment)))
		i += copy(data[i:], *m.Fragment)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Unavailability) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Unavailability) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Start == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("start")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Start.Size()))
		n2, err := m.Start.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Duration != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Duration.Size()))
		n3, err := m.Duration.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MachineID) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MachineID) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Ip != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Ip)))
		i += copy(data[i:], *m.Ip)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MachineInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MachineInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n4, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Mode != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Mode))
	}
	if m.Unavailability != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Unavailability.Size()))
		n5, err := m.Unavailability.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FrameworkInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FrameworkInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.User == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("user")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.User)))
		i += copy(data[i:], *m.User)
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Id != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n6, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.FailoverTimeout != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.FailoverTimeout)))
	}
	if m.Checkpoint != nil {
		data[i] = 0x28
		i++
		if *m.Checkpoint {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Role != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Role)))
		i += copy(data[i:], *m.Role)
	}
	if m.Hostname != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Principal != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.WebuiUrl != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.WebuiUrl)))
		i += copy(data[i:], *m.WebuiUrl)
	}
	if len(m.Capabilities) > 0 {
		for _, msg := range m.Capabilities {
			data[i] = 0x52
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Labels != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n7, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FrameworkInfo_Capability) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *FrameworkInfo_Capability) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HealthCheck) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Http != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Http.Size()))
		n8, err := m.Http.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.DelaySeconds != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.DelaySeconds)))
	}
	if m.IntervalSeconds != nil {
		data[i] = 0x19
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.IntervalSeconds)))
	}
	if m.TimeoutSeconds != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.TimeoutSeconds)))
	}
	if m.ConsecutiveFailures != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ConsecutiveFailures))
	}
	if m.GracePeriodSeconds != nil {
		data[i] = 0x31
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.GracePeriodSeconds)))
	}
	if m.Command != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n9, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HealthCheck_HTTP) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HealthCheck_HTTP) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.Path != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Path)))
		i += copy(data[i:], *m.Path)
	}
	if len(m.Statuses) > 0 {
		for _, num := range m.Statuses {
			data[i] = 0x20
			i++
			i = encodeVarintMesos(data, i, uint64(num))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uris) > 0 {
		for _, msg := range m.Uris {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Environment != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Environment.Size()))
		n10, err := m.Environment.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Value != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.Container != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n11, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.User != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.User)))
		i += copy(data[i:], *m.User)
	}
	if m.Shell != nil {
		data[i] = 0x30
		i++
		if *m.Shell {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Arguments) > 0 {
		for _, s := range m.Arguments {
			data[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo_URI) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo_URI) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.Executable != nil {
		data[i] = 0x10
		i++
		if *m.Executable {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Extract != nil {
		data[i] = 0x18
		i++
		if *m.Extract {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Cache != nil {
		data[i] = 0x20
		i++
		if *m.Cache {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommandInfo_ContainerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CommandInfo_ContainerInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Image == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("image")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Image)))
		i += copy(data[i:], *m.Image)
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			data[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExecutorInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ExecutorInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExecutorId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorId.Size()))
		n12, err := m.ExecutorId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.Data != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Command == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("command")
	} else {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n13, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.FrameworkId != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n14, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Name != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Source != nil {
		data[i] = 0x52
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Source)))
		i += copy(data[i:], *m.Source)
	}
	if m.Container != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n15, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Discovery != nil {
		data[i] = 0x62
		i++
		i = encodeVarintMesos(data, i, uint64(m.Discovery.Size()))
		n16, err := m.Discovery.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *MasterInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Id)))
		i += copy(data[i:], *m.Id)
	}
	if m.Ip == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("ip")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Ip))
	}
	if m.Port == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	} else {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.Pid != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Pid)))
		i += copy(data[i:], *m.Pid)
	}
	if m.Hostname != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Version != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Version)))
		i += copy(data[i:], *m.Version)
	}
	if m.Address != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Address.Size()))
		n17, err := m.Address.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SlaveInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SlaveInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hostname == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("hostname")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x1a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Id != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n18, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.Checkpoint != nil {
		data[i] = 0x38
		i++
		if *m.Checkpoint {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Port != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n19, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Ranges != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n20, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Set != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n21, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Text != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Text.Size()))
		n22, err := m.Text.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Scalar) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Scalar) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Value)))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Range) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Range) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Begin == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("begin")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Begin))
	}
	if m.End == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("end")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Ranges) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Ranges) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Range) > 0 {
		for _, msg := range m.Range {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Set) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Set) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Item) > 0 {
		for _, s := range m.Item {
			data[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Value_Text) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Value_Text) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Attribute) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Attribute) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n23, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.Ranges != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n24, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.Text != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Text.Size()))
		n25, err := m.Text.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.Set != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n26, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Scalar != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Scalar.Size()))
		n27, err := m.Scalar.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.Ranges != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ranges.Size()))
		n28, err := m.Ranges.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Set != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Set.Size()))
		n29, err := m.Set.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.Role != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Role)))
		i += copy(data[i:], *m.Role)
	}
	if m.Disk != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Disk.Size()))
		n30, err := m.Disk.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.Reservation != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.Reservation.Size()))
		n31, err := m.Reservation.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.Revocable != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Revocable.Size()))
		n32, err := m.Revocable.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource_ReservationInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource_ReservationInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource_DiskInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource_DiskInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Persistence != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Persistence.Size()))
		n33, err := m.Persistence.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.Volume != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Volume.Size()))
		n34, err := m.Volume.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource_DiskInfo_Persistence) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource_DiskInfo_Persistence) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Id)))
		i += copy(data[i:], *m.Id)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Resource_RevocableInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Resource_RevocableInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TrafficControlStatistics) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TrafficControlStatistics) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Id)))
		i += copy(data[i:], *m.Id)
	}
	if m.Backlog != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Backlog))
	}
	if m.Bytes != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Bytes))
	}
	if m.Drops != nil {
		data[i] = 0x20
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Drops))
	}
	if m.Overlimits != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Overlimits))
	}
	if m.Packets != nil {
		data[i] = 0x30
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Packets))
	}
	if m.Qlen != nil {
		data[i] = 0x38
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Qlen))
	}
	if m.Ratebps != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Ratebps))
	}
	if m.Ratepps != nil {
		data[i] = 0x48
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Ratepps))
	}
	if m.Requeues != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Requeues))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceStatistics) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceStatistics) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("timestamp")
	} else {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Timestamp)))
	}
	if m.CpusUserTimeSecs != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.CpusUserTimeSecs)))
	}
	if m.CpusSystemTimeSecs != nil {
		data[i] = 0x19
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.CpusSystemTimeSecs)))
	}
	if m.CpusLimit != nil {
		data[i] = 0x21
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.CpusLimit)))
	}
	if m.MemRssBytes != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemRssBytes))
	}
	if m.MemLimitBytes != nil {
		data[i] = 0x30
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemLimitBytes))
	}
	if m.CpusNrPeriods != nil {
		data[i] = 0x38
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpusNrPeriods))
	}
	if m.CpusNrThrottled != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpusNrThrottled))
	}
	if m.CpusThrottledTimeSecs != nil {
		data[i] = 0x49
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.CpusThrottledTimeSecs)))
	}
	if m.MemFileBytes != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemFileBytes))
	}
	if m.MemAnonBytes != nil {
		data[i] = 0x58
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemAnonBytes))
	}
	if m.MemMappedFileBytes != nil {
		data[i] = 0x60
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemMappedFileBytes))
	}
	if m.Perf != nil {
		data[i] = 0x6a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Perf.Size()))
		n35, err := m.Perf.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.NetRxPackets != nil {
		data[i] = 0x70
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxPackets))
	}
	if m.NetRxBytes != nil {
		data[i] = 0x78
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxBytes))
	}
	if m.NetRxErrors != nil {
		data[i] = 0x80
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxErrors))
	}
	if m.NetRxDropped != nil {
		data[i] = 0x88
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetRxDropped))
	}
	if m.NetTxPackets != nil {
		data[i] = 0x90
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxPackets))
	}
	if m.NetTxBytes != nil {
		data[i] = 0x98
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxBytes))
	}
	if m.NetTxErrors != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxErrors))
	}
	if m.NetTxDropped != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NetTxDropped))
	}
	if m.NetTcpRttMicrosecsP50 != nil {
		data[i] = 0xb1
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpRttMicrosecsP50)))
	}
	if m.NetTcpRttMicrosecsP90 != nil {
		data[i] = 0xb9
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpRttMicrosecsP90)))
	}
	if m.NetTcpRttMicrosecsP95 != nil {
		data[i] = 0xc1
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpRttMicrosecsP95)))
	}
	if m.NetTcpRttMicrosecsP99 != nil {
		data[i] = 0xc9
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpRttMicrosecsP99)))
	}
	if m.DiskLimitBytes != nil {
		data[i] = 0xd0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DiskLimitBytes))
	}
	if m.DiskUsedBytes != nil {
		data[i] = 0xd8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DiskUsedBytes))
	}
	if m.NetTcpActiveConnections != nil {
		data[i] = 0xe1
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpActiveConnections)))
	}
	if m.NetTcpTimeWaitConnections != nil {
		data[i] = 0xe9
		i++
		data[i] = 0x1
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.NetTcpTimeWaitConnections)))
	}
	if m.Processes != nil {
		data[i] = 0xf0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Processes))
	}
	if m.Threads != nil {
		data[i] = 0xf8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Threads))
	}
	if m.MemLowPressureCounter != nil {
		data[i] = 0x80
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemLowPressureCounter))
	}
	if m.MemMediumPressureCounter != nil {
		data[i] = 0x88
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemMediumPressureCounter))
	}
	if m.MemCriticalPressureCounter != nil {
		data[i] = 0x90
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemCriticalPressureCounter))
	}
	if len(m.NetTrafficControlStatistics) > 0 {
		for _, msg := range m.NetTrafficControlStatistics {
			data[i] = 0x9a
			i++
			data[i] = 0x2
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MemTotalBytes != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemTotalBytes))
	}
	if m.MemTotalMemswBytes != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemTotalMemswBytes))
	}
	if m.MemSoftLimitBytes != nil {
		data[i] = 0xb0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemSoftLimitBytes))
	}
	if m.MemCacheBytes != nil {
		data[i] = 0xb8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemCacheBytes))
	}
	if m.MemSwapBytes != nil {
		data[i] = 0xc0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemSwapBytes))
	}
	if m.MemUnevictableBytes != nil {
		data[i] = 0xc8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MemUnevictableBytes))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceUsage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceUsage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Total) > 0 {
		for _, msg := range m.Total {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ResourceUsage_Executor) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResourceUsage_Executor) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ExecutorInfo == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_info")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorInfo.Size()))
		n36, err := m.ExecutorInfo.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	if len(m.Allocated) > 0 {
		for _, msg := range m.Allocated {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Statistics != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Statistics.Size()))
		n37, err := m.Statistics.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.ContainerId.Size()))
		n38, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PerfStatistics) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PerfStatistics) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("timestamp")
	} else {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Timestamp)))
	}
	if m.Duration == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	} else {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Duration)))
	}
	if m.Cycles != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Cycles))
	}
	if m.StalledCyclesFrontend != nil {
		data[i] = 0x20
		i++
		i = encodeVarintMesos(data, i, uint64(*m.StalledCyclesFrontend))
	}
	if m.StalledCyclesBackend != nil {
		data[i] = 0x28
		i++
		i = encodeVarintMesos(data, i, uint64(*m.StalledCyclesBackend))
	}
	if m.Instructions != nil {
		data[i] = 0x30
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Instructions))
	}
	if m.CacheReferences != nil {
		data[i] = 0x38
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CacheReferences))
	}
	if m.CacheMisses != nil {
		data[i] = 0x40
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CacheMisses))
	}
	if m.Branches != nil {
		data[i] = 0x48
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Branches))
	}
	if m.BranchMisses != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchMisses))
	}
	if m.BusCycles != nil {
		data[i] = 0x58
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BusCycles))
	}
	if m.RefCycles != nil {
		data[i] = 0x60
		i++
		i = encodeVarintMesos(data, i, uint64(*m.RefCycles))
	}
	if m.CpuClock != nil {
		data[i] = 0x69
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.CpuClock)))
	}
	if m.TaskClock != nil {
		data[i] = 0x71
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.TaskClock)))
	}
	if m.PageFaults != nil {
		data[i] = 0x78
		i++
		i = encodeVarintMesos(data, i, uint64(*m.PageFaults))
	}
	if m.MinorFaults != nil {
		data[i] = 0x80
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MinorFaults))
	}
	if m.MajorFaults != nil {
		data[i] = 0x88
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.MajorFaults))
	}
	if m.ContextSwitches != nil {
		data[i] = 0x90
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ContextSwitches))
	}
	if m.CpuMigrations != nil {
		data[i] = 0x98
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.CpuMigrations))
	}
	if m.AlignmentFaults != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.AlignmentFaults))
	}
	if m.EmulationFaults != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.EmulationFaults))
	}
	if m.L1DcacheLoads != nil {
		data[i] = 0xb0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheLoads))
	}
	if m.L1DcacheLoadMisses != nil {
		data[i] = 0xb8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheLoadMisses))
	}
	if m.L1DcacheStores != nil {
		data[i] = 0xc0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheStores))
	}
	if m.L1DcacheStoreMisses != nil {
		data[i] = 0xc8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcacheStoreMisses))
	}
	if m.L1DcachePrefetches != nil {
		data[i] = 0xd0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcachePrefetches))
	}
	if m.L1DcachePrefetchMisses != nil {
		data[i] = 0xd8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1DcachePrefetchMisses))
	}
	if m.L1IcacheLoads != nil {
		data[i] = 0xe0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcacheLoads))
	}
	if m.L1IcacheLoadMisses != nil {
		data[i] = 0xe8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcacheLoadMisses))
	}
	if m.L1IcachePrefetches != nil {
		data[i] = 0xf0
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcachePrefetches))
	}
	if m.L1IcachePrefetchMisses != nil {
		data[i] = 0xf8
		i++
		data[i] = 0x1
		i++
		i = encodeVarintMesos(data, i, uint64(*m.L1IcachePrefetchMisses))
	}
	if m.LlcLoads != nil {
		data[i] = 0x80
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcLoads))
	}
	if m.LlcLoadMisses != nil {
		data[i] = 0x88
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcLoadMisses))
	}
	if m.LlcStores != nil {
		data[i] = 0x90
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcStores))
	}
	if m.LlcStoreMisses != nil {
		data[i] = 0x98
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcStoreMisses))
	}
	if m.LlcPrefetches != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcPrefetches))
	}
	if m.LlcPrefetchMisses != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.LlcPrefetchMisses))
	}
	if m.DtlbLoads != nil {
		data[i] = 0xb0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbLoads))
	}
	if m.DtlbLoadMisses != nil {
		data[i] = 0xb8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbLoadMisses))
	}
	if m.DtlbStores != nil {
		data[i] = 0xc0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbStores))
	}
	if m.DtlbStoreMisses != nil {
		data[i] = 0xc8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbStoreMisses))
	}
	if m.DtlbPrefetches != nil {
		data[i] = 0xd0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbPrefetches))
	}
	if m.DtlbPrefetchMisses != nil {
		data[i] = 0xd8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.DtlbPrefetchMisses))
	}
	if m.ItlbLoads != nil {
		data[i] = 0xe0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ItlbLoads))
	}
	if m.ItlbLoadMisses != nil {
		data[i] = 0xe8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ItlbLoadMisses))
	}
	if m.BranchLoads != nil {
		data[i] = 0xf0
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchLoads))
	}
	if m.BranchLoadMisses != nil {
		data[i] = 0xf8
		i++
		data[i] = 0x2
		i++
		i = encodeVarintMesos(data, i, uint64(*m.BranchLoadMisses))
	}
	if m.NodeLoads != nil {
		data[i] = 0x80
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeLoads))
	}
	if m.NodeLoadMisses != nil {
		data[i] = 0x88
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeLoadMisses))
	}
	if m.NodeStores != nil {
		data[i] = 0x90
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeStores))
	}
	if m.NodeStoreMisses != nil {
		data[i] = 0x98
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodeStoreMisses))
	}
	if m.NodePrefetches != nil {
		data[i] = 0xa0
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodePrefetches))
	}
	if m.NodePrefetchMisses != nil {
		data[i] = 0xa8
		i++
		data[i] = 0x3
		i++
		i = encodeVarintMesos(data, i, uint64(*m.NodePrefetchMisses))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Request) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Request) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SlaveId != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n39, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n40, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n40
	}
	if m.FrameworkId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n41, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	if m.SlaveId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("slave_id")
	} else {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n42, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.Hostname == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("hostname")
	} else {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ExecutorIds) > 0 {
		for _, msg := range m.ExecutorIds {
			data[i] = 0x32
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			data[i] = 0x3a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Url != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.Url.Size()))
		n43, err := m.Url.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	if m.Unavailability != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Unavailability.Size()))
		n44, err := m.Unavailability.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Launch != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Launch.Size()))
		n45, err := m.Launch.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	if m.Reserve != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Reserve.Size()))
		n46, err := m.Reserve.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	if m.Unreserve != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Unreserve.Size()))
		n47, err := m.Unreserve.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	if m.Create != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Create.Size()))
		n48, err := m.Create.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	if m.Destroy != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Destroy.Size()))
		n49, err := m.Destroy.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation_Launch) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation_Launch) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, msg := range m.TaskInfos {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation_Reserve) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation_Reserve) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation_Unreserve) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation_Unreserve) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation_Create) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation_Create) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Offer_Operation_Destroy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Offer_Operation_Destroy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *InverseOffer) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *InverseOffer) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Id.Size()))
		n50, err := m.Id.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	if m.Url != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Url.Size()))
		n51, err := m.Url.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.FrameworkId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	} else {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.FrameworkId.Size()))
		n52, err := m.FrameworkId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n52
	}
	if m.SlaveId != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n53, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	if m.Unavailability == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("unavailability")
	} else {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Unavailability.Size()))
		n54, err := m.Unavailability.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n54
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x32
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.TaskId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.TaskId.Size()))
		n55, err := m.TaskId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n55
	}
	if m.SlaveId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("slave_id")
	} else {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n56, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n56
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x22
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Executor != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Executor.Size()))
		n57, err := m.Executor.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n57
	}
	if m.Data != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.Command != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Command.Size()))
		n58, err := m.Command.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n58
	}
	if m.HealthCheck != nil {
		data[i] = 0x42
		i++
		i = encodeVarintMesos(data, i, uint64(m.HealthCheck.Size()))
		n59, err := m.HealthCheck.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n59
	}
	if m.Container != nil {
		data[i] = 0x4a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Container.Size()))
		n60, err := m.Container.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n60
	}
	if m.Labels != nil {
		data[i] = 0x52
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n61, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n61
	}
	if m.Discovery != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Discovery.Size()))
		n62, err := m.Discovery.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n62
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TaskStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TaskStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TaskId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.TaskId.Size()))
		n63, err := m.TaskId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n63
	}
	if m.State == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.State))
	}
	if m.Data != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.Message != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Message)))
		i += copy(data[i:], *m.Message)
	}
	if m.SlaveId != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.SlaveId.Size()))
		n64, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n64
	}
	if m.Timestamp != nil {
		data[i] = 0x31
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Timestamp)))
	}
	if m.ExecutorId != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.ExecutorId.Size()))
		n65, err := m.ExecutorId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n65
	}
	if m.Healthy != nil {
		data[i] = 0x40
		i++
		if *m.Healthy {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Source != nil {
		data[i] = 0x48
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Source))
	}
	if m.Reason != nil {
		data[i] = 0x50
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Reason))
	}
	if m.Uuid != nil {
		data[i] = 0x5a
		i++
		i = encodeVarintMesos(data, i, uint64(len(m.Uuid)))
		i += copy(data[i:], m.Uuid)
	}
	if m.Labels != nil {
		data[i] = 0x62
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n66, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n66
	}
	if m.ContainerStatus != nil {
		data[i] = 0x6a
		i++
		i = encodeVarintMesos(data, i, uint64(m.ContainerStatus.Size()))
		n67, err := m.ContainerStatus.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n67
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Filters) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Filters) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RefuseSeconds != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.RefuseSeconds)))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Environment) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Environment) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for _, msg := range m.Variables {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Environment_Variable) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Environment_Variable) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Parameter) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Parameter) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Key)))
		i += copy(data[i:], *m.Key)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Parameters) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Parameters) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Parameter) > 0 {
		for _, msg := range m.Parameter {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Credential) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Credential) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Principal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.Secret != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Secret)))
		i += copy(data[i:], *m.Secret)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Credentials) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Credentials) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Credentials) > 0 {
		for _, msg := range m.Credentials {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimit) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RateLimit) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Qps != nil {
		data[i] = 0x9
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.Qps)))
	}
	if m.Principal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Principal)))
		i += copy(data[i:], *m.Principal)
	}
	if m.Capacity != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Capacity))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RateLimits) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RateLimits) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, msg := range m.Limits {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AggregateDefaultQps != nil {
		data[i] = 0x11
		i++
		i = encodeFixed64Mesos(data, i, uint64(math.Float64bits(*m.AggregateDefaultQps)))
	}
	if m.AggregateDefaultCapacity != nil {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.AggregateDefaultCapacity))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Image) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Image) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if m.Appc != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(m.Appc.Size()))
		n68, err := m.Appc.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n68
	}
	if m.Docker != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Docker.Size()))
		n69, err := m.Docker.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n69
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Image_Appc) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Image_Appc) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Id != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Id)))
		i += copy(data[i:], *m.Id)
	}
	if m.Labels != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n70, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n70
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Image_Docker) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Image_Docker) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Volume) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Volume) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerPath == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_path")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.ContainerPath)))
		i += copy(data[i:], *m.ContainerPath)
	}
	if m.HostPath != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.HostPath)))
		i += copy(data[i:], *m.HostPath)
	}
	if m.Mode == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("mode")
	} else {
		data[i] = 0x18
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Mode))
	}
	if m.Image != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Image.Size()))
		n71, err := m.Image.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n71
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NetworkInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NetworkInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Protocol))
	}
	if m.IpAddress != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.IpAddress)))
		i += copy(data[i:], *m.IpAddress)
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			data[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				data[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			data[i] = uint8(l)
			i++
			i += copy(data[i:], s)
		}
	}
	if m.Labels != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n72, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n72
	}
	if len(m.IpAddresses) > 0 {
		for _, msg := range m.IpAddresses {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *NetworkInfo_IPAddress) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NetworkInfo_IPAddress) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != nil {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Protocol))
	}
	if m.IpAddress != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.IpAddress)))
		i += copy(data[i:], *m.IpAddress)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Type))
	}
	if len(m.Volumes) > 0 {
		for _, msg := range m.Volumes {
			data[i] = 0x12
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Docker != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Docker.Size()))
		n73, err := m.Docker.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n73
	}
	if m.Hostname != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Hostname)))
		i += copy(data[i:], *m.Hostname)
	}
	if m.Mesos != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Mesos.Size()))
		n74, err := m.Mesos.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n74
	}
	if len(m.NetworkInfos) > 0 {
		for _, msg := range m.NetworkInfos {
			data[i] = 0x3a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo_DockerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo_DockerInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Image == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("image")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Image)))
		i += copy(data[i:], *m.Image)
	}
	if m.Network != nil {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Network))
	}
	if len(m.PortMappings) > 0 {
		for _, msg := range m.PortMappings {
			data[i] = 0x1a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Privileged != nil {
		data[i] = 0x20
		i++
		if *m.Privileged {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if len(m.Parameters) > 0 {
		for _, msg := range m.Parameters {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ForcePullImage != nil {
		data[i] = 0x30
		i++
		if *m.ForcePullImage {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo_DockerInfo_PortMapping) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo_DockerInfo_PortMapping) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HostPort == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("host_port")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.HostPort))
	}
	if m.ContainerPort == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_port")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintMesos(data, i, uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Protocol)))
		i += copy(data[i:], *m.Protocol)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerInfo_MesosInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerInfo_MesosInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Image != nil {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(m.Image.Size()))
		n75, err := m.Image.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n75
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ContainerStatus) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ContainerStatus) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NetworkInfos) > 0 {
		for _, msg := range m.NetworkInfos {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Labels) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Labels) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Label) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Label) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Key)))
		i += copy(data[i:], *m.Key)
	}
	if m.Value != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Port) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Port) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Number == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("number")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Number))
	}
	if m.Name != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Protocol != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Protocol)))
		i += copy(data[i:], *m.Protocol)
	}
	if m.Visibility != nil {
		data[i] = 0x20
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Visibility))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Ports) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Ports) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			data[i] = 0xa
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DiscoveryInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *DiscoveryInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Visibility == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("visibility")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintMesos(data, i, uint64(*m.Visibility))
	}
	if m.Name != nil {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Environment != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Environment)))
		i += copy(data[i:], *m.Environment)
	}
	if m.Location != nil {
		data[i] = 0x22
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Location)))
		i += copy(data[i:], *m.Location)
	}
	if m.Version != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Version)))
		i += copy(data[i:], *m.Version)
	}
	if m.Ports != nil {
		data[i] = 0x32
		i++
		i = encodeVarintMesos(data, i, uint64(m.Ports.Size()))
		n76, err := m.Ports.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n76
	}
	if m.Labels != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintMesos(data, i, uint64(m.Labels.Size()))
		n77, err := m.Labels.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n77
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AppcImageManifest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AppcImageManifest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AcKind == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("acKind")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.AcKind)))
		i += copy(data[i:], *m.AcKind)
	}
	if m.AcVersion == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("acVersion")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.AcVersion)))
		i += copy(data[i:], *m.AcVersion)
	}
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0x1a
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			data[i] = 0x22
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Annotations) > 0 {
		for _, msg := range m.Annotations {
			data[i] = 0x2a
			i++
			i = encodeVarintMesos(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AppcImageManifest_Label) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AppcImageManifest_Label) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AppcImageManifest_Annotation) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AppcImageManifest_Annotation) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Name)))
		i += copy(data[i:], *m.Name)
	}
	if m.Value == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintMesos(data, i, uint64(len(*m.Value)))
		i += copy(data[i:], *m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Mesos(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Mesos(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMesos(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedFrameworkID(r randyMesos, easy bool) *FrameworkID {
	this := &FrameworkID{}
	v1 := randStringMesos(r)
	this.Value = &v1
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOfferID(r randyMesos, easy bool) *OfferID {
	this := &OfferID{}
	v2 := randStringMesos(r)
	this.Value = &v2
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedSlaveID(r randyMesos, easy bool) *SlaveID {
	this := &SlaveID{}
	v3 := randStringMesos(r)
	this.Value = &v3
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedTaskID(r randyMesos, easy bool) *TaskID {
	this := &TaskID{}
	v4 := randStringMesos(r)
	this.Value = &v4
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedExecutorID(r randyMesos, easy bool) *ExecutorID {
	this := &ExecutorID{}
	v5 := randStringMesos(r)
	this.Value = &v5
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedContainerID(r randyMesos, easy bool) *ContainerID {
	this := &ContainerID{}
	v6 := randStringMesos(r)
	this.Value = &v6
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedTimeInfo(r randyMesos, easy bool) *TimeInfo {
	this := &TimeInfo{}
	v7 := int64(r.Int63())
	if r.Intn(2) == 0 {
		v7 *= -1
	}
	this.Nanoseconds = &v7
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedDurationInfo(r randyMesos, easy bool) *DurationInfo {
	this := &DurationInfo{}
	v8 := int64(r.Int63())
	if r.Intn(2) == 0 {
		v8 *= -1
	}
	this.Nanoseconds = &v8
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedAddress(r randyMesos, easy bool) *Address {
	this := &Address{}
	if r.Intn(10) != 0 {
		v9 := randStringMesos(r)
		this.Hostname = &v9
	}
	if r.Intn(10) != 0 {
		v10 := randStringMesos(r)
		this.Ip = &v10
	}
	v11 := int32(r.Int31())
	if r.Intn(2) == 0 {
		v11 *= -1
	}
	this.Port = &v11
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedURL(r randyMesos, easy bool) *URL {
	this := &URL{}
	v12 := randStringMesos(r)
	this.Scheme = &v12
	this.Address = NewPopulatedAddress(r, easy)
	if r.Intn(10) != 0 {
		v13 := randStringMesos(r)
		this.Path = &v13
	}
	if r.Intn(10) != 0 {
		v14 := r.Intn(10)
		this.Query = make([]*Parameter, v14)
		for i := 0; i < v14; i++ {
			this.Query[i] = NewPopulatedParameter(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v15 := randStringMesos(r)
		this.Fragment = &v15
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedUnavailability(r randyMesos, easy bool) *Unavailability {
	this := &Unavailability{}
	this.Start = NewPopulatedTimeInfo(r, easy)
	if r.Intn(10) != 0 {
		this.Duration = NewPopulatedDurationInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedMachineID(r randyMesos, easy bool) *MachineID {
	this := &MachineID{}
	if r.Intn(10) != 0 {
		v16 := randStringMesos(r)
		this.Hostname = &v16
	}
	if r.Intn(10) != 0 {
		v17 := randStringMesos(r)
		this.Ip = &v17
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedMachineInfo(r randyMesos, easy bool) *MachineInfo {
	this := &MachineInfo{}
	this.Id = NewPopulatedMachineID(r, easy)
	if r.Intn(10) != 0 {
		v18 := MachineInfo_Mode([]int32{1, 2, 3}[r.Intn(3)])
		this.Mode = &v18
	}
	if r.Intn(10) != 0 {
		this.Unavailability = NewPopulatedUnavailability(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedFrameworkInfo(r randyMesos, easy bool) *FrameworkInfo {
	this := &FrameworkInfo{}
	v19 := randStringMesos(r)
	this.User = &v19
	v20 := randStringMesos(r)
	this.Name = &v20
	if r.Intn(10) != 0 {
		this.Id = NewPopulatedFrameworkID(r, easy)
	}
	if r.Intn(10) != 0 {
		v21 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v21 *= -1
		}
		this.FailoverTimeout = &v21
	}
	if r.Intn(10) != 0 {
		v22 := bool(bool(r.Intn(2) == 0))
		this.Checkpoint = &v22
	}
	if r.Intn(10) != 0 {
		v23 := randStringMesos(r)
		this.Role = &v23
	}
	if r.Intn(10) != 0 {
		v24 := randStringMesos(r)
		this.Hostname = &v24
	}
	if r.Intn(10) != 0 {
		v25 := randStringMesos(r)
		this.Principal = &v25
	}
	if r.Intn(10) != 0 {
		v26 := randStringMesos(r)
		this.WebuiUrl = &v26
	}
	if r.Intn(10) != 0 {
		v27 := r.Intn(10)
		this.Capabilities = make([]*FrameworkInfo_Capability, v27)
		for i := 0; i < v27; i++ {
			this.Capabilities[i] = NewPopulatedFrameworkInfo_Capability(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 12)
	}
	return this
}

func NewPopulatedFrameworkInfo_Capability(r randyMesos, easy bool) *FrameworkInfo_Capability {
	this := &FrameworkInfo_Capability{}
	v28 := FrameworkInfo_Capability_Type([]int32{1}[r.Intn(1)])
	this.Type = &v28
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedHealthCheck(r randyMesos, easy bool) *HealthCheck {
	this := &HealthCheck{}
	if r.Intn(10) != 0 {
		this.Http = NewPopulatedHealthCheck_HTTP(r, easy)
	}
	if r.Intn(10) != 0 {
		v29 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v29 *= -1
		}
		this.DelaySeconds = &v29
	}
	if r.Intn(10) != 0 {
		v30 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v30 *= -1
		}
		this.IntervalSeconds = &v30
	}
	if r.Intn(10) != 0 {
		v31 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v31 *= -1
		}
		this.TimeoutSeconds = &v31
	}
	if r.Intn(10) != 0 {
		v32 := uint32(r.Uint32())
		this.ConsecutiveFailures = &v32
	}
	if r.Intn(10) != 0 {
		v33 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v33 *= -1
		}
		this.GracePeriodSeconds = &v33
	}
	if r.Intn(10) != 0 {
		this.Command = NewPopulatedCommandInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedHealthCheck_HTTP(r randyMesos, easy bool) *HealthCheck_HTTP {
	this := &HealthCheck_HTTP{}
	v34 := uint32(r.Uint32())
	this.Port = &v34
	if r.Intn(10) != 0 {
		v35 := randStringMesos(r)
		this.Path = &v35
	}
	if r.Intn(10) != 0 {
		v36 := r.Intn(100)
		this.Statuses = make([]uint32, v36)
		for i := 0; i < v36; i++ {
			this.Statuses[i] = uint32(r.Uint32())
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedCommandInfo(r randyMesos, easy bool) *CommandInfo {
	this := &CommandInfo{}
	if r.Intn(10) != 0 {
		v37 := r.Intn(10)
		this.Uris = make([]*CommandInfo_URI, v37)
		for i := 0; i < v37; i++ {
			this.Uris[i] = NewPopulatedCommandInfo_URI(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Environment = NewPopulatedEnvironment(r, easy)
	}
	if r.Intn(10) != 0 {
		v38 := randStringMesos(r)
		this.Value = &v38
	}
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedCommandInfo_ContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v39 := randStringMesos(r)
		this.User = &v39
	}
	if r.Intn(10) != 0 {
		v40 := bool(bool(r.Intn(2) == 0))
		this.Shell = &v40
	}
	if r.Intn(10) != 0 {
		v41 := r.Intn(10)
		this.Arguments = make([]string, v41)
		for i := 0; i < v41; i++ {
			this.Arguments[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedCommandInfo_URI(r randyMesos, easy bool) *CommandInfo_URI {
	this := &CommandInfo_URI{}
	v42 := randStringMesos(r)
	this.Value = &v42
	if r.Intn(10) != 0 {
		v43 := bool(bool(r.Intn(2) == 0))
		this.Executable = &v43
	}
	if r.Intn(10) != 0 {
		v44 := bool(bool(r.Intn(2) == 0))
		this.Extract = &v44
	}
	if r.Intn(10) != 0 {
		v45 := bool(bool(r.Intn(2) == 0))
		this.Cache = &v45
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedCommandInfo_ContainerInfo(r randyMesos, easy bool) *CommandInfo_ContainerInfo {
	this := &CommandInfo_ContainerInfo{}
	v46 := randStringMesos(r)
	this.Image = &v46
	if r.Intn(10) != 0 {
		v47 := r.Intn(10)
		this.Options = make([]string, v47)
		for i := 0; i < v47; i++ {
			this.Options[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedExecutorInfo(r randyMesos, easy bool) *ExecutorInfo {
	this := &ExecutorInfo{}
	this.ExecutorId = NewPopulatedExecutorID(r, easy)
	if r.Intn(10) != 0 {
		v48 := r.Intn(100)
		this.Data = make([]byte, v48)
		for i := 0; i < v48; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v49 := r.Intn(10)
		this.Resources = make([]*Resource, v49)
		for i := 0; i < v49; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	this.Command = NewPopulatedCommandInfo(r, easy)
	if r.Intn(10) != 0 {
		this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	}
	if r.Intn(10) != 0 {
		v50 := randStringMesos(r)
		this.Name = &v50
	}
	if r.Intn(10) != 0 {
		v51 := randStringMesos(r)
		this.Source = &v51
	}
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Discovery = NewPopulatedDiscoveryInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 13)
	}
	return this
}

func NewPopulatedMasterInfo(r randyMesos, easy bool) *MasterInfo {
	this := &MasterInfo{}
	v52 := randStringMesos(r)
	this.Id = &v52
	v53 := uint32(r.Uint32())
	this.Ip = &v53
	v54 := uint32(r.Uint32())
	this.Port = &v54
	if r.Intn(10) != 0 {
		v55 := randStringMesos(r)
		this.Pid = &v55
	}
	if r.Intn(10) != 0 {
		v56 := randStringMesos(r)
		this.Hostname = &v56
	}
	if r.Intn(10) != 0 {
		v57 := randStringMesos(r)
		this.Version = &v57
	}
	if r.Intn(10) != 0 {
		this.Address = NewPopulatedAddress(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedSlaveInfo(r randyMesos, easy bool) *SlaveInfo {
	this := &SlaveInfo{}
	v58 := randStringMesos(r)
	this.Hostname = &v58
	if r.Intn(10) != 0 {
		v59 := r.Intn(10)
		this.Resources = make([]*Resource, v59)
		for i := 0; i < v59; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v60 := r.Intn(10)
		this.Attributes = make([]*Attribute, v60)
		for i := 0; i < v60; i++ {
			this.Attributes[i] = NewPopulatedAttribute(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Id = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v61 := bool(bool(r.Intn(2) == 0))
		this.Checkpoint = &v61
	}
	if r.Intn(10) != 0 {
		v62 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v62 *= -1
		}
		this.Port = &v62
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 9)
	}
	return this
}

func NewPopulatedValue(r randyMesos, easy bool) *Value {
	this := &Value{}
	v63 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v63
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Text = NewPopulatedValue_Text(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedValue_Scalar(r randyMesos, easy bool) *Value_Scalar {
	this := &Value_Scalar{}
	v64 := float64(r.Float64())
	if r.Intn(2) == 0 {
		v64 *= -1
	}
	this.Value = &v64
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Range(r randyMesos, easy bool) *Value_Range {
	this := &Value_Range{}
	v65 := uint64(uint64(r.Uint32()))
	this.Begin = &v65
	v66 := uint64(uint64(r.Uint32()))
	this.End = &v66
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedValue_Ranges(r randyMesos, easy bool) *Value_Ranges {
	this := &Value_Ranges{}
	if r.Intn(10) != 0 {
		v67 := r.Intn(10)
		this.Range = make([]*Value_Range, v67)
		for i := 0; i < v67; i++ {
			this.Range[i] = NewPopulatedValue_Range(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Set(r randyMesos, easy bool) *Value_Set {
	this := &Value_Set{}
	if r.Intn(10) != 0 {
		v68 := r.Intn(10)
		this.Item = make([]string, v68)
		for i := 0; i < v68; i++ {
			this.Item[i] = randStringMesos(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedValue_Text(r randyMesos, easy bool) *Value_Text {
	this := &Value_Text{}
	v69 := randStringMesos(r)
	this.Value = &v69
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedAttribute(r randyMesos, easy bool) *Attribute {
	this := &Attribute{}
	v70 := randStringMesos(r)
	this.Name = &v70
	v71 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v71
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Text = NewPopulatedValue_Text(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedResource(r randyMesos, easy bool) *Resource {
	this := &Resource{}
	v72 := randStringMesos(r)
	this.Name = &v72
	v73 := Value_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	this.Type = &v73
	if r.Intn(10) != 0 {
		this.Scalar = NewPopulatedValue_Scalar(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Ranges = NewPopulatedValue_Ranges(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Set = NewPopulatedValue_Set(r, easy)
	}
	if r.Intn(10) != 0 {
		v74 := randStringMesos(r)
		this.Role = &v74
	}
	if r.Intn(10) != 0 {
		this.Disk = NewPopulatedResource_DiskInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Reservation = NewPopulatedResource_ReservationInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Revocable = NewPopulatedResource_RevocableInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 10)
	}
	return this
}

func NewPopulatedResource_ReservationInfo(r randyMesos, easy bool) *Resource_ReservationInfo {
	this := &Resource_ReservationInfo{}
	v75 := randStringMesos(r)
	this.Principal = &v75
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedResource_DiskInfo(r randyMesos, easy bool) *Resource_DiskInfo {
	this := &Resource_DiskInfo{}
	if r.Intn(10) != 0 {
		this.Persistence = NewPopulatedResource_DiskInfo_Persistence(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Volume = NewPopulatedVolume(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedResource_DiskInfo_Persistence(r randyMesos, easy bool) *Resource_DiskInfo_Persistence {
	this := &Resource_DiskInfo_Persistence{}
	v76 := randStringMesos(r)
	this.Id = &v76
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedResource_RevocableInfo(r randyMesos, easy bool) *Resource_RevocableInfo {
	this := &Resource_RevocableInfo{}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 1)
	}
	return this
}

func NewPopulatedTrafficControlStatistics(r randyMesos, easy bool) *TrafficControlStatistics {
	this := &TrafficControlStatistics{}
	v77 := randStringMesos(r)
	this.Id = &v77
	if r.Intn(10) != 0 {
		v78 := uint64(uint64(r.Uint32()))
		this.Backlog = &v78
	}
	if r.Intn(10) != 0 {
		v79 := uint64(uint64(r.Uint32()))
		this.Bytes = &v79
	}
	if r.Intn(10) != 0 {
		v80 := uint64(uint64(r.Uint32()))
		this.Drops = &v80
	}
	if r.Intn(10) != 0 {
		v81 := uint64(uint64(r.Uint32()))
		this.Overlimits = &v81
	}
	if r.Intn(10) != 0 {
		v82 := uint64(uint64(r.Uint32()))
		this.Packets = &v82
	}
	if r.Intn(10) != 0 {
		v83 := uint64(uint64(r.Uint32()))
		this.Qlen = &v83
	}
	if r.Intn(10) != 0 {
		v84 := uint64(uint64(r.Uint32()))
		this.Ratebps = &v84
	}
	if r.Intn(10) != 0 {
		v85 := uint64(uint64(r.Uint32()))
		this.Ratepps = &v85
	}
	if r.Intn(10) != 0 {
		v86 := uint64(uint64(r.Uint32()))
		this.Requeues = &v86
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 11)
	}
	return this
}

func NewPopulatedResourceStatistics(r randyMesos, easy bool) *ResourceStatistics {
	this := &ResourceStatistics{}
	v87 := float64(r.Float64())
	if r.Intn(2) == 0 {
		v87 *= -1
	}
	this.Timestamp = &v87
	if r.Intn(10) != 0 {
		v88 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v88 *= -1
		}
		this.CpusUserTimeSecs = &v88
	}
	if r.Intn(10) != 0 {
		v89 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v89 *= -1
		}
		this.CpusSystemTimeSecs = &v89
	}
	if r.Intn(10) != 0 {
		v90 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v90 *= -1
		}
		this.CpusLimit = &v90
	}
	if r.Intn(10) != 0 {
		v91 := uint64(uint64(r.Uint32()))
		this.MemRssBytes = &v91
	}
	if r.Intn(10) != 0 {
		v92 := uint64(uint64(r.Uint32()))
		this.MemLimitBytes = &v92
	}
	if r.Intn(10) != 0 {
		v93 := uint32(r.Uint32())
		this.CpusNrPeriods = &v93
	}
	if r.Intn(10) != 0 {
		v94 := uint32(r.Uint32())
		this.CpusNrThrottled = &v94
	}
	if r.Intn(10) != 0 {
		v95 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v95 *= -1
		}
		this.CpusThrottledTimeSecs = &v95
	}
	if r.Intn(10) != 0 {
		v96 := uint64(uint64(r.Uint32()))
		this.MemFileBytes = &v96
	}
	if r.Intn(10) != 0 {
		v97 := uint64(uint64(r.Uint32()))
		this.MemAnonBytes = &v97
	}
	if r.Intn(10) != 0 {
		v98 := uint64(uint64(r.Uint32()))
		this.MemMappedFileBytes = &v98
	}
	if r.Intn(10) != 0 {
		this.Perf = NewPopulatedPerfStatistics(r, easy)
	}
	if r.Intn(10) != 0 {
		v99 := uint64(uint64(r.Uint32()))
		this.NetRxPackets = &v99
	}
	if r.Intn(10) != 0 {
		v100 := uint64(uint64(r.Uint32()))
		this.NetRxBytes = &v100
	}
	if r.Intn(10) != 0 {
		v101 := uint64(uint64(r.Uint32()))
		this.NetRxErrors = &v101
	}
	if r.Intn(10) != 0 {
		v102 := uint64(uint64(r.Uint32()))
		this.NetRxDropped = &v102
	}
	if r.Intn(10) != 0 {
		v103 := uint64(uint64(r.Uint32()))
		this.NetTxPackets = &v103
	}
	if r.Intn(10) != 0 {
		v104 := uint64(uint64(r.Uint32()))
		this.NetTxBytes = &v104
	}
	if r.Intn(10) != 0 {
		v105 := uint64(uint64(r.Uint32()))
		this.NetTxErrors = &v105
	}
	if r.Intn(10) != 0 {
		v106 := uint64(uint64(r.Uint32()))
		this.NetTxDropped = &v106
	}
	if r.Intn(10) != 0 {
		v107 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v107 *= -1
		}
		this.NetTcpRttMicrosecsP50 = &v107
	}
	if r.Intn(10) != 0 {
		v108 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v108 *= -1
		}
		this.NetTcpRttMicrosecsP90 = &v108
	}
	if r.Intn(10) != 0 {
		v109 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v109 *= -1
		}
		this.NetTcpRttMicrosecsP95 = &v109
	}
	if r.Intn(10) != 0 {
		v110 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v110 *= -1
		}
		this.NetTcpRttMicrosecsP99 = &v110
	}
	if r.Intn(10) != 0 {
		v111 := uint64(uint64(r.Uint32()))
		this.DiskLimitBytes = &v111
	}
	if r.Intn(10) != 0 {
		v112 := uint64(uint64(r.Uint32()))
		this.DiskUsedBytes = &v112
	}
	if r.Intn(10) != 0 {
		v113 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v113 *= -1
		}
		this.NetTcpActiveConnections = &v113
	}
	if r.Intn(10) != 0 {
		v114 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v114 *= -1
		}
		this.NetTcpTimeWaitConnections = &v114
	}
	if r.Intn(10) != 0 {
		v115 := uint32(r.Uint32())
		this.Processes = &v115
	}
	if r.Intn(10) != 0 {
		v116 := uint32(r.Uint32())
		this.Threads = &v116
	}
	if r.Intn(10) != 0 {
		v117 := uint64(uint64(r.Uint32()))
		this.MemLowPressureCounter = &v117
	}
	if r.Intn(10) != 0 {
		v118 := uint64(uint64(r.Uint32()))
		this.MemMediumPressureCounter = &v118
	}
	if r.Intn(10) != 0 {
		v119 := uint64(uint64(r.Uint32()))
		this.MemCriticalPressureCounter = &v119
	}
	if r.Intn(10) != 0 {
		v120 := r.Intn(10)
		this.NetTrafficControlStatistics = make([]*TrafficControlStatistics, v120)
		for i := 0; i < v120; i++ {
			this.NetTrafficControlStatistics[i] = NewPopulatedTrafficControlStatistics(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v121 := uint64(uint64(r.Uint32()))
		this.MemTotalBytes = &v121
	}
	if r.Intn(10) != 0 {
		v122 := uint64(uint64(r.Uint32()))
		this.MemTotalMemswBytes = &v122
	}
	if r.Intn(10) != 0 {
		v123 := uint64(uint64(r.Uint32()))
		this.MemSoftLimitBytes = &v123
	}
	if r.Intn(10) != 0 {
		v124 := uint64(uint64(r.Uint32()))
		this.MemCacheBytes = &v124
	}
	if r.Intn(10) != 0 {
		v125 := uint64(uint64(r.Uint32()))
		this.MemSwapBytes = &v125
	}
	if r.Intn(10) != 0 {
		v126 := uint64(uint64(r.Uint32()))
		this.MemUnevictableBytes = &v126
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 42)
	}
	return this
}

func NewPopulatedResourceUsage(r randyMesos, easy bool) *ResourceUsage {
	this := &ResourceUsage{}
	if r.Intn(10) != 0 {
		v127 := r.Intn(10)
		this.Executors = make([]*ResourceUsage_Executor, v127)
		for i := 0; i < v127; i++ {
			this.Executors[i] = NewPopulatedResourceUsage_Executor(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v128 := r.Intn(10)
		this.Total = make([]*Resource, v128)
		for i := 0; i < v128; i++ {
			this.Total[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedResourceUsage_Executor(r randyMesos, easy bool) *ResourceUsage_Executor {
	this := &ResourceUsage_Executor{}
	this.ExecutorInfo = NewPopulatedExecutorInfo(r, easy)
	if r.Intn(10) != 0 {
		v129 := r.Intn(10)
		this.Allocated = make([]*Resource, v129)
		for i := 0; i < v129; i++ {
			this.Allocated[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Statistics = NewPopulatedResourceStatistics(r, easy)
	}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedPerfStatistics(r randyMesos, easy bool) *PerfStatistics {
	this := &PerfStatistics{}
	v130 := float64(r.Float64())
	if r.Intn(2) == 0 {
		v130 *= -1
	}
	this.Timestamp = &v130
	v131 := float64(r.Float64())
	if r.Intn(2) == 0 {
		v131 *= -1
	}
	this.Duration = &v131
	if r.Intn(10) != 0 {
		v132 := uint64(uint64(r.Uint32()))
		this.Cycles = &v132
	}
	if r.Intn(10) != 0 {
		v133 := uint64(uint64(r.Uint32()))
		this.StalledCyclesFrontend = &v133
	}
	if r.Intn(10) != 0 {
		v134 := uint64(uint64(r.Uint32()))
		this.StalledCyclesBackend = &v134
	}
	if r.Intn(10) != 0 {
		v135 := uint64(uint64(r.Uint32()))
		this.Instructions = &v135
	}
	if r.Intn(10) != 0 {
		v136 := uint64(uint64(r.Uint32()))
		this.CacheReferences = &v136
	}
	if r.Intn(10) != 0 {
		v137 := uint64(uint64(r.Uint32()))
		this.CacheMisses = &v137
	}
	if r.Intn(10) != 0 {
		v138 := uint64(uint64(r.Uint32()))
		this.Branches = &v138
	}
	if r.Intn(10) != 0 {
		v139 := uint64(uint64(r.Uint32()))
		this.BranchMisses = &v139
	}
	if r.Intn(10) != 0 {
		v140 := uint64(uint64(r.Uint32()))
		this.BusCycles = &v140
	}
	if r.Intn(10) != 0 {
		v141 := uint64(uint64(r.Uint32()))
		this.RefCycles = &v141
	}
	if r.Intn(10) != 0 {
		v142 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v142 *= -1
		}
		this.CpuClock = &v142
	}
	if r.Intn(10) != 0 {
		v143 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v143 *= -1
		}
		this.TaskClock = &v143
	}
	if r.Intn(10) != 0 {
		v144 := uint64(uint64(r.Uint32()))
		this.PageFaults = &v144
	}
	if r.Intn(10) != 0 {
		v145 := uint64(uint64(r.Uint32()))
		this.MinorFaults = &v145
	}
	if r.Intn(10) != 0 {
		v146 := uint64(uint64(r.Uint32()))
		this.MajorFaults = &v146
	}
	if r.Intn(10) != 0 {
		v147 := uint64(uint64(r.Uint32()))
		this.ContextSwitches = &v147
	}
	if r.Intn(10) != 0 {
		v148 := uint64(uint64(r.Uint32()))
		this.CpuMigrations = &v148
	}
	if r.Intn(10) != 0 {
		v149 := uint64(uint64(r.Uint32()))
		this.AlignmentFaults = &v149
	}
	if r.Intn(10) != 0 {
		v150 := uint64(uint64(r.Uint32()))
		this.EmulationFaults = &v150
	}
	if r.Intn(10) != 0 {
		v151 := uint64(uint64(r.Uint32()))
		this.L1DcacheLoads = &v151
	}
	if r.Intn(10) != 0 {
		v152 := uint64(uint64(r.Uint32()))
		this.L1DcacheLoadMisses = &v152
	}
	if r.Intn(10) != 0 {
		v153 := uint64(uint64(r.Uint32()))
		this.L1DcacheStores = &v153
	}
	if r.Intn(10) != 0 {
		v154 := uint64(uint64(r.Uint32()))
		this.L1DcacheStoreMisses = &v154
	}
	if r.Intn(10) != 0 {
		v155 := uint64(uint64(r.Uint32()))
		this.L1DcachePrefetches = &v155
	}
	if r.Intn(10) != 0 {
		v156 := uint64(uint64(r.Uint32()))
		this.L1DcachePrefetchMisses = &v156
	}
	if r.Intn(10) != 0 {
		v157 := uint64(uint64(r.Uint32()))
		this.L1IcacheLoads = &v157
	}
	if r.Intn(10) != 0 {
		v158 := uint64(uint64(r.Uint32()))
		this.L1IcacheLoadMisses = &v158
	}
	if r.Intn(10) != 0 {
		v159 := uint64(uint64(r.Uint32()))
		this.L1IcachePrefetches = &v159
	}
	if r.Intn(10) != 0 {
		v160 := uint64(uint64(r.Uint32()))
		this.L1IcachePrefetchMisses = &v160
	}
	if r.Intn(10) != 0 {
		v161 := uint64(uint64(r.Uint32()))
		this.LlcLoads = &v161
	}
	if r.Intn(10) != 0 {
		v162 := uint64(uint64(r.Uint32()))
		this.LlcLoadMisses = &v162
	}
	if r.Intn(10) != 0 {
		v163 := uint64(uint64(r.Uint32()))
		this.LlcStores = &v163
	}
	if r.Intn(10) != 0 {
		v164 := uint64(uint64(r.Uint32()))
		this.LlcStoreMisses = &v164
	}
	if r.Intn(10) != 0 {
		v165 := uint64(uint64(r.Uint32()))
		this.LlcPrefetches = &v165
	}
	if r.Intn(10) != 0 {
		v166 := uint64(uint64(r.Uint32()))
		this.LlcPrefetchMisses = &v166
	}
	if r.Intn(10) != 0 {
		v167 := uint64(uint64(r.Uint32()))
		this.DtlbLoads = &v167
	}
	if r.Intn(10) != 0 {
		v168 := uint64(uint64(r.Uint32()))
		this.DtlbLoadMisses = &v168
	}
	if r.Intn(10) != 0 {
		v169 := uint64(uint64(r.Uint32()))
		this.DtlbStores = &v169
	}
	if r.Intn(10) != 0 {
		v170 := uint64(uint64(r.Uint32()))
		this.DtlbStoreMisses = &v170
	}
	if r.Intn(10) != 0 {
		v171 := uint64(uint64(r.Uint32()))
		this.DtlbPrefetches = &v171
	}
	if r.Intn(10) != 0 {
		v172 := uint64(uint64(r.Uint32()))
		this.DtlbPrefetchMisses = &v172
	}
	if r.Intn(10) != 0 {
		v173 := uint64(uint64(r.Uint32()))
		this.ItlbLoads = &v173
	}
	if r.Intn(10) != 0 {
		v174 := uint64(uint64(r.Uint32()))
		this.ItlbLoadMisses = &v174
	}
	if r.Intn(10) != 0 {
		v175 := uint64(uint64(r.Uint32()))
		this.BranchLoads = &v175
	}
	if r.Intn(10) != 0 {
		v176 := uint64(uint64(r.Uint32()))
		this.BranchLoadMisses = &v176
	}
	if r.Intn(10) != 0 {
		v177 := uint64(uint64(r.Uint32()))
		this.NodeLoads = &v177
	}
	if r.Intn(10) != 0 {
		v178 := uint64(uint64(r.Uint32()))
		this.NodeLoadMisses = &v178
	}
	if r.Intn(10) != 0 {
		v179 := uint64(uint64(r.Uint32()))
		this.NodeStores = &v179
	}
	if r.Intn(10) != 0 {
		v180 := uint64(uint64(r.Uint32()))
		this.NodeStoreMisses = &v180
	}
	if r.Intn(10) != 0 {
		v181 := uint64(uint64(r.Uint32()))
		this.NodePrefetches = &v181
	}
	if r.Intn(10) != 0 {
		v182 := uint64(uint64(r.Uint32()))
		this.NodePrefetchMisses = &v182
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 54)
	}
	return this
}

func NewPopulatedRequest(r randyMesos, easy bool) *Request {
	this := &Request{}
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v183 := r.Intn(10)
		this.Resources = make([]*Resource, v183)
		for i := 0; i < v183; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedOffer(r randyMesos, easy bool) *Offer {
	this := &Offer{}
	this.Id = NewPopulatedOfferID(r, easy)
	this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	this.SlaveId = NewPopulatedSlaveID(r, easy)
	v184 := randStringMesos(r)
	this.Hostname = &v184
	if r.Intn(10) != 0 {
		v185 := r.Intn(10)
		this.Resources = make([]*Resource, v185)
		for i := 0; i < v185; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v186 := r.Intn(10)
		this.ExecutorIds = make([]*ExecutorID, v186)
		for i := 0; i < v186; i++ {
			this.ExecutorIds[i] = NewPopulatedExecutorID(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v187 := r.Intn(10)
		this.Attributes = make([]*Attribute, v187)
		for i := 0; i < v187; i++ {
			this.Attributes[i] = NewPopulatedAttribute(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Url = NewPopulatedURL(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Unavailability = NewPopulatedUnavailability(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 10)
	}
	return this
}

func NewPopulatedOffer_Operation(r randyMesos, easy bool) *Offer_Operation {
	this := &Offer_Operation{}
	v188 := Offer_Operation_Type([]int32{1, 2, 3, 4, 5}[r.Intn(5)])
	this.Type = &v188
	if r.Intn(10) != 0 {
		this.Launch = NewPopulatedOffer_Operation_Launch(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Reserve = NewPopulatedOffer_Operation_Reserve(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Unreserve = NewPopulatedOffer_Operation_Unreserve(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Create = NewPopulatedOffer_Operation_Create(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Destroy = NewPopulatedOffer_Operation_Destroy(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedOffer_Operation_Launch(r randyMesos, easy bool) *Offer_Operation_Launch {
	this := &Offer_Operation_Launch{}
	if r.Intn(10) != 0 {
		v189 := r.Intn(10)
		this.TaskInfos = make([]*TaskInfo, v189)
		for i := 0; i < v189; i++ {
			this.TaskInfos[i] = NewPopulatedTaskInfo(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOffer_Operation_Reserve(r randyMesos, easy bool) *Offer_Operation_Reserve {
	this := &Offer_Operation_Reserve{}
	if r.Intn(10) != 0 {
		v190 := r.Intn(10)
		this.Resources = make([]*Resource, v190)
		for i := 0; i < v190; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOffer_Operation_Unreserve(r randyMesos, easy bool) *Offer_Operation_Unreserve {
	this := &Offer_Operation_Unreserve{}
	if r.Intn(10) != 0 {
		v191 := r.Intn(10)
		this.Resources = make([]*Resource, v191)
		for i := 0; i < v191; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOffer_Operation_Create(r randyMesos, easy bool) *Offer_Operation_Create {
	this := &Offer_Operation_Create{}
	if r.Intn(10) != 0 {
		v192 := r.Intn(10)
		this.Volumes = make([]*Resource, v192)
		for i := 0; i < v192; i++ {
			this.Volumes[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedOffer_Operation_Destroy(r randyMesos, easy bool) *Offer_Operation_Destroy {
	this := &Offer_Operation_Destroy{}
	if r.Intn(10) != 0 {
		v193 := r.Intn(10)
		this.Volumes = make([]*Resource, v193)
		for i := 0; i < v193; i++ {
			this.Volumes[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedInverseOffer(r randyMesos, easy bool) *InverseOffer {
	this := &InverseOffer{}
	this.Id = NewPopulatedOfferID(r, easy)
	if r.Intn(10) != 0 {
		this.Url = NewPopulatedURL(r, easy)
	}
	this.FrameworkId = NewPopulatedFrameworkID(r, easy)
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	this.Unavailability = NewPopulatedUnavailability(r, easy)
	if r.Intn(10) != 0 {
		v194 := r.Intn(10)
		this.Resources = make([]*Resource, v194)
		for i := 0; i < v194; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedTaskInfo(r randyMesos, easy bool) *TaskInfo {
	this := &TaskInfo{}
	v195 := randStringMesos(r)
	this.Name = &v195
	this.TaskId = NewPopulatedTaskID(r, easy)
	this.SlaveId = NewPopulatedSlaveID(r, easy)
	if r.Intn(10) != 0 {
		v196 := r.Intn(10)
		this.Resources = make([]*Resource, v196)
		for i := 0; i < v196; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Executor = NewPopulatedExecutorInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v197 := r.Intn(100)
		this.Data = make([]byte, v197)
		for i := 0; i < v197; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.Command = NewPopulatedCommandInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.HealthCheck = NewPopulatedHealthCheck(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Container = NewPopulatedContainerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Discovery = NewPopulatedDiscoveryInfo(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 12)
	}
	return this
}

func NewPopulatedTaskStatus(r randyMesos, easy bool) *TaskStatus {
	this := &TaskStatus{}
	this.TaskId = NewPopulatedTaskID(r, easy)
	v198 := TaskState([]int32{6, 0, 1, 2, 3, 4, 5, 7}[r.Intn(8)])
	this.State = &v198
	if r.Intn(10) != 0 {
		v199 := r.Intn(100)
		this.Data = make([]byte, v199)
		for i := 0; i < v199; i++ {
			this.Data[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v200 := randStringMesos(r)
		this.Message = &v200
	}
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v201 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v201 *= -1
		}
		this.Timestamp = &v201
	}
	if r.Intn(10) != 0 {
		this.ExecutorId = NewPopulatedExecutorID(r, easy)
	}
	if r.Intn(10) != 0 {
		v202 := bool(bool(r.Intn(2) == 0))
		this.Healthy = &v202
	}
	if r.Intn(10) != 0 {
		v203 := TaskStatus_Source([]int32{0, 1, 2}[r.Intn(3)])
		this.Source = &v203
	}
	if r.Intn(10) != 0 {
		v204 := TaskStatus_Reason([]int32{0, 21, 19, 20, 8, 17, 22, 23, 24, 1, 2, 3, 4, 5, 6, 7, 9, 18, 10, 11, 12, 13, 14, 15, 16}[r.Intn(25)])
		this.Reason = &v204
	}
	if r.Intn(10) != 0 {
		v205 := r.Intn(100)
		this.Uuid = make([]byte, v205)
		for i := 0; i < v205; i++ {
			this.Uuid[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ContainerStatus = NewPopulatedContainerStatus(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 14)
	}
	return this
}

func NewPopulatedFilters(r randyMesos, easy bool) *Filters {
	this := &Filters{}
	if r.Intn(10) != 0 {
		v206 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v206 *= -1
		}
		this.RefuseSeconds = &v206
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedEnvironment(r randyMesos, easy bool) *Environment {
	this := &Environment{}
	if r.Intn(10) != 0 {
		v207 := r.Intn(10)
		this.Variables = make([]*Environment_Variable, v207)
		for i := 0; i < v207; i++ {
			this.Variables[i] = NewPopulatedEnvironment_Variable(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedEnvironment_Variable(r randyMesos, easy bool) *Environment_Variable {
	this := &Environment_Variable{}
	v208 := randStringMesos(r)
	this.Name = &v208
	v209 := randStringMesos(r)
	this.Value = &v209
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedParameter(r randyMesos, easy bool) *Parameter {
	this := &Parameter{}
	v210 := randStringMesos(r)
	this.Key = &v210
	v211 := randStringMesos(r)
	this.Value = &v211
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedParameters(r randyMesos, easy bool) *Parameters {
	this := &Parameters{}
	if r.Intn(10) != 0 {
		v212 := r.Intn(10)
		this.Parameter = make([]*Parameter, v212)
		for i := 0; i < v212; i++ {
			this.Parameter[i] = NewPopulatedParameter(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedCredential(r randyMesos, easy bool) *Credential {
	this := &Credential{}
	v213 := randStringMesos(r)
	this.Principal = &v213
	if r.Intn(10) != 0 {
		v214 := randStringMesos(r)
		this.Secret = &v214
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedCredentials(r randyMesos, easy bool) *Credentials {
	this := &Credentials{}
	if r.Intn(10) != 0 {
		v215 := r.Intn(10)
		this.Credentials = make([]*Credential, v215)
		for i := 0; i < v215; i++ {
			this.Credentials[i] = NewPopulatedCredential(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedRateLimit(r randyMesos, easy bool) *RateLimit {
	this := &RateLimit{}
	if r.Intn(10) != 0 {
		v216 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v216 *= -1
		}
		this.Qps = &v216
	}
	v217 := randStringMesos(r)
	this.Principal = &v217
	if r.Intn(10) != 0 {
		v218 := uint64(uint64(r.Uint32()))
		this.Capacity = &v218
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedRateLimits(r randyMesos, easy bool) *RateLimits {
	this := &RateLimits{}
	if r.Intn(10) != 0 {
		v219 := r.Intn(10)
		this.Limits = make([]*RateLimit, v219)
		for i := 0; i < v219; i++ {
			this.Limits[i] = NewPopulatedRateLimit(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v220 := float64(r.Float64())
		if r.Intn(2) == 0 {
			v220 *= -1
		}
		this.AggregateDefaultQps = &v220
	}
	if r.Intn(10) != 0 {
		v221 := uint64(uint64(r.Uint32()))
		this.AggregateDefaultCapacity = &v221
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedImage(r randyMesos, easy bool) *Image {
	this := &Image{}
	v222 := Image_Type([]int32{1, 2}[r.Intn(2)])
	this.Type = &v222
	if r.Intn(10) != 0 {
		this.Appc = NewPopulatedImage_Appc(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Docker = NewPopulatedImage_Docker(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedImage_Appc(r randyMesos, easy bool) *Image_Appc {
	this := &Image_Appc{}
	v223 := randStringMesos(r)
	this.Name = &v223
	if r.Intn(10) != 0 {
		v224 := randStringMesos(r)
		this.Id = &v224
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedImage_Docker(r randyMesos, easy bool) *Image_Docker {
	this := &Image_Docker{}
	v225 := randStringMesos(r)
	this.Name = &v225
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedVolume(r randyMesos, easy bool) *Volume {
	this := &Volume{}
	v226 := randStringMesos(r)
	this.ContainerPath = &v226
	if r.Intn(10) != 0 {
		v227 := randStringMesos(r)
		this.HostPath = &v227
	}
	v228 := Volume_Mode([]int32{1, 2}[r.Intn(2)])
	this.Mode = &v228
	if r.Intn(10) != 0 {
		this.Image = NewPopulatedImage(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedNetworkInfo(r randyMesos, easy bool) *NetworkInfo {
	this := &NetworkInfo{}
	if r.Intn(10) != 0 {
		v229 := NetworkInfo_Protocol([]int32{1, 2}[r.Intn(2)])
		this.Protocol = &v229
	}
	if r.Intn(10) != 0 {
		v230 := randStringMesos(r)
		this.IpAddress = &v230
	}
	if r.Intn(10) != 0 {
		v231 := r.Intn(10)
		this.Groups = make([]string, v231)
		for i := 0; i < v231; i++ {
			this.Groups[i] = randStringMesos(r)
		}
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if r.Intn(10) != 0 {
		v232 := r.Intn(10)
		this.IpAddresses = make([]*NetworkInfo_IPAddress, v232)
		for i := 0; i < v232; i++ {
			this.IpAddresses[i] = NewPopulatedNetworkInfo_IPAddress(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedNetworkInfo_IPAddress(r randyMesos, easy bool) *NetworkInfo_IPAddress {
	this := &NetworkInfo_IPAddress{}
	if r.Intn(10) != 0 {
		v233 := NetworkInfo_Protocol([]int32{1, 2}[r.Intn(2)])
		this.Protocol = &v233
	}
	if r.Intn(10) != 0 {
		v234 := randStringMesos(r)
		this.IpAddress = &v234
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedContainerInfo(r randyMesos, easy bool) *ContainerInfo {
	this := &ContainerInfo{}
	v235 := ContainerInfo_Type([]int32{1, 2}[r.Intn(2)])
	this.Type = &v235
	if r.Intn(10) != 0 {
		v236 := r.Intn(10)
		this.Volumes = make([]*Volume, v236)
		for i := 0; i < v236; i++ {
			this.Volumes[i] = NewPopulatedVolume(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		this.Docker = NewPopulatedContainerInfo_DockerInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v237 := randStringMesos(r)
		this.Hostname = &v237
	}
	if r.Intn(10) != 0 {
		this.Mesos = NewPopulatedContainerInfo_MesosInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v238 := r.Intn(10)
		this.NetworkInfos = make([]*NetworkInfo, v238)
		for i := 0; i < v238; i++ {
			this.NetworkInfos[i] = NewPopulatedNetworkInfo(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedContainerInfo_DockerInfo(r randyMesos, easy bool) *ContainerInfo_DockerInfo {
	this := &ContainerInfo_DockerInfo{}
	v239 := randStringMesos(r)
	this.Image = &v239
	if r.Intn(10) != 0 {
		v240 := ContainerInfo_DockerInfo_Network([]int32{1, 2, 3}[r.Intn(3)])
		this.Network = &v240
	}
	if r.Intn(10) != 0 {
		v241 := r.Intn(10)
		this.PortMappings = make([]*ContainerInfo_DockerInfo_PortMapping, v241)
		for i := 0; i < v241; i++ {
			this.PortMappings[i] = NewPopulatedContainerInfo_DockerInfo_PortMapping(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v242 := bool(bool(r.Intn(2) == 0))
		this.Privileged = &v242
	}
	if r.Intn(10) != 0 {
		v243 := r.Intn(10)
		this.Parameters = make([]*Parameter, v243)
		for i := 0; i < v243; i++ {
			this.Parameters[i] = NewPopulatedParameter(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v244 := bool(bool(r.Intn(2) == 0))
		this.ForcePullImage = &v244
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 7)
	}
	return this
}

func NewPopulatedContainerInfo_DockerInfo_PortMapping(r randyMesos, easy bool) *ContainerInfo_DockerInfo_PortMapping {
	this := &ContainerInfo_DockerInfo_PortMapping{}
	v245 := uint32(r.Uint32())
	this.HostPort = &v245
	v246 := uint32(r.Uint32())
	this.ContainerPort = &v246
	if r.Intn(10) != 0 {
		v247 := randStringMesos(r)
		this.Protocol = &v247
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 4)
	}
	return this
}

func NewPopulatedContainerInfo_MesosInfo(r randyMesos, easy bool) *ContainerInfo_MesosInfo {
	this := &ContainerInfo_MesosInfo{}
	if r.Intn(10) != 0 {
		this.Image = NewPopulatedImage(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedContainerStatus(r randyMesos, easy bool) *ContainerStatus {
	this := &ContainerStatus{}
	if r.Intn(10) != 0 {
		v248 := r.Intn(10)
		this.NetworkInfos = make([]*NetworkInfo, v248)
		for i := 0; i < v248; i++ {
			this.NetworkInfos[i] = NewPopulatedNetworkInfo(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedLabels(r randyMesos, easy bool) *Labels {
	this := &Labels{}
	if r.Intn(10) != 0 {
		v249 := r.Intn(10)
		this.Labels = make([]*Label, v249)
		for i := 0; i < v249; i++ {
			this.Labels[i] = NewPopulatedLabel(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedLabel(r randyMesos, easy bool) *Label {
	this := &Label{}
	v250 := randStringMesos(r)
	this.Key = &v250
	if r.Intn(10) != 0 {
		v251 := randStringMesos(r)
		this.Value = &v251
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedPort(r randyMesos, easy bool) *Port {
	this := &Port{}
	v252 := uint32(r.Uint32())
	this.Number = &v252
	if r.Intn(10) != 0 {
		v253 := randStringMesos(r)
		this.Name = &v253
	}
	if r.Intn(10) != 0 {
		v254 := randStringMesos(r)
		this.Protocol = &v254
	}
	if r.Intn(10) != 0 {
		v255 := DiscoveryInfo_Visibility([]int32{0, 1, 2}[r.Intn(3)])
		this.Visibility = &v255
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 5)
	}
	return this
}

func NewPopulatedPorts(r randyMesos, easy bool) *Ports {
	this := &Ports{}
	if r.Intn(10) != 0 {
		v256 := r.Intn(10)
		this.Ports = make([]*Port, v256)
		for i := 0; i < v256; i++ {
			this.Ports[i] = NewPopulatedPort(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 2)
	}
	return this
}

func NewPopulatedDiscoveryInfo(r randyMesos, easy bool) *DiscoveryInfo {
	this := &DiscoveryInfo{}
	v257 := DiscoveryInfo_Visibility([]int32{0, 1, 2}[r.Intn(3)])
	this.Visibility = &v257
	if r.Intn(10) != 0 {
		v258 := randStringMesos(r)
		this.Name = &v258
	}
	if r.Intn(10) != 0 {
		v259 := randStringMesos(r)
		this.Environment = &v259
	}
	if r.Intn(10) != 0 {
		v260 := randStringMesos(r)
		this.Location = &v260
	}
	if r.Intn(10) != 0 {
		v261 := randStringMesos(r)
		this.Version = &v261
	}
	if r.Intn(10) != 0 {
		this.Ports = NewPopulatedPorts(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Labels = NewPopulatedLabels(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 8)
	}
	return this
}

func NewPopulatedAppcImageManifest(r randyMesos, easy bool) *AppcImageManifest {
	this := &AppcImageManifest{}
	v262 := randStringMesos(r)
	this.AcKind = &v262
	v263 := randStringMesos(r)
	this.AcVersion = &v263
	v264 := randStringMesos(r)
	this.Name = &v264
	if r.Intn(10) != 0 {
		v265 := r.Intn(10)
		this.Labels = make([]*AppcImageManifest_Label, v265)
		for i := 0; i < v265; i++ {
			this.Labels[i] = NewPopulatedAppcImageManifest_Label(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v266 := r.Intn(10)
		this.Annotations = make([]*AppcImageManifest_Annotation, v266)
		for i := 0; i < v266; i++ {
			this.Annotations[i] = NewPopulatedAppcImageManifest_Annotation(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 6)
	}
	return this
}

func NewPopulatedAppcImageManifest_Label(r randyMesos, easy bool) *AppcImageManifest_Label {
	this := &AppcImageManifest_Label{}
	v267 := randStringMesos(r)
	this.Name = &v267
	v268 := randStringMesos(r)
	this.Value = &v268
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

func NewPopulatedAppcImageManifest_Annotation(r randyMesos, easy bool) *AppcImageManifest_Annotation {
	this := &AppcImageManifest_Annotation{}
	v269 := randStringMesos(r)
	this.Name = &v269
	v270 := randStringMesos(r)
	this.Value = &v270
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedMesos(r, 3)
	}
	return this
}

type randyMesos interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMesos(r randyMesos) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMesos(r randyMesos) string {
	v271 := r.Intn(100)
	tmps := make([]rune, v271)
	for i := 0; i < v271; i++ {
		tmps[i] = randUTF8RuneMesos(r)
	}
	return string(tmps)
}
func randUnrecognizedMesos(r randyMesos, maxFieldNumber int) (data []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		data = randFieldMesos(data, r, fieldNumber, wire)
	}
	return data
}
func randFieldMesos(data []byte, r randyMesos, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		data = encodeVarintPopulateMesos(data, uint64(key))
		v272 := r.Int63()
		if r.Intn(2) == 0 {
			v272 *= -1
		}
		data = encodeVarintPopulateMesos(data, uint64(v272))
	case 1:
		data = encodeVarintPopulateMesos(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		data = encodeVarintPopulateMesos(data, uint64(key))
		ll := r.Intn(100)
		data = encodeVarintPopulateMesos(data, uint64(ll))
		for j := 0; j < ll; j++ {
			data = append(data, byte(r.Intn(256)))
		}
	default:
		data = encodeVarintPopulateMesos(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return data
}
func encodeVarintPopulateMesos(data []byte, v uint64) []byte {
	for v >= 1<<7 {
		data = append(data, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	data = append(data, uint8(v))
	return data
}
func (m *FrameworkID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OfferID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SlaveID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecutorID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerID) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeInfo) Size() (n int) {
	var l int
	_ = l
	if m.Nanoseconds != nil {
		n += 1 + sovMesos(uint64(*m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DurationInfo) Size() (n int) {
	var l int
	_ = l
	if m.Nanoseconds != nil {
		n += 1 + sovMesos(uint64(*m.Nanoseconds))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Address) Size() (n int) {
	var l int
	_ = l
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ip != nil {
		l = len(*m.Ip)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *URL) Size() (n int) {
	var l int
	_ = l
	if m.Scheme != nil {
		l = len(*m.Scheme)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Query) > 0 {
		for _, e := range m.Query {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Fragment != nil {
		l = len(*m.Fragment)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Unavailability) Size() (n int) {
	var l int
	_ = l
	if m.Start != nil {
		l = m.Start.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Duration != nil {
		l = m.Duration.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MachineID) Size() (n int) {
	var l int
	_ = l
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ip != nil {
		l = len(*m.Ip)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MachineInfo) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovMesos(uint64(*m.Mode))
	}
	if m.Unavailability != nil {
		l = m.Unavailability.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FrameworkInfo) Size() (n int) {
	var l int
	_ = l
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FailoverTimeout != nil {
		n += 9
	}
	if m.Checkpoint != nil {
		n += 2
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.WebuiUrl != nil {
		l = len(*m.WebuiUrl)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Capabilities) > 0 {
		for _, e := range m.Capabilities {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FrameworkInfo_Capability) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck) Size() (n int) {
	var l int
	_ = l
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.DelaySeconds != nil {
		n += 9
	}
	if m.IntervalSeconds != nil {
		n += 9
	}
	if m.TimeoutSeconds != nil {
		n += 9
	}
	if m.ConsecutiveFailures != nil {
		n += 1 + sovMesos(uint64(*m.ConsecutiveFailures))
	}
	if m.GracePeriodSeconds != nil {
		n += 9
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HealthCheck_HTTP) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.Path != nil {
		l = len(*m.Path)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Statuses) > 0 {
		for _, e := range m.Statuses {
			n += 1 + sovMesos(uint64(e))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.Uris) > 0 {
		for _, e := range m.Uris {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Environment != nil {
		l = m.Environment.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Shell != nil {
		n += 2
	}
	if len(m.Arguments) > 0 {
		for _, s := range m.Arguments {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo_URI) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Executable != nil {
		n += 2
	}
	if m.Extract != nil {
		n += 2
	}
	if m.Cache != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommandInfo_ContainerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Options) > 0 {
		for _, s := range m.Options {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecutorInfo) Size() (n int) {
	var l int
	_ = l
	if m.ExecutorId != nil {
		l = m.ExecutorId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Source != nil {
		l = len(*m.Source)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Discovery != nil {
		l = m.Discovery.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterInfo) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ip != nil {
		n += 1 + sovMesos(uint64(*m.Ip))
	}
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.Pid != nil {
		l = len(*m.Pid)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SlaveInfo) Size() (n int) {
	var l int
	_ = l
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Checkpoint != nil {
		n += 2
	}
	if m.Port != nil {
		n += 1 + sovMesos(uint64(*m.Port))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Text != nil {
		l = m.Text.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Scalar) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Range) Size() (n int) {
	var l int
	_ = l
	if m.Begin != nil {
		n += 1 + sovMesos(uint64(*m.Begin))
	}
	if m.End != nil {
		n += 1 + sovMesos(uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Ranges) Size() (n int) {
	var l int
	_ = l
	if len(m.Range) > 0 {
		for _, e := range m.Range {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Set) Size() (n int) {
	var l int
	_ = l
	if len(m.Item) > 0 {
		for _, s := range m.Item {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Value_Text) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Attribute) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Text != nil {
		l = m.Text.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Scalar != nil {
		l = m.Scalar.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ranges != nil {
		l = m.Ranges.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Set != nil {
		l = m.Set.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Disk != nil {
		l = m.Disk.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Reservation != nil {
		l = m.Reservation.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Revocable != nil {
		l = m.Revocable.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource_ReservationInfo) Size() (n int) {
	var l int
	_ = l
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource_DiskInfo) Size() (n int) {
	var l int
	_ = l
	if m.Persistence != nil {
		l = m.Persistence.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Volume != nil {
		l = m.Volume.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource_DiskInfo_Persistence) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Resource_RevocableInfo) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TrafficControlStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Backlog != nil {
		n += 1 + sovMesos(uint64(*m.Backlog))
	}
	if m.Bytes != nil {
		n += 1 + sovMesos(uint64(*m.Bytes))
	}
	if m.Drops != nil {
		n += 1 + sovMesos(uint64(*m.Drops))
	}
	if m.Overlimits != nil {
		n += 1 + sovMesos(uint64(*m.Overlimits))
	}
	if m.Packets != nil {
		n += 1 + sovMesos(uint64(*m.Packets))
	}
	if m.Qlen != nil {
		n += 1 + sovMesos(uint64(*m.Qlen))
	}
	if m.Ratebps != nil {
		n += 1 + sovMesos(uint64(*m.Ratebps))
	}
	if m.Ratepps != nil {
		n += 1 + sovMesos(uint64(*m.Ratepps))
	}
	if m.Requeues != nil {
		n += 1 + sovMesos(uint64(*m.Requeues))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		n += 9
	}
	if m.CpusUserTimeSecs != nil {
		n += 9
	}
	if m.CpusSystemTimeSecs != nil {
		n += 9
	}
	if m.CpusLimit != nil {
		n += 9
	}
	if m.MemRssBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemRssBytes))
	}
	if m.MemLimitBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemLimitBytes))
	}
	if m.CpusNrPeriods != nil {
		n += 1 + sovMesos(uint64(*m.CpusNrPeriods))
	}
	if m.CpusNrThrottled != nil {
		n += 1 + sovMesos(uint64(*m.CpusNrThrottled))
	}
	if m.CpusThrottledTimeSecs != nil {
		n += 9
	}
	if m.MemFileBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemFileBytes))
	}
	if m.MemAnonBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemAnonBytes))
	}
	if m.MemMappedFileBytes != nil {
		n += 1 + sovMesos(uint64(*m.MemMappedFileBytes))
	}
	if m.Perf != nil {
		l = m.Perf.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.NetRxPackets != nil {
		n += 1 + sovMesos(uint64(*m.NetRxPackets))
	}
	if m.NetRxBytes != nil {
		n += 1 + sovMesos(uint64(*m.NetRxBytes))
	}
	if m.NetRxErrors != nil {
		n += 2 + sovMesos(uint64(*m.NetRxErrors))
	}
	if m.NetRxDropped != nil {
		n += 2 + sovMesos(uint64(*m.NetRxDropped))
	}
	if m.NetTxPackets != nil {
		n += 2 + sovMesos(uint64(*m.NetTxPackets))
	}
	if m.NetTxBytes != nil {
		n += 2 + sovMesos(uint64(*m.NetTxBytes))
	}
	if m.NetTxErrors != nil {
		n += 2 + sovMesos(uint64(*m.NetTxErrors))
	}
	if m.NetTxDropped != nil {
		n += 2 + sovMesos(uint64(*m.NetTxDropped))
	}
	if m.NetTcpRttMicrosecsP50 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP90 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP95 != nil {
		n += 10
	}
	if m.NetTcpRttMicrosecsP99 != nil {
		n += 10
	}
	if m.DiskLimitBytes != nil {
		n += 2 + sovMesos(uint64(*m.DiskLimitBytes))
	}
	if m.DiskUsedBytes != nil {
		n += 2 + sovMesos(uint64(*m.DiskUsedBytes))
	}
	if m.NetTcpActiveConnections != nil {
		n += 10
	}
	if m.NetTcpTimeWaitConnections != nil {
		n += 10
	}
	if m.Processes != nil {
		n += 2 + sovMesos(uint64(*m.Processes))
	}
	if m.Threads != nil {
		n += 2 + sovMesos(uint64(*m.Threads))
	}
	if m.MemLowPressureCounter != nil {
		n += 2 + sovMesos(uint64(*m.MemLowPressureCounter))
	}
	if m.MemMediumPressureCounter != nil {
		n += 2 + sovMesos(uint64(*m.MemMediumPressureCounter))
	}
	if m.MemCriticalPressureCounter != nil {
		n += 2 + sovMesos(uint64(*m.MemCriticalPressureCounter))
	}
	if len(m.NetTrafficControlStatistics) > 0 {
		for _, e := range m.NetTrafficControlStatistics {
			l = e.Size()
			n += 2 + l + sovMesos(uint64(l))
		}
	}
	if m.MemTotalBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemTotalBytes))
	}
	if m.MemTotalMemswBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemTotalMemswBytes))
	}
	if m.MemSoftLimitBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemSoftLimitBytes))
	}
	if m.MemCacheBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemCacheBytes))
	}
	if m.MemSwapBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemSwapBytes))
	}
	if m.MemUnevictableBytes != nil {
		n += 2 + sovMesos(uint64(*m.MemUnevictableBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceUsage) Size() (n int) {
	var l int
	_ = l
	if len(m.Executors) > 0 {
		for _, e := range m.Executors {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Total) > 0 {
		for _, e := range m.Total {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResourceUsage_Executor) Size() (n int) {
	var l int
	_ = l
	if m.ExecutorInfo != nil {
		l = m.ExecutorInfo.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Allocated) > 0 {
		for _, e := range m.Allocated {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Statistics != nil {
		l = m.Statistics.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PerfStatistics) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		n += 9
	}
	if m.Duration != nil {
		n += 9
	}
	if m.Cycles != nil {
		n += 1 + sovMesos(uint64(*m.Cycles))
	}
	if m.StalledCyclesFrontend != nil {
		n += 1 + sovMesos(uint64(*m.StalledCyclesFrontend))
	}
	if m.StalledCyclesBackend != nil {
		n += 1 + sovMesos(uint64(*m.StalledCyclesBackend))
	}
	if m.Instructions != nil {
		n += 1 + sovMesos(uint64(*m.Instructions))
	}
	if m.CacheReferences != nil {
		n += 1 + sovMesos(uint64(*m.CacheReferences))
	}
	if m.CacheMisses != nil {
		n += 1 + sovMesos(uint64(*m.CacheMisses))
	}
	if m.Branches != nil {
		n += 1 + sovMesos(uint64(*m.Branches))
	}
	if m.BranchMisses != nil {
		n += 1 + sovMesos(uint64(*m.BranchMisses))
	}
	if m.BusCycles != nil {
		n += 1 + sovMesos(uint64(*m.BusCycles))
	}
	if m.RefCycles != nil {
		n += 1 + sovMesos(uint64(*m.RefCycles))
	}
	if m.CpuClock != nil {
		n += 9
	}
	if m.TaskClock != nil {
		n += 9
	}
	if m.PageFaults != nil {
		n += 1 + sovMesos(uint64(*m.PageFaults))
	}
	if m.MinorFaults != nil {
		n += 2 + sovMesos(uint64(*m.MinorFaults))
	}
	if m.MajorFaults != nil {
		n += 2 + sovMesos(uint64(*m.MajorFaults))
	}
	if m.ContextSwitches != nil {
		n += 2 + sovMesos(uint64(*m.ContextSwitches))
	}
	if m.CpuMigrations != nil {
		n += 2 + sovMesos(uint64(*m.CpuMigrations))
	}
	if m.AlignmentFaults != nil {
		n += 2 + sovMesos(uint64(*m.AlignmentFaults))
	}
	if m.EmulationFaults != nil {
		n += 2 + sovMesos(uint64(*m.EmulationFaults))
	}
	if m.L1DcacheLoads != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheLoads))
	}
	if m.L1DcacheLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheLoadMisses))
	}
	if m.L1DcacheStores != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheStores))
	}
	if m.L1DcacheStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcacheStoreMisses))
	}
	if m.L1DcachePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.L1DcachePrefetches))
	}
	if m.L1DcachePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1DcachePrefetchMisses))
	}
	if m.L1IcacheLoads != nil {
		n += 2 + sovMesos(uint64(*m.L1IcacheLoads))
	}
	if m.L1IcacheLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1IcacheLoadMisses))
	}
	if m.L1IcachePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.L1IcachePrefetches))
	}
	if m.L1IcachePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.L1IcachePrefetchMisses))
	}
	if m.LlcLoads != nil {
		n += 2 + sovMesos(uint64(*m.LlcLoads))
	}
	if m.LlcLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcLoadMisses))
	}
	if m.LlcStores != nil {
		n += 2 + sovMesos(uint64(*m.LlcStores))
	}
	if m.LlcStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcStoreMisses))
	}
	if m.LlcPrefetches != nil {
		n += 2 + sovMesos(uint64(*m.LlcPrefetches))
	}
	if m.LlcPrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.LlcPrefetchMisses))
	}
	if m.DtlbLoads != nil {
		n += 2 + sovMesos(uint64(*m.DtlbLoads))
	}
	if m.DtlbLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbLoadMisses))
	}
	if m.DtlbStores != nil {
		n += 2 + sovMesos(uint64(*m.DtlbStores))
	}
	if m.DtlbStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbStoreMisses))
	}
	if m.DtlbPrefetches != nil {
		n += 2 + sovMesos(uint64(*m.DtlbPrefetches))
	}
	if m.DtlbPrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.DtlbPrefetchMisses))
	}
	if m.ItlbLoads != nil {
		n += 2 + sovMesos(uint64(*m.ItlbLoads))
	}
	if m.ItlbLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.ItlbLoadMisses))
	}
	if m.BranchLoads != nil {
		n += 2 + sovMesos(uint64(*m.BranchLoads))
	}
	if m.BranchLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.BranchLoadMisses))
	}
	if m.NodeLoads != nil {
		n += 2 + sovMesos(uint64(*m.NodeLoads))
	}
	if m.NodeLoadMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodeLoadMisses))
	}
	if m.NodeStores != nil {
		n += 2 + sovMesos(uint64(*m.NodeStores))
	}
	if m.NodeStoreMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodeStoreMisses))
	}
	if m.NodePrefetches != nil {
		n += 2 + sovMesos(uint64(*m.NodePrefetches))
	}
	if m.NodePrefetchMisses != nil {
		n += 2 + sovMesos(uint64(*m.NodePrefetchMisses))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Request) Size() (n int) {
	var l int
	_ = l
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.ExecutorIds) > 0 {
		for _, e := range m.ExecutorIds {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Url != nil {
		l = m.Url.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Unavailability != nil {
		l = m.Unavailability.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Launch != nil {
		l = m.Launch.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Reserve != nil {
		l = m.Reserve.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Unreserve != nil {
		l = m.Unreserve.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Create != nil {
		l = m.Create.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Destroy != nil {
		l = m.Destroy.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation_Launch) Size() (n int) {
	var l int
	_ = l
	if len(m.TaskInfos) > 0 {
		for _, e := range m.TaskInfos {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation_Reserve) Size() (n int) {
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation_Unreserve) Size() (n int) {
	var l int
	_ = l
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation_Create) Size() (n int) {
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Offer_Operation_Destroy) Size() (n int) {
	var l int
	_ = l
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InverseOffer) Size() (n int) {
	var l int
	_ = l
	if m.Id != nil {
		l = m.Id.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Url != nil {
		l = m.Url.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.FrameworkId != nil {
		l = m.FrameworkId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Unavailability != nil {
		l = m.Unavailability.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskInfo) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.TaskId != nil {
		l = m.TaskId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Executor != nil {
		l = m.Executor.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.HealthCheck != nil {
		l = m.HealthCheck.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Container != nil {
		l = m.Container.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Discovery != nil {
		l = m.Discovery.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TaskStatus) Size() (n int) {
	var l int
	_ = l
	if m.TaskId != nil {
		l = m.TaskId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.State != nil {
		n += 1 + sovMesos(uint64(*m.State))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Timestamp != nil {
		n += 9
	}
	if m.ExecutorId != nil {
		l = m.ExecutorId.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Healthy != nil {
		n += 2
	}
	if m.Source != nil {
		n += 1 + sovMesos(uint64(*m.Source))
	}
	if m.Reason != nil {
		n += 1 + sovMesos(uint64(*m.Reason))
	}
	if m.Uuid != nil {
		l = len(m.Uuid)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.ContainerStatus != nil {
		l = m.ContainerStatus.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Filters) Size() (n int) {
	var l int
	_ = l
	if m.RefuseSeconds != nil {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Environment) Size() (n int) {
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for _, e := range m.Variables {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Environment_Variable) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Parameter) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Parameters) Size() (n int) {
	var l int
	_ = l
	if len(m.Parameter) > 0 {
		for _, e := range m.Parameter {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Credential) Size() (n int) {
	var l int
	_ = l
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Secret != nil {
		l = len(*m.Secret)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Credentials) Size() (n int) {
	var l int
	_ = l
	if len(m.Credentials) > 0 {
		for _, e := range m.Credentials {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimit) Size() (n int) {
	var l int
	_ = l
	if m.Qps != nil {
		n += 9
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Capacity != nil {
		n += 1 + sovMesos(uint64(*m.Capacity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RateLimits) Size() (n int) {
	var l int
	_ = l
	if len(m.Limits) > 0 {
		for _, e := range m.Limits {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.AggregateDefaultQps != nil {
		n += 9
	}
	if m.AggregateDefaultCapacity != nil {
		n += 1 + sovMesos(uint64(*m.AggregateDefaultCapacity))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Image) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if m.Appc != nil {
		l = m.Appc.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Docker != nil {
		l = m.Docker.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Image_Appc) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Id != nil {
		l = len(*m.Id)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Image_Docker) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Volume) Size() (n int) {
	var l int
	_ = l
	if m.ContainerPath != nil {
		l = len(*m.ContainerPath)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.HostPath != nil {
		l = len(*m.HostPath)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Mode != nil {
		n += 1 + sovMesos(uint64(*m.Mode))
	}
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkInfo) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != nil {
		n += 1 + sovMesos(uint64(*m.Protocol))
	}
	if m.IpAddress != nil {
		l = len(*m.IpAddress)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Groups) > 0 {
		for _, s := range m.Groups {
			l = len(s)
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.IpAddresses) > 0 {
		for _, e := range m.IpAddresses {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkInfo_IPAddress) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != nil {
		n += 1 + sovMesos(uint64(*m.Protocol))
	}
	if m.IpAddress != nil {
		l = len(*m.IpAddress)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovMesos(uint64(*m.Type))
	}
	if len(m.Volumes) > 0 {
		for _, e := range m.Volumes {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Docker != nil {
		l = m.Docker.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Hostname != nil {
		l = len(*m.Hostname)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Mesos != nil {
		l = m.Mesos.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.NetworkInfos) > 0 {
		for _, e := range m.NetworkInfos {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo_DockerInfo) Size() (n int) {
	var l int
	_ = l
	if m.Image != nil {
		l = len(*m.Image)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Network != nil {
		n += 1 + sovMesos(uint64(*m.Network))
	}
	if len(m.PortMappings) > 0 {
		for _, e := range m.PortMappings {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.Privileged != nil {
		n += 2
	}
	if len(m.Parameters) > 0 {
		for _, e := range m.Parameters {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.ForcePullImage != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo_DockerInfo_PortMapping) Size() (n int) {
	var l int
	_ = l
	if m.HostPort != nil {
		n += 1 + sovMesos(uint64(*m.HostPort))
	}
	if m.ContainerPort != nil {
		n += 1 + sovMesos(uint64(*m.ContainerPort))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerInfo_MesosInfo) Size() (n int) {
	var l int
	_ = l
	if m.Image != nil {
		l = m.Image.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ContainerStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.NetworkInfos) > 0 {
		for _, e := range m.NetworkInfos {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Labels) Size() (n int) {
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Label) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(*m.Key)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Port) Size() (n int) {
	var l int
	_ = l
	if m.Number != nil {
		n += 1 + sovMesos(uint64(*m.Number))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Protocol != nil {
		l = len(*m.Protocol)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Visibility != nil {
		n += 1 + sovMesos(uint64(*m.Visibility))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Ports) Size() (n int) {
	var l int
	_ = l
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DiscoveryInfo) Size() (n int) {
	var l int
	_ = l
	if m.Visibility != nil {
		n += 1 + sovMesos(uint64(*m.Visibility))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Environment != nil {
		l = len(*m.Environment)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Location != nil {
		l = len(*m.Location)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Version != nil {
		l = len(*m.Version)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Ports != nil {
		l = m.Ports.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Labels != nil {
		l = m.Labels.Size()
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppcImageManifest) Size() (n int) {
	var l int
	_ = l
	if m.AcKind != nil {
		l = len(*m.AcKind)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.AcVersion != nil {
		l = len(*m.AcVersion)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if len(m.Annotations) > 0 {
		for _, e := range m.Annotations {
			l = e.Size()
			n += 1 + l + sovMesos(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppcImageManifest_Label) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AppcImageManifest_Annotation) Size() (n int) {
	var l int
	_ = l
	if m.Name != nil {
		l = len(*m.Name)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.Value != nil {
		l = len(*m.Value)
		n += 1 + l + sovMesos(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMesos(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMesos(x uint64) (n int) {
	return sovMesos(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *FrameworkID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrameworkID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OfferID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OfferID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SlaveID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SlaveID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecutorID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutorID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerID{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TimeInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TimeInfo{`,
		`Nanoseconds:` + valueToStringMesos(this.Nanoseconds) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DurationInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DurationInfo{`,
		`Nanoseconds:` + valueToStringMesos(this.Nanoseconds) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Address) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Address{`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Ip:` + valueToStringMesos(this.Ip) + `,`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *URL) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&URL{`,
		`Scheme:` + valueToStringMesos(this.Scheme) + `,`,
		`Address:` + strings.Replace(fmt.Sprintf("%v", this.Address), "Address", "Address", 1) + `,`,
		`Path:` + valueToStringMesos(this.Path) + `,`,
		`Query:` + strings.Replace(fmt.Sprintf("%v", this.Query), "Parameter", "Parameter", 1) + `,`,
		`Fragment:` + valueToStringMesos(this.Fragment) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Unavailability) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Unavailability{`,
		`Start:` + strings.Replace(fmt.Sprintf("%v", this.Start), "TimeInfo", "TimeInfo", 1) + `,`,
		`Duration:` + strings.Replace(fmt.Sprintf("%v", this.Duration), "DurationInfo", "DurationInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MachineID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MachineID{`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Ip:` + valueToStringMesos(this.Ip) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MachineInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MachineInfo{`,
		`Id:` + strings.Replace(fmt.Sprintf("%v", this.Id), "MachineID", "MachineID", 1) + `,`,
		`Mode:` + valueToStringMesos(this.Mode) + `,`,
		`Unavailability:` + strings.Replace(fmt.Sprintf("%v", this.Unavailability), "Unavailability", "Unavailability", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FrameworkInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrameworkInfo{`,
		`User:` + valueToStringMesos(this.User) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Id:` + strings.Replace(fmt.Sprintf("%v", this.Id), "FrameworkID", "FrameworkID", 1) + `,`,
		`FailoverTimeout:` + valueToStringMesos(this.FailoverTimeout) + `,`,
		`Checkpoint:` + valueToStringMesos(this.Checkpoint) + `,`,
		`Role:` + valueToStringMesos(this.Role) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`WebuiUrl:` + valueToStringMesos(this.WebuiUrl) + `,`,
		`Capabilities:` + strings.Replace(fmt.Sprintf("%v", this.Capabilities), "FrameworkInfo_Capability", "FrameworkInfo_Capability", 1) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FrameworkInfo_Capability) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FrameworkInfo_Capability{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HealthCheck) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HealthCheck{`,
		`Http:` + strings.Replace(fmt.Sprintf("%v", this.Http), "HealthCheck_HTTP", "HealthCheck_HTTP", 1) + `,`,
		`DelaySeconds:` + valueToStringMesos(this.DelaySeconds) + `,`,
		`IntervalSeconds:` + valueToStringMesos(this.IntervalSeconds) + `,`,
		`TimeoutSeconds:` + valueToStringMesos(this.TimeoutSeconds) + `,`,
		`ConsecutiveFailures:` + valueToStringMesos(this.ConsecutiveFailures) + `,`,
		`GracePeriodSeconds:` + valueToStringMesos(this.GracePeriodSeconds) + `,`,
		`Command:` + strings.Replace(fmt.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HealthCheck_HTTP) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HealthCheck_HTTP{`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`Path:` + valueToStringMesos(this.Path) + `,`,
		`Statuses:` + fmt.Sprintf("%v", this.Statuses) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo{`,
		`Uris:` + strings.Replace(fmt.Sprintf("%v", this.Uris), "CommandInfo_URI", "CommandInfo_URI", 1) + `,`,
		`Environment:` + strings.Replace(fmt.Sprintf("%v", this.Environment), "Environment", "Environment", 1) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "CommandInfo_ContainerInfo", "CommandInfo_ContainerInfo", 1) + `,`,
		`User:` + valueToStringMesos(this.User) + `,`,
		`Shell:` + valueToStringMesos(this.Shell) + `,`,
		`Arguments:` + fmt.Sprintf("%v", this.Arguments) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo_URI) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo_URI{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`Executable:` + valueToStringMesos(this.Executable) + `,`,
		`Extract:` + valueToStringMesos(this.Extract) + `,`,
		`Cache:` + valueToStringMesos(this.Cache) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CommandInfo_ContainerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CommandInfo_ContainerInfo{`,
		`Image:` + valueToStringMesos(this.Image) + `,`,
		`Options:` + fmt.Sprintf("%v", this.Options) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ExecutorInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ExecutorInfo{`,
		`ExecutorId:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorId), "ExecutorID", "ExecutorID", 1) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Command:` + strings.Replace(fmt.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Source:` + valueToStringMesos(this.Source) + `,`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerInfo", "ContainerInfo", 1) + `,`,
		`Discovery:` + strings.Replace(fmt.Sprintf("%v", this.Discovery), "DiscoveryInfo", "DiscoveryInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *MasterInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&MasterInfo{`,
		`Id:` + valueToStringMesos(this.Id) + `,`,
		`Ip:` + valueToStringMesos(this.Ip) + `,`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`Pid:` + valueToStringMesos(this.Pid) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Version:` + valueToStringMesos(this.Version) + `,`,
		`Address:` + strings.Replace(fmt.Sprintf("%v", this.Address), "Address", "Address", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SlaveInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SlaveInfo{`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Attributes:` + strings.Replace(fmt.Sprintf("%v", this.Attributes), "Attribute", "Attribute", 1) + `,`,
		`Id:` + strings.Replace(fmt.Sprintf("%v", this.Id), "SlaveID", "SlaveID", 1) + `,`,
		`Checkpoint:` + valueToStringMesos(this.Checkpoint) + `,`,
		`Port:` + valueToStringMesos(this.Port) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Set:` + strings.Replace(fmt.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`Text:` + strings.Replace(fmt.Sprintf("%v", this.Text), "Value_Text", "Value_Text", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Scalar) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Scalar{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Range) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Range{`,
		`Begin:` + valueToStringMesos(this.Begin) + `,`,
		`End:` + valueToStringMesos(this.End) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Ranges) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Ranges{`,
		`Range:` + strings.Replace(fmt.Sprintf("%v", this.Range), "Value_Range", "Value_Range", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Set) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Set{`,
		`Item:` + fmt.Sprintf("%v", this.Item) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Value_Text) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Value_Text{`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attribute) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attribute{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Text:` + strings.Replace(fmt.Sprintf("%v", this.Text), "Value_Text", "Value_Text", 1) + `,`,
		`Set:` + strings.Replace(fmt.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Scalar:` + strings.Replace(fmt.Sprintf("%v", this.Scalar), "Value_Scalar", "Value_Scalar", 1) + `,`,
		`Ranges:` + strings.Replace(fmt.Sprintf("%v", this.Ranges), "Value_Ranges", "Value_Ranges", 1) + `,`,
		`Set:` + strings.Replace(fmt.Sprintf("%v", this.Set), "Value_Set", "Value_Set", 1) + `,`,
		`Role:` + valueToStringMesos(this.Role) + `,`,
		`Disk:` + strings.Replace(fmt.Sprintf("%v", this.Disk), "Resource_DiskInfo", "Resource_DiskInfo", 1) + `,`,
		`Reservation:` + strings.Replace(fmt.Sprintf("%v", this.Reservation), "Resource_ReservationInfo", "Resource_ReservationInfo", 1) + `,`,
		`Revocable:` + strings.Replace(fmt.Sprintf("%v", this.Revocable), "Resource_RevocableInfo", "Resource_RevocableInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource_ReservationInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource_ReservationInfo{`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource_DiskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource_DiskInfo{`,
		`Persistence:` + strings.Replace(fmt.Sprintf("%v", this.Persistence), "Resource_DiskInfo_Persistence", "Resource_DiskInfo_Persistence", 1) + `,`,
		`Volume:` + strings.Replace(fmt.Sprintf("%v", this.Volume), "Volume", "Volume", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource_DiskInfo_Persistence) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource_DiskInfo_Persistence{`,
		`Id:` + valueToStringMesos(this.Id) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Resource_RevocableInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Resource_RevocableInfo{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TrafficControlStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TrafficControlStatistics{`,
		`Id:` + valueToStringMesos(this.Id) + `,`,
		`Backlog:` + valueToStringMesos(this.Backlog) + `,`,
		`Bytes:` + valueToStringMesos(this.Bytes) + `,`,
		`Drops:` + valueToStringMesos(this.Drops) + `,`,
		`Overlimits:` + valueToStringMesos(this.Overlimits) + `,`,
		`Packets:` + valueToStringMesos(this.Packets) + `,`,
		`Qlen:` + valueToStringMesos(this.Qlen) + `,`,
		`Ratebps:` + valueToStringMesos(this.Ratebps) + `,`,
		`Ratepps:` + valueToStringMesos(this.Ratepps) + `,`,
		`Requeues:` + valueToStringMesos(this.Requeues) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceStatistics{`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`CpusUserTimeSecs:` + valueToStringMesos(this.CpusUserTimeSecs) + `,`,
		`CpusSystemTimeSecs:` + valueToStringMesos(this.CpusSystemTimeSecs) + `,`,
		`CpusLimit:` + valueToStringMesos(this.CpusLimit) + `,`,
		`MemRssBytes:` + valueToStringMesos(this.MemRssBytes) + `,`,
		`MemLimitBytes:` + valueToStringMesos(this.MemLimitBytes) + `,`,
		`CpusNrPeriods:` + valueToStringMesos(this.CpusNrPeriods) + `,`,
		`CpusNrThrottled:` + valueToStringMesos(this.CpusNrThrottled) + `,`,
		`CpusThrottledTimeSecs:` + valueToStringMesos(this.CpusThrottledTimeSecs) + `,`,
		`MemFileBytes:` + valueToStringMesos(this.MemFileBytes) + `,`,
		`MemAnonBytes:` + valueToStringMesos(this.MemAnonBytes) + `,`,
		`MemMappedFileBytes:` + valueToStringMesos(this.MemMappedFileBytes) + `,`,
		`Perf:` + strings.Replace(fmt.Sprintf("%v", this.Perf), "PerfStatistics", "PerfStatistics", 1) + `,`,
		`NetRxPackets:` + valueToStringMesos(this.NetRxPackets) + `,`,
		`NetRxBytes:` + valueToStringMesos(this.NetRxBytes) + `,`,
		`NetRxErrors:` + valueToStringMesos(this.NetRxErrors) + `,`,
		`NetRxDropped:` + valueToStringMesos(this.NetRxDropped) + `,`,
		`NetTxPackets:` + valueToStringMesos(this.NetTxPackets) + `,`,
		`NetTxBytes:` + valueToStringMesos(this.NetTxBytes) + `,`,
		`NetTxErrors:` + valueToStringMesos(this.NetTxErrors) + `,`,
		`NetTxDropped:` + valueToStringMesos(this.NetTxDropped) + `,`,
		`NetTcpRttMicrosecsP50:` + valueToStringMesos(this.NetTcpRttMicrosecsP50) + `,`,
		`NetTcpRttMicrosecsP90:` + valueToStringMesos(this.NetTcpRttMicrosecsP90) + `,`,
		`NetTcpRttMicrosecsP95:` + valueToStringMesos(this.NetTcpRttMicrosecsP95) + `,`,
		`NetTcpRttMicrosecsP99:` + valueToStringMesos(this.NetTcpRttMicrosecsP99) + `,`,
		`DiskLimitBytes:` + valueToStringMesos(this.DiskLimitBytes) + `,`,
		`DiskUsedBytes:` + valueToStringMesos(this.DiskUsedBytes) + `,`,
		`NetTcpActiveConnections:` + valueToStringMesos(this.NetTcpActiveConnections) + `,`,
		`NetTcpTimeWaitConnections:` + valueToStringMesos(this.NetTcpTimeWaitConnections) + `,`,
		`Processes:` + valueToStringMesos(this.Processes) + `,`,
		`Threads:` + valueToStringMesos(this.Threads) + `,`,
		`MemLowPressureCounter:` + valueToStringMesos(this.MemLowPressureCounter) + `,`,
		`MemMediumPressureCounter:` + valueToStringMesos(this.MemMediumPressureCounter) + `,`,
		`MemCriticalPressureCounter:` + valueToStringMesos(this.MemCriticalPressureCounter) + `,`,
		`NetTrafficControlStatistics:` + strings.Replace(fmt.Sprintf("%v", this.NetTrafficControlStatistics), "TrafficControlStatistics", "TrafficControlStatistics", 1) + `,`,
		`MemTotalBytes:` + valueToStringMesos(this.MemTotalBytes) + `,`,
		`MemTotalMemswBytes:` + valueToStringMesos(this.MemTotalMemswBytes) + `,`,
		`MemSoftLimitBytes:` + valueToStringMesos(this.MemSoftLimitBytes) + `,`,
		`MemCacheBytes:` + valueToStringMesos(this.MemCacheBytes) + `,`,
		`MemSwapBytes:` + valueToStringMesos(this.MemSwapBytes) + `,`,
		`MemUnevictableBytes:` + valueToStringMesos(this.MemUnevictableBytes) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceUsage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceUsage{`,
		`Executors:` + strings.Replace(fmt.Sprintf("%v", this.Executors), "ResourceUsage_Executor", "ResourceUsage_Executor", 1) + `,`,
		`Total:` + strings.Replace(fmt.Sprintf("%v", this.Total), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResourceUsage_Executor) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResourceUsage_Executor{`,
		`ExecutorInfo:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorInfo), "ExecutorInfo", "ExecutorInfo", 1) + `,`,
		`Allocated:` + strings.Replace(fmt.Sprintf("%v", this.Allocated), "Resource", "Resource", 1) + `,`,
		`Statistics:` + strings.Replace(fmt.Sprintf("%v", this.Statistics), "ResourceStatistics", "ResourceStatistics", 1) + `,`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PerfStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PerfStatistics{`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`Duration:` + valueToStringMesos(this.Duration) + `,`,
		`Cycles:` + valueToStringMesos(this.Cycles) + `,`,
		`StalledCyclesFrontend:` + valueToStringMesos(this.StalledCyclesFrontend) + `,`,
		`StalledCyclesBackend:` + valueToStringMesos(this.StalledCyclesBackend) + `,`,
		`Instructions:` + valueToStringMesos(this.Instructions) + `,`,
		`CacheReferences:` + valueToStringMesos(this.CacheReferences) + `,`,
		`CacheMisses:` + valueToStringMesos(this.CacheMisses) + `,`,
		`Branches:` + valueToStringMesos(this.Branches) + `,`,
		`BranchMisses:` + valueToStringMesos(this.BranchMisses) + `,`,
		`BusCycles:` + valueToStringMesos(this.BusCycles) + `,`,
		`RefCycles:` + valueToStringMesos(this.RefCycles) + `,`,
		`CpuClock:` + valueToStringMesos(this.CpuClock) + `,`,
		`TaskClock:` + valueToStringMesos(this.TaskClock) + `,`,
		`PageFaults:` + valueToStringMesos(this.PageFaults) + `,`,
		`MinorFaults:` + valueToStringMesos(this.MinorFaults) + `,`,
		`MajorFaults:` + valueToStringMesos(this.MajorFaults) + `,`,
		`ContextSwitches:` + valueToStringMesos(this.ContextSwitches) + `,`,
		`CpuMigrations:` + valueToStringMesos(this.CpuMigrations) + `,`,
		`AlignmentFaults:` + valueToStringMesos(this.AlignmentFaults) + `,`,
		`EmulationFaults:` + valueToStringMesos(this.EmulationFaults) + `,`,
		`L1DcacheLoads:` + valueToStringMesos(this.L1DcacheLoads) + `,`,
		`L1DcacheLoadMisses:` + valueToStringMesos(this.L1DcacheLoadMisses) + `,`,
		`L1DcacheStores:` + valueToStringMesos(this.L1DcacheStores) + `,`,
		`L1DcacheStoreMisses:` + valueToStringMesos(this.L1DcacheStoreMisses) + `,`,
		`L1DcachePrefetches:` + valueToStringMesos(this.L1DcachePrefetches) + `,`,
		`L1DcachePrefetchMisses:` + valueToStringMesos(this.L1DcachePrefetchMisses) + `,`,
		`L1IcacheLoads:` + valueToStringMesos(this.L1IcacheLoads) + `,`,
		`L1IcacheLoadMisses:` + valueToStringMesos(this.L1IcacheLoadMisses) + `,`,
		`L1IcachePrefetches:` + valueToStringMesos(this.L1IcachePrefetches) + `,`,
		`L1IcachePrefetchMisses:` + valueToStringMesos(this.L1IcachePrefetchMisses) + `,`,
		`LlcLoads:` + valueToStringMesos(this.LlcLoads) + `,`,
		`LlcLoadMisses:` + valueToStringMesos(this.LlcLoadMisses) + `,`,
		`LlcStores:` + valueToStringMesos(this.LlcStores) + `,`,
		`LlcStoreMisses:` + valueToStringMesos(this.LlcStoreMisses) + `,`,
		`LlcPrefetches:` + valueToStringMesos(this.LlcPrefetches) + `,`,
		`LlcPrefetchMisses:` + valueToStringMesos(this.LlcPrefetchMisses) + `,`,
		`DtlbLoads:` + valueToStringMesos(this.DtlbLoads) + `,`,
		`DtlbLoadMisses:` + valueToStringMesos(this.DtlbLoadMisses) + `,`,
		`DtlbStores:` + valueToStringMesos(this.DtlbStores) + `,`,
		`DtlbStoreMisses:` + valueToStringMesos(this.DtlbStoreMisses) + `,`,
		`DtlbPrefetches:` + valueToStringMesos(this.DtlbPrefetches) + `,`,
		`DtlbPrefetchMisses:` + valueToStringMesos(this.DtlbPrefetchMisses) + `,`,
		`ItlbLoads:` + valueToStringMesos(this.ItlbLoads) + `,`,
		`ItlbLoadMisses:` + valueToStringMesos(this.ItlbLoadMisses) + `,`,
		`BranchLoads:` + valueToStringMesos(this.BranchLoads) + `,`,
		`BranchLoadMisses:` + valueToStringMesos(this.BranchLoadMisses) + `,`,
		`NodeLoads:` + valueToStringMesos(this.NodeLoads) + `,`,
		`NodeLoadMisses:` + valueToStringMesos(this.NodeLoadMisses) + `,`,
		`NodeStores:` + valueToStringMesos(this.NodeStores) + `,`,
		`NodeStoreMisses:` + valueToStringMesos(this.NodeStoreMisses) + `,`,
		`NodePrefetches:` + valueToStringMesos(this.NodePrefetches) + `,`,
		`NodePrefetchMisses:` + valueToStringMesos(this.NodePrefetchMisses) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Request) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Request{`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer{`,
		`Id:` + strings.Replace(fmt.Sprintf("%v", this.Id), "OfferID", "OfferID", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`ExecutorIds:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorIds), "ExecutorID", "ExecutorID", 1) + `,`,
		`Attributes:` + strings.Replace(fmt.Sprintf("%v", this.Attributes), "Attribute", "Attribute", 1) + `,`,
		`Url:` + strings.Replace(fmt.Sprintf("%v", this.Url), "URL", "URL", 1) + `,`,
		`Unavailability:` + strings.Replace(fmt.Sprintf("%v", this.Unavailability), "Unavailability", "Unavailability", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Launch:` + strings.Replace(fmt.Sprintf("%v", this.Launch), "Offer_Operation_Launch", "Offer_Operation_Launch", 1) + `,`,
		`Reserve:` + strings.Replace(fmt.Sprintf("%v", this.Reserve), "Offer_Operation_Reserve", "Offer_Operation_Reserve", 1) + `,`,
		`Unreserve:` + strings.Replace(fmt.Sprintf("%v", this.Unreserve), "Offer_Operation_Unreserve", "Offer_Operation_Unreserve", 1) + `,`,
		`Create:` + strings.Replace(fmt.Sprintf("%v", this.Create), "Offer_Operation_Create", "Offer_Operation_Create", 1) + `,`,
		`Destroy:` + strings.Replace(fmt.Sprintf("%v", this.Destroy), "Offer_Operation_Destroy", "Offer_Operation_Destroy", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation_Launch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation_Launch{`,
		`TaskInfos:` + strings.Replace(fmt.Sprintf("%v", this.TaskInfos), "TaskInfo", "TaskInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation_Reserve) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation_Reserve{`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation_Unreserve) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation_Unreserve{`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation_Create) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation_Create{`,
		`Volumes:` + strings.Replace(fmt.Sprintf("%v", this.Volumes), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Offer_Operation_Destroy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Offer_Operation_Destroy{`,
		`Volumes:` + strings.Replace(fmt.Sprintf("%v", this.Volumes), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InverseOffer) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InverseOffer{`,
		`Id:` + strings.Replace(fmt.Sprintf("%v", this.Id), "OfferID", "OfferID", 1) + `,`,
		`Url:` + strings.Replace(fmt.Sprintf("%v", this.Url), "URL", "URL", 1) + `,`,
		`FrameworkId:` + strings.Replace(fmt.Sprintf("%v", this.FrameworkId), "FrameworkID", "FrameworkID", 1) + `,`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Unavailability:` + strings.Replace(fmt.Sprintf("%v", this.Unavailability), "Unavailability", "Unavailability", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskInfo{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`TaskId:` + strings.Replace(fmt.Sprintf("%v", this.TaskId), "TaskID", "TaskID", 1) + `,`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`Executor:` + strings.Replace(fmt.Sprintf("%v", this.Executor), "ExecutorInfo", "ExecutorInfo", 1) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`Command:` + strings.Replace(fmt.Sprintf("%v", this.Command), "CommandInfo", "CommandInfo", 1) + `,`,
		`HealthCheck:` + strings.Replace(fmt.Sprintf("%v", this.HealthCheck), "HealthCheck", "HealthCheck", 1) + `,`,
		`Container:` + strings.Replace(fmt.Sprintf("%v", this.Container), "ContainerInfo", "ContainerInfo", 1) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`Discovery:` + strings.Replace(fmt.Sprintf("%v", this.Discovery), "DiscoveryInfo", "DiscoveryInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TaskStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TaskStatus{`,
		`TaskId:` + strings.Replace(fmt.Sprintf("%v", this.TaskId), "TaskID", "TaskID", 1) + `,`,
		`State:` + valueToStringMesos(this.State) + `,`,
		`Data:` + valueToStringMesos(this.Data) + `,`,
		`Message:` + valueToStringMesos(this.Message) + `,`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`Timestamp:` + valueToStringMesos(this.Timestamp) + `,`,
		`ExecutorId:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorId), "ExecutorID", "ExecutorID", 1) + `,`,
		`Healthy:` + valueToStringMesos(this.Healthy) + `,`,
		`Source:` + valueToStringMesos(this.Source) + `,`,
		`Reason:` + valueToStringMesos(this.Reason) + `,`,
		`Uuid:` + valueToStringMesos(this.Uuid) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`ContainerStatus:` + strings.Replace(fmt.Sprintf("%v", this.ContainerStatus), "ContainerStatus", "ContainerStatus", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Filters) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Filters{`,
		`RefuseSeconds:` + valueToStringMesos(this.RefuseSeconds) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Environment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Environment{`,
		`Variables:` + strings.Replace(fmt.Sprintf("%v", this.Variables), "Environment_Variable", "Environment_Variable", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Environment_Variable) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Environment_Variable{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Parameter) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Parameter{`,
		`Key:` + valueToStringMesos(this.Key) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Parameters) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Parameters{`,
		`Parameter:` + strings.Replace(fmt.Sprintf("%v", this.Parameter), "Parameter", "Parameter", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Credential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Credential{`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`Secret:` + valueToStringMesos(this.Secret) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Credentials) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Credentials{`,
		`Credentials:` + strings.Replace(fmt.Sprintf("%v", this.Credentials), "Credential", "Credential", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RateLimit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RateLimit{`,
		`Qps:` + valueToStringMesos(this.Qps) + `,`,
		`Principal:` + valueToStringMesos(this.Principal) + `,`,
		`Capacity:` + valueToStringMesos(this.Capacity) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RateLimits) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RateLimits{`,
		`Limits:` + strings.Replace(fmt.Sprintf("%v", this.Limits), "RateLimit", "RateLimit", 1) + `,`,
		`AggregateDefaultQps:` + valueToStringMesos(this.AggregateDefaultQps) + `,`,
		`AggregateDefaultCapacity:` + valueToStringMesos(this.AggregateDefaultCapacity) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Appc:` + strings.Replace(fmt.Sprintf("%v", this.Appc), "Image_Appc", "Image_Appc", 1) + `,`,
		`Docker:` + strings.Replace(fmt.Sprintf("%v", this.Docker), "Image_Docker", "Image_Docker", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image_Appc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image_Appc{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Id:` + valueToStringMesos(this.Id) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Image_Docker) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Image_Docker{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Volume) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Volume{`,
		`ContainerPath:` + valueToStringMesos(this.ContainerPath) + `,`,
		`HostPath:` + valueToStringMesos(this.HostPath) + `,`,
		`Mode:` + valueToStringMesos(this.Mode) + `,`,
		`Image:` + strings.Replace(fmt.Sprintf("%v", this.Image), "Image", "Image", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkInfo{`,
		`Protocol:` + valueToStringMesos(this.Protocol) + `,`,
		`IpAddress:` + valueToStringMesos(this.IpAddress) + `,`,
		`Groups:` + fmt.Sprintf("%v", this.Groups) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`IpAddresses:` + strings.Replace(fmt.Sprintf("%v", this.IpAddresses), "NetworkInfo_IPAddress", "NetworkInfo_IPAddress", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkInfo_IPAddress) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkInfo_IPAddress{`,
		`Protocol:` + valueToStringMesos(this.Protocol) + `,`,
		`IpAddress:` + valueToStringMesos(this.IpAddress) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo{`,
		`Type:` + valueToStringMesos(this.Type) + `,`,
		`Volumes:` + strings.Replace(fmt.Sprintf("%v", this.Volumes), "Volume", "Volume", 1) + `,`,
		`Docker:` + strings.Replace(fmt.Sprintf("%v", this.Docker), "ContainerInfo_DockerInfo", "ContainerInfo_DockerInfo", 1) + `,`,
		`Hostname:` + valueToStringMesos(this.Hostname) + `,`,
		`Mesos:` + strings.Replace(fmt.Sprintf("%v", this.Mesos), "ContainerInfo_MesosInfo", "ContainerInfo_MesosInfo", 1) + `,`,
		`NetworkInfos:` + strings.Replace(fmt.Sprintf("%v", this.NetworkInfos), "NetworkInfo", "NetworkInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo_DockerInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo_DockerInfo{`,
		`Image:` + valueToStringMesos(this.Image) + `,`,
		`Network:` + valueToStringMesos(this.Network) + `,`,
		`PortMappings:` + strings.Replace(fmt.Sprintf("%v", this.PortMappings), "ContainerInfo_DockerInfo_PortMapping", "ContainerInfo_DockerInfo_PortMapping", 1) + `,`,
		`Privileged:` + valueToStringMesos(this.Privileged) + `,`,
		`Parameters:` + strings.Replace(fmt.Sprintf("%v", this.Parameters), "Parameter", "Parameter", 1) + `,`,
		`ForcePullImage:` + valueToStringMesos(this.ForcePullImage) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo_DockerInfo_PortMapping) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo_DockerInfo_PortMapping{`,
		`HostPort:` + valueToStringMesos(this.HostPort) + `,`,
		`ContainerPort:` + valueToStringMesos(this.ContainerPort) + `,`,
		`Protocol:` + valueToStringMesos(this.Protocol) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerInfo_MesosInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerInfo_MesosInfo{`,
		`Image:` + strings.Replace(fmt.Sprintf("%v", this.Image), "Image", "Image", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ContainerStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ContainerStatus{`,
		`NetworkInfos:` + strings.Replace(fmt.Sprintf("%v", this.NetworkInfos), "NetworkInfo", "NetworkInfo", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Labels) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Labels{`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Label", "Label", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Label) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Label{`,
		`Key:` + valueToStringMesos(this.Key) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Port) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Port{`,
		`Number:` + valueToStringMesos(this.Number) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Protocol:` + valueToStringMesos(this.Protocol) + `,`,
		`Visibility:` + valueToStringMesos(this.Visibility) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Ports) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Ports{`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "Port", "Port", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *DiscoveryInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&DiscoveryInfo{`,
		`Visibility:` + valueToStringMesos(this.Visibility) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Environment:` + valueToStringMesos(this.Environment) + `,`,
		`Location:` + valueToStringMesos(this.Location) + `,`,
		`Version:` + valueToStringMesos(this.Version) + `,`,
		`Ports:` + strings.Replace(fmt.Sprintf("%v", this.Ports), "Ports", "Ports", 1) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "Labels", "Labels", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AppcImageManifest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AppcImageManifest{`,
		`AcKind:` + valueToStringMesos(this.AcKind) + `,`,
		`AcVersion:` + valueToStringMesos(this.AcVersion) + `,`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Labels:` + strings.Replace(fmt.Sprintf("%v", this.Labels), "AppcImageManifest_Label", "AppcImageManifest_Label", 1) + `,`,
		`Annotations:` + strings.Replace(fmt.Sprintf("%v", this.Annotations), "AppcImageManifest_Annotation", "AppcImageManifest_Annotation", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AppcImageManifest_Label) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AppcImageManifest_Label{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AppcImageManifest_Annotation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AppcImageManifest_Annotation{`,
		`Name:` + valueToStringMesos(this.Name) + `,`,
		`Value:` + valueToStringMesos(this.Value) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMesos(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *FrameworkID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrameworkID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrameworkID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OfferID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OfferID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OfferID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SlaveID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SlaveID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SlaveID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecutorID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecutorID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecutorID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerID) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanoseconds", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Nanoseconds = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("nanoseconds")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DurationInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DurationInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DurationInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nanoseconds", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Nanoseconds = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("nanoseconds")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Address) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Address: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Address: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Ip = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *URL) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: URL: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: URL: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheme", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Scheme = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &Address{}
			}
			if err := m.Address.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = append(m.Query, &Parameter{})
			if err := m.Query[len(m.Query)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fragment", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Fragment = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("scheme")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("address")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Unavailability) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Unavailability: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Unavailability: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Start == nil {
				m.Start = &TimeInfo{}
			}
			if err := m.Start.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Duration == nil {
				m.Duration = &DurationInfo{}
			}
			if err := m.Duration.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("start")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MachineID) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MachineID: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MachineID: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Ip = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MachineInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MachineInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MachineInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &MachineID{}
			}
			if err := m.Id.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v MachineInfo_Mode
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (MachineInfo_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unavailability", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unavailability == nil {
				m.Unavailability = &Unavailability{}
			}
			if err := m.Unavailability.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FrameworkInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FrameworkInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FrameworkInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.User = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &FrameworkID{}
			}
			if err := m.Id.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailoverTimeout", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.FailoverTimeout = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Checkpoint = &b
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WebuiUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.WebuiUrl = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capabilities", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Capabilities = append(m.Capabilities, &FrameworkInfo_Capability{})
			if err := m.Capabilities[len(m.Capabilities)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = &Labels{}
			}
			if err := m.Labels.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("user")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FrameworkInfo_Capability) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Capability: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Capability: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v FrameworkInfo_Capability_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (FrameworkInfo_Capability_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &HealthCheck_HTTP{}
			}
			if err := m.Http.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DelaySeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.DelaySeconds = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.IntervalSeconds = &v2
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.TimeoutSeconds = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveFailures", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsecutiveFailures = &v
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GracePeriodSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.GracePeriodSeconds = &v2
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheck_HTTP) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTP: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTP: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Path = &s
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Statuses = append(m.Statuses, v)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uris", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uris = append(m.Uris, &CommandInfo_URI{})
			if err := m.Uris[len(m.Uris)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Environment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Environment == nil {
				m.Environment = &Environment{}
			}
			if err := m.Environment.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &CommandInfo_ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.User = &s
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shell", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Shell = &b
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Arguments", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Arguments = append(m.Arguments, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandInfo_URI) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: URI: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: URI: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Executable = &b
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extract", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Extract = &b
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Cache = &b
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandInfo_ContainerInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Image = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Options = append(m.Options, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("image")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecutorInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecutorInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecutorInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorId == nil {
				m.ExecutorId = &ExecutorID{}
			}
			if err := m.ExecutorId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Source = &s
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Discovery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Discovery == nil {
				m.Discovery = &DiscoveryInfo{}
			}
			if err := m.Discovery.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("command")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Id = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ip", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ip = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Pid = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Version = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &Address{}
			}
			if err := m.Address.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("ip")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("port")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SlaveInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SlaveInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SlaveInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &Attribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &SlaveID{}
			}
			if err := m.Id.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Checkpoint = &b
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("hostname")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Text == nil {
				m.Text = &Value_Text{}
			}
			if err := m.Text.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Scalar) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Scalar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Scalar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Value = &v2
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Range) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Range: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Range: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Begin", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Begin = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.End = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("begin")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("end")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Ranges) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ranges: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ranges: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Range = append(m.Range, &Value_Range{})
			if err := m.Range[len(m.Range)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Set) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Set: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Set: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Item", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Item = append(m.Item, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value_Text) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Text: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Text: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attribute) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attribute: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attribute: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Text", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Text == nil {
				m.Text = &Value_Text{}
			}
			if err := m.Text.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resource) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Value_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Value_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scalar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scalar == nil {
				m.Scalar = &Value_Scalar{}
			}
			if err := m.Scalar.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = &Value_Ranges{}
			}
			if err := m.Ranges.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Set", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Set == nil {
				m.Set = &Value_Set{}
			}
			if err := m.Set.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Disk", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Disk == nil {
				m.Disk = &Resource_DiskInfo{}
			}
			if err := m.Disk.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reservation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reservation == nil {
				m.Reservation = &Resource_ReservationInfo{}
			}
			if err := m.Reservation.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revocable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Revocable == nil {
				m.Revocable = &Resource_RevocableInfo{}
			}
			if err := m.Revocable.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resource_ReservationInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReservationInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReservationInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resource_DiskInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Persistence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Persistence == nil {
				m.Persistence = &Resource_DiskInfo_Persistence{}
			}
			if err := m.Persistence.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Volume == nil {
				m.Volume = &Volume{}
			}
			if err := m.Volume.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resource_DiskInfo_Persistence) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Persistence: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Persistence: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Id = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Resource_RevocableInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RevocableInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RevocableInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrafficControlStatistics) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TrafficControlStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TrafficControlStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Id = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backlog", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Backlog = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Bytes = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Drops", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Drops = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Overlimits", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Overlimits = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Packets", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Packets = &v
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Qlen", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Qlen = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ratebps", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ratebps = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ratepps", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ratepps = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requeues", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Requeues = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceStatistics) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Timestamp = &v2
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusUserTimeSecs", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.CpusUserTimeSecs = &v2
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusSystemTimeSecs", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.CpusSystemTimeSecs = &v2
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusLimit", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.CpusLimit = &v2
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemRssBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemRssBytes = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemLimitBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemLimitBytes = &v
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusNrPeriods", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpusNrPeriods = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusNrThrottled", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpusNrThrottled = &v
		case 9:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpusThrottledTimeSecs", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.CpusThrottledTimeSecs = &v2
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemFileBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemFileBytes = &v
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemAnonBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemAnonBytes = &v
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemMappedFileBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemMappedFileBytes = &v
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Perf", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Perf == nil {
				m.Perf = &PerfStatistics{}
			}
			if err := m.Perf.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxPackets", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxPackets = &v
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxBytes = &v
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxErrors", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxErrors = &v
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetRxDropped", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetRxDropped = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxPackets", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxPackets = &v
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxBytes = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxErrors", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxErrors = &v
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTxDropped", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NetTxDropped = &v
		case 22:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP50", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpRttMicrosecsP50 = &v2
		case 23:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP90", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpRttMicrosecsP90 = &v2
		case 24:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP95", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpRttMicrosecsP95 = &v2
		case 25:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpRttMicrosecsP99", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpRttMicrosecsP99 = &v2
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskLimitBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DiskLimitBytes = &v
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskUsedBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DiskUsedBytes = &v
		case 28:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpActiveConnections", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpActiveConnections = &v2
		case 29:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTcpTimeWaitConnections", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.NetTcpTimeWaitConnections = &v2
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processes", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Processes = &v
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Threads", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Threads = &v
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemLowPressureCounter", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemLowPressureCounter = &v
		case 33:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemMediumPressureCounter", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemMediumPressureCounter = &v
		case 34:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemCriticalPressureCounter", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemCriticalPressureCounter = &v
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetTrafficControlStatistics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetTrafficControlStatistics = append(m.NetTrafficControlStatistics, &TrafficControlStatistics{})
			if err := m.NetTrafficControlStatistics[len(m.NetTrafficControlStatistics)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemTotalBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemTotalBytes = &v
		case 37:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemTotalMemswBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemTotalMemswBytes = &v
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemSoftLimitBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemSoftLimitBytes = &v
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemCacheBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemCacheBytes = &v
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemSwapBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemSwapBytes = &v
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemUnevictableBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemUnevictableBytes = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("timestamp")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceUsage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceUsage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceUsage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executors = append(m.Executors, &ResourceUsage_Executor{})
			if err := m.Executors[len(m.Executors)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Total = append(m.Total, &Resource{})
			if err := m.Total[len(m.Total)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceUsage_Executor) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Executor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Executor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorInfo == nil {
				m.ExecutorInfo = &ExecutorInfo{}
			}
			if err := m.ExecutorInfo.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Allocated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Allocated = append(m.Allocated, &Resource{})
			if err := m.Allocated[len(m.Allocated)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statistics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Statistics == nil {
				m.Statistics = &ResourceStatistics{}
			}
			if err := m.Statistics.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_info")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PerfStatistics) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PerfStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PerfStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Timestamp = &v2
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Duration = &v2
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Cycles = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StalledCyclesFrontend", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StalledCyclesFrontend = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StalledCyclesBackend", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StalledCyclesBackend = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instructions", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Instructions = &v
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheReferences", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheReferences = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheMisses = &v
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Branches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Branches = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchMisses = &v
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BusCycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BusCycles = &v
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefCycles", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RefCycles = &v
		case 13:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuClock", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.CpuClock = &v2
		case 14:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskClock", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.TaskClock = &v2
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PageFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PageFaults = &v
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinorFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MinorFaults = &v
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MajorFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MajorFaults = &v
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextSwitches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContextSwitches = &v
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuMigrations", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CpuMigrations = &v
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlignmentFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AlignmentFaults = &v
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmulationFaults", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EmulationFaults = &v
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheLoads = &v
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheLoadMisses = &v
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheStores = &v
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcacheStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcacheStoreMisses = &v
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcachePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcachePrefetches = &v
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1DcachePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1DcachePrefetchMisses = &v
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcacheLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcacheLoads = &v
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcacheLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcacheLoadMisses = &v
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcachePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcachePrefetches = &v
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field L1IcachePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.L1IcachePrefetchMisses = &v
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcLoads = &v
		case 33:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcLoadMisses = &v
		case 34:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcStores = &v
		case 35:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcStoreMisses = &v
		case 36:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcPrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcPrefetches = &v
		case 37:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LlcPrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LlcPrefetchMisses = &v
		case 38:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbLoads = &v
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbLoadMisses = &v
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbStores = &v
		case 41:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbStoreMisses = &v
		case 42:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbPrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbPrefetches = &v
		case 43:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DtlbPrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DtlbPrefetchMisses = &v
		case 44:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItlbLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ItlbLoads = &v
		case 45:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItlbLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ItlbLoadMisses = &v
		case 46:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchLoads = &v
		case 47:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BranchLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BranchLoadMisses = &v
		case 48:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLoads", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeLoads = &v
		case 49:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLoadMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeLoadMisses = &v
		case 50:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeStores", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeStores = &v
		case 51:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeStoreMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodeStoreMisses = &v
		case 52:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePrefetches", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodePrefetches = &v
		case 53:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodePrefetchMisses", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NodePrefetchMisses = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("timestamp")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("duration")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Offer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Offer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &OfferID{}
			}
			if err := m.Id.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000008)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorIds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExecutorIds = append(m.ExecutorIds, &ExecutorID{})
			if err := m.ExecutorIds[len(m.ExecutorIds)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, &Attribute{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Url == nil {
				m.Url = &URL{}
			}
			if err := m.Url.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unavailability", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unavailability == nil {
				m.Unavailability = &Unavailability{}
			}
			if err := m.Unavailability.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("slave_id")
	}
	if hasFields[0]&uint64(0x00000008) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("hostname")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Operation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Operation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Offer_Operation_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Offer_Operation_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Launch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Launch == nil {
				m.Launch = &Offer_Operation_Launch{}
			}
			if err := m.Launch.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reserve", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Reserve == nil {
				m.Reserve = &Offer_Operation_Reserve{}
			}
			if err := m.Reserve.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unreserve", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unreserve == nil {
				m.Unreserve = &Offer_Operation_Unreserve{}
			}
			if err := m.Unreserve.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Create", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Create == nil {
				m.Create = &Offer_Operation_Create{}
			}
			if err := m.Create.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destroy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Destroy == nil {
				m.Destroy = &Offer_Operation_Destroy{}
			}
			if err := m.Destroy.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation_Launch) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Launch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Launch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskInfos = append(m.TaskInfos, &TaskInfo{})
			if err := m.TaskInfos[len(m.TaskInfos)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation_Reserve) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reserve: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reserve: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation_Unreserve) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Unreserve: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Unreserve: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation_Create) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Create: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Create: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &Resource{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Offer_Operation_Destroy) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Destroy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Destroy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &Resource{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InverseOffer) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InverseOffer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InverseOffer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Id == nil {
				m.Id = &OfferID{}
			}
			if err := m.Id.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Url == nil {
				m.Url = &URL{}
			}
			if err := m.Url.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FrameworkId == nil {
				m.FrameworkId = &FrameworkID{}
			}
			if err := m.FrameworkId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unavailability", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unavailability == nil {
				m.Unavailability = &Unavailability{}
			}
			if err := m.Unavailability.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("unavailability")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskId == nil {
				m.TaskId = &TaskID{}
			}
			if err := m.TaskId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Executor == nil {
				m.Executor = &ExecutorInfo{}
			}
			if err := m.Executor.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &CommandInfo{}
			}
			if err := m.Command.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthCheck == nil {
				m.HealthCheck = &HealthCheck{}
			}
			if err := m.HealthCheck.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Container == nil {
				m.Container = &ContainerInfo{}
			}
			if err := m.Container.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = &Labels{}
			}
			if err := m.Labels.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Discovery", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Discovery == nil {
				m.Discovery = &DiscoveryInfo{}
			}
			if err := m.Discovery.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("slave_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TaskStatus) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskId == nil {
				m.TaskId = &TaskID{}
			}
			if err := m.TaskId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var v TaskState
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (TaskState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.State = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Timestamp = &v2
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorId == nil {
				m.ExecutorId = &ExecutorID{}
			}
			if err := m.ExecutorId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Healthy", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Healthy = &b
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var v TaskStatus_Source
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (TaskStatus_Source(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Source = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var v TaskStatus_Reason
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (TaskStatus_Reason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reason = &v
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uuid", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uuid = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = &Labels{}
			}
			if err := m.Labels.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerStatus == nil {
				m.ContainerStatus = &ContainerStatus{}
			}
			if err := m.ContainerStatus.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("state")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Filters) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefuseSeconds", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.RefuseSeconds = &v2
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Environment) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Environment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Environment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Variables = append(m.Variables, &Environment_Variable{})
			if err := m.Variables[len(m.Variables)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Environment_Variable) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Variable: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Variable: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Parameter) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Parameter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Parameter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("value")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Parameters) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Parameters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Parameters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parameter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parameter = append(m.Parameter, &Parameter{})
			if err := m.Parameter[len(m.Parameter)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Credential) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Credential: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Credential: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Secret = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Credentials) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Credentials: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Credentials: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Credentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Credentials = append(m.Credentials, &Credential{})
			if err := m.Credentials[len(m.Credentials)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RateLimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RateLimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Qps", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.Qps = &v2
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Capacity = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("principal")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimits) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RateLimits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RateLimits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Limits = append(m.Limits, &RateLimit{})
			if err := m.Limits[len(m.Limits)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregateDefaultQps", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(data[iNdEx-8])
			v |= uint64(data[iNdEx-7]) << 8
			v |= uint64(data[iNdEx-6]) << 16
			v |= uint64(data[iNdEx-5]) << 24
			v |= uint64(data[iNdEx-4]) << 32
			v |= uint64(data[iNdEx-3]) << 40
			v |= uint64(data[iNdEx-2]) << 48
			v |= uint64(data[iNdEx-1]) << 56
			v2 := float64(math.Float64frombits(v))
			m.AggregateDefaultQps = &v2
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregateDefaultCapacity", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AggregateDefaultCapacity = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Image: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Image: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Image_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Image_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Appc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Appc == nil {
				m.Appc = &Image_Appc{}
			}
			if err := m.Appc.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Docker", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Docker == nil {
				m.Docker = &Image_Docker{}
			}
			if err := m.Docker.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image_Appc) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Appc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Appc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Id = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = &Labels{}
			}
			if err := m.Labels.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Image_Docker) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Docker: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Docker: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Name = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("name")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Volume) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Volume: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Volume: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.ContainerPath = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.HostPath = &s
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var v Volume_Mode
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Volume_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Mode = &v
			hasFields[0] |= uint64(0x00000002)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &Image{}
			}
			if err := m.Image.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_path")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("mode")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var v NetworkInfo_Protocol
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (NetworkInfo_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Protocol = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.IpAddress = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Groups", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Groups = append(m.Groups, string(data[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = &Labels{}
			}
			if err := m.Labels.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpAddresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpAddresses = append(m.IpAddresses, &NetworkInfo_IPAddress{})
			if err := m.IpAddresses[len(m.IpAddresses)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkInfo_IPAddress) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var v NetworkInfo_Protocol
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (NetworkInfo_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Protocol = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.IpAddress = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v ContainerInfo_Type
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (ContainerInfo_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volumes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Volumes = append(m.Volumes, &Volume{})
			if err := m.Volumes[len(m.Volumes)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Docker", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Docker == nil {
				m.Docker = &ContainerInfo_DockerInfo{}
			}
			if err := m.Docker.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Hostname = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mesos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Mesos == nil {
				m.Mesos = &ContainerInfo_MesosInfo{}
			}
			if err := m.Mesos.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkInfos = append(m.NetworkInfos, &NetworkInfo{})
			if err := m.NetworkInfos[len(m.NetworkInfos)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerInfo_DockerInfo) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DockerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DockerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Image = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var v ContainerInfo_DockerInfo_Network
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (ContainerInfo_DockerInfo_Network(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Network = &v
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortMappings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortMappings = append(m.PortMappings, &ContainerInfo_DockerInfo_PortMapping{})
			if err := m.PortMappings[len(m.PortMappings)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileged", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Privileged = &b
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Parameters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Parameters = append(m.Parameters, &Parameter{})
			if err := m.Parameters[len(m.Parameters)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForcePullImage", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.ForcePullImage = &b
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("image")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerInfo_DockerInfo_PortMapping) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortMapping: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortMapping: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostPort", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HostPort = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerPort", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainerPort = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Protocol = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("host_port")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_port")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerInfo_MesosInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MesosInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MesosInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Image", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Image == nil {
				m.Image = &Image{}
			}
			if err := m.Image.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ContainerStatus) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ContainerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ContainerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkInfos = append(m.NetworkInfos, &NetworkInfo{})
			if err := m.NetworkInfos[len(m.NetworkInfos)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Labels) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Labels: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Labels: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Label) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Label: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Label: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Key = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesos
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMesos
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Value = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesos(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesos
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("key")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Port) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesos
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Port: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf(