// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: metapb.proto

package metapb

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	_ "github.com/gogo/protobuf/gogoproto"

	encryptionpb "github.com/pingcap/kvproto/pkg/encryptionpb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type StoreState int32

const (
	StoreState_Up        StoreState = 0
	StoreState_Offline   StoreState = 1
	StoreState_Tombstone StoreState = 2
)

var StoreState_name = map[int32]string{
	0: "Up",
	1: "Offline",
	2: "Tombstone",
}
var StoreState_value = map[string]int32{
	"Up":        0,
	"Offline":   1,
	"Tombstone": 2,
}

func (x StoreState) String() string {
	return proto.EnumName(StoreState_name, int32(x))
}
func (StoreState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{0}
}

// NodeState is going to replace StoreState to make the state concept more clear.
// "Up" is devided into "Preparing" and "Serving" stages so that we can better describe the online process.
// "Removing" is just like previous `Offline` which is more accurate.
// "Removed" has the same meaning with `Tombstone`.
type NodeState int32

const (
	NodeState_Preparing NodeState = 0
	NodeState_Serving   NodeState = 1
	NodeState_Removing  NodeState = 2
	NodeState_Removed   NodeState = 3
)

var NodeState_name = map[int32]string{
	0: "Preparing",
	1: "Serving",
	2: "Removing",
	3: "Removed",
}
var NodeState_value = map[string]int32{
	"Preparing": 0,
	"Serving":   1,
	"Removing":  2,
	"Removed":   3,
}

func (x NodeState) String() string {
	return proto.EnumName(NodeState_name, int32(x))
}
func (NodeState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{1}
}

type PeerRole int32

const (
	// Voter -> Voter
	PeerRole_Voter PeerRole = 0
	// Learner/None -> Learner
	PeerRole_Learner PeerRole = 1
	// Learner/None -> Voter
	PeerRole_IncomingVoter PeerRole = 2
	// Voter -> Learner
	PeerRole_DemotingVoter PeerRole = 3
)

var PeerRole_name = map[int32]string{
	0: "Voter",
	1: "Learner",
	2: "IncomingVoter",
	3: "DemotingVoter",
}
var PeerRole_value = map[string]int32{
	"Voter":         0,
	"Learner":       1,
	"IncomingVoter": 2,
	"DemotingVoter": 3,
}

func (x PeerRole) String() string {
	return proto.EnumName(PeerRole_name, int32(x))
}
func (PeerRole) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{2}
}

type Cluster struct {
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// max peer count for a region.
	// pd will do the auto-balance if region peer count mismatches.
	MaxPeerCount         uint32   `protobuf:"varint,2,opt,name=max_peer_count,json=maxPeerCount,proto3" json:"max_peer_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{0}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return m.Size()
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Cluster) GetMaxPeerCount() uint32 {
	if m != nil {
		return m.MaxPeerCount
	}
	return 0
}

// Case insensitive key/value for replica constraints.
type StoreLabel struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StoreLabel) Reset()         { *m = StoreLabel{} }
func (m *StoreLabel) String() string { return proto.CompactTextString(m) }
func (*StoreLabel) ProtoMessage()    {}
func (*StoreLabel) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{1}
}
func (m *StoreLabel) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreLabel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreLabel.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StoreLabel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreLabel.Merge(dst, src)
}
func (m *StoreLabel) XXX_Size() int {
	return m.Size()
}
func (m *StoreLabel) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreLabel.DiscardUnknown(m)
}

var xxx_messageInfo_StoreLabel proto.InternalMessageInfo

func (m *StoreLabel) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *StoreLabel) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type Store struct {
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Address to handle client requests (kv, cop, etc.)
	Address string        `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	State   StoreState    `protobuf:"varint,3,opt,name=state,proto3,enum=metapb.StoreState" json:"state,omitempty"`
	Labels  []*StoreLabel `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
	Version string        `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// Address to handle peer requests (raft messages from other store).
	// Empty means same as address.
	PeerAddress string `protobuf:"bytes,6,opt,name=peer_address,json=peerAddress,proto3" json:"peer_address,omitempty"`
	// Status address provides the HTTP service for external components
	StatusAddress string `protobuf:"bytes,7,opt,name=status_address,json=statusAddress,proto3" json:"status_address,omitempty"`
	GitHash       string `protobuf:"bytes,8,opt,name=git_hash,json=gitHash,proto3" json:"git_hash,omitempty"`
	// The start timestamp of the current store
	StartTimestamp int64  `protobuf:"varint,9,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	DeployPath     string `protobuf:"bytes,10,opt,name=deploy_path,json=deployPath,proto3" json:"deploy_path,omitempty"`
	// The last heartbeat timestamp of the store.
	LastHeartbeat int64 `protobuf:"varint,11,opt,name=last_heartbeat,json=lastHeartbeat,proto3" json:"last_heartbeat,omitempty"`
	// If the store is physically destroyed, which means it can never up again.
	PhysicallyDestroyed bool `protobuf:"varint,12,opt,name=physically_destroyed,json=physicallyDestroyed,proto3" json:"physically_destroyed,omitempty"`
	// NodeState is used to replace StoreState which will be deprecated in the future.
	NodeState            NodeState `protobuf:"varint,13,opt,name=node_state,json=nodeState,proto3,enum=metapb.NodeState" json:"node_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Store) Reset()         { *m = Store{} }
func (m *Store) String() string { return proto.CompactTextString(m) }
func (*Store) ProtoMessage()    {}
func (*Store) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{2}
}
func (m *Store) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Store) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Store.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Store) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Store.Merge(dst, src)
}
func (m *Store) XXX_Size() int {
	return m.Size()
}
func (m *Store) XXX_DiscardUnknown() {
	xxx_messageInfo_Store.DiscardUnknown(m)
}

var xxx_messageInfo_Store proto.InternalMessageInfo

func (m *Store) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Store) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Store) GetState() StoreState {
	if m != nil {
		return m.State
	}
	return StoreState_Up
}

func (m *Store) GetLabels() []*StoreLabel {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Store) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Store) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *Store) GetStatusAddress() string {
	if m != nil {
		return m.StatusAddress
	}
	return ""
}

func (m *Store) GetGitHash() string {
	if m != nil {
		return m.GitHash
	}
	return ""
}

func (m *Store) GetStartTimestamp() int64 {
	if m != nil {
		return m.StartTimestamp
	}
	return 0
}

func (m *Store) GetDeployPath() string {
	if m != nil {
		return m.DeployPath
	}
	return ""
}

func (m *Store) GetLastHeartbeat() int64 {
	if m != nil {
		return m.LastHeartbeat
	}
	return 0
}

func (m *Store) GetPhysicallyDestroyed() bool {
	if m != nil {
		return m.PhysicallyDestroyed
	}
	return false
}

func (m *Store) GetNodeState() NodeState {
	if m != nil {
		return m.NodeState
	}
	return NodeState_Preparing
}

type RegionEpoch struct {
	// Conf change version, auto increment when add or remove peer
	ConfVer uint64 `protobuf:"varint,1,opt,name=conf_ver,json=confVer,proto3" json:"conf_ver,omitempty"`
	// Region version, auto increment when split or merge
	Version              uint64   `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegionEpoch) Reset()         { *m = RegionEpoch{} }
func (m *RegionEpoch) String() string { return proto.CompactTextString(m) }
func (*RegionEpoch) ProtoMessage()    {}
func (*RegionEpoch) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{3}
}
func (m *RegionEpoch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionEpoch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionEpoch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RegionEpoch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionEpoch.Merge(dst, src)
}
func (m *RegionEpoch) XXX_Size() int {
	return m.Size()
}
func (m *RegionEpoch) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionEpoch.DiscardUnknown(m)
}

var xxx_messageInfo_RegionEpoch proto.InternalMessageInfo

func (m *RegionEpoch) GetConfVer() uint64 {
	if m != nil {
		return m.ConfVer
	}
	return 0
}

func (m *RegionEpoch) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type BucketStats struct {
	// total read in bytes of each bucket
	ReadBytes []uint64 `protobuf:"varint,1,rep,packed,name=read_bytes,json=readBytes" json:"read_bytes,omitempty"`
	// total write in bytes of each bucket
	WriteBytes []uint64 `protobuf:"varint,2,rep,packed,name=write_bytes,json=writeBytes" json:"write_bytes,omitempty"`
	// total read qps of each bucket
	ReadQps []uint64 `protobuf:"varint,3,rep,packed,name=read_qps,json=readQps" json:"read_qps,omitempty"`
	// total write qps of each bucket
	WriteQps []uint64 `protobuf:"varint,4,rep,packed,name=write_qps,json=writeQps" json:"write_qps,omitempty"`
	// total read keys of each bucket
	ReadKeys []uint64 `protobuf:"varint,5,rep,packed,name=read_keys,json=readKeys" json:"read_keys,omitempty"`
	// total write keys of each bucket
	WriteKeys            []uint64 `protobuf:"varint,6,rep,packed,name=write_keys,json=writeKeys" json:"write_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BucketStats) Reset()         { *m = BucketStats{} }
func (m *BucketStats) String() string { return proto.CompactTextString(m) }
func (*BucketStats) ProtoMessage()    {}
func (*BucketStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{4}
}
func (m *BucketStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BucketStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BucketStats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BucketStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BucketStats.Merge(dst, src)
}
func (m *BucketStats) XXX_Size() int {
	return m.Size()
}
func (m *BucketStats) XXX_DiscardUnknown() {
	xxx_messageInfo_BucketStats.DiscardUnknown(m)
}

var xxx_messageInfo_BucketStats proto.InternalMessageInfo

func (m *BucketStats) GetReadBytes() []uint64 {
	if m != nil {
		return m.ReadBytes
	}
	return nil
}

func (m *BucketStats) GetWriteBytes() []uint64 {
	if m != nil {
		return m.WriteBytes
	}
	return nil
}

func (m *BucketStats) GetReadQps() []uint64 {
	if m != nil {
		return m.ReadQps
	}
	return nil
}

func (m *BucketStats) GetWriteQps() []uint64 {
	if m != nil {
		return m.WriteQps
	}
	return nil
}

func (m *BucketStats) GetReadKeys() []uint64 {
	if m != nil {
		return m.ReadKeys
	}
	return nil
}

func (m *BucketStats) GetWriteKeys() []uint64 {
	if m != nil {
		return m.WriteKeys
	}
	return nil
}

type Buckets struct {
	RegionId uint64 `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// A hint indicate if keys have changed.
	Version uint64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// keys of buckets, include start/end key of region
	Keys [][]byte `protobuf:"bytes,3,rep,name=keys" json:"keys,omitempty"`
	// bucket stats
	Stats *BucketStats `protobuf:"bytes,4,opt,name=stats" json:"stats,omitempty"`
	// The period in milliseconds that stats are collected with in
	PeriodInMs           uint64   `protobuf:"varint,5,opt,name=period_in_ms,json=periodInMs,proto3" json:"period_in_ms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Buckets) Reset()         { *m = Buckets{} }
func (m *Buckets) String() string { return proto.CompactTextString(m) }
func (*Buckets) ProtoMessage()    {}
func (*Buckets) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{5}
}
func (m *Buckets) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Buckets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Buckets.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Buckets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Buckets.Merge(dst, src)
}
func (m *Buckets) XXX_Size() int {
	return m.Size()
}
func (m *Buckets) XXX_DiscardUnknown() {
	xxx_messageInfo_Buckets.DiscardUnknown(m)
}

var xxx_messageInfo_Buckets proto.InternalMessageInfo

func (m *Buckets) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *Buckets) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *Buckets) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *Buckets) GetStats() *BucketStats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *Buckets) GetPeriodInMs() uint64 {
	if m != nil {
		return m.PeriodInMs
	}
	return 0
}

type Region struct {
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Region key range [start_key, end_key).
	StartKey    []byte       `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey      []byte       `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	RegionEpoch *RegionEpoch `protobuf:"bytes,4,opt,name=region_epoch,json=regionEpoch" json:"region_epoch,omitempty"`
	Peers       []*Peer      `protobuf:"bytes,5,rep,name=peers" json:"peers,omitempty"`
	// Encryption metadata for start_key and end_key. encryption_meta.iv is IV for start_key.
	// IV for end_key is calculated from (encryption_meta.iv + len(start_key)).
	// The field is only used by PD and should be ignored otherwise.
	// If encryption_meta is empty (i.e. nil), it means start_key and end_key are unencrypted.
	EncryptionMeta       *encryptionpb.EncryptionMeta `protobuf:"bytes,6,opt,name=encryption_meta,json=encryptionMeta" json:"encryption_meta,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Region) Reset()         { *m = Region{} }
func (m *Region) String() string { return proto.CompactTextString(m) }
func (*Region) ProtoMessage()    {}
func (*Region) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{6}
}
func (m *Region) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Region) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Region.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Region) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Region.Merge(dst, src)
}
func (m *Region) XXX_Size() int {
	return m.Size()
}
func (m *Region) XXX_DiscardUnknown() {
	xxx_messageInfo_Region.DiscardUnknown(m)
}

var xxx_messageInfo_Region proto.InternalMessageInfo

func (m *Region) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Region) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *Region) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *Region) GetRegionEpoch() *RegionEpoch {
	if m != nil {
		return m.RegionEpoch
	}
	return nil
}

func (m *Region) GetPeers() []*Peer {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Region) GetEncryptionMeta() *encryptionpb.EncryptionMeta {
	if m != nil {
		return m.EncryptionMeta
	}
	return nil
}

type Peer struct {
	Id                   uint64   `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	StoreId              uint64   `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	Role                 PeerRole `protobuf:"varint,3,opt,name=role,proto3,enum=metapb.PeerRole" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Peer) Reset()         { *m = Peer{} }
func (m *Peer) String() string { return proto.CompactTextString(m) }
func (*Peer) ProtoMessage()    {}
func (*Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_metapb_4b99a30223bb9a2e, []int{7}
}
func (m *Peer) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Peer.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Peer.Merge(dst, src)
}
func (m *Peer) XXX_Size() int {
	return m.Size()
}
func (m *Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_Peer proto.InternalMessageInfo

func (m *Peer) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Peer) GetStoreId() uint64 {
	if m != nil {
		return m.StoreId
	}
	return 0
}

func (m *Peer) GetRole() PeerRole {
	if m != nil {
		return m.Role
	}
	return PeerRole_Voter
}

func init() {
	proto.RegisterType((*Cluster)(nil), "metapb.Cluster")
	proto.RegisterType((*StoreLabel)(nil), "metapb.StoreLabel")
	proto.RegisterType((*Store)(nil), "metapb.Store")
	proto.RegisterType((*RegionEpoch)(nil), "metapb.RegionEpoch")
	proto.RegisterType((*BucketStats)(nil), "metapb.BucketStats")
	proto.RegisterType((*Buckets)(nil), "metapb.Buckets")
	proto.RegisterType((*Region)(nil), "metapb.Region")
	proto.RegisterType((*Peer)(nil), "metapb.Peer")
	proto.RegisterEnum("metapb.StoreState", StoreState_name, StoreState_value)
	proto.RegisterEnum("metapb.NodeState", NodeState_name, NodeState_value)
	proto.RegisterEnum("metapb.PeerRole", PeerRole_name, PeerRole_value)
}
func (m *Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Id))
	}
	if m.MaxPeerCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.MaxPeerCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StoreLabel) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreLabel) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Store) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Store) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Id))
	}
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.State != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.State))
	}
	if len(m.Labels) > 0 {
		for _, msg := range m.Labels {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMetapb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if len(m.PeerAddress) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.PeerAddress)))
		i += copy(dAtA[i:], m.PeerAddress)
	}
	if len(m.StatusAddress) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.StatusAddress)))
		i += copy(dAtA[i:], m.StatusAddress)
	}
	if len(m.GitHash) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.GitHash)))
		i += copy(dAtA[i:], m.GitHash)
	}
	if m.StartTimestamp != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.StartTimestamp))
	}
	if len(m.DeployPath) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.DeployPath)))
		i += copy(dAtA[i:], m.DeployPath)
	}
	if m.LastHeartbeat != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.LastHeartbeat))
	}
	if m.PhysicallyDestroyed {
		dAtA[i] = 0x60
		i++
		if m.PhysicallyDestroyed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NodeState != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.NodeState))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RegionEpoch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionEpoch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ConfVer != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.ConfVer))
	}
	if m.Version != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BucketStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BucketStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ReadBytes) > 0 {
		dAtA2 := make([]byte, len(m.ReadBytes)*10)
		var j1 int
		for _, num := range m.ReadBytes {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if len(m.WriteBytes) > 0 {
		dAtA4 := make([]byte, len(m.WriteBytes)*10)
		var j3 int
		for _, num := range m.WriteBytes {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j3))
		i += copy(dAtA[i:], dAtA4[:j3])
	}
	if len(m.ReadQps) > 0 {
		dAtA6 := make([]byte, len(m.ReadQps)*10)
		var j5 int
		for _, num := range m.ReadQps {
			for num >= 1<<7 {
				dAtA6[j5] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j5++
			}
			dAtA6[j5] = uint8(num)
			j5++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j5))
		i += copy(dAtA[i:], dAtA6[:j5])
	}
	if len(m.WriteQps) > 0 {
		dAtA8 := make([]byte, len(m.WriteQps)*10)
		var j7 int
		for _, num := range m.WriteQps {
			for num >= 1<<7 {
				dAtA8[j7] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j7++
			}
			dAtA8[j7] = uint8(num)
			j7++
		}
		dAtA[i] = 0x22
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j7))
		i += copy(dAtA[i:], dAtA8[:j7])
	}
	if len(m.ReadKeys) > 0 {
		dAtA10 := make([]byte, len(m.ReadKeys)*10)
		var j9 int
		for _, num := range m.ReadKeys {
			for num >= 1<<7 {
				dAtA10[j9] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j9++
			}
			dAtA10[j9] = uint8(num)
			j9++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j9))
		i += copy(dAtA[i:], dAtA10[:j9])
	}
	if len(m.WriteKeys) > 0 {
		dAtA12 := make([]byte, len(m.WriteKeys)*10)
		var j11 int
		for _, num := range m.WriteKeys {
			for num >= 1<<7 {
				dAtA12[j11] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j11++
			}
			dAtA12[j11] = uint8(num)
			j11++
		}
		dAtA[i] = 0x32
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(j11))
		i += copy(dAtA[i:], dAtA12[:j11])
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Buckets) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Buckets) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RegionId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.RegionId))
	}
	if m.Version != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Version))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintMetapb(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if m.Stats != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Stats.Size()))
		n13, err := m.Stats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.PeriodInMs != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.PeriodInMs))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Region) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Region) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Id))
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.RegionEpoch != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.RegionEpoch.Size()))
		n14, err := m.RegionEpoch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if len(m.Peers) > 0 {
		for _, msg := range m.Peers {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintMetapb(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.EncryptionMeta != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.EncryptionMeta.Size()))
		n15, err := m.EncryptionMeta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Peer) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Peer) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Id))
	}
	if m.StoreId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.StoreId))
	}
	if m.Role != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMetapb(dAtA, i, uint64(m.Role))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintMetapb(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Cluster) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovMetapb(uint64(m.Id))
	}
	if m.MaxPeerCount != 0 {
		n += 1 + sovMetapb(uint64(m.MaxPeerCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreLabel) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Store) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovMetapb(uint64(m.Id))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovMetapb(uint64(m.State))
	}
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetapb(uint64(l))
		}
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	l = len(m.PeerAddress)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	l = len(m.StatusAddress)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	l = len(m.GitHash)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.StartTimestamp != 0 {
		n += 1 + sovMetapb(uint64(m.StartTimestamp))
	}
	l = len(m.DeployPath)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.LastHeartbeat != 0 {
		n += 1 + sovMetapb(uint64(m.LastHeartbeat))
	}
	if m.PhysicallyDestroyed {
		n += 2
	}
	if m.NodeState != 0 {
		n += 1 + sovMetapb(uint64(m.NodeState))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionEpoch) Size() (n int) {
	var l int
	_ = l
	if m.ConfVer != 0 {
		n += 1 + sovMetapb(uint64(m.ConfVer))
	}
	if m.Version != 0 {
		n += 1 + sovMetapb(uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BucketStats) Size() (n int) {
	var l int
	_ = l
	if len(m.ReadBytes) > 0 {
		l = 0
		for _, e := range m.ReadBytes {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if len(m.WriteBytes) > 0 {
		l = 0
		for _, e := range m.WriteBytes {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if len(m.ReadQps) > 0 {
		l = 0
		for _, e := range m.ReadQps {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if len(m.WriteQps) > 0 {
		l = 0
		for _, e := range m.WriteQps {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if len(m.ReadKeys) > 0 {
		l = 0
		for _, e := range m.ReadKeys {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if len(m.WriteKeys) > 0 {
		l = 0
		for _, e := range m.WriteKeys {
			l += sovMetapb(uint64(e))
		}
		n += 1 + sovMetapb(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Buckets) Size() (n int) {
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovMetapb(uint64(m.RegionId))
	}
	if m.Version != 0 {
		n += 1 + sovMetapb(uint64(m.Version))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovMetapb(uint64(l))
		}
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.PeriodInMs != 0 {
		n += 1 + sovMetapb(uint64(m.PeriodInMs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Region) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovMetapb(uint64(m.Id))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.RegionEpoch != nil {
		l = m.RegionEpoch.Size()
		n += 1 + l + sovMetapb(uint64(l))
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovMetapb(uint64(l))
		}
	}
	if m.EncryptionMeta != nil {
		l = m.EncryptionMeta.Size()
		n += 1 + l + sovMetapb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Peer) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovMetapb(uint64(m.Id))
	}
	if m.StoreId != 0 {
		n += 1 + sovMetapb(uint64(m.StoreId))
	}
	if m.Role != 0 {
		n += 1 + sovMetapb(uint64(m.Role))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetapb(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMetapb(x uint64) (n int) {
	return sovMetapb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Cluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxPeerCount", wireType)
			}
			m.MaxPeerCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxPeerCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreLabel) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreLabel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreLabel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Store) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Store: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Store: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (StoreState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &StoreLabel{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PeerAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatusAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GitHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GitHash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimestamp", wireType)
			}
			m.StartTimestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTimestamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeployPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeployPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			m.LastHeartbeat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastHeartbeat |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PhysicallyDestroyed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PhysicallyDestroyed = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeState", wireType)
			}
			m.NodeState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeState |= (NodeState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionEpoch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionEpoch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionEpoch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfVer", wireType)
			}
			m.ConfVer = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConfVer |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BucketStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ReadBytes = append(m.ReadBytes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ReadBytes = append(m.ReadBytes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadBytes", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.WriteBytes = append(m.WriteBytes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.WriteBytes = append(m.WriteBytes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBytes", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ReadQps = append(m.ReadQps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ReadQps = append(m.ReadQps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadQps", wireType)
			}
		case 4:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.WriteQps = append(m.WriteQps, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.WriteQps = append(m.WriteQps, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteQps", wireType)
			}
		case 5:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ReadKeys = append(m.ReadKeys, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ReadKeys = append(m.ReadKeys, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadKeys", wireType)
			}
		case 6:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.WriteKeys = append(m.WriteKeys, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetapb
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetapb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.WriteKeys = append(m.WriteKeys, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteKeys", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Buckets) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Buckets: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Buckets: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &BucketStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeriodInMs", wireType)
			}
			m.PeriodInMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeriodInMs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Region) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Region: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Region: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionEpoch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionEpoch == nil {
				m.RegionEpoch = &RegionEpoch{}
			}
			if err := m.RegionEpoch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &Peer{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetapb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EncryptionMeta == nil {
				m.EncryptionMeta = &encryptionpb.EncryptionMeta{}
			}
			if err := m.EncryptionMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Peer) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Peer: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Peer: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreId", wireType)
			}
			m.StoreId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= (PeerRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetapb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetapb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetapb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetapb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetapb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMetapb
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMetapb
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMetapb(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMetapb = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetapb   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("metapb.proto", fileDescriptor_metapb_4b99a30223bb9a2e) }

var fileDescriptor_metapb_4b99a30223bb9a2e = []byte{
	// 919 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x55, 0xcf, 0x72, 0xdc, 0xc4,
	0x13, 0x8e, 0xf6, 0xaf, 0xd4, 0xd2, 0xae, 0x37, 0x13, 0x57, 0xfd, 0xe4, 0xe4, 0x87, 0x59, 0xb6,
	0xf8, 0xb3, 0xf8, 0x60, 0x82, 0xa1, 0xb8, 0x52, 0x6c, 0xe2, 0x2a, 0xbb, 0x92, 0x80, 0x91, 0x43,
	0x38, 0xaa, 0x66, 0x57, 0xed, 0x5d, 0xd5, 0x4a, 0x1a, 0x31, 0x33, 0xbb, 0x44, 0x6f, 0xc2, 0x95,
	0x1b, 0xaf, 0xc1, 0x8d, 0x23, 0x47, 0x0e, 0x1c, 0x28, 0xf3, 0x04, 0xbc, 0x01, 0xd5, 0x33, 0xd2,
	0xc6, 0x8e, 0x8b, 0x93, 0xa6, 0xbf, 0xaf, 0xbb, 0xa7, 0xe7, 0x9b, 0xe9, 0x16, 0x04, 0x39, 0x6a,
	0x5e, 0xce, 0x8f, 0x4b, 0x29, 0xb4, 0x60, 0x3d, 0x6b, 0x3d, 0x64, 0x58, 0x2c, 0x64, 0x55, 0xea,
	0x54, 0x14, 0x0d, 0xf7, 0x70, 0x7f, 0x29, 0x96, 0xc2, 0x2c, 0x3f, 0xa1, 0x55, 0x8d, 0xee, 0xc9,
	0x8d, 0xd2, 0x66, 0x69, 0x81, 0xc9, 0x97, 0xd0, 0x7f, 0x92, 0x6d, 0x94, 0x46, 0xc9, 0x86, 0xd0,
	0x4a, 0x93, 0xd0, 0x19, 0x3b, 0xd3, 0x4e, 0xd4, 0x4a, 0x13, 0xf6, 0x3e, 0x0c, 0x73, 0xfe, 0x3a,
	0x2e, 0x11, 0x65, 0xbc, 0x10, 0x9b, 0x42, 0x87, 0xad, 0xb1, 0x33, 0x1d, 0x44, 0x41, 0xce, 0x5f,
	0x5f, 0x20, 0xca, 0x27, 0x84, 0x4d, 0x3e, 0x07, 0xb8, 0xd4, 0x42, 0xe2, 0x73, 0x3e, 0xc7, 0x8c,
	0x8d, 0xa0, 0xbd, 0xc6, 0xca, 0x24, 0xf1, 0x22, 0x5a, 0xb2, 0x7d, 0xe8, 0x6e, 0x79, 0xb6, 0x41,
	0x13, 0xec, 0x45, 0xd6, 0x98, 0xfc, 0xd9, 0x86, 0xae, 0x09, 0xbb, 0xb3, 0x6b, 0x08, 0x7d, 0x9e,
	0x24, 0x12, 0x95, 0xaa, 0x23, 0x1a, 0x93, 0x4d, 0xa1, 0xab, 0x34, 0xd7, 0x18, 0xb6, 0xc7, 0xce,
	0x74, 0x78, 0xc2, 0x8e, 0x6b, 0x2d, 0x4c, 0x9e, 0x4b, 0x62, 0x22, 0xeb, 0xc0, 0x8e, 0xa0, 0x97,
	0x51, 0x39, 0x2a, 0xec, 0x8c, 0xdb, 0x53, 0xff, 0x2d, 0x57, 0x53, 0x69, 0x54, 0x7b, 0xd0, 0x7e,
	0x5b, 0x94, 0x2a, 0x15, 0x45, 0xd8, 0xb5, 0xfb, 0xd5, 0x26, 0x7b, 0x0f, 0x02, 0x73, 0xf6, 0xa6,
	0x9c, 0x9e, 0xa1, 0x7d, 0xc2, 0xbe, 0xaa, 0x4b, 0xfa, 0x00, 0x86, 0xb4, 0xe3, 0x46, 0xed, 0x9c,
	0xfa, 0xc6, 0x69, 0x60, 0xd1, 0xc6, 0xed, 0x00, 0xdc, 0x65, 0xaa, 0xe3, 0x15, 0x57, 0xab, 0xd0,
	0xb5, 0x9b, 0x2c, 0x53, 0x7d, 0xc6, 0xd5, 0x8a, 0x7d, 0x04, 0x7b, 0x4a, 0x73, 0xa9, 0x63, 0x9d,
	0xe6, 0xa8, 0x34, 0xcf, 0xcb, 0xd0, 0x1b, 0x3b, 0xd3, 0x76, 0x34, 0x34, 0xf0, 0xcb, 0x06, 0x65,
	0xef, 0x82, 0x9f, 0x60, 0x99, 0x89, 0x2a, 0x2e, 0xb9, 0x5e, 0x85, 0x60, 0xd2, 0x80, 0x85, 0x2e,
	0xb8, 0x5e, 0x51, 0x2d, 0x19, 0x57, 0x3a, 0x5e, 0x21, 0x97, 0x7a, 0x8e, 0x5c, 0x87, 0xbe, 0x49,
	0x34, 0x20, 0xf4, 0xac, 0x01, 0xd9, 0xa7, 0xb0, 0x5f, 0xae, 0x2a, 0x95, 0x2e, 0x78, 0x96, 0x55,
	0x71, 0x82, 0x4a, 0x4b, 0x51, 0x61, 0x12, 0x06, 0x63, 0x67, 0xea, 0x46, 0x0f, 0xde, 0x70, 0x4f,
	0x1b, 0x8a, 0x3d, 0x06, 0x28, 0x44, 0x82, 0xb1, 0x55, 0x7f, 0x60, 0xd4, 0xbf, 0xdf, 0x48, 0xfa,
	0xb5, 0x48, 0x6a, 0xf1, 0xbd, 0xa2, 0x59, 0x4e, 0x66, 0xe0, 0x47, 0xb8, 0x4c, 0x45, 0x71, 0x5a,
	0x8a, 0xc5, 0x8a, 0xce, 0xbf, 0x10, 0xc5, 0x55, 0xbc, 0x45, 0x59, 0xdf, 0x74, 0x9f, 0xec, 0x57,
	0x28, 0x6f, 0xca, 0xdf, 0xb2, 0x4c, 0x6d, 0x4e, 0x7e, 0x75, 0xc0, 0x9f, 0x6d, 0x16, 0x6b, 0xd4,
	0x94, 0x53, 0xb1, 0x77, 0x00, 0x24, 0xf2, 0x24, 0x9e, 0x57, 0x1a, 0x55, 0xe8, 0x8c, 0xdb, 0xd3,
	0x4e, 0xe4, 0x11, 0x32, 0x23, 0x80, 0xf4, 0xf9, 0x51, 0xa6, 0x1a, 0x6b, 0xbe, 0x65, 0x78, 0x30,
	0x90, 0x75, 0x38, 0x00, 0xd7, 0xc4, 0xff, 0x50, 0xaa, 0xb0, 0x6d, 0xd8, 0x3e, 0xd9, 0xdf, 0x96,
	0x8a, 0x3d, 0x02, 0xcf, 0xc6, 0x12, 0xd7, 0x31, 0x9c, 0x6b, 0x80, 0x9a, 0x34, 0x71, 0x6b, 0xac,
	0x54, 0xd8, 0xb5, 0x24, 0x01, 0xcf, 0xb0, 0x32, 0x45, 0xd9, 0x48, 0xc3, 0xf6, 0x6c, 0x51, 0x06,
	0x21, 0x7a, 0xf2, 0xb3, 0x03, 0x7d, 0x7b, 0x86, 0x3a, 0x0f, 0x69, 0x12, 0xef, 0xde, 0xbb, 0x6b,
	0x81, 0xf3, 0xe4, 0xbf, 0x65, 0x60, 0x0c, 0x3a, 0x26, 0x37, 0x95, 0x1c, 0x44, 0x66, 0xcd, 0x3e,
	0xb6, 0x9d, 0x40, 0xb5, 0x3a, 0x53, 0xff, 0xe4, 0x41, 0x73, 0x17, 0x37, 0xe4, 0xb2, 0xad, 0xa0,
	0xd8, 0x98, 0x1e, 0xb1, 0x4c, 0x45, 0x12, 0xa7, 0x45, 0x9c, 0x2b, 0xf3, 0xc6, 0x3b, 0x11, 0x58,
	0xec, 0xbc, 0x78, 0xa1, 0x26, 0xff, 0x38, 0xd0, 0xb3, 0x97, 0x75, 0xa7, 0x17, 0x1f, 0x81, 0x67,
	0x1f, 0x27, 0xf5, 0x34, 0xd5, 0x15, 0x44, 0xae, 0x01, 0x9e, 0x61, 0xc5, 0xfe, 0x07, 0x7d, 0x2c,
	0x8c, 0x2c, 0xa6, 0x21, 0x83, 0xa8, 0x87, 0x05, 0x89, 0xc2, 0xbe, 0x80, 0xa0, 0x3e, 0x28, 0xd2,
	0xed, 0xbf, 0x5d, 0xe4, 0x8d, 0x87, 0x11, 0xf9, 0xf2, 0xc6, 0x2b, 0x99, 0x40, 0x97, 0x7a, 0xcb,
	0x8a, 0xec, 0x9f, 0x04, 0x4d, 0x00, 0xcd, 0x9a, 0xc8, 0x52, 0xec, 0x14, 0xf6, 0xde, 0xcc, 0xba,
	0x98, 0x1c, 0x4c, 0x5b, 0xfa, 0x27, 0xff, 0x3f, 0xbe, 0x35, 0x03, 0x4f, 0x77, 0xc6, 0x0b, 0xd4,
	0x3c, 0x1a, 0xe2, 0x2d, 0x7b, 0xf2, 0x3d, 0x74, 0x28, 0xeb, 0x9d, 0x03, 0x1f, 0x80, 0xab, 0x68,
	0x44, 0xd0, 0x15, 0xd5, 0xf7, 0x60, 0xec, 0x73, 0x9a, 0x86, 0x1d, 0x29, 0xb2, 0x66, 0xf8, 0x8c,
	0x6e, 0x15, 0x27, 0x32, 0x8c, 0x0c, 0x7b, 0xf4, 0xb8, 0x9e, 0x86, 0xa6, 0x0d, 0x58, 0x0f, 0x5a,
	0xdf, 0x95, 0xa3, 0x7b, 0xcc, 0x87, 0xfe, 0x37, 0x57, 0x57, 0x59, 0x5a, 0xe0, 0xc8, 0x61, 0x03,
	0xf0, 0x5e, 0x8a, 0x7c, 0xae, 0xb4, 0x28, 0x70, 0xd4, 0x3a, 0x9a, 0x81, 0xb7, 0x6b, 0x21, 0xe2,
	0x2e, 0x24, 0x96, 0x5c, 0xa6, 0xc5, 0xd2, 0xc6, 0x5d, 0xa2, 0xdc, 0x92, 0xe1, 0xb0, 0x00, 0xdc,
	0x08, 0x73, 0x61, 0xac, 0x16, 0x51, 0xc6, 0xc2, 0x64, 0xd4, 0x3e, 0x3a, 0x03, 0xb7, 0xa9, 0x83,
	0x79, 0xd0, 0x7d, 0x25, 0x34, 0x4a, 0x1b, 0xfe, 0x1c, 0xb9, 0x2c, 0x50, 0x8e, 0x1c, 0x76, 0x1f,
	0x06, 0xe7, 0xc5, 0x42, 0xe4, 0x69, 0xb1, 0xb4, 0x7c, 0x8b, 0xa0, 0xa7, 0x98, 0x0b, 0xbd, 0x83,
	0xda, 0xb3, 0x0f, 0xff, 0xf8, 0xc5, 0x75, 0x7e, 0xbb, 0x3e, 0x74, 0x7e, 0xbf, 0x3e, 0x74, 0xfe,
	0xba, 0x3e, 0x74, 0x7e, 0xfa, 0xfb, 0xf0, 0x1e, 0x8c, 0x84, 0x5c, 0x1e, 0xeb, 0x74, 0xbd, 0x3d,
	0x5e, 0x6f, 0xcd, 0x6f, 0x63, 0xde, 0x33, 0x9f, 0xcf, 0xfe, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x5c,
	0xaf, 0xc4, 0x84, 0x90, 0x06, 0x00, 0x00,
}
