// Copyright 2020 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebase provides access to the Firebase Management API.
//
// For product documentation, see: https://firebase.google.com
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/firebase/v1beta1"
//   ...
//   ctx := context.Background()
//   firebaseService, err := firebase.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   firebaseService, err := firebase.NewService(ctx, option.WithScopes(firebase.FirebaseReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   firebaseService, err := firebase.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   firebaseService, err := firebase.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package firebase // import "google.golang.org/api/firebase/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "firebase:v1beta1"
const apiName = "firebase"
const apiVersion = "v1beta1"
const basePath = "https://firebase.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data across Google Cloud Platform services
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud Platform services
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"

	// View and administer all your Firebase data and settings
	FirebaseScope = "https://www.googleapis.com/auth/firebase"

	// View all your Firebase data and settings
	FirebaseReadonlyScope = "https://www.googleapis.com/auth/firebase.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
		"https://www.googleapis.com/auth/firebase",
		"https://www.googleapis.com/auth/firebase.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.AvailableProjects = NewAvailableProjectsService(s)
	s.Operations = NewOperationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AvailableProjects *AvailableProjectsService

	Operations *OperationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAvailableProjectsService(s *Service) *AvailableProjectsService {
	rs := &AvailableProjectsService{s: s}
	return rs
}

type AvailableProjectsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.AndroidApps = NewProjectsAndroidAppsService(s)
	rs.AvailableLocations = NewProjectsAvailableLocationsService(s)
	rs.DefaultLocation = NewProjectsDefaultLocationService(s)
	rs.IosApps = NewProjectsIosAppsService(s)
	rs.WebApps = NewProjectsWebAppsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	AndroidApps *ProjectsAndroidAppsService

	AvailableLocations *ProjectsAvailableLocationsService

	DefaultLocation *ProjectsDefaultLocationService

	IosApps *ProjectsIosAppsService

	WebApps *ProjectsWebAppsService
}

func NewProjectsAndroidAppsService(s *Service) *ProjectsAndroidAppsService {
	rs := &ProjectsAndroidAppsService{s: s}
	rs.Sha = NewProjectsAndroidAppsShaService(s)
	return rs
}

type ProjectsAndroidAppsService struct {
	s *Service

	Sha *ProjectsAndroidAppsShaService
}

func NewProjectsAndroidAppsShaService(s *Service) *ProjectsAndroidAppsShaService {
	rs := &ProjectsAndroidAppsShaService{s: s}
	return rs
}

type ProjectsAndroidAppsShaService struct {
	s *Service
}

func NewProjectsAvailableLocationsService(s *Service) *ProjectsAvailableLocationsService {
	rs := &ProjectsAvailableLocationsService{s: s}
	return rs
}

type ProjectsAvailableLocationsService struct {
	s *Service
}

func NewProjectsDefaultLocationService(s *Service) *ProjectsDefaultLocationService {
	rs := &ProjectsDefaultLocationService{s: s}
	return rs
}

type ProjectsDefaultLocationService struct {
	s *Service
}

func NewProjectsIosAppsService(s *Service) *ProjectsIosAppsService {
	rs := &ProjectsIosAppsService{s: s}
	return rs
}

type ProjectsIosAppsService struct {
	s *Service
}

func NewProjectsWebAppsService(s *Service) *ProjectsWebAppsService {
	rs := &ProjectsWebAppsService{s: s}
	return rs
}

type ProjectsWebAppsService struct {
	s *Service
}

// AddFirebaseRequest: All fields are required.
type AddFirebaseRequest struct {
	// LocationId: Deprecated. Instead, to set your project's default GCP
	// resource location,
	// call
	// [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize)
	// afte
	// r you add Firebase resources to your project.
	// <br>
	// <br>The ID of the project's default GCP resource location. The
	// location
	// must be one of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s).
	LocationId string `json:"locationId,omitempty"`

	// RegionCode: Deprecated. Instead, to link your Project with a Google
	// Analytics account,
	// call
	// [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics)
	// afte
	// r you add Firebase resources to your Project.
	// <br>
	// <br>The region code (CLDR) that the account will use for Firebase
	// Analytics
	// data.
	// <br>For example: US, GB, or DE
	// <br>
	// <br>In Java, use `com.google.i18n.identifiers.RegionCode`.
	RegionCode string `json:"regionCode,omitempty"`

	// TimeZone: Deprecated. Instead, to link your Project with a Google
	// Analytics account,
	// call
	// [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics)
	// afte
	// r you add Firebase resources to your Project.
	// <br>
	// <br>The time zone that the account will use for Firebase Analytics
	// data.
	// <br>For example: America/Los_Angeles or Africa/Abidjan
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AddFirebaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddFirebaseRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AddGoogleAnalyticsRequest struct {
	// AnalyticsAccountId: The ID for the existing
	// [Google Analytics account](http://www.google.com/analytics/) that
	// you
	// want to link with your `FirebaseProject`.
	// <br>
	// <br>Specifying this field will provision a new Google
	// Analytics
	// property in your Google Analytics account and associate the new
	// property
	// with your `FirebaseProject`.
	AnalyticsAccountId string `json:"analyticsAccountId,omitempty"`

	// AnalyticsPropertyId: The ID for the existing Google Analytics
	// property that you want to
	// associate with your `FirebaseProject`.
	AnalyticsPropertyId string `json:"analyticsPropertyId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsAccountId")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsAccountId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AddGoogleAnalyticsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AddGoogleAnalyticsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AdminSdkConfig struct {
	// DatabaseURL: The default Firebase Realtime Database URL.
	DatabaseURL string `json:"databaseURL,omitempty"`

	// LocationId: The ID of the project's default GCP resource location.
	// The location is one
	// of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s). <br>
	// <br>This field is omitted if the default GCP resource location has
	// not been
	// finalized yet. To set your project's default GCP resource
	// location,
	// call
	// [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize)
	// afte
	// r you add Firebase services to your project.
	LocationId string `json:"locationId,omitempty"`

	// ProjectId: Immutable. The globally unique, user-assigned project ID
	// of the parent
	// Project.
	ProjectId string `json:"projectId,omitempty"`

	// StorageBucket: The default Cloud Storage for Firebase storage bucket
	// name.
	StorageBucket string `json:"storageBucket,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DatabaseURL") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DatabaseURL") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AdminSdkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AdminSdkConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type AnalyticsDetails struct {
	// AnalyticsProperty: The Analytics Property object associated with the
	// specified
	// `FirebaseProject`.
	// <br>
	// <br>This object contains the details of the Google Analytics
	// property
	// associated with the specified `FirebaseProject`.
	AnalyticsProperty *AnalyticsProperty `json:"analyticsProperty,omitempty"`

	// StreamMappings: For Android Apps and iOS Apps: A map of `app` to
	// `streamId` for each
	// Firebase App in the specified `FirebaseProject`. Each `app`
	// and
	// `streamId` appears only once.<br>
	// <br>
	// For Web Apps: A map of `app` to `streamId` and `measurementId` for
	// each
	// Firebase App in the specified `FirebaseProject`. Each `app`,
	// `streamId`,
	// and `measurementId` appears only once.
	StreamMappings []*StreamMapping `json:"streamMappings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsProperty")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsProperty") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AnalyticsDetails) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyticsDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnalyticsProperty: Details of a Google Analytics property
type AnalyticsProperty struct {
	// DisplayName: The display name of the Google Analytics property
	// associated with the
	// specified `FirebaseProject`.
	DisplayName string `json:"displayName,omitempty"`

	// Id: The globally unique, Google-assigned identifier of the Google
	// Analytics
	// property associated with the specified `FirebaseProject`.
	// <br>
	// <br>If you
	// called
	// [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytic
	// s) to link
	// your `FirebaseProject` with a Google Analytics account, the value in
	// this
	// `id` field is the same as the ID of the property either specified
	// or
	// provisioned with that call to `AddGoogleAnalytics`.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AnalyticsProperty) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyticsProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AndroidApp: Details of a Firebase App for Android.
type AndroidApp struct {
	// AppId: Immutable. The globally unique, Firebase-assigned identifier
	// of the App.
	// <br>
	// <br>This identifier should be treated as an opaque token, as the
	// data
	// format is not specified.
	AppId string `json:"appId,omitempty"`

	// DisplayName: The user-assigned display name of the App.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The fully qualified resource name of the App, in the
	// format:
	// <br><code>projects/<var>projectId</var>/androidApps/<var>appId
	// </var></code>
	Name string `json:"name,omitempty"`

	// PackageName: The canonical package name of the Android App as would
	// appear in the
	// Google Play Developer Console.
	PackageName string `json:"packageName,omitempty"`

	// ProjectId: The globally unique, user-assigned ID of the parent
	// Project for the App.
	ProjectId string `json:"projectId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AndroidApp) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AndroidAppConfig: Configuration metadata of a single Firebase App for
// Android.
type AndroidAppConfig struct {
	// ConfigFileContents: The contents of the JSON configuration file.
	ConfigFileContents string `json:"configFileContents,omitempty"`

	// ConfigFilename: The filename that the configuration artifact is
	// typically saved as.
	// <br>For example: `google-services.json`
	ConfigFilename string `json:"configFilename,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConfigFileContents")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigFileContents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AndroidAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidAppConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DefaultResources: The default resources associated with a
// `FirebaseProject`.
type DefaultResources struct {
	// HostingSite: The default Firebase Hosting site name, in the
	// format:
	// <br><code><var>projectId</var></code>
	// <br>Though rare, your `projectId` might already be used as the name
	// for an
	// existing Hosting site in another project (learn more about
	// creating
	// non-default,
	// [additional
	// sites](https://firebase.google.com/docs/hosting/multisites)).
	// In these cases, your `projectId` is appended with a hyphen then
	// five
	// alphanumeric characters to create your default Hosting site name.
	// For
	// example, if your `projectId` is `myproject123`, your default Hosting
	// site
	// name might be:
	// <br><code>myproject123-a5c16</code>
	HostingSite string `json:"hostingSite,omitempty"`

	// LocationId: The ID of the project's default GCP resource location.
	// The location is one
	// of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s). <br>
	// <br>This field is omitted if the default GCP resource location has
	// not been
	// finalized yet. To set your project's default GCP resource
	// location,
	// call
	// [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize)
	// afte
	// r you add Firebase services to your project.
	LocationId string `json:"locationId,omitempty"`

	// RealtimeDatabaseInstance: The default Firebase Realtime Database
	// instance name, in the
	// format:
	// <br><code><var>projectId</var></code>
	// <br>Though rare, your `projectId` might already be used as the name
	// for an
	// existing Realtime Database instance in another project (learn more
	// about
	// [database
	// sharding](https://firebase.google.com/docs/database/us
	// age/sharding)). In
	// these cases, your `projectId` is appended with a hyphen then
	// five
	// alphanumeric characters to create your default Realtime Database
	// instance
	// name. For example, if your `projectId` is `myproject123`, your
	// default
	// database instance name might be:
	// <br><code>myproject123-a5c16</code>
	RealtimeDatabaseInstance string `json:"realtimeDatabaseInstance,omitempty"`

	// StorageBucket: The default Cloud Storage for Firebase storage bucket,
	// in the format:
	// <br><code><var>projectId</var>.appspot.com</code>
	StorageBucket string `json:"storageBucket,omitempty"`

	// ForceSendFields is a list of field names (e.g. "HostingSite") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HostingSite") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DefaultResources) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated
// empty messages in your APIs. A typical example is to use it as the
// request
// or the response type of an API method. For instance:
//
//     service Foo {
//       rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty);
//     }
//
// The JSON representation for `Empty` is empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

type FinalizeDefaultLocationRequest struct {
	// LocationId: The ID of the default GCP resource location for the
	// Project. The location
	// must be one of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s).
	LocationId string `json:"locationId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FinalizeDefaultLocationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod FinalizeDefaultLocationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirebaseAppInfo: A high-level summary of an App.
type FirebaseAppInfo struct {
	// AppId: Immutable. The globally unique, Firebase-assigned identifier
	// of the App.
	// <br>
	// <br>This identifier should be treated as an opaque token, as the
	// data
	// format is not specified.
	AppId string `json:"appId,omitempty"`

	// DisplayName: The user-assigned display name of the Firebase App.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The fully qualified resource name of the Firebase App, in the
	// format:
	// <br><code>projects/<var>projectId</var>/iosApps/<var>appId</va
	// r></code>
	// or
	// <br><code>projects/<var>projectId</var>/androidApps/<var>appId</var>
	// <
	// /code>
	Name string `json:"name,omitempty"`

	// Platform: The platform of the Firebase App.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Unknown state. This is only used for
	// distinguishing unset values.
	//   "IOS" - The Firebase App is associated with iOS.
	//   "ANDROID" - The Firebase App is associated with Android.
	//   "WEB" - The Firebase App is associated with web.
	Platform string `json:"platform,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirebaseAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FirebaseAppInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirebaseProject: A `FirebaseProject` is the top-level Firebase
// entity. It is the container for
// Firebase Apps, Firebase Hosting sites, storage systems (Firebase
// Realtime
// Database, Cloud Firestore, Cloud Storage buckets) and other Firebase
// and
// Google Cloud Platform (GCP) resources.
// <br>
// <br>You can create a new `FirebaseProject` in the
// [Firebase console](https://console.firebase.google.com/),
// or you can add Firebase resources to an
// existing
// [GCP
// `Project`](https://cloud.google.com/resource-manager/ref
// erence/rest/v1/projects)
// by calling
// AddFirebase.
// <br>
// <br>A `FirebaseProject` is actually also a GCP `Project`, so
// a
// `FirebaseProject` uses underlying GCP identifiers (most
// importantly,
// `projectId`) as its own for easy interop with GCP APIs.
type FirebaseProject struct {
	// DisplayName: The user-assigned display name of the Project.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The fully qualified resource name of the Project, in the
	// format:
	// <br><code>projects/<var>projectId</var></code>
	Name string `json:"name,omitempty"`

	// ProjectId: Immutable. The globally unique, user-assigned ID of the
	// Project.
	ProjectId string `json:"projectId,omitempty"`

	// ProjectNumber: The globally unique, Google-assigned identifier of the
	// Project.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`

	// Resources: The default Firebase resources associated with the
	// Project.
	Resources *DefaultResources `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirebaseProject) MarshalJSON() ([]byte, error) {
	type NoMethod FirebaseProject
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IosApp: Details of a Firebase App for iOS.
type IosApp struct {
	// AppId: Immutable. The globally unique, Firebase-assigned identifier
	// of the App.
	// <br>
	// <br>This identifier should be treated as an opaque token, as the
	// data
	// format is not specified.
	AppId string `json:"appId,omitempty"`

	// AppStoreId: The automatically generated Apple ID assigned to the App
	// by Apple in the
	// iOS App Store.
	AppStoreId string `json:"appStoreId,omitempty"`

	// BundleId: The canonical bundle ID of the iOS App as it would appear
	// in the iOS
	// AppStore.
	BundleId string `json:"bundleId,omitempty"`

	// DisplayName: The user-assigned display name of the App.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The fully qualified resource name of the App, in the
	// format:
	// <br><code>projects/<var>projectId</var>/iosApps/<var>appId</va
	// r></code>
	Name string `json:"name,omitempty"`

	// ProjectId: The globally unique, user-assigned ID of the parent
	// Project for the App.
	ProjectId string `json:"projectId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IosApp) MarshalJSON() ([]byte, error) {
	type NoMethod IosApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IosAppConfig: Configuration metadata of a single Firebase App for
// iOS.
type IosAppConfig struct {
	// ConfigFileContents: The content of the XML configuration file.
	ConfigFileContents string `json:"configFileContents,omitempty"`

	// ConfigFilename: The filename that the configuration artifact is
	// typically saved as.
	// <br>For example: `GoogleService-Info.plist`
	ConfigFilename string `json:"configFilename,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConfigFileContents")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigFileContents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IosAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IosAppConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListAndroidAppsResponse struct {
	// Apps: List of each AndroidApp that is in the parent Firebase Project.
	Apps []*AndroidApp `json:"apps,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results.
	// <br>
	// <br>This token can be used in a subsequent call to `ListAndroidApps`
	// to
	// find the next group of Apps.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apps") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apps") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAndroidAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAndroidAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListAvailableLocationsResponse struct {
	// Locations: One page of results from a call to
	// `ListAvailableLocations`.
	Locations []*Location `json:"locations,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results and all available locations have been listed.
	// <br>
	// <br>This token can be used in a subsequent call
	// to
	// `ListAvailableLocations` to find more locations.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAvailableLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAvailableLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListAvailableProjectsResponse struct {
	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results.
	// <br>
	// <br>This token can be used in a subsequent calls to
	// `ListAvailableProjects`
	// to find the next group of GCP `Projects`.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ProjectInfo: The list of GCP `Projects` which can have Firebase
	// resources added to them.
	ProjectInfo []*ProjectInfo `json:"projectInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAvailableProjectsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAvailableProjectsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListFirebaseProjectsResponse struct {
	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results.
	// <br>
	// <br>This token can be used in a subsequent calls to
	// `ListFirebaseProjects`
	// to find the next group of Projects.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: One page of the list of Projects that are accessible to the
	// caller.
	Results []*FirebaseProject `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListFirebaseProjectsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFirebaseProjectsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListIosAppsResponse struct {
	// Apps: List of each IosApp that is in the parent Firebase Project.
	Apps []*IosApp `json:"apps,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results.
	// <br>
	// <br>This token can be used in a subsequent call to `ListIosApps` to
	// find
	// the next group of Apps.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apps") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apps") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListIosAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListIosAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListShaCertificatesResponse struct {
	// Certificates: The list of SHA certificates associated with the App.
	Certificates []*ShaCertificate `json:"certificates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Certificates") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Certificates") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListShaCertificatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListShaCertificatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListWebAppsResponse struct {
	// Apps: List of each WebApp that is in the parent Firebase Project.
	Apps []*WebApp `json:"apps,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned. If the string is empty, then this response is the last
	// page of
	// results.
	// <br>
	// <br>This token can be used in a subsequent call to `ListWebApps` to
	// find
	// the next group of Apps.
	// <br>
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apps") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apps") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListWebAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWebAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Location: A GCP resource location that can be selected for a Project.
type Location struct {
	// Features: Products and services that are available in the GCP
	// resource location.
	//
	// Possible values:
	//   "LOCATION_FEATURE_UNSPECIFIED" - Used internally for distinguishing
	// unset values and is not intended for
	// external use.
	//   "FIRESTORE" - This location supports Cloud Firestore database
	// instances.
	// <br>
	// App Engine is available in this location, so it can be a
	// project's
	// [default GCP
	// resource
	// location](//firebase.google.com/docs/projects/locations#defau
	// lt-cloud-location).
	//   "DEFAULT_STORAGE" - This location supports default Cloud Storage
	// buckets.
	// <br>
	// App Engine is available in this location, so it can be a
	// project's
	// [default GCP
	// resource
	// location](//firebase.google.com/docs/projects/locations#defau
	// lt-cloud-location).
	//   "FUNCTIONS" - Cloud Functions for Firebase is available in this
	// location.
	Features []string `json:"features,omitempty"`

	// LocationId: The ID of the GCP resource location. It will be one of
	// the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/loc
	// ations#types).
	LocationId string `json:"locationId,omitempty"`

	// Type: Indicates whether the GCP resource location is a [regional
	// or
	// multi-regional
	// location](https://firebase.google.com/docs/projects/
	// locations#types)
	// for data replication.
	//
	// Possible values:
	//   "LOCATION_TYPE_UNSPECIFIED" - Used internally for distinguishing
	// unset values and is not intended for
	// external use.
	//   "REGIONAL" - The location is a regional location.
	// <br>Data in a regional location is replicated in multiple zones
	// within a
	// region.
	//   "MULTI_REGIONAL" - The location is a multi-regional
	// location.
	// <br>Data in a multi-region location is replicated in multiple
	// regions.
	// Within each region, data is replicated in multiple zones.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Features") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MessageSet: This is proto2's version of MessageSet.
type MessageSet struct {
}

// Operation: This resource represents a long-running operation that is
// the result of a
// network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress.
	// If `true`, the operation is completed, and either `error` or
	// `response` is
	// available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation.
	// It typically
	// contains progress information and common metadata such as create
	// time.
	// Some services might not provide such metadata.  Any method that
	// returns a
	// long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that
	// originally returns it. If you use the default HTTP mapping,
	// the
	// `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success.
	// If the original
	// method returns no data on success, such as `Delete`, the response
	// is
	// `google.protobuf.Empty`.  If the original method is
	// standard
	// `Get`/`Create`/`Update`, the response should be the resource.  For
	// other
	// methods, the response should have the type `XxxResponse`, where
	// `Xxx`
	// is the original method name.  For example, if the original method
	// name
	// is `TakeSnapshot()`, the inferred response type
	// is
	// `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ProjectInfo: A reference to a Google Cloud Platform (GCP) `Project`.
type ProjectInfo struct {
	// DisplayName: The user-assigned display name of the GCP `Project`, for
	// example:
	// <code>My App</code>
	DisplayName string `json:"displayName,omitempty"`

	// LocationId: The ID of the project's default GCP resource location.
	// The location is one
	// of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s). <br> <br>
	// Not all projects will have this field populated. If it is not
	// populated, it
	// means that the project does not yet have a default GCP resource
	// location.
	// To set your project's default GCP resource location,
	// call
	// [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize)
	//  after you
	// add Firebase resources to your project.
	LocationId string `json:"locationId,omitempty"`

	// Project: The resource name of the GCP `Project` to which Firebase
	// resources can be
	// added, in the
	// format:
	// <br><code>projects/<var>PROJECT_NUMBER</var></code>
	Project string `json:"project,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ProjectInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type RemoveAnalyticsRequest struct {
	// AnalyticsPropertyId: Optional. The ID of the Google Analytics
	// property associated with the
	// specified `FirebaseProject`.
	// <ul>
	// <li>If not set, then the Google Analytics property that is
	// currently
	// associated with the specified `FirebaseProject` is
	// removed.</li>
	// <li>If set, and the specified `FirebaseProject` is currently
	// associated
	// with a <em>different</em> Google Analytics property, then the
	// response is a
	// `412 Precondition Failed` error.</li>
	// </ul>
	AnalyticsPropertyId string `json:"analyticsPropertyId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsPropertyId")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsPropertyId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *RemoveAnalyticsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RemoveAnalyticsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type SearchFirebaseAppsResponse struct {
	// Apps: One page of results from a call to `SearchFirebaseApps`.
	Apps []*FirebaseAppInfo `json:"apps,omitempty"`

	// NextPageToken: If the result list is too large to fit in a single
	// response, then a token
	// is returned.
	// <br>
	// <br>This token can be used in a subsequent calls to
	// `SearchFirebaseApps`
	// to find the next group of Apps.
	// <br>If the string is empty, then this response is the last page of
	// results.
	// <br>Page tokens are short-lived and should not be persisted.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apps") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apps") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchFirebaseAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchFirebaseAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ShaCertificate: A SHA-1 or SHA-256 certificate associated with the
// AndroidApp.
type ShaCertificate struct {
	// CertType: The SHA certificate type.
	//
	// Possible values:
	//   "SHA_CERTIFICATE_TYPE_UNSPECIFIED" - Unknown state.  This is only
	// used for distinguishing unset values.
	//   "SHA_1" - Certificate is a SHA-1 type certificate.
	//   "SHA_256" - Certificate is a SHA-256 type certificate.
	CertType string `json:"certType,omitempty"`

	// Name: The fully qualified resource name of the `sha-key`, in the
	// format:
	// <br><code>projects/<var>PROJECT_NUMBER</var>/androidApps/<var>
	// APP_ID</var>/sha/<var>SHA_ID</var></code>
	Name string `json:"name,omitempty"`

	// ShaHash: The certificate hash for the App.
	ShaHash string `json:"shaHash,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CertType") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ShaCertificate) MarshalJSON() ([]byte, error) {
	type NoMethod ShaCertificate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for
// different programming environments, including REST APIs and RPC APIs.
// It is
// used by [gRPC](https://github.com/grpc). Each `Status` message
// contains
// three pieces of data: error code, error message, and error
// details.
//
// You can find out more about this error model and how to work with it
// in the
// [API Design Guide](https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details.  There is a
	// common set of
	// message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any
	// user-facing error message should be localized and sent in
	// the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StatusProto: Wire-format for a Status object
type StatusProto struct {
	// CanonicalCode: The canonical error code (see codes.proto) that most
	// closely
	// corresponds to this status. May be missing.
	CanonicalCode int64 `json:"canonicalCode,omitempty"`

	// Code: Numeric code drawn from the space specified below. Often, this
	// is the
	// canonical error space, and code is drawn from
	// google3/util/task/codes.proto
	Code int64 `json:"code,omitempty"`

	// Message: Detail message
	Message string `json:"message,omitempty"`

	// MessageSet: message_set associates an arbitrary proto message with
	// the status.
	MessageSet *MessageSet `json:"messageSet,omitempty"`

	// Payload: DEPRECATED.
	//
	// This field was deprecated in 2011 with cl/20297133.  Java support
	// for the field was moved to a proto1 backward compatibility class
	// in April 2017 with cl/142615857 and cl/154123203.  There was
	// never support for this field in Go; if set Go will ignore it.
	// C++ stopped setting StatusProto::payload in October 2015 with
	// cl/106347055,
	// and stopped reading the field in October 2017 with cl/173324114.
	//
	// In general, newly written code should use only "message_set". If you
	// need
	// to maintain backward compatibility with code written before
	// 3/25/2011, do
	// the following:
	//
	// - During the transition period, either (1) set both "payload" and
	//   "message_set", or (2) write the consumer of StatusProto so that it
	// can
	//   forge a MessageSet object from "payload" if "message_set" is
	// missing.
	//   The C++ util::Status implementation does (2).
	//
	// - Once all the consumers are converted to accept "message_set", then
	//   remove the use of "payload" on the producer side.
	Payload *TypedMessage `json:"payload,omitempty"`

	// Space: The following are usually only present when code != 0
	// Space to which this status belongs
	Space string `json:"space,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CanonicalCode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CanonicalCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StatusProto) MarshalJSON() ([]byte, error) {
	type NoMethod StatusProto
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// StreamMapping: A mapping of a Firebase App to a Google Analytics data
// stream
type StreamMapping struct {
	// App: The fully qualified resource name of the Firebase App associated
	// with the
	// Google Analytics data stream, in the
	// format:
	// <br><code>projects/<var>PROJECT_NUMBER</var>/androidApps/<var>
	// APP_ID</var></code>
	// or
	// <code>projects/<var>PROJECT_NUMBER</var>/iosApp
	// s/<var>APP_ID</var></code>
	// or
	// <code>projects/<var>PROJECT_NUMBER</var>
	// /webApps/<var>APP_ID</var></code>
	App string `json:"app,omitempty"`

	// MeasurementId: Applicable for Firebase Web Apps only.<br>
	// <br>The unique Google-assigned identifier of the Google Analytics
	// web
	// stream associated with the Firebase Web App. Firebase SDKs use this
	// ID to
	// interact with Google Analytics APIs.
	// <br>
	// <br>Learn more about this ID and Google Analytics web streams in
	// the
	// [Analytics
	// documentation](https://support.google.com/analytics/top
	// ic/9303475).
	MeasurementId string `json:"measurementId,omitempty"`

	// StreamId: The unique Google-assigned identifier of the Google
	// Analytics data stream
	// associated with the Firebase App.
	// <br>
	// <br>Learn more about Google Analytics data streams in
	// the
	// [Analytics
	// documentation](https://support.google.com/analytics/ans
	// wer/9303323).
	StreamId int64 `json:"streamId,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *StreamMapping) MarshalJSON() ([]byte, error) {
	type NoMethod StreamMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TypedMessage: Message that groups a protocol type_id (as defined by
// MessageSet),
// with an encoded message of that type.  Its use is similar
// to
// MessageSet, except it represents a single (type, encoded
// message)
// instead of a set.
//
// To fill for known protocol type:
//   MyProtocolMsg proto;
//   TypedMessage typed_msg;
//   typed_msg.set_type_id(MyProtocolMsg::MESSAGE_TYPE_ID);
//   proto.AppendToCord(typed_msg.mutable_message());
//
// To fill for unknown protocol type:
//   ProtocolMessage proto;
//   TypedMessage typed_msg;
//   typed_msg.set_type_id(proto.GetMapper()->type_id());
//   proto.AppendToCord(typed_msg.mutable_message());
type TypedMessage struct {
	// Message: Message bytes.
	Message string `json:"message,omitempty"`

	// TypeId: Identifier for the type.
	TypeId int64 `json:"typeId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TypedMessage) MarshalJSON() ([]byte, error) {
	type NoMethod TypedMessage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebApp: Details of a Firebase App for the web.
type WebApp struct {
	// AppId: Immutable. The globally unique, Firebase-assigned identifier
	// of the App.
	// <br>
	// <br>This identifier should be treated as an opaque token, as the
	// data
	// format is not specified.
	AppId string `json:"appId,omitempty"`

	// AppUrls: The fully qualified URLs where the App is hosted.
	AppUrls []string `json:"appUrls,omitempty"`

	// DisplayName: The user-assigned display name of the App.
	DisplayName string `json:"displayName,omitempty"`

	// Name: The fully qualified resource name of the App, for
	// example:
	// <br><code>projects/<var>projectId</var>/webApps/<var>appId</v
	// ar></code>
	Name string `json:"name,omitempty"`

	// ProjectId: The globally unique, user-assigned ID of the parent
	// Project for the App.
	ProjectId string `json:"projectId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WebApp) MarshalJSON() ([]byte, error) {
	type NoMethod WebApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WebAppConfig: Configuration metadata of a single Firebase App for the
// web.
type WebAppConfig struct {
	// ApiKey: The API key associated with the web App.
	ApiKey string `json:"apiKey,omitempty"`

	// AppId: Immutable. The globally unique, Firebase-assigned identifier
	// of the App.
	AppId string `json:"appId,omitempty"`

	// AuthDomain: The domain Firebase Auth configures for OAuth redirects,
	// in the format:
	// <br><code><var>projectId</var>.firebaseapp.com</code>
	AuthDomain string `json:"authDomain,omitempty"`

	// DatabaseURL: The default Firebase Realtime Database URL.
	DatabaseURL string `json:"databaseURL,omitempty"`

	// LocationId: The ID of the project's default GCP resource location.
	// The location is one
	// of the available
	// [GCP
	// resource
	// locations](https://firebase.google.com/docs/projects/location
	// s). <br>
	// <br>This field is omitted if the default GCP resource location has
	// not been
	// finalized yet. To set your project's default GCP resource
	// location,
	// call
	// [`FinalizeDefaultLocation`](../projects.defaultLocation/finalize)
	// afte
	// r you add Firebase services to your project.
	LocationId string `json:"locationId,omitempty"`

	// MeasurementId: This field will no longer be provided here. Instead,
	// use
	// `GetAnalyticsDetails`
	MeasurementId string `json:"measurementId,omitempty"`

	// MessagingSenderId: The sender ID for use with Firebase Cloud
	// Messaging.
	MessagingSenderId string `json:"messagingSenderId,omitempty"`

	// ProjectId: Immutable. The globally unique, user-assigned project ID
	// of the parent
	// Project for the App.
	ProjectId string `json:"projectId,omitempty"`

	// StorageBucket: The default Cloud Storage for Firebase storage bucket
	// name.
	StorageBucket string `json:"storageBucket,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiKey") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WebAppConfig) MarshalJSON() ([]byte, error) {
	type NoMethod WebAppConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "firebase.availableProjects.list":

type AvailableProjectsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of [Google Cloud Platform (GCP)
// `Projects`]
// (https://cloud.google.com/resource-manager/reference/rest/
// v1/projects)
// that are available to have Firebase resources added to
// them.
// <br>
// <br>A GCP `Project` will only be returned if:
// <ol>
//   <li><p>The caller has sufficient
//          [Google IAM](https://cloud.google.com/iam) permissions to
// call
//          AddFirebase.</p></li>
//   <li><p>The GCP `Project` is not already a
// FirebaseProject.</p></li>
//   <li><p>The GCP `Project` is not in an Organization which has
// policies
//          that prevent Firebase resources from being
// added.</p></li>
// </ol>
func (r *AvailableProjectsService) List() *AvailableProjectsListCall {
	c := &AvailableProjectsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of GCP `Projects` to return in the response.
// <br>
// <br>The server may return fewer than this value at its discretion.
// If no value is specified (or too large a value is specified), the
// server
// will impose its own limit.
// <br>
// <br>This value cannot be negative.
func (c *AvailableProjectsListCall) PageSize(pageSize int64) *AvailableProjectsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListAvailableProjects`
// indicating where in the set of GCP `Projects` to resume listing.
func (c *AvailableProjectsListCall) PageToken(pageToken string) *AvailableProjectsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AvailableProjectsListCall) Fields(s ...googleapi.Field) *AvailableProjectsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AvailableProjectsListCall) IfNoneMatch(entityTag string) *AvailableProjectsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AvailableProjectsListCall) Context(ctx context.Context) *AvailableProjectsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AvailableProjectsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AvailableProjectsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/availableProjects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.availableProjects.list" call.
// Exactly one of *ListAvailableProjectsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListAvailableProjectsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AvailableProjectsListCall) Do(opts ...googleapi.CallOption) (*ListAvailableProjectsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAvailableProjectsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of [Google Cloud Platform (GCP) `Projects`]\n(https://cloud.google.com/resource-manager/reference/rest/v1/projects)\nthat are available to have Firebase resources added to them.\n\u003cbr\u003e\n\u003cbr\u003eA GCP `Project` will only be returned if:\n\u003col\u003e\n  \u003cli\u003e\u003cp\u003eThe caller has sufficient\n         [Google IAM](https://cloud.google.com/iam) permissions to call\n         AddFirebase.\u003c/p\u003e\u003c/li\u003e\n  \u003cli\u003e\u003cp\u003eThe GCP `Project` is not already a FirebaseProject.\u003c/p\u003e\u003c/li\u003e\n  \u003cli\u003e\u003cp\u003eThe GCP `Project` is not in an Organization which has policies\n         that prevent Firebase resources from being added.\u003c/p\u003e\u003c/li\u003e\n\u003c/ol\u003e",
	//   "flatPath": "v1beta1/availableProjects",
	//   "httpMethod": "GET",
	//   "id": "firebase.availableProjects.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of GCP `Projects` to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this value at its discretion.\nIf no value is specified (or too large a value is specified), the server\nwill impose its own limit.\n\u003cbr\u003e\n\u003cbr\u003eThis value cannot be negative.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListAvailableProjects`\nindicating where in the set of GCP `Projects` to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/availableProjects",
	//   "response": {
	//     "$ref": "ListAvailableProjectsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AvailableProjectsListCall) Pages(ctx context.Context, f func(*ListAvailableProjectsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.operations.get":

type OperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation.  Clients can
// use this
// method to poll the operation result at intervals as recommended by
// the API
// service.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation.  Clients can use this\nmethod to poll the operation result at intervals as recommended by the API\nservice.",
	//   "flatPath": "v1beta1/operations/{operationsId}",
	//   "httpMethod": "GET",
	//   "id": "firebase.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^operations/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.addFirebase":

type ProjectsAddFirebaseCall struct {
	s                  *Service
	project            string
	addfirebaserequest *AddFirebaseRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// AddFirebase: Adds Firebase resources to the specified
// existing
// [Google Cloud Platform (GCP)
// `Project`]
// (https://cloud.google.com/resource-manager/reference/rest/v
// 1/projects).
// <br>
// <br>Since a FirebaseProject is actually also a GCP `Project`,
// a
// `FirebaseProject` uses underlying GCP identifiers (most
// importantly,
// the `PROJECT_NUMBER`) as its own for easy interop with GCP
// APIs.
// <br>
// <br>The result of this call is an
// [`Operation`](../../v1beta1/operations).
// Poll the `Operation` to track the provisioning process by
// calling
// GetOperation
// until
// [`done`](../../v1beta1/operations#Operation.FIELDS.done) is `true`.
// When
// `done` is `true`, the `Operation` has either succeeded or failed. If
// the
// `Operation` succeeded,
// its
// [`response`](../../v1beta1/operations#Operation.FIELDS.response) is
// set to
// a FirebaseProject; if the `Operation` failed,
// its
// [`error`](../../v1beta1/operations#Operation.FIELDS.error) is set to
// a
// google.rpc.Status. The `Operation` is automatically deleted
// after
// completion, so there is no need to
// call
// DeleteOperation.
// <br>
// <br>This method does not modify any billing account information on
// the
// underlying GCP `Project`.
// <br>
// <br>To call `AddFirebase`, a project member or service account must
// have
// the following permissions (the IAM roles of Editor and Owner contain
// these
// permissions):
// `firebase.projects.update`,
// `resourcemanager.projects.get`,
// `serviceusage.services.enable`, and `serviceusage.services.get`.
func (r *ProjectsService) AddFirebase(project string, addfirebaserequest *AddFirebaseRequest) *ProjectsAddFirebaseCall {
	c := &ProjectsAddFirebaseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.addfirebaserequest = addfirebaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAddFirebaseCall) Fields(s ...googleapi.Field) *ProjectsAddFirebaseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAddFirebaseCall) Context(ctx context.Context) *ProjectsAddFirebaseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAddFirebaseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAddFirebaseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addfirebaserequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+project}:addFirebase")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.addFirebase" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAddFirebaseCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds Firebase resources to the specified existing\n[Google Cloud Platform (GCP) `Project`]\n(https://cloud.google.com/resource-manager/reference/rest/v1/projects).\n\u003cbr\u003e\n\u003cbr\u003eSince a FirebaseProject is actually also a GCP `Project`, a\n`FirebaseProject` uses underlying GCP identifiers (most importantly,\nthe `PROJECT_NUMBER`) as its own for easy interop with GCP APIs.\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an [`Operation`](../../v1beta1/operations).\nPoll the `Operation` to track the provisioning process by calling\nGetOperation until\n[`done`](../../v1beta1/operations#Operation.FIELDS.done) is `true`. When\n`done` is `true`, the `Operation` has either succeeded or failed. If the\n`Operation` succeeded, its\n[`response`](../../v1beta1/operations#Operation.FIELDS.response) is set to\na FirebaseProject; if the `Operation` failed, its\n[`error`](../../v1beta1/operations#Operation.FIELDS.error) is set to a\ngoogle.rpc.Status. The `Operation` is automatically deleted after\ncompletion, so there is no need to call\nDeleteOperation.\n\u003cbr\u003e\n\u003cbr\u003eThis method does not modify any billing account information on the\nunderlying GCP `Project`.\n\u003cbr\u003e\n\u003cbr\u003eTo call `AddFirebase`, a project member or service account must have\nthe following permissions (the IAM roles of Editor and Owner contain these\npermissions):\n`firebase.projects.update`, `resourcemanager.projects.get`,\n`serviceusage.services.enable`, and `serviceusage.services.get`.",
	//   "flatPath": "v1beta1/projects/{projectsId}:addFirebase",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.addFirebase",
	//   "parameterOrder": [
	//     "project"
	//   ],
	//   "parameters": {
	//     "project": {
	//       "description": "The resource name of the GCP `Project` to which Firebase resources will be\nadded, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e\nAfter calling `AddFirebase`, the\n[`project_id`](https://cloud.google.com/resource-manager/reference/rest/v1/projects#Project.FIELDS.project_id)\nof the GCP `Project` is also the `project_id` of the FirebaseProject.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+project}:addFirebase",
	//   "request": {
	//     "$ref": "AddFirebaseRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.addGoogleAnalytics":

type ProjectsAddGoogleAnalyticsCall struct {
	s                         *Service
	parent                    string
	addgoogleanalyticsrequest *AddGoogleAnalyticsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// AddGoogleAnalytics: Links a FirebaseProject with an existing
// [Google Analytics
// account](http://www.google.com/analytics/).
// <br>
// <br>Using this call, you can either:
// <ul>
// <li>Specify an `analyticsAccountId` to provision a new Google
// Analytics
// property within the specified account and associate the new property
// with
// your `FirebaseProject`.</li>
// <li>Specify an existing `analyticsPropertyId` to associate the
// property
// with your `FirebaseProject`.</li>
// </ul>
// <br>
// Note that when you call `AddGoogleAnalytics`:
// <ol>
// <li>The first check determines if any existing data streams in
// the
// Google Analytics property correspond to any existing Firebase Apps in
// your
// `FirebaseProject` (based on the `packageName` or `bundleId`
// associated with
// the data stream). Then, as applicable, the data streams and apps
// are
// linked. Note that this auto-linking only applies to Android Apps and
// iOS
// Apps.</li>
// <li>If no corresponding data streams are found for your Firebase
// Apps,
// new data streams are provisioned in the Google Analytics property
// for each of your Firebase Apps. Note that a new data stream is
// always
// provisioned for a Web App even if it was previously associated with
// a
// data stream in your Analytics property.</li>
// </ol>
// Learn more about the hierarchy and structure of Google
// Analytics
// accounts in
// the
// [Analytics
// documentation](https://support.google.com/analytics/ans
// wer/9303323).
// <br>
// <br>The result of this call is an
// [`Operation`](../../v1beta1/operations).
// Poll the `Operation` to track the provisioning process by
// calling
// GetOperation
// until
// [`done`](../../v1beta1/operations#Operation.FIELDS.done) is `true`.
// When
// `done` is `true`, the `Operation` has either succeeded or failed. If
// the
// `Operation` succeeded,
// its
// [`response`](../../v1beta1/operations#Operation.FIELDS.response) is
// set to
// an AnalyticsDetails; if the `Operation` failed,
// its
// [`error`](../../v1beta1/operations#Operation.FIELDS.error) is set to
// a
// google.rpc.Status.
// <br>
// <br>To call `AddGoogleAnalytics`, a member must be an Owner for
// the existing `FirebaseProject` and have the
// [`Edit`
// permission](https://support.google.com/analytics/answer/2884495)
// for the Google Analytics account.
// <br>
// <br>If a `FirebaseProject` already has Google Analytics enabled, and
// you
// call `AddGoogleAnalytics` using an `analyticsPropertyId` that's
// different
// from the currently associated property, then the call will fail.
// Analytics
// may have already been enabled in the Firebase console or by
// specifying
// `timeZone` and `regionCode` in the call
// to
// [`AddFirebase`](../../v1beta1/projects/addFirebase).
func (r *ProjectsService) AddGoogleAnalytics(parent string, addgoogleanalyticsrequest *AddGoogleAnalyticsRequest) *ProjectsAddGoogleAnalyticsCall {
	c := &ProjectsAddGoogleAnalyticsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.addgoogleanalyticsrequest = addgoogleanalyticsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAddGoogleAnalyticsCall) Fields(s ...googleapi.Field) *ProjectsAddGoogleAnalyticsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAddGoogleAnalyticsCall) Context(ctx context.Context) *ProjectsAddGoogleAnalyticsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAddGoogleAnalyticsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAddGoogleAnalyticsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.addgoogleanalyticsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:addGoogleAnalytics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.addGoogleAnalytics" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAddGoogleAnalyticsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Links a FirebaseProject with an existing\n[Google Analytics account](http://www.google.com/analytics/).\n\u003cbr\u003e\n\u003cbr\u003eUsing this call, you can either:\n\u003cul\u003e\n\u003cli\u003eSpecify an `analyticsAccountId` to provision a new Google Analytics\nproperty within the specified account and associate the new property with\nyour `FirebaseProject`.\u003c/li\u003e\n\u003cli\u003eSpecify an existing `analyticsPropertyId` to associate the property\nwith your `FirebaseProject`.\u003c/li\u003e\n\u003c/ul\u003e\n\u003cbr\u003e\nNote that when you call `AddGoogleAnalytics`:\n\u003col\u003e\n\u003cli\u003eThe first check determines if any existing data streams in the\nGoogle Analytics property correspond to any existing Firebase Apps in your\n`FirebaseProject` (based on the `packageName` or `bundleId` associated with\nthe data stream). Then, as applicable, the data streams and apps are\nlinked. Note that this auto-linking only applies to Android Apps and iOS\nApps.\u003c/li\u003e\n\u003cli\u003eIf no corresponding data streams are found for your Firebase Apps,\nnew data streams are provisioned in the Google Analytics property\nfor each of your Firebase Apps. Note that a new data stream is always\nprovisioned for a Web App even if it was previously associated with a\ndata stream in your Analytics property.\u003c/li\u003e\n\u003c/ol\u003e\nLearn more about the hierarchy and structure of Google Analytics\naccounts in the\n[Analytics\ndocumentation](https://support.google.com/analytics/answer/9303323).\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an [`Operation`](../../v1beta1/operations).\nPoll the `Operation` to track the provisioning process by calling\nGetOperation until\n[`done`](../../v1beta1/operations#Operation.FIELDS.done) is `true`. When\n`done` is `true`, the `Operation` has either succeeded or failed. If the\n`Operation` succeeded, its\n[`response`](../../v1beta1/operations#Operation.FIELDS.response) is set to\nan AnalyticsDetails; if the `Operation` failed, its\n[`error`](../../v1beta1/operations#Operation.FIELDS.error) is set to a\ngoogle.rpc.Status.\n\u003cbr\u003e\n\u003cbr\u003eTo call `AddGoogleAnalytics`, a member must be an Owner for\nthe existing `FirebaseProject` and have the\n[`Edit` permission](https://support.google.com/analytics/answer/2884495)\nfor the Google Analytics account.\n\u003cbr\u003e\n\u003cbr\u003eIf a `FirebaseProject` already has Google Analytics enabled, and you\ncall `AddGoogleAnalytics` using an `analyticsPropertyId` that's different\nfrom the currently associated property, then the call will fail. Analytics\nmay have already been enabled in the Firebase console or by specifying\n`timeZone` and `regionCode` in the call to\n[`AddFirebase`](../../v1beta1/projects/addFirebase).",
	//   "flatPath": "v1beta1/projects/{projectsId}:addGoogleAnalytics",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.addGoogleAnalytics",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent `FirebaseProject` to link to an existing Google Analytics\naccount, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}:addGoogleAnalytics",
	//   "request": {
	//     "$ref": "AddGoogleAnalyticsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.get":

type ProjectsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the FirebaseProject identified by the specified resource
// name.
func (r *ProjectsService) Get(name string) *ProjectsGetCall {
	c := &ProjectsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetCall) Fields(s ...googleapi.Field) *ProjectsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetCall) IfNoneMatch(entityTag string) *ProjectsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetCall) Context(ctx context.Context) *ProjectsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.get" call.
// Exactly one of *FirebaseProject or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *FirebaseProject.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetCall) Do(opts ...googleapi.CallOption) (*FirebaseProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &FirebaseProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the FirebaseProject identified by the specified resource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the Project, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "FirebaseProject"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.getAdminSdkConfig":

type ProjectsGetAdminSdkConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAdminSdkConfig: Gets the configuration artifact used by servers to
// simplify initialization.
// <br>
// <br>Typically, this configuration is used with the Firebase Admin
// SDK
// [initializeApp](https://firebase.google.com/docs/admin/setup#initi
// alize_the_sdk)
// command.
func (r *ProjectsService) GetAdminSdkConfig(name string) *ProjectsGetAdminSdkConfigCall {
	c := &ProjectsGetAdminSdkConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetAdminSdkConfigCall) Fields(s ...googleapi.Field) *ProjectsGetAdminSdkConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetAdminSdkConfigCall) IfNoneMatch(entityTag string) *ProjectsGetAdminSdkConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetAdminSdkConfigCall) Context(ctx context.Context) *ProjectsGetAdminSdkConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetAdminSdkConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAdminSdkConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.getAdminSdkConfig" call.
// Exactly one of *AdminSdkConfig or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AdminSdkConfig.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetAdminSdkConfigCall) Do(opts ...googleapi.CallOption) (*AdminSdkConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AdminSdkConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the configuration artifact used by servers to simplify initialization.\n\u003cbr\u003e\n\u003cbr\u003eTypically, this configuration is used with the Firebase Admin SDK\n[initializeApp](https://firebase.google.com/docs/admin/setup#initialize_the_sdk)\ncommand.",
	//   "flatPath": "v1beta1/projects/{projectsId}/adminSdkConfig",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.getAdminSdkConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the Project, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/adminSdkConfig\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/adminSdkConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "AdminSdkConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.getAnalyticsDetails":

type ProjectsGetAnalyticsDetailsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAnalyticsDetails: Gets the Google Analytics details currently
// associated with a
// FirebaseProject.
// <br>
// <br>If the `FirebaseProject` is not yet linked to Google Analytics,
// then
// the response to `GetAnalyticsDetails` is NOT_FOUND.
func (r *ProjectsService) GetAnalyticsDetails(name string) *ProjectsGetAnalyticsDetailsCall {
	c := &ProjectsGetAnalyticsDetailsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsGetAnalyticsDetailsCall) Fields(s ...googleapi.Field) *ProjectsGetAnalyticsDetailsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsGetAnalyticsDetailsCall) IfNoneMatch(entityTag string) *ProjectsGetAnalyticsDetailsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsGetAnalyticsDetailsCall) Context(ctx context.Context) *ProjectsGetAnalyticsDetailsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsGetAnalyticsDetailsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetAnalyticsDetailsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.getAnalyticsDetails" call.
// Exactly one of *AnalyticsDetails or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AnalyticsDetails.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsGetAnalyticsDetailsCall) Do(opts ...googleapi.CallOption) (*AnalyticsDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AnalyticsDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the Google Analytics details currently associated with a\nFirebaseProject.\n\u003cbr\u003e\n\u003cbr\u003eIf the `FirebaseProject` is not yet linked to Google Analytics, then\nthe response to `GetAnalyticsDetails` is NOT_FOUND.",
	//   "flatPath": "v1beta1/projects/{projectsId}/analyticsDetails",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.getAnalyticsDetails",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/analyticsDetails\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/analyticsDetails$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "AnalyticsDetails"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.list":

type ProjectsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each FirebaseProject accessible to the
// caller.
// <br>
// <br>The elements are returned in no particular order, but they will
// be a
// consistent view of the Projects when additional requests are made
// with a
// `pageToken`.
// <br>
// <br>This method is eventually consistent with Project mutations,
// which
// means newly provisioned Projects and recent modifications to
// existing
// Projects might not be reflected in the set of Projects. The list
// will
// include only ACTIVE Projects.
// <br>
// <br>Use
// GetFirebaseProject
// for consistent reads as well as for additional Project details.
func (r *ProjectsService) List() *ProjectsListCall {
	c := &ProjectsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Projects to return in the response.
// <br>
// <br>The server may return fewer than this at its discretion.
// If no value is specified (or too large a value is specified), the
// server
// will impose its own limit.
// <br>
// <br>This value cannot be negative.
func (c *ProjectsListCall) PageSize(pageSize int64) *ProjectsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListFirebaseProjects` indicating
// where in the set of Projects to resume listing.
func (c *ProjectsListCall) PageToken(pageToken string) *ProjectsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsListCall) Fields(s ...googleapi.Field) *ProjectsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsListCall) IfNoneMatch(entityTag string) *ProjectsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsListCall) Context(ctx context.Context) *ProjectsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/projects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.list" call.
// Exactly one of *ListFirebaseProjectsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListFirebaseProjectsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsListCall) Do(opts ...googleapi.CallOption) (*ListFirebaseProjectsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListFirebaseProjectsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists each FirebaseProject accessible to the caller.\n\u003cbr\u003e\n\u003cbr\u003eThe elements are returned in no particular order, but they will be a\nconsistent view of the Projects when additional requests are made with a\n`pageToken`.\n\u003cbr\u003e\n\u003cbr\u003eThis method is eventually consistent with Project mutations, which\nmeans newly provisioned Projects and recent modifications to existing\nProjects might not be reflected in the set of Projects. The list will\ninclude only ACTIVE Projects.\n\u003cbr\u003e\n\u003cbr\u003eUse\nGetFirebaseProject\nfor consistent reads as well as for additional Project details.",
	//   "flatPath": "v1beta1/projects",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Projects to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this at its discretion.\nIf no value is specified (or too large a value is specified), the server\nwill impose its own limit.\n\u003cbr\u003e\n\u003cbr\u003eThis value cannot be negative.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListFirebaseProjects` indicating\nwhere in the set of Projects to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/projects",
	//   "response": {
	//     "$ref": "ListFirebaseProjectsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsListCall) Pages(ctx context.Context, f func(*ListFirebaseProjectsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.patch":

type ProjectsPatchCall struct {
	s               *Service
	name            string
	firebaseproject *FirebaseProject
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the attributes of the FirebaseProject identified by
// the
// specified resource name.
// <br>
// <br>All [query parameters](#query-parameters) are required.
func (r *ProjectsService) Patch(name string, firebaseproject *FirebaseProject) *ProjectsPatchCall {
	c := &ProjectsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.firebaseproject = firebaseproject
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which
// fields to update.
// <br>
// <br>If this list is empty, then no state will be updated.
// <br>Note that the fields `name`, `project_id`, and `project_number`
// are all
// immutable.
func (c *ProjectsPatchCall) UpdateMask(updateMask string) *ProjectsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsPatchCall) Fields(s ...googleapi.Field) *ProjectsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsPatchCall) Context(ctx context.Context) *ProjectsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.firebaseproject)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.patch" call.
// Exactly one of *FirebaseProject or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *FirebaseProject.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsPatchCall) Do(opts ...googleapi.CallOption) (*FirebaseProject, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &FirebaseProject{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the attributes of the FirebaseProject identified by the\nspecified resource name.\n\u003cbr\u003e\n\u003cbr\u003eAll [query parameters](#query-parameters) are required.",
	//   "flatPath": "v1beta1/projects/{projectsId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebase.projects.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the Project, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003eprojectId\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Specifies which fields to update.\n\u003cbr\u003e\n\u003cbr\u003eIf this list is empty, then no state will be updated.\n\u003cbr\u003eNote that the fields `name`, `project_id`, and `project_number` are all\nimmutable.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "FirebaseProject"
	//   },
	//   "response": {
	//     "$ref": "FirebaseProject"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.removeAnalytics":

type ProjectsRemoveAnalyticsCall struct {
	s                      *Service
	parent                 string
	removeanalyticsrequest *RemoveAnalyticsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// RemoveAnalytics: Unlinks the specified `FirebaseProject` from its
// Google Analytics account.
// <br>
// <br>This call removes the association of the specified
// `FirebaseProject`
// with its current Google Analytics property. However, this call does
// not
// delete the Google Analytics resources, such as the Google
// Analytics
// property or any data streams.
// <br>
// <br>These resources may be re-associated later to the
// `FirebaseProject`
// by
// calling
// [`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnal
// ytics) and
// specifying the same `analyticsPropertyId`. For Android Apps and iOS
// Apps,
// this call re-links data streams with their corresponding apps.
// However,
// for Web Apps, this call provisions a <em>new</em> data stream for
// each Web
// App.
// <br>
// <br>To call `RemoveAnalytics`, a member must be an Owner for
// the `FirebaseProject`.
func (r *ProjectsService) RemoveAnalytics(parent string, removeanalyticsrequest *RemoveAnalyticsRequest) *ProjectsRemoveAnalyticsCall {
	c := &ProjectsRemoveAnalyticsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.removeanalyticsrequest = removeanalyticsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsRemoveAnalyticsCall) Fields(s ...googleapi.Field) *ProjectsRemoveAnalyticsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsRemoveAnalyticsCall) Context(ctx context.Context) *ProjectsRemoveAnalyticsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsRemoveAnalyticsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRemoveAnalyticsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.removeanalyticsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:removeAnalytics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.removeAnalytics" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsRemoveAnalyticsCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Unlinks the specified `FirebaseProject` from its Google Analytics account.\n\u003cbr\u003e\n\u003cbr\u003eThis call removes the association of the specified `FirebaseProject`\nwith its current Google Analytics property. However, this call does not\ndelete the Google Analytics resources, such as the Google Analytics\nproperty or any data streams.\n\u003cbr\u003e\n\u003cbr\u003eThese resources may be re-associated later to the `FirebaseProject` by\ncalling\n[`AddGoogleAnalytics`](../../v1beta1/projects/addGoogleAnalytics) and\nspecifying the same `analyticsPropertyId`. For Android Apps and iOS Apps,\nthis call re-links data streams with their corresponding apps. However,\nfor Web Apps, this call provisions a \u003cem\u003enew\u003c/em\u003e data stream for each Web\nApp.\n\u003cbr\u003e\n\u003cbr\u003eTo call `RemoveAnalytics`, a member must be an Owner for\nthe `FirebaseProject`.",
	//   "flatPath": "v1beta1/projects/{projectsId}:removeAnalytics",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.removeAnalytics",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent `FirebaseProject` to unlink from its Google Analytics account,\nin the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}:removeAnalytics",
	//   "request": {
	//     "$ref": "RemoveAnalyticsRequest"
	//   },
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.searchApps":

type ProjectsSearchAppsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchApps: A convenience method that lists all available Apps for
// the specified
// FirebaseProject.
// <br>
// <br>Typically, interaction with an App should be done using
// the
// platform-specific service, but some tool use-cases require a summary
// of all
// known Apps (such as for App selector interfaces).
func (r *ProjectsService) SearchApps(parent string) *ProjectsSearchAppsCall {
	c := &ProjectsSearchAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Apps to return in the response.
// <br>
// <br>The server may return fewer than this value at its discretion.
// If no value is specified (or too large a value is specified), then
// the
// server will impose its own limit.
// <br>
// <br>This value cannot be negative.
func (c *ProjectsSearchAppsCall) PageSize(pageSize int64) *ProjectsSearchAppsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `SearchFirebaseApps` indicating
// where in the set of Apps to resume listing.
func (c *ProjectsSearchAppsCall) PageToken(pageToken string) *ProjectsSearchAppsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsSearchAppsCall) Fields(s ...googleapi.Field) *ProjectsSearchAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsSearchAppsCall) IfNoneMatch(entityTag string) *ProjectsSearchAppsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsSearchAppsCall) Context(ctx context.Context) *ProjectsSearchAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsSearchAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSearchAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:searchApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.searchApps" call.
// Exactly one of *SearchFirebaseAppsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *SearchFirebaseAppsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsSearchAppsCall) Do(opts ...googleapi.CallOption) (*SearchFirebaseAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchFirebaseAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "A convenience method that lists all available Apps for the specified\nFirebaseProject.\n\u003cbr\u003e\n\u003cbr\u003eTypically, interaction with an App should be done using the\nplatform-specific service, but some tool use-cases require a summary of all\nknown Apps (such as for App selector interfaces).",
	//   "flatPath": "v1beta1/projects/{projectsId}:searchApps",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.searchApps",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Apps to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this value at its discretion.\nIf no value is specified (or too large a value is specified), then the\nserver will impose its own limit.\n\u003cbr\u003e\n\u003cbr\u003eThis value cannot be negative.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `SearchFirebaseApps` indicating\nwhere in the set of Apps to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent Project for which to list Apps, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}:searchApps",
	//   "response": {
	//     "$ref": "SearchFirebaseAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsSearchAppsCall) Pages(ctx context.Context, f func(*SearchFirebaseAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.androidApps.create":

type ProjectsAndroidAppsCreateCall struct {
	s          *Service
	parent     string
	androidapp *AndroidApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests that a new AndroidApp be created.
// <br>
// <br>The result of this call is an `Operation` which can be used to
// track
// the provisioning process. The `Operation` is automatically deleted
// after
// completion, so there is no need to call `DeleteOperation`.
func (r *ProjectsAndroidAppsService) Create(parent string, androidapp *AndroidApp) *ProjectsAndroidAppsCreateCall {
	c := &ProjectsAndroidAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.androidapp = androidapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsCreateCall) Context(ctx context.Context) *ProjectsAndroidAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.androidapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/androidApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Requests that a new AndroidApp be created.\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an `Operation` which can be used to track\nthe provisioning process. The `Operation` is automatically deleted after\ncompletion, so there is no need to call `DeleteOperation`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.androidApps.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent Project in which to create an App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/androidApps",
	//   "request": {
	//     "$ref": "AndroidApp"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.get":

type ProjectsAndroidAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the AndroidApp identified by the specified resource name.
func (r *ProjectsAndroidAppsService) Get(nameid string) *ProjectsAndroidAppsGetCall {
	c := &ProjectsAndroidAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsGetCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAndroidAppsGetCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsGetCall) Context(ctx context.Context) *ProjectsAndroidAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.get" call.
// Exactly one of *AndroidApp or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AndroidApp.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsGetCall) Do(opts ...googleapi.CallOption) (*AndroidApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AndroidApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the AndroidApp identified by the specified resource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.androidApps.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "AndroidApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.getConfig":

type ProjectsAndroidAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the
// specified
// AndroidApp.
func (r *ProjectsAndroidAppsService) GetConfig(nameid string) *ProjectsAndroidAppsGetConfigCall {
	c := &ProjectsAndroidAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAndroidAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsGetConfigCall) Context(ctx context.Context) *ProjectsAndroidAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.getConfig" call.
// Exactly one of *AndroidAppConfig or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *AndroidAppConfig.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*AndroidAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AndroidAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the configuration artifact associated with the specified\nAndroidApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}/config",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.androidApps.getConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the App configuration to download, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e/config\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+/config$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "AndroidAppConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.list":

type ProjectsAndroidAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each AndroidApp associated with the specified parent
// Project.
// <br>
// <br>The elements are returned in no particular order, but will be
// a
// consistent view of the Apps when additional requests are made with
// a
// `pageToken`.
func (r *ProjectsAndroidAppsService) List(parent string) *ProjectsAndroidAppsListCall {
	c := &ProjectsAndroidAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Apps to return in the response.
// <br>
// <br>The server may return fewer than this at its discretion.
// If no value is specified (or too large a value is specified), then
// the
// server will impose its own limit.
func (c *ProjectsAndroidAppsListCall) PageSize(pageSize int64) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListAndroidApps` indicating where
// in the set of Apps to resume listing.
func (c *ProjectsAndroidAppsListCall) PageToken(pageToken string) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsListCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAndroidAppsListCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsListCall) Context(ctx context.Context) *ProjectsAndroidAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/androidApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.list" call.
// Exactly one of *ListAndroidAppsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAndroidAppsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsListCall) Do(opts ...googleapi.CallOption) (*ListAndroidAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAndroidAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists each AndroidApp associated with the specified parent Project.\n\u003cbr\u003e\n\u003cbr\u003eThe elements are returned in no particular order, but will be a\nconsistent view of the Apps when additional requests are made with a\n`pageToken`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.androidApps.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Apps to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this at its discretion.\nIf no value is specified (or too large a value is specified), then the\nserver will impose its own limit.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListAndroidApps` indicating where\nin the set of Apps to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent Project for which to list Apps, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/androidApps",
	//   "response": {
	//     "$ref": "ListAndroidAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAndroidAppsListCall) Pages(ctx context.Context, f func(*ListAndroidAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.androidApps.patch":

type ProjectsAndroidAppsPatchCall struct {
	s          *Service
	name       string
	androidapp *AndroidApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the AndroidApp identified by the
// specified
// resource name.
func (r *ProjectsAndroidAppsService) Patch(name string, androidapp *AndroidApp) *ProjectsAndroidAppsPatchCall {
	c := &ProjectsAndroidAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.androidapp = androidapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which
// fields to update.
// <br>Note that the fields `name`, `app_id`, `project_id`, and
// `package_name`
// are all immutable.
func (c *ProjectsAndroidAppsPatchCall) UpdateMask(updateMask string) *ProjectsAndroidAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsPatchCall) Context(ctx context.Context) *ProjectsAndroidAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.androidapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.patch" call.
// Exactly one of *AndroidApp or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *AndroidApp.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsPatchCall) Do(opts ...googleapi.CallOption) (*AndroidApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AndroidApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the attributes of the AndroidApp identified by the specified\nresource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebase.projects.androidApps.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003eprojectId\u003c/var\u003e/androidApps/\u003cvar\u003eappId\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Specifies which fields to update.\n\u003cbr\u003eNote that the fields `name`, `app_id`, `project_id`, and `package_name`\nare all immutable.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "AndroidApp"
	//   },
	//   "response": {
	//     "$ref": "AndroidApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.sha.create":

type ProjectsAndroidAppsShaCreateCall struct {
	s              *Service
	parentid       string
	shacertificate *ShaCertificate
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Adds a SHA certificate to the specified AndroidApp.
func (r *ProjectsAndroidAppsShaService) Create(parentid string, shacertificate *ShaCertificate) *ProjectsAndroidAppsShaCreateCall {
	c := &ProjectsAndroidAppsShaCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.shacertificate = shacertificate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsShaCreateCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsShaCreateCall) Context(ctx context.Context) *ProjectsAndroidAppsShaCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsShaCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.shacertificate)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/sha")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.create" call.
// Exactly one of *ShaCertificate or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ShaCertificate.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsShaCreateCall) Do(opts ...googleapi.CallOption) (*ShaCertificate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ShaCertificate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Adds a SHA certificate to the specified AndroidApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}/sha",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.androidApps.sha.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent App to which a SHA certificate will be added, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/sha",
	//   "request": {
	//     "$ref": "ShaCertificate"
	//   },
	//   "response": {
	//     "$ref": "ShaCertificate"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.sha.delete":

type ProjectsAndroidAppsShaDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Removes a SHA certificate from the specified AndroidApp.
func (r *ProjectsAndroidAppsShaService) Delete(name string) *ProjectsAndroidAppsShaDeleteCall {
	c := &ProjectsAndroidAppsShaDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsShaDeleteCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsShaDeleteCall) Context(ctx context.Context) *ProjectsAndroidAppsShaDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsShaDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsAndroidAppsShaDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Removes a SHA certificate from the specified AndroidApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}/sha/{shaId}",
	//   "httpMethod": "DELETE",
	//   "id": "firebase.projects.androidApps.sha.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the `sha-key`, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e/sha/\u003cvar\u003eSHA_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eYou can obtain the full name from the response of\n[`ListShaCertificates`](../projects.androidApps.sha/list) or the original\n[`CreateShaCertificate`](../projects.androidApps.sha/create).",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+/sha/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.androidApps.sha.list":

type ProjectsAndroidAppsShaListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of SHA-1 and SHA-256 certificates for the
// specified
// AndroidApp.
func (r *ProjectsAndroidAppsShaService) List(parentid string) *ProjectsAndroidAppsShaListCall {
	c := &ProjectsAndroidAppsShaListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAndroidAppsShaListCall) Fields(s ...googleapi.Field) *ProjectsAndroidAppsShaListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAndroidAppsShaListCall) IfNoneMatch(entityTag string) *ProjectsAndroidAppsShaListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAndroidAppsShaListCall) Context(ctx context.Context) *ProjectsAndroidAppsShaListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAndroidAppsShaListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAndroidAppsShaListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/sha")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.androidApps.sha.list" call.
// Exactly one of *ListShaCertificatesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListShaCertificatesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAndroidAppsShaListCall) Do(opts ...googleapi.CallOption) (*ListShaCertificatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListShaCertificatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of SHA-1 and SHA-256 certificates for the specified\nAndroidApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/androidApps/{androidAppsId}/sha",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.androidApps.sha.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent App for which to list SHA certificates, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/androidApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/androidApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/sha",
	//   "response": {
	//     "$ref": "ListShaCertificatesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.availableLocations.list":

type ProjectsAvailableLocationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of valid Google Cloud Platform (GCP) resource
// locations for
// the specified Project (including a FirebaseProject).
// <br>
// <br>One of these locations can be selected as the Project's
// [_default_ GCP
// resource
// location](https://firebase.google.com/docs/projects/locations),
// which is the geographical location where project resources, such as
// Cloud
// Firestore, will be provisioned by default. However, if the default
// GCP
// resource location has already been set for the Project, then this
// setting
// cannot be changed.
// <br>
// <br>This call checks for any
// possible
// [location
// restrictions](https://cloud.google.com/resource-man
// ager/docs/organization-policy/defining-locations)
// for the specified Project and, thus, might return a subset of all
// possible
// GCP resource locations. To list all GCP resource locations
// (regardless of
// any restrictions), call the endpoint without specifying a
// `PROJECT_NUMBER`
// (that is, `/v1beta1/{parent=projects/-}/listAvailableLocations`).
// <br>
// <br>To call `ListAvailableLocations` with a specified project, a
// member
// must be at minimum a Viewer of the project. Calls without a
// specified
// project do not require any specific project permissions.
func (r *ProjectsAvailableLocationsService) List(parent string) *ProjectsAvailableLocationsListCall {
	c := &ProjectsAvailableLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of locations to return in the response.
// <br>
// <br>The server may return fewer than this value at its discretion.
// If no value is specified (or too large a value is specified), then
// the
// server will impose its own limit.
// <br>
// <br>This value cannot be negative.
func (c *ProjectsAvailableLocationsListCall) PageSize(pageSize int64) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListAvailableLocations` indicating
// where in the list of locations to resume listing.
func (c *ProjectsAvailableLocationsListCall) PageToken(pageToken string) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsAvailableLocationsListCall) Fields(s ...googleapi.Field) *ProjectsAvailableLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsAvailableLocationsListCall) IfNoneMatch(entityTag string) *ProjectsAvailableLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsAvailableLocationsListCall) Context(ctx context.Context) *ProjectsAvailableLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsAvailableLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAvailableLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/availableLocations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.availableLocations.list" call.
// Exactly one of *ListAvailableLocationsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListAvailableLocationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsAvailableLocationsListCall) Do(opts ...googleapi.CallOption) (*ListAvailableLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAvailableLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of valid Google Cloud Platform (GCP) resource locations for\nthe specified Project (including a FirebaseProject).\n\u003cbr\u003e\n\u003cbr\u003eOne of these locations can be selected as the Project's [_default_ GCP\nresource location](https://firebase.google.com/docs/projects/locations),\nwhich is the geographical location where project resources, such as Cloud\nFirestore, will be provisioned by default. However, if the default GCP\nresource location has already been set for the Project, then this setting\ncannot be changed.\n\u003cbr\u003e\n\u003cbr\u003eThis call checks for any possible\n[location\nrestrictions](https://cloud.google.com/resource-manager/docs/organization-policy/defining-locations)\nfor the specified Project and, thus, might return a subset of all possible\nGCP resource locations. To list all GCP resource locations (regardless of\nany restrictions), call the endpoint without specifying a `PROJECT_NUMBER`\n(that is, `/v1beta1/{parent=projects/-}/listAvailableLocations`). \u003cbr\u003e\n\u003cbr\u003eTo call `ListAvailableLocations` with a specified project, a member\nmust be at minimum a Viewer of the project. Calls without a specified\nproject do not require any specific project permissions.",
	//   "flatPath": "v1beta1/projects/{projectsId}/availableLocations",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.availableLocations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of locations to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this value at its discretion.\nIf no value is specified (or too large a value is specified), then the\nserver will impose its own limit.\n\u003cbr\u003e\n\u003cbr\u003eThis value cannot be negative.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListAvailableLocations` indicating\nwhere in the list of locations to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The Project for which to list GCP resource locations, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eIf no project is specified (that is, `projects/-`), the returned list\ndoes not take into account org-specific or project-specific location\nrestrictions.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/availableLocations",
	//   "response": {
	//     "$ref": "ListAvailableLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAvailableLocationsListCall) Pages(ctx context.Context, f func(*ListAvailableLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.defaultLocation.finalize":

type ProjectsDefaultLocationFinalizeCall struct {
	s                              *Service
	parent                         string
	finalizedefaultlocationrequest *FinalizeDefaultLocationRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Finalize: Sets the default Google Cloud Platform (GCP) resource
// location for the
// specified FirebaseProject.
// <br>
// <br>This method creates an App Engine application with a
// [default Cloud
// Storage
// bucket](https://cloud.google.com/appengine/docs/standard/pytho
// n/googlecloudstorageclient/setting-up-cloud-storage#activating_a_cloud
// _storage_bucket),
// located in the
// specified
// [`location_id`](#body.request_body.FIELDS.location_id).
// This
//  location must be one of the available
// [GCP
// resource
// locations](https://firebase.google.com/docs/projects/location
// s). <br>
// <br>After the default GCP resource location is finalized, or if it
// was
// already set, it cannot be changed. The default GCP resource location
// for
// the specified FirebaseProject might already be set because either
// the
// GCP `Project` already has an App Engine application
// or
// `FinalizeDefaultLocation` was previously called with a
// specified
// `location_id`. Any new calls to `FinalizeDefaultLocation` with
// a
// <em>different</em> specified `location_id` will return a 409
// error.
// <br>
// <br>The result of this call is an
// [`Operation`](../../v1beta1/operations),
// which can be used to track the provisioning process.
// The
// [`response`](../../v1beta1/operations#Operation.FIELDS.response) type
// of
// the `Operation` is google.protobuf.Empty.
// <br>
// <br>The `Operation` can be polled by its `name` using
// GetOperation until `done` is
// true. When `done` is true, the `Operation` has either succeeded or
// failed.
// If the `Operation` has succeeded,
// its
// [`response`](../../v1beta1/operations#Operation.FIELDS.response) will
// be
// set to a google.protobuf.Empty; if the `Operation` has failed,
// its
// `error` will be set to a google.rpc.Status. The `Operation`
// is
// automatically deleted after completion, so there is no need to
// call
// DeleteOperation.
// <br>
// <br>All fields listed in the [request body](#request-body) are
// required.
// <br>
// <br>To call `FinalizeDefaultLocation`, a member must be an Owner
// of the project.
func (r *ProjectsDefaultLocationService) Finalize(parent string, finalizedefaultlocationrequest *FinalizeDefaultLocationRequest) *ProjectsDefaultLocationFinalizeCall {
	c := &ProjectsDefaultLocationFinalizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.finalizedefaultlocationrequest = finalizedefaultlocationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsDefaultLocationFinalizeCall) Fields(s ...googleapi.Field) *ProjectsDefaultLocationFinalizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsDefaultLocationFinalizeCall) Context(ctx context.Context) *ProjectsDefaultLocationFinalizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsDefaultLocationFinalizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDefaultLocationFinalizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.finalizedefaultlocationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/defaultLocation:finalize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.defaultLocation.finalize" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDefaultLocationFinalizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the default Google Cloud Platform (GCP) resource location for the\nspecified FirebaseProject.\n\u003cbr\u003e\n\u003cbr\u003eThis method creates an App Engine application with a\n[default Cloud Storage\nbucket](https://cloud.google.com/appengine/docs/standard/python/googlecloudstorageclient/setting-up-cloud-storage#activating_a_cloud_storage_bucket),\nlocated in the specified\n[`location_id`](#body.request_body.FIELDS.location_id).\nThis location must be one of the available\n[GCP resource\nlocations](https://firebase.google.com/docs/projects/locations). \u003cbr\u003e\n\u003cbr\u003eAfter the default GCP resource location is finalized, or if it was\nalready set, it cannot be changed. The default GCP resource location for\nthe specified FirebaseProject might already be set because either the\nGCP `Project` already has an App Engine application or\n`FinalizeDefaultLocation` was previously called with a specified\n`location_id`. Any new calls to `FinalizeDefaultLocation` with a\n\u003cem\u003edifferent\u003c/em\u003e specified `location_id` will return a 409 error.\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an [`Operation`](../../v1beta1/operations),\nwhich can be used to track the provisioning process. The\n[`response`](../../v1beta1/operations#Operation.FIELDS.response) type of\nthe `Operation` is google.protobuf.Empty.\n\u003cbr\u003e\n\u003cbr\u003eThe `Operation` can be polled by its `name` using\nGetOperation until `done` is\ntrue. When `done` is true, the `Operation` has either succeeded or failed.\nIf the `Operation` has succeeded, its\n[`response`](../../v1beta1/operations#Operation.FIELDS.response) will be\nset to a google.protobuf.Empty; if the `Operation` has failed, its\n`error` will be set to a google.rpc.Status. The `Operation` is\nautomatically deleted after completion, so there is no need to call\nDeleteOperation.\n\u003cbr\u003e\n\u003cbr\u003eAll fields listed in the [request body](#request-body) are required.\n\u003cbr\u003e\n\u003cbr\u003eTo call `FinalizeDefaultLocation`, a member must be an Owner\nof the project.",
	//   "flatPath": "v1beta1/projects/{projectsId}/defaultLocation:finalize",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.defaultLocation.finalize",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The resource name of the Project for which the default GCP resource\nlocation will be set, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/defaultLocation:finalize",
	//   "request": {
	//     "$ref": "FinalizeDefaultLocationRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.iosApps.create":

type ProjectsIosAppsCreateCall struct {
	s          *Service
	parent     string
	iosapp     *IosApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests that a new IosApp be created.
// <br>
// <br>The result of this call is an `Operation` which can be used to
// track
// the provisioning process. The `Operation` is automatically deleted
// after
// completion, so there is no need to call `DeleteOperation`.
func (r *ProjectsIosAppsService) Create(parent string, iosapp *IosApp) *ProjectsIosAppsCreateCall {
	c := &ProjectsIosAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.iosapp = iosapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsIosAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsIosAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsIosAppsCreateCall) Context(ctx context.Context) *ProjectsIosAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsIosAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.iosapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/iosApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsIosAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Requests that a new IosApp be created.\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an `Operation` which can be used to track\nthe provisioning process. The `Operation` is automatically deleted after\ncompletion, so there is no need to call `DeleteOperation`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/iosApps",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.iosApps.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent Project in which to create an App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/iosApps",
	//   "request": {
	//     "$ref": "IosApp"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.iosApps.get":

type ProjectsIosAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the IosApp identified by the specified resource name.
func (r *ProjectsIosAppsService) Get(nameid string) *ProjectsIosAppsGetCall {
	c := &ProjectsIosAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsIosAppsGetCall) Fields(s ...googleapi.Field) *ProjectsIosAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsIosAppsGetCall) IfNoneMatch(entityTag string) *ProjectsIosAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsIosAppsGetCall) Context(ctx context.Context) *ProjectsIosAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsIosAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.get" call.
// Exactly one of *IosApp or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *IosApp.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsIosAppsGetCall) Do(opts ...googleapi.CallOption) (*IosApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &IosApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the IosApp identified by the specified resource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/iosApps/{iosAppsId}",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.iosApps.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, in the format:\n\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/iosApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/iosApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/iosApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "IosApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.iosApps.getConfig":

type ProjectsIosAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the
// specified IosApp.
func (r *ProjectsIosAppsService) GetConfig(nameid string) *ProjectsIosAppsGetConfigCall {
	c := &ProjectsIosAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsIosAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsIosAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsIosAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsIosAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsIosAppsGetConfigCall) Context(ctx context.Context) *ProjectsIosAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsIosAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.getConfig" call.
// Exactly one of *IosAppConfig or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *IosAppConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsIosAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*IosAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &IosAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the configuration artifact associated with the specified IosApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/iosApps/{iosAppsId}/config",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.iosApps.getConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the App configuration to download, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/iosApps/\u003cvar\u003eAPP_ID\u003c/var\u003e/config\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/iosApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/iosApps/[^/]+/config$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "IosAppConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.iosApps.list":

type ProjectsIosAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each IosApp associated with the specified parent
// Project.
// <br>
// <br>The elements are returned in no particular order, but will be
// a
// consistent view of the Apps when additional requests are made with
// a
// `pageToken`.
func (r *ProjectsIosAppsService) List(parent string) *ProjectsIosAppsListCall {
	c := &ProjectsIosAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Apps to return in the response.
// <br>
// <br>The server may return fewer than this at its discretion.
// If no value is specified (or too large a value is specified), the
// server
// will impose its own limit.
func (c *ProjectsIosAppsListCall) PageSize(pageSize int64) *ProjectsIosAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListIosApps` indicating where in
// the set of Apps to resume listing.
func (c *ProjectsIosAppsListCall) PageToken(pageToken string) *ProjectsIosAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsIosAppsListCall) Fields(s ...googleapi.Field) *ProjectsIosAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsIosAppsListCall) IfNoneMatch(entityTag string) *ProjectsIosAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsIosAppsListCall) Context(ctx context.Context) *ProjectsIosAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsIosAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/iosApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.list" call.
// Exactly one of *ListIosAppsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListIosAppsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsIosAppsListCall) Do(opts ...googleapi.CallOption) (*ListIosAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListIosAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists each IosApp associated with the specified parent Project.\n\u003cbr\u003e\n\u003cbr\u003eThe elements are returned in no particular order, but will be a\nconsistent view of the Apps when additional requests are made with a\n`pageToken`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/iosApps",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.iosApps.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Apps to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this at its discretion.\nIf no value is specified (or too large a value is specified), the server\nwill impose its own limit.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListIosApps` indicating where in\nthe set of Apps to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent Project for which to list Apps, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/iosApps",
	//   "response": {
	//     "$ref": "ListIosAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsIosAppsListCall) Pages(ctx context.Context, f func(*ListIosAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.iosApps.patch":

type ProjectsIosAppsPatchCall struct {
	s          *Service
	name       string
	iosapp     *IosApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the IosApp identified by the
// specified
// resource name.
func (r *ProjectsIosAppsService) Patch(name string, iosapp *IosApp) *ProjectsIosAppsPatchCall {
	c := &ProjectsIosAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.iosapp = iosapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which
// fields to update.
// <br>Note that the fields `name`, `appId`, `projectId`, and
// `bundleId`
// are all immutable.
func (c *ProjectsIosAppsPatchCall) UpdateMask(updateMask string) *ProjectsIosAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsIosAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsIosAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsIosAppsPatchCall) Context(ctx context.Context) *ProjectsIosAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsIosAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsIosAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.iosapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.iosApps.patch" call.
// Exactly one of *IosApp or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *IosApp.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsIosAppsPatchCall) Do(opts ...googleapi.CallOption) (*IosApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &IosApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the attributes of the IosApp identified by the specified\nresource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/iosApps/{iosAppsId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebase.projects.iosApps.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003eprojectId\u003c/var\u003e/iosApps/\u003cvar\u003eappId\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/iosApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Specifies which fields to update.\n\u003cbr\u003eNote that the fields `name`, `appId`, `projectId`, and `bundleId`\nare all immutable.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "IosApp"
	//   },
	//   "response": {
	//     "$ref": "IosApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.webApps.create":

type ProjectsWebAppsCreateCall struct {
	s          *Service
	parent     string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Requests that a new WebApp be created.
// <br>
// <br>The result of this call is an `Operation` which can be used to
// track
// the provisioning process. The `Operation` is automatically deleted
// after
// completion, so there is no need to call `DeleteOperation`.
func (r *ProjectsWebAppsService) Create(parent string, webapp *WebApp) *ProjectsWebAppsCreateCall {
	c := &ProjectsWebAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.webapp = webapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebAppsCreateCall) Fields(s ...googleapi.Field) *ProjectsWebAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebAppsCreateCall) Context(ctx context.Context) *ProjectsWebAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.webapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsWebAppsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Requests that a new WebApp be created.\n\u003cbr\u003e\n\u003cbr\u003eThe result of this call is an `Operation` which can be used to track\nthe provisioning process. The `Operation` is automatically deleted after\ncompletion, so there is no need to call `DeleteOperation`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/webApps",
	//   "httpMethod": "POST",
	//   "id": "firebase.projects.webApps.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "The parent Project in which to create an App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/webApps",
	//   "request": {
	//     "$ref": "WebApp"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}

// method id "firebase.projects.webApps.get":

type ProjectsWebAppsGetCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the WebApp identified by the specified resource name.
func (r *ProjectsWebAppsService) Get(nameid string) *ProjectsWebAppsGetCall {
	c := &ProjectsWebAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebAppsGetCall) Fields(s ...googleapi.Field) *ProjectsWebAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsWebAppsGetCall) IfNoneMatch(entityTag string) *ProjectsWebAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebAppsGetCall) Context(ctx context.Context) *ProjectsWebAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.get" call.
// Exactly one of *WebApp or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsWebAppsGetCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the WebApp identified by the specified resource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/webApps/{webAppsId}",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.webApps.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/webApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/webApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "WebApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.webApps.getConfig":

type ProjectsWebAppsGetConfigCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetConfig: Gets the configuration artifact associated with the
// specified WebApp.
func (r *ProjectsWebAppsService) GetConfig(nameid string) *ProjectsWebAppsGetConfigCall {
	c := &ProjectsWebAppsGetConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebAppsGetConfigCall) Fields(s ...googleapi.Field) *ProjectsWebAppsGetConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsWebAppsGetConfigCall) IfNoneMatch(entityTag string) *ProjectsWebAppsGetConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebAppsGetConfigCall) Context(ctx context.Context) *ProjectsWebAppsGetConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebAppsGetConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsGetConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.getConfig" call.
// Exactly one of *WebAppConfig or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *WebAppConfig.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsWebAppsGetConfigCall) Do(opts ...googleapi.CallOption) (*WebAppConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebAppConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the configuration artifact associated with the specified WebApp.",
	//   "flatPath": "v1beta1/projects/{projectsId}/webApps/{webAppsId}/config",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.webApps.getConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the App configuration to download, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e/webApps/\u003cvar\u003eAPP_ID\u003c/var\u003e/config\u003c/code\u003e\n\u003cbr\u003eAs an \u003cvar\u003eAPP_ID\u003c/var\u003e is a unique identifier, the Unique Resource\nfrom Sub-Collection access pattern may be used here, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/-/webApps/\u003cvar\u003eAPP_ID\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webApps/[^/]+/config$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "WebAppConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// method id "firebase.projects.webApps.list":

type ProjectsWebAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists each WebApp associated with the specified parent
// Project.
// <br>
// <br>The elements are returned in no particular order, but will be
// a
// consistent view of the Apps when additional requests are made with
// a
// `pageToken`.
func (r *ProjectsWebAppsService) List(parent string) *ProjectsWebAppsListCall {
	c := &ProjectsWebAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Apps to return in the response.
// <br>
// <br>The server may return fewer than this value at its discretion.
// If no value is specified (or too large a value is specified), then
// the
// server will impose its own limit.
func (c *ProjectsWebAppsListCall) PageSize(pageSize int64) *ProjectsWebAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token returned
// from a previous call to `ListWebApps` indicating where in
// the set of Apps to resume listing.
func (c *ProjectsWebAppsListCall) PageToken(pageToken string) *ProjectsWebAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebAppsListCall) Fields(s ...googleapi.Field) *ProjectsWebAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsWebAppsListCall) IfNoneMatch(entityTag string) *ProjectsWebAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebAppsListCall) Context(ctx context.Context) *ProjectsWebAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/webApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.list" call.
// Exactly one of *ListWebAppsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListWebAppsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsWebAppsListCall) Do(opts ...googleapi.CallOption) (*ListWebAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListWebAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists each WebApp associated with the specified parent Project.\n\u003cbr\u003e\n\u003cbr\u003eThe elements are returned in no particular order, but will be a\nconsistent view of the Apps when additional requests are made with a\n`pageToken`.",
	//   "flatPath": "v1beta1/projects/{projectsId}/webApps",
	//   "httpMethod": "GET",
	//   "id": "firebase.projects.webApps.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of Apps to return in the response.\n\u003cbr\u003e\n\u003cbr\u003eThe server may return fewer than this value at its discretion.\nIf no value is specified (or too large a value is specified), then the\nserver will impose its own limit.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token returned from a previous call to `ListWebApps` indicating where in\nthe set of Apps to resume listing.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "The parent Project for which to list Apps, in the format:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003ePROJECT_NUMBER\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/webApps",
	//   "response": {
	//     "$ref": "ListWebAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/cloud-platform.read-only",
	//     "https://www.googleapis.com/auth/firebase",
	//     "https://www.googleapis.com/auth/firebase.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsWebAppsListCall) Pages(ctx context.Context, f func(*ListWebAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "firebase.projects.webApps.patch":

type ProjectsWebAppsPatchCall struct {
	s          *Service
	name       string
	webapp     *WebApp
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates the attributes of the WebApp identified by the
// specified
// resource name.
func (r *ProjectsWebAppsService) Patch(name string, webapp *WebApp) *ProjectsWebAppsPatchCall {
	c := &ProjectsWebAppsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.webapp = webapp
	return c
}

// UpdateMask sets the optional parameter "updateMask": Specifies which
// fields to update.
// <br>Note that the fields `name`, `appId`, and `projectId` are
// all
// immutable.
func (c *ProjectsWebAppsPatchCall) UpdateMask(updateMask string) *ProjectsWebAppsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsWebAppsPatchCall) Fields(s ...googleapi.Field) *ProjectsWebAppsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsWebAppsPatchCall) Context(ctx context.Context) *ProjectsWebAppsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsWebAppsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsWebAppsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20200617")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.webapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebase.projects.webApps.patch" call.
// Exactly one of *WebApp or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *WebApp.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsWebAppsPatchCall) Do(opts ...googleapi.CallOption) (*WebApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &WebApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the attributes of the WebApp identified by the specified\nresource name.",
	//   "flatPath": "v1beta1/projects/{projectsId}/webApps/{webAppsId}",
	//   "httpMethod": "PATCH",
	//   "id": "firebase.projects.webApps.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The fully qualified resource name of the App, for example:\n\u003cbr\u003e\u003ccode\u003eprojects/\u003cvar\u003eprojectId\u003c/var\u003e/webApps/\u003cvar\u003eappId\u003c/var\u003e\u003c/code\u003e",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/webApps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Specifies which fields to update.\n\u003cbr\u003eNote that the fields `name`, `appId`, and `projectId` are all\nimmutable.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "WebApp"
	//   },
	//   "response": {
	//     "$ref": "WebApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform",
	//     "https://www.googleapis.com/auth/firebase"
	//   ]
	// }

}
