// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grafeas/v1/grafeas.proto

package grafeas

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An instance of an analysis type that has been found on a resource.
type Occurrence struct {
	// Output only. The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. A URI that represents the resource for which the
	// occurrence applies. For example,
	// `https://gcr.io/project/image@sha256:123abc` for a Docker image.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// Required. Immutable. The analysis note associated with this occurrence, in
	// the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`. This field can be
	// used as a filter in list requests.
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName,proto3" json:"note_name,omitempty"`
	// Output only. This explicitly denotes which of the occurrence details are
	// specified. This field can be used as a filter in list requests.
	Kind NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1.NoteKind" json:"kind,omitempty"`
	// A description of actions that can be taken to remedy the note.
	Remediation string `protobuf:"bytes,5,opt,name=remediation,proto3" json:"remediation,omitempty"`
	// Output only. The time this occurrence was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this occurrence was last updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Immutable. Describes the details of the note kind found on this
	// resource.
	//
	// Types that are valid to be assigned to Details:
	//	*Occurrence_Vulnerability
	//	*Occurrence_Build
	//	*Occurrence_Image
	//	*Occurrence_Package
	//	*Occurrence_Deployment
	//	*Occurrence_Discovery
	//	*Occurrence_Attestation
	Details              isOccurrence_Details `protobuf_oneof:"details"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Occurrence) Reset()         { *m = Occurrence{} }
func (m *Occurrence) String() string { return proto.CompactTextString(m) }
func (*Occurrence) ProtoMessage()    {}
func (*Occurrence) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{0}
}

func (m *Occurrence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Occurrence.Unmarshal(m, b)
}
func (m *Occurrence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Occurrence.Marshal(b, m, deterministic)
}
func (m *Occurrence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Occurrence.Merge(m, src)
}
func (m *Occurrence) XXX_Size() int {
	return xxx_messageInfo_Occurrence.Size(m)
}
func (m *Occurrence) XXX_DiscardUnknown() {
	xxx_messageInfo_Occurrence.DiscardUnknown(m)
}

var xxx_messageInfo_Occurrence proto.InternalMessageInfo

func (m *Occurrence) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Occurrence) GetResourceUri() string {
	if m != nil {
		return m.ResourceUri
	}
	return ""
}

func (m *Occurrence) GetNoteName() string {
	if m != nil {
		return m.NoteName
	}
	return ""
}

func (m *Occurrence) GetKind() NoteKind {
	if m != nil {
		return m.Kind
	}
	return NoteKind_NOTE_KIND_UNSPECIFIED
}

func (m *Occurrence) GetRemediation() string {
	if m != nil {
		return m.Remediation
	}
	return ""
}

func (m *Occurrence) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Occurrence) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

type isOccurrence_Details interface {
	isOccurrence_Details()
}

type Occurrence_Vulnerability struct {
	Vulnerability *VulnerabilityOccurrence `protobuf:"bytes,8,opt,name=vulnerability,proto3,oneof"`
}

type Occurrence_Build struct {
	Build *BuildOccurrence `protobuf:"bytes,9,opt,name=build,proto3,oneof"`
}

type Occurrence_Image struct {
	Image *ImageOccurrence `protobuf:"bytes,10,opt,name=image,proto3,oneof"`
}

type Occurrence_Package struct {
	Package *PackageOccurrence `protobuf:"bytes,11,opt,name=package,proto3,oneof"`
}

type Occurrence_Deployment struct {
	Deployment *DeploymentOccurrence `protobuf:"bytes,12,opt,name=deployment,proto3,oneof"`
}

type Occurrence_Discovery struct {
	Discovery *DiscoveryOccurrence `protobuf:"bytes,13,opt,name=discovery,proto3,oneof"`
}

type Occurrence_Attestation struct {
	Attestation *AttestationOccurrence `protobuf:"bytes,14,opt,name=attestation,proto3,oneof"`
}

func (*Occurrence_Vulnerability) isOccurrence_Details() {}

func (*Occurrence_Build) isOccurrence_Details() {}

func (*Occurrence_Image) isOccurrence_Details() {}

func (*Occurrence_Package) isOccurrence_Details() {}

func (*Occurrence_Deployment) isOccurrence_Details() {}

func (*Occurrence_Discovery) isOccurrence_Details() {}

func (*Occurrence_Attestation) isOccurrence_Details() {}

func (m *Occurrence) GetDetails() isOccurrence_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Occurrence) GetVulnerability() *VulnerabilityOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (m *Occurrence) GetBuild() *BuildOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Build); ok {
		return x.Build
	}
	return nil
}

func (m *Occurrence) GetImage() *ImageOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Image); ok {
		return x.Image
	}
	return nil
}

func (m *Occurrence) GetPackage() *PackageOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Package); ok {
		return x.Package
	}
	return nil
}

func (m *Occurrence) GetDeployment() *DeploymentOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *Occurrence) GetDiscovery() *DiscoveryOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (m *Occurrence) GetAttestation() *AttestationOccurrence {
	if x, ok := m.GetDetails().(*Occurrence_Attestation); ok {
		return x.Attestation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Occurrence) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Occurrence_Vulnerability)(nil),
		(*Occurrence_Build)(nil),
		(*Occurrence_Image)(nil),
		(*Occurrence_Package)(nil),
		(*Occurrence_Deployment)(nil),
		(*Occurrence_Discovery)(nil),
		(*Occurrence_Attestation)(nil),
	}
}

// A type of analysis that can be done for a resource.
type Note struct {
	// Output only. The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A one sentence description of this note.
	ShortDescription string `protobuf:"bytes,2,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// A detailed description of this note.
	LongDescription string `protobuf:"bytes,3,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. The type of analysis. This field can be used as a filter in
	// list requests.
	Kind NoteKind `protobuf:"varint,4,opt,name=kind,proto3,enum=grafeas.v1.NoteKind" json:"kind,omitempty"`
	// URLs associated with this note.
	RelatedUrl []*RelatedUrl `protobuf:"bytes,5,rep,name=related_url,json=relatedUrl,proto3" json:"related_url,omitempty"`
	// Time of expiration for this note. Empty if note does not expire.
	ExpirationTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The time this note was created. This field can be used as a
	// filter in list requests.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this note was last updated. This field can be used as
	// a filter in list requests.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Other notes related to this note.
	RelatedNoteNames []string `protobuf:"bytes,9,rep,name=related_note_names,json=relatedNoteNames,proto3" json:"related_note_names,omitempty"`
	// Required. Immutable. The type of analysis this note represents.
	//
	// Types that are valid to be assigned to Type:
	//	*Note_Vulnerability
	//	*Note_Build
	//	*Note_Image
	//	*Note_Package
	//	*Note_Deployment
	//	*Note_Discovery
	//	*Note_Attestation
	Type                 isNote_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Note) Reset()         { *m = Note{} }
func (m *Note) String() string { return proto.CompactTextString(m) }
func (*Note) ProtoMessage()    {}
func (*Note) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{1}
}

func (m *Note) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Note.Unmarshal(m, b)
}
func (m *Note) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Note.Marshal(b, m, deterministic)
}
func (m *Note) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Note.Merge(m, src)
}
func (m *Note) XXX_Size() int {
	return xxx_messageInfo_Note.Size(m)
}
func (m *Note) XXX_DiscardUnknown() {
	xxx_messageInfo_Note.DiscardUnknown(m)
}

var xxx_messageInfo_Note proto.InternalMessageInfo

func (m *Note) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Note) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Note) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Note) GetKind() NoteKind {
	if m != nil {
		return m.Kind
	}
	return NoteKind_NOTE_KIND_UNSPECIFIED
}

func (m *Note) GetRelatedUrl() []*RelatedUrl {
	if m != nil {
		return m.RelatedUrl
	}
	return nil
}

func (m *Note) GetExpirationTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

func (m *Note) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Note) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Note) GetRelatedNoteNames() []string {
	if m != nil {
		return m.RelatedNoteNames
	}
	return nil
}

type isNote_Type interface {
	isNote_Type()
}

type Note_Vulnerability struct {
	Vulnerability *VulnerabilityNote `protobuf:"bytes,10,opt,name=vulnerability,proto3,oneof"`
}

type Note_Build struct {
	Build *BuildNote `protobuf:"bytes,11,opt,name=build,proto3,oneof"`
}

type Note_Image struct {
	Image *ImageNote `protobuf:"bytes,12,opt,name=image,proto3,oneof"`
}

type Note_Package struct {
	Package *PackageNote `protobuf:"bytes,13,opt,name=package,proto3,oneof"`
}

type Note_Deployment struct {
	Deployment *DeploymentNote `protobuf:"bytes,14,opt,name=deployment,proto3,oneof"`
}

type Note_Discovery struct {
	Discovery *DiscoveryNote `protobuf:"bytes,15,opt,name=discovery,proto3,oneof"`
}

type Note_Attestation struct {
	Attestation *AttestationNote `protobuf:"bytes,16,opt,name=attestation,proto3,oneof"`
}

func (*Note_Vulnerability) isNote_Type() {}

func (*Note_Build) isNote_Type() {}

func (*Note_Image) isNote_Type() {}

func (*Note_Package) isNote_Type() {}

func (*Note_Deployment) isNote_Type() {}

func (*Note_Discovery) isNote_Type() {}

func (*Note_Attestation) isNote_Type() {}

func (m *Note) GetType() isNote_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Note) GetVulnerability() *VulnerabilityNote {
	if x, ok := m.GetType().(*Note_Vulnerability); ok {
		return x.Vulnerability
	}
	return nil
}

func (m *Note) GetBuild() *BuildNote {
	if x, ok := m.GetType().(*Note_Build); ok {
		return x.Build
	}
	return nil
}

func (m *Note) GetImage() *ImageNote {
	if x, ok := m.GetType().(*Note_Image); ok {
		return x.Image
	}
	return nil
}

func (m *Note) GetPackage() *PackageNote {
	if x, ok := m.GetType().(*Note_Package); ok {
		return x.Package
	}
	return nil
}

func (m *Note) GetDeployment() *DeploymentNote {
	if x, ok := m.GetType().(*Note_Deployment); ok {
		return x.Deployment
	}
	return nil
}

func (m *Note) GetDiscovery() *DiscoveryNote {
	if x, ok := m.GetType().(*Note_Discovery); ok {
		return x.Discovery
	}
	return nil
}

func (m *Note) GetAttestation() *AttestationNote {
	if x, ok := m.GetType().(*Note_Attestation); ok {
		return x.Attestation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Note) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Note_Vulnerability)(nil),
		(*Note_Build)(nil),
		(*Note_Image)(nil),
		(*Note_Package)(nil),
		(*Note_Deployment)(nil),
		(*Note_Discovery)(nil),
		(*Note_Attestation)(nil),
	}
}

// Request to get an occurrence.
type GetOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOccurrenceRequest) Reset()         { *m = GetOccurrenceRequest{} }
func (m *GetOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*GetOccurrenceRequest) ProtoMessage()    {}
func (*GetOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{2}
}

func (m *GetOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOccurrenceRequest.Unmarshal(m, b)
}
func (m *GetOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *GetOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOccurrenceRequest.Merge(m, src)
}
func (m *GetOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_GetOccurrenceRequest.Size(m)
}
func (m *GetOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOccurrenceRequest proto.InternalMessageInfo

func (m *GetOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list occurrences.
type ListOccurrencesRequest struct {
	// The name of the project to list occurrences for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list. Must be positive. Max allowed
	// page size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOccurrencesRequest) Reset()         { *m = ListOccurrencesRequest{} }
func (m *ListOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*ListOccurrencesRequest) ProtoMessage()    {}
func (*ListOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{3}
}

func (m *ListOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOccurrencesRequest.Unmarshal(m, b)
}
func (m *ListOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *ListOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOccurrencesRequest.Merge(m, src)
}
func (m *ListOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_ListOccurrencesRequest.Size(m)
}
func (m *ListOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListOccurrencesRequest proto.InternalMessageInfo

func (m *ListOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing occurrences.
type ListOccurrencesResponse struct {
	// The occurrences requested.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListOccurrencesResponse) Reset()         { *m = ListOccurrencesResponse{} }
func (m *ListOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*ListOccurrencesResponse) ProtoMessage()    {}
func (*ListOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{4}
}

func (m *ListOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListOccurrencesResponse.Unmarshal(m, b)
}
func (m *ListOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *ListOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListOccurrencesResponse.Merge(m, src)
}
func (m *ListOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_ListOccurrencesResponse.Size(m)
}
func (m *ListOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListOccurrencesResponse proto.InternalMessageInfo

func (m *ListOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a occurrence.
type DeleteOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteOccurrenceRequest) Reset()         { *m = DeleteOccurrenceRequest{} }
func (m *DeleteOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteOccurrenceRequest) ProtoMessage()    {}
func (*DeleteOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{5}
}

func (m *DeleteOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteOccurrenceRequest.Unmarshal(m, b)
}
func (m *DeleteOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteOccurrenceRequest.Merge(m, src)
}
func (m *DeleteOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteOccurrenceRequest.Size(m)
}
func (m *DeleteOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteOccurrenceRequest proto.InternalMessageInfo

func (m *DeleteOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to create a new occurrence.
type CreateOccurrenceRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrence is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrence to create.
	Occurrence           *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateOccurrenceRequest) Reset()         { *m = CreateOccurrenceRequest{} }
func (m *CreateOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateOccurrenceRequest) ProtoMessage()    {}
func (*CreateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{6}
}

func (m *CreateOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateOccurrenceRequest.Unmarshal(m, b)
}
func (m *CreateOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *CreateOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateOccurrenceRequest.Merge(m, src)
}
func (m *CreateOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateOccurrenceRequest.Size(m)
}
func (m *CreateOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateOccurrenceRequest proto.InternalMessageInfo

func (m *CreateOccurrenceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

// Request to update an occurrence.
type UpdateOccurrenceRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated occurrence.
	Occurrence *Occurrence `protobuf:"bytes,2,opt,name=occurrence,proto3" json:"occurrence,omitempty"`
	// The fields to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateOccurrenceRequest) Reset()         { *m = UpdateOccurrenceRequest{} }
func (m *UpdateOccurrenceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateOccurrenceRequest) ProtoMessage()    {}
func (*UpdateOccurrenceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{7}
}

func (m *UpdateOccurrenceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateOccurrenceRequest.Unmarshal(m, b)
}
func (m *UpdateOccurrenceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateOccurrenceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateOccurrenceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateOccurrenceRequest.Merge(m, src)
}
func (m *UpdateOccurrenceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateOccurrenceRequest.Size(m)
}
func (m *UpdateOccurrenceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateOccurrenceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateOccurrenceRequest proto.InternalMessageInfo

func (m *UpdateOccurrenceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateOccurrenceRequest) GetOccurrence() *Occurrence {
	if m != nil {
		return m.Occurrence
	}
	return nil
}

func (m *UpdateOccurrenceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to get a note.
type GetNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetNoteRequest) Reset()         { *m = GetNoteRequest{} }
func (m *GetNoteRequest) String() string { return proto.CompactTextString(m) }
func (*GetNoteRequest) ProtoMessage()    {}
func (*GetNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{8}
}

func (m *GetNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetNoteRequest.Unmarshal(m, b)
}
func (m *GetNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetNoteRequest.Marshal(b, m, deterministic)
}
func (m *GetNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetNoteRequest.Merge(m, src)
}
func (m *GetNoteRequest) XXX_Size() int {
	return xxx_messageInfo_GetNoteRequest.Size(m)
}
func (m *GetNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetNoteRequest proto.InternalMessageInfo

func (m *GetNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to get the note to which the specified occurrence is attached.
type GetOccurrenceNoteRequest struct {
	// The name of the occurrence in the form of
	// `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOccurrenceNoteRequest) Reset()         { *m = GetOccurrenceNoteRequest{} }
func (m *GetOccurrenceNoteRequest) String() string { return proto.CompactTextString(m) }
func (*GetOccurrenceNoteRequest) ProtoMessage()    {}
func (*GetOccurrenceNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{9}
}

func (m *GetOccurrenceNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Unmarshal(m, b)
}
func (m *GetOccurrenceNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Marshal(b, m, deterministic)
}
func (m *GetOccurrenceNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOccurrenceNoteRequest.Merge(m, src)
}
func (m *GetOccurrenceNoteRequest) XXX_Size() int {
	return xxx_messageInfo_GetOccurrenceNoteRequest.Size(m)
}
func (m *GetOccurrenceNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOccurrenceNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOccurrenceNoteRequest proto.InternalMessageInfo

func (m *GetOccurrenceNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list notes.
type ListNotesRequest struct {
	// The name of the project to list notes for in the form of
	// `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of notes to return in the list. Must be positive. Max allowed page
	// size is 1000. If not specified, page size defaults to 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotesRequest) Reset()         { *m = ListNotesRequest{} }
func (m *ListNotesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNotesRequest) ProtoMessage()    {}
func (*ListNotesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{10}
}

func (m *ListNotesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotesRequest.Unmarshal(m, b)
}
func (m *ListNotesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotesRequest.Marshal(b, m, deterministic)
}
func (m *ListNotesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotesRequest.Merge(m, src)
}
func (m *ListNotesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNotesRequest.Size(m)
}
func (m *ListNotesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotesRequest proto.InternalMessageInfo

func (m *ListNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListNotesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNotesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNotesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing notes.
type ListNotesResponse struct {
	// The notes requested.
	Notes []*Note `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	// The next pagination token in the list response. It should be used as
	// `page_token` for the following request. An empty value means no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNotesResponse) Reset()         { *m = ListNotesResponse{} }
func (m *ListNotesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNotesResponse) ProtoMessage()    {}
func (*ListNotesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{11}
}

func (m *ListNotesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNotesResponse.Unmarshal(m, b)
}
func (m *ListNotesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNotesResponse.Marshal(b, m, deterministic)
}
func (m *ListNotesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNotesResponse.Merge(m, src)
}
func (m *ListNotesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNotesResponse.Size(m)
}
func (m *ListNotesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNotesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNotesResponse proto.InternalMessageInfo

func (m *ListNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

func (m *ListNotesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to delete a note.
type DeleteNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteNoteRequest) Reset()         { *m = DeleteNoteRequest{} }
func (m *DeleteNoteRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteNoteRequest) ProtoMessage()    {}
func (*DeleteNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{12}
}

func (m *DeleteNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteNoteRequest.Unmarshal(m, b)
}
func (m *DeleteNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteNoteRequest.Marshal(b, m, deterministic)
}
func (m *DeleteNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteNoteRequest.Merge(m, src)
}
func (m *DeleteNoteRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteNoteRequest.Size(m)
}
func (m *DeleteNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteNoteRequest proto.InternalMessageInfo

func (m *DeleteNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to create a new note.
type CreateNoteRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the note is to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The ID to use for this note.
	NoteId string `protobuf:"bytes,2,opt,name=note_id,json=noteId,proto3" json:"note_id,omitempty"`
	// The note to create.
	Note                 *Note    `protobuf:"bytes,3,opt,name=note,proto3" json:"note,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateNoteRequest) Reset()         { *m = CreateNoteRequest{} }
func (m *CreateNoteRequest) String() string { return proto.CompactTextString(m) }
func (*CreateNoteRequest) ProtoMessage()    {}
func (*CreateNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{13}
}

func (m *CreateNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateNoteRequest.Unmarshal(m, b)
}
func (m *CreateNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateNoteRequest.Marshal(b, m, deterministic)
}
func (m *CreateNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateNoteRequest.Merge(m, src)
}
func (m *CreateNoteRequest) XXX_Size() int {
	return xxx_messageInfo_CreateNoteRequest.Size(m)
}
func (m *CreateNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateNoteRequest proto.InternalMessageInfo

func (m *CreateNoteRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateNoteRequest) GetNoteId() string {
	if m != nil {
		return m.NoteId
	}
	return ""
}

func (m *CreateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

// Request to update a note.
type UpdateNoteRequest struct {
	// The name of the note in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated note.
	Note *Note `protobuf:"bytes,2,opt,name=note,proto3" json:"note,omitempty"`
	// The fields to update.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateNoteRequest) Reset()         { *m = UpdateNoteRequest{} }
func (m *UpdateNoteRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateNoteRequest) ProtoMessage()    {}
func (*UpdateNoteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{14}
}

func (m *UpdateNoteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateNoteRequest.Unmarshal(m, b)
}
func (m *UpdateNoteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateNoteRequest.Marshal(b, m, deterministic)
}
func (m *UpdateNoteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateNoteRequest.Merge(m, src)
}
func (m *UpdateNoteRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateNoteRequest.Size(m)
}
func (m *UpdateNoteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateNoteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateNoteRequest proto.InternalMessageInfo

func (m *UpdateNoteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateNoteRequest) GetNote() *Note {
	if m != nil {
		return m.Note
	}
	return nil
}

func (m *UpdateNoteRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request to list occurrences for a note.
type ListNoteOccurrencesRequest struct {
	// The name of the note to list occurrences for in the form of
	// `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The filter expression.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of occurrences to return in the list.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNoteOccurrencesRequest) Reset()         { *m = ListNoteOccurrencesRequest{} }
func (m *ListNoteOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesRequest) ProtoMessage()    {}
func (*ListNoteOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{15}
}

func (m *ListNoteOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Unmarshal(m, b)
}
func (m *ListNoteOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *ListNoteOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNoteOccurrencesRequest.Merge(m, src)
}
func (m *ListNoteOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_ListNoteOccurrencesRequest.Size(m)
}
func (m *ListNoteOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNoteOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListNoteOccurrencesRequest proto.InternalMessageInfo

func (m *ListNoteOccurrencesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListNoteOccurrencesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListNoteOccurrencesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for listing occurrences for a note.
type ListNoteOccurrencesResponse struct {
	// The occurrences attached to the specified note.
	Occurrences []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListNoteOccurrencesResponse) Reset()         { *m = ListNoteOccurrencesResponse{} }
func (m *ListNoteOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*ListNoteOccurrencesResponse) ProtoMessage()    {}
func (*ListNoteOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{16}
}

func (m *ListNoteOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Unmarshal(m, b)
}
func (m *ListNoteOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *ListNoteOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListNoteOccurrencesResponse.Merge(m, src)
}
func (m *ListNoteOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_ListNoteOccurrencesResponse.Size(m)
}
func (m *ListNoteOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListNoteOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListNoteOccurrencesResponse proto.InternalMessageInfo

func (m *ListNoteOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func (m *ListNoteOccurrencesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to create notes in batch.
type BatchCreateNotesRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the notes are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The notes to create. Max allowed length is 1000.
	Notes                map[string]*Note `protobuf:"bytes,2,rep,name=notes,proto3" json:"notes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BatchCreateNotesRequest) Reset()         { *m = BatchCreateNotesRequest{} }
func (m *BatchCreateNotesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateNotesRequest) ProtoMessage()    {}
func (*BatchCreateNotesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{17}
}

func (m *BatchCreateNotesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateNotesRequest.Unmarshal(m, b)
}
func (m *BatchCreateNotesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateNotesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateNotesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateNotesRequest.Merge(m, src)
}
func (m *BatchCreateNotesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateNotesRequest.Size(m)
}
func (m *BatchCreateNotesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateNotesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateNotesRequest proto.InternalMessageInfo

func (m *BatchCreateNotesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateNotesRequest) GetNotes() map[string]*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

// Response for creating notes in batch.
type BatchCreateNotesResponse struct {
	// The notes that were created.
	Notes                []*Note  `protobuf:"bytes,1,rep,name=notes,proto3" json:"notes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateNotesResponse) Reset()         { *m = BatchCreateNotesResponse{} }
func (m *BatchCreateNotesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchCreateNotesResponse) ProtoMessage()    {}
func (*BatchCreateNotesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{18}
}

func (m *BatchCreateNotesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateNotesResponse.Unmarshal(m, b)
}
func (m *BatchCreateNotesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateNotesResponse.Marshal(b, m, deterministic)
}
func (m *BatchCreateNotesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateNotesResponse.Merge(m, src)
}
func (m *BatchCreateNotesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchCreateNotesResponse.Size(m)
}
func (m *BatchCreateNotesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateNotesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateNotesResponse proto.InternalMessageInfo

func (m *BatchCreateNotesResponse) GetNotes() []*Note {
	if m != nil {
		return m.Notes
	}
	return nil
}

// Request to create occurrences in batch.
type BatchCreateOccurrencesRequest struct {
	// The name of the project in the form of `projects/[PROJECT_ID]`, under which
	// the occurrences are to be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The occurrences to create. Max allowed length is 1000.
	Occurrences          []*Occurrence `protobuf:"bytes,2,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchCreateOccurrencesRequest) Reset()         { *m = BatchCreateOccurrencesRequest{} }
func (m *BatchCreateOccurrencesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateOccurrencesRequest) ProtoMessage()    {}
func (*BatchCreateOccurrencesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{19}
}

func (m *BatchCreateOccurrencesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Unmarshal(m, b)
}
func (m *BatchCreateOccurrencesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateOccurrencesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateOccurrencesRequest.Merge(m, src)
}
func (m *BatchCreateOccurrencesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateOccurrencesRequest.Size(m)
}
func (m *BatchCreateOccurrencesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateOccurrencesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateOccurrencesRequest proto.InternalMessageInfo

func (m *BatchCreateOccurrencesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateOccurrencesRequest) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

// Response for creating occurrences in batch.
type BatchCreateOccurrencesResponse struct {
	// The occurrences that were created.
	Occurrences          []*Occurrence `protobuf:"bytes,1,rep,name=occurrences,proto3" json:"occurrences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchCreateOccurrencesResponse) Reset()         { *m = BatchCreateOccurrencesResponse{} }
func (m *BatchCreateOccurrencesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchCreateOccurrencesResponse) ProtoMessage()    {}
func (*BatchCreateOccurrencesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3546117bddf8439b, []int{20}
}

func (m *BatchCreateOccurrencesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Unmarshal(m, b)
}
func (m *BatchCreateOccurrencesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Marshal(b, m, deterministic)
}
func (m *BatchCreateOccurrencesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateOccurrencesResponse.Merge(m, src)
}
func (m *BatchCreateOccurrencesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchCreateOccurrencesResponse.Size(m)
}
func (m *BatchCreateOccurrencesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateOccurrencesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateOccurrencesResponse proto.InternalMessageInfo

func (m *BatchCreateOccurrencesResponse) GetOccurrences() []*Occurrence {
	if m != nil {
		return m.Occurrences
	}
	return nil
}

func init() {
	proto.RegisterType((*Occurrence)(nil), "grafeas.v1.Occurrence")
	proto.RegisterType((*Note)(nil), "grafeas.v1.Note")
	proto.RegisterType((*GetOccurrenceRequest)(nil), "grafeas.v1.GetOccurrenceRequest")
	proto.RegisterType((*ListOccurrencesRequest)(nil), "grafeas.v1.ListOccurrencesRequest")
	proto.RegisterType((*ListOccurrencesResponse)(nil), "grafeas.v1.ListOccurrencesResponse")
	proto.RegisterType((*DeleteOccurrenceRequest)(nil), "grafeas.v1.DeleteOccurrenceRequest")
	proto.RegisterType((*CreateOccurrenceRequest)(nil), "grafeas.v1.CreateOccurrenceRequest")
	proto.RegisterType((*UpdateOccurrenceRequest)(nil), "grafeas.v1.UpdateOccurrenceRequest")
	proto.RegisterType((*GetNoteRequest)(nil), "grafeas.v1.GetNoteRequest")
	proto.RegisterType((*GetOccurrenceNoteRequest)(nil), "grafeas.v1.GetOccurrenceNoteRequest")
	proto.RegisterType((*ListNotesRequest)(nil), "grafeas.v1.ListNotesRequest")
	proto.RegisterType((*ListNotesResponse)(nil), "grafeas.v1.ListNotesResponse")
	proto.RegisterType((*DeleteNoteRequest)(nil), "grafeas.v1.DeleteNoteRequest")
	proto.RegisterType((*CreateNoteRequest)(nil), "grafeas.v1.CreateNoteRequest")
	proto.RegisterType((*UpdateNoteRequest)(nil), "grafeas.v1.UpdateNoteRequest")
	proto.RegisterType((*ListNoteOccurrencesRequest)(nil), "grafeas.v1.ListNoteOccurrencesRequest")
	proto.RegisterType((*ListNoteOccurrencesResponse)(nil), "grafeas.v1.ListNoteOccurrencesResponse")
	proto.RegisterType((*BatchCreateNotesRequest)(nil), "grafeas.v1.BatchCreateNotesRequest")
	proto.RegisterMapType((map[string]*Note)(nil), "grafeas.v1.BatchCreateNotesRequest.NotesEntry")
	proto.RegisterType((*BatchCreateNotesResponse)(nil), "grafeas.v1.BatchCreateNotesResponse")
	proto.RegisterType((*BatchCreateOccurrencesRequest)(nil), "grafeas.v1.BatchCreateOccurrencesRequest")
	proto.RegisterType((*BatchCreateOccurrencesResponse)(nil), "grafeas.v1.BatchCreateOccurrencesResponse")
}

func init() { proto.RegisterFile("grafeas/v1/grafeas.proto", fileDescriptor_3546117bddf8439b) }

var fileDescriptor_3546117bddf8439b = []byte{
	// 1580 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x4b, 0x73, 0xd3, 0xd6,
	0x17, 0xff, 0xcb, 0x79, 0x38, 0x3e, 0x26, 0x89, 0x73, 0xff, 0x34, 0x56, 0x1d, 0x02, 0x46, 0x09,
	0x90, 0x98, 0x62, 0x4f, 0x02, 0x53, 0x20, 0xb4, 0xc3, 0x10, 0x92, 0xa6, 0x94, 0x96, 0x52, 0x17,
	0xba, 0x60, 0x51, 0x8f, 0x62, 0xdf, 0x18, 0x25, 0xb2, 0x24, 0x24, 0xd9, 0x83, 0xa1, 0xd0, 0x99,
	0x0e, 0x33, 0xed, 0x74, 0x4b, 0x37, 0xdd, 0xb2, 0xed, 0xc7, 0xe8, 0x47, 0xe8, 0xbe, 0xab, 0xee,
	0xfb, 0x15, 0x3a, 0xf7, 0x21, 0xeb, 0x5e, 0x3d, 0x6c, 0xd3, 0x4c, 0xdb, 0x9d, 0x7c, 0xcf, 0xf3,
	0x9e, 0xf3, 0xfb, 0xdd, 0x73, 0x12, 0x50, 0xdb, 0xae, 0x7e, 0x80, 0x75, 0xaf, 0xd6, 0xdb, 0xa8,
	0xf1, 0xcf, 0xaa, 0xe3, 0xda, 0xbe, 0x8d, 0x20, 0xf8, 0xd9, 0xdb, 0x28, 0x9d, 0x6a, 0xdb, 0x76,
	0xdb, 0xc4, 0x35, 0xdd, 0x31, 0x6a, 0xba, 0x65, 0xd9, 0xbe, 0xee, 0x1b, 0xb6, 0xc5, 0x35, 0x4b,
	0x4b, 0x5c, 0x4a, 0x7f, 0xed, 0x77, 0x0f, 0x6a, 0xb8, 0xe3, 0xf8, 0x7d, 0x2e, 0x2c, 0x47, 0x85,
	0x07, 0x06, 0x36, 0x5b, 0x8d, 0x8e, 0xee, 0x1d, 0x71, 0x8d, 0x33, 0x51, 0x0d, 0xdf, 0xe8, 0x60,
	0xcf, 0xd7, 0x3b, 0x0e, 0x57, 0x38, 0x25, 0xe4, 0xa8, 0xfb, 0x3e, 0x91, 0x91, 0xf0, 0x5c, 0xba,
	0x28, 0x48, 0xf7, 0xbb, 0x86, 0xd9, 0xe2, 0xe7, 0x45, 0xe1, 0xbc, 0x69, 0x77, 0x3a, 0x03, 0x83,
	0x25, 0x41, 0xd0, 0xc2, 0x8e, 0x69, 0xf7, 0x3b, 0xd8, 0xf2, 0xb9, 0xb0, 0x24, 0x0a, 0x0d, 0xaf,
	0x69, 0xf7, 0xb0, 0xdb, 0x4f, 0x88, 0x64, 0x74, 0xf4, 0x36, 0xe6, 0xe7, 0x62, 0x0d, 0x1d, 0xbd,
	0x79, 0x14, 0x4a, 0xc4, 0x50, 0x8e, 0x6b, 0xf7, 0xb0, 0xa5, 0x5b, 0xcd, 0x40, 0x78, 0x5a, 0x10,
	0xf6, 0xba, 0xa6, 0x85, 0x5d, 0x7d, 0xdf, 0x30, 0x8d, 0xa0, 0x72, 0xda, 0x9f, 0x53, 0x00, 0x9f,
	0x37, 0x9b, 0x5d, 0xd7, 0xc5, 0x56, 0x13, 0x23, 0x04, 0x93, 0x96, 0xde, 0xc1, 0xaa, 0x52, 0x56,
	0xd6, 0x72, 0x75, 0xfa, 0x8d, 0xce, 0xc2, 0x09, 0x17, 0x7b, 0x76, 0xd7, 0x6d, 0xe2, 0x46, 0xd7,
	0x35, 0xd4, 0x0c, 0x95, 0xe5, 0x83, 0xb3, 0x87, 0xae, 0x81, 0x96, 0x20, 0x67, 0xd9, 0x3e, 0x6e,
	0x50, 0xdb, 0x09, 0x2a, 0x9f, 0x21, 0x07, 0xf7, 0x88, 0xfd, 0x1a, 0x4c, 0x1e, 0x19, 0x56, 0x4b,
	0x9d, 0x2c, 0x2b, 0x6b, 0x73, 0x9b, 0x27, 0xab, 0x61, 0xcb, 0xab, 0xf7, 0x6c, 0x1f, 0xdf, 0x35,
	0xac, 0x56, 0x9d, 0x6a, 0xa0, 0x32, 0xe4, 0x5d, 0xdc, 0xc1, 0x2d, 0x83, 0x96, 0x5e, 0x9d, 0x0a,
	0x02, 0x0d, 0x8e, 0xd0, 0x0d, 0xc8, 0x37, 0x5d, 0xac, 0xfb, 0xb8, 0x41, 0xfa, 0xa7, 0x4e, 0x97,
	0x95, 0xb5, 0xfc, 0x66, 0xa9, 0xca, 0x9a, 0x5b, 0x0d, 0x9a, 0x5b, 0x7d, 0x10, 0x34, 0xb7, 0x0e,
	0x4c, 0x9d, 0x1c, 0x10, 0xe3, 0xae, 0xd3, 0x1a, 0x18, 0x67, 0x47, 0x1b, 0x33, 0x75, 0x6a, 0x7c,
	0x17, 0x66, 0xa5, 0xfa, 0xa9, 0x33, 0xd4, 0x7c, 0x45, 0xbc, 0xce, 0x57, 0xa2, 0x42, 0x58, 0xd5,
	0x8f, 0xff, 0x57, 0x97, 0x6d, 0xd1, 0x65, 0x98, 0xa2, 0x28, 0x52, 0x73, 0xd4, 0xc9, 0x92, 0xe8,
	0x64, 0x9b, 0x08, 0x24, 0x63, 0xa6, 0x4b, 0x8c, 0x28, 0x20, 0x54, 0x88, 0x1b, 0xdd, 0x21, 0x02,
	0xd9, 0x88, 0xea, 0xa2, 0xeb, 0x90, 0xe5, 0x68, 0x51, 0xf3, 0xd4, 0x6c, 0x59, 0x34, 0xbb, 0xcf,
	0x44, 0x92, 0x61, 0xa0, 0x8f, 0xb6, 0x01, 0x42, 0xe4, 0xaa, 0x27, 0xa8, 0x75, 0x59, 0xb4, 0xde,
	0x19, 0x48, 0x25, 0x07, 0x82, 0x15, 0xba, 0x09, 0xb9, 0x01, 0xc0, 0xd5, 0x59, 0xea, 0xe2, 0x8c,
	0xe4, 0x22, 0x10, 0x4a, 0x1e, 0x42, 0x1b, 0xb4, 0x0b, 0x79, 0x81, 0x8d, 0xea, 0x1c, 0x75, 0x71,
	0x56, 0x74, 0x71, 0x2b, 0x14, 0x4b, 0x4e, 0x44, 0xbb, 0xed, 0x1c, 0x64, 0x5b, 0xd8, 0xd7, 0x0d,
	0xd3, 0xd3, 0x7e, 0x9f, 0x86, 0x49, 0x82, 0xbb, 0x44, 0xac, 0x5f, 0x84, 0x05, 0xef, 0xb1, 0xed,
	0xfa, 0x8d, 0x16, 0xf6, 0x9a, 0xae, 0xe1, 0xd0, 0xa0, 0x0c, 0xf0, 0x05, 0x2a, 0xd8, 0x09, 0xcf,
	0xd1, 0x3a, 0x14, 0x4c, 0xdb, 0x6a, 0x4b, 0xba, 0x0c, 0xfc, 0xf3, 0xe4, 0x5c, 0x54, 0x1d, 0x9f,
	0x03, 0x57, 0x09, 0x07, 0x4c, 0xdd, 0xc7, 0xad, 0x46, 0xd7, 0x35, 0xd5, 0xa9, 0xf2, 0xc4, 0x5a,
	0x7e, 0x73, 0x51, 0x34, 0xa8, 0x33, 0xf1, 0x43, 0xd7, 0xac, 0x83, 0x3b, 0xf8, 0x46, 0xb7, 0x61,
	0x1e, 0x3f, 0x75, 0x0c, 0x97, 0x5e, 0x78, 0x5c, 0x7a, 0xcc, 0x85, 0x26, 0x01, 0x45, 0x44, 0x7e,
	0x65, 0x8f, 0xc3, 0xaf, 0x99, 0xb7, 0xe2, 0xd7, 0x7b, 0x80, 0x82, 0x7b, 0x0f, 0x9e, 0x12, 0x4f,
	0xcd, 0x95, 0x27, 0x48, 0xe9, 0xb9, 0xe4, 0x1e, 0x7f, 0x52, 0x3c, 0xb4, 0x1b, 0x65, 0x23, 0xc4,
	0xc1, 0x2d, 0xb1, 0x91, 0x98, 0xc6, 0x79, 0x78, 0x29, 0xe0, 0x21, 0xe3, 0xc6, 0x3b, 0x31, 0x1e,
	0x72, 0x33, 0xce, 0xc0, 0x4b, 0x01, 0x03, 0x4f, 0xc4, 0xd5, 0x29, 0x03, 0x03, 0x75, 0xc6, 0xbd,
	0xcb, 0x21, 0xf7, 0x18, 0xf4, 0x8b, 0x09, 0xdc, 0xe3, 0x26, 0x03, 0xd6, 0x7d, 0x20, 0xb1, 0x6e,
	0x2e, 0xa8, 0x61, 0x12, 0xeb, 0xb8, 0xa9, 0xc8, 0xb7, 0xeb, 0x22, 0xdf, 0xe6, 0xa9, 0xf1, 0xbb,
	0x89, 0x7c, 0xe3, 0xb6, 0x02, 0xd3, 0x6e, 0xca, 0x4c, 0x2b, 0xc4, 0x1f, 0x19, 0x81, 0x69, 0xdc,
	0x5c, 0xe2, 0xd8, 0x34, 0x4c, 0xfa, 0x7d, 0x07, 0x6b, 0x15, 0x38, 0xb9, 0x87, 0x85, 0x27, 0xa1,
	0x8e, 0x9f, 0x74, 0xb1, 0xe7, 0x27, 0xf1, 0x4d, 0x7b, 0xa5, 0xc0, 0xe2, 0xa7, 0x86, 0x27, 0x68,
	0x7b, 0x81, 0xfa, 0x22, 0x4c, 0x3b, 0xba, 0x4b, 0x8a, 0xc0, 0x0c, 0xf8, 0x2f, 0x72, 0x7e, 0x60,
	0x98, 0x3e, 0x76, 0x39, 0x2f, 0xf9, 0x2f, 0x32, 0x83, 0x1c, 0xbd, 0x8d, 0x1b, 0x9e, 0xf1, 0x8c,
	0xcd, 0xa0, 0xa9, 0xfa, 0x0c, 0x39, 0xf8, 0xd2, 0x78, 0x86, 0xd1, 0x32, 0x00, 0x15, 0xfa, 0xf6,
	0x11, 0xb6, 0x28, 0x0b, 0x73, 0x75, 0xaa, 0xfe, 0x80, 0x1c, 0x68, 0xcf, 0xa1, 0x18, 0xcb, 0xc2,
	0x73, 0x6c, 0xcb, 0xc3, 0xe8, 0x1a, 0xe4, 0xed, 0xf0, 0x58, 0x55, 0xe2, 0x7c, 0x14, 0x6e, 0x2a,
	0xaa, 0xa2, 0xf3, 0x30, 0x6f, 0xe1, 0xa7, 0x7e, 0x43, 0x08, 0xcc, 0x32, 0x9e, 0x25, 0xc7, 0xf7,
	0x07, 0xc1, 0x2f, 0x41, 0x71, 0x07, 0x9b, 0xd8, 0xc7, 0xe3, 0x95, 0xcc, 0x80, 0xe2, 0x6d, 0xca,
	0xb9, 0xb8, 0x7a, 0x5a, 0xc9, 0xde, 0x07, 0x08, 0x13, 0xa3, 0x49, 0xa4, 0x5f, 0x41, 0xd0, 0xd4,
	0xde, 0x28, 0x50, 0x7c, 0x48, 0x29, 0x3a, 0x56, 0x6a, 0x7f, 0x37, 0x8e, 0xf0, 0x70, 0x90, 0x8d,
	0x8d, 0x36, 0x2f, 0xe9, 0xe1, 0xf8, 0x88, 0x2c, 0x75, 0x9f, 0xe9, 0xde, 0x51, 0xf0, 0x70, 0x90,
	0x6f, 0x6d, 0x15, 0xe6, 0xf6, 0x30, 0xe5, 0xc2, 0xb0, 0xaa, 0x55, 0x41, 0x95, 0x40, 0x39, 0x4a,
	0xff, 0x25, 0x14, 0x08, 0x22, 0x88, 0xda, 0x7f, 0x82, 0xc8, 0x26, 0x2c, 0x08, 0xf1, 0x39, 0x16,
	0xcf, 0xc3, 0x14, 0x79, 0x1b, 0x03, 0x14, 0x16, 0xa2, 0x63, 0xa4, 0xce, 0xc4, 0x63, 0x23, 0xef,
	0x02, 0x2c, 0x30, 0xe4, 0x8d, 0xaa, 0xc6, 0x21, 0x2c, 0x30, 0xcc, 0x89, 0x8a, 0x69, 0xe5, 0x28,
	0x42, 0x96, 0xbe, 0xe0, 0x46, 0x2b, 0xa8, 0x07, 0xf9, 0x79, 0xa7, 0x85, 0x56, 0x61, 0x92, 0x7c,
	0xf1, 0xfe, 0xc6, 0xb3, 0xa7, 0x52, 0xed, 0x47, 0x05, 0x16, 0x18, 0xe8, 0x46, 0x64, 0x35, 0xf0,
	0x97, 0x19, 0xe6, 0xef, 0x78, 0xe0, 0x7a, 0xa5, 0x40, 0x29, 0xe8, 0x43, 0xc2, 0x1b, 0x95, 0x94,
	0xd5, 0x3f, 0x81, 0x86, 0x6f, 0x61, 0x29, 0x31, 0x8b, 0x7f, 0xed, 0x8d, 0xfa, 0x55, 0x81, 0xe2,
	0xb6, 0xee, 0x37, 0x1f, 0x87, 0x30, 0x18, 0x49, 0x8b, 0x9d, 0x00, 0xad, 0x19, 0x9a, 0x4f, 0x55,
	0x1a, 0xae, 0xc9, 0xbe, 0x68, 0xdf, 0xbc, 0x5d, 0xcb, 0x77, 0xfb, 0x1c, 0xcb, 0xa5, 0x4f, 0x00,
	0xc2, 0x43, 0x54, 0x80, 0x89, 0x23, 0xdc, 0xe7, 0x81, 0xc8, 0x27, 0xe1, 0x44, 0x4f, 0x37, 0xbb,
	0xe9, 0x28, 0x60, 0xe2, 0xad, 0xcc, 0x35, 0x45, 0xdb, 0x06, 0x35, 0x1e, 0xf8, 0xed, 0xb8, 0xa5,
	0x3d, 0x81, 0x65, 0xc1, 0xc7, 0x5b, 0xcc, 0xad, 0x48, 0x93, 0x32, 0x63, 0x37, 0x49, 0x7b, 0x04,
	0xa7, 0xd3, 0x42, 0x1e, 0x17, 0x00, 0x9b, 0x3f, 0xcd, 0x41, 0x76, 0x8f, 0xa9, 0xa1, 0x1e, 0xcc,
	0x4a, 0x6f, 0x24, 0x92, 0xb6, 0xfd, 0xa4, 0x99, 0x5e, 0x4a, 0x89, 0xa1, 0x5d, 0xfc, 0xee, 0xb7,
	0x3f, 0x5e, 0x67, 0xce, 0xa1, 0x15, 0xf2, 0x77, 0xe7, 0x73, 0xc2, 0x8b, 0x0f, 0x1d, 0xd7, 0x3e,
	0xc4, 0x4d, 0xdf, 0xab, 0x55, 0x6a, 0x42, 0x02, 0xb5, 0xca, 0x0b, 0xf4, 0xbd, 0x02, 0xf3, 0x91,
	0xf1, 0x8b, 0x34, 0xd1, 0x71, 0xf2, 0x86, 0x50, 0x5a, 0x19, 0xaa, 0xc3, 0x4a, 0x13, 0xc9, 0x84,
	0xf5, 0x42, 0xc8, 0xe5, 0x85, 0x98, 0x0c, 0xfa, 0x06, 0x0a, 0xd1, 0x51, 0x8c, 0x56, 0xe4, 0xe5,
	0x2b, 0x71, 0x50, 0x93, 0x3a, 0x44, 0xde, 0x93, 0xdd, 0x8e, 0xe3, 0xf7, 0x83, 0xe8, 0x95, 0xb1,
	0xea, 0xf0, 0x83, 0x02, 0x85, 0x68, 0x8f, 0xe5, 0xf0, 0x29, 0x83, 0x3f, 0xb5, 0x0d, 0x57, 0x69,
	0xf8, 0x0d, 0x6d, 0x9c, 0xcb, 0x6f, 0x89, 0x13, 0xf9, 0x17, 0x05, 0x16, 0x93, 0x31, 0x87, 0xd6,
	0x53, 0x78, 0x9c, 0xd0, 0xa0, 0xca, 0x38, 0xaa, 0xbc, 0x4f, 0x5b, 0x34, 0xd5, 0x2b, 0x5a, 0x6d,
	0x9c, 0x54, 0xf7, 0x43, 0x5f, 0x5b, 0x4a, 0x85, 0x16, 0x2e, 0xba, 0xa7, 0xc8, 0x85, 0x4b, 0xd9,
	0x62, 0x46, 0x15, 0x6e, 0x73, 0x9c, 0xbe, 0x49, 0x85, 0x7b, 0x09, 0x0b, 0xb1, 0x3d, 0x03, 0xad,
	0xa6, 0xf2, 0x48, 0x18, 0x71, 0xa5, 0xd8, 0x93, 0xa3, 0x6d, 0xd0, 0x2c, 0x2e, 0xa2, 0xf5, 0x31,
	0xb2, 0xa8, 0xb1, 0xd1, 0xff, 0x35, 0x64, 0xf9, 0x36, 0x84, 0x4a, 0x91, 0xa8, 0xc3, 0x63, 0x9d,
	0xa3, 0xb1, 0xce, 0xa0, 0xe5, 0xc4, 0x58, 0xd4, 0x39, 0xc1, 0xa8, 0x0d, 0xb9, 0xc1, 0x5e, 0x82,
	0x4e, 0x45, 0x09, 0x28, 0xbe, 0xe5, 0xa5, 0xe5, 0x14, 0x29, 0x6f, 0xb8, 0x1c, 0x30, 0xa1, 0xe1,
	0xec, 0x42, 0x87, 0x00, 0xe1, 0x8e, 0x82, 0x96, 0xe3, 0x64, 0x14, 0xaf, 0x95, 0x46, 0x43, 0x1e,
	0xab, 0x32, 0xe2, 0x72, 0x87, 0x00, 0xe1, 0x68, 0x90, 0x63, 0xc5, 0xd6, 0x9f, 0x84, 0x12, 0x72,
	0xb2, 0x6b, 0xc3, 0x6f, 0xb4, 0xc5, 0xd6, 0x92, 0xd7, 0x0a, 0x14, 0xa2, 0xc3, 0x48, 0xc6, 0x6c,
	0xca, 0x8c, 0x2c, 0xad, 0x0e, 0x57, 0xe2, 0xe5, 0xbd, 0x42, 0x93, 0xa9, 0x6a, 0xeb, 0xc3, 0x93,
	0x89, 0x30, 0xe9, 0x10, 0x20, 0xdc, 0xbd, 0xe4, 0x0a, 0xc4, 0x76, 0xb2, 0xf4, 0x0a, 0x6c, 0x0e,
	0xaf, 0x33, 0xaf, 0xc0, 0xcf, 0x0a, 0xfc, 0x3f, 0x61, 0xab, 0x41, 0xe7, 0x93, 0x70, 0x93, 0xf0,
	0xba, 0x5c, 0x18, 0xa9, 0xc7, 0x4b, 0x31, 0x9c, 0x46, 0x41, 0x56, 0x22, 0x9f, 0xb6, 0xbf, 0x80,
	0x59, 0xc3, 0x16, 0xfc, 0xdf, 0x57, 0x1e, 0x5d, 0xe3, 0xd0, 0x6a, 0xdb, 0xa6, 0x6e, 0xb5, 0xab,
	0xb6, 0xdb, 0xae, 0xb5, 0xb1, 0x45, 0x81, 0x56, 0x63, 0x22, 0xdd, 0x31, 0xbc, 0x5a, 0xf8, 0xff,
	0xd6, 0x1b, 0xfc, 0xf3, 0x4d, 0x66, 0x62, 0xaf, 0x7e, 0x6b, 0x7f, 0x9a, 0xaa, 0x5e, 0xfe, 0x2b,
	0x00, 0x00, 0xff, 0xff, 0x5a, 0x64, 0xc4, 0x3a, 0x0d, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GrafeasClient is the client API for Grafeas service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GrafeasClient interface {
	// Gets the specified occurrence.
	GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Gets the specified note.
	GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error)
}

type grafeasClient struct {
	cc *grpc.ClientConn
}

func NewGrafeasClient(cc *grpc.ClientConn) GrafeasClient {
	return &grafeasClient{cc}
}

func (c *grafeasClient) GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error) {
	out := new(ListOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/DeleteOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/CreateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error) {
	out := new(BatchCreateOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/BatchCreateOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/UpdateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetOccurrenceNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error) {
	out := new(ListNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/DeleteNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/CreateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error) {
	out := new(BatchCreateNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/BatchCreateNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/UpdateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error) {
	out := new(ListNoteOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListNoteOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GrafeasServer is the server API for Grafeas service.
type GrafeasServer interface {
	// Gets the specified occurrence.
	GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(context.Context, *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error)
	// Gets the specified note.
	GetNote(context.Context, *GetNoteRequest) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(context.Context, *DeleteNoteRequest) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(context.Context, *CreateNoteRequest) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(context.Context, *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error)
}

// UnimplementedGrafeasServer can be embedded to have forward compatible implementations.
type UnimplementedGrafeasServer struct {
}

func (*UnimplementedGrafeasServer) GetOccurrence(ctx context.Context, req *GetOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrence not implemented")
}
func (*UnimplementedGrafeasServer) ListOccurrences(ctx context.Context, req *ListOccurrencesRequest) (*ListOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOccurrences not implemented")
}
func (*UnimplementedGrafeasServer) DeleteOccurrence(ctx context.Context, req *DeleteOccurrenceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOccurrence not implemented")
}
func (*UnimplementedGrafeasServer) CreateOccurrence(ctx context.Context, req *CreateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOccurrence not implemented")
}
func (*UnimplementedGrafeasServer) BatchCreateOccurrences(ctx context.Context, req *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateOccurrences not implemented")
}
func (*UnimplementedGrafeasServer) UpdateOccurrence(ctx context.Context, req *UpdateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOccurrence not implemented")
}
func (*UnimplementedGrafeasServer) GetOccurrenceNote(ctx context.Context, req *GetOccurrenceNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrenceNote not implemented")
}
func (*UnimplementedGrafeasServer) GetNote(ctx context.Context, req *GetNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNote not implemented")
}
func (*UnimplementedGrafeasServer) ListNotes(ctx context.Context, req *ListNotesRequest) (*ListNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotes not implemented")
}
func (*UnimplementedGrafeasServer) DeleteNote(ctx context.Context, req *DeleteNoteRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNote not implemented")
}
func (*UnimplementedGrafeasServer) CreateNote(ctx context.Context, req *CreateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNote not implemented")
}
func (*UnimplementedGrafeasServer) BatchCreateNotes(ctx context.Context, req *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateNotes not implemented")
}
func (*UnimplementedGrafeasServer) UpdateNote(ctx context.Context, req *UpdateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNote not implemented")
}
func (*UnimplementedGrafeasServer) ListNoteOccurrences(ctx context.Context, req *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNoteOccurrences not implemented")
}

func RegisterGrafeasServer(s *grpc.Server, srv GrafeasServer) {
	s.RegisterService(&_Grafeas_serviceDesc, srv)
}

func _Grafeas_GetOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetOccurrence(ctx, req.(*GetOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListOccurrences(ctx, req.(*ListOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_DeleteOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).DeleteOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/DeleteOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).DeleteOccurrence(ctx, req.(*DeleteOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_CreateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).CreateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/CreateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).CreateOccurrence(ctx, req.(*CreateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_BatchCreateOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).BatchCreateOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/BatchCreateOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).BatchCreateOccurrences(ctx, req.(*BatchCreateOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_UpdateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).UpdateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/UpdateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).UpdateOccurrence(ctx, req.(*UpdateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_GetOccurrenceNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetOccurrenceNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetOccurrenceNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetOccurrenceNote(ctx, req.(*GetOccurrenceNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_GetNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetNote(ctx, req.(*GetNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListNotes(ctx, req.(*ListNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_DeleteNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).DeleteNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/DeleteNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).DeleteNote(ctx, req.(*DeleteNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_CreateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).CreateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/CreateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).CreateNote(ctx, req.(*CreateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_BatchCreateNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).BatchCreateNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/BatchCreateNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).BatchCreateNotes(ctx, req.(*BatchCreateNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_UpdateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).UpdateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/UpdateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).UpdateNote(ctx, req.(*UpdateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListNoteOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNoteOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListNoteOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListNoteOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListNoteOccurrences(ctx, req.(*ListNoteOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Grafeas_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grafeas.v1.Grafeas",
	HandlerType: (*GrafeasServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOccurrence",
			Handler:    _Grafeas_GetOccurrence_Handler,
		},
		{
			MethodName: "ListOccurrences",
			Handler:    _Grafeas_ListOccurrences_Handler,
		},
		{
			MethodName: "DeleteOccurrence",
			Handler:    _Grafeas_DeleteOccurrence_Handler,
		},
		{
			MethodName: "CreateOccurrence",
			Handler:    _Grafeas_CreateOccurrence_Handler,
		},
		{
			MethodName: "BatchCreateOccurrences",
			Handler:    _Grafeas_BatchCreateOccurrences_Handler,
		},
		{
			MethodName: "UpdateOccurrence",
			Handler:    _Grafeas_UpdateOccurrence_Handler,
		},
		{
			MethodName: "GetOccurrenceNote",
			Handler:    _Grafeas_GetOccurrenceNote_Handler,
		},
		{
			MethodName: "GetNote",
			Handler:    _Grafeas_GetNote_Handler,
		},
		{
			MethodName: "ListNotes",
			Handler:    _Grafeas_ListNotes_Handler,
		},
		{
			MethodName: "DeleteNote",
			Handler:    _Grafeas_DeleteNote_Handler,
		},
		{
			MethodName: "CreateNote",
			Handler:    _Grafeas_CreateNote_Handler,
		},
		{
			MethodName: "BatchCreateNotes",
			Handler:    _Grafeas_BatchCreateNotes_Handler,
		},
		{
			MethodName: "UpdateNote",
			Handler:    _Grafeas_UpdateNote_Handler,
		},
		{
			MethodName: "ListNoteOccurrences",
			Handler:    _Grafeas_ListNoteOccurrences_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "grafeas/v1/grafeas.proto",
}
