// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.12.2
// source: google/cloud/datastream/v1alpha1/datastream_resources.proto

package datastream

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// File format in Cloud Storage.
//
// Deprecated: Do not use.
type GcsFileFormat int32

const (
	// Unspecified Cloud Storage file format.
	GcsFileFormat_GCS_FILE_FORMAT_UNSPECIFIED GcsFileFormat = 0
	// Avro file format
	GcsFileFormat_AVRO GcsFileFormat = 1
)

// Enum value maps for GcsFileFormat.
var (
	GcsFileFormat_name = map[int32]string{
		0: "GCS_FILE_FORMAT_UNSPECIFIED",
		1: "AVRO",
	}
	GcsFileFormat_value = map[string]int32{
		"GCS_FILE_FORMAT_UNSPECIFIED": 0,
		"AVRO":                        1,
	}
)

func (x GcsFileFormat) Enum() *GcsFileFormat {
	p := new(GcsFileFormat)
	*p = x
	return p
}

func (x GcsFileFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GcsFileFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[0].Descriptor()
}

func (GcsFileFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[0]
}

func (x GcsFileFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GcsFileFormat.Descriptor instead.
func (GcsFileFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{0}
}

// Schema file format.
type SchemaFileFormat int32

const (
	// Unspecified schema file format.
	SchemaFileFormat_SCHEMA_FILE_FORMAT_UNSPECIFIED SchemaFileFormat = 0
	// Do not attach schema file.
	SchemaFileFormat_NO_SCHEMA_FILE SchemaFileFormat = 1
	// Avro schema format.
	SchemaFileFormat_AVRO_SCHEMA_FILE SchemaFileFormat = 2
)

// Enum value maps for SchemaFileFormat.
var (
	SchemaFileFormat_name = map[int32]string{
		0: "SCHEMA_FILE_FORMAT_UNSPECIFIED",
		1: "NO_SCHEMA_FILE",
		2: "AVRO_SCHEMA_FILE",
	}
	SchemaFileFormat_value = map[string]int32{
		"SCHEMA_FILE_FORMAT_UNSPECIFIED": 0,
		"NO_SCHEMA_FILE":                 1,
		"AVRO_SCHEMA_FILE":               2,
	}
)

func (x SchemaFileFormat) Enum() *SchemaFileFormat {
	p := new(SchemaFileFormat)
	*p = x
	return p
}

func (x SchemaFileFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchemaFileFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[1].Descriptor()
}

func (SchemaFileFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[1]
}

func (x SchemaFileFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchemaFileFormat.Descriptor instead.
func (SchemaFileFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{1}
}

// Private Connection state.
type PrivateConnection_State int32

const (
	PrivateConnection_STATE_UNSPECIFIED PrivateConnection_State = 0
	// The private connection is in creation state - creating resources.
	PrivateConnection_CREATING PrivateConnection_State = 1
	// The private connection has been created with all of it's resources.
	PrivateConnection_CREATED PrivateConnection_State = 2
	// The private connection creation has failed.
	PrivateConnection_FAILED PrivateConnection_State = 3
)

// Enum value maps for PrivateConnection_State.
var (
	PrivateConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "FAILED",
	}
	PrivateConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"FAILED":            3,
	}
)

func (x PrivateConnection_State) Enum() *PrivateConnection_State {
	p := new(PrivateConnection_State)
	*p = x
	return p
}

func (x PrivateConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[2].Descriptor()
}

func (PrivateConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[2]
}

func (x PrivateConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateConnection_State.Descriptor instead.
func (PrivateConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{7, 0}
}

// Json file compression.
type JsonFileFormat_JsonCompression int32

const (
	// Unspecified json file compression.
	JsonFileFormat_JSON_COMPRESSION_UNSPECIFIED JsonFileFormat_JsonCompression = 0
	// Do not compress JSON file.
	JsonFileFormat_NO_COMPRESSION JsonFileFormat_JsonCompression = 1
	// Gzip compression.
	JsonFileFormat_GZIP JsonFileFormat_JsonCompression = 2
)

// Enum value maps for JsonFileFormat_JsonCompression.
var (
	JsonFileFormat_JsonCompression_name = map[int32]string{
		0: "JSON_COMPRESSION_UNSPECIFIED",
		1: "NO_COMPRESSION",
		2: "GZIP",
	}
	JsonFileFormat_JsonCompression_value = map[string]int32{
		"JSON_COMPRESSION_UNSPECIFIED": 0,
		"NO_COMPRESSION":               1,
		"GZIP":                         2,
	}
)

func (x JsonFileFormat_JsonCompression) Enum() *JsonFileFormat_JsonCompression {
	p := new(JsonFileFormat_JsonCompression)
	*p = x
	return p
}

func (x JsonFileFormat_JsonCompression) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JsonFileFormat_JsonCompression) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[3].Descriptor()
}

func (JsonFileFormat_JsonCompression) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[3]
}

func (x JsonFileFormat_JsonCompression) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JsonFileFormat_JsonCompression.Descriptor instead.
func (JsonFileFormat_JsonCompression) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{24, 0}
}

// Stream state.
type Stream_State int32

const (
	// Unspecified stream state.
	Stream_STATE_UNSPECIFIED Stream_State = 0
	// The stream has been created.
	Stream_CREATED Stream_State = 1
	// The stream is running.
	Stream_RUNNING Stream_State = 2
	// The stream is paused.
	Stream_PAUSED Stream_State = 3
	// The stream is in maintenance mode.
	//
	// Updates are rejected on the resource in this state.
	Stream_MAINTENANCE Stream_State = 4
	// The stream is experiencing an error that is preventing data from being
	// streamed.
	Stream_FAILED Stream_State = 5
	// The stream has experienced a terminal failure.
	Stream_FAILED_PERMANENTLY Stream_State = 6
	// The stream is starting, but not yet running.
	Stream_STARTING Stream_State = 7
	// The Stream is no longer reading new events, but still writing events in
	// the buffer.
	Stream_DRAINING Stream_State = 8
)

// Enum value maps for Stream_State.
var (
	Stream_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATED",
		2: "RUNNING",
		3: "PAUSED",
		4: "MAINTENANCE",
		5: "FAILED",
		6: "FAILED_PERMANENTLY",
		7: "STARTING",
		8: "DRAINING",
	}
	Stream_State_value = map[string]int32{
		"STATE_UNSPECIFIED":  0,
		"CREATED":            1,
		"RUNNING":            2,
		"PAUSED":             3,
		"MAINTENANCE":        4,
		"FAILED":             5,
		"FAILED_PERMANENTLY": 6,
		"STARTING":           7,
		"DRAINING":           8,
	}
)

func (x Stream_State) Enum() *Stream_State {
	p := new(Stream_State)
	*p = x
	return p
}

func (x Stream_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Stream_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[4].Descriptor()
}

func (Stream_State) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[4]
}

func (x Stream_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Stream_State.Descriptor instead.
func (Stream_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{27, 0}
}

// Validation execution status.
type Validation_Status int32

const (
	// Unspecified status.
	Validation_STATUS_UNSPECIFIED Validation_Status = 0
	// Validation did not execute.
	Validation_NOT_EXECUTED Validation_Status = 1
	// Validation failed.
	Validation_FAILED Validation_Status = 2
	// Validation passed.
	Validation_PASSED Validation_Status = 3
)

// Enum value maps for Validation_Status.
var (
	Validation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "NOT_EXECUTED",
		2: "FAILED",
		3: "PASSED",
	}
	Validation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"NOT_EXECUTED":       1,
		"FAILED":             2,
		"PASSED":             3,
	}
)

func (x Validation_Status) Enum() *Validation_Status {
	p := new(Validation_Status)
	*p = x
	return p
}

func (x Validation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Validation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[5].Descriptor()
}

func (Validation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[5]
}

func (x Validation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Validation_Status.Descriptor instead.
func (Validation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{30, 0}
}

// Validation message level.
type ValidationMessage_Level int32

const (
	// Unspecified level.
	ValidationMessage_LEVEL_UNSPECIFIED ValidationMessage_Level = 0
	// Potentially cause issues with the Stream.
	ValidationMessage_WARNING ValidationMessage_Level = 1
	// Definitely cause issues with the Stream.
	ValidationMessage_ERROR ValidationMessage_Level = 2
)

// Enum value maps for ValidationMessage_Level.
var (
	ValidationMessage_Level_name = map[int32]string{
		0: "LEVEL_UNSPECIFIED",
		1: "WARNING",
		2: "ERROR",
	}
	ValidationMessage_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED": 0,
		"WARNING":           1,
		"ERROR":             2,
	}
)

func (x ValidationMessage_Level) Enum() *ValidationMessage_Level {
	p := new(ValidationMessage_Level)
	*p = x
	return p
}

func (x ValidationMessage_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValidationMessage_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[6].Descriptor()
}

func (ValidationMessage_Level) Type() protoreflect.EnumType {
	return &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes[6]
}

func (x ValidationMessage_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValidationMessage_Level.Descriptor instead.
func (ValidationMessage_Level) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{31, 0}
}

// Oracle database profile.
type OracleProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the Oracle connection.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Port for the Oracle connection, default value is 1521.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Username for the Oracle connection.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Password for the Oracle connection.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// Required. Database for the Oracle connection.
	DatabaseService string `protobuf:"bytes,5,opt,name=database_service,json=databaseService,proto3" json:"database_service,omitempty"`
	// Connection string attributes
	ConnectionAttributes map[string]string `protobuf:"bytes,6,rep,name=connection_attributes,json=connectionAttributes,proto3" json:"connection_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *OracleProfile) Reset() {
	*x = OracleProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleProfile) ProtoMessage() {}

func (x *OracleProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleProfile.ProtoReflect.Descriptor instead.
func (*OracleProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{0}
}

func (x *OracleProfile) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *OracleProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *OracleProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *OracleProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *OracleProfile) GetDatabaseService() string {
	if x != nil {
		return x.DatabaseService
	}
	return ""
}

func (x *OracleProfile) GetConnectionAttributes() map[string]string {
	if x != nil {
		return x.ConnectionAttributes
	}
	return nil
}

// MySQL database profile.
type MysqlProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the MySQL connection.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Port for the MySQL connection, default value is 3306.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. Username for the MySQL connection.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. Password for the MySQL connection.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// SSL configuration for the MySQL connection.
	SslConfig *MysqlSslConfig `protobuf:"bytes,5,opt,name=ssl_config,json=sslConfig,proto3" json:"ssl_config,omitempty"`
}

func (x *MysqlProfile) Reset() {
	*x = MysqlProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlProfile) ProtoMessage() {}

func (x *MysqlProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlProfile.ProtoReflect.Descriptor instead.
func (*MysqlProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{1}
}

func (x *MysqlProfile) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *MysqlProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MysqlProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *MysqlProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MysqlProfile) GetSslConfig() *MysqlSslConfig {
	if x != nil {
		return x.SslConfig
	}
	return nil
}

// Cloud Storage bucket profile.
type GcsProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full project and resource path for Cloud Storage bucket including the
	// name.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// The root path inside the Cloud Storage bucket.
	RootPath string `protobuf:"bytes,2,opt,name=root_path,json=rootPath,proto3" json:"root_path,omitempty"`
}

func (x *GcsProfile) Reset() {
	*x = GcsProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsProfile) ProtoMessage() {}

func (x *GcsProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsProfile.ProtoReflect.Descriptor instead.
func (*GcsProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{2}
}

func (x *GcsProfile) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *GcsProfile) GetRootPath() string {
	if x != nil {
		return x.RootPath
	}
	return ""
}

// No connectivity settings.
type NoConnectivitySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *NoConnectivitySettings) Reset() {
	*x = NoConnectivitySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NoConnectivitySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NoConnectivitySettings) ProtoMessage() {}

func (x *NoConnectivitySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NoConnectivitySettings.ProtoReflect.Descriptor instead.
func (*NoConnectivitySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{3}
}

// Static IP address connectivity.
type StaticServiceIpConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StaticServiceIpConnectivity) Reset() {
	*x = StaticServiceIpConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticServiceIpConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticServiceIpConnectivity) ProtoMessage() {}

func (x *StaticServiceIpConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticServiceIpConnectivity.ProtoReflect.Descriptor instead.
func (*StaticServiceIpConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{4}
}

// Forward SSH Tunnel connectivity.
type ForwardSshTunnelConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname for the SSH tunnel.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Required. Username for the SSH tunnel.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// Port for the SSH tunnel, default value is 22.
	Port int32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// Types that are assignable to AuthenticationMethod:
	//	*ForwardSshTunnelConnectivity_Password
	//	*ForwardSshTunnelConnectivity_PrivateKey
	AuthenticationMethod isForwardSshTunnelConnectivity_AuthenticationMethod `protobuf_oneof:"authentication_method"`
}

func (x *ForwardSshTunnelConnectivity) Reset() {
	*x = ForwardSshTunnelConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardSshTunnelConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardSshTunnelConnectivity) ProtoMessage() {}

func (x *ForwardSshTunnelConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardSshTunnelConnectivity.ProtoReflect.Descriptor instead.
func (*ForwardSshTunnelConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{5}
}

func (x *ForwardSshTunnelConnectivity) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (m *ForwardSshTunnelConnectivity) GetAuthenticationMethod() isForwardSshTunnelConnectivity_AuthenticationMethod {
	if m != nil {
		return m.AuthenticationMethod
	}
	return nil
}

func (x *ForwardSshTunnelConnectivity) GetPassword() string {
	if x, ok := x.GetAuthenticationMethod().(*ForwardSshTunnelConnectivity_Password); ok {
		return x.Password
	}
	return ""
}

func (x *ForwardSshTunnelConnectivity) GetPrivateKey() string {
	if x, ok := x.GetAuthenticationMethod().(*ForwardSshTunnelConnectivity_PrivateKey); ok {
		return x.PrivateKey
	}
	return ""
}

type isForwardSshTunnelConnectivity_AuthenticationMethod interface {
	isForwardSshTunnelConnectivity_AuthenticationMethod()
}

type ForwardSshTunnelConnectivity_Password struct {
	// Input only. SSH password.
	Password string `protobuf:"bytes,100,opt,name=password,proto3,oneof"`
}

type ForwardSshTunnelConnectivity_PrivateKey struct {
	// Input only. SSH private key.
	PrivateKey string `protobuf:"bytes,101,opt,name=private_key,json=privateKey,proto3,oneof"`
}

func (*ForwardSshTunnelConnectivity_Password) isForwardSshTunnelConnectivity_AuthenticationMethod() {}

func (*ForwardSshTunnelConnectivity_PrivateKey) isForwardSshTunnelConnectivity_AuthenticationMethod() {
}

// The VPC Peering configuration is used to create VPC peering between
// Datastream and the consumer's VPC.
type VpcPeeringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. fully qualified name of the VPC Datastream will peer to.
	VpcName string `protobuf:"bytes,1,opt,name=vpc_name,json=vpcName,proto3" json:"vpc_name,omitempty"`
	// Required. A free subnet for peering. (CIDR of /29)
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (x *VpcPeeringConfig) Reset() {
	*x = VpcPeeringConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpcPeeringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcPeeringConfig) ProtoMessage() {}

func (x *VpcPeeringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcPeeringConfig.ProtoReflect.Descriptor instead.
func (*VpcPeeringConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{6}
}

func (x *VpcPeeringConfig) GetVpcName() string {
	if x != nil {
		return x.VpcName
	}
	return ""
}

func (x *VpcPeeringConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

// The PrivateConnection resource is used to establish private connectivity
// between Datastream and a customer's network.
type PrivateConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The state of the Private Connection.
	State PrivateConnection_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.datastream.v1alpha1.PrivateConnection_State" json:"state,omitempty"`
	// Output only. In case of error, the details of the error in a user-friendly format.
	Error *Error `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// VPC Peering Config
	VpcPeeringConfig *VpcPeeringConfig `protobuf:"bytes,100,opt,name=vpc_peering_config,json=vpcPeeringConfig,proto3" json:"vpc_peering_config,omitempty"`
}

func (x *PrivateConnection) Reset() {
	*x = PrivateConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnection) ProtoMessage() {}

func (x *PrivateConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnection.ProtoReflect.Descriptor instead.
func (*PrivateConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{7}
}

func (x *PrivateConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateConnection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PrivateConnection) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PrivateConnection) GetState() PrivateConnection_State {
	if x != nil {
		return x.State
	}
	return PrivateConnection_STATE_UNSPECIFIED
}

func (x *PrivateConnection) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PrivateConnection) GetVpcPeeringConfig() *VpcPeeringConfig {
	if x != nil {
		return x.VpcPeeringConfig
	}
	return nil
}

// Private Connectivity
type PrivateConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrivateConnectionName string `protobuf:"bytes,1,opt,name=private_connection_name,json=privateConnectionName,proto3" json:"private_connection_name,omitempty"`
}

func (x *PrivateConnectivity) Reset() {
	*x = PrivateConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateConnectivity) ProtoMessage() {}

func (x *PrivateConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateConnectivity.ProtoReflect.Descriptor instead.
func (*PrivateConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{8}
}

func (x *PrivateConnectivity) GetPrivateConnectionName() string {
	if x != nil {
		return x.PrivateConnectionName
	}
	return ""
}

// The Route resource is the child of the PrivateConnection resource.
// It used to define a route for a PrivateConnection setup.
type Route struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Destination address for connection
	DestinationAddress string `protobuf:"bytes,6,opt,name=destination_address,json=destinationAddress,proto3" json:"destination_address,omitempty"`
	// Destination port for connection
	DestinationPort int32 `protobuf:"varint,7,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
}

func (x *Route) Reset() {
	*x = Route{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Route) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Route) ProtoMessage() {}

func (x *Route) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Route.ProtoReflect.Descriptor instead.
func (*Route) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Route) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Route) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Route) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Route) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Route) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Route) GetDestinationAddress() string {
	if x != nil {
		return x.DestinationAddress
	}
	return ""
}

func (x *Route) GetDestinationPort() int32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

// MySQL SSL configuration information.
type MysqlSslConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. PEM-encoded private key associated with the Client Certificate.
	// If this field is used then the 'client_certificate' and the
	// 'ca_certificate' fields are mandatory.
	ClientKey string `protobuf:"bytes,11,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// Output only. Indicates whether the client_key field is set.
	ClientKeySet bool `protobuf:"varint,12,opt,name=client_key_set,json=clientKeySet,proto3" json:"client_key_set,omitempty"`
	// Input only. PEM-encoded certificate that will be used by the replica to
	// authenticate against the source database server. If this field is used
	// then the 'client_key' and the 'ca_certificate' fields are mandatory.
	ClientCertificate string `protobuf:"bytes,13,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// Output only. Indicates whether the client_certificate field is set.
	ClientCertificateSet bool `protobuf:"varint,14,opt,name=client_certificate_set,json=clientCertificateSet,proto3" json:"client_certificate_set,omitempty"`
	// Input only. PEM-encoded certificate of the CA that signed the source database
	// server's certificate.
	CaCertificate string `protobuf:"bytes,15,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// Output only. Indicates whether the ca_certificate field is set.
	CaCertificateSet bool `protobuf:"varint,16,opt,name=ca_certificate_set,json=caCertificateSet,proto3" json:"ca_certificate_set,omitempty"`
}

func (x *MysqlSslConfig) Reset() {
	*x = MysqlSslConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlSslConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlSslConfig) ProtoMessage() {}

func (x *MysqlSslConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlSslConfig.ProtoReflect.Descriptor instead.
func (*MysqlSslConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{10}
}

func (x *MysqlSslConfig) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *MysqlSslConfig) GetClientKeySet() bool {
	if x != nil {
		return x.ClientKeySet
	}
	return false
}

func (x *MysqlSslConfig) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MysqlSslConfig) GetClientCertificateSet() bool {
	if x != nil {
		return x.ClientCertificateSet
	}
	return false
}

func (x *MysqlSslConfig) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *MysqlSslConfig) GetCaCertificateSet() bool {
	if x != nil {
		return x.CaCertificateSet
	}
	return false
}

type ConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time of the resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time of the resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Connection configuration for the ConnectionProfile.
	//
	// Types that are assignable to Profile:
	//	*ConnectionProfile_OracleProfile
	//	*ConnectionProfile_GcsProfile
	//	*ConnectionProfile_MysqlProfile
	Profile isConnectionProfile_Profile `protobuf_oneof:"profile"`
	// Connectivity options used to establish a connection to the profile.
	//
	// Types that are assignable to Connectivity:
	//	*ConnectionProfile_NoConnectivity
	//	*ConnectionProfile_StaticServiceIpConnectivity
	//	*ConnectionProfile_ForwardSshConnectivity
	//	*ConnectionProfile_PrivateConnectivity
	Connectivity isConnectionProfile_Connectivity `protobuf_oneof:"connectivity"`
}

func (x *ConnectionProfile) Reset() {
	*x = ConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProfile) ProtoMessage() {}

func (x *ConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionProfile.ProtoReflect.Descriptor instead.
func (*ConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{11}
}

func (x *ConnectionProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectionProfile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConnectionProfile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConnectionProfile) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ConnectionProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *ConnectionProfile) GetProfile() isConnectionProfile_Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

func (x *ConnectionProfile) GetOracleProfile() *OracleProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_OracleProfile); ok {
		return x.OracleProfile
	}
	return nil
}

func (x *ConnectionProfile) GetGcsProfile() *GcsProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_GcsProfile); ok {
		return x.GcsProfile
	}
	return nil
}

func (x *ConnectionProfile) GetMysqlProfile() *MysqlProfile {
	if x, ok := x.GetProfile().(*ConnectionProfile_MysqlProfile); ok {
		return x.MysqlProfile
	}
	return nil
}

func (m *ConnectionProfile) GetConnectivity() isConnectionProfile_Connectivity {
	if m != nil {
		return m.Connectivity
	}
	return nil
}

func (x *ConnectionProfile) GetNoConnectivity() *NoConnectivitySettings {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_NoConnectivity); ok {
		return x.NoConnectivity
	}
	return nil
}

func (x *ConnectionProfile) GetStaticServiceIpConnectivity() *StaticServiceIpConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_StaticServiceIpConnectivity); ok {
		return x.StaticServiceIpConnectivity
	}
	return nil
}

func (x *ConnectionProfile) GetForwardSshConnectivity() *ForwardSshTunnelConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_ForwardSshConnectivity); ok {
		return x.ForwardSshConnectivity
	}
	return nil
}

func (x *ConnectionProfile) GetPrivateConnectivity() *PrivateConnectivity {
	if x, ok := x.GetConnectivity().(*ConnectionProfile_PrivateConnectivity); ok {
		return x.PrivateConnectivity
	}
	return nil
}

type isConnectionProfile_Profile interface {
	isConnectionProfile_Profile()
}

type ConnectionProfile_OracleProfile struct {
	// Oracle ConnectionProfile configuration.
	OracleProfile *OracleProfile `protobuf:"bytes,100,opt,name=oracle_profile,json=oracleProfile,proto3,oneof"`
}

type ConnectionProfile_GcsProfile struct {
	// Cloud Storage ConnectionProfile configuration.
	GcsProfile *GcsProfile `protobuf:"bytes,101,opt,name=gcs_profile,json=gcsProfile,proto3,oneof"`
}

type ConnectionProfile_MysqlProfile struct {
	// MySQL ConnectionProfile configuration.
	MysqlProfile *MysqlProfile `protobuf:"bytes,102,opt,name=mysql_profile,json=mysqlProfile,proto3,oneof"`
}

func (*ConnectionProfile_OracleProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_GcsProfile) isConnectionProfile_Profile() {}

func (*ConnectionProfile_MysqlProfile) isConnectionProfile_Profile() {}

type isConnectionProfile_Connectivity interface {
	isConnectionProfile_Connectivity()
}

type ConnectionProfile_NoConnectivity struct {
	// No connectivity option chosen.
	NoConnectivity *NoConnectivitySettings `protobuf:"bytes,200,opt,name=no_connectivity,json=noConnectivity,proto3,oneof"`
}

type ConnectionProfile_StaticServiceIpConnectivity struct {
	// Static Service IP connectivity.
	StaticServiceIpConnectivity *StaticServiceIpConnectivity `protobuf:"bytes,201,opt,name=static_service_ip_connectivity,json=staticServiceIpConnectivity,proto3,oneof"`
}

type ConnectionProfile_ForwardSshConnectivity struct {
	// Forward SSH tunnel connectivity.
	ForwardSshConnectivity *ForwardSshTunnelConnectivity `protobuf:"bytes,202,opt,name=forward_ssh_connectivity,json=forwardSshConnectivity,proto3,oneof"`
}

type ConnectionProfile_PrivateConnectivity struct {
	// Private connectivity.
	PrivateConnectivity *PrivateConnectivity `protobuf:"bytes,203,opt,name=private_connectivity,json=privateConnectivity,proto3,oneof"`
}

func (*ConnectionProfile_NoConnectivity) isConnectionProfile_Connectivity() {}

func (*ConnectionProfile_StaticServiceIpConnectivity) isConnectionProfile_Connectivity() {}

func (*ConnectionProfile_ForwardSshConnectivity) isConnectionProfile_Connectivity() {}

func (*ConnectionProfile_PrivateConnectivity) isConnectionProfile_Connectivity() {}

// Oracle Column.
type OracleColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// The Oracle data type.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Column length.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Column precision.
	Precision int32 `protobuf:"varint,4,opt,name=precision,proto3" json:"precision,omitempty"`
	// Column scale.
	Scale int32 `protobuf:"varint,5,opt,name=scale,proto3" json:"scale,omitempty"`
	// Column encoding.
	Encoding string `protobuf:"bytes,6,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Whether or not the column represents a primary key.
	PrimaryKey bool `protobuf:"varint,7,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Whether or not the column can accept a null value.
	Nullable bool `protobuf:"varint,8,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The ordinal position of the column in the table.
	OrdinalPosition int32 `protobuf:"varint,9,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *OracleColumn) Reset() {
	*x = OracleColumn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleColumn) ProtoMessage() {}

func (x *OracleColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleColumn.ProtoReflect.Descriptor instead.
func (*OracleColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{12}
}

func (x *OracleColumn) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *OracleColumn) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *OracleColumn) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *OracleColumn) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *OracleColumn) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *OracleColumn) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *OracleColumn) GetPrimaryKey() bool {
	if x != nil {
		return x.PrimaryKey
	}
	return false
}

func (x *OracleColumn) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *OracleColumn) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// Oracle table.
type OracleTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Oracle columns in the schema.
	// When unspecified as part of inclue/exclude lists, includes/excludes
	// everything.
	OracleColumns []*OracleColumn `protobuf:"bytes,2,rep,name=oracle_columns,json=oracleColumns,proto3" json:"oracle_columns,omitempty"`
}

func (x *OracleTable) Reset() {
	*x = OracleTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleTable) ProtoMessage() {}

func (x *OracleTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleTable.ProtoReflect.Descriptor instead.
func (*OracleTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{13}
}

func (x *OracleTable) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *OracleTable) GetOracleColumns() []*OracleColumn {
	if x != nil {
		return x.OracleColumns
	}
	return nil
}

// Oracle schema.
type OracleSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema name.
	SchemaName string `protobuf:"bytes,1,opt,name=schema_name,json=schemaName,proto3" json:"schema_name,omitempty"`
	// Tables in the schema.
	OracleTables []*OracleTable `protobuf:"bytes,2,rep,name=oracle_tables,json=oracleTables,proto3" json:"oracle_tables,omitempty"`
}

func (x *OracleSchema) Reset() {
	*x = OracleSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSchema) ProtoMessage() {}

func (x *OracleSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSchema.ProtoReflect.Descriptor instead.
func (*OracleSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{14}
}

func (x *OracleSchema) GetSchemaName() string {
	if x != nil {
		return x.SchemaName
	}
	return ""
}

func (x *OracleSchema) GetOracleTables() []*OracleTable {
	if x != nil {
		return x.OracleTables
	}
	return nil
}

// Oracle database structure.
type OracleRdbms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Oracle schemas/databases in the database server.
	OracleSchemas []*OracleSchema `protobuf:"bytes,1,rep,name=oracle_schemas,json=oracleSchemas,proto3" json:"oracle_schemas,omitempty"`
}

func (x *OracleRdbms) Reset() {
	*x = OracleRdbms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleRdbms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleRdbms) ProtoMessage() {}

func (x *OracleRdbms) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleRdbms.ProtoReflect.Descriptor instead.
func (*OracleRdbms) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{15}
}

func (x *OracleRdbms) GetOracleSchemas() []*OracleSchema {
	if x != nil {
		return x.OracleSchemas
	}
	return nil
}

// Oracle data source configuration
type OracleSourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Oracle objects to include in the stream.
	Allowlist *OracleRdbms `protobuf:"bytes,1,opt,name=allowlist,proto3" json:"allowlist,omitempty"`
	// Oracle objects to exclude from the stream.
	Rejectlist *OracleRdbms `protobuf:"bytes,2,opt,name=rejectlist,proto3" json:"rejectlist,omitempty"`
}

func (x *OracleSourceConfig) Reset() {
	*x = OracleSourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OracleSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OracleSourceConfig) ProtoMessage() {}

func (x *OracleSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OracleSourceConfig.ProtoReflect.Descriptor instead.
func (*OracleSourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{16}
}

func (x *OracleSourceConfig) GetAllowlist() *OracleRdbms {
	if x != nil {
		return x.Allowlist
	}
	return nil
}

func (x *OracleSourceConfig) GetRejectlist() *OracleRdbms {
	if x != nil {
		return x.Rejectlist
	}
	return nil
}

// MySQL Column.
type MysqlColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName,proto3" json:"column_name,omitempty"`
	// The MySQL data type. Full data types list can be found here:
	// https://dev.mysql.com/doc/refman/8.0/en/data-types.html
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Column length.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Column collation.
	Collation string `protobuf:"bytes,4,opt,name=collation,proto3" json:"collation,omitempty"`
	// Whether or not the column represents a primary key.
	PrimaryKey bool `protobuf:"varint,5,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Whether or not the column can accept a null value.
	Nullable bool `protobuf:"varint,6,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// The ordinal position of the column in the table.
	OrdinalPosition int32 `protobuf:"varint,7,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
}

func (x *MysqlColumn) Reset() {
	*x = MysqlColumn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlColumn) ProtoMessage() {}

func (x *MysqlColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlColumn.ProtoReflect.Descriptor instead.
func (*MysqlColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{17}
}

func (x *MysqlColumn) GetColumnName() string {
	if x != nil {
		return x.ColumnName
	}
	return ""
}

func (x *MysqlColumn) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *MysqlColumn) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *MysqlColumn) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *MysqlColumn) GetPrimaryKey() bool {
	if x != nil {
		return x.PrimaryKey
	}
	return false
}

func (x *MysqlColumn) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *MysqlColumn) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

// MySQL table.
type MysqlTable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table name.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// MySQL columns in the database.
	// When unspecified as part of include/exclude lists, includes/excludes
	// everything.
	MysqlColumns []*MysqlColumn `protobuf:"bytes,2,rep,name=mysql_columns,json=mysqlColumns,proto3" json:"mysql_columns,omitempty"`
}

func (x *MysqlTable) Reset() {
	*x = MysqlTable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlTable) ProtoMessage() {}

func (x *MysqlTable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlTable.ProtoReflect.Descriptor instead.
func (*MysqlTable) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{18}
}

func (x *MysqlTable) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *MysqlTable) GetMysqlColumns() []*MysqlColumn {
	if x != nil {
		return x.MysqlColumns
	}
	return nil
}

// MySQL database.
type MysqlDatabase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database name.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// Tables in the database.
	MysqlTables []*MysqlTable `protobuf:"bytes,2,rep,name=mysql_tables,json=mysqlTables,proto3" json:"mysql_tables,omitempty"`
}

func (x *MysqlDatabase) Reset() {
	*x = MysqlDatabase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlDatabase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlDatabase) ProtoMessage() {}

func (x *MysqlDatabase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlDatabase.ProtoReflect.Descriptor instead.
func (*MysqlDatabase) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{19}
}

func (x *MysqlDatabase) GetDatabaseName() string {
	if x != nil {
		return x.DatabaseName
	}
	return ""
}

func (x *MysqlDatabase) GetMysqlTables() []*MysqlTable {
	if x != nil {
		return x.MysqlTables
	}
	return nil
}

// MySQL database structure
type MysqlRdbms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mysql databases on the server
	MysqlDatabases []*MysqlDatabase `protobuf:"bytes,1,rep,name=mysql_databases,json=mysqlDatabases,proto3" json:"mysql_databases,omitempty"`
}

func (x *MysqlRdbms) Reset() {
	*x = MysqlRdbms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlRdbms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlRdbms) ProtoMessage() {}

func (x *MysqlRdbms) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlRdbms.ProtoReflect.Descriptor instead.
func (*MysqlRdbms) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{20}
}

func (x *MysqlRdbms) GetMysqlDatabases() []*MysqlDatabase {
	if x != nil {
		return x.MysqlDatabases
	}
	return nil
}

// MySQL source configuration
type MysqlSourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// MySQL objects to retrieve from the source.
	Allowlist *MysqlRdbms `protobuf:"bytes,1,opt,name=allowlist,proto3" json:"allowlist,omitempty"`
	// MySQL objects to exclude from the stream.
	Rejectlist *MysqlRdbms `protobuf:"bytes,2,opt,name=rejectlist,proto3" json:"rejectlist,omitempty"`
}

func (x *MysqlSourceConfig) Reset() {
	*x = MysqlSourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MysqlSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MysqlSourceConfig) ProtoMessage() {}

func (x *MysqlSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MysqlSourceConfig.ProtoReflect.Descriptor instead.
func (*MysqlSourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{21}
}

func (x *MysqlSourceConfig) GetAllowlist() *MysqlRdbms {
	if x != nil {
		return x.Allowlist
	}
	return nil
}

func (x *MysqlSourceConfig) GetRejectlist() *MysqlRdbms {
	if x != nil {
		return x.Rejectlist
	}
	return nil
}

// The configuration of the stream source.
type SourceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Source connection profile identifier.
	SourceConnectionProfileName string `protobuf:"bytes,1,opt,name=source_connection_profile_name,json=sourceConnectionProfileName,proto3" json:"source_connection_profile_name,omitempty"`
	// Stream configuration that is specific to the data source type.
	//
	// Types that are assignable to SourceStreamConfig:
	//	*SourceConfig_OracleSourceConfig
	//	*SourceConfig_MysqlSourceConfig
	SourceStreamConfig isSourceConfig_SourceStreamConfig `protobuf_oneof:"source_stream_config"`
}

func (x *SourceConfig) Reset() {
	*x = SourceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceConfig) ProtoMessage() {}

func (x *SourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceConfig.ProtoReflect.Descriptor instead.
func (*SourceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{22}
}

func (x *SourceConfig) GetSourceConnectionProfileName() string {
	if x != nil {
		return x.SourceConnectionProfileName
	}
	return ""
}

func (m *SourceConfig) GetSourceStreamConfig() isSourceConfig_SourceStreamConfig {
	if m != nil {
		return m.SourceStreamConfig
	}
	return nil
}

func (x *SourceConfig) GetOracleSourceConfig() *OracleSourceConfig {
	if x, ok := x.GetSourceStreamConfig().(*SourceConfig_OracleSourceConfig); ok {
		return x.OracleSourceConfig
	}
	return nil
}

func (x *SourceConfig) GetMysqlSourceConfig() *MysqlSourceConfig {
	if x, ok := x.GetSourceStreamConfig().(*SourceConfig_MysqlSourceConfig); ok {
		return x.MysqlSourceConfig
	}
	return nil
}

type isSourceConfig_SourceStreamConfig interface {
	isSourceConfig_SourceStreamConfig()
}

type SourceConfig_OracleSourceConfig struct {
	// Oracle data source configuration
	OracleSourceConfig *OracleSourceConfig `protobuf:"bytes,100,opt,name=oracle_source_config,json=oracleSourceConfig,proto3,oneof"`
}

type SourceConfig_MysqlSourceConfig struct {
	// MySQL data source configuration
	MysqlSourceConfig *MysqlSourceConfig `protobuf:"bytes,101,opt,name=mysql_source_config,json=mysqlSourceConfig,proto3,oneof"`
}

func (*SourceConfig_OracleSourceConfig) isSourceConfig_SourceStreamConfig() {}

func (*SourceConfig_MysqlSourceConfig) isSourceConfig_SourceStreamConfig() {}

// AVRO file format configuration.
type AvroFileFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AvroFileFormat) Reset() {
	*x = AvroFileFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvroFileFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvroFileFormat) ProtoMessage() {}

func (x *AvroFileFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvroFileFormat.ProtoReflect.Descriptor instead.
func (*AvroFileFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{23}
}

// JSON file format configuration.
type JsonFileFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The schema file format along JSON data files.
	SchemaFileFormat SchemaFileFormat `protobuf:"varint,1,opt,name=schema_file_format,json=schemaFileFormat,proto3,enum=google.cloud.datastream.v1alpha1.SchemaFileFormat" json:"schema_file_format,omitempty"`
	// Compression of the loaded JSON file.
	Compression JsonFileFormat_JsonCompression `protobuf:"varint,2,opt,name=compression,proto3,enum=google.cloud.datastream.v1alpha1.JsonFileFormat_JsonCompression" json:"compression,omitempty"`
}

func (x *JsonFileFormat) Reset() {
	*x = JsonFileFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JsonFileFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JsonFileFormat) ProtoMessage() {}

func (x *JsonFileFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JsonFileFormat.ProtoReflect.Descriptor instead.
func (*JsonFileFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{24}
}

func (x *JsonFileFormat) GetSchemaFileFormat() SchemaFileFormat {
	if x != nil {
		return x.SchemaFileFormat
	}
	return SchemaFileFormat_SCHEMA_FILE_FORMAT_UNSPECIFIED
}

func (x *JsonFileFormat) GetCompression() JsonFileFormat_JsonCompression {
	if x != nil {
		return x.Compression
	}
	return JsonFileFormat_JSON_COMPRESSION_UNSPECIFIED
}

// Google Cloud Storage destination configuration
type GcsDestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path inside the Cloud Storage bucket to write data to.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// File format that data should be written in.
	// Deprecated field - use file_format instead.
	//
	// Deprecated: Do not use.
	GcsFileFormat GcsFileFormat `protobuf:"varint,2,opt,name=gcs_file_format,json=gcsFileFormat,proto3,enum=google.cloud.datastream.v1alpha1.GcsFileFormat" json:"gcs_file_format,omitempty"`
	// The maximum file size to be saved in the bucket.
	FileRotationMb int32 `protobuf:"varint,3,opt,name=file_rotation_mb,json=fileRotationMb,proto3" json:"file_rotation_mb,omitempty"`
	// The maximum duration for which new events are added before a file is
	// closed and a new file is created.
	FileRotationInterval *durationpb.Duration `protobuf:"bytes,4,opt,name=file_rotation_interval,json=fileRotationInterval,proto3" json:"file_rotation_interval,omitempty"`
	// File Format that the data should be written in.
	//
	// Types that are assignable to FileFormat:
	//	*GcsDestinationConfig_AvroFileFormat
	//	*GcsDestinationConfig_JsonFileFormat
	FileFormat isGcsDestinationConfig_FileFormat `protobuf_oneof:"file_format"`
}

func (x *GcsDestinationConfig) Reset() {
	*x = GcsDestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestinationConfig) ProtoMessage() {}

func (x *GcsDestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestinationConfig.ProtoReflect.Descriptor instead.
func (*GcsDestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{25}
}

func (x *GcsDestinationConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Deprecated: Do not use.
func (x *GcsDestinationConfig) GetGcsFileFormat() GcsFileFormat {
	if x != nil {
		return x.GcsFileFormat
	}
	return GcsFileFormat_GCS_FILE_FORMAT_UNSPECIFIED
}

func (x *GcsDestinationConfig) GetFileRotationMb() int32 {
	if x != nil {
		return x.FileRotationMb
	}
	return 0
}

func (x *GcsDestinationConfig) GetFileRotationInterval() *durationpb.Duration {
	if x != nil {
		return x.FileRotationInterval
	}
	return nil
}

func (m *GcsDestinationConfig) GetFileFormat() isGcsDestinationConfig_FileFormat {
	if m != nil {
		return m.FileFormat
	}
	return nil
}

func (x *GcsDestinationConfig) GetAvroFileFormat() *AvroFileFormat {
	if x, ok := x.GetFileFormat().(*GcsDestinationConfig_AvroFileFormat); ok {
		return x.AvroFileFormat
	}
	return nil
}

func (x *GcsDestinationConfig) GetJsonFileFormat() *JsonFileFormat {
	if x, ok := x.GetFileFormat().(*GcsDestinationConfig_JsonFileFormat); ok {
		return x.JsonFileFormat
	}
	return nil
}

type isGcsDestinationConfig_FileFormat interface {
	isGcsDestinationConfig_FileFormat()
}

type GcsDestinationConfig_AvroFileFormat struct {
	// AVRO file format configuration.
	AvroFileFormat *AvroFileFormat `protobuf:"bytes,100,opt,name=avro_file_format,json=avroFileFormat,proto3,oneof"`
}

type GcsDestinationConfig_JsonFileFormat struct {
	// JSON file format configuration.
	JsonFileFormat *JsonFileFormat `protobuf:"bytes,101,opt,name=json_file_format,json=jsonFileFormat,proto3,oneof"`
}

func (*GcsDestinationConfig_AvroFileFormat) isGcsDestinationConfig_FileFormat() {}

func (*GcsDestinationConfig_JsonFileFormat) isGcsDestinationConfig_FileFormat() {}

// The configuration of the stream destination.
type DestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Destination connection profile identifier.
	DestinationConnectionProfileName string `protobuf:"bytes,1,opt,name=destination_connection_profile_name,json=destinationConnectionProfileName,proto3" json:"destination_connection_profile_name,omitempty"`
	// Stream configuration that is specific to the data destination type.
	//
	// Types that are assignable to DestinationStreamConfig:
	//	*DestinationConfig_GcsDestinationConfig
	DestinationStreamConfig isDestinationConfig_DestinationStreamConfig `protobuf_oneof:"destination_stream_config"`
}

func (x *DestinationConfig) Reset() {
	*x = DestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfig) ProtoMessage() {}

func (x *DestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfig.ProtoReflect.Descriptor instead.
func (*DestinationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{26}
}

func (x *DestinationConfig) GetDestinationConnectionProfileName() string {
	if x != nil {
		return x.DestinationConnectionProfileName
	}
	return ""
}

func (m *DestinationConfig) GetDestinationStreamConfig() isDestinationConfig_DestinationStreamConfig {
	if m != nil {
		return m.DestinationStreamConfig
	}
	return nil
}

func (x *DestinationConfig) GetGcsDestinationConfig() *GcsDestinationConfig {
	if x, ok := x.GetDestinationStreamConfig().(*DestinationConfig_GcsDestinationConfig); ok {
		return x.GcsDestinationConfig
	}
	return nil
}

type isDestinationConfig_DestinationStreamConfig interface {
	isDestinationConfig_DestinationStreamConfig()
}

type DestinationConfig_GcsDestinationConfig struct {
	GcsDestinationConfig *GcsDestinationConfig `protobuf:"bytes,100,opt,name=gcs_destination_config,json=gcsDestinationConfig,proto3,oneof"`
}

func (*DestinationConfig_GcsDestinationConfig) isDestinationConfig_DestinationStreamConfig() {}

type Stream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The stream's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time of the stream.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time of the stream.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Source connection profile configuration.
	SourceConfig *SourceConfig `protobuf:"bytes,6,opt,name=source_config,json=sourceConfig,proto3" json:"source_config,omitempty"`
	// Required. Destination connection profile configuration.
	DestinationConfig *DestinationConfig `protobuf:"bytes,7,opt,name=destination_config,json=destinationConfig,proto3" json:"destination_config,omitempty"`
	// The state of the stream.
	State Stream_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.datastream.v1alpha1.Stream_State" json:"state,omitempty"`
	// Stream backfill strategy.
	//
	// Types that are assignable to BackfillStrategy:
	//	*Stream_BackfillAll
	//	*Stream_BackfillNone
	BackfillStrategy isStream_BackfillStrategy `protobuf_oneof:"backfill_strategy"`
	// Output only. Errors on the Stream.
	Errors []*Error `protobuf:"bytes,9,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *Stream) Reset() {
	*x = Stream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream) ProtoMessage() {}

func (x *Stream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream.ProtoReflect.Descriptor instead.
func (*Stream) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{27}
}

func (x *Stream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Stream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Stream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Stream) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Stream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Stream) GetSourceConfig() *SourceConfig {
	if x != nil {
		return x.SourceConfig
	}
	return nil
}

func (x *Stream) GetDestinationConfig() *DestinationConfig {
	if x != nil {
		return x.DestinationConfig
	}
	return nil
}

func (x *Stream) GetState() Stream_State {
	if x != nil {
		return x.State
	}
	return Stream_STATE_UNSPECIFIED
}

func (m *Stream) GetBackfillStrategy() isStream_BackfillStrategy {
	if m != nil {
		return m.BackfillStrategy
	}
	return nil
}

func (x *Stream) GetBackfillAll() *Stream_BackfillAllStrategy {
	if x, ok := x.GetBackfillStrategy().(*Stream_BackfillAll); ok {
		return x.BackfillAll
	}
	return nil
}

func (x *Stream) GetBackfillNone() *Stream_BackfillNoneStrategy {
	if x, ok := x.GetBackfillStrategy().(*Stream_BackfillNone); ok {
		return x.BackfillNone
	}
	return nil
}

func (x *Stream) GetErrors() []*Error {
	if x != nil {
		return x.Errors
	}
	return nil
}

type isStream_BackfillStrategy interface {
	isStream_BackfillStrategy()
}

type Stream_BackfillAll struct {
	// Automatically backfill objects included in the stream source
	// configuration. Specific objects can be excluded.
	BackfillAll *Stream_BackfillAllStrategy `protobuf:"bytes,101,opt,name=backfill_all,json=backfillAll,proto3,oneof"`
}

type Stream_BackfillNone struct {
	// Do not automatically backfill any objects.
	BackfillNone *Stream_BackfillNoneStrategy `protobuf:"bytes,102,opt,name=backfill_none,json=backfillNone,proto3,oneof"`
}

func (*Stream_BackfillAll) isStream_BackfillStrategy() {}

func (*Stream_BackfillNone) isStream_BackfillStrategy() {}

// Represent a user-facing Error.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A title that explains the reason for the error.
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// A unique identifier for this specific error,
	// allowing it to be traced throughout the system in logs and API responses.
	ErrorUuid string `protobuf:"bytes,2,opt,name=error_uuid,json=errorUuid,proto3" json:"error_uuid,omitempty"`
	// A message containing more information about the error that occurred.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The time when the error occurred.
	ErrorTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=error_time,json=errorTime,proto3" json:"error_time,omitempty"`
	// Additional information about the error.
	Details map[string]string `protobuf:"bytes,5,rep,name=details,proto3" json:"details,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{28}
}

func (x *Error) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Error) GetErrorUuid() string {
	if x != nil {
		return x.ErrorUuid
	}
	return ""
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Error) GetErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ErrorTime
	}
	return nil
}

func (x *Error) GetDetails() map[string]string {
	if x != nil {
		return x.Details
	}
	return nil
}

// Contains the current validation results.
type ValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of validations (includes both executed as well as not executed
	// validations).
	Validations []*Validation `protobuf:"bytes,1,rep,name=validations,proto3" json:"validations,omitempty"`
}

func (x *ValidationResult) Reset() {
	*x = ValidationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationResult) ProtoMessage() {}

func (x *ValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationResult.ProtoReflect.Descriptor instead.
func (*ValidationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{29}
}

func (x *ValidationResult) GetValidations() []*Validation {
	if x != nil {
		return x.Validations
	}
	return nil
}

type Validation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short description of the validation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Validation execution status.
	Status Validation_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.cloud.datastream.v1alpha1.Validation_Status" json:"status,omitempty"`
	// Messages reflecting the validation results.
	Message []*ValidationMessage `protobuf:"bytes,3,rep,name=message,proto3" json:"message,omitempty"`
	// A custom code identifying this validation.
	Code string `protobuf:"bytes,4,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *Validation) Reset() {
	*x = Validation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Validation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Validation) ProtoMessage() {}

func (x *Validation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Validation.ProtoReflect.Descriptor instead.
func (*Validation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{30}
}

func (x *Validation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Validation) GetStatus() Validation_Status {
	if x != nil {
		return x.Status
	}
	return Validation_STATUS_UNSPECIFIED
}

func (x *Validation) GetMessage() []*ValidationMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *Validation) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Represent user-facing validation result message.
type ValidationMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the validation.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Message severity level (warning or error).
	Level ValidationMessage_Level `protobuf:"varint,2,opt,name=level,proto3,enum=google.cloud.datastream.v1alpha1.ValidationMessage_Level" json:"level,omitempty"`
	// Additional metadata related to the result.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A custom code identifying this specific message.
	Code string `protobuf:"bytes,4,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *ValidationMessage) Reset() {
	*x = ValidationMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValidationMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationMessage) ProtoMessage() {}

func (x *ValidationMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationMessage.ProtoReflect.Descriptor instead.
func (*ValidationMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{31}
}

func (x *ValidationMessage) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ValidationMessage) GetLevel() ValidationMessage_Level {
	if x != nil {
		return x.Level
	}
	return ValidationMessage_LEVEL_UNSPECIFIED
}

func (x *ValidationMessage) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ValidationMessage) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Backfill strategy to automatically backfill the Stream's objects.
// Specific objects can be excluded.
type Stream_BackfillAllStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of objects to exclude.
	//
	// Types that are assignable to ExcludedObjects:
	//	*Stream_BackfillAllStrategy_OracleExcludedObjects
	//	*Stream_BackfillAllStrategy_MysqlExcludedObjects
	ExcludedObjects isStream_BackfillAllStrategy_ExcludedObjects `protobuf_oneof:"excluded_objects"`
}

func (x *Stream_BackfillAllStrategy) Reset() {
	*x = Stream_BackfillAllStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream_BackfillAllStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream_BackfillAllStrategy) ProtoMessage() {}

func (x *Stream_BackfillAllStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream_BackfillAllStrategy.ProtoReflect.Descriptor instead.
func (*Stream_BackfillAllStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{27, 0}
}

func (m *Stream_BackfillAllStrategy) GetExcludedObjects() isStream_BackfillAllStrategy_ExcludedObjects {
	if m != nil {
		return m.ExcludedObjects
	}
	return nil
}

func (x *Stream_BackfillAllStrategy) GetOracleExcludedObjects() *OracleRdbms {
	if x, ok := x.GetExcludedObjects().(*Stream_BackfillAllStrategy_OracleExcludedObjects); ok {
		return x.OracleExcludedObjects
	}
	return nil
}

func (x *Stream_BackfillAllStrategy) GetMysqlExcludedObjects() *MysqlRdbms {
	if x, ok := x.GetExcludedObjects().(*Stream_BackfillAllStrategy_MysqlExcludedObjects); ok {
		return x.MysqlExcludedObjects
	}
	return nil
}

type isStream_BackfillAllStrategy_ExcludedObjects interface {
	isStream_BackfillAllStrategy_ExcludedObjects()
}

type Stream_BackfillAllStrategy_OracleExcludedObjects struct {
	// Oracle data source objects to avoid backfilling.
	OracleExcludedObjects *OracleRdbms `protobuf:"bytes,1,opt,name=oracle_excluded_objects,json=oracleExcludedObjects,proto3,oneof"`
}

type Stream_BackfillAllStrategy_MysqlExcludedObjects struct {
	// MySQL data source objects to avoid backfilling.
	MysqlExcludedObjects *MysqlRdbms `protobuf:"bytes,2,opt,name=mysql_excluded_objects,json=mysqlExcludedObjects,proto3,oneof"`
}

func (*Stream_BackfillAllStrategy_OracleExcludedObjects) isStream_BackfillAllStrategy_ExcludedObjects() {
}

func (*Stream_BackfillAllStrategy_MysqlExcludedObjects) isStream_BackfillAllStrategy_ExcludedObjects() {
}

// Backfill strategy to disable automatic backfill for the Stream's objects.
type Stream_BackfillNoneStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Stream_BackfillNoneStrategy) Reset() {
	*x = Stream_BackfillNoneStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Stream_BackfillNoneStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream_BackfillNoneStrategy) ProtoMessage() {}

func (x *Stream_BackfillNoneStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream_BackfillNoneStrategy.ProtoReflect.Descriptor instead.
func (*Stream_BackfillNoneStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP(), []int{27, 1}
}

var File_google_cloud_datastream_v1alpha1_datastream_resources_proto protoreflect.FileDescriptor

var file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x02, 0x0a, 0x0d, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0x7e, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x1a, 0x47, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd9, 0x01, 0x0a,
	0x0c, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x4f, 0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d,
	0x79, 0x73, 0x71, 0x6c, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x73,
	0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4f, 0x0a, 0x0a, 0x47, 0x63, 0x73, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x6f, 0x6f, 0x74, 0x50, 0x61, 0x74, 0x68, 0x22, 0x18, 0x0a, 0x16, 0x4e, 0x6f, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x1d, 0x0a, 0x1b, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x22, 0xd8, 0x01, 0x0a, 0x1c, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73,
	0x68, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x21, 0x0a, 0x08, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x26, 0x0a, 0x0b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x65, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x42, 0x17, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x4f, 0x0a,
	0x10, 0x56, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x70, 0x63, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x22, 0xb2,
	0x06, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x60, 0x0a, 0x12,
	0x76, 0x70, 0x63, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x50,
	0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x76, 0x70,
	0x63, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03,
	0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x22, 0x52, 0x0a, 0x13, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x3b, 0x0a, 0x17, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xbc, 0x04, 0x0a, 0x05, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x1f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x7b,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22, 0xad, 0x02, 0x0a, 0x0e, 0x4d, 0x79, 0x73, 0x71, 0x6c,
	0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x29, 0x0a,
	0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x16,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x22, 0xe4, 0x09, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x67, 0x63, 0x73, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x0d, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4d, 0x79, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0c,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x64, 0x0a, 0x0f,
	0x6e, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18,
	0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x48, 0x01, 0x52, 0x0e, 0x6e, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x12, 0x85, 0x01, 0x0a, 0x1e, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x01, 0x52, 0x1b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x7b, 0x0a, 0x18, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73, 0x68, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x01, 0x52,
	0x16, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x6b, 0x0a, 0x14, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18,
	0xcb, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x01, 0x52,
	0x13, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x0e, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x22, 0x9c, 0x02,
	0x0a, 0x0c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x0a,
	0x0b, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x52, 0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x0c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0c, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x0b, 0x4f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x12, 0x55, 0x0a, 0x0e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x0d, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x22, 0xb0,
	0x01, 0x0a, 0x12, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x6c, 0x69, 0x73, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x0a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x6c, 0x69, 0x73,
	0x74, 0x22, 0xe9, 0x01, 0x0a, 0x0b, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a,
	0x0a, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x6d, 0x79,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x52, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x22, 0x85,
	0x01, 0x0a, 0x0d, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d,
	0x79, 0x73, 0x71, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x0b, 0x6d, 0x79, 0x73, 0x71, 0x6c,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x22, 0x66, 0x0a, 0x0a, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x52,
	0x64, 0x62, 0x6d, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x0e,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x22, 0xad,
	0x01, 0x0a, 0x11, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c,
	0x52, 0x64, 0x62, 0x6d, 0x73, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74,
	0x12, 0x4c, 0x0a, 0x0a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62,
	0x6d, 0x73, 0x52, 0x0a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x6c, 0x69, 0x73, 0x74, 0x22, 0xc1,
	0x02, 0x0a, 0x0c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x48, 0x0a, 0x1e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x14, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x12, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x13, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x16, 0x0a, 0x14, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x10, 0x0a, 0x0e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x22, 0xa9, 0x02, 0x0a, 0x0e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x60, 0x0a, 0x12, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46, 0x69, 0x6c,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x62, 0x0a, 0x0b, 0x63, 0x6f, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x51, 0x0a,
	0x0f, 0x4a, 0x73, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x20, 0x0a, 0x1c, 0x4a, 0x53, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x5a, 0x49, 0x50, 0x10, 0x02,
	0x22, 0xcd, 0x03, 0x0a, 0x14, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x5b, 0x0a,
	0x0f, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x67, 0x63, 0x73,
	0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x62, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x62, 0x12, 0x4f, 0x0a, 0x16, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x72, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x14, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x5c, 0x0a, 0x10, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x41, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x76, 0x72, 0x6f, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x5c, 0x0a, 0x10, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x48,
	0x00, 0x52, 0x0e, 0x6a, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x22, 0xf4, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x23, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x16, 0x67, 0x63,
	0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x1b, 0x0a, 0x19, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8f, 0x0b, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x67, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x61,
	0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x41, 0x6c,
	0x6c, 0x12, 0x64, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x5f, 0x6e, 0x6f,
	0x6e, 0x65, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x65, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x66,
	0x69, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x65, 0x12, 0x44, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a, 0xf8, 0x01,
	0x0a, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x67, 0x0a, 0x17, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x52, 0x64, 0x62, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x15, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x64,
	0x0a, 0x16, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x52, 0x64, 0x62, 0x6d, 0x73, 0x48, 0x00, 0x52, 0x14,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x16, 0x0a, 0x14, 0x42, 0x61, 0x63, 0x6b,
	0x66, 0x69, 0x6c, 0x6c, 0x4e, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x95, 0x01, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x16, 0x0a, 0x12, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e,
	0x45, 0x4e, 0x54, 0x4c, 0x59, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x08, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x66, 0x69, 0x6c, 0x6c,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x9f, 0x02, 0x0a, 0x05, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x75, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x55, 0x75, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a,
	0x3a, 0x0a, 0x0c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x62, 0x0a, 0x10, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x4e, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xaa, 0x02, 0x0a, 0x0a, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4d, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x22, 0x4a, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x53, 0x53, 0x45, 0x44, 0x10, 0x03, 0x22, 0xe6, 0x02, 0x0a,
	0x11, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x4f, 0x0a, 0x05,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x5d, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x36, 0x0a,
	0x05, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x02, 0x2a, 0x3e, 0x0a, 0x0d, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x43, 0x53, 0x5f, 0x46, 0x49,
	0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x56, 0x52, 0x4f, 0x10,
	0x01, 0x1a, 0x02, 0x18, 0x01, 0x2a, 0x60, 0x0a, 0x10, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x43, 0x48,
	0x45, 0x4d, 0x41, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10,
	0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x56, 0x52, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x42, 0xff, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x42, 0x1d, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xaa, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescOnce sync.Once
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescData = file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDesc
)

func file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescData)
	})
	return file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDescData
}

var file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_google_cloud_datastream_v1alpha1_datastream_resources_proto_goTypes = []interface{}{
	(GcsFileFormat)(0),                   // 0: google.cloud.datastream.v1alpha1.GcsFileFormat
	(SchemaFileFormat)(0),                // 1: google.cloud.datastream.v1alpha1.SchemaFileFormat
	(PrivateConnection_State)(0),         // 2: google.cloud.datastream.v1alpha1.PrivateConnection.State
	(JsonFileFormat_JsonCompression)(0),  // 3: google.cloud.datastream.v1alpha1.JsonFileFormat.JsonCompression
	(Stream_State)(0),                    // 4: google.cloud.datastream.v1alpha1.Stream.State
	(Validation_Status)(0),               // 5: google.cloud.datastream.v1alpha1.Validation.Status
	(ValidationMessage_Level)(0),         // 6: google.cloud.datastream.v1alpha1.ValidationMessage.Level
	(*OracleProfile)(nil),                // 7: google.cloud.datastream.v1alpha1.OracleProfile
	(*MysqlProfile)(nil),                 // 8: google.cloud.datastream.v1alpha1.MysqlProfile
	(*GcsProfile)(nil),                   // 9: google.cloud.datastream.v1alpha1.GcsProfile
	(*NoConnectivitySettings)(nil),       // 10: google.cloud.datastream.v1alpha1.NoConnectivitySettings
	(*StaticServiceIpConnectivity)(nil),  // 11: google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
	(*ForwardSshTunnelConnectivity)(nil), // 12: google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
	(*VpcPeeringConfig)(nil),             // 13: google.cloud.datastream.v1alpha1.VpcPeeringConfig
	(*PrivateConnection)(nil),            // 14: google.cloud.datastream.v1alpha1.PrivateConnection
	(*PrivateConnectivity)(nil),          // 15: google.cloud.datastream.v1alpha1.PrivateConnectivity
	(*Route)(nil),                        // 16: google.cloud.datastream.v1alpha1.Route
	(*MysqlSslConfig)(nil),               // 17: google.cloud.datastream.v1alpha1.MysqlSslConfig
	(*ConnectionProfile)(nil),            // 18: google.cloud.datastream.v1alpha1.ConnectionProfile
	(*OracleColumn)(nil),                 // 19: google.cloud.datastream.v1alpha1.OracleColumn
	(*OracleTable)(nil),                  // 20: google.cloud.datastream.v1alpha1.OracleTable
	(*OracleSchema)(nil),                 // 21: google.cloud.datastream.v1alpha1.OracleSchema
	(*OracleRdbms)(nil),                  // 22: google.cloud.datastream.v1alpha1.OracleRdbms
	(*OracleSourceConfig)(nil),           // 23: google.cloud.datastream.v1alpha1.OracleSourceConfig
	(*MysqlColumn)(nil),                  // 24: google.cloud.datastream.v1alpha1.MysqlColumn
	(*MysqlTable)(nil),                   // 25: google.cloud.datastream.v1alpha1.MysqlTable
	(*MysqlDatabase)(nil),                // 26: google.cloud.datastream.v1alpha1.MysqlDatabase
	(*MysqlRdbms)(nil),                   // 27: google.cloud.datastream.v1alpha1.MysqlRdbms
	(*MysqlSourceConfig)(nil),            // 28: google.cloud.datastream.v1alpha1.MysqlSourceConfig
	(*SourceConfig)(nil),                 // 29: google.cloud.datastream.v1alpha1.SourceConfig
	(*AvroFileFormat)(nil),               // 30: google.cloud.datastream.v1alpha1.AvroFileFormat
	(*JsonFileFormat)(nil),               // 31: google.cloud.datastream.v1alpha1.JsonFileFormat
	(*GcsDestinationConfig)(nil),         // 32: google.cloud.datastream.v1alpha1.GcsDestinationConfig
	(*DestinationConfig)(nil),            // 33: google.cloud.datastream.v1alpha1.DestinationConfig
	(*Stream)(nil),                       // 34: google.cloud.datastream.v1alpha1.Stream
	(*Error)(nil),                        // 35: google.cloud.datastream.v1alpha1.Error
	(*ValidationResult)(nil),             // 36: google.cloud.datastream.v1alpha1.ValidationResult
	(*Validation)(nil),                   // 37: google.cloud.datastream.v1alpha1.Validation
	(*ValidationMessage)(nil),            // 38: google.cloud.datastream.v1alpha1.ValidationMessage
	nil,                                  // 39: google.cloud.datastream.v1alpha1.OracleProfile.ConnectionAttributesEntry
	nil,                                  // 40: google.cloud.datastream.v1alpha1.PrivateConnection.LabelsEntry
	nil,                                  // 41: google.cloud.datastream.v1alpha1.Route.LabelsEntry
	nil,                                  // 42: google.cloud.datastream.v1alpha1.ConnectionProfile.LabelsEntry
	(*Stream_BackfillAllStrategy)(nil),   // 43: google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
	(*Stream_BackfillNoneStrategy)(nil),  // 44: google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
	nil,                                  // 45: google.cloud.datastream.v1alpha1.Stream.LabelsEntry
	nil,                                  // 46: google.cloud.datastream.v1alpha1.Error.DetailsEntry
	nil,                                  // 47: google.cloud.datastream.v1alpha1.ValidationMessage.MetadataEntry
	(*timestamppb.Timestamp)(nil),        // 48: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),          // 49: google.protobuf.Duration
}
var file_google_cloud_datastream_v1alpha1_datastream_resources_proto_depIdxs = []int32{
	39, // 0: google.cloud.datastream.v1alpha1.OracleProfile.connection_attributes:type_name -> google.cloud.datastream.v1alpha1.OracleProfile.ConnectionAttributesEntry
	17, // 1: google.cloud.datastream.v1alpha1.MysqlProfile.ssl_config:type_name -> google.cloud.datastream.v1alpha1.MysqlSslConfig
	48, // 2: google.cloud.datastream.v1alpha1.PrivateConnection.create_time:type_name -> google.protobuf.Timestamp
	48, // 3: google.cloud.datastream.v1alpha1.PrivateConnection.update_time:type_name -> google.protobuf.Timestamp
	40, // 4: google.cloud.datastream.v1alpha1.PrivateConnection.labels:type_name -> google.cloud.datastream.v1alpha1.PrivateConnection.LabelsEntry
	2,  // 5: google.cloud.datastream.v1alpha1.PrivateConnection.state:type_name -> google.cloud.datastream.v1alpha1.PrivateConnection.State
	35, // 6: google.cloud.datastream.v1alpha1.PrivateConnection.error:type_name -> google.cloud.datastream.v1alpha1.Error
	13, // 7: google.cloud.datastream.v1alpha1.PrivateConnection.vpc_peering_config:type_name -> google.cloud.datastream.v1alpha1.VpcPeeringConfig
	48, // 8: google.cloud.datastream.v1alpha1.Route.create_time:type_name -> google.protobuf.Timestamp
	48, // 9: google.cloud.datastream.v1alpha1.Route.update_time:type_name -> google.protobuf.Timestamp
	41, // 10: google.cloud.datastream.v1alpha1.Route.labels:type_name -> google.cloud.datastream.v1alpha1.Route.LabelsEntry
	48, // 11: google.cloud.datastream.v1alpha1.ConnectionProfile.create_time:type_name -> google.protobuf.Timestamp
	48, // 12: google.cloud.datastream.v1alpha1.ConnectionProfile.update_time:type_name -> google.protobuf.Timestamp
	42, // 13: google.cloud.datastream.v1alpha1.ConnectionProfile.labels:type_name -> google.cloud.datastream.v1alpha1.ConnectionProfile.LabelsEntry
	7,  // 14: google.cloud.datastream.v1alpha1.ConnectionProfile.oracle_profile:type_name -> google.cloud.datastream.v1alpha1.OracleProfile
	9,  // 15: google.cloud.datastream.v1alpha1.ConnectionProfile.gcs_profile:type_name -> google.cloud.datastream.v1alpha1.GcsProfile
	8,  // 16: google.cloud.datastream.v1alpha1.ConnectionProfile.mysql_profile:type_name -> google.cloud.datastream.v1alpha1.MysqlProfile
	10, // 17: google.cloud.datastream.v1alpha1.ConnectionProfile.no_connectivity:type_name -> google.cloud.datastream.v1alpha1.NoConnectivitySettings
	11, // 18: google.cloud.datastream.v1alpha1.ConnectionProfile.static_service_ip_connectivity:type_name -> google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
	12, // 19: google.cloud.datastream.v1alpha1.ConnectionProfile.forward_ssh_connectivity:type_name -> google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
	15, // 20: google.cloud.datastream.v1alpha1.ConnectionProfile.private_connectivity:type_name -> google.cloud.datastream.v1alpha1.PrivateConnectivity
	19, // 21: google.cloud.datastream.v1alpha1.OracleTable.oracle_columns:type_name -> google.cloud.datastream.v1alpha1.OracleColumn
	20, // 22: google.cloud.datastream.v1alpha1.OracleSchema.oracle_tables:type_name -> google.cloud.datastream.v1alpha1.OracleTable
	21, // 23: google.cloud.datastream.v1alpha1.OracleRdbms.oracle_schemas:type_name -> google.cloud.datastream.v1alpha1.OracleSchema
	22, // 24: google.cloud.datastream.v1alpha1.OracleSourceConfig.allowlist:type_name -> google.cloud.datastream.v1alpha1.OracleRdbms
	22, // 25: google.cloud.datastream.v1alpha1.OracleSourceConfig.rejectlist:type_name -> google.cloud.datastream.v1alpha1.OracleRdbms
	24, // 26: google.cloud.datastream.v1alpha1.MysqlTable.mysql_columns:type_name -> google.cloud.datastream.v1alpha1.MysqlColumn
	25, // 27: google.cloud.datastream.v1alpha1.MysqlDatabase.mysql_tables:type_name -> google.cloud.datastream.v1alpha1.MysqlTable
	26, // 28: google.cloud.datastream.v1alpha1.MysqlRdbms.mysql_databases:type_name -> google.cloud.datastream.v1alpha1.MysqlDatabase
	27, // 29: google.cloud.datastream.v1alpha1.MysqlSourceConfig.allowlist:type_name -> google.cloud.datastream.v1alpha1.MysqlRdbms
	27, // 30: google.cloud.datastream.v1alpha1.MysqlSourceConfig.rejectlist:type_name -> google.cloud.datastream.v1alpha1.MysqlRdbms
	23, // 31: google.cloud.datastream.v1alpha1.SourceConfig.oracle_source_config:type_name -> google.cloud.datastream.v1alpha1.OracleSourceConfig
	28, // 32: google.cloud.datastream.v1alpha1.SourceConfig.mysql_source_config:type_name -> google.cloud.datastream.v1alpha1.MysqlSourceConfig
	1,  // 33: google.cloud.datastream.v1alpha1.JsonFileFormat.schema_file_format:type_name -> google.cloud.datastream.v1alpha1.SchemaFileFormat
	3,  // 34: google.cloud.datastream.v1alpha1.JsonFileFormat.compression:type_name -> google.cloud.datastream.v1alpha1.JsonFileFormat.JsonCompression
	0,  // 35: google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format:type_name -> google.cloud.datastream.v1alpha1.GcsFileFormat
	49, // 36: google.cloud.datastream.v1alpha1.GcsDestinationConfig.file_rotation_interval:type_name -> google.protobuf.Duration
	30, // 37: google.cloud.datastream.v1alpha1.GcsDestinationConfig.avro_file_format:type_name -> google.cloud.datastream.v1alpha1.AvroFileFormat
	31, // 38: google.cloud.datastream.v1alpha1.GcsDestinationConfig.json_file_format:type_name -> google.cloud.datastream.v1alpha1.JsonFileFormat
	32, // 39: google.cloud.datastream.v1alpha1.DestinationConfig.gcs_destination_config:type_name -> google.cloud.datastream.v1alpha1.GcsDestinationConfig
	48, // 40: google.cloud.datastream.v1alpha1.Stream.create_time:type_name -> google.protobuf.Timestamp
	48, // 41: google.cloud.datastream.v1alpha1.Stream.update_time:type_name -> google.protobuf.Timestamp
	45, // 42: google.cloud.datastream.v1alpha1.Stream.labels:type_name -> google.cloud.datastream.v1alpha1.Stream.LabelsEntry
	29, // 43: google.cloud.datastream.v1alpha1.Stream.source_config:type_name -> google.cloud.datastream.v1alpha1.SourceConfig
	33, // 44: google.cloud.datastream.v1alpha1.Stream.destination_config:type_name -> google.cloud.datastream.v1alpha1.DestinationConfig
	4,  // 45: google.cloud.datastream.v1alpha1.Stream.state:type_name -> google.cloud.datastream.v1alpha1.Stream.State
	43, // 46: google.cloud.datastream.v1alpha1.Stream.backfill_all:type_name -> google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
	44, // 47: google.cloud.datastream.v1alpha1.Stream.backfill_none:type_name -> google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
	35, // 48: google.cloud.datastream.v1alpha1.Stream.errors:type_name -> google.cloud.datastream.v1alpha1.Error
	48, // 49: google.cloud.datastream.v1alpha1.Error.error_time:type_name -> google.protobuf.Timestamp
	46, // 50: google.cloud.datastream.v1alpha1.Error.details:type_name -> google.cloud.datastream.v1alpha1.Error.DetailsEntry
	37, // 51: google.cloud.datastream.v1alpha1.ValidationResult.validations:type_name -> google.cloud.datastream.v1alpha1.Validation
	5,  // 52: google.cloud.datastream.v1alpha1.Validation.status:type_name -> google.cloud.datastream.v1alpha1.Validation.Status
	38, // 53: google.cloud.datastream.v1alpha1.Validation.message:type_name -> google.cloud.datastream.v1alpha1.ValidationMessage
	6,  // 54: google.cloud.datastream.v1alpha1.ValidationMessage.level:type_name -> google.cloud.datastream.v1alpha1.ValidationMessage.Level
	47, // 55: google.cloud.datastream.v1alpha1.ValidationMessage.metadata:type_name -> google.cloud.datastream.v1alpha1.ValidationMessage.MetadataEntry
	22, // 56: google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.oracle_excluded_objects:type_name -> google.cloud.datastream.v1alpha1.OracleRdbms
	27, // 57: google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.mysql_excluded_objects:type_name -> google.cloud.datastream.v1alpha1.MysqlRdbms
	58, // [58:58] is the sub-list for method output_type
	58, // [58:58] is the sub-list for method input_type
	58, // [58:58] is the sub-list for extension type_name
	58, // [58:58] is the sub-list for extension extendee
	0,  // [0:58] is the sub-list for field type_name
}

func init() { file_google_cloud_datastream_v1alpha1_datastream_resources_proto_init() }
func file_google_cloud_datastream_v1alpha1_datastream_resources_proto_init() {
	if File_google_cloud_datastream_v1alpha1_datastream_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NoConnectivitySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticServiceIpConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardSshTunnelConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpcPeeringConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Route); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlSslConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleColumn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleRdbms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OracleSourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlColumn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlTable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlDatabase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlRdbms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MysqlSourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvroFileFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JsonFileFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Validation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValidationMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream_BackfillAllStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Stream_BackfillNoneStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ForwardSshTunnelConnectivity_Password)(nil),
		(*ForwardSshTunnelConnectivity_PrivateKey)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*ConnectionProfile_OracleProfile)(nil),
		(*ConnectionProfile_GcsProfile)(nil),
		(*ConnectionProfile_MysqlProfile)(nil),
		(*ConnectionProfile_NoConnectivity)(nil),
		(*ConnectionProfile_StaticServiceIpConnectivity)(nil),
		(*ConnectionProfile_ForwardSshConnectivity)(nil),
		(*ConnectionProfile_PrivateConnectivity)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[22].OneofWrappers = []interface{}{
		(*SourceConfig_OracleSourceConfig)(nil),
		(*SourceConfig_MysqlSourceConfig)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*GcsDestinationConfig_AvroFileFormat)(nil),
		(*GcsDestinationConfig_JsonFileFormat)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*DestinationConfig_GcsDestinationConfig)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*Stream_BackfillAll)(nil),
		(*Stream_BackfillNone)(nil),
	}
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*Stream_BackfillAllStrategy_OracleExcludedObjects)(nil),
		(*Stream_BackfillAllStrategy_MysqlExcludedObjects)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datastream_v1alpha1_datastream_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_datastream_v1alpha1_datastream_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_datastream_v1alpha1_datastream_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_datastream_v1alpha1_datastream_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_datastream_v1alpha1_datastream_resources_proto = out.File
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_rawDesc = nil
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_goTypes = nil
	file_google_cloud_datastream_v1alpha1_datastream_resources_proto_depIdxs = nil
}
